# AEI Photo System - Credentials

**WARNING: Keep this file secure and do not commit to public repositories.**
**Last Updated:** 2026-02-04

---

## Remote Photo API Authentication

**Endpoint:** `https://aeihawaii.com/photoapi/upload.php`
**Also used by:** `getimagelisting.php`, `getimagelistingm.php`, `delete.php`

```
Auth Token: aei@89806849
```

Storage: Hardcoded in PHP files

---

## Local Upload API Authentication

**Endpoint:** `https://upload.aeihawaii.com/uploadlocallat_kuldeep.php`

```
Auth Token: remote_token
```

Storage: `.env` file at `/var/www/html/upload/.env`

---

## Remote Database (mandhdesign_schedular)

**Server:** Remote (18.225.0.90) — localhost connection from PHP

```
Host:     localhost
Database: mandhdesign_schedular
User:     schedular
Password: M1gif9!6
```

Source: `upload.php` line 29

---

## Local Database (Schedular)

**Server:** Local (upload.aeihawaii.com) — used by `uploadlocallat_kuldeep.php`

```
Host:     localhost
Database: Schedular
User:     upload_user
Password: P@55w02d778899
```

Permissions: `SELECT` on `unified_customers` table only
Source: `/var/www/html/upload/db_config.php`

---

## AWS S3 Integration

**Bucket:** `aeiimages`
**Region:** `eu-north-1`

```
Access Key: AKIAT7JJUULFMWZTUALA
Secret Key: 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
Signature:  v4
```

Source: `phototab.php` S3 client factory

---

## Batch Processing API

**Script:** `/var/opt/move_photos/move_photos.py`

```
API URL:    http://aeihawaii.com/upload_api.php
Auth Token: aei@89806849
```

---

## SSH Access to Remote Server

```
Host:     18.225.0.90
User:     Julian
Key:      /root/.ssh/aei_remote.pem
Key Source: /var/opt/AEI_REMOTE/SSH/schedular_server_private_key.ppk (convert with puttygen)
```

See `/var/opt/AEI_REMOTE/REMOTE_SERVER.md` for full SSH documentation, key conversion steps, and troubleshooting.

---

## Quick Reference

| Service | Token / User | Location |
|---------|-------------|----------|
| Remote Photo API | `aei@89806849` | Hardcoded in PHP |
| Local Upload API | `remote_token` | `/var/www/html/upload/.env` |
| Remote MySQL | `schedular` / `M1gif9!6` | `upload.php` |
| Local MySQL | `upload_user` / `P@55w02d778899` | `db_config.php` |
| AWS S3 | `AKIAT7JJUULFMWZTUALA` | `phototab.php` |
| Batch Processing | `aei@89806849` | `move_photos.py` |

---

*Extracted from PHOTO_SYSTEM_DOCUMENTATION.md, PHOTO_SYSTEM_INTEGRATION.md — 2026-02-04*
