# Chunked Upload Enhancement

**Date:** 2026-02-05
**Status:** Implemented (pending deployment)

## Files Modified

| File | Server | Deploy Location |
|------|--------|-----------------|
| `uploadlocallat_kuldeep.php` | Local | `/var/www/html/upload/uploadlocallat_kuldeep.php` |
| `sync_to_local.py` | Remote | `/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/sync_to_local.py` |
| `process_retry_queue.py` | Remote | `/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/process_retry_queue.py` |

## Folder Structure

```
ENHANCEMENTS/CHUNKED_UPLOAD/
├── README.md          ← This file
├── NEW/               ← Modified files (chunked upload support)
│   ├── uploadlocallat_kuldeep.php
│   ├── sync_to_local.py
│   └── process_retry_queue.py
└── ORIGINAL/          ← Pre-modification files (for rollback)
    ├── uploadlocallat_kuldeep.php
    ├── sync_to_local.py
    └── process_retry_queue.py
```

## Quick Rollback

To revert all changes, copy the ORIGINAL files back to their source locations:

```bash
# Local server receiver
cp ORIGINAL/uploadlocallat_kuldeep.php \
   /var/opt/AEI_REMOTE/AEI_PHOTO_API_PROJECT/LOCAL/uploadlocallat_kuldeep.php.current
sudo cp ORIGINAL/uploadlocallat_kuldeep.php \
   /var/www/html/upload/uploadlocallat_kuldeep.php

# Remote server sender (via SCP)
cp ORIGINAL/sync_to_local.py \
   /var/opt/AEI_REMOTE/AEI_PHOTO_API_PROJECT/REMOTE/photoapi/sync_to_local.py
scp -i /root/.ssh/aei_remote.pem ORIGINAL/sync_to_local.py \
   Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/sync_to_local.py

# Remote server retry processor (via SCP)
cp ORIGINAL/process_retry_queue.py \
   /var/opt/AEI_REMOTE/AEI_PHOTO_API_PROJECT/REMOTE/photoapi/process_retry_queue.py
scp -i /root/.ssh/aei_remote.pem ORIGINAL/process_retry_queue.py \
   Julian@18.225.0.90:/var/www/vhosts/aeihawaii.com/httpdocs/photoapi/process_retry_queue.py
```

## Full Documentation

See `DOCS/CHUNKED_UPLOAD_ENHANCEMENT.md` for protocol specification, architecture, deployment steps, and verification commands.
