<!--
Customer Types: Residential, Commercial
Job Type: Solar Water Heating, Photovoltaic, Solar Attic Fan, Service Call

Automatic filtering to prevent same-name/same-address scenarios. i.e. if name is entered and there is a similar name/lastname, if asks if this person lives at the same address. If yes, it'll modify that persons profile, ie customers can have more than one job added to it like solar water heating, photovoltaics, solar fans, etc
Ability to 'Save for later', i.e. saves and closes overlay window and returns to Job Calendar view
Ability to 'Enter more details' - takes user to job detailed page to enter more customer details.

- width of all overlays should be the same, although its not necessary to keep it the same width in the mockups
-->

<div class="reserve-job" id="reservejob">
	<div class="header">
		<div class="title">Schedule New Job - Job Type </div>
		<div class="close-button"><a href="#" class="cancel-facebox">&times;</a></div>
		<div class="clear-both"></div>
	</div>
	<div class="content">
		
		<div class="form-errors" style="display:none;"></div>
		<?=form_open('ajax/reserve_job', 'id="reserve_form"');?>
		
		<?=form_hidden('customer_id',$customer_id)?>
		<?=form_hidden('year',$year)?>
                <?=form_hidden('month',$month)?>
		
		<?=form_label('Customer Type', 'customer_type');?>
		<?php $customer_type = $this->input->get("customer_type"); ?>
    <?=form_dropdown('customer_type', $customer_types, @$customer_type);?>
		
		<?php 
		if ($this->input->get("preselect") == 'service_call'):
			$ps_sc = '5';
		else:
			$ps_sc = null;
		endif;

    $ps_sc = $this->input->get("job_type");
		?>
		<?=form_label('Job Type', 'job_type');?>
		<?=form_dropdown('job_type', $job_types, $ps_sc);?>
		
		<?=form_label('First Name');?>
		<?=form_input('first_name',$this->input->get("first_name"),'id="first_name"');?>
		
		<?=form_label('Last Name', 'last_name');?>
		<?=form_input('last_name',$this->input->get("last_name"),'id="last_name"');?>
		
		<div class="orange-radios" style="display:none;">
			<table>
				<tr>
					<td width="70%">
						Does <span class="name"></span> live in <span class="address"></span> <!--Pearl City, Hawaii @ 98042 Pualli Way-->?
					</td>
					<td>
						<div align="right">
						<table id="radio-table">
							<tr>
								<td><input type="radio" name="found_client" value="y" class="found_client"></td>
								<td><div align="right">Yes</div></td>
								<td><input type="radio" name="found_client" value="n" class="found_client"></td>
								<td><div align="right">No</div></td>
							</tr>
						</table>
						</div>
					</td>
				</tr>
			</table>
			<br />
		</div>
		
		<?php if ($this->session->userdata('role') == 'admin'): ?>
			<?=form_label('Salesperson', 're_user_id');?>
			<?=form_dropdown('re_user_id',$salesmen ,'id="re_user_id_admin"')?>
		<?php endif ?>
		
		<?=form_close();?>
		
		<div style="float:left;">
			<button class="cancel-facebox">Cancel</button>
		</div>
		
		<div style="float:right">
			<!--<button class="save-for-later">Save for later</button> -->
			<button class="next">Next</button>
		</div>
		<div class="clear-both"></div>
		
	</div>
</div>

<script type="text/javascript" charset="utf-8">
var customer_id = '';
var userid ='';
$(document).ready(function() {
	
	// look for previously entered customers
  var first_name = $('#first_name').val();
	var last_name = $('#last_name').val();
  if (first_name && last_name){
    
    var first_name = $('#first_name').val();
		
		
		$.ajax({
			type: "POST",
			url: "/ajax/find_previous_customer",
			data: $('#reserve_form').serialize(),
			dataType: "json",
			success: function(json) {
				if(json.success == true)
				{
					$('.orange-radios').fadeIn();
					$('.orange-radios .name').text(first_name+' '+last_name);
					$('.orange-radios .address').text(json.address);
					customer_id = json.customer_id;
				}
				else
				{
					$('.orange-radios').fadeOut();
					$('.orange-radios .name').text('');
					$('.orange-radios .address').text('');
				}
			}
		});
  }
  $('#last_name').live('keyup',function(event) {
		var first_name = $('#first_name').val();
		var last_name = $('#last_name').val();
		
		$.ajax({
			type: "POST",
			url: "/ajax/find_previous_customer",
			data: $('#reserve_form').serialize(),
			dataType: "json",
			success: function(json) {
				if(json.success == true)
				{
					$('.orange-radios').fadeIn();
					$('.orange-radios .name').text(first_name+' '+last_name);
					$('.orange-radios .address').text(json.address);
					customer_id = json.customer_id;
				}
				else
				{
					$('.orange-radios').fadeOut();
					$('.orange-radios .name').text('');
					$('.orange-radios .address').text('');
				}
			}
		});
	});
	
	$('.found_client').live('click',function() {
		if($('.found_client:checked').val() == 'y')
		{
			$("input[name=customer_id]").val(customer_id);
		}
		else
		{
			$("input[name=customer_id]").val('');
		}
	});
	
	save_for_later = function()
	{

		userid = $('select[name=re_user_id] option:selected').val();
                reserverjob = $('#reserve_form').serialize();
                   $.ajax({
			type: "POST",
			url: "/ajax/validate_savejob",
			data: $('#reserve_form').serialize(),
			dataType: "json",
			success: function(json) {
				if(json.success == true)
				{
					$.facebox({ ajax: '/ajax/installer/<?=$year?>/<?=$month?>' }, 'Installer');
                                        
					
				}
				else
				{
					$(".form-errors").html(json.msg);
					$(".form-errors").fadeIn();
				}
			}
		});
	}
	
	enter_more_details = function()
	{
		$.ajax({
			type: "POST",
			url: "/ajax/init_job",
			data: $('#reserve_form').serialize(),
			dataType: "json",
			success: function(json) {
				if(json.success == true)
				{
					location.href = '/admin/'+json.job_url+'/'+json.job_id;
				}
				else
				{
					$(".form-errors").html(json.msg);
					$(".form-errors").fadeIn();
				}
			}
		});
	}
	
	$('.next').click(function() {  save_for_later() });
	$('.enter-more-details').click(function() { $(this).unbind('click'); enter_more_details() });
});
</script>