<!--
Customer Types: Residential, Commercial
Job Type: Solar Water Heating, Photovoltaic, Solar Attic Fan, Service Call

Automatic filtering to prevent same-name/same-address scenarios. i.e. if name is entered and there is a similar name/lastname, if asks if this person lives at the same address. If yes, it'll modify that persons profile, ie customers can have more than one job added to it like solar water heating, photovoltaics, solar fans, etc
Ability to 'Save for later', i.e. saves and closes overlay window and returns to Job Calendar view
Ability to 'Enter more details' - takes user to job detailed page to enter more customer details.

- width of all overlays should be the same, although its not necessary to keep it the same width in the mockups
-->

<div class="reserve-job">
	<div class="header">
		<div class="title">Schedule New Job - Required Information</div>
		<div class="close-button"><a href="#" class="cancel-facebox">&times;</a></div>
		<div class="clear-both"></div>
	</div>
	<div class="content">
		
		<div class="form-errors" style="display:none;"></div>
		
		<?=form_open('ajax/installer', 'id="installer_form"');?>
		
		<?=form_hidden('job_id',$customer_id)?>
		
		
		<?=form_label('Number of System', 'in_nos');?>
		<?=form_dropdown('in_nos', $numberofsystem,null,"id='in_nos' " );?>
		
		<?=form_label('Number of Module', 'in_nom');?>
		<?=form_dropdown('in_nom', $nomodule,null,"id='in_nom' onchange='calculateInstaller();'");?>
		
                <?=form_label('Number of  Sub-Arrays', 'in_nosa');?>
		<?=form_dropdown('in_nosa', $nosubarray,null,"id='in_nosa' onchange='calculateInstaller();'");?>

                <?=form_label('Roof type', 'in_rooftype');?>
		<?=form_dropdown('in_rooftype', $roof_type,null,"id='in_rooftype'  onchange='calculateInstaller();'");?>

		<?=form_label('Wire Run Distance', 'in_wirerundist');?>
		<?=form_dropdown('in_wirerundist', $wirerundistance,null,"id='in_wirerundist' onchange='calculateInstaller();'");?>

                <?=form_label('Wire Run type', 'in_wireruntype');?>
		<?=form_dropdown('in_wireruntype', $wire_type,null,"id='in_wireruntype' onchange='calculateInstaller();'");?>
		<div class="orange-radios" >
			<table >
				<tr>
					
					<td width="100%">
						<div align="left">
						<table >
							<tr>
                                                            <td ><div style="width:200px;">Installers Required For Your Job:</div></td>
								<td  align="left"> <input type="text" id="in_noi" name ="in_noi" style="width:100px;color:black;"  ></td>
								
                                                        </tr><tr>
							    <td width ="70">Number of Day to  Split job into: </div></td>
                                                            <td width ="30" align="left"><div ><?=form_dropdown('in_nod', $nod,null,'style="width:100px;" ');?></div></td>
								
							</tr>
						</table>
						</div>
					</td>
				</tr>
			</table>
			<br />
		</div>
		
		
		
		<?=form_close();?>
		<br/>
                <div style="float:left;">
			<button class="cancel-facebox">Cancel</button>
		</div>
		
		<div style="float:right">
			<button class="backdiv">Back</button>
			<button class="findavailabledate">Find Available Date</button>
		</div>
		<div class="clear-both"></div>
		
	</div>
</div>

<script type="text/javascript" charset="utf-8">
var customer_id = '';
$(document).ready(function() {
	
	// look for previously entered customers
	
	save_for_later = function()
	{
		$.ajax({
			type: "POST",
			url: "/ajax/save_session",
			data: $('#installer_form').serialize()+"&"+reserverjob,
			dataType: "json",
			success: function(json) {
				if(json.success == true)
				{
					//$.facebox.close();
					location.href="/admin/installer_available/<?=$year?>/<?=$month?>/"+userid;
				}
				else
				{
					$(".form-errors").html(json.msg);
					$(".form-errors").fadeIn();
				}
			}
		});
	}
	
	calculateInstaller = function()
	{
          var noi;
          noi = 0;
          var nom = $("#in_nom").val();
          nom = parseInt(nom);
          if (nom<=16){
            noi += 0;
          }else if(nom>16 && nom<=24) {
            noi += 1;
          }else if (nom>=25 && nom<=32) {
            noi += 2;
          } else if (nom>=33 && nom<=40) {
            noi += 3;
          }else if (nom>=41 && nom<=48){
            noi += 4;
          }
          
        
           var nosa = $("#in_nosa").val();
           nosa = parseInt(nosa);

          if (nosa<1){
            noi += 0;
          }else if(nosa>1 && nosa<=6) {
            noi += 1;
          }
        
          if (nom ){
          var rooftype = $("#in_rooftype").val();
          rooftype =  parseInt(rooftype);
          if(rooftype){
             var noi_r = Math.round(nom/rooftype);
             
          }
          if (noi_r)
           noi +=noi_r;
          }
          
          var wirerundist = $("#in_wirerundist").val();
          wirerundist = parseInt(wirerundist);
          switch(wirerundist){
              case 1:
                  noi += 1;
                  break;
              case 2:
                  noi += 2;
                  break;
              case 3:
                  noi += 3;
                  break;
              case 4:
                  noi += 4;
                  break;
              case 5:
                  noi -= 2;
                  break;
          }

          
          var wireruntype = $("#in_wireruntype").val();
          wireruntype = parseInt(wireruntype);
           switch(wireruntype){
              case 4:
                  noi += 0;
                  break;
              case 5:
                  noi += 1;
                  break;
              case 6:
                  noi += 2;
                  break;
          }
          if(noi<4){
              noi = 4;
          }
          
          $("#in_noi").val(noi);
      
        }

  function  backReservejob(){
    $.facebox({ ajax: '/ajax/reserve_job/<?=$year?>/<?=$month?>?'+reserverjob+'' }, 'Installer');
  }
	$('.findavailabledate').click(function() { $(this).unbind('click'); save_for_later() });
	$('.backdiv').click(function() { $(this).unbind('click'); backReservejob() });
});
</script>