<!--
Service Call Detail Page

- Job Summary widget
    - functionality as seen in design

- Customer Summary Widget
  - functionality as seen in design

- Job Notes widget
    - ability for user to add simple notes/progress on job with date-stamp

- Upload files widget
   - ability for users to upload/add/delete files to Job

- Job Location Map
   - Google Map of job address
-->

<div style="position:relative;">
	<div class="page-top-buttons">
		<button>Create Purchase Agreement</button>
		<button>Print Summary</button>
	</div>
</div>

<h1>Job Details</h1>
<p><a href="<?=base_url()?>">Home</a> / <a href="<?=base_url()?>admin/jobschedule">Job Calendar</a> / <a href="<?=base_url()?>admin/day/<?=date("Y/m/d",$service_call_timestamp)?>"><?=date("F jS, Y",$service_call_timestamp)?></a> / <a href="<?=base_url()?>admin/customer/<?=$service_call['customer_id']?>"><?=$service_call['first_name']?> <?=$service_call['last_name']?></a> / Service Call</p>
<br />

<div class="generic-page-block">
	<div class="green-header">
		<span class="dark-green">Job Date:</span> <?=date("F jS, Y",$service_call_timestamp)?>
		<span class="dark-green">Job Type:</span> Service Call 
		<span class="dark-green">Customer Name:</span> <?=$service_call['first_name']?> <?=$service_call['last_name']?>
	</div>
	<div class="content">
		<div class="two-col-wide-left">
			<div class="content-header">Service Call Information</div>
			<p>Please fill out the relevant information below for your Customer's service call.</p>
			<br />
			
			<?=form_open('admin/service_call/'.$service_call['id'],array('name' => 'form1', 'id' => 'form1'));?>
			<?=form_hidden('dosubmit','true')?>
			<table id="two-col-form" cellspacing="0" cellpadding="0" width="100%">
				<tr>
					<td>
						<br />
						<span class="green-text">[Time]</span><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Time of Repair', 'repair_time');?>
						<?=form_dropdown('repair_time',$times_dd,@$service_call['repair_time'])?>
					</td>
				</tr>
				<tr>
					<td>
						<br />
						<span class="green-text">[AEI Technician]</span><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('AEI Technician', 'technician');?>
						<?=form_dropdown('technician_id',$technicians_dd,@$service_call['technician_id'])?>
					</td>
				</tr>
				<tr>
					<td>
						<br />
						<?=form_label('Assign a Contractor', 'contractor');?>
						<?=form_dropdown('contractor_id',@$contractors,$service_call['contractor_id'])?>
					</td>
				</tr>
				<tr>
					<td>
						<br />
						<span class="green-text">[Details of Service or Repair]</span><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Type of repair', 'repair_type');?>
						<?=form_input('repair_type',@$service_call['repair_type']);?>
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Description of parts needed', 'description');?>
						<?=form_textarea('description',@$service_call['description']);?>
					</td>
				</tr>
				<!--
				<tr>
					<td>
						<p><a href="" class="underline">Add another referral</a></p><br />
					</td>
				</tr>
				-->
				<tr>
					<td>
						<br />
						<span class="green-text">[More Details]</span><br />
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<?=form_label('Additional comments or requirements', 'comments');?>
						<?=form_textarea('comments',@$service_call['comments'])?>
					</td>
				</tr>
			</table>
			<?=form_close()?>

			<div></div>
			<br />
			
			<div style="float:left;">
				<button>Cancel</button>
			</div>
			
			<div style="float:right">
				<button>Print</button>
				<?php if ($this->session->userdata("user_id") == $job['user_id'] or $this->session->userdata('role') == 'admin'): ?>
					<?php if (!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") == 'n')): ?>
						<button onclick="document.form1.submit()">Save</button>
					<?php endif; ?>
				<?php endif; ?>
			</div>
			<div class="clear-both"></div>
			
		</div>
		<div class="two-col-wide-right">
			<!--
			<div class="progress-block">
				<div class="progress-bar">
					<div class="bar" style="width:75%;"></div>
				</div>
				<strong>Progress:</strong><br />
				You have completed <span class="bold">75%</span> of this form.
			</div>
			-->
			
			<div class="job-side-box">
				<div class="header">
					<a href="<?=base_url()?>admin/jobschedule">Back to Schedule</a>
					Job Summary
				</div>
				<div class="content">
					<!--
					<strong>Salesperson:</strong> Akio Takasaki<br />
					<div class="divider"></div>
					-->
					<strong>Booking Date:</strong> <?=date("F jS, Y",strtotime($service_call['created']))?><br />
					<!--<em>Last edited by: Office Admin</em>-->
					
					<div class="divider"></div>
					<?php if ($this->session->userdata("user_id") == $service_call['user_id'] or $this->session->userdata('role') == 'admin'): ?>
						<?php if (!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") == 'n')): ?>
							<a href="<?=base_url()?>admin/delete_service_call/<?=$service_call['id']?>?ref=/admin/day/<?=date("Y/m/j",$service_call_timestamp)?>" class="delete-job-link" onclick="return confirm('Are you sure you want to delete this job?');">Delete this job</a>
						<?php endif; ?>
					<?php endif; ?>
					
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
					<a href="<?=base_url()?>admin/customer/<?=$service_call['customer_id']?>">Edit Profile</a>
					Customer Summary
				</div>
				<div class="content">
					<strong>Customer:</strong> <a href="<?=base_url()?>admin/customer/<?=$service_call['customer_id']?>"><?=$service_call['first_name']?> <?=$service_call['last_name']?></a><br />
					<strong>Address:</strong><br />
					<div style="padding-left:10px;">
						<?=$service_call['address']?><br />
						<?=$service_call['city']?>, <?=$service_call['state']?>, <?=$service_call['zip_code']?>
					</div>
					<strong>Billing Address:</strong><br />
					<div style="padding-left:10px;">
						<?php if ($service_call['different_billing_address'] == 'y'): ?>
							<?=$service_call['billing_address']?><br />
							<?=$service_call['billing_city']?>, <?=$service_call['billing_state']?>, <?=$service_call['billing_zip_code']?>
						<?php else: ?>
							<?=$service_call['address']?><br />
							<?=$service_call['city']?>, <?=$service_call['state']?>, <?=$service_call['zip_code']?>
						<?php endif ?>
					</div>
					<div class="divider"></div>
					<strong>Other Active Service Calls:</strong>
					<div style="padding-left:10px;">
						<?php foreach ($other_service_calls as $key => $value): ?>
						<a href="<?=base_url()?>admin/service_call/<?=$value['id']?>">Service Call (<?=date("M j, Y",strtotime($value['date']))?>)</a><br />
						<?php endforeach ?>
						<?php if (count($other_service_calls) == 0): ?>
							Customer has no other service calls
						<?php endif ?>
					</div>
				</div>
			</div>
			
			<div class="job-side-box">
				<a name="job-notes"></a>
				<div class="header">
					<a href="<?=base_url()?>ajax/view_sc_notes/<?=$service_call['id']?>" style="margin-right:75px;" class="facebox">View All</a> 
					<a href="<?=base_url()?>ajax/add_sc_note/<?=$service_call['id']?>" class="facebox">Add Note</a>
					Job Notes
				</div>
				<div class="content">
					<?php foreach ($job_notes as $key => $value): ?>
						<strong>Posted:</strong> <?=date("F j, Y",strtotime($value['created']))?>, <strong>By:</strong> <?=$value['first_name']?> <?=$value['last_name']?><br />
						<span class="warning"><?=character_limiter($value['note'],90)?></span>
						<div class="divider"></div>
					<?php endforeach ?>
					<?php if (count($job_notes) == 0): ?>
					<div style="background:#fff; padding:10px">
						This job has no notes.
					</div>
					<?php endif ?>
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
					<a href="<?=base_url()?>ajax/add_file_iframe/<?=$service_call['id']?>?service_call=yes" class="facebox">Add File</a>
					Upload Files
				</div>
				<div class="content">
					<?php if (count($job_files) > 0): ?>
					<table cellspacing="0" class="files-table">
						<?php foreach ($job_files as $key => $value): ?>
						<tr>
							<td><img src="/assets/images/mime-generic.gif" /></td>
							<td><a href="<?=base_url()?>admin/download/<?=$value['id']?>"><?=$value['original_filename']?></a></td>
							<td><a href="<?=base_url()?>admin/delete_file/<?=$value['id']?>"><img src="/assets/images/delete-icon.gif" /></a></td>
						</tr>
						<?php endforeach ?>
					</table>
					<?php else: ?>
						<div style="padding:10px; background:#fff;">
							No uploaded files.
						</div>
					<?php endif ?>
				</div>
			</div>
			
			<!--
			<div class="job-side-box">
				<div class="header">
					<a href="#">Add File</a>
					Upload Files
				</div>
				<div class="content">
					<table cellspacing="0" class="files-table">
						<tr>
							<td><span class="no-uploaded-files">No uploaded files</span></td>
						</tr>
					</table>
				</div>
			</div>
			-->
		</div>
		<div class="clear-both"></div>
	</div>
</div>