<!--
Job Detail Page - Job Specifications

- Ability for admin-user to edit/add dropdown options
- Ability to view progress of form completion
- Ability to "Create Purchase Agreement" PDF to download. A pre-designed PDF form will be populated with data on this page and customer details

- Job Summary widget
    - Ability for all users to change 'current status'
    - functionality as seen in design

- Customer Summary Widget
  - functionality as seen in design

- Job Notes widget
    - ability for user to add simple notes/progress on job with date-stamp

- Upload files widget
   - ability for users to upload/add/delete files to Job

- Job Location Map
   - Google Map of job address
-->

<div style="position:relative;">
	<div class="page-top-buttons">
		<button>Create Purchase Agreement</button>
		<button>Print Summary</button>
	</div>
</div>

<h1>Job Details</h1>
<p><a href="<?=base_url()?>">Home</a> / <a href="<?=base_url()?>admin/jobschedule">Job Calendar</a> / <a href="<?=base_url()?>admin/day/<?=date("Y/m/d",$job_timestamp)?>"><?=date("F jS, Y",$job_timestamp)?></a> / <a href="<?=base_url()?>admin/customer/<?=$job['customer_id']?>"><?=$job['first_name']?> <?=$job['last_name']?></a> / <?=$job['job_type']?></p>
<br />

<div class="generic-page-block">
	<div class="green-header">
		<span class="dark-green">Job Date:</span> <?=date("F jS, Y",$job_timestamp)?>
		<span class="dark-green">Job Type:</span> <?=$job['job_type']?>
		<span class="dark-green">Customer Name:</span> <?=$job['first_name']?> <?=$job['last_name']?>
	</div>
	<div class="content">
		<div class="two-col-wide-left">
			<div class="content-header">Solar Attic Fan Information</div>
			<p>Please fill out the relevant information below for your Customer's <?=$job['job_type']?> system.</p>
			<br />
			
			<div class="generic-nav-tabs">
				<a href="/admin/job/<?=$job_id?>" class="active">Job Specifications</a>
				<a href="/admin/job_financing/<?=$job_id?>">Financing</a>
				<a href="/admin/job_referrals/<?=$job_id?>">Referrals</a>
				<div class="clear-left"></div>
			</div>
			
			<br /><br />
			
			<?=form_open('admin/job/'.$job_id,array('name' => 'form1', 'id' => 'form1'));?>
			<?=form_hidden('dosubmit','true')?>
			<table id="two-col-form" cellspacing="0" cellpadding="0" width="100%">
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Solar Fan Details]</span><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Solar Fan Brand', 'fan_brand_id');?>
						<?=form_dropdown('fan_brand_id', @$fan_brands, @$job['fan_brand_id']);?>
					</td>
					<td></td>
					<td>
						<div style="display:none" id="fan_brand_wrap">
						<?=form_label('Other Solar Fan Brand', 'other_fan_brand');?>
						<?=form_input('other_fan_brand',@$job['other_fan_brand']);?>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Solar Fan Size', 'fan_size_id');?>
						<?=form_dropdown('fan_size_id', @$fan_sizes, @$job['fan_size_id']);?>
					</td>
					<td></td>
					<td>
						<div style="display:none" id="fan_size_wrap">
						<?=form_label('Other Solar Fan Size', 'other_fan_size');?>
						<?=form_input('other_fan_size',@$job['other_fan_size']);?>
						</div>
					</td>
				</tr>
				
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Roof Details]</span><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Number of stories', 'stories');?>
						<?=form_dropdown('stories', $stories, @$job['stories']);?>
					</td>
					<td></td>
					<td>
						
					</td>
				</tr>
				<tr style="display:none;" id="panel_access_row">
					<td colspan="3">
						<table class="padded-table">
							<tr>
								<td>Access to panel installation location? </td>
								<td>
								<?
								if(@$job['module_install_location_access'] == 'y') {$checked=true;} else {$checked=false;}
								echo form_radio('panel_install_location_access','y',$checked)?>
								</td>
								<td>Yes</td>
								<td>
								<?
								if(@$job['module_install_location_access'] == 'n') {$checked=true;} else {$checked=false;}
								echo form_radio('panel_install_location_access','n',$checked)?></td>
								<td>No</td>
							</tr>
						</table>
						
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Roof Type', 'roof_type');?>
						<?=form_dropdown('roof_type_id', @$roof_types, @$job['roof_type_id']);?>
					</td>
					<td></td>
					<td>
						<div style="display:none;" id="other_roof_type_wrap">
						<?=form_label('Other roof type', 'other_roof_type');?>
						<?=form_input('other_roof_type',@$job['other_roof_type']);?>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Rafter Type', 'rafter_type_id');?>
						<?=form_dropdown('rafter_type_id', @$rafter_types, @$job['rafter_type_id']);?>
					</td>
					<td></td>
					<td>
						<div style="display:none" id="other_rafter_type_wrap">
						<?=form_label('Other rafter type', 'other_rafter_type');?>
						<?=form_input('other_rafter_type',@$job['other_rafter_type']);?>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Color of roof', 'roof_color');?>
						<?=form_input('roof_color',@$job['roof_color']);?>
					</td>
					<td></td>
					<td>
						<?=form_label('Distance between rafters <span class="light-gray">(ft, inches)</span>', 'rafter_distance');?>
						<?=form_input('rafter_distance',@$job['rafter_distance']);?>
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<table class="padded-table">
							<tr>
								<td>Tilt kit needed? </td>
								<td>
								<?
								if(@$job['tilt_kit_needed'] == 'y') {$checked=true;} else {$checked=false;}
								echo form_radio('tilt_kit_needed','y',$checked)?>
								</td>
								<td>Yes</td>
								<td>
								<?
								if(@$job['tilt_kit_needed'] == 'n') {$checked=true;} else {$checked=false;}
								echo form_radio('tilt_kit_needed','n',$checked)?></td>
								<td>No</td>
							</tr>
						</table>
						
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Installation Type', 'installation_type_id');?>
						<?=form_dropdown('installation_type_id', @$installation_types, @$job['installation_type_id']);?>
					</td>
					<td></td>
					<td>
						<div style="display:none" id="other_installation_type_wrap">
						<?=form_label('Other installation type', 'other_installation_type');?>
						<?=form_input('other_installation_type',@$job['other_installation_type']);?>
						</div>
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Roof Orientation', 'roof_orientation');?>
						<?=form_input('roof_orientation',@$job['roof_orientation']);?>
					</td>
					<td></td>
					<td>
						<?=form_label('Roof pitch <span class="light-gray">(degrees)</span>', 'roof_pitch');?>
						<?=form_input('roof_pitch',@$job['roof_pitch']);?>
					</td>
				</tr>
				
				<tr>
					<td>
						<?=form_label('Assign a Contractor', 'contractors[]');?>
						<?=form_dropdown('contractor_id',@$contractors,$job['contractor_id'])?>
						
						<a href="#" style="text-decoration:underline;">Add another contractor</a>
					</td>
					<td></td>
					<td></td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[More Details]</span><br />
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<?=form_label('Additional comments or requirements', 'additional_comments');?>
						<?=form_textarea('additional_comments',@$job['additional_comments'])?>
					</td>
				</tr>
			</table>
			<?=form_close()?>
			
			<div class="divider"></div>
			
			<div style="float:left;">
				<button>Back to Calendar</button>
			</div>
			
			<div style="float:right">
				<button>Create Purchase Agreement</button>
				<button>Print</button>
				<?php if ($this->session->userdata("user_id") == $job['user_id'] or $this->session->userdata('role') == 'admin'): ?>
					<?php if (!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") == 'n')): ?>
						<button onclick="document.form1.submit()">Save</button>
					<?php endif; ?>
				<?php endif; ?>
			</div>
			<div class="clear-both"></div>
			
		</div>
		<div class="two-col-wide-right">
			
			<div class="progress-block">
				<div class="progress-bar">
					<div class="bar" style="width:<?=$percent_completed?>%;"></div>
				</div>
				<strong>Progress:</strong><br />
				You have completed <span class="bold"><?=$percent_completed?>%</span> of this form.
			</div>
			
			
			<div class="job-side-box">
				<div class="header">
					<a href="#">Back to Schedule</a>
					Job Summary
				</div>
				<div class="content">
					
					<strong>Salesperson:</strong> Akio Takasaki<br />
					<strong>Installers:</strong> Joey Phoman, Joe Bloggs, Darren Furumoto, Dean Watakusuki<br />
					<div class="divider"></div>
					
					<?php if ($this->session->userdata("role") == 'admin'): ?>
					<table width="100%">
						<tr>
							<td>
								Current Status: <span id="job-status-indicator"><img src="<?=base_url()?>assets/images/ajax-loader.gif" /></span>
							</td>
							<td><div align="right">
								<?=form_dropdown('current_status',$job_statuses,$job['current_status'])?>
							</div></td>
						</tr>
					</table>
					<div class="divider"></div>
					<?php endif; ?>
					<strong>Booking Date:</strong> <?=date("l, F j, Y",strtotime($job['created']))?><br />
					
					<span class="warning"><strong>Time Left for Expiration:</strong>  <?php echo $timediff;?> hours</span><br />
					<em>Last edited by: Office Admin</em>
					
					
					<div class="divider"></div>
					
					<?php if ($this->session->userdata("user_id") == $job['user_id'] or $this->session->userdata('role') == 'admin'): ?>
						<?php if (!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") == 'n')): ?>
							<a href="<?=base_url()?>admin/delete_job/<?=$job['id']?>?ref=/admin/day/<?=date("Y/m/j",$job_timestamp)?>" class="delete-job-link" onclick="return confirm('Are you sure you want to delete this job?');">Delete this job</a>
						<?php endif ?>
					<?php endif ?>
				</div>
			</div>
			
			<?php if ($this->session->userdata('role') == 'admin'): ?>
				<div class="job-side-box">
					<div class="header">
						Job Count Settings
					</div>
					<div class="content">
						How many job slots does this job take up?
						<div class="divider"></div>
						<select id="job_count" style="width:auto; margin:0 4px;">
							<?php for($i=0;$i<($daily_limit['limit'] + 1);$i++): ?>
							<?php if (@$job['job_count']==$i): ?>
								<option selected="selected"><?=$i?></option>
							<?php else: ?>
								<option><?=$i?></option>
							<?php endif ?>
							<?php endfor; ?>
						</select>
						slots.
						<span class="ajax-loader" style="display:none;"><img src="<?=base_url()?>assets/images/ajax-loader.gif" /></span>
					</div>
				</div>
			<?php endif ?>
			
			<div class="job-side-box">
				<div class="header">
					<a href="<?=base_url()?>admin/customer/<?=$job['customer_id']?>">Edit Profile</a>
					Customer Summary
				</div>
				<div class="content">
					<strong>Customer:</strong> <a href="<?=base_url()?>admin/customer/<?=$job['customer_id']?>"><?=$job['first_name']?> <?=$job['last_name']?></a><br />
					<strong>Address:</strong><br />
					<div style="padding-left:10px;">
						<?=$job['address']?><br />
						<?=$job['city']?>, <?=$job['state']?>, <?=$job['zip_code']?>
					</div>
					<strong>Billing Address:</strong><br />
					<div style="padding-left:10px;">
						<?php if ($job['different_billing_address'] == 'y'): ?>
							<?=$job['billing_address']?><br />
							<?=$job['billing_city']?>, <?=$job['billing_state']?>, <?=$job['billing_zip_code']?>
						<?php else: ?>
							<?=$job['address']?><br />
							<?=$job['city']?>, <?=$job['state']?>, <?=$job['zip_code']?>
						<?php endif ?>
					</div>
					<div class="divider"></div>
					<strong>Other Active Jobs:</strong>
					<div style="padding-left:10px;">
						<?php foreach ($other_jobs as $key => $value): ?>
						<a href="<?=base_url()?>admin/job/<?=$value['id']?>"><?=$value['job_type']?> (<?=date("M j, Y",strtotime($value['job_date']))?>)</a><br />
						<?php endforeach ?>
						<?php if (count($other_jobs) == 0): ?>
							Customer has no other jobs
						<?php endif ?>
					</div>
				</div>
			</div>
			
			<div class="job-side-box">
				<a name="job-notes"></a>
				<div class="header">
					<a href="<?=base_url()?>ajax/view_job_notes/<?=$job['id']?>" style="margin-right:75px;" class="facebox">View All</a> 
					<a href="<?=base_url()?>ajax/add_job_note/<?=$job['id']?>" class="facebox">Add Note</a>
					Job Notes
				</div>
				<div class="content">
					<?php foreach ($job_notes as $key => $value): ?>
						<strong>Posted:</strong> <?=date("F j, Y",strtotime($value['created']))?>, <strong>By:</strong> <?=$value['first_name']?> <?=$value['last_name']?><br />
						<span class="warning"><?=character_limiter($value['note'],90)?></span>
						<div class="divider"></div>
					<?php endforeach ?>
					<?php if (count($job_notes) == 0): ?>
					<div style="background:#fff; padding:10px">
						This job has no notes.
					</div>
					<?php endif ?>
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
					<a href="<?=base_url()?>ajax/add_file_iframe/<?=$job['id']?>" class="facebox">Add File</a>
					Upload Files
				</div>
				<div class="content">
					<?php if (count($job_files) > 0): ?>
					<table cellspacing="0" class="files-table">
						<?php foreach ($job_files as $key => $value): ?>
						<tr>
							<td><img src="/assets/images/mime-generic.gif" /></td>
							<td><a href="<?=base_url()?>admin/download/<?=$value['id']?>"><?=$value['original_filename']?></a></td>
							<td><a href="<?=base_url()?>admin/delete_file/<?=$value['id']?>"><img src="/assets/images/delete-icon.gif" /></a></td>
						</tr>
						<?php endforeach ?>
					</table>
					<?php else: ?>
						<div style="padding:10px; background:#fff;">
							No uploaded files.
						</div>
					<?php endif ?>
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
					Job Location Map
				</div>
				<?php if ($job['address'] != '' && $job['city'] != '' && $job['state'] != ''): ?>
					<div id="map_canvas" style="width: 100%; height: 200px"></div>
				<?php else: ?>
					<div style="padding:10px; background:#fff;">
						No address specified.
					</div>
				<?php endif ?>
			</div>
			
		</div>
		<div class="clear-both"></div>
	</div>
</div>

<script type="text/javascript" charset="utf-8">
$(document).ready(function() {
	var address = '<?=$job['address']?>';
	var city = '<?=$job['city']?>';
	var state = '<?=$job['state']?>';
        var jobstatus = $("select[name=current_status]").val();
	
	if(address != '' && city != '' && state != '')
	{
		showAddress('<?=$job['address']?>, <?=$job['city']?>, <?=$job['state']?>');
	}
	
	if($('select[name=stories]').val() > 1) {$("#panel_access_row").show(); }
	if($('select[name=roof_type_id]').val() == 'other') {$("#other_roof_type_wrap").show();}
	if($('select[name=rafter_type_id]').val() == 'other') {$("#other_rafter_type_wrap").show();}
	if($('select[name=installation_type_id]').val() == 'other') {$("#other_installation_type_wrap").show();}
	if($('select[name=fan_brand_id]').val() == 'other') {$("#fan_brand_wrap").show();}
	if($('select[name=fan_size_id]').val() == 'other') {$("#fan_size_wrap").show();}
	
	$('select[name=stories]').change(function() {
		if($(this).val() > 1)
			$("#panel_access_row").show();
		else
			$("#panel_access_row").hide();
	});
	
	$('select[name=roof_type_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_roof_type_wrap").show();
		else
			$("#other_roof_type_wrap").hide();
	});
	
	$('select[name=rafter_type_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_rafter_type_wrap").show();
		else
			$("#other_rafter_type_wrap").hide();
	});
	
	$('select[name=installation_type_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_installation_type_wrap").show();
		else
			$("#other_installation_type_wrap").hide();
	});
	
	$('select[name=fan_brand_id]').change(function() {
		if($(this).val() == 'other')
			$("#fan_brand_wrap").show();
		else
			$("#fan_brand_wrap").hide();
	});
	
	$('select[name=fan_size_id]').change(function() {
		if($(this).val() == 'other')
			$("#fan_size_wrap").show();
		else
			$("#fan_size_wrap").hide();
	});
	
	$('select[name=current_status]').change(function() {
		if(window.confirm("Are you sure?")){
		status = $(this).val();
                jobstatus =status;
		$.ajax({
		type: "POST",
		url: "/ajax/update_job_status",
		data: "job_id="+<?=$job_id?>+"&status="+status,
		dataType: "json",
		beforeSend : function() {
			$("#job-status-indicator").show();
		},
		success: function(json) {
			if(json.success == true)
			{
				//location.href = '/admin/job/' + job_id;
				$("#job-status-indicator").fadeOut('slow');
			}
			else
			{
				alert(json.msg);
			}
		  }
		});
                 } else{

                 $(this+'option[value="'+jobstatus+'"]').attr('selected', 'selected');
                }
	});
	
	var year = '<?=date("Y",$job_timestamp)?>';
	var day = '<?=date("d",$job_timestamp)?>';
	var month = '<?=date("m",$job_timestamp)?>';

	$('#job_count').change(function() {
		// update day's service call job count
		$.ajax({
			type: "POST",
			url: "/ajax/update_job_count",
			data: 'month='+month+'&year='+year+'&day='+day+'&job_count='+$(this).val(),
			beforeSend : function() {
				$(".ajax-loader").show();
			},
			dataType: "json",
			success: function(json) {
				$(".ajax-loader").fadeOut();
			}
		});
	});
});
</script>