<!--
Job Detail Page - Referrals - Add New
-->

<!--
Job Detail Page - Financing

- If system special price is 'yes', then sales commision is SET at $1300 (list price should be $14,285). Then Sales commission = 1300 - program discount - referral amount.
- if system special price is 'no', then sales commision is SET at 10% of list price. Then Sales commision = %10(list price of system) - program discount - referral amount.

-  Cannot Save unless referral is added (if yes)
-->

<!--
Job Detail Page - Job Specifications

- Ability for admin-user to edit/add dropdown options
- Ability to view progress of form completion
- Ability to "Create Purchase Agreement" PDF to download. A pre-designed PDF form will be populated with data on this page and customer details

- Job Summary widget
    - Ability for all users to change 'current status'
    - functionality as seen in design

- Customer Summary Widget
  - functionality as seen in design

- Job Notes widget
    - ability for user to add simple notes/progress on job with date-stamp

- Upload files widget
   - ability for users to upload/add/delete files to Job

- Job Location Map
   - Google Map of job address
-->

<div style="position:relative;">
	<div class="page-top-buttons">
		<button>Create Purchase Agreement</button>
		<button>Print Summary</button>
	</div>
</div>

<h1>Job Details</h1>
<p><a href="<?=base_url()?>">Home</a> / <a href="<?=base_url()?>admin/jobschedule">Job Calendar</a> / <a href="<?=base_url()?>admin/day/<?=date("Y/m/d/",$job_timestamp)?>"><?=date("F jS, Y",$job_timestamp)?></a> / <a href="#"><?=$job['first_name']?> <?=$job['last_name']?></a> / <?=$job['job_type']?></p>
<br />

<div class="generic-page-block">
	<div class="green-header">
		<span class="dark-green">Job Date:</span> <?=date("F jS, Y",$job_timestamp)?>
		<span class="dark-green">Job Type:</span> <?=$job['job_type']?>
		<span class="dark-green">Customer Name:</span> <?=$job['first_name']?> <?=$job['last_name']?>
	</div>
	<div class="content">
		<div class="two-col-wide-left">
			<div class="content-header"><?=$job['job_type']?> System Information</div>
			<p>Please fill out the relevant information below for your Customer's <?=$job['job_type']?> system.</p>
			<br />
			
			<div class="generic-nav-tabs">
				<a href="<?=base_url()?>admin/job/<?=$job_id?>">Job Specifications</a>
				<a href="<?=base_url()?>admin/job_financing/<?=$job_id?>">Financing</a>
				<a href="<?=base_url()?>admin/job_referrals/<?=$job_id?>" class="active">Referrals</a>
				<div class="clear-left"></div>
			</div>
			
			<br /><br />
			
			<?=form_open('admin/edit_referral/'.$referral_id,array('name' => 'form1', 'id' => 'form1'));?>
			<?=form_hidden('dosubmit','true')?>
			<table id="two-col-form" cellspacing="0" cellpadding="0" width="100%">
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Referral Source]</span><br /><br />
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<?=form_label('Referral Source', 'referral_type_id');?>
						<?=form_dropdown('referral_type_id',$referral_types,@$referral['referral_type_id'])?>
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Referee Contact Details]</span><br /><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('First Name', 'first_name');?>
						<?=form_input('first_name',@$referral['first_name']);?>
						
						<?=form_label('Home Phone', 'home_phone');?>
						<?=form_input('home_phone',@$referral['home_phone']);?>
					</td>
					<td>
						<div style="width:10px;"></div>
					</td>
					<td>
						<?=form_label('Last Name', 'last_name');?>
						<?=form_input('last_name',@$referral['last_name']);?>
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Referee Address Details]</span><br /><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Address', 'address');?>
						<?=form_input('address',@$referral['address']);?>
						
						<?=form_label('State', 'state');?>
						<?=form_dropdown('state',$states,@$referral['state'])?>
					</td>
					<td></td>
					<td>
						<?=form_label('City', 'city');?>
						<?=form_input('city',@$referral['city']);?>
						
						<?=form_label('Zip Code', 'zip_code');?>
						<?=form_input('zip_code',@$referral['zip_code']);?>
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Referral Amount]</span><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Referral Amount', 'referral_amount');?>
						<?=form_input('referral_amount',@$referral['referral_amount']);?>
					</td>
					<td></td>
					<td></td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[More Details]</span><br />
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<?=form_label('Additional comments or requirements', 'comments');?>
						<?=form_textarea('comments',@$referral['comments'])?>
					</td>
				</tr>
			</table>
			<?=form_close()?>
			
			<p><a href="" class="underline">Add another referral</a></p>
			<br /><br />
			<div class="divider"></div>
			
			<div style="float:left;">
				<button>Back to Calendar</button>
			</div>
			
			<div style="float:right">
				<button>Create Purchase Agreement</button>
				<button>Print</button>
				<button onclick="document.form1.submit()">Save</button>
			</div>
			<div class="clear-both"></div>
			
		</div>
		<div class="two-col-wide-right">
			<div class="progress-block">
				<div class="progress-bar">
					<div class="bar" style="width:<?=$percent_completed?>%;"></div>
				</div>
				<strong>Progress:</strong><br />
				You have completed <span class="bold"><?=$percent_completed?>%</span> of this form.
			</div>
			
			<div class="job-side-box">
				<div class="header">
					<a href="#">Back to Schedule</a>
					Job Summary
				</div>
				<div class="content">
					<strong>Salesperson:</strong> Akio Takasaki<br />
					<strong>Installers:</strong> Joey Phoman, Joe Bloggs, Darren Furumoto, Dean Watakusuki<br />
					<div class="divider"></div>
					<table width="100%">
						<tr>
							<td>Current Status:</td>
							<td><div align="right">
								<select>
									<option class="forms-pending">Forms Pending</option>
								</select>
							</div></td>
						</tr>
					</table>
					<div class="divider"></div>
					<strong>Booking Date:</strong> Wednesday, March 4, 2009<br />
					<span class="warning"><strong>Time Left for Expiration:</strong> 14 hours</span><br />
					<em>Last edited by: Office Admin</em>
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
					<a href="#">Edit Profile</a>
					Customer Summary
				</div>
				<div class="content">
					<strong>Customer:</strong> <a href="#">Glen Miyashiro</a>
					<strong>Address:</strong><br />
					<div style="padding-left:10px;">
						1234 Ocean Rd<br />
						Pearl City Highlands, Hawaii, 97667
					</div>
					<strong>Billing Address:</strong><br />
					<div style="padding-left:10px;">
						98553 Puaalii Lp<br />
						Aiea, Hawaii, 96701
					</div>
					<div class="divider"></div>
					<strong>Other Active Jobs:</strong>
					<div style="padding-left:10px;">
						<a href="#">Solar Water Heating (Nov 12, 2009)</a>
					</div>
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
					<a href="<?=base_url()?>ajax/view_job_notes" style="margin-right:75px;" class="facebox">View All</a> 
					<a href="<?=base_url()?>ajax/add_job_note" class="facebox">Add Note</a>
					Job Notes
				</div>
				<div class="content">
					<strong>Posted:</strong> October 30, 2009, <strong>By:</strong> Akio Takasaki<br />
					<span class="warning">The pre-pipe was completed, install date set</span>
					<div class="divider"></div>
					<strong>Posted:</strong> October 29, 2009, <strong>By:</strong> Akio Takasaki<br />
					<span class="warning">This customer needs a pre-pipe completed first. Darren needs to confirm with customer on date to measuring out house to get an install date.</span>
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
					<a href="#">Add File</a>
					Upload Files
				</div>
				<div class="content">
					<table cellspacing="0" class="files-table">
						<tr>
							<td><img src="/assets/images/mime-generic.gif" /></td>
							<td><a href="#">Miyashiro Plot plan.jpg</a></td>
							<td><a href="#"><img src="/assets/images/delete-icon.gif" /></a></td>
						</tr>
						<tr>
							<td><img src="/assets/images/mime-pdf.gif" /></td>
							<td><a href="#">Miyashiro AEI Purchase Agreement.pdf</a></td>
							<td><a href="#"><img src="/assets/images/delete-icon.gif" /></a></td>
						</tr>
						<tr>
							<td><img src="/assets/images/mime-pdf.gif" /></td>
							<td><a href="#">PV spec/design sheet.pdf</a></td>
							<td><a href="#"><img src="/assets/images/delete-icon.gif" /></a></td>
						</tr>
					</table>
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
					Job Location Map
				</div>
				<div id="map_canvas" style="width: 100%; height: 200px"></div>
			</div>
			
		</div>
		<div class="clear-both"></div>
	</div>
</div>
<script type="text/javascript" charset="utf-8">

$(document).ready(function() {
    <?php if(@$savedata){
            echo "$.facebox('<h3>Your Changes Have Been Saved.</h3><br /><button class=\"cancel-facebox\" >OK</button>');";
        }
      ?>
              });
 </script>