<?php

class Ajax extends Controller {

	function Ajax()
	{
		parent::Controller();
		if(!$this->session->userdata('logged_in'))
		{
			exit;
		}	
	}
	
	function index()
	{
		
	}
	
	function preview_job()
	{
		$this->load->view("ajax/preview_job");
	}
	
	function choose_reserve_date()
	{
		$this->load->view("ajax/choose_reserve_date");
	}
	
	function preview_day($year='',$month='',$day='')
	{
		
		if(@$year=='') {$year = date("Y");}
		if(@$month=='') {$month = date("m");}
		if(@$day=='') {$day = date("d");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = $day;
		
		$data['day_timestamp'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		$extra_sql = '';
		if($this->session->userdata("role") != 'admin')
		{
			$extra_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));
		}
		// grab photovoltaic jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='2' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
			";
		$data['jobs'] = $this->db->query($sql)->result_array();
		
		// grab solar water heating jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='1' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['jobs'] += $this->db->query($sql)->result_array();
		
		// grab solar attic fan jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='3' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['jobs'] += $this->db->query($sql)->result_array();
		
		// get service calls for the day
		$sql = "SELECT service_calls.*,customers.first_name,customers.last_name,customers.address,customers.city,customers.state,colors.hex FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN customers ON service_calls.customer_id=customers.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(service_calls.date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql";
		$data['service_calls'] = $this->db->query($sql)->result_array();
		
		$this->load->view("ajax/preview_day",$data);
	}
	
	function reserve_job($year='',$month='')
	{
		if($year=='')
		{
			$year = date("Y");
			$month = date("n");
			
		}
		
		$month = ltrim($month,"0");
		
		
		$data['year'] = $year;
		$data['month'] = $month;
		
		$data['customer_id'] = '';
		if($this->input->get("customer_id"))
		{
			$data['customer_id'] = $this->input->get("customer_id");
			$data['customer'] = $this->db->query("SELECT * FROM customers WHERE id=".$this->db->escape($data['customer_id']))->row_array();
		}
		
		//$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		// Grab customer types
		$data['customer_types'][''] = '- Select an Customer Type -';
		$this->db->order_by('type','asc');
		$inverter_types = $this->db->get("customer_types")->result_array();
		foreach($inverter_types as $row)
		{
			$data['customer_types'][$row['id']] = $row['type'];
		}
		
		// Grab job types
		$data['job_types'][''] = '- Select an Job Type -';
		$this->db->order_by('type','asc');
		$inverter_types = $this->db->get("job_types")->result_array();
		foreach($inverter_types as $row)
		{
			$data['job_types'][$row['id']] = $row['type'];
		}
		
		if ($this->session->userdata('role') == 'admin')
		{
			$data['salesmen'][''] = '- Select a Salesperson -';
			// Grab salesmen for dropdown
			$this->db->where('type','sales');
			$this->db->or_where('type','admin');
			$sm = $this->db->get("users")->result_array();
			foreach($sm as $v)
			{
				$data['salesmen'][$v['id']] = $v['first_name'].' '.$v['last_name'];
			}
		}
		
		$this->load->view("ajax/reserve_job",$data);
	}
	
	function init_job()
	{
		//header('Content-Type: application/json; charset=utf-8');
		
		$this->load->library('validation');
		$new_customer = false;
		
		// set validation rules
		$rules['job_type'] = "required";
		$rules['first_name'] = "required";
		$rules['last_name']	= "required";
		
		// set field "real" names
		$fields['first_name'] = "First Name";
		$fields['last_name'] = "Last Name";
		$fields['job_type'] = "Job Type";
		$fields['customer_type'] = "Customer Type";

		if($this->input->post("customer_id") == '')
		{
			$new_customer = true;
			$rules['customer_type'] = "required";
		}
		
		$this->validation->set_rules($rules);
		$this->validation->set_fields($fields);

		if($this->validation->run() == FALSE)
		{
			$json['success'] = false;
			$json['msg'] = $this->validation->error_string;
			echo json_encode($json);
		}
		else
		{
			if($new_customer)
			{
				// need to add new customer to db
				$row = array();
				$row['first_name'] = $this->input->post("first_name");
				$row['last_name'] = $this->input->post("last_name");
				$row['customer_type_id'] = $this->input->post("customer_type");
				$row['created'] = date("Y-m-d h:i:s");
				$this->db->insert("customers",$row);
				$customer_id = $this->db->insert_id(); // get id of customer that was added
			}
			else
			{
				$customer_id = $this->input->post("customer_id");
			}
			
			if($this->input->post("job_type") == 5)
			{
				$job['customer_id'] = $customer_id;
				if ($this->input->post("user_id")) {
					$job['user_id'] = $this->input->post("user_id");
				} else {
					$job['user_id'] = $this->session->userdata("user_id");
				}
				$job['date'] = $this->input->post("job_date")." ".date("h:i:s");
				$job['created'] = date("Y-m-d h:i:s");
				$this->db->insert("service_calls",$job);
				$job_id = $this->db->insert_id();
				$json['job_url'] = 'service_call';
			}
			else
			{
				$job['customer_id'] = $customer_id;
				if ($this->input->post("user_id")) {
					$job['user_id'] = $this->input->post("user_id");
				} else {
					$job['user_id'] = $this->session->userdata("user_id");
				}
				$job['job_type_id'] = $this->input->post("job_type");
				$job['job_date'] = $this->input->post("job_date")." ".date("h:i:s");
				$job['created'] = date("Y-m-d h:i:s");
				$this->db->insert("jobs",$job);
				$job_id = $this->db->insert_id();
				$json['job_url'] = 'job';
			}
			
			$json['success'] = true;
			$json['job_id'] = $job_id;
			$json['msg'] = 'Job added successfully';
			echo json_encode($json);
		}
	}
	
	function view_job_notes($job_id='')
	{
		$this->load->helper("text");
		
		// get job/customer info
		$sql = "SELECT 
				jobs.*, 
				job_types.type as job_type, 
				customers.first_name, 
				customers.last_name 
			FROM 
				jobs 
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id 
			LEFT JOIN customers ON jobs.customer_id=customers.id 
			WHERE jobs.id=".$this->db->escape($job_id);
		$data['job'] = $this->db->query($sql)->row_array();
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($job_id);
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		$this->load->view("ajax/view_job_notes", $data);
	}
	
	function view_sc_notes($sc_id='')
	{
		$this->load->helper("text");
		
		// get job/customer info
		$sql = "SELECT 
				service_calls.*,  
				customers.first_name, 
				customers.last_name 
			FROM 
				service_calls 
			LEFT JOIN customers ON service_calls.customer_id=customers.id 
			WHERE service_calls.id=".$this->db->escape($sc_id);
		$data['job'] = $this->db->query($sql)->row_array();
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id=".$this->db->escape($sc_id);
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		$this->load->view("ajax/view_sc_notes", $data);
	}
	
	function add_job_note($job_id='')
	{
		$data['job_id'] = $job_id;
		
		$this->load->view("ajax/add_job_note",$data);
	}
	
	function add_sc_note($sc_id='')
	{
		$data['service_call_id'] = $sc_id;
		
		$this->load->view("ajax/add_sc_note",$data);
	}
	
	function edit_job_note($note_id='')
	{
		$data['note_id'] = $note_id;
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.id=".$this->db->escape($note_id);
		$data['job_note'] = $this->db->query($sql)->row_array();
		$data['job_id'] = $data['job_note']['job_id'];
		
		$this->load->view("ajax/edit_job_note",$data);
	}
	
	function edit_sc_note($note_id='')
	{
		$data['note_id'] = $note_id;
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.id=".$this->db->escape($note_id);
		$data['job_note'] = $this->db->query($sql)->row_array();
		$data['service_call_id'] = $data['job_note']['service_call_id'];
		
		$this->load->view("ajax/edit_sc_note",$data);
	}
	
	function delete_job_note($note_id='')
	{
		// get job id based on note id
		$this->db->where("id",$note_id);
		$note = $this->db->get("notes")->row_array();
		
		$this->db->where('id',$note_id);
		$this->db->delete("notes");
		
		redirect("admin/job/".$note['job_id']);
	}
	
	function delete_sc_note($note_id='')
	{
		// get job id based on note id
		$this->db->where("id",$note_id);
		$note = $this->db->get("notes")->row_array();
		
		$this->db->where('id',$note_id);
		$this->db->delete("notes");
		
		redirect("admin/service_call/".$note['service_call_id']);
	}
	
	function do_update_note()
	{
		$row['note'] = $this->input->post("note");
		$this->db->where("id",$this->input->post("note_id"));
		$this->db->update("notes",$row);
		
		$json['success'] = true;
		$json['msg'] = 'Note has been updated!';
		echo json_encode($json);
	}
	
	function doaddnote()
	{
		//header('Content-Type: application/json; charset=utf-8');
		
		$json = array();
		
		if($this->input->post("note"))
		{
			$row = array();
			$row['job_id'] = $this->input->post("job_id");
			$row['service_call_id'] = $this->input->post("service_call_id");
			$row['note'] = $this->input->post("note");
			$row['user_id'] = $this->session->userdata("user_id");
			$row['created'] = date("Y-m-d h:i:s");
			$this->db->insert("notes",$row);
			
			$json['success'] = true;
			$json['msg'] = 'Note added';
			echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = 'Problem adding note';
			echo json_encode($json);
		}
	}
	
	function add_file_iframe($job_id='')
	{
		$data['job_id'] = $job_id;
		$this->load->view("ajax/add_file_iframe",$data);
	}
	
	function add_file($job_id='',$service_call='no')
	{
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}
		
		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
			$config['allowed_types'] = 'gif|jpg|png|pdf|doc|jpeg|docx|xls|xlsx|tiff';

			$this->load->library('upload');
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();

				$row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d h:i:s");
				$this->db->insert("files",$row);
				
				$this->load->view("ajax/file_uploaded",$data);
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_file",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_file",$data);
		}
	}
	
	function service_calls($year='',$month='',$day='')
	{
		$this->load->helper('text');
		
		if($year=='') {$year = date("Y");}
		if($month=='') {$month = date("m");}
		if($day=='') {$day = date("d");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = sprintf("%02d",$day);
		
		$data['calendar_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		$extra_sql = '';
		if($this->session->userdata("role") != 'admin')
		{
			$extra_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata('user_id'));
		}
		
		// get jobs for the current month
		$data['service_calls'] = $this->db->query("SELECT service_calls.*,customers.first_name,customers.last_name,customers.address,customers.city,customers.state FROM service_calls LEFT JOIN customers ON service_calls.customer_id=customers.id WHERE DATE_FORMAT(date,'%Y-%m-%d') = '".$year."-".$month."-".$data['day']."' $extra_sql ORDER BY service_calls.date ASC")->result_array();
		
		$this->load->view("ajax/service_calls",$data);
	}
	
	function quick_summary($year='',$month='',$day='')	
	{
		if(@$year=='') {$year = date("Y");}
		if(@$month=='') {$month = date("m");}
		if(@$day=='') {$day = date("d");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = $day;
		
		$data['day_timestamp'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		$extra_sql = '';
		if($this->session->userdata("role") != 'admin')
		{
			$extra_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));
		}
		
		// grab photovoltaic jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='2' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
			";
		$data['pv_jobs'] = $this->db->query($sql)->result_array();
		
		// grab solar water heating jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='1' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql";
		#die(print($sql));
		$data['swh_jobs'] = $this->db->query($sql)->result_array();
		
		// grab solar attic fan jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='3' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['saf_jobs'] = $this->db->query($sql)->result_array();
		
		#die(print(count($data['jobs'])));
		
		$data['jobs'] = ($data['saf_jobs'] + $data['pv_jobs'] + $data['swh_jobs']);
		
		// get service calls for the day
		$sql = "SELECT service_calls.*,customers.first_name,customers.last_name,customers.address,customers.city,customers.state,colors.hex FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN customers ON service_calls.customer_id=customers.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(service_calls.date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql";
		$data['service_calls'] = $this->db->query($sql)->result_array();
		
		$this->load->view("ajax/quick_summary",$data);
	}
	
	function find_previous_customer()
	{
		header('Content-Type: application/json; charset=utf-8');
		
		$this->db->where('first_name',$this->input->post("first_name"));
		$this->db->where('last_name',$this->input->post("last_name"));
		$row = $this->db->get("customers")->row_array();
		
		if(count($row) > 0)
		{
			$json['success'] = true;
			$json['msg'] = 'Previous customer found matching '.$this->input->post("first_name")." ".$this->input->post("last_name");
			$json['address'] = $row['city'].", ".$row['state']." @ ".$row['address'];
			$json['customer_id'] = $row['id'];
			echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = 'No customer found '.$this->input->post("first_name")." ".$this->input->post("last_name");
			echo json_encode($json);
		}
	}
	
	function update_day_count()
	{
		$year = $this->input->post("year");
		$month = $this->input->post("month");
		$day = $this->input->post("day");
		$sql = "UPDATE service_calls SET job_count=".$this->db->escape($this->input->post("job_count"))." WHERE DATE_FORMAT(`date`,'%Y-%m-%d') = '".$year."-".$month."-".$day."'";
		$this->db->query($sql);
		
		//$sql = "UPDATE jobs SET job_count=".$this->db->escape($this->input->post("job_count"))." WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".$day."'";
		//$this->db->query($sql);
		
		$json['success'] = true;
		$json['msg'] = 'Service call count updated';
		echo json_encode($json);
	}
	
	function update_job_count()
	{
		$year = $this->input->post("year");
		$month = $this->input->post("month");
		$day = $this->input->post("day");
		
		$sql = "UPDATE jobs SET job_count=".$this->db->escape($this->input->post("job_count"))." WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".$day."'";
		$this->db->query($sql);
		
		$json['success'] = true;
		$json['msg'] = 'Job count updated';
		echo json_encode($json);
	}
	
	function update_day_status($year='',$month='',$day='')
	{
		// get day's installation job count
		$jc = $this->db->query("SELECT job_count as total FROM jobs WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."'")->result_array();
		$jc_total = 0;
		foreach($jc as $jcs)
		{
			$jc_total += $jcs['total'];
		}
		
		// get day's service call total count
		$sc = $this->db->query("SELECT job_count as total FROM service_calls WHERE DATE_FORMAT(`date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."'")->row_array();		
		
		$data['day_job_total'] = ($jc_total + @$sc['total']);
		
		// daily job limit
		$data['daily_limit'] = $this->db->get("job_limit")->row_array();
		
		$this->load->view("ajax/day_status",$data);
	}
	
	function update_job_status()
	{
		if($this->input->post("status") && $this->input->post("job_id"))
		{
			$row['current_status'] = $this->input->post("status");
			$this->db->where("id",$this->input->post("job_id"));
			$this->db->update("jobs",$row);
			
			$json['success'] = true;
			$json['msg'] = "Job status updated!";
			
			echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = "Problem updating job status!";
			
			echo json_encode($json);
		}
	}
	
	function update_daily_limit()
	{	
		$sql = "UPDATE job_limit SET `limit`=".$this->db->escape($this->input->post("limit"));
		$this->db->query($sql);
		
		$json['success'] = true;
		$json['msg'] = 'Daily Limit';
		echo json_encode($json);
	}
    function  installer($year='',$month=''){
        $data = array();
        $data['customer_id'] = '';
       	$month = ltrim($month,"0");
	$data['year'] = $year;
	$data['month'] = $month;
	//$data['day'] = $day;
	//$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
	if($this->input->get("customer_id")){
            $data['customer_id'] = $this->input->get("customer_id");
            $data['customer'] = $this->db->query("SELECT * FROM customers WHERE id=".$this->db->escape($data['customer_id']))->row_array();
	}
	/**
         *  To do to remove the hard coded 
         */
        $data["numberofsystem"] = array(""=>"Select Number of Systems", "1"=>"1","2"=>"2","3"=>"3","4"=>"4","5"=>"5","6"=>"6");
        
        $module_array = array(""=>"Select Number of Modules");
        for ($i = 1 ; $i<=48;$i++){
            $module_array[$i] = $i;
        }
        $data["nomodule"] = $module_array;
        $data["nosubarray"] = array(""=>"Select Number of Sub-Arrays","1"=>"1","2"=>"2","3"=>"3","4"=>"4","5"=>"5","6"=>"6");
        $sql = "SELECT id,type FROM roof_types ";
        $roof_typea = array();
        $roof_typea["0"]= "Select Roof Type";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0){
             foreach ($query->result() as $row){
                $roof_typea[$row->id] =  $row->type;
            }
        }
        $data["roof_type"]= $roof_typea;
        $data["wirerundistance"] = array(""=>"Select Wire Run Distance","1"=>"1-20","2"=>"21-40","3"=>"41-80","4"=>"81-120","5"=>"Electrical Contractor");
        $sql = "SELECT id,type FROM wire_run_types ";
        $wire_typea = array();
        $wire_typea[" "]="Select A Wire Run Type";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0){
             foreach ($query->result() as $row){
                $wire_typea[$row->id] =  $row->type;
            }
        }
        
        $data["wire_type"] = $wire_typea;
        $data["nod"] = array("1"=>"1", "2"=> "2", "3"=>"3");
      
        $this->load->view("ajax/installer.php",$data);
    }

    function validate_savejob() {
            $this->load->library('validation');
            $new_customer = false;
            // set validation rules
            $rules['job_type'] = "required";
            $rules['first_name'] = "required";
            $rules['last_name']	= "required";
	// set field "real" names
            $fields['first_name'] = "First Name";
            $fields['last_name'] = "Last Name";
            $fields['job_type'] = "Job Type";
            $fields['customer_type'] = "Customer Type";
            if($this->input->post("customer_id") == '')
		{
			$new_customer = true;
			$rules['customer_type'] = "required";
		}
		
		$this->validation->set_rules($rules);
		$this->validation->set_fields($fields);
		if($this->validation->run() == FALSE)
		{
			$json['success'] = false;
			$json['msg'] = $this->validation->error_string;
			echo json_encode($json);
                        return ;
		}
                $json['success'] = true;
                echo json_encode($json);
    }
    function day_installerassign($year='',$month='',$day='' , $noinstaller = 4){
        $data = array();
        $data['customer_id'] = '';
        if($year==''){
            $year = date("Y");
            $month = date("n");
            $day = date("j");
	}
	$month = ltrim($month,"0");
	$day = ltrim($day,"0");
	$data['year'] = $year;
	$data['month'] = $month;
	$data['day'] = $day;
        $data['available_installer'] = $noinstaller;
	$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
        /**
         *  To do to remove the hard coded
         */
        $data["numberofinstaller"] = array(""=>"Select Number of Systems", "4"=>"4","5"=>"5","6"=>"6","7"=>"7","8"=>"8","9"=>"9" ,"10"=>"10" ,"11"=>"11","12"=>"12");
        $this->load->view("ajax/installer_assign.php",$data);
    }
    function block_day($date,$message=""){
     if (!$date  ){
        return 0;
     }
     else{
         //$date = "$year-$month-$day";
     $sql = "INSERT INTO admin_block_date(block_date,message) values('$date','$message')";
     $this->db->query($sql);
       echo 1;
     }
    }
     function block_day_form($year='',$month='',$day=''){
          $date = "$year-$month-$day";
          $data['year'] = $year;
	$data['month'] = $month;
	$data['day'] = $day;
	$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
          $data['date'] = $date;

        /**
         *  To do to remove the hard coded
         */

        $this->load->view("ajax/adminblockday",$data);
     
    }
    function save_session(){
        $this->session->set_userdata($_POST);
        
        $json['success'] = true;
        echo json_encode($json);
        //print_R($_SESSION);
    }
    function save_sessioninstaller($date='',$numberofinstaller=0,$user_id=0){
        if (!$date &&  !$numberofinstaller &&!$user_id){
            $json['success'] = true;
            echo json_encode($json);
            return ;
        }
        if (!$user_id) {
            $user_id = $this->session->userdata("re_user_id");
        }
        $session_id = $this->session->userdata("session_id");
        $sql = "INSERT INTO session_installer(sessionid,date_booked,user_id,number_of_installer) VALUES('$session_id', $date,$user_id,$numberofinstaller )";
        $this->db->query($sql);
        $json['success'] = true;
        echo json_encode($json);
        //print_R($_SESSION);
    }
}

?>