<?php

class Ajax extends Controller {

	function Ajax()
	{
		parent::Controller();
		if(!$this->session->userdata('logged_in'))
		{
			exit;
		}	
	}
	
	function index()
	{
		
	}
	
	function preview_job()
	{
		$this->load->view("ajax/preview_job");
	}
	
	function choose_reserve_date()
	{
		$this->load->view("ajax/choose_reserve_date");
	}
	
	function preview_day($year='',$month='',$day='')
	{
		
		if(@$year=='') {$year = date("Y");}
		if(@$month=='') {$month = date("m");}
		if(@$day=='') {$day = date("d");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = $day;
		
		$data['day_timestamp'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		$extra_sql = '';
		if($this->session->userdata("role") != 'admin')
		{
			$extra_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));
		}
		// grab photovoltaic jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='2' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
			";
		$data['jobs'] = $this->db->query($sql)->result_array();
		
		// grab solar water heating jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='1' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['jobs'] += $this->db->query($sql)->result_array();
		
		// grab solar attic fan jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='3' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['jobs'] += $this->db->query($sql)->result_array();
		
		// get service calls for the day
		$sql = "SELECT service_calls.*,customers.first_name,customers.last_name,customers.address,customers.city,customers.state,colors.hex FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN customers ON service_calls.customer_id=customers.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(service_calls.date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql";
		$data['service_calls'] = $this->db->query($sql)->result_array();
		
		$this->load->view("ajax/preview_day",$data);
	}
	
	function reserve_job($year='',$month='')
	{       $this->canceljob();
		if($year=='')
		{
			$year = date("Y");
			$month = date("n");
			
		}
		
		$month = ltrim($month,"0");
		
		
		$data['year'] = $year;
		$data['month'] = $month;
		
		$data['customer_id'] = '';
		if($this->input->get("customer_id"))
		{
			$data['customer_id'] = $this->input->get("customer_id");
			$data['customer'] = $this->db->query("SELECT * FROM customers WHERE id=".$this->db->escape($data['customer_id']))->row_array();
		}
		
		//$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		// Grab customer types
		$data['customer_types'][''] = '- Select an Customer Type -';
		$this->db->order_by('type','asc');
		$inverter_types = $this->db->get("customer_types")->result_array();
		foreach($inverter_types as $row)
		{
			$data['customer_types'][$row['id']] = $row['type'];
		}
		
		// Grab job types
		$data['job_types'][''] = '- Select an Job Type -';
		$this->db->order_by('type','asc');
		$inverter_types = $this->db->get("job_types")->result_array();
		foreach($inverter_types as $row)
		{
			$data['job_types'][$row['id']] = $row['type'];
		}
		
		if ($this->session->userdata('role') == 'admin')
		{
			$data['salesmen'][''] = '- Select a Salesperson -';
			// Grab salesmen for dropdown
			$this->db->where('type','sales');
			$this->db->or_where('type','admin');
			$sm = $this->db->get("users")->result_array();
			foreach($sm as $v)
			{
				$data['salesmen'][$v['id']] = $v['first_name'].' '.$v['last_name'];
			}
		}
		$data["sesuid"] = $this->session->userdata("user_id");
		$this->load->view("ajax/reserve_job",$data);
	}
	
	function init_job()
	{
		//header('Content-Type: application/json; charset=utf-8');
		
		$this->load->library('validation');
		$new_customer = false;
		
		// set validation rules
		$rules['job_type'] = "required";
		$rules['first_name'] = "required";
		$rules['last_name']	= "required";
		
		// set field "real" names
		$fields['first_name'] = "First Name";
		$fields['last_name'] = "Last Name";
		$fields['job_type'] = "Job Type";
		$fields['customer_type'] = "Customer Type";

		if($this->input->post("customer_id") == '')
		{
			$new_customer = true;
			$rules['customer_type'] = "required";
		}
		
		$this->validation->set_rules($rules);
		$this->validation->set_fields($fields);

		if($this->validation->run() == FALSE)
		{
			$json['success'] = false;
			$json['msg'] = $this->validation->error_string;
			echo json_encode($json);
		}
		else
		{
			if($new_customer)
			{
				// need to add new customer to db
				$row = array();
				$row['first_name'] = $this->input->post("first_name");
				$row['last_name'] = $this->input->post("last_name");
				$row['customer_type_id'] = $this->input->post("customer_type");
				$row['created'] = date("Y-m-d h:i:s");
				$this->db->insert("customers",$row);
				$customer_id = $this->db->insert_id(); // get id of customer that was added
			}
			else
			{
				$customer_id = $this->input->post("customer_id");
			}
			
			if($this->input->post("job_type") == 5)
			{
				$job['customer_id'] = $customer_id;
				if ($this->input->post("user_id")) {
					$job['user_id'] = $this->input->post("user_id");
				} else {
					$job['user_id'] = $this->session->userdata("user_id");
				}
				$job['date'] = $this->input->post("job_date")." ".date("h:i:s");
				$job['created'] = date("Y-m-d h:i:s");
				$this->db->insert("service_calls",$job);
				$job_id = $this->db->insert_id();
				$json['job_url'] = 'service_call';
			}
			else
			{
				$job['customer_id'] = $customer_id;
				if ($this->input->post("user_id")) {
					$job['user_id'] = $this->input->post("user_id");
				} else {
					$job['user_id'] = $this->session->userdata("user_id");
				}
				$job['job_type_id'] = $this->input->post("job_type");
				$job['job_date'] = $this->input->post("job_date")." ".date("h:i:s");
				$job['created'] = date("Y-m-d h:i:s");
				$this->db->insert("jobs",$job);
				$job_id = $this->db->insert_id();
				$json['job_url'] = 'job';
			}
			
			$json['success'] = true;
			$json['job_id'] = $job_id;
			$json['msg'] = 'Job added successfully';
			echo json_encode($json);
		}
	}
	
	function view_job_notes($job_id='')
	{
		$this->load->helper("text");
		
		// get job/customer info
		$sql = "SELECT 
				jobs.*, 
				job_types.type as job_type, 
				customers.first_name, 
				customers.last_name 
			FROM 
				jobs 
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id 
			LEFT JOIN customers ON jobs.customer_id=customers.id 
			WHERE jobs.id=".$this->db->escape($job_id);
		$data['job'] = $this->db->query($sql)->row_array();
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($job_id);
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		$this->load->view("ajax/view_job_notes", $data);
	}
	
	function view_sc_notes($sc_id='')
	{
		$this->load->helper("text");
		
		// get job/customer info
		$sql = "SELECT 
				service_calls.*,  
				customers.first_name, 
				customers.last_name 
			FROM 
				service_calls 
			LEFT JOIN customers ON service_calls.customer_id=customers.id 
			WHERE service_calls.id=".$this->db->escape($sc_id);
		$data['job'] = $this->db->query($sql)->row_array();
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id=".$this->db->escape($sc_id);
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		$this->load->view("ajax/view_sc_notes", $data);
	}
	
	function add_job_note($job_id='')
	{
		$data['job_id'] = $job_id;
		
		$this->load->view("ajax/add_job_note",$data);
	}
	
	function add_sc_note($sc_id='')
	{
		$data['service_call_id'] = $sc_id;
		
		$this->load->view("ajax/add_sc_note",$data);
	}
	
	function edit_job_note($note_id='')
	{
		$data['note_id'] = $note_id;
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.id=".$this->db->escape($note_id);
		$data['job_note'] = $this->db->query($sql)->row_array();
		$data['job_id'] = $data['job_note']['job_id'];
		
		$this->load->view("ajax/edit_job_note",$data);
	}
	
	function edit_sc_note($note_id='')
	{
		$data['note_id'] = $note_id;
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.id=".$this->db->escape($note_id);
		$data['job_note'] = $this->db->query($sql)->row_array();
		$data['service_call_id'] = $data['job_note']['service_call_id'];
		
		$this->load->view("ajax/edit_sc_note",$data);
	}
	
	function delete_job_note($note_id='')
	{
		// get job id based on note id
		$this->db->where("id",$note_id);
		$note = $this->db->get("notes")->row_array();
		
		$this->db->where('id',$note_id);
		$this->db->delete("notes");
		
		redirect("admin/job/".$note['job_id']);
	}
	
	function delete_sc_note($note_id='')
	{
		// get job id based on note id
		$this->db->where("id",$note_id);
		$note = $this->db->get("notes")->row_array();
		
		$this->db->where('id',$note_id);
		$this->db->delete("notes");
		
		redirect("admin/service_call/".$note['service_call_id']);
	}
	
	function do_update_note()
	{
		$row['note'] = $this->input->post("note");
		$this->db->where("id",$this->input->post("note_id"));
		$this->db->update("notes",$row);
		
		$json['success'] = true;
		$json['msg'] = 'Note has been updated!';
		echo json_encode($json);
	}
	
	function doaddnote()
	{
		//header('Content-Type: application/json; charset=utf-8');
		
		$json = array();
		
		if($this->input->post("note"))
		{
			$row = array();
			$row['job_id'] = $this->input->post("job_id");
			$row['service_call_id'] = $this->input->post("service_call_id");
			$row['note'] = $this->input->post("note");
			$row['user_id'] = $this->session->userdata("user_id");
			$row['created'] = date("Y-m-d h:i:s");
			$this->db->insert("notes",$row);
			
			$json['success'] = true;
			$json['msg'] = 'Note added';
			echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = 'Problem adding note';
			echo json_encode($json);
		}
	}
	
	function add_file_iframe($job_id='')
	{
		$data['job_id'] = $job_id;
		$this->load->view("ajax/add_file_iframe",$data);
	}
        function add_plan_iframe($job_id='')
	{
		$data['job_id'] = $job_id;
		$this->load->view("ajax/add_plan_iframe",$data);
	}
	
	function add_file($job_id='',$service_call='no')
	{
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}
		
		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
			$config['allowed_types'] = 'gif|jpg|png|pdf|doc|jpeg|docx|xls|xlsx|tiff';

			$this->load->library('upload');
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();

				$row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d h:i:s");
				$this->db->insert("files",$row);
				
				$this->load->view("ajax/file_uploaded",$data);
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_file",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_file",$data);
		}
	}

        function add_planfile($job_id='',$service_call='no')
	{
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
			$config['allowed_types'] = 'jpg|png|pdf|doc|jpeg|docs';

			$this->load->library('upload');
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();

				$row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d h:i:s");
                                $row['job_type'] = 2;
				$this->db->insert("genral_files",$row);
                                $data['jobid'] = $job_id ;
                                 $this->load->view("common/header");
				$this->load->view("ajax/plan_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_file",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_file",$data);
		}
	}

	function service_calls($year='',$month='',$day='')
	{
		$this->load->helper('text');
		
		if($year=='') {$year = date("Y");}
		if($month=='') {$month = date("m");}
		if($day=='') {$day = date("d");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = sprintf("%02d",$day);
		
		$data['calendar_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		$extra_sql = '';
		if($this->session->userdata("role") != 'admin')
		{
			$extra_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata('user_id'));
		}
		
		// get jobs for the current month
		$data['service_calls'] = $this->db->query("SELECT service_calls.*,customers.first_name,customers.last_name,customers.address,customers.city,customers.state FROM service_calls LEFT JOIN customers ON service_calls.customer_id=customers.id WHERE DATE_FORMAT(date,'%Y-%m-%d') = '".$year."-".$month."-".$data['day']."' $extra_sql ORDER BY service_calls.date ASC")->result_array();
		
		$this->load->view("ajax/service_calls",$data);
	}
	
	function quick_summary($year='',$month='',$day='')	
	{
		if(@$year=='') {$year = date("Y");}
		if(@$month=='') {$month = date("m");}
		if(@$day=='') {$day = date("d");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = $day;
		
		$data['day_timestamp'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		$data['editjob'] = true;
		$extra_sql = '';
		$pv_sql = '';
		if($this->session->userdata("role") != 'admin' )
		{
		 $extra_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));
                 $pv_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));

		}
                if( $this->session->userdata("role") == 'installer')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",installer_id)";
                  $data['editjob'] = false;
		}
                  if( $this->session->userdata("role") == 'contractor')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",contractor_id)";
                  $data['editjob'] = false;
		}
		// grab photovoltaic jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='2' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."'  $pv_sql
			";
		$data['pv_jobs'] = $this->db->query($sql)->result_array();
		
		// grab solar water heating jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='1' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql";
		#die(print($sql));
		$data['swh_jobs'] = $this->db->query($sql)->result_array();
		
		// grab solar attic fan jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='3' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['saf_jobs'] = $this->db->query($sql)->result_array();
		
		#die(print(count($data['jobs'])));
		
		$data['jobs'] = ($data['saf_jobs'] + $data['pv_jobs'] + $data['swh_jobs']);
		
		// get service calls for the day
		$sql = "SELECT service_calls.*,customers.first_name,customers.last_name,customers.address,customers.city,customers.state,colors.hex FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN customers ON service_calls.customer_id=customers.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(service_calls.date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql";
		$data['service_calls'] = $this->db->query($sql)->result_array();
		 global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		$this->load->view("ajax/quick_summary",$data);
	}
	
	function find_previous_customer()
	{
		header('Content-Type: application/json; charset=utf-8');
		
		$this->db->where('first_name',trim($this->input->post("re_first_name")));
		$this->db->where('last_name',trim($this->input->post("re_last_name")));
		$row = $this->db->get("customers")->row_array();
		
		if(count($row) > 0)
		{
			$json['success'] = true;
			$json['msg'] = 'Previous customer found matching '.$this->input->post("first_name")." ".$this->input->post("last_name");
			$json['address'] = $row['city'].", ".$row['state']." @ ".$row['address'];
			$json['customer_id'] = $row['id'];
			echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = 'No customer found '.$this->input->post("first_name")." ".$this->input->post("last_name");
			echo json_encode($json);
		}
	}
	
	function update_day_count()
	{
		$year = $this->input->post("year");
		$month = $this->input->post("month");
		$day = $this->input->post("day");
		$sql = "UPDATE service_calls SET job_count=".$this->db->escape($this->input->post("job_count"))." WHERE DATE_FORMAT(`date`,'%Y-%m-%d') = '".$year."-".$month."-".$day."'";
		$this->db->query($sql);
		
		//$sql = "UPDATE jobs SET job_count=".$this->db->escape($this->input->post("job_count"))." WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".$day."'";
		//$this->db->query($sql);
		
		$json['success'] = true;
		$json['msg'] = 'Service call count updated';
		echo json_encode($json);
	}
	
	function update_job_count()
	{
		$year = $this->input->post("year");
		$month = $this->input->post("month");
		$day = $this->input->post("day");
		
		$sql = "UPDATE jobs SET job_count=".$this->db->escape($this->input->post("job_count"))." WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".$day."'";
		$this->db->query($sql);
		
		$json['success'] = true;
		$json['msg'] = 'Job count updated';
		echo json_encode($json);
	}
	
	function update_day_status($year='',$month='',$day='')
	{
		// get day's installation job count
		$jc = $this->db->query("SELECT job_count as total FROM jobs WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."'")->result_array();
		$jc_total = 0;
		foreach($jc as $jcs)
		{
			$jc_total += $jcs['total'];
		}
		
		// get day's service call total count
		$sc = $this->db->query("SELECT job_count as total FROM service_calls WHERE DATE_FORMAT(`date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."'")->row_array();		
		
		$data['day_job_total'] = ($jc_total + @$sc['total']);
		
		// daily job limit
		$data['daily_limit'] = $this->db->get("job_limit")->row_array();
		
		$this->load->view("ajax/day_status",$data);
	}
	
	function update_job_status()
	{
		if($this->input->post("status") && $this->input->post("job_id"))
		{
			$row['current_status'] = $this->input->post("status");
			$this->db->where("id",$this->input->post("job_id"));
			$this->db->update("jobs",$row);
			
			$json['success'] = true;
			$json['msg'] = "Job status updated!";
			
			echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = "Problem updating job status!";
			
			echo json_encode($json);
		}
	}
	
	function update_daily_limit()
	{	
		$sql = "UPDATE job_limit SET `limit`=".$this->db->escape($this->input->post("limit"));
		$this->db->query($sql);
		
		$json['success'] = true;
		$json['msg'] = 'Daily Limit';
		echo json_encode($json);
	}
    function  installer($year='',$month=''){
        $data = array();
        $data['customer_id'] = '';
       	$month = ltrim($month,"0");
	$data['year'] = $year;
	$data['month'] = $month;
	//$data['day'] = $day;
	//$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
	if($this->input->get("customer_id")){
            $data['customer_id'] = $this->input->get("customer_id");
            $data['customer'] = $this->db->query("SELECT * FROM customers WHERE id=".$this->db->escape($data['customer_id']))->row_array();
	}
	/**
         *  To do to remove the hard coded 
         */
        $data["numberofsystem"] = array(""=>"Select Number of Systems", "1"=>"1","2"=>"2","3"=>"3","4"=>"4","5"=>"5","6"=>"6");
        
        $module_array = array(""=>"Select Number of Modules");
        for ($i = 1 ; $i<=48;$i++){
            $module_array[$i] = $i;
        }
        $data["nomodule"] = $module_array;
        $data["nosubarray"] = array(""=>"Select Number of Sub-Arrays","1"=>"1","2"=>"2","3"=>"3","4"=>"4","5"=>"5","6"=>"6","7"=>"7","8"=>"8");
        $sql = "SELECT id,type FROM roof_types ";
        $roof_typea = array();
        $roof_typea["0"]= "Select Roof Type";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0){
             foreach ($query->result() as $row){
                $roof_typea[$row->id] =  $row->type;
            }
        }
        $data["roof_type"]= $roof_typea;

        $data["wirerundistance"] = array("0"=>"Select Wire Run Distance");
        $this->db->order_by('id','asc');
        $moniter_display = $this->db->get("wire_run_distance")->result_array();
        foreach($moniter_display as $row) {
          $data["wirerundistance"][$row['id']] = $row['type'];
        }
        //$data["wirerundistance"] = array(""=>"Select Wire Run Distance","1"=>"1-20","2"=>"21-40","3"=>"41-80","4"=>"81-120","5"=>"Electrical Contractor");
        $sql = "SELECT id,type FROM wire_run_types ";
        $wire_typea = array();
        $wire_typea[" "]="Select A Wire Run Type";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0){
             foreach ($query->result() as $row){
                $wire_typea[$row->id] =  $row->type;
            }
        }
        
        $data["wire_type"] = $wire_typea;
        $data["nod"] = array("1"=>"1", "2"=> "2", "3"=>"3");
      
        $this->load->view("ajax/installer.php",$data);
    }

    function validate_savejob() {
            $this->load->library('validation');
            $new_customer = false;
            // set validation rules
            $rules['job_type'] = "required";
            $rules['re_first_name'] = "required";
            $rules['re_last_name']	= "required";
	// set field "real" names
            $fields['re_first_name'] = "First Name";
            $fields['re_last_name'] = "Last Name";
            $fields['job_type'] = "Job Type";
            $fields['customer_type'] = "Customer Type";
            if($this->input->post("customer_id") == '')
		{
			$new_customer = true;
			$rules['customer_type'] = "required";
		}
		
		$this->validation->set_rules($rules);
		$this->validation->set_fields($fields);
		if($this->validation->run() == FALSE)
		{
			$json['success'] = false;
			$json['msg'] = $this->validation->error_string;
			echo json_encode($json);
                        return ;
		}
                $json['success'] = true;
                echo json_encode($json);
    }
    function day_installerassign($year='',$month='',$day='' , $noinstaller = 4 , $noofday = 1){
        $data = array();
        $data['customer_id'] = '';
        if($year==''){
            $year = date("Y");
            $month = date("n");
            $day = date("j");
	}
	$month = ltrim($month,"0");
	$day = ltrim($day,"0");
	$data['year'] = $year;
	$data['month'] = $month;
	$data['day'] = $day;
        $data['available_installer'] = $noinstaller;
        $data['total_installer']= $this->session->userdata("in_noi");
        $data['no_day'] = $this->session->userdata("in_nod");
	$data['current_day'] = $noofday;
        $data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
        /**
         *  To do to remove the hard coded
         */
         $selectinstaller = array();
         $selectinstaller[0] = "Select Number of Installers";
         if ($data['no_day'] == 1){
             $selectinstaller[$data['total_installer']] = $data['total_installer'];
         }else {
         for($i = 1; $i<=$data['total_installer']; $i++ ){
            $selectinstaller[$i] = $i;
            if ($i >=12) break;
         }
         }
         $data["numberofinstaller"] = $selectinstaller;
         if(!$noofday){
           $this->load->view("ajax/installer_assignederror.php",$data);
        }else{
           
            $this->load->view("ajax/installer_assign.php",$data);
        }
    }
    function block_day($date,$message=""){
     if (!$date  ){
        return 0;
     }
     else{
         //$date = "$year-$month-$day";
     $sql = "INSERT INTO admin_block_date(block_date,message) values('$date','$message')";
     $this->db->query($sql);
       echo 1;
     }
    }
     function block_day_form($year='',$month='',$day=''){
          $date = "$year-$month-$day";
          $data['year'] = $year;
	$data['month'] = $month;
	$data['day'] = $day;
	$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
          $data['date'] = $date;

        /**
         *  To do to remove the hard coded
         */

        $this->load->view("ajax/adminblockday",$data);
     
    }
    function save_session(){
        
        $this->session->set_userdata($_POST);
        $json['success'] = true;
         
        echo json_encode($json);
      
    }
    function save_sessioninstaller(){
        $date=$this->input->get("re_date");
        $numberofinstaller=$this->input->get("in_nos");
        $user_id=0;
         if (!$user_id) {
            $user_id = $this->session->userdata("re_user_id");
            if(!$user_id){
                $setagain["re_user_id"] = $this->session->userdata("user_id");
                $this->session->set_userdata($setagain);
                $user_id = $this->session->userdata("user_id");
            }
        }
        if (!$date &&  !$numberofinstaller &&!$user_id){
            $json['success'] = false;
            echo json_encode($json);
            return ;
        }
          $session_id = $this->session->userdata("re_session_id");
          $noi_session = $this->session->userdata('in_noi');
          $nod_session =  $this->session->userdata('in_nod');
          $setagain["in_noi"] = $noi_session - $numberofinstaller ;
          $setagain["in_nod"] = $nod_session - 1;
          $this->session->set_userdata($setagain);
          $sql = "INSERT INTO session_installer(sessionid,date_booked,user_id,number_of_installer) VALUES('$session_id', '$date',$user_id,$numberofinstaller )";
          $this->db->query($sql);
          $json['success'] = true;
          echo json_encode($json);
     
    }
    function canceljob($return_type=0){
      $session_id = $this->session->userdata("re_session_id");
      $sql = "DELETE FROM  session_installer WHERE sessionid='$session_id'";
      $this->db->query($sql);
      $this->session->unset_userdata('re_user_id');
      $this->session->unset_userdata('re_first_name');
      $this->session->unset_userdata('re_last_name');
      $this->session->unset_userdata('job_type');
      $this->session->unset_userdata('in_noi');
      $this->session->unset_userdata('in_nod');
      if($return_type) {
        $json['success'] = true;
        echo json_encode($json);
      }
   }
    function savejob() {
      $year = "";
      $month = "";
      if(!$this->session->userdata('customer_id')) {
        // need to add new customer to db
        $row = array();
	$row['first_name'] =  $this->session->userdata('re_first_name');
	$row['last_name'] = $this->session->userdata('re_last_name');
	$row['customer_type_id'] = $this->session->userdata('customer_type');
	$row['created'] = date("Y-m-d h:i:s");
	$this->db->insert("customers",$row);
	$customer_id = $this->db->insert_id(); // get id of customer that was added
	}
	else
        {
	$customer_id = $this->session->userdata("customer_id");
	}
       $job['customer_id'] = $customer_id;
       $job['user_id'] = $this->session->userdata('re_user_id');
       $job['job_type_id'] = $this->session->userdata('job_type');
       $session_installer = $this->db->query("SELECT *  FROM  session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")."")->result_array();
       foreach($session_installer as $key => $value)
          {
              $session_installer_data[date("j", strtotime($value['date_booked']))][] = $value;
              $job['modified_by'] =  $this->session->userdata("user_id");
              $job['job_date'] =$value['date_booked']." ".date("h:i:s");
              $job['created'] = date("Y-m-d h:i:s");
              $job['no_installer_allocated'] = $value['number_of_installer'];
              $job['job_nos'] =  $this->session->userdata('in_nos');
              $job['job_nosa'] =  $this->session->userdata('in_nosa');
              $job['job_nom'] =  $this->session->userdata('in_nom');
              $job['roof_type_id'] =  $this->session->userdata('in_rooftype');
              $job['wire_run_distance'] =  $this->session->userdata('in_wirerundist');
              $job['wire_run_type_id'] =  $this->session->userdata('in_wireruntype');
              $this->db->insert("jobs",$job);
              $job_id = $this->db->insert_id();
              $year = date("Y" ,strtotime($value['date_booked']));
              $month = date("m" ,strtotime($value['date_booked']));
        }
          $json['success'] = true;
          $json['year'] = $year;
          $json['month'] = $month;
          $j= $this->getUserLoad($this->session->userdata('re_user_id'));
          $this->load->library('email');
          $config['mailtype'] = 'html';
          $this->email->initialize($config);
          $this->email->from('sales@aeihawaii.com', 'Schedular');
          $this->email->to($j[0]->email);
          $this->email->subject('AEI Administration:Job Created');
                   $message = "Congratulations ".$j[0]->first_name." ". $j[0]->last_name."<br/>
                       Now that you have completed your contract with your customer, you will now have to enter the technical specifications on the AEI Team System and get them an installation date.<br/>
Update and Edit your Technical Specifications Here:<br/>
  <a href='".base_url()."admin/job/$job_id'>Edit Technical Specification</a><br/><br/>
Update and Edit your Customer Information Here:<br/>

<a href='".base_url()."admin/customer_job/$job_id'>Edit Customer Information</a><br/><br/>
IMPORTANT NOTICE: YOU HAVE 24 HOURS FROM TIME OF INITIAL BOOKING TO ENTER AND SAVE ALL REQUIRED FIELDS FOR THE CUSTOMER'S:<br/>
   1.) JOB SPECIFICATIONS<br/>
   2.) CUSTOMER INFORMATION<br/>
   3.) PRICE INFORMATION<br/><br/><br/>
Sincerely,<br/>
The AEI Administration Team<br/>";
          @$this->email->message($message);
          @$this->email->send();
          $this->canceljob();
          echo json_encode($json);
        
    }
    function cancelsessionjob($id,$year ,$month,$noinstaller , $uid){
       $noi_session = $this->session->userdata('in_noi');
       $nod_session =  $this->session->userdata('in_nod');
       $setagain["in_noi"] = $noi_session + $noinstaller ;
       $setagain["in_nod"] = $nod_session + 1;
       $this->session->set_userdata($setagain);
       $sql = "DELETE FROM  session_installer WHERE id='$id'";
       $this->db->query($sql);
       redirect("admin/installer_available/$year/$month/$uid");
    }
    function day_installeredit($year,$month,$day,$installer,$jobs){
         $selectinstaller = array();
         $data["year"] = $year;
         $data["month"] = $month;
         $data["day"] = $day;
         $data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
         $data["installer"] = $installer;
         $data["jobs"] = $jobs;
         $this->load->view("ajax/installer_edit.php",$data);
        }
    
    function day_installersave(){
        $row = array();
        $resultcnt = 0;
	$row['day'] =  $this->input->post("re_date");
        $resultcnt = array();
	$resultcnt =  $this->db->query("SELECT * FROM installer_manual where day = '".$row['day']."'")->result_array();
        if(count($resultcnt)>=1) {
          $row['installer'] =  $this->input->post("in_nos") + $this->input->post("jobs");
          $this->db->where('day',$row['day']);
          $this->db->update('installer_manual', $row);
          $json['success'] = true;
          echo json_encode($json);
          return;
        }
        $row['installer'] =  $this->input->post("in_nos") + $this->input->post("jobs");
	$row['uid'] = $this->session->userdata('user_id');
	$row['created_on'] = date("Y-m-d h:i:s");
	$this->db->insert("installer_manual",$row);
        $json['success'] = true;
        echo json_encode($json);
    }

     function unblock_day($date,$message=""){
        // echo "$date";
        // die;
     
     if (!$date  ){
        return 0;
     }
     else{
         //$date = "$year-$month-$day";
     $sql = "DELETE FROM  admin_block_date  WHERE block_date='$date'";
     $this->db->query($sql);
       echo 1;
     }
    }
     function unblock_day_form($year='',$month='',$day=''){
         $date = "$year-$month-$day";
         $data['year'] = $year;
	 $data['month'] = $month;
	 $data['day'] = $day;
	 $data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
         $data['date'] = $date;

        /**
         *  To do to remove the hard coded
         */

        $this->load->view("ajax/adminunblockday",$data);

    }
    function adduser_ajax($usertype=null){
        
        if($this->session->userdata("role") != 'admin'){
            redirect("admin/error?e=permissions");
        }
        $data = array();
	if($this->input->post("type")){
            $row = array();
            $row['first_name'] = $this->input->post("first_name");
            $row['last_name'] = $this->input->post("last_name");
            $row['color_id'] = $this->input->post("color_id");
            $row['type'] = $this->input->post("type");
            $row['email'] = $this->input->post("email");
            $row['custom_hex'] = $this->input->post("custom_hex");
            if($this->input->post("password"))
            {
                $row['password'] = md5($this->input->post("password"));
            }
           $t = $this->db->insert("users",$row);
           $json['success'] = true;
           $json['id'] = $this->db->insert_id();
           $json['value'] = ucfirst($row['first_name']) ." ".ucfirst($row['last_name']);
           echo json_encode($json);
	   return;
        }
        $roles =array();
        $roles['admin'] = 'Admin';
	$roles['sales'] = 'Salesperson';
	$roles['installer'] = 'Installer';
        $roles['contractor'] = 'Contractor';
	$data['usertype'] = "";
        if($usertype) {
            if(!array_key_exists($usertype, $roles)){
                redirect("admin/error?e=permissions");
            }
            $roles =array();
            $roles[$usertype] = ucfirst($usertype);
        } 
        $data['roles'] = array();
	$data['usertype'] = "";
        $data['roles'] = $roles;
        $data['colors'] = $this->db->get("colors")->result_array();
        $this->load->view("ajax/new_user",$data);
		
    }

    function save_jobinstaller(){
        $assigninstaller=$this->input->post("ai");
        $job_id = $this->input->post("job_id");
        $sql = "UPDATE jobs set installer_id='$assigninstaller' WHERE id=$job_id";
        $this->db->query($sql);
        $json['success'] = true;
        echo json_encode($json);
    }
    function delete_referral($id){
        $sql = "DELETE FROM referrals WHERE id=".$id;
        $this->db->query($sql);
        $json['success'] = true;
        echo json_encode($json);
    }
    function ajaxplanlisting($job_id){
         $this->db->where("job_id",$job_id);
	$this->db->order_by("created","desc");
	$plan_files = $this->db->get("genral_files")->result_array();
        if (count($plan_files) > 0){
        $output =    '<table cellspacing="0" class="files-table">';
        foreach ($plan_files as $key => $value) {

        $output .='<tr>';
	$output .='<td><img src="/assets/images/mime-generic.gif" />&nbsp;&nbsp;';
        $output .='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/download/'.$value['id'].'">'.$value['original_filename'].'</a></td>';
	$output .='<td><a href="'.base_url().'admin/delete_planfile/'.$value['id'].'"><img src="/assets/images/delete-icon.gif" /></a></td>';
	$output .='</tr>';
	}
        $output .='</table>';

       } else{
	$output ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';
	}
    
        echo $output;
    }

    function savetimelimit(){
     $row = array();
     $resultcnt = 0;
     $row['jid']  =  $this->input->post("jobid");
     $resultcnt = array();
     $resultcnt =  $this->db->query("SELECT * FROM timelimit_manual_extend where jid = '".$row['jid']."'")->result_array();
     if(count($resultcnt)>=1) {
        $row['timeext'] =  $this->input->post("timeext");
        $this->db->where('jid',$row['jid']);
        $this->db->update('timelimit_manual_extend', $row);
        $json['success'] = true;
         echo json_encode($json);
          return;
        }
        $row['timeext'] =  $this->input->post("timeext");
	$row['created_on'] = date("Y-m-d h:i:s");
	$this->db->insert("timelimit_manual_extend",$row);
        $json['success'] = true;
        echo json_encode($json);
    }
    function timeextform($jobid){
      $data['jobid'] = $jobid;
      $data["timeext"] = array(""=>"Select Number of day", "24"=>"1 Day","48"=>"2 Day","72"=>"3 day","96"=>"4 day","120"=>"5 day","144"=>"6 day");
      $data["timeextsel"] = 0;
      $resultcnt =  $this->db->query("SELECT * FROM timelimit_manual_extend where jid = '".$jobid."'")->result_array();
      if(count($resultcnt)>=1) {
        $data["timeextsel"] = $resultcnt[0]['timeext'];
      }
      $this->load->view("ajax/timeext_job",$data);
    }

    function  globaltimeextform(){
      $data["timeext"] = array(""=>"Select Number of day", "24"=>"1 Day","48"=>"2 Day","72"=>"3 day","96"=>"4 day","120"=>"5 day","144"=>"6 day");
      $data["timeextsel"] = 0;
      $resultcnt =  $this->db->query("SELECT * FROM globalconfig  where id = 1")->result_array();
      if(count($resultcnt)>=1) {
        $data["timeextsel"] = $resultcnt[0]['globaltimelimit'];
      }
      $this->load->view("ajax/globaltimeext_job",$data);
    }
    function saveglobaltimelimit(){
     $row = array();
     $row['globaltimelimit'] =  $this->input->post("timeext");
     $this->db->where('id',1);
     $this->db->update('globalconfig', $row);
     $json['success'] = true;
     echo json_encode($json);
    }
    function getUserLoad($id){
      if (!$id) return 0;
      $j = $this->db->query("SELECT * FROM users WHERE id=$id")->result();

      return $j;
 }
}

?>