<style>
.ts-container { max-width: 960px; margin: 0 auto; padding: 10px; }
.ts-tabs { margin-bottom: 15px; }
.ts-tabs a { display: inline-block; padding: 8px 16px; margin-right: 5px; background: #e0e0e0; color: #333; text-decoration: none; border-radius: 4px 4px 0 0; }
.ts-tabs a.active { background: #4a90d9; color: #fff; }
.ts-tabs a:hover { background: #4a90d9; color: #fff; }
.ts-nav { margin-bottom: 15px; }
.ts-nav a { text-decoration: none; color: #4a90d9; padding: 5px 10px; }
.ts-nav a:hover { text-decoration: underline; }
.ts-table { width: 100%; border-collapse: collapse; margin-top: 10px; }
.ts-table th { background: #4a90d9; color: #fff; padding: 8px 10px; text-align: left; font-size: 13px; }
.ts-table td { padding: 8px 10px; border-bottom: 1px solid #ddd; font-size: 13px; }
.ts-table tr:hover { background: #f5f5f5; }
.ts-table .weekend { background: #f9f0f0; }
.ts-table .day-total { font-weight: bold; background: #f0f4f8; }
.ts-week-total { font-size: 16px; font-weight: bold; text-align: right; margin-top: 10px; padding: 10px; background: #e8f0fe; }
.ts-user-select { margin-bottom: 15px; }
.ts-user-select select { padding: 5px; font-size: 14px; }
.ts-badge { display: inline-block; padding: 2px 6px; border-radius: 3px; font-size: 11px; }
.ts-badge-manual { background: #fff3cd; color: #856404; }
.ts-badge-clock { background: #d1ecf1; color: #0c5460; }
.ts-cust-summary { margin-top: 15px; padding: 15px; background: #f8f9fa; border: 1px solid #ddd; border-radius: 4px; }
.ts-cust-summary h4 { margin: 0 0 10px 0; }
.ts-cust-summary table { width: 100%; border-collapse: collapse; }
.ts-cust-summary table th { background: #6c757d; color: #fff; padding: 6px 10px; text-align: left; font-size: 12px; }
.ts-cust-summary table td { padding: 6px 10px; border-bottom: 1px solid #ddd; font-size: 13px; }
@media (max-width: 600px) {
    .ts-table { font-size: 12px; }
    .ts-table th, .ts-table td { padding: 5px; }
}
</style>

<div class="ts-container">
    <div class="ts-tabs">
        <a href="<?= base_url() ?>timesheet">Clock In/Out</a>
        <a href="<?= base_url() ?>timesheet/weekly" class="active">Weekly</a>
        <a href="<?= base_url() ?>timesheet/monthly">Monthly</a>
        <?php if ($is_admin) { ?>
        <a href="<?= base_url() ?>timesheet/admin_view">Admin</a>
        <a href="<?= base_url() ?>timesheet/group_admin">Groups</a>
        <?php } ?>
    </div>

    <?php if ($is_admin && !empty($groups)) { ?>
    <div style="margin-bottom:8px;">
        <strong style="color:#7b2d8e;">Group:</strong>
        <a href="<?= base_url() ?>timesheet/weekly/<?= date('Y/m/d', strtotime($week_start)) ?>?group_id=0" style="display:inline-block; padding:3px 10px; border-radius:12px; font-size:12px; text-decoration:none; margin:0 2px; <?= ($group_filter == 0) ? 'background:#7b2d8e; color:#fff;' : 'background:#f0e6f6; color:#7b2d8e;' ?>">No Group</a>
        <?php foreach ($groups as $g) { ?>
        <a href="<?= base_url() ?>timesheet/weekly/<?= date('Y/m/d', strtotime($week_start)) ?>?group_id=<?= intval($g['id']) ?>" style="display:inline-block; padding:3px 10px; border-radius:12px; font-size:12px; text-decoration:none; margin:0 2px; <?= ($group_filter == $g['id']) ? 'background:#7b2d8e; color:#fff;' : 'background:#f0e6f6; color:#7b2d8e;' ?>"><?= htmlspecialchars($g['group_name']) ?> (<?= intval($g['member_count']) ?>)</a>
        <?php } ?>
    </div>
    <?php } ?>

    <?php if ($is_admin) { ?>
    <div class="ts-user-select">
        <strong>Role:</strong>
        <label style="margin:0 4px; cursor:pointer;">
            <input type="checkbox" id="ts-role-all" onchange="tsRoleAllToggle(this)" <?= empty($role_filter) ? 'checked' : '' ?> /> All
        </label>
        <?php foreach ($roles as $r) { ?>
        <label style="margin:0 4px; cursor:pointer;">
            <input type="checkbox" class="ts-role-cb" value="<?= htmlspecialchars($r) ?>" onchange="tsRoleCbChange()" <?= in_array($r, $role_filter) ? 'checked' : '' ?> /> <?= ucfirst(htmlspecialchars($r)) ?>
        </label>
        <?php } ?>
        <button type="button" onclick="tsApplyRolesWeekly()" style="padding:3px 10px; cursor:pointer;">Apply</button>
        <span style="margin:0 10px;">|</span>
        <strong>Employee:</strong>
        <select id="ts-emp-select" onchange="tsChangeEmployee(this.value, 'weekly')">
            <?php foreach ($employees as $emp) { ?>
            <option value="<?= $emp['id'] ?>" <?= ($emp['id'] == $view_user_id) ? 'selected' : '' ?>><?= htmlspecialchars($emp['first_name'] . ' ' . $emp['last_name']) ?></option>
            <?php } ?>
        </select>
    </div>
    <?php } ?>

    <h3><?= htmlspecialchars($view_user_name) ?> - Week of <?= date('M j', strtotime($week_start)) ?> - <?= date('M j, Y', strtotime($week_end)) ?></h3>

    <div class="ts-nav">
        <a href="<?= base_url() ?>timesheet/weekly/<?= $prev_week ?><?= ($is_admin && $view_user_id != $user_id) ? '?user_id=' . $view_user_id : '' ?>">&laquo; Previous Week</a>
        |
        <a href="<?= base_url() ?>timesheet/weekly<?= ($is_admin && $view_user_id != $user_id) ? '?user_id=' . $view_user_id : '' ?>">Current Week</a>
        |
        <a href="<?= base_url() ?>timesheet/weekly/<?= $next_week ?><?= ($is_admin && $view_user_id != $user_id) ? '?user_id=' . $view_user_id : '' ?>">Next Week &raquo;</a>
    </div>

    <table class="ts-table">
        <tr>
            <th>Day</th>
            <th>Date</th>
            <th>Clock In</th>
            <th>Clock Out</th>
            <th>Break</th>
            <th>Net Hours</th>
            <th>Job</th>
            <th>Type</th>
            <th>Notes</th>
        </tr>
        <?php
        // Accumulate per-customer weekly totals while rendering
        $weekly_cust_totals = array();

        foreach ($days as $day) {
            $is_weekend = (date('N', strtotime($day['date'])) >= 6);
            $row_class = $is_weekend ? ' class="weekend"' : '';
            $wk_class = $is_weekend ? ' weekend' : '';

            if (count($day['entries']) > 0) {
                foreach ($day['entries'] as $idx => $entry) {
                    $net = intval($entry['duration_minutes']) - intval($entry['break_minutes']);
                    echo '<tr' . $row_class . '>';
                    if ($idx == 0) {
                        echo '<td><strong>' . $day['day_name'] . '</strong></td>';
                        echo '<td>' . date('M j', strtotime($day['date'])) . '</td>';
                    } else {
                        echo '<td></td><td></td>';
                    }
                    echo '<td>' . date('g:i A', strtotime($entry['clock_in'])) . '</td>';
                    echo '<td>' . ($entry['clock_out'] ? date('g:i A', strtotime($entry['clock_out'])) : '<em>Active</em>') . '</td>';
                    echo '<td>' . intval($entry['break_minutes']) . 'm</td>';
                    echo '<td>' . ($entry['clock_out'] ? floor($net / 60) . 'h ' . ($net % 60) . 'm' : '-') . '</td>';
                    echo '<td>';
                    if (!empty($entry['customer_id'])) {
                        echo htmlspecialchars(trim($entry['customer_name']));
                        if (!empty($entry['customer_address'])) {
                            echo ' <small style="color:#666;">' . htmlspecialchars(trim($entry['customer_address'])) . '</small>';
                        }
                    } else {
                        echo '<span style="color:#999;">-</span>';
                    }
                    echo '</td>';
                    echo '<td><span class="ts-badge ts-badge-' . $entry['entry_type'] . '">' . $entry['entry_type'] . '</span></td>';
                    echo '<td>' . htmlspecialchars($entry['notes']) . '</td>';
                    echo '</tr>';

                    // Accumulate customer totals
                    if ($entry['clock_out']) {
                        $cid = !empty($entry['customer_id']) ? intval($entry['customer_id']) : 0;
                        if (!isset($weekly_cust_totals[$cid])) {
                            $weekly_cust_totals[$cid] = array(
                                'customer_id' => $cid,
                                'customer_name' => isset($entry['customer_name']) ? trim($entry['customer_name']) : '',
                                'customer_address' => isset($entry['customer_address']) ? trim($entry['customer_address']) : '',
                                'minutes' => 0
                            );
                        }
                        $weekly_cust_totals[$cid]['minutes'] += $net;
                    }
                }
                // Day subtotal
                echo '<tr class="day-total' . $wk_class . '">';
                echo '<td colspan="6" style="text-align:right;">' . $day['day_name'] . ' Total:</td>';
                echo '<td colspan="3"><strong>' . floor($day['total_minutes'] / 60) . 'h ' . ($day['total_minutes'] % 60) . 'm</strong></td>';
                echo '</tr>';
            } else {
                echo '<tr' . $row_class . '>';
                echo '<td><strong>' . $day['day_name'] . '</strong></td>';
                echo '<td>' . date('M j', strtotime($day['date'])) . '</td>';
                echo '<td colspan="7" style="color:#999;">No entries</td>';
                echo '</tr>';
            }
        } ?>
    </table>

    <div class="ts-week-total">
        Week Total: <?= floor($week_total / 60) ?>h <?= $week_total % 60 ?>m
        (<?= round($week_total / 60, 2) ?> hours)
    </div>

    <?php if (count($weekly_cust_totals) > 1 || (count($weekly_cust_totals) == 1 && !isset($weekly_cust_totals[0]))) { ?>
    <div class="ts-cust-summary">
        <h4>Time by Job - This Week</h4>
        <table>
            <tr>
                <th>Job</th>
                <th>Total Hours</th>
            </tr>
            <?php
            foreach ($weekly_cust_totals as $ct) {
                if ($ct['customer_id'] == 0) continue;
                echo '<tr>';
                $job_label = htmlspecialchars($ct['customer_name']);
                if (!empty($ct['customer_address'])) {
                    $job_label .= ' <small style="color:#666;">' . htmlspecialchars(trim($ct['customer_address'])) . '</small>';
                }
                echo '<td>' . $job_label . '</td>';
                echo '<td>' . floor($ct['minutes'] / 60) . 'h ' . ($ct['minutes'] % 60) . 'm (' . round($ct['minutes'] / 60, 2) . ' hrs)</td>';
                echo '</tr>';
            }
            if (isset($weekly_cust_totals[0]) && $weekly_cust_totals[0]['minutes'] > 0) {
                echo '<tr>';
                echo '<td><em>General (no job)</em></td>';
                echo '<td>' . floor($weekly_cust_totals[0]['minutes'] / 60) . 'h ' . ($weekly_cust_totals[0]['minutes'] % 60) . 'm (' . round($weekly_cust_totals[0]['minutes'] / 60, 2) . ' hrs)</td>';
                echo '</tr>';
            }
            ?>
        </table>
    </div>
    <?php } ?>
</div>

<script>
function tsChangeEmployee(userId, view) {
    var url = '<?= base_url() ?>timesheet/' + view;
    <?php if (isset($week_start)) { ?>
    if (view === 'weekly') {
        url += '/<?= date('Y/m/d', strtotime($week_start)) ?>';
    }
    <?php } ?>
    url += '?user_id=' + userId;
    window.location.href = url;
}

function tsRoleAllToggle(el) {
    if (el.checked) {
        var cbs = document.querySelectorAll('.ts-role-cb');
        for (var i = 0; i < cbs.length; i++) cbs[i].checked = false;
    }
}
function tsRoleCbChange() {
    var cbs = document.querySelectorAll('.ts-role-cb');
    var anyChecked = false;
    for (var i = 0; i < cbs.length; i++) { if (cbs[i].checked) anyChecked = true; }
    document.getElementById('ts-role-all').checked = !anyChecked;
}
function tsApplyRolesWeekly() {
    var allEl = document.getElementById('ts-role-all');
    var url = '<?= base_url() ?>timesheet/weekly';
    <?php if (isset($week_start)) { ?>
    url += '/<?= date('Y/m/d', strtotime($week_start)) ?>';
    <?php } ?>
    if (allEl && allEl.checked) {
        url += '?roles=all';
    } else {
        var cbs = document.querySelectorAll('.ts-role-cb');
        var selected = [];
        for (var i = 0; i < cbs.length; i++) {
            if (cbs[i].checked) selected.push(cbs[i].value);
        }
        url += '?roles=' + (selected.length > 0 ? encodeURIComponent(selected.join(',')) : 'all');
    }
    window.location.href = url;
}
</script>
