<style>
.ts-container { max-width: 960px; margin: 0 auto; padding: 10px; }
.ts-tabs { margin-bottom: 15px; }
.ts-tabs a { display: inline-block; padding: 8px 16px; margin-right: 5px; background: #e0e0e0; color: #333; text-decoration: none; border-radius: 4px 4px 0 0; }
.ts-tabs a.active { background: #4a90d9; color: #fff; }
.ts-tabs a:hover { background: #4a90d9; color: #fff; }
.ts-nav { margin-bottom: 15px; }
.ts-nav a { text-decoration: none; color: #4a90d9; padding: 5px 10px; }
.ts-nav a:hover { text-decoration: underline; }
.ts-table { width: 100%; border-collapse: collapse; margin-top: 10px; }
.ts-table th { background: #4a90d9; color: #fff; padding: 8px 10px; text-align: left; font-size: 13px; }
.ts-table td { padding: 6px 10px; border-bottom: 1px solid #ddd; font-size: 13px; }
.ts-table tr:hover { background: #f5f5f5; }
.ts-table .weekend { background: #f9f0f0; }
.ts-table .overtime { color: #e74c3c; font-weight: bold; }
.ts-table .day-total { font-weight: bold; background: #f0f4f8; }
.ts-table .day-total.weekend { background: #f0e8e8; }
.ts-grand-total { font-size: 16px; font-weight: bold; text-align: right; margin-top: 10px; padding: 10px; background: #e8f0fe; }
.ts-user-select { margin-bottom: 15px; }
.ts-user-select select { padding: 5px; font-size: 14px; }
.ts-cust-summary { margin-top: 15px; padding: 15px; background: #f8f9fa; border: 1px solid #ddd; border-radius: 4px; }
.ts-cust-summary h4 { margin: 0 0 10px 0; }
.ts-cust-summary table { width: 100%; border-collapse: collapse; }
.ts-cust-summary table th { background: #6c757d; color: #fff; padding: 6px 10px; text-align: left; font-size: 12px; }
.ts-cust-summary table td { padding: 6px 10px; border-bottom: 1px solid #ddd; font-size: 13px; }
.ts-toggle-detail { font-size: 12px; cursor: pointer; color: #4a90d9; text-decoration: underline; margin-left: 15px; }
@media (max-width: 600px) {
    .ts-table { font-size: 12px; }
    .ts-table th, .ts-table td { padding: 4px 5px; }
}
</style>

<div class="ts-container">
    <div class="ts-tabs">
        <a href="<?= base_url() ?>timesheet">Clock In/Out</a>
        <a href="<?= base_url() ?>timesheet/weekly">Weekly</a>
        <a href="<?= base_url() ?>timesheet/monthly" class="active">Monthly</a>
        <?php if ($is_admin) { ?>
        <a href="<?= base_url() ?>timesheet/admin_view">Admin</a>
        <a href="<?= base_url() ?>timesheet/group_admin">Groups</a>
        <?php } ?>
    </div>

    <?php if ($is_admin && !empty($groups)) { ?>
    <div style="margin-bottom:8px;">
        <strong style="color:#7b2d8e;">Group:</strong>
        <a href="<?= base_url() ?>timesheet/monthly/<?= $year ?>/<?= $month ?>?group_id=0" style="display:inline-block; padding:3px 10px; border-radius:12px; font-size:12px; text-decoration:none; margin:0 2px; <?= ($group_filter == 0) ? 'background:#7b2d8e; color:#fff;' : 'background:#f0e6f6; color:#7b2d8e;' ?>">No Group</a>
        <?php foreach ($groups as $g) { ?>
        <a href="<?= base_url() ?>timesheet/monthly/<?= $year ?>/<?= $month ?>?group_id=<?= intval($g['id']) ?>" style="display:inline-block; padding:3px 10px; border-radius:12px; font-size:12px; text-decoration:none; margin:0 2px; <?= ($group_filter == $g['id']) ? 'background:#7b2d8e; color:#fff;' : 'background:#f0e6f6; color:#7b2d8e;' ?>"><?= htmlspecialchars($g['group_name']) ?> (<?= intval($g['member_count']) ?>)</a>
        <?php } ?>
    </div>
    <?php } ?>

    <?php if ($is_admin) { ?>
    <div class="ts-user-select">
        <strong>Role:</strong>
        <label style="margin:0 4px; cursor:pointer;">
            <input type="checkbox" id="ts-role-all" onchange="tsRoleAllToggle(this)" <?= empty($role_filter) ? 'checked' : '' ?> /> All
        </label>
        <?php foreach ($roles as $r) { ?>
        <label style="margin:0 4px; cursor:pointer;">
            <input type="checkbox" class="ts-role-cb" value="<?= htmlspecialchars($r) ?>" onchange="tsRoleCbChange()" <?= in_array($r, $role_filter) ? 'checked' : '' ?> /> <?= ucfirst(htmlspecialchars($r)) ?>
        </label>
        <?php } ?>
        <button type="button" onclick="tsApplyRolesMonthly()" style="padding:3px 10px; cursor:pointer;">Apply</button>
        <span style="margin:0 10px;">|</span>
        <strong>Employee:</strong>
        <select id="ts-emp-select" onchange="window.location.href='<?= base_url() ?>timesheet/monthly/<?= $year ?>/<?= $month ?>?user_id='+this.value">
            <?php foreach ($employees as $emp) { ?>
            <option value="<?= $emp['id'] ?>" <?= ($emp['id'] == $view_user_id) ? 'selected' : '' ?>><?= htmlspecialchars($emp['first_name'] . ' ' . $emp['last_name']) ?></option>
            <?php } ?>
        </select>
    </div>
    <?php } ?>

    <h3>
        <?= htmlspecialchars($view_user_name) ?> - <?= $month_name ?> <?= $year ?>
        <span class="ts-toggle-detail" onclick="tsToggleDetail()">[Show/Hide Detail]</span>
    </h3>

    <div class="ts-nav">
        <a href="<?= base_url() ?>timesheet/monthly/<?= $prev_month ?><?= ($is_admin && $view_user_id != $user_id) ? '?user_id=' . $view_user_id : '' ?>">&laquo; Previous Month</a>
        |
        <a href="<?= base_url() ?>timesheet/monthly<?= ($is_admin && $view_user_id != $user_id) ? '?user_id=' . $view_user_id : '' ?>">Current Month</a>
        |
        <a href="<?= base_url() ?>timesheet/monthly/<?= $next_month ?><?= ($is_admin && $view_user_id != $user_id) ? '?user_id=' . $view_user_id : '' ?>">Next Month &raquo;</a>
    </div>

    <table class="ts-table">
        <tr>
            <th>Day</th>
            <th>Date</th>
            <th>Clock In</th>
            <th>Clock Out</th>
            <th>Hours</th>
            <th>Job</th>
        </tr>
        <?php foreach ($days as $day) {
            $is_weekend = $day['is_weekend'];
            $row_class = $is_weekend ? ' class="weekend"' : '';
            $wk_class = $is_weekend ? ' weekend' : '';
            $is_ot = ($day['total_minutes'] > $ot_daily);
            $has_entries = (count($day['entries']) > 0);

            if ($has_entries) {
                // Individual entry rows (hidden by default, toggled by Show/Hide)
                foreach ($day['entries'] as $idx => $entry) {
                    $net = intval($entry['duration_minutes']) - intval($entry['break_minutes']);
                    echo '<tr class="ts-entry-row' . $wk_class . '" style="display:none;">';
                    if ($idx == 0) {
                        echo '<td>' . $day['day_name'] . '</td>';
                        echo '<td>' . date('M j', strtotime($day['date'])) . '</td>';
                    } else {
                        echo '<td></td><td></td>';
                    }
                    echo '<td>' . date('g:i A', strtotime($entry['clock_in'])) . '</td>';
                    echo '<td>' . ($entry['clock_out'] ? date('g:i A', strtotime($entry['clock_out'])) : '<em>Active</em>') . '</td>';
                    echo '<td>' . ($entry['clock_out'] ? floor($net / 60) . 'h ' . ($net % 60) . 'm' : '-') . '</td>';
                    echo '<td>';
                    if (!empty($entry['customer_id'])) {
                        echo htmlspecialchars(trim($entry['customer_name']));
                    } else {
                        echo '<span style="color:#999;">-</span>';
                    }
                    echo '</td>';
                    echo '</tr>';
                }

                // Day summary row (always visible)
                echo '<tr class="day-total ts-summary-row' . $wk_class . '">';
                echo '<td><strong>' . $day['day_name'] . '</strong></td>';
                echo '<td>' . date('M j', strtotime($day['date'])) . '</td>';

                $entry_count = count($day['entries']);
                $cust_count = 0;
                $day_custs = array();
                foreach ($day['entries'] as $ent) {
                    if (!empty($ent['customer_id']) && !in_array($ent['customer_id'], $day_custs)) {
                        $day_custs[] = $ent['customer_id'];
                        $cust_count++;
                    }
                }
                echo '<td colspan="2" style="font-size:12px; color:#666;">' . $entry_count . ' entr' . ($entry_count == 1 ? 'y' : 'ies') . '</td>';

                $ot_cls = $is_ot ? ' class="overtime"' : '';
                echo '<td' . $ot_cls . '><strong>' . floor($day['total_minutes'] / 60) . 'h ' . ($day['total_minutes'] % 60) . 'm</strong>';
                if ($is_ot) echo ' (OT)';
                echo '</td>';

                // Jobs column in summary
                echo '<td style="font-size:12px;">';
                if ($cust_count > 0) {
                    $cust_labels = array();
                    foreach ($day['entries'] as $ent) {
                        if (!empty($ent['customer_id']) && !isset($cust_labels[$ent['customer_id']])) {
                            $label = htmlspecialchars(trim($ent['customer_name']));
                            if (!empty($ent['customer_address'])) {
                                $label .= ' <small style="color:#666;">' . htmlspecialchars(trim($ent['customer_address'])) . '</small>';
                            }
                            $cust_labels[$ent['customer_id']] = $label;
                        }
                    }
                    echo implode(', ', $cust_labels);
                } else {
                    echo '<span style="color:#999;">-</span>';
                }
                echo '</td>';

                echo '</tr>';
            } else {
                echo '<tr class="ts-summary-row' . $row_class . '">';
                echo '<td>' . $day['day_name'] . '</td>';
                echo '<td>' . date('M j', strtotime($day['date'])) . '</td>';
                echo '<td colspan="4" style="color:#999;">-</td>';
                echo '</tr>';
            }
        } ?>
    </table>

    <div class="ts-grand-total">
        Monthly Total: <?= floor($grand_total / 60) ?>h <?= $grand_total % 60 ?>m
        (<?= round($grand_total / 60, 2) ?> hours)
    </div>

    <?php if (count($customer_totals) > 0) { ?>
    <div class="ts-cust-summary">
        <h4>Time by Job - <?= $month_name ?> <?= $year ?></h4>
        <table>
            <tr>
                <th>Job</th>
                <th>Total Hours</th>
            </tr>
            <?php
            $general_minutes = $grand_total;
            foreach ($customer_totals as $ct) {
                $general_minutes -= $ct['minutes'];
                echo '<tr>';
                $job_label = htmlspecialchars($ct['customer_name']);
                if (!empty($ct['customer_address'])) {
                    $job_label .= ' <small style="color:#666;">' . htmlspecialchars(trim($ct['customer_address'])) . '</small>';
                }
                echo '<td>' . $job_label . '</td>';
                echo '<td>' . floor($ct['minutes'] / 60) . 'h ' . ($ct['minutes'] % 60) . 'm (' . round($ct['minutes'] / 60, 2) . ' hrs)</td>';
                echo '</tr>';
            }
            if ($general_minutes > 0) {
                echo '<tr>';
                echo '<td><em>General (no job)</em></td>';
                echo '<td>' . floor($general_minutes / 60) . 'h ' . ($general_minutes % 60) . 'm (' . round($general_minutes / 60, 2) . ' hrs)</td>';
                echo '</tr>';
            }
            ?>
        </table>
    </div>
    <?php } ?>
</div>

<script>
function tsRoleAllToggle(el) {
    if (el.checked) {
        var cbs = document.querySelectorAll('.ts-role-cb');
        for (var i = 0; i < cbs.length; i++) cbs[i].checked = false;
    }
}
function tsRoleCbChange() {
    var cbs = document.querySelectorAll('.ts-role-cb');
    var anyChecked = false;
    for (var i = 0; i < cbs.length; i++) { if (cbs[i].checked) anyChecked = true; }
    document.getElementById('ts-role-all').checked = !anyChecked;
}
function tsApplyRolesMonthly() {
    var allEl = document.getElementById('ts-role-all');
    var url = '<?= base_url() ?>timesheet/monthly/<?= $year ?>/<?= $month ?>';
    if (allEl && allEl.checked) {
        url += '?roles=all';
    } else {
        var cbs = document.querySelectorAll('.ts-role-cb');
        var selected = [];
        for (var i = 0; i < cbs.length; i++) {
            if (cbs[i].checked) selected.push(cbs[i].value);
        }
        url += '?roles=' + (selected.length > 0 ? encodeURIComponent(selected.join(',')) : 'all');
    }
    window.location.href = url;
}

var tsDetailVisible = false;
function tsToggleDetail() {
    tsDetailVisible = !tsDetailVisible;
    var rows = document.querySelectorAll('.ts-entry-row');
    for (var i = 0; i < rows.length; i++) {
        rows[i].style.display = tsDetailVisible ? '' : 'none';
    }
}
</script>
