<style>
.ts-container { max-width: 960px; margin: 0 auto; padding: 10px; }
.ts-tabs { margin-bottom: 15px; }
.ts-tabs a { display: inline-block; padding: 8px 16px; margin-right: 5px; background: #e0e0e0; color: #333; text-decoration: none; border-radius: 4px 4px 0 0; }
.ts-tabs a.active { background: #4a90d9; color: #fff; }
.ts-tabs a:hover { background: #4a90d9; color: #fff; }
.ts-clock-section { text-align: center; padding: 20px 0; }
.ts-clock-btn {
    display: inline-block; width: 200px; height: 200px; border-radius: 50%;
    font-size: 24px; font-weight: bold; color: #fff; border: none; cursor: pointer;
    line-height: 200px; text-align: center; transition: all 0.3s;
    box-shadow: 0 4px 12px rgba(0,0,0,0.2);
}
.ts-clock-btn.clock-in { background: #27ae60; }
.ts-clock-btn.clock-in:hover { background: #219a52; }
.ts-clock-btn.clock-out { background: #e74c3c; }
.ts-clock-btn.clock-out:hover { background: #c0392b; }
.ts-clock-btn:disabled { background: #999; cursor: not-allowed; }
.ts-status { font-size: 16px; margin: 10px 0; color: #555; }
.ts-today-total { font-size: 18px; font-weight: bold; color: #333; margin: 5px 0 20px; }
.ts-msg { padding: 10px; margin: 10px 0; border-radius: 4px; display: none; }
.ts-msg.success { background: #d4edda; color: #155724; }
.ts-msg.error { background: #f8d7da; color: #721c24; }
.ts-cust-input { margin: 10px auto; max-width: 400px; text-align: left; }
.ts-cust-input label { font-weight: bold; font-size: 14px; display: block; margin-bottom: 4px; }
.ts-cust-input input { width: 220px; padding: 6px; font-size: 14px; border: 1px solid #ccc; border-radius: 3px; }
.ts-cust-input button { padding: 6px 12px; font-size: 13px; cursor: pointer; background: #6c757d; color: #fff; border: none; border-radius: 3px; }
.ts-cust-input button:hover { background: #5a6268; }
.ts-cust-input .ts-cust-info { font-size: 12px; color: #155724; margin-top: 3px; min-height: 16px; }
.ts-cust-results { max-height: 150px; overflow-y: auto; border: 1px solid #ddd; background: #fff; margin-top: 3px; display: none; }
.ts-cust-results div { padding: 5px 8px; cursor: pointer; border-bottom: 1px solid #eee; font-size: 12px; }
.ts-cust-results div:hover { background: #e8f0fe; }
.ts-table { width: 100%; border-collapse: collapse; margin-top: 10px; }
.ts-table th { background: #4a90d9; color: #fff; padding: 8px 10px; text-align: left; font-size: 13px; }
.ts-table td { padding: 8px 10px; border-bottom: 1px solid #ddd; font-size: 13px; }
.ts-table tr:hover { background: #f5f5f5; }
.ts-table .weekend { background: #f9f0f0; }
.ts-week-total { font-size: 16px; font-weight: bold; text-align: right; margin-top: 10px; }
.ts-elapsed { font-size: 20px; font-weight: bold; color: #e74c3c; margin: 5px 0; }
@media (max-width: 600px) {
    .ts-clock-btn { width: 150px; height: 150px; font-size: 20px; line-height: 150px; }
    .ts-table { font-size: 12px; }
    .ts-table th, .ts-table td { padding: 5px; }
    .ts-cust-input { max-width: 100%; padding: 0 10px; }
}
</style>

<div class="ts-container">
    <div class="ts-tabs">
        <a href="<?= base_url() ?>timesheet" class="active">Clock In/Out</a>
        <a href="<?= base_url() ?>timesheet/weekly">Weekly</a>
        <a href="<?= base_url() ?>timesheet/monthly">Monthly</a>
        <?php if ($is_admin) { ?>
        <a href="<?= base_url() ?>timesheet/admin_view">Admin</a>
        <a href="<?= base_url() ?>timesheet/group_admin">Groups</a>
        <?php } ?>
    </div>

    <div class="ts-clock-section">
        <div id="ts-msg" class="ts-msg"></div>

        <?php if ($active_entry) { ?>
            <button id="ts-clock-btn" class="ts-clock-btn clock-out" onclick="tsClockOut()">CLOCK OUT</button>
            <div class="ts-elapsed" id="ts-elapsed"></div>
            <div class="ts-status">
                Clocked in since <strong id="ts-clock-time"><?= date('g:i A', strtotime($active_entry['clock_in'])) ?></strong>
                <?php if (!empty($active_entry['customer_id'])) { ?>
                    <br/>Customer: <?= htmlspecialchars(trim($active_entry['customer_name'])) ?>
                    <?php if (!empty($active_entry['customer_address'])) { ?>
                        - <?= htmlspecialchars(trim($active_entry['customer_address'])) ?>
                    <?php } ?>
                <?php } ?>
            </div>
            <script>
            (function() {
                var clockInTs = <?= strtotime($active_entry['clock_in']) ?>;
                function updateElapsed() {
                    var now = Math.floor(Date.now() / 1000);
                    var diff = now - clockInTs;
                    if (diff < 0) diff = 0;
                    var h = Math.floor(diff / 3600);
                    var m = Math.floor((diff % 3600) / 60);
                    var s = diff % 60;
                    var el = document.getElementById('ts-elapsed');
                    if (el) el.textContent = h + 'h ' + (m < 10 ? '0' : '') + m + 'm ' + (s < 10 ? '0' : '') + s + 's';
                }
                updateElapsed();
                setInterval(updateElapsed, 1000);
            })();
            </script>
        <?php } else { ?>
            <div class="ts-cust-input" id="ts-cust-section">
                <label>Customer <span style="font-weight:normal; color:#888;">(optional)</span></label>
                <input type="hidden" id="ts-clock-customer-id" value="" />
                <input type="text" id="ts-clock-customer-search" placeholder="Search by name or address..." autocomplete="off" />
                <button type="button" onclick="tsClockSearchCustomer()">Search</button>
                <div class="ts-cust-results" id="ts-clock-cust-results"></div>
                <div class="ts-cust-info" id="ts-clock-cust-info"></div>
            </div>
            <button id="ts-clock-btn" class="ts-clock-btn clock-in" onclick="tsClockIn()">CLOCK IN</button>
            <div class="ts-status" id="ts-status-text">Ready to clock in</div>
        <?php } ?>

        <div class="ts-today-total">Today: <span id="ts-today-total"><?= isset($today_total) ? floor($today_total / 60) . 'h ' . ($today_total % 60) . 'm' : '0h 0m' ?></span></div>
    </div>

    <h3>This Week (<?= date('M j', strtotime($week_start)) ?> - <?= date('M j, Y', strtotime($week_end)) ?>)</h3>
    <table class="ts-table">
        <tr>
            <th>Day</th>
            <th>Date</th>
            <th>Clock In</th>
            <th>Clock Out</th>
            <th>Hours</th>
            <th>Job</th>
        </tr>
        <?php
        $days_map = array();
        foreach ($week_entries as $entry) {
            $d = date('Y-m-d', strtotime($entry['clock_in']));
            if (!isset($days_map[$d])) $days_map[$d] = array();
            $days_map[$d][] = $entry;
        }

        for ($i = 0; $i < 7; $i++) {
            $day_date = date('Y-m-d', strtotime("+$i days", strtotime($week_start)));
            $day_name = date('l', strtotime($day_date));
            $is_weekend = (date('N', strtotime($day_date)) >= 6);
            $row_class = $is_weekend ? ' class="weekend"' : '';

            if (isset($days_map[$day_date]) && count($days_map[$day_date]) > 0) {
                $first = true;
                foreach ($days_map[$day_date] as $entry) {
                    $net = intval($entry['duration_minutes']) - intval($entry['break_minutes']);
                    echo '<tr' . $row_class . '>';
                    if ($first) {
                        echo '<td>' . $day_name . '</td>';
                        echo '<td>' . date('M j', strtotime($day_date)) . '</td>';
                        $first = false;
                    } else {
                        echo '<td></td><td></td>';
                    }
                    echo '<td>' . date('g:i A', strtotime($entry['clock_in'])) . '</td>';
                    echo '<td>' . ($entry['clock_out'] ? date('g:i A', strtotime($entry['clock_out'])) : '<em>Active</em>') . '</td>';
                    echo '<td>' . ($entry['clock_out'] ? floor($net / 60) . 'h ' . ($net % 60) . 'm' : '-') . '</td>';
                    echo '<td>';
                    if (!empty($entry['customer_id'])) {
                        echo htmlspecialchars(trim($entry['customer_name']));
                    } else {
                        echo '<span style="color:#999;">-</span>';
                    }
                    echo '</td>';
                    echo '</tr>';
                }
            } else {
                echo '<tr' . $row_class . '>';
                echo '<td>' . $day_name . '</td>';
                echo '<td>' . date('M j', strtotime($day_date)) . '</td>';
                echo '<td colspan="4" style="color:#999;">-</td>';
                echo '</tr>';
            }
        }
        ?>
    </table>
    <div class="ts-week-total">Week Total: <?= floor($week_total / 60) ?>h <?= $week_total % 60 ?>m</div>
</div>

<script>
function tsEscHtml(str) {
    if (!str) return '';
    var div = document.createElement('div');
    div.appendChild(document.createTextNode(str));
    return div.innerHTML;
}

var tsClockSearchTimer = null;

$(document).on('keyup', '#ts-clock-customer-search', function() {
    clearTimeout(tsClockSearchTimer);
    tsClockSearchTimer = setTimeout(function() { tsClockSearchCustomer(); }, 300);
});

function tsClockSearchCustomer() {
    var q = $.trim($('#ts-clock-customer-search').val());
    if (q.length < 2) {
        $('#ts-clock-cust-results').hide();
        return;
    }
    $.ajax({
        type: "POST",
        url: "<?= base_url() ?>timesheet/search_customers",
        data: { q: q },
        dataType: "json",
        success: function(json) {
            if (json.success && json.results && json.results.length > 0) {
                var $container = $('#ts-clock-cust-results').empty();
                for (var i = 0; i < json.results.length; i++) {
                    (function(r) {
                        var $row = $('<div></div>');
                        $row.attr('data-id', r.id).attr('data-name', r.name).attr('data-address', r.address || '');
                        var $name = $('<strong></strong>').text(r.name);
                        $row.append($name);
                        if (r.address) {
                            $row.append(' ');
                            var $addr = $('<span style="color:#666;"></span>').text('- ' + r.address);
                            $row.append($addr);
                        }
                        $row.on('click', function() {
                            tsClockSelectCustomer(r.id, r.name, r.address || '');
                        });
                        $container.append($row);
                    })(json.results[i]);
                }
                $container.show();
            } else {
                $('#ts-clock-cust-results').empty().append($('<div style="color:#999;"></div>').text('No customers found')).show();
            }
        }
    });
}

function tsClockSelectCustomer(id, name, address) {
    $('#ts-clock-customer-id').val(id);
    $('#ts-clock-customer-search').val(name);
    var $info = $('#ts-clock-cust-info').empty();
    var $span = $('<span style="color:#155724;"></span>').text(name + (address ? ' - ' + address : ''));
    var $clear = $('<a href="javascript:void(0)" style="color:#e74c3c; font-size:11px; margin-left:5px;"></a>').text('[clear]');
    $clear.on('click', function() { tsClockClearCustomer(); });
    $info.append($span).append(' ').append($clear);
    $('#ts-clock-cust-results').hide();
}

function tsClockClearCustomer() {
    $('#ts-clock-customer-id').val('');
    $('#ts-clock-customer-search').val('');
    $('#ts-clock-cust-info').empty();
}

function tsClockIn() {
    var btn = document.getElementById('ts-clock-btn');
    btn.disabled = true;
    var customerId = $.trim($('#ts-clock-customer-id').val());
    var postData = {};
    if (customerId) postData.customer_id = customerId;

    $.ajax({
        type: "POST",
        url: "<?= base_url() ?>timesheet/clock_in",
        data: postData,
        dataType: "json",
        success: function(json) {
            if (json.success) {
                tsShowMsg(json.message, 'success');
                setTimeout(function() { location.reload(); }, 1200);
            } else {
                tsShowMsg(json.message, 'error');
                btn.disabled = false;
            }
        },
        error: function() {
            tsShowMsg('Connection error. Please try again.', 'error');
            btn.disabled = false;
        }
    });
}

function tsClockOut() {
    var btn = document.getElementById('ts-clock-btn');
    btn.disabled = true;
    $.ajax({
        type: "POST",
        url: "<?= base_url() ?>timesheet/clock_out",
        dataType: "json",
        success: function(json) {
            if (json.success) {
                tsShowMsg(json.message + ' (' + json.duration + ')', 'success');
                setTimeout(function() { location.reload(); }, 1200);
            } else {
                tsShowMsg(json.message, 'error');
                btn.disabled = false;
            }
        },
        error: function() {
            tsShowMsg('Connection error. Please try again.', 'error');
            btn.disabled = false;
        }
    });
}

function tsShowMsg(msg, type) {
    var el = document.getElementById('ts-msg');
    el.className = 'ts-msg ' + type;
    el.textContent = msg;
    el.style.display = 'block';
    setTimeout(function() { el.style.display = 'none'; }, 4000);
}
</script>
