<style>
.ts-container { max-width: 960px; margin: 0 auto; padding: 10px; }
.ts-tabs { margin-bottom: 15px; }
.ts-tabs a { display: inline-block; padding: 8px 16px; margin-right: 5px; background: #e0e0e0; color: #333; text-decoration: none; border-radius: 4px 4px 0 0; }
.ts-tabs a.active { background: #7b2d8e; color: #fff; }
.ts-tabs a:hover { background: #4a90d9; color: #fff; }
.ts-table { width: 100%; border-collapse: collapse; margin-top: 10px; }
.ts-table th { background: #7b2d8e; color: #fff; padding: 8px 10px; text-align: left; font-size: 13px; }
.ts-table td { padding: 8px 10px; border-bottom: 1px solid #ddd; font-size: 13px; }
.ts-table tr:hover { background: #f5f5f5; }
.ts-add-btn { padding: 6px 16px; background: #7b2d8e; color: #fff; border: none; cursor: pointer; border-radius: 3px; text-decoration: none; display: inline-block; margin-bottom: 10px; }
.ts-add-btn:hover { background: #5e1f6d; color: #fff; }
.ts-dual-list { display: table; width: 100%; border-spacing: 8px 0; }
.ts-dual-col { display: table-cell; width: 44%; vertical-align: top; }
.ts-dual-mid { display: table-cell; width: 12%; vertical-align: middle; text-align: center; }
.ts-dual-col h4 { margin: 0 0 6px 0; font-size: 13px; color: #333; }
.ts-dual-col select { width: 100%; height: 280px; font-size: 12px; border: 1px solid #ccc; border-radius: 3px; padding: 2px; }
.ts-dual-mid button { display: block; margin: 4px auto; padding: 5px 12px; cursor: pointer; background: #7b2d8e; color: #fff; border: none; border-radius: 3px; font-size: 14px; min-width: 40px; }
.ts-dual-mid button:hover { background: #5e1f6d; }
.ts-dual-search { width: 100%; padding: 4px 6px; margin-bottom: 4px; font-size: 12px; border: 1px solid #ccc; border-radius: 3px; box-sizing: border-box; }
</style>

<div class="ts-container">
    <div class="ts-tabs">
        <a href="<?= base_url() ?>timesheet">Clock In/Out</a>
        <a href="<?= base_url() ?>timesheet/weekly">Weekly</a>
        <a href="<?= base_url() ?>timesheet/monthly">Monthly</a>
        <a href="<?= base_url() ?>timesheet/admin_view">Admin</a>
        <a href="<?= base_url() ?>timesheet/group_admin" class="active">Groups</a>
    </div>

    <h3>Manage Timesheet Groups</h3>

    <button type="button" class="ts-add-btn" onclick="tsShowGroupForm(0,'','')">+ Create Group</button>

    <table class="ts-table">
        <thead>
            <tr>
                <th>Group Name</th>
                <th>Description</th>
                <th>Members</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php if (empty($groups)) { ?>
            <tr><td colspan="4" style="color:#999; text-align:center;">No groups yet. Create one to get started.</td></tr>
        <?php } else { foreach ($groups as $g) { ?>
            <tr>
                <td><strong><?= htmlspecialchars($g['group_name']) ?></strong></td>
                <td><?= htmlspecialchars($g['description']) ?></td>
                <td><?= intval($g['member_count']) ?></td>
                <td>
                    <a href="javascript:void(0)" class="ts-group-edit" data-id="<?= intval($g['id']) ?>" data-name="<?= htmlspecialchars($g['group_name'], ENT_QUOTES) ?>" data-desc="<?= htmlspecialchars($g['description'], ENT_QUOTES) ?>">Edit</a> |
                    <a href="javascript:void(0)" class="ts-group-members" data-id="<?= intval($g['id']) ?>" data-name="<?= htmlspecialchars($g['group_name'], ENT_QUOTES) ?>">Members</a> |
                    <a href="javascript:void(0)" class="ts-group-delete" data-id="<?= intval($g['id']) ?>" style="color:#e74c3c;">Delete</a>
                </td>
            </tr>
        <?php } } ?>
        </tbody>
    </table>
</div>

<script>
var tsAllEmployees = <?= json_encode(array_map(function($emp) {
    return array(
        'id' => intval($emp['id']),
        'name' => htmlspecialchars($emp['first_name'] . ' ' . $emp['last_name']),
        'role' => htmlspecialchars($emp['role'])
    );
}, $all_employees)) ?>;

function tsEscHtml(str) {
    if (!str) return '';
    var div = document.createElement('div');
    div.appendChild(document.createTextNode(str));
    return div.innerHTML;
}

// Delegated click handlers for group actions
$(document).on('click', '.ts-group-edit', function() {
    var $el = $(this);
    tsShowGroupForm($el.data('id'), $el.data('name'), $el.data('desc'));
});
$(document).on('click', '.ts-group-members', function() {
    var $el = $(this);
    tsManageMembers($el.data('id'), $el.data('name'));
});
$(document).on('click', '.ts-group-delete', function() {
    tsDeleteGroup($(this).data('id'));
});

function tsShowGroupForm(id, name, desc) {
    var html = '<div style="padding:15px; min-width:400px;">'
        + '<h3>' + (id ? 'Edit Group' : 'Create Group') + '</h3>'
        + '<input type="hidden" id="ts-gf-id" value="' + id + '" />'
        + '<table style="width:100%;">'
        + '<tr><td style="padding:5px;"><strong>Name:</strong></td>'
        + '<td style="padding:5px;"><input type="text" id="ts-gf-name" value="' + tsEscHtml(name) + '" style="width:100%; padding:5px;" /></td></tr>'
        + '<tr><td style="padding:5px;"><strong>Description:</strong></td>'
        + '<td style="padding:5px;"><input type="text" id="ts-gf-desc" value="' + tsEscHtml(desc) + '" style="width:100%; padding:5px;" /></td></tr>'
        + '</table>'
        + '<div id="ts-gf-msg" style="padding:5px; margin:5px 0; display:none;"></div>'
        + '<div style="text-align:right; margin-top:10px;">'
        + '<button type="button" id="ts-gf-save-btn" onclick="tsSaveGroup()" style="padding:8px 20px; background:#7b2d8e; color:#fff; border:none; cursor:pointer; border-radius:3px;">Save</button>'
        + '</div></div>';
    $.facebox(html);
}

function tsSaveGroup() {
    var btn = document.getElementById('ts-gf-save-btn');
    if (btn.disabled) return;

    var gid = $('#ts-gf-id').val();
    var name = $.trim($('#ts-gf-name').val());
    if (!name) {
        $('#ts-gf-msg').css({background:'#f8d7da',color:'#721c24'}).text('Name is required.').show();
        return;
    }

    btn.disabled = true;
    btn.textContent = 'Saving...';

    $.ajax({
        type: 'POST',
        url: '<?= base_url() ?>timesheet/save_group',
        data: { group_id: gid, group_name: name, description: $.trim($('#ts-gf-desc').val()) },
        dataType: 'json',
        success: function(json) {
            if (json.success) {
                $('#ts-gf-msg').css({background:'#d4edda',color:'#155724'}).text(json.message).show();
                setTimeout(function() { location.reload(); }, 800);
            } else {
                $('#ts-gf-msg').css({background:'#f8d7da',color:'#721c24'}).text(json.message).show();
                btn.disabled = false;
                btn.textContent = 'Save';
            }
        },
        error: function() {
            $('#ts-gf-msg').css({background:'#f8d7da',color:'#721c24'}).text('Connection error.').show();
            btn.disabled = false;
            btn.textContent = 'Save';
        }
    });
}

function tsDeleteGroup(gid) {
    if (!confirm('Delete this group? This cannot be undone.')) return;
    $.ajax({
        type: 'POST',
        url: '<?= base_url() ?>timesheet/delete_group',
        data: { group_id: gid },
        dataType: 'json',
        success: function(json) {
            if (json.success) {
                location.reload();
            } else {
                alert(json.message);
            }
        }
    });
}

function tsManageMembers(gid, groupName) {
    // Build dual-list HTML
    var html = '<div style="padding:15px; min-width:600px;">'
        + '<h3>Members: ' + tsEscHtml(groupName) + '</h3>'
        + '<input type="hidden" id="ts-mm-gid" value="' + gid + '" />'
        + '<div class="ts-dual-list">'
        + '<div class="ts-dual-col">'
        + '<h4>Available Employees</h4>'
        + '<input type="text" class="ts-dual-search" id="ts-avail-search" placeholder="Search..." onkeyup="tsFilterAvail()" />'
        + '<select id="ts-avail-list" multiple size="14"></select>'
        + '</div>'
        + '<div class="ts-dual-mid">'
        + '<button type="button" onclick="tsMoveToGroup()" title="Add to group">&raquo;</button>'
        + '<button type="button" onclick="tsMoveFromGroup()" title="Remove from group">&laquo;</button>'
        + '<br/><br/>'
        + '<button type="button" onclick="tsMoveAllToGroup()" title="Add all" style="font-size:11px;">All &raquo;</button>'
        + '<button type="button" onclick="tsMoveAllFromGroup()" title="Remove all" style="font-size:11px;">&laquo; All</button>'
        + '</div>'
        + '<div class="ts-dual-col">'
        + '<h4>Group Members</h4>'
        + '<input type="text" class="ts-dual-search" id="ts-member-search" placeholder="Search..." onkeyup="tsFilterMembers()" />'
        + '<select id="ts-member-list" multiple size="14"></select>'
        + '</div>'
        + '</div>'
        + '<div id="ts-mm-msg" style="padding:5px; margin:8px 0 0 0; display:none;"></div>'
        + '<div style="text-align:right; margin-top:10px;">'
        + '<button type="button" id="ts-mm-save-btn" onclick="tsSaveMembers()" style="padding:8px 20px; background:#7b2d8e; color:#fff; border:none; cursor:pointer; border-radius:3px;">Save Members</button>'
        + '<button type="button" onclick="$.facebox.close()" style="padding:8px 20px; background:#999; color:#fff; border:none; cursor:pointer; border-radius:3px; margin-left:6px;">Cancel</button>'
        + '</div></div>';

    $.facebox(html);

    // Fetch current members, then populate both lists
    $.ajax({
        type: 'POST',
        url: '<?= base_url() ?>timesheet/get_group_members',
        data: { group_id: gid },
        dataType: 'json',
        success: function(json) {
            var memberIds = (json.success && json.member_ids) ? json.member_ids : [];
            tsPopulateDualList(memberIds);
        },
        error: function() {
            tsPopulateDualList([]);
        }
    });
}

function tsPopulateDualList(memberIds) {
    var $avail = $('#ts-avail-list').empty();
    var $member = $('#ts-member-list').empty();
    for (var i = 0; i < tsAllEmployees.length; i++) {
        var e = tsAllEmployees[i];
        var isMember = false;
        for (var j = 0; j < memberIds.length; j++) {
            if (memberIds[j] == e.id) { isMember = true; break; }
        }
        var $opt = $('<option></option>').val(e.id).text(e.name + ' (' + e.role + ')');
        if (isMember) {
            $member.append($opt);
        } else {
            $avail.append($opt);
        }
    }
}

function tsMoveToGroup() {
    $('#ts-avail-list option:selected').each(function() {
        $(this).remove().appendTo('#ts-member-list');
    });
}

function tsMoveFromGroup() {
    $('#ts-member-list option:selected').each(function() {
        $(this).remove().appendTo('#ts-avail-list');
    });
}

function tsMoveAllToGroup() {
    // Move only visible (not filtered out) options
    $('#ts-avail-list option').each(function() {
        if (this.style.display !== 'none') {
            $(this).remove().appendTo('#ts-member-list');
        }
    });
    $('#ts-avail-search').val('');
}

function tsMoveAllFromGroup() {
    $('#ts-member-list option').each(function() {
        if (this.style.display !== 'none') {
            $(this).remove().appendTo('#ts-avail-list');
        }
    });
    $('#ts-member-search').val('');
}

function tsFilterAvail() {
    var q = $.trim($('#ts-avail-search').val()).toLowerCase();
    $('#ts-avail-list option').each(function() {
        var text = $(this).text().toLowerCase();
        this.style.display = (q === '' || text.indexOf(q) >= 0) ? '' : 'none';
    });
}

function tsFilterMembers() {
    var q = $.trim($('#ts-member-search').val()).toLowerCase();
    $('#ts-member-list option').each(function() {
        var text = $(this).text().toLowerCase();
        this.style.display = (q === '' || text.indexOf(q) >= 0) ? '' : 'none';
    });
}

function tsSaveMembers() {
    var btn = document.getElementById('ts-mm-save-btn');
    if (btn.disabled) return;
    btn.disabled = true;
    btn.textContent = 'Saving...';

    var gid = $('#ts-mm-gid').val();
    var selected = [];
    $('#ts-member-list option').each(function() {
        selected.push(this.value);
    });
    $.ajax({
        type: 'POST',
        url: '<?= base_url() ?>timesheet/save_group_members',
        data: { group_id: gid, user_ids: selected.join(',') },
        dataType: 'json',
        success: function(json) {
            if (json.success) {
                $('#ts-mm-msg').css({background:'#d4edda',color:'#155724'}).text(json.message).show();
                setTimeout(function() { location.reload(); }, 800);
            } else {
                $('#ts-mm-msg').css({background:'#f8d7da',color:'#721c24'}).text(json.message).show();
                btn.disabled = false;
                btn.textContent = 'Save Members';
            }
        },
        error: function() {
            $('#ts-mm-msg').css({background:'#f8d7da',color:'#721c24'}).text('Connection error.').show();
            btn.disabled = false;
            btn.textContent = 'Save Members';
        }
    });
}
</script>
