<div style="padding: 15px; min-width: 400px;">
    <h3 id="ts-form-title">Add Time Entry</h3>
    <input type="hidden" id="ts-entry-id" value="" />
    <input type="hidden" id="ts-form-customer-id" value="" />
    <table style="width:100%;">
        <tr>
            <td style="padding: 5px;"><strong>Employee:</strong></td>
            <td style="padding: 5px;">
                <select id="ts-form-user" style="width:100%; padding:5px;">
                    <?php if (isset($employees)) { foreach ($employees as $emp) { ?>
                    <option value="<?= $emp['id'] ?>"><?= htmlspecialchars($emp['first_name'] . ' ' . $emp['last_name']) ?></option>
                    <?php } } ?>
                </select>
            </td>
        </tr>
        <tr>
            <td style="padding: 5px;"><strong>Job:</strong></td>
            <td style="padding: 5px;">
                <input type="text" id="ts-form-customer-search" placeholder="Search by name or address..." style="width:70%; padding:5px;" autocomplete="off" />
                <button type="button" onclick="tsSearchCustomer()" style="padding:5px 10px; cursor:pointer;">Search</button>
                <div id="ts-customer-results" style="max-height:150px; overflow-y:auto; border:1px solid #ddd; display:none; margin-top:3px; background:#fff;"></div>
                <div id="ts-customer-selected" style="font-size:12px; color:#155724; margin-top:3px;"></div>
            </td>
        </tr>
        <tr>
            <td style="padding: 5px;"><strong>Date:</strong></td>
            <td style="padding: 5px;"><input type="date" id="ts-form-date" value="<?= date('Y-m-d') ?>" style="width:100%; padding:5px;" /></td>
        </tr>
        <tr>
            <td style="padding: 5px;"><strong>Clock In:</strong></td>
            <td style="padding: 5px;"><input type="time" id="ts-form-clockin" value="08:00" style="width:100%; padding:5px;" /></td>
        </tr>
        <tr>
            <td style="padding: 5px;"><strong>Clock Out:</strong></td>
            <td style="padding: 5px;"><input type="time" id="ts-form-clockout" value="17:00" style="width:100%; padding:5px;" /></td>
        </tr>
        <tr>
            <td style="padding: 5px;"><strong>Break (min):</strong></td>
            <td style="padding: 5px;"><input type="number" id="ts-form-break" value="30" min="0" style="width:100%; padding:5px;" /></td>
        </tr>
        <tr>
            <td style="padding: 5px;"><strong>Notes:</strong></td>
            <td style="padding: 5px;"><textarea id="ts-form-notes" style="width:100%; padding:5px; height:60px;"></textarea></td>
        </tr>
    </table>
    <div id="ts-form-msg" style="padding:5px; margin:5px 0; display:none;"></div>
    <div style="text-align: right; margin-top: 10px;">
        <button id="ts-save-btn" onclick="tsSaveEntry()" style="padding: 8px 20px; background: #4a90d9; color: #fff; border: none; cursor: pointer; border-radius: 3px;">Save</button>
        <button onclick="tsDeleteEntry()" id="ts-delete-btn" style="padding: 8px 20px; background: #e74c3c; color: #fff; border: none; cursor: pointer; border-radius: 3px; display:none;">Delete</button>
    </div>
</div>

<script>
function tsEscHtml(str) {
    if (!str) return '';
    var div = document.createElement('div');
    div.appendChild(document.createTextNode(str));
    return div.innerHTML;
}

var tsSearchTimer = null;

// Auto-search on typing (debounced)
$(document).on('keyup', '#ts-form-customer-search', function() {
    clearTimeout(tsSearchTimer);
    tsSearchTimer = setTimeout(function() { tsSearchCustomer(); }, 300);
});

function tsSearchCustomer() {
    var q = $.trim($('#ts-form-customer-search').val());
    if (q.length < 2) {
        $('#ts-customer-results').hide();
        return;
    }
    $.ajax({
        type: "POST",
        url: "<?= base_url() ?>timesheet/search_customers",
        data: { q: q },
        dataType: "json",
        success: function(json) {
            if (json.success && json.results && json.results.length > 0) {
                var $container = $('#ts-customer-results').empty();
                for (var i = 0; i < json.results.length; i++) {
                    (function(r) {
                        var $row = $('<div style="padding:5px 8px; cursor:pointer; border-bottom:1px solid #eee; font-size:12px;"></div>');
                        $row.on('mouseover', function() { $(this).css('background', '#e8f0fe'); });
                        $row.on('mouseout', function() { $(this).css('background', '#fff'); });
                        var $name = $('<strong></strong>').text(r.name);
                        $row.append($name);
                        if (r.address) {
                            $row.append(' ');
                            $row.append($('<span style="color:#666;"></span>').text('- ' + r.address));
                        }
                        if (r.city) {
                            $row.append(' ');
                            $row.append($('<span style="color:#999;"></span>').text(r.city));
                        }
                        $row.on('click', function() {
                            tsSelectCustomer(r.id, r.name, r.address || '');
                        });
                        $container.append($row);
                    })(json.results[i]);
                }
                $container.show();
            } else {
                $('#ts-customer-results').empty().append(
                    $('<div style="padding:5px 8px; color:#999; font-size:12px;"></div>').text('No customers found')
                ).show();
            }
        }
    });
}

function tsSelectCustomer(id, name, address) {
    $('#ts-form-customer-id').val(id);
    $('#ts-form-customer-search').val(name);
    var $sel = $('#ts-customer-selected').empty();
    var $span = $('<span style="color:#155724;"></span>');
    $span.append(document.createTextNode('Selected: '));
    $span.append($('<strong></strong>').text(name));
    if (address) {
        $span.append(document.createTextNode(' - ' + address));
    }
    var $clear = $('<a href="javascript:void(0)" style="color:#e74c3c; font-size:11px; margin-left:5px;"></a>').text('[clear]');
    $clear.on('click', function() { tsClearCustomer(); });
    $sel.append($span).append(' ').append($clear);
    $('#ts-customer-results').hide();
}

function tsClearCustomer() {
    $('#ts-form-customer-id').val('');
    $('#ts-form-customer-search').val('');
    $('#ts-customer-selected').empty();
}

function tsSaveEntry() {
    var saveBtn = document.getElementById('ts-save-btn');
    if (saveBtn.disabled) return;
    saveBtn.disabled = true;
    var origText = saveBtn.textContent;
    saveBtn.textContent = 'Saving...';

    var entryId = $('#ts-entry-id').val();
    var date = $('#ts-form-date').val();
    var clockIn = date + ' ' + $('#ts-form-clockin').val() + ':00';
    var clockOut = date + ' ' + $('#ts-form-clockout').val() + ':00';

    var postData = {
        user_id: $('#ts-form-user').val(),
        customer_id: $('#ts-form-customer-id').val(),
        clock_in: clockIn,
        clock_out: clockOut,
        break_minutes: $('#ts-form-break').val(),
        notes: $('#ts-form-notes').val()
    };

    var url = '<?= base_url() ?>timesheet/save_entry';
    if (entryId) {
        postData.entry_id = entryId;
        url = '<?= base_url() ?>timesheet/edit_entry';
    }

    $.ajax({
        type: "POST",
        url: url,
        data: postData,
        dataType: "json",
        success: function(json) {
            if (json.success) {
                $('#ts-form-msg').css({background:'#d4edda',color:'#155724'}).text(json.message).show();
                setTimeout(function() { location.reload(); }, 1000);
            } else {
                $('#ts-form-msg').css({background:'#f8d7da',color:'#721c24'}).text(json.message).show();
                saveBtn.disabled = false;
                saveBtn.textContent = origText;
            }
        },
        error: function() {
            $('#ts-form-msg').css({background:'#f8d7da',color:'#721c24'}).text('Connection error.').show();
            saveBtn.disabled = false;
            saveBtn.textContent = origText;
        }
    });
}

function tsDeleteEntry() {
    var entryId = $('#ts-entry-id').val();
    if (!entryId) return;
    if (!confirm('Delete this time entry?')) return;

    var delBtn = document.getElementById('ts-delete-btn');
    if (delBtn.disabled) return;
    delBtn.disabled = true;
    var origText = delBtn.textContent;
    delBtn.textContent = 'Deleting...';

    $.ajax({
        type: "POST",
        url: "<?= base_url() ?>timesheet/delete_entry",
        data: { entry_id: entryId },
        dataType: "json",
        success: function(json) {
            if (json.success) {
                $('#ts-form-msg').css({background:'#d4edda',color:'#155724'}).text(json.message).show();
                setTimeout(function() { location.reload(); }, 1000);
            } else {
                $('#ts-form-msg').css({background:'#f8d7da',color:'#721c24'}).text(json.message).show();
                delBtn.disabled = false;
                delBtn.textContent = origText;
            }
        },
        error: function() {
            $('#ts-form-msg').css({background:'#f8d7da',color:'#721c24'}).text('Connection error.').show();
            delBtn.disabled = false;
            delBtn.textContent = origText;
        }
    });
}

function tsEditEntry(entryId, userId, customerId, customerName, date, clockIn, clockOut, breakMin, notes) {
    $('#ts-form-title').text('Edit Time Entry');
    $('#ts-entry-id').val(entryId);
    $('#ts-form-user').val(userId);
    $('#ts-form-customer-id').val(customerId || '');
    $('#ts-form-customer-search').val(customerName || '');
    if (customerId && customerName) {
        var $sel = $('#ts-customer-selected').empty();
        var $span = $('<span style="color:#155724;"></span>');
        $span.append(document.createTextNode('Selected: '));
        $span.append($('<strong></strong>').text(customerName));
        var $clear = $('<a href="javascript:void(0)" style="color:#e74c3c; font-size:11px; margin-left:5px;"></a>').text('[clear]');
        $clear.on('click', function() { tsClearCustomer(); });
        $sel.append($span).append(' ').append($clear);
    } else {
        $('#ts-customer-selected').empty();
    }
    $('#ts-customer-results').hide();
    $('#ts-form-date').val(date);
    $('#ts-form-clockin').val(clockIn);
    $('#ts-form-clockout').val(clockOut);
    $('#ts-form-break').val(breakMin);
    $('#ts-form-notes').val(notes);
    $('#ts-delete-btn').show().prop('disabled', false).text('Delete');
    $('#ts-save-btn').prop('disabled', false).text('Save');
    $('#ts-form-msg').hide();
}
</script>
