<style>
.ts-container { max-width: 960px; margin: 0 auto; padding: 10px; }
.ts-tabs { margin-bottom: 15px; }
.ts-tabs a { display: inline-block; padding: 8px 16px; margin-right: 5px; background: #e0e0e0; color: #333; text-decoration: none; border-radius: 4px 4px 0 0; }
.ts-tabs a.active { background: #4a90d9; color: #fff; }
.ts-tabs a:hover { background: #4a90d9; color: #fff; }
.ts-table { width: 100%; border-collapse: collapse; margin-top: 10px; }
.ts-table th { background: #4a90d9; color: #fff; padding: 8px 10px; text-align: left; font-size: 13px; cursor: pointer; }
.ts-table th:hover { background: #357ab7; }
.ts-table th.headerSortUp:after { content: " \25B2"; font-size: 10px; }
.ts-table th.headerSortDown:after { content: " \25BC"; font-size: 10px; }
.ts-table td { padding: 8px 10px; border-bottom: 1px solid #ddd; font-size: 13px; }
.ts-table tr:hover { background: #f5f5f5; }
.ts-table thead th.header { background-image: none; }
.ts-status-badge { display: inline-block; padding: 3px 8px; border-radius: 3px; font-size: 12px; font-weight: bold; }
.ts-status-in { background: #d4edda; color: #155724; }
.ts-status-out { background: #f8d7da; color: #721c24; }
.ts-export-section { margin: 15px 0; padding: 15px; background: #f8f9fa; border: 1px solid #ddd; border-radius: 4px; }
.ts-export-section label { margin-right: 10px; font-weight: bold; }
.ts-export-section input, .ts-export-section select { padding: 5px; margin-right: 10px; }
.ts-export-btn { padding: 6px 16px; background: #27ae60; color: #fff; border: none; cursor: pointer; border-radius: 3px; }
.ts-export-btn:hover { background: #219a52; }
.ts-add-btn { padding: 6px 16px; background: #4a90d9; color: #fff; border: none; cursor: pointer; border-radius: 3px; text-decoration: none; display: inline-block; margin-bottom: 10px; }
.ts-add-btn:hover { background: #357ab7; color: #fff; }
.ts-sort-hint { font-size: 11px; color: #888; margin-bottom: 5px; }
.ts-role-filter { margin-bottom: 12px; }
.ts-role-filter a {
    display: inline-block; padding: 5px 14px; margin: 2px 3px 2px 0;
    background: #e9ecef; color: #495057; text-decoration: none;
    border-radius: 15px; font-size: 13px; border: 1px solid #dee2e6;
}
.ts-role-filter a:hover { background: #dee2e6; }
.ts-role-filter a.active { background: #4a90d9; color: #fff; border-color: #4a90d9; }
.ts-role-count { font-size: 11px; color: #888; margin-left: 5px; }
.ts-flag-badge { display:inline-block; padding:2px 6px; border-radius:3px; font-size:10px; margin-left:3px; }
.ts-flag-danger { background:#f8d7da; color:#721c24; }
.ts-flag-warning { background:#fff3cd; color:#856404; }
.ts-flag-info { background:#d1ecf1; color:#0c5460; }
@media (max-width: 600px) {
    .ts-table { font-size: 12px; }
    .ts-table th, .ts-table td { padding: 5px; }
    .ts-role-filter a { padding: 4px 10px; font-size: 12px; }
}
</style>

<div class="ts-container">
    <div class="ts-tabs">
        <a href="<?= base_url() ?>timesheet">Clock In/Out</a>
        <a href="<?= base_url() ?>timesheet/weekly">Weekly</a>
        <a href="<?= base_url() ?>timesheet/monthly">Monthly</a>
        <a href="<?= base_url() ?>timesheet/admin_view" class="active">Admin</a>
        <a href="<?= base_url() ?>timesheet/group_admin">Groups</a>
    </div>

    <h3>Employee Timesheet Dashboard</h3>

    <div class="ts-role-filter" <?= ($group_filter > 0) ? 'style="opacity:0.5;"' : '' ?>>
        <strong>Filter by Role:</strong>
        <form id="ts-role-form" method="get" action="<?= base_url() ?>timesheet/admin_view" style="display:inline;">
        <label style="margin:0 6px; cursor:pointer;">
            <input type="checkbox" id="ts-role-all" onchange="tsRoleAllToggle(this)" <?= empty($role_filter) ? 'checked' : '' ?> <?= ($group_filter > 0) ? 'disabled' : '' ?> /> All
        </label>
        <?php foreach ($roles as $r) { ?>
        <label style="margin:0 6px; cursor:pointer;">
            <input type="checkbox" class="ts-role-cb" name="role_cb[]" value="<?= htmlspecialchars($r) ?>" onchange="tsRoleCbChange()" <?= in_array($r, $role_filter) ? 'checked' : '' ?> <?= ($group_filter > 0) ? 'disabled' : '' ?> /> <?= ucfirst(htmlspecialchars($r)) ?>
        </label>
        <?php } ?>
        <button type="button" onclick="tsApplyRoles('admin_view')" style="padding:4px 12px; margin-left:8px; cursor:pointer;" <?= ($group_filter > 0) ? 'disabled' : '' ?>>Apply</button>
        <?php if ($group_filter > 0) { ?><small style="color:#888; margin-left:8px;">(disabled while group filter active)</small><?php } ?>
        </form>
    </div>

    <?php if (!empty($groups)) { ?>
    <div class="ts-role-filter" style="margin-top:5px;">
        <strong style="color:#7b2d8e;">Group Filter:</strong>
        <a href="<?= base_url() ?>timesheet/admin_view?group_id=0" class="<?= ($group_filter == 0) ? 'active' : '' ?>" style="<?= ($group_filter == 0) ? 'background:#7b2d8e; border-color:#7b2d8e;' : '' ?>">No Group Filter</a>
        <?php foreach ($groups as $g) { ?>
        <a href="<?= base_url() ?>timesheet/admin_view?group_id=<?= intval($g['id']) ?>" class="<?= ($group_filter == $g['id']) ? 'active' : '' ?>" style="<?= ($group_filter == $g['id']) ? 'background:#7b2d8e; border-color:#7b2d8e;' : '' ?>"><?= htmlspecialchars($g['group_name']) ?> <span class="ts-role-count">(<?= intval($g['member_count']) ?>)</span></a>
        <?php } ?>
        <a href="<?= base_url() ?>timesheet/group_admin" style="margin-left:8px; font-size:12px; color:#7b2d8e;">Manage Groups</a>
    </div>
    <?php } ?>

    <a href="#ts-entry-modal" class="ts-add-btn facebox">+ Add Manual Entry</a>
    <div class="ts-sort-hint">Click any column header to sort | Showing: <?php
        if ($group_filter > 0) {
            $gn = '';
            foreach ($groups as $g) { if ($g['id'] == $group_filter) $gn = $g['group_name']; }
            echo 'Group: ' . htmlspecialchars($gn);
        } else {
            echo !empty($role_filter) ? implode(', ', array_map('ucfirst', $role_filter)) : 'All Roles';
        }
    ?> (<?= count($employees) ?> employees)</div>

    <table class="ts-table" id="ts-admin-table">
        <thead>
            <tr>
                <th>Employee</th>
                <th>Role</th>
                <th>Status</th>
                <th>Today</th>
                <th>This Week</th>
                <th class="{sorter: false}">Actions</th>
            </tr>
        </thead>
        <tbody>
        <?php foreach ($employees as $emp) {
            $is_in = !empty($emp['active_entry']);
            $emp_id = intval($emp['id']);
            echo '<tr>';
            echo '<td><a href="' . base_url() . 'timesheet/weekly?user_id=' . $emp_id . '" style="color:#333; text-decoration:none;"><strong>' . htmlspecialchars($emp['first_name'] . ' ' . $emp['last_name']) . '</strong></a>';
            // Exception flags
            if (isset($exception_flags[$emp_id])) {
                foreach ($exception_flags[$emp_id] as $flag) {
                    echo ' <span class="ts-flag-badge ts-flag-' . htmlspecialchars($flag['type']) . '">' . htmlspecialchars($flag['label']) . '</span>';
                }
            }
            echo '</td>';
            echo '<td>' . htmlspecialchars($emp['role']) . '</td>';
            echo '<td>';
            if ($is_in) {
                echo '<span class="ts-status-badge ts-status-in">Clocked In</span>';
                echo ' <small>since ' . date('g:i A', strtotime($emp['active_entry']['clock_in'])) . '</small>';
            } else {
                echo '<span class="ts-status-badge ts-status-out">Out</span>';
            }
            echo '</td>';
            echo '<td data-sort-value="' . intval($emp['today_total']) . '">' . floor($emp['today_total'] / 60) . 'h ' . ($emp['today_total'] % 60) . 'm';
            echo ' <a href="javascript:void(0)" onclick="tsOpenUserEntries(' . $emp_id . ',\'' . date('Y-m-d') . '\',\'day\')" style="font-size:11px; color:#4a90d9;">[edit]</a>';
            echo '</td>';
            echo '<td data-sort-value="' . intval($emp['week_total']) . '">' . floor($emp['week_total'] / 60) . 'h ' . ($emp['week_total'] % 60) . 'm';
            echo ' <a href="javascript:void(0)" onclick="tsOpenUserEntries(' . $emp_id . ',\'' . date('Y-m-d') . '\',\'week\')" style="font-size:11px; color:#4a90d9;">[edit]</a>';
            echo '</td>';
            echo '<td>';
            echo '<a href="' . base_url() . 'timesheet/weekly?user_id=' . $emp_id . '">Weekly</a> | ';
            echo '<a href="' . base_url() . 'timesheet/monthly?user_id=' . $emp_id . '">Monthly</a>';
            echo '</td>';
            echo '</tr>';
        } ?>
        </tbody>
    </table>

    <div class="ts-export-section">
        <h4>Export CSV</h4>
        <form method="get" action="<?= base_url() ?>timesheet/export_csv">
            <label>From:</label>
            <input type="date" name="from" value="<?= date('Y-m-01') ?>" />
            <label>To:</label>
            <input type="date" name="to" value="<?= date('Y-m-d') ?>" />
            <label>Employee:</label>
            <select name="user_id">
                <option value="">All Employees</option>
                <?php foreach ($employees as $emp) { ?>
                <option value="<?= $emp['id'] ?>"><?= htmlspecialchars($emp['first_name'] . ' ' . $emp['last_name']) ?></option>
                <?php } ?>
            </select>
            <button type="submit" class="ts-export-btn">Download CSV</button>
        </form>
    </div>

    <div id="ts-entry-modal" style="display:none;">
        <?php include(APPPATH . 'views/timesheet/entry_form.php'); ?>
    </div>

    <div id="ts-user-entries-modal" style="display:none;">
        <div style="padding:15px; min-width:550px;">
            <h3 id="ts-ue-title">Entries</h3>
            <div id="ts-ue-body" style="max-height:400px; overflow-y:auto;">Loading...</div>
            <div style="text-align:right; margin-top:10px;">
                <button type="button" onclick="tsOpenAddForUser()" style="padding:6px 16px; background:#4a90d9; color:#fff; border:none; cursor:pointer; border-radius:3px;">+ Add Entry</button>
                <button type="button" onclick="tsOpenAddCustomerForUser()" style="padding:6px 16px; background:#27ae60; color:#fff; border:none; cursor:pointer; border-radius:3px; margin-left:5px;">+ Add Job</button>
            </div>
        </div>
    </div>
</div>

<script>
function tsEscHtml(str) {
    if (!str) return '';
    var div = document.createElement('div');
    div.appendChild(document.createTextNode(str));
    return div.innerHTML;
}

function tsRoleAllToggle(el) {
    if (el.checked) {
        var cbs = document.querySelectorAll('.ts-role-cb');
        for (var i = 0; i < cbs.length; i++) cbs[i].checked = false;
    }
}
function tsRoleCbChange() {
    var cbs = document.querySelectorAll('.ts-role-cb');
    var anyChecked = false;
    for (var i = 0; i < cbs.length; i++) { if (cbs[i].checked) anyChecked = true; }
    document.getElementById('ts-role-all').checked = !anyChecked;
}
function tsApplyRoles(page) {
    var allEl = document.getElementById('ts-role-all');
    if (allEl && allEl.checked) {
        window.location.href = '<?= base_url() ?>timesheet/' + page + '?roles=all';
        return;
    }
    var cbs = document.querySelectorAll('.ts-role-cb');
    var selected = [];
    for (var i = 0; i < cbs.length; i++) {
        if (cbs[i].checked) selected.push(cbs[i].value);
    }
    if (selected.length === 0) {
        window.location.href = '<?= base_url() ?>timesheet/' + page + '?roles=all';
    } else {
        window.location.href = '<?= base_url() ?>timesheet/' + page + '?roles=' + encodeURIComponent(selected.join(','));
    }
}

$(document).ready(function() {
    $.tablesorter.addParser({
        id: 'hoursMinutes',
        is: function(s) { return false; },
        format: function(s, table, cell) {
            return $(cell).attr('data-sort-value') || 0;
        },
        type: 'numeric'
    });

    $('#ts-admin-table').tablesorter({
        headers: {
            3: { sorter: 'hoursMinutes' },
            4: { sorter: 'hoursMinutes' },
            5: { sorter: false }
        },
        sortList: [[0, 0]]
    });
});

var tsUeUserId = 0, tsUeDate = '', tsUeMode = 'day';

function tsOpenUserEntries(userId, date, mode) {
    tsUeUserId = userId;
    tsUeDate = date;
    tsUeMode = mode;
    $.facebox({div: '#ts-user-entries-modal'});
    $('#ts-ue-body').html('<em>Loading...</em>');
    $.ajax({
        type: 'POST',
        url: '<?= base_url() ?>timesheet/get_user_day_entries',
        data: { user_id: userId, date: date, mode: mode },
        dataType: 'json',
        success: function(json) {
            if (!json.success) {
                $('#ts-ue-body').empty().append($('<span style="color:red;"></span>').text(json.message));
                return;
            }
            var label = json.user_name + ' - ';
            if (json.mode == 'week') {
                label += 'Week of ' + json.from + ' to ' + json.to;
            } else {
                label += json.from;
            }
            $('#ts-ue-title').text(label);
            tsRenderUserEntries(json.entries, json.user_id);
        },
        error: function() {
            $('#ts-ue-body').empty().append($('<span style="color:red;"></span>').text('Connection error.'));
        }
    });
}

function tsRenderUserEntries(entries, userId) {
    var $body = $('#ts-ue-body').empty();
    if (!entries || entries.length === 0) {
        $body.append($('<p style="color:#999;"></p>').text('No entries found.'));
        return;
    }
    var $table = $('<table style="width:100%; border-collapse:collapse;"></table>');
    var $head = $('<tr style="background:#4a90d9; color:#fff;"></tr>');
    var cols = ['Date', 'In', 'Out', 'Net', 'Job', 'Notes', ''];
    for (var c = 0; c < cols.length; c++) {
        $head.append($('<th style="padding:6px;"></th>').text(cols[c]));
    }
    $table.append($head);

    for (var i = 0; i < entries.length; i++) {
        (function(e) {
            var net = (parseInt(e.duration_minutes) || 0) - (parseInt(e.break_minutes) || 0);
            var netStr = e.clock_out ? (Math.floor(net/60) + 'h ' + (net%60) + 'm') : '-';
            var cin = e.clock_in ? e.clock_in.substring(11, 16) : '';
            var cout = e.clock_out ? e.clock_out.substring(11, 16) : 'Active';
            var eDate = e.clock_in ? e.clock_in.substring(0, 10) : '';
            var custStr = e.customer_id ? (e.customer_name || 'Job #' + e.customer_id) : '-';

            var $row = $('<tr style="border-bottom:1px solid #ddd;"></tr>');
            var tdStyle = 'padding:5px; font-size:12px;';
            $row.append($('<td></td>').css({padding:'5px',fontSize:'12px'}).text(eDate));
            $row.append($('<td></td>').css({padding:'5px',fontSize:'12px'}).text(cin));
            $row.append($('<td></td>').css({padding:'5px',fontSize:'12px'}).text(cout));
            $row.append($('<td></td>').css({padding:'5px',fontSize:'12px'}).text(netStr));
            $row.append($('<td></td>').css({padding:'5px',fontSize:'12px'}).text(custStr));
            $row.append($('<td></td>').css({padding:'5px',fontSize:'12px'}).text(e.notes || ''));

            var $editLink = $('<a href="javascript:void(0)" style="font-size:11px;"></a>').text('Edit');
            $editLink.on('click', function() {
                tsEditFromPanel(
                    e.id, userId, (e.customer_id || 0), (e.customer_name || ''),
                    eDate, cin, (e.clock_out ? e.clock_out.substring(11,16) : ''),
                    (parseInt(e.break_minutes) || 0), (e.notes || '')
                );
            });
            $row.append($('<td style="padding:5px;"></td>').append($editLink));

            $table.append($row);
        })(entries[i]);
    }
    $body.append($table);
}

function tsOpenAddForUser() {
    $.facebox({div: '#ts-entry-modal'});
    $('#ts-form-title').text('Add Time Entry');
    $('#ts-entry-id').val('');
    $('#ts-form-user').val(tsUeUserId);
    $('#ts-form-date').val(tsUeDate);
    $('#ts-form-clockin').val('08:00');
    $('#ts-form-clockout').val('17:00');
    $('#ts-form-break').val('30');
    $('#ts-form-notes').val('');
    $('#ts-form-customer-id').val('');
    $('#ts-form-customer-search').val('');
    $('#ts-customer-selected').empty();
    $('#ts-customer-results').hide();
    $('#ts-delete-btn').hide();
    $('#ts-save-btn').prop('disabled', false).text('Save');
    $('#ts-form-msg').hide();
}

function tsOpenAddCustomerForUser() {
    // Open entry form pre-focused on the customer search
    tsOpenAddForUser();
    setTimeout(function() { $('#ts-form-customer-search').focus(); }, 300);
}

function tsEditFromPanel(entryId, userId, customerId, customerName, date, clockIn, clockOut, breakMin, notes) {
    $.facebox({div: '#ts-entry-modal'});
    tsEditEntry(entryId, userId, customerId, customerName, date, clockIn, clockOut || '17:00', breakMin, notes);
}
</script>
