 <!--
Customer Types: Residential, Commercial
Job Type: Solar Water Heating, Photovoltaic, Solar Attic Fan, Service Call

Automatic filtering to prevent same-name/same-address scenarios. i.e. if name is entered and there is a similar name/lastname, if asks if this person lives at the same address. If yes, it'll modify that persons profile, ie customers can have more than one job added to it like solar water heating, photovoltaics, solar fans, etc
Ability to 'Save for later', i.e. saves and closes overlay window and returns to Job Calendar view
Ability to 'Enter more details' - takes user to job detailed page to enter more customer details.

- width of all overlays should be the same, although its not necessary to keep it the same width in the mockups
-->
<style>
.anothername{display:none;}
.chacklist_checkbox p {
    color: #fff;
    font-weight: bold;
    padding: 4px 4px;
}
</style>
<META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE">
<div class="generic-page-block">
    
    <div style="positon:absolute; z-index:1;">
	<div class="green-header">
            <div class="title">Technician Assignment Team</div>
	</div>
        <div class="clearfix" style="padding:5px;"></div>
        <div class="green-headers">
            <div style="">
                <div style="float: right;">
                    <a href="<?=base_url()?>create_team/add_team_type/0/0/0/" class="facebox">
                        <button class = "submit">Add Team Type</button>
                    </a>
                 </div>
            </div>
        </div>
        
	<div class="content clearfix" style="padding:10px;">

            <div class="form-errors" style="display:none;"></div>
            
            <?=form_open('create_team/create_new_team', 'id="create_new_team"');?>
                
                <?=form_label('Select Team Type','team_type');?>
                <div id="select_team_type_error" style="display:none; padding:5px 0;">
                    <span style="color:#ff9f44;">Please select at least one Team Type.</span>
                </div>
                <?=form_dropdown('team_type',@$team_types,@$teams['team_type_id'],'id="team_type" onchange="change_team_type()"');?>
                
                <?php 
                    if(@$teams['team_type_id']){
                        $display = 'block';
                    }else{
                        $display = 'none';
                    }
                ?>
                
                <div style='display:<?=@$display;?>;' id="technician_teams_title">
                    <?=form_label('Select Team','technician_teams');?>
                    <div id="select_team_error" style="display:none; padding:5px 0;">
                        <span style="color:#ff9f44;">Please select at least one Team.</span>
                    </div>
                    <div id="technician_drop">
                        <?=form_dropdown('technician_teams',@$technician_teams,@$teams['id'],'id="technician_teams" onchange="change_technician_teams()"');?>
                    </div>
                </div>
                
                <div style='display:<?=@$display;?>;' id="title">
                    <?=form_label('Team Name', 'team_name');?>
                    <div id="select_team_name_error" style="display:none; padding:5px 0;">
                        <span style="color:#ff9f44;">Please Enter Team Name.</span>
                    </div>
                    <?=form_input('team_name',@$teams['team_name'],'id="team_name" ');?>
                </div>
                &nbsp;
                <h3 class="pera-div">Please Select Technician: </h3>
                &nbsp;
               
                <div id="topbar">
                    <input class="text" name="search_technic" value="" type="text" style="margin: -5px 0 5px 0px;width: 274px;">
                </div>
                
                <div id="select_employee_error" style="display:none; padding:5px 0;">
                    <span style="color:#ff9f44;">Please select at least one Technician.</span>
                </div>
                <h3 style="padding: 5px 0px 5px 20px; font-size: 14px;background: rgb(65, 142, 28) none repeat scroll 0% 0%;width: 283px; color: #FFF;">Technician Name</h3>
                <div class="chacklist_checkbox" id="all_technicians_list" style="max-height: 210px;border: 1px solid rgb(204, 204, 204);margin: 0px;overflow: auto;width: 300px;">
                    <?php 
                    
                        if(count(@$technician_list) == 0 ){ ?>
                            <div align="center" style="padding:10px; background:#f4f4f4; color:#666; border:1px solid #ddd; margin:-7px;">
                                No Technicians found
                            </div>
                        <?php } else{
                        
                        foreach (@$technician_list as  $key => $val) { ?>
                            
                            <p><input type="checkbox" class="technicians" id="<?=@$key;?>" value="<?=@$key;?>" name="technicians[]" <?=((@$selectedTechnicians && in_array(@$key, $selectedTechnicians)) ? 'checked="checked"' : ''); ?> />&nbsp;<?=@$val;?></p>
                            
                        <?php } }?>
                </div>
                <?=form_close();?>
                <div style="float:left;margin-top: 10px;">
                    <button class="cancel-facebox" type="reset">Cancel</button>
                </div>
                <div style="float:left;margin-top: 10px;">
                    &nbsp;<button class="next"><?=(@$teams['team_type_id']?'Update':'Save');?></button>
                </div>
            
            <div class="clear-both"></div>
	</div>
    </div>	
</div>

<script type="text/javascript" charset="utf-8">
    
    function search_function(){
        $("#select_team_type_error ,#select_team_error,#select_employee_error,#select_team_name_error").hide();
        var search_employee = $("input[name=search_technic]").val();
        var team_type = $('#team_type').val();
        var technician_teams = $('#technician_teams').val();
        if(team_type == '') team_type=0;
        if(technician_teams == '') technician_teams=0;
        $('#displayloading').show();
        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>create_team/search_by_technician_name/",
            data: 'team_type='+team_type + '&technician_teams=' + technician_teams + '&search_employee=' + search_employee,
            dataType: 'JSON',
            success: function (json) {
                if (json.success == true)
                {
                    $('#all_technicians_list').html(json.htmldata);
                    var technician_teams = $('#technician_teams').val();
                    if(technician_teams != '' && technician_teams!=9999){
                        $('#title').show();
                        $('#team_name').val(json.team_name);
                    }
                }
                else
                {
                    $(".form-errors").html(json.msg);
                    $(".form-errors").fadeIn();
                }
                $('#displayloading').hide();
            }
        });
    }
    
    $(document).ready(function() {
        
        $('input[name=search_technic]').keyup(function() {
            search_function();
        });

        $(".next").click( function(){
            $("#select_team_type_error ,#select_team_error,#select_employee_error,#select_team_name_error").hide();
            
            $('#create_new_team').find('input:text').each(function(){
                $(this).val($.trim($(this).val()));
            });
            var team_type = $('#team_type').val();
            var technician_teams = $('#technician_teams').val();
            var team_name = $('#team_name').val();
            
            if(team_type == '' ){
                $('#select_team_type_error').show();
                return false;
            }
            if(technician_teams == '' ){
                $('#select_team_error').show();
                return false;
            }else if(technician_teams==9999){
                if(team_name == '' ){
                    $('#select_team_name_error').show();
                    return false;
                }
            }
            var numberEmployees = $('.technicians:checked').length;
            if(numberEmployees == 0 ){
                $('#select_employee_error').show();
                return false;
            }
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>create_team/create_team_submit",
                data: $('#create_new_team').serialize(),
                dataType: "json",
                success: function(json) {
                    if(json.success == true)
                    {
                        document.getElementById("create_new_team").reset();
                        //window.location.reload();
                        location.href = '<?=base_url() ?>create_team/index/';
                        //$.facebox('<h3>Your Changes Have Been Saved.</h3><br /><button onclick="window.location.reload();" >OK</button>');
                    }
                    else
                    {
                        $("#displayloading").hide();
                        $(".form-errors").html(json.msg);
                        $(".form-errors").fadeIn();
                    }
                }
            });
        });
    });
    
    var team_type_Id = <?=(@$team_type_Id?@$team_type_Id :0);?>;
    var technic_team_Id = <?=(@$technic_team_Id?@$technic_team_Id :0);?>;
    if(team_type_Id!='' && team_type_Id!=0){
        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>create_team/update_technician_team/",
            data: "team_type=" + team_type_Id + "&team_id=" + technic_team_Id, 
            dataType: "",
            success: function (json) {
                $("#technician_drop").html(json);
            }
        });
    }
    $("#team_type").change(function () {
        var team_type = $("#team_type").val();
        var team_id = <?=(@$team_id?@$team_id :0);?>;
        if(team_type!=''){
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>create_team/update_technician_team/",
                data: "team_type=" + team_type + "&team_id=" + team_id, 
                dataType: "",
                success: function (json) {
                    $("#technician_drop").html(json);
                    $('#title').hide();
                }
            });
        }
        search_function();
    });
    
    $(document.body).on('change', 'select[name^="technician_teams"]', function() {
        var technician_teams = $('#technician_teams').val();
        if(technician_teams==9999){
            $('#title').show();
            $('#team_name').val('');
        }else{
            $('#title').hide();
        }
        search_function();
    });
    
    function change_team_type(){
        var team_type = $('#team_type').val();
        if(team_type!=''){
            $('#technician_teams_title').show();
        }else{
            $('#technician_teams_title').hide();
            $('#title').hide();
        }
    }
    function change_technician_teams(){
        var technician_teams = $('#technician_teams').val();
        alert(technician_teams)
        if(technician_teams==9999){
            $('#title').show();
        }else{
            $('#title').hide();
        }
    }

</script>