<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Alternate Energy</title>
<style type="text/css">
body{font-family:"Neo Sans", Arial, Helvetica, sans-serif; color:#404041; font-size:100%;}

*{margin:0; padding:0;}
.fl{float:left;}
.fr{float:right;}
.cl{clear:both;}
img{border:none;}
li{list-style:none;}
strong{font-weight:bold;}

/* FIXES */
.clearfix:after, .paginationBar:after {content: "."; display: block; height: 0px; clear: both; visibility: hidden;}
.clearfix, .paginationBar {display: inline-block;}
/* Hides from IE-mac \*/
* html .clearfix, * html .paginationBar {height: 1%;}
.clearfix{display: block;}
/* End hide from IE-mac */

.wrap{width:980px; padding:0; margin:16px auto;}

.headerPan{padding-bottom:1px; margin-bottom:11px; border-bottom:1px solid #71b644; color:#505051; position:relative;}

h1{font-style:italic; font-weight:lighter; font-size:38px; margin:44px 0 15px 0; color:#414142; padding-bottom:8px; border-bottom:1px solid #71b644; position:absolute; font-family:neo sans light;}
.datePan{font:16px neo sans; white-space:0.01em; margin-bottom:43px; color:#414142;}
.datePan strong{font-weight:bold;}

h2, h4{font-size:21px; font-style:normal; font-family:neo sans; font-weight:500; margin:0 0 4px 0; letter-spacing:normal; padding-bottom:5px; color:#414142; border-bottom:1px solid #848485;}

/*
h4{font-size:19px; font-family:neo sans; font-weight:bold; margin:0 0 5px 0; padding-bottom:5px; color:#414142; border-bottom:1px solid #848485;}
*/


p, p.secondp{font-size:17px; font-weight:normal; padding:3px 0; line-height: 135%; color:#414142; font-family:neo sans light;}

/*p.secondp{font-size:17px; font-weight:400; padding:3px 0; line-height: 150%; color:#414142; font-family:neo sans light;}*/

.notes{font-size:13px; font-weight:lighter; font-family:neo sans light; padding:10px 0; margin-top:10px; line-height:150%; color:#6D6F71; border-top:1px solid #404041;}
.notesd{font-size:14px; font-weight:lighter; font-family:neo sans light; padding:10px 0; margin-top:15px; line-height:150%; color:#6D6F71; border-top:1px solid #404041;}


ul li{font-size:16px; font-weight:normal;}
ul li strong{font-weight:bold;}

h3{font-size:18px; font-weight:normal; margin:0 0 5px 0; padding-bottom:5px; color:#414142; border-bottom:1px solid #848485;}
.catlt{font-size:15px; font-weight:normal; padding:10px 0 20px 0; line-height:150%; color:#414142;}
.footeraddress{font-size:11px; line-height:150%; font-weight:normal; border-left:1px solid #71b644; padding:0 10px; margin:0 10px;}

.taxbenefits{border-collapse:collapse; width:100%;}
/*.tdData{border:none; font-size:15px; font-weight:lighter; padding:3px; color:#414142;}*/
.tdData{font-size:17px; font-weight:normal; padding:3px; color:#414142; font-family:neo sans light;}
.txtright{text-align:right;}
td strong{color:#000000;}

.graphtable{border-collapse:collapse; width:96%; margin:0 auto;}

.graphtable td {padding:3px 0 3px 15px; color:#414142; font-weight:lighter; font-size:1em; font-family:neo sans light;}
.graphtable th{border-bottom:1px solid #000000; font-weight:lighter; font-size:1em; text-align:left; padding:3px 0 3px 15px; font-family:neo sans light; color:#414142;}
.declaraton{font-size:21px; font-weight:500; font-family:neo sans; padding-bottom:5px; letter-spacing:normal; color:#414142;}
.declaratontext{font-size:21px; font-weight:500; font-family:neo sans; letter-spacing:normal; color:#414142;}

ol.leftnumbers{float:left;}
ol.leftnumbers li{list-style:none; text-align:right; margin:20px 0 0 0; font-size:0.7em;}

.chatdiagram{border-collapse:collapse;}

ol.graphdata li, ol.graphmonth li{list-style:none; display:inline-block; padding:1px; margin:0 6px; width:15px; font-size:0.8em; text-align:center;}
ol.graphdata li{background-color:#6fb446; font-size:0; color:transparent; vertical-align:bottom;}

.module{padding-top:10px; font-family:neo sans; font-weight:lighter;}
.module strong{font-weight:bold;}

.top15{padding-top:15px;}

.graphData{background-color: #6FB446;}
.monthD{width:15px; text-align:center; font-size:11px;}
.listN{font-size:11px; text-align:right; height:25px; vertical-align:bottom;}

.salesmandtl{font-size:11px; line-height:150%; font-weight:normal; padding:0 5px; margin:0 5px;}

h5{color:#71B644;}

.greenbox{background-color:#71B644; padding:15px; color:#ffffff;}

.break { page-break-before: always; }
</style>
</head>

<body>

<div class="wrap">
	<div class="clearfix cl">
		<div class="fl">
			<img src="<?=base_url()?>assets/pdfimages/salesman-pic.jpg" class="fl" style="width:62px;" />
			<div class="salesmandtl fl">
				<strong>Prepared By:</strong> [Salesuser Firstname], [Salesuser Lastname]<br/>
				<strong>Phone:</strong> [Salesuser Phone Number]<br/>
				<strong>Email:</strong> [Salesuser Email]
			</div>
		</div>
		<img src="<?=base_url()?>assets/pdfimages/logo.png" class="fr" />
	</div>

	<div class="headerPan clearfix" style="margin-top:400px;">
	<h1 class="fl" >[System Size] Residential Photovoltaic System</h1>
	<div style="height:98px;"></div>
	</div>
</div>

<div class="wrap break">
	<div class="headerPan clearfix">
	<h1 class="fl"></h1>
	<img src="<?=base_url()?>assets/pdfimages/logo.png" class="fr" />
	</div>
	<table>
		<tr>
			<td style="color:#71B644; width:33%;">Introduction</td>
			<td style="width:33%;"></td><td style="width:33%;"></td>
		</tr>
		<tr>
			<td>
				<h5>Congratulations</h5>
				<p>
				Welcome to Alternative Energy Inc�s.
				Energy Analysis and Proposal for a grid
				tied photovoltaic system to be considered
				for the [Customer lastname]�s
				residence of [Customer Address]. The
				purpose of this document is to illustrate
				the advantages for you, your household
				and the environment by installing a gridtied
				photovoltaic system with Alternate
				Energy Inc.
				</p>

				<h5>Three Generations</h5>
				<p>
				Alternate Energy Inc. (AEI) is a familyowned
				and operated business with a long
				history of serving kamaaina. More than 30
				years ago, Bruce Ekimura, a plumber by
				trade, realized that harnessing the power
				of the sun could help Hawaii families
				combat the rising price of electricity and
				help our state become less dependent on
				imported oil. Bruce and his father became
				early specialists in the installation of solar
				hot water heaters, and later photovoltaic
				(PV) systems, and in 1993 Alternate
				Energy was officially incorporated.
				</p>
			</td>
			
			<td>
				<p>
				Today, as rising oil prices continue to keep
				electricity rates soaring, Alternate Energy
				remains committed to helping local families
				and businesses discover the clean, green,
				moneysaving power of the sun.
				</p>

				<h5>Elite Dealer</h5>
				<p class="clearfix;">
				Alternate Energy Inc. recently achieved
				the status of Mitsubishi Electric�s first
				Nationally recognized Elite Dealer for
				solar PV. This means that we are Certified
				and trusted by
				Mitsubishi Electric
				to sell and install
				its premium
				<img src="<?=base_url()?>assets/pdfimages/Elite-Dealer.jpg" class="fr" style="width:150px;" />
				monocrystalline solar panels in Hawaii.
				</p>
				
				<h5 class="cl">Elite Training & Certification</h5>
				<p>
				All of our highly skilled solar technicians
				are employees (not subcontractors)
				annually Trained and Certified by
				Mitsubishi Electric to design, install and
				service all of your PV needs.
				</p>
			</td>

			<td>
				<h5>Elite Products<h5>
				<p>
				We understand that photovoltaic systems
				are a long term investment. That�s why
				we invest in the most reliable companies
				that have been trusted for years.
				Mitsubishi Electric�s premium solar panels
				are made 100% in Japan where quality is a
				high standard.
				</p>

				<p style="padding-top:20px;">
				The solar panels are also designed and
				warrantied for installations near salt
				water for long lasting performance.
				</p>

				<h5>Elite Service</h5>
				<p>
				Being family-owned and operated, we
				take pride in every job and make sure each
				customer is satisfi ed, every time. We are
				Hawaii�s expert solar company since 1993.
				</p>

				<div class="greenbox">
					This system will prevent [X]
					lbs sulfur dioxide (causes
					acid rain) from being released
					into Hawaii�s rainforests.
				</div>
			</td>
		</tr>
	</table>
</div>

<div class="wrap break">
	<div class="headerPan clearfix">
	<h1 class="fl">Photovoltaic System Summary</h1>
	<img src="<?=base_url()?>assets/pdfimages/logo.png" class="fr" />
	</div>
	<div class="clearfix">
		<div class="datePan"><strong><?=date("F j, Y",strtotime($proposal['created']));?> / Quote No.</strong> <?=$proposal['id']?> / Photovoltaic Proposal Page 1</div>
	
	</div>
		
		<?=@$moduletypedesc;?>
		<br/>
		
		<?=@$invertertypedesc;?>
	
	
	<div style="clear:left; display:block; height:5px; background: url('<?=base_url()?>assets/images/energy-dashedlines.png') repeat-x;">&nbsp;</div>	
	
	
	<div class="clearfix cl" style="font-family:neo sans light; padding:29px 0;">
			<?=@$reckone1;?>
			<?=@$reckone2;?>
			<?=@$reckone3;?>
	</div>
	
	
</div>
 <?                                       
                                          $startmo =0;
                                          $solorsum = 0;
                                          $pvsumenergy =0;
                                          $pvenergyval =0;
                                          $first_month_cal=false;
                                          $first_month_sav =234;
                                          $pvenergy_g = array();
                                          foreach($proposal_month as $pvenergy) {
                                             if($pvenergy['month']=='Year') continue;
                                            if (!$first_month_cal)  {
                                                $first_month_sav = ($proposal['ceu']-$pvenergy['acenergy'])*$proposal["electriccost"];
                                            }
                                            $solorsum += $pvenergy['solar'];
                                            $pvsumenergy +=$pvenergy['acenergy'];
                                            $pvenergyval +=$pvenergy['costsaved'];
                                            $pvenergy_g[] = $pvenergy['acenergy'];
                                          }
                                            $k = $proposal['nos'];
                                              $sumtax=0;
                                             for($i=1;$i<=$k ;$i++) {
                                                 $state_tax = ($proposal['price']/$k)*.35;
                                                 if($state_tax>5000){
                                                     $state_tax=5000;
                                                 }
                                                 $sumtax+= ($state_tax)+(($proposal['price']/$k)*.3);
                                             }
                                           $paybackyears = round(($proposal['price']-$sumtax)/$pvenergyval,2);
                                           $max_pvenergy_g = max($pvenergy_g);
                                           $divdedby=100;
                                           $per = 1;
                                           if($max_pvenergy_g>700 && $max_pvenergy_g<=1000){
                                            $divdedby=150;
                                            $per=.66;
                                           }else if($max_pvenergy_g>1000 && $max_pvenergy_g<2000){
                                            $divdedby=200;
                                            $per=.5;
                                           }else if($max_pvenergy_g>2000){
                                            $divdedby=300;
                                            $per=.33;
                                           }
                                           $grpah_m = ceil($max_pvenergy_g/$divdedby);
                                       ?>
<div class="wrap break">
	<div class="headerPan clearfix">
	<h1 class="fl">Power Production Estimate</h1>
	<img src="<?=base_url()?>assets/pdfimages/logo.png" class="fr" />
	</div>
	<div class="clearfix">
		<div class="datePan"><strong><?=date("F j, Y",strtotime($proposal['created']) );?> / Quote No.</strong> <?=$proposal['id']?>/ Photovoltaic Proposal Page 2</div>
	</div>
		
		<div class="clearfix">
			<div class="fl" style="width:480px;">
				<h4>Customer Details</h4>
				<p class="secondp">
					Utility Rate: <?=$proposal["electriccost"]?>c/kWh<br class="cl" />
                                        Current AVG. Energy Usage: <?=$proposal['ceu']?>kWh <br class="cl" />
                                        Current Utility  Bill($): <?=number_format($proposal['ceu']*$proposal["electriccost"]/1000,2);?> <br class="cl" />
                                        Solar Sunshine Zone: <?=$proposal['avgzoneenergy']?> <br class="cl" />
                                        Street Address: <?=$proposal['address']?> <br class="cl" />
					City:  <?=$proposal['city']?>, Zip Code:  <?=$proposal['zip']?>, State:  <?=$proposal['state']?> <br class="cl" />

				</p>

				<h4 class="top15">PV System Specifications</h4>
				<p class="secondp">
					Module Type: <?=$qoute_mws[$proposal['module_type']]?><br class="cl" />
					Number of Modules: <?=$proposal['nom']?><br class="cl" />
					System Size (DC Rating): <?=$proposal['system_size']?> kW<br class="cl" />
                                        Inverter Type: <?=$qoute_iws[$proposal['invertert']]?><br class="cl" />
					DC to AC Derate Factor:<?=$proposal['dctoacderate']?> <br class="cl" />
					Array Azimuth (Degrees): <?=$proposal['arrayazimuth']?><br class="cl" />
				</p>

				<h4 class="top15">Energy Production & Savings</h4>
				<p class="secondp">

					Energy Offset Due to PV System: <?=round(($proposal['ceu']/$pvsumenergy)*12*100,2)?>%<br class="cl" />
                                        Utility Rate: <?=$proposal["electriccost"]?>c/kWh<br class="cl" />
					Average Monthly Production: <?=number_format($pvsumenergy/12,2);?>kWh<br class="cl" />
                                        Average Monthly Savings: $<?=round($pvenergyval/12);?>/ Month<br class="cl" />
                                        Annual Power Production: <?=number_format($pvsumenergy,2);?>kWh<br class="cl" />
					Annual Energy Savings: $<?=number_format($pvenergyval,2);?> / Year<br class="cl" />
					Payback Period: <?=$paybackyears;?> Years<br class="cl" />
				</p>

			</div>
			
			<div class="fr">
				<div class="declaraton">Monthly Production Estimates*</div>
				<div style="width:472px; float:right;">
					<div style="border:3px solid #000000; padding:10px 10px 15px 10px;" class="clearfix">
					<div class="graphchatTable">
						<table>
							<tr>
								<td valign="middle"><img src="<?=base_url()?>assets/pdfimages/chat-left.png" /></td>
								<td>
									<table width="420" cellpadding="0" cellspacing="10" border="0">
									  <tr>
										<td class="listN" width="20"><?=$grpah_m*$divdedby;?></td>
										<? foreach($proposal_month as $pmd){ if($pmd['month']=='Year') continue;?>
										<td rowspan="<?=$grpah_m+1?>" valign="bottom"><div class="graphData" style="height:<?=$pmd['acenergy']*.37*$per?>px;"></div></td>
										<?} ?>
									  </tr>
                                                                           <? for($k=$grpah_m-1;$k>=0;$k--) {?> 
									  <tr>
										<td class="listN"><?=$k*$divdedby;?></td>
									  </tr>
                                                                            <? } ?>
									  
									  <tr>
										<td>&nbsp;</td>
										<td class="monthD">J</td>
										<td class="monthD">F</td>
										<td class="monthD">M</td>
										<td class="monthD">A</td>
										<td class="monthD">M</td>
										<td class="monthD">J</td>
										<td class="monthD">J</td>
										<td class="monthD">A</td>
										<td class="monthD">S</td>
										<td class="monthD">O</td>
										<td class="monthD">N</td>
										<td class="monthD">D</td>
									  </tr>
									</table>
								</td>
							</tr>
							<tr>
								<td></td>
								<td style="text-align:center; font-size:11px;">MONTHS(<?=date("Y",strtotime($proposal['created']));?>)</td>
							</tr>
						</table>
					</div>
					<table class="graphtable">
						<tr><th>Month</th><th>Sun Hours</th><th>Energy (kWh)</th><th>Energy Value($)</th></tr>
						<? 
                                                $startmo =0;
                                                $solorsum = 0;
                                                $pvsumenergy =0;
                                                $pvenergyval =0;
                                                foreach($proposal_month as $pvenergy) {
                                                    if($pvenergy['month']=="Year") continue;
                                                    $startmo+=1;
                                                    $solorsum += $pvenergy['solar'];
                                                    $pvsumenergy +=$pvenergy['acenergy'];
                                                    $pvenergyval +=$pvenergy['costsaved'];
                                                ?>
                                                <tr>
						<td><?=$startmo;?></td>
						<td><?=$pvenergy['solar']?></td>
						<td><?=$pvenergy['acenergy']?></td>
						<td><?=$pvenergy['costsaved']?></td>
						</tr>
                                                <? } ?>
						
						<tr style="border-top:1px solid #000;">
						<td>Year</td>
						<td><?=round($solorsum/12,2)?></td>
						<td><?=$pvsumenergy?></td>
						<td><?=$pvenergyval?></td>
						</tr>
					</table>
					</div>
				
					<div style="padding:10px 0; margin-top:10px; border-top:0px solid #ffffff;" class="notesd">
						<?=$pdf2footertext?>
					</div>
				</div>
			</div>
			
		</div>
	
		
	
	
	
</div>

<div class="wrap break">
	<div class="headerPan clearfix">
	<h1 class="fl">Tax Invoice - Purchase Agreement</h1>
	<img src="<?=base_url()?>assets/pdfimages/logo.png" class="fr" />
	</div>
	<div class="clearfix">
		<div class="datePan"><strong><?=date("F j, Y",strtotime($proposal['created']));?> / Quote No.</strong>  <?=$proposal['id']?> / Photovoltaic Proposal Page 3</div>
	</div>
		
		<div class="clearfix">
			<div class="clearfix">
			<div class="fl" style="width:480px;">
				<h4>Customer Details</h4>
				<p class="secondp">
					Name: <?=ucfirst($proposal['dpp_firstname'])?> <?=ucfirst($proposal['dpp_lastname'])?> <br class="cl" />
					Street Address: <?=$proposal['address']?> <br class="cl" />
					City: <?=$proposal['city']?> , Zip Code: <?=$proposal['zip']?> , State: <?=$proposal['state']?> <br class="cl" />
					Phone: <?=$proposal['phone']?>, Secondary Phone: <?=$proposal['sphone']?><br class="cl" />
					Email: <?=$proposal['email']?><br class="cl" />
				</p>
			
				<h4 class="top15">PV System Specifications</h4>
				<p class="secondp">
					Module Type: <?=$qoute_mws[$proposal['module_type']]?><br class="cl" />
					Number of Modules: <?=$proposal['nom']?><br class="cl" />
					System Size (DC Rating): <?=$proposal['system_size']?> kW<br class="cl" />
					Inverter Type: <?=$qoute_iws[$proposal['invertert']]?><br class="cl" />
					Number of Inverters: <?=$proposal['not']?><br class="cl" />
					Number of Systems: <?=$proposal['nos']?><br class="cl" />
					Addtional Requirements/Note:  <?=$proposal['add_requirement']?><br class="cl" />
				</p>
			</div>
			
			<div class="fr" style="width:472px;">
				<div class="declaraton">AEI's Premium PV System Cost</div>
				<div style="border:3px solid #000000; padding:10px;" class="clearfix">
				<table class="taxbenefits">
					<tr><td class="tdData">System Price:</td><td class="tdData txtright"><strong> $<? echo $cal =number_format(($proposal['price']*100)/104.712,2)?></strong></td></tr>
					<tr><td class="tdData">General Excise Tax (4.712%):</td><td class="tdData txtright"><strong><?=number_format(($proposal['price']*4.712)/104.712,2)?></strong></td></tr>
                                        <tr><td class="tdData">Total Payable:</td><td class="tdData txtright"><strong>$<?=number_format($proposal['price'],2)?></strong></td></tr>
				</table>
					<p style="border-top:1px solid #000000; padding-top:10px;">
						Method of Payment:<br class="cl" />
						<div style="font-size:13px;">
						<strong style="color:#000000;">Credit Card:</strong> AMEX &nbsp;|&nbsp; VISA &nbsp;|&nbsp; MC &nbsp; &nbsp; <strong style="color:#000000;">Other:</strong> Cash/Check &nbsp;|&nbsp; ASB &nbsp;|&nbsp; Enerbank
						</div>
					</p>
				</div>
				<h4 style="margin-top:15px;">Basic Tax Benefits</h4>
				<table class="taxbenefits">
                                        <?php $k = $proposal['nos'];
                                              $sumtax=0;
                                             for($i=1;$i<=$k ;$i++) {
                                                 $state_tax = ($proposal['price']/$k)*.35;
                                                 if($state_tax>5000){
                                                     $state_tax=5000;
                                                 }
                                                 $sumtax+= ($state_tax)+(($proposal['price']/$k)*.3);
                                             ?>
                                                 
					<tr><td class="tdData">System #<?=$i?> (<?=$proposal['system_size']/2?> kW):</td><td class="tdData txtright"><strong>$<?=number_format($proposal['price']/$k,2) ?></strong></td></tr>
					<tr><td class="tdData">U.S. Federal Tax Credit 30%:</td><td class="tdData txtright">($<?=number_format(($proposal['price']/$k)*.3,2) ?></td></tr>
					<tr><td class="tdData">Hawaii State Tax Credit 35%:</td><td class="tdData txtright">($<?=number_format($state_tax,2) ?>)</td></tr>
					<tr><td>&nbsp;</td></tr>
                                        <?php } ?>
					<tr><td class="tdData">Total Basic Tax Credits:</td><td class="tdData txtright">($<?=number_format($sumtax,2)?>)</td></tr>
					<tr><td class="tdData"><strong>Total Net System Cost w/ Tax Benefits:</strong></td><td class="tdData txtright"><strong><?=number_format($proposal['price']-$sumtax,2);?></strong></td></tr>
					<tr><td class="tdData">Estimated Annual Savings:</td><td class="tdData txtright">$<?=number_format($pvenergyval,2)?></td></tr>
					<tr><td class="tdData">Simple Payback:</td><td class="tdData txtright"><?=$paybackyears;?> Years</td></tr>
					<tr><td class="tdData">Price Per Watt Installed</td><td class="tdData txtright"><?=number_format(($proposal['price'])/($proposal['system_size']*1000),2) ?>
					</tr>
				</table>
			</div>
			</div>
			
			<div class="cl clearfix" style="margin-top:<?=320-55*($proposal['nos']-1)?>px;">
				<div class="declaraton">Customer Agreement & Contract</div>
				<div style="border:2px solid #000000; padding:10px;" class="clearfix">
					<div class="declaratontext">
					I, the buyer, agree to purchase the goods and services described above by paying 50% deposit of the total payable upon signing of this purchase agreement and 50% upon completion.***<br class="cl" /><br class="cl" />
					Alternate Energy Inc.<br class="cl" /><br class="cl" />
					</div>
					<div class="cl">
						<div style="border-top:2px solid #000000; width:470px; float:left; padding-top:5px;">
							<div class="fl"><p style="font-family:neo sans;">Managing Employee</p></div>
							<div class="fr"><p style="font-family:neo sans;">Date: <?=date("F j, Y",strtotime($proposal['created']));?></p></div>
						</div>
						<div style="border-top:2px solid #000000; margin-left:15px; width:470px; float:left; padding-top:5px;">
							<div class="fl"><p style="font-family:neo sans;">Customer Print & Signature</p></div>
							<div class="fr"><p style="font-family:neo sans;">Date: <?=date("F j, Y",strtotime($proposal['created']));?></p></div>
						</div>
					</div>
				</div>
			</div>
		</div>
	
		<div style="padding:10px 0; margin-top:10px; border-top:0px solid #ffffff;" class="notesd">
				*Exclusions: Broken glass or any damage caused by natural causes. Any tampering or any damage caused by a Non-Alternate Energy Inc. employee voids warranties. See Alternate Energy Inc. Warranty sheet for more details. **Check with appropriate taxing authority for your tax credit eligibility. ***Customer has 3 days after signing
purchase agreement to cancel installation. Any cancellations after that is subject to a 20% restocking fee.
			</div>
	
	
	
</div>
</body>
</html>
