<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Alternate Energy</title>
<style type="text/css">
body{font-family:"Neo Sans", Arial, Helvetica, sans-serif; color:#404041; font-size:100%;}

*{margin:0; padding:0;}
.fl{float:left;}
.fr{float:right;}
.cl{clear:both;}
img{border:none;}
li{list-style:none;}
strong{font-weight:bold;}

/* FIXES */
.clearfix:after, .paginationBar:after {content: "."; display: block; height: 0px; clear: both; visibility: hidden;}
.clearfix, .paginationBar {display: inline-block;}
/* Hides from IE-mac \*/
* html .clearfix, * html .paginationBar {height: 1%;}
.clearfix{display: block;}
/* End hide from IE-mac */

.wrap{width:980px; padding:0; margin:16px auto;}

.headerPan{padding-bottom:1px; margin-bottom:11px; border-bottom:1px solid #71b644; color:#505051; position:relative;}

h1{font-style:italic; font-weight:lighter; font-size:2.09em; margin:54px 0 15px 0; color:#000000; padding-bottom:5px; border-bottom:2px solid #71b644; position:absolute; font-family:neo sans light;}
.datePan{font-size:0.9em; margin-bottom:43px;}
.datePan strong{font-weight:bold;}

h2{font-size:21px; font-style:normal; margin:0 0 4px 0; padding-bottom:5px; color:#414142; border-bottom:1px solid #3f3f40;}
p{font-size:1em; font-weight:lighter; padding:3px 0; line-height: 135%; color:#414142; font-family:neo sans light;}
.notes{font-size:12px; font-weight:lighter; padding:10px 0; margin-top:10px; line-height:150%; color:#414142; border-top:1px solid #404041;}

ul li{font-size:16px; font-weight:normal;}
ul li strong{font-weight:bold;}

h3{font-size:18px; font-weight:normal; margin:0 0 5px 0; padding-bottom:5px; color:#414142; border-bottom:1px solid #848485;}
.catlt{font-size:13px; font-weight:normal; padding:10px 0 20px 0; line-height:120%; color:#414142;}
.footeraddress{font-size:11px; line-height:150%; font-weight:normal; border-left:1px solid #71b644; padding:0 10px; margin:0 10px;}

h4{font-size:18px; font-weight:bold; margin:0 0 5px 0; padding-bottom:5px; color:#414142; border-bottom:1px solid #404041;}

.secondp{line-height:150%;}

.taxbenefits, .graphtable{border-collapse:collapse; width:100%;}
.tdData{border:none; font-size:15px; font-weight:lighter; padding:3px; color:#414142;}
.txtright{text-align:right;}
td strong{color:#000000;}

.graphtable td {padding:3px 0 3px 9px; color:#414142; font-weight:lighter; font-size:1em; font-family:neo sans light;}
.graphtable th{border-bottom:1px solid #000000; font-weight:lighter; font-size:1em; text-align:left; padding:3px; font-family:neo sans light; color:#414142;}
.declaraton{font-size:18px; font-weight:bold; padding-bottom:5px; color:#414142;}

ol.leftnumbers{float:left;}
ol.leftnumbers li{list-style:none; text-align:right; margin:10px 0 0 0; font-size:0.7em;}

.chatdiagram{border-collapse:collapse; height:235px;}

ol.graphdata li, ol.graphmonth li{list-style:none; display:inline-block; padding:1px; margin:0 6px; width:15px; font-size:0.8em; text-align:center;}
ol.graphdata li{background-color:#6fb446; font-size:0; color:transparent; vertical-align:bottom;}

.module{padding-top:10px;}

.top15{padding-top:15px;}

.break { page-break-before: always; }
</style>
</head>

<body>
<div class="wrap">
	<div class="headerPan clearfix">
	<h1 class="fl">Photovoltaic System Summary</h1>
	<img src="images/logo.png" class="fr" />
	</div>
	<div class="clearfix">
		<div class="datePan"><strong>March 12, 2012 / Quote No.</strong> <?=$proposal['id']?> / Photovoltaic Proposal Page 1</div>
	</div>
		
		<div style="font-family:neo sans light;">
			<div class="fl" style="width:470px;">
				<h2>Type of Modules: Mitsubishi Electric</h2>
				<p class="class">
					<img src="images/Mitsubishi-Electric-logo.png" class="fl" />
					Mitsubishi Electric is a global leader in providing superior-quality photovoltaic modules to businesses and residences around the world. With more than 37 years experience in the photovoltaic industry, we manufacture products that are designed and built for optimal efficiency and reliability. With a name like Mitsubishi Electric, you can be sure you�re getting the best.
				</p>
				<ul class="module">
					<li><strong>Module Type:</strong> 255W PV-MLU255HC</li>
					<li><strong>Manufacturer Warranty:</strong> 25 Years</li>
				</ul>
			</div>
			<img src="images/Mitsubishi-Electric.png" class="fr" />
		</div>
		<br/>
		<div class="clearfix cl" style="border-top:2px dashed #848485; font-family:neo sans light; margin-top:5px; padding:34px 0 5px 0;">
			<div class="fl" style="width:470px;">
				<h2>Type of Inverter: Enphase Microinveter</h2>
				<p>
					<img src="images/Enphase-Microinveter-logo.png" class="fl" />
					The Enphase Energy Microinverter System improves energy harvest,
increases reliability, and dramatically
simplifies design, installation and management of solar power systems. The Enphase System includes the microinverter, the Envoy Communications Gateway, and Enlighten, Enphase�s monitoring and analysis software.
				</p>
				<ul class="module">
					<li><strong>Inverter Type:</strong> M215</li> 
					<li><strong>Manufacturer Warranty:</strong> 25 Years</li>
				</ul>
			</div>
			<img src="images/Enphase-Microinveter.png" class="fr" /><br/>
		</div>
	
	<div class="clearfix cl" style="border-top:2px dashed #848485; font-family:neo sans light; margin-top:5px; padding:29px 0;">
			<div class="fl" style="width:310px;">
				<h3>Module Racking System</h3>
				<div class="catlt clearfix">
				<img src="images/Module-Racking-System.jpg" class="fr" />
				IronRidge Solar Roof Racking accommodate some of the longest spans in the industry, reducing the number of roof attachments and saving time and money <br class="cl"/>
				</div>
			</div>
			<div class="fl" style="width:310px; margin-left:20px;">
				<h3>Roof Flashing</h3>
				<div class="catlt clearfix">
				<img src="images/Roof-Flashing.jpg"  class="fr" />
				Alternate Energy Inc.'s custom panel roof mount and flashing systems are leak tested to an equivalent pressure of 70 feet of standing water so you can be sure your roof penetrations remain watertight under
the most adverse conditions.
				</div>
			</div>
			<div class="fl" style="width:310px; margin-left:20px;">
				<h3>Hardware & Accessories</h3>
				<div class="catlt clearfix">
				<img src="images/Hardware-Accessories.jpg" class="fr" />
				The hardware like nuts and bolts used in our installations are all stainless steel. This is to ensure a long lasting installation and foundation for your photovoltaic system.
				</div>
			</div>
	</div>
	
	<div class="cl clearfix" style="margin:10px 0; padding:20px 0;">
		<div class="footeraddress fl">
			<strong>Oahu</strong> / Alternate Energy Inc. <br class="cl"/>
			96-1276 Waihona St #124, Pearl City, HI 96782 <br class="cl"/>
			<em>phone</em> 808 842 5853 <em>fax</em> 808 847 7594
		</div>
		<div class="footeraddress fl">
			<strong>Maui</strong> / Alternate Energy Inc.<br class="cl"/>
			60 East Wakea Avenue #109, Kahului, HI 96732<br class="cl"/>
			<em>phone</em> 808 872 9592 <em>fax</em> 808 871 9418
		</div>
		<div class="footeraddress fr">
			<em>email</em> sales@alternateenergyhawaii.com<br class="cl"/>
			<em>web</em> www.AlternateEnergyHawaii.com<br class="cl"/>
			<em>license no.</em> C-26041
		</div>
	</div>
</div>

<div class="wrap break">
	<div class="headerPan clearfix">
	<h1 class="fl" style="margin-top:48px;">PV WATTS<sup>TM</sup> Power Production Estimate</h1>
	<img src="images/logo.png" class="fr" />
	</div>
	<div class="clearfix">
		<div class="datePan"><strong>March 12, 2012 / Quote No.</strong> <?=$proposal['id']?>/ Photovoltaic Proposal Page 2</div>
	</div>
		
		<div class="clearfix">
			<div class="fl" style="width:470px;">
				<h4>Customer Details</h4>
				<p class="secondp">
					Current Energy Usage: 934 kWh <br class="cl" />
					Energy Offset Due to PV System: 85%	<br class="cl" /> 
					Street Address: <?=$proposal['address']?> <br class="cl" />
					City:  <?=$proposal['city']?>, Zip Code:  <?=$proposal['zip']?>, State:  <?=$proposal['state']?> <br class="cl" />
					Latitude/Longitude:  <?=$proposal['lat']?>N/  <?=$proposal['long']?> W<br class="cl" />
				</p>
			
				<h4 class="top15">PV System Specifications</h4>
				<p class="secondp">
					Module Type: Mitsubishi PV-MLU255HC <br class="cl" />
					Number of Modules: 24<br class="cl" />
					System Size (DC Rating): 4.0 kW<br class="cl" />
					DC to AC Derate Factor: 0.80<br class="cl" />
					Array Azimuth (Orientation): 180.0�<br class="cl" />
				</p>
				
				<h4 class="top15">Energy Savings</h4>
				<p class="secondp">
					Utility Rate: 36 �/kWh<br class="cl" />
					Annual Power Production: 2,234 kWh<br class="cl" />
					Annual Energy Savings ($): $2,433 / Year<br class="cl" />
					Average Monthly Savings: $130/ Month<br class="cl" />
					Payback Period: 4.6 Years<br class="cl" />
				</p>
				
				<h4 class="top15">Lifetime Savings</h4>
				<p class="secondp">
					Upfront Investment Cost: $34,334<br class="cl" />
					Return On Investment (ROI): 22.5 % (w/ Tax Credits)<br class="cl" />
					Return On Investment (ROI): 12 % (w/o Tax Credits)<br class="cl" />
					First Month Savings: $234<br class="cl" />
					New Utility Bill: $18<br class="cl" />
					Lifetime Savings: $235,543<br class="cl" />
				</p>
				
				<div class="notes">
					* Alternate Energy Inc�s energy production estimates use the National Renewable
Energy Laboratory�s (NREL) PVWattsTM calculator. It determines the energy production and cost savings of grid-connected photovoltaic (PV) energy systems throughout the world. It allows homeowners, installers, manufacturers, and researchers to easily develop estimates of the performance of hypothetical PV installations. The PVWatts calculator was developed by NREL�s Electricity, Resources, and Building Systems Integration Center.
				</div>
			</div>
			
			<div class="fr">
				<div class="declaraton">PV WATTS<sup>TM</sup> Monthly Production Estimates*</div>
				<div style="width:472px; float:right;">
					<div style="border:3px solid #000000; padding:10px 10px 15px 10px;" class="clearfix">
					<div class="graphchatTable">
						<img src="images/chat-left.png" class="fl" />
						<ol class="leftnumbers">
							<li>600</li>
							<li>500</li>
							<li>400</li>
							<li>500</li>
							<li>400</li>
							<li>300</li>
							<li>200</li>
							<li>100</li>
							<li>0</li>
						</ol>
						<table class="chatdiagram">
							<tr>
								<td valign="bottom" style="vertical-align:bottom;">
									<ol class="graphdata cl">
										<? foreach($proposal_month as $pmd){?>
                                                                                <li class="<?=strtolower($pmd['month'])?>" style="height:<?=$pmd['acenergy']/100?>;"><?=strtoupper($pmd['month'][0])?></li>
                                                                               <? }?>
									</ol>
									<ol class="graphmonth cl">
										<li>J</li>
										<li>F</li>
										<li>M</li>
										<li>A</li>
										<li>M</li>
										<li>J</li>
										<li>J</li>
										<li>A</li>
										<li>S</li>
										<li>O</li>
										<li>N</li>
										<li>D</li>
									</ol>
								</td>
							</tr>
						</table>
						<div class="cl" style="display:block; text-align:center; padding-bottom:15px;">
							MONTHS(2011)
						</div>
					</div>
					<table class="graphtable">
						<tr><th>Month</th><th>Sun Hours</th><th>Energy (kWh)</th><th>Energy Value</th></tr>
						<? 
                                                $startmo =0;
                                                $solorsum = 0;
                                                $pvsumenergy =0;
                                                $pvenergyval =0;
                                                foreach($proposal_month as $pvenergy) {
                                                    $startmo+=1;
                                                    $solorsum += $pvenergy['solar'];
                                                    $pvsumenergy +=$pvenergy['acenergy'];
                                                    $pvenergyval +=$pvenergy['acenergy']*.36;
                                                ?>
                                                <tr>
						<td><?=$startmo;?></td>
						<td><?=$pvenergy['solar']?></td>
						<td><?=$pvenergy['acenergy']?></td>
						<td><?=$pvenergy['acenergy']*.36?></td>
						</tr>
                                                <? } ?>
						
						<tr style="border-top:1px solid #000;">
						<td>Year</td>
						<td><?=$solorsum/12?></td>
						<td><?=$pvsumenergy?></td>
						<td><?=$pvenergyval?></td>
						</tr>
					</table>
					</div>
				</div>
			</div>
			
		</div>
	
		
	
	
	<div class="cl clearfix" style="margin:10px 0; padding:20px 0;">
		<div class="footeraddress fl">
			<strong>Oahu</strong> / Alternate Energy Inc. <br class="cl"/>
			96-1276 Waihona St #124, Pearl City, HI 96782 <br class="cl"/>
			<em>phone</em> 808 842 5853 <em>fax</em> 808 847 7594
		</div>
		<div class="footeraddress fl">
			<strong>Maui</strong> / Alternate Energy Inc.<br class="cl"/>
			60 East Wakea Avenue #109, Kahului, HI 96732<br class="cl"/>
			<em>phone</em> 808 872 9592 <em>fax</em> 808 871 9418
		</div>
		<div class="footeraddress fr">
			<em>email</em> sales@alternateenergyhawaii.com<br class="cl"/>
			<em>web</em> www.AlternateEnergyHawaii.com<br class="cl"/>
			<em>license no.</em> C-26041
		</div>
	</div>
</div>

<div class="wrap break">
	<div class="headerPan clearfix">
	<h1 class="fl">Tax Invoice - Purchase Agreement</h1>
	<img src="images/logo.png" class="fr" />
	</div>
	<div class="clearfix">
		<div class="datePan"><strong>March 12, 2012 / Quote No.</strong>  <?=$proposal['id']?> / Photovoltaic Proposal Page 3</div>
	</div>
		
		<div class="clearfix">
			<div class="clearfix">
			<div class="fl" style="width:470px;">
				<h4>Customer Details</h4>
				<p class="secondp">
					Name: <?=ucfirst($proposal['dpp_firstname'])?> <?=ucfirst($proposal['dpp_lastname'])?> <br class="cl" />
					Street Address: <?=$proposal['address']?> <br class="cl" />
					City: <?=$proposal['id']?> , Zip Code: <?=$proposal['id']?> , State: <?=$proposal['id']?> <br class="cl" />
					Phone: 466-5654, Secondary Phone: 544-4454<br class="cl" />
					Email: john@alternateenergyhawaii.com<br class="cl" />
				</p>
			
				<h4 class="top15">PV System Specifications</h4>
				<p class="secondp">
					Module Type: Mitsubishi PV-MLU255HC<br class="cl" />
					Number of Modules: 24<br class="cl" />
					System Size (DC Rating): 6.12 kW<br class="cl" />
					Inverter Type: SMA SunnyBoy HF2500<br class="cl" />
					Number of Inverters: 1<br class="cl" />
					Number of Systems: 2<br class="cl" />
					Addtional Requirements/Note: Lorem ipsum dolor sit amet, consectetur adipiscing elit. Nulla ornare fringilla elementum.<br class="cl" />
					In sollicitudin arcu vel massa semper eget lobortis enim tempor.<br class="cl" />
				</p>
			</div>
			
			<div class="fr" style="width:472px;">
				<div class="declaraton">AEI�s Premium PV System Cost</div>
				<div style="border:3px solid #000000; padding:10px;" class="clearfix">
				<table class="taxbenefits">
					<tr><td class="tdData">System Price:</td><td class="tdData txtright"><strong> $<? echo $cal =($proposal['price']*104.712)/100?></strong></td></tr>
					<tr><td class="tdData">General Excise Tax (4.712%):</td><td class="tdData txtright"><strong><?=$cal*4.712/100?>$1,395.21</strong></td></tr>
					<tr><td class="tdData">Total Payable:</td><td class="tdData txtright"><strong>$<?=$proposal['price']?></strong></td></tr>
				</table>
					<p style="border-top:1px solid #000000; padding-top:10px;">
						Method of Payment:<br class="cl" />
						<div style="font-size:13px;">
						<strong style="color:#000000;">Credit Card:</strong> AMEX | VISA | MC &nbsp; &nbsp; <strong style="color:#000000;">Other:</strong> Cash/Check | ASB | Enerbank
						</div>
					</p>
				</div>
				<h4 style="margin-top:15px;">Basic Tax Benefits</h4>
				<table class="taxbenefits">
					<tr><td class="tdData">System #1 (3.12 kW):</td><td class="tdData txtright"><strong>$15,508.75</strong></td></tr>
					<tr><td class="tdData">U.S. Federal Tax Credit 30%:</td><td class="tdData txtright">($4,652.63)</td></tr>
					<tr><td class="tdData">Hawaii State Tax Credit 35%:</td><td class="tdData txtright">($5,000.00)</td></tr>
					<tr><td>&nbsp;</td></tr>
					<tr><td class="tdData">System #2 (3.12 kW):</td><td class="tdData txtright"><strong>$15,508.75</strong></td></tr>
					<tr><td class="tdData">U.S. Federal Tax Credit 30%**:</td><td class="tdData txtright">($4,652.63)</td></tr>
					<tr><td class="tdData">Hawaii State Tax Credit 35%**:</td><td class="tdData txtright">($5,000.00)</td></tr>
					<tr><td>&nbsp;</td></tr>
					<tr><td class="tdData">Total Basic Tax Credits:</td><td class="tdData txtright">($19,305.25)</td></tr>
					<tr><td class="tdData"><strong>Total Net System Cost w/ Tax Benefits:</strong></td><td class="tdData txtright"><strong>$11,712.25</strong></td></tr>
					<tr><td class="tdData">PV WATTSTM Estimated Annual Savings:</td><td class="tdData txtright">$3,210.72</td></tr>
					<tr><td class="tdData">Simple Payback:</td><td class="tdData txtright">4.34 Years</td></tr>
					<tr><td class="tdData">Price Per Watt Installed</td><td class="tdData txtright">$5.34/W</td></tr>
				</table>
			</div>
			</div>
			
			<div class="cl clearfix" style="margin-top:20px;">
				<div class="declaraton">Customer Agreement & Contract</div>
				<div style="border:2px solid #000000; padding:10px;" class="clearfix">
					<div class="declaraton">
					I, the buyer, agree to purchase the goods and services described above by paying 50% deposit of the total payable upon signing of this purchase agreement and 50% upon completion.***<br class="cl" /><br class="cl" />
					Alternate Energy Inc.<br class="cl" /><br class="cl" />
					</div>
					<div class="cl">
						<div style="border-top:2px solid #000000; width:470px; float:left; padding-top:5px;">
							<div class="fl"><p>Managing Employee</p></div>
							<div class="fr"><p>Date: March 29, 2012</p></div>
						</div>
						<div style="border-top:2px solid #000000; margin-left:15px; width:470px; float:left; padding-top:5px;">
							<div class="fl"><p>Customer Print & Signature</p></div>
							<div class="fr"><p>Date: March 29, 2012</p></div>
						</div>
					</div>
				</div>
			</div>
		</div>
	
		<div style="padding:10px 0; margin-top:10px; border-top:1px solid #000000;" class="notes">
				*Exclusions: Broken glass or any damage caused by natural causes. Any tampering or any damage caused by a Non-Alternate Energy Inc. employee voids warranties. See Alternate Energy Inc. Warranty sheet for more details. **Check with appropriate taxing authority for your tax credit eligibility. ***Customer has 3 days after signing
purchase agreement to cancel installation. Any cancellations after that is subject to a 20% restocking fee.
			</div>
	
	
	<div class="cl clearfix" style="margin:10px 0; padding:20px 0;">
		<div class="footeraddress fl">
			<strong>Oahu</strong> / Alternate Energy Inc. <br class="cl"/>
			96-1276 Waihona St #124, Pearl City, HI 96782 <br class="cl"/>
			<em>phone</em> 808 842 5853 <em>fax</em> 808 847 7594
		</div>
		<div class="footeraddress fl">
			<strong>Maui</strong> / Alternate Energy Inc.<br class="cl"/>
			60 East Wakea Avenue #109, Kahului, HI 96732<br class="cl"/>
			<em>phone</em> 808 872 9592 <em>fax</em> 808 871 9418
		</div>
		<div class="footeraddress fr">
			<em>email</em> sales@alternateenergyhawaii.com<br class="cl"/>
			<em>web</em> www.AlternateEnergyHawaii.com<br class="cl"/>
			<em>license no.</em> C-26041
		</div>
	</div>
</div>
</body>
</html>
