<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
<title>Alternate Energy</title>
<style type="text/css">
body{font-family:"Neo Sans", Arial, Helvetica, sans-serif; color:#404041; font-size:100%;}

*{margin:0; padding:0;}
.fl{float:left;}
.fr{float:right;}
.cl{clear:both;}
img{border:none;}
li{list-style:none;}
strong{font-weight:bold;}

/* FIXES */
.clearfix:after, .paginationBar:after {content: "."; display: block; height: 0px; clear: both; visibility: hidden;}
.clearfix, .paginationBar {display: inline-block;}
/* Hides from IE-mac \*/
* html .clearfix, * html .paginationBar {height: 1%;}
.clearfix{display: block;}
/* End hide from IE-mac */

.wrap{width:980px; padding:0; margin:16px auto;}

.headerPan{padding-bottom:1px; margin-bottom:11px; border-bottom:1px solid #71b644; color:#505051; position:relative;}

h1{font-style:italic; font-weight:lighter; font-size:38px; margin:44px 0 15px 0; color:#414142; padding-bottom:8px; border-bottom:1px solid #71b644; position:absolute; font-family:neo sans light;}
.datePan{font:16px neo sans; white-space:0.01em; margin-bottom:43px; color:#414142;}
.datePan strong{font-weight:bold;}

h5{font-style:italic; font-weight:lighter; font-size:30px; margin:50px 0 50px 0; color:#414142; padding-bottom:8px; font-family:neo sans light;}

h2, h4{font-size:20px; font-style:normal; font-family:neo sans; font-weight:bold; margin:0 0 4px 0; letter-spacing:normal; padding-bottom:5px; color:#414142; border-bottom:1px solid #848485;}

/*
h4{font-size:19px; font-family:neo sans; font-weight:bold; margin:0 0 5px 0; padding-bottom:5px; color:#414142; border-bottom:1px solid #848485;}
*/


p, p.secondp{font-size:17px; font-weight:normal; padding:3px 0; line-height: 135%; color:#414142; font-family:neo sans light;}

/*p.secondp{font-size:17px; font-weight:400; padding:3px 0; line-height: 150%; color:#414142; font-family:neo sans light;}*/

.notes{font-size:13px; font-weight:lighter; font-family:neo sans light; padding:10px 0; margin-top:10px; line-height:150%; color:#6d6e71; border-top:1px solid #404041;}
.notesd{font-size:14px; font-weight:lighter; font-family:neo sans light; padding:10px 0; margin-top:15px; line-height:150%; color:#6d6e71; border-top:1px solid #404041;}


ul li{font-size:16px; font-weight:normal;}
ul li strong{font-weight:bold;}

h3{font-size:18px; font-family:neo sans; font-weight:bold; margin:0 0 5px 0; padding-bottom:5px; color:#414142; border-bottom:1px solid #848485;}
.catlt{font-size:15px; font-weight:normal; padding:10px 0 20px 0; line-height:150%; color:#414142;}
.footeraddress{font-size:11px; line-height:150%; font-weight:normal; border-left:1px solid #71b644; padding:0 10px; margin:0 10px;}

.taxbenefits{border-collapse:collapse; width:100%;}
/*.tdData{border:none; font-size:15px; font-weight:lighter; padding:3px; color:#414142;}*/
.tdData{font-size:17px; font-weight:normal; padding:3px; color:#414142; font-family:neo sans light;}
.txtright{text-align:right;}
td strong{color:#000000;}

.graphtable{border-collapse:collapse; width:96%; margin:0 auto;}

.graphtable td {padding:3px 0 3px 15px; color:#414142; font-weight:lighter; font-size:1em; font-family:neo sans light;}
.graphtable th{border-bottom:1px solid #000000; font-weight:lighter; font-size:1em; text-align:left; padding:3px 0 3px 15px; font-family:neo sans light; color:#414142;}
.declaraton{font-size:20px; font-weight:bold; font-family:neo sans; padding-bottom:5px; letter-spacing:normal; color:#414142;}
.declaratontext{font-size:20px; font-weight:bold; font-family:neo sans; letter-spacing:normal; color:#414142;}

ol.leftnumbers{float:left;}
ol.leftnumbers li{list-style:none; text-align:right; margin:20px 0 0 0; font-size:0.7em;}

.chatdiagram{border-collapse:collapse;}

ol.graphdata li, ol.graphmonth li{list-style:none; display:inline-block; padding:1px; margin:0 6px; width:15px; font-size:0.8em; text-align:center;}
ol.graphdata li{background-color:#6fb446; font-size:0; color:transparent; vertical-align:bottom;}

.module{padding-top:10px; font-family:neo sans; font-weight:lighter;}
.module strong{font-weight:bold;}

.top15{padding-top:15px;}

.graphData{background-color: #6FB446;}
.monthD{width:15px; text-align:center; font-size:11px;}
.listN{font-size:11px; text-align:right; height:25px; vertical-align:bottom;}

.salesmandtl{font-size:11px; line-height:150%; font-weight:normal; padding:0 5px; margin:0 5px;}

.greenbox{background-color:#71B644; padding:20px; color:#ffffff; width:250px; margin-top:30px; font-size:17px; font-weight:normal; line-height:150%; font-family:neo sans light;}

.rightalign{text-align:right;}

table.dataTable{border-collapse:collapse; width:100%;}
table.dataTable td{padding:5px; font-size:17px; font-weight:normal; color:#414142; font-family:neo sans light;}
table.dataTable tr.altBg td{background-color:#e7e5e4}

table.threecolumn{border-collapse:collapse; width:100%;}
table.threecolumn h4{border-bottom:none; padding-bottom:0px !important;}

table.threecolumn p{padding-bottom:25px !important; line-height:150% !important;}

table.dataTable strong, p strong{font-size:16px; font-family:neo sans; font-weight:bold; color:#414142;}

.break { page-break-before: always; }
</style>
</head>

<body>

<div class="wrap">
	<div class="clearfix cl">
		<div class="fl" style="padding-top:20px;">
                       <? if(@$sales_user['profile_photo']) {
                           $img_path = thumbnail($sales_user['profile_photo'], 67, 55);
                          // if(@file_exists($img_path)){
                           ?>
			<img src="<?=$img_path;?>" class="fl" style="width:67px; margin-top:7px;" />
                        <? }//} ?>
			<div class="salesmandtl fl" style="font-size:14px; margin-top:2px">
				<strong>Prepared By:</strong> <?=ucfirst(@$sales_user['first_name'])?> <?=ucfirst(@$sales_user['last_name']);?><br/>
				<strong>Phone:</strong> <?=@$sales_user['phone'];?><br/>
				<strong>Email:</strong> <?=@$sales_user['email'];?>
			</div>
		</div>
		<img src="<?=base_url()?>assets/pdfimages/logo.png" class="fr" />
	</div>

	<div class="headerPan clearfix" style="margin-top:350px;">
	<h1 class="fl" ><?=round($proposal['system_size'],2)?>kw Residential Photovoltaic System</h1>
	<div style="height:98px;"></div>
	</div>
    <div class="clearfix">
		<div class="datePan"><strong><?=date("F j, Y",strtotime($proposal['created']));?> / Quote No.</strong> <?=$proposal['id']?> / <?=$proposal['address']?>, <?=$proposal['city']?>, Hawaii</div>
	
	</div>
</div>
<?
                                          $startmo =0;
                                          $solorsum = 0;
                                          $pvsumenergy =0;
                                          $pvenergyval =0;
                                          $first_month_cal=false;
                                          $first_month_sav =234;
                                          $pvenergy_g = array();
                                          $sun_hours_g = array();
                                          foreach($proposal_month as $pvenergy) {
                                             if($pvenergy['month']=='Year') continue;
                                            if (!$first_month_cal)  {
                                                $first_month_sav = ($proposal['ceu']-$pvenergy['acenergy'])*$proposal["electriccost"];
                                            }
                                            $solorsum += $pvenergy['solar'];
                                            $pvsumenergy +=$pvenergy['acenergy'];
                                            $pvenergyval +=$pvenergy['costsaved'];
                                            $pvenergy_g[] = $pvenergy['acenergy'];
                                            $sun_hours_g[$pvenergy['acenergy']]=$pvenergy['solar'];
                                          }
                                            $k = $proposal['nos'];
                                              $sumtax=0;
                                             for($i=1;$i<=$k ;$i++) {
                                                 $state_tax = ($proposal['price']/$k)*.35;
                                                 if($state_tax>5000){
                                                     $state_tax=5000;
                                                 }
                                                 $sumtax+= ($state_tax)+(($proposal['price']/$k)*.3);
                                             }
                                           $paybackyears = round(($proposal['price']-$sumtax)/$pvenergyval,2);
                                           $max_pvenergy_g = max($pvenergy_g);
                                           $max_sun_hours=$sun_hours_g[$max_pvenergy_g];
                                           $divdedby=100;
                                           $per = 1;
                                           if($max_pvenergy_g>700 && $max_pvenergy_g<=1000){
                                            $divdedby=150;
                                            $per=.66;
                                           }else if($max_pvenergy_g>1000 && $max_pvenergy_g<2000){
                                            $divdedby=200;
                                            $per=.5;
                                           }else if($max_pvenergy_g>2000){
                                            $divdedby=300;
                                            $per=.33;
                                           }
                                           $grpah_m = ceil($max_pvenergy_g/$divdedby);
                                           $supler= number_format(($pvsumenergy*5.3/1000)*2.204622622,2);
                                           $carbon= number_format(($pvsumenergy*1.6/1000)*2.204622622,2);
                                           $nitrogen= number_format(($pvsumenergy*2.8/1000)*2.204622622,2);
                                       ?>
<div class="wrap break">
	<div class="headerPan clearfix">
	<h1 class="fl" style="color:#ffffff;">Residential Photovoltaic System</h1>
	<img src="<?=base_url()?>assets/pdfimages/logo.png" class="fr" />
	</div>
    <div class="clearfix">
		<div class="datePan"><strong><?=date("F j, Y",strtotime($proposal['created']));?> / Quote No.</strong> <?=$proposal['id']?> / Photovoltaic Proposal Page 2</div>
	
	</div>
    
    <h5>Introduction</h5>
	<table class="threecolumn">
		<tr>
			<td width="30%" valign="top">
				<h4>Congratulations</h4>
				<p>
				Welcome to Alternative Energy Inc's.
				Energy Analysis and Proposal for a grid
				tied photovoltaic system to be considered
				for the <strong> <?=$proposal['dpp_lastname']?>'s </strong>
				residence of <strong><?=$proposal['address']?></strong>. The
				purpose of this document is to illustrate
				the advantages for you, your household
				and the environment by installing a gridtied
				photovoltaic system with Alternate
				Energy Inc.
				</p>

				<h4>Three Generations</h4>
				<p>
				Alternate Energy Inc. (AEI) is a familyowned
				and operated business with a long
				history of serving kamaaina. More than 30
				years ago, Bruce Ekimura, a plumber by
				trade, realized that harnessing the power
				of the sun could help Hawaii families
				combat the rising price of electricity and
				help our state become less dependent on
				imported oil. Bruce and his father became
				early specialists in the installation of solar
				hot water heaters, and later photovoltaic
				(PV) systems, and in 1993 Alternate
				Energy was officially incorporated.
				</p>
			</td>
			<td width="5%">&nbsp;</td>
			<td width="30%" valign="top">
				<p>
				Today, as rising oil prices continue to keep
				electricity rates soaring, Alternate Energy
				remains committed to helping local families
				and businesses discover the clean, green,
				moneysaving power of the sun.
				</p>

				<h4>Elite Dealer</h4>
				<p class="clearfix;">
				Alternate Energy Inc. recently achieved
				the status of Mitsubishi Electric's first
				Nationally recognized Elite Dealer for
				solar PV. This means that we are Certified
				and trusted by
				Mitsubishi Electric
				to sell and install
				its premium
				<img src="<?=base_url()?>assets/pdfimages/Elite-Dealer.jpg" class="fr" style="width:150px;" />
				monocrystalline solar panels in Hawaii.
				</p>
				
				<h4 class="cl">Elite Training & Certification</h4>
				<p>
				All of our highly skilled solar technicians
				are employees (not subcontractors)
				annually Trained and Certified by
				Mitsubishi Electric to design, install and
				service all of your PV needs.
				</p>
			</td>
			<td width="5%">&nbsp;</td>
			<td width="30%" valign="top">
				<h4>Elite Products</h4>
				<p>
				We understand that photovoltaic systems
				are a long term investment. That's why
				we invest in the most reliable companies
				that have been trusted for years.
				Mitsubishi Electric's premium solar panels
				are made 100% in Japan where quality is a
				high standard.
				</p>

				<p>
				The solar panels are also designed and
				warrantied for installations near salt
				water for long lasting performance.
				</p>

				<h4>Elite Service</h4>
				<p>
				Being family-owned and operated, we
				take pride in every job and make sure each
				customer is satisfi ed, every time. We are
				Hawaii's expert solar company since 1993.
				</p>

				<div class="greenbox fl">
					This system will prevent <?=$supler;?><br />
					lbs sulfur dioxide (causes<br />
					acid rain) from being released<br />
					into Hawaii's rainforests.
				</div>
			</td>
		</tr>
	</table>
</div>


 
                                       
<div class="wrap break">
	<div class="headerPan clearfix">
	<h1 class="fl">Power Production Estimate</h1>
	<img src="<?=base_url()?>assets/pdfimages/logo.png" class="fr" />
	</div>
	<div class="clearfix">
		<div class="datePan"><strong><?=date("F j, Y",strtotime($proposal['created']));?> / Quote No.</strong> <?=$proposal['id']?> / Photovoltaic Proposal Page 3</div>
	
	</div>
    
    <div class="clearfix">
		<div class="fl" style="width:480px;">
        	<h4>Customer Details</h4>
            <table class="dataTable">
            	<tr>
                	<td>
            			Current Average Usage:
                    </td>
                    <td class="rightalign"><?=$proposal['ceu']?>kWh</td>
                </tr>
                <tr class="altBg">
                	<td>
						Current Utility Bill:
                    </td>    
					<td class="rightalign">$ <?=number_format($proposal['ceu']*$proposal["electriccost"]/100,2);?></td>
				</tr>
                <tr>
                	<td>
						Solar Sunshine Zone:
                    </td>    
					<td class="rightalign"><?=$proposal['avgzoneenergy']?></td>
				</tr>
                <tr class="altBg">
                	<td>
						Peak Sun Hours for Production:
                    </td>    
					<td class="rightalign"><?=$max_sun_hours?>hrs</td>
				</tr>
				<tr>
                	<td>
						Current Utility Rate:
                    </td>
                    <td class="rightalign"><?=$proposal["electriccost"]?> c/kWh</td>
				</tr>
            </table>
            
            <h4 style="margin-top:20px;">PV System Specifications</h4>
            <table class="dataTable">
            	<tr>
                    <td>System Size (DC Rating):</td><td class="rightalign"><?=$proposal['system_size']?>kW</td>
				</tr>
                <tr class="altBg">	
                    <td>DC to AC Derate Factor:</td><td class="rightalign"><?=$proposal['dctoacderate']?></td>
                </tr>
                <tr>    
                    <td>System Size (AC Rating):</td><td class="rightalign"><?=number_format($proposal['system_size']*$proposal['dctoacderate'],2)?> kW</td>
                </tr>
                <tr class="altBg">    
                    <td>Module Type:</td><td class="rightalign"><?=$qoute_mws[$proposal['module_type']]?></td>
                </tr>
                <tr>    
                    <td>Number of Modules:</td><td class="rightalign"><?=$proposal['nom']?></td>
                </tr>
                <tr class="altBg">    
                    <td>Module Power:</td><td class="rightalign"><?if($proposal['module_type']==1) echo "255"; if($proposal['module_type']==2) echo '225';?>W</td>
                </tr>
                <tr>    
                    <td>Module Dimensions:</td><td class="rightalign">40.1" x 63"</td>
                </tr>
                <tr class="altBg">    
                    <td>Inverter Type:</td><td class="rightalign"><?=$qoute_iws[$proposal['invertert']]?></td>
                </tr>
                <tr>    
                    <td>Array Azimuth (Orientation):</td><td class="rightalign"><?=$proposal['arrayazimuth']?></td>
                </tr>   
                <tr class="altBg">
                    <td>Roof Tilt:</td><td class="rightalign">22</td>
                </tr>
                <tr>
                	<td colspan="2">
                    	<?=$proposal["add_requirement"]?>
					</td>    
                </tr>
            </table>
            
            <h4 style="margin-top:20px;">Energy Production & Savings</h4>
            <table class="dataTable">
            	<tr>
                	<td>New Average Usage (kWh):</td><td class="rightalign"><?=number_format(($proposal['ceu'])-($pvsumenergy/12),2) ?>kW / Month</td>
				</tr>
                <tr class="altBg">
                    <td>New Estimated Utility Bill ($):</td><td class="rightalign"><?=number_format((($proposal['ceu'])-($pvsumenergy/12))*$proposal["electriccost"]/1000,2);?></td>
                </tr>
                <tr>
                    <td>Energy Offset Due to PV System:</td><td class="rightalign"><?=round(($proposal['ceu']/$pvsumenergy)*12*100,2)?>%</td>
                </tr>
                <tr class="altBg">    
                    <td>Monthly Energy Production (kWh):</td><td class="rightalign"><?=number_format($pvsumenergy/12,2)?> kW / Month</td>
                </tr>
                <tr>    
                    <td>Monthly Average Savings ($):</td><td class="rightalign">$<?=round($pvenergyval/12);?> / Month</td>
                </tr>
                <tr class="altBg">    
                    <td>Annual Average Production (kWh):</td><td class="rightalign"><?=number_format($pvsumenergy,2);?> kW / Year</td>
                </tr>
                <tr>    
                    <td>Estimated Annual Savings ($):</td><td class="rightalign">$<?=number_format($pvenergyval,2);?> / Year</td>
                </tr>
                <tr class="altBg">    
                    <td>Average Monthly Savings:</td><td class="rightalign">$<?=number_format($pvenergyval/12,2);?> / Month</td>
                </tr>
                <tr>    
                    <td>Payback Period:</td><td class="rightalign"><?=$paybackyears;?> Years</td>
                </tr>    
            </table>
        </div>
<!-- graph section -->        
        <div class="fr">
				<div class="declaraton">Monthly Production Estimates*</div>
				<div style="width:472px; float:right;">
					<div style="border:3px solid #000000; padding:10px 10px 15px 10px;" class="clearfix">
					<div class="graphchatTable">
						<table>
							<tr>
								<td valign="middle"><img src="<?=base_url()?>assets/pdfimages/chat-left.png" /></td>
								<td>
									<table width="420" cellpadding="0" cellspacing="10" border="0">
									  <tr>
										<td class="listN" width="20"><?=$grpah_m*$divdedby;?></td>
										<? foreach($proposal_month as $pmd){ if($pmd['month']=='Year') continue;?>
										<td rowspan="<?=$grpah_m+1?>" valign="bottom"><div class="graphData" style="height:<?=$pmd['acenergy']*.37*$per?>px;"></div></td>
										<?} ?>
									  </tr>
                                                                           <? for($k=$grpah_m-1;$k>=0;$k--) {?> 
									  <tr>
										<td class="listN"><?=$k*$divdedby;?></td>
									  </tr>
                                                                            <? } ?>
									  
									  <tr>
										<td>&nbsp;</td>
										<td class="monthD">J</td>
										<td class="monthD">F</td>
										<td class="monthD">M</td>
										<td class="monthD">A</td>
										<td class="monthD">M</td>
										<td class="monthD">J</td>
										<td class="monthD">J</td>
										<td class="monthD">A</td>
										<td class="monthD">S</td>
										<td class="monthD">O</td>
										<td class="monthD">N</td>
										<td class="monthD">D</td>
									  </tr>
									</table>
								</td>
							</tr>
							<tr>
								<td></td>
								<td style="text-align:center; font-size:11px;">MONTHS(<?=date("Y",strtotime($proposal['created']));?>)</td>
							</tr>
						</table>
					</div>
					<table class="graphtable">
						<tr><th>Month</th><th>Sun Hours</th><th>Energy (kWh)</th><th>Energy Value($)</th></tr>
						<? 
                                                $startmo =0;
                                                $solorsum = 0;
                                                $pvsumenergy =0;
                                                $pvenergyval =0;
                                                foreach($proposal_month as $pvenergy) {
                                                    if($pvenergy['month']=="Year") continue;
                                                    $startmo+=1;
                                                    $solorsum += $pvenergy['solar'];
                                                    $pvsumenergy +=$pvenergy['acenergy'];
                                                    $pvenergyval +=$pvenergy['costsaved'];
                                                ?>
                                                <tr>
						<td><?=$startmo;?></td>
						<td><?=$pvenergy['solar']?></td>
						<td><?=$pvenergy['acenergy']?></td>
						<td><?=$pvenergy['costsaved']?></td>
						</tr>
                                                <? } ?>
						
						<tr style="border-top:1px solid #000;">
						<td>Year</td>
						<td><?=round($solorsum/12,2)?></td>
						<td><?=$pvsumenergy?></td>
						<td><?=$pvenergyval?></td>
						</tr>
					</table>
					</div>
				
					<div style="padding:10px 0; margin-top:10px; border-top:0px solid #ffffff;" class="notesd">
						<?=$pdf2footertext?>
					</div>
				</div>
			</div>
<!-- /graph section -->
    </div>    
</div>

<div class="wrap break">
	<div class="headerPan clearfix">
	<h1 class="fl">PV System Investment</h1>
	<img src="<?=base_url()?>assets/pdfimages/logo.png" class="fr" />
	</div>
	<div class="clearfix">
		<div class="datePan"><strong><?=date("F j, Y",strtotime($proposal['created']));?> / Quote No.</strong> <?=$proposal['id']?> / Photovoltaic Proposal Page 4</div>
	
	</div>
    
    <div class="clearfix">
    	<div class="fl" style="width:480px;">
        	<h4>Customer Details</h4>
            <table class="dataTable">
            	<tr>
                	<td>Name</td><td class="rightalign"><?=ucfirst($proposal['dpp_firstname'])?> <?=ucfirst($proposal['dpp_lastname'])?></td>
                </tr>
                <tr class="altBg">    
                    <td>Street Address</td><td class="rightalign"><?=$proposal['address']?></td>
                </tr>
                <tr>    
                    <td>City, Zip Code, State</td><td class="rightalign"><?=$proposal['city']?>, <?=$proposal['zip']?>, <?=$proposal['state']?></td>
                </tr>
                <tr class="altBg">    
                    <td>Primary Phone ,Secondary Phone:</td><td class="rightalign"><? $new_parray=array(); if($proposal['phone']){
                                                                                         $new_parray[]=$proposal['phone'];

                                                                                       } if($proposal['sphone']){$new_parray[]=$proposal['phone'];}
                                                                                       echo @implode(",",$new_parray);
                                                                                       ?> </td>
                 </tr>
                 <tr>   
                    <td>Email</td><td class="rightalign"><?=$proposal['email']?></td>
                </tr>
            </table>
            
            <div class="greenbox">
            	<?=$carbon;?> lbs of carbon dioxide
                (leading cause for greenhouse
                gases) will be avoided
                by your PV system.
            </div>
        </div>
        
        <div class="fr" style="width:472px;">
        	<div class="declaraton">AEI's Premium PV System Cost</div>
            <div style="border:2px solid #000000; padding:10px;" class="clearfix">
            <table class="taxbenefits">
                <tr><td class="tdData" style="font-size:20px; font-style:normal; font-family:neo sans; font-weight:normal;">System Price:</td><td class="tdData txtright" style="font-size:20px; font-style:normal; font-family:neo sans; font-weight:normal;">
                 $<? echo $cal =number_format(($proposal['price']*100)/104.712,2)?></td></tr>
                <tr><td class="tdData" style="font-size:20px; font-style:normal; font-family:neo sans; font-weight:normal;">General Excise Tax (4.712%):</td><td class="tdData txtright" style="font-size:20px; font-style:normal; font-family:neo sans; font-weight:normal;"><?=number_format(($proposal['price']*4.712)/104.712,2)?></td></tr>
                                    <tr><td class="tdData" style="font-size:20px; font-style:normal; font-family:neo sans; font-weight:bold; color:#71B644;">Total Payable:</td><td class="tdData txtright" ><strong style="font-size:20px; font-style:normal; font-family:neo sans; font-weight:bold; color:#71B644;">$<?=number_format($proposal['price'],2)?></strong></td></tr>
            </table>
            </div>
        
            <h4 style="margin-top:20px;">Basic Tax Benefits</h4>
            <table class="dataTable">
                 <?php $k  = $proposal['nos'];
                       $nom =$proposal['nom'];
                       $mod = $nom%$k; 
                       $mod_temp =$mod;
                       if($mod!=0 && $nom>$k) {
                        $system_size=array();   
                        for($i=1;$i<=$k ;$i++) {
                          if($proposal['module_type']==1){  
                            if($mod_temp>0){
                                $system_size[$i]=((($nom-$mod)/$k + 1)*255)/1000;
                            } else{
                                $system_size[$i]=((($nom-$mod)/$k)*255)/1000;
                            }
                          }else{
                             if($mod_temp>0){
                                $system_size[$i]=((($nom-$mod)/$k + 1)*225)/1000;
                             }else{
                                $system_size[$i]=((($nom-$mod)/$k)*225)/1000;
                             }
                          }    
                          $mod_temp--;    
                       }
                       }
                        
                                             $sumtax=0;
                                             for($i=1;$i<=$k ;$i++) {
                                                 $state_tax = ($proposal['price']/$k)*.35;
                                                 if($state_tax>5000){
                                                     $state_tax=5000;
                                              }
                                              $sumtax+= ($state_tax)+(($proposal['price']/$k)*.3);
                                              if($mod!=0 && $nom>$k ){
                                                  $new_system_size=$system_size[$i];

                                              }else{
                                                $new_system_size=$proposal['system_size']/$proposal['nos'];
                                              }
                                             ?>
                <tr>
                        <td><strong>System #<?=$i?> (<?=number_format($new_system_size,2)?> kW):</strong></td><td class="rightalign"><strong>$<?=number_format($proposal['price']/$k,2) ?></strong></td>
                </tr>
                <tr class="altBg">    
                        <td>U.S. Federal Tax Credit 30%:</td><td class="rightalign">($<?=number_format(($proposal['price']/$k)*.3,2) ?>)</td>
                </tr>
                <tr>
                        <td>Hawaii State Tax Credit 35%:</td><td class="rightalign">($<?=number_format($state_tax,2) ?>)</td>
                </tr>
                <tr>
                    <td>&nbsp;</td>
                </tr>
                <? } ?>
                <tr class="altBg">
                        <td>Total Basic Tax Credits:</td><td class="rightalign">($<?=number_format($sumtax,2)?>)</td>
                </tr>
                <tr>
                        <td>Estimated Annual Savings:</td><td class="rightalign">$<?=number_format($pvenergyval,2)?></td>
                </tr>
                <tr class="altBg">
                        <td>Simple Payback:</td><td class="rightalign"><?=$paybackyears;?> Years</td>
                </tr>
                <tr>
                        <td>Price Per Watt Installed</td><td class="rightalign"><?=number_format(($proposal['price'])/($proposal['system_size']*1000),2) ?>/W</td>
                </tr>
            	
                
            </table>
            
            <table class="dataTable" style="border:1px solid #000000; margin-top:20px;">
            	<tr>
                	<td style="padding:10px 5px;"><strong>Total Net System Cost w/ Tax Benefits:</strong></td><td class="rightalign" style="padding:10px 5px;"><strong>$<?=number_format($proposal['price']-$sumtax,2);?></strong></td>
                </tr>
            </table>
           
    </div>    
</div>

<div class="wrap break">
	<div class="headerPan clearfix">
	<h1 class="fl">Photovoltaic System Summary</h1>
	<img src="<?=base_url()?>assets/pdfimages/logo.png" class="fr" />
	</div>
	<div class="clearfix">
		<div class="datePan"><strong><?=date("F j, Y",strtotime($proposal['created']));?> / Quote No.</strong> <?=$proposal['id']?> / Photovoltaic Proposal Page 5</div>
	
	</div>
		
		<?=@$moduletypedesc;?>
		<br/>
		
		<?=@$invertertypedesc;?>
	
	
	<div style="clear:left; display:block; height:5px; background: url('<?=base_url()?>assets/images/energy-dashedlines.png') repeat-x;">&nbsp;</div>	
	
	
	<div class="clearfix cl" style="font-family:neo sans light; padding:29px 0;">
			<?=@$reckone1;?>
			<?=@$reckone2;?>
			<?=@$reckone3;?>
	</div>
		
</div>

<div class="wrap break">
	<div class="headerPan clearfix">
	<h1 class="fl" style="color:#ffffff;">Residential Photovoltaic System</h1>
	<img src="<?=base_url()?>assets/pdfimages/logo.png" class="fr" />
	</div>
    <div class="clearfix">
		
	</div>
    
    <h5>Final Analysis</h5>
	<table class="threecolumn">
		<tr>
			<td width="30%" valign="top">
				<h4>Your Solar Future</h4>
                <p>
                	What can you be sure of in times like this?
                    You can be sure that your PV system will
                    pay for itself while saving you money. As
                    an investment property your PV system
                    will yield a steady return year after year
                    regardless of what the economy is doing,
                    protecting your household from rate hikes.
				</p>
                
                <div class="greenbox">
                	<?=$nitrogen;?> lbs of nitrogen oxides
					(causes smog) avoided
                </div>    
        	</td>
            <td width="5%">&nbsp;</td>
            <td width="30%" valign="top">
            	<h4>Assured Warranty</h4>
            	<p>
                	When you choose AEI, you get more
                    then a well trained and professional
                    staff. You also get AEI's thirty years of
                    proven reliability, outstanding customer
                    support and the assurance of our 10-
                    year guarantee. AEI warrants parts
                    and labor against defects in material or
                    workmanship for a period of ten years
                    from the date of original purchase, and
                    agrees to repair or, at the company's
                    option, replace a defective product
                    without charge for either replacement
                    parts or labor during such time.	
				</p>
                
                <p>
                	Mitsubishi Electric warrants the power
                    output of their PV panels for twenty-five
                    years. The power output degradation
                    will not fall under 80% of the designated
                    minimum power output.
                </p>
                
                <p>
                	Enphase's microinverter has a
                    manufacture warranty of 25 years.
				</p>
                
                <p>
                    SMA's warranty covers their inverters
                    for a period of ten (10) years. If a device
                    becomes defective during the relevant
                </p>   
            </td>
            <td width="5%">&nbsp;</td>
            <td width="30%" valign="top">
            	<p>
	            	SMA warranty period, one of the following
                    services, as selected by SMA, will be
                    performed at no charge for materials
                    or labor costs: Repair at SMA, or Repair
                    On-site, or Exchange for a replacement
                    Device.
                 </p>
                 
                   
                 <h4>Conclusion</h4>
                 <p>
                    Thank you for the opportunity to present
                    you with a proposal for your grid-tied solar
                    electric system. Alternate Energy Inc. is
                    delighted to be working with you. Please
                    let us know what we can do to win your
                    business.
                  </p>  
            </td>
        </tr>
     </table>
</div>            
</body>
</html>
