 <!--
Customer Types: Residential, Commercial
Job Type: Solar Water Heating, Photovoltaic, Solar Attic Fan, Service Call

Automatic filtering to prevent same-name/same-address scenarios. i.e. if name is entered and there is a similar name/lastname, if asks if this person lives at the same address. If yes, it'll modify that persons profile, ie customers can have more than one job added to it like solar water heating, photovoltaics, solar fans, etc
Ability to 'Save for later', i.e. saves and closes overlay window and returns to Job Calendar view
Ability to 'Enter more details' - takes user to job detailed page to enter more customer details.

- width of all overlays should be the same, although its not necessary to keep it the same width in the mockups
-->
<style>
.anothername{display:none;}
</style>
<META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE">

<div class="generic-page-block">
    <div style="positon:absolute; z-index:1;">
	<div class="green-header">
            <div class="title">Final Analysis</div>
	</div>
        
	<div class="content clearfix" style="padding:10px;">
            <div class="form-errors" style="display:none;"></div>
                
            <?=form_open('proposal/final_analysis', 'id="final_analysis"');?>
                <?//=form_hidden('proposal_id',$proposal_id)?>
                
                <?=form_label('Select Deal Type','deal_type');?>
                <?=form_dropdown('deal_type',@$deal_types,"",'id="deal_type" class="deal_type" onchange="pricetitle()"');?>
                
                <?=form_label('Select Type','type');?>
                <div id="deal_type_ajax">
                    <?=form_dropdown('type',@$module_inverter,"",'id="type" onchange="pricetitle()"');?>
                </div>
                
                <div  id="desc1" style='display:none;' >
                    <?=form_label('Description', 'desc');?>
                    <?     $cdata = array('name' => 'desc', 'id' => 'desc', 'cols' => '200', 'rows' => '300','value'=>'');
                            echo form_textarea($cdata);
                    ?>
                </div>
                
            <?=form_close();?>

            <div style="float:left;margin-top: 10px;">
                <button class="cancel-facebox">Cancel</button>
            </div>

            <div style="float:left;margin-top: 10px;">
                <!--<button class="save-for-later">Save for later</button> -->
                &nbsp;<button class="next">Save</button>
            </div>
            <div class="clear-both"></div>
        </div>
    </div>	
</div>

<script type="text/javascript" charset="utf-8">
    $(document).ready(function() {
        $('.deal_type').change(function(){
            var deal_type = $('#deal_type').val();
            if(deal_type==''){
                return false;
            }
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>proposal/final_analysis_modules/"+deal_type,
                dataType: "",
                async:false,
                success: function(json) {
                    $("#deal_type_ajax").html(json);
                    $('#desc_html').contents().find('body').html('');
                    $('#desc').html('');
                }
            });
        });
        $(".next").click( function(){
            //$("#displayloading").show();
            
            $('#final_analysis').find('input:text').each(function(){
                $(this).val($.trim($(this).val()));
            });
            $.ajax({
                type: "POST",
                url: "<?=base_url()?>proposal/final_analysis_submit",
                data: $('#final_analysis').serialize(),
                dataType: "json",
                success: function(json) {
                    if(json.success == true)
                    {
                        window.location.reload();
                    }
                    else
                    {
                        $("#displayloading").hide();
                        $(".form-errors").html(json.msg);
                        $(".form-errors").fadeIn();
                    }
                }
            });
        });
        $('#desc1').show();
        $("#desc").css("height","400").css("width","800").htmlbox({
            toolbars:[
                ["cut","copy","paste","separator_dots","bold","italic","underline","strike","sub","sup","separator_dots","undo","redo","separator_dots",
                     "left","center","right","justify","separator_dots","ol","ul","indent","outdent","separator_dots","link","unlink","image"],
                ["code","removeformat","striptags","separator_dots","quote","paragraph","hr","separator_dots",
                        {icon:"new.png",tooltip:"New",command:function(){hb_silk_icon_set_blue.set_text("<p></p>");}},
                        {icon:"open.png",tooltip:"Open",command:function(){alert('Open')}},
                        {icon:"save.png",tooltip:"Save",command:function(){alert('Save')}}
                ]
            ],
            icons:"silk",
            skin:"blue",
            idir:"<?=base_url();?>htmlbox/images"
        });
        $('#desc_html').contents().find('body').html('');
        //$('#desc_wrap').hide();
    });
    
    function pricetitle(){
        var deal_type = $('#deal_type').val();
        var type = $('#type').val();
        if(deal_type=='' || type==''){
            $('#desc_html').contents().find('body').html('');
            $('#desc').html('');
            return false;
        }
        $.ajax({
            type: "POST",
            url: "<?=base_url()?>proposal/get_final_analysis_desc/",
            //data:"select_id="+id.value ,
            data:"select_id="+type+"&deal_type="+deal_type,
            dataType: "json",
            success: function(json) {
                if(json.success == true)
                {
                    $('#desc_wrap').show();
                    $('#desc_html').contents().find('body').html(json.desc);
                    $('#desc').html(json.desc);
                }
                else
                {
                    $("#displayloading").hide();
                    $(".form-errors").html(json.msg);
                    $(".form-errors").fadeIn();
                }
            }
        });
    }

</script>