<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title><?//= html_escape($title ?? 'Premeasure Upload') ?></title>
  <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
  <style>
    body { background:#e9eff3; }
    .wrap { max-width: 820px; margin: 30px auto; }
    .card { border-radius:12px; }
    .title { font-weight:700; color:#3498db; }
    label { font-weight:600; }

    /* NEW: full-page loading overlay */
    #pageLoading {
      position: fixed;
      inset: 0;
      background: rgba(255,255,255,0.8);
      z-index: 1050; /* above Bootstrap modals */
      display: none;
      align-items: center;
      justify-content: center;
    }
  </style>
</head>
<body>
  <!-- NEW: Page-wide loading overlay -->
  <div id="pageLoading">
    <div class="text-center">
      <div class="spinner-border text-primary" style="width:3rem;height:3rem;" role="status"></div>
      <div class="mt-3 fw-semibold text-primary">
        Uploading files, please wait...
      </div>
    </div>
  </div>

  <div class="wrap">
    <div class="card shadow-sm">
      <div class="card-body p-4">
        <h1 class="h3 text-center title mb-4">Premeasure Upload</h1>

        <?php if($this->session->flashdata('error')): ?>
          <div class="alert alert-danger"><?= $this->session->flashdata('error') ?></div>
        <?php endif; ?>
        <?php if($this->session->flashdata('success')): ?>
          <div class="alert alert-success"><?= $this->session->flashdata('success') ?></div>
        <?php endif; ?>

        <form method="post" action="preupload/submit" enctype="multipart/form-data">
          <?php
            // CI3 CSRF hidden input (works only if csrf_protection = TRUE)
          ?>

          <div class="mb-3">
            <label class="form-label">Job Date:</label>
            <div class="input-group">
              <input id="job_date" type="date" name="job_date" class="form-control" required>
              <span class="input-group-text">📅</span>
            </div>
          </div>

          <div class="mb-3">
            <label class="form-label">Job Type:</label>
            <select id="job_type" name="job_type" class="form-control" required>
              <option value="">Select job type</option>
              <!-- dynamically populated -->
            </select>
          </div>

          <div class="mb-3">
            <label class="form-label">Photo Type:</label>
            <select id="photo_type" name="photo_type" class="form-control" required>
              <option value="">Select Photo type</option>
              <option value="S">Survey</option>
              <option value="I">Installation</option>
            </select>
          </div>

          <div class="mb-3">
            <label class="form-label">Customer Name:</label>
            <select id="customer_name" name="customer_name" class="form-control" required>
              <option value="">Select customer</option>
              <!-- dynamically populated -->
            </select>
          </div>

          <div class="mb-3">
            <label class="form-label">Notes (optional):</label>
            <textarea name="notes" rows="4" class="form-control" placeholder="Enter any additional notes here"></textarea>
          </div>

          <!-- SINGLE FILE INPUT + LOADING + STATS -->
          <div class="mb-3">
            <label class="form-label">Select Files:</label>
            <input id="files" type="file" name="files[]" class="form-control" multiple>

            <!-- Loading indicator -->
            <div id="fileLoading" class="mt-2" style="display:none; align-items:center;">
              <div class="spinner-border text-primary" style="width: 1.5rem; height: 1.5rem;" role="status"></div>
              <span class="ms-2">Processing selected files...</span>
            </div>

            <!-- File stats -->
            <div class="form-text mt-1" id="fileStats">
              Total files to upload: 0, Total MB: 0
            </div>
          </div>

          <div class="d-grid">
            <button class="btn btn-primary btn-lg" type="submit">Upload Files</button>
          </div>
        </form>
      </div>
    </div>
  </div>

  <!-- FILE LOADING + SIZE CALC SCRIPT -->
  <script>
    (function(){
      const input   = document.getElementById('files');
      const stats   = document.getElementById('fileStats');
      const loading = document.getElementById('fileLoading');

      if (!input) return;

      input.addEventListener('change', function(){
        if (!this.files || this.files.length === 0) {
          stats.textContent = 'Total files to upload: 0, Total MB: 0';
          if (loading) loading.style.display = 'none';
          return;
        }

        // Show spinner
        if (loading) loading.style.display = 'inline-flex';
        stats.textContent = 'Calculating...';

        let total = this.files.length;
        let bytes = 0;
        for (let i = 0; i < total; i++) {
          bytes += this.files[i].size;
        }

        stats.textContent =
          'Total files to upload: ' + total +
          ', Total MB: ' + (bytes / 1024 / 1024).toFixed(2);

        // Keep spinner visible briefly so it's noticeable
        setTimeout(() => {
          if (loading) loading.style.display = 'none';
        }, 800);
      });
    })();
  </script>

  <!-- DATE DEFAULT + AJAX DROPDOWNS + PAGE LOADING ON SUBMIT -->
  <script>
    // Default today's date for input[type=date]
    (function(){
      const d = new Date();
      const dd = String(d.getDate()).padStart(2,'0');
      const mm = String(d.getMonth()+1).padStart(2,'0');
      const yyyy = d.getFullYear();
      const el = document.getElementById('job_date');
      if (el && !el.value) el.value = yyyy+'-'+mm+'-'+dd;
    })();

    const jobDateEl = document.getElementById('job_date');
    const jobTypeEl = document.getElementById('job_type');
    const custEl    = document.getElementById('customer_name');

    async function fetchJSON(url){
      const res = await fetch(url, { credentials: 'same-origin' });
      return res.json();
    }

    // Generic dropdown filler: supports [{value:'',label:''}] or plain strings
    function setOptions(select, items, placeholder){
      select.innerHTML = '';
      const opt0 = document.createElement('option');
      opt0.value = '';
      opt0.textContent = placeholder || 'Select';
      select.appendChild(opt0);

      items.forEach(item=>{
        let value, label;
        if (typeof item === 'object') {
          value = item.value || item.id || item.name || '';
          label = item.label || item.text || item.name || item.value || '';
        } else {
          value = item;
          label = item;
        }
        const o = document.createElement('option');
        o.value = value;
        o.textContent = label;
        select.appendChild(o);
      });

      // auto-select if only 1
      if (items.length === 1) {
        select.value = (typeof items[0] === 'object') ? (items[0].value || '') : items[0];
        select.dispatchEvent(new Event('change'));
      }
    }

    // Populate Job Types when date changes
    jobDateEl.addEventListener('change', async ()=>{
      custEl.innerHTML = '<option value="">Select customer</option>';
      const date = jobDateEl.value; // yyyy-mm-dd
      if(!date){ setOptions(jobTypeEl, [], 'Select job type'); return; }
      try{
        const data = await fetchJSON('preupload/jobtypes?date=' + encodeURIComponent(date));
        if(data.status === 'ok'){
          setOptions(jobTypeEl, data.items || [], 'Select job type');
        } else {
          setOptions(jobTypeEl, [], 'Select job type');
        }
      } catch(e){
        setOptions(jobTypeEl, [], 'Select job type');
      }
    });

    // Populate Customers when job type changes
    jobTypeEl.addEventListener('change', async ()=>{
      const date = jobDateEl.value;
      const type = jobTypeEl.value;
      if(!date || !type){ setOptions(custEl, [], 'Select customer'); return; }
      try{
        const data = await fetchJSON(
          'preupload/customers?date=' + encodeURIComponent(date) +
          '&job_type=' + encodeURIComponent(type)
        );
        if(data.status === 'ok'){
          setOptions(custEl, data.items || [], 'Select customer');
        } else {
          setOptions(custEl, [], 'Select customer');
        }
      } catch(e){
        setOptions(custEl, [], 'Select customer');
      }
    });

    // Trigger initial load (today)
    jobDateEl.dispatchEvent(new Event('change'));

    // NEW: Show page-wide loading overlay on submit (during upload)
    (function(){
      const form = document.querySelector('form');
      const pageLoading = document.getElementById('pageLoading');
      const submitBtn =
        form ? form.querySelector('button[type="submit"], button:not([type])') : null;

      if (!form) return;

      form.addEventListener('submit', function(){
        // Optional: only show if files are selected
        const fileInput = document.getElementById('files');
        if (fileInput && (!fileInput.files || fileInput.files.length === 0)) {
          // If you want overlay even without files, remove this return
          // return;
        }

        if (pageLoading) {
          pageLoading.style.display = 'flex';
        }
        if (submitBtn) {
          submitBtn.disabled = true;
          submitBtn.textContent = 'Uploading...';
        }
      });
    })();
  </script>

</body>
</html>
