<!--
Customer Types: Residential, Commercial
Job Type: Solar Water Heating, Photovoltaic, Solar Attic Fan, Service Call

Automatic filtering to prevent same-name/same-address scenarios. i.e. if name is entered and there is a similar name/lastname, if asks if this person lives at the same address. If yes, it'll modify that persons profile, ie customers can have more than one job added to it like solar water heating, photovoltaics, solar fans, etc
Ability to 'Save for later', i.e. saves and closes overlay window and returns to Job Calendar view
Ability to 'Enter more details' - takes user to job detailed page to enter more customer details.

- width of all overlays should be the same, although its not necessary to keep it the same width in the mockups
-->
<div class="reserve-job" id="reservejob">
	<div class="header clearfix">
		<div class="title">Stock </div>
		<div class="close-button"><a href="#" class="cancel-facebox">&times;</a></div>
		<div class="clear-both"></div>
	</div>
	<div class="content clearfix" style="padding:10px;">
		
		<div class="form-errors" style="display:none;"></div>
		<?=form_open('inventory/inventorystockform', 'id="inventorystockform"');?>
                <?=form_dropdown('calendar_years', $calendar_years);?>
                <?=form_dropdown('month', $month);?>
                <?=form_dropdown('job_types', $job_types);?>
                <?=form_dropdown('module_types', $module_types);?>
               
                <div id="stock">
                <?=form_label('Stock Value:-')?>
                <?=form_input("stock")?>
                </div>
                <?=form_close();?>
		<div style="float:left;">
			<button class="cancel-facebox">Cancel</button>
		</div>
		
		<div style="float:right">
			<!--<button class="save-for-later">Save for later</button> -->
			<button class="savejob">Save</button>
		</div>
		<div class="clear-both"></div>
		
	</div>
</div>

<script type="text/javascript" charset="utf-8">
var customer_id = '';
var userid ='';
$(document).ready(function() {
   
   $("select[name='job_types']").change(function(){
      var jobtype = $(this).val();
      if (jobtype=="2"){
          $("select[name=module_types]").show();
          
         $("#stock").hide();
         $("select[name='panel_sizes']").hide();
      }else if(jobtype=="1"){
          $("select[name='module_types']").hide();
          $("#stock").hide();
          
      }else{
         $("select[name=module_types]").hide();
         $("#stock").hide();
         
      }
   });
 
    $("select[name=module_types]").change(function(){
       $("#stock").show();
      $.ajax({
            type: "POST",
            url: "<?=base_url()?>inventory/getinventorymodulestockvalue",
            data: $('#inventorystockform').serialize(),
            dataType: "json",
            success: function(json) {
                if(json.success == true){
                    $("input[name=stock]").val(json.value);
		}else{
                    $(".form-errors").html(json.msg);
                    $(".form-errors").fadeIn();
                }
            }
      });
  });

  function validate_stock(){

      var year = $("select[name='calendar_years']").val();
      if(year=="" || !year){
           $(".form-errors").html("Please select year.");
           $(".form-errors").show();
           return false;
      }
      var job_type = $("select[name='job_types']").val();
      if(job_type=="" || !job_type){
           $(".form-errors").html("Please select Job Type");
           $(".form-errors").show();
           return false;
      }else{
          if (job_type==2) {
             var inverter_types = $("select[name='module_types']").val();
            if(inverter_types=="" || !inverter_types){
                    $(".form-errors").html("Please select Inverter Type");
                    $(".form-errors").show();
                    return false;
            } else{
            var stock = parseInt($("input[name=stock]").val());

            if(!stock || stock=="" || stock<=0){
                $(".form-errors").html("Please enter correct stock value");
                $(".form-errors").show();
                return false;
            }else {
                if(!isUnsignedInteger(stock)){
                   $(".form-errors").html("Stock value should be integer");
                   $(".form-errors").show();
                   return false;
                }
            }
          }
          }
           else{
               $(".form-errors").html("Please select Photovoltic or SWH job type only");
                   $(".form-errors").show();
                   return false;
          }
      }
    return true;
      }

   $(".savejob").click( function(){
     if(!validate_stock()){
         return false;
     }
     $.ajax({
            type: "POST",
            url: "<?=base_url()?>inventory/inventorymodulestockform",
            data: $('#inventorystockform').serialize(),
            dataType: "json",
            success: function(json) {
                if(json.success == true){
                     $("select").hide();
                     $("select[name='calendar_years']").show();
                     $('#inventorystockform')[0].reset();
                     $("#stock").hide();
                     $("select[name='job_types']").show();
                    $("input[name=stock]").val(json.value);
                    $(".form-errors").html("Stock has been updated successfully.");
                    $(".form-errors").show();
                    $("select[name='month']").show();
		}else{
                    $(".form-errors").html(json.msg);
                    $(".form-errors").fadeIn();
                }
            }
      });



// look for previously entered customers
});
   $("select").hide();
   $("#stock").hide();
   $("select[name='job_types']").show();
   $("select[name='calendar_years']").show();
   $("select[name='month']").show();
  });
      
function isUnsignedInteger(s) {
  return (s.toString().search(/^[0-9]+$/) == 0);
}
   
</script>