<!--
Customer Types: Residential, Commercial
Job Type: Solar Water Heating, Photovoltaic, Solar Attic Fan, Service Call

Automatic filtering to prevent same-name/same-address scenarios. i.e. if name is entered and there is a similar name/lastname, if asks if this person lives at the same address. If yes, it'll modify that persons profile, ie customers can have more than one job added to it like solar water heating, photovoltaics, solar fans, etc
Ability to 'Save for later', i.e. saves and closes overlay window and returns to Job Calendar view
Ability to 'Enter more details' - takes user to job detailed page to enter more customer details.

- width of all overlays should be the same, although its not necessary to keep it the same width in the mockups
-->

<div class="reserve-job">
    <div class="header">
        <div class="title">EL Reschedule</div>
        <div class="close-button"><a href="#" class="cancel-facebox">&times;</a></div>
        <div class="clear-both"></div>
    </div>
    <div class="content" style="padding:10px;">

        <div class="form-errors" style="display:none;"></div>

        <?= form_open('prejobscheduleajax/el_reschedule', 'id="installer_form"'); ?>
        <? //=form_hidden('available_installer1',$available_installer)?>
        <? if (@$job_id) { ?>
            <br><span id="comment_msg">  Reason for reschedule:</span>
            <? echo form_dropdown('option_reason', $poption, 'large', 'id="option_reason"'); ?>
            <br><span id="comment_msg"> Please enter reason for rescheduling job:</span>
            <?= form_textarea(array("name" => 'el_reschedule_reason', "rows" => '5', "cols" => '64', "id" => 'el_reschedule_reason')); ?>

            <?= form_close(); ?>

            <div style="float:right; margin-left:5px;">
                <button class="nootherjob">Proceed</button>
            </div>



        <? } else { ?>
            Redirect<img  src="<?= base_url() ?>assets/images/loading.gif">
        <? } ?>

        <br/>
        <div class="clear-both"></div>

    </div>
</div>
<script type="text/javascript" charset="utf-8">

    $(document).ready(function () {


        var userid = <?= $user_id ? $user_id : 3; ?>;

        function  wpl_reschedule()

        {

            var checkbox = $("input:checkbox[name=el_reschdule]").is(':checked');
            var el_reschedule_reason = $("#el_reschedule_reason").val();
            var comment_length = $("#el_reschedule_reason").val().length;
            if ($.trim(el_reschedule_reason) == "")
            {
                $("#comment_msg").css("color", "#cc0000");
                $("#comment_msg").css("font-weight", "bold");
                return false;
            }

            if (comment_length > 250)
            {
                alert("Comment character length should not be greater then 250.");
                return false;
            }
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>eljobscheduleajax/elsave_session_un/<?= $job_id; ?>/0",
                data: $('#installer_form').serialize(),
                dataType: "json",
                success: function (json) {
                    if (json.success == true)
                    {

                        location.href = "<?= base_url() ?>admin/installer_available/<?= date("Y", $job_timestamp) ?>/<?= date("m", $job_timestamp) ?>/" + userid;


                    }
                    else
                    {
                        $(".form-errors").html(json.msg);
                        installerclick = false;
                        $(".form-errors").fadeIn();

                    }
                }
            });
        }
        $('.nootherjob').click(function () {
            wpl_reschedule();
        });
        
    });
</script>