<!--
Customer Types: Residential, Commercial
Job Type: Solar Water Heating, Photovoltaic, Solar Attic Fan, Service Call

Automatic filtering to prevent same-name/same-address scenarios. i.e. if name is entered and there is a similar name/lastname, if asks if this person lives at the same address. If yes, it'll modify that persons profile, ie customers can have more than one job added to it like solar water heating, photovoltaics, solar fans, etc
Ability to 'Save for later', i.e. saves and closes overlay window and returns to Job Calendar view
Ability to 'Enter more details' - takes user to job detailed page to enter more customer details.

- width of all overlays should be the same, although its not necessary to keep it the same width in the mockups
-->

    <div class="reserve-job">
        <div class="header">
            <div class="title">Select Customer</div>
            <div class="close-button"><a href="#" class="cancel-facebox">&times;</a></div>
            <div class="clear-both"></div>
        </div>

        <div class="content">
            <div class="form-errors" style="display:none;"></div>
            <div class="content" style="padding:10px;">
                <?=form_open('duplicatejob/move', 'id="duplicate_remove"');?>
                    
                    <?=form_hidden('customer_did',$customer_replace)?>
                    <? if(@$permission){ ?>
                        Select Customer : 
                        <?=form_dropdown('duplicate',$duplicate,"style=width:30px;");?>
                    <? } else {?>
                        You do not have sufficient permission, to resolve this issue, Please contact to Admin
                    <? } ?>
                <br/>
                <?=form_close();?>
                <div style="float:right">
                    <button class="saveselect" >Update  </button>
                </div>
                <div class="clear-both"></div>
            </div>
        </div>
    </div>

<script>
    $(document).ready(function() {
        save_for_later = function()
	{
            if(window.confirm("Are you sure?")){
                $.ajax({
                    type: "POST",
                    url: "<?=base_url()?>duplicatejob/move",
                    data: $('#duplicate_remove').serialize(),
                    dataType: "json",
                    success: function(json) {
                        if(json.success == true){
                            alert("Customer association  has been done sucessfully.");
                            window.location.reload();
                        }else{
                            alert("Error, Please contact to site Adminstrator.");
                            window.location.reload();
                        }
                    }
                });
            }
	}
	$('.saveselect').click(function() {  save_for_later() });
    });
</script>