<!--
Customer Types: Residential, Commercial
Job Type: Solar Water Heating, Photovoltaic, Solar Attic Fan, Service Call

Automatic filtering to prevent same-name/same-address scenarios. i.e. if name is entered and there is a similar name/lastname, if asks if this person lives at the same address. If yes, it'll modify that persons profile, ie customers can have more than one job added to it like solar water heating, photovoltaics, solar fans, etc
Ability to 'Save for later', i.e. saves and closes overlay window and returns to Job Calendar view
Ability to 'Enter more details' - takes user to job detailed page to enter more customer details.

- width of all overlays should be the same, although its not necessary to keep it the same width in the mockups
-->
<style>
.anothername{display:none;}
</style>
<div class="reserve-job" id="reservejob">
    <div id="displayloading" style="position: absolute; z-index: 2; text-align: center; display:none; width: 100%; line-height: 321px; background-color: rgb(240, 240, 240);"><img src="<?=base_url()?>assets/images/loading.gif"><br/>Processing..</div>
	<div class="header clearfix">
		<div class="title">Quotes</div>
		<div class="close-button"><a href="#" class="cancel-facebox">&times;</a></div>
		<div class="clear-both"></div>
	</div>
	<div class="content clearfix" style="padding:10px;">

		<div class="form-errors" style="display:none;"></div>
		<?=form_open('proposal/proposal_pvwatts', 'id="proposal_pvwatts"');?>
                <?=form_hidden('proposal_id',$proposal_id)?>
		<?//=form_hidden('customer_id',$customer_id)?>
                <?//=form_hidden('job_id',$this->input->get("job_id"))?>

			<div class="clheader clearfix">
				<div class="ltheader">Location:</div>
				<div class="rtoutput"><?=$proposal['address']?>,<?=$proposal['city']?></div>
			</div>
			<div class="clheader clearfix">
				<div class="ltheader">D Rating (System Size - STC):</div>
				<div class="rtoutput"><?=$proposal['system_size']?>kW</div>
			</div>
			<div class="clheader clearfix">
				<div class="ltheader">Derate:</div>
				<div class="rtoutput">0.85</div>
			</div>
			<div class="clheader clearfix">
				<div class="ltheader">Array Tilt:</div>
				<div class="rtoutput">21.3</div>
			</div>

		<?=form_label('Array Azimuth(Roof orientation in Degrees)','array_azimuth');?>
		<?=form_input('array_azimuth',@$proposal['arrayazimuth'],'id="array_azimuth"');?>
		<?=form_label('Current Electric Rate(cents/kWh)', 'current_electricrate');?>
		<?=form_input('current_electricrate',@$proposal['electriccost'],'id="current_electricrate"');?>
                <?=form_label(' Energy  Usage', 'ceu');?>
		<?=form_input('ceu',@$proposal['ceu'],'id="ceu"');?>
                <?=form_label('Solar Sunshine Zone', 'avgzoneenergy');?>
		<?=form_input('avgzoneenergy',@$proposal['avgzoneenergy'],'id="avgzoneenergy"');?>
                <?=form_close();?>

		<div style="float:left;">
			<button class="cancel-facebox">Cancel</button>
		</div>

		<div style="float:right">
			<!--<button class="save-for-later">Save for later</button> -->
			<button class="next">Finish</button>
		</div>
		<div class="clear-both"></div>

	</div>
</div>

<script type="text/javascript" charset="utf-8">
$(document).ready(function() {
 $(".next").click( function(){
      $('#proposal_pvwatts').find('input:text').each(function(){
                   $(this).val($.trim($(this).val()));
                });
var arrazi = $('#array_azimuth').val();
if(arrazi>=0 && arrazi<=360){

}else{
    alert("Array Azimuth is not acceptable.");
    return;
}
$("#displayloading").show();

                    $.ajax({
			type: "POST",
			url: "<?=base_url()?>proposal/validate_proppvwatts",
			data: $('#proposal_pvwatts').serialize(),
			dataType: "json",
			success: function(json) {
				if(json.success == true)
				{
				      window.location.reload();
				}
				else
				{
					$("#displayloading").hide();
                                        $(".form-errors").html(json.msg);
					$(".form-errors").fadeIn();
				}
			}
		});

  });
});

</script>