<?php

    class Dayview extends Controller {
	function Dayview()
	{
            parent::Controller();
            if(!$this->session->userdata('logged_in'))
            {
                $tempurl = explode("/index.php/", $_SERVER['PHP_SELF']);
                redirect("login?ref=".$tempurl[1]);
            }
            $this->load->helper(array('form', 'url'));
	}
        
        function index() {
            $date3 = $this->input->get("datepicker3_txt");
            $date2 = $this->input->get("datepicker2_txt");
            $date1 = $this->input->get("datepicker1_txt");

            $data = array();
            $data['date']=date("M d,Y");
            $data['display']=1;
            $date_filter = "";
            $data["dateinterval"] = false;
            $data["date_range"] = false;
            if (isset($date3) && trim($date3) != "") {
                $data["date3"] = $date3;
                $explode_date = explode(";", $date3);
                $date_array = array();
                foreach ($explode_date as $datedata) {
                    $date_array[] = "'" . date("Y-m-d", strtotime($datedata)) . "'";
                }
                $date_filter = "jobs.job_date in (" . implode(",", $date_array) . ")";
                $data["dateinterval"] = true;
                $data['date']=date("M d,Y", strtotime($date3));
                $data['display']=0;
            } else if (isset($date1) && isset($date2) && strtotime($date1) > 0 && strtotime($date2) > 0) {
                $newdate1 = date("Y-m-d", strtotime($date1));
                $newdate2 = date("Y-m-d", strtotime($date2));
                $data["date2"] = $date2;
                $data["date1"] = $date1;
                $date_filter = "jobs.job_date >='$newdate1' AND jobs.job_date<='$newdate2'";
                $data["date_range"] = true;
                $data['date']=date("M d,Y", strtotime($date1))."-".date("M d,Y", strtotime($date2));
                $data['display']=1;
            } else {
                $date_filter = "jobs.job_date='" . date("Y-m-d") . "'";
                $data['display']=0;
            }
            //START JOB FILTER
            
            $data['reasons']['ok'] = 'OK';
            $data['reasons']['1'] = 'SIC';
            $data['reasons']['3'] = 'VAC';
            $data['reasons']['9'] = 'OFF';
            
            $filter = array();
            if($this->input->get("pv")){
               array_push($filter,2);
            }
            if($this->input->get("ac")){
                array_push($filter,16);
            }
            if($this->input->get("swh")){
                array_push($filter,1);
            }
            if($this->input->get("pm")){
                array_push($filter,7);
            }
            if($this->input->get("ass")){
                array_push($filter,15);
            }
            if($this->input->get("sc")){
                array_push($filter,5);
            }
            if(count($filter)>0)
                $filter = implode(",",$filter);
            else
                $filter = 0;
            $pv_sql =" AND jobs.job_type_id in(2,16,1,15,5,7)";
            if( $filter){
            $pv_sql = " AND jobs.job_type_id in($filter)";
           }
            //END JOB FILTER
            //Start Code by vikas on 03-03-2016
            $RightsideExist = 1;
            $filterDate = 0;
            if (isset($date1) && isset($date2) && strtotime($date1) > 0 && strtotime($date2) > 0) {
                $from_date = (strtotime($date1)) ? date('m/d/Y', strtotime($date1)) : '';
                $end_date = (strtotime($date2)) ? date('m/d/Y', strtotime($date2)) : '';
                if($from_date == $end_date){
                    $filterDate = date('Y-m-d',  strtotime($date1));
                    $displayTeams = "block";
                }else{
                    $displayTeams = "none";
                    $RightsideExist = 0;
                }
            }else if (isset($date3) && trim($date3) != "" && strtotime($date3) > 0) {
                $filterDate = date('Y-m-d',  strtotime($date3));
                $displayTeams = "block";
            }else{
                $filterDate = date('Y-m-d');
                $displayTeams = "block";
            }
            $data["filterDate"] = $filterDate;
            
            $data["displayTeams"] = $displayTeams;
            $data["RightsideExist"] = $RightsideExist;
            $data['team_details'] = array();
            $data['team_types'] = array();
            
            $this->db->order_by('type', 'asc');
            $inverter_types = $this->db->get("inverter_types")->result_array();
            foreach ($inverter_types as $row) {
                $data['inverter_types'][$row['id']] = $row['type'];
            }
            
            $j = array();
            $jobs = array();
            $j = $this->db->query("SELECT jobs.*, jobs.system_type,colors.hex, users.custom_hex, users.id as user_id ,users.first_name as ufirstname ,
                users.last_name ulastname, cs.first_name as csfirstname ,
                cs.last_name as cslastname ,cs.address as csstate,cs.city as cscity,cs.association as  csassociation,cs.zip_code as  zip_code,
                job_types.intials as job_type
                FROM jobs
                LEFT JOIN job_types ON job_types.id=jobs.job_type_id
                LEFT JOIN  customers cs ON jobs.customer_id = cs.id
                LEFT JOIN users ON jobs.user_id=users.id
                LEFT JOIN colors ON users.color_id=colors.id
                WHERE $date_filter $pv_sql ORDER BY jobs.job_date ASC ,job_type ASC")->result_array();
            //echo '<pre>';print_r($j);die;
            $this->db->where("type", "installer");
            $this->db->order_by("first_name", "desc");
            $installeruser = $this->db->get("users")->result_array();
            $installer_data = array();
            $output = array();
            $jobdatearray = array();
            $job_id_list=array();
                
            foreach ($j as $key => $value) {  
                array_push($job_id_list,$value['id']);
                $conductid_arr = array();
                $temp_array = array();
                $jobdatetimestamp = strtotime($value["job_date"]);
                $temp_array["job_date"] = $jobdatetimestamp;
                $temp_array["id"]= $value['id'];
                
                if($value['job_type']=='PV'){
                    $temp_array["inverter_count"]= $value['inverter_count'];
                    $temp_array["inverter_type_id"]= $value['inverter_type_id'];
                }else{
                    $temp_array["inverter_count"]= 0;
                    $temp_array["inverter_type_id"]= 0;
                }
                
                $temp_array["description"]= $value['servicedesc'];
                $temp_array["labour_allocated"]= $value['labour_allocated'];
                $temp_array["repair_time"]= $value['repair_time'];
                $temp_array["eat_time"]= $value['eat_time'];
                $temp_array["edt_time"]= $value['edt_time'];
                $temp_array["system_type"]= $value['system_type'];
                $temp_array["eng_id"]= $value['project_designer_id'];
                $ZipArea='';$ZipArea = explode("->", $this->getArea($value['zip_code']));
                $temp_array["city"]= $ZipArea[0];
                $temp_array["citycolor"] = $this->getCustomerNeighborhoodColor($value['customer_id']);
                $temp_array['id'] = $value['id'];
                $temp_array['type'] = $value['job_type'];
                $temp_array['rel_job'] = $this->getrelatedjob($value["job_pid"], $value["id"]);
                $temp_array['cname'] = ucfirst($value["csfirstname"]) . " " . ucfirst($value["cslastname"]);
                $temp_array['salesman'] = ucfirst($value["ufirstname"]);
                $temp_array['comments'] = $value["comments"];
                $temp_array['proposal_id'] = $value["proposal_id"];
                $proposal_id=$this->getProposalId($value["job_pid"]);
                if($value['job_type']=='SWH' ||$value['job_type']=='WM'){
                    $temp_array['nom'] = $value["panel_count"];
                }else if($value['job_type']=='SAF' || $value['job_type']=='EV'){
                    $temp_array['nom'] = $value["no_of_saf"];
                }else if($value['job_type']=='AC' || $value['job_type']=='APM' || $value['job_type']=='AS' ){
                    $temp_array['nom'] =  $this->getunit($proposal_id);
                }else{
                    $temp_array['nom'] = $value["job_nom"];
                }
                
                $newstories = "";
                if (isset($value["stories"]) && $value["stories"] != "") {
                    $newstories = $value["stories"] . " / ";
                }
                $temp_array['rooftype'] = @$newstories . $this->getidothervalue($value['roof_type_id'], $value['other_roof_type'], 'roof_types', 'type');
                $installer_id_table = array();
                $installer_id_table = explode(",", $value['installer_id']);
                $newnoassign = array();
                foreach ($installer_id_table as $id) {
                    if ($this->getUserIntial($id, true))
                        $newnoassign[] = '<div class="instBox" id="rinstaller' . $id . $value['id'] . '"><a href="javascript:void(0);" >' . $this->getUserIntial($id, true) . '</a><a  onclick="removeinstaller(' . $id . ',' . $value['id'] . ')" href="javascript:void(0);" class="instCross"></a></div>';
                }
                
                if (count($newnoassign) >= 1)
                    $temp_array['installer'] = implode(" ", $newnoassign);
                else {
                    $temp_array['installer'] = "";
                }
                $temp_array['varibleLaborCost']=$this->getAllvaribleLaborCost($proposal_id,$value["job_type_id"],$value["location_access"]);
                $temp_array['note'] = $this->getnote($value["job_pid"]);
                $output[] = $temp_array;
                
            
            }
            
                if(count($job_id_list)>0)
                      $job_id_list = implode(",",$job_id_list);
                 else
                     $job_id_list = 0;
                     $job_id_sql ="";
                 if( $job_id_list){
                     $job_id_sql = " AND job_id in($job_id_list)"; 
                 }
                 
             if(@$RightsideExist){
                $filter_by_date = "and DATE_FORMAT(request.start_date,'%Y-%m-%d') <= '".$filterDate."' AND DATE_FORMAT(request.end_date,'%Y-%m-%d') >= '".$filterDate."'";
                $team_types = $this->db->query("select * from technician_team_types order by id")->result_array();
                $data['team_types'] = $team_types;
                foreach ($team_types as $types)
                {
                    $teamsInType = array();
                    $teamsInType = $this->db->query("select distinct id from technician_teams where team_type_id=".$types['id']."")->result_array();
                    if(count($teamsInType)>0){
                        $count=1;
                        foreach ($teamsInType as $TeamsName)
                        {
                            $team_wise_tech = array();
                            $team_wise_tech = $this->db->query("select team_names.id as technician_team_id, team_names.created as team_created,team_names.team_name,assigns.technician_id_time,assigns.technician_id_pheo,assigns.technician_email,assigns.assigned FROM technician_teams as team_names LEFT JOIN technicians_assign as assigns ON team_names.id=assigns.team_id where team_names.id=".$TeamsName['id']." and assigns.team_type_id=".$types['id']." and team_names.team_type_id=".$types['id']."")->result_array();
                            if(count($team_wise_tech)>0){
                                $technician_id_time = '';$technician_id_pheo='';$technicians_names='';
                                
                                foreach($team_wise_tech as $Technicians)
                                {
                                    $technicians_names = $this->GetUserName($Technicians['technician_id_pheo'],true);
                                    $technicianss_name = rtrim($technicians_names, ", ");
                                    
                                    $technicians_type = $this->GetTechnicianType($Technicians['technician_id_pheo']);
                                    $team_wise_data['technicians_type'] = $technicians_type;
                                    
                                    $team_wise_data['technicians_names'] = $technicianss_name;
                                    $team_wise_data['team_type_id'] = $types['id'];
                                    $team_wise_data['technician_team_id'] = $TeamsName['id'];
                                    $team_wise_data['team_type'] = $types['team_type_name'];
                                    $team_wise_data['assigned'] = $this->check_assigned(@$Technicians['technician_id_pheo'],@$TeamsName['id'],@$job_id_sql);
                                    $team_wise_data['team_name'] = $Technicians['team_name'];
                                    $team_wise_data['team_created'] = $Technicians['team_created'];
                                    
                                    $team_wise_data['technician_id_time'] = $Technicians['technician_id_time'];
                                    $team_wise_data['technician_id_pheo'] = $Technicians['technician_id_pheo'];
                                    
                                    $team_wise_data['techInTeam'] = ucfirst($Technicians['team_name'][0]).ucfirst($Technicians['team_name'][1]).$count;                      
                                    
                                    $this->db2 = $this->load->database('otherdb', true);
                                    $request_details = $this->db2->query("select request.*, emp_users.first_name,emp_users.last_name,emp_users.id as user_id,codes.name as reason FROM emp_timeoff_request as request LEFT JOIN emp_users ON request.user_id=emp_users.id LEFT JOIN absence_codes as codes ON request.timeoff_reason=codes.id WHERE request.user_id='".$Technicians['technician_id_time']."' $filter_by_date order by request.id desc limit 1");
                                    $details = $request_details->row_array();
                                    
                                    //echo $this->db2->last_query();die;
                                    if(count($details)>0){
                                        if($details['request_status'] == 'approved' && $details['confirm_request'] == 'Y'){
                                            $team_wise_data['technician_status'] = ucfirst($details['reason'][0]).ucfirst($details['reason'][1]).ucfirst($details['reason'][2]);
                                            $team_wise_data['timeoff_request_id'] = $details['id'];
                                        }else{
                                            $team_wise_data['technician_status'] = 'OK';
                                            $team_wise_data['timeoff_request_id'] = 0;
                                        }
                                    }else{
                                        $team_wise_data['technician_status'] = 'OK';
                                        $team_wise_data['timeoff_request_id'] = 0;
                                    }
                                    
                                    $from_W_date=date('Y-m-d',strtotime('last Sunday'));
                                    $to_W_date=date('Y-m-d',  strtotime('+6 days',strtotime('last Sunday')));
                                    
                                    $q=$this->db2->query("SELECT t_c.* FROM user_calculated_time_sheet_details as t_c where t_c.user_id ='".$Technicians['technician_id_time']."' and (status='Submitted' or status='Approved') and t_c.submited_date BETWEEN  '".$from_W_date."' and '".$to_W_date."'");   
                                    if($q->num_rows()){
                                        $TimeSheetdetails = $q->row_array();
                                        $team_wise_data['technician_worked_hours'] = $TimeSheetdetails['reg_hrs']+$TimeSheetdetails['ot'];
                                    }else{
                                        $team_wise_data['technician_worked_hours'] = 0;
                                    }
                                    $this->db2->close();
                                    $data['team_details'][$types['id']][$Technicians['team_name']][] = $team_wise_data;
                                }
                                $count++;
                            }
                        }
                    }
                }
            }
            //echo '<pre>';print_r($data['team_details']);die;
            $data["jobs"] = $output;
            $data["technicians_details_jobwise"]=$this->db->query("SELECT * from technicians_in_jobs order by created")->result_array();
            $this->load->view("dayview/index", $data);
        }
        
        function save_reason(){
            $timesheetId =   $this->input->post("timesheetId");
            $reasonValue = $this->input->post("did");
            $timeOffid = $this->input->post("timeOffid");
            $timeStamp = $this->input->post("timeStamp");
            $start_date = date('Y-m-d',$this->input->post("timeStamp"));
            
            $row = array();
            $row['user_id'] = $this->input->post("timesheetId");
            $row['start_date'] = date('Y-m-d',$this->input->post("timeStamp"));
            $row['end_date'] = date('Y-m-d',$this->input->post("timeStamp"));
            $row['hours_leave'] = 8;
            $row['request_date']=date('Y-m-d H:i:s');
            
            if($reasonValue == 1){
                $row['deduct_from_bank'] = 4;
                $row['timeoff_reason'] = 1;
            }else if($reasonValue == 3){
                $row['deduct_from_bank'] = 2;
                $row['timeoff_reason'] = 3;
            }else if($reasonValue == 9){
                $row['deduct_from_bank'] = 3;
                $row['timeoff_reason'] = 9;
            }else{
                $row['deduct_from_bank'] = 9999;
                $row['timeoff_reason'] = 9999;
            }
            
            $this->db2 = $this->load->database('otherdb', true);
            $row_plan = $this->db2->query("SELECT * FROM emp_timeoff_request WHERE user_id=".$timesheetId." and id=".$timeOffid."")->row_array();
            if(count($row_plan) > 0){
                if($reasonValue == 'ok'){
                    $row['request_status']= 'pending';
                    $row['confirm_request']= 'N';
                    $this->db2->where(array('user_id' => $timesheetId, 'id' => $timeOffid));
                    $this->db2->update("emp_timeoff_request",$row);
                }else{
                    $row['request_status']= 'approved';
                    $row['confirm_request']= 'Y';
                    $this->db2->where(array('user_id' => $timesheetId, 'id' => $timeOffid));
                    $this->db2->update("emp_timeoff_request",$row);
                }
            }else{
                if($reasonValue == 'ok'){
                    $row['deduct_from_bank'] = 0;
                }else{
                    $row['request_status']= 'approved';
                    $row['confirm_request']= 'Y';
                    $this->db2->insert("emp_timeoff_request",$row);
                }
            }
            //$this->db2->last_query();die;
            $json['success'] = true;
            $this->db2->close();
            $json['reasonValue'] = $reasonValue;
            echo json_encode($json);
        }
        
    //start new code on 07/03/2016      
        function exportjob() {
            $this->load->helper('download');
            $date3 = $this->input->get("datepicker3_txt");
            $date2 = $this->input->get("datepicker2_txt");
            $date1 = $this->input->get("datepicker1_txt");
            $data = array();
            $data['date']=date("M d,Y");
            $data['display']=1;
            $date_filter = "";
            $data["dateinterval"] = false;
            $data["date_range"] = false;
            if (isset($date3) && trim($date3) != "") {
                $data["date3"] = $date3;
                $explode_date = explode(";", $date3);
                $date_array = array();
                foreach ($explode_date as $datedata) {
                    $date_array[] = "'" . date("Y-m-d", strtotime($datedata)) . "'";
                }
                $date_filter = "jobs.job_date in (" . implode(",", $date_array) . ")";
                $data["dateinterval"] = true;
                $data['date']=date("M d,Y", strtotime($date3));
                $data['display']=0;
            } else if (isset($date1) && isset($date2) && strtotime($date1) > 0 && strtotime($date2) > 0) {
                $newdate1 = date("Y-m-d", strtotime($date1));
                $newdate2 = date("Y-m-d", strtotime($date2));
                $data["date2"] = $date2;
                $data["date1"] = $date1;
                $date_filter = "jobs.job_date >='$newdate1' AND jobs.job_date<='$newdate2'";
                $data["date_range"] = true;
                $data['date']=date("M d,Y", strtotime($date1))."-".date("M d,Y", strtotime($date2));
                $data['display']=1;
            } else {
                $date_filter = "jobs.job_date='" . date("Y-m-d") . "'";
            }
            //START JOB FILTER
            
            $filter = array();
            if($this->input->get("pv")){
               array_push($filter,2);
            }
            if($this->input->get("ac")){
                array_push($filter,16);
            }
            if($this->input->get("swh")){
                array_push($filter,1);
            }
            if($this->input->get("pm")){
                array_push($filter,7);
            }
            if($this->input->get("ass")){
                array_push($filter,15);
            }
            if($this->input->get("sc")){
                array_push($filter,5);
            }
            if(count($filter)>0)
                $filter = implode(",",$filter);
            else
                $filter = 0;
            $pv_sql =" AND jobs.job_type_id in(2,16,1,15,5,7)";
            if( $filter){
            $pv_sql = " AND jobs.job_type_id in($filter)";
           }
        $j = array();
        $jobs = array();
        $j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id ,users.first_name as ufirstname ,
            users.last_name ulastname, cs.first_name as csfirstname ,
            cs.last_name as cslastname ,cs.address as csstate,cs.city as cscity,cs.association as  csassociation,cs.zip_code as  zip_code,
            job_types.intials as job_type
            FROM jobs
            LEFT JOIN job_types ON job_types.id=jobs.job_type_id
            LEFT JOIN  customers cs ON jobs.customer_id = cs.id
            LEFT JOIN users ON jobs.user_id=users.id
            LEFT JOIN colors ON users.color_id=colors.id
            WHERE $date_filter $pv_sql ORDER BY jobs.job_date ASC")->result_array();
        
         $temp_array = array();
         $output = array();
         $data['j']=$j;       
                $module_position=1;
                $output="";
                $headingoutput=array();
                $headingoutput[]="SRno.";
                $headingoutput[]="Job Type.";
                $headingoutput[]="Customer Name";
                $headingoutput[]="Sales";
                $headingoutput[]="Engineer";
                $headingoutput[]="Area";
                $headingoutput[]="Related Job";
                $headingoutput[]="Panels/Units";
                $headingoutput[]="Stories/Roof Type";
                $headingoutput[]="Time Allocated";
                $headingoutput[]="Time(For SC)";
                $headingoutput[]="Labour Allocated";
                $headingoutput[]="Notes";
                $headingoutput[]="Discription(For SC)";
                $output.="\n".implode(",",$headingoutput);
                
                $row_output=array();
                $job=$data['j']; 
                if (count($job)==0 ){ 
                $row_output[]="No Details \n";
                $output.="\n".implode(",",$row_output);
              
            } else{
            $k=1;
            
            foreach ($j as $key => $value) {
                       $row_output[]= $k;
                       $k++;
                       $row_output[]=$value['job_type'];
                       $row_output[]= ucfirst($value["csfirstname"]) . " " . ucfirst($value["cslastname"]);
                       $row_output[]= ucfirst($value["ufirstname"]);
                       $row_output[]=$this->getEng(@$value['project_designer_id']);
                       $ZipArea='';$ZipArea = explode("->", $this->getArea($value['zip_code']));
                       $row_output[]= $ZipArea[0];
                       $row_output[]=$this->getrelatedjobforexcel($value["job_pid"], $value["id"]);
                            $proposal_id=$this->getProposalId($value["job_pid"]);
                            if($value['job_type']=='SWH' ||$value['job_type']=='WM'){
                                $temp_array['nom'] = $value["panel_count"];
                            }else if($value['job_type']=='SAF' || $value['job_type']=='EV'){
                                $temp_array['nom'] = $value["no_of_saf"];
                            }else if($value['job_type']=='AC' || $value['job_type']=='APM' || $value['job_type']=='AS' ){
                                $temp_array['nom'] =  $this->getunit($proposal_id);
                            }else{
                                $temp_array['nom'] = $value["job_nom"];
                            }
                       $row_output[]= $temp_array['nom'];
                       $row_output[]=@$value["stories"] . $this->getidothervalue($value['roof_type_id'], $value['other_roof_type'], 'roof_types', 'type');
                       $row_output[]= $this->getAllvaribleLaborCost($proposal_id,$value["job_type_id"],$value["location_access"]); 
                         if(@$value['repair_time']==0){
                                $repair_type="None";
                        }
                        else if(@$value['repair_time']==1){
                            $repair_type="	9:00am - 12:00pm ";
                        }else if(@$value['repair_time']==2){
                             $repair_type="1:00pm - 04:00pm";
                        }else{
                             $repair_type=@$value['edt_time'].'-'.@$value['eat_time'];

                        }
                       $row_output[] = $repair_type;
                       $row_output[] = $value["labour_allocated"];
                       $row_output[] = $value["comments"];
                       $row_output[] = $value["servicedesc"];
                       $output.="\n".implode(",",$row_output);
                       $row_output=array();
           
                       }
                   }
                force_download("Technicianassign.csv", $output);
       }
   //End new code on 07/03/2016
       
       
        function GetTechnicianType($id=0) {
            if (!$id)
                return 0;
            $intial = 0;
            $j = $this->db->query("SELECT * FROM users WHERE id=$id")->row_array();
            if($j['type'] == 'lead_tech'){
                $intial = 'L';
            }
            return $intial;
        }
    
        function GetUserName($id=0, $fullname = false) {
            if (!$id)
                return 0;
            $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
            $intial = "";
            foreach ($j as $key => $value) {
                $intial = ucfirst($value['first_name'][0]) . strtoupper($value['last_name'][0] . $value['last_name'][1]);
                if ($fullname) {
                    $intial = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
                }
            }
            if(strlen($intial)>15){
                $intial = substr($intial,0,25)."..";
            }
            return $intial;
        }
        
        function getEng($id){ 
           if (!$id)
               return "";
           if($id>0){
                $j = $this->db->query("SELECT first_name, last_name FROM users WHERE  id =$id ")->result_array();
                if(isset($j[0]['first_name'])||isset($j[0]['last_name']))
                    return ucfirst($j[0]['first_name']) . " " . ucfirst($j[0]['last_name']);
            } else{
                return " ";
            }
        }
        
        function getdayinstaller($job_date) {
            $rs = $this->db->query("SELECT installer_id FROM jobs WHERE  job_date='$job_date' ")->result_array();
            $temp = array();
            foreach ($rs as $key => $value) {
                $temp[] = $value['installer_id'];
            }
            if (count($temp)) {
                return implode(",", $temp);
            }
        }

        function getidothervalue($other, $id, $tablename, $column = "*") {
            if ($other == "other" || $other == "" || !$other) {
                return $id;
            }
            $j = $this->db->query("SELECT $column  FROM $tablename  WHERE  id =$other")->result();
            
            if (isset($j[0]->$column))
                return $j[0]->$column;
            else
                return "";
        }

        function getUserIntial($id, $fullname = false) {
            if (!$id)
                return 0;
            $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
            $intial = "";
            foreach ($j as $key => $value) {
                $intial = ucfirst($value['first_name'][0]) . ucfirst($value['last_name'][0]);
                if ($fullname) {
                    $intial = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
                }
            }
            return $intial;
        }
        
        function getUserEmpNo($id, $fullname = false) {
            if (!$id)
                return 0;
            $j = $this->db->query("SELECT emp_num FROM users WHERE id=$id")->result_array();
            if ($j[0]['emp_num'] > 0) {
                return $j[0]['emp_num'];
            }
            return $id;
        }
        
        function getUserFirstName($id) {
            if (!$id)
                return 0;
            $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
            $intial = "";
            foreach ($j as $key => $value) {
                $intial = ucfirst($value['first_name']);
            }
            return $intial;
        }

        function getCustomerNeighborhoodColor($id) {
            if (!$id)
                return '#ffffff';
            $neighborhood = "";
            $value = $this->db->query("SELECT neighborhood,other_neighborhood FROM customers WHERE id=$id")->row_array();
            if (isset($value['neighborhood'])) {
                if ($value['neighborhood'] == "other") {
                    return;
                } else {
                    if (isset($value['neighborhood']) && $value['neighborhood'] != "" && is_numeric($value['neighborhood'])) {
                        $sql = "SELECT neighbour,color from  neigbhour where id=" . $value['neighborhood'];
                        $row_neighbour = $this->db->query($sql)->row_array();
                        return @$row_neighbour['color'];
                    } else {
                        return "#ffffff";
                    }
                }
            }
            return @$neighborhood;
        }

        function getCustomerNeighborhood($id) {
            if (!$id)
                return 0;
            $neighborhood = "";
            $j = $this->db->query("SELECT neighborhood,other_neighborhood FROM customers WHERE id=$id")->result_array();
            foreach ($j as $key => $value) {
                if (isset($value['neighborhood'])) {
                    if ($value['neighborhood'] == "other") {
                        $neighborhood = ucfirst($value['other_neighborhood']);
                    } else {
                        if (isset($value['neighborhood']) && $value['neighborhood'] != "" && is_numeric($value['neighborhood'])) {
                            $sql = "SELECT neighbour from  neigbhour where id=" . $value['neighborhood'];
                            $row_neighbour = $this->db->query($sql)->row_array();
                            $neighborhood = ucfirst(@$row_neighbour['neighbour']);
                        } else {
                            $neighborhood = $value['neighborhood'];
                        }
                    }
                }
            }
            if (strlen($neighborhood) > 20) {
                $neighborhood = substr($neighborhood, 0, 20) . "..";
            }
            return @$neighborhood;
        }
        
        function getCustomerLastname($id) {
            if (!$id)
                return 0;

            $j = $this->db->query("SELECT last_name FROM customers WHERE id=$id")->result_array();
            foreach ($j as $key => $value) {
                $lastname = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
            }
            return @$lastname;
        }
        
        function getnote($job_id) {
            $notes = $this->db->query("select *  from notes where job_id=$job_id ")->result_array();
            $return_note_array = array();
            foreach ($notes as $note) {
                $return_note_array[] = @$note["note"] . "(Posted by:" . $this->getUserIntial($note["user_id"], true) . ", " . date("m/d/y", strtotime($note["created"])) . ")";
            }
            return implode(",", $return_note_array);
        }
        
        function getrelatedjob($job_pid, $job_id) {
            $sql = "SELECT jobs.*, job_types.intials as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_pid=" . $job_pid . " AND jobs.id!=" . $job_id . " ORDER BY jobs.job_date ASC";
            $related_job = $this->db->query($sql)->result_array();
            $link = array();
            foreach ($related_job as $jobs) {
                $link[] = "<a  target='_blank' style='text-decoration:underline;' href='" . base_url() . "admin/job/" . $jobs["id"] . "'>" . $jobs["job_type"] . date("m/d/y", strtotime($jobs["job_date"])) . "</a>";
            }
            return implode(",", $link);
        }

        function getrelatedjobforexcel($job_pid, $job_id) {
            $sql = "SELECT jobs.*, job_types.intials as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_pid=" . $job_pid . " AND jobs.id!=" . $job_id . " ORDER BY jobs.job_date ASC";
            $related_job = $this->db->query($sql)->result_array();
            $link = array();
            foreach ($related_job as $jobs) {
                $link[] = "" . $jobs["job_type"] . date("m/d/y", strtotime($jobs["job_date"])) . "";
            }
            return implode(",", $link);
        }

        function getparentjobid($job_id) {
            $resultcnt = $this->db->query("SELECT job_pid FROM jobs  where id = $job_id")->result_array();
            $pid = $resultcnt[0]['job_pid'];
            if (!$pid) {
                $pid = $job_id;
            }
            return $pid;
        }

        function savecomment($id) {
            $row = array();
            $pid = $this->getparentjobid($id);
            $row["comments"] = $this->input->post("comments");
            $this->db->where("job_pid", $pid);
            $this->db->update("jobs", $row);
            $json["success"] = true;
            echo json_encode($json);
        }

        function addinstaller($job_id) {
            $pid = $this->getparentjobid($job_id);
            $rs_installer = $this->db->query("select concat('0',installer_id) as installer_id from jobs where id=job_pid AND job_pid=$pid")->row_array();
            if (isset($rs_installer["installer_id"]) && $rs_installer["installer_id"] != "") {
                $sql = "SELECT * FROM users WHERE  type='installer' and id not in (" . $rs_installer["installer_id"] . ")";
            } else {
                $sql = "SELECT * FROM users WHERE  type='installer' ";
            }
            $data['users'] = $this->db->query($sql)->result_array();
            $user_select = array();
            foreach ($data['users'] as $users) {
                $user_select[$users['id']] = ucfirst($users['first_name']) . " " . ucfirst($users['last_name']);
            }
            $data['job_id'] = $job_id;
            
            $data['saleuser'] = $user_select;
            $this->load->view("exportapi/salesuser", $data);
        }
        
        function updatejobinstaller($job_id) {
            $row = array();
            $pid = $this->getparentjobid($job_id);
            $exist_installer = $this->db->query("select installer_id from jobs where id=job_pid AND job_pid=$pid")->row_array();
            $array_installer = explode(",", $exist_installer["installer_id"]);
            $installer_r = array();
            foreach ($array_installer as $value) {
                if ($value == $this->input->post("installer_id")) {
                    $json['success'] = true;
                    echo json_encode($json);
                    return;
                }
            }
            $row['installer_id'] = $exist_installer["installer_id"] . "," . $this->input->post("installer_id");
            $this->db->where("job_pid", $pid);
            $this->db->update("jobs", $row);
            $json['success'] = true;
            echo json_encode($json);
        }
        
        function removeinstaller($job_id, $id) {
            $row = array();
            $pid = $this->getparentjobid($job_id);
            $exist_installer = $this->db->query("select installer_id from jobs where id=job_pid AND job_pid=$pid")->row_array();
            $array_installer = explode(",", $exist_installer["installer_id"]);
            $installer_r = array();
            foreach ($array_installer as $value) {
                if ($value == $id)
                    continue;
                $installer_r[] = $value;
            }
            $row['installer_id'] = implode(",", $installer_r);
            $this->db->where("job_pid", $pid);
            $this->db->update("jobs", $row);
            $json['success'] = true;
            echo json_encode($json);
        }

        function getinstallerjson() {
            $firstname = $this->input->get("term");
            $row = $this->db->query("SELECT * FROM users WHERE  type='installer'  AND first_name like '$firstname%' ")->result_array();
            $installer_json = array();
            foreach ($row as $installer) {
                $installer_pre['id'] = $installer["id"];
                $installer_pre['value'] = ucfirst($installer["first_name"]) . " " . ucfirst($installer["last_name"]);
                $installer_json[] = $installer_pre;
            }
            echo json_encode($installer_json);
        }

        function getinstallerbyname() {
            $name = @trim($this->input->post("term"));
            $name = str_replace('"', "", $name);
            $explodename = array();
            $explodename = explode(" ", $name);
            if (count($explodename) != 2) {
                $installer_json["success"] = false;
                echo json_encode($installer_json);
                die;
            }
            $firstname = $explodename[0];
            $lastname = $explodename[1];
            // echo "SELECT * FROM users WHERE  type='installer'  AND first_name='$firstname' AND last_name='$lastname' ";
            $row = $this->db->query("SELECT * FROM users WHERE  type='installer'  AND first_name='$firstname' AND last_name='$lastname' ")->row_array();
            $installer_json = array();
            if (isset($row["id"]) && $row["id"] > 0) {
                $installer_json["success"] = true;
                $installer_json["id"] = $row["id"];
                $installer_json["name"] = ucfirst($row['first_name']) . " " . ucfirst($row["last_name"]);
                echo json_encode($installer_json);
                die;
            }
            $installer_json["success"] = false;
            echo json_encode($installer_json);
        }
        
        function getlaboucost($proposal_id) {
            if ($proposal_id < 11390) {
                $sql = "SELECT sum(variable_job.price*variable_job.quantity) as sumlabour
    FROM variable_job
    LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
    AND variable_job.proposal_id=system_price_proposal.proposal_id
    where variable_job.proposal_id=$proposal_id
    AND  variable_job.variable_id in (23,17,69)
    order by variable_job.id";
                $row = $this->db->query($sql)->row_array();
                $sql_elec = "SELECT sum(variable_job.price*variable_job.quantity) as sumlabour
    FROM variable_job
    LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
    AND variable_job.proposal_id=system_price_proposal.proposal_id
    where variable_job.proposal_id=$proposal_id
    AND  variable_job.variable_id in (29,31)
    order by variable_job.id";
                $row_elec = $this->db->query($sql_elec)->row_array();
                if (!$row_elec) {
                    $sql_elec = "SELECT sum(variable_job.price*variable_job.quantity) as sumlabour
    FROM variable_job
    LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
    AND variable_job.proposal_id=system_price_proposal.proposal_id
    where variable_job.proposal_id=$proposal_id
    AND  variable_job.variable_id in (100,101,102)
    order by variable_job.id";
                    $row_elec = $this->db->query($sql_elec)->row_array();
                }
                return round($row["sumlabour"] / 40) . " roof/" . round($row_elec["sumlabour"] / 40) . 'elec';
            } else {

                $sql = "SELECT sum(variable_job.quantity) as sumlabour
    FROM variable_job
    LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
    AND variable_job.proposal_id=system_price_proposal.proposal_id
    where variable_job.proposal_id=$proposal_id
    AND  variable_job.variable_id in (206,207)
    order by variable_job.id";
                $row = $this->db->query($sql)->row_array();
                $sql_elec = "SELECT sum(variable_job.quantity) as sumlabour
    FROM variable_job
    LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
    AND variable_job.proposal_id=system_price_proposal.proposal_id
    where variable_job.proposal_id=$proposal_id
    AND  variable_job.variable_id in (101,102)
    order by variable_job.id";
                $row_elec = $this->db->query($sql_elec)->row_array();
                return round($row["sumlabour"]) . " roof/" . round($row_elec["sumlabour"]) . 'elec';
            }
        }

        function getallsalesuser() {
            $sql = "SELECT * FROM users WHERE  type='sales'";
            $data['users'] = $this->db->query($sql)->result_array();
            $user_select = array();
            foreach ($data['users'] as $users) {
                $user_select[$users['id']] = ucfirst($users['first_name']) . " " . ucfirst($users['last_name']);
            }
            $user_select['all'] = 'All';
            $data['saleuser'] = $user_select;
            $data['jobtype_list'] = array("" => "-Please select job type-", "all" => "All jobs", 2 => "PV", 1 => "SWH", 16 => "HVAC", 21 => "EV", 20 => "SAF", 6 => "PV+SWH", 7 => "PV+AC", 8 => "PV+SWH+AC", 9 => "Sold", 10 => "Non-Sold");
            $this->load->view("exportapi/salesuser", $data);
        }

        function downloadcsv($saleuser_id, $job_type_select = '') {
            $this->load->helper('csv');
            $this->load->helper('download');
            $jobtype_select = $job_type_select;
            if ($job_type_select == '') {
                $jobtype_select = "all";
            }
            if ($jobtype_select == "all" || $jobtype_select == 2 || $jobtype_select == 1 || $jobtype_select == 16 || $jobtype_select == 21 || $jobtype_select == 20 || $jobtype_select == 6 || $jobtype_select == 7 || $jobtype_select == 8 || $jobtype_select == "all") {
                if ($jobtype_select == "all") {
                    $sql_jobtype = "";
                }
                if ($jobtype_select == 2) {
                    $sql_jobtype = "and jobs.job_type_id=2";
                } else if ($jobtype_select == 1) {
                    $sql_jobtype = "and jobs.job_type_id=1";
                } else if ($jobtype_select == 16) {
                    $sql_jobtype = "and jobs.job_type_id=16";
                } else if ($jobtype_select == 21) {
                    $sql_jobtype = "and jobs.job_type_id=21";
                } else if ($jobtype_select == 20) {
                    $sql_jobtype = "and jobs.job_type_id=20";
                } else if ($jobtype_select == 6) {
                    $sql_jobtype = "and (jobs.job_type_id=2 or jobs.job_type_id=1)";
                } else if ($jobtype_select == 7) {
                    $sql_jobtype = "and (jobs.job_type_id=2 or jobs.job_type_id=16)";
                } else if ($jobtype_select == 8) {
                    $sql_jobtype = "and (jobs.job_type_id=2 or jobs.job_type_id=16 or jobs.job_type_id=1)";
                } else {
                    $sql_jobtype = "";
                }
                $saleuser_filter = "";
                if ($saleuser_id == 'all') {
                    $saleuser_filter = "";
                } else {
                    $saleuser_filter = "AND jobs.user_id=$saleuser_id";
                }
                $sql = "SELECT distinct first_name,last_name,email FROM  jobs left join customers  on jobs.customer_id=customers.id where 1=1 AND email is not null AND email!=''  $sql_jobtype $saleuser_filter order by first_name";
                $row = $this->db->query($sql)->result_array();
                $output = "";
                $output .= "First Name,Last Name ,Email\n";
                foreach ($row as $data) {
                    $output .= ucfirst(str_replace(",", "", $data['first_name'])) . ", " . ucfirst(str_replace(",", "", $data['last_name'])) . "," . $data['email'] . "\n";
                }

                if ($saleuser_id == 'all') {

                    force_download("All Customer's list.csv", $output);
                } else {
                    $userload = $this->getUserIntial($saleuser_id, true);

                    force_download($userload . " Customer's list.csv", $output);
                }
            }
            if ($jobtype_select == 9 || $jobtype_select == 10) {
                $user_filter = "";
                if ($saleuser_id == 'all') {
                    $userload = "All Customers ";
                    $user_filter = "";
                } else {
                    $userload = $this->getUserIntial($saleuser_id, true);
                    $user_filter = " and user_id=" . $saleuser_id;
                }
                if ($jobtype_select == 9) {
                    $sql = "select * from sold_detail where status = 'sold'  $user_filter";
                    $userload.="-sold";
                } else if ($jobtype_select == 10) {
                    $sql = "select * from sold_detail where status = 'non-sold' $user_filter";
                    $userload.="-non-sold";
                }
                $list_array = $this->db->query($sql)->result_array();
                $records[0] = array('First Name', 'Last Name', 'Email');
                $k = 1;
                foreach ($list_array as $row) {
                    $records[$k] = array($row['first_name'], $row['last_name'], $row['email']);
                    $k++;
                }
                echo $myarray = array_to_csv($records, $userload . ".csv");
            }
        }
        
        function getArea($pincode){
             $row=$this->db->query('Select neighbour from neigbhour left join neigbhour_pin_codes neg on neg.neighbour_id=neigbhour.id where neg.pin_codes="'.$pincode.'"')->row_array();
             return @$row['neighbour'];
         }
         
        function getProposalId($job_pid){
            $row=$this->db->query('Select proposal_id from jobs where id="'.$job_pid.'"')->row_array();
            return @$row['proposal_id'];
        }
      
        function getAllvaribleLaborCost($proposal_id,$job_type,$location_access){
    
            $row=array();
            $text='';
            if($job_type==2 || $job_type==6 || $job_type==7){
                
                if($job_type==2){
                    $var_list_order=array('EJ'=>101,'EH'=>102,'RL'=>206);
                }else if($job_type==6){
                    $var_list_order=array('RL'=>224);
                }else{
                    $var_list_order=array('PM'=>207);
                } 

                foreach ($var_list_order as $key=>$val){
                    $variable_id=$val;

                    if($variable_id==101 || $variable_id==102){
                        $sqlc = "SELECT  title, variable_job.price AS hours,quantity as price  ,ROUND(quantity*variable_job.price) AS cost,system_price_proposal.proposal_id  FROM variable_job
        JOIN system_price_proposal  ON variable_job.`variable_id`=system_price_proposal.`id`
         WHERE  variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.id ='" . $variable_id . "' AND system_price_proposal.location_access ='" . $location_access . "'";
                    }else{
                        $sqlc = "SELECT  title,quantity AS hours,variable_job.price ,ROUND(quantity*variable_job.price) AS cost,system_price_proposal.proposal_id  FROM variable_job
        JOIN system_price_proposal  ON variable_job.`variable_id`=system_price_proposal.`id`
         WHERE  variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.id ='" . $variable_id. "' AND system_price_proposal.location_access ='" . $location_access . "'";
                    }

                    $row = $this->db->query($sqlc)->row_array();
                    if (count($row)){
                        if($job_type==6){
                            $text.=floatval($row['hours']).' '.$key.' / ';
                        }else{
                            $text .=$key.' '.floatval($row['hours']).' / ';
                        }
                    }

                }
            }else if($job_type==16 || $job_type==15){
                
                if($job_type==16){
                    $var_list_order=array('ACJ'=>35,'EJ'=>33,'AL'=>117);
                }else if($job_type==15){
                    $var_list_order=array('AS'=>37);
                }
                foreach ($var_list_order as $key=>$val){
                    $variable_id=$val;
                    $sqlc = "SELECT title, sum(quantity) AS hours, acvariable_job.price as price ,sum(quantity*acvariable_job.price) AS cost,acsystem_price_proposal.proposal_id FROM acvariable_job
        JOIN acsystem_price_proposal  ON acvariable_job.`variable_id`=acsystem_price_proposal.`id`
         WHERE  acvariable_job.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.id ='" . $variable_id. "' AND acsystem_price_proposal.location_access ='" . $location_access . "' ";
                    $row = $this->db->query($sqlc)->row_array();
                    if (count($row)){
                        $text .=$key. ' '.$row['hours'].' / ';
                    }
                }
            }
            else if($job_type==5 || $job_type==1){
                if($job_type==5){
                    $var_list_order=array('WM'=>102);
                }else if($job_type==1){
                    $var_list_order=array('PJ'=>99,'RL'=>100);
                }
                foreach ($var_list_order as $key=>$val){
                    $variable_id=$val;
                    if($key=='RL'){
                        $statement=" AND system_price_swhproposal.id in (100,101)";
                        $cols="SUM(quantity) AS hours";
                    }else{
                        $statement=" AND system_price_swhproposal.id ='" . $variable_id. "'";
                        $cols="quantity AS hours";
                    }     
                    $sqlc = "SELECT  title,$cols,swh_variable_job.price ,ROUND(quantity*swh_variable_job.price) AS cost,system_price_swhproposal.proposal_id  FROM swh_variable_job
    JOIN system_price_swhproposal  ON swh_variable_job.`variable_id`=system_price_swhproposal.`id`
     WHERE  swh_variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_swhproposal.`proposal_id`='" . $proposal_id . "' $statement ";
                    $row = $this->db->query($sqlc)->row_array();
                    
                    if (count($row)){
                        $text .=$key. ' '.floatval($row['hours']).' / ';
                    }

                }
            }
           
            if(strlen($text)){
                return substr($text, 0, -2);
            }else{
                 return '';
            }
        }
        
        function getunit($proposal_id){
            $sql_zone="SELECT * from acproposalzone where acproposal_id='".$proposal_id."'";
            $zones=$this->db->query($sql_zone)->result_array();
            $unitcount=0;
            foreach( $zones as $zdata) {
                $mz_chk1 = $zdata['mzone_rec1_id'];
                $mz_chk2 = $zdata['mzone_rec2_id'];
                $mz_add_check = $zdata['additional_unit_1_price'];
                $mz_rec_check = $zdata['reccomended_unit_1_price'];
                if($mz_chk1>0 && $mz_chk2>0 ){
                    //$unitcount+=2;
                    continue;
                }else if ($mz_chk1>0 && $mz_add_check==0 ){
                    $unitcount+=1;
                    continue;
                } else if($mz_chk2>0 && $mz_rec_check>0 ){
                    $unitcount+=1;
                    continue;
                } else {
                    $unitcount+=1;
                    if(!$zdata['reccomended_unit_delete'] &&  !$zdata['additional_unit_delete'] && $zdata['additional_unit_1_price']>0 ) { 
                        $unitcount+=2;
                    }
                    if($zdata['reccomended_unit_delete'] &&  $zdata['additional_unit_delete'] ) { 
                        $unitcount-=1;
                    }
                }
            }
            return $unitcount;
        }
        
        function deleteTechnician($job_id=0){
            $data= array();
            if(!@$job_id){
                $data['success'] = false;
                echo json_encode($data);
                return;
            }
            
            $team_type_name = $this->input->post('team_type_name');
            $teamType = $this->input->post('team_type_id');
            $teamId = $this->input->post('technician_team_id');
            $technicianIdPheo = $this->input->post('technician_id_pheo');
            $technicianIdTime = $this->input->post('technician_id_time');
            $job_id = $this->input->post('job_id');
            $techInTeam = $this->input->post('techInTeam');
            //$key = $this->input->post('key');
            
            $jobUpdate = array();
            $rowjobs = $this->db->query("SELECT * FROM jobs where id=".$job_id."")->row_array();
            $job_pid=@$rowjobs['job_pid'];
            $job_type_id=@$rowjobs['job_type_id'];
            if(@$rowjobs['installer_id']){
                $installer_id =  explode(',', $rowjobs['installer_id']);
                if($technicianIdPheo && in_array($technicianIdPheo,$installer_id)) {
                    $pos = array_search($technicianIdPheo, $installer_id);
                    unset($installer_id[$pos]);
                }
                $installer_id = implode(",",$installer_id);
                $jobUpdate['installer_id'] = $installer_id;
            }else{
                $jobUpdate['installer_id'] = '';
            }
            
            $this->db->where(array('job_id' => $job_id,'technician_id_pheo' =>$technicianIdPheo,'technician_id_time' => $technicianIdTime));
            $this->db->delete("technicians_in_jobs");
            $labour_cont=$this->db->query("SELECT count(*) as count from technicians_in_jobs where job_id=".$job_id)->result_array();
            $json['labour_count']=8*@$labour_cont[0]['count'];
            $jobUpdate['labour_allocated']=$json['labour_count'];
            $this->db->where(array('job_pid'=>$job_pid,'job_type_id'=>$job_type_id));
            $this->db->update("jobs",$jobUpdate);
            
             $rowtechnician = $this->db->query("SELECT * FROM technicians_in_jobs where technician_id_pheo=".$technicianIdPheo."")->result_array();
            if (count($rowtechnician)== 0)
            {
             $set=array();
             $set['assigned']=0;
             $this->db->where(array('technician_id_pheo' => $technicianIdPheo));
             $this->db->update("technicians_assign",$set);
            }   
            if($this->db->affected_rows()>0){
                $json['success'] = true;
                echo json_encode($json);
            }else{
                $json['success'] = false;
                echo json_encode($json);
            }
	}
        
        function saveTechnician($job_id=0){
            
            $data= array();
            if(!@$job_id){
                $data['success'] = false;
                echo json_encode($data);
                return;
            }
            
            $team_type_name = $this->input->post('team_type_name');
            $teamType = $this->input->post('team_type_id');
            $teamId = $this->input->post('technician_team_id');
            $technicianIdPheo = $this->input->post('technician_id_pheo');
            $technicianIdTime = $this->input->post('technician_id_time');
            $job_id = $this->input->post('job_id');
            $key = $this->input->post('key');
            
            $row = array();
            $row['team_type_id'] = $this->input->post("team_type_id");
            $row['technician_id_pheo'] = $this->input->post("technician_id_pheo");
            $row['technician_id_time'] = $this->input->post("technician_id_time");
            $row['team_id'] = $this->input->post("technician_team_id");
            $row['job_id'] = $this->input->post("job_id");
            $workhour=$row['technician_worked_hours'] = $this->input->post("technician_worked_hours");
            
            $row['created']=date("Y-m-d H:i:s");
            $row['tech_in_team'] = $this->input->post("techInTeam");
            
            $jobUpdate = array();
            $rowjobs = $this->db->query("SELECT * FROM jobs where id=".$job_id."")->row_array();
            $job_pid=@$rowjobs['job_pid'];
            $job_type_id=@$rowjobs['job_type_id'];
            if(@$rowjobs['installer_id']){
                $installer_id =  explode(',', $rowjobs['installer_id']);
                if($technicianIdPheo && in_array($technicianIdPheo,$installer_id)) {
                }else{
                    array_push($installer_id,$technicianIdPheo);
                }
                $installer_id = implode(",",$installer_id);
                $jobUpdate['installer_id'] = $installer_id;
            }else{
                $jobUpdate['installer_id'] = $this->input->post("technician_id_pheo");
            }
            
            $row1 = $this->db->query("SELECT * FROM technicians_in_jobs where job_id=".$job_id." and technician_id_pheo=".$technicianIdPheo." and technician_id_time=".$technicianIdTime."")->row_array();
            if (count($row1) > 0)
            {
                $data['success'] = true;
                $data['isExist'] = 1;
            }
            else
            {
                $this->db->insert("technicians_in_jobs",$row);
                $set=array();
                $set['assigned']=1;
                $this->db->where(array('technician_id_pheo' => $technicianIdPheo,'team_id'=>$teamId));
                $this->db->update("technicians_assign",$set);
                $labour_cont=$this->db->query("SELECT count(*) as count from technicians_in_jobs where job_id=".$job_id)->result_array();
                $data['labour_count']=8*@$labour_cont[0]['count'];
                $jobUpdate['labour_allocated']=$data['labour_count'];
                $this->db->where(array('job_pid'=>$job_pid,'job_type_id'=>$job_type_id));
                $this->db->update("jobs",$jobUpdate);
                
                $data['success'] = true;
                $data['isExist'] = 0;
            }
            echo json_encode($data);
        }
        
         function save_technician_by_team($job_id=0){
           // 
            $data= array();
            if(!@$job_id){
                $data['success'] = false;
                echo json_encode($data);
                return;
            }
            $technician_team_id = $this->input->post('technician_team_id');
            $team_name = $this->input->post('team_name');
            $teamId = $this->input->post('technician_team_id');
            $team_type_id= $this->input->post('team_type_id');
            $job_id = $this->input->post('job_id');
            $teamname = $this->input->post("techInTeam");
            
            $rowjobs = $this->db->query("SELECT * FROM technicians_assign  where team_id=".$technician_team_id)->result_array();
            foreach($rowjobs as $team){
            $row = array();
            $row['team_type_id'] =$team['team_type_id']; 
            $row['technician_id_pheo'] = $team['technician_id_pheo'];
            $technicianIdPheo=$team['technician_id_pheo'];
            $row['technician_id_time'] = $team['technician_id_time'];
            $technicianIdTime=$team['technician_id_time'];
            $row['team_id'] =$team['team_id'];
            $row['job_id'] = $job_id;
            $row['tech_in_team'] =$teamname;
            $row['technician_worked_hours'] =$this->work_hours($team['technician_id_time']);
            $row['created']=date("Y-m-d H:i:s");
           
            $jobUpdate = array();
            $rowjobs = $this->db->query("SELECT * FROM jobs where id=".$job_id."")->row_array();
            $job_pid=@$rowjobs['job_pid'];
            $job_type_id=@$rowjobs['job_type_id'];
            if(@$rowjobs['installer_id']){
                $installer_id =  explode(',', $rowjobs['installer_id']);
                if($technicianIdPheo && in_array($technicianIdPheo,$installer_id)) {
                }else{
                    array_push($installer_id,$technicianIdPheo);
                }
                $installer_id = implode(",",$installer_id);
                $jobUpdate['installer_id'] = $installer_id;
            }else{
                $jobUpdate['installer_id'] = $this->input->post("technician_id_pheo");
            }
           
            $row1 = $this->db->query("SELECT * FROM technicians_in_jobs where job_id=".$job_id." and technician_id_pheo=".$technicianIdPheo." and technician_id_time=".$technicianIdTime."")->result_array();
         
            if(count($row1) > 0)
            {
                $data['success'] = true;
                $data['isExist'] = 1;
            }
            else
            {
                $this->db->insert("technicians_in_jobs",$row);
                $set=array();
                $set['assigned']=1;
                $this->db->where(array('technician_id_pheo' => $technicianIdPheo,'team_id'=>$teamId));
                $this->db->update("technicians_assign",$set);
                $labour_cont=$this->db->query("SELECT count(*) as count from technicians_in_jobs where job_id=".$job_id)->result_array();
                $data['labour_count']=8*@$labour_cont[0]['count'];
                $jobUpdate['labour_allocated']=$data['labour_count'];
                $this->db->where(array('job_pid'=>$job_pid,'job_type_id'=>$job_type_id));
                $this->db->update("jobs",$jobUpdate);
                $data['success'] = true;
                $data['isExist'] = 0;
            }
         }
            echo json_encode($data);
        }
        
       function work_hours($tech_id){
                $from_W_date=date('Y-m-d',strtotime('last Sunday'));
                $to_W_date=date('Y-m-d',  strtotime('+6 days',strtotime('last Sunday')));
                $this->db2 = $this->load->database('otherdb', true);
                $q=$this->db2->query("SELECT t_c.* FROM user_calculated_time_sheet_details as t_c where t_c.user_id ='".$tech_id."' and (status='Submitted' or status='Approved') and t_c.submited_date BETWEEN  '".$from_W_date."' and '".$to_W_date."'");   
                if($q->num_rows()){
                    $TimeSheetdetails = $q->row_array();
                    $technician_worked_hours = $TimeSheetdetails['reg_hrs']+$TimeSheetdetails['ot'];
                }else{
                   $technician_worked_hours = 0;
                }
                
                return  $technician_worked_hours;
        } 
        function check_assigned($technician_id,$team_id,$job_id){
           //echo $team_id;
            if(!$job_id){
                 return 0;
             }else{
                 
                    $sql="select * from technicians_in_jobs  where team_id=".$team_id." and technician_id_pheo=".$technician_id.$job_id ;
                    $row=$this->db->query($sql)->result_array();
                    if(count($row)>0){
                        return 1;
                    }else{
                        return 0; 
                    }
             } 
          }
          
   
    }
?>
