<!--
Customer Types: Residential, Commercial
Job Type: Solar Water Heating, Photovoltaic, Solar Attic Fan, Service Call

Automatic filtering to prevent same-name/same-address scenarios. i.e. if name is entered and there is a similar name/lastname, if asks if this person lives at the same address. If yes, it'll modify that persons profile, ie customers can have more than one job added to it like solar water heating, photovoltaics, solar fans, etc
Ability to 'Save for later', i.e. saves and closes overlay window and returns to Job Calendar view
Ability to 'Enter more details' - takes user to job detailed page to enter more customer details.

- width of all overlays should be the same, although its not necessary to keep it the same width in the mockups
-->
<? ini_set("display_errors", 1); ?>
<script type="text/javascript" src="<?= base_url() ?>assets/js/dropdowncontent.js"></script>
<style>
    .service_type_div{margin-bottom:10px;}
    .anothername{display:none;}
    #subcontent a{cursor: pointer; font-size: 12px;}
    #subcontent{top:450px !important;left:10px !important;margin:0;-webkit-margin-before:-28px !important;}
    #subcontent ul{list-style: initial !important; padding-left:10px;}
    #subcontent li ul {padding-left: 50px !important ; list-style: circle !important;}
    #subcontent li ul li a{padding: 3px 5px !important;}
    .reserve-job input[type="text"], .reserve-job .text{
        width:120px;}
    #tabs-client-info .textw {
        width:97.5%;}
    textarea{
        width: 96%;
        height: 115px;    }
    .reserve-job{
        width: 540px;}
    .reserve-job .value input[type="text"]{
        width:25px;float: left;}
    #facebox{
        z-index:9999; }
    #qoute_sezc{
        width: 185px;
    }
    #qoute_seew{
        width: 185px;
    }
    .subtotal-div td{
        padding: 5px !important;
    }
    .check{line-height: 25px;}
    input[type="checkbox"]{vertical-align: middle;}
    textarea{
        width: 96%;
        height: 115px!important;    }
    .after{font-size: 14px;
           margin-left: 4px;
           top: 3px;
           position: relative;}
    .before{font-size: 14px;
            margin-left: 4px;
            top: 2px;
            position: relative;
            float: left;
            margin-left: -15px;
    }

    .error_d{
        background: #FED4DE;
        color: #CE0030;
        font-weight: bold;
        padding: 8px;
        text-align: left;
        border: 1px solid #FFB8CA;
        margin: 10px 0;
        font-size: 10px;
    }

</style>
<script>
    $(function () {
        $("#tabs").tabs();

        $("#prevBtn").bind("click", prevOfferTab);

        $("#nextBtn").bind("click", nextOfferTab);
        // getSelectedTabIndex(0);
    });
    function prevOfferTab() {
        var newTabIndex = parseInt(getSelectedTabIndex(-1));
        $('#tabs').tabs('select', newTabIndex);

    }
    function nextOfferTab() {
        var newTabIndex = parseInt(getSelectedTabIndex(1));
        
        $('#tabs').tabs('select', newTabIndex);
    }
    function getSelectedTabIndexPrev(change, system) {
        var $tabs = $('#tabs').tabs();
        var current = parseInt($tabs.tabs('option', 'selected'));
        var selected = current + change;
        return selected;
    }
    function getSelectedTabIndex(change, system) {
        var tabs = $('#tabs').tabs();
        var selected = $('#tabs').tabs('option', 'selected') + change;

        if (selected == 0 || system == 1) {
            $("#prevBtn").hide();

        }
        else {
            $("#prevBtn").show();

        }
        var tabsCount = this.$('#tabs').tabs('length') - 1;

        if (selected == tabsCount || system == 6) {
            $("#nextBtn").hide();
            $("#saveBtn").hide();
        }
        else {
            $("#nextBtn").show();
            $("#saveBtn").show();
        }

        return selected;
    }

    $("#tabs").tabs({
        activate: function (event, ui) {
            var tab = $("#tabs").tabs("option", "active");
            var electric_project = $("input[name=electric_project]").val();
            var general_project = $("input[name=general_project]").val();
            var plumber_project = $("input[name=plumber_project]").val();

            if (tab != 0) {
                $.ajax({
                    type: "POST",
                    url: "<?= base_url() ?>customers_gc/tabsession",
                    data: "tab=" + $("#tabs").tabs("option", "active"),
                    dataType: "json",
                    success: function (json) {
                    }
                });
            }
        },
<?php if ($this->session->userdata("tabs_selected")) { ?>
            active: $("#tabs").tabs({active: <?= $this->session->userdata("tabs_selected"); ?>})
<?php } ?>
    });

</script>
<script type="text/javascript" charset="utf-8">

    $(".details").click(function () {
        var proposal_id;
        proposal_id = parseInt($("input[name=proposal_id]").val(), 10);
        $.facebox({ajax: '<?= base_url() ?>customers_gc/price_quote_second/' + proposal_id}, 'Proposal Cost');
    });


    $(".close").click(function () {
        window.location.reload();
    });
    
</script>
<style>
    .ui-widget-header{background-color:#FFF !important; background-image:none !important; border:0px !important;} 
    #prevBtn { display:none;}   
    .ui-tabs .ui-tabs-nav li a{padding-left:2px!important; padding-right:2px !important;}
    #cus_error {background: none repeat scroll 0 0 #FED4DE; border: 1px solid #FFB8CA;    color: #CE0030;    font-weight: bold;    margin: 10px 0;    padding: 8px;    text-align: left;}
	.gc_table-in tr td input{width:90px !important;}
	.pop_city label{width:230px;}
	.pop_zip label{width:106px;}
	.popup_location{width:100%;}
	
	.popup_city{width: 233px;
    margin-right: 10px!important;}
	.popup_city input{width:95% !important;}
	
	.popup_state{width: 233px;
    margin-left: 11px;}
	.popup_state input{width:95% !important;}
	.but-loc_new{float:right;margin-top:10px;}
	.footer{display:none !important;}
	.value{margin-top:10px;}
	.value tr td{padding:5px 0 !important; font-size: 12px !important;}
	
</style>
<div class="reserve-job" id="reservejob" style="position:relative;">

    <div id="displayloading" style="position: absolute; z-index: 2; text-align: center; display:none; width:100%; background-color:#f0f0f0; height:100%; line-height:100%;"><img src="<?= base_url() ?>assets/images/loading.gif"><br/>Processing..</div>
    <div class="header clearfix">
        <div class="title" >Add a Project</div>
        <div class="close-button"><a href="#" class="cancel-facebox">&times;</a></div>
        <div class="clear-both"></div>
    </div>
    <div class="content clearfix" style="padding:10px;">
        <div id="cus_error"  style="display:none;"></div>
        <div class="form-errors " id="main_error" style="display:none;"></div>
        <div id="tabs" style="positon:absolute; z-index:1;width:510px; margin:0 auto;"  class="custDetsForm">
                <ul>
                <li>
                    <a href="#tabs-client-info" onclick="getSelectedTabIndex(1, 1);">Client Info</a>
                </li>
                <?php if ($this->session->userdata("const_prop_admin_access")) { ?>
                <? 
                if (count($constructionzone)) {
                        
                    foreach ($constructionzone as $key=>$cons_val){
                    ?>
                
                    <li >
                        <a  onclick="getSelectedTabIndex(1);" href="#tabs-<?= $cons_val['id']; ?>">Project <?=$key+1?></a>
                    </li>
                <? }
                    
                } ?>
                
                <? } ?>
                <?php if ($this->session->userdata("const_prop_admin_access")) { ?>    
                    <? if (count($constructionzone)) { ?>
                        <li>
                            <a href="#tabs-specifications" onclick="getSelectedTabIndex(1);">Specifications</a>
                        </li>
                    <? } ?>
                <? } ?>        
                
                <? if (count($constructionzone)) { ?>
                    <li>
                        <a href="#tabs-summary" onclick="getSelectedTabIndex(1);">Summary</a>
                    </li>
                <? } ?>
                <?php if ($this->session->userdata("const_prop_admin_access")) { ?>    
                <li style="float:right;" >
                    <a href="#tabs-add-project" onclick="getSelectedTabIndex(1, 6);">Add a Project</a>
                </li>
                <? } ?>
            </ul>
            <!--Client info tab-->
            <div class="content clearfix" style="padding: 10px;" id="tabs-client-info" >    
                <!--<div class="form-errors" style="display:none;"></div>-->

                <h2><b>Project Details</b></h2>
                <br>

                <?= form_open('drwproposal/proposal_basic', 'id="proposal_basic"'); ?>
                <?= form_hidden('proposal_id', $proposal_id) ?>
                <?= form_hidden('customer_id', @$proposal_basic['customer_id'] ? @$proposal_basic['customer_id'] : 0) ?>
                
		<?= form_hidden('customer_exist', @$proposal_basic['customer_exist'] == 'y' ? 'y' : 'n') ?>

                <?= form_label('Project Name'); ?>
                <?= form_input('project_name', @$proposal_basic['project_name'], 'id="project_name" class="textw"'); ?>

                <?= form_label('Company Name '); ?>
                <?= form_input('b_address', @$proposal_basic['b_address'], 'id="b_address" class="textw"'); ?>

                <div class="popuplocation cl clearfix popup_location">
                    <div class="popupcity pop_city">
                        <?= form_label('City'); ?>
                        <?= form_input('city', @$proposal_basic['city'], 'id="city" style="width:180px;"'); ?>
                    </div>
                    <div class="popupzip pop_zip">
                        <?= form_label('Zip', 'zip'); ?>
                        <?= form_input('zip', @$proposal_basic['zip'], 'id="zip"'); ?>
                    </div>
                    <div class="popupstate">
                        <?= form_label('State', 'state'); ?>
                        <?
                       if(isset($proposal['state']) && @$proposal['state']!="") {
                        $state=$proposal['state'];
                       } else {
                             $state="HI";
                       }
		
                        ?>
                        &nbsp;<?= form_dropdown('state', $states, $state, 'id="state" style="margin:0; height:27px"'); ?>
                    </div>
                </div>         
                <br>
                <?= form_close(); ?>
                <div style="clear:both;"></div>
                <div style="float:left; margin-top:10px">
                        
                    <input type="button" class="close submit"  style="font-size:12px !important;cursor:pointer;" value="Close"> 
                </div>
                <div class="but-loc_new">
                	<button class="" style="cursor:pointer;" onclick="saveinfo(<?=$proposal_id?>)">Save</button>
                        <?php if (!$this->session->userdata("const_prop_admin_access")) { ?>
                                    <input onclick="sendadminalert();"  type="button" id="sendtoop" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Send to Operation">
                        <? } ?>
                        <?php if ($this->session->userdata("const_prop_admin_access") && !$this->session->userdata('superadmin')) { ?>
                                        <input  onclick="sendsuperadminalert();" type="button" id="sendtosu" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Send to Superadmin">
                        <? } ?>
                        <?php if ($this->session->userdata('superadmin')) { ?>
                                        <input  onclick="sendsalealert();"  type="button" id="sendtosale" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Finish">
                        <? } ?>
                </div>    
                
            </div>
            
            <? if (count($constructionzone)) {
               foreach ($constructionzone as $key=>$cons_val){
            ?>
            
                <div  id="tabs-<?= $cons_val['id']; ?>" class="content clearfix" style="padding:10px;display:none;">
                     
                    <?= form_open('drwproposal/price_quote_second', 'id="cost_form_'.$cons_val['id'].'"'); ?>
                    <div class=" error_d" style="display:none;" ></div>
                    <?= form_hidden('proposal_id', $proposal_id) ?>
                    <?= form_hidden('proposal_pid', $proposal_id) ?>
                    <?= form_label('Project Type', 'Project Type'); ?>
                    
                    <?= form_hidden('elect_labor', 60, 'id="elect_labor" onchange="calculatePriceQuote1(this);"'); ?>
                    <?= form_hidden('c_design_engg', 53, 'id="c_design_engg" onchange="calculatePriceQuote1(this);"'); ?>
                    
                    <div class="service_type_div">
                        <?= form_dropdown('service_type', $service_type,@$cons_val['service_type'], ' style="width:476px;'); ?>
                        <div class="other_service_div"  style="display: none">
                            <?= form_label('Other Service', 'Service Name'); ?>
                            <input type="text" name="other_service"  />
                        </div>
                    </div>
                                
                    <div class="clearfix">
                    <?php if ($this->session->userdata("const_prop_admin_access")) { ?>
                            <table width="100%" class="gc_table-in">		
                                <tr>
                                    <td width="125px">     <?= form_label('Materials Cost', 'elect_mat'); ?></td>
                                    <td> <font class="before">$</font> <?= form_input('elect_mat', @$cons_val['elect_mat'], 'id="elect_mat" onchange="calculatePriceQuote1(this);"'); ?></td>
                                
                                    <td>     <?= form_label('Electrical Labor Hours', 'Electrical Labor Hours'); ?></td>
                                    <td>     <font class="before"></font> <?= form_input('elect_labor_hours', @$cons_val['elect_labor_hours'], 'id="elect_labor_hours" onchange="calculatePriceQuote1(this);"'); ?></td>
                                </tr>
                                
                                <tr>
                                    <td>     <?= form_label('Subcontractor Cost', 'c_sub_contractor'); ?></td>
                                    <td>     <font class="before">$</font> <?= form_input('c_sub_contractor', @$cons_val['c_sub_contractor'], 'id="c_sub_contractor" onchange="calculatePriceQuote1(this);"'); ?></td>
                                
                                    <td>     <?= form_label('Genral Labor Hours', 'c_hours'); ?></td>
                                    <td>     <font class="before"></font> <?= form_input('c_hours', @$cons_val['c_hours'], 'id="c_hours" onchange="calculatePriceQuote1(this);"'); ?></td>
                                </tr>
                                <?php if ($this->session->userdata('superadmin')) { ?>
                                <tr>
                                    <td>    <?= form_label('Overhead', 'c_overhead_val'); ?></td>
                                    <td>    <font class="before"> %</font>
									<?= form_input('c_overhead_val', @$cons_val['c_overhead_val'], 'id="c_overhead_val" onchange="calculatePriceQuote1(this);"'); ?> </td>

                                    <td>     <?= form_label('Profit Margin', 'c_p_margin_val'); ?></td>
                                    <td>    <font class="before"> %</font>
									<?= form_input('c_p_margin_val', @$cons_val['c_p_margin_val'], 'id="c_p_margin_val" onchange="calculatePriceQuote1(this);"'); ?> </td>
                                </tr>
                                <tr>
                                    <td> <?= form_label('Commission', 'c_scommission_val'); ?></td>
                                    <td>    <font class="before"> %</font>
									<?= form_input('c_scommission_val', @$cons_val['c_scommission_val'], 'id="c_scommission_val" onchange="calculatePriceQuote1(this);"'); ?> </td>
                                    <td> <?= form_label('Permit Fee', 'permit_fee_val'); ?></td>
                                    <td>  
                                        <input type="checkbox" name="c_permit_fee_val" id="c_permit_fee_val" <?=(@$cons_val['c_permit_fee_val']>0)?'checked="checked"':''?>"  onclick="calculatePriceQuote1(this);" />
                                    </td>
                                </tr>  
                                <?php }?>
                                
                                <tr>
                                    <td></td><td></td>
                                    <td> <?= form_label('Discount', 'discount_val'); ?></td>
                                    <td>   <font class="before">$</font>  <?= form_input('c_discount_val', @$cons_val['c_discount_val'], 'id="c_discount_val" onchange="calculatePriceQuote1(this);"'); ?></td>
                                </tr>
                                <tr>
                                    <td></td><td></td>
                                <td> <?= form_label('Additional Cost', 'c_add_cost_val'); ?></td>
                                <td>    <font class="before">$</font> <?= form_input('c_add_cost_val', @$cons_val['c_add_cost_val'], 'id="c_add_cost_val" onchange="calculatePriceQuote1(this);"'); ?></td>
                                </tr>
                                 <tr>
                                <td></td><td></td>
                                <td> <?= form_label('Upcharge', 'upcharge_val'); ?></td>
                                <td>    <font class="before">$</font> <?= form_input('c_upcharge_val', @$cons_val['c_upcharge_val'], 'id="c_upcharge_val" onchange="calculatePriceQuote1(this);"'); ?></td>
                                </tr>
                            </table>
                            <? } ?>
                        <div class="leftModalList">
                            <?= form_label('Description of Works', 'c_desc'); ?>
                            <?= form_textarea('c_desc', @$cons_val['c_desc'], 'id="c_desc" style="width: 484px; height: 70px;"'); ?>
                        </div>
                    </div>
                    <div class="emmp">
                        
                        <?= form_hidden('c_total', @$cons_val['c_total'], 'id="c_total"'); ?>

                        <?= form_hidden('c_subtotal', @$cons_val['c_subtotal'], 'id="c_subtotal"'); ?>


                        <?= form_hidden('c_ge_tax', @$cons_val['c_ge_tax'], 'id="c_ge_tax"'); ?>

                        <?= form_hidden('c_total_cost', @$cons_val['c_total_cost'], 'id="c_total_cost"'); ?>

                        <?= form_hidden('c_add_cost', @$cons_val['c_add_cost'], 'id="c_add_cost"'); ?>
                        <?= form_hidden('c_upcharge', @$cons_val['c_upcharge'], 'id="c_upcharge"'); ?>
                        <?= form_hidden('c_discount', @$cons_val['c_discount'], 'id="c_discount"'); ?>

                        <?= form_hidden('c_total_assests_val', @$cons_val['c_total_assests_val'], 'id="c_total_assests_val"'); ?>

                        <?= form_hidden('c_permit_fee', @$cons_val['c_permit_fee'], 'id="c_permit_fee"'); ?>

                        <?= form_hidden('c_total_elec_payable', @$cons_val['c_total_elec_payable'], 'id="c_total_elec_payable"'); ?>
                        

                        <?= form_hidden('c_overhead', @$cons_val['c_overhead'], 'id="c_overhead"'); ?>
                        
                        <?= form_hidden('c_profit_margin', @$cons_val['c_profit_margin'], 'id="c_profit_margin"'); ?>
                        

                        <?= form_hidden('c_salesman_commission', @$cons_val['c_salesman_commission'], 'id="c_salesman_commission"'); ?>
                        
                        <?= form_hidden('final_subtotal', @$cons_val['final_subtotal'], 'id="final_subtotal"'); ?>
                        <?= form_hidden('final_overhead', @$cons_val['final_overhead'], 'id="final_overhead"'); ?>

                        <?= form_hidden('final_profit_margin', @$cons_val['final_profit_margin'], 'id="final_profit_margin"'); ?>
                        <?= form_hidden('final_salesman_commission', @$cons_val['final_salesman_commission'], 'id="final_salesman_commission"'); ?>
                    </div>
                    
                    <?php if ($this->session->userdata("const_prop_admin_access")) { ?>
                        <table width="100%" class="value">
                            <?php if ($this->session->userdata('superadmin')) { ?>
                                
                            <?php } else { ?>
                                <?= form_hidden('c_overhead_val', @$cons_val['c_overhead_val'], 'id="c_overhead_val"'); ?>
                                <?= form_hidden('c_p_margin_val', @$cons_val['c_p_margin_val'], 'id="c_p_margin_val"'); ?>
                                <?= form_hidden('c_scommission_val', @$cons_val['c_scommission_val'], 'id="c_scommission_val"'); ?>
                                <? } ?>
                            <tr>
                                
                                <?php if ($this->session->userdata('superadmin')) { ?>
                                    <td width="280px">&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td><b>Overhead :</b> $ <font class="c_overhead"><?= @$cons_val['c_overhead'] ?></font></td>
                                <? } else { ?>
                                    <td>&nbsp;</td>
                                <? } ?>
                                
                            </tr>
                            <tr>
                                <?php if ($this->session->userdata('superadmin')) { ?>
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td><b>Profit Margin :</b> $ <font class="c_profit_margin"><?= @$cons_val['c_profit_margin'] ?></font></td>
                                <? } else { ?>
                                    <td>&nbsp;</td>
                            <? } ?>
                            </tr>
                            <tr>
                                
                                <?php if ($this->session->userdata('superadmin')) { ?>	
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td nowrap>
                                        <b>Salesman Commission :</b> $ <font class="c_salesman_commission"><?= @$cons_val['c_salesman_commission'] ?></font>
                                    </td>
                                <? } else { ?>
                                    <td>&nbsp;</td>
                                <? } ?>
                                
                            </tr>
                            <tr>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td rowspan="2" nowrap> <span style="float:left; width:129px;"><b><?= form_label('TOTAL PAYABLE'); ?></b></span>
                                <span><strong>$ </strong><font class="c_total_elec_payable"><strong><?= @$cons_val['c_total_elec_payable']; ?></strong></font>
                                </span></td>
                            </tr>
                        </table> 
                    <? } ?>
                    <?= form_close(); ?>
                    <br/>
					<div style="clear:both;"></div>
                    
                    <div style="float:left; margin-top:10px">
                        <button class="elecpricediv" onclick="deleteprojecttype(<?= @$cons_val['id']; ?>);" id="elecpricediv" style="cursor:pointer;background-color: #bb1717;">Delete</button>
                        <input type="button" class="close submit"  style="font-size:12px !important;cursor:pointer;" value="Close"> 
                    </div>
                    
                    
                    <div class="but-loc_new">
                	
                    <button class="elecpricediv" onclick="update_project(<?=@$cons_val['id'];?>);"  style="cursor:pointer;">Update</button>
                        
                    <?php if (!$this->session->userdata("const_prop_admin_access")) { ?>
                                    <input onclick="sendadminalert();"  type="button" id="sendtoop" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Send to Operation">
                        <? } ?>
                        <?php if ($this->session->userdata("const_prop_admin_access") && !$this->session->userdata('superadmin')) { ?>
                                        <input  onclick="sendsuperadminalert();" type="button" id="sendtosu" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Send to Superadmin">
                        <? } ?>
                        <?php if ($this->session->userdata('superadmin')) { ?>
                                        <input  onclick="sendsalealert();"  type="button" id="sendtosale" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Finish">
                        <? } ?>
                    </div>  
                    
                </div>
            
            <? }
            
            } 
            ?>
            <?php if ($this->session->userdata("const_prop_admin_access")) { ?>  
            <!--OTHER SPECIFICATION TAB tab-->
            <? if (count($constructionzone)) { ?>
            
                <div class="content clearfix" style="padding:10px;" id="tabs-specifications">
                    <h2>Other Specifications</h2>
                    <?= form_open('drwproposal/price_quote_second', 'id="specfication_form"'); ?>
                    <?= form_hidden('proposal_id', $proposal_id) ?>
                    <?= form_hidden('proposal_pid', $proposal_id) ?>
                    <?= form_hidden('specification', $proposal_basic['specification'], 'id="specification"') ?>
                        <? $chk_spec = explode(",", $proposal_basic['specification']); ?>    
                    <ul> <?
                        $i = 1;
                        foreach ($specification as $spec) {
                            $checked = "";
                            if (in_array($spec['id'], $chk_spec)) {
                                $checked = "checked";
                            }
                            echo "<li class='check'> <input type='checkbox' class='chkNumber' value='" . $spec['id'] . "' $checked /> " . $i . ". " . $spec['desc'] . "</li>";
                            $i++;
                        }
                        ?>
                    </ul>
                    <?= form_close(); ?>
                    <div style="clear:both;"></div>
                    <div style="float:left; margin-top:10px">
                        
                        <input type="button" class="close submit"  style="font-size:12px !important;cursor:pointer;" value="Close"> 
                    </div>
                    <div class="but-loc_new">
                	   
                        <input  type="button"  class="submit" style="font-size:12px !important;cursor:pointer;" value="Save" onclick="savespecification(1);">
                        
                    <?php if (!$this->session->userdata("const_prop_admin_access")) { ?>
                                    <input onclick="sendadminalert();"  type="button" id="sendtoop" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Send to Operation">
                        <? } ?>
                        <?php if ($this->session->userdata("const_prop_admin_access") && !$this->session->userdata('superadmin')) { ?>
                                        <input  onclick="sendsuperadminalert();" type="button" id="sendtosu" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Send to Superadmin">
                        <? } ?>
                        <?php if ($this->session->userdata('superadmin')) { ?>
                                        <input  onclick="sendsalealert();"  type="button" id="sendtosale" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Finish">
                        <? } ?>
                    </div> 
                </div>
            
            <? } ?>
            <? } ?>
            <!--SUMMERY TAB tab-->
            <? if (count($constructionzone)) { ?>
                <div class="content clearfix" style="padding:10px;" id="tabs-summary">

                <!--<div class="form-errors" style="display:none;" ></div>-->
                    <? 
                    $total_overhead=0;
                    $total_profit_margin=0;
                    $total_commission =0;
                    $final_subtotal =0;
                if (count($constructionzone)) {
                       
                    foreach ($constructionzone as $key=>$cons_val){
                        $total_overhead+=@$cons_val['c_overhead'];
                        $total_profit_margin+=@$cons_val['c_profit_margin'];
                        $total_commission+=@$cons_val['c_salesman_commission'];
                        $final_subtotal+=$cons_val["c_total_elec_payable"];
                    ?>
                    
                    <?= form_hidden('proposal_id', $proposal_id) ?>
                    <?= form_hidden('proposal_pid', $proposal_id) ?>
                    <h2>Project <?=$key+1?></h2>
                    <br>
                    <?php if ($this->session->userdata('superadmin')) { ?>
                    <table width="100%"  class="tab-price">     
                        <tr>
                            <td>Materials Cost : $<?= @$cons_val['elect_mat'] ?></td>
                            <td>&nbsp;Electrical Labor Cost : $<?= (60*@$cons_val['elect_labor_hours']) ?></td>
                            <td>&nbsp;Subcontractor Cost : $<?= @$cons_val['c_sub_contractor'] ?></td>
                            <td>&nbsp;General Labor Cost : $<?= (53*@$cons_val['c_hours']) ?></td>
                        </tr>
                    </table>
                    <?}?>
                    <br>		
                    <table width="100%"  class="tab-price">     
                        <tr>
                            <td width="12%">
                                <?= form_label('Total', 'c_total'); ?>
                            </td>
                            <td class="c_total" width="15%">$<?= @$cons_val['c_total'] ?></td>
                            <?php if ($this->session->userdata("const_prop_admin_access")) { ?> 
                            <td  width="16%">
                                <?= form_label('Overhead', 'c_overhead'); ?>
                            </td>
                            <td class="c_overhead" width="15%">$<?= @$cons_val['c_overhead'] ?></td>

                            <td   width="20%">
                                <?= form_label('Profit Margin', 'c_profit_margin'); ?>
                            </td>
                            <td class="c_profit_margin" width="11%">$<?= @$cons_val['c_profit_margin'] ?></td>
                            <?}?>
                        </tr>
                        <tr>
                            <td>
                                <?= form_label('Subtotal', 'c_subtotal'); ?>
                            </td>
                            <td class="c_subtotal">$<?= @$cons_val['c_subtotal'] ?></td>

                            <td>
                                <?= form_label('Sales Commission', 'c_salesman_commission'); ?>
                            </td>
                            <td class="c_salesman_commission">$<?= @$cons_val['c_salesman_commission'] ?></td>

                            <td>
                                <?= form_label('GE Tax', 'c_ge_tax'); ?>
                            </td>
                            <td class="c_ge_tax">$<?= @$cons_val['c_ge_tax'] ?></td>
                        </tr>

                        <tr><td>
                                <?= form_label('Total Cost', 'c_total_cost'); ?>
                            </td>
                            <td class="c_total_cost">$<?= @$cons_val['c_total_cost'] ?></td>
                            <td>
                                <?= form_label('Assets Value', 'c_total_assests_val'); ?>
                            </td>
                            <td class="c_total_assests_val">$<?= @$cons_val['c_total_assests_val'] ?></td>
                            <td>
                                <?= form_label('Permit Fee', 'c_permit_fee'); ?>
                            </td>
                            <td class="c_permit_fee">$<?= @$cons_val['c_permit_fee'] ?></td>

                        </tr>
                        <tr style="border-top:thin dotted black;">   
                            <td></td><td></td><td></td><td></td>
                            <td>
                                <?= form_label('Total Electrical Payable', 'c_total_elec_payable'); ?>
                            </td>
                            <td class="c_total_elec_payable">$<?= @$cons_val['c_total_elec_payable'] ?></td>
                        </tr>
                    </table>

                    <br>
                    <? }
                    }
                    ?>
                    <br>
                    <h2>Job Total Summary</h2>

                    <table width="50%" class="subtotal-div" style="text-align:right;" align="right">
                        <tr>
                            <td>
                                <strong>SUBTOTAL</strong>             
                            </td>
                            <td class="final_subtotal">$<?= $final_subtotal ?></td>
                        </tr>
                    </table>
                    
                    <table width="100%"  class="subtotal-div" style="border-top:black solid 1px; border-bottom:black solid 1px;margin-top: 25px;">
                        <tr>
                            <?php if ($this->session->userdata("const_prop_admin_access")) { ?> 
                            <td width="15%">
                                <strong>OVERHEAD</strong>
                            </td>
                            <td class="final_overhead"  width="20%">$<?= $total_overhead ?></td>
                            <td width="15%">
                                <strong>Profit Margin</strong>
                            </td>
                            
                            <td class="final_profit_margin" width="20%">$<?= $total_profit_margin ?></td>
                                <?}?>
                            <td  width="15%">
                                <strong>Commission</strong>
                            </td>
                            <td class="final_salesman_commission"  width="20%">$<?= $total_commission?></td>
                        </tr>
                    </table>
                <?= form_close()?>
                <div style="clear:both;"></div>
                <div style="float:left; margin-top:10px">
                        
                        <input type="button" class="close submit"  style="font-size:12px !important;cursor:pointer;" value="Close"> 
                    </div>
                    <div class="but-loc_new">
                        
                    <?php if (!$this->session->userdata("const_prop_admin_access")) { ?>
                                    <input onclick="sendadminalert();"  type="button" id="sendtoop" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Send to Operation">
                        <? } ?>
                        <?php if ($this->session->userdata("const_prop_admin_access") && !$this->session->userdata('superadmin')) { ?>
                                        <input  onclick="sendsuperadminalert();" type="button" id="sendtosu" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Send to Superadmin">
                        <? } ?>
                        <?php if ($this->session->userdata('superadmin')) { ?>
                                        <input  onclick="sendsalealert();"  type="button" id="sendtosale" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Finish">
                        <? } ?>
                    </div>
                </div>
             <? } ?>
            <!--add project tab-->
            <?php if ($this->session->userdata("const_prop_admin_access")) { ?>
                <div id="tabs-add-project" class="content clearfix" style="padding:10px;">    
                
                    <?= form_open('drwproposal/chk_project', 'id="new_project_detail"'); ?>
                    <div class=" error_d" style="display:none;" ></div>
                    <?= form_hidden('proposal_id', $proposal_id) ?>
                    <?= form_label('Project Type', 'Project Type'); ?>
                    <?= form_hidden('elect_labor', 60); ?>
                    <?= form_hidden('c_design_engg', 53); ?>
                    <div class="service_type_div">
                            <?= form_dropdown('service_type', $service_type, '', 'id="service_type" style="width:200px;'); ?>
                        <div class="other_service_div"  style="display: none">
                            <?= form_label('Other Service', 'Service Name'); ?>
                            <input type="text" name="other_service"  />
                        </div>
                     </div>
                
                    <div class="clearfix">
                    <?php if ($this->session->userdata("const_prop_admin_access")) { ?>
                            <table width="100%" class="gc_table-in">		
                                <tr>
                                    <td width="125px"><?= form_label('Materials Cost', 'elect_mat'); ?></td>
                                    <td> <font class="before">$</font> <?= form_input('elect_mat', 0, 'id="elect_mat" onchange="calculatePriceQuote1(this);"'); ?></td>
                                
                                    <td>     <?= form_label('Electrical Labor Hours', 'Electrical Labor Hours'); ?></td>
                                    <td>     <font class="before"></font> <?= form_input('elect_labor_hours', 0, 'id="elect_labor_hours" onchange="calculatePriceQuote1(this);"'); ?></td>
                                </tr>
                                
                                <tr>
                                    <td>     <?= form_label('Subcontractor Cost', 'c_sub_contractor'); ?></td>
                                    <td>     <font class="before">$</font> <?= form_input('c_sub_contractor',0, 'id="c_sub_contractor" onchange="calculatePriceQuote1(this);"'); ?></td>
                                
                                    <td>     <?= form_label('Genral Labor Hours', 'c_hours'); ?></td>
                                    <td>     <font class="before"></font> <?= form_input('c_hours', 0, 'id="c_hours" onchange="calculatePriceQuote1(this);"'); ?></td>
                                </tr>
                                <?php if ($this->session->userdata('superadmin')) { ?>
                                <tr>
                                    <td>    <?= form_label('Overhead', 'c_overhead_val'); ?></td>
                                    <td>    <font class="before"> %</font>
									<?= form_input('c_overhead_val', 0, 'id="c_overhead_val" onchange="calculatePriceQuote1(this);"'); ?> </td>

                                    <td>     <?= form_label('Profit Margin', 'c_p_margin_val'); ?></td>
                                    <td><font class="before"> %</font>    
									<?= form_input('c_p_margin_val', 0, 'id="c_p_margin_val" onchange="calculatePriceQuote1(this);"'); ?> </td>
                                </tr>
                                <tr>
                                    <td> <?= form_label('Commission', 'c_scommission_val'); ?></td>
                                    <td>    <font class="before"> %</font><?= form_input('c_scommission_val',0, 'id="c_scommission_val" onchange="calculatePriceQuote1(this);"'); ?> </td>
                                    <td> <?= form_label('Permit Fee', 'permit_fee_val'); ?></td>
                                    <td> 
                                        <input type="checkbox" name="c_permit_fee_val" id="c_permit_fee_val"  checked="checked" onclick="calculatePriceQuote1(this);" />
                                </tr>  
                                <?php }?>
                                <tr>
                                    <td></td><td></td>
                                    <td> <?= form_label('Discount', 'discount_val'); ?></td>
                                    <td>   <font class="before">$</font>  <?= form_input('c_discount_val', 0, 'id="c_discount_val" onchange="calculatePriceQuote1(this);"'); ?></td>
                                </tr>
<!--                                <tr>
                                    <td></td><td></td>
                                    
   
                                </tr>-->
                                <tr>
                                    <td></td><td></td>
                                <td> <?= form_label('Additional Cost', 'c_add_cost_val'); ?></td>
                                <td>    <font class="before">$</font> <?= form_input('c_add_cost_val',0, 'id="c_add_cost_val" onchange="calculatePriceQuote1(this);"'); ?></td>
                                </tr>
                                 <tr>
                                <td></td><td></td>
                                <td> <?= form_label('Upcharge', 'upcharge_val'); ?></td>
                                <td>    <font class="before">$</font> <?= form_input('c_upcharge_val', 0, 'id="c_upcharge_val" onchange="calculatePriceQuote1(this);"'); ?></td>
                                </tr>
                            </table>
                            <? } ?>
                        <div class="leftModalList">
                            <?= form_label('Description of Works', 'c_desc'); ?>
                            <?= form_textarea('c_desc', '', 'id="c_desc" style="width: 484px; height: 70px;"'); ?>
                        </div>
                    </div>
                    <!--hiddenfield div-->
                    <div class="emmp">
                        
                        <?= form_hidden('c_total', '', 'id="c_total"'); ?>

                        <?= form_hidden('c_subtotal','', 'id="c_subtotal"'); ?>


                        <?= form_hidden('c_ge_tax', '', 'id="c_ge_tax"'); ?>

                        <?= form_hidden('c_total_cost', '', 'id="c_total_cost"'); ?>

                        <?= form_hidden('c_add_cost', '', 'id="c_add_cost"'); ?>
                        <?= form_hidden('c_upcharge', '', 'id="c_upcharge"'); ?>
                        <?= form_hidden('c_discount', '', 'id="c_discount"'); ?>

                        <?= form_hidden('c_total_assests_val', '', 'id="c_total_assests_val"'); ?>

                        <?= form_hidden('c_permit_fee', '', 'id="c_permit_fee"'); ?>

                        <?= form_hidden('c_total_elec_payable', '', 'id="c_total_elec_payable"'); ?>
                        
                        <?= form_hidden('c_overhead', '', 'id="c_overhead"'); ?>
                        
                        <?= form_hidden('c_profit_margin', '', 'id="c_profit_margin"'); ?>
                        
                        <?= form_hidden('c_salesman_commission', '', 'id="c_salesman_commission"'); ?>
                        
                        <?= form_hidden('final_subtotal', '', 'id="final_subtotal"'); ?>
                        <?= form_hidden('final_overhead', '', 'id="final_overhead"'); ?>

                        <?= form_hidden('final_profit_margin', '', 'id="final_profit_margin"'); ?>
                        <?= form_hidden('final_salesman_commission', '', 'id="final_salesman_commission"'); ?>
                    </div>
                    
                    <?php if ($this->session->userdata("const_prop_admin_access")) { ?>
                        <table width="100%" class="value">
                            <?php if ($this->session->userdata('superadmin')) { ?>
                                
                            <?php } else { ?>
                                <?= form_hidden('c_overhead_val', '', 'id="c_overhead_val"'); ?>
                                <?= form_hidden('c_p_margin_val', '', 'id="c_p_margin_val"'); ?>
                                <?= form_hidden('c_scommission_val', '', 'id="c_scommission_val"'); ?>
                                <? } ?>
                            <tr>
                                
                                <?php if ($this->session->userdata('superadmin')) { ?>
                                    <td width="280px">&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td><b>Overhead :</b> $ <font class="c_overhead">0.00</font></td>
                                <? } else { ?>
                                    <td>&nbsp;</td>
                                <? } ?>
                                
                            </tr>
                            <tr>
                                <?php if ($this->session->userdata('superadmin')) { ?>
                                    <td>&nbsp;</td><td>&nbsp;</td>
                                    <td><b>Profit Margin :</b> $ <font class="c_profit_margin">0.00</font></td>
                                <? } else { ?>
                                    <td>&nbsp;</td>
                            <? } ?>
                            </tr>
                            <tr>
                                
                                <?php if ($this->session->userdata('superadmin')) { ?>	
                                    <td>&nbsp;</td>
                                    <td>&nbsp;</td>
                                    <td nowrap>
                                        <b>Salesman Commission :</b> $ <font class="c_salesman_commission">0.00</font>
                                    </td>
                                <? } else { ?>
                                    <td>&nbsp;</td>
                                <? } ?>
                                
                            </tr>
                            <tr>
                                <td>&nbsp;</td>
                                <td>&nbsp;</td>
                                <td rowspan="2" nowrap> <span style="float:left; width:129px;"><b><?= form_label('TOTAL PAYABLE'); ?></b></span>
                                <span><strong>$ </strong><font class="c_total_elec_payable"><strong>0</strong></font>
                                </span></td>
                            </tr>
                        </table> 
                    <? } ?>
                <?= form_close(); ?>
                    
                
                <div style="clear:both;"></div>
                <div style="float:left; margin-top:10px">
                        
                        <input type="button" class="close submit"  style="font-size:12px !important;cursor:pointer;" value="Close"> 
                    </div>
                <div class="but-loc_new">
                	<button class="next" style="cursor:pointer;">Save</button>
                        
                        <?php if (!$this->session->userdata("const_prop_admin_access")) { ?>
                                    <input onclick="sendadminalert();"  type="button" id="sendtoop" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Send to Operation">
                        <? } ?>
                        <?php if ($this->session->userdata("const_prop_admin_access") && !$this->session->userdata('superadmin')) { ?>
                                        <input  onclick="sendsuperadminalert();" type="button" id="sendtosu" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Send to Superadmin">
                        <? } ?>
                        <?php if ($this->session->userdata('superadmin')) { ?>
                                        <input  onclick="sendsalealert();"  type="button" id="sendtosale" class="submit" style="font-size:12px !important;cursor:pointer;"  value="Finish">
                        <? } ?>
                </div>    
            </div>
             <? } ?>

        </div>	
        <div style="clear:both;"></div>
        
        <div class="but-loc_new">
                           
        </div>

        <br/>
    </div>
</div>
<script>
    
    function updatetext(val) 
    {
        var values = $(val).val();
        values = values.split('-');
        id = values[0];
        table = values[1];
        if(id != 'other' || id != '')
        {
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>customers_gc/get_customer_detail/" + id,
                data: "id=" + id + "&table=" + table,
                dataType: "json",
                success: function (json) {

                    if (json.success == true)
                    {
                        customer_id = json.customer_id;
                        city = json.city;
                        state = json.state;
                        address = json.address1;
                        zip = json.zip;
                        phone = json.phone;
                        email = json.email;
                        last_name = json.last_name;
                        first_name = json.first_name;
                        $("input[name=customer_id]").val(customer_id);
                        $("#city").val(city);
                        $("#state").val(state);
                        $("#contact_address").val(address);
                        $("#zip").val(zip);
                        $('#phone').val(phone);
                        $('#email').val(email);
                        $('#last_name').val(last_name);
                        $('#first_name').val(first_name);
                    }
                    else if (json.success == false)
                    {
                        $("input[name=customer_exist]").val('n');
                        $("input[name=customer_id]").val('');
                        $("#city").val('');
                        $("#state").val('');
                        $("#contact_address").val('');
                        $("#zip").val('');
                        $('#phone').val('');
                        $('#email').val('');
                    }
                }
            });
        }
    }
    
    $('#last_name').live('keyup', function (event) {
        var first_name = $('#first_name').val();
        var last_name = $('#last_name').val();
        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>customers_gc/find_allprevious_customer",
            data: $('#proposal_basic').serialize(),
            dataType: "json",
            success: function (json) {
                if (json.success == true)
                {
                    var div_sugg = '';
                    div_sugg += '<label>Select Customer</label>';
                    div_sugg += '<select name="conf_exist" style="width: 100%;" onchange="return updatetext(this);"><option value="">--Please select customer--</option><option value="This is a new customer-0">This is a new customer</option>';
                    $.each(json.suggestions, function (i, object) {
                        div_sugg += '<option value="'+ object.value +'-'+ object.table+'" >' + object.data + '</option>';
                    });
                    div_sugg += '</select>';
                    if (div_sugg != '') {
                        $(".suggest").show();
                        $(".suggest").html(div_sugg);
                    }
                }
                else if (json.success == false)
                {
                    var div_sugg = '';
                    div_sugg += '<label>Select Customer</label>';
                    div_sugg += '<input name="conf_exist" type="text" value="no customer found" style="width:97%;">';
                    $(".suggest").html(div_sugg);
                }
                else {
                }
            }
        });
    });
    
    function update_project(id)  
    {   
        $('#main_error').css('display','none');
        var form_ref=$('#cost_form_'+id);
        var service_type = form_ref.find("[name=service_type]").val();
        var other_service = form_ref.find("[name=other_service]").val();
        var c_discount_val = form_ref.find("[name=c_discount_val]").val();
        var c_additional_cost = parseInt(form_ref.find("input[name=c_add_cost_val]").val());
        var c_upcharge = parseInt(form_ref.find("input[name=c_upcharge_val]").val());
      
        if(c_discount_val<=0){
            form_ref.find(".error_d").show();
            form_ref.find(".error_d").text('Discount cost should be postive value');
            return;
        }
        if(c_additional_cost<=0){
            form_ref.find(".error_d").show();
            form_ref.find(".error_d").text('Additional cost should be postive value');
            return;
        }
        if(c_upcharge<=0){
            form_ref.find(".error_d").show();
            form_ref.find(".error_d").text('Upcharge  should be postive value');
            return;
        }
        
        form_ref.find(".error_d").hide();
        
            
        if (service_type == 0)
        {
            form_ref.find(".error_d").show();
            form_ref.find(".error_d").text('Please Select Service Type');
            return;
        }else if (service_type == 4 && other_service == '')
        {
            form_ref.find(".error_d").text('Please provide other service name');
            form_ref.find(".error_d").show();
            return;
        }
        else {
            
            $("#displayloading").show();
            $.ajax({
                type: "POST",
                url: "<?= base_url() ?>customers_gc/updateprojectdetails/"+id,
                data: $("#cost_form_"+id).serialize(),
                dataType: "json",
                async: false,
                success: function (json) {
                    //alert(json);
                    if (json.success == true)
                    {
                       $.facebox({ajax: '<?= base_url() ?>customers_gc/project_type/<?= $proposal_id; ?>'}, 'Proposal Cost'); 
                    }
                    else
                    {
                        $("#displayloading").hide();
                        $(".form-errors").html(json.msg);
                        $(".form-errors").fadeIn();
                    }
                }
            });
        }
        $("#displayloading").hide();
        if (id)
            alert("Form data has been saved.");
    }
    function saveinfo()
    {
        
            $.ajax({
            type: "POST",
            url: "<?= base_url() ?>customers_gc/validate_propbasic/",
            data: $('#proposal_basic').serialize(),
            dataType: "json",
            async: false,
            success: function (json) {
                //alert(json);
                if (json.success == true)
                {
                     $.facebox({ajax: '<?= base_url() ?>customers_gc/project_type/<?= $proposal_id; ?>'}, 'Proposal Cost');
                }
                else
                {
                    $("#displayloading").hide();
                    $(".form-errors").html(json.msg);
                    $(".form-errors").fadeIn();
                }
            }
        });
    }
    function savespecification()
    {
        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>customers_gc/validate_spec",
            data: $("#specfication_form").serialize(),
            dataType: "json",
            async: false,
            success: function (json) {
                //alert(json);
                if (json.success == true)
                {
                     $.facebox({ajax: '<?= base_url() ?>customers_gc/project_type/<?= $proposal_id; ?>'}, 'Proposal Cost');
                }
                else
                {
                    $("#displayloading").hide();
                    $(".form-errors").html(json.msg);
                    $(".form-errors").fadeIn();
                }
            }
        });
    }
    $(document).ready(function () {
        
        $("[name=c_permit_fee_val]").change(function () {
            if($(this).is(':checked'))
                $(this).val(1);
            else
                $(this).val(0)
        });
        $("[name=service_type]").change(function () {
            
            var parr=$(this).parent();
            
            if($(this).val()==4){
                parr.find('.other_service_div').show()
            }else{
                parr.find('.other_service_div').hide()
                $("[name=other_service]").val('');
                
                if($(this).val()!=1 && $(this).val()!=2 && $(this).val()!=3 && $(this).val()!=4)
                {
                    var form1= $(this).closest("form")
                    var form_id=  form1.attr('id');
                    
                   $.ajax({
                        type: "POST",
                        url: "<?= base_url() ?>customers_gc/fetchexitsprojectdetails/"+$(this).val()+'/'+form_id,
                        data: '',
                        dataType: "json",
                        success: function (json) {
                            
                            if (json.success == true) 
                            {
                                form1.find("input[name=elect_mat]").val(json.elect_mat);
                                
                                form1.find("input[name=elect_labor_hours]").val(json.elect_labor_hours);

                                form1.find("input[name=c_sub_contractor]").val(json.c_sub_contractor);
                                form1.find("input[name=c_hours]").val(json.c_hours);
                                form1.find("input[name=c_overhead_val]").val(json.c_overhead_val);
                                form1.find("input[name=c_p_margin_val]").val(json.c_p_margin_val);
                                form1.find("input[name=c_scommission_val]").val(json.c_scommission_val);
                                form1.find("input[name=c_discount_val]").val(json.c_discount_val);
                                
                                form1.find("input[name=c_add_cost_val]").val(json.c_add_cost_val);
                                
                                form1.find("input[name=c_upcharge_val]").val(json.c_upcharge_val);
                                
                                form1.find("textarea").text(json.c_desc);
                                if(json.c_permit_fee_val>0){
                                    form1.find("input[name=c_permit_fee_val]").prop('checked', true);
                                }else{
                                    form1.find("input[name=c_permit_fee_val]").prop('checked', false);
                                }
                                
                                form1.find("input[name=c_hours]").trigger('onchange');
                                
                                
                            }
                        }
                    });
                }
            }
        });
        
        $(".next").click(function () {
            $('#main_error').css('display','none');
            var form_ref=$('#new_project_detail');
            var total_payable = parseInt(form_ref.find("input[name=c_total_elec_payable]").val());
            var service_type = form_ref.find("[name=service_type]").val();
            var other_service = form_ref.find("[name=other_service]").val();
             
             
            var c_discount_val = form_ref.find("[name=c_discount_val]").val();
            var c_additional_cost = parseInt(form_ref.find("input[name=c_add_cost_val]").val());
            var c_upcharge = parseInt(form_ref.find("input[name=c_upcharge_val]").val());
      
            if(c_discount_val<=0){
                form_ref.find(".error_d").show();
                form_ref.find(".error_d").text('Discount cost should be postive value');
                return;
            }
            if(c_additional_cost<=0){
                form_ref.find(".error_d").show();
                form_ref.find(".error_d").text('Additional cost should be postive value');
                return;
            }
            if(c_upcharge<=0){
                form_ref.find(".error_d").show();
                form_ref.find(".error_d").text('Upcharge  should be postive value');
                return;
            }
            form_ref.find(".error_d").hide();

            if (service_type == 0)
            {
                form_ref.find(".error_d").show();
                form_ref.find(".error_d").text('Please Select Service Type');
                return;
            }else if (service_type == 4 && other_service == '')
            {
                form_ref.find(".error_d").text('Please provide other service name');
                form_ref.find(".error_d").show();
                return;
                
            }else if(!total_payable || !total_payable<0){
                form_ref.find(".error_d").text('Total payable should be greater than zero');
                form_ref.find(".error_d").show();
                return;
            }
            else {

                var proposal_id;
                proposal_id = parseInt($("input[name=proposal_id]").val(), 10);

                $.ajax({
                    type: "POST",
                    url: "<?= base_url() ?>customers_gc/addproject/",
                    data: $('#new_project_detail').serialize(),
                    dataType: "json",
                    success: function (json) {
                        if (json.success == true) {
                            
                            $.facebox({ajax: '<?= base_url() ?>customers_gc/project_type/<?= $proposal_id; ?>'}, 'Proposal Cost');
                            }else{
                                $(".form-errors").html(json.msg);
                                $(".form-errors").fadeIn();   
                            }
                    }
                });

            }
        });
        
        calculatePriceQuote1 = function (pform, is_save) 
        {
            
            var form1 = $(pform).closest("form"); //this refers to the form
            
            var elect_mat = parseFloat(form1.find("input[name=elect_mat]").val());
            var elect_labor = parseFloat(form1.find("input[name=elect_labor]").val());
            
            var elect_labor_hours = parseFloat(form1.find("input[name=elect_labor_hours]").val());
            
            var c_design_engg = parseFloat(form1.find("input[name=c_design_engg]").val());
            var c_sub_contractor = parseFloat(form1.find("input[name=c_sub_contractor]").val());
            
            var c_hours = parseFloat(form1.find("input[name=c_hours]").val());
            
            var c_discount_val=form1.find("input[name=c_discount_val]").val();
            
            if(c_discount_val<0){
                form1.find(".error_d").show();
                form1.find(".error_d").text('Discount cost should be postive value');
                return;
            }

             var c_additional_cost = parseInt(form1.find("input[name=c_add_cost_val]").val());
             
             var c_upcharge = parseInt(form1.find("input[name=c_upcharge_val]").val());

            if(c_additional_cost<0){
            form_ref.find(".error_d").show();
            form_ref.find(".error_d").text('Additional cost should be postive value');
            return;
            }
            if(c_upcharge<0){
            form_ref.find(".error_d").show();
            form_ref.find(".error_d").text('Upcharge  should be postive value');
             return;
            }
            form1.find(".error_d").hide();
                
            
            if (!elect_mat)
            {
                elect_mat = 0;
            }
            if (!elect_labor)
            {
                elect_labor = 0;
            }
            if (!c_design_engg)
            {
                c_design_engg = 0;
            }
            if (!c_sub_contractor)
            {
                c_sub_contractor = 0;
            }
            //Total
            var c_total = elect_mat + (elect_labor*elect_labor_hours) + (c_design_engg*c_hours) + c_sub_contractor;
            c_total=(c_total>0)?c_total:0;
//            console.log('elect_mat='+elect_mat)
//            console.log('elect_labor='+elect_labor)
//            console.log('elect_labor_hours='+elect_labor_hours)
//            console.log('c_design_engg='+c_design_engg)
//            console.log('c_hours='+c_hours)
//            console.log('c_sub_contractor='+c_sub_contractor)
//            console.log('c_total='+c_total)
            
            form1.find("input[name=c_total]").val(c_total);
            form1.find(".c_total").html(c_total);

            //Overhead
            var c_over = (form1.find("input[name=c_overhead_val]").val());
            var c_overhead = c_total * c_over / 100;
            form1.find("input[name=c_overhead]").val(c_overhead);
            form1.find(".c_overhead").html((c_overhead>0)?c_overhead:0);

            //Subtotal
            var c_p_margin = parseInt(form1.find("input[name=c_p_margin_val]").val());
            var c_subtotal = (c_total + c_overhead) / ((100 - c_p_margin) / 100);
            form1.find("input[name=c_subtotal]").val(c_subtotal.toFixed(2));
            form1.find(".c_subtotal").html((c_subtotal>0)?c_subtotal.toFixed(2):0);

            //Profit Margin
            var c_pm = 1
            var c_profit_margin = (c_subtotal - (c_total + c_overhead) * c_pm);
            form1.find("input[name=c_profit_margin]").val(c_profit_margin.toFixed(2));
            form1.find(".c_profit_margin").html((c_profit_margin>0)?c_profit_margin.toFixed(2):0);

            //Salesman Commission
            var c_sm = parseInt(form1.find("input[name=c_scommission_val]").val());
            var c_salesman_commission = c_subtotal * c_sm / 100;
            form1.find("input[name=c_salesman_commission]").val(c_salesman_commission.toFixed(2));
            form1.find(".c_salesman_commission").html((c_salesman_commission>0)?c_salesman_commission.toFixed(2):0);

            //GE TAX
            var c_gt = 0.04712;
            var c_ge_tax = (c_subtotal + c_salesman_commission) * c_gt;
            form1.find("input[name=c_ge_tax]").val(c_ge_tax.toFixed(2));
            form1.find(".c_ge_tax").html((c_ge_tax>0)?c_ge_tax.toFixed(2):0);

            //Total Cost
            var c_total_cost = c_subtotal + c_salesman_commission + c_ge_tax;
            form1.find("input[name=c_total_cost]").val(c_total_cost.toFixed(2));
            form1.find(".c_total_cost").html((c_total_cost>0)?c_total_cost.toFixed(2):0);

            //Total Assests Value
            var c_additional_cost = parseInt(form1.find("input[name=c_add_cost_val]").val());
            var c_upcharge = parseInt(form1.find("input[name=c_upcharge_val]").val());
            var c_discount = parseInt(form1.find("input[name=c_discount_val]").val());
            var c_total_assests_val = c_total_cost + c_additional_cost + c_upcharge - c_discount;
            form1.find("input[name=c_total_assests_val]").val(c_total_assests_val.toFixed(2));
            form1.find(".c_total_assests_val").html(c_total_assests_val.toFixed(2));

            //Permit Fee
            
            var c_p_fee = c_total_assests_val * 0.02;
            var c_p_fee_count = parseInt(form1.find("input[name=c_permit_fee_val]").is(':checked')?1:0);
            var c_permit_fee = c_p_fee * c_p_fee_count;
            form1.find("input[name=c_permit_fee]").val(c_permit_fee.toFixed(2));
            form1.find(".c_permit_fee").html(c_permit_fee.toFixed(2));

            //Total Value
            var c_total_elec_payable = c_total_assests_val + c_permit_fee;
            form1.find("input[name=c_total_elec_payable]").val(c_total_elec_payable.toFixed(2));
            form1.find(".c_total_elec_payable").html('<strong>'+((c_total_elec_payable>0)?c_total_elec_payable.toFixed(2):0)+'</strong>');

            //Final Subtotal
            var total1 = parseInt(form1.find("input[name=c_total_elec_payable]").val());
            
            var final_subtotal = total1;
            form1.find("input[name=final_subtotal]").val(final_subtotal);
            form1.find(".final_subtotal").html(final_subtotal);


            //Final Overhead	
            var overhead1 = parseInt(form1.find("input[name=c_overhead]").val());
            
            var final_overhead = overhead1;
            form1.find("input[name=final_overhead]").val(final_overhead);
            form1.find(".final_overhead").html(final_overhead);

            //Final Profile Margin	
            var profit_margin1 = parseInt($("input[name=c_profit_margin]").val());
            
            var final_profit_margin = profit_margin1;
            
            form1.find("input[name=final_profit_margin]").val(final_profit_margin);
            form1.find(".final_profit_margin").html(final_profit_margin);

            //Final Salesman Commisssion	
            var salesman_commission1 = parseInt(form1.find("input[name=c_salesman_commission]").val());
            var final_salesman_commission = salesman_commission1;
            form1.find("input[name=final_salesman_commission]").val(final_salesman_commission);
            form1.find(".final_salesman_commission").html(final_salesman_commission);
        };
    });

    $(function () {
        $('.chkNumber').click(function () {
            if ($('.chkNumber:checked').length) {
                var chkId = '';
                $('.chkNumber:checked').each(function () {
                    chkId += $(this).val() + ",";
                });
                chkId = chkId.slice(0, -1);
                $("input[name=specification]").val(chkId);
            }
            else if ($('.chkNumber:checked').length == 0)
            {
                $("input[name=specification]").val(0);
            }
        });
    });

    $(function () {
        $('.chkProject').click(function () {
            if ($('.chkProject:checked').length) {
                var chkId = '';
                $('.chkProject:checked').each(function () {
                    chkId += $(this).val() + ",";
                });
                chkId = chkId.slice(0, -1);
                $("input[name=project]").val(chkId);
            }
            else if ($('.chkProject:checked').length == 0)
            {
                $("input[name=project]").val(0);
            }
        });
    });


    function deleteprojecttype(project_id)
    {
        
        $("#displayloading").show();
        
        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>customers_gc/deleteprojecttype/"+project_id,
            data: '',
            dataType: "json",
            async: false,
            success: function (json) {
                //alert(json);
                    if (json.success == true)
                    {
                        $.facebox({ajax: '<?= base_url() ?>customers_gc/project_type/<?= $proposal_id; ?>'}, 'Proposal Cost');
                    }
                    else
                    {
                        $("#displayloading").hide();
                        $(".form-errors").html(json.msg);
                        $(".form-errors").fadeIn();
                    }
            }
        });
    }

    function deletegen() 
    {
        //$("#cost_form").reset();
        $("#displayloading").show();
        $("#cost_form_1").find("input[type=text], textarea").val("");
        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>customers_gc/delete_gen",
            data: $("#cost_form").serialize(),
            dataType: "json",
            async: false,
            success: function (json) {
                //alert(json);
                if (json.success == true)
                {
                    $.facebox({ajax: '<?= base_url() ?>customers_gc/project_type/<?= $proposal_id; ?>'}, 'Proposal Cost');
                }
                else
                {
                    $("#displayloading").hide();
                    $(".form-errors").html(json.msg);
                    $(".form-errors").fadeIn();
                }
            }
        });
    }
    function deleteplu() 
    {
        $("#displayloading").show();
        $("#cost_form_2").find("input[type=text], textarea").val("");
        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>customers_gc/delete_plu",
            data: $("#cost_form").serialize(),
            dataType: "json",
            async: false,
            success: function (json) {
                //alert(json);
                if (json.success == true)
                {
                    $.facebox({ajax: '<?= base_url() ?>customers_gc/project_type/<?= $proposal_id; ?>'}, 'Proposal Cost');
                }
                else
                {
                    $("#displayloading").hide();
                    $(".form-errors").html(json.msg);
                    $(".form-errors").fadeIn();
                }
            }
        });
    }
    function sendadminalert() 
    {
        $("#displayloading").show();
        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>customers_gc/sendadminalert/<?= $proposal_id; ?>",
            data: '',
            dataType: "json",
            async: false,
            success: function (json) {
                //alert(json);
                if (json.success == true)
                {
                    $("#displayloading").hide();
                    alert("Mail has been sent");
                    window.location.reload();
                }
                else
                {
                    $("#displayloading").hide();
                    $(".form-errors").html(json.msg);
                    $(".form-errors").fadeIn();
                }
            }
        });
    }
    function sendsuperadminalert() 
    {
        $("#displayloading").show();

        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>customers_gc/sendsuperadminalert/<?= $proposal_id; ?>",
            data: '',
            dataType: "json",
            async: false,
            success: function (json) {
                //alert(json);
                if (json.success == true)
                {
                    $("#displayloading").hide();
                    alert("Mail has been sent");
                    window.location.reload();
                }
                else
                {
                    $("#displayloading").hide();
                    $(".form-errors").html(json.msg);
                    $(".form-errors").fadeIn();
                }
            }
        });
    }

    function sendsalealert() 
    {
        
    $('.error_d').css('display','none');   
    $("#displayloading").show();

        $.ajax({
            type: "POST",
            url: "<?= base_url() ?>customers_gc/sendsalealert/<?= $proposal_id; ?>",
            data: '',
            dataType: "json",
            async: false,
            success: function (json) {
                //alert(json);
                if (json.success == true)
                {
                    $("#displayloading").hide();
                    alert("Mail has been sent");
                    window.location.reload();
                }
                else
                {
                    $("#displayloading").hide();
                    $(".form-errors").html(json.msg);
                    $(".form-errors").fadeIn();
                }
            }
        });
    }
                                                                                               
                                                                                                    
</script>