<?php
/**
 * Shared job detail navigation tabs.
 *
 * Expected variables (all set by controller):
 *   $job_id, $job, $titlejob, $titleshow, $userrole,
 *   $jobclass, $finaceclass, $customerclass
 *   $active_tab (string: 'comments','specs','cost','status','photos',
 *                'reqphotos','referrals','customer','documents',
 *                'permits','inv','files','installers','support')
 *
 * Variables extracted in this partial:
 *   $tab_setting_jobid (from get_tab_setting())
 *   $deal_type (from getproposaltype() for PV jobs)
 *
 * SCH-018: Extracted from ~74 admin view files into single shared partial.
 */

$tab_setting_jobid = get_tab_setting();
$CI =& get_instance();
$deal_type = 0;
if ($job['job_type_id']==2 && $job['proposal_id']>0) {
    $deal_type = $CI->getproposaltype($job['proposal_id']);
}

$role = $this->session->userdata('role');
$is_admin = ($role == 'admin');
$is_sales = ($role == 'sales');
$jtype = $job['job_type_id'];
?>
<div class="generic-nav-tabs">

    <!-- Comments -->
    <a href="<?=base_url()?>admin/job_comment/<?=$job_id?>"
       <?php if($active_tab=='comments') echo 'class="active"'; ?>>Comments</a>

    <!-- Specs -->
    <?php
    $specs_label = $titleshow . ' Specs';
    if ($titlejob == 'Service') $specs_label = 'Service Specs';
    elseif ($titlejob == 'Electrical Pre-install') $specs_label = 'EL Specs';
    ?>
    <a id="jobpvswh" href="<?=base_url()?>admin/job/<?=$job_id?>"
       class="<?php if($active_tab=='specs') echo 'active '; echo $jobclass; ?>"><?=$specs_label?></a>

    <!-- Cost (hidden from installer/contractor/designer roles, PreLag, Premeasure) -->
    <?php if(!$userrole && $titleshow!='PreLag' && $titleshow!='Premeasure') { ?>
    <a id="financepvswh" href="<?=base_url()?>admin/job_financing/<?=$job_id?>"
       class="<?php if($active_tab=='cost') echo 'active '; echo $finaceclass; ?>">Cost</a>
    <?php } ?>

    <!-- Status -->
    <?php if($deal_type==9 && $job_id<34181) { ?>
    <a href="<?=base_url()?>admin/job_status/<?=$job_id?>"
       <?php if($active_tab=='status') echo 'class="active"'; ?>>Status</a>
    <?php } ?>
    <?php if($job_id>34181) { ?>
    <a href="<?=base_url()?>job_status_tab/job_status/<?=$job_id?>"
       <?php if($active_tab=='status') echo 'class="active"'; ?>>Status</a>
    <?php } ?>

    <!-- Req. Photos -->
    <?php if($job_id < $tab_setting_jobid): ?>
        <?php if ($job_id<16587 && !$is_sales) { ?>
    <a href="<?=base_url()?>filetab/fileview_job/<?=$job_id?>"
       <?php if($active_tab=='reqphotos') echo 'class="active"'; ?>> Req. Photos </a>
        <?php } elseif (!$is_sales) { ?>
    <a href="<?=base_url()?>filetab/file_index/<?=$job_id?>"
       <?php if($active_tab=='reqphotos') echo 'class="active"'; ?>> Req. Photos </a>
        <?php } ?>
    <?php endif; ?>

    <!-- Photos -->
    <a href="<?=base_url()?>phototab/photo_index/<?=$job_id?>"
       <?php if($active_tab=='photos') echo 'class="active"'; ?>>Photos</a>

    <!-- Referrals (Job type only, not Service/EL/PreLag/Premeasure) -->
    <?php if($titlejob=='Job' && !$userrole && $titleshow!='PreLag'
             && $titleshow!='Premeasure' && $jtype!=5 && $jtype!=8) { ?>
    <a href="<?=base_url()?>admin/job_referrals/<?=$job_id?>"
       <?php if($active_tab=='referrals') echo 'class="active"'; ?>>Referrals</a>
    <?php } ?>

    <!-- Customer -->
    <a id="customerpvswh" href="<?=base_url()?>admin/customer_job/<?=$job_id?>"
       class="<?php if($active_tab=='customer') echo 'active '; echo $customerclass; ?>">Customer</a>

    <!-- Documents -->
    <a href="<?=base_url()?>admin/job_file_status/<?=$job_id?>"
       <?php if($active_tab=='documents') echo 'class="active"'; ?>>Documents</a>

    <!-- Permits -->
    <?php if($job_id < $tab_setting_jobid): ?>
        <?php if((@$deal_type!=9 && $jtype!=5) || $job_id<27428) { ?>
    <a href="<?=base_url()?>admin/permit_job/<?=$job_id?>"
       <?php if($active_tab=='permits') echo 'class="active"'; ?>> Permits</a>
        <?php } ?>
    <?php endif; ?>

    <!-- INV (admin only, PV/SAF with proposal) -->
    <?php if($is_admin && ($jtype==2 || $jtype==6) && $job['proposal_id']>0) { ?>
    <a href="<?=base_url()?>tracmor/inv_tab/<?=$job_id?>"
       <?php if($active_tab=='inv') echo 'class="active"'; ?>> INV</a>
    <?php } ?>
    <!-- INV (admin only, Service jobs) -->
    <?php if($is_admin && $jtype==5) { ?>
        <?php if(isset($job['service_call_type']) && $job['service_call_type']==2) { ?>
    <a href="<?=base_url()?>tracmorservice/inv_tab_sc_swh/<?=$job_id?>"
       <?php if($active_tab=='inv') echo 'class="active"'; ?>> INV</a>
        <?php } else { ?>
    <a href="<?=base_url()?>tracmorservice/inv_tab_sc_pv/<?=$job_id?>"
       <?php if($active_tab=='inv') echo 'class="active"'; ?>> INV</a>
        <?php } ?>
    <?php } ?>

    <!-- Support (Service jobs only) -->
    <?php if($jtype==5) { ?>
    <a href="<?=base_url()?>jobsupporttab/index/<?=$job_id?>"
       <?php if($active_tab=='support') echo 'class="active"'; ?>> Support</a>
    <?php } ?>

    <div class="clear-left"></div>
</div>
