<!--
Customer Types: Residential, Commercial
Job Type: Solar Water Heating, Photovoltaic, Solar Attic Fan, Service Call

Automatic filtering to prevent same-name/same-address scenarios. i.e. if name is entered and there is a similar name/lastname, if asks if this person lives at the same address. If yes, it'll modify that persons profile, ie customers can have more than one job added to it like solar water heating, photovoltaics, solar fans, etc
Ability to 'Save for later', i.e. saves and closes overlay window and returns to Job Calendar view
Ability to 'Enter more details' - takes user to job detailed page to enter more customer details.

- width of all overlays should be the same, although its not necessary to keep it the same width in the mockups
-->
<style>
.anothername{display:none;}
</style>
<div class="reserve-job" id="reservejob">
	<div class="header clearfix">
		
                <div class="title">Job Count Setting For <span class="underline"><?=strtoupper(date("M j, Y",$job_date))?></span></div>
		<div class="close-button"><a href="#" class="cancel-facebox">&times;</a></div>
		<div class="clear-both"></div>
	</div>
	<div class="content clearfix" style="padding:10px;">
		
		<div class="form-errors" style="display:none;"></div>
		<?=form_open('ajax/reserve_job', 'id="reserve_form"');?>
                <?=form_hidden('job_date',$job_date)?>
                <?=form_hidden('id',@$id)?>
		<?=form_label('PV Job');?>
		<?=form_input('pv_job',$pv,'id="pvjob" maxlength=3');?>
        <?=form_label('SWH Job');?>
		<?=form_input('swh_job',$swh,'id="swhjob" maxlength=3');?>
   <?=form_label('GC Job');?>
		<?=form_input('gc_job',$gc,'id="gcjob" maxlength=3');?>
        <?=form_label('SC Job');?>
		<?=form_input('sc_job',$sc,'id="scjob" maxlength=3');?>
        <?=form_label('EL Job');?>
		<?=form_input('el_job',$el,'id="eljob" maxlength=3');?>		
        <?=form_label('PM Job');?>
		<?=form_input('pm_job',$pm,'id="pmjob" maxlength=3');?>
		<?=form_label('AC Job');?>
		<?=form_input('ac_job',$ac,'id="acjob" maxlength=3');?>		
        <?=form_label('APM Job');?>
		<?=form_input('apm_job',$apm,'id="apmjob" maxlength=3');?>
		 <?=form_label('PL Job');?>
		<?=form_input('pl_job',$pl,'id="pljob" maxlength=3');?>
  <?=form_label('HESS Job');?>
		<?=form_input('hess_job',$hess,'id="hessjob" maxlength=3');?>
   <?=form_label('WM Job');?>
		<?=form_input('wm_job',$wm,'id="wmjob" maxlength=3');?>
		<?=form_close();?>
		<div style="float:left;">
			<button class="cancel-facebox">Cancel</button>
		</div>
		
		<div style="float:right">
			<!--<button class="save-for-later">Save for later</button> -->
			<button class="save">Save</button>
		</div>
		<div class="clear-both"></div>
		
	</div>
</div>

<script type="text/javascript" charset="utf-8">
$(document).ready(function() {
        enter_more_details = function()
	{
		var pv_job   = parseInt($("#pvjob").val(),10);
                if(!pv_job) {
					pv_job=0;
                   // alert("Please enter the PV job value");
                  //  return;
                }
                var swh_job  = parseInt($("#swhjob").val(),10);
                if(!swh_job) {
					swh_job=0;
                    //alert("Please enter the SWH job value");
                    //return;
                }
                var sc_job   = parseInt($("#scjob").val(),10);
                if(!sc_job) {
					sc_job=0;
                    //alert("Please enter the SC job value");
                    //return;
                }
                var el_job   = parseInt($("#eljob").val(),10);
                if(!el_job) {
					el_job=0;
                    //alert("Please enter the SC job value");
                    //return;
                }                
                
                
                
                var pm_job   = parseInt($("#pmjob").val(),10);
              
                if(!pm_job) {
					pm_job=0;
                    //alert("Please enter the PM job value");
                    //return;
                }
				 var ac_job   = parseInt($("#acjob").val(),10);
              
                if(!ac_job) {
					ac_job=0;
                    //alert("Please enter the AC job value");
                    //return;
                }
                
                var apm_job   = parseInt($("#apmjob").val(),10);
              
                if(!apm_job) {
					apm_job=0;
                    //alert("Please enter the APM job value");
                    //return;
                }

				 var pl_job   = parseInt($("#pljob").val(),10);
              
                if(!pl_job) {
					             pl_job=0;
                }
                 var hess_job   = parseInt($("#hessjob").val(),10);
                 if(!hess_job) {
					             hess_job=0;
                }
                var wm_job   = parseInt($("#wmjob").val(),10);
                 if(!wm_job) {
					             wm_job=0;
                }
                  var gc_job   = parseInt($("#gcjob").val(),10);
                 if(!gc_job) {
					             gc_job=0;
                }
                var job_date = $("input[name=job_date]").val();
                var id = $("input[name=id]").val();
                $.ajax({
			type: "POST",
			url: "<?=base_url()?>ajax/updatejobsetting/"+job_date+"/"+pv_job+"/"+swh_job+"/"+sc_job+"/"+pm_job+"/"+el_job+"/"+ac_job+"/"+apm_job+"/"+pl_job+"/"+hess_job+"/"+"/"+wm_job+"/"+"/"+gc_job+"/"+id,
			data: $('#reserve_form').serialize(),
			dataType: "json",
			success: function(json) {
				if(json.success == true)
				{
					alert("job setting has been updated.")
     $.facebox.close();
				}
				else
				{
					$(".form-errors").html(json.msg);
					$(".form-errors").fadeIn();
				}
			}
		});
	}
	
	
	$('.save').click(function() {  enter_more_details() });
});

</script>