<!--
Customer Types: Residential, Commercial
Job Type: Solar Water Heating, Photovoltaic, Solar Attic Fan, Service Call

Automatic filtering to prevent same-name/same-address scenarios. i.e. if name is entered and there is a similar name/lastname, if asks if this person lives at the same address. If yes, it'll modify that persons profile, ie customers can have more than one job added to it like solar water heating, photovoltaics, solar fans, etc
Ability to 'Save for later', i.e. saves and closes overlay window and returns to Job Calendar view
Ability to 'Enter more details' - takes user to job detailed page to enter more customer details.

- width of all overlays should be the same, although its not necessary to keep it the same width in the mockups
-->

<div class="reserve-job">
	<div class="header">
		<div class="title">Schedule New Job - Required Information</div>
		<div class="close-button"><a href="#" class="cancel-facebox">&times;</a></div>
		<div class="clear-both"></div>
	</div>
	<div class="content">
		
		<div class="form-errors" style="display:none;"></div>
		
		<?=form_open('ajax/installer', 'id="installer_form"');?>
		
		<?=form_hidden('job_id',@$job['id'])?>
		
		
		<?=form_label('Number of Panels', 'nop');?>
		<?=form_dropdown('nop', $numberofpanels ,@$job['panel_count'],"id='nop' onchange='calculateInstaller();' " );?>
		
	
                <?=form_label('Roof type', 'in_rooftype');?>
		<?=form_dropdown('in_rooftype', $roof_type,@$job['roof_type_id'],"id='in_rooftype'  onchange='calculateInstaller();'");?>

		<?=form_label('Pipe Run Distance', 'piperundist');?>
		<?=form_dropdown('piperundist', $piperundistance,@$job['piperun_length'],"id='piperundist' onchange='calculateInstaller();'");?>
                 <?php
                     $default_installer = 2;
                     if(@$job['no_installer_allocated']) {
                        $default_installer = $job['no_installer_allocated'];
                      }
                 ?>
                
		<div class="clearfix" style=" background: none repeat scroll 0 0 #FF6600;border: 1px solid #DF5900;padding: 10px;">
			<div class="clearfix">
				<div class="ltpan" style="width:250px; float:left; padding-top:3px;">Installers Required For Your Job:</div>
				<div class="rtpan" style="width:50px; float:right;" ><input type="text" id="in_noi" name ="in_noi" style="width:39px; color:#c44e00;"   value="<?=$default_installer?>"/></div>
			</div>
			<div class="clearfix">
				<div class="ltpan" style="width:250px; float:left; padding-top:3px;">Number of Day to  Split job into:</div>
				<div class="rtpan" style="width:50px; float:right;"><?=form_dropdown('in_nod', $nod,@$job['in_nod'],'style="width:50px; margin:0; color:#c44e00;"  id="in_nod" ');?></div>
			</div>
		</div>
		
		
		
		<?=form_close();?>
		<br/>
                <div style="float:left;">
			<button class="cancel-facebox">Cancel</button>
		</div>
		
		<div style="float:right">
			<button class="backdiv">Back</button>
			<button class="findavailabledate">Find Available Date</button>
		</div>
		<div class="clear-both"></div>
		
	</div>
</div>

<script type="text/javascript" charset="utf-8">
var customer_id = '';
var numberofinstaller = 40;
$(document).ready(function() {
	
	// look for previously entered customers
	
	save_for_later = function()
	{
          var msg = "";
          var error = false;
          var nop = $("#nop").val();
          nop = parseInt(nop);
          if (!nop ){
              msg = "Please Select The Number of Panel \n  <br/>";
              error = true;
          }
        
          var rooftype = $("#in_rooftype").val();
          rooftype =  parseInt(rooftype);
          if (!rooftype && !error ){
              msg = "Please Select The Roof Type \n <br/>";
              error = true;
          }
          var piperundist = $("#piperundist").val();
          piperundist = parseInt(piperundist);
          if (!piperundist && !error ){
              msg = "Please Select The Pipe Run Distance \n <br/>";
              error = true;
          }
          var ni = $("#in_noi").val();
          var da = $("#in_nod").val();
          if (!error){
              if (ni > numberofinstaller && da==1) {
                msg = "You will need to split your job into multiple days due to installer limitation.";
                error = true;
              }

              if (ni > 2*numberofinstaller  && da==2) {
                msg = "You will need to split your job into multiple days due to installer limitation.";
                error = true;
              }

              if (ni > 3*numberofinstaller  && da==3) {
                msg = "Please Contact To  Administrator.";
                error = true;
              }
          }
          if (error){
              $(".form-errors").html(msg);
	      $(".form-errors").fadeIn();
              return ;
          }
          
                <?=@$sct;?>
		$.ajax({
			type: "POST",
			url: "<?=base_url()?>ajax/save_session",
			data: $('#installer_form').serialize()+"&"+reserverjob,
			dataType: "json",
			success: function(json) {
				if(json.success == true)
				{
					//$.facebox.close();
					location.href="<?=base_url()?>admin/installer_available/<?=$year?>/<?=$month?>/"+userid;
				}
				else
				{
					$(".form-errors").html(json.msg);
					$(".form-errors").fadeIn();
				}
			}
		});
	}
	
	calculateInstaller = function()
	{
          var noi;
          noi = 2;
          var nop = $("#nop").val();
          nop = parseInt(nop);
          if (nop==4){
            noi += 1;
          }
          
          
          var rooftype = $("#in_rooftype").val();
           rooftype =  parseInt(rooftype);
        
        switch(rooftype){
              case 5:
                  noi += 0;
                  break;
              case 6:
                  noi += 1;
                  break;
              case 7:
                  noi += 1;
                  break;
              case 8:
                  noi += 0;
                  break;
              
          }


          var piperundist = $("#piperundist").val();
          piperundist = parseInt(piperundist);
          switch(piperundist){
              case 1:
                  noi += 0;
                  break;
              case 2:
                  noi += 1;
                  break;
              case 3:
                  noi += 2;
                  break;
              case 4:
                  noi += 4;
                  break;
              case 5:
                  noi -= 2;
                  break;
          }

          
          
          $("#in_noi").val(noi);
      
        }

  function  backReservejob(){
    $.facebox({ ajax: '<?=base_url()?>ajax/reserve_job/<?=$year?>/<?=$month?>?'+reserverjob+'' }, 'Installer');
  }
	$('.findavailabledate').click(function() {  save_for_later() });
	$('.backdiv').click(function() { $(this).unbind('click'); backReservejob() });
});
</script>
<style>
    #facebox{

     z-index:9999; }
</style>