<?php

class Ajax extends Controller {

	function Ajax()
	{
		parent::Controller();
		if(!$this->session->userdata('logged_in'))
		{
			$tempurl = explode("/index.php/", $_SERVER['PHP_SELF']);
                        redirect("login?ref=".$tempurl[1]);
		}	
	}
	
	function index()
	{
		
	}
	
	function preview_job()
	{
		$this->load->view("ajax/preview_job");
	}
	
	function choose_reserve_date()
	{
		$this->load->view("ajax/choose_reserve_date");
	}
	
	function preview_day($year='',$month='',$day='')
	{
		
		if(@$year=='') {$year = date("Y");}
		if(@$month=='') {$month = date("m");}
		if(@$day=='') {$day = date("d");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = $day;
		
		$data['day_timestamp'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		$extra_sql = '';
		if($this->session->userdata("role") != 'admin')
		{
			$extra_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));
		}
		// grab photovoltaic jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='2' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
			";
		$data['jobs'] = $this->db->query($sql)->result_array();
		
		// grab solar water heating jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='1' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['jobs'] += $this->db->query($sql)->result_array();
		
		// grab solar attic fan jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='3' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['jobs'] += $this->db->query($sql)->result_array();
		
		// get service calls for the day
		$sql = "SELECT service_calls.*,customers.first_name,customers.last_name,customers.address,customers.city,customers.state,colors.hex FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN customers ON service_calls.customer_id=customers.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(service_calls.date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql";
		$data['service_calls'] = $this->db->query($sql)->result_array();
		
		$this->load->view("ajax/preview_day",$data);
	}
	
	function reserve_job($year='',$month='')
	{       $this->canceljob();
		if(!$this->session->userdata('access')) { redirect("admin/error?e=permissions");}
                if($year=='')
		{
			$year = date("Y");
			$month = date("n");
			
		}
		
		$month = ltrim($month,"0");
		$data['year'] = $year;
		$data['month'] = $month;
		
		$data['customer_id'] = '';
		if($this->input->get("customer_id"))
		{
			$data['customer_id'] = $this->input->get("customer_id");
			$data['customer'] = $this->db->query("SELECT * FROM customers WHERE id=".$this->db->escape($data['customer_id']))->row_array();
		}
		
		//$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		// Grab customer types
		$data['customer_types'][''] = '- Select an Customer Type -';
		$this->db->order_by('type','asc');
		$inverter_types = $this->db->get("customer_types")->result_array();
		foreach($inverter_types as $row)
		{
			$data['customer_types'][$row['id']] = $row['type'];
		}
		
		// Grab job types
		$data['job_types'][''] = '- Select an Job Type -';
		$this->db->where('id !=',6);
                $this->db->order_by('type','asc');
                
		$inverter_types = $this->db->get("job_types")->result_array();
		foreach($inverter_types as $row)
		{
			$data['job_types'][$row['id']] = $row['type'];
		}
		
		if ($this->session->userdata('role') == 'admin')
		{
			$data['salesmen'][''] = '- Select a Salesperson -';
			// Grab salesmen for dropdown
			$this->db->where('type','sales');
			$this->db->or_where('type','admin');
			$sm = $this->db->get("users")->result_array();
			foreach($sm as $v)
			{
				$data['salesmen'][$v['id']] = $v['first_name'].' '.$v['last_name'];
			}
		}
		$data["sesuid"] = $this->session->userdata("user_id");
		$this->load->view("ajax/reserve_job",$data);
	}
	
	function init_job()
	{
		//header('Content-Type: application/json; charset=utf-8');
		
		$this->load->library('validation');
		$new_customer = false;
		
		// set validation rules
		$rules['job_type'] = "required";
		$rules['first_name'] = "required";
		$rules['last_name']	= "required";
		
		// set field "real" names
		$fields['first_name'] = "First Name";
		$fields['last_name'] = "Last Name";
		$fields['job_type'] = "Job Type";
		$fields['customer_type'] = "Customer Type";
                $fields['neighborhood'] = "Neighborhood";

		if($this->input->post("customer_id") == '')
		{
			$new_customer = true;
			$rules['customer_type'] = "required";
		}
		
		$this->validation->set_rules($rules);
		$this->validation->set_fields($fields);

		if($this->validation->run() == FALSE)
		{
			$json['success'] = false;
			$json['msg'] = $this->validation->error_string;
			echo json_encode($json);
		}
		else
		{
			if($new_customer)
			{
				// need to add new customer to db
				$row = array();
				$row['first_name'] = $this->input->post("first_name");
				$row['last_name'] = $this->input->post("last_name");
				$row['customer_type_id'] = $this->input->post("customer_type");
                                $row['neighborhood'] = $this->input->post("neighborhood");
				$row['created'] = date("Y-m-d h:i:s");
				$this->db->insert("customers",$row);
				$customer_id = $this->db->insert_id(); // get id of customer that was added
			}
			else
			{
				$customer_id = $this->input->post("customer_id");
			}
			
			if($this->input->post("job_type") == 5)
			{
				$job['customer_id'] = $customer_id;
				if ($this->input->post("user_id")) {
					$job['user_id'] = $this->input->post("user_id");
				} else {
					$job['user_id'] = $this->session->userdata("user_id");
				}
				$job['date'] = $this->input->post("job_date")." ".date("h:i:s");
				$job['created'] = date("Y-m-d h:i:s");
				$this->db->insert("service_calls",$job);
				$job_id = $this->db->insert_id();
				$json['job_url'] = 'service_call';
			}
			else
			{
				$job['customer_id'] = $customer_id;
				if ($this->input->post("user_id")) {
					$job['user_id'] = $this->input->post("user_id");
				} else {
					$job['user_id'] = $this->session->userdata("user_id");
				}
				$job['job_type_id'] = $this->input->post("job_type");
				$job['job_date'] = $this->input->post("job_date")." ".date("h:i:s");
				$job['created'] = date("Y-m-d h:i:s");
				$this->db->insert("jobs",$job);
				$job_id = $this->db->insert_id();
				$json['job_url'] = 'job';
			}
			
			$json['success'] = true;
			$json['job_id'] = $job_id;
			$json['msg'] = 'Job added successfully';
			echo json_encode($json);
		}
	}
	
	function view_job_notes($job_id='')
	{
		$this->load->helper("text");
		
		// get job/customer info
		$sql = "SELECT 
				jobs.*, 
				job_types.type as job_type, 
				customers.first_name, 
				customers.last_name 
			FROM 
				jobs 
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id 
			LEFT JOIN customers ON jobs.customer_id=customers.id 
			WHERE jobs.id=".$this->db->escape($job_id);
		$data['job'] = $this->db->query($sql)->row_array();
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($job_id);
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		$this->load->view("ajax/view_job_notes", $data);
	}
	
	function view_sc_notes($sc_id='')
	{
		$this->load->helper("text");
		
		// get job/customer info
		$sql = "SELECT 
				service_calls.*,  
				customers.first_name, 
				customers.last_name 
			FROM 
				service_calls 
			LEFT JOIN customers ON service_calls.customer_id=customers.id 
			WHERE service_calls.id=".$this->db->escape($sc_id);
		$data['job'] = $this->db->query($sql)->row_array();
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id=".$this->db->escape($sc_id);
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		$this->load->view("ajax/view_sc_notes", $data);
	}
	
	function add_job_note($job_id='')
	{
		$data['job_id'] = $job_id;
		
		$this->load->view("ajax/add_job_note",$data);
	}
	
	function add_sc_note($sc_id='')
	{
		$data['service_call_id'] = $sc_id;
		
		$this->load->view("ajax/add_sc_note",$data);
	}
	
	function edit_job_note($note_id='')
	{
		$data['note_id'] = $note_id;
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.id=".$this->db->escape($note_id);
		$data['job_note'] = $this->db->query($sql)->row_array();
		$data['job_id'] = $data['job_note']['job_id'];
		
		$this->load->view("ajax/edit_job_note",$data);
	}
	
	function edit_sc_note($note_id='')
	{
		$data['note_id'] = $note_id;
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.id=".$this->db->escape($note_id);
		$data['job_note'] = $this->db->query($sql)->row_array();
		$data['service_call_id'] = $data['job_note']['service_call_id'];
		
		$this->load->view("ajax/edit_sc_note",$data);
	}
	
	function delete_job_note($note_id='')
	{
		// get job id based on note id
		$this->db->where("id",$note_id);
		$note = $this->db->get("notes")->row_array();
		
		$this->db->where('id',$note_id);
		$this->db->delete("notes");
		
		redirect("admin/job_comment/".$note['job_id']);
	}
	
	function delete_sc_note($note_id='')
	{
		// get job id based on note id
		$this->db->where("id",$note_id);
		$note = $this->db->get("notes")->row_array();
		
		$this->db->where('id',$note_id);
		$this->db->delete("notes");
		
		redirect("admin/service_call/".$note['service_call_id']);
	}
	
	function do_update_note()
	{
		$row['note'] = $this->input->post("note");
		$this->db->where("id",$this->input->post("note_id"));
		$this->db->update("notes",$row);
		
		$json['success'] = true;
		$json['msg'] = 'Note has been updated!';
		echo json_encode($json);
	}
	
	function doaddnote()
	{
		//header('Content-Type: application/json; charset=utf-8');
		
		$json = array();
		
		if($this->input->post("note"))
		{
			$row = array();
			$row['job_id'] = $this->input->post("job_id");
			$row['service_call_id'] = $this->input->post("service_call_id");
			$row['note'] = $this->input->post("note");
			$row['user_id'] = $this->session->userdata("user_id");
			$row['created'] = date("Y-m-d h:i:s");
			$this->db->insert("notes",$row);
                        
                        $sql = "SELECT
				users.email,customers.first_name,customers.last_name,jobs.contractor_id,jobs.installer_id,jobs.conduit_id FROM		jobs
			LEFT JOIN users ON jobs.user_id=users.id
                        LEFT JOIN customers ON jobs.customer_id=customers.id
                        LEFT JOIN  notification_setting ns ON ns.user_id = users.id
			WHERE ns.notification!=0 AND jobs.id=".$row['job_id'];
		        $data = array();
                        
                        $data = $this->db->query($sql)->result_array();
                       if(count($data)>=1){
                            $name = ucfirst($data[0]['first_name'])." ".ucfirst($data[0]['last_name']);
                            @$this->sendcommentmail($data[0]['email'],$row['note'],$row['job_id'],$name);
                        
                            $in_user = '';
                            if($data[0]['contractor_id']){
                                $in_user .= $data[0]['contractor_id'].",";  
                            }
                            if($data[0]['installer_id']){
                                $in_user .= $data[0]['installer_id'].",";  
                            }
                            if($data[0]['conduit_id']){
                                $in_user .= $data[0]['conduit_id'].",";  
                            }
                            $in_user = substr($in_user,0,-1);
                            $assoc_users =  array();
                            if ($in_user!=''){
                             $assoc_users = $this->db->query("SELECT users.email from users WHERE id in ($in_user)")->result_array();
                            // print_R($assoc_users);
                            foreach ($assoc_users as $value){
                                @$this->sendcommentmail($value['email'],$row['note'],$row['job_id'],$name);
                            }
                            }
                        }
                        $row_users =  array();
                        $row_users = $this->db->query("SELECT users.email from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type='admin'")->result_array();
                        foreach ($row_users as $value){
                          @$this->sendcommentmail($value['email'],$row['note'],$row['job_id'],$name);
                        }
                       
                        $json['success'] = true;
			$json['msg'] = 'Note added';
			echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = 'Problem adding note';
			echo json_encode($json);
		}
	}
	
	function add_file_iframe($job_id='')
	{
		$data['job_id'] = $job_id;
		$this->load->view("ajax/add_file_iframe",$data);
	}
        function add_plan_iframe($job_id='',$filet="")
	{
		$data['job_id'] = $job_id;
                $data['file_type'] = $filet;
		$this->load->view("ajax/add_plan_iframe",$data);
	}
        function add_sketch_iframe($job_id='',$filet="")
	{
		$data['job_id'] = $job_id;
                $data['file_type'] = $filet;
		$this->load->view("ajax/add_sketch_iframe",$data);
	}
       function add_presale_iframe($job_id='',$filet="")
	{
		$data['job_id'] = $job_id;
                $data['file_type'] = $filet;
		$this->load->view("ajax/add_presale_iframe",$data);
	}
        
	function add_premit_iframe($job_id='',$filet="")
	{
		$data['job_id'] = $job_id;
                $data['file_type'] = $filet;
		$this->load->view("ajax/add_permit_iframe",$data);
	}
        function add_elecphoto_iframe($job_id='',$photo_id="")
	{
		$data['job_id'] = $job_id;
                $data['photo_id'] = $photo_id;
		$this->load->view("ajax/add_elecphoto_iframe",$data);
	}
        function add_userprofilephoto_iframe($user_id='')
	{
            $data['user_id'] = $user_id;
            $this->load->view("ajax/add_userprofilephoto_iframe",$data);
	}
	function add_file($job_id='',$service_call='no')
	{
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}
		
		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
			$config['allowed_types'] = 'pdf|doc|docx|xls|xlsx|tiff|gif|jpg|png|jpeg';

			$this->load->library('upload');
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();

				$row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d h:i:s");
				$this->db->insert("files",$row);
				
				$this->load->view("ajax/file_uploaded",$data);
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_file",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_file",$data);
		}
	}

        function add_planfile($job_id='',$file_type="no", $service_call='no')
	{
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
                        if($file_type=="no"){

                            $config['allowed_types'] = 'pdf';
                        } else{
                          $config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/scheduler/uploads";
                          $config['allowed_types'] = 'gif|jpg|png|jpeg';
                        }

			$this->load->library('upload',$config);
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();
                                
				$row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
                                $pid = $this->getparentjobid($job_id);
                                $row['job_id'] =  $pid;
				$row['created'] = date("Y-m-d h:i:s");
                                $row['job_type'] = 2;
                                if($file_type=="no"){
                                    $this->db->insert("genral_files",$row);
                                } else {
                                    $this->db->insert("meter_files",$row);
                                }
				//$this->db->insert("genral_files",$row);
                                $data['jobid'] = $job_id ;
                                $data['file_type'] = $file_type;
                                $subject = "AEI Notification:-Plot Plan Uploaded";
                                $content = " {name} has uploaded this file.";
                                $this->sendjobfilenotification($job_id,$content,$subject,0,1);

                                $this->load->view("common/header");
				$this->load->view("ajax/plan_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_file",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_file",$data);
		}
	}
        function add_sketchfile($job_id='',$file_type="no", $service_call='no')
	{
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
                        if($file_type=="no"){

                            $config['allowed_types'] = 'pdf';
                        } else{
                          $config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/scheduler/uploads";
                          $config['allowed_types'] = 'gif|jpg|png|jpeg';
                        }

			$this->load->library('upload',$config);
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();
                                
				$row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d h:i:s");
                                $row['job_type'] = 2;
                                $pid = $this->getparentjobid($job_id);
                                $row['job_id'] =  $pid;
                                $this->db->insert("sketch_files",$row);
                                $data['jobid'] = $job_id ;
                                $data['file_type'] = $file_type;
                                if($this->session->userdata("role") != 'admin'){
                                    $subject = "{name}: Sketch Uploaded - Ready to Measure";
                                    $content = " {name} has uploaded the file.";
                                    $this->sendjobfilenotification($job_id,$content,$subject,0,1);
                                }
                                $this->load->view("common/header");
				$this->load->view("ajax/sketch_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_sketchfile",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_sketchfile",$data);
		}
	}
        function add_presalefile($job_id='',$file_type="no", $service_call='no'){
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
                        if($file_type=="no"){

                            $config['allowed_types'] = 'pdf';
                        } else{
                          $config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/scheduler/uploads";
                          $config['allowed_types'] = 'gif|jpg|png|jpeg';
                        }

			$this->load->library('upload',$config);
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();
                                
				$row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d h:i:s");
                                $row['job_type'] = 2;
                                $pid = $this->getparentjobid($job_id);
                                $row['job_id'] =  $pid;
                                $this->db->insert("presale_files",$row);
                                $data['jobid'] = $job_id ;
                                $data['file_type'] = $file_type;
                                if($this->session->userdata("role") == 'admin'  ){
                                    $subject = "Pre-Measured Sketch Upload - Please Confirm With Your Customer({cust_name})";
                                    $content = "{name} has uploaded this file.";
                                    $this->sendjobfilenotification($job_id,$content,$subject,1,1);
                                }
                                $this->load->view("common/header");
				$this->load->view("ajax/presale_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_presalefile",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_presalefile",$data);
		}
	}
         function add_permitfile($job_id='',$file_type="no", $service_call='no'){
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}
                $data['file_type'] = $file_type;

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
                        $config['allowed_types'] = 'pdf';
                        $this->load->library('upload',$config);
			$this->upload->initialize($config);
			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();
                                $row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d h:i:s");
                                $row['job_type'] = 2;
                                $pid = $this->getparentjobid($job_id);
                                $row['job_id'] =  $pid;
                                $row['type'] = $file_type;
                                $row['permit_no'] = @$this->input->post("permitno");
                                $this->db->insert("permit_files",$row);
                                $data['jobid'] = $job_id ;
                                $data['file_type'] = $file_type;
                                $this->load->view("common/header");
				$this->load->view("ajax/permit_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_permitfile",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_permitfile",$data);
		}
	}
        function add_elecphotofile($job_id='',$photo_id="1"){
		$data['job_id'] = $job_id;
	
                $data['photo_id'] = $photo_id;

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/scheduler/uploads";
			$config['encrypt_name'] = true;
                        $config['allowed_types'] = 'jpg|jpeg|png|gif';
                        $this->load->library('upload',$config);
			$this->upload->initialize($config);
			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();
                                $row = array();
				$row['job_id'] = $job_id;
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d h:i:s");
                                $row['job_type'] = 2;
                                $pid = $this->getparentjobid($job_id);
                                $row['job_id'] =  $pid;
                                $row['photo_id'] = @$photo_id;
                                $this->db->insert("elecphoto_files",$row);
                                $data['jobid'] = $job_id ;
                                $this->load->view("common/header");
				$this->load->view("ajax/elecphoto_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_elecphoto",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_elecphoto",$data);
		}
	}
         function add_userprofilephotofile($user_id){
		$data['user_id'] = $user_id;
		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/scheduler/uploads";
			$config['encrypt_name'] = true;
                        $config['allowed_types'] = 'jpg|jpeg|png|gif';
                        $this->load->library('upload',$config);
			$this->upload->initialize($config);
			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();
                                $row = array();
				//$row['unique_filename'] = $file_data['file_name'];
				$row['profile_photo'] = $file_data['file_name'];
				$this->db->where("id",$user_id);
                                $this->db->update("users",$row);
                                $this->load->helper("thumbnail_helper");
                                $src_path = $row['profile_photo'];
                                $data['profile_photo']='Profile Photo : <br/><img src="'.thumbnail($src_path, 50, 50).'" />';
                                $this->load->view("common/header");
				$this->load->view("ajax/userprofilephoto_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_userprofilephotofile",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_userprofilephotofile",$data);
		}
	}
	function service_calls($year='',$month='',$day='')
	{
		$this->load->helper('text');
		
		if($year=='') {$year = date("Y");}
		if($month=='') {$month = date("m");}
		if($day=='') {$day = date("d");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = sprintf("%02d",$day);
		
		$data['calendar_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		$extra_sql = '';
		if($this->session->userdata("role") != 'admin')
		{
			$extra_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata('user_id'));
		}
		
		// get jobs for the current month
		$data['service_calls'] = $this->db->query("SELECT service_calls.*,customers.first_name,customers.last_name,customers.address,customers.city,customers.state FROM service_calls LEFT JOIN customers ON service_calls.customer_id=customers.id WHERE DATE_FORMAT(date,'%Y-%m-%d') = '".$year."-".$month."-".$data['day']."' $extra_sql ORDER BY service_calls.date ASC")->result_array();
		
		$this->load->view("ajax/service_calls",$data);
	}
	
	function quick_summary($year='',$month='',$day='')	
	{
		if(@$year=='') {$year = date("Y");}
		if(@$month=='') {$month = date("m");}
		if(@$day=='') {$day = date("d");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = $day;
		$data['timeframe'] = array();
                $data['timeframe'][1]="9:00am-12:00am";
                $data['timeframe'][2]="1:00pm-4:00pm";
                $data['timeframe'][3]= "All Day";
		$data['day_timestamp'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		$data['editjob'] = true;
		$extra_sql = '';
		$pv_sql = '';
		if($this->session->userdata("role") != 'admin' )
		{
		 //$extra_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));
                // $pv_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));

		}
                if( $this->session->userdata("role") == 'installer')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",installer_id)";
                  $data['editjob'] = false;
		}
                  if( $this->session->userdata("role") == 'contractor')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",contractor_id)";
                  $data['editjob'] = false;
		}
                  if( $this->session->userdata("role") == 'designer')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",designer_id)";
                  $data['editjob'] = false;
		}
		// grab photovoltaic jobs
		$sql = "SELECT 
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex,
                        inverter_types.type as inverter_type_name,
                        module_brands.brand as module_brand_name
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
                        LEFT JOIN  inverter_types on  inverter_types.id= jobs.inverter_type_id
                        LEFT JOIN  module_brands on  module_brands.id= jobs.module_brand_id
			WHERE jobs.job_type_id='2' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."'  $pv_sql
			";
		$data['pv_jobs'] = $this->db->query($sql)->result_array();
		foreach($data['pv_jobs'] as $job){
                        $sql_split = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex,
                        inverter_types.type as inverter_type_name,
                        module_brands.brand as module_brand_name
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
                        LEFT JOIN  inverter_types on  inverter_types.id= jobs.inverter_type_id
                        LEFT JOIN  module_brands on  module_brands.id= jobs.module_brand_id
			WHERE jobs.id!=".$job['id']." AND  jobs.job_pid=".$job['job_pid']." AND jobs.job_type_id='2'   $pv_sql	";
		      $data['split_pv_jobs'][$job['job_pid']] = $this->db->query($sql_split)->result_array();
                       
                }
		// grab solar water heating jobs
		$sql = "SELECT 
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='1' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql ";
		#die(print($sql));
		$data['swh_jobs'] = $this->db->query($sql)->result_array();
                foreach ($data['swh_jobs'] as $swhjob){
                    $sql_swh = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.id!=".$swhjob["id"]." AND jobs.job_pid=".$swhjob["job_pid"]." AND jobs.job_type_id='1'  $pv_sql ";
		#die(print($sql));
		    $data['split_swh_jobs'][$swhjob["job_pid"]] = $this->db->query($sql_swh)->result_array();
                }
		
		// grab solar attic fan jobs
		$sql = "SELECT 
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='3' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['saf_jobs'] = $this->db->query($sql)->result_array();
		
		#die(print(count($data['jobs'])));
		
		$data['jobs'] = ($data['saf_jobs'] + $data['pv_jobs'] + $data['swh_jobs']);
		
		// get service calls for the day
		$sql = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='5' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql ";
		$data['service_calls'] = $this->db->query($sql)->result_array();
                
                // get service calls for the day
		$sql = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='6' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql ";
		$data['pl_jobs'] = $this->db->query($sql)->result_array();
		 global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		$this->load->view("ajax/quick_summary",$data);
	}
	
	function find_previous_customer()
	{
		header('Content-Type: application/json; charset=utf-8');
		
		$this->db->where('first_name',trim($this->input->post("re_first_name")));
		$this->db->where('last_name',trim($this->input->post("re_last_name")));
		$row = $this->db->get("customers")->row_array();
		
		if(count($row) > 0)
		{
			$json['success'] = true;
			$json['msg'] = 'Previous customer found matching '.$this->input->post("first_name")." ".$this->input->post("last_name");
			$json['address'] = $row['city'].", ".$row['state']." @ ".$row['address'];
			$json['customer_id'] = $row['id'];
                        if(isset($row['neighborhood']) && $row['neighborhood']!="other" ){
                            $json['neighborhood'] = $row['neighborhood'];
                        }elseif($row['neighborhood']!="other"){
                            $json['neighborhood'] = $row['other_neighborhood'];
                        } else {
                            $json['neighborhood'] = "";
                        }
                        echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = 'No customer found '.$this->input->post("first_name")." ".$this->input->post("last_name");
                        $json['neighborhood'] = "";
			echo json_encode($json);
		}
	}
	
	function update_day_count()
	{
		$year = $this->input->post("year");
		$month = $this->input->post("month");
		$day = $this->input->post("day");
		$sql = "UPDATE service_calls SET job_count=".$this->db->escape($this->input->post("job_count"))." WHERE DATE_FORMAT(`date`,'%Y-%m-%d') = '".$year."-".$month."-".$day."'";
		$this->db->query($sql);
		
		//$sql = "UPDATE jobs SET job_count=".$this->db->escape($this->input->post("job_count"))." WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".$day."'";
		//$this->db->query($sql);
		
		$json['success'] = true;
		$json['msg'] = 'Service call count updated';
		echo json_encode($json);
	}
	
	function update_job_count()
	{
		$year = $this->input->post("year");
		$month = $this->input->post("month");
		$day = $this->input->post("day");
		
		$sql = "UPDATE jobs SET job_count=".$this->db->escape($this->input->post("job_count"))." WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".$day."'";
		$this->db->query($sql);
		
		$json['success'] = true;
		$json['msg'] = 'Job count updated';
		echo json_encode($json);
	}
	
	function update_day_status($year='',$month='',$day='')
	{
		// get day's installation job count
		$jc = $this->db->query("SELECT job_count as total FROM jobs WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."'")->result_array();
		$jc_total = 0;
		foreach($jc as $jcs)
		{
			$jc_total += $jcs['total'];
		}
		
		// get day's service call total count
		$sc = $this->db->query("SELECT job_count as total FROM service_calls WHERE DATE_FORMAT(`date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."'")->row_array();		
		
		$data['day_job_total'] = ($jc_total + @$sc['total']);
		
		// daily job limit
		$data['daily_limit'] = $this->db->get("job_limit")->row_array();
		
		$this->load->view("ajax/day_status",$data);
	}
	
	function update_job_status()
	{
           $job_id = $this->input->post("job_id");
           $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$job_id;
             $data['job'] = $this->db->query($sql)->row_array();
             $j = $this->getUserLoad($data['job']['user_id']);
             if($this->input->post("status") && $this->input->post("job_id"))
		{
			$pid = $this->getparentjobid($this->input->post("job_id"));
                        $row['current_status'] = $this->input->post("status");

			if($row['current_status']=='unscheduled'){
                           $row['job_date'] = null;
                           $installer = $this->db->query("SELECT sum(no_installer_allocated)as suminstaller FROM jobs where    job_pid= '".$pid."'")->result_array();
                           $this->db->query("DELETE FROM jobs where  id != job_pid and  job_pid= '".$pid."'");
                           $this->db->query("UPDATE jobs set job_lastscheduledate=job_date  where  job_pid= '".$pid."'");
                           $row['no_installer_allocated'] = $installer[0]['suminstaller'];
                        } else{
                            $row['status_updated'] = 'admin';
                        }
                        
                        $this->db->where("job_pid",$pid);
			$this->db->update("jobs",$row);
			$row_users =  array();
                        $row_users = $this->db->query("SELECT users.email,users.first_name,users.last_name from users
                            LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type='admin'")->result_array();
                        foreach ($row_users as $value){
                            
                           $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $row['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$value['email']);
                        }
                        $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $row['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$j[0]->email,$j[0]->id);
                        if(isset($data['job']['contractor_id'])){
                           $cont = explode(",",$data['job']['contractor_id']);
                           foreach($cont as $user_id){
                            if(!isset($user_id)) continue;
                               $k = $this->getUserLoad($user_id);
                               $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $row['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$k[0]->email,$user_id);
                            }
                        }
                        if(isset($data['job']['designer_id'])){
                            $cont = explode(",",$data['job']['designer_id']);
                            foreach($cont as $user_id){
                                if(!isset($user_id)) continue;
                               $k = $this->getUserLoad($user_id);
                               $this->statusnotifaction(ucfirst($data['job']['first_name']).ucfirst($data['job']['last_name']),$data['job']['current_status'] , $row['current_status'],ucfirst($j[0]->first_name).ucfirst($j[0]->last_name),$k[0]->email,$user_id);
                        }
                       }
                        if(isset($data['job']['installer_id'])){
                            $cont = explode(",",$data['job']['installer_id']);
                            foreach($cont as $user_id){
                            if(!isset($user_id)) continue;
                            $k = $this->getUserLoad($user_id);
                            $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $row['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$k[0]->email,$user_id);
                          }
                       }
                        $json['success'] = true;
			$json['msg'] = "Job status updated!";
			echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = "Problem updating job status!";

			
			echo json_encode($json);
		}

	}
	
	function update_daily_limit()
	{	
		$sql = "UPDATE job_limit SET `limit`=".$this->db->escape($this->input->post("limit"));
		$this->db->query($sql);
		
		$json['success'] = true;
		$json['msg'] = 'Daily Limit';
		echo json_encode($json);
	}
    function  installer($year='',$month='',$job_id=0){
        $data = array();
        $data['job'] =array();
        $data["sct"] ="";
        if($job_id) {
		// get job data
		$sql = "SELECT
			jobs.*,
                         sum(jobs.no_installer_allocated) as sum_installer_allocated,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.job_pid=".$this->db->escape($job_id)." GROUP BY jobs.job_pid
		";
            $data['job'] = $this->db->query($sql)->row_array();
            $data["sct"] ="var customer_id = '';var userid =''; var reserverjob;";
          }
        
        $data['customer_id'] = '';
       	$month = ltrim($month,"0");
	$data['year'] = $year;
	$data['month'] = $month;
	//$data['day'] = $day;
	//$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
	if($this->input->get("customer_id")){
            $data['customer_id'] = $this->input->get("customer_id");
            $data['customer'] = $this->db->query("SELECT * FROM customers WHERE id=".$this->db->escape($data['customer_id']))->row_array();
	}
	/**
         *  To do to remove the hard coded 
         */
        $data["numberofsystem"] = array(""=>"Select Number of Systems", "1"=>"1","2"=>"2","3"=>"3","4"=>"4","5"=>"5","6"=>"6");
        
        $module_array = array(""=>"Select Number of Modules");
        for ($i = 1 ; $i<=100;$i++){
            $module_array[$i] = $i;
        }
        $data["nomodule"] = $module_array;
        $data["nosubarray"] = array(""=>"Select Number of Sub-Arrays","1"=>"1","2"=>"2","3"=>"3","4"=>"4","5"=>"5","6"=>"6","7"=>"7","8"=>"8");
        $sql = "SELECT id,type FROM roof_types ";
        $roof_typea = array();
        $roof_typea["0"]= "-Select roof type-";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0){
             foreach ($query->result() as $row){
                $roof_typea[$row->id] =  $row->type;
            }
        }
        $data["roof_type"]= $roof_typea;

        $data["wirerundistance"] = array("0"=>"Select Wire Run Distance");
        $this->db->order_by('id','asc');
        $moniter_display = $this->db->get("wire_run_distance")->result_array();
        foreach($moniter_display as $row) {
          $data["wirerundistance"][$row['id']] = $row['type'];
        }
        //$data["wirerundistance"] = array(""=>"Select Wire Run Distance","1"=>"1-20","2"=>"21-40","3"=>"41-80","4"=>"81-120","5"=>"Electrical Contractor");
        $sql = "SELECT id,type FROM wire_run_types ";
        $wire_typea = array();
        $wire_typea[" "]="Select A Wire Run Type";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0){
             foreach ($query->result() as $row){
                $wire_typea[$row->id] =  $row->type;
            }
        }
        
        $data["wire_type"] = $wire_typea;
        $data["nod"] = array("1"=>"1", "2"=> "2", "3"=>"3");
      
        $this->load->view("ajax/installer.php",$data);
    }

    function validate_savejob() {
            $this->load->library('validation');
            $new_customer = false;
            // set validation rules
            $rules['job_type'] = "required";
            $rules['re_first_name'] = "required|alpha_numeric";
            $rules['re_last_name']	= "required|alpha_numeric";
	// set field "real" names
            $fields['re_first_name'] = "First Name";
            $fields['re_last_name'] = "Last Name";
            $fields['job_type'] = "Job Type";
            $fields['customer_type'] = "Customer Type";
            if($this->input->post("customer_id") == ''){
                $new_customer = true;
		$rules['customer_type'] = "required";
            }
            if($this->input->post("spouse_firstname") != ''){
                $rules['spouse_firstname'] = "alpha_numeric";
                $fields['spouse_firstname']="Another First Name";
            }
            if($this->input->post("spouse_lastname") != ''){
               $rules['spouse_lastname']= "alpha_numeric";
               $fields['spouse_lastname']="Another Last Name";
            }
                $this->validation->set_message('alpha_numeric', 'There is an illegal character being used, please check that there are no spaces or non-alpha-numeric characters.');
		$this->validation->set_rules($rules);
		$this->validation->set_fields($fields);
		if($this->validation->run() == FALSE)
		{
			$json['success'] = false;
			$json['msg'] = $this->validation->error_string;
			echo json_encode($json);
                        return ;
		}
                $json['success'] = true;
                echo json_encode($json);
    }
    function day_installerassign($year='',$month='',$day='' , $noinstaller = 4 , $noofday = 1){
        global $pv_job_count,$swh_job_count;
        $data = array();
        $data['customer_id'] = '';
        if($year==''){
            $year = date("Y");
            $month = date("n");
            $day = date("j");
	}
	$month = ltrim($month,"0");
	$day = ltrim($day,"0");
        
	$data['year'] = $year;
	$data['month'] = $month;
	$data['day'] = $day;
        $sql_jobcount = "SELECT count(*)as totaljobs FROM jobs WHERE jobs.job_type_id=".$this->session->userdata('job_type')." and job_date='$year-$month-$day'";
        $nojob = $this->db->query($sql_jobcount)->row_array();
        
        $data['available_installer'] = $noinstaller;
        $data['total_installer']= $this->session->userdata("in_noi");
        $data['no_day'] = $this->session->userdata("in_nod");
	$data['current_day'] = $noofday;
        $data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
        /**
         *  To do to remove the hard coded
         */
         $selectinstaller = array();
         $selectinstaller[0] = "Select Number of Installers";
         if ($data['no_day'] == 1){
             $selectinstaller[$data['total_installer']] = $data['total_installer'];
         }else {
         for($i = 1; $i<=$data['total_installer']; $i++ ){
            $selectinstaller[$i] = $i;
            if ($i >=8) break;
         }
         }
         $data["numberofinstaller"] = $selectinstaller;
         if($this->session->userdata('job_type')==1 && $nojob['totaljobs']>=$swh_job_count){
            $this->load->view("ajax/installer_bookederror.php",$data);
            return;
        }
        if($this->session->userdata('job_type')==2 && $nojob['totaljobs']>=$pv_job_count){
            $this->load->view("ajax/installer_bookederror.php",$data);
            return;
        }
         if(!$noofday){
           $this->load->view("ajax/installer_assignederror.php",$data);
        }else{
           
            $this->load->view("ajax/installer_assign.php",$data);
        }
    }
    function block_day($date,$message=""){
     if (!$date  ){
        return 0;
     }
     else{
         //$date = "$year-$month-$day";
     $sql = "INSERT INTO admin_block_date(block_date,message) values('$date','$message')";
     $this->db->query($sql);
       echo 1;
     }
    }
     function block_day_form($year='',$month='',$day=''){
          $date = "$year-$month-$day";
          $data['year'] = $year;
	$data['month'] = $month;
	$data['day'] = $day;
	$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
          $data['date'] = $date;

        /**
         *  To do to remove the hard coded
         */

        $this->load->view("ajax/adminblockday",$data);
     
    }
    function save_session(){
        
        $this->session->set_userdata($_POST);
        $json['success'] = true;
        echo json_encode($json);
      
    }
    function save_session_un($job_id){
      $pid = $this->getparentjobid($job_id);
      $sql = "SELECT
			jobs.*,
                        sum(no_installer_allocated) as sum_installer_allocated,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
                        customers.customer_type_id,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.job_type_id!=6 AND  jobs.job_pid=".$this->db->escape($pid)." GROUP BY jobs.job_pid
		";
		$data['job'] = $this->db->query($sql)->row_array();
               
           
                $arr = array();

        
        $arr[0]['job_id'] = $data['job']['id'];
        $arr[0]['in_nos'] = $data['job']['job_nos'];
        $arr[0]['in_nom'] = $data['job']['job_nom'];
        $arr[0]['in_nosa'] = $data['job']['job_nosa'];
        $arr[0]['in_rooftype'] = $data['job']['roof_type_id'];
        $arr[0]['in_wirerundist'] = $data['job']['wire_run_distance'];
        $arr[0]['in_wireruntype'] = $data['job']['wire_run_type_id'];
        $arr[0]['in_noi'] = $data['job']['sum_installer_allocated'];

        if($data['job']['in_nod']){
            $arr[0]['in_nod'] = $data['job']['in_nod'];
        }else if ($arr[0]['in_noi']<16){
            $arr[0]['in_nod'] = 1;
        }else if ($arr[0]['in_noi']>16 && $arr[0]['in_noi']<=32){
            $arr[0]['in_nod'] = 2;
        }else if ($arr[0]['in_noi']>32){
            $arr[0]['in_nod'] = 3;
        }else{
            $arr[0]['in_nod'] = 1;
        }
        //$arr[0]['in_nod'] = 1;
        $arr[0]['customer_id'] = $data['job']['customer_id'];
       // $arr[0]['year'] = $data['job'][0]['id'];
        //$arr[0]['month'] = $data['job'][0]['id'];
        $arr[0]['customer_type'] = $data['job']['customer_type_id'];
        $arr[0]['job_type'] = $data['job']['job_type_id'];
        $arr[0]['re_first_name'] = $data['job']['first_name'];
        $arr[0]['re_last_name'] = $data['job']['last_name'];
        $arr[0]['found_client'] = 'y';
        $arr[0]['re_user_id'] = $data['job']['user_id'];
        $arr[0]['nop'] = $data['job']['panel_count'];
        $arr[0]['job_pid'] = $data['job']['job_pid'];
        $arr[0]['piperundist'] = $data['job']['piperun_length'];
        $arr[0]['job_type_pl'] = 0;

        $arr =$arr[0];
        $this->session->set_userdata($arr);
        $json['success'] = true;
        echo json_encode($json);

    }
    function save_sessioninstaller(){
        $date=$this->input->get("re_date");
        $numberofinstaller=$this->input->get("in_nos");
        $user_id=0;
         if (!$user_id) {
            $user_id = $this->session->userdata("re_user_id");
            if(!$user_id){
                $setagain["re_user_id"] = $this->session->userdata("user_id");
                $this->session->set_userdata($setagain);
                $user_id = $this->session->userdata("user_id");
            }
        }
        if (!$date &&  !$numberofinstaller &&!$user_id){
            $json['success'] = false;
            echo json_encode($json);
            return ;
        }
          $pl_session_installer = $this->db->query("SELECT *  FROM  pl_session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")." ORDER BY id")->row_array();
          if(@$pl_session_installer['date_booked']){
              if($pl_session_installer['date_booked']>$date){
                   $json['success'] = false;
                   $json['msg'] = 'Cannot assign final installation date before your prelag date.';
                   echo json_encode($json);
                   return;
              }
          }
          $session_id = $this->session->userdata("re_session_id");
          $noi_session = $this->session->userdata('in_noi');
          $nod_session =  $this->session->userdata('in_nod');
          $setagain["in_noi"] = $noi_session - $numberofinstaller ;
          $setagain["in_nod"] = $nod_session - 1;
          $this->session->set_userdata($setagain);
          $sql = "INSERT INTO session_installer(sessionid,date_booked,user_id,number_of_installer) VALUES('$session_id', '$date',$user_id,$numberofinstaller )";
          $this->db->query($sql);
          $json['success'] = true;
          echo json_encode($json);
     
    }
    function canceljob($return_type=0){
      $session_id = $this->session->userdata("re_session_id");
      $sql = "DELETE FROM  session_installer WHERE sessionid='$session_id'";
      $this->db->query($sql);
      $sql_pl = "DELETE FROM  pl_session_installer WHERE sessionid='$session_id'";
      $this->db->query($sql_pl);
      $this->session->unset_userdata('re_user_id');
      $this->session->unset_userdata('re_first_name');
      $this->session->unset_userdata('re_last_name');
      $this->session->unset_userdata('job_type');
      $this->session->unset_userdata('in_noi');
      $this->session->unset_userdata('in_nod');
      $this->session->unset_userdata('assigned_pl_installer');
      $this->session->unset_userdata('job_type_pl');
      $this->session->unset_userdata('proposal_id');

      if($return_type) {
        $json['success'] = true;
        echo json_encode($json);
      }
   }
    function savejob() {
      
      $year = "";
      $month = "";
      $pid = 0;
      $job_id = 0;
      $job_update  = false;
      $da[0]->job_lastscheduledate=null;
      if(@$this->session->userdata('job_type_pl')==6){
          $pid= $this->getparentjobid(@$this->session->userdata('job_id'));
          $this->savePLjobs(null,$pid , true);
          return;
      }
      if(@$this->session->userdata('job_id')&& @$this->session->userdata('job_pid')){
         $pid  = @$this->session->userdata('job_pid');
         $job_id = $this->session->userdata('job_id');
         $sql = "DELETE FROM jobs  where job_type_id!=6 AND id!=job_pid AND job_pid=".$pid;
         $this->db->query($sql);
         $sql = "SELECT job_lastscheduledate FROM jobs where job_pid=".$pid;
         $da = $this->db->query($sql)->result();
         $job_update  = true;
      }
      if(!$this->session->userdata('customer_id') ) {
        // need to add new customer to db
        $row = array();
	$row['first_name'] =  $this->session->userdata('re_first_name');
	$row['last_name'] = $this->session->userdata('re_last_name');
        $row['first_name1'] =  $this->session->userdata('spouse_firstname');
	$row['last_name1'] = $this->session->userdata('spouse_lastname');
        $row['customer_type_id'] = $this->session->userdata('customer_type');
	$row['created'] = date("Y-m-d h:i:s");
	$this->db->insert("customers",$row);
	$customer_id = $this->db->insert_id(); // get id of customer that was added
	}
	else
        {
	$customer_id = $this->session->userdata("customer_id");
	}
       
       $dateinstall = array();
       $session_installer = array();
       $session_installer = $this->db->query("SELECT *  FROM  session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")." ORDER BY id")->result_array();
       $job['in_nod']= count($session_installer);
       foreach($session_installer as $key => $value)
          {
          $date_mail[]= strtotime($value['date_booked']);
           if (!$job_update && $this->session->userdata('job_id')){
            $sql = "SELECT jobs.* FROM 	jobs WHERE jobs.id=".$this->db->escape($job_id);
            $job = $this->db->query($sql)->row_array();
            unset($job['id']);
            unset($job['current_status']);

           }
           $job['current_status'] = "";
           $job['customer_id'] = $customer_id;
           $job['user_id'] = $this->session->userdata('re_user_id');
           $job['job_type_id'] = $this->session->userdata('job_type');
          
             if($this->session->userdata('job_type')==2){
                $session_installer_data[date("j", strtotime($value['date_booked']))][] = $value;
                $job['modified_by'] =  $this->session->userdata("user_id");
                $job['job_date'] =$value['date_booked']." ".date("h:i:s");
                $dateinstall[] =date("l,F j, Y",strtotime($value['date_booked'])) ;
                $job['created'] = date("Y-m-d h:i:s");
                $job['no_installer_allocated'] = $value['number_of_installer'];
                
                $job['job_nos'] =  $this->session->userdata('in_nos');
                $job['job_nosa'] =  $this->session->userdata('in_nosa');
                $job['job_nom'] =  $this->session->userdata('in_nom');
                $job['roof_type_id'] =  $this->session->userdata('in_rooftype');
                $job['wire_run_distance'] =  $this->session->userdata('in_wirerundist');
                $job['wire_run_type_id'] =  $this->session->userdata('in_wireruntype');
                if( $this->session->userdata('proposal_id')){
                   $job['proposal_id']=$this->session->userdata('proposal_id');
                   $sql_prop = "SELECT * FROM  proposal WHERE id=".$this->session->userdata('proposal_id');
                   $result =$this->db->query($sql_prop)->row_array();
                   $customer_update = array();
                   $customer_update['city'] = $result['city'];
                   $customer_update['state'] =$result['state'];
                   $customer_update['address'] =$result['address'];
                   $customer_update['home_phone'] ="home";
                   $customer_update['home_phone1'] ="cell";
                   $customer_update['secondary_phone'] = $result['phone'];
                   $customer_update['secondary_phone1'] =$result['sphone'];
                   $customer_update['zip_code'] =$result['zip'];
                   $this->db->where("id",$customer_id);
                    $this->db->update("customers",$customer_update);
                   $job['list_price'] =$result['price'];
                   $sum_tax = 0;
                   $nos = $result['nos'];
                   $new_price = $result['price']/$nos;
                   for($k=0;$k<$nos;$k++){
                    $state_exicse_tax = .35*$new_price;
                    if($state_exicse_tax >5000){
                     $state_exicse_tax = 5000;
                    }
                    $federal_tax_credit=.3*$new_price;
                    $sum_tax += $federal_tax_credit+$state_exicse_tax;
                    if($k==0){
                      $job['state_tax_credit'] = number_format($state_exicse_tax,2);
                      $job['federal_tax_credit'] = number_format($federal_tax_credit,2);
                    } else {
                     $job['state_tax_credit_'.$k] = number_format($state_exicse_tax,2);
                     $job['federal_tax_credit_'.$k] = number_format($federal_tax_credit,2);
                    }


                   }
                   $job['total_tax_credits'] = number_format($sum_tax,2);
                   $job['net_total_price'] = number_format(($result['price']-$sum_tax),2);
                   $job['sub_total_price'] = number_format(($result['price'] + $result['price']*0.04712),2);
                   $job['system_size'] = $result['system_size'];
                   if($result['module_type']==1){
                    $job['module_brand_id']=32;

                   }elseif($result['module_type']==2){
                    $job['module_brand_id']=31;
                   }
                   switch($result['invertert']){
                     case 3:
                        $job['inverter_type_id']=31;
                         break;
                     case 4:
                        $job['inverter_type_id']=25;
                         break;
                     case 5:
                        $job['inverter_type_id']=37;
                         break;
                     case 6:
                        $job['inverter_type_id']=34;
                         break;
                     case 7:
                        $job['inverter_type_id']=36;
                         break;
                     case 43:
                         $job['inverter_type_id']=26;
                             break;
                   }
               $job["inverter_count"] = $result['not'];
             
               switch($result["roof_type"]){
              case 8:
                  $job['roof_type_id'] =10;
                  break;
              case 9:
                  $job['roof_type_id'] =8;
                  break;
              case 10:
                  $job['roof_type_id'] =11;
                  break;
             case 11:
                  $job['roof_type_id'] =12;
                  break;
              case 37:
                  $job['roof_type_id'] =5;
                  break;
              case 38:
                  $job['roof_type_id'] =13;
                  break;
               case 39:
                  $job['roof_type_id'] =14;
                  break;
             case 40:
                  $job['roof_type_id'] =15;
                  break;
              case 41:
                  $job['roof_type_id'] =9;
                  break;
              case 42:
                  $job['roof_type_id'] =2;
                  break;
            }
          if ($result["is_tilt_kit"]==1){
              $result["tilt_kit_needed"]='y';

          }else if ($result["is_tilt_kit"]==2) {
              $result["tilt_kit_needed"]='n';
          }
         
          $this->db->query("UPDATE proposal set is_delete=0 WHERE id=".$this->session->userdata('proposal_id'));
         }
                $job['job_pid'] = $pid;
                if(!$job_update){
                    $this->db->insert("jobs",$job);
                    $job_id = $this->db->insert_id();
                    
                    if(!$pid){
                        $pid = $job_id;
                        $jobpid['job_pid'] = $pid;
                        $this->db->where("id",$job_id);
                        $this->db->update("jobs",$jobpid);
                    }
                } else{
                     $this->db->where("id",$job_id);
                     $this->db->update("jobs",$job);
                     $job_update =false;
                }

                $year = date("Y" ,strtotime($value['date_booked']));
                $month = date("m" ,strtotime($value['date_booked']));
             }
             if($this->session->userdata('job_type')==1){
                $session_installer_data[date("j", strtotime($value['date_booked']))][] = $value;
                
                $job['modified_by'] =  $this->session->userdata("user_id");
                $job['job_date'] =$value['date_booked']." ".date("h:i:s");
                $job['created'] = date("Y-m-d h:i:s");
                  $dateinstall[] =date("l,F j, Y",strtotime($value['date_booked'])) ;
                $job['no_installer_allocated'] = $value['number_of_installer'];
                $job['roof_type_id'] =  $this->session->userdata('in_rooftype');
                $job['piperun_length'] =  $this->session->userdata('piperundist');
                $job['panel_count'] =  $this->session->userdata('nop');
                $job['job_pid'] = $pid;
                if(!$job_update){
                $this->db->insert("jobs",$job);
                $job_id = $this->db->insert_id();
                if(!$pid){
                    $pid = $job_id;
                    $jobpid['job_pid'] = $pid;
                    $this->db->where("id",$job_id);
                    $this->db->update("jobs",$jobpid);
                }

                } else {
                    $this->db->where("id",$job_id);
                    $this->db->update("jobs",$job);
                    $job_update =false;
                }
                $year = date("Y" ,strtotime($value['date_booked']));
                $month = date("m" ,strtotime($value['date_booked']));
             }
             if($this->session->userdata('job_type')==5){
                $session_installer_data[date("j", strtotime($value['date_booked']))][] = $value;
                $job['current_status'] = "to be completed";
                $job['modified_by'] =  $this->session->userdata("user_id");
                $job['job_date'] =$value['date_booked']." ".date("h:i:s");
                $job['created'] = date("Y-m-d h:i:s");
                $dateinstall[] =date("l,F j, Y",strtotime($value['date_booked'])) ;
                $job['no_installer_allocated'] = $value['number_of_installer'];
                if(!$job_update){
                $this->db->insert("jobs",$job);
               $job_id = $this->db->insert_id();
               if(!$pid){
                    $pid = $job_id;
                    $jobpid['job_pid'] = $pid;
                    $this->db->where("id",$job_id);
                    $this->db->update("jobs",$jobpid);
                }
                } else{
                    $this->db->where("id",$job_id);
                    $this->db->update("jobs",$job);
                    $job_update =false;
                }
                $year = date("Y" ,strtotime($value['date_booked']));
                $month = date("m" ,strtotime($value['date_booked']));
             }

        }
          if( $this->session->userdata('job_type')==1 || $this->session->userdata('job_type')==2){
              
              $this->savePLjobs($job, $pid, false);
          }
          $json['success'] = true;
          $json['year'] = $year;
          $json['month'] = $month;
          $j= $this->getUserLoad($this->session->userdata('re_user_id'));
          $ismailsent = $this->globalnotifcation();
          if($ismailsent){
            $this->load->library('email');
            $config['mailtype'] = 'html';
            $this->email->initialize($config);
            $this->email->from('sales@aeihawaii.com', 'Schedular');
            $row_users =  array();
            $row_users = $this->db->query("SELECT users.email FROM users LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type='admin'")->result_array();
            $cnt = count($row_users);
            $row_users[$cnt ]['email']= $j[0]->email;
            foreach ($row_users as $valueuser){
                $this->email->to($valueuser['email']);
                $jobtimelimit = $this->gettimeLimit($value['id']);
                $timediff =  $jobtimelimit;
                // foreach($date_mail as $key => $value){
                if($da[0]->job_lastscheduledate!=null){
                if ($this->session->userdata('job_type')==5 ){
                       $this->email->subject('Rescheduled AEI Service Call  for  '.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name'));
                       $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
This job has been rescheduled from '.date("l,F j, Y", strtotime($da[0]->job_lastscheduledate)).' to '.implode(",", $dateinstall).'<br/> To view the details of this service call, update and edit your technical specifications here:<br/>
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification for '.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name').'</a><br/><br/>



Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
                       
                  }else {
                $this->email->subject('Job Rescheduled for  '.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name'));
                  
                $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p><b>Congratulations '.$j[0]->first_name." ".$j[0]->last_name.'!</b></p>
 This job has been rescheduled from '.date("l,F j, Y", strtotime($da[0]->job_lastscheduledate)).' to '.implode(",", $dateinstall).'
Now that you have completed your contract with your customer, you will now have to enter the technical specifications on the AEI Team System and get them an installation date.
Update and Edit your Technical Specifications Here:
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification</a><br/><br/>

Edit Customer Information:
 <a href="'.base_url().'admin/customer_job/'.$job_id.'">'.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name').' - Installation Date: '.implode(",", $dateinstall).'</a><br/><br/>
<p>
IMPORTANT NOTICE: YOU HAVE '.$timediff.' HOURS FROM TIME OF INITIAL BOOKING TO ENTER AND SAVE ALL REQUIRED FIELDS FOR THE CUSTOMER\'S:<br/>
1.) <a href="'.base_url().'admin/job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">JOB SPECIFICATIONS</a><br/>
2.) <a href="'.base_url().'admin/customer_job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">CUSTOMER INFORMATION</a><br/>
3.) <a href="'.base_url().'admin/job_financing/'.$job_id.'" style="text-decoration:none; color:#418E1C;">PRICE INFORMATION</a><br/>
</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
                  }}else{
                  if ($this->session->userdata('job_type')==5 ){
                       $this->email->subject('AEI Service Call Scheduled for  '.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name'));
                       $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
A Service Call has been scheduled for your customer.<br/> To view the details of this service call, update and edit your technical specifications here:<br/>
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification for '.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name').'</a><br/><br/>



Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
                       
                  }else{

                    $this->email->subject('AEI Administration:Job Created for  '.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name'));
                  

                $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p><b>Congratulations '.$j[0]->first_name." ". $j[0]->last_name.'!</b></p>
Now that you have completed your contract with your customer, you will now have to enter the technical specifications on the AEI Team System and get them an installation date.
Update and Edit your Technical Specifications Here:
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification</a><br/><br/>

Edit Customer Information:
 <a href="'.base_url().'admin/customer_job/'.$job_id.'">'.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name').' - Installation Date: '.implode(",", $dateinstall).'</a><br/><br/>
<p>
IMPORTANT NOTICE: YOU HAVE '.$timediff.' HOURS FROM TIME OF INITIAL BOOKING TO ENTER AND SAVE ALL REQUIRED FIELDS FOR THE CUSTOMER\'S:<br/>
1.) <a href="'.base_url().'admin/job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">JOB SPECIFICATIONS</a><br/>
2.) <a href="'.base_url().'admin/customer_job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">CUSTOMER INFORMATION</a><br/>
3.) <a href="'.base_url().'admin/job_financing/'.$job_id.'" style="text-decoration:none; color:#418E1C;">PRICE INFORMATION</a><br/>
</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
                  }
                }
          @$this->email->message($message);
          @$this->email->send();
        }
         }
          //}
          $this->db->query("UPDATE jobs set job_lastscheduledate=job_date  where  job_pid= '".$pid."'");
        
          $this->canceljob();
          echo json_encode($json);
        
    }
    function cancelsessionjob($id,$year ,$month,$noinstaller , $uid){
       $noi_session = $this->session->userdata('in_noi');
       $nod_session =  $this->session->userdata('in_nod');
       $setagain["in_noi"] = $noi_session + $noinstaller ;
       $setagain["in_nod"] = $nod_session + 1;
       $this->session->set_userdata($setagain);
       $sql = "DELETE FROM  session_installer WHERE id='$id'";
       $this->db->query($sql);
       redirect("admin/installer_available/$year/$month/$uid");
    }
    function day_installeredit($year,$month,$day,$installer,$jobs){
         $selectinstaller = array();
         $data["year"] = $year;
         $data["month"] = $month;
         $data["day"] = $day;
         $data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
         $data["installer"] = $installer;
         $data["jobs"] = $jobs;
         $this->load->view("ajax/installer_edit.php",$data);
        }
    
    function day_installersave(){
        $row = array();
        $resultcnt = 0;
	$row['day'] =  $this->input->post("re_date");
        $resultcnt = array();
	$resultcnt =  $this->db->query("SELECT * FROM installer_manual where day = '".$row['day']."'")->result_array();
        if(count($resultcnt)>=1) {
          $row['installer'] =  $this->input->post("in_nos") + $this->input->post("jobs");
          $this->db->where('day',$row['day']);
          $this->db->update('installer_manual', $row);
          $json['success'] = true;
          echo json_encode($json);
          return;
        }
        $row['installer'] =  $this->input->post("in_nos") + $this->input->post("jobs");
	$row['uid'] = $this->session->userdata('user_id');
	$row['created_on'] = date("Y-m-d h:i:s");
	$this->db->insert("installer_manual",$row);
        $json['success'] = true;
        echo json_encode($json);
    }

     function unblock_day($date,$message=""){
        // echo "$date";
        // die;
     
     if (!$date  ){
        return 0;
     }
     else{
         //$date = "$year-$month-$day";
     $sql = "DELETE FROM  admin_block_date  WHERE block_date='$date'";
     $this->db->query($sql);
       echo 1;
     }
    }
     function unblock_day_form($year='',$month='',$day=''){
         $date = "$year-$month-$day";
         $data['year'] = $year;
	 $data['month'] = $month;
	 $data['day'] = $day;
	 $data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
         $data['date'] = $date;

        /**
         *  To do to remove the hard coded
         */

        $this->load->view("ajax/adminunblockday",$data);

    }
    function adduser_ajax($usertype=null){
        
        if($this->session->userdata("role") != 'admin'){
            redirect("admin/error?e=permissions");
        }
        $data = array();
	if($this->input->post("type")){
            $row = array();
            $row['first_name'] = $this->input->post("first_name");
            $row['last_name'] = $this->input->post("last_name");
            $row['color_id'] = $this->input->post("color_id");
            $row['type'] = $this->input->post("type");
            $row['email'] = $this->input->post("email");
            $row['custom_hex'] = $this->input->post("custom_hex");
            if($this->input->post("password"))
            {
                $row['password'] = md5($this->input->post("password"));
            }
           $t = $this->db->insert("users",$row);
           $json['success'] = true;
           $json['id'] = $this->db->insert_id();
           $json['value'] = ucfirst($row['first_name']) ." ".ucfirst($row['last_name']);
           echo json_encode($json);
	   return;
        }
        $roles =array();
        $roles['admin'] = 'Admin';
	$roles['sales'] = 'Salesperson';
	$roles['installer'] = 'Installer';
        $roles['contractor'] = 'Contractor';
	$data['usertype'] = "";
        if($usertype) {
            if(!array_key_exists($usertype, $roles)){
                redirect("admin/error?e=permissions");
            }
            $roles =array();
            $roles[$usertype] = ucfirst($usertype);
        } 
        $data['roles'] = array();
	$data['usertype'] = "";
        $data['roles'] = $roles;
        $data['colors'] = $this->db->get("colors")->result_array();
        $this->load->view("ajax/new_user",$data);
		
    }

    function save_jobinstaller(){

        $assigninstaller=$this->input->post("ai");
        $job_id = $this->input->post("job_id");
        $ci= $this->input->post("ci");
        $chk = $this->input->post("chk");
        $sql = "UPDATE jobs set installer_id='$assigninstaller', conduit_id = '$ci' WHERE id=$job_id";
        $this->db->query($sql);
        if($this->input->post("job_type_id")!=6) {
          $pid = $this->getparentjobid($job_id);
        }else{
            $pid ="=".$this->getparentjobid($job_id)." AND job_type_id=6";
        }
	if(in_array($this->session->userdata("user_id"),array(5,88,66,27,117))){
            $sql_cond = "select contractor_id,job_date from jobs WHERE job_pid=$pid";
            $result_cond = $this->db->query($sql_cond)->result_array();
            $sqlC = "UPDATE jobs set contractor_id='$chk' WHERE job_pid=$pid";
            $this->db->query($sqlC);
            if(isset($result_cond[0]['contractor_id'])){
                $cont = explode(",",$result_cond[0]['contractor_id']);
                $cont_1 = explode(",",$chk);
                $diff = array_diff($cont,$cont_1);
                foreach($diff as $user_id){
                    if(!isset($user_id)) continue;
                    $this->job_unassignnotification($job_id,$user_id,$result_cond[0]['job_date']);
                }
            }
            if(isset($chk)){
                $cont = explode(",",$chk);
                foreach($cont as $user_id){
                    if(!isset($user_id)) continue;
                    $this->job_assignnotification($job_id,$user_id);
                }
            }

        }


        if(isset($assigninstaller)){
            $cont = explode(",",$assigninstaller);
            foreach($cont as $user_id){
                if(!isset($user_id)) continue;
                $this->job_assignnotification($job_id,$user_id);
            }
        }
        if(isset($ci)){
            $cont = explode(",",$ci);
            foreach($cont as $user_id){
                if(!isset($user_id)) continue;
                $this->job_assignnotification($job_id,$user_id);
            }
        }
        $json['success'] = true;
        echo json_encode($json);
    }
    
    function day_view_save_jobinstaller(){
       $job_id = $this->input->post("job_id"); 
       $assigninstaller=$this->input->post("ai_".$job_id);
       $ci= $this->input->post("ci_".$job_id);
        $chk = $this->input->post("chk_".$job_id);
        $sql = "UPDATE jobs set installer_id='$assigninstaller', conduit_id = '$ci' WHERE id=$job_id";
        $this->db->query($sql);
        if($this->input->post("job_type_id")!=6) {
          $pid = $this->getparentjobid($job_id);
        }else{
            $pid ="=".$this->getparentjobid($job_id)." AND job_type_id=6";
        }
	if(in_array($this->session->userdata("user_id"),array(5,88,66,27,117))){
            $sql_cond = "select contractor_id,job_date from jobs WHERE job_pid=$pid";
            $result_cond = $this->db->query($sql_cond)->result_array();
            $sqlC = "UPDATE jobs set contractor_id='$chk' WHERE job_pid=$pid";
            $this->db->query($sqlC);
            if(isset($result_cond[0]['contractor_id'])){
                $cont = explode(",",$result_cond[0]['contractor_id']);
                $cont_1 = explode(",",$chk);
                $diff = array_diff($cont,$cont_1);
                foreach($diff as $user_id){
                    if(!isset($user_id)) continue;
                    $this->job_unassignnotification($job_id,$user_id,$result_cond[0]['job_date']);
                }
            }
            if(isset($chk)){
                $cont = explode(",",$chk);
                foreach($cont as $user_id){
                    if(!isset($user_id)) continue;
                    $this->job_assignnotification($job_id,$user_id);
                }
            }

        }


        if(isset($assigninstaller)){
            $cont = explode(",",$assigninstaller);
            foreach($cont as $user_id){
                if(!isset($user_id)) continue;
                $this->job_assignnotification($job_id,$user_id);
            }
        }
        if(isset($ci)){
            $cont = explode(",",$ci);
            foreach($cont as $user_id){
                if(!isset($user_id)) continue;
                $this->job_assignnotification($job_id,$user_id);
            }
        }
        $json['success'] = true;
        echo json_encode($json);
    }
    function delete_referral($id){
        $sql = "DELETE FROM referrals WHERE id=".$id;
        $this->db->query($sql);
        $json['success'] = true;
        echo json_encode($json);
    }
    function ajaxplanlisting($job_id,$file_type="no"){
        $pid = $this->getparentjobid($job_id);
        $this->db->where("job_id",$pid);
	$this->db->order_by("created","desc");
        $plan_files = $this->db->get("genral_files")->result_array();
        if (count($plan_files) > 0){
        $output =    '<table cellspacing="0" class="files-table">';
        foreach ($plan_files as $key => $value) {

        $output .='<tr>';
	$output .='<td><img src="/assets/images/mime-generic.gif" />&nbsp;&nbsp;';
        $output .='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadplan/'.$value['id'].'">'.$value['original_filename'].'</a></td>';
        $output1 ='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadplan/'.$value['id'].'">Download Plot Plan</a>';
	$output .='<td><a href="'.base_url().'admin/delete_planfile/'.$value['id'].'"><img src="/assets/images/delete-icon.gif" /></a></td>';
	$output .='</tr>';
	}
        $output .='</table>';

       } else{
	$output ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';
        $output1 ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';
	}
    
        $json['first'] = $output;
        $json['second'] = $output1;
        echo json_encode($json);
    }
     function ajaxpremitfilelisting($job_id,$file_type="no"){
        $pid = $this->getparentjobid($job_id); 
        $this->db->where("job_id",$pid);
        $this->db->where("type",$file_type);
	$this->db->order_by("created","desc");
        $json = array();
        $downloadname = "Download";
        $type =$file_type;
        if($type=="building"){
            $downloadname = "Download Building Permit";
        }elseif($type=="netmeter"){
            $downloadname = "Download Net Metering Agreement";
        }elseif($type=="homeowner"){
            $downloadname = "Download Home Owners Association";
        }
        $plan_files = $this->db->get("permit_files")->result_array();
        if (count($plan_files) > 0){
            $json['success']=true;
        foreach ($plan_files as $key => $value) {
            $json['filedata']='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadpermit/'.$value['id'].'">'.$downloadname.'</a></td>';
            $json['uploaddata']='Uploaded     '.date("y/m/d",strtotime($value['created'])).'&nbsp;&nbsp;<a href="'.base_url().'admin/delete_permitfile/'.$value['id'].'"> <img src="/assets/images/delete-icon.gif" /></a>';
       	}
        echo json_encode($json); 

       } 
        
    }
     function ajaxsketchlisting($job_id,$file_type="no"){
        $pid = $this->getparentjobid($job_id); 
        $this->db->where("job_id",$pid);
	$this->db->order_by("created","desc");
      
	$plan_files = $this->db->get("sketch_files")->result_array();
        if (count($plan_files) > 0){
        $output =    '<table cellspacing="0" class="files-table">';
        foreach ($plan_files as $key => $value) {

        $output .='<tr>';
	$output .='<td><img src="/assets/images/mime-generic.gif" />&nbsp;&nbsp;';
        $output .='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadsketch/'.$value['id'].'">'.$value['original_filename'].'</a></td>';
        $output1 ='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadsketch/'.$value['id'].'">Download Salesman Sketch</a>';
	$output .='<td><a href="'.base_url().'admin/delete_sketchfile/'.$value['id'].'"><img src="/assets/images/delete-icon.gif" /></a></td>';
	$output .='</tr>';
	}
        $output .='</table>';

       } else{
	$output ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';
        $output1 ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';
	}
        $json =array();
       $json['first'] = $output;
        $json['second'] = $output1;
        echo json_encode($json);
       
    }
     function ajaxelecphotofilelisting($job_id,$photo_id=1){
        $this->load->helper("thumbnail_helper"); 
        $pid = $this->getparentjobid($job_id); 
        $this->db->where("job_id",$pid);
	$this->db->where("photo_id",$photo_id);
      	$elecphoto_files = $this->db->get("elecphoto_files")->result_array();
        if (count($elecphoto_files) > 0){
        $output =    '<table cellspacing="0" class="files-table">';
        foreach ($elecphoto_files as $key => $value) {
            if($value['photo_id']==$photo_id){    
            $output .='<tr>';
            $output .='<td><img src="/assets/images/mime-generic.gif" />&nbsp;&nbsp;';
            $output .='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadelecphoto/'.$value['id'].'">'.$value['original_filename'].'</a></td>';
            $output .='<td><a href="'.base_url().'admin/delete_elecphotofile/'.$value['id'].'"><img src="/assets/images/delete-icon.gif" /></a></td>';
            $output .='</tr>';
            }
                   $output1 ='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadelecphoto/'.$value['id'].'">Download Salesman Sketch</a>';
	}
        $output .='</table>';

       } else{
	$output ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';
        
	}
        $this->db->where("job_id",$pid);
  $this->db->where("photo_id",1);
  
  $elec_photo_1 = $this->db->get("elecphoto_files")->result_array();
  $this->db->where("job_id",$pid);
  $this->db->where("photo_id",2);
  $elec_photo_2 = $this->db->get("elecphoto_files")->result_array();
  $this->db->where("job_id",$pid);
  $this->db->where("photo_id",3);
  $elec_photo_3 = $this->db->get("elecphoto_files")->result_array();
  $output1 = "<table><tr>";
    if (count($elec_photo_1) > 0){
        foreach ($elec_photo_1 as $key => $value){
          $src_pth = $value["unique_filename"];
	  $output1 .= '<td><a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadplan/'.$value["id"].'"><img src="'.thumbnail($src_pth, 50, 50).'" /></a> </td>';
          }
     } else { 
             $output1 .= '<td>No Image1</td>';
     }
     if (count($elec_photo_2) > 0){
        foreach ($elec_photo_1 as $key => $value){
          $src_pth = $value["unique_filename"];
	  $output1 .= '<td><a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadplan/'.$value["id"].'"><img src="'.thumbnail($src_pth, 50, 50).'" /></a> </td>';
          }
     } else { 
             $output1 .= '<td>No Image1</td>';
     }
     if (count($elec_photo_3) > 0){
        foreach ($elec_photo_1 as $key => $value){
          $src_pth = $value["unique_filename"];
	  $output1 .= '<td><a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadplan/'.$value["id"].'"><img src="'.thumbnail($src_pth, 50, 50).'" /></a> </td>';
          }
     } else { 
             $output1 .= '<td>No Image1</td>';
     }
$output1 .='</tr></table>';
        $json =array();
       $json['success'] = true;
       $json['first'] = $output;
       $json['second'] = $output1;
       echo json_encode($json);
       
    }
    function ajaxsalefilelisting($job_id,$file_type="no"){
        $pid = $this->getparentjobid($job_id); 
        $this->db->where("job_id",$pid);
	$this->db->order_by("created","desc");
        
	$plan_files = $this->db->get("presale_files")->result_array();
        if (count($plan_files) > 0){
        $output =    '<table cellspacing="0" class="files-table">';
        foreach ($plan_files as $key => $value) {

        $output .='<tr>';
	$output .='<td><img src="/assets/images/mime-generic.gif" />&nbsp;&nbsp;';
        $output .='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadpresale/'.$value['id'].'">'.$value['original_filename'].'</a></td>';
        $output1 ='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadpresale/'.$value['id'].'">Download Measured Sketch</a>';
        if ($value['notification'])
            $output1 .= "<br/>(Confirmed)";
        else
            $output1 .= "<br/>(Not Confirmed)";
	$output .='<td><a href="'.base_url().'admin/delete_presalefile/'.$value['id'].'"><img src="/assets/images/delete-icon.gif" /></a></td>';
	$output .= '<td style="border: 0pt none;"><div style="display:inline;margin-left:50px;width:250px;float:right;"> <input type="checkbox" value="" name="presalenotification" onclick="sendnotification();"><span  style="padding:5px;">Confirmed By Customer</span></div></td>';
        
        $output .='</tr>';
	}
        $output .='</table>';

       } else{
	$output ='<div style="padding:10px; background:#fff;">No PreSale files.</div>';
        $output1 ='<div style="padding:10px; background:#fff;">No PreSale files.</div>';
	}
        
        $json['first'] = $output;
        $json['second'] = $output1;
        echo json_encode($json);
        
    }
  
    function savetimelimit(){
     $row = array();
     $resultcnt = 0;
     $getpid  =  $this->input->post("jobid");

     $resultcnt = array();
     $row['jid'] = $this->getparentjobid($getpid);
     $resultcnt =  $this->db->query("SELECT * FROM timelimit_manual_extend where jid = '".$row['jid']."'")->result_array();
     if(count($resultcnt)>=1) {
        $row['timeext'] =  $this->input->post("timeext");
        $this->db->where('jid',$row['jid']);
        $this->db->update('timelimit_manual_extend', $row);
        $json['success'] = true;
         echo json_encode($json);
          return;
        }
        $row['timeext'] =  $this->input->post("timeext");
	$row['created_on'] = date("Y-m-d h:i:s");
	$this->db->insert("timelimit_manual_extend",$row);
        $json['success'] = true;
        echo json_encode($json);
    }
    function timeextform($jobid){
      $data['jobid'] = $jobid;
      $data["timeext"] = array(""=>"Select hours", "5"=>"5","10"=>"10","20"=>"20","30"=>"30","40"=>"40","50"=>"50","168"=>"168","192"=>"192","216"=>"216");
      $data["timeextsel"] = 0;
      $pid = $this->getparentjobid($jobid);
      $resultcnt =  $this->db->query("SELECT * FROM timelimit_manual_extend where jid = '".$pid."'")->result_array();
      if(count($resultcnt)>=1) {
        $data["timeextsel"] = $resultcnt[0]['timeext'];
      }
      $this->load->view("ajax/timeext_job",$data);
    }

    function  globaltimeextform(){
      $data["timeext"] = array(""=>"Select Number of day", "24"=>"1 Day","48"=>"2 Day","72"=>"3 day","96"=>"4 day","120"=>"5 day","144"=>"6 day","168"=>"7 day");
      $data["timeextsel"] = 0;
      $resultcnt =  $this->db->query("SELECT * FROM globalconfig  where id = 1")->result_array();
      if(count($resultcnt)>=1) {
        $data["timeextsel"] = $resultcnt[0]['globaltimelimit'];
      }
      $this->load->view("ajax/globaltimeext_job",$data);
    }
    function saveglobaltimelimit(){
     $row = array();
     $row['globaltimelimit'] =  $this->input->post("timeext");
     $this->db->where('id',1);
     $this->db->update('globalconfig', $row);
     $json['success'] = true;
     echo json_encode($json);
    }
    function getUserLoad($id){
      if (!$id) return 0;
      $j = $this->db->query("SELECT * FROM users WHERE id=$id")->result();

      return $j;
 }

 function  installer_swh($year='',$month='',$job_id=0){
        $data = array();
         $data['job'] =array();
         $data["sct"] ="";
        if($job_id) {
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
            $data['job'] = $this->db->query($sql)->row_array();
            $data["sct"] ="var customer_id = '';var userid =''; var reserverjob;";
          }
        $data['customer_id'] = '';
       	$month = ltrim($month,"0");
	$data['year'] = $year;
	$data['month'] = $month;
	//$data['day'] = $day;
	//$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
	if($this->input->get("customer_id")){
            $data['customer_id'] = $this->input->get("customer_id");
            $data['customer'] = $this->db->query("SELECT * FROM customers WHERE id=".$this->db->escape($data['customer_id']))->row_array();
	}
	/**
         *  To do to remove the hard coded
         */
         $sql = "SELECT id,type FROM panel_numbers ";
        $nop_type = array();
        $nop_type["0"]= "Select Number of Panels";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0){
             foreach ($query->result() as $row){
                $nop_type[$row->id] =  $row->type;
            }
        }
        $data["numberofpanels"]= $nop_type;
        $sql = "SELECT id,type FROM roof_types";
        $roof_typea = array();
        $roof_typea["0"]= "-Select roof type-";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0){
             foreach ($query->result() as $row){
                $roof_typea[$row->id] =  $row->type;
            }
        }
        $data["roof_type"]= $roof_typea;

        $data["piperundistance"] = array("0"=>"Select Pipe Run Distance");
        $this->db->order_by('id','asc');
        $piperundistance_display = $this->db->get("pipe_run_distance")->result_array();
        foreach($piperundistance_display as $row) {
          $data["piperundistance"][$row['id']] = $row['type'];
        }
       
        $data["nod"] = array("1"=>"1", "2"=> "2", "3"=>"3");

        $this->load->view("ajax/installer_swh.php",$data);
    }
 function gettimeLimit($jobid){
      $timelimit = 24;
     $resultcnt =  $this->db->query("SELECT * FROM globalconfig  where id = 1")->result_array();
     $timelimit = $resultcnt[0]['globaltimelimit'];
     return $timelimit;
  }

 function getparentjobid($job_id){
   $resultcnt =  $this->db->query("SELECT job_pid FROM jobs  where id = $job_id")->result_array();
   $pid = $resultcnt[0]['job_pid'];
   if(!$pid){
    $pid =$job_id;
   }
   return $pid;
 }
 function sendcommentmail($mailid,$content,$job_id,$name){
   $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($mailid);
   $this->email->subject('AEI System Notification');
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inci" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> You have received a comment on your job for '.$name.'<br/>'.$content.'<br/>
<a href="'.base_url().'admin/job_comment/'.$job_id.'">Go to Job Comment</a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
          @$this->email->message($message);
          @$this->email->send();
 }
 function setdeafultpage(){
     $url =  $this->input->get("q");
     $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;Are you sure to set this as default page?<br/>&nbsp;&nbsp;&nbsp;<button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
     $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() { location.href='".base_url()."ajax/sethomepage?q=/$url'}); });</script>";
     echo $output;
 }
 function sethomepage($url){
     $url =  substr($this->input->get("q"),1);
     $rowu['homepage'] = $url;
     $sql = "Select user_id from home_page WHERE user_id=".$this->session->userdata("user_id");
     $row = $this->db->query($sql)->result_array();
     if($row[0]['user_id']){
        $this->db->where('user_id',$row[0]['user_id']);
         $this->db->update("home_page",$rowu);
       
     }else{
        $rowu['user_id'] = $this->session->userdata("user_id");
        $this->db->insert("home_page",$rowu);
     }
     $this->session->set_userdata(array('job_url'=>$rowu['homepage']));
     
     redirect($url);
  }
  function deletefilem($file_id){
     $url =  $this->input->get("q");
     
     $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;Are you sure to delete this file?<br/>&nbsp;&nbsp;&nbsp;<button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
     $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() { location.href='".base_url()."admin/deleteImage/0/$file_id'}); });</script>";
     echo $output;
 }
 function deletecustomer($cust_id){
     $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;All Job related to this user will delete.&nbsp;Are you sure to delete this &nbsp;&nbsp;&nbsp;Customer?<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
     $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() { location.href='".base_url()."admin/delete_customer/$cust_id'}); });</script>";
     echo $output;
 }
 function savenotification($value){
   $row['notification'] = $value;
   //$row['id'] = 1;
   $this->db->where('id',1);
   $this->db->update('notification_setting', $row); 
   $json['success'] = true;
   echo json_encode($json);
 }
 function save_designer(){
   $jobid =   $this->input->post("job_id");
   $pid = $this->getparentjobid($this->input->post("job_id"));  
   $row['designer_id'] = $this->input->post("did");
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        $json['success'] = true;
        echo json_encode($json);
        return;
    }
	  $row['designer_id'] = $this->input->post("did");
	

     if($row['designer_id']=="") {
        $json['success'] = true;
        echo json_encode($json);
         return;
     }

    $isuserpre = $this->issendnotification($row['designer_id']);
	
    if(!$isuserpre){
        $json['success'] = true;
        echo json_encode($json);
        return ;
    }
    $j= $this->getUserLoad($row['designer_id']);
	$this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($j[0]->email);
   $this->email->subject('AEI System :-Job Notification');
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> A Plot Plan has assigned to you. For  Detail , please click below<br/>
<a href="'.base_url().'admin/job/'.$jobid.'">Go to Job </a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
          @$this->email->message($message);
          @$this->email->send();
   $json['success'] = true;
   echo json_encode($json);
 }
 function send_bisnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);  
   $row['bis'] = implode("-",explode("/",$this->input->post("dt")));
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row); 
   $this->sendusermail($job_id,'building');
   $json['success'] = true;
   echo json_encode($json);
 }
 function send_eisnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);  
   $row['eis'] = implode("-",explode("/",$this->input->post("dt")));
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->sendusermail($job_id,'electrical');
   $json['success'] = true;
   echo json_encode($json);
 }
 function send_hapshnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);  
   $row['hapsta'] = implode("-",explode("/",$this->input->post("dt")));
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->sendusermail($job_id,'Homeowner Association');
   $json['success'] = true;
   echo json_encode($json);
 }
 function savenotificationuser($value,$user_id){
   $row['notification'] = $value;
   $sql = "SELECT user_id FROM  notification_setting WHERE user_id = $user_id";
   $rowe = array();
   $rowe = $this->db->query($sql)->result_array();
   if(count($rowe)>=1 && $rowe[0]['user_id']){
        $this->db->where('user_id',$rowe[0]['user_id']);
        $this->db->update('notification_setting', $row); 
       
     }else{
        $row['user_id'] = $user_id;
        $this->db->insert('notification_setting', $row); 
     }
   
   $json['success'] = true;
   echo json_encode($json);
 }
  function ppsavechk($value,$jid){
   $row['is_pp_checked'] = $value;
   $this->db->where('job_pid',$jid);
   $this->db->update('jobs', $row);
   $json['success'] = true;
   echo json_encode($json);
 }
  function sendpreassementmail($job_id){
    $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
    if($job_id) {
        	// get job data
            $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
            $data = $this->db->query($sql)->row_array();
            
           
    $this->load->library('email');
    $config['mailtype'] = 'html';
    $this->email->initialize($config);
    $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
    $row_users = $this->db->query("SELECT users.email from users LEFT JOIN notification_setting ns ON users.id=ns.`user_id` WHERE   users.type='admin' and ns.notification=1")->result_array();
    foreach ($row_users as $value){
      $this->email->to($value['email']);
      $jobtimelimit = $this->gettimeLimit($job_id);
      $timediff =  $jobtimelimit;
      $this->email->subject('Pre-assessment Sketch Confirmed - '.$data['first_name'].', '.$data['last_name']);
      $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">

Now that you have completed your contract with your customer, you will now have to enter the technical specifications on the AEI Team System and get them an installation date.
Update and Edit your Technical Specifications Here:
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification</a><br/><br/>

Edit Customer Information:
 <a href="'.base_url().'admin/customer_job/'.$job_id.'">'.$data['first_name'].', '.$data['last_name'].'</a><br/><br/>
<p>
IMPORTANT NOTICE: YOU HAVE '.$timediff.' HOURS FROM TIME OF INITIAL BOOKING TO ENTER AND SAVE ALL REQUIRED FIELDS FOR THE CUSTOMER\'S:<br/>
1.) <a href="'.base_url().'admin/job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">JOB SPECIFICATIONS</a><br/>
2.) <a href="'.base_url().'admin/customer_job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">CUSTOMER INFORMATION</a><br/>
3.) <a href="'.base_url().'admin/job_financing/'.$job_id.'" style="text-decoration:none; color:#418E1C;">PRICE INFORMATION</a><br/>
</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
      @$this->email->message($message);
      @$this->email->send();
  }
  $pid = $this->getparentjobid($job_id); 
  
   $row['notification'] = 1;
   $this->db->where('job_id',$pid);
   $this->db->update('presale_files', $row); 
  $json['success'] = true;
 echo json_encode($json);
 }  else {
  $json['success'] = false;
   echo json_encode($json);
}
}
function sendusermail($job_id,$content){
    $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
     $sql = "SELECT   users.email,customers.first_name,customers.last_name,jobs.contractor_id,jobs.installer_id,jobs.conduit_id FROM		jobs
			LEFT JOIN users ON jobs.user_id=users.id
                        LEFT JOIN customers ON jobs.customer_id=customers.id
                        LEFT JOIN  notification_setting ns ON ns.user_id = users.id
			WHERE ns.notification!=0 AND jobs.id=".$job_id;
     $data = array();
     $data = $this->db->query($sql)->result_array();
     if(count($data)>=1){
        $name = ucfirst($data[0]['last_name'])." ".ucfirst($data[0]['first_name']);
        @$this->sendpermitmail($data[0]['email'],$content,$job_id,$name);
        $in_user = '';
        if($data[0]['contractor_id']){
            $in_user .= $data[0]['contractor_id'].",";  
        }
        if($data[0]['installer_id']){
            $in_user .= $data[0]['installer_id'].",";  
        }
        $in_user = substr($in_user,0,-1);
        $assoc_users =  array();
        if ($in_user!=''){
            $assoc_users = $this->db->query("SELECT users.email from users WHERE id in ($in_user)")->result_array();
            // print_R($assoc_users);
            foreach ($assoc_users as $value){
                @$this->sendpermitmail($value['email'],$content,$job_id,$name);
            }
        }
     }
    $row_users =  array();
    $row_users = $this->db->query("SELECT users.email from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type='admin'")->result_array();
     foreach ($row_users as $value){
         @$this->sendpermitmail($value['email'],$content,$job_id,$name);
     }
}
function sendpermitmail($mailid,$content,$job_id,$name){
   $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($mailid);
   $this->email->subject('AEI System Permit Notification');
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> '.@ucfirst($content).' Permit for '.$name.' has been uploaded for review<br/>
<a href="'.base_url().'admin/permit_job/'.$job_id.'">Download Permit</a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
     @$this->email->message($message);
     @$this->email->send();
 }

 function sendjobfilenotification($job_id,$content,$subject,$is_user,$is_admin){
     $ismailsent = $this->globalnotifcation();
     if(!$ismailsent){
        return;
     }																																  
      $sql = "SELECT   users.email,customers.first_name,customers.last_name,jobs.contractor_id,jobs.installer_id,jobs.conduit_id,jobs.designer_id FROM		jobs
			LEFT JOIN users ON jobs.user_id=users.id
                        LEFT JOIN customers ON jobs.customer_id=customers.id
                        LEFT JOIN  notification_setting ns ON ns.user_id = users.id
			WHERE ns.notification!=0 AND jobs.id=".$job_id;
        $data = array();
        $data = $this->db->query($sql)->result_array();
        if(count($data)>=1){
            $name = ucfirst($data[0]['last_name'])." ".ucfirst($data[0]['first_name']);
         }else{
             $name="";
         }
			if(isset($data[0]['designer_id'])&& $data[0]['designer_id']!=""){
				$j = $this->getUserLoad($data[0]['designer_id']);
				@$this->filenotification($j[0]->email,$content,$job_id,$name,$subject);
			}
       if($is_user) {
           @$this->filenotification($data[0]['email'],$content,$job_id,$name,$subject);
           //@$this->filenotification($this->session->userdata("email"),$content,$job_id,$name,$subject);
        }
   
   if($is_admin){
        $row_users =  array();
        $row_users = $this->db->query("SELECT users.email,users.first_name,users.last_name from users 
            LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type='admin'")->result_array();
        foreach ($row_users as $value){
       
            @$this->filenotification($value['email'],$content,$job_id,$name,$subject);
        }

   }
}
function filenotification($mailid,$content,$job_id,$name,$subject='AEI System  Notification'){
   $ismailsent = $this->globalnotifcation();
   if(!$ismailsent){
        return;
   }
   $sql  = "SELECT notification from notification_setting WHERE id=1";
   $nresult =  $this->db->query($sql)->result_array();
   if(!$nresult[0]['notification']) return ;
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($mailid);
   $subject =@str_replace("{cust_name}",$name,$subject);
    $subject =@str_replace("{name}","",$subject);
   $this->email->subject($subject);
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> '.@str_replace("{name}",$this->session->userdata("first_name").$this->session->userdata("last_name"),$content).' <br/>
<a href="'.base_url().'admin/job/'.$job_id.'">Download </a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
     @$this->email->message($message);
     @$this->email->send();
 }

 function  issendnotification($user_id){
   $sql = "SELECT user_id FROM  notification_setting WHERE user_id = $user_id";

   $rowe = array();
   $rowe = $this->db->query($sql)->result_array();
   if((count($rowe) >= 1)  && $rowe[0]['user_id']){
      return true;
   }else{
        $row['user_id'] = $user_id;
        return false;
   }

 }
 function globalnotifcation(){
   $sql  = "SELECT notification from notification_setting WHERE id=1";
   $nresult =  $this->db->query($sql)->result_array();
   if(!$nresult[0]['notification']) return 'false' ;
    return true;
 }
function updatepreassementmail($job_id){
 $row['notification'] = 0;
 $this->db->where('job_id',$job_id);
 $this->db->update('presale_files', $row);
 $json['success'] = true;
 echo json_encode($json);

}
function job_assignnotification($jobid,$userid){
     $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
    if($userid==""|| $jobid=="") return;
    $isuserpre = $this->issendnotification($userid);
    if(!$isuserpre){
        return ;
    }
    $j= $this->getUserLoad($userid);
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($j[0]->email);
   $this->email->subject('AEI System :-Job Notification');
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> A job has assigned to you. For job Detail , please click below<br/>
<a href="'.base_url().'admin/job_comment/'.$jobid.'">Go to Job </a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
    @$this->email->message($message);
    @$this->email->send();
}
function job_unassignnotification($jobid,$userid,$date){
     $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
    if($userid==""|| $jobid=="") return;
    $isuserpre = $this->issendnotification($userid);
    if(!$isuserpre){
        return ;
    }
    $j= $this->getUserLoad($userid);
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($j[0]->email);
   $this->email->subject('You have been un-assigned from this project '.$j[0]->last_name.' ,'.$j[0]->first_name.' on '.date("l,F j, Y",strtotime($date)));
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> This job has been unassigned from this job. <br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
    @$this->email->message($message);
    @$this->email->send();
}
function statusnotifaction ($custname,$ljobs , $cjobs,$saleman,$email,$userid=0,$notify=null){
   $ismailsent = $this->globalnotifcation();

    if(!$ismailsent){
        return;
    }
    if($userid){
        $isuserpre = $this->issendnotification($userid);
        if(!$isuserpre){
            return ;
        }
    }
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($email);
   $subject ='Job Status For '.$custname.' Has Updated To '.ucfirst($cjobs).' from '.ucfirst($ljobs)."($notify)";
   $this->email->subject($subject);
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> 
Hi '.$saleman.',<br/>
Your job <a href="'.base_url().'/"> '.$custname.'\'s </a>  job status has been updated to "'.ucfirst($cjobs).'" from " '.ucfirst($ljobs).'"<br/>
What this means: <br/>
If any actions are necessary, please make them as soon as possible. This change of status could mean informing your customer about the progress of their installation or permits.<br/>
<br/>Thank you,<br/>
The AEI Administration Team<br/>

</p>


		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
@$this->email->message($message);
@$this->email->send();
}
function permitcommonnotification($job_id,$notify){
    $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$job_id;
     $data['job'] = $this->db->query($sql)->row_array();
     $j = $this->getUserLoad($data['job']['user_id']);
     $row_users = $this->db->query("SELECT users.email,users.first_name,users.last_name from users
                            LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type='admin'")->result_array();
             foreach ($row_users as $value){
                $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $data['job']['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$value['email'],0,$notify);
             }
        $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $data['job']['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$j[0]->email,$j[0]->id,$notify);
            if(isset($data['job']['contractor_id'])){
                $cont = explode(",",$data['job']['contractor_id']);
                           foreach($cont as $user_id){
                            if(!isset($user_id)|| trim($user_id)=="") continue;
                            $k = array();
                            $k = $this->getUserLoad($user_id);
                            if(!count($k)|| $k==0) continue;
                               $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $data['job']['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$k[0]->email,$user_id,$notify);
                            }
            }
            if(isset($data['job']['designer_id'])){
                            $cont = explode(",",$data['job']['designer_id']);
                             foreach($cont as $user_id){
                           if(!isset($user_id)|| trim($user_id)=="") continue;
                            $k = array();
                            $k = $this->getUserLoad($user_id);
                            if(!count($k)|| $k==0) continue;
                               $this->statusnotifaction(ucfirst($data['job']['first_name']).ucfirst($data['job']['last_name']),$data['job']['current_status'] , $data['job']['current_status'],ucfirst($j[0]->first_name).ucfirst($j[0]->last_name),$k[0]->email,$user_id,$notify);
                        }
          }
          if(isset($data['job']['installer_id'])){
                            $cont = explode(",",$data['job']['installer_id']);
                            foreach($cont as $user_id){
                            if(!isset($user_id)|| trim($user_id)=="") continue;
                            $k = array();
                            $k = $this->getUserLoad($user_id);
                            if(!count($k)|| $k==0) continue;
                          
                            $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $data['job']['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$k[0]->email,$user_id,$notify);
                          }
       }
			

    }
function send_permitnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['permitnotfication'] = implode("-",explode("/",$this->input->post("dt")));
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->permitcommonnotification($job_id,'Permit Closed');
   $json['success'] = true;
   echo json_encode($json);
 }
function send_hieconotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['heconotfication'] = implode("-",explode("/",$this->input->post("dt")));
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->permitcommonnotification($job_id,'HECO Notified');
   $json['success'] = true;
   echo json_encode($json);
 }
 function unschedulejob($job_id){
     $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;Are you sure to unschedule  this  job &nbsp;&nbsp;&nbsp;<br/><br/>".  form_checkbox('job_pl')."Do you want to unschedule the PreLog job also?<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
     $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() { var val=0; if($('input:checkbox[name=job_pl]').is(':checked')){val =1;}  location.href='".base_url()."ajax/dounschedulejob/$job_id/'+val }); });</script>";
     echo $output;
 }
 function dounschedulejob($job_id,$val){
   if($val) {
    $pid = $this->getparentjobid($job_id);
    $installer = $this->db->query("SELECT sum(no_installer_allocated)as suminstaller FROM jobs where  job_type_id!=6 AND   job_pid= '".$pid."'")->result_array();
    $this->db->query("DELETE FROM jobs where  job_type_id!=6 AND id != job_pid  AND   job_pid='".$pid."'");
    $this->db->query("UPDATE jobs set job_lastscheduledate=job_date  where   job_pid= '".$pid."'");
    $sql = "UPDATE jobs set pl_job_id=0,job_lastscheduledate=job_date,job_date=null,current_status='unscheduled',no_installer_allocated=".$installer[0]['suminstaller']." where  job_pid=$pid";
    $this->db->query($sql);
   } else{
       $pid = $this->getparentjobid($job_id);
       $installer = $this->db->query("SELECT sum(no_installer_allocated)as suminstaller FROM jobs where  job_type_id!=6 AND   job_pid= '".$pid."'")->result_array();
       $this->db->query("DELETE FROM jobs where  job_type_id!=6 AND id != job_pid  AND   job_pid='".$pid."'");
       $this->db->query("UPDATE jobs set job_lastscheduledate=job_date  where job_type_id!=6 AND  job_pid= '".$pid."'");
       $sql = "UPDATE jobs set job_lastscheduledate=job_date,job_date=null,current_status='unscheduled',no_installer_allocated=".$installer[0]['suminstaller']." where job_type_id!=6 AND job_pid=$pid";
       $this->db->query($sql);
    }
   redirect("admin/myjobs");
 }
 function savePLjobs($job,$job_id,$is_reschedule){
    $session_installer = $this->db->query("SELECT *  FROM  pl_session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")." ORDER BY id")->row_array();
    if(@$session_installer['date_booked']){
      $sql = "SELECT * FROM jobs where jobs.job_type_id=6 AND job_pid=$job_id";
      $is_exist_job=$this->db->query($sql)->row_array();
      if(!isset($is_exist_job['id'])&& !$is_reschedule){
       $job['job_pid']=$job_id;
       $job['job_type_id']=6;
       $job['rel_job_id'] = $job_id;
       $job['job_date'] =$session_installer['date_booked']." ".date("h:i:s");
       $job['no_installer_allocated'] = 2;
       $slot_time=1;
       if($session_installer['slot_time']>2 && $session_installer['slot_time']<=4 ){
                $slot_time=2;
          }
          if($session_installer['slot_time']>4  ){
                $slot_time=3;
          }
       $job['arrival_time']=$slot_time;
       $this->db->insert("jobs",$job);
       $pl_job_id = $this->db->insert_id();
       $job_update['pl_job_id']=$pl_job_id;
       $this->db->where("job_pid",$job_id);
       $this->db->update("jobs",$job_update);
       $year = date("Y" ,strtotime($session_installer['date_booked']));
       $month = date("m" ,strtotime($session_installer['date_booked']));
      } else if (isset($is_exist_job['id'])&& $is_reschedule){
      
         $job =array();
         $job['job_date'] =$session_installer['date_booked']." ".date("h:i:s");
         $job['current_status'] = "";
         $slot_time=1;
         if($session_installer['slot_time']>2 && $session_installer['slot_time']<=4 ){
                $slot_time=2;
         }
         if($session_installer['slot_time']>4  ){
                $slot_time=3;
        }
       
       $job['arrival_time']=$slot_time;
       $this->db->where("id",$is_exist_job['id']);
       $this->db->update("jobs",$job);
       $year = date("Y" ,strtotime($session_installer['date_booked']));
       $month = date("m" ,strtotime($session_installer['date_booked']));
       $json['year'] = @$year;
       $json['month'] = @$month;
       $json['success'] = true;
       echo json_encode($json);
       $this->canceljob();
   }
      
    }  
  
 }
 
}
?>