<!--
Job Detail Page - Job Specifications

- Ability for admin-user to edit/add dropdown options
- Ability to view progress of form completion
- Ability to "Create Purchase Agreement" PDF to download. A pre-designed PDF form will be populated with data on this page and customer details

- Job Summary widget
    - Ability for all users to change 'current status'
    - functionality as seen in design

- Customer Summary Widget
  - functionality as seen in design

- Job Notes widget
    - ability for user to add simple notes/progress on job with date-stamp

- Upload files widget
   - ability for users to upload/add/delete files to Job

- Job Location Map
   - Google Map of job address
-->

<div style="position:relative;">
	<div class="page-top-buttons">
           <a href="<?=base_url()?>admin/createpdf/<?=$job_id?>" target="_blank"> <button>Create Design Sheet</button></a> <a target="_blank"  href="<?=base_url()?>admin/createpdf/<?=$job_id?>"  style="cursor:pointer;">	<button >Create Purchase Agreement</button></a>
		
	</div>
</div>

<h1>Job Details</h1>
<p><a href="<?=base_url()?>">Home</a> / <a href="<?=base_url()?>admin/jobschedule">Job Calendar</a> / <a href="<?=base_url()?>admin/day/<?=date("Y/m/d",$job_timestamp)?>"><?=date("F jS, Y",$job_timestamp)?></a> / <a href="<?=base_url()?>admin/customer/<?=$job['customer_id']?>"><?=$job['first_name']?> <?=$job['last_name']?></a> / <?=$job['job_type']?></p>
<br />

<div class="generic-page-block">
	<div class="green-header">
		<span class="dark-green">Job Date:</span> <?=date("F jS, Y",$job_timestamp)?>
		<span class="dark-green">Job Type:</span> <?=$job['job_type']?>
		<span class="dark-green">Customer Name:</span> <?=$job['first_name']?> <?=$job['last_name']?>
	</div>
	<div class="content">
		<div class="two-col-wide-left">
			<div class="content-header">Photovoltaic System Information</div>
			<p>Please fill out the relevant information below for your Customer's <?=$job['job_type']?> system.</p>
			<br />
			
			<div class="generic-nav-tabs">
                                <a href="<?=base_url()?>admin/job_comment/<?=$job_id?>"  >Comments</a>
				<a href="<?=base_url()?>admin/job/<?=$job_id?>" class="active">Job Specifications</a>
				<a href="<?=base_url()?>admin/job_financing/<?=$job_id?>">Financing</a>
				<a href="<?=base_url()?>admin/job_referrals/<?=$job_id?>">Referrals</a>
                                 <?php if($this->session->userdata("role") == 'admin') {?>
                                <a href="<?=base_url()?>admin/installers/<?=$job_id?>">Installers</a>
                                <?php }?>
                                <a href="<?=base_url()?>admin/customer_job/<?=$job_id?>">Customer</a>
				<div class="clear-left"></div>
			</div>
			
			<br /><br />
			
			<?=form_open('admin/job/'.$job_id,array('name' => 'form1', 'id' => 'form1'));?>
			<?=form_hidden('dosubmit','true')?>
			<div class="jobdetails clearfix" id="four-col-form">

                <div class="clearfix">
					<span class="green-text">[module details]</span>
				</div>

                <div class="jobrow clearfix">
                    <div class="jobdata mright">
						<?=form_label('Number of System', 'nos');?>
						<?=form_input('nos',@$job['job_nos'],'class="teszt"');?>
					</div>
                    <div class="jobdata">
						<?=form_label('Number of Sub Arrays', 'nosa');?>
						<?=form_input('nosa',@$job['job_nosa'],'class="teszt"');?>
					</div>
                </div>
                 <div class="jobrow clearfix">
                    <div class="jobdata mright">
						<table class="padded-table">
							<tr>
								<td>Sub Arrays On Other Roof-Face? </td>
								<td>
								<?
								if(@$job['saoorf'] == 'y') {$checked=true;} else {$checked=false;}
								echo form_radio('saoorf','y',$job['saoorf'],$checked)?>
								</td>
								<td>Yes</td>
								<td>
								<?
								if(@$job['saoorf'] == 'n' || !$checked) {$checked=true;} else {$checked=false;}
								echo form_radio('saoorf','n',$checked)?></td>
								<td>No</td>
							</tr>
						</table>
					</div>
                    <div class="jobdata" style="display:none;" id="div_nodrf">
                        <?=form_label('Number of Different Roof-Faces', 'nosa');?>
			<?=form_input('nodrf',@$job['nodrf'],'class="teszt"');?>
                    </div>
                </div>

                <div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Number of Module', 'job_nom');?>
						<?=form_dropdown('nom', @$nomodule, @$job['job_nom'] ,'class="teszt"');?>
					</div>
					<div class="jobdata" style="display:none;" id="other_nom">
							<?=form_label('Other Number of Module ', 'other_nom');?>
							<?=form_input('other_nom',@$job['other_job_nom']);?>
					</div>
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Module Type ', 'mt');?>
						<?=form_dropdown('mt',  @$module_brands, @$job['module_brand_id']);?>
					</div>
					<div class="jobdata" style="display:none;" id="other_mt">					
						<?=form_label('Other Module Type ', 'other_mt');?>
						<?=form_input('other_mt',@$job['other_module_brand']);?>
					</div>
				</div>
				
                <div class="jobrow clearfix" style="display:none;">
					<div class="jobdata mright">
						<div style="width:10px;"></div>
						<div style="display:none;" id="other_module_brand_wrap">
							<?=form_label('Other Module Brand', 'other_module_brand');?>
							<?=form_input('other_module_brand',@$job['other_module_brand']);?>
						</div>
					</div>
					
                    <div class="jobdata">
						<?=form_label('Module Power <span class="light-gray">(W)</span>', 'module_power_id');?>
						<?=form_dropdown('module_power_id', @$module_powers, @$job['module_power_id']);?>
						<div style="display:none;" id="other_module_power_wrap">
							<?=form_label('Other Module Power <span class="light-gray">(W)</span>', 'other_module_power');?>
							<?=form_input('other_module_power',@$job['other_module_power']);?>
						</div>
					</div>
				</div>

                                 
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('System Size <span class="light-gray">(kW) (Num Mods x Power)</span>', 'system_size');?>
						<?=form_input('system_size',@$job['system_size']);?>
					</div>
				</div>

				<div class="jobrow clearfix">
					<div class="jobdata">
						<span class="green-text">[inverter details]</span>
					</div>	
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Inverter Type', 'inverter_type_id');?>
						<?=form_dropdown('inverter_type_id', $inverter_types, @$job['inverter_type_id']);?>
					</div>
					<div class="jobdata" style="display:none;" id="other_inverter_type_wrap">
						<?=form_label('Other Inverter Type', 'other_inverter_type');?>
						<?=form_input('other_inverter_type',@$job['other_inverter_type']);?>
					</div>					
				</div>
				
				<div class="jobrow clearfix" style="display:none;">
					<div class="jobdata" style="display:none;">
						<?=form_label('Inverter Module Number/Name', 'inverter_brand_id');?>
						<?=form_dropdown('inverter_brand_id', $inverter_brands, @$job['inverter_brand_id']);?>
						<div style="display:none;" id="other_inverter_brand_wrap">
							<?=form_label('Other Inverter Brand', 'other_inverter_brand');?>
							<?=form_input('other_inverter_brand',@$job['other_inverter_brand']);?>
						</div>
					</div>
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Number of inverters', 'inverter_count');?>
						<?=form_input('inverter_count',@$job['inverter_count']);?>
					</div>
				</div>
                                
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Monitering System', 'ms');?>
						<?=form_dropdown('ms', @$moniter, @$job['mointer_system']);?>
					</div>
					<div class="jobdata" style="display:none;" id="other_ms">
						<?=form_label('Other Monitering System', 'other_ms');?>
						<?=form_input('other_ms',@$job['other_mointer_system']);?>
					</div>					
				</div>
				
				<div class="jobrow clearfix">
						<table class="padded-table">
							<tr>
								<td>Inverter Accessible? </td>
								<td>
								<?
								if(@$job['inverter_accessible'] == 'y') {$checked=true;} else {$checked=false;}
								echo form_radio('inverter_accessible','y',$job['inverter_accessible'],$checked)?>
								</td>
								<td>Yes</td>
								<td>
								<?
								if(@$job['inverter_accessible'] == 'n' || !$checked) {$checked=true;} else {$checked=false;}
								echo form_radio('inverter_accessible','n',$checked)?></td>
								<td>No</td>
							</tr>
						</table>
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata">
						<span class="green-text">[Electrical Meter Details]</span>
					</div>	
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Wire-run type', 'wire_run_type_id');?>
						<?=form_dropdown('wire_run_type_id', $wire_run_types, @$job['wire_run_type_id']);?>
					</div>	
					<div class="jobdata" style="display:none" id="other_wire_run_type_wrap">
						<?=form_label('Other  Wire-Run Type', 'other_wire_run_type');?>
						<?=form_input('other_wire_run_type',@$job['other_wire_run_type']);?>
					</div>
				</div>
					
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Wire Run Distance <span class="light-gray"> (Modules to Inverter ,ft)</span>', 'wire_run_distance');?>
						<?=form_dropdown('wire_run_distance', @$wirerundistance, @$job['wire_run_distance']);?>
					</div>	
					<div class="jobdata" style="display:none" id="other_wire_run_distance">
						<?=form_label('Other Wire Run Distance', 'other_wire_run_distance');?>
						<?=form_input('other_wire_run_distance',@$job['other_wire_run_distance']);?>
					</div>
				</div>
				
                <div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Electrical Meter Type', 'emt');?>
						<?=form_dropdown('emt', @$data_emt,@$job['jobs_emt']);?>
					</div>
					<div class="jobdata" style="display:none;" id="other_emt" >
						<?=form_label('Other Electrical Meter Type', 'other_emt');?>
						<?=form_input('other_emt',@$job['other_jobs_emt']);?>
					</div>
				</div>
					
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Electric Wire Source ', 'ews');?>
						<?=form_dropdown('ews',@$data_ews, @$job["electric_wire_source"]);?>
					</div>
					<div class="jobdata" style="display:none;" id="other_ews">
						<?=form_label('Other Electric Wire Source ', 'other_ews');?>
						<?=form_input('other_ews',@$job['electric_wire_source_other']);?>
					</div>				
				</div>
				
                <div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Service Panel Amperage', 'service_panel_amperage_id');?>
						<?=form_dropdown('service_panel_amperage_id', $service_panel_amperages, @$job['service_panel_amperage_id']);?>
					</div>
					<div class="jobdata" style="display:none" id="other_amperage_wrap">
						<?=form_label('Other Amperage', 'other_amperage');?>	
						<?=form_input('other_amperage',@$job['other_amperage']);?>
					</div>
				</div>
                
				<div class="jobrow clearfix">
                                    <div class="jobdata mright">
						<?=form_label('Service Panel Upgrade?', 'service_panel_upgrade');?>
						<?=form_dropdown('service_panel_upgrade', $servicepanelupgrade, @$job['servicepanelupgrade']);?>
					</div>
				    <div  class="jobdata" style="display:none" id="other_spu_wrap">
						<?=form_label('Service Panel Size? ', 'spu');?>
						<?=form_input('spu',@$job['job_spu']);?>
					</div>
				</div>
                
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Is SubPanel Needed?', 'job_wssn')?>
						<?=form_dropdown('job_wssn',$jobwssn, @$job["job_wssn"]);?>
					</div>
					<div class="jobdata" style="display:none" id="div_isnws">
						<?=form_label('SubPanel Size', 'isnws');?>
						<?=form_input('isnws', @$job["job_isnws"]);?>
					</div>
				</div>
                            <div class="jobrow clearfix" style="display:none;">
					<div class="jobdata mright">

						<?=form_label('Distance of Wire Run <span class="light-gray">(modules to pnael ,ft)</span>', 'dowr');?>
						<?=form_input('dowr','1');?>
					</div>
				</div>
                                
				<div class="jobrow clearfix">
					<div class="jobdata">
                       <?php if(!$userrole) {?> <a style="text-decoration:underline;" href="<?=base_url()?>ajax/add_plan_iframe/<?=$job['id']?>" class="facebox" >Upload Plot Plan</a><br />

                           <?php }?>
					<div class="content" id="contentplan">
					<?php if (count($plan_files) > 0): ?>
					<table cellspacing="0" class="files-table">
						<?php foreach ($plan_files as $key => $value): ?>
						<tr>
							<td><img src="/assets/images/mime-generic.gif" />&nbsp;&nbsp;<a style="vertical-align:top;text-decoration:underline" href="<?=base_url()?>admin/downloadplan/<?=$value['id']?>"><?=$value['original_filename']?></a></td>

							<td><a href="<?=base_url()?>admin/delete_planfile/<?=$value['id']?>"><img src="/assets/images/delete-icon.gif" /></a></td>
						</tr>
						<?php endforeach ?>
					</table>
					<?php else: ?>
						<div style="padding:10px; background:#fff;">
							No uploaded files.
						</div>
					<?php endif ?>
				</div>
                                        </div>
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata">	
						<span class="green-text">[Roof Details]</span>
					</div>
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Number of stories', 'stories');?>
						<?=form_dropdown('stories', $stories, @$job['stories']);?>
					</div>	
					<div class="jobdata" style="display:none" id="other_stories">
						<?=form_label('Other Stories', 'other_stories');?>
						<?=form_input('other_stories',@$job['other_stories']);?>
					</div>
				</div>
				
				<div class="jobrow clearfix" style="display:none;" id="mod_access_row">
					<table class="padded-table">
						<tr>
							<td>Long Ladder included? </td>
							<td>
						
						
							</td>
							<td>
								<?
								if(@$job['is_ladder'] == 'y') {$checked=true;} else {$checked=false;}
								echo form_radio('is_longladder','y',$job['is_ladder'],$checked)?>
								</td>
								<td>Yes</td>
								<td>
								<?
								if(@$job['is_ladder'] == 'n') {$checked=true;} else {$checked=false;}
								echo form_radio('is_longladder','n',$checked)?></td>
								<td>No</td>
						</tr>
					</table>
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Roof Type', 'roof_type');?>
						<?=form_dropdown('roof_type_id', @$roof_types, @$job['roof_type_id']);?>
					</div>
					<div class="jobdata" style="display:none" id="other_roof_type_wrap">
						<?=form_label('Other roof type', 'other_roof_type');?>
						<?=form_input('other_roof_type',@$job['other_roof_type']);?>
					</div>					
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Rafter Type', 'rafter_type_id');?>
						<?=form_dropdown('rafter_type_id', @$rafter_types, @$job['rafter_type_id']);?>
					</div>
					<div class="jobdata" style="display:none" id="other_rafter_type_wrap">
						<?=form_label('Other rafter type', 'other_rafter_type');?>
						<?=form_input('other_rafter_type',@$job['other_rafter_type']);?>
					</div>					
				</div>
				
				
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Color of roof', 'roof_color');?>
						<?=form_input('roof_color',@$job['roof_color']);?>
					</div>
					<div class="jobdata">
						<?=form_label('Distance between rafters <span class="light-gray">(ft, inches)</span>', 'rafter_distance');?>
						<?=form_input('rafter_distance',@$job['rafter_distance']);?>
					</div>
				</div>
				
				<div class="jobrow clearfix">
					<table class="padded-table">
						<tr>
							<td>Tilt kit needed? </td>
							<td>
							<?
							if(@$job['tilt_kit_needed'] == 'y') {$checked=true;} else {$checked=false;}
							echo form_radio('tilt_kit_needed','y',$checked)?>
							</td>
							<td>Yes</td>
							<td>
							<?
							if(@$job['tilt_kit_needed'] == 'n' || !$checked) {$checked=true;} else {$checked=false;}
							echo form_radio('tilt_kit_needed','n',$checked)?></td>
							<td>No</td>
						</tr>
					</table>
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Module Configuration', 'installation_type_id');?>
						<?=form_dropdown('installation_type_id', @$installation_types, @$job['installation_type_id']);?>
					</div>
					<div class="jobdata" style="display:none" id="other_installation_type_wrap">
						<?=form_label('Other installation type', 'other_installation_type');?>
						<?=form_input('other_installation_type',@$job['other_installation_type']);?>
					</div>					
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Roof Orientation', 'roof_orientation');?>
						<?=form_input('roof_orientation',@$job['roof_orientation']);?>
					</div>
					<div class="jobdata">
						<?=form_label('Roof pitch <span class="light-gray">(degrees)</span>', 'roof_pitch');?>
						<?=form_input('roof_pitch',@$job['roof_pitch']);?>
					</div>
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata">	
						<span class="green-text">[Third Party Contractor]</span>
					</div>	
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata">
						<?=form_label('Assign a Contractor', 'contractor');?>
						<?=form_multiselect('contractor_id[]',@$contractors,explode("," ,$job['contractor_id']))?>
						<?php if(!$userrole) {?><a href="/ajax/adduser_ajax/contractor" style="text-decoration:underline;" class="facebox">Add another contractor</a> <?php }?>
					</div>
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata">
						<span class="green-text">[More Details]</span>
					</div>
				</div>
				
				<div class="jobrow clearfix">
					<div class="jobdata">
						<?=form_label('Additional comments or requirements', 'comments');?>
						<?=form_textarea('comments',@$job['comments'])?>
					</div>
				</div>
			</div>
			<?=form_close()?>
			
			<div class="divider"></div>
			
			<div style="float:left;">
				<button>Back to Calendar</button>
			</div>
			
			<div style="float:right">

                               <a target="_blank"  href="<?=base_url()?>admin/createpdf/<?=$job_id?>"  style="cursor:pointer;" > <button>Create Design Sheet</button></a> <a target="_blank"  href="<?=base_url()?>admin/createpdf/<?=$job_id?>"  style="cursor:pointer;">	<button >Create Purchase Agreement</button></a>
				
				<?php if ($this->session->userdata("user_id") == $job['user_id'] or $this->session->userdata('role') == 'admin'): ?>
					<?php if (!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") == 'n')): ?>
						<button class ="savejob">Save</button>
					<?php endif; ?>
				<?php endif; ?>
			</div>
			<div class="clear-both"></div>
			
		</div>
		<div class="two-col-wide-right">
			
			<div class="progress-block">
				<div class="progress-bar">
					<div class="bar" style="width:<?=$percent_completed?>%;"></div>
				</div>
				<strong>Progress:</strong><br />
				You have completed <span class="bold"><?=$percent_completed?>%</span> of this form.
			</div>
			
			
			<div class="job-side-box">
				<div class="header">
					<a href="#">Back to Schedule</a>
					Job Summary
				</div>
				<div class="content">
					
					<strong>Salesperson: </strong><?php echo $salesman ?><br />
					<strong>Installers: </strong> <?php echo $showinstaller; ?> <br />
					<div class="divider"></div>
					
					<?php if ($this->session->userdata("role") == 'admin'): ?>
					<table width="100%">
						<tr>
							<td>Current Status: <span id="job-status-indicator"><img src="<?=base_url()?>assets/images/ajax-loader.gif" /></span></td>
							<td><div align="right">
								<?=form_dropdown('current_status',$job_statuses,$job['current_status'])?>
							</div></td>
						</tr>
					</table>
					<div class="divider"></div>
					<?php endif; ?>
					<strong>Booking Date:</strong> <?=date("F jS, Y",strtotime($job['created']))?><br />
					<?php //currenttime?>
					<span class="warning"><?php if($timediff>0 && $percent_completed<100) {?><strong>Time Left for Expiration:</strong> <?=$timediff?> hours</span><br />
                                        <?php } else if($timediff<=0 && $percent_completed<100) { ?>
                                        <strong>This job has been expired ,please contact to Administrator</strong><br />
                                        <?php }?>
					Last edited by:  <?=$editedby;?>
					<?php if ($this->session->userdata("role") == 'admin'){ ?>
                                        <br/><a href="<?=base_url()?>ajax/timeextform/<?=$job['id']?>"  class="facebox">Edit TimeLimit </a>
                                        <?php }?>
					<div class="divider"></div>
					
					<?php if ($this->session->userdata("user_id") == $job['user_id'] or $this->session->userdata('role') == 'admin'): ?>
						<?php if (!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") == 'n')): ?>
							<a href="<?=base_url()?>admin/delete_job/<?=$job['id']?>?ref=/admin/day/<?=date("Y/m/j",$job_timestamp)?>" class="delete-job-link" onclick="return confirm('Are you sure you want to delete this job?');">Delete this job</a>
						<?php endif ?>
					<?php endif ?>
				</div>
			</div>
			
			<?php if ($this->session->userdata('role') == 'admin'): ?>
				<div class="job-side-box" style="display:none;">
					<div class="header">
						Job Count Settings
					</div>
					<div class="content">
						How many job slots does this job take up?
						<div class="divider"></div>
						<select id="job_count" style="width:auto; margin:0 4px;">
							<?php for($i=0;$i<($daily_limit['limit'] + 1);$i++): ?>
							<?php if (@$job['job_count']==$i): ?>
								<option selected="selected"><?=$i?></option>
							<?php else: ?>
								<option><?=$i?></option>
							<?php endif ?>
							<?php endfor; ?>
						</select>
						slots.
						<span class="ajax-loader" style="display:none;"><img src="<?=base_url()?>assets/images/ajax-loader.gif" /></span>
					</div>
				</div>
			<?php endif ?>
			
			<div class="job-side-box">
				<div class="header">
					<?php if(!$userrole) {?><a href="<?=base_url()?>admin/customer_job/<?=$job_id?>">Edit Profile</a> <?php }?>
					Customer Summary
				</div>
				<div class="content">
					<strong>Customer:</strong><?php if(!$userrole) {?> <a href="<?=base_url()?>admin/customer_job/<?=$job_id?>"><?=$job['first_name']?> <?=$job['last_name']?></a><?php }else{?><?=$job['first_name']?> <?=$job['last_name']?><?php }?><br />
					<strong>Address:</strong><br />
					<div style="padding-left:10px;">
						<?=$job['address']?><br />
						<?=$job['city']?>, <?=$job['state']?>, <?=$job['zip_code']?>
					</div>
					<strong>Billing Address:</strong><br />
					<div style="padding-left:10px;">
						<?php if ($job['different_billing_address'] == 'y'): ?>
							<?=$job['billing_address']?><br />
							<?=$job['billing_city']?>, <?=$job['billing_state']?>, <?=$job['billing_zip_code']?>
						<?php else: ?>
							<?=$job['address']?><br />
							<?=$job['city']?>, <?=$job['state']?>, <?=$job['zip_code']?>
						<?php endif ?>
					</div>
					<div class="divider"></div>
					<strong>Other Active Jobs:</strong>
					<div style="padding-left:10px;">
						<?php foreach ($other_jobs as $key => $value): ?>
						<a href="<?=base_url()?>admin/job/<?=$value['id']?>"><?=$value['job_type']?> (<?=date("M j, Y",strtotime($value['job_date']))?>)</a><br />
						<?php endforeach ?>
						<?php if (count($other_jobs) == 0): ?>
							Customer has no other jobs
						<?php endif ?>
					</div>
				</div>
			</div>
			
			<div class="job-side-box" style="display:none;">
				<a name="job-notes"></a>
				<div class="header"> 
					<?php if(!$userrole) {?><a href="<?=base_url()?>ajax/add_job_note/<?=$job['id']?>" class="facebox">Add Note</a><?php }?>
					<a href="<?=base_url()?>ajax/view_job_notes/<?=$job['id']?>" class="facebox">View All</a>
					Job Notes
				</div>
				<div class="content">
					<?php foreach ($job_notes as $key => $value): ?>
						<strong>Posted:</strong> <?=date("F j, Y",strtotime($value['created']))?>, <strong>By:</strong> <?=$value['first_name']?> <?=$value['last_name']?><br />
						<span class="warning"><?=character_limiter($value['note'],90)?></span>
						<div class="divider"></div>
					<?php endforeach ?>
					<?php if (count($job_notes) == 0): ?>
					<div style="background:#fff; padding:10px">
						This job has no notes.
					</div>
					<?php endif ?>
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
				<?php if(!$userrole) {?>	<a href="<?=base_url()?>ajax/add_file_iframe/<?=$job['id']?>" class="facebox">Add File</a><?php }?>
					Upload Files
				</div>
				<div class="content">
					<?php if (count($job_files) > 0): ?>
					<table cellspacing="0" class="files-table">
						<?php foreach ($job_files as $key => $value): ?>
						<tr>
							<td><img src="/assets/images/mime-generic.gif" />&nbsp;&nbsp;<a style="vertical-align:top;text-decoration:underline" href="<?=base_url()?>admin/download/<?=$value['id']?>"><?=$value['original_filename']?></a></td>
							
							<td><a href="<?=base_url()?>admin/delete_file/<?=$value['id']?>"><img src="/assets/images/delete-icon.gif" /></a></td>
						</tr>
						<?php endforeach ?>
					</table>
					<?php else: ?>
						<div style="padding:10px; background:#fff;">
							No uploaded files.
						</div>
					<?php endif ?>
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
					Job Location Map
				</div>
				<?php if ($job['address'] != '' && $job['city'] != '' && $job['state'] != ''): ?>
					<div id="map_canvas" style="width: 100%; height: 200px"></div>
				<?php else: ?>
					<div style="padding:10px; background:#fff;">
						No address specified.
					</div>
				<?php endif ?>
			</div>
			
		</div>
		<div class="clear-both"></div>
	</div>
</div>

<script type="text/javascript" charset="utf-8">
    
$(document).ready(function() {
   
	var address = '<?=$job['address']?>';
	var city = '<?=$job['city']?>';
	var state = '<?=$job['state']?>';
	var jobstatus = $("select[name=current_status]").val();
	if(address != '' && city != '' && state != '')
	{
		showAddress('<?=$job['address']?>, <?=$job['city']?>, <?=$job['state']?>');
	}
        //alert();
        //$('input:radio[name=saoorf]:checked' ).val()
        if($('input:radio[name=saoorf]:checked').val()=='y' ) {$("#div_nodrf").show(); }
	if($('select[name=stories]').val() > 1) {$("#mod_access_row").show(); }
        
        if($('select[name=job_wssn]').val() == 'y') {$("#div_isnws").show();}

        if($('select[name=service_panel_upgrade]').val() == '1') {$("#other_spu_wrap").show();}

        if($('select[name=roof_type_id]').val() == 'other') {$("#other_roof_type_wrap").show();}

        if($('select[name=rafter_type_id]').val() == 'other') {$("#other_rafter_type_wrap").show();}
	if($('select[name=installation_type_id]').val() == 'other') {$("#other_installation_type_wrap").show();}
	if($('select[name=wire_run_type_id]').val() == 'other') {$("#other_wire_run_type_wrap").show();}
	if($('select[name=service_panel_amperage_id]').val() == 'other') {$("#other_amperage_wrap").show();}
	if($('select[name=inverter_type_id]').val() == 'other') {$("#other_inverter_type_wrap").show();}
	if($('select[name=inverter_brand_id]').val() == 'other') {$("#other_inverter_brand_wrap").show();}
	if($('select[name=module_power_id]').val() == 'other') {$("#other_module_power_wrap").show();}
	if($('select[name=module_brand_id]').val() == 'other') {$("#other_module_brand_wrap").show();}
	if($('select[name=nom]').val() == 'other') {$("#other_nom").show();}
        if($('select[name=mt]').val() == 'other') {$("#other_mt").show();}
        if($('select[name=ms]').val() == 'other') {$("#other_ms").show();}
        if($('select[name=emt]').val() == 'other') {$("#other_emt").show();}

        if($('select[name=ews]').val() == 'other') {$("#other_ews").show();}
        if($('select[name=wire_run_distance]').val() == 'other') {$("#other_wire_run_distance").show();}
	if('<?=$job['stories']?>' > 1)
	{
		$("#mod_access_row").show();
	}
        $('select[name=job_wssn]').change(function(){
            var wssn = $(this).val();
            if(wssn=="y"){
               $("#div_isnws").show();
            }
        });

        $('input:radio[name=saoorf]').change(function(){
            if($(this).val()=='y')
            {
                $("#div_nodrf").show();
            }
            if($(this).val()=='n')
            {
                $("#div_nodrf").hide();
            }
        });
        $('select[name=service_panel_upgrade]').change(function() {
		if($(this).val() == '1')
			$("#other_spu_wrap").show();
		else
			$("#other_spu_wrap").hide();
	});
        $('select[name=wire_run_distance]').change(function() {
		if($(this).val() == 'other')
			$("#other_wire_run_distance").show();
		else
			$("#other_wire_run_distance").hide();
	});
        $('select[name=ews]').change(function() {
		if($(this).val() == 'other')
			$("#other_ews").show();
		else
			$("#other_ews").hide();
	});

        $('select[name=emt]').change(function() {
		if($(this).val() == 'other')
			$("#other_emt").show();
		else
			$("#other_emt").hide();
	});
        
	$('select[name=stories]').change(function() {
		if($(this).val() > 1)
			$("#mod_access_row").show();
		else
			$("#mod_access_row").hide();
	});
	
	$('select[name=module_brand_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_module_brand_wrap").show();
		else
			$("#other_module_brand_wrap").hide();
	});
	
	$('select[name=ms]').change(function() {
		if($(this).val() == 'other')
			$("#other_ms").show();
		else
			$("#other_ms").hide();
	});
        $('select[name=nom]').change(function() {
               var text = $('select[name=mt] option:selected').text();
               var text1 = text.split("MLU");
                if(text1){
                    text2 = parseInt(text1[1]);
                    var nom =parseInt($('select[name=nom]').val());
                    if(nom )   text2 = (text2*nom)/1000;
                    if(text2)
                    $('input[name=system_size]').val(text2)
                    else
                     $('input[name=system_size]').val("0")
                }
		if($(this).val() == 'other')
			$("#other_nom").show();
		else
			$("#other_nom").hide();
	});
        $('select[name=mt]').change(function() {
             var text = $('select[name=mt] option:selected').text();
             var text1 = text.split("MLU");
                if(text1){
                    text2 = parseInt(text1[1]);
                    var nom =parseInt($('select[name=nom]').val());
                    if(nom )   text2 = (text2*nom)/1000;
                    if(text2)
                    $('input[name=system_size]').val(text2)
                    else
                     $('input[name=system_size]').val("0")
                }
		if($(this).val() == 'other')
			$("#other_mt").show();
		else
			$("#other_mt").hide();
	});
        $('select[name=module_power_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_module_power_wrap").show();
		else
			$("#other_module_power_wrap").hide();
	});
	
	$('select[name=service_panel_amperage_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_amperage_wrap").show();
		else
			$("#other_amperage_wrap").hide();
	});
	
	$('select[name=inverter_type_id]').change(function() {
                var text = $('select[name=inverter_type_id] option:selected').text();
                var text1 = text.indexOf("Microinverter");
		if(text1){
                    var nom =parseInt($('select[name=nom]').val());
                    if(nom)   
                       $('input[name=inverter_count]').val(nom)
                    else
                       $('input[name=inverter_count]').val("0")
                    
                }
                if($(this).val() == 'other')
			$("#other_inverter_type_wrap").show();
		else
			$("#other_inverter_type_wrap").hide();
	});
	
	$('select[name=inverter_brand_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_inverter_brand_wrap").show();
		else
			$("#other_inverter_brand_wrap").hide();
	});
	
	$('select[name=wire_run_type_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_wire_run_type_wrap").show();
		else
			$("#other_wire_run_type_wrap").hide();
	});
	
	$('select[name=roof_type_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_roof_type_wrap").show();
		else
			$("#other_roof_type_wrap").hide();
	});
	
	$('select[name=rafter_type_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_rafter_type_wrap").show();
		else
			$("#other_rafter_type_wrap").hide();
	});
	
	$('select[name=installation_type_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_installation_type_wrap").show();
		else
			$("#other_installation_type_wrap").hide();
	});
	
	$('select[name=current_status]').change(function() {
		if(window.confirm("Are you sure?")){
		status = $(this).val();
                jobstatus =status;
		$.ajax({
		type: "POST",
		url: "<?=base_url()?>ajax/update_job_status",
		data: "job_id="+<?=$job_id?>+"&status="+status,
		dataType: "json",
		beforeSend : function() {
			$("#job-status-indicator").show();
		},
		success: function(json) {
			if(json.success == true)
			{
				// location.href = '/admin/job/' + job_id;
				$("#job-status-indicator").fadeOut('slow');
			}
			else
			{
				alert(json.msg);
			}
		  }
		});
                 } else{

                 $(this+'option[value="'+jobstatus+'"]').attr('selected', 'selected');
                }
	});
	
	var year = '<?=date("Y",$job_timestamp)?>';
	var day = '<?=date("d",$job_timestamp)?>';
	var month = '<?=date("m",$job_timestamp)?>';

	$('#job_count').change(function() {
		// update day's service call job count
		$.ajax({
			type: "POST",
			url: "<?=base_url()?>ajax/update_job_count",
			data: 'month='+month+'&year='+year+'&day='+day+'&job_count='+$(this).val(),
			beforeSend : function() {
				$(".ajax-loader").show();
			},
			dataType: "json",
			success: function(json) {
				$(".ajax-loader").fadeOut();
			}
		});
	});
       validate_requiredfield =function(){
         $('div').removeClass("red");
         var isvalid=true;
         var nos_valid = $("input[name=nos]").val();
          if (!nos_valid){
              $("input[name=nos]").addClass('red');
               isvalid = false;
          }


          var nom_valid = $("select[name=nom]").val();
          if (!nom_valid || nom_valid=="0" ){
              $("select[name=nom]").addClass('red');
               isvalid = false;
          } else if(nom_valid=='other'){
             var other_nom_valid = $("input[name=other_nom]").val();
              if (!other_nom_valid){
                $("input[name=other_nom]").addClass('red');
                isvalid= false;
              }

          }

          var nom_valid = $("select[name=service_panel_upgrade]").val();
          if (!nom_valid || nom_valid=="0" ){
              $("select[name=nom]").addClass('red');
               isvalid = false;
          } else if(nom_valid=='1'){
             var other_nom_valid = $("input[name=spu]").val();
              if (!other_nom_valid || other_nom_valid=="0"){
                $("input[name=spu]").addClass('red');
                isvalid= false;
              }

          }

           if($('input:radio[name=saoorf]:checked').val()=='y' ) {
                var other_nodrf = $("input[name=nodrf]").val();
                if (!other_nodrf){
                $("input[name=nodrf]").addClass('red');
                isvalid= false;
              }
           }
          var mt_valid = $("select[name=mt]").val();
          
          if (!mt_valid || mt_valid=="0" ){
              $("select[name=mt]").addClass('red');
              
              isvalid = false;
          } else if(mt_valid=='other'){
             var other_mt_valid = $("input[name=other_mt]").val();
              if (!other_mt_valid){
                $("input[name=other_mt]").addClass('red');
                isvalid= false;
              }

          }
          var system_size_valid = $("input[name=system_size]").val();
          if (!system_size_valid){
              $("input[name=system_size]").addClass('red');
               isvalid = false;
          }

          var inverter_type_id_valid = $("select[name=inverter_type_id]").val();
          if (!inverter_type_id_valid ||inverter_type_id_valid=="0" ){
              $("select[name=inverter_type_id]").addClass('red');
               isvalid = false;
          } else if(inverter_type_id_valid=='other'){
             var other_inverter_type_valid = $("input[name=other_inverter_type]").val();
              if (!other_inverter_type_valid){
                $("input[name=other_inverter_type]").addClass('red');
                isvalid= false;
              }

          }
           var inverter_count_valid = $("input[name=inverter_count]").val();
          if (!inverter_count_valid){
              $("input[name=inverter_count]").addClass('red');
               isvalid = false;
          }

          var ms_valid = $("select[name=ms]").val();
          if (!ms_valid || ms_valid=="0" ){
              $("select[name=ms]").addClass('red');
               isvalid = false;
          }

          var wire_run_type_id_valid = $("select[name=wire_run_type_id]").val();
          if (!wire_run_type_id_valid || wire_run_type_id_valid=="0" ){
              $("select[name=wire_run_type_id]").addClass('red');
               isvalid = false;
          } else if(wire_run_type_id_valid=='other'){
             var other_wire_run_type_valid = $("input[name=other_wire_run_type]").val();
              if (!other_wire_run_type_valid){
                $("input[name=other_wire_run_type]").addClass('red');
                isvalid= false;
              }

          }

          var wire_run_distance_valid = $("select[name=wire_run_distance]").val();
          if (!wire_run_distance_valid || wire_run_distance_valid=="0" ){
              $("select[name=wire_run_distance]").addClass('red');
               isvalid = false;
          } else if(wire_run_distance_valid=='other'){
             var other_wire_run_distance_valid = $("input[name=other_wire_run_distance]").val();
              if (!other_wire_run_distance_valid){
                $("input[name=other_wire_run_distance]").addClass('red');
                isvalid= false;
              }

          }

          var emt_valid = $("select[name=emt]").val();
          if (!emt_valid || emt_valid=="0" ){
              $("select[name=emt]").addClass('red');
               isvalid = false;
          } else if(emt_valid=='other'){
             var other_emt_valid = $("input[name=other_emt]").val();
              if (!other_emt_valid){
                $("input[name=other_emt]").addClass('red');
                isvalid= false;
              }

          }

          var ews_valid = $("select[name=ews]").val();
          if (!ews_valid || ews_valid=="0" ){
              $("select[name=ews]").addClass('red');
               isvalid = false;
          } else if(ews_valid=='other'){
             var other_ews_valid = $("input[name=other_ews]").val();
              if (!other_ews_valid){
                $("input[name=other_ews]").addClass('red');
                isvalid= false;
              }

          }

          var service_panel_amperage_id_valid = $("select[name=service_panel_amperage_id]").val();
          if (!service_panel_amperage_id_valid || service_panel_amperage_id_valid=="0" ){
              $("select[name=service_panel_amperage_id]").addClass('red');
               isvalid = false;
          } else if( service_panel_amperage_id_valid=='other'){
             var other_amperage_valid = $("input[name=other_amperage]").val();
              if (!other_amperage_valid){
                $("input[name=other_amperage]").addClass('red');
                isvalid= false;
              }

          }
          var isnws_valid = $("input[name=isnws]").val();
          if (!isnws_valid){
              if($('select[name=job_wssn]').val() == 'y')
              $("input[name=isnws]").addClass('red');
             else {
                 $("input[name=isnws]").val(1);
             }
               isvalid = false;
          }
          var dowr_valid = $("input[name=dowr]").val();
          if (!dowr_valid){
              $("input[name=dowr]").addClass('red');
               isvalid = false;
          }
          
          //if($(".jobdata .content img").length<=0){
             // $(".jobdata .content ").addClass('red');
             // isvalid = false;
          //}

          var stories_valid = $("select[name=stories]").val();
          if (!stories_valid || stories_valid=="0" ){
              $("select[name=stories]").addClass('red');
               isvalid = false;
          }

           var roof_type_id_valid = $("select[name=roof_type_id]").val();
          if (!roof_type_id_valid || roof_type_id_valid=="0" ){
              $("select[name=roof_type_id]").addClass('red');
               isvalid = false;
          } else if(roof_type_id_valid=='other'){
             var other_roof_type_valid = $("input[name=other_roof_type]").val();
              if (!other_roof_type_valid){
                $("input[name=other_roof_type]").addClass('red');
                isvalid= false;
              }

          }

           var rafter_type_id_valid = $("select[name=rafter_type_id]").val();
          if (!rafter_type_id_valid || rafter_type_id_valid=="0" ){
              $("select[name=rafter_type_id_id]").addClass('red');
               isvalid = false;
          } else if(rafter_type_id_valid=='other'){
             var other_rafter_type_valid = $("input[name=other_rafter_type]").val();
              if (!other_rafter_type_valid){
                $("input[name=other_rafter_type]").addClass('red');
                isvalid= false;
              }

          }

          var roof_color_valid = $("input[name=roof_color]").val();
          if (! roof_color_valid){
              $("input[name=roof_color]").addClass('red');
               isvalid = false;
          }

          var rafter_distance_valid = $("input[name=rafter_distance]").val();
          if (!rafter_distance_valid){
              $("input[name=rafter_distance]").addClass('red');
               isvalid = false;
          }
          var roof_orientation_valid = $("input[name=roof_orientation]").val();
          if (!roof_orientation_valid){
              $("input[name=roof_orientation]").addClass('red');
               isvalid = false;
          }
          var roof_pitch_valid = $("input[name=roof_pitch]").val();
          if (!roof_pitch_valid){
              $("input[name=roof_pitch]").addClass('red');
               isvalid = false;
          }

           var installation_type_id_valid = $("select[name=installation_type_id]").val();
          if (!installation_type_id_valid || installation_type_id_valid=="0" ){
              $("select[name=installation_type_id]").addClass('red');
               isvalid = false;
          } else if(installation_type_id_valid=='other'){
             var other_installation_type_valid = $("input[name=other_installation_type]").val();
              if (!other_installation_type_valid){
                $("input[name=other_installation_type]").addClass('red');
                isvalid= false;
              }

          }

          return isvalid;
       }

        $(".savejob").click( function(){
          
           $('#form1').submit();
           });

  <?php if(@$savedata){
           echo "var  valid =  validate_requiredfield();";
           echo " if(!valid) { $.facebox('<h3>Your Changes Have Been Saved,<br/>Please filled the highlighted field before job expire.</h3><br /><button class=\"cancel-facebox\" >OK</button>');}else{";
            echo "$.facebox('<h3>Your Changes Have Been Saved.</h3><br /><button class=\"cancel-facebox\" >OK</button>'); }";
        }

      ?>
});

function print_url(url)
{
 location=url;
 print();
 }


</script>