<!--
Customer Detail Page

- Active Jobs widget
    - functionality as seen in design

- Customer Notes widget
    - ability for user to add simple notes/progress on job with date-stamp

- Upload files widget
   - ability for users to upload/add/delete files to Job

- Job Location Map
   - Google Map of job address

-->

<div style="position:relative;">
	<div class="page-top-buttons">
		<button>Print</button>
		<button>Save</button>
	</div>
</div>

<h1>Customer Details</h1>
<p class="bread-crumbs"><a href="<?=base_url()?>">Home</a> / <a href="<?=base_url()?>admin/myjobs">My Jobs</a> / <?=$customer['first_name']?> <?=$customer['last_name']?></p>
<br />

<div class="generic-page-block">
	<div class="green-header">
		<span class="dark-green">Customer Name:</span> <?=$customer['first_name']?> <?=$customer['last_name']?>
		<span class="dark-green">Customer Since:</span> <?=date("F jS, Y",strtotime($customer['created']))?>
	</div>
	<div class="content">
		<div class="two-col-wide-left">
			<div class="content-header">Customer Information</div>
			<p>Please fill out the fields below for your Customer's Information.</p>
			<br />
			
			<?php if (@$duplicate_addresses): ?>
			<div class="form-errors">
				<strong>Duplicate customers found for this address:</strong><br />
				<?php foreach ($duplicate_customers as $key => $value): ?>
				<a href="<?=base_url()?>admin/customer/<?=$value['id']?>"><?=$value['first_name']?> <?=$value['last_name']?></a><br />
				<?php endforeach ?>
			</div>
			<?php endif ?>
			
			<?=form_open('admin/customer/'.$customer_id,array('name' => 'form1', 'id' => 'form1'));?>
			<?=form_hidden('dosubmit','true')?>
			<table id="two-col-form" cellspacing="0" cellpadding="0" width="100%">
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Customer Contact Details]</span><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('First Name', 'first_name');?>
						<?=form_input('first_name',@$customer['first_name']);?>
						
						<?=form_label('Home Phone', 'home_phone');?>
						<?=form_input('home_phone',@$customer['home_phone']);?>
						
						<?=form_label('Email', 'email');?>
						<?=form_input('email',@$customer['email']);?>
					</td>
					<td>
						<div style="width:10px;"></div>
					</td>
					<td>
						<?=form_label('Last Name', 'last_name');?>
						<?=form_input('last_name',@$customer['last_name']);?>
						
						<?=form_label('Secondary Phone', 'secondary_phone');?>
						<?=form_input('secondary_phone',@$customer['secondary_phone']);?>
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Customer Address Details]</span><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Address', 'address');?>
						<?=form_input('address',@$customer['address']);?>
						
						<?=form_label('State', 'state');?>
						<?=form_dropdown('state',$states,$customer['state'])?>
					</td>
					<td></td>
					<td>
						<?=form_label('City', 'city');?>
						<?=form_input('city',@$customer['city']);?>
						
						<?=form_label('Zip Code', 'zip_code');?>
						<?=form_input('zip_code',@$customer['zip_code']);?>
					</td>
				</tr>
				<tr>
					<td colsan="3">
						<p><a href="#" class="underline">Add a different billing address</a></p>
						<br />
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Customer Household Details]</span><br />
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<?=form_label('Household Type', 'household_type_id');?>
						<?=form_dropdown('household_type_id',$household_types,$customer['household_type_id'])?>
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Neighborhood', 'neighborhood');?>
						<?=form_input('neighborhood',@$customer['neighborhood']);?>
						
						<?=form_label('Number of household members', 'household_members');?>
						<?=form_input('household_members',@$customer['household_members']);?>
						
						<?=form_label('Sun Zone', 'sun_zone');?>
						<?=form_input('sun_zone',@$customer['sun_zone']);?>
						
						<?=form_label('HECO Meter #', 'heco_meter_number');?>
						<?=form_input('heco_meter_number',@$customer['heco_meter_number']);?>
					</td>
					<td></td>
					<td>
						<?=form_label('Association', 'association');?>
						<?=form_input('association',@$customer['association']);?>
						
						<?=form_label('Average Monthly Electric Bill', 'avg_electric_bill');?>
						<?=form_input('avg_electric_bill',@$customer['avg_electric_bill']);?>
						
						<?=form_label('HECO ACCT #', 'heco_account_number');?>
						<?=form_input('heco_account_number',@$customer['heco_account_number']);?>
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[More Details]</span><br />
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<?=form_label('Additional comments or requirements', 'comments');?>
						<?=form_textarea('comments',@$customer['comments'])?>
					</td>
				</tr>
			</table>
			<?=form_close()?>
			
			<br />
			<div class="divider"></div>
			
			<div style="float:left;">
				<button onclick="location.href='<?=base_url()?>admin/jobschedule';">Back to Calendar</button>
			</div>
			
			<div style="float:right">
				<button>Create Purchase Agreement</button>
				<button>Print</button>
				<button onclick="document.form1.submit()">Save</button>
			</div>
			<div class="clear-both"></div>
			
		</div>
		<div class="two-col-wide-right">
			<!--
			<div class="progress-block">
				<div class="progress-bar">
					<div class="bar" style="width:75%;"></div>
				</div>
				<strong>Progress:</strong><br />
				You have completed <span class="bold">75%</span> of this form.
			</div>
			-->
			
			<div class="job-side-box">
				<div class="header">
					<a href="#" onclick="$.get('<?=base_url()?>ajax/choose_reserve_date?customer_id=<?=$customer_id?>',function(data) {$.facebox(data);});">Add a new job</a>
					Active Jobs
				</div>
				<div class="content">
					<?php foreach ($jobs as $key => $value): ?>
					<a href="<?=base_url()?>admin/job/<?=$value['id']?>" class="underline"><?=$value['job_type']?></a><br />
					<!--<strong>Sales Person:</strong> Akio Takasaki<br />-->
					<strong>Job Installation Date:</strong> <?=date("l, F j, Y",strtotime($value['job_date']))?><br />
					<strong>Booking Date:</strong> <?=date("l, F j, Y",strtotime($value['created']))?><br />
					<strong>Status:</strong> <?=$value['current_status']?><br />
					<!--<span class="warning"><strong>Time Left for Expiration:</strong> 14 hours</span><br />-->
					<!--<em>Last edited by: Akio Takasaki</em>-->

					<div class="divider"></div>
					<?php endforeach ?>
					
					<?php if (count($jobs) == 0): ?>
					<div style="background:#fff; padding:10px">
						This customer has no booked jobs.
					</div>
					<?php else: ?>
						<!--<a href="<?=base_url()?>admin/customer_jobs/<?=$customer_id?>" class="underline">View all customer's active jobs</a>-->
					<?php endif; ?>
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
					<a href="#">Add Note</a>
					Customer Notes
				</div>
				<div class="content">
					<?php foreach ($notes as $key => $value): ?>
						<strong>Posted:</strong> <?=date("F j, Y",strtotime($value['created']))?>, <strong>By:</strong> <?=$value['first_name']?> <?=$value['last_name']?><br />
						<span class="warning">
							<?=character_limiter($value['note'],90)?>
						</span>
						<div class="divider"></div>
					<?php endforeach ?>
					<?php if (count($notes) == 0): ?>
					<div style="background:#fff; padding:10px">
						This user has no job notes.
					</div>
					<?php endif ?>
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
					<!--<a href="<?=base_url()?>ajax/add_file_iframe/<?=$job['id']?>" class="facebox">Add File</a>-->
					Uploaded Files
				</div>
				<div class="content">
					<?php if (count($customer_files) > 0): ?>
					<table cellspacing="0" class="files-table">
						<?php foreach ($customer_files as $key => $value): ?>
						<tr>
							<td><img src="/assets/images/mime-generic.gif" /></td>
							<td><a href="<?=base_url()?>admin/download/<?=$value['id']?>"><?=$value['original_filename']?></a></td>
							<td><a href="<?=base_url()?>admin/delete_file/<?=$value['id']?>"><img src="/assets/images/delete-icon.gif" /></a></td>
						</tr>
						<?php endforeach ?>
					</table>
					<?php else: ?>
						<div style="padding:10px; background:#fff;">
							No uploaded files.
						</div>
					<?php endif ?>
				</div>
			</div>
			
			<div class="job-side-box">
				<div class="header">
					Job Location Map
				</div>
				<?php if ($customer['address'] != '' && $customer['city'] != '' && $customer['state'] != ''): ?>
					<div id="map_canvas" style="width: 100%; height: 200px"></div>
				<?php else: ?>
					<div style="padding:10px; background:#fff;">
						No address specified.
					</div>
				<?php endif ?>
			</div>
			
		</div>
		<div class="clear-both"></div>
	</div>
</div>

<script type="text/javascript" charset="utf-8">
$(document).ready(function() {
	var address = '<?=$customer['address']?>';
	var city = '<?=$customer['city']?>';
	var state = '<?=$customer['state']?>';
	
	if(address != '' && city != '' && state != '')
	{
		showAddress('<?=$customer['address']?>, <?=$customer['city']?>, <?=$customer['state']?>');
	}
});
</script>