<!--
Job Calendar - Day View details page

- Ability to view all jobs scheduled for the day
- Ability to view status of the day ie, 'FULL' means no more jobs available

- Service Call Settings widget
    - Ability for admin-user only to set "Number of jobs" that the Service Calls will take up for that day. i.e. a Service Call may take up one job slot, or two job slots, etc.

- Job Notes widget
    - ability for user to add simple notes/progress on job with date-stamp
-->

<div style="position:relative;">
	<div class="page-top-buttons">
		<button>Print Summary</button>
		<?php if (!($this->session->userdata("role") == 'installer') && $this->session->userdata("installer_permissions") == 'n'): ?>
			<button onclick="$.get('<?=base_url()?>ajax/reserve_job/<?=$year?>/<?=$month?>/<?=$day?>',function(data) {$.facebox(data);});">Reserve a new job</button>
		<?php endif ?>
	</div>
</div>

<h1>Day View</h1>
<p><a href="<?=base_url()?>">Home</a> / <a href="<?=base_url()?>admin/jobschedule">Job Calendar</a> / <?=date("F jS, Y",$day_timestamp)?></p>
<br />

<div class="generic-page-block">
	<div class="green-header">
		<span class="dark-green">Day view for:</span> <?=date("F jS, Y",$day_timestamp)?>
	</div>
	<div class="content">
		<div class="two-col-wide-left">
			<div class="content-header">Here's what's been booked for today</div>
			<p>See below for what's been booked for <?=date("F jS, Y",$day_timestamp)?>. You can also EDIT each job using the Edit button to the right of each listing. 
				<a href="/admin/jobschedule" class="underline">Return to Calendar</a></p>
			<br />
			
			<?php if (count($pv_jobs) == 0 && count($swh_jobs) == 0 && count($saf_jobs) == 0 && count($service_calls) == 0): ?>
			<div style="padding:20px; background:#f4f4f4; border:1px solid #ddd; text-align:center; font-size:14px; color:#666">
				You don't have any jobs booked for this day.
			</div><br /><br />
			<?php endif; ?>
			
			<?php if (count($pv_jobs) > 0): ?>
			<p>Photovoltaic Systems</p>
			<?php foreach ($pv_jobs as $key => $value): 
			if($value['hex'] == '') {$value['hex'] = '7DBB4C';}
			if($value['custom_hex'] != '') {$value['hex'] = $value['custom_hex'];}
			?>
			<div style="padding:10px; background:#<?=$value['hex']?>; color:#fff; position:relative;">
				<?php if($editjob) {?><a href="<?=base_url()?>admin/job_comment/<?=$value['id']?>" class="edit-link">EDIT</a><?php } else {?>
				<a href="<?=base_url()?>admin/job/<?=$value['id']?>" class="edit-link">View</a>
                                    <?php } ?>
                                <?php if($this->session->userdata('role') == 'admin'){?>| <a target="_blank"  href="<?=base_url()?>admin/createpdfpartjob/<?=$job_id?>"  style="cursor:pointer;" > Export Parts List</a><?}?>
                                    <?=$value['first_name']?> <?=$value['last_name']?>
			</div>
			<div style="padding:10px; border:1px solid #<?=$value['hex']?>;">
				<table cellspacing="0" class="day-job-table">
					<tr>
						<th>Address</th>
						<th>Job Type</th>
                                                <th>PL</th>
						<th>Status</th>
						<th>Salesperson</th>
                                                <th>No. Installers</th
					</tr>
					<tr>
						<td>
							<?php
							$address = $value['address'].", ".$value['city'].", ".$value['state'];
							?>
							<?=character_limiter($address,30)?>
						</td>
						<td><?=$value['job_type']?></td>
                                                <td>
                                                <?
                                                $output_plcompletd = "";
                                                if($value['pl_job_id']!=0){
                                                if($value['pl_completed']==1){
                                                    $output_plcompletd .= "Yes";
                                                } else {
                                                if($this->session->userdata('role')=='admin'){
                                                    $output_plcompletd .= "<div id='plcompleted_a_".$value['job_pid']."'><a href='javascript:void(0);'  onclick='complete_pl(".$value['job_pid'].");'>No</a></div>";
                                                } else {
                                                    $output_plcompletd .= "/No";
                                                }
                                                }

                                                } else {
                                                    $output_plcompletd = "NA";
                                                }

                                                echo $output_plcompletd;
                                                ?>
                                                </td>
						<td><?=$value['current_status']?></td>
						<td><?=$value['user_first_name']?> <?=$value['user_last_name']?></td>
                                                <td><?=$value['no_installer_allocated']?> </td>
					</tr>
				</table>
			</div>
			<?php endforeach ?>
			<br />
			<?php endif ?>
			
			<?php if (count($swh_jobs) > 0): ?>
			<p>Solar Water Heating</p>
			<?php foreach ($swh_jobs as $key => $value): 
			if($value['hex'] == '') {$value['hex'] = '7DBB4C';}
			if($value['custom_hex'] != '') {$value['hex'] = $value['custom_hex'];}
			?>
			<div style="padding:10px; background:#<?=$value['hex']?>; color:#fff; position:relative;">
				<?php if($editjob) {?><a href="<?=base_url()?>admin/job/<?=$value['id']?>" class="edit-link">EDIT</a> <?php } else {?>
                                <a href="<?=base_url()?>admin/job/<?=$value['id']?>" class="edit-link">View</a>
                                <?php }?>
				<?=$value['first_name']?> <?=$value['last_name']?>
			</div>
			<div style="padding:10px; border:1px solid #<?=$value['hex']?>;">
				<table cellspacing="0" class="day-job-table">
					<tr>
						<th>Address</th>
						<th>Job Type</th>
                                                <th>PL</th>
						<th>Status</th>
						<th>Salesperson</th>
                                               <th>No. Installers</th
					</tr>
					<tr>
						<td>
							<?php
							$address = $value['address'].", ".$value['city'].", ".$value['state'];
							?>
							<?=character_limiter($address,30)?>
						</td>
						<td><?=$value['job_type']?></td>
						<td><?=$value['current_status']?></td>
                                                <td>
                                                <?
                                                $output_plcompletd = "";
                                                if($value['pl_job_id']!=0){
                                                if($value['pl_completed']==1){
                                                    $output_plcompletd .= "Yes";
                                                } else {
                                                if($this->session->userdata('role')=='admin'){
                                                    $output_plcompletd .= "<div id='plcompleted_a_".$value['id']."'><a href='javascript:void(0);'  onclick='complete_pl(".$value['job_pid'].");'>No</a></div>";
                                                } else {
                                                    $output_plcompletd .= "/No";
                                                }
                                                }} else {
                                                    $output_plcompletd = "NA";
                                                }
                                                echo $output_plcompletd;
                                                ?>
                                                </td>
						<td><?=$value['user_first_name']?> <?=$value['user_last_name']?></td>
                                                <td><?=$value['no_installer_allocated']?> </td>
					</tr>
				</table>
			</div>
			<?php endforeach ?>
			<br />
			<?php endif ?>
			
			<?php if (count($saf_jobs) > 0): ?>
			<p>Solar Attic Fan</p>
			<?php foreach ($saf_jobs as $key => $value): 
			if($value['hex'] == '') {$value['hex'] = '7DBB4C';}
			if($value['custom_hex'] != '') {$value['hex'] = $value['custom_hex'];}
			?>
			<div style="padding:10px; background:#<?=$value['hex']?>; color:#fff; position:relative">
				<?php if($editjob) {?><a href="<?=base_url()?>admin/job/<?=$value['id']?>" class="edit-link">EDIT</a> <?php } else {?>
                                <a href="<?=base_url()?>admin/job/<?=$value['id']?>" class="edit-link">View</a>
                                <?php }?>
				<?=$value['first_name']?> <?=$value['last_name']?>
			</div>
			<div style="padding:10px; border:1px solid #<?=$value['hex']?>;">
				<table cellspacing="0" class="day-job-table">
					<tr>
						<th>Address</th>
						<th>Job Type</th>
						<th>Status</th>
						<th>Salesperson</th>
					</tr>
					<tr>
						<td>
							<?php
							$address = $value['address'].", ".$value['city'].", ".$value['state'];
							?>
							<?=character_limiter($address,30)?>
						</td>
						<td><?=$value['job_type']?></td>
						<td><?=$value['current_status']?></td>
						<td><?=$value['user_first_name']?> <?=$value['user_last_name']?></td>
					</tr>
				</table>
			</div>
			<?php endforeach ?>
			<br />
			<?php endif ?>
                        <?php if (count($pl_jobs) > 0): ?>
			<p>PreLag Job</p>
			<?php foreach ($pl_jobs as $key => $value): 
			if($value['hex'] == '') {$value['hex'] = '7DBB4C';}
			if($value['custom_hex'] != '') {$value['hex'] = $value['custom_hex'];}
			?>
			<div style="padding:10px; background:#<?=$value['hex']?>; color:#fff; position:relative">
				<?php if($editjob) {?><a href="<?=base_url()?>admin/job/<?=$value['id']?>" class="edit-link">EDIT</a> <?php } else {?>
                                <a href="<?=base_url()?>admin/job/<?=$value['id']?>" class="edit-link">View</a>
                                <?php }?>
				<?=$value['first_name']?> <?=$value['last_name']?>
			</div>
			<div style="padding:10px; border:1px solid #<?=$value['hex']?>;">
				<table cellspacing="0" class="day-job-table">
					<tr>
						<th>Address</th>
						<th>Job Type</th>
						<th>Status</th>
						<th>Salesperson</th>
					</tr>
					<tr>
						<td>
							<?php
							$address = $value['address'].", ".$value['city'].", ".$value['state'];
							?>
							<?=character_limiter($address,30)?>
						</td>
						<td><?=$value['job_type']?></td>
						<td><?=$value['current_status']?></td>
						<td><?=$value['user_first_name']?> <?=$value['user_last_name']?></td>
					</tr>
				</table>
			</div>
			<?php endforeach ?>
			<br />
			<?php endif ?>

                        <?php if (count($pm_jobs) > 0): ?>
			<p>Premeasurr Job</p>
			<?php foreach ($pm_jobs as $key => $value):
			if($value['hex'] == '') {$value['hex'] = '7DBB4C';}
			if($value['custom_hex'] != '') {$value['hex'] = $value['custom_hex'];}
			?>
			<div style="padding:10px; background:#<?=$value['hex']?>; color:#fff; position:relative">
				<?php if($editjob) {?><a href="<?=base_url()?>admin/job/<?=$value['id']?>" class="edit-link">EDIT</a> <?php } else {?>
                                <a href="<?=base_url()?>admin/job/<?=$value['id']?>" class="edit-link">View</a>
                                <?php }?>
				<?=$value['first_name']?> <?=$value['last_name']?>
			</div>
			<div style="padding:10px; border:1px solid #<?=$value['hex']?>;">
				<table cellspacing="0" class="day-job-table">
					<tr>
						<th>Address</th>
						<th>Job Type</th>
						<th>Status</th>
						<th>Salesperson</th>
					</tr>
					<tr>
						<td>
							<?php
							$address = $value['address'].", ".$value['city'].", ".$value['state'];
							?>
							<?=character_limiter($address,30)?>
						</td>
						<td><?=$value['job_type']?></td>
						<td><?=$value['current_status']?></td>
						<td><?=$value['user_first_name']?> <?=$value['user_last_name']?></td>
					</tr>
				</table>
			</div>
			<?php endforeach ?>
			<br />
			<?php endif ?>

                        
			
			<?php if (count($service_calls) > 0): ?>
			<p>Service Call</p>
			<?php foreach ($service_calls as $key => $value):
			if($value['hex'] == '') {$value['hex'] = '7DBB4C';}
			if($value['custom_hex'] != '') {$value['hex'] = $value['custom_hex'];}
			?>
			<div style="padding:10px; background:#<?=$value['hex']?>; color:#fff; position:relative;">
				<?php if($editjob) {?><a href="<?=base_url()?>admin/job_comment/<?=$value['id']?>" class="edit-link">EDIT</a><?php } else {?>
				<a href="<?=base_url()?>admin/job/<?=$value['id']?>" class="edit-link">View</a>
                                    <?php } ?>
                                    <?=$value['first_name']?> <?=$value['last_name']?>
			</div>
			<div style="padding:10px; border:1px solid #<?=$value['hex']?>;">
				<table cellspacing="0" class="day-job-table">
					<tr>
						<th>Address</th>
						<th>Job Type</th>
						<th>Status</th>
						<th>Salesperson</th>
                                                <th>No. Installers</th
					</tr>
					<tr>
						<td>
							<?php
							$address = $value['address'].", ".$value['city'].", ".$value['state'];
							?>
							<?=character_limiter($address,30)?>
						</td>
						<td><?=$value['job_type']?></td>
						<td><?=$value['current_status']?></td>
						<td><?=$value['user_first_name']?> <?=$value['user_last_name']?></td>
                                                <td><?=$value['no_installer_allocated']?> </td>
					</tr>
				</table>
			</div>
			<?php endforeach ?>
			<br />
			<?php endif ?>
			
			<div style="float:left;">
				<button onclick="location.href='<?=base_url()?>/admin/jobschedule'">Back to Calendar</button>
			</div>
			
			<div style="float:right">
				<?php if (!($this->session->userdata("role") == 'installer') && $this->session->userdata("installer_permissions") == 'n'): ?>
				<button onclick="$.get('<?=base_url()?>/ajax/reserve_job/<?=$year?>/<?=$month?>/<?=$day?>',function(data) {$.facebox(data);});">Reserve a new job</button>
				<?php endif; ?>
			</div>
			<div class="clear-both"></div>
			
		</div>
		<div class="two-col-wide-right">
			<div class="gray-block">
				<strong>Available Installers for today:
				<span >
				<?php if ($installeravail) { ?>
					<span><?=$installeravail?></span>
                                                </span>
				</strong><br />
				<?php } else{  ?>
                                        <span>None</span>
                                        </span>
				</strong><br />
				Please try <a href="<?=base_url()?>admin/jobschedule">another day</a> for your booking.
                                  <?php }?>
				
			</div>
			
			<?php if ($this->session->userdata('role') == 'admin'): ?>
				<div class="job-side-box" style="display:none;">
					<div class="header">
						Service Call Settings
					</div>
					<div class="content">
						If there are service calls scheduled for today, please allocate the number of jobs it will take for the day.
						<div class="divider"></div>
						Service calls will take up to 
						<select id="service_call_count" style="width:auto; margin:0 4px;">
							<?php for($i=0;$i<($daily_limit['limit'] + 1);$i++): ?>
							<?php if (@$service_count_total==$i): ?>
								<option selected="selected"><?=$i?></option>
							<?php else: ?>
								<option><?=$i?></option>
							<?php endif ?>
							<?php endfor; ?>
						</select>
						jobs.
						<span class="ajax-loader" style="display:none;"><img src="<?=base_url()?>assets/images/ajax-loader.gif" /></span>
					</div>
				</div>
			<?php endif ?>
			
			<div class="job-side-box">
				<a name="job-notes"></a>
				<div class="header"> 
					Day Notes
				</div>
				<div class="content">
					<?php foreach ($day_notes as $key => $value): ?>
						<strong>Posted:</strong> <?=date("F j, Y",strtotime($value['created']))?>, <strong>By:</strong> <?=$value['first_name']?> <?=$value['last_name']?><br />
						<span class="warning"><?=character_limiter($value['note'],90)?></span>
						<div class="divider"></div>
					<?php endforeach ?>
					<?php if (count($day_notes) == 0): ?>
					<div style="background:#fff; padding:10px">
						There are no notes for this day.
					</div>
					<?php endif ?>
					<?php if ($remaining_notes > 0): ?>
						<em><?=$remaining_notes?> additinoal note(s)...</em>
					<?php endif ?>
				</div>
			</div>
		</div>
		<div class="clear-both"></div>
	</div>
</div>

<script type="text/javascript" charset="utf-8">
var year = '<?=date("Y",$day_timestamp)?>';
var day = '<?=date("d",$day_timestamp)?>';
var month = '<?=date("m",$day_timestamp)?>';

$('#service_call_count').change(function() {
	// update day's service call job count
	$.ajax({
		type: "POST",
		url: "<?=base_url()?>ajax/update_day_count",
		data: 'month='+month+'&year='+year+'&day='+day+'&job_count='+$(this).val(),
		beforeSend : function() {
			$(".ajax-loader").show();
		},
		dataType: "json",
		success: function(json) {
			$(".ajax-loader").fadeOut();
			update_day_status();
		}
	});
});

function update_day_status()
{
	$.ajax({
		type: "GET",
		url: "<?=base_url()?>ajax/update_day_status/"+year+"/"+month+"/"+day,
		success: function(html) {
			$(".day-status").html(html);
		}
	});
}

update_day_status();

function complete_pl(job_id){
        if(window.confirm("Are you sure?")){
          val =1;
          $.ajax({
		type: "POST",
		url: "<?=base_url()?>prejobscheduleajax/update_plstatus/"+job_id+"/"+val,
		data: "job_id="+<?=$job_id?>+"&val="+val,
		dataType: "json",
		beforeSend : function() {

		},
		success: function(json) {
			if(json.success == true)
			{
				alert("Job Completed");
				$("#plcompleted_a_"+job_id).html("Yes")
			}
			else
			{
				alert(json.msg);
			}
		  }
	    });
          }
 }
</script>
