<!--
-  Each salesman-user and installer-user is given a unique color.
- Salesman-users can ONLY see their color and the default color.
- Admin-users can see all colors of all salesman-users, and installer-users


-  The default color is the 'green' color (given to admin-user)

- If there are 'jobs' present on a specific day, the number of jobs appear in the middle.
     - If a user hovers over the number of jobs on that day, 'Reserve a job' tool tip appears and if clicked, 'Reserve/add a job' overlay window will appear (see screen below)

- If there are 'Service Calls' scheduled for that day, a 'Service Calls' link appears at the top of the day, if clicked on the 'View Service Calls' overlay appears (see screen below)

- If user hovers over magify icon, 'Quick Summary' tooltip appears, and if clicked on, 'Quick Summary' overlay appears. (see screen below)

-->
<style type="text/css">
*{margin:0; padding:0;}
.dateNav{background-color:#333333; color:#ffffff;}
.dateWrap{clear:both; background-color:#ffffff; padding:2px;}
ul.dateLeft{width:64%; float:left; border-right:1px solid #e1e1e1; padding:0 5px 0 0; height:115px;}
ul.dateLeft li{float:none; list-style:none; border-top:1px solid #e1e1e1; font-size:12px; text-align:left; padding:5px 0;}
ul.dateLeft li.green{color:#2c9600;}
ul.dateLeft li.orange{color:#ff9731;}
ul.dateLeft li.blue{color:#2e97cb;}
ul.dateLeft li span{display:block; font-size:16px; font-weight:800; padding:0 0 4px 0;}
ul.dateLeft li span p{display:block; font-size:16px; font-weight:800; padding:0 0 3px 0;}
ul.dateLeft li:first-child{border:none;}
ul.dateRight{width:29%; float:left;}
ul.dateRight li{float:none; list-style:none; font-size:12px; font-weight:bold; color:#5b5b5b; padding:0 0 0 5px;}
ul.dateRight li p{font-size:12px; font-weight:bold;}

ul.iconList{top:-1px !important;}
</style>
<div class="clearfix" style="padding-bottom:20px;">
	<div class="fl">
		<h1>Alternate Energy, Inc.</h1>
		<p class="bread-crumbs"><a href="<?=base_url()?>admin">Home</a> / Job Schedule
			<?php if( !in_array($this->session->userdata("role"),array('installer' ,'contractor') ) &&  $this->session->userdata('access') ){ ?>
		</p>
	</div>
	<div class="fr">
		<?php if($this->session->userdata("role")=='admin') { ?><a class="facebox" href="<?=base_url()?>ajax/reserve_job/<?=$year?>/<?=$month?>" > <button style="cursor:pointer;">Schedule A Job</button></a><?php } }?>
                
	</div>
</div>

<div id="calendar-navigation">
	<div class="drop-downs" style="padding:4px 4px 0 0;">
		<div class="fr" style="padding:2px 0 0 3px;"><button style="cursor:pointer;" class="submitcal" name>Go</button></div>
		<form name="dropdowns" method="post" id="jobsc" class="fr" style="_padding-top:2px; *padding-top:2px;">
			<?=form_dropdown('calendar_month',$calendar_months,$calendar_month)?>
			<?=form_dropdown('calendar_year',$calendar_years,$calendar_year)?>
			
		</form>
		<div class="arrow-nav fr" style="padding:4px 3px 0 0;">
			<?php
			if(($month - 1) > 0)
			{
				$prev_month = sprintf("%02d",$month - 1);
				$prev_year_nav = $year;
			}
			else
			{
				$prev_month = '12';
				$prev_year_nav = ($year  - 1);
			}
			
			if(($month + 1) > 12)
			{
				$next_month = '01';
				$next_year_nav = ($year + 1);
			}
			else
			{
				$next_month = sprintf("%02d",$month + 1);
				$next_year_nav = $year;
			}
			?>
			<a href="<?=base_url()?>admin/jobschedule/<?=$prev_year_nav?>/<?=$prev_month?>"><img src="<?=base_url()?>assets/images/leftnav.png" /></a>
			<a href="<?=base_url()?>admin/jobschedule/<?=$next_year_nav?>/<?=$next_month?>"><img src="<?=base_url()?>assets/images/rightnav.png" /></a>
		</div>
	</div>
</div>
<?=$this->calendar->generate($year,$month,@$dates);?>

<script type="text/javascript" charset="utf-8">
  $(document).ready(function(){
   $(".submitcal").click(function(){

       year = $('select[name=calendar_year]').val();
	month = $('select[name=calendar_month]').val();
	location.href = '<?=base_url()?>admin/jobschedule/'+year+'/'+month;
   });
  });
/*$("select[name=calendar_month]").change(function(){
	year = $('select[name=calendar_year]').val();
	month = $('select[name=calendar_month]').val();
	location.href = '<?=base_url()?>admin/jobschedule/'+year+'/'+month;
});

$("select[name=calendar_year]").change(function(){
	year = $('select[name=calendar_year]').val();
	month = $('select[name=calendar_month]').val();
	location.href = '<?=base_url()?>admin/jobschedule/'+year+'/'+month;
});*/
</script>