<!--
Job Detail Page - Job Specifications

- Ability for admin-user to edit/add dropdown options
- Ability to view progress of form completion
- Ability to "Create Purchase Agreement" PDF to download. A pre-designed PDF form will be populated with data on this page and customer details

- Job Summary widget
    - Ability for all users to change 'current status'
    - functionality as seen in design

- Customer Summary Widget
  - functionality as seen in design

- Job Notes widget
    - ability for user to add simple notes/progress on job with date-stamp

- Upload files widget
   - ability for users to upload/add/delete files to Job

- Job Location Map
   - Google Map of job address
-->

<div style="position:relative;">
	<div class="page-top-buttons">
		 <a href="<?=base_url()?>admin/createswhpdf/<?=$job_id?>" target="_blank"> <button>Create Design Sheet</button></a>
		
	</div>
</div>

<h1>Job Details</h1>
<p><a href="<?=base_url()?>">Home</a> / <a href="<?=base_url()?>admin/jobschedule">Job Calendar</a>/ <a href="<?=base_url()?>admin/day/<?=date("Y/m/d",$job_timestamp)?>"><?=date("Y",$job_timestamp)?></a>/ <a href="<?=base_url()?>admin/jobschedule/<?=date("Y",$job_timestamp)?>/<?=date("m",$job_timestamp)?>"><?=date("F",$job_timestamp)?></a> / <a href="<?=base_url()?>admin/day/<?=date("Y/m/d",$job_timestamp)?>"><?=date("d",$job_timestamp)?></a> / <a href="<?=base_url()?>admin/customer/<?=$job['customer_id']?>"><?=$job['first_name']?> <?=$job['last_name']?></a> / <?=$job['job_type']?></p>
<br />

<div class="generic-page-block">
	<div class="green-header">
		<span class="dark-green">Job Date:</span> <?=date("F jS, Y",$job_timestamp)?>
		<span class="dark-green">Job Type:</span> <?=$job['job_type']?>
		<span class="dark-green">Customer Name:</span> <?=$job['first_name']?> <?=$job['last_name']?>
	</div>
	<div class="content">
		<div class="two-col-wide-left">
			<div class="content-header"><?=$job['job_type']?> System Information  <span id="pgbar" style="display: none"><img src="<?=base_url()?>assets/images/ajax-loader.gif" /></span></div>
			<p>Please fill out the relevant information below for your Customer's <?=$job['job_type']?> system.</p>
			<br />
			
			<div class="generic-nav-tabs">
				<a href="<?=base_url()?>admin/job_comment/<?=$job_id?>"  >Comments</a>
				<a id="jobpvswh" href="<?=base_url()?>admin/job/<?=$job_id?>" class="active <?php echo $jobclass;?>">Job Specifications</a>
				 <?php if(!$userrole) {?> <a id="financepvswh" href="<?=base_url()?>admin/job_financing/<?=$job_id?>" class="<?php echo $finaceclass;?>">Cost</a>
				<a href="<?=base_url()?>admin/job_referrals/<?=$job_id?>">Referrals</a>
                                <?php } ?>
                                 <?php if($this->session->userdata("role") == 'admin') {?>
                                <a href="<?=base_url()?>admin/installers/<?=$job_id?>">Installers</a>
                                <?php }?>
                                <a id="customerpvswh"  href="<?=base_url()?>admin/customer_job/<?=$job_id?>" class="<?php echo $customerclass;?>">Customer</a>
                                <a   href="<?=base_url()?>admin/fileview_job/<?=$job_id?>"  > Files </a>
                                <a   href="<?=base_url()?>admin/permit_job/<?=$job_id?> "    > Permits</a>
				<div class="clear-left"></div>
			</div>
			<div style="margin-bottom:20px;margin-top:20px;display:none;"  ><div style="float:left; padding:2px 5px 0 0; ">Auto Save</div> <img src="<?php echo base_url(); ?>assets/images/bar.gif"></div>
			<br /><br />
			
			<?=form_open('admin/job/'.$job_id,array('name' => 'form1', 'id' => 'form1'));?>
			<?=form_hidden('dosubmit','true')?>
			
			<div id="two-col-form" class="jobdetails clearfix">
				<div class="clearfix">
					<span class="green-text">[Tank Details]</span><br />
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Tank Brand', 'tank_brand_id');?>
						<?=form_dropdown('tank_brand_id', @$tank_brands, @$job['tank_brand_id']);?>
					</div>
					
					<div class="jobdata" style="display:none;" id="other_tank_brand_wrap">
					<?=form_label('Other Tank Brand', 'other_tank_brand');?>
					<?=form_input('other_tank_brand', @$job['other_tank_brand']);?>
					</div>
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Tank Size', 'tank_size_id');?>
						<?=form_dropdown('tank_size_id', @$tank_sizes, @$job['tank_size_id']);?>
					</div>
					<div class="jobdata" style="display:none;" id="other_tank_size_wrap">
					<?=form_label('Other Tank Size', 'other_tank_size');?>
					<?=form_input('other_tank_size', @$job['other_tank_size']);?>
					</div>
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Location of Existing Heater', 'existing_heater_location');?>
						<?=form_input('existing_heater_location',@$job['existing_heater_location']);?>
					</div>
				</div>
                                <div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Type of Jump', 'typeofjump');?>
						<?=form_input('typeofjump',@$job['typeofjump']);?>
					</div>
				</div>
				<div class="jobrow clearfix">
					<table class="padded-table">
						<tr>
							<td>Remove old tank? </td>
							<td>
							<?
							if(@$job['remove_old_tank'] == 'y') {$checked=true;} else {$checked=false;}
							echo form_radio('remove_old_tank','y',$checked)?>
							</td>
							<td>Yes</td>
							<td>
							<?
							if(@$job['remove_old_tank'] == 'n') {$checked=true;} else {$checked=false;}
							echo form_radio('remove_old_tank','n',$checked)?></td>
							<td>No</td>
						</tr>
					</table>
				</div>
				<div class="jobrow clearfix">
					<table class="padded-table">
						<tr>
							<td>Relocate  tank? </td>
							<td>
							<?
							if(@$job['relocate_old_tank'] == 'y') {$checked=true;} else {$checked=false;}
							echo form_radio('relocate_old_tank','y',$checked)?>
							</td>
							<td>Yes</td>
							<td>
							<?
							if(@$job['relocate_old_tank'] == 'n') {$checked=true;} else {$checked=false;}
							echo form_radio('relocate_old_tank','n',$checked)?></td>
							<td>No</td>
						</tr>
					</table>
				</div>
				<div class="jobrow clearfix" style="display:none;" id="tank_loc_row">
					<div class="jobdata mright">
						<?=form_label('Location of New Tank', 'new_tank_location');?>
						<?=form_input('new_tank_location',@$job['new_tank_location']);?>
					</div>
					<div class="jobdata">
						<?=form_label('Distance from Old Tank', 'tank_distance');?>
						<?=form_input('tank_distance',@$job['tank_distance']);?>
					</div>
				</div>
				<div class="jobrow clearfix">
					<table class="padded-table">
						<tr>
							<td>Is solar tank accessible? </td>
							<td>
							<?
							if(@$job['solar_tank_accessible'] == 'y') {$checked=true;} else {$checked=false;}
							echo form_radio('solar_tank_accessible','y',$checked)?>
							</td>
							<td>Yes</td>
							<td>
							<?
							if(@$job['solar_tank_accessible'] == 'n') {$checked=true;} else {$checked=false;}
							echo form_radio('solar_tank_accessible','n',$checked)?></td>
							<td>No</td>
						</tr>
					</table>
				</div>
				<div class="jobrow clearfix">
						<span class="green-text">[Panel Details]</span><br />
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Panel Type', 'panel_type_id');?>
						<?=form_dropdown('panel_type_id', @$panel_types, @$job['panel_type_id']);?>
					</div>
					<div class="jobdata" style="display:none" id="other_panel_type_wrap">
					<?=form_label('Other Panel Type', 'other_panel_type');?>
					<?=form_input('other_panel_type',@$job['other_panel_type']);?>
					</div>
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Panel Sizes', 'panel_size_id');?>
						<?=form_dropdown('panel_size_id', @$panel_sizes, @$job['panel_size_id']);?>
						
						<?=form_label('Number of panels', 'panel_count');?>
						<?=form_input('panel_count',@$job['panel_count']);?>
					</div>
					<div class="jobdata" style="display:none" id="other_panel_size_wrap">
					<?=form_label('Other Panel Size', 'other_panel_size');?>
					<?=form_input('other_panel_size',@$job['other_panel_size']);?>
					</div>
				</div>
				<div class="jobrow clearfix">
					<span class="green-text">[Pipe-Run Details]</span>
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
					<?=form_label('Pipe Run Distance <span class="light-gray">(one way, ft, inches)</span>', 'piperun_length');?>
					<?=form_dropdown('piperun_length',$piperundistance,@$job['piperun_length']);?>
					</div>
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Pipe-Run Type', 'piperun_type_id');?>
						<?=form_dropdown('piperun_type_id', @$piperun_types, @$job['piperun_type_id']);?>
					</div>
					<div class="jobdata" style="display:none" id="other_piperun_type_wrap">
					<?=form_label('Other Pipe-Run Type', 'other_piperun_type');?>
					<?=form_input('other_piperun_type',@$job['other_piperun_type']);?>
					</div>
				</div>
                                <div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Type of pump', 'pump_type_id');?>
						<?=form_dropdown('pump_type_id', @$pump_types, @$job['pump_type_id']);?>
					</div>
					<div class="jobdata" style="display:none" id="other_pump_type_id">
					<?=form_label('Other Pump  Type', 'other_pump_type_id');?>
					<?=form_input('other_pump_type',@$job['other_pump_type']);?>
					</div>
				</div>
				<div class="jobrow clearfix">
					<table class="padded-table">
						<tr>
							<td>Need gutter installation? </td>
							<td>
							<?
							if(@$job['gutter_installation'] == 'y') {$checked=true;} else {$checked=false;}
							echo form_radio('gutter_installation','y',$checked)?>
							</td>
							<td>Yes</td>
							<td>
							<?
							if(@$job['gutter_installation'] == 'n') {$checked=true;} else {$checked=false;}
							echo form_radio('gutter_installation','n',$checked)?></td>
							<td>No</td>
						</tr>
					</table>
				</div>
				<div class="jobrow clearfix">
					<span class="green-text">[Roof Details]</span>
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Number of stories', 'stories');?>
						<?=form_dropdown('stories', $stories, @$job['stories']);?>
					</div>
				</div>
				<div class="jobrow clearfix" style="display:none;" id="panel_access_row">
					<table class="padded-table">
						<tr>
							<td>Access to panel installation location? </td>
							<td>
							<?
							if(@$job['module_install_location_access'] == 'y') {$checked=true;} else {$checked=false;}
							echo form_radio('panel_install_location_access','y',$checked)?>
							</td>
							<td>Yes</td>
							<td>
							<?
							if(@$job['module_install_location_access'] == 'n') {$checked=true;} else {$checked=false;}
							echo form_radio('panel_install_location_access','n',$checked)?></td>
							<td>No</td>
						</tr>
					</table>
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Roof Type', 'roof_type');?>
						<?=form_dropdown('roof_type_id', @$roof_types, @$job['roof_type_id']);?>
					</div>
					<div class="jobdata" style="display:none;" id="other_roof_type_wrap">
					<?=form_label('Other roof type', 'other_roof_type');?>
					<?=form_input('other_roof_type',@$job['other_roof_type']);?>
					</div>
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Rafter Type', 'rafter_type_id');?>
						<?=form_dropdown('rafter_type_id', @$rafter_types, @$job['rafter_type_id']);?>
					</div>
					<div class="jobdata" style="display:none" id="other_rafter_type_wrap">
						<?=form_label('Other rafter type', 'other_rafter_type');?>
						<?=form_input('other_rafter_type',@$job['other_rafter_type']);?>
					</div>
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Color of roof', 'roof_color');?>
						<?=form_input('roof_color',@$job['roof_color']);?>
					</div>
					<div class="jobdata">
						<?=form_label('Distance between rafters <span class="light-gray">(ft, inches)</span>', 'rafter_distance');?>
						<?=form_input('rafter_distance',@$job['rafter_distance']);?>
					</div>
				</div>
				<div class="jobrow clearfix">
					<table class="padded-table">
						<tr>
							<td>Tilt kit needed? </td>
							<td>
							<?
							if(@$job['tilt_kit_needed'] == 'y') {$checked=true;} else {$checked=false;}
							echo form_radio('tilt_kit_needed','y',$checked)?>
							</td>
							<td>Yes</td>
							<td>
							<?
							if(@$job['tilt_kit_needed'] == 'n') {$checked=true;} else {$checked=false;}
							echo form_radio('tilt_kit_needed','n',$checked)?></td>
							<td>No</td>
						</tr>
					</table>
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Installation Type', 'installation_type_id');?>
						<?=form_dropdown('installation_type_id', @$installation_types, @$job['installation_type_id']);?>
					</div>
					<div class="jobdata">
						<div style="display:none" id="other_installation_type_wrap">
						<?=form_label('Other installation type', 'other_installation_type');?>
						<?=form_input('other_installation_type',@$job['other_installation_type']);?>
						</div>
					</div>
				</div>
				<div class="jobrow clearfix">
					<div class="jobdata mright">
						<?=form_label('Roof Orientation', 'roof_orientation');?>
						<?=form_input('roof_orientation',@$job['roof_orientation']);?>
					</div>
					<div class="jobdata">
						<?=form_label('Roof pitch <span class="light-gray">(degrees)</span>', 'roof_pitch');?>
						<?=form_input('roof_pitch',@$job['roof_pitch']);?>
					</div>
				</div>
				<div class="jobrow clearfix">
					<table class="padded-table">
						<tr>
							<td>Electrician sent out to inspect/quote? </td>
							<td>
							<?
							if(@$job['elec_insp_quote'] == 'y') {$checked=true;} else {$checked=false;}
							echo form_radio('elec_insp_quote','y',$checked)?>
							</td>
							<td>Yes</td>
							<td>
							<?
							if(@$job['elec_insp_quote'] == 'n' || !$checked) {$checked=true;} else {$checked=false;}
							echo form_radio('elec_insp_quote','n',$checked)?></td>
							<td>No</td>
						</tr>

					</table>
				</div>
                          <div class="jobrow clearfix">
					<table class="padded-table">

                                                <tr><td> <div id ="elec_comment_div" style="display:<?php if(@$job['elec_insp_quote'] == 'y') echo "block"; else echo "none"; ?>;">
                                                                <?=form_label('Please describe scope of work quoted', 'elec_comments');?>
						<?=form_textarea('elec_comments',@$job['elec_comments'])?></td>
                                                    </div>
                                                </tr>
					</table>
				</div>
				<div class="jobrow clearfix">
						<span class="green-text">[More Details]</span>
				</div>
				<div class="jobrow clearfix">
						<?=form_label('Additional comments or requirements', 'comments');?>
						<?=form_textarea('comments',@$job['comments'])?>
				</div>
			</div>
			
			<?=form_close()?>
			
			<div class="divider"></div>
			
			<div style="float:left;">
				<button>Back to Calendar</button>
			</div>
			
			<div style="float:right">
				 <a href="<?=base_url()?>admin/createswhpdf/<?=$job_id?>" target="_blank"> <button>Create Design Sheet</button></a>
				<button>Print</button>
				<?php if ($this->session->userdata("user_id") == $job['user_id'] or $this->session->userdata('role') == 'admin'): ?>
					<?php if (!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") == 'n')): ?>
						<button onclick="saveswh();">Save</button>
					<?php endif; ?>
				<?php endif; ?>
			</div>
			<div class="clear-both"></div>
			
		</div>
		<div class="two-col-wide-right">

			<div class="progress-block">
				<div class="progress-bar">
					<div id="pgbarw"  class="bar" style="width:<?=$percent_completed?>%;"></div>
				</div>
				<strong>Progress:</strong><br />
				You have completed <span class="bold" id="pgbarv"><?=$percent_completed?>%</span> of this form.
			</div>


			<div class="job-side-box">
				<div class="header">
					<a href="#">Back to Schedule</a>
					Job Summary
				</div>
				<div class="content">

					<strong>Salesperson: </strong><?php echo $salesman ?><br />
					<strong>Installers: </strong> <?php echo $showinstaller; ?> <br />
					<div class="divider"></div>

					<?php if ($this->session->userdata("role") == 'admin'): ?>
					<table width="100%">
						<tr>
							<td>Current Status:<span id="job-status-indicator"><img src="<?=base_url()?>assets/images/ajax-loader.gif" /></span></td>
							<td><div align="right">
								<?=form_dropdown('current_status',$job_statuses,$job['current_status'])?>
							</div></td>
						</tr>
					</table>
					<div class="divider"></div>
					<?php endif; ?>
					<strong>Booking Date:</strong> <?=date("F jS, Y",strtotime($job['created']))?><br />
					<?php //currenttime?>
					<span class="warning"><?php if($timediff>0 && $percent_completed<100) {?><strong>Time Left for Expiration:</strong> <?=$timediff?> hours</span><br />
                                        <?php } else if($timediff<=0 && $percent_completed<100) { ?>
                                        <strong>This job has been expired ,please contact to Administrator</strong><br />
                                        <?php }?>
					Last edited by:  <?=$editedby;?>
					<?php if ($this->session->userdata("role") == 'admin'){ ?>
                                        <br/><a href="<?=base_url()?>ajax/timeextform/<?=$job['id']?>"  class="facebox">Edit TimeLimit </a>
                                        <?php }?>
					<div class="divider"></div>

					<?php if ($this->session->userdata("user_id") == $job['user_id'] or $this->session->userdata('role') == 'admin'): ?>
						<?php if (!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") == 'n')): ?>
							<a href="<?=base_url()?>admin/delete_job/<?=$job['id']?>?ref=/admin/day/<?=date("Y/m/j",$job_timestamp)?>" class="delete-job-link" onclick="return confirm('Are you sure you want to delete this job?');">Delete this job</a>
                                                        <a href="#" onclick="schedule_job(<?=$job['id']?>,<?=$job['user_id']?>);"  class="delete-job-link" > Schedule Job</a>
						<?php endif ?>
					<?php endif ?>
				</div>
			</div>

			<?php if ($this->session->userdata('role') == 'admin'): ?>
				<div class="job-side-box" style="display:none;">
					<div class="header">
						Job Count Settings
					</div>
					<div class="content">
						How many job slots does this job take up?
						<div class="divider"></div>
						<select id="job_count" style="width:auto; margin:0 4px;">
							<?php for($i=0;$i<($daily_limit['limit'] + 1);$i++): ?>
							<?php if (@$job['job_count']==$i): ?>
								<option selected="selected"><?=$i?></option>
							<?php else: ?>
								<option><?=$i?></option>
							<?php endif ?>
							<?php endfor; ?>
						</select>
						slots.
						<span class="ajax-loader" style="display:none;"><img src="<?=base_url()?>assets/images/ajax-loader.gif" /></span>
					</div>
				</div>
			<?php endif ?>

			<div class="job-side-box">
				<div class="header">
					<?php if(!$userrole) {?><a href="<?=base_url()?>admin/customer_job/<?=$job_id?>">Edit Profile</a> <?php }?>
					Customer Summary
				</div>
				<div class="content">
					<strong>Customer:</strong><?php if(!$userrole) {?> <a href="<?=base_url()?>admin/customer_job/<?=$job_id?>"><?=$job['first_name']?> <?=$job['last_name']?></a><?php }else{?><?=$job['first_name']?> <?=$job['last_name']?><?php }?><br />
					<strong>Address:</strong><br />
					<div style="padding-left:10px;">
						<?=$job['address']?><br />
						<?=$job['city']?>, <?=$job['state']?>, <?=$job['zip_code']?>
					</div>
					<strong>Billing Address:</strong><br />
					<div style="padding-left:10px;">
						<?php if ($job['different_billing_address'] == 'y'): ?>
							<?=$job['billing_address']?><br />
							<?=$job['billing_city']?>, <?=$job['billing_state']?>, <?=$job['billing_zip_code']?>
						<?php else: ?>
							<?=$job['address']?><br />
							<?=$job['city']?>, <?=$job['state']?>, <?=$job['zip_code']?>
						<?php endif ?>
					</div>
					<div class="divider"></div>
					<strong>Other Active Jobs:</strong>
					<div style="padding-left:10px;">
						<?php foreach ($other_jobs as $key => $value): ?>
						<a href="<?=base_url()?>admin/job/<?=$value['id']?>"><?=$value['job_type']?> (<?=date("M j, Y",strtotime($value['job_date']))?>)</a><br />
						<?php endforeach ?>
						<?php if (count($other_jobs) == 0): ?>
							Customer has no other jobs
						<?php endif ?>
					</div>
                                        <?php if (count($split_jobs) != 0) {?>
                                        <div class="divider"></div>
					<strong>Split Jobs:</strong>
					<div style="padding-left:10px;">
						<?php foreach ($split_jobs as $key => $value): ?>
						<a href="<?=base_url()?>admin/job/<?=$value['id']?>"><?=$value['job_type']?> (<?=date("M j, Y",strtotime($value['job_date']))?>)</a><br />
						<?php endforeach ?>

					</div>
                                        <?php }?>
				</div>
			</div>

			<div class="job-side-box" style="display:none;">
				<a name="job-notes"></a>
				<div class="header">
					<?php if(!$userrole) {?><a href="<?=base_url()?>ajax/add_job_note/<?=$job['id']?>" class="facebox">Add Note</a><?php }?>
					<a href="<?=base_url()?>ajax/view_job_notes/<?=$job['id']?>" class="facebox">View All</a>
					Job Notes
				</div>
				<div class="content">
					<?php foreach ($job_notes as $key => $value): ?>
						<strong>Posted:</strong> <?=date("F j, Y",strtotime($value['created']))?>, <strong>By:</strong> <?=$value['first_name']?> <?=$value['last_name']?><br />
						<span class="warning"><?=character_limiter($value['note'],90)?></span>
						<div class="divider"></div>
					<?php endforeach ?>
					<?php if (count($job_notes) == 0): ?>
					<div style="background:#fff; padding:10px">
						This job has no notes.
					</div>
					<?php endif ?>
				</div>
			</div>

			<div class="job-side-box" style="display:none;">
				<div class="header">
				<?php if(!$userrole) {?>	<a href="<?=base_url()?>ajax/add_file_iframe/<?=$job['id']?>" class="facebox">Add File</a><?php }?>
					Upload Files
				</div>
				<div class="content">
					<?php if (count($job_files) > 0): ?>
					<table cellspacing="0" class="files-table">
						<?php foreach ($job_files as $key => $value): ?>
						<tr>
							<td><img src="<?=base_url()?>/assets/images/mime-generic.gif" />&nbsp;&nbsp;<a style="vertical-align:top;text-decoration:underline" href="<?=base_url()?>admin/download/<?=$value['id']?>"><?=$value['original_filename']?></a></td>

							<td><a href="<?=base_url()?>admin/delete_file/<?=$value['id']?>"><img src="/assets/images/delete-icon.gif" /></a></td>
						</tr>
						<?php endforeach ?>
					</table>
					<?php else: ?>
						<div style="padding:10px; background:#fff;">
							No uploaded files.
						</div>
					<?php endif ?>
				</div>
			</div>

			<div class="job-side-box">
				<div class="header">
					Job Location Map
				</div>
				<?php if ($job['address'] != '' && $job['city'] != '' && $job['state'] != ''): ?>
					<div id="map_canvas" style="width: 100%; height: 200px"></div>
				<?php else: ?>
					<div style="padding:10px; background:#fff;">
						No address specified.
					</div>
				<?php endif ?>
			</div>

		</div>
		<div class="clear-both"></div>
	</div>
</div>


<script type="text/javascript" charset="utf-8">
$(document).ready(function() {
	var address = '<?=$job['address']?>';
	var city = '<?=$job['city']?>';
	var state = '<?=$job['state']?>';
	var jobstatus = $("select[name=current_status]").val();
        
	if($('input[name=relocate_old_tank]:checked').val() == 'y') { $("#tank_loc_row").show(); }
	if($('select[name=stories]').val() > 1) {$("#panel_access_row").show(); }
	if($('select[name=roof_type_id]').val() == 'other') {$("#other_roof_type_wrap").show();}
	if($('select[name=rafter_type_id]').val() == 'other') {$("#other_rafter_type_wrap").show();}
	if($('select[name=installation_type_id]').val() == 'other') {$("#other_installation_type_wrap").show();}
	if($('select[name=tank_brand_id]').val() == 'other') {$("#other_tank_brand_wrap").show();}
	if($('select[name=tank_size_id]').val() == 'other') {$("#other_tank_size_wrap").show();}
	if($('select[name=panel_type_id]').val() == 'other') {$("#other_panel_type_wrap").show();}
	if($('select[name=panel_size_id]').val() == 'other') {$("#other_panel_size_wrap").show();}
	if($('select[name=piperun_type_id]').val() == 'other') {$("#other_piperun_type_wrap").show();}
	
	$('select[name=stories]').change(function() {
		if($(this).val() > 1)
			$("#panel_access_row").show();
		else
			$("#panel_access_row").hide();
	});
	
	$('select[name=roof_type_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_roof_type_wrap").show();
		else
			$("#other_roof_type_wrap").hide();
	});
	
	$('select[name=rafter_type_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_rafter_type_wrap").show();
		else
			$("#other_rafter_type_wrap").hide();
	});
	
	$('select[name=installation_type_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_installation_type_wrap").show();
		else
			$("#other_installation_type_wrap").hide();
	});
	
	$('select[name=tank_brand_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_tank_brand_wrap").show();
		else
			$("#other_tank_brand_wrap").hide();
	});
	
	$('select[name=tank_size_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_tank_size_wrap").show();
		else
			$("#other_tank_size_wrap").hide();
	});
	
	$('select[name=panel_type_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_panel_type_wrap").show();
		else
			$("#other_panel_type_wrap").hide();
	});
	
	$('select[name=panel_size_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_panel_size_wrap").show();
		else
			$("#other_panel_size_wrap").hide();
	});
	
	$('select[name=piperun_type_id]').change(function() {
		if($(this).val() == 'other')
			$("#other_piperun_type_wrap").show();
		else
			$("#other_piperun_type_wrap").hide();
	});
	
	$("input[name=relocate_old_tank]").click(function() {
		if($("input[name=relocate_old_tank]:checked").val() == 'n')
		{
			$("#tank_loc_row").hide();
		}
		else
		{
			$("#tank_loc_row").show();
		}
	});
	$('input:radio[name=elec_insp_quote]').change(function(){
            if($(this).val()=='y')
            {
                $("#elec_comment_div").show();
            }
            if($(this).val()=='n')
            {
                $("#elec_comment_div").hide();
            }
        });
	$('select[name=current_status]').change(function() {
		var status ;
                if(window.confirm("Are you sure?")){

		status = $(this).val();
                jobstatus =status;
		$.ajax({
		type: "POST",
		url: "<?=base_url()?>ajax/update_job_status",
		data: "job_id="+<?=$job_id?>+"&status="+status,
		dataType: "json",
		beforeSend : function() {
			$("#job-status-indicator").show();
		},
		success: function(json) {
			if(json.success == true)
			{
				//location.href = '/admin/job/' + job_id;
				$("#job-status-indicator").fadeOut('slow');
			}
			else
			{
				alert(json.msg);
			}
		  }
		});
                 } else{

                 $(this+'option[value="'+jobstatus+'"]').attr('selected', 'selected');
                }
	});
	
	if(address != '' && city != '' && state != '')
	{
		showAddress('<?=$job['address']?>, <?=$job['city']?>, <?=$job['state']?>');
	}
	
	var year = '<?=date("Y",$job_timestamp)?>';
	var day = '<?=date("d",$job_timestamp)?>';
	var month = '<?=date("m",$job_timestamp)?>';

	$('#job_count').change(function() {
		// update day's service call job count
		$.ajax({
			type: "POST",
			url: "<?=base_url()?>ajax/update_job_count",
			data: 'month='+month+'&year='+year+'&day='+day+'&job_count='+$(this).val(),
			beforeSend : function() {
				$(".ajax-loader").show();
			},
			dataType: "json",
			success: function(json) {
				$(".ajax-loader").fadeOut();
			}
		});
	});

        validate_requiredfield =function(){
         $('div').removeClass("red");
         var isvalid=true;
         var nos_valid = $("input[name=panel_count]").val();
          if (!nos_valid){
              $("input[name=panel_count]").addClass('red');
               isvalid = false;
          }
         var tanksize_valid = $("select[name=tank_size_id]").val();
          if (!tanksize_valid || tanksize_valid=="0" ){
              $("select[name=tank_size_id]").addClass('red');
               isvalid = false;
          } else if(tanksize_valid=='other'){
             var other_tanksize_valid = $("input[name=other_tank_size]").val();
              if (!other_tanksize_valid){
                $("input[name=other_tank_size]").addClass('red');
                isvalid= false;
              }

          }

          var panel_type_id_valid = $("select[name=panel_type_id]").val();
          if (!panel_type_id_valid || panel_type_id_valid=="0" ){
              $("select[name=panel_type_id]").addClass('red');
               isvalid = false;
          } else if(panel_type_id_valid=='other'){
             var other_panel_type_valid = $("input[name=other_panel_type]").val();
              if (!other_panel_type_valid || other_panel_type_valid=="0"){
                $("input[name=other_panel_type]").addClass('red');
                isvalid= false;
              }

          }
          var panel_size_id_valid = $("select[name=panel_size_id]").val();
          if (!panel_size_id_valid || panel_size_id_valid=="0" ){
              $("select[name=panel_size_id]").addClass('red');
               isvalid = false;
          } else if(panel_size_id_valid=='other'){
             var other_panel_size_valid = $("input[name=other_panel_size]").val();
              if (!other_panel_size_valid || other_panel_size_valid=="0"){
                $("input[name=other_panel_size]").addClass('red');
                isvalid= false;
              }

          }
          return isvalid;
        }
        var submitvar =false;
        saveswh = function(){
            submitvar = true;
            document.form1.submit();
        }
<?php if(@$savedata){
           echo "var  valid =  validate_requiredfield();";
           echo " if(!valid) { $.facebox('<h3>Your Changes Have Been Saved,<br/>Please filled the highlighted field before job expire.</h3><br /><button class=\"cancel-facebox\" >OK</button>');}else{";
            echo "$.facebox('<h3>Your Changes Have Been Saved.</h3><br /><button class=\"cancel-facebox\" >OK</button>'); }";
        }else{
           echo "var  valid =  validate_requiredfield();";
        }

      ?>
      <?php if (($this->session->userdata("user_id") == $job['user_id'] &&  $this->session->userdata('access') ) or $this->session->userdata('role') == 'admin'){ ?>
    $(window).unload(function() {
        
     if(!submitvar){

      /**var  valid =  validate_requiredfield();
        if(!valid){
            alert("Please filled the highlighted field before job expire.");
        }*/
  $.ajax({
	type: "POST",
	url: "<?=base_url()?>admin/job/<?php echo $job_id; ?>",
	data: $('#form1').serialize(),
	beforeSend : function() {
	   $("#pgbar").show();
	},
	dataType: "json",
	success: function(json) {
	  //$(".ajax-loader").fadeOut();
        }
   });
   }
});
<?php }?>
$.ajax({
	type: "POST",
	url: "<?=base_url()?>admin/tabstatusjob/<?php echo $job_id; ?>",
	beforeSend : function() {

	},
	dataType: "json",
	success: function(json) {
            $("#jobpvswh").removeClass('incomplete_Actice incomplete');
            $("#financepvswh").removeClass('incomplete_Actice incomplete');
            $("#customerpvswh").removeClass('incomplete_Actice incomplete');
            $("#jobpvswh").addClass(json.jobclass)
            $("#financepvswh").addClass(json.finaceclass);
            $("#customerpvswh").addClass(json.customerclass);
            $("#pgbarw").css("width",json.percent_completed+"%")
            $("#pgbarv").html(json.percent_completed+"%");
        }
   });
    schedule_job = function(jobid,userid)
	{
		$.ajax({
			type: "POST",
			url: "<?=base_url()?>ajax/save_session_un/"+jobid,
			dataType: "json",
			success: function(json) {
				if(json.success == true)
				{
					location.href="<?=base_url()?>admin/installer_available/<?=date("Y",$job_timestamp)?>/<?=date("m",$job_timestamp)?>/"+userid;
				}
				else
				{
					$(".form-errors").html(json.msg);
					$(".form-errors").fadeIn();
				}
			}
		});
	}
});

function print_url(url)
{
 location=url;
 print();
 }
</script>