<!--
Job Detail Page - Referrals - Add New
-->

<!--
Job Detail Page - Financing

- If system special price is 'yes', then sales commision is SET at $1300 (list price should be $14,285). Then Sales commission = 1300 - program discount - referral amount.
- if system special price is 'no', then sales commision is SET at 10% of list price. Then Sales commision = %10(list price of system) - program discount - referral amount.

-  Cannot Save unless referral is added (if yes)
-->

<!--
Job Detail Page - Job Specifications

- Ability for admin-user to edit/add dropdown options
- Ability to view progress of form completion
- Ability to "Create Purchase Agreement" PDF to download. A pre-designed PDF form will be populated with data on this page and customer details

- Job Summary widget
    - Ability for all users to change 'current status'
    - functionality as seen in design

- Customer Summary Widget
  - functionality as seen in design

- Job Notes widget
    - ability for user to add simple notes/progress on job with date-stamp

- Upload files widget
   - ability for users to upload/add/delete files to Job

- Job Location Map
   - Google Map of job address
-->

<div style="position:relative;">
	<div class="page-top-buttons">
		<button>Create Purchase Agreement</button>
		<button>Print Summary</button>
	</div>
</div>

<h1>Job Details</h1>
<p><a href="<?=base_url()?>">Home</a> / <a href="<?=base_url()?>admin/jobschedule">Job Calendar</a> / <a href="<?=base_url()?>admin/day/<?=date("Y/m/d/",$job_timestamp)?>"><?=date("F jS, Y",$job_timestamp)?></a> / <a href="#"><?=$job['first_name']?> <?=$job['last_name']?></a> / <?=$job['job_type']?></p>
<br />

<div class="generic-page-block">
	<div class="green-header">
		<span class="dark-green">Job Date:</span> <?=$job_timestamp?date("F jS, Y",$job_timestamp):"Unscheduled"?>
		<span class="dark-green">Job Type:</span> <?=$job['job_type']?>
		<span class="dark-green">Customer Name:</span> <?=$job['first_name']?> <?=$job['last_name']?>
	</div>
	<div class="content">
		<div class="two-col-wide-left">
			<div class="content-header"><?=$job['job_type']?> System Information</div>
			<p>Please fill out the relevant information below for your Customer's <?=$job['job_type']?> system.</p>
			<br />
			
			<?php $this->load->view('common/job_nav_tabs'); ?>
			
			<br /><br />
			
			<?=form_open('admin/edit_referral/'.$referral_id,array('name' => 'form1', 'id' => 'form1'));?>
			<?=form_hidden('dosubmit','true')?>
			<table id="two-col-form" cellspacing="0" cellpadding="0" width="100%">
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Referral Source]</span><br /><br />
					</td>
				</tr>
				<tr>
					<td >
						<?=form_label('Referral Source', 'referral_type_id');?>
						<?=form_dropdown('referral_type_id',$referral_types,@$referral['referral_type_id'])?>
					</td>
                                         <td>
						<div style="width:10px;"></div>
					</td>
					<td>
						<?//=form_label('Turned in I-9 Tax Form?', 'ti9taxform');?><br/><br/>
						<?=form_checkbox('ti9taxform',1,@$referral['ti9taxform']);?>&nbsp;&nbsp;Turned in W-9 Tax Form?
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Referee Contact Details]</span><br /><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('First Name', 'first_name');?>
						<?=form_input('first_name',@$referral['first_name']);?>
						
						<?=form_label('Home Phone', 'home_phone');?>
						<?=form_input('home_phone',@$referral['home_phone']);?>
					</td>
					<td>
						<div style="width:10px;"></div>
					</td>
					<td>
						<?=form_label('Last Name', 'last_name');?>
						<?=form_input('last_name',@$referral['last_name']);?>
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Referee Address Details]</span><br /><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Address', 'address');?>
						<?=form_input('address',@$referral['address']);?>
						
						<?=form_label('State', 'state');?>
						<?=form_dropdown('state',$states,@$referral['state'])?>
					</td>
					<td></td>
					<td>
						<?=form_label('City', 'city');?>
						<?=form_input('city',@$referral['city']);?>
						
						<?=form_label('Zip Code', 'zip_code');?>
						<?=form_input('zip_code',@$referral['zip_code']);?>
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[Referral Amount]</span><br />
					</td>
				</tr>
				<tr>
					<td>
						<?=form_label('Referral Amount', 'referral_amount');?>
						<?=form_input('referral_amount',@$referral['referral_amount']);?>
					</td>
					<td></td>
					<td></td>
				</tr>
				<tr>
					<td colspan="3">
						<br />
						<span class="green-text">[More Details]</span><br />
					</td>
				</tr>
				<tr>
					<td colspan="3">
						<?=form_label('Additional comments or requirements', 'comments');?>
						<?=form_textarea('comments',@$referral['comments'])?>
					</td>
				</tr>
			</table>
			<?=form_close()?>
			
			<p><a href="" class="underline">Add another referral</a></p>
			<br /><br />
			<div class="divider"></div>
			
			<div style="float:left;">
				<a href="<?=base_url()?>admin/job_referrals/<?=$job_id?>" class="active"><button>Back to Referrals List</button></a>
			</div>
			
			<div style="float:right">
				<button>Create Purchase Agreement</button>
				<button>Print</button>
				<button onclick="document.form1.submit()">Update</button>
			</div>
			<div class="clear-both"></div>
			
		</div>
		<div class="two-col-wide-right">

			<div class="progress-block">
				<div class="progress-bar">
					<div class="bar" style="width:<?=$percent_completed?>%;"></div>
				</div>
				<strong>Progress:</strong><br />
				You have completed <span class="bold"><?=$percent_completed?>%</span> of this form.
			</div>


			<div class="job-side-box">
				<div class="header">
					<a href="#">Back to Schedule</a>
					Job Summary
				</div>
				<div class="content">
					<strong>Salesperson: </strong> <?php echo $salesman ?><br />
					<strong>Installers:</strong> <?php echo $showinstaller; ?><br />
					<div class="divider"></div>

					<?php if ($this->session->userdata("role") == 'admin'): ?>
					<table width="100%">
						<tr>
							<td>Current Status:<span id="job-status-indicator"><img src="<?=base_url()?>assets/images/ajax-loader.gif" /></span> </td>
							<td><div align="right">
								<?=form_dropdown('current_status',$job_statuses,$job['current_status'])?>
							</div></td>
						</tr>
					</table>
					<div class="divider"></div>
					<?php endif; ?>
					<strong>Booking Date:</strong> <?=date("F jS, Y",strtotime($job['created']))?><br />

					<span class="warning"><?php if($timediff>0 && $percent_completed<90) {?><strong>Time Left for Expiration:</strong> <?=$timediff?> hours</span><br />
                                        <?php } else if($timediff<=0 && $percent_completed<90) { ?>
                                        <strong>This job has been expired ,please contact to Administrator</strong><br />
                                        <?php }?>
					Last edited by:  <?=$editedby;?>

					<div class="divider"></div>

					<?php if ($this->session->userdata('role') == 'admin'): ?>
						
							<a href="<?=base_url()?>ajax/confirmdelete_job/<?=$job['id']?>?ref=/admin/day/<?=date("Y/m/j",$job_timestamp)?>"  class="delete-job-link facebox" >Delete this job</a>
				   <?php endif; ?>
				</div>
			</div>

			<div class="job-side-box">
				<div class="header">
					  <?php if(!$userrole) {?><a href="<?=base_url()?>admin/customer_job/<?=$job_id?>">Edit Profile</a><?php }?>
					Customer Summary
				</div>
				<div class="content">
					<strong>Customer:</strong>
                                          <?php if(!$userrole) {?>
                                        <a href="<?=base_url()?>admin/customer_job/<?=$job_id?>"><?=$job['first_name']?> <?=$job['last_name']?></a><br />
                                        <?php } else {?><?=$job['first_name']?> <?=$job['last_name']?><?php }?>
					<strong>Address:</strong><br />
					<div style="padding-left:10px;">
						<?=$job['address']?><br />
						<?=$job['city']?>, <?=$job['state']?>, <?=$job['zip_code']?>
					</div>
					<strong>Billing Address:</strong><br />
					<div style="padding-left:10px;">
						<?php if ($job['different_billing_address'] == 'y'): ?>
							<?=$job['billing_address']?><br />
							<?=$job['billing_city']?>, <?=$job['billing_state']?>, <?=$job['billing_zip_code']?>
						<?php else: ?>
							<?=$job['address']?><br />
							<?=$job['city']?>, <?=$job['state']?>, <?=$job['zip_code']?>
						<?php endif ?>
					</div>
					<div class="divider"></div>
					<strong>Other Active Jobs:</strong>
					<div style="padding-left:10px;">
						<?php foreach ($other_jobs as $key => $value): ?>
						<a href="<?=base_url()?>admin/job/<?=$value['id']?>"><?=$value['job_type']?> (<?=date("M j, Y",strtotime($value['job_date']))?>)</a><br />
						<?php endforeach ?>
						<?php if (count($other_jobs) == 0): ?>
							Customer has no other jobs
						<?php endif ?>
					</div>
				</div>
			</div>

			

			<div class="job-side-box">
				<div class="header">
					<?php if(!$userrole) {?><a href="<?=base_url()?>ajax/add_file_iframe/<?=$job['id']?>" class="facebox">Add File</a><?php }?>
					Upload Files
				</div>
				<div class="content">
					<?php if (count($job_files) > 0): ?>
					<table cellspacing="0" class="files-table">
						<?php foreach ($job_files as $key => $value): ?>
						<tr>
							<td><img src="/assets/images/mime-generic.gif" /></td>
							<td><a href="<?=base_url()?>admin/download/<?=$value['id']?>"><?=$value['original_filename']?></a></td>
							<td><a href="<?=base_url()?>admin/delete_file/<?=$value['id']?>"><img src="/assets/images/delete-icon.gif" /></a></td>
						</tr>
						<?php endforeach ?>
					</table>
					<?php else: ?>
						<div style="padding:10px; background:#fff;">
							No uploaded files.
						</div>
					<?php endif ?>
				</div>
			</div>

			<div class="job-side-box">
				<div class="header">
					Job Location Map
				</div>
				<?php if ($job['address'] != '' && $job['city'] != '' && $job['state'] != ''): ?>
					<div id="map_canvas" style="width: 100%; height: 200px"></div>
				<?php else: ?>
					<div style="padding:10px; background:#fff;">
						No address specified.
					</div>
				<?php endif ?>
			</div>

		</div>
		<div class="clear-both"></div>
	</div>
</div>
<script type="text/javascript" charset="utf-8">

$(document).ready(function() {
    <?php if(@$savedata){
            echo "$.facebox('<h3>Your Changes Have Been Saved.</h3><br /><button class=\"cancel-facebox\" >OK</button>');";
        }
      ?>
var address = '<?=$job['address']?>';
	var city = '<?=$job['city']?>';
	var state = '<?=$job['state']?>';
	var jobstatus = $("select[name=current_status]").val();
	if(address != '' && city != '' && state != '')
	{
		showAddress('<?=$job['address']?>, <?=$job['city']?>, <?=$job['state']?>');
	}        
    

});
 </script>