<?php

class Admin extends Controller {

	function Admin()
	{
	     
              parent::Controller();
		if(!$this->session->userdata('logged_in'))
		{
		   $tempurl = explode("/index.php/", $_SERVER['PHP_SELF']);
                   redirect("login?ref=".$tempurl[1]);
		}
		//ini_set("display_errors",1);
		// if user is an installer, redirect them to an error page if
		// they're trying to do something they do have permissions to do
		if($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y')
		{
			$method = $this->router->method;
			$protected = array("delete_job");
			if(in_array($method,$protected))
			{
				redirect("admin/error?e=permissions");
			}
		}
                $this->getjoblimit();
                $this->load->helper(array('form', 'url'));
	}
	
	function index()
	{
		$data = array();
		
		$this->load->helper("date");
		
		$prefs = array (
			'start_day'    => 'sunday',
			'month_type'   => 'long',
			'day_type'     => 'short'
		);
		
		if(@$year=='') {$year = date("Y");}
		if(@$month=='') {$month = date("m");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$data['year'] = $year;
		$data['month'] = $month;
		
		// daily job limit
		$daily_limit = $this->db->get("job_limit")->row_array();
		$daily_limit = $daily_limit['limit'];
		$jobs = array();
		// get jobs for the current month
		$j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%m') = '".$year."-".$month."' ORDER BY jobs.job_date ASC")->result_array();
		foreach($j as $key => $value)
		{
			$jobs[date("j", strtotime($value['job_date']))][] = $value;
		}
		$days_count = days_in_month($month,$year);
		
		// grab service calls for the current month
		$sc = $this->db->query("SELECT service_calls.*,colors.hex, users.custom_hex, users.id as user_id FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(`date`,'%Y-%m') = '".$year."-".$month."' GROUP BY DATE_FORMAT(`date`,'%Y-%m-%d')")->result_array();
		// loop through them and assign their days as key values to make them easier to access when setup the calendar values
		$service_calls = array();
		$has_service_calls = array();
                $data['dates'] = null;
		foreach($sc as $key => $value)
		{
			if($value['job_count'] == '')
			{
				$has_service_calls[date("j",strtotime($value['date']))] = true;
			}
			$service_calls[date("j",strtotime($value['date']))] = $value['job_count'];
		}
		
		for($i=0; $i<($days_count + 1); $i++)
		{
			if(array_key_exists($i,$jobs) or array_key_exists($i,$service_calls))
			{
				if(array_key_exists($i,$service_calls))
				{
					$service_call_count = $service_calls[$i];
				}
				else
				{
					$service_call_count = 0;
				}
				
				if($this->session->userdata("role") == 'admin')
				{
					if(array_key_exists($i,$jobs))
					{
						if($jobs[$i][0]['hex'] == '')
						{
							$jobs[$i][0]['hex'] = '7DBB4C';
						}
						if($jobs[$i][0]['custom_hex'] != '') {
							$color = $jobs[$i][0]['custom_hex'];
						} else {
							$color = $jobs[$i][0]['hex'];
						}
						$data['dates'][$i] = '<div style="background:#'.$color.';" class="">';
					}
					else
					{
						if(array_key_exists($i,$service_calls))
						{
							$data['dates'][$i] = '<div class="">';
						}
					}
				}
				else
				{
					if(array_key_exists($i,$jobs))
					{
						// determine if user has any jobs on the current day
						$has_job_on_day = false;
						foreach($jobs[$i] as $day_job)
						{
							if($day_job['user_id'] == $this->session->userdata("user_id"))
							{
								$has_job_on_day = true;
							}
						}
						if ($has_job_on_day === true) {
							$data['dates'][$i] = '<div style="background:#'.$this->session->userdata("hex_color").';" class="">';
						} else {
							$data['dates'][$i] = '<div style="background:#7DBB4C;" class="">';
						}
					}
					else
					{
						if(array_key_exists($i,$service_calls))
						{
							$data['dates'][$i] = '<div class="">';
						}
					}
				}
				
				$day_job_count = max(@$jobs[$i][0]['job_count'],@$service_call_count);
				
				if($day_job_count < 1)
				{
					$day_job_count = 0;
				}
				$data['dates'][$i] .= '<a href="/ajax/preview_day/'.$year.'/'.$month.'/{day}" class="facebox day-view-url">
					<div class="job-count-home">';
				if($day_job_count < 2)
				{
					if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
					{
						$data['dates'][$i] .= '<a href="/ajax/preview_day/'.$year.'/'.$month.'/'.sprintf("%02d",$i).'" class="facebox day-view-url">';
					}
				}
				$data['dates'][$i] .= $day_job_count.'/'.$daily_limit;
				if($day_job_count < $daily_limit)
				{
					if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
					{
						@$data['dates'][$i] .= '</a>';
					}
				}
				$data['dates'][$i] .= '
						</a>
					</div>
					</a>
				</div>';
				$data['dates'][$i] .= '<div class="booked-day-home">';
				if(array_key_exists($i,$has_service_calls) or $service_call_count > 0)
				{
					$data['dates'][$i] .= '
					<!--<div class="service-calls"><a href="/ajax/service_calls/'.$year."/".$month."/".sprintf("%02d",$i).'" class="facebox">Service Calls</a></div>-->';
				}
				$data['dates'][$i] .= '
					<span style="color:#fff;">{day}</span>
				</div>';
			}
		}
		
		$prefs['template'] = '

		   {table_open}<table class="calendar2" border="0" cellpadding="0" cellspacing="1">{/table_open}

		   {heading_row_start}<tr>{/heading_row_start}
			
		   {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
		   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
		   {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}

		   {heading_row_end}</tr>{/heading_row_end}

		   {week_row_start}<tr class="week-days">{/week_row_start}
		   {week_day_cell}<td style="background-color:#7d7d7d; border:1px solid #7d7d7d;"><div align="left" style="color:#fff;">{week_day}</div></td>{/week_day_cell}
		   {week_row_end}</tr>{/week_row_end}

		   {cal_row_start}<tr>{/cal_row_start}
		   {cal_cell_start}<td>{/cal_cell_start}

			{cal_cell_content}
		    <div class="cell-inner-home">
				{content}
			</div>
			{/cal_cell_content}
			{cal_cell_content_today}
			<div class="cell-inner-home">
				{content}
			</div>
			{/cal_cell_content_today}

			{cal_cell_no_content}
			<div class="cell-inner-home">
				<div class="reserve-job-block-home">';
			
			if($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y')
			{
				
			}
			else
			{
				$prefs['template'] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Reserve a Job"><img src="/assets/images/blank.gif" /></a></div>';
			}
			
			$prefs['template'] .= '
				<span class="day-block2">{day}</span>
			</div>
			{/cal_cell_no_content}
			{cal_cell_no_content_today}
			<div class="cell-inner-home">
				<div class="reserve-job-block-home">';
			
			if($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y')
			{
				
			}
			else
			{
				$prefs['template'] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Reserve a Job"><img src="/assets/images/blank.gif" /></a></div>';
			}
				
			$prefs['template'] .= '
				<span class="day-block2">{day}</span>
			</div>
			{/cal_cell_no_content_today}

		   {cal_cell_blank}&nbsp;{/cal_cell_blank}

		   {cal_cell_end}</td>{/cal_cell_end}
		   {cal_row_end}</tr>{/cal_row_end}

		   {table_close}</table>{/table_close}
		';
		
		$this->load->library('calendar',$prefs);
		
		$yearmonth = (date("Y")-1)."01";		
		$data['year_m'] = array();		
		$calender_select =array();
		//$data['year_m'][''] = 'Select';
		for($i=date("Y",strtotime("-3 years")); $i<date("Y",strtotime("+3 years")); $i++)
		{
			$data['year_m'][$i] = $i;
		}		
		
		$data['month_m'] = array();
		//@$data['month_m']['']= "Select";
		for ($i = 1; $i <= 12; $i++)
		{
			if($i < 10)
			$m = "0".$i;
			else
			$m = $i;
			
			
			@$data['month_m'][$m]= date("F", mktime(0, 0, 0, $i+1, 0, 0, 0));
			
		}
		
		$days_count = days_in_month(substr($yearmonth,-2,2),substr($yearmonth,0,4));
		//$data['day_dd'][''] = "Select";
                for($i=1; $i<$days_count+1; $i++)
		{
			$data['day_dd'][sprintf("%02d",$i)] = sprintf("%02d",$i);
		}		
		
		
		
		
			@$data["searchto"]="";
			@$data["searchfrom"]="";			
		
			$current_date = date("Y-m-d");
		
			if($this->input->get("frommonth") !="" && $this->input->get("fromday")!="" && $this->input->get("fromyear") !="")
			{
				$fromdate=$this->input->get("fromyear").$this->input->get("frommonth").$this->input->get("fromday");				
				@$data["searchfrom"]=$fromdate;
				
			}
			if($this->input->get("month") !="" && $this->input->get("day")!="" && $this->input->get("year") !="")
			{
				$todate=$this->input->get("year").$this->input->get("month").$this->input->get("day");
				@$data["searchto"]=$todate;	
			}
			
			
			if($this->input->get("frommonth") == "")			
			$data['frommonth'] = date("m")-1;
			else
			$data['frommonth'] = $this->input->get("frommonth");
			
			if($this->input->get("fromday") == "")			
			$data['fromday'] = date("d");
			else
			$data['fromday'] = $this->input->get("fromday");		
			
			if($this->input->get("fromyear") == "")			
			$data['fromyear'] = date("Y");
			else
			$data['fromyear'] = $this->input->get("fromyear");				
			
			if($this->input->get("month") == "")			
			$data['month'] = date("m");
			else
			$data['month'] = $this->input->get("month");
			
			if($this->input->get("day") == "")			
			$data['day'] = date("d");
			else
			$data['day'] = $this->input->get("day");		
			
			if($this->input->get("year") == "")			
			$data['year'] = date("Y");
			else
			$data['year'] = $this->input->get("year");			

		
		$this->load->view("common/header");
		if( $this->session->userdata("role") == 'sales' || ( $this->session->userdata("role") == 'admin' &&  $this->session->userdata('superadmin') )  ){		
			$sql = "select * from users where type = 'sales'  and user_status='active'";
			$data['user_details'] = $this->db->query($sql)->result_array();				
			$sql = "select * from module_brands where 1 ";
			$data['module_brands'] = $this->db->query($sql)->result_array();
                        $sqlsaleuser = "select * from users where type = 'sales' and user_status='active'";
                        $row_saleuser=$this->db->query($sqlsaleuser)->result_array();
                        foreach($row_saleuser as $saleuserd)
                        $data['ssalesuser'][$saleuserd['id']]=ucfirst($saleuserd["first_name"][0])."".strtoupper($saleuserd["last_name"][0].$saleuserd["last_name"][1]);
			$this->load->library("saleattainment");
			$this->load->view("admin/salesindex",$data);
		}else{
			$this->load->view("admin/index",$data);
		}
		$this->load->view("common/footer");
	}

	function usergraph($id=0)
	{
        $this->load->helper('download');
        $this->load->helper("thumbnail_helper");
		$sql = "select * from users where type = 'sales' ";
		$data['user_details'] = $this->db->query($sql)->result_array();		
		$sql = "select * from module_brands where 1 ";
		$data['module_brands'] = $this->db->query($sql)->result_array();
		$data['user_id'] = $id;
        $t = rand(1, 99999);
	    $current_date = date("Y-m-d");
		$to_date 	= $this->input->get("to_date");
		$from_date	= $this->input->get("from_date");		
		if($this->input->get("to_date") =="" && $this->input->get("from_date")=="")
		{
			$sql = "SELECT DATE_SUB('$current_date', INTERVAL 1 MONTH) as lastmonthdate";
			$result = $this->db->query($sql)->result_array();		
			$from_date =  date("m/d/Y", strtotime($result[0]['lastmonthdate']));
			$to_date =  date("m/d/Y", strtotime($current_date));
		}	
		$todate=explode("/",$to_date);		
		$fromdate=explode("/",$from_date);	
		@$data["searchto"]=$todate[2].$todate[0].$todate[1];
		@$data["searchfrom"]=$fromdate[2].$fromdate[0].$fromdate[1];			
		$data['user_id'] = $id;	
		$this->load->library("saleattainment");
		$html=$this->load->view("admin/salesgraph",$data,true);
               // echo $html;
                /*if($id==35) {
                    echo $html;
                    die;
                }*/
                $data["sales_user"] = $this->db->query("SELECT * from users where id=".$id." ")->row_array();
		$fp = fopen(FCPATH . "pdftemp/temp$t-$id.html","w+");
        fputs ($fp, $html);
        fclose ($fp);
         $footer_html = $this->load->view("admin/footer",$data,true);
           $footer_t = rand(1, 99999);
           $footer_fp = fopen(FCPATH . "pdftemp/footer$footer_t-$id.html","w+");
           fputs ($footer_fp, $footer_html);
           fclose ($footer_fp);
           $footerhtml =FCPATH . "pdftemp/footer$footer_t-$id.html";
        exec("/var/www/vhosts/aeihawaii.com/httpdocs/page/wkhtmltopdf-i386 -B 20  --page-size A4 " . FCPATH . "pdftemp/temp$t-$id.html  --footer-html  $footerhtml  " . FCPATH . "pdftemp/proposal$t-$id.pdf ");
        $data_file = file_get_contents(FCPATH . "pdftemp/proposal$t-$id.pdf"); // Read the file's contents
        @$name = "salegraph".$id.".pdf";
        force_download($name, $data_file);
        unlink(FCPATH . "pdftemp/temp$t.html");
        unlink(FCPATH . "pdftemp/proposal$t.pdf");
	
	}
	
	function   jobschedule($year='',$month='')
	{
		$this->load->library("job");
		$this->load->helper("date");
		
		$data = array();
		
		$prefs = array (
			'start_day'    => 'sunday',
			'month_type'   => 'long',
			'day_type'     => 'long'
		);
		
		$jobs = array();
                $job_type = array();
		$inverter_types = $this->db->get("job_types")->result_array();
		foreach($inverter_types as $row)
		{
			$job_type[$row['id']] = $row['intials'];
		}
                //$job_type[6] = 'Prelag';
                $sql = "SELECT homepage FROM home_page WHERE user_id=".$this->session->userdata("user_id");
                $row = array();
                $row = $this->db->query($sql)->result_array();
                $newhomepage=array();
                if (count($row) && @$row[0]['homepage']){
                   $newhomepage = explode("/",$row[0]['homepage']);
                   
                }
              
		if($year=='') {
                    $year = date("Y");
                    if (count($newhomepage)>2 && $newhomepage[2]){
                        $year = $newhomepage[2];
                        
                    }
                }
		if($month=='') {
                    $month = date("m");
                    if (count($newhomepage)>2 && $newhomepage[3]){
                        $month = $newhomepage[3];
                    }
                }
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$data['year'] = $year;
		$data['month'] = $month;
		
		// daily job limit
		$daily_limit = $this->db->get("job_limit")->row_array();
		$daily_limit = $daily_limit['limit'];
		
		// create calendar and year dd values and set which should be preselected
		$data['calendar_months'] = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
		$data['calendar_years'] = array();
		for($i=date("Y",strtotime("-3 years")); $i<date("Y",strtotime("+3 years")); $i++)
		{
			$data['calendar_years'][$i] = $i;
		}
		$data['calendar_month'] = $data['month'];
		$data['calendar_year'] = $data['year'];
			
		// get jobs for the current month
		$pv_sql = "";
                $pv_sql = " AND jobs.job_type_id in(1,2,3,5,6,7,8,9,15,16,20,21,17) ";
          if($this->session->userdata("role")!="admin" ){
             //$pv_sql = " AND jobs.user_id=".$this->session->userdata("user_id");
		  }
          if( $this->session->userdata("role") == 'installer'){
		  $pv_sql = " AND  FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",installer_id)";
                  
		}
                  if( $this->session->userdata("role") == 'contractor')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",contractor_id)";
                  
		}
                 /*if( $this->session->userdata("rolep") == 'engineer')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",designer_id)";
                  
		}*/
                $j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%m') = '".$year."-".$month."' $pv_sql ORDER BY jobs.job_date ASC")->result_array();
		foreach($j as $key => $value)
		{
			$jobs[date("j", strtotime($value['job_date']))][] = $value;
		}
		$days_count = days_in_month($month,$year);
		
		// grab service calls for the current month
		$sc = $this->db->query("SELECT service_calls.*,colors.hex, users.custom_hex, users.id as user_id FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(`date`,'%Y-%m') = '".$year."-".$month."' GROUP BY DATE_FORMAT(`date`,'%Y-%m-%d')")->result_array();
		// loop through them and assign their days as key values to make them easier to access when setup the calendar values
		$service_calls = array();
		$has_service_calls = array();
		foreach($sc as $key => $value)
		{
			if($value['job_count'] == '')
			{
                            $has_service_calls[date("j",strtotime($value['date']))] = true;
			}
			$service_calls[date("j",strtotime($value['date']))] = $value['job_count'];
		}
		
		#die(print(count($service_calls)));
                $adminblock_date = array();
		$inverter_types = $this->db->query("SELECT * FROM admin_block_date WHERE   DATE_FORMAT(block_date,'%Y-%m') = '".$year."-".$month."' ")->result_array();
		foreach($inverter_types as $row => $value){
                     $adminblock_date[date("j",strtotime($value['block_date']))] = $value['message'];
		}
		
		for($i=0; $i<($days_count+1); $i++)
		{
		    if(array_key_exists($i,$adminblock_date) ){
                        $data['dates'][$i] = '<div style="background:#333333;" class="booked-day-wrap "><div style="margin-right:110px;">'.$i.'</div><div  style="color:white;"><br/><br/>'.$adminblock_date[$i].'</div></div>';
                        
                        
                    }else if(array_key_exists($i,$jobs) or array_key_exists($i,$service_calls))
			{	
				if(array_key_exists($i,$service_calls))
				{
					$service_call_count = $service_calls[$i];
				}
				else
				{
					$service_call_count = 0;
				}
				
				if($this->session->userdata("role") == 'admin')
				{
					if(array_key_exists($i,$jobs))
					{
						if($jobs[$i][0]['hex'] == '')
						{
							$jobs[$i][0]['hex'] = '7DBB4C';
						}
						if($jobs[$i][0]['custom_hex'] != '') {
							$color = $jobs[$i][0]['custom_hex'];
						} else {
							$color = $jobs[$i][0]['hex'];
						}
						$data['dates'][$i] = '<ul class="iconList"><li><a href="'.base_url().'ajax/loadjobsetting/'.$year.'/'.$month.'/{day}" class="facebox job-setting-count tooltip" title=" Job Setting"><img src="'.base_url().'/assets/images/magnifier1.png" /></a></li><li><a href="'.base_url().'ajax/quick_summary/'.$year.'/'.$month.'/{day}" class="facebox quick-summary tooltip" title="Quick Summary"><img src="/assets/images/magnifier.png" /></a></li></ul><div  class="booked-day-wrap">';
					}
					else
					{
						if(array_key_exists($i,$service_calls))
						{
							$data['dates'][$i] = '<div class="booked-day-wrap2" >';
						}
					}
				}
				else
				{
					if(array_key_exists($i,$jobs))
					{
						// determine if user has any jobs on the current day
						$has_job_on_day = false;
						foreach($jobs[$i] as $day_job)
						{
							if($day_job['user_id'] == $this->session->userdata("user_id"))
							{
								$has_job_on_day = true;
							}
						}
						if ($has_job_on_day === true) {
							$data['dates'][$i] = '<a href="'.base_url().'ajax/quick_summary/'.$year.'/'.$month.'/{day}" class="facebox quick-summary tooltip" title="Quick Summary"><img src="/assets/images/magnifier.png" /></a><div  class="booked-day-wrap" {style_wrap} >';
						} else {
							$data['dates'][$i] = '<a href="'.base_url().'ajax/quick_summary/'.$year.'/'.$month.'/{day}" class="facebox quick-summary tooltip" title="Quick Summary"><img src="/assets/images/magnifier.png" /></a><div class="booked-day-wrap " {style_wrap} >';
						}
					}
					else
					{
						if(array_key_exists($i,$service_calls))
						{
							$data['dates'][$i] = '<div class="booked-day-wrap2" >';
						}
					}
				}
				
				$day_job_count = 0;
                                $service_job_count = 0 ;
				$dayData = "";
                                $new_dayData=array();
                                $pvjob_count=0;
                                $swhjob_count=0;
                                $pljob_count=0;
                                $pmjob_count=0;
                                $swhpmjob_count=0;
                                $eljob_count=0;
                                $acjob_count=0;
                                $acmjob_count=0;
								$safjob_count=0;
                                $evjob_count=0;
                                $apjob_count=0;

				if(array_key_exists($i,$jobs))
				{
			            $jobcounter = 1;
                                    $temp = false;
                                     foreach(@$jobs[$i] as $tj)
					{
                                            if($tj['custom_hex'] != '') {
							$color = $tj['custom_hex'];
						} else {
							$color = $tj['hex'];
						}
                                                $currentinstaller = true;
                                                if($this->session->userdata("role")=='installer'){
                                                    $getinstaller = explode(",",$tj['installer_id']);
                                                    if (in_array($this->session->userdata("user_id"),$getinstaller)){
                                                        $currentinstaller = false;
                                                         $color = $this->getUserColor($this->session->userdata("user_id"));
                                                    }
                                                }
                                                if($this->session->userdata("role")=='contractor'){
                                                    $getinstaller = explode(",",$tj['contractor_id']);
                                                    if ($this->session->userdata("user_id")==$tj['contractor_id']){
                                                        $currentinstaller = false;
                                                        $color = $this->getUserColor($this->session->userdata("user_id"));
                                                    }
                                                }
                                                 if($this->session->userdata("role")=='designer'){
                                                    $getinstaller = explode(",",$tj['designer_id']);
                                                    if ($this->session->userdata("user_id")==$tj['designer_id']){
                                                        $currentinstaller = false;
                                                        $color = $this->getUserColor($this->session->userdata("user_id"));
                                                    }
                                                }

                                                
                                                if ($this->session->userdata("role") != 'admin' && $tj['user_id']!=$this->session->userdata("user_id") && $currentinstaller){
                                                   $color = "7dbb4b";
                                                   if ($jobcounter>5){
                                                    if(!$temp) {
                                                        //$new_dayData[]= '<a title="Day View" class="tooltip quick-dayview" href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;"><img src="'.base_url().'assets/images/day-view.png"></a>';
                                                        $dayData .= '<a title="Day View" class="tooltip quick-dayview" href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;"><img src="'.base_url().'assets/images/day-view.png"></a>';
                                                        $temp =true;
                                                    }
                                                   }else{
                                                     $dayData .= '<div style="background:#'.$color.';text-align:left;margin:3px;height:16px;">'.$job_type[$tj['job_type_id']].",".$this->getCustomerLastname($tj['customer_id']).",". $this->getUserIntial($tj['user_id']).'</div>';
                                                     
                                                     if($tj['job_type_id']==6 || $tj['job_type_id']==7 || $tj['job_type_id']==15  || $tj['job_type_id']==17){
                                                        $height=16;
                                                        $neighbour_job = $this->getCustomerNeighborhood($tj['customer_id']);
                                                        if(strlen($neighbour_job)>13){
                                                            $height=23;
															if(strlen($neighbour_job)>20){
                                                               $height=33;
															 }
                                                        }
                                                      // $new_dayData[] = '<div style="background:#'.$color.';text-align:left;margin:1px;height:'.$height.'px;">'.$job_type[$tj['job_type_id']].",".$neighbour_job.'</div>';
                                                     }else{
                                                     // $new_dayData[] = '<div style="background:#'.$color.';text-align:left;margin:3px;height:16px;">'.$job_type[$tj['job_type_id']].",".$this->getCustomerNeighborhood($tj['customer_id']).'</div>';    
                                                     }  
                                                   }
                                                } else{
                                                   if ($jobcounter>5){
                                                       $temp =false;
                                                    if(!$temp) {
                                                        unset($new_dayData[4]);
                                                        $dayData .= '<a title="Day View" class="quick-dayview  tooltip" href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;"><img src="'.base_url().'assets/images/day-view.png"></a>';
                                                        $new_dayData[5]= '<a title="Day View" class="quick-dayview tooltip" href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;"><img src="'.base_url().'assets/images/day-view.png"></a>';
                                                        $new_temp= '<a href="'.base_url().'admin/job_comment/'.$tj['id'].'" style="color:white;"><div style="background:#'.$color.';text-align:left;margin:3px;height:16px;">'.$job_type[$tj['job_type_id']].",".$this->getCustomerLastname($tj['customer_id']).",". $this->getUserIntial($tj['user_id']).'</div></a>';
                                                        if($tj['job_type_id']==6 || $tj['job_type_id']==7 || $tj['job_type_id']==15 || $tj['job_type_id']==17){
                                                            $height=16;
                                                            $neighbour_job = $this->getCustomerNeighborhood($tj['customer_id']);
                                                            if(strlen($neighbour_job)>10){
                                                                $height=23;
																if(strlen($neighbour_job)>20){
                                                                   $height=33;
																}
                                                            }
                                                            $new_temp = '<a href="'.base_url().'admin/job_comment/'.$tj['id'].'" style="color:white;"><div style="background:#'.$color.';text-align:left;margin:3px;height:'.$height.'px;">'.$job_type[$tj['job_type_id']].",".$this->getCustomerLastname($tj['customer_id']).",".$neighbour_job."</div></a>";
                                                        }
                                                        array_unshift($new_dayData, $new_temp);
                                                        $temp =true;
                                                        
                                                       }
                                                   } else {
                                                       $dayData .= '<a href="'.base_url().'admin/job_comment/'.$tj['id'].'" style="color:white;"><div style="background:#'.$color.';text-align:left;margin:3px;height:16px;">'.$job_type[$tj['job_type_id']].",".$this->getCustomerLastname($tj['customer_id']).",". $this->getUserIntial($tj['user_id']).'</div></a>';
                                                       $new_temp= '<a href="'.base_url().'admin/job_comment/'.$tj['id'].'" style="color:white;"><div style="background:#'.$color.';text-align:left;margin:3px;height:16px;">'.$job_type[$tj['job_type_id']].",".$this->getCustomerLastname($tj['customer_id']).",". $this->getUserIntial($tj['user_id']).'</div></a>';
                                                       if($tj['job_type_id']==6 || $tj['job_type_id']==7 ){
                                                        $height=16;
                                                        $neighbour_job = $this->getCustomerNeighborhood($tj['customer_id']);
                                                        if(strlen($neighbour_job)>10){
                                                                $height=23;
																if(strlen($neighbour_job)>25){
                                                                $height=33;
                                                         }
	                                                    }
                                                        $new_temp = '<a href="'.base_url().'admin/job_comment/'.$tj['id'].'" style="color:white;"><div style="background:#'.$color.';text-align:left;margin:3px;height:'.$height.'px;">'.$job_type[$tj['job_type_id']].",".$this->getCustomerLastname($tj['customer_id']).",".$neighbour_job."</div></a>";
                                                       }
                                                       array_unshift($new_dayData, $new_temp);
                                                   }
                                                }
                                                $jobcounter++;
                                                
                                            if($tj['job_type_id']!=5  ){
                                               
                                                $day_job_count += (int)$tj['job_count'];
                                                 if($tj['job_type_id']==2  ){
                                                    $pvjob_count++; 
                                                 }
                                                 if($tj['job_type_id']==1){
                                                     $swhjob_count++; 
                                                 }
                                                 if($tj['job_type_id']==6){
                                                   $pljob_count++;  
                                                 }
												 if($tj['job_type_id']==17){
                                                   $apjob_count++;  
                                                 }
                                               if($tj['job_type_id']==7){
                                                   $pmjob_count++;
                                                 }
											   if($tj['job_type_id']==8){
                                                   $eljob_count++;
                                                 }
												 if($tj['job_type_id']==9){
                                                   $swhpmjob_count++;
                                                 }
											   if($tj['job_type_id']==15){
                                                   $acmjob_count++;
                                                }
											    if($tj['job_type_id']==16){
                                                   $acjob_count++;
                                                 }
												 if($tj['job_type_id']==20){
                                                   $safjob_count++;
                                                 }
                                                 if($tj['job_type_id']==21){
                                                   $evjob_count++;
                                                 }
                                            }
                                            if($tj['job_type_id']==5){
                                               
                                                $service_job_count += (int)$tj['job_count'];
                                               
                                            }
					}
				}
				
				//$day_job_count += @$service_call_count;

                                $job_count_message = "";


				if($day_job_count < 1)
				{
					$day_job_count = 0;
				}else{
                                 if($pvjob_count){
                                   $job_count_message .= "$pvjob_count P,";
                                     
                                 }
                                 if($swhjob_count){
                                   $job_count_message .= "$swhjob_count W,";
                                     
                                 }
                                 if($pljob_count){
                                   $job_count_message .= "$pljob_count L,";
                                     
                                 }
								 if($apjob_count){
                                   $job_count_message .= "$apjob_count AP,";
                                     
                                 }
                                 if($pmjob_count){
                                   $job_count_message .= "$pmjob_count M,";

                                 }
								if($eljob_count){
                                   $job_count_message .= "$eljob_count EL,";

                                 }
								if($acjob_count){
                                   $job_count_message .= "$acjob_count A,";

                                 } 
								if($acmjob_count){
                                   $job_count_message .= "$acmjob_count AM,";

                                 }
								 if($safjob_count){
                                   $job_count_message .= "$safjob_count SAF,";

                                 }
                                 if($evjob_count){
                                   $job_count_message .= "$evjob_count EV,";

                                 }
                                }
                                $service_count_message = "";
                                if($service_job_count < 1)
				{
					$service_job_count = 0;
				}else{
                                 $service_count_message = "$service_job_count S,";
								 
                                $space_nbsp= "&nbsp;&nbsp;";
								//$data['dates'][$i]=str_replace("{style_wrap}","",$data['dates'][$i]);
								if($this->session->userdata("role")=="admin" ){
								 $service_count_message ="";
								  $job_count_message="";
								}
                                //$space_nbsp="";
                                if($service_job_count && $day_job_count ){
                                    if($pvjob_count && ($swhjob_count || $eljob_count) && $pljob_count){
                                     $space_nbsp="";
                                     $service_count_message = "$job_count_message  $service_count_message";
                                    }else{
                                        
                                        $service_count_message = "$job_count_message  $service_count_message";
                                    }
                                }else if($service_job_count) {
                                     $service_count_message = "$service_count_message";
                                }else if($day_job_count){
                                    $service_count_message = "$job_count_message";
                                }
				$service_count_message=substr($service_count_message,0,-1);
				if(strlen($service_count_message)>22)
                                  $data['dates'][$i]=str_replace("{style_wrap}","style='margin-top:9px;'".strlen($service_count_message),$data['dates'][$i]);
                                }

				$data['dates'][$i]=str_replace("{style_wrap}","",$data['dates'][$i]);
				$data['dates'][$i] .= '	<div class="jobconpan">';

				if($day_job_count < $daily_limit)
				{
					if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
					{
						//$data['dates'][$i] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/'.sprintf("%02d",$i).'" class="facebox reserve-job reserve-inner tooltip" title="Reserve a Job">';
					}
				}
				$acpmjob_count=$acmjob_count;
				//$swhpmjob_count=$acmjob_count;
				//$data['dates'][$i] .= implode(" ",$new_dayData);
				 if($this->session->userdata("role")=="admin" ){
                if($pvjob_count || $pmjob_count || $pljob_count || $acjob_count || $acpmjob_count || $swhjob_count || $swhpmjob_count || $service_job_count || $eljob_count  || $safjob_count || $evjob_count || $apjob_count ){
				$data['dates'][$i] .= '<div class="dateWrap"><ul class="dateLeft">';
	        	if($pvjob_count || $pmjob_count || $pljob_count || 1){
                  $pvmsg="";
				  if($pvjob_count ){
                   $pvmsg='<a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$pvjob_count.' PV </a>';
				  } else {
                    $pvmsg='<p style="color:#ccc">'.$pvjob_count.' PV </p>';
				  }
				  $pmmsg="";
				  if(($pmjob_count && $pljob_count)){
                   $pmmsg='<a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$pmjob_count.' PM ,'.$pljob_count.'PL </a>';
				  }else if ($pmjob_count){
					$pmmsg= '<div style="display:inline;"><a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$pmjob_count.' PM'.'</a>,<p style="color:#ccc;display:inline;"> 0 PL </p> </div>';
				  }else if ($pljob_count){
					$pmmsg='<div style="display:inline;">  <p style="color:#ccc;display:inline;"> 0 PM </p>,<a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$pljob_count.' PL</a> </div>';
				  }else{
					$pmmsg='<p style="color:#ccc;"> 0 PM , 0 PL</p>';
				  }

				 $data['dates'][$i] .='<li class="green"><span>'. $pvmsg.'</span>'.$pmmsg.'</li>';
				}
				if($acjob_count||$acpmjob_count || 1 ){
			       $acmsg="";
				  if($acjob_count){
                   $acmsg='<a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$acjob_count.' AC </a>';
				  } else {
                    $acmsg='<p style="color:#ccc;"> '.$acjob_count.' AC </p>';
				  }
				  $ammsg="";
				  if($acpmjob_count){
                   $ammsg='<a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$acpmjob_count.' APM </a>';
				  } else {
				     $ammsg='<p style="color:#ccc;"> '.$acpmjob_count.' APM </p>';
				  }

				   if($apjob_count){
                   $apmsg='<a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$apjob_count.' AP </a>';
				  } else {
				     $apmsg='<p style="color:#ccc;"> '.$apjob_count.' AP </p>';
				  }
		          $data['dates'][$i] .='<li class="orange"><span>'.$acmsg.' </span>'.$ammsg.$apmsg.' </li>';
				}
				if($swhjob_count || $swhpmjob_count || 1 ){
				  $swhmsg="";
				  if($swhjob_count ){
                   $swhmsg='<a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$swhjob_count.' W </a>';
				  } else{
				   $swhmsg='<p style="color:#ccc;"> '.$swhjob_count.' W </p>';	
				  }
				  $wmmsg="";
				  if($swhpmjob_count ){
                   $wmsg='<a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$swhpmjob_count.' WM </a>';
				  } else {
				   $wmsg='<p style="color:#ccc;"> '.$swhpmjob_count.' WM </p>';	
				  }
	             $data['dates'][$i] .= '<li class="blue"><span>'.$swhmsg.'</span>'.$wmsg.' </li>';
				}
				$data['dates'][$i] .= '</ul>';
				if ($service_job_count || $eljob_count || 1  ) { 
				$data['dates'][$i] .='<ul class="dateRight">';
				if($service_job_count ){
					$data['dates'][$i] .=	'<li><a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$service_job_count.' SC </a></li>';
				}else{
					$data['dates'][$i] .=	'<li><p style="color:#ccc;">'.$service_job_count.' SC</p></li>';
				}  
				if($eljob_count){
					$data['dates'][$i] .=    '<li><a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$eljob_count.' EL</a></li>';
				} else{
					$data['dates'][$i] .=    '<li><p style="color:#ccc;">'.$eljob_count.' EL</p></li>';
				}
				if($safjob_count){
					$data['dates'][$i] .=    '<li><a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$safjob_count.' SAF</a></li>';
				} else{
					$data['dates'][$i] .=    '<li><p style="color:#ccc;">0 SAF</p></li>';
				}
                                if($evjob_count){
					$data['dates'][$i] .=    '<li><a title="Day View"  href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" style="cursor: pointer;">'.$evjob_count.' EV</a></li>';
				} else{
					$data['dates'][$i] .=    '<li><p style="color:#ccc;">0 EV</p></li>';
				}

                 $data['dates'][$i] .= '</ul>'; 
				}
				 $data['dates'][$i] .='</div>';
			   } }else{
					$data['dates'][$i] .= implode(" ",$new_dayData);
			   }
				if($day_job_count < $daily_limit)
				{
					if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
					{
						//$data['dates'][$i] .= '</a>';
					}
				}
				$data['dates'][$i] .= '
						
					</div>
					
				</div>';
				$data['dates'][$i] .= '<div class="booked-day">';
					//$data['dates'][$i] .= $job_count_message.' '.$service_count_message;
				$data['dates'][$i] .= '
					<span style="color:#fff;">{day} '.$space_nbsp.'<a href="'.base_url().'admin/day/'.$year.'/'.$month.'/{day}" class="day-view-url tooltip" title="Go To Day View"> <span style="font:underline;text-decoration: underline;">'. $service_count_message.'</span> </a></span></div>';
			}
		}
		
		$prefs['template'] = '

		   {table_open}<table class="calendar" border="0" cellpadding="0" cellspacing="1">{/table_open}

		   {heading_row_start}<tr>{/heading_row_start}
			
		   {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
		   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
		   {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}

		   {heading_row_end}</tr>{/heading_row_end}

		   {week_row_start}<tr class="week-days">{/week_row_start}
		   {week_day_cell}<td style="background-color:#7d7d7d; border:1px solid #7d7d7d;"><div align="left" style="color:#fff;">{week_day}</div></td>{/week_day_cell}
		   {week_row_end}</tr>{/week_row_end}

		   {cal_row_start}<tr>{/cal_row_start}
		   {cal_cell_start}<td>{/cal_cell_start}

			{cal_cell_content}
		    <div class="cell-inner-big">
				
				{content}
			</div>
			{/cal_cell_content}
			{cal_cell_content_today}
			<div class="cell-inner-big">
				
				{content}
			</div>
			{/cal_cell_content_today}

			{cal_cell_no_content}
			<div class="cell-inner-big">
				<div class="reserve-job-block">';
			
			if($this->session->userdata("role") == 'admin')
			{
				$prefs['template'] .= '<ul class="iconList"><li><a href="'.base_url().'ajax/loadjobsetting/'.$year.'/'.$month.'/{day}" class="facebox job-setting-count tooltip" title=" Job Setting"><img src="'.base_url().'/assets/images/magnifier1.png" /></a></li></ul><a href="'.base_url().'ajax/block_day_form/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Block A Day"><img src="/assets/images/blank.gif" /></a></div>';
			}
			
			$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content}
			{cal_cell_no_content_today}
			<div class="cell-inner-big">
				<div class="reserve-job-block">';
			
			if($this->session->userdata("role") == 'admin')
			{
				$prefs['template'] .= '<ul class="iconList"><li><a href="'.base_url().'ajax/loadjobsetting/'.$year.'/'.$month.'/{day}" class="facebox job-setting-count tooltip" title=" Job Setting"><img src="'.base_url().'/assets/images/magnifier1.png" /></a></li></ul><a href="'.base_url().'ajax/block_day_form/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Block A Day"><img src="/assets/images/blank.gif" /></a></div>';
			}
			$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content_today}

		   {cal_cell_blank}&nbsp;{/cal_cell_blank}

		   {cal_cell_end}</td>{/cal_cell_end}
		   {cal_row_end}</tr>{/cal_row_end}

		   {table_close}</table>{/table_close}
		';
		
		$this->load->library('calendar',$prefs);
		$this->load->view("common/header");
		$this->load->view("admin/jobschedule",$data);
		$this->load->view("common/footer");
	}
	
	function day($year='',$month='',$day='',$installeravail = 0)
	{
		$this->load->helper("text");
		
		$data = array();
		$data['timeframe'] = array();
                $data['timeframe'][0]="Not Selected";
                $data['timeframe'][1]="9:00am-12:00am";
                $data['timeframe'][2]="1:00pm-4:00pm";
                $data['timeframe'][3]= "All Day";
		if($year == '' or $month == '' or $day == '') { redirect("admin/error?e=no_day");}
		
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = $day;
                if(!$installeravail){
                   $installeravail=$this->getInstallerDay($year,$month,$day);
                }
		$data['installeravail'] = $installeravail;
		$data['day_timestamp'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		// daily job limit
		$data['daily_limit'] = $this->db->get("job_limit")->row_array();
		
		$extra_sql = '';
                $pv_sql ='';
                $data['editjob'] = true;
		if($this->session->userdata("role") == 'sales' )
		{
		   //$extra_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));
           //$pv_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));
		   $data['editjob'] = false;

		}
                if( $this->session->userdata("role") == 'installer')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",installer_id)";
                  $data['editjob'] = false;
		}
                  if( $this->session->userdata("role") == 'contractor')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",contractor_id)";
                  $data['editjob'] = false;
		}
                if( $this->session->userdata("role") == 'designer_id')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",designer_id)";
                  $data['editjob'] = false;
		}
		// grab photovoltaic jobs
		 $sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex,
			UPPER(concat(SUBSTR(usr.first_name, 1, 1) , SUBSTR(usr.last_name, 1, 1) )) as contactor_name
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN users as usr ON jobs.contractor_id=usr.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='2' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql
			";
		$data['pv_job'] = $this->db->query($sql)->result_array();
               $data['pv_jobs']=array();
                foreach($data['pv_job'] as $pv_job) {
                   if($pv_job['installer_id']!="" && $pv_job['installer_id']){
                     $show_instaler = explode("," ,$pv_job['installer_id']);
                     $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        if(@isset($userload[0]->first_name) && @isset($userload[0]->last_name)){
                            @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                        }
                    }
                    $pv_job["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $pv_job["showinstaller"] = " ";
                }
                
                if($pv_job['contractor_id']!="" && $pv_job['contractor_id']){
                    $show_instaler = explode("," ,$pv_job['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $pv_job["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $pv_job["showelectrican"]= " ";
                }
		// find other active jobs for customer that this job belongs to
		
                $install_assign = $pv_job['installer_id'];
                $installer_assign_array = explode("," ,$install_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $pv_job['installer_assign']=array();
                $pv_job['installer_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$installer_assign_array )){
                          $pv_job['installer_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $pv_job['installer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }
                $conduit_assign = $pv_job['conduit_id'];
                $conduit_array = explode("," ,$conduit_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $pv_job['conduit_assign']=array();
                $pv_job['conduit_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$conduit_array )){
                          $pv_job['conduit_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $pv_job['conduit_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }    
                
                $this->db->where('type','contractor');
		$contractors = $this->db->get("users")->result_array();
		foreach($contractors as $row) { 
                    $pv_job['contractors'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row['last_name']); 
                    
                } 
                $data['pv_jobs'][]=$pv_job;
             }
		//print_R($data['pv_jobs']);
                //die;
		// grab solar water heating jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='1' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql
		";
		$data['swh_jobs'] = $this->db->query($sql)->result_array();
		
		// grab solar attic fan jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='3' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['saf_jobs'] = $this->db->query($sql)->result_array();
		$sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='6' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['pl_job'] = $this->db->query($sql)->result_array();
                $data['pl_jobs']=array();
		// get service calls for the day
                foreach($data['pl_job'] as $pv_job) {
                   if($pv_job['installer_id']!="" && $pv_job['installer_id']){
                     $show_instaler = explode("," ,$pv_job['installer_id']);
                     $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = @ucfirst($userload[0]->first_name)." ".@ucfirst($userload[0]->last_name);
                    }
                    $pv_job["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $pv_job["showinstaller"] = " ";
                }
                
                if($pv_job['contractor_id']!="" && $pv_job['contractor_id']){
                    $show_instaler = explode("," ,$pv_job['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $pv_job["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $pv_job["showelectrican"]= " ";
                }
		// find other active jobs for customer that this job belongs to
		
                $install_assign = $pv_job['installer_id'];
                $installer_assign_array = explode("," ,$install_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $pv_job['installer_assign']=array();
                $pv_job['installer_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$installer_assign_array )){
                          $pv_job['installer_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $pv_job['installer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }
                $conduit_assign = $pv_job['conduit_id'];
                $conduit_array = explode("," ,$conduit_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $pv_job['conduit_assign']=array();
                $pv_job['conduit_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$conduit_array )){
                          $pv_job['conduit_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $pv_job['conduit_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }    
                
                 
                $data['pl_jobs'][]=$pv_job;
             }

             $sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='7' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['pm_job'] = $this->db->query($sql)->result_array();
                $data['pm_jobs']=array();
                //;
		// get service calls for the day
                foreach($data['pm_job'] as $pv_job) {
                   if($pv_job['installer_id']!="" && $pv_job['installer_id']){
                     $show_instaler = explode("," ,$pv_job['installer_id']);
                     $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $pv_job["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $pv_job["showinstaller"] = " ";
                }

                if($pv_job['contractor_id']!="" && $pv_job['contractor_id']){
                    $show_instaler = explode("," ,$pv_job['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $pv_job["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $pv_job["showelectrican"]= " ";
                }
		// find other active jobs for customer that this job belongs to

                $install_assign = $pv_job['installer_id'];
                $installer_assign_array = explode("," ,$install_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $pv_job['installer_assign']=array();
                $pv_job['installer_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$installer_assign_array )){
                          $pv_job['installer_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $pv_job['installer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }
                $conduit_assign = $pv_job['conduit_id'];
                $conduit_array = explode("," ,$conduit_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $pv_job['conduit_assign']=array();
                $pv_job['conduit_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$conduit_array )){
                          $pv_job['conduit_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $pv_job['conduit_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }


                $data['pm_jobs'][]=$pv_job;
             }

		$sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='5' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['service_calls'] = $this->db->query($sql)->result_array();
		
		$sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='8' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['el_jobs'] = $this->db->query($sql)->result_array();	
		
		$sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='15' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['acm_jobs'] = $this->db->query($sql)->result_array();	


		$sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='16' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['ac_jobs'] = $this->db->query($sql)->result_array();	

		$sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='9' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['wm_jobs'] = $this->db->query($sql)->result_array();	
		
		   $sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='20' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		  $data['safps_jobs'] = $this->db->query($sql)->result_array();
                
                $sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='21' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['ev_jobs'] = $this->db->query($sql)->result_array();

		$sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='17' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['ap_jobs'] = $this->db->query($sql)->result_array();
		
		// get day's installation job count
		$jc = $this->db->query("SELECT job_count as total FROM jobs LEFT JOIN users ON jobs.user_id=users.id WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."' $extra_sql")->row_array();
		// get day's service call total count
		$sc = $this->db->query("SELECT job_count as total FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id WHERE DATE_FORMAT(`date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."' $extra_sql")->row_array();
		$data['day_job_total'] = max(@$sc['total'], @$jc['total']);
		$data['service_count_total'] = @$sc['total'];
		
		$data['notes'] = array();
		// grab notes for all jobs on this day
		foreach($data['pv_jobs'] as $j)
		{
			$notes  = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id='".$j['id']."'")->result_array();
			foreach($notes as $n)
			{
				$data['notes'][strtotime($n['created'])] = $n;
			}
		}
		
		foreach($data['swh_jobs'] as $j)
		{
			$notes  = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id='".$j['id']."'")->result_array();
			foreach($notes as $n)
			{
				$data['notes'][strtotime($n['created'])] = $n;
			}
		}
		
		foreach($data['saf_jobs'] as $j)
		{
			$notes  = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id='".$j['id']."'")->result_array();
			foreach($notes as $n)
			{
				$data['notes'][strtotime($n['created'])] = $n;
			}
		}
		
		foreach($data['service_calls'] as $j)
		{
			$notes  = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id='".$j['id']."'")->result_array();
			foreach($notes as $n)
			{
				$data['notes'][strtotime($n['created'])] = $n;
			}
		}
		
		ksort($data['notes']);
		$data['day_notes'] = array_slice($data['notes'],0,3);
		$data['remaining_notes'] = (count($data['notes']) - count($data['day_notes']));
		if(!$this->session->userdata('access')){
                     $data['editjob'] = false;
                }
                
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                
		$this->load->view("common/header");
		$this->load->view("admin/day_new",$data);
		$this->load->view("common/footer");
	}
	
	function error()
	{
		$data = array();
			
		$this->load->view("common/header");
		$this->load->view("admin/error",$data);
		$this->load->view("common/footer");
	}
	
	function job($job_id='')
	{
		$data = array();
		
		$data['job_id'] = $job_id;
		
		$this->load->library("job");
		$this->load->helper("date");
		$this->load->helper("text");
                 $this->load->helper("thumbnail_helper");
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
		 $data['system_type'][]="- Select a system type -";
         $data['system_type']['PV']="PV";
         $data['system_type']['SWH']="SWH";
         $data['system_type']['AC']="AC";
         $data['system_type']['ELEC']="ELEC";
         $data['system_type']['other']="Other";
		 if($data['job']['project_designer_id']!="" && $data['job']['project_designer_id']){
                    
                    $show_instaler = explode("," ,$data['job']['project_designer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["enginner"]= implode(", " ,$showinstaller_name);
         } else {
                    $data["enginner"]= " ";
          }
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['zone1'] = array();
		if($data['job']['job_type_id'] == 20){
                    $sql_systemprice = "SELECT * FROM saf_system_price";
                    $data['system_price'] = $this->db->query($sql_systemprice)->result_array();
                    $data['qoute_mws'][''] = '- Select  -';
                     $data['qoute_iws'][''] = '- Select  -';
                    $data['qoute_kra'][''] = '- Select  -';
                    foreach ($data['system_price'] as $value) {
                        if ($value['type'] == "saftype") {
                        $data['qoute_iws'][$value['id']] = $value['title'];
                    }
                }
                }
                if($data['job']['job_type_id'] == 21){
                    $sql_systemprice = "SELECT * FROM homecharging_system_price";
                $data['system_price']= $this->db->query($sql_systemprice)->result_array();
               
                $data['qoute_iws'][''] = '- Select  -';
                
                foreach($data['system_price'] as $value){
                    if ($value['type']=="cstype"){
                         $data['qoute_iws'][$value['id']] = $value['title'];
                    }
                   
                   
               }
           }
		if($data['job']['job_type_id'] == 15 || $data['job']['job_type_id'] == 16)
		{
			 $data['mop'][''] = '- Select an Expected Payment Method  -';
		 $data['mop']['amex'] = 'AMEX';
		 $data['mop']['visa'] = 'VISA';
		 $data['mop']['mc'] = 'MC';
		 $data['mop']['cash/Check'] = 'Cash/Check';
		 $data['mop']['financing'] = 'Financing';
		 $data['mop']['other'] = 'Other';
		 
		 $data['costadj'][''] = '- Select an Cost Adjustment  -';
		 $data['costadj']['0'] = 'COST AJ1';
		 $data['costadj']['1'] = 'COST AJ2';
		 $data['costadj']['2'] = 'COST AJ3';
		 
		 // coundit zone
		 $data['counduit'][''] = 'SELECT Counduit Run Length';
		 $data['counduit'][1] = '0 to 30';
		 $data['counduit'][2] = '31 to 50';
		 $data['counduit'][3] = '51 to 75';
		 $data['counduit'][4] = '76 to 100';
		 $data['counduit'][5] = '100+';
		
		 
		 $dealtype[''] = 'Select deal type';
		 $dealtype[1] = 'Alternate Energy - HVAC';
		 $unittype[''] = 'Select Unit Type';
		 $unittype['1'] = 'Mitsubishi M-Series Ductless Split AC';
		 $unittype['2'] = 'Fujitsu';
		 $data['dealtype'] = $dealtype;
		 $data['unittype'] = $unittype;
         $data["proposal_id"]=$data['job']['proposal_id'];
		 $roomname[''] = 'Select Room Type';
		 $roomname[1] = 'Living Room';
		 $roomname[2] = 'Bed Room';
		 $data['roomname'] = $roomname;
		 $aeispecial[''] = 'Select an AEI Special';
		 $aeispecial['1'] = 'AEI Special 1';
		 $aeispecial['2'] = 'AEI Special 2';
		 $data['aeispecial'] = $aeispecial;
		 $room_exposure_longest_wall[''] = 'Select ROOM EXPOSURE--Longest wall';
		 $room_exposure_longest_wall['4'] = 'West';
		 $room_exposure_longest_wall['3'] = 'East';
		 $room_exposure_longest_wall['6'] = 'South';
		 $room_exposure_longest_wall['5'] = 'North';
		
		
		 $data['room_exposure_longest_wall'] = $room_exposure_longest_wall;
		 $data['mzone'] = array(''=>'Select Multi-Zone',1=>'MZ1',2=>'MZ2',3=>'MZ3');
		 if($data['job']['job_type_id'] == 16 || $data['job']['job_type_id'] == 15  ) {
		 $sql = "SELECT * FROM acproposal WHERE job_id = '".$data['job']['job_pid']."'";
			$data['proposal'] =  $this->db->query($sql)->row_array();
			$sql = "SELECT * FROM acproposalzone WHERE job_id = '".$data['job']['job_pid']."' ORDER BY zone_type";
			$data['zone1'] =  $this->db->query($sql)->result_array();
			 $sql_price ="SELECT * FROM  acsystem_price_proposal WHERE proposal_id='".$data["proposal_id"]."'";
                 $result_price = $this->db->query($sql_price)->result_array();
                 $data['system_price']=$result_price;
                 if(count($result_price) < 2){
                    $sql_propsoal_price ="INSERT INTO `acsystem_price_proposal`(`proposal_id`,id, `type`, `title`, `price`, `created`, `select_id`, `modified`, `formula`) SELECT  $proposal_id,`id`,`type`, `title`, `price`, `created`, `select_id`, `modified`, `formula` FROM ac_system_price where is_show=1;";
                    $this->db->query($sql_propsoal_price);
                    $sql_price ="SELECT * FROM  acsystem_price_proposal WHERE proposal_id=$proposal_id";
                    $data['system_price'] = $this->db->query($sql_price)->result_array();
                }
                $system_price_json = array();
                foreach($data['system_price'] as $value){
                    $system_price_json[$value['id']] = $value;
                }
                $data['systemprice_json']=json_encode($system_price_json);
			
			}
		  }
		        if($data['job']['job_type_id'] == 1 || $data['job']['job_type_id'] == 9   ) {
					$sql = "SELECT * FROM swhproposal WHERE  id = '".$data['job']['proposal_id']."'";
			        $data['proposal'] =  $this->db->query($sql)->row_array();
				}
                $jobtimelimit = $this->gettimeLimit($job_id);
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id,'active');
                $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit
                if($data["timediff"]<=0){
                  /*  $this->delete_jobcron($job_id);
                    $j = $this->db->query("SELECT * FROM users WHERE id=".$data['job']['user_id']."")->result();
                    $sname = $j[0]->first_name." ".$j[0]->last_name;
                    $this->deletemail($value['id'],$timediff,$sname,$j[0]->email);
                    redirect("admin/jobschedule?m=jd");*/
                }
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] = $jobtimelimit1;
                   }

                }
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
    					 if( @$userload[0]->first_name!="" &&  @$userload[0]->last_name!="")
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                $data['daily_limit'] = $this->db->get("job_limit")->row_array();
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

                $sqlpid = "SELECT job_pid  FROM jobs where  id  =".$job_id;
                $rowpid = $this->db->query($sqlpid)->result_array();
                $sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_type_id not in (6,7,8) AND jobs.job_pid=".$rowpid[0]['job_pid']." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();
		
                // grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $pid = $this->getparentjobid($job_id);
                $this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$data['mifa'] = $this->db->get("meter_files")->result_array();

                $this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$data['plan_files'] = $this->db->get("genral_files")->result_array();
                
		$this->db->where("job_id",$pid);
		$data['rivision_count'] = count($this->db->get("plotplan_revision")->result_array());
		

                $this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$data['sketch_files'] = $this->db->get("sketch_files")->result_array();

                $this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$data['predesignsketch_files'] = $this->db->get("predesignsketch_files")->result_array();

                $this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$data['presale_files'] = $this->db->get("presale_files")->result_array();
                
                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",1);
		$this->db->order_by("created","desc");
		$data['elec_photo_1'] = $this->db->get("elecphoto_files")->result_array();
                
                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",2);
		$this->db->order_by("created","desc");
		$data['elec_photo_2'] = $this->db->get("elecphoto_files")->result_array();

                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",1);
		$this->db->order_by("created","desc");
		$data['elec_photo_1'] = $this->db->get("elecphoto_files")->result_array();

                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",2);
		$this->db->order_by("created","desc");
		$data['elec_photo_2'] = $this->db->get("elecphoto_files")->result_array();

                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",3);
		$this->db->order_by("created","desc");
		$data['elec_photo_3'] = $this->db->get("elecphoto_files")->result_array();
                
                $this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$data['elecphoto_allfiles'] = $this->db->get("elecphoto_files")->result_array();


               $data['job_statuses'][''] = "- Select a job status -";
               $data['job_statuses']['unscheduled'] = "Unscheduled";
               if($data['job']['job_type_id']<=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";

                // set job type so we know what template to display and how to validate the data
		if($data['job']['job_type_id'] == 1) { $job_type = 'swh'; }
		if($data['job']['job_type_id'] == 1) { $job_type = 'swh'; }
		if($data['job']['job_type_id'] == 2) { $job_type = 'pv'; }
		if($data['job']['job_type_id'] == 3) { $job_type = 'saf'; }
		 if($data['job']['job_type_id'] == 20) { $job_type = 'saf'; }
                if($data['job']['job_type_id'] == 21) { $job_type = 'ev'; }

                if($data['job']['job_type_id'] == 5) { $job_type = 'service'; }
                if($data['job']['job_type_id'] == 6) { $job_type = 'pl'; }
		if($data['job']['job_type_id'] == 7) { $job_type = 'pm'; }
		if($data['job']['job_type_id'] == 8) { $job_type = 'el'; }
		if($data['job']['job_type_id'] == 9) { $job_type = 'wm'; }
        if($data['job']['job_type_id'] == 15) { $job_type = 'ac'; }
		if($data['job']['job_type_id'] == 16) { $job_type = 'ac'; }
		if($data['job']['job_type_id'] == 17) { $job_type = 'ac'; }
		// Grab installation types
		$data['contractors'][] = '- Select a contractor -';
		$this->db->or_where('type','contractor');
		$contractors = $this->db->get("users")->result_array();
		foreach($contractors as $row) { $data['contractors'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row['last_name']); }

                $temp =explode(",",$data['job']['contractor_id']);
                $installname = array();
                foreach($temp as $c=>$v) {
                if($v){
                    $installname[] = $this->getUserIntial($v,true);
                    }
                }
                $data['electrican'] =  $installname;
		/* ---------------------------------------
		PV Job Type
		--------------------------------------- */
		if($job_type == 'pv' || $job_type == 'pm' || $job_type == 'pl' )
		{
			 // Grab Number of modules
                        $module_array = array("0"=>"Select Number of Modules");
                        for ($i = 1 ; $i<=100;$i++){
                         $module_array[$i] = $i;
                        }
                       $data["nomodule"] = $module_array;
                       $data['nomodule']['other'] = 'Other';
                       if($data['job']['other_job_nom'] != '' && $data['job']['other_job_nom']) $data['job']['job_nom'] = 'other';




                       
                       
		       $data['spmsip']['no'] = "No";
                       $data['spmsip']['yes'] = "Yes";

                       $data['servicepanelupgrade'][0] = "--Upgrade Needed?--";
                       $this->db->order_by('type','asc');
                       $service_display = $this->db->get("service_panel_upgrade")->result_array();
		       foreach($service_display as $row) { $data['servicepanelupgrade'][$row['id']] = $row['type']; }

                       $data['moniter'][0] = "Select Moniter Display";
                       $this->db->order_by('type','asc');
                       $moniter_display = $this->db->get("moniter_display")->result_array();
		       foreach($moniter_display as $row) { $data['moniter'][$row['id']] = $row['type']; }
                       
                        //$data['moniter']['other'] = 'Other';
                        //$data["jobwssn"][0] = "Please Select ";
                        $data["jobwssn"]= array('0'=>"Please Select ",'n'=>"No",'y'=>"Yes");
                        if($data['job']['other_mointer_system'] != '' && $data['job']['other_mointer_system']) $data['job']['mointer_system'] = 'other';


                        $data['data_emt'][0] = "-- Select a Meter Type --";
                        $this->db->order_by('type','asc');

                        $moniter_display = $this->db->get("electric_wire_type")->result_array();
			foreach($moniter_display as $row) { $data['data_emt'][$row['id']] = $row['type']; }

                        
                        $data['data_emt']['other'] = 'Other';

                        if($data['job']['other_jobs_emt'] != '' && $data['job']['other_jobs_emt'] ) $data['job']['jobs_emt'] = 'other';

                        //$data['nonosa'][""]= "- Select Number of Array/Subarrays -";
                        $data['nonosa']=array(" "=>"- Select Number of Array/Subarrays -", "1"=>"1", "2"=>"2","3"=>"3","4"=>"4","5"=>"5","6"=>"6","7"=>"7","8"=>"8");
                        $data['nonosa']['other'] = 'Other';

                        if($data['job']['other_job_nosa'] != '' && $data['job']['other_job_nosa'] ) $data['job']['nosa'] = 'other';

                        // Grab Number of Electiric  wire source
                        $data["data_ews"] = array("0"=>"Select Electric Wire Source");
                       
                        $this->db->order_by('source','asc');

                        $moniter_display = $this->db->get("electric_wire_source")->result_array();
			foreach($moniter_display as $row) { $data["data_ews"][$row['id']] = $row['source']; }

                        
                        $data['data_ews']['other'] = 'Other';
                        if($data['job']['electric_wire_source_other'] != '' && $data['job']['electric_wire_source_other']) $data['job']['electric_wire_source'] = 'other';

                        $this->db->order_by('id','asc');


                        $data["wirerundistance"] = array("0"=>"Select Wire Run Distance");

                        $wire_distance = $this->db->get("wire_run_distance")->result_array();
			
                        foreach($wire_distance as $row) { $data["wirerundistance"][$row['id']] = $row['type']; }

                        $data["wirerundistance"]['other'] = 'Other';

                        if($data['job']['other_wire_run_distance'] != '' && $data['job']['other_wire_run_distance'] != '') $data['job']['wire_run_distance'] = 'other';

                        
                        $data['inverter_types'][] = '- Select an inverter type -';
			$this->db->order_by('type','asc');
			$inverter_types = $this->db->get("inverter_types")->result_array();
			foreach($inverter_types as $row) { $data['inverter_types'][$row['id']] = $row['type']; }
			$data['inverter_types']['other'] = 'Other';
			if($data['job']['other_inverter_type'] != '') $data['job']['inverter_type_id'] = 'other';
			
			// Grab module powers
			$data['module_powers'][] = '- Select module power -';
			$this->db->order_by('power','desc');
			$module_powers = $this->db->get("module_powers")->result_array();
			foreach($module_powers as $row) { $data['module_powers'][$row['id']] = $row['power']; }
			$data['module_powers']['other'] = 'Other';
			if($data['job']['other_module_power'] != '') $data['job']['module_power_id'] = 'other';

			// Grab module brands
			$data['module_brands'][] = '- Select a module Type -';
			$this->db->order_by('brand','asc');
			$module_brands = $this->db->get("module_brands")->result_array();
			foreach($module_brands as $row) { $data['module_brands'][$row['id']] = $row['brand']; }
			$data['module_brands']['other'] = 'Other';
			if($data['job']['other_module_brand'] != '') $data['job']['module_brand_id'] = 'other';

			// Grab roof types 
			$data['roof_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$roof_types = $this->db->get("roof_types")->result_array();
			foreach($roof_types as $row) { $data['roof_types'][$row['id']] = $row['type']; }
			$data['roof_types']['other'] = 'Other';
			if($data['job']['other_roof_type'] != '') $data['job']['roof_type_id'] = 'other';
                         
                        // Grab roof types 
                        $data['standoff_size'][] = '- Select a Standoff Size -';
			$this->db->order_by('type','asc');
			$standoff_size = $this->db->get("standoff_size")->result_array();
			foreach($standoff_size as $row) { $data['standoff_size'][$row['id']] = $row['type']; }
			//$data['standoff_size']['other'] = 'Other';
			if($data['job']['other_standoff_size'] != '') $data['job']['standoff_size_id'] = 'other';
                        
			// Grab rafter types 
			$data['rafter_types'][] = '- Select a Rafter Type -';
			$this->db->order_by('type','asc');
			$rafter_types = $this->db->get("rafter_types")->result_array();
			foreach($rafter_types as $row) { $data['rafter_types'][$row['id']] = $row['type']; }
			$data['rafter_types']['other'] = 'Other';
			if($data['job']['other_rafter_type'] != '') $data['job']['rafter_type_id'] = 'other';

			// Grab inverter brands
			$data['inverter_brands'][] = '- Select an Module Number/Name -';
			$this->db->order_by('brand','asc');
			$inverter_brands = $this->db->get("inverter_brands")->result_array();
			foreach($inverter_brands as $row) { $data['inverter_brands'][$row['id']] = $row['brand']; }
			$data['inverter_brands']['other'] = 'Other';
			if($data['job']['other_inverter_brand'] != '') $data['job']['inverter_brand_id'] = 'other';

			// Grab service panel amperage options
			$data['service_panel_amperages'][] = '- Select an amperage -';
			$this->db->order_by('amperage','asc');
			$service_panel_amperages = $this->db->get("service_panel_amperages")->result_array();
			foreach($service_panel_amperages as $row) { $data['service_panel_amperages'][$row['id']] = $row['amperage']; }
			$data['service_panel_amperages']['other'] = 'Other';
			if($data['job']['other_amperage'] != '') $data['job']['service_panel_amperage_id'] = 'other';

			// Grab wire run types
			$data['wire_run_types'][] = '- Select an type -';
			$this->db->order_by('type','asc');
			$wire_run_types = $this->db->get("wire_run_types")->result_array();
			foreach($wire_run_types as $row) { $data['wire_run_types'][$row['id']] = $row['type']; }
			$data['wire_run_types']['other'] = 'Other';
			if($data['job']['other_wire_run_type'] != '') $data['job']['wire_run_type_id'] = 'other';

			// Grab installation types
			$data['installation_types'][] = '- Select an type -';
			$this->db->order_by('type','asc');
			$installation_types = $this->db->get("installation_types")->result_array();
			foreach($installation_types as $row) { $data['installation_types'][$row['id']] = $row['type']; }
			$data['installation_types']['other'] = 'Other';
			if($data['job']['other_installation_type'] != '') $data['job']['installation_type_id'] = 'other';
			
			// build stories drop-down
                        $data['stories'][]='- Select Number of Stories -';
			for($i=1; $i<=3; $i++) { $data['stories'][$i] = $i; }
                         $data['stories']['1+2+3']='1+2+3';
                         $data['stories']['1+2']='1+2';
                         $data['roof_flashing'][' '] = '- Select a Roof Flashing Type -';
                         $data['roof_flashing']['2'] = 'Quickmount';
                         $data['roof_flashing']['3'] = 'Wakaflex';
                         $data['roof_flashing']['4'] = 'GEOCEL Sealant';
                         $data['roof_flashing']['5'] = 'Lead Flashing';
                         $data['roof_flashing']['6'] = 'Standoffs';
                         $data['roof_flashing']['7'] = 'Tile Hooks';
                         $data['roof_flashing']['8'] = 'Quickmount Flashing 12" x 12" (asphalt)';
                         $data['roof_flashing']['9'] = 'Quickmount Flashing 18" X 18" (wood shake)';
                        
                       //  $data['roof_flashing']['11'] = 'Unirac 2-piece Standoff 4"';
                         //$data['roof_flashing']['12'] = 'Unirac 2-piece Standoff 6""';
                         $data['roof_flashing']['13'] = 'Gaco Silicone/Geocel 4500';
                         $data['roof_flashing']['14'] = 'S5 Clips';
                         $data['roof_flashing']['15'] = 'Wakaflex Flashing';
                         $data['roof_flashing']['16'] = 'Lag/Hanger hardware';
                         $data['roof_flashing']['17'] = 'Custom/Trellis';
                         
		      }
		
		if($job_type == 'swh')
		{
			// Grab tank brands
			$data["piperundistance"] = array("0"=>"Select Pipe Run Distance");
                         $this->db->order_by('id','asc');
                         $piperundistance_display = $this->db->get("pipe_run_distance")->result_array();
                         foreach($piperundistance_display as $row) {
                          $data["piperundistance"][$row['id']] = $row['type'];
                        }
                        $data['tank_brands'][] = '- Select a tank brand -';
			$this->db->order_by('brand','asc');
			$tank_brands = $this->db->get("tank_brands")->result_array();
			foreach($tank_brands as $row) { $data['tank_brands'][$row['id']] = $row['brand']; }
			$data['tank_brands']['other'] = 'Other';
			if($data['job']['other_tank_brand'] != '') {$data['job']['tank_brand_id'] = 'other';}
			
			// Grab tank sizes
			$data['tank_sizes'][] = '- Select a tank sizes -';
			$this->db->order_by('size','asc');
			$tank_sizes = $this->db->get("tank_sizes")->result_array();
			foreach($tank_sizes as $row) { $data['tank_sizes'][$row['id']] = $row['size']; }
			$data['tank_sizes']['other'] = 'Other';
			if($data['job']['other_tank_size'] != '') $data['job']['tank_size_id'] = 'other';
			
			// Grab panel types
			$data['panel_types'][] = '- Select a panel type -';
			$this->db->order_by('type','asc');
			$panel_types = $this->db->get("panel_types")->result_array();
			foreach($panel_types as $row) { $data['panel_types'][$row['id']] = $row['type']; }
			$data['panel_types']['other'] = 'Other';
			if($data['job']['other_panel_type'] != '') $data['job']['panel_type_id'] = 'other';
			
			// Grab panel sizes
			$data['panel_sizes'][] = '- Select a panel size -';
			$this->db->order_by('size','asc');
			$panel_sizes = $this->db->get("panel_sizes")->result_array();
			foreach($panel_sizes as $row) { $data['panel_sizes'][$row['id']] = $row['size']; }
			$data['panel_sizes']['other'] = 'Other';
			if($data['job']['other_panel_size'] != '') $data['job']['panel_size_id'] = 'other';
			
			// Grab pipe run types
			$data['pump_types'][] = '- Select Type of pump -';
			$data['pump_types'][] = 'DC';
                        $data['pump_types'][] = 'AC';
                        $data['pump_types'][] = 'Heat Pump';

                        $data['piperun_types'][] = '- Select a pipe-run type -';
			$this->db->order_by('type','asc');
			$piperun_types = $this->db->get("piperun_types")->result_array();
			foreach($piperun_types as $row) { $data['piperun_types'][$row['id']] = $row['type']; }

			$data['piperun_types']['other'] = 'Other';
			if($data['job']['other_piperun_type'] != '') $data['job']['piperun_type_id'] = 'other';
			
			// Grab installation types
			$data['installation_types'][] = '- Select an type -';
			$this->db->order_by('type','asc');
			$installation_types = $this->db->get("installation_types")->result_array();
			foreach($installation_types as $row) { $data['installation_types'][$row['id']] = $row['type']; }
			$data['installation_types']['other'] = 'Other';
			if($data['job']['other_installation_type'] != '') $data['job']['installation_type_id'] = 'other';
			
			// Grab roof types 
			$data['roof_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$roof_types = $this->db->get("roof_types")->result_array();
			foreach($roof_types as $row) { $data['roof_types'][$row['id']] = $row['type']; }
			$data['roof_types']['other'] = 'Other';
			if($data['job']['other_roof_type'] != '') $data['job']['roof_type_id'] = 'other';

			// Grab rafter types 
			$data['rafter_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$rafter_types = $this->db->get("rafter_types")->result_array();
			foreach($rafter_types as $row) { $data['rafter_types'][$row['id']] = $row['type']; }
			$data['rafter_types']['other'] = 'Other';
                         $data['stories'][]='*- Select Number of Stories -*';
			if($data['job']['other_rafter_type'] != '') $data['job']['rafter_type_id'] = 'other';
			
			// build stories drop-down
			for($i=1; $i<=3; $i++) { $data['stories'][$i] = $i; }
		}
		
		if($job_type == 'saf')
		{
			// Grab fan brands
			$data['fan_brands'][] = '- Select a brand -';
			$this->db->order_by('brand','asc');
			$fan_brands = $this->db->get("fan_brands")->result_array();
			foreach($fan_brands as $row) { $data['fan_brands'][$row['id']] = $row['brand']; }
			$data['fan_brands']['other'] = 'Other';
			
			// Grab fan sizes
			$data['fan_sizes'][] = '- Select a fan size -';
			$this->db->order_by('size','asc');
			$fan_sizes = $this->db->get("fan_sizes")->result_array();
			foreach($fan_sizes as $row) { $data['fan_sizes'][$row['id']] = $row['size']; }
			$data['fan_sizes']['other'] = 'Other';
			
			// Grab installation types
			$data['installation_types'][] = '- Select an type -';
			$this->db->order_by('type','asc');
			$installation_types = $this->db->get("installation_types")->result_array();
			foreach($installation_types as $row) { $data['installation_types'][$row['id']] = $row['type']; }
			$data['installation_types']['other'] = 'Other';
			
			// Grab roof types 
			$data['roof_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$roof_types = $this->db->get("roof_types")->result_array();
			foreach($roof_types as $row) { $data['roof_types'][$row['id']] = $row['type']; }
			$data['roof_types']['other'] = 'Other';

			// Grab rafter types 
			$data['rafter_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$rafter_types = $this->db->get("rafter_types")->result_array();
			foreach($rafter_types as $row) { $data['rafter_types'][$row['id']] = $row['type']; }
			$data['rafter_types']['other'] = 'Other';
			
			// build stories drop-down
			for($i=1; $i<=3; $i++) { $data['stories'][$i] = $i; }
		}
                if ($job_type == 'service' || $job_type == 'el'){
                
		// find other active jobs for customer that this job belongs to
		//$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		//$data['other_jobs'] = $this->db->query($sql)->result_array();

		
		// grab service call notes
		//$data['job_notes'] = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id=".$this->db->escape($service_call_id)." LIMIT 3")->result_array();

		// build times drop-down
		$start = strtotime('9:00am');
		$end = strtotime('9:00pm');
        
		$data['times_dd'] = array();
		 if($job_id<15824){
		 for ($i = $start; $i <= $end; $i += 900)
		  {
			$data['times_dd'][date('g:i a', $i)] = date('g:i a', $i);
		 }
		 } else {
		// grab technician type users
		  $data['times_dd'][" "]="-Select a time Range-";
		  $data['times_dd']["1"]="9:00am-12:00pm";
		  $data['times_dd']["2"]="1:00pm-4:00pm";
		  $data['times_dd']["3"]="Other(specify time)";
		}
		  $start = strtotime('9:00am');
		  $end = strtotime('9:00pm');
		  for ($i = $start; $i <= $end; $i += 900){
			$data['eat_times_dd'][date('g:i a', $i)] = date('g:i a', $i);
		 }
          $start = strtotime('9:00am');
    	  $end = strtotime('9:00pm');
		  for ($i = $start; $i <= $end; $i += 900){
			$data['edt_times_dd'][date('g:i a', $i)] = date('g:i a', $i);
	      }


	   }
                
                 if ($job_type == 'pl'){
                
		// find other active jobs for customer that this job belongs to
		//$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		//$data['other_jobs'] = $this->db->query($sql)->result_array();

		
		// grab service call notes
		//$data['job_notes'] = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id=".$this->db->escape($service_call_id)." LIMIT 3")->result_array();

		// build times drop-down
		$start = strtotime('9:00am');
		$end = strtotime('9:00pm');

		$data['times_dd'] = array();
		$data['times_dd'][1] ="9am-12pm";
                $data['times_dd'][2] ="1pm-4pm";
                $data['times_dd'][3] ="All Day";

		// grab technician type users
		

		

                }
		
		
		if($this->input->post('dosubmit'))
		{
			$row = array();
			// fields for pv job type
                        $row['modified_by'] =  $this->session->userdata("user_id");
                       /* if($job_type == 'pl'){
                            $row['arrival_time'] = $this->input->post("arrival_time");
                            $row['toprelag'] = $this->input->post("toprelag");
                            $row['pldesc'] = $this->input->post("pldesc");
                          //  $row['contractor_id'] = implode("," ,$this->input->post("contractor_id"));
                            $row['pl_comments'] = $this->input->post("pl_comments");
                            $this->db->where("id",$job_id);
                            $this->db->update("jobs",$row);
                            redirect("admin/job/".$job_id."?savedata=1");
                        }*/
						if($job_type == 'ev'  || $job_type == 'saf' ){
                             $row['saf_type'] = $this->input->post("saf_type");
                            $row['no_of_saf'] = $this->input->post("no_of_saf");
                            $row['comments'] = $this->input->post("comments");
			 
						}
                        if($job_type == 'service' || $job_type == 'el'){
                            $row['repair_time'] = $this->input->post("repair_time");
                            $row['repair_type'] = $this->input->post("repair_type");
                            $row['servicedesc'] = $this->input->post("description");
							$row['system_type_other'] = $this->input->post("system_type_other");
							$row['eat_time'] = $this->input->post("eat_time");
							$row['edt_time'] = $this->input->post("edt_time");
                          //  $row['contractor_id'] = implode("," ,$this->input->post("contractor_id"));
                            $row['comments'] = $this->input->post("comments");
							$row['warranty_valid'] = $this->input->post("warranty_valid");
							
                            $row['system_type'] = $this->input->post("system_type");
                            $date=$this->input->post("year")."-".$this->input->post("month")."-".$this->input->post("day");
                            $row['installed_date'] = date("Y-m-d", strtotime($date));
                            $this->db->where("id",$job_id);
                            $this->db->update("jobs",$row);
							if($row['warranty_valid']!="yes"){
								$row['warranty_valid']="no";
							}
                             $this->load->helper('osticket');
							 $url_job=base_url()."admin/job/".$job_id;
							 $message= "<p>A New SC job created with id $job_id. View Details <a href=\"$url_job\"> click here </a></p>";
							 $message.="<p>";
							 $message.="<br/>Time of Repair :-";
							 if($job_id<15824){
                               $message.= $row['repair_time'];
							 } else {
                             
							   $message.=$data['times_dd'][$row['repair_time']];
							   if($row['repair_time']==3){
								  $message.=$row['eat_time']."-".$row['edt_time'];
							   }
							 }
							 $message.="<br/>System Type :-";
							 if($row['system_type']=="other"){
                               $message.= $row['system_type_other'];
							 } else {
							   $message.=$row['system_type'];
							 }
							 
							 $message.="<br/>Installation Date :-";
							  if(strtotime($date)){
                               $message.= date("l,F j, Y", strtotime($date));
							 }
							 $message.="<br/>Warranty Valid :-".ucfirst($row['warranty_valid']);
							 $message.="<br/>Type of Repair :-".$row['repair_type'];
							 $message.="<br/>Describe Problem :-".$row['servicedesc'] ;
							 $message.="<br/>Service & Part Rendered/Comments :-".$row['comments'];
							 $message.="</p>";
							 $tsql = "select * from  osticket where job_id = '".$job_id."'";
							 $ticket=$this->db->query($tsql)->row_array();
							 if ( isset($ticket['os_ticket']) && $ticket['os_ticket']>0 )
							 update_ticket($ticket['os_ticket'],$message); 
                             redirect("admin/job/".$job_id."?savedata=1");
                        }
                        $row['job_nos'] = $this->input->post("nos");
                        //$row['job_nosa'] = $this->input->post("nosa");
                       
                        if ($this->input->post('nosa') == 'other') {
                            $row['job_nosa'] = 'other';
                            $row['other_job_nosa'] = $this->input->post("other_nosa");
                         } else {
                            $row['job_nosa'] = $this->input->post("nosa");
                            $row['other_job_nosa'] = '';
			}

                        $row['saoorf'] = $this->input->post("saoorf");
                        $row['nodrf'] = $this->input->post("nodrf");
                        $row['envoy_serial_number'] = $this->input->post("envoy_serial_number");
                        $row['spmsip_job'] = $this->input->post("spmsip_job");
                        if ($this->input->post('nom') == 'other') {
                            $row['job_nom'] = '';
                            $row['other_job_nom'] = $this->input->post("other_nom");
			} else {
                            $row['job_nom'] = $this->input->post("nom");
                            $row['other_job_nom'] = '';
			}
                       

			if($job_type == 'pv' || $job_type == 'pl')
			{

                              if ($this->input->post('mt') == 'other') {
					$row['module_brand_id'] = '';
					$row['other_module_brand'] = $this->input->post("other_mt");
				} else {
					$row['module_brand_id'] = $this->input->post("mt");
					$row['other_module_brand'] = '';
				}
                if($job_type == 'pv')
				{
					$ckval = @$this->input->post('monier_tile_ck')!=''?'1':'0'; 
					$row['monier_tile_ck'] = $ckval;
					$row['monier_tile_count'] = $this->input->post('monier_tile_count');
				}
                             //   $row['module_count'] = $this->input->post("module_count");
				$row['system_size'] = $this->input->post("system_size");
				if ($this->input->post("module_power_id") == 'other') {
					$row['module_power_id'] = '';
					$row['other_module_power'] = $this->input->post("other_module_power");
				} else {
					$row['module_power_id'] = $this->input->post("module_power_id");
					$row['other_module_power'] = '';
				}
				if ($this->input->post("inverter_type_id") == 'other') {
					$row['inverter_type_id'] = '';
					$row['other_inverter_type'] = $this->input->post("other_inverter_type");
				} else {
					$row['inverter_type_id'] = $this->input->post("inverter_type_id");
					$row['other_inverter_type'] = '';
				}
                                if ($this->input->post("ms") == 'other') {
					$row['mointer_system'] = '';
					$row['other_mointer_system'] = $this->input->post("other_ms");
				} else {
					$row['mointer_system'] =$this->input->post("ms");
					$row['other_mointer_system'] = '';
				}
				if ($this->input->post("inverter_brand_id") == 'other') {
					$row['inverter_brand_id'] = '';
					$row['other_inverter_brand'] = $this->input->post("other_inverter_brand");
				} else {
					$row['inverter_brand_id'] =$this->input->post("inverter_brand_id");
					$row['other_inverter_brand'] = '';
				}
                                $row['elec_insp_quote'] = $this->input->post('elec_insp_quote');
                                if ($row['elec_insp_quote']=='y') {
                                    $row['elec_comments'] = $this->input->post("elec_comments");
                                } else {
                                     $row['elec_comments'] = '';
                                }
				$row['inverter_count'] = $this->input->post("inverter_count");
                                $row['roof_flashing'] = $this->input->post("roof_flashing");
				$row['inverter_accessible'] = $this->input->post("inverter_accessible");
                                $row['subpanel_exist'] = $this->input->post("subpanel_exist");
                                $row['is_ladder'] = $this->input->post("is_longladder");
				if ($this->input->post("emt") == 'other') {
					$row['jobs_emt'] = '';
					$row['other_jobs_emt'] = $this->input->post("other_emt");
				} else {
					$row['jobs_emt'] = $this->input->post("emt");
					$row['other_jobs_emt'] = '';
				}
                               
                                if ($this->input->post("ews") == 'other') {
					$row['electric_wire_source'] = '';
					$row['electric_wire_source_other'] = $this->input->post("other_ews");
				} else {
					$row['electric_wire_source'] = $this->input->post("ews");
					$row['electric_wire_source_other'] = '';
				}
                                
                                $row['job_isnws'] = $this->input->post("isnws");
                                $row['job_wssn'] = $this->input->post("job_wssn");
                               
				if ($this->input->post("service_panel_amperage_id") == 'other') {
					$row['service_panel_amperage_id'] = '';
					$row['other_amperage'] = $this->input->post("other_amperage");
				} else {
					$row['service_panel_amperage_id'] = $this->input->post("service_panel_amperage_id");
					$row['other_amperage'] = '';
				}

                                $row['job_dowr'] = $this->input->post("dowr");
                                $row['job_spu'] = $this->input->post("spu");
                                $row['servicepanelupgrade'] = $this->input->post("service_panel_upgrade");
				if ($this->input->post("wire_run_type_id") == 'other') {
					$row['wire_run_type_id'] = '';
					$row['other_wire_run_type'] = $this->input->post("other_wire_run_type");
				} else {
					$row['wire_run_type_id'] = $this->input->post("wire_run_type_id");
					$row['other_wire_run_type'] = '';
				}
                                if ($this->input->post("wire_run_distance") == 'other') {
					$row['wire_run_distance'] = '';
					$row['other_wire_run_distance'] = $this->input->post("other_wire_run_distance");
				} else {
					$row['wire_run_distance'] = $this->input->post("wire_run_distance");
					$row['other_wire_run_distance'] = '';
				}
				$row['wire_run_distance'] = $this->input->post("wire_run_distance");
				$row['stories'] = $this->input->post("stories");
				if ($this->input->post("roof_type_id") == 'other') {
					$row['roof_type_id'] = '';
					$row['other_roof_type'] = $this->input->post("other_roof_type");
				} else {
					$row['roof_type_id'] = $this->input->post("roof_type_id");
					$row['other_roof_type'] = '';
				}
                                if ($this->input->post("standoff_size") == 'other') {
					$row['standoff_size_id'] = '';
					$row['other_standoff_size'] = $this->input->post("other_standoff_size");
				} else {
					$row['standoff_size_id'] = $this->input->post("standoff_size");
					$row['other_standoff_size'] = '';
				}
				$row['roof_color'] = $this->input->post("roof_color");
				$row['roof_pitch'] = $this->input->post("roof_pitch");
				$row['roof_orientation'] = $this->input->post("roof_orientation");
				$row['module_install_location_access'] = $this->input->post("module_install_location_access");
				if ($this->input->post("rafter_type_id") == 'other') {
					$row['rafter_type_id'] = '';
					$row['other_rafter_type'] = $this->input->post("other_rafter_type");
				} else {
					$row['rafter_type_id'] = $this->input->post("rafter_type_id");
					$row['other_rafter_type'] = '';
				}
				$row['rafter_distance'] = $this->input->post("rafter_distance");
				$row['tilt_kit_needed'] = $this->input->post("tilt_kit_needed");
				if ($this->input->post("installation_type_id") == 'other') {
					$row['installation_type_id'] = '';
					$row['other_installation_type'] = $this->input->post("other_installation_type");
				} else {
					$row['installation_type_id'] = $this->input->post("installation_type_id");
					$row['other_installation_type'] = '';
				}
                                if($this->input->post("contractor_id")){
				  $row['contractor_id'] = $this->input->post("contractor_id");
                                }
                              /*  $job_newcontrator = array();
                                $job_existcontrator = array();
                                $job_existcontrator = explode(",",$data['job']['contractor_id']);
                                $job_newcontrator =  $this->input->post("contractor_id");
                                $diff_Array = array();
                                $diff_Array = array_diff($job_newcontrator,$job_existcontrator);
                               
                                if(count($diff_Array)>=1){
                                  $new_userstring = implode(",",$diff_Array);
                                  $row_users = $this->db->query("SELECT users.email from users WHERE    id in ($new_userstring)")->result_array();
                                  foreach ($row_users as $value){
                                      $this->job->sendmailhelper($job_id,$data['job']['first_name'],$data['job']['last_name'],$value['email']);
                                  }
                                }*/
				$row['comments'] = $this->input->post("comments");
			}
			
			if($job_type == 'saf')
			{
				if ($this->input->post("fan_brand_id") == 'other') {
					$row['fan_brand_id'] = '';
					$row['other_fan_brand'] = $this->input->post("other_fan_brand");
				} else {
					$row['fan_brand_id'] = $this->input->post("fan_brand_id");
					$row['other_fan_brand'] = '';
				}
				if ($this->input->post("fan_size_id") == 'other') {
					$row['fan_size_id'] = '';
					$row['other_fan_size'] = $this->input->post("other_fan_size");
				} else {
					$row['fan_size_id'] = $this->input->post("fan_size_id");
					$row['other_fan_size'] = '';
				}
				$row['panel_install_location_access'] = $this->input->post("panel_install_location_access");
				$row['stories'] = $this->input->post("stories");
				if ($this->input->post("roof_type_id") == 'other') {
					$row['roof_type_id'] = '';
					$row['other_roof_type'] = $this->input->post("other_roof_type");
				} else {
					$row['roof_type_id'] = $this->input->post("roof_type_id");
					$row['other_roof_type'] = '';
				}
				$row['roof_color'] = $this->input->post("roof_color");
				$row['roof_pitch'] = $this->input->post("roof_pitch");
				$row['roof_orientation'] = $this->input->post("roof_orientation");
				$row['fan_install_location_access'] = $this->input->post("module_install_location_access");
				if ($this->input->post("rafter_type_id") == 'other') {
					$row['rafter_type_id'] = '';
					$row['other_rafter_type'] = $this->input->post("other_rafter_type");
				} else {
					$row['rafter_type_id'] = $this->input->post("rafter_type_id");
					$row['other_rafter_type'] = '';
				}
				$row['rafter_distance'] = $this->input->post("rafter_distance");
				$row['tilt_kit_needed'] = $this->input->post("tilt_kit_needed");
				if ($this->input->post("installation_type_id") == 'other') {
					$row['installation_type_id'] = '';
					$row['other_installation_type'] = $this->input->post("other_installation_type");
				} else {
					$row['installation_type_id'] = $this->input->post("installation_type_id");
					$row['other_installation_type'] = '';
				}
				//$row['contractor_id'] = $this->input->post("contractor_id");
				$row['comments'] = $this->input->post("comments");
			}
			
			if($job_type == 'swh')
			{
				if ($this->input->post("tank_brand_id") == 'other') {
					$row['tank_brand_id'] = '';
					$row['other_tank_brand'] = $this->input->post("other_tank_brand");
				} else {
					$row['tank_brand_id'] = $this->input->post("tank_brand_id");
					$row['other_tank_brand'] = '';
				}
				if ($this->input->post("tank_size_id") == 'other') {
					$row['tank_size_id'] = '';
					$row['other_tank_size'] = $this->input->post("other_tank_size");
				} else {
					$row['tank_size_id'] = $this->input->post("tank_size_id");
					$row['other_tank_size'] = '';
				}
                                $row['elec_insp_quote'] = $this->input->post('elec_insp_quote');
                                if ($row['elec_insp_quote']=='y') {
                                    $row['elec_comments'] = $this->input->post("elec_comments");
                                } else {
                                    $row['elec_comments'] = '';
                                }
                                $row['typeofjump'] = $this->input->post("typeofjump");
				$row['existing_heater_location'] = $this->input->post("existing_heater_location");
				$row['remove_old_tank'] = $this->input->post("remove_old_tank");
				$row['relocate_old_tank'] = $this->input->post("relocate_old_tank");
				$row['new_tank_location'] = $this->input->post("new_tank_location");
				$row['tank_distance'] = $this->input->post("tank_distance");
				$row['solar_tank_accessible'] = $this->input->post("solar_tank_accessible");
                                if ($this->input->post("pump_type_id") == 'other') {
					$row['pump_type_id'] = '';
					$row['other_pump_type'] = $this->input->post("other_pump_type");
				} else {
					$row['pump_type_id'] = $this->input->post("pump_type_id");
					$row['other_pump_type'] = '';
				}

				if ($this->input->post("panel_type_id") == 'other') {
					$row['panel_type_id'] = '';
					$row['other_panel_type'] = $this->input->post("other_panel_type");
				} else {
					$row['panel_type_id'] = $this->input->post("panel_type_id");
					$row['other_panel_type'] = '';
				}
				if ($this->input->post("panel_size_id") == 'other') {
					$row['panel_size_id'] = '';
					$row['other_panel_size'] = $this->input->post("other_panel_size");
				} else {
					$row['panel_size_id'] = $this->input->post("panel_size_id");
					$row['other_panel_size'] = '';
				}
				
				$row['piperun_length'] = $this->input->post("piperun_length");
				if ($this->input->post("piperun_type_id") == 'other') {
					$row['piperun_type_id'] = '';
					$row['other_piperun_type'] = $this->input->post("other_piperun_type");
				} else {
					$row['piperun_type_id'] = $this->input->post("piperun_type_id");
					$row['other_piperun_type'] = '';
				}
				$row['gutter_installation'] = $this->input->post("gutter_installation");
				$row['panel_install_location_access'] = $this->input->post("panel_install_location_access");
				$row['stories'] = $this->input->post("stories");
				if ($this->input->post("rafter_type_id") == 'other') {
					$row['rafter_type_id'] = '';
					$row['other_rafter_type'] = $this->input->post("other_rafter_type");
				} else {
					$row['rafter_type_id'] = $this->input->post("rafter_type_id");
					$row['other_rafter_type'] = '';
				}
				$row['roof_color'] = $this->input->post("roof_color");
				$row['roof_pitch'] = $this->input->post("roof_pitch");
				$row['roof_orientation'] = $this->input->post("roof_orientation");
				$row['module_install_location_access'] = $this->input->post("module_install_location_access");
				if ($this->input->post("rafter_type_id") == 'other') {
					$row['rafter_type_id'] = '';
					$row['other_rafter_type'] = $this->input->post("other_rafter_type");
				} else {
					$row['rafter_type_id'] = $this->input->post("rafter_type_id");
					$row['other_rafter_type'] = '';
				}
				$row['rafter_distance'] = $this->input->post("rafter_distance");
				$row['tilt_kit_needed'] = $this->input->post("tilt_kit_needed");
				if ($this->input->post("roof_type_id") == 'other') {
					$row['roof_type_id'] = '';
					$row['other_roof_type'] = $this->input->post("other_roof_type");
				} else {
					$row['roof_type_id'] = $this->input->post("roof_type_id");
					$row['other_roof_type'] = '';
				}
				if ($this->input->post("installation_type_id") == 'other') {
					$row['installation_type_id'] = '';
					$row['other_installation_type'] = $this->input->post("other_installation_type");
				} else {
					$row['installation_type_id'] = $this->input->post("installation_type_id");
					$row['other_installation_type'] = '';
				}
                                $row['panel_count'] = $this->input->post("panel_count");
				//$row['contractor_id'] = $this->input->post("contractor_id");
                                
				//$row['contractor_id'] = implode("," ,$this->input->post("contractor_id"));
                                $row['comments'] = $this->input->post("comments");
			}
			
			$pid_job = $this->getparentjobid($job_id);
                        $this->db->where("job_pid",$pid_job);
                        
			$this->db->update("jobs",$row);
			//Create activity log for update job
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Update", "jobs", $pid_job, $this->session->userdata("user_id"));				
			redirect("admin/job/".$job_id."?savedata=1");
		}
		 global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		$data['savedata'] =  $this->input->get("savedata");
                $this->load->view("common/header");
               if($data['job']['proposal_id']>0 && $job_type=='pv' && $this->session->userdata("role")!='admin'){
                   $job_type="pv_proposal";
               }
              // echo "admin/job_$job_type";
		$this->load->view("admin/job_$job_type",$data);
		$this->load->view("common/footer");
	}
	
	function delete_job($job_id='')
	{

              if($this->session->userdata("deletepermission")==0){
               // redirect("admin/error?e=permissions");

              }
               // make sure user is either admin or that the job at least belongs to them before deleting
		if($this->session->userdata("role") != 'admin')
		{
			$row = $this->db->query("SELECT * FROM jobs WHERE user_id=".$this->db->escape($this->session->userdata("user_id"))." AND id=".$this->db->escape($job_id))->row_array();
			if (count($row) > 0) {
				$this->db->where("id",$job_id);
				$this->db->delete("jobs");
				/* Create activity log after deletion of Job */
				$this->load->library("activitylog");
				//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
				$this->activitylog->createlog("Delete", "jobs", $job_id, $this->session->userdata("user_id"));				
				
				
				if($this->input->get("confirmdelete") == "yes"){
					$this->db->where("id",$row[0]['customer_id']);
					$this->db->delete("customers");
					/* Create activity log after deletion of customer */
					$this->load->library("activitylog");
					//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
					$this->activitylog->createlog("Delete", "customers", '' , $this->session->userdata("user_id"), $row[0]['customer_id']);	
				
				}				
				
				if($this->input->get("ref"))
				{
					redirect($this->input->get("ref"));
				}
				else
				{
					redirect("admin/jobschedule");
				}
			} else {
				redirect("admin/error?e=permissions");
			}
		}
		else
		{
			 $sqlpid = "SELECT job_pid,job_type_id, customer_id,proposal_id  FROM jobs where  id  =".$job_id;
                         $rowpid = $this->db->query($sqlpid)->result_array();
                        
                         if($rowpid[0]['job_type_id']==6 || $rowpid[0]['job_type_id']==7){
                            $this->db->where("id",$job_id);
                            $this->db->delete("jobs");
                         }else{
                            $this->db->where("job_pid",$rowpid[0]['job_pid']);
                            $this->db->delete("jobs");
                            $row_proposal=array();
                            $row_proposal["is_schedule"]=0;
                            $this->db->where("id",$rowpid[0]["proposal_id"]);
                            $this->db->update("proposal",$row_proposal);
                        }
			/* Create activity log after deletion of Job */

			if($rowpid[0]['job_type_id']==6 || $rowpid[0]['job_type_id']==7){
				$DelJob_id = $job_id;
			}else{
				$DelJob_id = $rowpid[0]['job_pid'];
			}	

			
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Delete", "jobs", $DelJob_id , $this->session->userdata("user_id"));	
			
			 $job_type_id=$rowpid[0]["job_type_id"];
             $proposal_id=$rowpid[0]["proposal_id"];
             $this->delete_is_schedule($job_type_id,$proposal_id);
			
			if($this->input->get("confirmdelete") == "yes"){
				$this->db->where("id",$rowpid[0]['customer_id']);
				$this->db->delete("customers");
				/* Create activity log after deletion of customer */			
				$this->load->library("activitylog");
				//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
				$this->activitylog->createlog("Delete", "customers", '' , $this->session->userdata("user_id"), $rowpid[0]['customer_id']);	

			}
			
			if ($this->input->get("ref")) {
				redirect($this->input->get("ref"));
			} else {
				redirect("admin/jobschedule");
			}
		}
	}
	
	function delete_service_call($service_call_id='')
	{
		// make sure user is either admin or that the job at least belongs to them before deleting
		if($this->session->userdata("role") != 'admin')
		{
			$row = $this->db->query("SELECT * FROM service_calls WHERE user_id=".$this->db->escape($this->session->userdata("user_id"))." AND id=".$this->db->escape($service_call_id))->row_array();
			if (count($row) > 0) {
				$this->db->where("id",$service_call_id);
				$this->db->delete("service_calls");
				
				if ($this->input->get("ref")) {
					redirect($this->input->get("ref"));
				} else {
					redirect("admin/jobschedule");
				}
			} else {
				redirect("admin/error?e=permissions");
			}
		}
		else
		{
			$this->db->where("id",$service_call_id);
			$this->db->delete("service_calls");

			if ($this->input->get("ref")) {
				redirect($this->input->get("ref"));
			} else {
				redirect("admin/jobschedule");
			}
		}
	}
	
	function job_financing($job_id='')
	{
           
		$data = array();
		
		$data['job_id'] = $job_id;
		
		$this->load->library("job");
                $data['percent_completed'] = $this->job->percent_completed($job_id);
		$this->load->helper("text");
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
   
		$data['job'] = $this->db->query($sql)->row_array();
		        if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
                if(!isset($data['job']['job_nos']) || $data['job']['job_nos']=='' || $data['job']['job_nos']==0){
                    $data['job']['job_nos']=1;
                }
                if($data['job']['proposal_id'] && $data['job']['job_type_id']==2 ){
                    $sql = "SELECT * from proposal WHERE id=".$data['job']['proposal_id'];
                    $data["proposal"]  = $this->db->query($sql)->row_array();
                    $elite_user = $this->db->query("SELECT elite_agent from users where id=".$data["proposal"]["user_id"])->row_array();;
                    $data["elite_agent"]=@$elite_user['elite_agent'];
					$data['cleaningcharge']=0;
					if( $data["proposal"]["cleaning_contract"]==1){
						$sql_clean = "SELECT * FROM variable_job WHERE variable_id=76 AND proposal_id=".$data['job']['proposal_id'];
						@$variable_record_clean=$this->db->query($sql_clean)->row_array();
						$data['cleaningcharge'] = @$variable_record_clean["quantity"]*@$variable_record_clean["price"];
                    }
                }else if ($data['job']['proposal_id'] && $data['job']['job_type_id']==1){
                     $sql = "SELECT * from swhproposal WHERE id=".$data['job']['proposal_id'];
                    $data["proposal"]  = $this->db->query($sql)->row_array();
                    $elite_user = $this->db->query("SELECT elite_agent from users where id=".$data["proposal"]["user_id"])->row_array();;
                    $data["elite_agent"]=@$elite_user['elite_agent'];
                }
                else if ($data['job']['proposal_id'] && $data['job']['job_type_id']==20){
                     $sql = "SELECT * from safproposal WHERE id=".$data['job']['proposal_id'];
                    $data["proposal"]  = $this->db->query($sql)->row_array();
                    $elite_user = $this->db->query("SELECT elite_agent from users where id=".$data["proposal"]["user_id"])->row_array();;
                    $data["elite_agent"]=@$elite_user['elite_agent'];
                }else if ($data['job']['proposal_id'] && $data['job']['job_type_id']==21){
                     $sql = "SELECT * from homecharging WHERE id=".$data['job']['proposal_id'];
                    $data["proposal"]  = $this->db->query($sql)->row_array();
                    $elite_user = $this->db->query("SELECT elite_agent from users where id=".$data["proposal"]["user_id"])->row_array();;
                    $data["elite_agent"]=@$elite_user['elite_agent'];
                }
				if($data['job']['job_type_id'] == 15 || $data['job']['job_type_id'] == 16)
				{
				 	$data['mop'][''] = '- Select an Expected Payment Method  -';
			 		$data['mop']['amex'] = 'AMEX';
			 		$data['mop']['visa'] = 'VISA';
			 		$data['mop']['mc'] = 'MC';
					$data['mop']['cash/Check'] = 'Cash/Check';
			 		$data['mop']['financing'] = 'Financing';
			 		$data['mop']['other'] = 'Other';
			 
					$data['costadj'][''] = '- Select an Cost Adjustment  -';
			 		$data['costadj']['0'] = 'COST AJ1';
			 		$data['costadj']['1'] = 'COST AJ2';
			 		$data['costadj']['2'] = 'COST AJ3';
			 
					 // coundit zone
					 $data['counduit'][''] = 'SELECT Counduit Run Length';
					 $data['counduit'][1] = '0 to 30';
					 $data['counduit'][2] = '31 to 50';
					 $data['counduit'][3] = '51 to 75';
					 $data['counduit'][4] = '76 to 100';
					 $data['counduit'][5] = '100+';
			
			 
					 $dealtype[''] = 'Select deal type';
					 $dealtype[1] = 'Alternate Energy - HVAC';
					 $unittype[''] = 'Select Unit Type';
					 $unittype['1'] = 'Mitsubishi M-Series Ductless Split AC';
					 $unittype['2'] = 'Fujitsu';
					 $data['dealtype'] = $dealtype;
					 $data['unittype'] = $unittype;
					 $data["proposal_id"]=$data['job']['proposal_id'];
					 $roomname[''] = 'Select Room Type';
					 $roomname[1] = 'Living Room';
					 $roomname[2] = 'Bed Room';
					 $data['roomname'] = $roomname;
					 $aeispecial[''] = 'Select an AEI Special';
					 $aeispecial['1'] = 'AEI Special 1';
					 $aeispecial['2'] = 'AEI Special 2';
					 $data['aeispecial'] = $aeispecial;
					 $room_exposure_longest_wall[''] = 'Select ROOM EXPOSURE--Longest wall';
					 $room_exposure_longest_wall['4'] = 'West';
					 $room_exposure_longest_wall['3'] = 'East';
					 $room_exposure_longest_wall['6'] = 'South';
					 $room_exposure_longest_wall['5'] = 'North';
					 $data['room_exposure_longest_wall'] = $room_exposure_longest_wall;
					 $data['mzone'] = array(''=>'Select Multi-Zone',1=>'MZ1',2=>'MZ2',3=>'MZ3');
					 $sql = "SELECT * FROM acproposal WHERE job_id = '".$data['job']['job_pid']."'";
					$data['proposal'] =  $this->db->query($sql)->row_array();
					$sql = "SELECT * FROM acproposalzone WHERE job_id = '".$data['job']['job_pid']."' ORDER BY zone_type";
					$data['zone1'] =  $this->db->query($sql)->result_array();
				 	$sql_price ="SELECT * FROM  acsystem_price_proposal WHERE proposal_id='".$data["proposal_id"]."'";
					 $result_price = $this->db->query($sql_price)->result_array();
					 $data['system_price']=$result_price;
					 if(count($result_price) < 2){
						$sql_propsoal_price ="INSERT INTO `acsystem_price_proposal`(`proposal_id`,id, `type`, `title`, `price`, `created`, `select_id`, `modified`, `formula`) SELECT  $proposal_id,`id`,`type`, `title`, `price`, `created`, `select_id`, `modified`, `formula` FROM ac_system_price where is_show=1;";
						$this->db->query($sql_propsoal_price);
						$sql_price ="SELECT * FROM  acsystem_price_proposal WHERE proposal_id=$proposal_id";
						$data['system_price'] = $this->db->query($sql_price)->result_array();
					}
					$system_price_json = array();
					foreach($data['system_price'] as $value){
						$system_price_json[$value['id']] = $value;
					}
					$data['systemprice_json']=json_encode($system_price_json);
				
				}

                $data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
				if($data['job']['job_type_id'] == 8 ) { $data['titlejob'] = 'Electrical Pre-install'; }
                if($data['job']['job_type_id'] == 6 ) { $data['titleshow'] = 'PreLag'; }
                if($data['job']['job_type_id'] == 7 ) { $data['titleshow'] = 'Premeasure'; }
				 if($data['job']['job_type_id'] == 8 ) { $data['titlejob'] = 'EL'; }
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		//$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
		// daily job limit
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id,'active');
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		 if($data['job']['project_designer_id']!="" && $data['job']['project_designer_id']){
                    $show_instaler = explode("," ,$data['job']['project_designer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["enginner"]= implode(", " ,$showinstaller_name);
				 } else {
                    $data["enginner"]= " ";
				}
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		$sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_type_id not in (6,7,8,15) AND jobs.job_pid=".$data['job']['job_pid']." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();


		
		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
        if($data['job']['proposal_id']>0){
            $sql_commission = "SELECT * FROM variable_job WHERE variable_id=36 AND proposal_id=".$data['job']['proposal_id'] ;
            @$variable_record=$this->db->query($sql_commission)->row_array();
            $data['commission'] = @$variable_record["quantity"];
		 }
		 $data['referral_job']= Array("1"=>"N0","2"=>"Yes");
                 
		$data['job_statuses'][''] = "- Select a job status -";
               $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']<5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
		$data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
		// Grab payment types
		$data['payment_types'][] = '- Select a payment method -';
		$this->db->order_by('type','asc');
		$payment_types = $this->db->get("payment_types")->result_array();
                $data['inverter_types'][] = '- Select an inverter type -';
                $this->db->order_by('type','asc');
		$inverter_types = $this->db->get("inverter_types")->result_array();
		foreach($inverter_types as $row) { $data['inverter_types'][$row['id']] = $row['type']; }
                    $data['inverter_types']['other'] = 'Other';
                    if($data['job']['other_inverter_type'] != '') $data['job']['inverter_type_id'] = 'other';
			// Grab module powers
                    $data['module_powers'][] = '- Select module power -';
                    $this->db->order_by('power','desc');
                    $module_powers = $this->db->get("module_powers")->result_array();
                    foreach($module_powers as $row) { $data['module_powers'][$row['id']] = $row['power']; }
                        $data['module_powers']['other'] = 'Other';
                    if($data['job']['other_module_power'] != '') $data['job']['module_power_id'] = 'other';
                    // Grab module brands
                    $data['module_brands'][] = '- Select a module Type -';
                    $this->db->order_by('brand','asc');
                    $module_brands = $this->db->get("module_brands")->result_array();
                    foreach($module_brands as $row) { $data['module_brands'][$row['id']] = $row['brand']; }
                        $data['module_brands']['other'] = 'Other';
                	if($data['job']['other_module_brand'] != '') $data['job']['module_brand_id'] = 'other';

		foreach($payment_types as $row)
		{
			$data['payment_types'][$row['id']] = $row['type'];
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['system_special_pricing'] = $this->input->post("system_special_pricing");
			$row['list_price'] = $this->input->post("list_price");
			$row['referral'] = $this->input->post("referral");
			$row['program_discount'] = $this->input->post("program_discount");
			$row['state_excise_tax'] = $this->input->post("state_excise_tax");
			$row['referral_amount'] = $this->input->post("referral_amount");
			$row['sales_commission'] = $this->input->post("sales_commission");
			$row['state_tax_credit'] = $this->input->post("state_tax_credit");

                        $row['federal_tax_credit'] = $this->input->post("federal_tax_credit");
			$row['total_tax_credits'] = $this->input->post("total_tax_credits");
			$row['payment_type_id'] = $this->input->post("payment_type_id");
			$row['financing_comments'] = $this->input->post("financing_comments");
                        $row['institution'] = $this->input->post("institution");
                        $row['payment_dpp'] = $this->input->post("dpp");
			$row['payment_amdpp'] = $this->input->post("amdpp");
			$row['payment_fpp'] = $this->input->post("fpp");
			$row['payment_amfpp'] = $this->input->post("amfpp");
			$row['net_total_price'] = $this->input->post("net_total");
			$row['sub_total_price'] = $this->input->post("sub_total");
                        $nos = $data['job']['job_nos'];
                       
                        for($k=1;$k<$nos;$k++){
                            $row['state_tax_credit_'.$k] = $this->input->post("state_tax_credit_".$k);
                            $row['federal_tax_credit_'.$k] = $this->input->post("federal_tax_credit_".$k);
                        }
                       
			$pid_job = $this->getparentjobid($job_id);
                        $this->db->where("job_pid",$pid_job);
			$this->db->update("jobs",$row);
			
			redirect("admin/job_financing/".$job_id."?savedata=1");
		}
		
		// see if we need to notify user to add a referral
		if($data['job']['referral'] == 'y')
		{
			$this->db->where('job_id',$data['job']['id']);
			$refs = $this->db->get("referrals")->result_array();
			if(count($refs) == 0)
			{
				$data['show_referral_popup'] = true;
			}
		}
		 global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $data['savedata'] =  $this->input->get("savedata");
		$this->load->view("common/header");
                if($data['job']['job_type_id'] == 5 ){
                    $this->load->view("admin/service_financing",$data);
                }else if($data['job']['job_type_id'] == 8 ){
                    $this->load->view("admin/el_financing",$data);
                } else if($data['job']['job_type_id'] == 8 ){
                    $this->load->view("admin/el_financing",$data);
                }  else if($data['job']['job_type_id'] == 15 || $data['job']['job_type_id'] == 16 ){
                    $this->load->view("admin/ac_financing",$data);
                } else if($data['job']['job_type_id'] == 1){
                    if($data['job']['proposal_id']>0){
                       $this->load->view("admin/jobswh_financing_proposal",$data);
                    } else {
                        $this->load->view("admin/jobswh_financing",$data);
                    }
				} elseif($data['job']['job_type_id'] == 20){
                     $sql_systemprice = "SELECT * FROM saf_system_price";
                    $data['system_price'] = $this->db->query($sql_systemprice)->result_array();
                    $data['qoute_mws'][''] = '- Select  -';
                     $data['qoute_iws'][''] = '- Select  -';
                    $data['qoute_kra'][''] = '- Select  -';
                    foreach ($data['system_price'] as $value) {
                        if ($value['type'] == "saftype") {
                        $data['qoute_iws'][$value['id']] = $value['title'];
                    }
                }
                    $this->load->view("admin/saf_job_financing",$data);
                }
                elseif($data['job']['job_type_id'] == 21){
                    $sql_systemprice = "SELECT * FROM homecharging_system_price";
                    $data['system_price']= $this->db->query($sql_systemprice)->result_array();
                    $data['qoute_iws'][''] = '- Select  -';
                  foreach($data['system_price'] as $value){
                    if ($value['type']=="cstype"){
                         $data['qoute_iws'][$value['id']] = $value['title'];
                     }
                               
                  }
                   $this->load->view("admin/ev_job_financing",$data);
                
				}else{
                    $this->load->view("admin/job_financing",$data);
                }
		$this->load->view("common/footer");
	}
        function payment1Details($job_pid){
            $this->db->select('payment_recieved,user_id,datetime');
             $this->db->where('job_pid',$job_pid);
            $this->db->where('payment_recieved_type','DPA');
            $this->db->order_by('datetime','desc');
            $this->db->limit(1);
          return  $query= $this->db->get('payment_recieved_log')->row_array();
        }
        function payment2Details($job_pid){
            $this->db->select('final_payment_recieved,user_id,datetime');
            $this->db->where('payment_recieved_type','FAC');
            $this->db->where('job_pid',$job_pid);
            $this->db->order_by('datetime','desc');
            $this->db->limit(1);
           return $query= $this->db->get('payment_recieved_log')->row_array();
        }
        function getUsername($id){
            if (!$id) return 0;
      $j = $this->db->query("SELECT first_name,last_name FROM users WHERE id=$id")->row_array();

      return $j['first_name'].' '.$j['last_name'];
        }
	function job_referrals($job_id='')
	{
		$this->load->library("job");
		$this->load->helper("text");
		
		$data = array();
		$data['job_id'] = $job_id;
		
		$sql = "SELECT
			referrals.*,
			referral_types.type as referral_type
			FROM
				referrals
			LEFT JOIN referral_types ON referrals.referral_type_id=referral_types.id
			WHERE referrals.job_id=".$this->db->escape($job_id)."
		";
		$data['referrals'] = $this->db->query($sql)->result_array();
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
                $data['job'] = $this->db->query($sql)->row_array();
                $data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
				if($data['job']['job_type_id'] == 8 ) { $data['titlejob'] = 'Electrical Pre-install'; }
                 if($data['job']['job_type_id'] == 6 ) { $data['titleshow'] = 'PreLag'; }
                 if($data['job']['job_type_id'] == 7 ) { $data['titleshow'] = 'Premeasure'; }
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);

                $jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                 $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		 if($data['job']['project_designer_id']!="" && $data['job']['project_designer_id']){
                    $show_instaler = explode("," ,$data['job']['project_designer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["enginner"]= implode(", " ,$showinstaller_name);
				 } else {
                    $data["enginner"]= " ";
		}
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();
		$sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_type_id not in (6,7,8,15) AND jobs.job_pid=".$data['job']['job_pid']." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();
		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
		
		$data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                 $data['job_statuses']['to be completed'] = "To Be Completed";
                 $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
		 global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		$data['savedata'] =  $this->input->get("savedata");
		$this->load->view("common/header");
		$this->load->view("admin/job_referrals",$data);
		$this->load->view("common/footer");
	}
	
	function add_referral($job_id='')
	{
		$this->load->library("job");
		
		$data = array();
		$data['job_id'] = $job_id;
		
		$this->db->where("job_id",$job_id);
		$data['referrals'] = $this->db->get("referrals")->result_array();
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
                $jobtimelimit = $this->gettimeLimit($job_id);
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
		// daily job limit
                if($data["timediff"]<=0){
                  /*  $this->delete_jobcron($job_id);
                    $j = $this->db->query("SELECT * FROM users WHERE id=".$data['job']['user_id']."")->result();
                    $sname = $j[0]->first_name." ".$j[0]->last_name;
                    $this->deletemail($value['id'],$timediff,$sname,$j[0]->email);
                    redirect("admin/jobschedule?m=jd");*/
                }
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                $data['daily_limit'] = $this->db->get("job_limit")->row_array();

		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['plan_files'] = $this->db->get("genral_files")->result_array();
                $data['percent_completed'] = $this->job->percent_completed($job_id);
                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
		$data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
		
		// states array
		$data['states'] =  array('' => "- Choose a state -");
		$data['states'] += array('AK'=>"Alaska",'AL'=>"Alabama",'AR'=>"Arkansas",'AZ'=>"Arizona",'CA'=>"California",'CO'=>"Colorado",'CT'=>"Connecticut",'DC'=>"District Of Columbia",'DE'=>"Delaware",'FL'=>"Florida",'GA'=>"Georgia",'HI'=>"Hawaii",'IA'=>"Iowa",'ID'=>"Idaho",'IL'=>"Illinois", 'IN'=>"Indiana",'KS'=>"Kansas",'KY'=>"Kentucky",'LA'=>"Louisiana",'MA'=>"Massachusetts",'MD'=>"Maryland",'ME'=>"Maine",'MI'=>"Michigan",'MN'=>"Minnesota",'MO'=>"Missouri",'MS'=>"Mississippi",'MT'=>"Montana",'NC'=>"North Carolina",'ND'=>"North Dakota",'NE'=>"Nebraska",'NH'=>"New Hampshire",'NJ'=>"New Jersey",'NM'=>"New Mexico",'NV'=>"Nevada",'NY'=>"New York",'OH'=>"Ohio",'OK'=>"Oklahoma", 'OR'=>"Oregon",'PA'=>"Pennsylvania",'RI'=>"Rhode Island",'SC'=>"South Carolina",'SD'=>"South Dakota",'TN'=>"Tennessee",'TX'=>"Texas",'UT'=>"Utah",'VA'=>"Virginia",'VT'=>"Vermont",'WA'=>"Washington",'WI'=>"Wisconsin",'WV'=>"West Virginia",'WY'=>"Wyoming");
		
		// Grab referral types
		$data['referral_types'][] = '- Select a referral type -';
		$this->db->order_by('type','asc');
		$referral_types = $this->db->get("referral_types")->result_array();
		foreach($referral_types as $row)
		{
			$data['referral_types'][$row['id']] = $row['type'];
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['job_id'] = $job_id;
			$row['referral_type_id'] = $this->input->post("referral_type_id");
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['home_phone'] = $this->input->post("home_phone");
			$row['address'] = $this->input->post("address");
			$row['city'] = $this->input->post("city");
			$row['state'] = $this->input->post("state");
			$row['zip_code'] = $this->input->post("zip_code");
			$row['referral_amount'] = $this->input->post("referral_amount");
                        $row['ti9taxform'] = $this->input->post("ti9taxform");
			$row['comments'] = $this->input->post("comments");
			$this->db->insert("referrals",$row);
			redirect("admin/job_referrals/".$job_id."?savedata=1");
		}
		global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $data['savedata'] =  $this->input->get("savedata");
		$this->load->view("common/header");
		$this->load->view("admin/add_referral",$data);
		$this->load->view("common/footer");
	}
	
	function edit_referral($referral_id='')
	{
		$this->load->library("job");
		
		$data = array();
		
		$data['referral_id'] = $referral_id;
		
		// grab referral info
		$this->db->where("id",$referral_id);
		$data['referral'] = $this->db->get("referrals")->row_array();
		
		$job_id = $data['referral']['job_id'];
		
		$data['job_id'] = $job_id;
		
		$this->db->where("job_id",$job_id);
		$data['referrals'] = $this->db->get("referrals")->result_array();
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
                $jobtimelimit = $this->gettimeLimit($job_id);
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
		// daily job limit
                if($data["timediff"]<=0){
                  /*  $this->delete_jobcron($job_id);
                    $j = $this->db->query("SELECT * FROM users WHERE id=".$data['job']['user_id']."")->result();
                    $sname = $j[0]->first_name." ".$j[0]->last_name;
                    $this->deletemail($value['id'],$timediff,$sname,$j[0]->email);
                    redirect("admin/jobschedule?m=jd");*/
                }
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                $data['daily_limit'] = $this->db->get("job_limit")->row_array();

		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['plan_files'] = $this->db->get("genral_files")->result_array();
                $data['percent_completed'] = $this->job->percent_completed($job_id);
                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
		$data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
		
		// states array
		$data['states'] =  array('' => "- Choose a state -");
		$data['states'] += array('AK'=>"Alaska",'AL'=>"Alabama",'AR'=>"Arkansas",'AZ'=>"Arizona",'CA'=>"California",'CO'=>"Colorado",'CT'=>"Connecticut",'DC'=>"District Of Columbia",'DE'=>"Delaware",'FL'=>"Florida",'GA'=>"Georgia",'HI'=>"Hawaii",'IA'=>"Iowa",'ID'=>"Idaho",'IL'=>"Illinois", 'IN'=>"Indiana",'KS'=>"Kansas",'KY'=>"Kentucky",'LA'=>"Louisiana",'MA'=>"Massachusetts",'MD'=>"Maryland",'ME'=>"Maine",'MI'=>"Michigan",'MN'=>"Minnesota",'MO'=>"Missouri",'MS'=>"Mississippi",'MT'=>"Montana",'NC'=>"North Carolina",'ND'=>"North Dakota",'NE'=>"Nebraska",'NH'=>"New Hampshire",'NJ'=>"New Jersey",'NM'=>"New Mexico",'NV'=>"Nevada",'NY'=>"New York",'OH'=>"Ohio",'OK'=>"Oklahoma", 'OR'=>"Oregon",'PA'=>"Pennsylvania",'RI'=>"Rhode Island",'SC'=>"South Carolina",'SD'=>"South Dakota",'TN'=>"Tennessee",'TX'=>"Texas",'UT'=>"Utah",'VA'=>"Virginia",'VT'=>"Vermont",'WA'=>"Washington",'WI'=>"Wisconsin",'WV'=>"West Virginia",'WY'=>"Wyoming");
		
		// Grab referral types
		$data['referral_types'][] = '- Select a referral type -';
		$this->db->order_by('type','asc');
		$referral_types = $this->db->get("referral_types")->result_array();
		foreach($referral_types as $row)
		{
			$data['referral_types'][$row['id']] = $row['type'];
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['job_id'] = $job_id;
                        $row['referral_type_id'] = $this->input->post("referral_type_id");
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['home_phone'] = $this->input->post("home_phone");
			$row['address'] = $this->input->post("address");
			$row['city'] = $this->input->post("city");
			$row['state'] = $this->input->post("state");
			$row['zip_code'] = $this->input->post("zip_code");
			$row['referral_amount'] = $this->input->post("referral_amount");
                        $row['ti9taxform'] = $this->input->post("ti9taxform");
			$row['comments'] = $this->input->post("comments");
			$this->db->where("id",$referral_id);
			$this->db->update("referrals",$row);
			
			redirect("admin/edit_referral/".$referral_id."?savedata=1");
		}
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		$data['savedata'] =  $this->input->get("savedata");
		$this->load->view("common/header");
		$this->load->view("admin/edit_referral",$data);
		$this->load->view("common/footer");
	}
	
	function service_call($service_call_id='')
	{
		$data = array();
		
		$this->load->helper("text");
		
		if($service_call_id=='') { redirect('admin/error?e=service_call_id'); }
		
		$sql = "SELECT
			service_calls.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address
			FROM
				service_calls
			LEFT JOIN customers ON service_calls.customer_id=customers.id
			WHERE service_calls.id=".$this->db->escape($service_call_id)."
		";
		$data['service_call'] = $this->db->query($sql)->row_array();
		$data['service_call_timestamp'] = strtotime($data['service_call']['date']);
		
		// grab job files
		$this->db->where("service_call_id",$service_call_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
		
		// Grab contractors
		$data['contractors'][] = '- Select a contractor -';
		$this->db->order_by('contractor','asc');
		$contractors = $this->db->get("contractors")->result_array();
		foreach($contractors as $row) { $data['contractors'][$row['id']] = $row['contractor']; }
		
		// find other active jobs for customer that this job belongs to
		//$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		//$data['other_jobs'] = $this->db->query($sql)->result_array();
		
		// find other service calls
		$sql = "SELECT service_calls.* FROM service_calls WHERE service_calls.customer_id=".$this->db->escape($data['service_call']['customer_id'])." AND service_calls.id!=".$this->db->escape($service_call_id)." ORDER BY service_calls.date ASC";
		$data['other_service_calls'] = $this->db->query($sql)->result_array();
		
		// grab service call notes
		$data['job_notes'] = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id=".$this->db->escape($service_call_id)." LIMIT 3")->result_array();
		
		// build times drop-down
		$start = strtotime('9:00am');
		$end = strtotime('9:00pm');

		$data['times_dd'] = array();
		for ($i = $start; $i <= $end; $i += 900)
		{
			$data['times_dd'][date('g:i a', $i)] = date('g:i a', $i);
		}
		
		// grab technician type users
		$technicians = $this->db->query("SELECT * FROM users WHERE type='installer' ORDER BY last_name ASC")->result_array();
		$data['technicians_dd'] = array();
		foreach($technicians as $key => $value)
		{
			$data['technicians_dd'][$value['id']] = $value['first_name']." ".$value['last_name'];
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['technician_id'] = $this->input->post("technician_id");
			$row['repair_time'] = $this->input->post("repair_time");
			$row['repair_type'] = $this->input->post("repair_type");
			$row['description'] = $this->input->post("description");
			//$row['contractor_id'] = $this->input->post("contractor_id");
			$row['comments'] = $this->input->post("comments");
			
			$this->db->where("id",$service_call_id);
			$this->db->update("service_calls",$row);
			
			redirect("admin/service_call/".$service_call_id);
		}
		
		$this->load->view("common/header");
		$this->load->view("admin/service_call",$data);
		$this->load->view("common/footer");
	}
	
	function customer($customer_id='')
	{
		$data = array();
		
		$this->load->helper("text");
		$data['customer_id'] = $customer_id;
                if($customer_id=='') { redirect('admin/error?e=customer_id'); }
		 $data = array();
                 //$data['job_id'] = $job_id;
                 $this->load->library("job");
                 $this->load->helper("text");
                 $sql = "SELECT
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
                        customers.first_name1,
			customers.last_name1,
			customers.address,
			customers.city,
			customers.created as ccreated,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,customers.home_phone,customers.secondary_phone,customers.home_phone1,customers.secondary_phone1,customers.home_phone2,customers.secondary_phone2,
                        customers.household_type_id,
                        customers.email
                        
		FROM
			customers
			
		WHERE customers.id=".$this->db->escape($customer_id)."
		";
		$data['customer'] = $this->db->query($sql)->row_array();
		if(count($data['customer']) == 0){ redirect("admin/error?e=job_id"); }
		
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['customer']['customer_id'])."  ORDER BY jobs.created DESC limit 0,1";
		$data['job'] = $this->db->query($sql)->row_array();
       
	     $userload = $this->getuser($data['job']['user_id']);
         $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);

// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['customer']['customer_id'])."  ORDER BY jobs.job_date ASC";
		$data['jobs'] = $this->db->query($sql)->result_array();


                
        $data['phone'][''] = "- Select a phone -";
        $data['phone']['home'] = "Home";
		$data['phone']['work'] = "work";
		$data['phone']['cell'] = "cell";

                
                $customer_id = $data['customer']['customer_id'];
                $data['customer_id'] = $customer_id;
		if($customer_id=='') { redirect('admin/error?e=customer_id'); }

		$data['states'] =  array('' => "- Choose a state -");
		$data['states'] += array('AK'=>"Alaska",'AL'=>"Alabama",'AR'=>"Arkansas",'AZ'=>"Arizona",'CA'=>"California",'CO'=>"Colorado",'CT'=>"Connecticut",'DC'=>"District Of Columbia",'DE'=>"Delaware",'FL'=>"Florida",'GA'=>"Georgia",'HI'=>"Hawaii",'IA'=>"Iowa",'ID'=>"Idaho",'IL'=>"Illinois", 'IN'=>"Indiana",'KS'=>"Kansas",'KY'=>"Kentucky",'LA'=>"Louisiana",'MA'=>"Massachusetts",'MD'=>"Maryland",'ME'=>"Maine",'MI'=>"Michigan",'MN'=>"Minnesota",'MO'=>"Missouri",'MS'=>"Mississippi",'MT'=>"Montana",'NC'=>"North Carolina",'ND'=>"North Dakota",'NE'=>"Nebraska",'NH'=>"New Hampshire",'NJ'=>"New Jersey",'NM'=>"New Mexico",'NV'=>"Nevada",'NY'=>"New York",'OH'=>"Ohio",'OK'=>"Oklahoma", 'OR'=>"Oregon",'PA'=>"Pennsylvania",'RI'=>"Rhode Island",'SC'=>"South Carolina",'SD'=>"South Dakota",'TN'=>"Tennessee",'TX'=>"Texas",'UT'=>"Utah",'VA'=>"Virginia",'VT'=>"Vermont",'WA'=>"Washington",'WI'=>"Wisconsin",'WV'=>"West Virginia",'WY'=>"Wyoming");

		 $this->db->order_by("id","asc");
                $data['neighbour']['']="Select Geographical Area";
                //$data['neighbour']['other']="Other";
		$this->db->where('is_new =',1);
                $neighbour_display = $this->db->get("neigbhour")->result_array();

                foreach($neighbour_display as $row) { $data['neighbour'][$row['id']] = $row['neighbour']; }

		// find existing, other customers with this address...
		

		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['customer_type_id'] = $this->input->post("customer_type_id");
			$row['household_type_id'] = $this->input->post("household_type_id");
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
                        $row['first_name1'] = $this->input->post("spouse_firstname");
			$row['last_name1'] = $this->input->post("spouse_lastname");
			$row['home_phone'] = $this->input->post("home_phone");
			$row['secondary_phone'] = $this->input->post("secondary_phone");
            $row['home_phone1'] = $this->input->post("home_phone1");
			$row['secondary_phone1'] = $this->input->post("secondary_phone1");
            $row['home_phone2'] = $this->input->post("home_phone2");
			$row['secondary_phone2'] = $this->input->post("secondary_phone2");
			$row['email'] = $this->input->post("email");
			$row['address'] = $this->input->post("address");
			$row['city'] = $this->input->post("city");
			$row['state'] = $this->input->post("state");
			$row['zip_code'] = $this->input->post("zip_code");
            $row['billing_address'] = $this->input->post("billing_address");
			$row['billing_city'] = $this->input->post("billing_city");
			$row['billing_state'] = $this->input->post("billing_state");
			$row['billing_zip_code'] = $this->input->post("billing_zip_code");

			$row['different_billing_address'] = $this->input->post("is_billing_address");
            $row['neighborhood'] = $this->input->post("neighborhood");
			$row['association'] = $this->input->post("association");
			$row['household_members'] = $this->input->post("household_members");
			$row['avg_electric_bill'] = $this->input->post("avg_electric_bill");
			$row['sun_zone'] = $this->input->post("sun_zone");
			$row['cust_tmk'] = $this->input->post("cust_tmk");
            $row['cust_bpan'] = $this->input->post("cust_bpan");
            $row['heco_account_number'] = $this->input->post("heco_account_number");
			$row['heco_meter_number'] = $this->input->post("heco_meter_number");
			$row['comments'] = $this->input->post("comments");
                       
			$this->db->where("id",$customer_id);
			$this->db->update("customers",$row);

			//Create activity log for updated customer
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Update", "customers", '', $this->session->userdata("user_id"), $customer_id);			
			

			redirect("admin/customer/".$customer_id."?savedata=1");
                }
                $sql = "SELECT * FROM household_types ORDER BY `type` ASC";
		$htypes = $this->db->query($sql)->result_array();
		$data['household_types'][] = '- Choose a household type';
		foreach($htypes as $h)
		{
			$data['household_types'][$h['id']] = $h['type'];
		}
		 global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $data['savedata'] =  $this->input->get("savedata");
                $data['errordata'] =  $this->input->get("errordata");
                $this->db->where("id",$customer_id);
		$data['customer'] = $this->db->get("customers")->row_array();
                $this->load->view("common/header");
		$this->load->view("admin/customer_new",$data);
		$this->load->view("common/footer");
	}
	
	function customer_jobs($customer_id='')
	{
		$data = array();
			
		$this->load->view("common/header");
		$this->load->view("admin/customer_jobs",$data);
		$this->load->view("common/footer");
	}
	
	function profile()
	{
		$data = array();
                $this->load->helper("thumbnail_helper");
		$data['validation_errors'] = false;
		$data['updated'] = false;
		
		// grab user data for form
		$data['user'] = $this->db->query("SELECT * FROM users WHERE id=".$this->db->escape($this->session->userdata("user_id")))->row_array();
		
		if($this->input->post("dosubmit"))
		{
			$this->load->library('validation');
			
			if($this->input->post("email") != $this->session->userdata("email")) 
			{
				$rules['email']	= "required|valid_email|callback_email_exists";
			} 
			else 
			{
				$rules['email']	= "required|valid_email";
			}

			$rules['first_name']	= "required";
			$rules['last_name']	= "required";
                        $rules['uname']	= "alpha_numeric|callback_uname_exists";
			if($this->input->post("new_password"))
			{
				$rules['password'] = "callback_password_check";
				$rules['new_password']	= "required|matches[new_password2]";
				$rules['new_password2']	= "required";
			}
			
			$this->validation->set_rules($rules);
			
			$fields['password']	= 'Password';
			$fields['new_password']	= 'New Password';
			$fields['new_password2'] = 'New Password Confirmation';
			$fields['email'] = 'Email Address';
			$fields['first_name'] = 'First Name';
			$fields['last_name'] = 'Last Name';
                        $field['uname'] = "User Name";

			$this->validation->set_fields($fields);

			if ($this->validation->run() == FALSE)
			{
				$data['validation_errors'] = true;
			}
			else
			{
				$data['updated'] = true;
				$row = array();
				$row['email'] = $this->input->post("email");
				$row['first_name'] = $this->input->post("first_name");
				$row['last_name'] = $this->input->post("last_name");
                                $row['uname'] = $this->input->post("uname");
                                $row['phone']= $this->input->post("phone");
				if($this->input->post("new_password"))
				{
					$row['password'] = md5($this->input->post("new_password"));
				}
				$this->db->where("id",$this->session->userdata("user_id"));
				$this->db->update("users",$row);
				
				// grab updated user data for form
				$data['user'] = $this->db->query("SELECT * FROM users WHERE id=".$this->db->escape($this->session->userdata("user_id")))->row_array();
				$this->session->set_userdata('email', $this->input->post("email"));
			}
		}
		
		$this->load->view("common/header");
		$this->load->view("admin/profile",$data);
		$this->load->view("common/footer");
	}
	
	
	//method called for search page functionality
	function search()
	{
		$data = array();
		$data['keywords'] = $this->input->get("q");
		$this->input->get("searchtype");;
		$data['searchtype'] = $this->input->get("searchtype");
		$perpage = $this->input->get("per_page")>=1?$this->input->get("per_page"):0;	
                $config['base_url'] = base_url()."admin/search?q=".$this->input->get("q")."&searchtype=".$this->input->get("searchtype");
		$limit = $this->input->get("limit");
		if($limit > 15 )
		{
			$limit = 15;
		}
                if($limit == '' || !isset($limit))
		{
			$limit = 15;
		}
                $data['limit'] = $limit;
		$config['per_page'] = $limit;
		$keyword = @explode(" ", $this->input->get("q"));
		if(count($keyword)>1){
		$keyword = $this->input->get("q");
		}else{$keyword = $this->input->get("q")."*";}
		$jobscondition = "";
                //$keyword=$this->input->get("q");
		$quotescondition="";
		if( $this->session->userdata("role") != "admin" ){
		$jobscondition = " and jobs.user_id= '".$this->session->userdata("user_id")."'";
		$quotescondition = " and proposal.user_id= '".$this->session->userdata("user_id")."'";
		}
		$sql_cnt="";
		$sql="";
		$data['total_rows'] = 0;
		$data['search_results'] = array();		
		switch ($data['searchtype'])
		{
			case "hoa": //search by customer from search form
				$sql = "SELECT customers.*,MATCH (customers.association)
					AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE) as  relevance  FROM customers
					WHERE MATCH (customers.association)
					AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE) AND customers.first_name != '0' ORDER BY relevance DESC  limit ".$perpage." , ".$config['per_page'];

				$sql_cnt ="SELECT COUNT(distinct customers.id) AS numrows FROM customers
					WHERE MATCH (customers.association)
					AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE) AND customers.first_name != '0'";
			break;
			
			case "customer": //search by customer from search form
				$sql = "SELECT customers.*,MATCH (customers.first_name, 
					customers.last_name, 
					customers.email, 
					customers.zip_code, 
					customers.home_phone, 
					customers.secondary_phone, 
					customers.address)  
					AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE) as relevance   FROM customers
					WHERE MATCH (customers.first_name, 
					customers.last_name, 
					customers.email, 
					customers.zip_code, 
					customers.home_phone, 
					customers.secondary_phone, 
					customers.address)  
					AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE) AND customers.first_name != '0' ORDER BY relevance DESC  limit ".$perpage." , ".$config['per_page'];

				$sql_cnt ="SELECT COUNT(customers.id) AS numrows FROM customers
					WHERE MATCH (customers.first_name, 
					customers.last_name, 
					customers.email, 
					customers.zip_code, 
					customers.home_phone, 
					customers.secondary_phone, 
					customers.address)  
					AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE) AND customers.first_name != '0'";
			break;
	
			case "jobs": //search by jobs from search form
				 $sql = "SELECT distinct customers.*  ,MATCH (
					customers.first_name,
					customers.last_name, 
					customers.address)  
					AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE) as relevance from jobs 
					LEFT JOIN module_brands on module_brands.id= jobs.module_brand_id 
					LEFT JOIN inverter_brands on inverter_brands.id=jobs.inverter_type_id 
					LEFT JOIN roof_types on roof_types.id = jobs.roof_type_id
					LEFT JOIN users on jobs.user_id = users.id
					INNER JOIN customers on customers.id = jobs.customer_id where 
					MATCH (
					customers.first_name,
					customers.last_name, 
					customers.address)  
					AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE)	$jobscondition 
					ORDER BY relevance DESC limit ".$perpage." , ".$config['per_page'];

					$sql_cnt = "SELECT  COUNT(distinct customers.id) AS numrows from jobs 
					LEFT JOIN module_brands on module_brands.id= jobs.module_brand_id 
					LEFT JOIN inverter_brands on inverter_brands.id=jobs.inverter_type_id 
					LEFT JOIN roof_types on roof_types.id = jobs.roof_type_id 
					INNER JOIN customers 
					on customers.id = jobs.customer_id where 
					MATCH (
					customers.first_name,
					customers.last_name, 
					customers.address)  
					AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE)	$jobscondition";		
			break;	
			
			case "quotes": //search by quotes from search form
				 $sql = "SELECT distinct  proposal.*,MATCH (proposal.dpp_lastname,
					proposal.dpp_firstname,
					proposal.price)  
					AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE) as relevance  from proposal 
					LEFT JOIN module_brands on module_brands.id= proposal.module_type 
					LEFT JOIN inverter_brands on inverter_brands.id=proposal.invertert 
					LEFT JOIN roof_types on roof_types.id = proposal.roof_type 
					LEFT JOIN users on proposal.user_id = users.id
					LEFT JOIN customers on customers.id = proposal.customer_id where is_delete=1 AND
					(MATCH (proposal.dpp_lastname,
					proposal.dpp_firstname,
					proposal.price)  
					AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE)
					) $quotescondition
					ORDER BY relevance DESC
					limit ".$perpage." , ".$config['per_page'];
							
					$sql_cnt = "SELECT  COUNT( distinct proposal.id) AS numrows from proposal 
					left join module_brands on module_brands.id= proposal.module_type 
					left join inverter_brands on inverter_brands.id=proposal.invertert 
					left join roof_types on roof_types.id = proposal.roof_type 
					LEFT JOIN users on proposal.user_id = users.id
					left join customers on customers.id = proposal.customer_id where 
					(MATCH (proposal.dpp_lastname,
					proposal.dpp_firstname,
					proposal.price)  
					AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE)
					) $quotescondition
					order by proposal.id desc";			
			break;	

			case "comment": //search by comment from search form
				$sql = "SELECT distinct customers.*,MATCH (customers.first_name,
				customers.last_name,
				customers.address,
				notes.note,
				jobs.comments)  
				AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE) as relevance  from jobs 
				INNER join customers on customers.id = jobs.customer_id 
				LEFT join notes on notes.job_id = jobs.id
				LEFT JOIN users on jobs.user_id = users.id
				where 
				MATCH (customers.first_name,
				customers.last_name,
				customers.address,
				notes.note,
				jobs.comments)  
				AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE) $jobscondition
				ORDER BY relevance DESC  limit ".$perpage." , ".$config['per_page'];

				$sql_cnt = "	SELECT  COUNT(distinct customers.id) AS numrows from jobs 
				INNER join customers on customers.id = jobs.customer_id 
				LEFT join notes on notes.job_id = jobs.id
				LEFT JOIN users on jobs.user_id = users.id
				where 
				MATCH (customers.first_name,
				customers.last_name,
				customers.address,
				notes.note,
				jobs.comments)  
				AGAINST ('".mysql_escape_string($keyword)."' IN BOOLEAN MODE) $jobscondition";		
			break;	
			
		}
		if($sql_cnt !="" && $sql!=""){
		$rowcount = $this->db->query($sql_cnt)->result_array();
		$config['total_rows'] = $rowcount[0]["numrows"];	
		$data['total_rows'] = $rowcount[0]["numrows"];
		$data['search_results'] = $this->db->query($sql)->result_array();
		$this->load->library('pagination');
                $this->pagination->initialize($config);
                $data["links"] = $this->pagination->create_links();    
                }
		$this->load->view("common/header");
		$this->load->view("admin/search",$data);
		$this->load->view("common/footer");
	}
	
	function getSearchJobDetails($customerid){
	
		$sql_query = "SELECT job_types.type, jobs.job_date, jobs.id  from jobs 
					inner join job_types on job_types.id = jobs.job_type_id
					where jobs.customer_id = '".$customerid."' order by jobs.job_date";
		$result = $this->db->query($sql_query)->result_array();
		return $result;
	}
	
	function getSearchCutomerDetails($customerid){
		$sql_query = "SELECT customers.* from customers where customers.id='".$customerid."'";
		$result = $this->db->query($sql_query)->result_array();
		return $result;
	}
	
	function getSearchJobDetailsByProposal($proposalid){
		$sql_query = "SELECT id, job_date from jobs WHERE job_type_id=2 and proposal_id=".$proposalid; // query used from getjobdate() function of proposal controller
		$result = $this->db->query($sql_query)->result_array();
		return $result;	
	
	}
	
	function news()
	{
		$data = array();
			
		$this->load->view("common/header");
		$this->load->view("admin/news",$data);
		$this->load->view("common/footer");
	}
	
	function view_news($news_id)
	{
		$data = array();
			
		$this->load->view("common/header");
		$this->load->view("admin/view_news",$data);
		$this->load->view("common/footer");
	}
	
	function myjobs()
	{
		$data = array();
		
		$this->load->helper("date");
		$this->load->helper("text");
		$this->load->library("job");
	        $this->load->library('pagination');
                $this->load->helper('url');
                $urlstring =  array();
                $urlstring = explode("&per_page=",$_SERVER["QUERY_STRING"]);
                if(count($urlstring)==1){$urlstring[0] = "q=0".$urlstring[0]; }
                $config['base_url'] = base_url()."admin/myjobs?".$urlstring[0];
               // print_R();
		$yearmonth = $this->input->get("yearmonth");
		$day = $this->input->get("day");
		$endyearmonth = $this->input->get("endyearmonth");
		$endday = $this->input->get("endday");
                $data['filterdata'] = true;
		if($yearmonth=='' &&  $endyearmonth==''&& $yearmonth==0 &&  $endyearmonth==0){
                    $data['filterdata'] =false;
                }
		if($yearmonth=='' || $yearmonth==0 ) {$yearmonth = (date("Y")-1)."01";}
		if($day=='' || $day==0) {$day = "01";}
		$yearmonth = preg_replace("/[^0-9]/","",$yearmonth);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['yearmonth'] = $yearmonth;
		$data['day'] = $day;
		
		if($endyearmonth=='' || $endyearmonth==0 ) {$endyearmonth = (date("Y")+3)."12";}
		if($endday=='' || $endday==0 ) {$endday = "31";}
		$endyearmonth = preg_replace("/[^0-9]/","",$endyearmonth);
		$endday = preg_replace("/[^0-9]/","",$endday);
		$data['endyearmonth'] = $endyearmonth;
		$data['endday'] = $endday;
		$salesuserg = $this->input->get("salesuser");
                $sql_saleuser = "";
                if ($salesuserg!=-1 && $salesuserg!="") {
                  $sql_saleuser = " AND (jobs.user_id =".$salesuserg." OR  FIND_IN_SET(".$this->db->escape($salesuserg).",contractor_id) OR FIND_IN_SET(".$this->db->escape($salesuserg).",installer_id) OR FIND_IN_SET(".$this->db->escape($salesuserg).",designer_id) )";
                  $data['salesuser'] = $salesuserg;
                }
                
                $statususerg = $this->input->get("statususer");
                $sql_statususer = "";
                if ($statususerg!=-1 && $statususerg!="") {
                  $sql_statususer = " AND jobs.current_status ='".$statususerg."' ";
                  $data['statususer'] = $statususerg;
                }
                
		$limit = $this->input->get("limit");
                
		if($limit > 30 )
		{
			$limit = 30;
		}
		if($limit == 'all' )
		{
			$limit = '9999';
		}
                if($limit == '' || !isset($limit))
		{
			$limit = 30;
		}
                $data['limit'] = $limit;
		if($limit == '9999') {
                    $data['limit'] = 'all';
                }
		$extra_jobs_sql = '';
		$extra_sc_sql = '';
                $data['editjob'] = true;
                $pv_sql = "";
		if($this->session->userdata("role") != 'admin' )
		{
		 $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                 $pv_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                 $extra_sc_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata("user_id")); 
		}
                if( $this->session->userdata("role") == 'installer')
		{
		  $pv_sql = " AND  FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",installer_id)";
                  $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $extra_sc_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $data['editjob'] = false;
		}
                  if( $this->session->userdata("role") == 'contractor')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",contractor_id)";
                  $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $data['editjob'] = false;
		}
                /* if( $this->session->userdata("rolep") == 'engineer')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",designer_id)";
                  $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $data['editjob'] = false;
		}*/
                   $pv_sql .= $sql_saleuser.$sql_statususer;
        $sql_order_by=" ORDER by jobs.job_date desc"; 
		if($this->session->userdata("role")=='admin'){
		   $sql_order_by=" ORDER by jobs.project_designer_id asc ,jobs.created desc"; 
		}

		$config['per_page'] = $limit;
		// get jobs and service calls matching desired dates
		// get jobs and service calls matching desired dates
		$perpage = $this->input->get("per_page")>=1?$this->input->get("per_page"):0;
                $sql_date = "";
                if($data['filterdata']){
                   $sql_date = " AND DATE_FORMAT(jobs.job_date,'%Y%m%d') >= '".$data['yearmonth'].$data['day']."' AND DATE_FORMAT(jobs.job_date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."'" ;
                }
                $sql = "SELECT jobs.*,customers.association, customers.first_name, customers.last_name, customers.address, customers.city, customers.state, job_types.intials as job_type,users.first_name as userfirstname ,users.last_name as userlastname  FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_date>='".date("Y-m-d")."' AND jobs.current_status!='unscheduled'  $sql_date  $pv_sql  $sql_order_by  limit ".$perpage." , ".$config['per_page'];
		//die(print($sql));
		$jobs = $this->db->query($sql)->result_array();
                $sql_cnt = "SELECT COUNT(*) AS numrows FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_date>='".date("Y-m-d")."' AND  jobs.current_status!='unscheduled'  $sql_date  $pv_sql";
                $jobcnt = $this->db->query($sql_cnt)->result_array();
                $config['total_rows'] = $jobcnt[0]["numrows"];
                $this->pagination->initialize($config);
                $data["links"] = $this->pagination->create_links();
               /* $sql_u = "SELECT jobs.*, customers.first_name, customers.customer_type_id,customers.last_name, customers.address, customers.city, customers.state, job_types.intials as job_type,users.first_name as userfirstname ,users.last_name as userlastname FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE  current_status='unscheduled'  $pv_sql";
		//die(print($sql));
		$jobs_u = $this->db->query($sql_u)->result_array();*/
                //$data['jobs_u'] = $jobs_u;
		$sql = "SELECT service_calls.*,customers.association, customers.first_name, customers.last_name, customers.address, customers.city, customers.state FROM service_calls LEFT JOIN customers ON service_calls.customer_id=customers.id WHERE DATE_FORMAT(service_calls.date,'%Y%m%d') >= '".$data['endyearmonth'].$data['day']."' AND DATE_FORMAT(service_calls.date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."' $extra_sc_sql";
		$service_calls = $this->db->query($sql)->result_array();
		#die(print_r($jobs));
		$data['jobs'] = array();
                $user_id  = array();
                $salesuser = array();
                $statususer = array();
                $statususer["-1"] = "All";
                $salesuser["-1"] = "All";
		$ppfile = array();
                $pmfile =array();
                $tppfile = array();
                $tpmfile = array();
                $tpermitfile = array();
                $skfile = array();
                $tskfile = array();
                $this->db->order_by("created","desc");
		$ppfile = $this->db->get("genral_files")->result_array();
                foreach($ppfile as $ppfilekey => $ppfilevalue){
                    $tppfile[$ppfilevalue['job_id']] = $ppfilevalue;
                }

                $pp_users = array();
				$where='( type="engineer")  AND user_status="active"';
                //$this->db->where("type",'engineer');

                $this->db->where($where);
				
				$ppsql = $this->db->get("users")->result_array();
                $pp_users[0] ="-";
                foreach($ppsql as $ppsqlkey => $ppsqlvalue){
                  $pp_users[$ppsqlvalue['id']] = ucfirst(substr($ppsqlvalue['first_name'],0,1)).ucfirst(substr($ppsqlvalue['last_name'],0,1));
                }

                $data["pp_users"] =  $pp_users;
                $this->db->order_by("created","desc");
		$pmfile = $this->db->get("presale_files")->result_array();
                foreach($pmfile as $pmfilekey => $pmfilevalue){
                  $tpmfile[$pmfilevalue['job_id']] = $pmfilevalue;
                }
                $this->db->order_by("created","desc");
		$permitfile = $this->db->get("permit_files")->result_array();
                foreach($permitfile as $pmfilekey => $pmfilevalue){
                  $tpermitfile[$pmfilevalue['job_id']] = $pmfilevalue;
                }
                $this->db->order_by("created","desc");
		$skfile = $this->db->get("sketch_files")->result_array();
                foreach($skfile as $pmfilekey => $pmfilevalue){
                  $tskfile[$pmfilevalue['job_id']] = $pmfilevalue;
                }
                foreach($jobs as $key => $job)
		{
		    $salesuser[$job['user_id']]  =  ucfirst($job['userfirstname'])." ".ucfirst($job['userlastname'])."(S)";
                    if(isset($job["designer_id"]) && $job["designer_id"]!=""){
                       $exp_user = explode(",",$job["designer_id"]);
                       foreach( $exp_user as $user){
                        if($user==0 || $user=='') continue;
                        $salesuser[$user] = $this->getUserIntial($user,true)."(De)";
                       }
                    }
                    $temp_elec = array();
                    if(isset($job["contractor_id"]) && $job["contractor_id"]!=""){

                        $exp_user = explode(",",$job["contractor_id"]);
                       foreach( $exp_user as $user){
                        if($user==0 || $user=='') continue;
                         $salesuser[$user] = $this->getUserIntial($user,true)."(C)";
                         $temp_elec[]= $this->getUserIntial($user,false);

                       }
                        $job["contractor_id"] = implode(",",$temp_elec);
                    } else{
                        $job["contractor_id"] = "-";
                    }
                    if(isset($job["installer_id"]) && $job["installer_id"]!=""){
                       $exp_user = explode(",",$job["installer_id"]);
                       foreach( $exp_user as $user){
                           if($user==0 || $user=='') continue;
                           $salesuser[$user] = $this->getUserIntial($user,true)."(I)";
                       }
                    }
                     if ($job['current_status']!="" && $job['current_status'] !=null){
                        $statususer[$job['current_status']] = ucfirst($job['current_status']);
                       }
                    if($job['current_status']=='inprogress' || $job['current_status']=="") {
                        $percent_completed = $this->job->percent_completed($job['id']);
                        $jobtimelimit = $this->gettimeLimit($job['id']);
                        $timediff =  (int) ($jobtimelimit-(int)(time()-strtotime($job['created']))/3600);
                        $jobtimelimit1 = $this->getexttimeLimit($job['id']);
                        if($jobtimelimit1){
                          if($timediff>=0){
                             $timediff +=$jobtimelimit1;
                          }else{
                              $timediff = $jobtimelimit1;
                          }

                       }
                        $job['current_status']="<font color='red'>".$percent_completed."%, ".$timediff."hrs remaining</font>";
                      }
                      $output_download = "";
                      $output_plcompletd = "";
                      $output_pmcompletd="";
                      if($job['pl_job_id']!=0 ) {

                      if($job['pl_completed']==1){
                        $output_plcompletd .= "Yes";
                      } else {
                         if($this->session->userdata('role')=='admin'){
                            $output_plcompletd .= "<div id='plcompleted_a_".$job['job_pid']."'><a href='javascript:void(0);'  onclick='complete_pl(".$job['job_pid'].");'>No</a></div>";
                         } else {
                            $output_plcompletd .= "No";
                         }
                      }
                      
                      if($job['pm_completed']==1){
                        $output_pmcompletd .= "/Yes";
                      } else {
                         if($this->session->userdata('role')=='admin'){
                            $output_pmcompletd .= "<div id='pmcompleted_a_".$job['job_pid']."'><a href='javascript:void(0);'  onclick='complete_pm(".$job['job_pid'].");'>/No</a></div>";
                         } else {
                            $output_pmcompletd .= "/No";
                         }
                      }
                      } else {
                          $output_plcompletd = "NA";
                          $output_pmcompletd = "/NA";
                      }
                      $job['pl_completed'] = $output_plcompletd.$output_pmcompletd;
                      if(array_key_exists($job['job_pid'],$tskfile) &&  $this->session->userdata('ofp')==1){
                          $output_download= " <a href='".base_url()."admin/downloadsketch/".$tskfile[$job['job_pid']]['id']."' >Yes</a>";
                      } else {
                          $output_download= "  No";
                      }
                      if(array_key_exists($job['job_pid'],$tpmfile) &&  $this->session->userdata('ofp')==1){
                          if($tpmfile[$job['job_pid']]['notification'])
                          $output_download.= " / <a href='".base_url()."admin/downloadpresale/".$tpmfile[$job['job_pid']]['id']."' class='greendot'>Yes&nbsp;&nbsp;</a>";
                          else
                          $output_download.= " / <a href='".base_url()."admin/downloadpresale/".$tpmfile[$job['job_pid']]['id']."' class='reddot'>Yes&nbsp;&nbsp;</a>";
                      } else{
                          $output_download.= " / No";
                      }
                      if(array_key_exists($job['job_pid'],$tppfile) &&( $this->session->userdata('ppdp')==1 || $this->session->userdata('ppup')==1)){
                          $output_download .= "/ <a href='".base_url()."admin/downloadplan/".$tppfile[$job['job_pid']]['id']."'>Yes</a>";
                      } else {
                          $output_download .= "/ No";
                      }
                     
                      $job["pppm"] = $output_download;

                      $poutput_download = "";
                      $building = false;
                      $netmeter = false;
                      $homeowner = false;
                      $bid = 0;
                      $nid=0;
                      $hid=0;
                      if(array_key_exists($job['job_pid'],$tpermitfile) ){
                          
                          foreach($permitfile as $pmfilekey => $pmfilevalue){
                             if($pmfilevalue['job_id'] == $job['job_pid'] && trim($pmfilevalue['type'])=="building"  ){
                                 $building = true;
                                 $bid = $pmfilevalue['id'];
                             }
                             if($pmfilevalue['job_id'] == $job['job_pid'] && trim($pmfilevalue['type'])=="netmeter"  ){
                                 $netmeter = true;
                                 $nid = $pmfilevalue['id'];
                             }
                             if($pmfilevalue['job_id'] == $job['job_pid'] && trim($pmfilevalue['type'])=="homeowner"  ){
                                 $homeowner = true;
                                 $hid = $pmfilevalue['id'];
                             }
                           }
                      }

                     if($this->session->userdata("role")=='admin'){
					 
                      if(isset($job['association']) && $job['association']!=""){
                          $poutput_download .=$job['association'];
                      } else {
                          $poutput_download .= " None";
                      }
					 } else {
							
					  if($building){
                          $poutput_download= " <a href='".base_url()."admin/downloadpermit/".$bid."' >Yes</a>";
                      } else {
                          $poutput_download= " No";
                      }
                      if($netmeter){
                        $poutput_download.= " / <a href='".base_url()."admin/downloadpermit/".$nid."' >Yes&nbsp;&nbsp;</a>";
                      } else{
                          $poutput_download.= " / No";
                      }
                      if($homeowner){
                          $poutput_download .= "/<a href='".base_url()."admin/downloadpermit/".$hid."'>Yes</a>";
                      } else {
                          $poutput_download .= "/ No";
                      }

					 }
                      $job["pert_file"] = $poutput_download;
                     /** if(isset($job["designer_id"])&& $job["designer_id"] && $job["designer_id"]!=""){
                       $job["designer_id"] = $this->getUserIntial($job["designer_id"],false);
                      }else{
                          $job["designer_id"] = "-";
                      }*/
                      $data['jobs'][strtotime($job['job_date'])][] = $job;
                     
		}
		foreach($service_calls as $key => $service_call)
		{
			$data['jobs'][strtotime($service_call['date'])][] = $service_call;
		}
		if($this->session->userdata("role")!='admin'){
			ksort($data['jobs']);
		}
		$data['salesuserd'] = $salesuser;
                $data['statususerd'] =$statususer;
		// get unique month/year's logged-in user has jobs on
		$sql = "SELECT DISTINCT DATE_FORMAT(jobs.job_date,'%Y%m') as yearmonth, job_date FROM jobs WHERE id != '0' AND jobs.job_date is not null  AND current_status!='unscheduled' AND jobs.job_date !='0000-00-00 00:00:00' $pv_sql ORDER BY yearmonth ASC";
		#die(print($sql));
		$job_months = $this->db->query($sql)->result_array();
		//$service_call_months = $this->db->query("SELECT DISTINCT DATE_FORMAT(service_calls.date,'%Y%m')  as yearmonth, date FROM service_calls WHERE id !='0' $extra_sc_sql ORDER BY yearmonth ASC")->result_array();

		$data['calendar_months'] = $job_months ;
		
		//$data['calendar_months'] = array_unique($data['calendar_months']);
		
		$data['year_month_dd'] = array();
                //$data['year_month_dd'] = array('ALL');
		foreach($data['calendar_months'] as $ym)
		{
			if (@$ym['date']) {
				// only add yearmonth combos that are new
				if(!array_key_exists(date("M Y",strtotime($ym['date'])),$data['year_month_dd']))
				{
					$data['year_month_dd'][$ym['yearmonth']] = date("M Y",strtotime($ym['date']));
				}
			} else {
				if(!array_key_exists(date("M Y",strtotime($ym['job_date'])),$data['year_month_dd']))
				{
					$data['year_month_dd'][$ym['yearmonth']] = date("M Y",strtotime($ym['job_date']));
				}
			}
		}
		
		// day drop down
		$days_count = days_in_month(substr($yearmonth,-2,2),substr($yearmonth,0,4));
		//$data['day_dd'] =  array('All');
                for($i=1; $i<$days_count+1; $i++)
		{
			$data['day_dd'][sprintf("%02d",$i)] = sprintf("%02d",$i);
		}
		
		// limit drop-down
		$data['limit_dd']['5'] = '5';
		$data['limit_dd']['10'] = '10';
		$data['limit_dd']['20'] = '20';
		$data['limit_dd']['30'] = '30';
                $data['limit_dd']['all'] = 'all';
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		 $data["year"] = date("Y");
                $data["month"] = date("n");
                if(!$this->session->userdata('access')){
                     $data['editjob'] = false;
                }
		 $this->load->view("common/header");
		 if($this->session->userdata("role")=='admin'){
			 $this->load->view("admin/admin_myjobs",$data);
		 } else{
		   $this->load->view("admin/myjobs",$data);
		}
	    $this->load->view("common/footer");
	}
	function unscheduled_jobs()
	{
		$data = array();
		
		$this->load->helper("date");
		$this->load->helper("text");
		$this->load->library("job");
	        $this->load->library('pagination');
                $this->load->helper('url');
                $urlstring =  array();
                $urlstring = explode("&per_page=",$_SERVER["QUERY_STRING"]);
                if(count($urlstring)==1){$urlstring[0] = "q=0".$urlstring[0]; }
                $config['base_url'] = base_url()."admin/unscheduled_jobs?".$urlstring[0];
               // print_R();
		$yearmonth = $this->input->get("yearmonth");
		$day = $this->input->get("day");
		$endyearmonth = $this->input->get("endyearmonth");
		$endday = $this->input->get("endday");
                $data['filterdata'] = true;
		if($yearmonth=='' &&  $endyearmonth==''&& $yearmonth==0 &&  $endyearmonth==0){
                    $data['filterdata'] =false;
                }
		if($yearmonth=='' || $yearmonth==0 ) {$yearmonth = (date("Y")-1)."01";}
		if($day=='' || $day==0) {$day = "01";}
		$yearmonth = preg_replace("/[^0-9]/","",$yearmonth);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['yearmonth'] = $yearmonth;
		$data['day'] = $day;
		
		if($endyearmonth=='' || $endyearmonth==0 ) {$endyearmonth = (date("Y")+3)."12";}
		if($endday=='' || $endday==0 ) {$endday = "31";}
		$endyearmonth = preg_replace("/[^0-9]/","",$endyearmonth);
		$endday = preg_replace("/[^0-9]/","",$endday);
		$data['endyearmonth'] = $endyearmonth;
		$data['endday'] = $endday;
		$salesuserg = $this->input->get("salesuser");
                $sql_saleuser = "";
                if ($salesuserg!=-1 && $salesuserg!="") {
                  $sql_saleuser = " AND (jobs.user_id =".$salesuserg." OR  FIND_IN_SET(".$this->db->escape($salesuserg).",contractor_id) OR FIND_IN_SET(".$this->db->escape($salesuserg).",installer_id) OR FIND_IN_SET(".$this->db->escape($salesuserg).",designer_id) )";
                  $data['salesuser'] = $salesuserg;
                }
                
                $statususerg = $this->input->get("statususer");
                $sql_statususer = "";
                if ($statususerg!=-1 && $statususerg!="") {
                  $sql_statususer = " AND jobs.current_status ='".$statususerg."' ";
                  $data['statususer'] = $statususerg;
                }
                
		$limit = $this->input->get("limit");
                
		if($limit > 30 )
		{
			$limit = 30;
		}
		if($limit == 'all' )
		{
			$limit = '9999';
		}
                if($limit == '' || !isset($limit))
		{
			$limit = 30;
		}
                $data['limit'] = $limit;
		if($limit == '9999') {
                    $data['limit'] = 'all';
                }
		$extra_jobs_sql = '';
		$extra_sc_sql = '';
                $data['editjob'] = true;
                $pv_sql = "";
		if($this->session->userdata("role") != 'admin' )
		{
		 $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                 $pv_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                 $extra_sc_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata("user_id")); 
		}
                if( $this->session->userdata("role") == 'installer')
		{
		  $pv_sql = " AND  FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",installer_id)";
                  $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $extra_sc_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $data['editjob'] = false;
		}
                  if( $this->session->userdata("role") == 'contractor')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",contractor_id)";
                  $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $data['editjob'] = false;
		}
                /* if( $this->session->userdata("rolep") == 'engineer')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",designer_id)";
                  $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $data['editjob'] = false;
		}*/
                   $pv_sql .= $sql_saleuser.$sql_statususer;
                    

		$config['per_page'] = $limit;
		// get jobs and service calls matching desired dates
		// get jobs and service calls matching desired dates
		$perpage = $this->input->get("per_page")>=1?$this->input->get("per_page"):0;
                $sql_date = "";
                if($data['filterdata']){
                   $sql_date = " AND DATE_FORMAT(jobs.job_date,'%Y%m%d') >= '".$data['yearmonth'].$data['day']."' AND DATE_FORMAT(jobs.job_date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."'" ;
                }
              /*  $sql = "SELECT jobs.*, customers.first_name, customers.last_name, customers.address, customers.city, customers.state, job_types.intials as job_type,users.first_name as userfirstname ,users.last_name as userlastname  FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE  jobs.current_status!='unscheduled'  $sql_date  $pv_sql   ORDER by jobs.job_date limit ".$perpage." , ".$config['per_page'];
		//die(print($sql));
		$jobs = $this->db->query($sql)->result_array();
                $sql_cnt = "SELECT COUNT(*) AS numrows FROM jobs LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE DATE_FORMAT(jobs.job_date,'%Y%m%d') >= '".$data['yearmonth'].$data['day']."' AND DATE_FORMAT(jobs.job_date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."'   $pv_sql";
                $jobcnt = $this->db->query($sql_cnt)->result_array();
                $config['total_rows'] = $jobcnt[0]["numrows"];
                $this->pagination->initialize($config);
                $data["links"] = $this->pagination->create_links();*/
                $sql_u = "SELECT jobs.*, customers.first_name, customers.customer_type_id,customers.last_name, customers.address, customers.city, customers.state, job_types.intials as job_type,users.first_name as userfirstname ,users.last_name as userlastname FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE  current_status='unscheduled'  $pv_sql  order by jobs.created desc limit ".$perpage." , ".$config['per_page'];

		//die(print($sql));
		$jobs_u = $this->db->query($sql_u)->result_array();
		$jobs=$jobs_u;
		$sql_cnt = "SELECT  COUNT(*) AS numrows FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE  current_status='unscheduled'  $pv_sql";
                $jobcnt = $this->db->query($sql_cnt)->result_array();
                $config['total_rows'] = $jobcnt[0]["numrows"];
                $this->pagination->initialize($config);
                $data["links"] = $this->pagination->create_links();
                $data['jobs_u'] = $jobs_u;
		$sql = "SELECT service_calls.*, customers.first_name, customers.last_name, customers.address, customers.city, customers.state FROM service_calls LEFT JOIN customers ON service_calls.customer_id=customers.id WHERE DATE_FORMAT(service_calls.date,'%Y%m%d') >= '".$data['endyearmonth'].$data['day']."' AND DATE_FORMAT(service_calls.date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."' $extra_sc_sql";
		$service_calls = $this->db->query($sql)->result_array();
		#die(print_r($jobs));
		$data['jobs'] = array();
                $user_id  = array();
                $salesuser = array();
                $statususer = array();
                $statususer["-1"] = "All";
                $salesuser["-1"] = "All";
		$ppfile = array();
                $pmfile =array();
                $tppfile = array();
                $tpmfile = array();
                $tpermitfile = array();
                $skfile = array();
                $tskfile = array();
                $this->db->order_by("created","desc");
		$ppfile = $this->db->get("genral_files")->result_array();
                foreach($ppfile as $ppfilekey => $ppfilevalue){
                    $tppfile[$ppfilevalue['job_id']] = $ppfilevalue;
                }

                $pp_users = array();
				$where='(type="engineer1" OR  type="warehouse" )';
                //$this->db->where("type",'engineer');
                $this->db->where($where);
				$ppsql = $this->db->get("users")->result_array();
                $pp_users[0] ="-";
                foreach($ppsql as $ppsqlkey => $ppsqlvalue){
                  $pp_users[$ppsqlvalue['id']] = ucfirst(substr($ppsqlvalue['first_name'],0,1)).ucfirst(substr($ppsqlvalue['last_name'],0,1));
                }

                $data["pp_users"] =  $pp_users;
                $this->db->order_by("created","desc");
		$pmfile = $this->db->get("presale_files")->result_array();
                foreach($pmfile as $pmfilekey => $pmfilevalue){
                  $tpmfile[$pmfilevalue['job_id']] = $pmfilevalue;
                }
                $this->db->order_by("created","desc");
		$permitfile = $this->db->get("permit_files")->result_array();
                foreach($permitfile as $pmfilekey => $pmfilevalue){
                  $tpermitfile[$pmfilevalue['job_id']] = $pmfilevalue;
                }
                $this->db->order_by("created","desc");
		$skfile = $this->db->get("sketch_files")->result_array();
                foreach($skfile as $pmfilekey => $pmfilevalue){
                  $tskfile[$pmfilevalue['job_id']] = $pmfilevalue;
                }
                foreach($jobs as $key => $job)
		{
		    $salesuser[$job['user_id']]  =  ucfirst($job['userfirstname'])." ".ucfirst($job['userlastname'])."(S)";
                    if(isset($job["designer_id"]) && $job["designer_id"]!=""){
                       $exp_user = explode(",",$job["designer_id"]);
                       foreach( $exp_user as $user){
                        if($user==0 || $user=='') continue;
                        $salesuser[$user] = $this->getUserIntial($user,true)."(De)";
                       }
                    }
                    $temp_elec = array();
                    if(isset($job["contractor_id"]) && $job["contractor_id"]!=""){

                        $exp_user = explode(",",$job["contractor_id"]);
                       foreach( $exp_user as $user){
                        if($user==0 || $user=='') continue;
                         $salesuser[$user] = $this->getUserIntial($user,true)."(C)";
                         $temp_elec[]= $this->getUserIntial($user,false);

                       }
                        $job["contractor_id"] = implode(",",$temp_elec);
                    } else{
                        $job["contractor_id"] = "-";
                    }
                    if(isset($job["installer_id"]) && $job["installer_id"]!=""){
                       $exp_user = explode(",",$job["installer_id"]);
                       foreach( $exp_user as $user){
                           if($user==0 || $user=='') continue;
                           $salesuser[$user] = $this->getUserIntial($user,true)."(I)";
                       }
                    }
                     if ($job['current_status']!="" && $job['current_status'] !=null){
                        $statususer[$job['current_status']] = ucfirst($job['current_status']);
                       }
                    if($job['current_status']=='inprogress' || $job['current_status']=="") {
                        $percent_completed = $this->job->percent_completed($job['id']);
                        $jobtimelimit = $this->gettimeLimit($job['id']);
                        $timediff =  (int) ($jobtimelimit-(int)(time()-strtotime($job['created']))/3600);
                        $jobtimelimit1 = $this->getexttimeLimit($job['id']);
                        if($jobtimelimit1){
                          if($timediff>=0){
                             $timediff +=$jobtimelimit1;
                          }else{
                              $timediff = $jobtimelimit1;
                          }

                       }
                        $job['current_status']="<font color='red'>".$percent_completed."%, ".$timediff."hrs remaining</font>";
                      }
                      $output_download = "";
                      $output_plcompletd = "";
                      $output_pmcompletd="";
                      if($job['pl_job_id']!=0 ) {

                      if($job['pl_completed']==1){
                        $output_plcompletd .= "Yes";
                      } else {
                         if($this->session->userdata('role')=='admin'){
                            $output_plcompletd .= "<div id='plcompleted_a_".$job['job_pid']."'><a href='javascript:void(0);'  onclick='complete_pl(".$job['job_pid'].");'>No</a></div>";
                         } else {
                            $output_plcompletd .= "No";
                         }
                      }
                      
                      if($job['pm_completed']==1){
                        $output_pmcompletd .= "/Yes";
                      } else {
                         if($this->session->userdata('role')=='admin'){
                            $output_pmcompletd .= "<div id='pmcompleted_a_".$job['job_pid']."'><a href='javascript:void(0);'  onclick='complete_pm(".$job['job_pid'].");'>/No</a></div>";
                         } else {
                            $output_pmcompletd .= "/No";
                         }
                      }
                      } else {
                          $output_plcompletd = "NA";
                          $output_pmcompletd = "/NA";
                      }
                      $job['pl_completed'] = $output_plcompletd.$output_pmcompletd;
                      if(array_key_exists($job['job_pid'],$tskfile) &&  $this->session->userdata('ofp')==1){
                          $output_download= " <a href='".base_url()."admin/downloadsketch/".$tskfile[$job['job_pid']]['id']."' >Yes</a>";
                      } else {
                          $output_download= "  No";
                      }
                      if(array_key_exists($job['job_pid'],$tpmfile) &&  $this->session->userdata('ofp')==1){
                          if($tpmfile[$job['job_pid']]['notification'])
                          $output_download.= " / <a href='".base_url()."admin/downloadpresale/".$tpmfile[$job['job_pid']]['id']."' class='greendot'>Yes&nbsp;&nbsp;</a>";
                          else
                          $output_download.= " / <a href='".base_url()."admin/downloadpresale/".$tpmfile[$job['job_pid']]['id']."' class='reddot'>Yes&nbsp;&nbsp;</a>";
                      } else{
                          $output_download.= " / No";
                      }
                      if(array_key_exists($job['job_pid'],$tppfile) &&( $this->session->userdata('ppdp')==1 || $this->session->userdata('ppup')==1)){
                          $output_download .= "/ <a href='".base_url()."admin/downloadplan/".$tppfile[$job['job_pid']]['id']."'>Yes</a>";
                      } else {
                          $output_download .= "/ No";
                      }
                     
                      $job["pppm"] = $output_download;

                      $poutput_download = "";
                      $building = false;
                      $netmeter = false;
                      $homeowner = false;
                      $bid = 0;
                      $nid=0;
                      $hid=0;
                      if(array_key_exists($job['job_pid'],$tpermitfile) ){
                          
                          foreach($permitfile as $pmfilekey => $pmfilevalue){
                             if($pmfilevalue['job_id'] == $job['job_pid'] && trim($pmfilevalue['type'])=="building"  ){
                                 $building = true;
                                 $bid = $pmfilevalue['id'];
                             }
                             if($pmfilevalue['job_id'] == $job['job_pid'] && trim($pmfilevalue['type'])=="netmeter"  ){
                                 $netmeter = true;
                                 $nid = $pmfilevalue['id'];
                             }
                             if($pmfilevalue['job_id'] == $job['job_pid'] && trim($pmfilevalue['type'])=="homeowner"  ){
                                 $homeowner = true;
                                 $hid = $pmfilevalue['id'];
                             }
                           }
                      }
                      if($building){
                          $poutput_download= " <a href='".base_url()."admin/downloadpermit/".$bid."' >Yes</a>";
                      } else {
                          $poutput_download= " No";
                      }
                      if($netmeter){
                        $poutput_download.= " / <a href='".base_url()."admin/downloadpermit/".$nid."' >Yes&nbsp;&nbsp;</a>";
                      } else{
                          $poutput_download.= " / No";
                      }
                      if($homeowner){
                          $poutput_download .= "/ <a href='".base_url()."admin/downloadpermit/".$hid."'>Yes</a>";
                      } else {
                          $poutput_download .= "/ No";
                      }
                      $job["pert_file"] = $poutput_download;
                     /** if(isset($job["designer_id"])&& $job["designer_id"] && $job["designer_id"]!=""){
                       $job["designer_id"] = $this->getUserIntial($job["designer_id"],false);
                      }else{
                          $job["designer_id"] = "-";
                      }*/
                      $data['jobs'][strtotime($job['job_date'])][] = $job;
                     
		}
		foreach($service_calls as $key => $service_call)
		{
			$data['jobs'][strtotime($service_call['date'])][] = $service_call;
		}
		ksort($data['jobs']);
		 $ss_users = array();
				$where='( type="sales" )';
                //$this->db->where("type",'engineer');
                $this->db->where($where);
				$ppsql = $this->db->get("users")->result_array();
                $ss_users["-1"] ="All";
                foreach($ppsql as $ppsqlkey => $ppsqlvalue){
                  $ss_users[$ppsqlvalue['id']] = ucfirst($ppsqlvalue['first_name']).ucfirst($ppsqlvalue['last_name'])."(S)";
                }
		$data['salesuserd'] = $ss_users;
                $data['statususerd'] =$statususer;
		// get unique month/year's logged-in user has jobs on
		$sql = "SELECT DISTINCT DATE_FORMAT(jobs.job_date,'%Y%m') as yearmonth, job_date FROM jobs WHERE id != '0' AND jobs.job_date is not null  AND current_status!='unscheduled' AND jobs.job_date !='0000-00-00 00:00:00' $pv_sql ORDER BY yearmonth ASC";
		#die(print($sql));
		$job_months = $this->db->query($sql)->result_array();
		//$service_call_months = $this->db->query("SELECT DISTINCT DATE_FORMAT(service_calls.date,'%Y%m')  as yearmonth, date FROM service_calls WHERE id !='0' $extra_sc_sql ORDER BY yearmonth ASC")->result_array();

		$data['calendar_months'] = $job_months ;
		
		//$data['calendar_months'] = array_unique($data['calendar_months']);
		
		$data['year_month_dd'] = array();
                //$data['year_month_dd'] = array('ALL');
		foreach($data['calendar_months'] as $ym)
		{
			if (@$ym['date']) {
				// only add yearmonth combos that are new
				if(!array_key_exists(date("M Y",strtotime($ym['date'])),$data['year_month_dd']))
				{
					$data['year_month_dd'][$ym['yearmonth']] = date("M Y",strtotime($ym['date']));
				}
			} else {
				if(!array_key_exists(date("M Y",strtotime($ym['job_date'])),$data['year_month_dd']))
				{
					$data['year_month_dd'][$ym['yearmonth']] = date("M Y",strtotime($ym['job_date']));
				}
			}
		}
		
		// day drop down
		$days_count = days_in_month(substr($yearmonth,-2,2),substr($yearmonth,0,4));
		//$data['day_dd'] =  array('All');
                for($i=1; $i<$days_count+1; $i++)
		{
			$data['day_dd'][sprintf("%02d",$i)] = sprintf("%02d",$i);
		}
		
		// limit drop-down
		$data['limit_dd']['5'] = '5';
		$data['limit_dd']['10'] = '10';
		$data['limit_dd']['20'] = '20';
		$data['limit_dd']['30'] = '30';
                $data['limit_dd']['all'] = 'all';
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		 $data["year"] = date("Y");
                $data["month"] = date("n");
                if(!$this->session->userdata('access')){
                     $data['editjob'] = false;
                }
		$this->load->view("common/header");
		$this->load->view("admin/myjobsu",$data);
		$this->load->view("common/footer");
	}

	function mycompletejobs()
	{
		$data = array();
		
		$this->load->helper("date");
		$this->load->helper("text");
		$this->load->library("job");
	        $this->load->library('pagination');
                $this->load->helper('url');
                $urlstring =  array();
                $urlstring = explode("&per_page=",$_SERVER["QUERY_STRING"]);
                if(count($urlstring)==1){$urlstring[0] = "q=0".$urlstring[0]; }
                $config['base_url'] = base_url()."admin/mycompletejobs?".$urlstring[0];
               // print_R();
		$yearmonth = $this->input->get("yearmonth");
		$day = $this->input->get("day");
		$endyearmonth = $this->input->get("endyearmonth");
		$endday = $this->input->get("endday");
                $data['filterdata'] = true;
		if($yearmonth=='' &&  $endyearmonth==''&& $yearmonth==0 &&  $endyearmonth==0){
                    $data['filterdata'] =false;
                }
		if($yearmonth=='' || $yearmonth==0 ) {$yearmonth = (date("Y")-1)."01";}
		if($day=='' || $day==0) {$day = "01";}
		$yearmonth = preg_replace("/[^0-9]/","",$yearmonth);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['yearmonth'] = $yearmonth;
		$data['day'] = $day;
		
		if($endyearmonth=='' || $endyearmonth==0 ) {$endyearmonth = (date("Y")+3)."12";}
		if($endday=='' || $endday==0 ) {$endday = "31";}
		$endyearmonth = preg_replace("/[^0-9]/","",$endyearmonth);
		$endday = preg_replace("/[^0-9]/","",$endday);
		$data['endyearmonth'] = $endyearmonth;
		$data['endday'] = $endday;
		$salesuserg = $this->input->get("salesuser");
                $sql_saleuser = "";
                if ($salesuserg!=-1 && $salesuserg!="") {
                  $sql_saleuser = " AND (jobs.user_id =".$salesuserg." OR  FIND_IN_SET(".$this->db->escape($salesuserg).",contractor_id) OR FIND_IN_SET(".$this->db->escape($salesuserg).",installer_id) OR FIND_IN_SET(".$this->db->escape($salesuserg).",designer_id) )";
                  $data['salesuser'] = $salesuserg;
                }
                
                $statususerg = $this->input->get("statususer");
                $sql_statususer = "";
                if ($statususerg!=-1 && $statususerg!="") {
                  $sql_statususer = " AND jobs.current_status ='".$statususerg."' ";
                  $data['statususer'] = $statususerg;
                }
                
		$limit = $this->input->get("limit");
                
		if($limit > 30 )
		{
			$limit = 30;
		}
		if($limit == 'all' )
		{
			$limit = '9999';
		}
                if($limit == '' || !isset($limit))
		{
			$limit = 30;
		}
                $data['limit'] = $limit;
		if($limit == '9999') {
                    $data['limit'] = 'all';
                }
		$extra_jobs_sql = '';
		$extra_sc_sql = '';
                $data['editjob'] = true;
                $pv_sql = "";
		if($this->session->userdata("role") != 'admin' )
		{
		 $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                 $pv_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                 $extra_sc_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata("user_id")); 
		}
                if( $this->session->userdata("role") == 'installer')
		{
		  $pv_sql = " AND  FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",installer_id)";
                  $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $extra_sc_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $data['editjob'] = false;
		}
                  if( $this->session->userdata("role") == 'contractor')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",contractor_id)";
                  $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $data['editjob'] = false;
		}
                /* if( $this->session->userdata("rolep") == 'engineer')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",designer_id)";
                  $extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
                  $data['editjob'] = false;
		}*/
                   $pv_sql .= $sql_saleuser.$sql_statususer;
                    

		$config['per_page'] = $limit;
		// get jobs and service calls matching desired dates
		// get jobs and service calls matching desired dates
		$perpage = $this->input->get("per_page")>=1?$this->input->get("per_page"):0;
                $sql_date = "";
                if($data['filterdata']){
                   $sql_date = " AND DATE_FORMAT(jobs.job_date,'%Y%m%d') >= '".$data['yearmonth'].$data['day']."' AND DATE_FORMAT(jobs.job_date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."'" ;
                }
				$sql_date .=' AND jobs.job_date < "'.date('Y-m-d').'"';
              /*  $sql = "SELECT jobs.*, customers.first_name, customers.last_name, customers.address, customers.city, customers.state, job_types.intials as job_type,users.first_name as userfirstname ,users.last_name as userlastname  FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE  jobs.current_status!='unscheduled'  $sql_date  $pv_sql   ORDER by jobs.job_date limit ".$perpage." , ".$config['per_page'];
		//die(print($sql));
		$jobs = $this->db->query($sql)->result_array();
                $sql_cnt = "SELECT COUNT(*) AS numrows FROM jobs LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE DATE_FORMAT(jobs.job_date,'%Y%m%d') >= '".$data['yearmonth'].$data['day']."' AND DATE_FORMAT(jobs.job_date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."'   $pv_sql";
                $jobcnt = $this->db->query($sql_cnt)->result_array();
                $config['total_rows'] = $jobcnt[0]["numrows"];
                $this->pagination->initialize($config);
                $data["links"] = $this->pagination->create_links();*/
                $sql_u = "SELECT jobs.*, customers.first_name, customers.customer_type_id,customers.last_name, customers.address, customers.city, customers.state, job_types.intials as job_type,users.first_name as userfirstname ,users.last_name as userlastname FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE  jobs.job_date >'2000-1-1' AND 1=1  $pv_sql $sql_date order by jobs.created desc limit ".$perpage." , ".$config['per_page'];

		//die(print($sql));
		$jobs_u = $this->db->query($sql_u)->result_array();
		$jobs=$jobs_u;
		$sql_cnt = " SELECT  COUNT(*) AS numrows  FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE 1=1  $pv_sql $sql_date";
                $jobcnt = $this->db->query($sql_cnt)->result_array();
                $config['total_rows'] = $jobcnt[0]["numrows"];
                $this->pagination->initialize($config);
                $data["links"] = $this->pagination->create_links();
                $data['jobs_u'] = $jobs_u;
		$sql = "SELECT service_calls.*, customers.first_name, customers.last_name, customers.address, customers.city, customers.state FROM service_calls LEFT JOIN customers ON service_calls.customer_id=customers.id WHERE DATE_FORMAT(service_calls.date,'%Y%m%d') >= '".$data['endyearmonth'].$data['day']."' AND DATE_FORMAT(service_calls.date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."' $extra_sc_sql";
		$service_calls = $this->db->query($sql)->result_array();
		#die(print_r($jobs));
		$data['jobs'] = array();
                $user_id  = array();
                $salesuser = array();
                $statususer = array();
                $statususer["-1"] = "All";
                $salesuser["-1"] = "All";
		$ppfile = array();
                $pmfile =array();
                $tppfile = array();
                $tpmfile = array();
                $tpermitfile = array();
                $skfile = array();
                $tskfile = array();
                $this->db->order_by("created","desc");
		$ppfile = $this->db->get("genral_files")->result_array();
                foreach($ppfile as $ppfilekey => $ppfilevalue){
                    $tppfile[$ppfilevalue['job_id']] = $ppfilevalue;
                }

                $pp_users = array();
				$where='(type="warehouse" or type="engineer1" )  AND user_status="active"';
                //$this->db->where("type",'engineer');
                $this->db->where($where);
    			
				$ppsql = $this->db->get("users")->result_array();
                $pp_users[0] ="-";
                foreach($ppsql as $ppsqlkey => $ppsqlvalue){
                  $pp_users[$ppsqlvalue['id']] = ucfirst(substr($ppsqlvalue['first_name'],0,1)).ucfirst(substr($ppsqlvalue['last_name'],0,1));
                }

                $data["pp_users"] =  $pp_users;
                $this->db->order_by("created","desc");
		$pmfile = $this->db->get("presale_files")->result_array();
                foreach($pmfile as $pmfilekey => $pmfilevalue){
                  $tpmfile[$pmfilevalue['job_id']] = $pmfilevalue;
                }
                $this->db->order_by("created","desc");
		$permitfile = $this->db->get("permit_files")->result_array();
                foreach($permitfile as $pmfilekey => $pmfilevalue){
                  $tpermitfile[$pmfilevalue['job_id']] = $pmfilevalue;
                }
                $this->db->order_by("created","desc");
		$skfile = $this->db->get("sketch_files")->result_array();
                foreach($skfile as $pmfilekey => $pmfilevalue){
                  $tskfile[$pmfilevalue['job_id']] = $pmfilevalue;
                }
                foreach($jobs as $key => $job)
		{
		    $salesuser[$job['user_id']]  =  ucfirst($job['userfirstname'])." ".ucfirst($job['userlastname'])."(S)";
                    if(isset($job["designer_id"]) && $job["designer_id"]!=""){
                       $exp_user = explode(",",$job["designer_id"]);
                       foreach( $exp_user as $user){
                        if($user==0 || $user=='') continue;
                        $salesuser[$user] = $this->getUserIntial($user,true)."(De)";
                       }
                    }
                    $temp_elec = array();
                    if(isset($job["contractor_id"]) && $job["contractor_id"]!=""){

                        $exp_user = explode(",",$job["contractor_id"]);
                       foreach( $exp_user as $user){
                        if($user==0 || $user=='') continue;
                         $salesuser[$user] = $this->getUserIntial($user,true)."(C)";
                         $temp_elec[]= $this->getUserIntial($user,false);

                       }
                        $job["contractor_id"] = implode(",",$temp_elec);
                    } else{
                        $job["contractor_id"] = "-";
                    }
                    if(isset($job["installer_id"]) && $job["installer_id"]!=""){
                       $exp_user = explode(",",$job["installer_id"]);
                       foreach( $exp_user as $user){
                           if($user==0 || $user=='') continue;
                           $salesuser[$user] = $this->getUserIntial($user,true)."(I)";
                       }
                    }
                     if ($job['current_status']!="" && $job['current_status'] !=null){
                        $statususer[$job['current_status']] = ucfirst($job['current_status']);
                       }
                    if($job['current_status']=='inprogress' || $job['current_status']=="") {
                        $percent_completed = @$this->job->percent_completed($job['id']);
                        $jobtimelimit = $this->gettimeLimit($job['id']);
                        $timediff =  (int) ($jobtimelimit-(int)(time()-strtotime($job['created']))/3600);
                        $jobtimelimit1 = $this->getexttimeLimit($job['id']);
                        if($jobtimelimit1){
                          if($timediff>=0){
                             $timediff +=$jobtimelimit1;
                          }else{
                              $timediff = $jobtimelimit1;
                          }

                       }
                        $job['current_status']="<font color='red'>".$percent_completed."%, ".$timediff."hrs remaining</font>";
                      }
                      $output_download = "";
                      $output_plcompletd = "";
                      $output_pmcompletd="";
                      if($job['pl_job_id']!=0 ) {

                      if($job['pl_completed']==1){
                        $output_plcompletd .= "Yes";
                      } else {
                         if($this->session->userdata('role')=='admin'){
                            $output_plcompletd .= "<div id='plcompleted_a_".$job['job_pid']."'><a href='javascript:void(0);'  onclick='complete_pl(".$job['job_pid'].");'>No</a></div>";
                         } else {
                            $output_plcompletd .= "No";
                         }
                      }
                      
                      if($job['pm_completed']==1){
                        $output_pmcompletd .= "/Yes";
                      } else {
                         if($this->session->userdata('role')=='admin'){
                            $output_pmcompletd .= "<div id='pmcompleted_a_".$job['job_pid']."'><a href='javascript:void(0);'  onclick='complete_pm(".$job['job_pid'].");'>/No</a></div>";
                         } else {
                            $output_pmcompletd .= "/No";
                         }
                      }
                      } else {
                          $output_plcompletd = "NA";
                          $output_pmcompletd = "/NA";
                      }
                      $job['pl_completed'] = $output_plcompletd.$output_pmcompletd;
                      if(array_key_exists($job['job_pid'],$tskfile) &&  $this->session->userdata('ofp')==1){
                          $output_download= " <a href='".base_url()."admin/downloadsketch/".$tskfile[$job['job_pid']]['id']."' >Yes</a>";
                      } else {
                          $output_download= "  No";
                      }
                      if(array_key_exists($job['job_pid'],$tpmfile) &&  $this->session->userdata('ofp')==1){
                          if($tpmfile[$job['job_pid']]['notification'])
                          $output_download.= " / <a href='".base_url()."admin/downloadpresale/".$tpmfile[$job['job_pid']]['id']."' class='greendot'>Yes&nbsp;&nbsp;</a>";
                          else
                          $output_download.= " / <a href='".base_url()."admin/downloadpresale/".$tpmfile[$job['job_pid']]['id']."' class='reddot'>Yes&nbsp;&nbsp;</a>";
                      } else{
                          $output_download.= " / No";
                      }
                      if(array_key_exists($job['job_pid'],$tppfile) &&( $this->session->userdata('ppdp')==1 || $this->session->userdata('ppup')==1)){
                          $output_download .= "/ <a href='".base_url()."admin/downloadplan/".$tppfile[$job['job_pid']]['id']."'>Yes</a>";
                      } else {
                          $output_download .= "/ No";
                      }
                     
                      $job["pppm"] = $output_download;

                      $poutput_download = "";
                      $building = false;
                      $netmeter = false;
                      $homeowner = false;
                      $bid = 0;
                      $nid=0;
                      $hid=0;
                      if(array_key_exists($job['job_pid'],$tpermitfile) ){
                          
                          foreach($permitfile as $pmfilekey => $pmfilevalue){
                             if($pmfilevalue['job_id'] == $job['job_pid'] && trim($pmfilevalue['type'])=="building"  ){
                                 $building = true;
                                 $bid = $pmfilevalue['id'];
                             }
                             if($pmfilevalue['job_id'] == $job['job_pid'] && trim($pmfilevalue['type'])=="netmeter"  ){
                                 $netmeter = true;
                                 $nid = $pmfilevalue['id'];
                             }
                             if($pmfilevalue['job_id'] == $job['job_pid'] && trim($pmfilevalue['type'])=="homeowner"  ){
                                 $homeowner = true;
                                 $hid = $pmfilevalue['id'];
                             }
                           }
                      }
                      if($building){
                          $poutput_download= " <a href='".base_url()."admin/downloadpermit/".$bid."' >Yes</a>";
                      } else {
                          $poutput_download= " No";
                      }
                      if($netmeter){
                        $poutput_download.= " / <a href='".base_url()."admin/downloadpermit/".$nid."' >Yes&nbsp;&nbsp;</a>";
                      } else{
                          $poutput_download.= " / No";
                      }
                      if($homeowner){
                          $poutput_download .= "/ <a href='".base_url()."admin/downloadpermit/".$hid."'>Yes</a>";
                      } else {
                          $poutput_download .= "/ No";
                      }
                      $job["pert_file"] = $poutput_download;
                     /** if(isset($job["designer_id"])&& $job["designer_id"] && $job["designer_id"]!=""){
                       $job["designer_id"] = $this->getUserIntial($job["designer_id"],false);
                      }else{
                          $job["designer_id"] = "-";
                      }*/
                      $data['jobs'][strtotime($job['job_date'])][] = $job;
                     
		}
		foreach($service_calls as $key => $service_call)
		{
			$data['jobs'][strtotime($service_call['date'])][] = $service_call;
		}
		ksort($data['jobs']);
		$data['salesuserd'] = $salesuser;
                $data['statususerd'] =$statususer;
		// get unique month/year's logged-in user has jobs on
		$sql = "SELECT DISTINCT DATE_FORMAT(jobs.job_date,'%Y%m') as yearmonth, job_date FROM jobs WHERE id != '0' AND jobs.job_date is not null  AND current_status!='unscheduled' AND jobs.job_date !='0000-00-00 00:00:00' $pv_sql ORDER BY yearmonth ASC";
		#die(print($sql));
		$job_months = $this->db->query($sql)->result_array();
		//$service_call_months = $this->db->query("SELECT DISTINCT DATE_FORMAT(service_calls.date,'%Y%m')  as yearmonth, date FROM service_calls WHERE id !='0' $extra_sc_sql ORDER BY yearmonth ASC")->result_array();

		$data['calendar_months'] = $job_months ;
		
		//$data['calendar_months'] = array_unique($data['calendar_months']);
		
		$data['year_month_dd'] = array();
                //$data['year_month_dd'] = array('ALL');
		foreach($data['calendar_months'] as $ym)
		{
			if (@$ym['date']) {
				// only add yearmonth combos that are new
				if(!array_key_exists(date("M Y",strtotime($ym['date'])),$data['year_month_dd']))
				{
					$data['year_month_dd'][$ym['yearmonth']] = date("M Y",strtotime($ym['date']));
				}
			} else {
				if(!array_key_exists(date("M Y",strtotime($ym['job_date'])),$data['year_month_dd']))
				{
					$data['year_month_dd'][$ym['yearmonth']] = date("M Y",strtotime($ym['job_date']));
				}
			}
		}
		
		// day drop down
		$days_count = days_in_month(substr($yearmonth,-2,2),substr($yearmonth,0,4));
		//$data['day_dd'] =  array('All');
                for($i=1; $i<$days_count+1; $i++)
		{
			$data['day_dd'][sprintf("%02d",$i)] = sprintf("%02d",$i);
		}
		
		// limit drop-down
		$data['limit_dd']['5'] = '5';
		$data['limit_dd']['10'] = '10';
		$data['limit_dd']['20'] = '20';
		$data['limit_dd']['30'] = '30';
                $data['limit_dd']['all'] = 'all';
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		 $data["year"] = date("Y");
                $data["month"] = date("n");
                if(!$this->session->userdata('access')){
                     $data['editjob'] = false;
                }
		$this->load->view("common/header");
		$this->load->view("admin/mycompletejobs",$data);
		$this->load->view("common/footer");
	}
	function users()
	{
		if($this->session->userdata("role") != 'admin')
		{
			redirect("admin/error?e=permissions");
		}
		
		$data = array();
		$data['email_sort']='desc';
                $data['firstname_sort']='asc';
                $data['lastname_sort']='desc';
                $data['empno_sort']='desc';
                $data['role_sort']='desc';
                $sortorder = "asc";
                $sort_column = "users.last_name";
                if($this->input->get("q")=="email"  ){
                  $sort_column = "users.email";
                  $sortorder = $this->input->get("email_sort");
                 if($this->input->get("email_sort")=='desc')
                    $data['email_sort']='asc';
                 else
                   $data['email_sort']='desc';
                  
                }else if($this->input->get("q")=="first_name" ){
                    $sort_column = "users.first_name";
                    $sortorder = $this->input->get("firstname_sort");
                    if($this->input->get("firstname_sort")=='asc')
                    $data['firstname_sort']='desc';
                 else
                   $data['firstname_sort']='asc';

                } else if($this->input->get("q")=="last_name" ){
                  $sort_column = "users.last_name";
                  $sortorder = $this->input->get("lastname_sort");
                  if($this->input->get("lastname_sort")=='desc')
                    $data['lastname_sort']='asc';
                 else
                   $data['lastname_sort']='desc';
                } else if($this->input->get("q")=="emp_no"){
                    $sort_column = "users.emp_num";
                    $sortorder = $this->input->get("empno_sort");
                    if($this->input->get("empno_sort")=='desc')
                        $data['empno_sort']='asc';
                    else
                        $data['empno_sort']='desc';
                }
                 else if($this->input->get("q")=="role"){
                    $sort_column = "  CASE type
                                    WHEN 'admin' THEN 1            
                                    WHEN 'conduit' THEN 2
                                    WHEN 'contractor' THEN 3 
                                    WHEN 'installer' THEN 4
                                    WHEN 'sales' THEN 5
                                    END";
                    $sortorder = $this->input->get("role_sort");
                    if($this->input->get("role_sort")=='desc')
                        $data['role_sort']='asc';
                    else
                        $data['role_sort']='desc';
                }
                if ($this->input->get("q")){
                    $data["divshow"] = $this->input->get("q");
                } else {
                   $data["divshow"] = "last_name" ;
                }
		$sql_order = " ORDER BY $sort_column $sortorder";
                $data['users'] = $this->db->query("SELECT users.*, colors.nickname as color, colors.hex,ns.notification FROM users LEFT JOIN colors ON users.color_id=colors.id  LEFT JOIN notification_setting ns ON  users.id = ns.user_id $sql_order")->result_array();
                $this->load->view("common/header");
		        $this->load->view("admin/users",$data);
		        $this->load->view("common/footer");
	}

	function export_pdf($user_id=0)
	{
	 $data = array();	
	 $data["datepicker1_txt"] = $this->input->post("datepicker1_txt");
	 $data["datepicker2_txt"] = $this->input->post("datepicker2_txt");
	 $data["user_id"] = $user_id;
	 $this->load->view("admin/saleuserreport",$data);	
	}
	
	function validate_exportform()
	{
		$this->load->library('validation');	
		$rules['datepicker1_txt'] 		= "required";
		$fields['datepicker1_txt'] 		= "From";
		$rules['datepicker2_txt'] 		= "required";
		$fields['datepicker2_txt'] 		= "To";		
		
            $this->validation->set_rules($rules);
            $this->validation->set_fields($fields);		
		
            if($this->validation->run() == FALSE)
            {
            	$json['success'] = false;
		$json['msg'] = $this->validation->error_string;
		echo json_encode($json);
                return ;
            }else{		
                $json['success'] = true;
                echo json_encode($json);
                }
		
	} 		
	
	function edit_user($user_id='',$updated = false)
	{
		$data = array();
		 $this->load->helper("thumbnail_helper");
		/*if($this->input->get("updated"))
		{
			$data['updated'] = true;
		}*/
		$data['updated'] = $updated;
		if($this->input->post("dosubmit"))
		{
			$this->load->library('validation');

			if($this->input->post("email") != $this->session->userdata("email"))
			{
				$rules['email']	= "required|valid_email|callback_email_exists";
			}
			else
			{
				$rules['email']	= "required|valid_email";
			}

			$rules['first_name']	= "required";
			$rules['last_name']	= "required";
                        $rules['uname']	= "alpha_numeric|callback_uname_exists";
                        $rules['emp_number'] = "numeric|callback_empnumber_exists";
			$this->validation->set_rules($rules);
			$fields['password']	= 'Password';
			$fields['new_password']	= 'New Password';
			$fields['new_password2'] = 'New Password Confirmation';
			$fields['email'] = 'Email Address';
			$fields['first_name'] = 'First Name';
			$fields['last_name'] = 'Last Name';
                        $field['uname'] = "User Name";
                        $field['emp_number'] =  "Employee number";
			$this->validation->set_fields($fields);

			if ($this->validation->run() == FALSE)
			{
				$data['validation_errors'] = true;
			}
			else
			{
                        $row = array();
                        $row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['color_id'] = $this->input->post("color_id");
			$row['type'] = $this->input->post("type");
			$row['uname'] = $this->input->post("uname");
                        $row['email'] = $this->input->post("email");
                        $row['is_editjob'] = $this->input->post("editjob");
			$row['emp_num']= $this->input->post("emp_number");
			$row['custom_hex'] = $this->input->post("custom_hex");
                        $row['plotplanuploaded'] = $this->input->post("plotplanuploaded");
			$row['plotplandownloaded'] = $this->input->post("plotplandownloaded");
            $row['otheruploaddown']= $this->input->post("otheruploaddown");
            $row['user_status']=$this->input->post('user_status');
			if ($this->input->post("installer_permissions") == 'y') {
				$row['installer_permissions'] = 'y';
			} else {
				$row['installer_permissions'] = 'n';
			}
			if($this->input->post("password"))
			{
				$row['password'] = md5($this->input->post("password"));
			}
			if(is_array($this->input->post('role_extra'))){
	    		$row['role_extra'] = implode(",",$this->input->post("role_extra"));
			}
			$this->db->where("id",$user_id);
			$this->db->update("users",$row);
			
			// update session data
			if($user_id == $this->session->userdata("user_id"))
			{
				$sql = "SELECT colors.* FROM colors WHERE id=".$this->db->escape($this->input->post("color_id"));
				$color = $this->db->query($sql)->row_array();
				
				if(@$row['custom_hex'] != '')
				{
					$hex = $row['custom_hex'];
				}
				else
				{
					if(@$row['type'] == 'admin')
					{			
						$hex = '7DBB4C';
					}
					else
					{
						$hex = $color['hex'];
					}
				}
				
				$this->session->set_userdata('role', $row['type']);
				$this->session->set_userdata('hex_color', $hex);
			}
			
			redirect("admin/edit_user/".$user_id."/true");
                        }
		}
		
		$data['user'] = $this->db->query("SELECT users.*, colors.nickname as color, colors.hex FROM users LEFT JOIN colors ON users.color_id=colors.id WHERE users.id=".$this->db->escape($user_id)." ORDER BY users.last_name ASC")->row_array();
                
		$data['roles'] = array();
		$data['roles']['admin'] = 'Admin';
		$data['roles']['sales'] = 'Salesperson';
		$data['roles']['installer'] = 'Installer';
        $data['roles']['contractor'] = 'Contractor';
        $data['roles']['designer'] = 'Designer';
        $data['roles']['engineer'] = 'Engineer II';
        $data['roles']['engineer1'] = 'Engineer  I';


        if($this->session->userdata('superadmin')){ 
			$data['roles']['superadmin'] = 'SuperAdmin';
			$data['roles']['warehouse'] = 'Warehouse';
		}
		//$data['roles']['conduit'] = 'Conduit';
		$data['colors'] = $this->db->get("colors")->result_array();

		$this->load->view("common/header");
		$this->load->view("admin/edit_user",$data);
		$this->load->view("common/footer");
	}
	
	function new_user()
	{
		$data = array();
		
		if($this->input->post("dosubmit"))
		{
			$this->load->library('validation');
			
			if($this->input->post("email") != $this->session->userdata("email")) 
			{
				$rules['email']	= "required|valid_email|callback_email_exists";
			} 
			else 
			{
				$rules['email']	= "required|valid_email";
			}

			$rules['first_name']	= "required";
			$rules['last_name']	= "required";
                        $rules['uname']	= "alpha_numeric|callback_uname_exists";
                        $rules['emp_number'] = "numeric|callback_empnumber_exists";
			$this->validation->set_rules($rules);
			$fields['password']	= 'Password';
			$fields['new_password']	= 'New Password';
			$fields['new_password2'] = 'New Password Confirmation';
			$fields['email'] = 'Email Address';
			$fields['first_name'] = 'First Name';
                        $field['uname'] = "User Name";

			$this->validation->set_fields($fields);

			if ($this->validation->run() == FALSE)
			{
				$data['validation_errors'] = true;
			}
			else
			{

                        $row = array();
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['uname'] = $this->input->post("uname");
                        $row['color_id'] = $this->input->post("color_id");
			$row['type'] = $this->input->post("type");
			$row['email'] = $this->input->post("email");
                        $row['is_editjob'] = $this->input->post("editjob");
			$row['custom_hex'] = $this->input->post("custom_hex");
                        $row['emp_num']= $this->input->post("emp_number");
                        $row['plotplanuploaded'] = $this->input->post("plotplanuploaded");
			$row['plotplandownloaded'] = $this->input->post("plotplandownloaded");
                        $row['otheruploaddown']= $this->input->post("otheruploaddown");
                       	if($this->input->post("password"))
			{
				$row['password'] = md5($this->input->post("password"));
			}

			$this->db->insert("users",$row);
			redirect("admin/users");
                        }
		}

		$data['roles'] = array();
		$data['roles']['admin'] = 'Admin';
		$data['roles']['sales'] = 'Salesperson';
		$data['roles']['installer'] = 'Installer';
                $data['roles']['contractor'] = 'Contractor';
                $data['roles']['designer'] = 'Designer';
                $data['roles']['engineer'] = 'Engineer II';
                $data['roles']['engineer1'] = 'Engineer I';
                $data['roles']['superadmin'] = 'SuperAdmin';
				 $data['roles']['warehouse'] = 'WareHouse';
		//$data['roles']['conduit '] = 'Conduit ';
		$data['colors'] = $this->db->get("colors")->result_array();
         if(is_array($this->input->post('role_extra'))) {
		  $row['role_extra'] = implode(",",$this->input->post("role_extra"));
		 }
		$this->load->view("common/header");
		$this->load->view("admin/new_user",$data);
		$this->load->view("common/footer");
	}
	
	function delete_user($user_id)
	{
		if($this->session->userdata("role") == 'admin')
		{
			$this->db->where("id",$user_id);
			$this->db->delete("users");
                        $this->db->where("modified_by",$user_id);
                        $row = array();
                        $row['modified_by']=$this->session->userdata("user_id") ;
			$this->db->update("jobs",$row);
                        $this->db->where("user_id",$user_id);
                        $row = array();
                        $row['user_id']=$this->session->userdata("user_id") ;
			$this->db->update("jobs",$row);
			redirect("admin/users");

		}
		else
		{
			redirect("admin/error?e=permissions");
		}
	}
	function delete_customer($cust_id)
	{
		if($this->session->userdata("role") == 'admin')
		{
			$this->db->where("id",$cust_id);
			$this->db->delete("customers");
			/* Create activity log after deletion of customer */
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Delete", "customers", '', $this->session->userdata("user_id"), $cust_id);	
			
				
                        $this->db->where("customer_id",$cust_id);
			$this->db->delete("jobs");
			
			/* Create activity log after deletion of jobs */
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Delete", "jobs", '', $this->session->userdata("user_id"), $cust_id);
 			
			
			redirect("admin/jobschedule");
		}
		else
		{
			redirect("admin/error?e=permissions");
		}
	}
	function password_check($password)
	{
		$row = $this->db->query("SELECT * FROM users WHERE password=".($this->db->escape(md5($this->input->post("password"))))." AND email=".$this->db->escape($this->input->post("email")))->row_array();
		
		if (count($row) == 0)
		{
			$this->validation->set_message('password_check', 'Current password is incorrect');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function email_exists($email)
	{
		$sql_user = "";
                if ($this->input->post("user_id")){
                    $sql_user = " AND id !=".$this->input->post("user_id");
                }
                $row = $this->db->query("SELECT * FROM users WHERE email=".$this->db->escape($this->input->post("email"))."$sql_user")->row_array();
		if (count($row) > 0)
		{
			$this->validation->set_message('email_exists', 'That email address already exists');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	function uname_exists($email)
	{
		$sql_user = "";
                if ($this->input->post("user_id")){
                    $sql_user = " AND id !=".$this->input->post("user_id");
                }
                $row = $this->db->query("SELECT * FROM users WHERE id !=".$this->db->escape($this->session->userdata("user_id"))." AND  uname=".$this->db->escape($this->input->post("uname"))."$sql_user")->row_array();
		if (count($row) > 0)
		{
			$this->validation->set_message('uname_exists', 'That UserName already exists.');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
        function empnumber_exists($empno){
               $sql_user = "";
                if ($this->input->post("user_id")){
                    $sql_user = " AND id !=".$this->input->post("user_id");
                }
                if(!$this->input->post("emp_number")){
                    return true;
                }
                $row = $this->db->query("SELECT * FROM users WHERE id !=".$this->db->escape($this->session->userdata("user_id"))." AND  emp_num=".$this->db->escape($this->input->post("emp_number"))." $sql_user")->row_array();
		if (count($row) > 0)
		{
			$this->validation->set_message('empnumber_exists', 'That Employee Number is  already exists.');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
        }
	function download($file_id='')
	{
		$this->load->helper('download');
		
		$this->db->where('id',$file_id);
		$file = $this->db->get("files")->row_array();
		
		$data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename']); // Read the file's contents
		$name = $file['original_filename'];

		force_download($name, $data);
	}
        function downloadplan($file_id='')
	{
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("genral_files")->row_array();
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
        function downloadsketch($file_id='')
	{
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("sketch_files")->row_array();
            echo $_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename'];
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
        function downloadpredesignsketch($file_id='')
	{
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("predesignsketch_files")->row_array();
            echo $_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename'];
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
        function downloadpresale($file_id='')
	{
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("presale_files")->row_array();
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
        function downloadfiletab($file_id='')
	{
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("meter_files")->row_array();
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/scheduler/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
        function downloadpermit($file_id=''){
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("permit_files")->row_array();
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
        function downloadelecphoto($file_id='')
	{
            $this->load->helper('download');
            $this->db->where('id',$file_id);
            $file = $this->db->get("elecphoto_files")->row_array();
            $data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/scheduler/uploads/".$file['unique_filename']); // Read the file's contents
            $name = $file['original_filename'];
            force_download($name, $data);
	}
         function viewelecphotofile($file_id='')
	{
             $this->load->helper("thumbnail_helper");
            $this->db->where('id',$file_id);
            $file = $this->db->get("elecphoto_files")->row_array();
            $src_pth = $file['unique_filename'];
            echo '<img src="'.thumbnail($src_pth, 250, 250).'"/>';
            
	}
	function config()
	{
		if($this->session->userdata("role") == 'sales' ){
		    $this->load->view("common/header");
		 	$this->load->view("admin/config_saleuser");
			$this->load->view("common/footer");
			return;
        }
		if($this->session->userdata("role") != 'admin')
		{
			redirect("admin/error?e=permissions");
		}
		$data = array();
		$data['tables'] = array();
		$data['tables']['fan_brands'] = array('fkey' => 'brand');
		$data['tables']['fan_sizes'] = array('fkey' => 'size');
		$data['tables']['installation_types'] = array('fkey' => 'type');
		//$data['tables']['inverter_brands'] = array('fkey' => 'brand');
		//$data['tables']['inverter_types'] = array('fkey' => 'type');
		//$data['tables']['module_brands'] = array('fkey' => 'brand');
		//$data['tables']['module_powers'] = array('fkey' => 'power');
		$data['tables']['panel_sizes'] = array('fkey' => 'size');
		$data['tables']['panel_types'] = array('fkey' => 'type');
		$data['tables']['piperun_types'] = array('fkey' => 'type');
		$data['tables']['rafter_types'] = array('fkey' => 'type');
		$data['tables']['referral_types'] = array('fkey' => 'type');
		$data['tables']['roof_types'] = array('fkey' => 'type');
		$data['tables']['service_panel_amperages'] = array('fkey' => 'amperage');
		$data['tables']['tank_brands'] = array('fkey' => 'brand');
		$data['tables']['tank_sizes'] = array('fkey' => 'size');
		$data['tables']['fan_brands'] = array('fkey' => 'brand');
		//$data['tables']['wire_run_types'] = array('fkey' => 'type');
		$data['tables']['household_types'] = array('fkey' => 'type');
		//$data['tables']['contractors'] = array('fkey' => 'contractor');
               // $data['tables']['wire_run_distance'] = array('fkey' => 'type');
		$data['tables']['electric_wire_source'] = array('fkey' => 'source');
		$data['tables']['moniter_display'] = array('fkey' => 'type');
		$data['tables']['electric_wire_type'] = array('fkey' => 'type');
		$data['tables']['service_panel_upgrade'] = array('fkey' => 'type');
                //$data['tables']['pipe_run_distance'] = array('fkey' => 'type');
                $data['tables']['panel_numbers'] = array('fkey' => 'type');
		foreach($data['tables'] as $key => $value)
		{
			$this->db->order_by($value['fkey'],'asc');
			$data['tables'][$key]['rows'] = $this->db->get($key)->result_array();
		}
		
		$row = $this->db->get("job_limit")->row_array();
		$data['daily_limit'] = $row['limit'];
		
		for($i=0; $i<20; $i++)
		{
			$data['daily_limits'][$i] = $i;
		}
		
		if($this->input->post("dosubmit"))
		{
			foreach($data['tables'] as $key => $value)
			{
				// explode textbox values into array
				$options = array();
				$options = explode("\n", $this->input->post($key));
				// remove empty options (in case there were additional line breaks)
				foreach($options as $k => $o) 
				{
					if(trim($o) == '')
					{
						unset($options[$k]);
					}
				}
				#die(print_r($options));
				if(count($options) > 0)
				{
					foreach($options as $option)
					{						
						$matched_rows = array();
						$sql = "SELECT * FROM $key WHERE UPPER(".$value['fkey'].") = ".$this->db->escape(strtoupper($option));
						$matched_rows = $this->db->query($sql)->result_array();
						
						// look for new values
						$new = array();
						if(count($matched_rows) == 0)
						{
							$new[$value['fkey']] = $option;
							$this->db->insert($key,$new);
						}
						
						// delete old values
						$existing_rows = array();
						$existing_rows = $this->db->get($key)->result_array();
						foreach($existing_rows as $row)
						{
							if(!in_array($row[$value['fkey']],$options))
							{
								$sql = "DELETE FROM $key WHERE id = ".$this->db->escape($row['id']);
								$this->db->query($sql);
							}
						}
					}
				}
			}
			
			redirect("admin/config");
		}
		  $sql  = "SELECT notification from notification_setting WHERE id=1";
                  $nresult =  $this->db->query($sql)->result_array();
                  if(!$nresult[0]['notification'] ) {
                      $data['notification']=0  ;
                  } else {
                      $data['notification']=1;
                  }
		$this->load->view("common/header");
		if($this->session->userdata("role") == 'admin' && $this->session->userdata('superadmin')){
			$this->load->view("admin/config",$data);
		} else if($this->session->userdata("role") == 'admin'){
			$this->load->view("admin/config_admin",$data);
		 } else {
		   $this->load->view("admin/config_sale",$data);
		 }
		
		$this->load->view("common/footer");
	}
	
	function delete_file($file_id='')
	{
		$this->db->where('id',$file_id);
		$file = $this->db->get("files")->row_array();
		
		$this->db->where("id",$file_id);
		$this->db->delete('files');
		
		redirect("admin/job/".$file['job_id']);
	}
        function delete_planfile($file_id='',$file_type="no")
	{
		

		/* get record for Final PV Design Plot Plan file */
		$this->db->where("id",$file_id);
		$this->db->order_by("created","desc");
		$plan_files = $this->db->get("genral_files")->result_array();
		@$plan_file_id = ($plan_files[0]['id']);		
		/* Create activity log before deletion for Final PV Design Plot Plan before deletion*/
		if(isset($plan_file_id) && $plan_file_id > 0 && $file_type=="no")
		{
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Delete", "genral_files", $plan_files[0]['job_id'], $this->session->userdata("user_id"));			
			
		}		
		
		$this->db->where('id',$file_id);
                if($file_type=="no"){
		 $file = $this->db->get("genral_files")->row_array();
                } else{
                    $file = $this->db->get("meter_files")->row_array();
                }
		$this->db->where("id",$file_id);
		if($file_type=="no"){
                $this->db->delete('genral_files');
                } else {
                 $this->db->delete('meter_files');
                }
		redirect("admin/job/".$file['job_id']);
	}
        function delete_sketchfile($file_id='',$file_type="no")
	{
		
		$this->db->where("id",$file_id);
		$this->db->order_by("created","desc");
		$salessketck_files = $this->db->get("sketch_files")->result_array();
		@$salessketck_file_id = ($salessketck_files[0]['id']);		
		
		/* Create activity log before deletion for Sales Sketch file before deletion*/
		if(isset($salessketck_file_id) && $salessketck_file_id > 0 && $file_type=="no")
		{
			
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Delete", "sketch_files", $salessketck_files[0]['job_id'], $this->session->userdata("user_id"));
		}		
		
		$this->db->where('id',$file_id);
                if($file_type=="no"){
		 $file = $this->db->get("sketch_files")->row_array();
                } else{
                    $file = $this->db->get("meter_files")->row_array();
                }
		$this->db->where("id",$file_id);
		if($file_type=="no"){
                $this->db->delete('sketch_files');
                } else {
                 $this->db->delete('meter_files');
                }
		redirect("admin/job/".$file['job_id']);
	}
       
       function delete_predesignsketchfile($file_id='',$file_type="no")
	{
		@$pid=$this->input->get("pid");	 //get job id
		$this->load->library("activitylog");
		if(isset($pid) && $pid > 0)
		{
			/* get record for Pre-Measure file */		
			$this->db->where("job_id",$pid);
			$this->db->order_by("created","desc");
			$presale_files = $this->db->get("presale_files")->result_array();
			@$presale_file_id = $presale_files[0]['id'];

			/* get record for Final PV Design Plot Plan file */
			$this->db->where("job_id",$pid);
			$this->db->order_by("created","desc");
			$plan_files = $this->db->get("genral_files")->result_array();
			@$plan_file_id = ($plan_files[0]['id']); 		
		
			/* Create activity log before deletion for presales before deletion*/
			if(isset($presale_file_id) && $presale_file_id > 0)
			{
				//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
				$this->activitylog->createlog("Delete", "presale_files", $pid, $this->session->userdata("user_id"));
				
				$this->db->where('id',$presale_file_id);
				$this->db->delete('presale_files');
			}
			
			/* Create activity log before deletion for Final PV Design Plot Plan before deletion*/
			if(isset($plan_file_id) && $plan_file_id > 0)
			{
				//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
				$this->activitylog->createlog("Delete", "genral_files", $pid, $this->session->userdata("user_id"));
				
				$this->db->where('id',$plan_file_id);
				$this->db->delete('genral_files');
			}			
		}
		

		/* get record for  Pre-Design Sketch file */		
		$this->db->where("id",$file_id);
		$this->db->order_by("created","desc");
		$predesign_files = $this->db->get("predesignsketch_files")->result_array();
		
		/* Create activity log before deletion for Pre-Design Sketch before deletion*/
		
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Delete", "predesignsketch_files", $predesign_files[0]['job_id'], $this->session->userdata("user_id"));		
		
		$this->db->where('id',$file_id);
                $file = $this->db->get("predesignsketch_files")->row_array();
		$this->db->where("id",$file_id);
		$this->db->delete('predesignsketch_files');
		redirect("admin/job/".$file['job_id']);
	}
         function delete_elecphotofile($file_id='')
	{
		$this->db->where('id',$file_id);
                $file = $this->db->get("elecphoto_files")->row_array();
		$this->db->where("id",$file_id);
		$this->db->delete('elecphoto_files');
                redirect("admin/job/".$file['job_id']);
	}
         function delete_presalefile($file_id='',$file_type="no")
	{
		@$pid=$this->input->get("pid");	 //get job id
		/* get record for Final PV Design Plot Plan file */
		$this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$plan_files = $this->db->get("genral_files")->result_array();
		@$plan_file_id = ($plan_files[0]['id']); 		
		
		/* Create activity log before deletion for Final PV Design Plot Plan before deletion*/
		if(isset($plan_file_id) && $plan_file_id > 0)
		{
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Delete", "genral_files", $pid, $this->session->userdata("user_id"));			

			$this->db->where('id',$plan_file_id);
			$this->db->delete('genral_files');
		}			
		
		
		/* get record for Pre-Measure file */		
		$this->db->where("job_id",$pid);
		$this->db->order_by("created","desc");
		$presale_files = $this->db->get("presale_files")->result_array();
		@$presale_file_id = $presale_files[0]['id'];
		/* Create activity log before deletion for presales before deletion*/
		if(isset($presale_file_id) && $presale_file_id > 0 & $file_type=="no")
		{
			
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Delete", "presale_files", $pid, $this->session->userdata("user_id"));

		}		
		
		
		$this->db->where('id',$file_id);
                if($file_type=="no"){
		 $file = $this->db->get("presale_files")->row_array();
                } else{
                    $file = $this->db->get("meter_files")->row_array();
                }
		$this->db->where("id",$file_id);
		if($file_type=="no"){
                $this->db->delete('presale_files');
                } else {
                 $this->db->delete('meter_files');
                }
		redirect("admin/job/".$file['job_id']);
	}
         function delete_permitfile($file_id='',$jobid=1)
	{
		$this->db->where('id',$file_id);
                $this->db->delete('permit_files');
                redirect("admin/permit_job/".$jobid."?msg=file_del");
	}
  function    installer_available($year='', $month='', $uid=0)
	{
                global $sc_job_count;
                global $pv_job_count;
                global $swh_job_count;
                global $pm_pl;
                global $pl_pv;
                global $digital_pm_pv;
                global $hoa_setting;
				 global $el_job_count;
				 global $saf_job_count;
                global $ev_job_count;
		$year = (int)$year;
		$month = (int) $month;
                if(!$uid){
                   $uid = $this->session->userdata("user_id");
                }
                $this->load->library("job");
		$this->load->helper("date");
		$data = array();
		$prefs = array (
			'start_day'    => 'sunday',
			'month_type'   => 'long',
			'day_type'     => 'long'
		);

		$jobs = array();
                $day_selected = array();
		if($year=='') {$year = date("Y");}
		if($month=='') {$month = date("m");}
		  //$year = preg_replace("/[^0-9]/","",$year);
		 // $month = preg_replace("/[^0-9]/","",$month);
		$data['year'] = $year;
		$data['month'] = $month;
                $data["uuid"] = $uid;
		// daily job limit
		$daily_limit = $this->db->get("job_limit")->row_array();
		$daily_limit = $daily_limit['limit'];

		// create calendar and year dd values and set which should be preselected
		$data['calendar_months'] = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
		$data['calendar_years'] = array();
		for($i=date("Y",strtotime("-2 years")); $i<date("Y",strtotime("+2 years")); $i++)
		{
			$data['calendar_years'][$i] = $i;
		}
		$data['calendar_month'] = $data['month'];
		$data['calendar_year'] = $data['year'];
                $noofday = 1; // split the job
		// get jobs for the current month
		//"SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%c') = '".$year."-".$month."' AND jobs.user_id='".$uid."' ORDER BY jobs.job_date ASC";
                $j_filter = " AND jobs.job_type_id!=6";
                $j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE  jobs.job_type_id!=7  AND  jobs.job_type_id!=6 AND DATE_FORMAT(jobs.job_date,'%Y-%c') = '".$year."-".$month."'  $j_filter  ORDER BY jobs.job_date ASC")->result_array();

             //print_R($j);
	
    foreach($j as $key => $value)
		{
			$jobs[date("j", strtotime($value['job_date']))][] = $value;
		}
		$days_count = days_in_month($month,$year);

                $session_installer_data = array();
                //print_R($this->session);
                //die;
		if ($this->session->userdata("re_user_id") ) {
                    
                    $session_installer = $this->db->query("SELECT *  FROM  session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")."")->result_array();
                    foreach($session_installer as $key => $value)
                        {
			$session_installer_data[date("j", strtotime($value['date_booked']))][] = $value;
                	}
                         $data['pl_selected_date']=array();
                         $session_installer_PL = $this->db->query("SELECT *  FROM  pl_session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")."")->row_array();
                         if(isset($session_installer_PL['date_booked'])){
                         $data['pl_selected_date'][] =  array("bookeddate"=>$session_installer_PL['date_booked'], "sessionid" => $session_installer_PL['id'] ,"number_of_installer" =>$session_installer_PL['number_of_installer']); 
                         }
     
                         $session_installer_PM = $this->db->query("SELECT *  FROM  pm_session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")."")->row_array();
                         $data['pm_selected_date']=array();
                         if (isset($session_installer_PM['date_booked']))
                         $data['pm_selected_date'][] =  array("bookeddate"=>$session_installer_PM['date_booked'], "sessionid" => $session_installer_PM['id'] ,"number_of_installer" =>$session_installer_PM['number_of_installer']); 
                         $session_installer_PV = $this->db->query("SELECT *  FROM  session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")."")->result_array();
                         $data['pv_selected_date']=array();
                         foreach($session_installer_PV as $session_pv_data) {
                           $data['pv_selected_date'][] =  array("bookeddate"=>$session_pv_data['date_booked'], "sessionid" => $session_pv_data['id'] ,"number_of_installer" =>$session_pv_data['number_of_installer']);                 
                         }
                }
                if($this->session->userdata("job_pid")&& !$this->session->userdata("pm_reschedule") && !$this->session->userdata("pl_reschedule")){
                   $exist_pm_data = $this->db->query("SELECT job_date FROM  jobs where job_type_id=7 AND job_pid=".$this->session->userdata("job_pid"))->row_array();
                   $exist_pl_data = $this->db->query("SELECT job_date FROM  jobs where job_type_id=6 AND job_pid=".$this->session->userdata("job_pid"))->row_array();
                 }
		$adminblock_date = array();
		$inverter_types = $this->db->query("SELECT * FROM admin_block_date WHERE   DATE_FORMAT(block_date,'%Y-%c') = '".$year."-".$month."' ")->result_array();
		foreach($inverter_types as $row => $value){
                     $adminblock_date[date("j",strtotime($value['block_date']))] = $value['message'];
		}
                $job_setting = array();
		$day_jobcount = $this->db->query("SELECT * FROM day_job_setting WHERE   DATE_FORMAT(job_date,'%Y-%c') = '".$year."-".$month."' ")->result_array();
		foreach($day_jobcount as $row => $value){
                    if($this->session->userdata('job_type')==2)
                       $job_setting[date("j",strtotime($value['job_date']))] = $value['pv'];
                    if($this->session->userdata('job_type')==5)
                       $job_setting[date("j",strtotime($value['job_date']))] = $value['sc'];
					if($this->session->userdata('job_type')==8)
                       $job_setting[date("j",strtotime($value['job_date']))] = $value['el'];                       
                    if($this->session->userdata('job_type')==1)
                       $job_setting[date("j",strtotime($value['job_date']))] = $value['swh'];
					if($this->session->userdata('job_type')==21)
                       $job_setting[date("j",strtotime($value['job_date']))] = $value['saf'];
                    if($this->session->userdata('job_type')==20)
                       $job_setting[date("j",strtotime($value['job_date']))] = $value['ev'];
		}
               
                #die(print(count($service_calls)));
                  $admineditinstaller_date = array();
		$editinstaller = $this->db->query("SELECT * FROM installer_manual WHERE   DATE_FORMAT(day,'%Y-%c') = '".$year."-".$month."' ")->result_array();
		foreach($editinstaller as $row => $value){
                     $admineditinstaller_date[date("j",strtotime($value['day']))] = $value["installer"];
		}
                #die(print(count($service_calls)));
                $number_installer = NUMBEROFINSTALLER;


                
		for($i=0; $i<($days_count+1); $i++)
		{
                    $pv_job_daycount=0;
                    $swh_job_daycount=0;
                    $sc_job_daycount=0;
        			 $el_job_daycount=0;
					  $ev_job_daycount=0;
                    $saf_job_daycount=0;
                    $number_installer = NUMBEROFINSTALLER;
                    if(array_key_exists($i,$admineditinstaller_date)){
                        $number_installer = $admineditinstaller_date[$i];
                     }
                     $day_diff=$pl_pv;
                     $cmp_diff=$pl_pv;
                    if (@$this->session->userdata('assigned_pl_installer')==1 && @$this->session->userdata('assigned_pm_installer')==1){
                       $day_diff = (strtotime("$year-$month-$i")-strtotime($session_installer_PL["date_booked"]))/(60*60*24);
                       $cmp_diff=$pl_pv;
                    }else if($this->session->userdata('assigned_pm_installer') ){
                        $day_diff = (strtotime("$year-$month-$i")-strtotime($session_installer_PM["date_booked"]))/(60*60*24);
                        $cmp_diff=$pm_pl;
                        if ($this->session->userdata("home_owner_assoc")=='2') {
                               $cmp_diff=$hoa_setting;
                        }
                        if ($this->session->userdata("meter_type")=='2') {
                               $cmp_diff+=$digital_pm_pv;
                        }
						if ($this->session->userdata("meter_type")=='2' && $this->session->userdata("home_owner_assoc")=='2') {
                               $cmp_diff=$digital_pm_pv+$hoa_setting;
                        }
                       
                        if($day_diff>=1 && $this->session->userdata("pm_reschedule") && !$this->session->userdata("pl_reschedule")){
                             $exist_pl_data = $this->db->query("SELECT job_date FROM  jobs where job_type_id=6 AND job_pid=".$this->session->userdata("job_pid"))->row_array();
                             if(isset($exist_pl_data["job_date"])){
                                $day_diff = (strtotime("$year-$month-$i")-strtotime($exist_pl_data["job_date"]))/(60*60*24);
                                if($day_diff>=$pm_pl){
                                    $day_diff=2;
                                }
                             }
                        }
                    }else if(!$this->session->userdata("pm_reschedule") && $this->session->userdata("pl_reschedule") && @$this->session->userdata('assigned_pl_installer')==1 ){
                        $day_diff = (strtotime("$year-$month-$i")-strtotime($session_installer_PL["date_booked"]))/(60*60*24);
                        $cmp_diff=$pl_pv;
                    }else if($this->session->userdata("job_pid")&& !$this->session->userdata("pm_reschedule") && !$this->session->userdata("pl_reschedule")){
                           if(isset($exist_pm_data["job_date"])){
                              $day_diff = (strtotime("$year-$month-$i")-strtotime($exist_pm_data["job_date"]))/(60*60*24); 
                           
                           }
                           if($day_diff >=$pm_pl && isset($exist_pl_data["job_date"])){
                                $day_diff = (strtotime("$year-$month-$i")-strtotime($exist_pl_data["job_date"]))/(60*60*24);
                                if($day_diff>=$pl_pv){
                                    $day_diff=2;
                                }
                           }
                           
                    }
                    
                    if($day_diff<$cmp_diff || ((strtotime("$year-$month-$i")-time())<0 && $this->session->userdata("role")!='admin')){
                        $color = '7d7d7d;';
                        $installer_view=0;
                        $data['dates'][$i]='<div title="Installer Assigned" class="booked-day-wrap tooltip" style="background: #'.$color.'; cursor: pointer;"><div class="job-count">'.$installer_view.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div>';
                    }else   if(array_key_exists($i,$adminblock_date) ){
                        $data['dates'][$i] = '<div style="background:#333333;" class="booked-day-wrap "><div style="margin-right:110px;">'.$i.'</div><div  style="color:white;"><br/><br/>'.$adminblock_date[$i].'</div></div>';
                        
                        
                    } else  if (array_key_exists($i,$session_installer_data) ){
                       $color = $this->getUserColor($this->session->userdata("re_user_id"));
                       $day_selected[] =  array("bookeddate"=>$session_installer_data[$i][0]['date_booked'], "sessionid" => $session_installer_data[$i][0]['id'] ,"number_of_installer" =>$session_installer_data[$i][0]['number_of_installer']);
                       $noofday = $noofday+1;
                       if(array_key_exists($i,$jobs)){
                           $job_installer = 0;
                           foreach(@$jobs[$i] as $tj)
					{
                                        $job_installer = $job_installer + $tj['no_installer_allocated'] ;
					}
                        $installer_view = $number_installer - $job_installer ;
                        $installer_view = $installer_view-$session_installer_data[$i][0]['number_of_installer'];
                       } else {
                            $installer_view = $number_installer-$session_installer_data[$i][0]['number_of_installer'];
                       }
                       if ($installer_view==0){
                            $color = '#7d7d7d;';
                       }
                       $data['dates'][$i]='<div title="Installer Assigned" class="booked-day-wrap tooltip" style="background: #'.$color.'; cursor: pointer;"><div class="job-count">'.$installer_view.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div>
';

                    }
                     else if(array_key_exists($i,$jobs)){

                         $job_installer = 0;
                           foreach(@$jobs[$i] as $tj)
                            {   
                                if($tj['job_type_id']==2){
                                    $pv_job_daycount++;
                                }
                                if($tj['job_type_id']==1){
                                    $swh_job_daycount++;
                                }
                                if($tj['job_type_id']==5){
                                  $sc_job_daycount++;
                                }
								 if($tj['job_type_id']==8){
                                  $el_job_daycount++;
                                } 

								if($tj['job_type_id']==20){
                                  $ev_job_daycount++;
                                } 
                                if($tj['job_type_id']==21){
                                  $saf_job_daycount++;
                                } 
                                $job_installer = $job_installer + $tj['no_installer_allocated'] ;
                            }
                        $installer_view = $number_installer - $job_installer ;
                        //$installer_view = $number_installer - $jobs[$i][0]['no_installer_allocated'] ;
                        $color1 = '#59912c;';
                        if ($installer_view==0){
                            $color1 = '#7d7d7d;';
                       }
                        if ($installer_view>=0 || $installer_view<0 ) {
                            $swh_count_check=false;
                            $pv_count_check=false;
                            $sc_count_check = false;
							 $el_count_check = false;
                            if(array_key_exists($i,$job_setting) ){
                                
                                if($this->session->userdata('job_type')==1 &&  $swh_job_daycount>=$job_setting[$i]){
                                    $swh_count_check=true;
                                }
                                
                                if($this->session->userdata('job_type')==2 &&  $pv_job_daycount>=$job_setting[$i]){
                                    $pv_count_check=true;
                                    
                                }
                                if($this->session->userdata('job_type')==5 &&  $sc_job_daycount>=$job_setting[$i]){
                                    $sc_count_check=true;
                                }
								 if($this->session->userdata('job_type')==8 &&  $el_job_daycount>=$job_setting[$i]){
                                    $el_count_check=true;
                                }  
                                
                            } else if($this->session->userdata('job_type')==1 &&  $swh_job_daycount>=$swh_job_count){
                                 $swh_count_check=true;
                            }
                            else if($this->session->userdata('job_type')==2 &&  $pv_job_daycount>=$pv_job_count){
                                 $pv_count_check=true;
                            }else if($this->session->userdata('job_type')==5 &&  $sc_job_daycount>=$sc_job_count){
                                 $sc_count_check=true;
                            }else if($this->session->userdata('job_type')==8 &&  $el_job_daycount>=$el_job_count){
                                 $el_count_check=true;
                            }else if($this->session->userdata('job_type')==20 &&  $saf_job_daycount>=$saf_job_count){
                                 $saf_count_check=true;
                            }else if($this->session->userdata('job_type')==21 &&  $ev_job_daycount>=$ev_job_count){
                                 $ev_count_check=true;
                            }
                            if($installer_view<0 || $pv_count_check  || $swh_count_check || $sc_count_check || $el_count_check || $ev_count_check || $saf_count_check ){$installer_view=0;$color1 = '#7d7d7d;';}
                                $data['dates'][$i]='<a class="facebox day-view-url" href="'.base_url().'ajax/day_installerassign/'.$year.'/'.$month.'/'.$i.'/'.$installer_view.'/'.$noofday.'"><div title="Available Installer" class="booked-day-wrap tooltip" style="background: '.$color1.' cursor: pointer;"><div class="job-count">'.$installer_view.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div>
</a>';                      } else {
                          /*      $data['dates'][$i]='<div title="Go To Day View" class="booked-day-wrap tooltip" style="background: none repeat scroll 0% 0% rgb(152, 26, 54); cursor: pointer;"><a class="day-view-url" href="/admin/day/2011/08/2">
</a><div class="job-count"><a class="day-view-url" href="/admin/day/2011/08/2">2</a></div></div><div class="booked-day"><span style="color:#fff;">2</span></div>';
*/

                        }
                    } else{
                             $swh_count_check=false;
                            $pv_count_check=false;
                            $sc_count_check = false;
							$el_count_check = false;
							 $ev_count_check=false;
                            $saf_count_check=false; 
                             if(array_key_exists($i,$job_setting) ){
                                if($this->session->userdata('job_type')==1 && !$job_setting[$i]){
                                    $swh_count_check=true;
                                }

                                if($this->session->userdata('job_type')==2 &&  !$job_setting[$i]){
                                    $pv_count_check=true;

                                }
                                if($this->session->userdata('job_type')==5 &&  !$job_setting[$i]){
                                    $sc_count_check=true;
                                }
								if($this->session->userdata('job_type')==8 &&  !$job_setting[$i]){
                                    $el_count_check=true;
                                } 
								if($this->session->userdata('job_type')==20 &&  !$job_setting[$i]){
                                    $ev_count_check=true;
                                }
								if($this->session->userdata('job_type')==21 &&  !$job_setting[$i]){
                                    $saf_count_check=true;
                                } 
                            }
                            if( $pv_count_check  || $swh_count_check || $sc_count_check || $el_count_check || $ev_count_check ||$saf_count_check ){$installer_view=0;$color1 = '#7d7d7d;';
                           $data['dates'][$i]='<a class="facebox day-view-url" href="'.base_url().'ajax/day_installerassign/'.$year.'/'.$month.'/'.$i.'/'.$installer_view.'/'.$noofday.'"><div title="Available Installer" class="booked-day-wrap tooltip" style="background: '.$color1.' cursor: pointer;"><div class="job-count">'.$installer_view.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div></a>';
                       } else{
                            $data['dates'][$i]='<a class="facebox day-view-url" href="'.base_url().'ajax/day_installerassign/'.$year.'/'.$month.'/'.$i.'/'.$number_installer.'/'.$noofday.'"><div title="Available Installer" class="booked-day-wrap tooltip" style="background:#59912c; cursor: pointer;"><div class="job-count">'.$number_installer.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div></a>
'; }
                    }

		}
		$prefs['template'] = ' {table_open}<table class="calendar" border="0" cellpadding="0" cellspacing="1">{/table_open}

		   {heading_row_start}<tr>{/heading_row_start}

		   {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
		   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
		   {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}

		   {heading_row_end}</tr>{/heading_row_end}

		   {week_row_start}<tr class="week-days">{/week_row_start}
		   {week_day_cell}<td style=background-color:#7d7d7d; border:1px solid #7d7d7d;"><div align="left" style="color:#fff;">{week_day}</div></td>{/week_day_cell}
		   {week_row_end}</tr>{/week_row_end}

		   {cal_row_start}<tr>{/cal_row_start}
		   {cal_cell_start}<td>{/cal_cell_start}
                        {cal_cell_content}
		    <div class="cell-inner-big">
			{content}
			</div>
			{/cal_cell_content}
			{cal_cell_content_today}
			<div class="cell-inner-big">
                        {content}
			</div>
			{/cal_cell_content_today}
			{cal_cell_no_content}
			<div class="cell-inner-big">
			<div class="reserve-job-block">';
       
				$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content}
			{cal_cell_no_content_today}
			<div class="cell-inner-big">
				<div class="reserve-job-block">';
                        
			$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content_today}

		   {cal_cell_blank}&nbsp;{/cal_cell_blank}

		   {cal_cell_end}</td>{/cal_cell_end}
		   {cal_row_end}</tr>{/cal_row_end}

		   {table_close}</table>{/table_close}
		';
                 if($this->session->userdata("in_noi")){
                    $data['availaible_installer']= $this->session->userdata("in_noi");

                 }else if(count($day_selected)==0){
                    $this->session->set_userdata(array("in_noi"=>1));
                    $data['availaible_installer']= 1;
                 } else{
                     $data['availaible_installer']= $this->session->userdata("in_noi");
                 }
                 if($this->session->userdata("in_nod")){
                    $data['no_day'] = $this->session->userdata("in_nod");
                 }else if(count($day_selected)==0) {
                    $this->session->set_userdata(array("no_day"=>0));
                    $data['no_day']=0;
                 }else{
                     $data['no_day'] = $this->session->userdata("in_nod");
                 }
                $data["selected_date"] = $day_selected;
                $data["current_day"] = $noofday ;
                $data["job_id"] = 0;
                $data["job_type"] =null;
                if($this->session->userdata('job_id')){
                  $data["job_id"] = $this->session->userdata('job_id');
                }
                if($this->session->userdata('job_type')){
                  $data["job_type"] = $this->session->userdata('job_type');
                }
		$this->load->library('calendar',$prefs);
		$this->load->view("common/header");
		$this->load->view("admin/installeravailable",$data);
		$this->load->view("common/footer");
  }
  function getCustomerLastname($id){
      if (!$id) return 0;

      $j = $this->db->query("SELECT last_name FROM customers WHERE id=$id")->result_array();
      foreach($j as $key => $value) {
        if(strlen($value['last_name'])>9)
        $lastname = substr(ucfirst($value['last_name']),0,8).".";
		else
		$lastname = ucfirst($value['last_name']);
      }
      return @$lastname;
  }
  function getCustomerNeighborhood($id){
      if (!$id) return 0;
      $neighborhood="";
      $j = $this->db->query("SELECT neighborhood,other_neighborhood FROM customers WHERE id=$id")->result_array();
      foreach($j as $key => $value) {
        if(isset($value['neighborhood'])){
            if($value['neighborhood']=="other"){
                $neighborhood = ucfirst($value['other_neighborhood']);
            }else{
               if(isset($value['neighborhood']) && $value['neighborhood']!="" && is_numeric($value['neighborhood']) ){
               $sql = "SELECT neighbour from  neigbhour where id=".$value['neighborhood'];
               $row_neighbour = $this->db->query($sql)->row_array();
               $neighborhood = ucfirst($row_neighbour['neighbour']);
               }else{
               $neighborhood = $value['neighborhood'];
               }
            }
        }
      }
      if(strlen($neighborhood)>20){
          $neighborhood = substr($neighborhood,0,10)."..";
      }
      return @$neighborhood;
  }
 function getUserIntial($id,$fullname=false){
      if (!$id) return 0;
      $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
      $intial="";
      foreach($j as $key => $value) {
        $intial = ucfirst($value['first_name'][0]).strtoupper($value['last_name'][0].$value['last_name'][0]);
        if($fullname){
         $intial = ucfirst($value['first_name'])." ".ucfirst($value['last_name']);
        }
      }
      return $intial;
 }
 function getUserEmpNo($id,$fullname=false){
      if (!$id) return 0;
      $j = $this->db->query("SELECT emp_num FROM users WHERE id=$id")->result_array();
      if($j[0]['emp_num']>0){
        return $j[0]['emp_num'];
      }

      return $id;
 }
 function getUserColor($id){
      if (!$id) return 0;
      $j = $this->db->query("SELECT custom_hex,color_id FROM users WHERE id=$id")->result_array();
      foreach($j as $key => $value) {
        $color = $value['custom_hex'];
        $color_id = $value['color_id'];
      }
      if (!$color && $color_id){
        $j = $this->db->query("SELECT hex FROM colors WHERE id=$color_id")->result_array();
      foreach($j as $key => $value) {
        $color = $value['hex'];

      }
      }
      if(!$color) {
          $color = "7dbb4b";
      }
      return $color;
 }


   function    installer_edit($year='', $month='', $uid=0)
	{

		if ($this->session->userdata("role") != 'admin'){
                    return "No Access";
                }
                if($year=='') {$year = date("Y");}
		if($month=='') {$month = date("m");}
                $year = (int)$year;
		$month = (int) $month;
                if(!$uid){
                   $uid = $this->session->userdata("user_id");
                }
                $this->load->library("job");
		$this->load->helper("date");
		$data = array();
		$prefs = array (
			'start_day'    => 'sunday',
			'month_type'   => 'long',
			'day_type'     => 'long'
		);

		$jobs = array();
                $day_selected = array();
		
		  //$year = preg_replace("/[^0-9]/","",$year);
		 // $month = preg_replace("/[^0-9]/","",$month);
		$data['year'] = $year;
		$data['month'] = $month;
                $data["uuid"] = $uid;
		// daily job limit
		$daily_limit = $this->db->get("job_limit")->row_array();
		$daily_limit = $daily_limit['limit'];

		// create calendar and year dd values and set which should be preselected
		$data['calendar_months'] = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
		$data['calendar_years'] = array();
		for($i=date("Y",strtotime("-2 years")); $i<date("Y",strtotime("+2 years")); $i++)
		{
			$data['calendar_years'][$i] = $i;
		}
		$data['calendar_month'] = $data['month'];
		$data['calendar_year'] = $data['year'];
                $noofday = 1; // split the job
		// get jobs for the current month
		//"SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%c') = '".$year."-".$month."' AND jobs.user_id='".$uid."' ORDER BY jobs.job_date ASC";
                $j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE jobs.job_type_id!=6 AND jobs.job_type_id!=7 AND DATE_FORMAT(jobs.job_date,'%Y-%c') = '".$year."-".$month."'  ORDER BY jobs.job_date ASC")->result_array();

                //print_R($j);

    foreach($j as $key => $value)
		{
			$jobs[date("j", strtotime($value['job_date']))][] = $value;
		}
		$days_count = days_in_month($month,$year);
                $adminblock_date = array();
		$inverter_types = $this->db->query("SELECT * FROM admin_block_date WHERE   DATE_FORMAT(block_date,'%Y-%c') = '".$year."-".$month."' ")->result_array();
		foreach($inverter_types as $row => $value){
                     $adminblock_date[date("j",strtotime($value['block_date']))] = $value['message'];
		}

                $admineditinstaller_date = array();
		$editinstaller = $this->db->query("SELECT * FROM installer_manual WHERE   DATE_FORMAT(day,'%Y-%c') = '".$year."-".$month."' ")->result_array();
		foreach($editinstaller as $row => $value){
                     $admineditinstaller_date[date("j",strtotime($value['day']))] = $value["installer"];
		}
                #die(print(count($service_calls)));
                $number_installer = NUMBEROFINSTALLER;
		for($i=0; $i<($days_count+1); $i++)
		{
                     $number_installer = NUMBEROFINSTALLER;
                    if(array_key_exists($i,$admineditinstaller_date)){
                        $number_installer = $admineditinstaller_date[$i];
                     }

                    if(array_key_exists($i,$adminblock_date) ){
                        $data['dates'][$i] = '<a class="facebox day-view-url" href="'.base_url().'ajax/unblock_day_form/'.$year.'/'.$month.'/'.$i.'" title="Unblock Day" ><div style="background:#333333;" class="booked-day-wrap "><div style="margin-right:110px;">'.$i.'</div><div  style="color:white;"><br/><br/>'.$adminblock_date[$i].'</div></div></a>';


                    } 
                     else if(array_key_exists($i,$jobs)){
                         $job_installer = 0;
                           foreach(@$jobs[$i] as $tj)
                            {
                                $job_installer = $job_installer + $tj['no_installer_allocated'] ;
                            }
                           $installer_view = $number_installer - $job_installer ;
                        //$installer_view = $number_installer - $jobs[$i][0]['no_installer_allocated'] ;

                        if ($installer_view>0) {
                                        $data['dates'][$i]='<a class="facebox day-view-url" href="'.base_url().'ajax/day_installeredit/'.$year.'/'.$month.'/'.$i.'/'.$installer_view.'/'.$job_installer.'"><div title="Available Installer" class="booked-day-wrap tooltip" style="background: #59912c; cursor: pointer;"><div class="job-count">'.$installer_view.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div>
</a>';                      } else if ($installer_view==0 || $installer_view<=0) {
                                if( $installer_view<0) $installer_view=0;
                                $data['dates'][$i]='<a class="facebox day-view-url" href="'.base_url().'ajax/day_installeredit/'.$year.'/'.$month.'/'.$i.'/'.$installer_view.'/'.$job_installer.'"><div title="Available Installer" class="booked-day-wrap tooltip" style="background: #7d7d7d; cursor: pointer;"><div class="job-count">'.$installer_view.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div></a>';
    /*      $data['dates'][$i]='<div title="Go To Day View" class="booked-day-wrap tooltip" style="background: none repeat scroll 0% 0% rgb(152, 26, 54); cursor: pointer;"><a class="day-view-url" href="/admin/day/2011/08/2">
</a><div class="job-count"><a class="day-view-url" href="/admin/day/2011/08/2">2</a></div></div><div class="booked-day"><span style="color:#fff;">2</span></div>';
*/

                        }
                    } else{
                            $data['dates'][$i]='<a class="facebox day-view-url" href="'.base_url().'ajax/day_installeredit/'.$year.'/'.$month.'/'.$i.'/'.$number_installer.'/0"><div title="Available Installer" class="booked-day-wrap tooltip" style="background:#59912c; cursor: pointer;"><div class="job-count">'.$number_installer.'</div></div><div class="booked-day"><span style="color:#fff;">'.$i.'</span></div></a>
';
                    }

		}
		$prefs['template'] = ' {table_open}<table class="calendar" border="0" cellpadding="0" cellspacing="1">{/table_open}

		   {heading_row_start}<tr>{/heading_row_start}

		   {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
		   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
		   {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}

		   {heading_row_end}</tr>{/heading_row_end}

		   {week_row_start}<tr class="week-days">{/week_row_start}
		   {week_day_cell}<td style=background-color:#7d7d7d; border:1px solid #7d7d7d;"><div align="left" style="color:#fff;">{week_day}</div></td>{/week_day_cell}
		   {week_row_end}</tr>{/week_row_end}

		   {cal_row_start}<tr>{/cal_row_start}
		   {cal_cell_start}<td>{/cal_cell_start}
                        {cal_cell_content}
		    <div class="cell-inner-big">
			{content}
			</div>
			{/cal_cell_content}
			{cal_cell_content_today}
			<div class="cell-inner-big">
                        {content}
			</div>
			{/cal_cell_content_today}
			{cal_cell_no_content}
			<div class="cell-inner-big">
			<div class="reserve-job-block">';

				$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content}
			{cal_cell_no_content_today}
			<div class="cell-inner-big">
				<div class="reserve-job-block">';

			$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content_today}

		   {cal_cell_blank}&nbsp;{/cal_cell_blank}

		   {cal_cell_end}</td>{/cal_cell_end}
		   {cal_row_end}</tr>{/cal_row_end}

		   {table_close}</table>{/table_close}
		';

                 global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
		$this->load->library('calendar',$prefs);
		$this->load->view("common/header");
		$this->load->view("admin/installeravailableedit",$data);
		$this->load->view("common/footer");
  }

   function createnewdesignpdf($jobid){
       $this->load->helper('designpdf');
	   $this->load->helper('download');
	  /* if($this->session->userdata("user_id")!=49){
	     createdesignesheet($jobid);
    	   die;
	   }*/ 
	  include("/var/www/vhosts/aeihawaii.com/httpdocs/MPDF531/mpdf.php");
      include("/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/mergepdf/mergepdf.php");
            
            //$pdfpath    = "C:/wamp/www/product/trunk/scheduler/uploads/";
            //$uploaddir  = "C:/wamp/www/product/trunk/scheduler/uploads/";  //set this to where your files should be uploaded. 
      $uploaddir = "/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/";
      $pdfpath  = "/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/";
      
	  $pid = $this->getparentjobid($jobid);
      $this->db->where("job_id",$pid);
      $this->db->where("type",'building');
      $this->db->order_by("created","desc");
      
	  $data['permit_file_building'] = array();
	  $data['permit_file_building'] = $this->db->get("permit_files")->row_array();
	  $this->db->where("job_id",$pid);
      $this->db->where("type",'electric');
	  $this->db->order_by("created","desc");
      
	  $data['permit_file_electric'] = array();
	  $data['permit_file_electric'] = $this->db->get("permit_files")->row_array();      
	  
	  $this->db->where("job_id",$pid);
      $this->db->where("type",'lineimage');
	  $this->db->order_by("created","desc");
      
	  $data['permit_file_lineimage'] = array();
	  $data['permit_file_lineimage'] = $this->db->get("permit_files")->row_array();
	  $this->db->where("job_id",$pid);
      $this->db->where("job_type",2);
      $this->db->where("mime",'application/pdf');
	  $this->db->order_by("created","desc");
      
	  $data['permit_file_design'] = array();
	  $data['permit_file_design'] = $this->db->get("genral_files")->row_array();
      
	  //$html =createdesignesheet($jobid,$re_part='part_pdf');
     
      $merge_pdfall['1'] = $html;
      $htmlappend1="";
	  if(count($data['permit_file_design'])){
        //$merge_pdfall['2'] = $_SERVER['DOCUMENT_ROOT']."/uploads/".@$data['permit_file_design']['unique_filename'];
		$newpath=$pdfpath.@$data['permit_file_design']['id'].'_temp.jpg';
		@unlink($newpath);
	    $existpath= $_SERVER['DOCUMENT_ROOT']."/uploads/".@$data['permit_file_design']['unique_filename'];
		exec ("convert $existpath -append  $newpath  ");
	    $naddimg = "<img src='".base_url()."/uploads/".@$data['permit_file_design']['id']."_temp.jpg'/><br/><br/>"; // Read the file's contents
       // $htmlappend1 .='<pagebreak />';
        $htmlappend1 .='<table cellpadding="0" cellspacing="0" align="center" width="100%">';
        $htmlappend1 .='<tr><td></td>
                    <td align="left" >'.$naddimg.'  </td>
                    </tr>
                ';
        $htmlappend1 .='</table>';
      }
    
	  //$htmlappend1 .= createdesignesheetimage($jobid);
      
	    if(count($data['permit_file_lineimage'])){
         //$merge_pdfall['4'] = $_SERVER['DOCUMENT_ROOT']."/uploads/".@$data['permit_file_building']['unique_filename'];
		 $newpath=$pdfpath.@$data['permit_file_lineimage']['id'].'_temp.jpg';
		@unlink($newpath);
	    $existpath= $_SERVER['DOCUMENT_ROOT']."/uploads/".@$data['permit_file_lineimage']['unique_filename'];
		exec ("convert $existpath -append  $newpath  ");
	    $naddimg = "<img src='".base_url()."/uploads/".@$data['permit_file_lineimage']['id']."_temp.jpg'/><br/><br/>"; // Read the file's contents
        //$htmlappend1 .='<pagebreak />';
        $htmlappend1 .='<table cellpadding="0" cellspacing="0" align="center" width="100%">';
        $htmlappend1 .='<tr><td></td>
                    <td align="left" >'.$naddimg.'  </td>
                    </tr>
                ';
        $htmlappend1 .='</table>';
      } if(count($data['permit_file_electric'])){            
			$merge_pdfall['5'] = $_SERVER['DOCUMENT_ROOT']."/uploads/".@$data['permit_file_electric']['unique_filename'];
			$newpath=$pdfpath.@$data['permit_file_electric']['id'].'_temp.jpg';
			@unlink($newpath);
		    $existpath= $_SERVER['DOCUMENT_ROOT']."/uploads/".@$data['permit_file_electric']['unique_filename'];
			exec ("convert $existpath -append  $newpath  ");
			$naddimg = "<img src='".base_url()."/uploads/".@$data['permit_file_electric']['id']."_temp.jpg'/><br/><br/>"; // Read the file's contents
	       // $htmlappend1 .='<pagebreak />';
		    $htmlappend1 .='<table cellpadding="0" cellspacing="0" align="center" width="100%">';
			$htmlappend1 .='<tr><td></td>
                    <td align="left" >'.$naddimg.'  </td>
                    </tr>
                ';
         $htmlappend1 .='</table>';
	  } if(count($data['permit_file_building'])){
            $merge_pdfall['6'] = $_SERVER['DOCUMENT_ROOT']."/uploads/".@$data['permit_file_building']['unique_filename'];
			$newpath=$pdfpath.@$data['permit_file_building']['id'].'_temp.jpg';
			@unlink($newpath);
		    $existpath= $_SERVER['DOCUMENT_ROOT']."/uploads/".@$data['permit_file_building']['unique_filename'];
			exec ("convert $existpath -append  $newpath  ");
		    $naddimg = "<img src='".base_url()."/uploads/".@$data['permit_file_building']['id']."_temp.jpg'/><br/><br/>"; // Read the file's contents
		    //$htmlappend1 .='<pagebreak />';
			$htmlappend1 .='<table cellpadding="0" cellspacing="0" align="center" width="100%">';
			$htmlappend1 .='<tr><td></td>
                    <td align="left" >'.$naddimg.'  </td>
                    </tr>';
            $htmlappend1 .='</table>';
      }
	    $htmlappend1 .='<table class="page-break-before: always;"><tr><td><br/><br/></td></tr></table>';
	    $htmlappend1 .=  $this->createpdfpartjob($jobid,$re_part='part_pdf');
	     
		 //$htmlappend1 .=  $this->createpdfpartjob($jobid,$re_part='part_pdf');
	     createdesignesheet($jobid, $htmlappend1);
		 die;
	   

	     
	
   }

  function createpdf($jobid){
   
   $sql_jobtype = "SELECT job_type_id FROM jobs where id=$jobid";
   $res = mysql_fetch_object(mysql_query($sql_jobtype));
   if ($res->job_type_id == 1 || $res->job_type_id == 9) {
       $this->createswhpdf($jobid);
       return;
   }
   if($res->job_type_id == 5 ) {
      $this->createservicepdf($jobid);
      return;
     }
   $html = $this->load->view("admin/createpdfhtml",'',true);
   $j = array();
   //$roof_flashing['1'] = 'AEI(Eco Fastener)';
   $roof_flashing['2'] = 'Quickmount';
   $roof_flashing['3'] = 'Wakaflex';
   $roof_flashing['4'] = 'GEOCEL Sealant';
   $roof_flashing['5'] = 'Lead Flashing';
   $roof_flashing['6'] = 'Standoffs';
   $roof_flashing['7'] = 'Tile Hooks';
   $roof_flashing['8'] = 'Quickmount Flashing 12" x 12" (asphalt)';
   $roof_flashing['9'] = 'Quickmount Flashing 18" X 18" (wood shake)';
  // $roof_flashing['10'] = 'Unirac 2-piece Standoff 3"';
   //$roof_flashing['11'] = 'Unirac 2-piece Standoff 4"';
   //$roof_flashing['12'] = 'Unirac 2-piece Standoff 6""';
   $roof_flashing['13'] = 'Gaco Silicone/Geocel 4500';
   $roof_flashing['14'] = 'S5 Clips';
   $roof_flashing['15'] = 'Wakaflex Flashing';
   $roof_flashing['16'] = 'Lag/Hanger hardware';
   $roof_flashing['17'] = 'Custom/Trellis';
 // include("C:\wamp\www\sites\\trunk\scheduler\MPDF53\mpdf.php");
   //include("C:\wamp\www\sites\\trunk\scheduler\mergepdf\mergepdf.php");
   include("/var/www/vhosts/aeihawaii.com/httpdocs/MPDF531/mpdf.php");
   include("/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/mergepdf/mergepdf.php");

   $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
                        customers.email,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			customers.home_phone,
                        customers.secondary_phone,
                        customers.association,
                        customers.heco_account_number,
                        customers.heco_meter_number,
                        customers.neighborhood,
                        customers.other_neighborhood,
                        job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($jobid)."
		";

     $data = $this->db->query($sql)->row_array();
     $sql_pl="SELECT job_date from jobs WHERE job_pid=".$data['job_pid']." AND job_type_id=6";
     $data_pl= $this->db->query($sql_pl)->row_array();
     
     $sql_pm="SELECT job_date from jobs WHERE job_pid=".$data['job_pid']." AND job_type_id=7";
     $data_pm= $this->db->query($sql_pm)->row_array();
     
     $sql_pv="SELECT job_date from jobs WHERE job_pid=".$data['job_pid']." AND job_type_id=2";
     $data_pv = $this->db->query($sql_pv)->row_array();
     
	 $sql_proposal="SELECT deal_type from proposal WHERE id=".$data['proposal_id'];
     $data_proposal = $this->db->query($sql_proposal)->row_array();
     $deal_type="AEI";
     if($data_proposal["deal_type"]==2){
        $deal_type="AEI CPF";
     }
	 if($data_proposal["deal_type"]==3){
        $deal_type="DS";
     }
	 if($data_proposal["deal_type"]==4){
        $deal_type="DS CPF";
     }
	$html = str_replace("{payment_type}" ,$deal_type,$html);
    $userload = $this->getuser($data['user_id']);
    $customername = $data['first_name']." ".$data['last_name'];
    $username = $userload[0]->first_name." ".$userload[0]->last_name;
    $html = str_replace("{salesman_name}" ,$username ,$html);
    $html = str_replace("{salesman_phoneno}" ,$userload[0]->phone,$html);
    $customername_pdf = $data['first_name']."-".$data['last_name'].".pdf";
   /* Customer Information*/
   
   $html = str_replace("{customer_name}" ,$customername ,$html);
   $html = str_replace("{address_customer}" ,$data['address'] ,$html);
   $html = str_replace("{city_customer}" ,$data['city'] ,$html);
   $html = str_replace("{zipcode_customer}" ,$data['zip_code'] ,$html);
   $html = str_replace("{email_customer}" ,$data['email'] ,$html);
   $html = str_replace("{telephone_customer}" ,"'".$data['home_phone']." ".$data['secondary_phone']."'" ,$html);
   $html = str_replace("{assoc_customer}" ,$data['association'], $html);
   $install_date="";

   $install_date_array = array();

   if($data_pm['job_date'] ) {
    $install_date_array[]="(PM)".date("m/d/y",strtotime($data_pm['job_date']))."(".date("D",strtotime($data_pm['job_date'])).")<br/>";
   }

   if($data_pl['job_date'] ) {
    $install_date_array[]="(PL)".date("m/d/y",strtotime($data_pl['job_date']))."(".date("D",strtotime($data_pl['job_date'])).")<br/>";
   }

   if($data_pv['job_date'] ) {
    $install_date_array[]="(PV)".date("m/d/y",strtotime($data_pv['job_date']))."(".date("D",strtotime($data_pv['job_date'])).")<br/>";
   }
   $ptr_system="";
   $appc_system="";
   $finalacc_system="";
   
   if($data['ptr'] ) {
    $ptr_system=date("m/d/y",strtotime($data['ptr']));
   }

    if($data['ppc'] ) {
     $appc_system=date("m/d/y",strtotime($data['ppc']));
    }

    if($data['fa'] ) {
     $finalacc_system=date("m/d/y",strtotime($data['fa']));
    }


   if(count($install_date_array)==0){
       $install_date="Unscheduled Job";   
   }else{
      $install_date = implode(" ", $install_date_array);
   }
   $html = str_replace("{installdate_customer}" ,$install_date ,$html);
   $html = str_replace("{dow_customer}" ,date("l",strtotime($data['job_date'])) ,$html);

   /* System Information*/
   $html = str_replace("{ptr_system}" ,$ptr_system ,$html);
   $html = str_replace("{appc_system}" ,$appc_system ,$html);
   $html = str_replace("{finalacc_system}" ,$finalacc_system ,$html);
   
   
   $html = str_replace("{nos_system}" ,$data['job_nos'] ,$html);
   $html = str_replace("{ss_system}" ,$data['system_size'] ,$html);
   $html = str_replace("{nom_system}" ,$data['job_nom'] ,$html);
   $html = str_replace("{mt_system}" ,$this->getidothervalue($data['module_brand_id'] ,$data['other_module_brand'] ,'module_brands' ,'brand') ,$html);
   $html = str_replace("{ib_system}" ,$data['inverter_count'] ,$html);
   $html = str_replace("{roofflashing_job}" ,$roof_flashing[$data['roof_flashing']] ,$html);
   $html = str_replace("{neighborhood}" ,$this->getidothervalue($data['neighborhood'] ,$data['other_neighborhood'] ,'neigbhour' ,'neighbour') ,$html);
   $html = str_replace("{it_system}" ,$this->getidothervalue($data['inverter_type_id'] ,$data['other_inverter_type'] ,'inverter_types' ,'type') ,$html);
    if($data['inverter_accessible']=="y")
       $data['inverter_accessible'] = "Yes";
   else
    $data['inverter_accessible'] = "No";
   $html = str_replace("{ia_system}" ,ucfirst($data['inverter_accessible']) ,$html);
   $html = str_replace("{wrd_system}" ,$this->getidothervalue($data['wire_run_distance'] ,$data['other_wire_run_distance'] ,'wire_run_distance' ,'type')." ft" ,$html);
   
   if($data['job_nosa']=="other") $data['job_nosa']= @$data["other_job_nosa"];

   $html = str_replace("{nosa_system}" ,$data['job_nosa'] ,$html);
   if($data['tilt_kit_needed']=="y")
       $data['tilt_kit_needed'] = "Yes";
   else
       $data['tilt_kit_needed'] = "No";
   $html = str_replace("{tkn_system}" ,$data['tilt_kit_needed'] ,$html);
   $html = str_replace("{ort_system}" ,$data['roof_orientation'] ,$html);
   $html = str_replace("{rp_system}" ,$data['roof_pitch'] ,$html);
   $html = str_replace("{pom_system}" ,$this->getidothervalue($data['installation_type_id'] ,$data['other_installation_type'] ,'installation_types' ,'type') ,$html);
   $html = str_replace("{ms_system}" ,$this->getidothervalue($data['mointer_system'] ,$data['other_mointer_system'] ,'moniter_display' ,'type') ,$html);

   /* job specification */
   $html = str_replace("{rt_job}" ,$this->getidothervalue($data['roof_type_id'] ,$data['other_roof_type'] ,'roof_types' ,'type') ,$html);
   $html = str_replace("{rmt_job}" ,$this->getidothervalue($data['rafter_type_id'] ,$data['other_rafter_type'] ,'rafter_types' ,'type') ,$html);
   $html = str_replace("{dbr_job}" ,$data['rafter_distance'] ,$html);
   $html = str_replace("{rut_job}" ,$this->getidothervalue($data['wire_run_type_id'] ,$data['other_wire_run_type'] ,'wire_run_types' ,'type') ,$html);
   $html = str_replace("{nof_job}" ,$data['stories'] ,$html);
   if($data['is_ladder']=="y")
       $data['is_ladder'] = "Yes";
   else
       $data['is_ladder'] = "No";
   $html = str_replace("{lle_job}" , $data['is_ladder'] ,$html);


   $contractor = $data['contractor_id'];
   $temp =explode(",",$contractor);
   $cnamei = array();
   foreach($temp as $c=>$v) {
    $cnamei[] = $this->getUserIntial($v,true);
   }
   
   $installer_id = $data['installer_id'];
   $temp =explode(",",$installer_id);
   $installname = array();
   foreach($temp as $c=>$v) {
       if($v){
           $installname[] = $this->getUserIntial($v,true)."(".$this->getUserEmpNo($v).")";
       }
   }
  
   $html = str_replace("{technician}",implode(",",$installname),$html);
   /* Electric  specification */
   
   $html = str_replace("{er_elec}" ,implode(",",$cnamei) ,$html);
   $html = str_replace("{hm_elec}" ,$data['heco_meter_number'] ,$html);
   $html = str_replace("{ha_elec}" ,$data['heco_account_number'] ,$html);
   $standoff_size_html="";
   if($data['roof_flashing']==6){
        $standoff_size_html='<tr><td width="40%">Standoff Size: <td width="60%" class="bdr">'.$this->getidothervalue($data['standoff_size_id'] ,$data['other_standoff_size_id'] ,'standoff_size' ,'type').'</td></tr>';
   }
   $html = str_replace("{standoff_size}" ,$standoff_size_html ,$html);
   $html = str_replace("{tm_elec}" ,$this->getidothervalue($data['jobs_emt'] ,$data['other_jobs_emt'] ,'electric_wire_type' ,'type') ,$html);
    if($data['job_wssn']=="y")
       $data['job_wssn'] = "Yes";
   else
       $data['job_wssn'] = "No";
   $html = str_replace("{nsn_elec}" ,$data['job_wssn'] ,$html);
   $html = str_replace("{iyws_elec}" ,$data['job_isnws'] ,$html);
   $html = str_replace("{sm_elec}" ,"" ,$html);
   
   $html = str_replace("{spa_elec}" ,$this->getidothervalue($data['service_panel_amperage_id'] ,$data['other_amperage'] ,'service_panel_amperages' ,'amperage') ,$html);
   $html = str_replace("{ews_elec}" ,$this->getidothervalue($data['electric_wire_source'] ,$data['electric_wire_source_other'] ,'electric_wire_source' ,'source') ,$html);
   $un_elec = "";
   if ($data['servicepanelupgrade']==1){
       $un_elec = 'Yes( Size:- '.$data['job_spu'].')';
   } else if($data['servicepanelupgrade']==2){
       $un_elec = 'No';

   } else if($data['servicepanelupgrade']==3){
       $un_elec = 'Upgrade Needed?';
   }
   $html = str_replace("{un_elec}" ,$un_elec,$html);

     if($data['spmsip_job']=="yes")
       $data['spmsip_job'] = "Yes";
   else
       $data['spmsip_job'] = "No";
   $html = str_replace("{spmsip_job}" ,$data['spmsip_job'],$html);
  
   $html = str_replace("{comment_elec}" ,$data['comments'] ,$html);
   
   $pid_job = $this->getparentjobid($jobid);
   if($data["job_old"]==1){
      $tablename_design="presale_files";
   } else{
      $tablename_design="genral_files";
   }
   $sql_plot = "SELECT * FROM  $tablename_design  WHERE job_id=$pid_job AND mime in ('application/pdf','\"application/pdf\"' ) ";
   $plot_files = array();
   $plot_files = $this->db->query($sql_plot)->result_array();
   $htmlappend1 ="";
   $pdfpath = "/var/www/vhosts/aeihawaii.com/httpdocs/uploads/";
   if (count($plot_files)>0 && file_exists($pdfpath.$sketch_files[0]['unique_filename'])){
    $merge_pdfall[1] = $pdfpath.$plot_files[0]['unique_filename'];
    $newpath=$pdfpath.'temp.jpg';
    @unlink($newpath);
    $existpath= $pdfpath.$plot_files[0]['unique_filename'];
//echo $pdfpath.$plot_files[0]['unique_filename'];
   exec ("convert $existpath -append  $newpath  ");
//die;
  $htmlappend1 .='<pagebreak />';
  $htmlappend1 .='<table cellpadding="0" cellspacing="0" align="center" width="100%">';
  $htmlappend1 .='<tr><td></td>
                    <td align="left" width="40%">{planimagesadd}  </td>
                    </tr>
                ';
  $htmlappend1 .='</table>';
  $html = str_replace("{planaddimage}" , $htmlappend1 ,$html);
  $naddimg = "<img src='".$newpath."' /><br/><br/>"; // Read the file's contents
  $html = str_replace("{planimagesadd}" , $naddimg ,$html);
  } else {
   $html = str_replace("{planaddimage}" , "" ,$html);
  }


   $img = "";
   $sql = "SELECT * FROM meter_files WHERE job_id=$jobid AND is_export=1 AND mime in ('image/jpg' ,'image/jpeg' ,'image/png', 'image/gif' )";
   $plan_files = array();
   $plan_files = $this->db->query($sql)->result_array();
   
   $htmlappend ="";
   $count = 1;
   if(count($plan_files)){
       foreach ($plan_files as $key => $value){
           if ($count == 1 || $count%2 == 1){
            $htmlappend .='<pagebreak />';
            $htmlappend .='<table cellpadding="0" cellspacing="0" align="center" width="100%">';
           }
             $htmlappend .='<tr>
                    <td></td>
                    <td align="left" width="40%">{planimages_'.$count.'}  </td>
                    </tr>
                ';
             if ($count == 1 || $count%2 == 1){
                $htmlappend .='</table>';
             }
        $count = $count + 1;
       }
       $html = str_replace("{strimage}" , $htmlappend ,$html);
       $count = 1;
       foreach ($plan_files as $key => $value){
        $img = "<img src='".base_url()."uploads/".$value['unique_filename']."' /><br/><br/>"; // Read the file's contents
        $html = str_replace("{planimages_".$count."}" , $img ,$html);
        $count = $count + 1;
        }
        
   }else{
       $html = str_replace("{strimage}" , "" ,$html);
   }
   
   $sql_file_pdf = "SELECT * FROM  meter_files  WHERE job_id=$pid_job AND is_export=1 AND file_type=4 AND  mime in ('application/pdf','\"application/pdf\"' ) ";
   $partpdf_files = array();
   $partpdf_files = $this->db->query($sql_file_pdf)->result_array();

   $htmlappend1 ="";
   $k=0;
   foreach($partpdf_files as $partpdffiles){
   $pdfpath = "/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/";
   //echo $pdfpath.$partpdffiles['unique_filename'];
   if ( file_exists($pdfpath.$partpdffiles['unique_filename'])){
    $merge_pdfall[1] = $pdfpath.$partpdffiles['unique_filename'];
    $newpath=$pdfpath.$partpdffiles['id'].'_temp.jpg';
    @unlink($newpath);
    $existpath= $pdfpath.$partpdffiles['unique_filename'];
//echo "convert $existpath -append  $newpath  ";
   exec ("convert $existpath -append  $newpath  ");

//die;
  $naddimg = "<img src='".$newpath."' /><br/><br/>"; // Read the file's contents
   $htmlappend1 .='<pagebreak />';
  $htmlappend1 .='<table cellpadding="0" cellspacing="0" align="center" width="100%">';
  $htmlappend1 .='<tr><td></td>
                    <td align="left" width="40%">'.$naddimg.'  </td>
                    </tr>
                ';
   $htmlappend1 .='</table>';
   
  
 
  
  
   }
   }
   
     $html = str_replace("{partpdfimage}" , $htmlappend1 ,$html);
   //$pid = $this->getparentjobid($job_id);
   //$sql = "SELECT  * from elecphoto_files WHERE job_id=$pid ORDER by photo_id";
   //$data['photo']= $this->db->query($sql)->result_array();

  $mpdf=new mPDF('s');
  $mpdf->SetDisplayMode('fullpage');
  
 
   $merge_pdfall =array();
   $mpdf->WriteHTML($html);
   // linux path
   //$pdfpath = "C:/wamp/www/sites/trunk/scheduler/uploads/"; // linux path
   $data =$mpdf->Output($customername_pdf,"D");
  /* $merge_pdfall[0] =$pdfpath.$customername_pdf;
   $pid_job = $this->getparentjobid($jobid);
   /**$sql_sketchfile = "SELECT * FROM sketch_files WHERE job_id=$pid_job AND mime in ('application/pdf' ) ";
   $sketch_files = array();
   $sketch_files = $this->db->query($sql_sketchfile)->result_array();
   if (count($sketch_files)>0 && file_exists($pdfpath.$sketch_files[0]['unique_filename'])  )
    $merge_pdfall[1] = $pdfpath.$sketch_files[0]['unique_filename'];
  
  $sql_presale = "SELECT * FROM presale_files WHERE job_id=$pid_job AND mime in ('application/pdf' ) ";
  $presale_files = array();
  $presale_files = $this->db->query($sql_presale)->result_array();
  if (count($presale_files)>0 && file_exists($pdfpath.$sketch_files[0]['unique_filename']))
    $merge_pdfall[2] = $pdfpath.$presale_files[0]['unique_filename'];
   */
  
  
   $pdf = new concat_pdf(); 
   $pdf->setFiles($merge_pdfall); 
   $pdf->concat(); 
   $pdf->Output($customername_pdf, 'D');
   }
  function getcustomer($id){
       $j = $this->db->query("SELECT customers.* FROM customers  WHERE  id =$id ")->result();
      
       return $j;
  }
  function getuser($id){
	  if(!isset($id) || $id<0) {
	      $j = new stdclass;
		  $j[0]->first_name=" ";
           $j[0]->last_name=" ";
           $j[0]->phone=" ";
           return $j;
	  }

	  if($id>0){
		$j = new stdclass;
		$j = $this->db->query("SELECT users.* FROM users WHERE  id =$id ")->result();
		if(isset($j[0]->first_name))
			return $j;
		else {
           $j[0]->first_name="";
           $j[0]->last_name="";
           $j[0]->phone="";
           return $j;
       }
	  } else{
	      return " ";
	  }
  }
  function getidothervalue($other ,$id ,$tablename , $column ="*"){
   if($other=="other" || $other=="" || !$other){

       return $id;
   }
   
   $j = $this->db->query("SELECT $column  FROM $tablename  WHERE  id =$other")->result();
    
    if(isset($j[0]->$column))
     return $j[0]->$column;
     else
      return "" ;
  }
  function installers($job_id){
    $data = array();

		$data['job_id'] = $job_id;

		$this->load->library("job");
		$this->load->helper("text");

		if($job_id=='') { redirect('admin/error?e=job_id'); }

		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();

		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['job'] = $this->db->query($sql)->row_array();
                $data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
				if($data['job']['job_type_id'] == 8 ) { $data['titlejob'] = 'Electrical Pre-install'; }
				if($data['job']['job_type_id'] == 8 ) { $data['titlejob'] = 'Electrical Pre-install'; }
                 if($data['job']['job_type_id'] == 6 ) {
                     $data['titleshow'] = 'PreLag';
                     $data['job']['job_type']='PreLag';
                  }
                 if($data['job']['job_type_id'] == 7 ) {
                     $data['titleshow'] = 'Premeasure';
                     $data['job']['job_type']='Premeasure';
                  }
                $data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);

                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
                // daily job limit
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);

                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
				if($data['job']['project_designer_id']!="" && $data['job']['project_designer_id']){
                    $show_instaler = explode("," ,$data['job']['project_designer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["enginner"]= implode(", " ,$showinstaller_name);
				 } else {
                    $data["enginner"]= " ";
				}
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		$sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_type_id not in (6,7,8,15) AND jobs.job_pid=".$data['job']['job_pid']." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $install_assign = $data['job']['installer_id'];
                $installer_assign_array = explode("," ,$install_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $data['installer_assign']=array();
                $data['installer_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$installer_assign_array )){
                          $data['installer_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $data['installer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                    }
                $conduit_assign = $data['job']['conduit_id'];
                $conduit_array = explode("," ,$conduit_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $data['conduit_assign']=array();
                $data['conduit_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$conduit_array )){
                          $data['conduit_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $data['conduit_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }    
                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']<5){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
                //$totalinstaller = $this->db->query("SELECT GROUP_CONCAT(installer_id) as totalinstaller FROM jobs   WHERE jobs.job_date = '".$data['job']['job_date']."' GROUP BY jobs.job_date ")->result_array();
		//$data['totalinstallercnt'] = $totalinstaller[0]['totalinstaller'];
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
               
		$this->db->where('type','contractor');
		$contractors = $this->db->get("users")->result_array();
		foreach($contractors as $row) { $data['contractors'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row['last_name']); }
         if($data['job']['project_designer_id']!="" && $data['job']['project_designer_id']){
                    
                    $show_instaler = explode("," ,$data['job']['project_designer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["enginner"]= implode(", " ,$showinstaller_name);
         } else {
                    $data["enginner"]= " ";
          }      
				
				$where='( type="engineer"  )  AND user_status="active"';
               // $this->db->where("type","engineer");
                $this->db->where($where);
				$this->db->order_by("first_name","desc");
		        $designeruser = $this->db->get("users")->result_array();
                $data['designer_eng'] = array();
                foreach($designeruser as $row) {
                    $data['designer_eng'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }
				$this->load->view("common/header");
                $this->load->view("admin/job_installer",$data);
                $this->load->view("common/footer");
  }
  function customer_job($job_id){
        $data = array();
        $data['job_id'] = $job_id;
        $this->load->library("job");
        $data['percent_completed'] = $this->job->percent_completed($job_id);
	    $this->load->helper("text");
          if($job_id=='') { redirect('admin/error?e=job_id'); }
            $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
                        customers.first_name1,
			customers.last_name1,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
                        customers.neighborhood,
                        customers.other_neighborhood,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
                if($data['job']['neighborhood']!="other"){
                  $data['job']['neighborhood_view']= $this->getCustomerNeighborhood($data['job']['customer_id']);
                }else{
                 $data['job']['neighborhood_view']= $data['job']['other_neighborhood'];
                }
                
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		//$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
                 $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id,'active');
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                 $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		
		 if($data['job']['project_designer_id']!="" && $data['job']['project_designer_id']){
                    $show_instaler = explode("," ,$data['job']['project_designer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["enginner"]= implode(", " ,$showinstaller_name);
				 } else {
                    $data["enginner"]= " ";
		 }
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();
		
		$sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_type_id not in (6,7,8,15) AND jobs.job_pid=".$data['job']['job_pid']." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();
                $this->db->order_by("id","asc");
                $data['neighbour']['']="Select Geographical Area";
                //$data['neighbour']['other']="Other";
		$this->db->where('is_new =',1);
                $neighbour_display = $this->db->get("neigbhour")->result_array();
                
                foreach($neighbour_display as $row) { $data['neighbour'][$row['id']] = $row['neighbour']; }
		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();

               $data['job_statuses'][''] = "- Select a job status -";
               $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']<5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                 $data['job_statuses']['to be completed'] = "To Be Completed";
                 $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";

                $data['phone'][''] = "- Select a phone -";
                $data['phone']['home'] = "Home";
		$data['phone']['work'] = "work";
		$data['phone']['cell'] = "cell";

                
                $customer_id = $data['job']['customer_id'];
                $data['customer_id'] = $customer_id;
		if($customer_id=='') { redirect('admin/error?e=customer_id'); }

		$data['states'] =  array('' => "- Choose a state -");
		$data['states'] += array('AK'=>"Alaska",'AL'=>"Alabama",'AR'=>"Arkansas",'AZ'=>"Arizona",'CA'=>"California",'CO'=>"Colorado",'CT'=>"Connecticut",'DC'=>"District Of Columbia",'DE'=>"Delaware",'FL'=>"Florida",'GA'=>"Georgia",'HI'=>"Hawaii",'IA'=>"Iowa",'ID'=>"Idaho",'IL'=>"Illinois", 'IN'=>"Indiana",'KS'=>"Kansas",'KY'=>"Kentucky",'LA'=>"Louisiana",'MA'=>"Massachusetts",'MD'=>"Maryland",'ME'=>"Maine",'MI'=>"Michigan",'MN'=>"Minnesota",'MO'=>"Missouri",'MS'=>"Mississippi",'MT'=>"Montana",'NC'=>"North Carolina",'ND'=>"North Dakota",'NE'=>"Nebraska",'NH'=>"New Hampshire",'NJ'=>"New Jersey",'NM'=>"New Mexico",'NV'=>"Nevada",'NY'=>"New York",'OH'=>"Ohio",'OK'=>"Oklahoma", 'OR'=>"Oregon",'PA'=>"Pennsylvania",'RI'=>"Rhode Island",'SC'=>"South Carolina",'SD'=>"South Dakota",'TN'=>"Tennessee",'TX'=>"Texas",'UT'=>"Utah",'VA'=>"Virginia",'VT'=>"Vermont",'WA'=>"Washington",'WI'=>"Wisconsin",'WV'=>"West Virginia",'WY'=>"Wyoming");

        $data['dtmls'] =  array('' => "- Select a DML -");
 		$data['dtmls'] +=array(1=>"100%+",5=>"0-25",4=>"25-50",3=>"50-75",2=>"75-100");
		$data['dtmls'] += array(6=>"0-74",7=>"75-99",8=>"100-120",9=>"120+");
		// grab customer info
		$this->db->where("id",$customer_id);
		$data['customer'] = $this->db->get("customers")->row_array();

		// find existing, other customers with this address...
		$this->db->where("address !=",'');
		$this->db->where("city !=",'');
		$this->db->where("state !=",'');
		$this->db->where("address",$data['customer']['address']);
		$this->db->where("city",$data['customer']['city']);
		$this->db->where("state",$data['customer']['state']);
		$this->db->where("id !=", $data['customer']['id']);
		$data['duplicate_customers'] = $this->db->get("customers")->result_array();
		if(count($data['duplicate_customers'])> 0)
		{
			$data['duplicate_addresses'] = true;
		}

		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['customer_type_id'] = $this->input->post("customer_type_id");
			$row['household_type_id'] = $this->input->post("household_type_id");
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
                        $row['first_name1'] = $this->input->post("spouse_firstname");
			$row['last_name1'] = $this->input->post("spouse_lastname");
			$row['home_phone'] = $this->input->post("home_phone");
                        if ($row['home_phone']){
			  $row['secondary_phone'] = $this->input->post("secondary_phone");
                        } else {
                            $row['secondary_phone'] = "";
                        }
                        $row['home_phone1'] = $this->input->post("home_phone1");
			if ($row['home_phone1']){
                            $row['secondary_phone1'] = $this->input->post("secondary_phone1");
                        } else {
                            $row['secondary_phone1'] ="";
                        }

                        $row['home_phone2'] = $this->input->post("home_phone2");
			if($row['home_phone2']){
                            $row['secondary_phone2'] = $this->input->post("secondary_phone2");
                        } else{
                            $row['secondary_phone2'] = "";
                        }

                        if ($this->input->post('neighborhood') == 'other') {
                            $row['neighborhood'] = '';
                            $row['other_neighborhood'] = $this->input->post("other_neighborhood");
			} else {
                            $row['neighborhood'] = $this->input->post("neighborhood");
                            $row['other_neighborhood'] = '';
			}
			$row['email'] = $this->input->post("email");
			$row['address'] = $this->input->post("address");
			$row['dtml'] = $this->input->post("dtml");
			$row['city'] = $this->input->post("city");
			$row['state'] = $this->input->post("state");
			$row['zip_code'] = $this->input->post("zip_code");
                        $row['billing_address'] = $this->input->post("billing_address");
			$row['billing_city'] = $this->input->post("billing_city");
			$row['billing_state'] = $this->input->post("billing_state");
			$row['billing_zip_code'] = $this->input->post("billing_zip_code");

			$row['different_billing_address'] = $this->input->post("is_billing_address");
                        $row['neighborhood'] = $this->input->post("neighborhood");
			$row['association'] = $this->input->post("association");
			$row['household_members'] = $this->input->post("household_members");
			$row['avg_electric_bill'] = $this->input->post("avg_electric_bill");
			$row['sun_zone'] = $this->input->post("sun_zone");
			$row['cust_tmk'] = $this->input->post("cust_tmk");
                        $row['cust_bpan'] = $this->input->post("cust_bpan");
                        $row['heco_account_number'] = $this->input->post("heco_account_number");
			$row['heco_meter_number'] = $this->input->post("heco_meter_number");
			$row['comments'] = $this->input->post("comments");
                        $this->db->where("address !=",'');
		        $this->db->where("city !=",'');
		        $this->db->where("state !=",'');
		        $this->db->where("address",$row['address']);
		        $this->db->where("city",$row['city']);
		        $this->db->where("state",$row['state']);
		        $this->db->where("id !=", $customer_id);
		        $data['duplicate_customers'] = $this->db->get("customers")->result_array();
		        if(count($data['duplicate_customers'])> 0)
		        {
                            redirect("admin/customer_job/".$job_id."?errordata=1");
	        	}
			$this->db->where("id",$customer_id);
			$this->db->update("customers",$row);
			//Create activity log for updated customer
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Update", "customers", '', $this->session->userdata("user_id"), $customer_id);			


			redirect("admin/customer_job/".$job_id."?savedata=1");
		}

                /*
		// grab customer's jobs
		$sql = "SELECT jobs.*,job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($customer_id)." LIMIT 3";
		$data['jobs'] = $this->db->query($sql)->result_array();

		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes INNER JOIN jobs ON notes.job_id=jobs.id LEFT JOIN users ON notes.user_id=users.id WHERE jobs.customer_id=".$this->db->escape($customer_id)." LIMIT 3";
		$data['notes'] = $this->db->query($sql)->result_array();

		// grab customer files
		$sql = "SELECT files.* FROM files INNER JOIN jobs ON files.job_id=jobs.id INNER JOIN customers ON jobs.customer_id=customers.id WHERE jobs.customer_id=".$this->db->escape($customer_id)." ORDER BY files.created DESC LIMIT 3";
		$data['customer_files'] = $this->db->query($sql)->result_array();

		// grab household types */
		$sql = "SELECT * FROM household_types ORDER BY `type` ASC";
		$htypes = $this->db->query($sql)->result_array();
		$data['household_types'][] = '- Choose a household type';
		foreach($htypes as $h)
		{
			$data['household_types'][$h['id']] = $h['type'];
		}

		#die(print_r($data['customer_files']));
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $data['savedata'] =  $this->input->get("savedata");
                $data['errordata'] =  $this->input->get("errordata");
                $data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
    			if($data['job']['job_type_id'] == 8 ) { $data['titlejob'] = 'Electrical Pre-install'; }
                if($data['job']['job_type_id'] == 6 ) { $data['titleshow'] = 'PreLag'; }
                if($data['job']['job_type_id'] == 7 ) { $data['titleshow'] = 'Premeasure'; }
                $this->load->view("common/header");
                if($data['job']['job_type_id'] == 5 ){
                    $this->load->view("admin/service_customer",$data);
                }else if ($data['job']['job_type_id'] == 1){
                   $this->load->view("admin/job_swhcustomer",$data);
                } else {
                   $this->load->view("admin/job_customer",$data);
                }

                $this->load->view("common/footer");
  }

  function delete_referral($id){
      $data['id'] = $id;
     $this->load->view("admin/deletereferal",$data);
  }
  function getInstallerDay($year,$month,$day){
    $year = (int)$year;
    $month = (int) $month;
    $day = (int)$day;
    $editinstaller = array();
    $j =array();
     $j = $this->db->query("SELECT sum(no_installer_allocated)as inst FROM  jobs   WHERE DATE_FORMAT(job_date,'%Y-%c-%e') = '".$year."-".$month."-".$day."'  Group By job_date")->result();
     $editinstaller = $this->db->query("SELECT * FROM installer_manual WHERE   DATE_FORMAT(day,'%Y-%c-%e') = '".$year."-".$month."-".$day."'")->result();
    
    $number_installer = NUMBEROFINSTALLER;
    if($editinstaller && $editinstaller[0]->installer){
         $number_installer = $editinstaller[0]->installer;
    }
    if( $j &&  $j[0]->inst){
      $installavail = $number_installer-$j[0]->inst;
    }else{
       $installavail = $number_installer;
     }
     if($installavail<=0) return 0;
       return $installavail;
  }
  function gettimeLimit($jobid){
      $timelimit = 24;
      $resultcnt =  $this->db->query("SELECT * FROM globalconfig  where id = 1")->result_array();
      $timelimit = $resultcnt[0]['globaltimelimit'];
      return $timelimit;
  }
  function getexttimeLimit($jobid){
     $pid = $this->getparentjobid($jobid);
     $resultcnt =  $this->db->query("SELECT timeext as smtimeext,created_on FROM timelimit_manual_extend where jid = '".$pid."' ")->result_array();
     $timelimit = 0;
     if(count($resultcnt)>=1) {
       $timelimit_cal =  (int)(time()-strtotime($resultcnt[0]['created_on']));
       $timelimit = $resultcnt[0]['smtimeext']-round($timelimit_cal/3600);
     }
     return $timelimit;
  }
  function delete_jobcron($jobid){
      $this->db->query("DELETE FROM jobs where  id= '".$jobid."'");
      return;
  }
  function cronjob(){
      $result =  $this->db->query("SELECT * FROM jobs ")->result_array();
            foreach($result as $key => $value){
          $jobtimelimit = $this->gettimeLimit($value['id']);
           $timediff =  (int) ($jobtimelimit-(int)(time()-strtotime($value['created']))/3600);
          
		// daily job limit
                if($timediff<=0){
                    $this->delete_jobcron($value['id']);
                     $j = $this->db->query("SELECT * FROM users WHERE id=".$value['user_id']."")->result();
                    $sname = $j[0]->first_name." ".$j[0]->last_name;
                    $this->deletemail($value['id'],$timediff,$sname,$j[0]->email);

                } else if($timediff>1 && $timediff<3) {
                     $j = $this->db->query("SELECT * FROM users WHERE id=".$value['user_id']."")->result();
                    $sname = $j[0]->first_name." ".$j[0]->last_name;
                    $this->deletebeforemail($value['id'],$timediff,$sname,$j[0]->email);
                }
      }

      return;
  }

  function deletebeforemail($jobid,$timediff,$sname,$mail){
       $ismailsent = $this->globalnotifcation();
       if(!$ismailsent){
        return;
       }
       $sql_userid="SELECT user_id FROM  jobs WHERE  id=".$jobid;
       $row_userid = $this->db->query($sql_userid)->row_array();
       $isuserpre = $this->issendnotification($row_userid['user_id']);
       if(!$isuserpre){
         $json['success'] = true;
         echo json_encode($json);
        return ;
      }
         $this->load->library('email');
          $config['mailtype'] = 'html';
          $this->email->initialize($config);
          $this->email->from('sales@aeihawaii.com', 'Schedular');
          $this->email->to($mail);
          $this->email->subject('AEI Administration:Job Notification');
                   $message = "Dear [$sname],
This is an alert to let you know you have the following jobs awaiting your attention:
 <a href='".base_url()."job/$jobid'>Edit Technical Specification</a>
IMPORTANT NOTICE: YOU HAVE [$timediff HOURS] LEFT TO COMPLETE THE FOLLOWING:
   1.) JOB SPECIFICATIONS
   2.) CUSTOMER INFORMATION
   3.) PRICE INFORMATION
Thank you,
The AEI Administration Team";
  $this->email->message($message);
  $this->email->send();
  }
  function deletemail($jobid,$timediff,$sname,$mail){
          $ismailsent = $this->globalnotifcation();
          if(!$ismailsent){
            return;
          }
         $sql_userid="SELECT user_id FROM  jobs WHERE  id=".$jobid;
         $row_userid = $this->db->query($sql_userid)->row_array();
         $isuserpre = $this->issendnotification($row_userid['user_id']);
         if(!$isuserpre){
            $json['success'] = true;
            echo json_encode($json);
            return ;
         }
          $this->load->library('email');
          $config['mailtype'] = 'html';
          $this->email->initialize($config);
          $this->email->from('sales@aeihawaii.com', 'Schedular');
          $this->email->to($mail);
          $this->email->subject('AEI Administration:Job Created');
                   $message = "Dear [$sname],
This is an alert to let you know you have the following jobs have been removed from the schedule:
[<a href='".base_url()."job/$jobid'>] Job is deleted </a>
If you would like to reschedule your job, please do so here (<a href='".base_url()."admin/jobschedule'>] Schedule Job </a>).
Thank you,
The AEI Administration Teamm";
  $this->email->message($message);
  $this->email->send();
  }
  function getCommentType()
	{
		$sql = "SELECT id,comment_type FROM comment_type";
		return $this->db->query($sql)->result_array();
		}
	function getRankType()
	{
		$sql = "SELECT id,rank_type FROM rank_type";
		return $this->db->query($sql)->result_array();
		}
	function getCommentReply($comment_id)
	{
		$sql = "SELECT REPLY.*,USER.first_name,USER.last_name,USER.profile_photo from notes_reply AS REPLY,users AS USER WHERE USER.id = REPLY.user_id AND comment_id = '".$comment_id."'";// die();
		$res = $this->db->query($sql)->result_array();
		if(count($res)>0){
		$html = '
		<div class="divider"></div>
		<table width="100%" border="0">';
		foreach($res as $val)
		{
			if($val['profile_photo']!=''){
              	$src_path = $val['profile_photo']; 
              	$img = '<img src="'.thumbnail($src_path, 50, 50).'" />';
             } else 
				 $img = '<img src="'.base_url().'/assets/images/noprofile.jpg" width="50" height="50" />';
		  $html .='<tr id="reply'.$val['id'].'">
					<td width="93%" valign="top"><table width="100%" border="0">
  <tr>
   <td valign="top" width="2%"><br><span class="arrow">&nbsp;</span></td>
    <td valign="top" width="4%">'.$img.'</td>
    <td valign="top" width="94%"><strong> Date Posted:'.date('M d,Y g:i a',strtotime($val['created'])).' By:'.$val['first_name'].' '.$val['last_name'].' | </strong>'.$val['reply'].'(<a href="'.base_url().'admin/editreply?id='.$val['id'].'" class="facebox">Edit</a> | <a href="javascript:void(0)" onclick="deleteReply('.$val['id'].')">Delete</a>).</td>
  </tr>
</table>
</td></tr>';
		}
		$html .= '</table>';
		return $html;
		}
		else
			return '';
	}
 // editing reply here
 function editreply()
 {
	 if($this->input->get('id')!='' && is_numeric($this->input->get('id')))
	 {
		 $sql = "SELECT * FROM notes_reply WHERE id = '".$this->input->get('id')."'";
		 $data['reply'] = $this->db->query($sql)->row_array();
		 $this->load->view("admin/editreply",$data);
		 }
		 else
		 	echo "Invalid data supplied";
 }
 // removing reply here
 function removereply()
 {
	 $sql = "DELETE FROM notes_reply WHERE id = '".$this->input->post('id')."'";
	 $this->db->query($sql);
	 }
 // updating reply here
 function updatereply()
 {
	  $sql = "UPDATE notes_reply SET reply = '".$this->input->post('note')."' WHERE id = '".$this->input->post('id')."'";
	  $this->db->query($sql);
	  $data['success'] = true;
	  echo json_encode($data);
	 }

   function job_comment($job_id){
              $data = array();

		$data['job_id'] = $job_id;

		$this->load->library("job");
		$this->load->helper("text");
		$this->load->helper("thumbnail_helper");
		if($job_id=='') { redirect('admin/error?e=job_id'); }

		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
                
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
				if($data['job']['job_type_id'] == 8 ) { $data['titlejob'] = 'Electrical Pre-install'; }
                if($data['job']['job_type_id'] == 6 ) { 
                    $data['titleshow'] = 'PreLag';
                    $data['job']['job_type']='PreLag';
                }
                if($data['job']['job_type_id'] == 7 ) {
                    $data['titleshow'] = 'Premeasure';
                    $data['job']['job_type']='Premeasure';
                }
                $data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] = $jobtimelimit1;
                   }

                }
                 $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                if($data['job']['project_designer_id']!="" && $data['job']['project_designer_id']){
                    $show_instaler = explode("," ,$data['job']['project_designer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["enginner"]= implode(", " ,$showinstaller_name);
				 } else {
                    $data["enginner"]= " ";
				}
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        if(isset($userload[0]->first_name) && isset($userload[0]->last_name) )
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                         if(isset($userload[0]->first_name) && isset($userload[0]->last_name) )
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name,users.profile_photo  FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id in (".$this->db->escape($data['job']['id']).",".$data['job']['job_pid'].") AND notes.comment_type = 1 ORDER by created desc ";
		$data['job_notes_design'] = $this->db->query($sql)->result_array();
		
		$sql = "SELECT notes.*, users.first_name, users.last_name,users.profile_photo FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id in (".$this->db->escape($data['job']['id']).",".$data['job']['job_pid'].") AND notes.comment_type = 2 ORDER by created desc ";
		$data['job_notes_installation'] = $this->db->query($sql)->result_array();
		
		$sql = "SELECT notes.*, users.first_name, users.last_name,users.profile_photo  FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id in (".$this->db->escape($data['job']['id']).",".$data['job']['job_pid'].") AND notes.comment_type in (3,99) ORDER by created desc ";
		$data['job_notes_admin'] = $this->db->query($sql)->result_array();
        
		$sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_type_id not in (6,7,8,15) AND jobs.job_pid=".$data['job']['job_pid']." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();
		
		$plopt = array(1=>'Postponed - Roofing issues',2=>'Postponed - HOA',3=>'Rainout',4=>'Cancelled',6=>"Waiting for HECO approval",5=>'Other');
	 	$data['poption'] = $plopt;
		 $data['admin_comments'] =array();	
    	 $sql = "SELECT * FROM job_reschedule_comment WHERE job_id = '".$job_id."'";
	     $data['admin_comments'] = $this->db->query($sql)->result_array();
		 

		 
		 foreach($this->getCommentType() as $comtype){
		$data['comment_type'][$comtype['id']] = $comtype['comment_type'];
		}
		foreach($this->getRankType() as $ranktype){
		$data['rating_type'][$ranktype['id']] = $ranktype['rank_type'];
		}
		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $install_assign = $data['job']['installer_id'];
                $installer_assign_array = explode("," ,$install_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $data['installer_assign']=array();
                $data['installer_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$installer_assign_array )){
                          $data['installer_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $data['installer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }
                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']<5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $data['editcomment'] = false;
                if ($this->session->userdata("user_id")==$data['job']['user_id']){
                     $data['editcomment'] = true;
                }
                $this->load->view("common/header");
                $this->load->view("admin/job_comment",$data);
                $this->load->view("common/footer");
	
        
  }
 function getJobComment($job_id,$type)
	{
      
		$CI = & get_instance();
                $CI->load->helper("thumbnail_helper");
		$htm = '';
		$sql = 'SELECT job_type_id,jobs.comments,CUS.first_name,CUS.last_name,jobs.created,CUS.profile_photo FROM jobs,users as CUS WHERE jobs.user_id = CUS.id AND jobs.id = '.$job_id;
		$job = $CI->db->query($sql)->row_array();
		
		$htm .= '<table width="100%" border="0" class="detsils">';
		$sql = "SELECT notes.*, users.first_name, users.last_name,users.profile_photo  FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$job_id." AND notes.comment_type = ".$type." ORDER by created desc "; //die();
        $cnt=$CI->db->query($sql)->result_array();
		$i=0;
		if($job['job_type_id']==1 &&  $type==2 && $i==0)
		{
			if($job['profile_photo']!=''){
				$src_path = $job['profile_photo'];
                $img = '<img src="'.thumbnail($src_path, 45, 45).'" />';
		} else {
				$img = '<img src="'.base_url().'/assets/images/noprofile.jpg" width="30" height="30" />';
		}
                
			$htm = '
                                              <tr>
                                                <td width="8%">'.$img.'</td>
                                                <td width="92%"><strong>Date Posted:</strong>'.date("M d, Y g:i a",strtotime($job['created'])).' <strong>, By:</strong> '.$job['first_name'].' '.$job['last_name'].'
                                                '.substr($job['comments'],0,1000).'</td>
                                              </tr>';
			}
		foreach($CI->db->query($sql)->result_array() as $val)
		{
			
		
                 if($val['profile_photo']!=''){
				$src_path = $val['profile_photo'];
                $img = '<img src="'.thumbnail($src_path, 45, 45).'" />';
		} else {
				$img = '<img src="'.base_url().'/assets/images/noprofile.jpg" width="30" height="30" />';
		}
		
			
					  $htm .=           '<tr>
					  							<td width="7.5%" valign="top"><div class="displayImg">'.$img.'</div></td>
												<td width="92.5%" valign="top"><div style="line-height:120%; margin:0; pagging:0;"><strong> Date Posted: '.date("M d, Y g:i a",strtotime($val['created'])).' , By: '.$val['first_name'].' '.$val['last_name'].' 
												, Rating:</strong> <span class="rank'.$CI->getRankTypeById($val['comment_rating']).'">'.$CI->getRankTypeById($val['comment_rating']).'</span>
												 '.substr($val['note'],0,1000).' </div></td>
											  </tr>';
                    $sql = "SELECT REPLY.*,USER.first_name,USER.last_name,USER.profile_photo from notes_reply AS REPLY,users AS USER WHERE USER.id = REPLY.user_id AND comment_id = '".$val['id']."'";// die();
	             	$res = $CI->db->query($sql)->result_array();
		            if(count($res)>0){
						$htm .=	'<tr><td colspan="3">';
					    $htm .= $this->getCommentReply($val['id']);			
						$htm .='</td></tr>';
		            }
					$i++;					
			}
			$htm .= '</table>';
			return $htm;
	}
 
  function createswhpdf($jobid){
   $html = $this->load->view("admin/SWHpdf.php",'',true);

   $j = array();
   include("/var/www/vhosts/aeihawaii.com/httpdocs/MPDF531/mpdf.php");
   $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
                        customers.email,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			customers.home_phone,
                        customers.secondary_phone,
                        customers.association,
                        customers.sun_zone,
                        customers.heco_account_number,
                        customers.heco_meter_number,
                        customers.neighborhood,
                        customers.household_members,
                        job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($jobid)."
		";


	 $data = $this->db->query($sql)->row_array();
           $sql = "SELECT * FROM swhproposal WHERE id = '".$data['proposal_id']."'";
			        $data['proposal'] =  $this->db->query($sql)->row_array();
   $userload = $this->getuser($data['user_id']);
   $customername = $data['first_name']." ".$data['last_name'];
   $username = $userload[0]->first_name." ".$userload[0]->last_name;
   $html = str_replace("{salesman_name}" ,$username ,$html);
   $customername_pdf = $data['first_name']."-".$data['last_name'].".pdf";
   /* Customer Information*/
    
   $html = str_replace("{customer_name}" ,$customername ,$html);
   $html = str_replace("{address_customer}" ,$data['address'] ,$html);
   $html = str_replace("{city_customer}" ,$data['city'] ,$html);
   $html = str_replace("{zipcode_customer}" ,$data['zip_code'] ,$html);
   $html = str_replace("{email_customer}" ,$data['email'] ,$html);
   $html = str_replace("{telephone_customer}" ," ' ".$data['home_phone']." '".$data['secondary_phone'] ,$html);
   $html = str_replace("{assoc_customer}" ,$data['association'], $html);
   $html = str_replace("{cust_neigh}" ,$data['neighborhood'], $html);
   $html = str_replace("{job_residents}" ,$data['household_members'], $html);
   if ($data['proposal']['qoute_heep_rebate']==1) {
    $html = str_replace("{heep_reb}" ,"Applied",$html);
   }else {
   $html = str_replace("{heep_reb}" ,"",$html);
   }
   $html = str_replace("{job_needelec}" ,$this->changevalue($data['elec_insp_quote']), $html);
   $html = str_replace("{job_reason}" ,$data['elec_comments'], $html);
   $html = str_replace("{job_gfi}" ,$this->changevalue($data['gutter_installation']), $html);
   $html = str_replace("{job_retank}" ,$this->changevalue($data['relocate_old_tank']), $html);
   $html = str_replace("{job_drin}" ,$data['tank_distance']." ft" , $html);
   $html = str_replace("{job_pcn}" ,$this->changevalue($data['tilt_kit_needed']), $html);

   $html = str_replace("{cust_zone}" ,$data['sun_zone'], $html);
   $html = str_replace("{design_comment}" ,$this->getJobComment($this->db->escape($data['job_pid']),1),$html);
    $html = str_replace("{install_comment}" ,$this->getJobComment($this->db->escape($data['job_pid']),2),$html);
    $html = str_replace("{admin_comment}" ,$this->getJobComment($this->db->escape($data['job_pid']),3),$html);
    $html = str_replace("{reschedule_comment}" ,$this->getJobComment($this->db->escape($data['job_pid']),4),$html);
   if($data['job_date']){
    $html = str_replace("{installdate_customer}" ,date("F jS, Y ",strtotime($data['job_date'])) ,$html);
   }else{
    $html = str_replace("{installdate_customer}" ,"Unscheduled Job" ,$html);
   }
   $html = str_replace("{dow_customer}" ,date("l",strtotime($data['job_date'])) ,$html);


   /* job specification */
   $html = str_replace("{job_tanksize}" ,$this->getidothervalue($data['tank_size_id'] ,$data['other_tank_size'] ,'tank_sizes' ,'size') ,$html);
	 $html = str_replace("{job_topanels}" ,$this->getidothervalue($data['panel_type_id'] ,$data['other_panel_type'] ,'panel_types' ,'type') ,$html);
          $html = str_replace("{it_type}" ,$this->getidothervalue($data['installation_type_id'] ,$data['other_installation_type'] ,'installation_types' ,'type') ,$html);

   $html = str_replace("{job_nopanels}" ,$data['panel_count'] ,$html);


	 $html = str_replace("{job_sizepanels}" ,$this->getidothervalue($data['panel_size_id'] ,$data['other_panel_size'] ,'panel_sizes' ,'size') ,$html);

	 $html = str_replace("{job_gasheater}" ,$data['heater_location'] ,$html);
	 $html = str_replace("{job_loexistheater}" ,$data['existing_heater_location'] ,$html);


	 if($data['remove_old_tank']=="y")
       $data['remove_old_tank'] = "Yes";
   else
       $data['remove_old_tank'] = "No";

	 $html = str_replace("{job_rotank}" , $data['remove_old_tank'] ,$html);

	  if($data['relocate_old_tank']=="y")
       $data['relocate_old_tank'] = "Yes";
   else
       $data['relocate_old_tank'] = "No";

	 $html = str_replace("{job_rotank}" , $data['relocate_old_tank'] ,$html);

	   if($data['relocate_old_tank']=="y")
       $data['relocate_old_tank'] = "Yes";
   else
       $data['relocate_old_tank'] = "No";

	 $html = str_replace("{job_tankaccess}" , $this->changevalue($data['solar_tank_accessible']) ,$html);
	 $html = str_replace("{job_sprd}" ,$this->getidothervalue($data['piperun_length'] ,$data['otherpiperun_length'] ,'pipe_run_distance' ,'type')." ft"  ,$html);
   $html = str_replace("{job_tpr}" ,$this->getidothervalue($data['piperun_type_id'] ,$data['other_piperun_type'] ,'piperun_types' ,'type') ,$html);
	 $html = str_replace("{job_or}" ,$data['roof_orientation'] ,$html);
	 $html = str_replace("{job_pr}" ,$data['roof_pitch'] ,$html);

	 $html = str_replace("{rt_job}" ,$this->getidothervalue($data['roof_type_id'] ,$data['roof_type_id'] ,'roof_types' ,'type') ,$html);

	 $html = str_replace("{rmt_job}" ,$this->getidothervalue($data['rafter_type_id'] ,$data['other_rafter_type'] ,'rafter_types' ,'type') ,$html);
        $html = str_replace("{dbr_job}" ,$data['rafter_distance']." ft"  ,$html);


	 $html = str_replace("{job_colorroof}" ,$data['roof_color'] ,$html);
	 $html = str_replace("{nof_job}" ,$data['stories'] ,$html);
         if($data['pump_type_id']==1){
            $data['pump_type_id'] = 'DC';
         }else if($data['pump_type_id']==2){
            $data['pump_type_id'] = 'AC';
         }
         $html = str_replace("{job_top}" ,$data['pump_type_id'] ,$html);



   $contractor = $data['contractor_id'];
   $temp =explode(",",$contractor);
   $cnamei = array();
   foreach($temp as $c=>$v) {
    $cnamei[] = $this->getUserIntial($v,true);
   }
   /* Electric  specification */

   $html = str_replace("{un_elec}" ," ",$html);
   
   $html = str_replace("{comment_elec}" ,$data['comments'] ,$html);


   $sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['customer_id'])." AND jobs.id!=".$this->db->escape($jobid)." ORDER BY jobs.job_date ASC";


         $otherjob = array();
	 $other_jobs = $this->db->query($sql)->result_array();
         $other_data = "";
         foreach ($other_jobs as $key => $value){
	  $other_data .='<a href="'.base_url().'admin/job/'.$value['id'].'">'.$value['job_type'].'('.date("M j, Y",strtotime($value['job_date'])).')</a><br />';
	 }
	 $html = str_replace("{job_others}" ,$other_data , $html);

	 $img = "";

	  $img = "";
   $sql = "SELECT * FROM meter_files WHERE job_id=$jobid AND is_export=1 AND mime in ('image/jpg' ,'image/jpeg' ,'image/png', 'image/gif' )";
   $plan_files = array();
   $plan_files = $this->db->query($sql)->result_array();

   $htmlappend ="";
   $count = 1;
   if(count($plan_files)){
       foreach ($plan_files as $key => $value){
           if ($count == 1 || $count%2 == 1){
            $htmlappend .='<pagebreak />';
            $htmlappend .='<table cellpadding="0" cellspacing="0" align="center" width="100%">';
           }
             $htmlappend .='<tr>
                    <td></td>
                    <td align="left" width="40%">{planimages_'.$count.'}  </td>
                    </tr>
                ';
             if ($count == 1 || $count%2 == 1){
                $htmlappend .='</table>';
             }
        $count = $count + 1;
       }
       $html = str_replace("{strimage}" , $htmlappend ,$html);
       $count = 1;
       foreach ($plan_files as $key => $value){
        $img = "<img src='".base_url()."uploads/".$value['unique_filename']."' /><br/><br/>"; // Read the file's contents
        $html = str_replace("{planimages_".$count."}" , $img ,$html);
        $count = $count + 1;
        }

   }else{
       $html = str_replace("{strimage}" , "" ,$html);
   }
   
       $html = str_replace("{strimage}" , $htmlappend ,$html);
    

   $this->db->where("job_id",$jobid);
   $this->db->order_by("created","desc");
   $mpdf=new mPDF('s');
   $mpdf->SetDisplayMode('fullpage');
   $mpdf->WriteHTML($html);
   $data =$mpdf->Output($customername_pdf,'D');

   }
   function tabstatusjob($job_id){
  $this->load->library("job");
  $this->load->helper("text");
  $json['finaceclass'] = $this->job->getfinancetabclass($job_id);
  $json['customerclass'] = $this->job->getcustomertabclass($job_id);
  $json['jobclass'] = $this->job->getjobtabclass($job_id,'active');
  $json['fileclass'] = $this->job->getfiletabclass($job_id);
  $json['percent_completed'] = $this->job->percent_completed($job_id);
  echo json_encode($json);
  }
   function tabstatusfile($job_id){
  $this->load->library("job");
  $this->load->helper("text");
  $json['finaceclass'] = $this->job->getfinancetabclass($job_id);
  $json['customerclass'] = $this->job->getcustomertabclass($job_id);
  $json['jobclass'] = $this->job->getjobtabclass($job_id);
  $json['fileclass'] = $this->job->getfiletabclass($job_id,'active');
  $json['percent_completed'] = $this->job->percent_completed($job_id);
  echo json_encode($json);
  }
  function tabstatusfinance($job_id){
  $this->load->library("job");
  $this->load->helper("text");
  $json['finaceclass'] = $this->job->getfinancetabclass($job_id,'active');
  $json['customerclass'] = $this->job->getcustomertabclass($job_id);
  $json['jobclass'] = $this->job->getjobtabclass($job_id);
  $json['fileclass'] = $this->job->getfiletabclass($job_id);
  $json['percent_completed'] = $this->job->percent_completed($job_id);
  echo json_encode($json);
  }
  function tabstatuscustomer($job_id){
  $this->load->library("job");
  $this->load->helper("text");
  $json['finaceclass'] = $this->job->getfinancetabclass($job_id);
  $json['customerclass'] = $this->job->getcustomertabclass($job_id,'active');
  $json['jobclass'] = $this->job->getjobtabclass($job_id);
  $json['fileclass'] = $this->job->getfiletabclass($job_id);
  $json['percent_completed'] = $this->job->percent_completed($job_id);
  echo json_encode($json);
  }
 
  function tabstatusgenral($job_id){
  $this->load->library("job");
  $this->load->helper("text");
  $json['finaceclass'] = $this->job->getfinancetabclass($job_id);
  $json['customerclass'] = $this->job->getcustomertabclass($job_id);
  $json['jobclass'] = $this->job->getjobtabclass($job_id);
  $json['fileclass'] = $this->job->getfiletabclass($job_id);
  $json['percent_completed'] = $this->job->percent_completed($job_id);
  echo json_encode($json);
  }
 function getparentjobid($job_id){
   $resultcnt =  $this->db->query("SELECT job_pid FROM jobs  where id = $job_id")->result_array();
   $pid = $resultcnt[0]['job_pid'];
   if(!$pid){
    $pid =$job_id;
   }
   return $pid;
 }
 function job_file($job_id,$file_type=3){
    
    $data = array();

		$data['job_id'] = $job_id;
                $data['file_type']=$file_type;

		$this->load->library("job");
		$this->load->helper("text");

		if($job_id=='') { redirect('admin/error?e=job_id'); }

		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();

		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
				if($data['job']['job_type_id'] == 8 ) { $data['titlejob'] = 'Electrical Pre-install'; }
                if($data['job']['job_type_id'] == 6 ) { 
                    $data['titleshow'] = 'PreLag';
                    $data['job']['job_type']='PreLag';
                }
                $data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                $data['fileclass'] = $this->job->getfiletabclass($job_id,'active');
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        $showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }

		 if($data['job']['project_designer_id']!="" && $data['job']['project_designer_id']){
                    $show_instaler = explode("," ,$data['job']['project_designer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["enginner"]= implode(", " ,$showinstaller_name);
				 } else {
                    $data["enginner"]= " ";
		}
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $install_assign = $data['job']['installer_id'];
                $installer_assign_array = explode("," ,$install_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $data['installer_assign']=array();
                $data['installer_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$installer_assign_array )){
                          $data['installer_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $data['installer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                    }
                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']<5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $this->load->view("common/header");
                $data['error'] = '';
                 if($data['job']['created']>'2012-08-20')
                  $this->load->view("admin/job_file",$data);    
                else
                 $this->load->view("admin/job_file_old",$data);
                $this->load->view("common/footer");
  }
  public function do_upload($job_id,$file_type=3) {
         $this->load->helper("thumbnail_helper");
	$upload_path_url = base_url()."uploads/";
	$config['upload_path'] = FCPATH.'uploads/';
        $config['encrypt_name'] = true;
        if ($file_type==FILE_TYPE_METER || $file_type==FILE_TYPE_ROOF){
          $config['allowed_types'] = 'jpg|jpeg|png|gif';
        }else {
         //$config['allowed_types'] = 'pdf|docx|doc|txt|jpg|jpeg|png|gif';
            $config['allowed_types'] = 'jpg|jpeg|png|gif';
        }
		if($file_type==4){
            $config['allowed_types'] = 'pdf';
        }
       // $config['allowed_types'] = 'gif|jpg|png';
        $config['max_size'] = 10485760;
       
  	$this->load->library('upload', $config);
        
        if ( !$this->upload->do_upload()){
            
            $error = array('error' => $this->upload->display_errors());
           
            $this->load->view('admin/error_file', $error);
  	}
  	else {
	   $data = $this->upload->data();
           $new_base_url=explode("/dev",base_url());
           if(count($new_base_url)>1){
              $srcpath=FCPATH . 'uploads/'.$data['file_name'];
              $despath='/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/uploads/'.$data['file_name'];
              if(!copy($srcpath,$despath)){
                  die("image problem");
              }
           }
           $row['original_filename'] = $data['orig_name'];
           $row['unique_filename'] = $data['file_name'];
           $row['mime'] = $data['file_type'];
           $row['created'] = date("Y-m-d h:i:s");
           $pid_job = $this->getparentjobid($job_id);
           $row['job_id'] = $pid_job;
           $row['file_size']= $data['file_size']*1024;
           $row['file_type']=$file_type;
           $row['title'] = $data['orig_name'];
           $row['desc'] =  $data['orig_name'];
           $this->db->insert("meter_files",$row);
           $this->load->helper('text');
           $file_id = $this->db->insert_id();
           @$info->name = @$data['orig_name'];
           $info->size = $data['file_size']*1024;
           $info->type = $data['file_type'];
           $info->url =  $upload_path_url .$data['file_name'];
           $info->imagedetailurl = base_url().'admin/filedetails'."/".$file_id;
           if ($data['file_type']=="image/jpeg" || $data['file_type']=="image/jpeg" || $data['file_type']=="image/png" || $data['file_type']=="image/gif" ) {
               $rowp['spmsip_job']= 'yes';
               $this->db->where('id', $job_id);
               $this->db->update('jobs', $rowp);
               $info->thumbnail_url = thumbnail($data['file_name'], 50, 50) ;//I set this to original file since I did not create thumbs.  change to thumbnail directory if you do = $upload_path_url .'/thumbs' .$data[file_name]
           } else if($data['file_type']=="application/pdf" ||$data['file_type']== '"application/pdf"' ){
                $info->thumbnail_url = base_url()."/assets/images/file_pdf.ico";
           } else if($data['file_type']=="text/plain" || $data['file_type']=="application/msword"){
               $info->thumbnail_url = base_url()."/assets/images/doc_files.ico";
           }
           $info->delete_url = base_url().'admin/deleteImage/'.$data['file_name']."/".$file_id;
           $info->delete_type = 'DELETE';
           echo json_encode(array($info));
           exit;
           if (IS_AJAX) {   //this is why we put this in the constants to pass only json data
                   
	           
                    //this has to be the only the only data returned or you will get an error.
                    //if you don't give this a json array it will give you a Empty file upload result error
                    //it you set this without the if(IS_AJAX)...else... you get ERROR:TRUE (my experience anyway)
                      }
	else {   // so that this will still work if javascript is not enabled
		  	$file_data['upload_data'] = $this->upload->data();
		  	$this->load->view('admin/upload_success', $file_data);
		}

	 }

}

public function deleteImage($file,$file_id=0)//gets the job done but you might want to add error checking and security
	{
		if(!$file){
                    $sql = "SELECT * FROM  meter_files WHERE id=".$file_id;
                    $data = $this->db->query($sql)->row_array();
                    $file  = $data['unique_filename'];
                }
                if($file_id){
                 $this->db->where("id",$file_id);
                 $this->db->delete('meter_files');
                }
                
                $success =@unlink(FCPATH.'uploads/' .$file);
		//info to see if it is doing what it is supposed to
		$info->sucess =$success;
		$info->path =base_url().'uploads/' .$file;
		$info->file =is_file(FCPATH.'uploads/' .$file);
	if (IS_AJAX) {//I don't think it matters if this is set but good for error checking in the console/firebug
	    echo json_encode(array($info));}
	else {     //here you will need to decide what you want to show for a successful delete
		redirect("admin/fileview_job/".$data['job_id']."?savedata=1");
	   }
}
public function deletemeterImage($file_id,$job_id){
    $row=array();
    $row['is_delete']= 1;
    $row['delete_by_userid']=$this->session->userdata('user_id');
    $row['deletion_time']=date('Y-m-d g:i');
    $this->db->where("id",$file_id);
    $this->db->update('elecphoto_files',$row);
    redirect("admin/fileview_job/".$job_id."?savedata=1");
 }
public function filedetails($file_id, $reload=0){
  $data['file_id']= $file_id;
  if($file_id){
     $sql = "SELECT * FROM  meter_files WHERE id=".$file_id;
     $data['file'] = $this->db->query($sql)->row_array();
  }
  $data['reload'] = $reload;
  $this->load->view('admin/filedetails', $data);
}

public function meterfiledetails($file_id, $reload=0){
  $data['file_id']= $file_id;
  if($file_id){
     $sql = "SELECT * FROM  elecphoto_files WHERE id=".$file_id;
     $data['file'] = $this->db->query($sql)->row_array();
  }
  $data['reload'] = $reload;
  $this->load->view('admin/imagefiledetails', $data);
}
public function  savemeterfiledetails($file_id){
  $data['file_id']= $file_id;
  $row['title'] = $this->input->post("title");
  $row['desc'] = $this->input->post("desc");
  $this->db->where("id",$file_id);
  $this->db->update("elecphoto_files",$row);
  $json['success'] = true;
  echo json_encode($json);
}
public function  savefiledetails($file_id){

$data['file_id']= $file_id;
  $row['title'] = $this->input->post("title");
  $row['desc'] = $this->input->post("desc");
  $this->db->where("id",$file_id);
  $this->db->update("meter_files",$row);
  $json['success'] = true;
  echo json_encode($json);
}
function fileview_job($job_id){
     $data = array();

		$data['job_id'] = $job_id;

		$this->load->library("job");
		$this->load->helper("text");
                $this->load->helper("thumbnail_helper");

		if($job_id=='') { redirect('admin/error?e=job_id'); }

		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();

		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }

               
                
		$data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
				if($data['job']['job_type_id'] == 8 ) { $data['titlejob'] = 'Electrical Pre-install'; }
                if($data['job']['job_type_id'] == 6 ) { $data['titleshow'] = 'PreLag'; }
                if($data['job']['job_type_id'] == 7 ) { $data['titleshow'] = 'Premeasure'; }
                $data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] =$jobtimelimit1;
                   }

                }
		// daily job limit
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);

                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                       @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }

      if($data['job']['project_designer_id']!="" && $data['job']['project_designer_id']){
                    $show_instaler = explode("," ,$data['job']['project_designer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["enginner"]= implode(", " ,$showinstaller_name);
				 } else {
                    $data["enginner"]= " ";
				}
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		$sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_type_id not in (6,7,8,15) AND jobs.job_pid=".$data['job']['job_pid']." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();

		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		$data["file_options"]=array();
                $where_id="";
                if($data['job']['subpanel_exist']!='y' ){
                   $where_id=" AND id!=2" ;
                 }
                $data_files_option=$this->db->query("SELECT * from file_options where 1 AND 1  $where_id")->result_array();
                foreach($data_files_option as $dfo){
                  $data["file_options"][$dfo["id"]]=$dfo["file_options"];    
                }
                
               $data["roof_file_options"] =array("1"=>"Rooftype Confirmation", "2"=>"Array Location on Roof",'3'=>'Other');
                
                // grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
                $pid_job = $this->getparentjobid($job_id);
                $this->db->where("job_id",$pid_job);
		$this->db->order_by("created","desc");
		$data['files'] = $this->db->get("meter_files")->result_array();

                $install_assign = $data['job']['installer_id'];
                $installer_assign_array = explode("," ,$install_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $data['installer_assign']=array();
                $data['installer_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$installer_assign_array )){
                          $data['installer_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $data['installer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                    }
                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']<5 && $data['percent_completed']!=100){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
                $pid = $pid_job;
                
                $this->db->where("job_id",$pid);
                $this->db->where("file_type",1);
                $data['meter_files']=array();
		$data['meter_files']=$this->db->get("meter_files")->result_array();
                $this->db->where("job_id",$pid);
                $this->db->where("file_type",1);
                $this->db->where("image_id",0);
                $data['cmeter_files']=array();
		$data['cmeter_files']=$this->db->get("meter_files")->result_array();
                $totalcount=count($data['cmeter_files']);
                $requiredphoto=array();
                if($data['job']['subpanel_exist']!='y'){
                   $where_id=" AND id!=2" ;
                }
                
                $sql = "SELECT * FROM file_options WHERE  id not in (SELECT image_id from meter_files  WHERE  file_type=".FILE_TYPE_METER." AND job_id=$pid_job) $where_id ";
                $result = $this->db->query($sql)->result_array();
                $mcount=0;
                $data["requiredphoto"]=array();
                if(count($result)>=1){
                    foreach($result as $tdata){
                      $mcount++;
                      if($mcount<=$totalcount) continue;
                      $data["requiredphoto"][] = array("id"=>$tdata['id']);
                      
                    }
                }
                
                $this->db->where("job_id",$pid);
                $this->db->where("file_type",2);
                $data['roof_files'] =array();
		$data['roof_files'] = $this->db->get("meter_files")->result_array();
                $data["roofphotorequired"] = array("1"=>"Rooftype Confirmation", "2"=>"Array Location on Roof");
                $sql = "SELECT image_id from meter_files WHERE  file_type=".FILE_TYPE_ROOF." AND job_id=$pid_job ";
                $result = $this->db->query($sql)->result_array();
                $rcount=1;
                if(count($result)>=1){
                    
                    foreach($result as $tdata){
                      unset($data["roofphotorequired"][$tdata['image_id']]);
                      $rcount++;
                    }
                }
                
                if($rcount==3) $data["roofphotorequired"]=array();
                $this->db->where("job_id",$pid);
                $this->db->where("file_type",3);
                $data['other_files'] =array();
		$data['other_files'] = $this->db->get("meter_files")->result_array();

		     $this->db->where("job_id",$pid);
             $this->db->where("file_type",4);
             $data['pdf_files'] =array();
		     $data['pdf_files'] = $this->db->get("meter_files")->result_array();

                
                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",1);
                $this->db->where("is_delete",0);
		$data['elec_photo_1'] = $this->db->get("elecphoto_files")->row_array();
              
                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",2);
		$this->db->where("is_delete",0);
		$data['elec_photo_2'] = $this->db->get("elecphoto_files")->row_array();

                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",3);
		$this->db->where("is_delete",0);
		$data['elec_photo_3'] = $this->db->get("elecphoto_files")->row_array();

                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",4);
		$this->db->where("is_delete",0);
		$data['elec_photo_4'] = $this->db->get("elecphoto_files")->row_array();

                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",5);
		$this->db->where("is_delete",0);

                $data['elec_photo_5'] = $this->db->get("elecphoto_files")->row_array();
                $this->db->where("job_id",$pid);
		

                $data['elecphoto_allfiles'] = $this->db->get("elecphoto_files")->row_array();

                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",6);
		$this->db->where("is_delete",0);
		$data['elec_photo_6'] = $this->db->get("elecphoto_files")->row_array();

                $this->db->where("job_id",$pid);
                $this->db->where("photo_id",7);
		$this->db->where("is_delete",0);
		$data['elec_photo_7'] = $this->db->get("elecphoto_files")->row_array();

                $this->db->where("id",1);
                $data['elec_photo_desc'] = $this->db->get("globalconfig")->row_array();

                $data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $this->load->view("common/header");
                if($data['job']['created']>'2012-08-20')
                $this->load->view("admin/fileview",$data);
                else
                $this->load->view("admin/fileview_old",$data);
                $this->load->view("common/footer");
}
 function showimage($file_id){
     $this->load->helper("thumbnail_helper");
     echo  "<style>#facebox .footer {
      border-top: none !important;
     }</style>";
     $new_base_url=explode("/dev",base_url());
     if(count($new_base_url)>1){
        $new_base_url_m=$new_base_url[0]."/scheduler/";
     }else{
         $new_base_url_m=base_url();
     }
   if($file_id) {
     $sql = "SELECT * FROM  meter_files WHERE id=".$file_id;
      $data['file'] = $this->db->query($sql)->row_array();
      $imageexplode=explode("image",$data['file']['mime']);
      if (count($imageexplode)<=1){ return ;}
      
     $imagedim = getimagesize($_SERVER['DOCUMENT_ROOT']."/scheduler/uploads/".$data['file']['unique_filename']);

     if ($imagedim[1]<=800 ||$imagedim[0]<=600){
        echo  '<script>$("#facebox").css("width:'.$imagedim[0].';left:200px;");</script><img src="'.$new_base_url_m.'/uploads/'.$data['file']['unique_filename'].'"   />';

     } else {
        echo  '<script>$("#facebox").css("width:800px;left:200px;");</script><img src="'.thumbnail($data['file']['unique_filename'], 800, 600).'"   />';
     } 
 }
 }
 function showimagemeter($file_id){
     $this->load->helper("thumbnail_helper");
     echo  "<style>#facebox .footer {
      border-top: none !important;
     }</style>";
     $new_base_url=explode("/dev",base_url());
     if(count($new_base_url)>1){
        $new_base_url_m=$new_base_url[0]."/scheduler/";
     }else{
         $new_base_url_m=base_url();
     }
   if($file_id) {
     $sql = "SELECT * FROM  elecphoto_files  WHERE id=".$file_id;
     $data['file'] = $this->db->query($sql)->row_array();
     $imageexplode=explode("image",$data['file']['mime']);
     if (count($imageexplode)<=1){ return ;}
        $imagedim = getimagesize($_SERVER['DOCUMENT_ROOT']."/scheduler/uploads/".$data['file']['unique_filename']);
     if ($imagedim[0]<=700 ||$imagedim[0]<=800){
        echo  '<img src="'.$new_base_url_m.'uploads/'.$data['file']['unique_filename'].'"   />';
     } else{
               echo  '<img src="'.thumbnail($data['file']['unique_filename'], 700, 800).'"  />';
     }
 }
 }

function scheduleprint($year='',$month=''){
    if($year=='') {
        $year = date("Y");
    }
    if($month=='') {
        $month = date("m");
        $year = preg_replace("/[^0-9]/","",$year);
	$month = preg_replace("/[^0-9]/","",$month);
    }
    $data['year'] = $year;
    $data['month'] = $month;
    $j = array();
    $jobs = array();
    
    $j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id ,users.first_name as ufirstname , 
            users.last_name ulastname, cs.first_name as csfirstname ,
            cs.last_name as cslastname ,cs.address as csstate,cs.city as cscity,cs.association as  csassociation,
            job_types.intials as job_type
            FROM jobs 
            LEFT JOIN job_types ON job_types.id=jobs.job_type_id
            LEFT JOIN  customers cs ON jobs.customer_id = cs.id  
            LEFT JOIN users ON jobs.user_id=users.id 
            LEFT JOIN colors ON users.color_id=colors.id 
            WHERE DATE_FORMAT(jobs.job_date,'%Y-%m') = '".$year."-".$month."' ORDER BY jobs.job_date ASC")->result_array();
    
     $this->db->where("type","installer");
     $this->db->order_by("first_name","desc");
     $installeruser = $this->db->get("users")->result_array();
     $installer_data = array();
     
     foreach($installeruser as $rowdata){
      $installer_data[] = $rowdata['id'];

    }
    $r_jobsplit = $this->db->query("select  job_pid ,count(job_pid) as cntjob from jobs where id!=job_pid group by job_pid ")->result_array();
    $rsplitjob = array();
    foreach($r_jobsplit as $key1 => $value1){
        $rsplitjob[$value1["job_pid"]]= $value1["cntjob"]; 
    }
    $arr_splitjob= array();
    foreach($j as $key => $value){
     $conductid_arr = array();
     
     if(array_key_exists($value["job_pid"],$rsplitjob)){
       if (in_array($value["job_pid"],$arr_splitjob)){
           $temp_array = array();
           $temp_array = array_keys($arr_splitjob,$value["job_pid"]);
           if(count($temp_array)==1){
            $value['cslastname'].= " <br/>(Day 2) ";   
           }
           if(count($temp_array)==2){
            $value['cslastname'].= " <br/>(Day 3) ";   
           }
           $arr_splitjob[] =$value["job_pid"];
           
       }else{
            $value['cslastname'].= " <br/>(Day 1) "; 
            $arr_splitjob[] = $value["job_pid"];
       }
       
        /*if ($value["job_pid"]==$value["id"]){
            $value['cslastname'].= " (Day 1) "; 
        }else if ($rsplitjob[$value["job_pid"]]==1){
           $value['cslastname'].= " (Day 2)"; 
        }else if ($rsplitjob[$value["job_pid"]]>1){
          $value['cslastname'].= $this->splitjobday($value["job_pid"],$value["job_date"]) ; 
        } */  
     }
     if($value['conduit_id']){
     $conductid_arr = explode(",",$value['conduit_id']);
     $value['conduit_id']  = '';
     $temp = array();
     foreach ($conductid_arr as $arr){
        $temp[]= $this->getUserEmpNo($arr);
     }
     $value['conduit_id']= implode(",",$temp )    ;
     } else{
         $value['conduit_id']  = '';
     }
     if($value['contractor_id']){
        $contractor_arr = array();
        $contractor_arr = explode(",",$value['contractor_id']);
        $value['contractor_id']  = '';
        $temp = array();
        foreach ($contractor_arr as $arr){
          $temp[] = $this->getUserIntial($arr);
        }
        $value['contractor_id']  = implode(",",$temp); 
     }


        $installer_id_table = array();
        $installer_id_table = explode(",",$this->getdayinstaller($value['job_date']));
        
        $noassignedinstaller = array_diff($installer_data,$installer_id_table );
        $newnoassign = array();
        foreach($noassignedinstaller as $id){
          $newnoassign[] = $this->getUserEmpNo($id);
        }
       
        $value['off'] = implode(",",$newnoassign);
        $installer_no = explode(",",$value['installer_id']);

        $newinsatller_no = array();
        foreach($installer_no as $id){
          $newinsatller_no[] = $this->getUserEmpNo($id);
        }
        $temp = implode(",",$newinsatller_no);
        if($temp){
        $value['installer_id'] = $temp;
        } else{
            $value['installer_id'] = "";
        }
        $value['roof_type_id'] = $this->getidothervalue($value['roof_type_id'] ,$value['other_roof_type'] ,'roof_types' ,'type');
        $value['jobs_emt'] = $this->getidothervalue($value['jobs_emt'] ,$value['other_jobs_emt'] ,'electric_wire_type' ,'type');
        $jobs[date("j", strtotime($value['job_date']))][] = $value;

    }
    $data["j"] = $j;
    $data["jobs"] = $jobs;
    $this->load->view("admin/printschedule",$data);
 }
  function printyearmonth(){
      $data['calendar_months'] = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
      $data['calendar_years'] = array();
      for($i=date("Y",strtotime("-2 years")); $i<date("Y",strtotime("+2 years")); $i++){
	$data['calendar_years'][$i] = $i;
      }
      $this->load->view("admin/printyearmonth",$data);
  }
  function getdayinstaller($job_date){
     $rs = $this->db->query("SELECT installer_id FROM jobs WHERE  job_date='$job_date' ")->result_array();
     $temp = array();
     foreach ($rs as $key=>$value){
        $temp[] = $value['installer_id'];
     }
     if(count($temp)){
       return implode(",",$temp);
     }

  }
  function splitjobday($job_id,$job_date){
     $rs = $this->db->query("SELECT count(*) as cntjob FROM jobs WHERE job_pid=$job_id && job_date<'$job_date' ")->result_array();
     if ($rs[0]["cntjob"]>0){
        return "(Day 3)";           
     } else {
       return "(Day 2)";   
     }
  }
  function permit_job($job_id){
    $data = array();
    
		$data['job_id'] = $job_id;

		$this->load->library("job");
		$this->load->helper("text");

		if($job_id=='') { redirect('admin/error?e=job_id'); }

		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();

		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
				if($data['job']['job_type_id'] == 8 ) { $data['titlejob'] = 'Electrical Pre-install'; }
                if($data['job']['job_type_id'] == 6 ) { $data['titleshow'] = 'PreLag'; }
                if($data['job']['job_type_id'] == 7 ) { $data['titleshow'] = 'Premeasure'; }
                
                $data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit

                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] = $jobtimelimit1;
                   }

                }
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);

                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
                if($data['job']['contractor_id']!="" && $data['job']['contractor_id']){
                    $show_instaler = explode("," ,$data['job']['contractor_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showelectrican"]= implode(", " ,$showinstaller_name);
                } else {
                    $data["showelectrican"]= " ";
                }

	    if($data['job']['project_designer_id']!="" && $data['job']['project_designer_id']){
                    
                    $show_instaler = explode("," ,$data['job']['project_designer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["enginner"]= implode(", " ,$showinstaller_name);
         } else {
                    $data["enginner"]= " ";
          }
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

			
		$sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_type_id not in (6,7,8,15) AND jobs.job_pid=".$data['job']['job_pid']." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();

       $sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_type_id not in (6,7,8,15) AND jobs.job_pid=".$data['job']['job_pid']." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();
		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();

		$pid = $this->getparentjobid($job_id);
        
		$this->db->where("job_id",$pid);
        $this->db->where("type",'nemstatus');
        $this->db->order_by("created","desc");
        $data['permit_file_nemstatus'] = array();
		$data['permit_file_nemstatus'] = $this->db->get("permit_files")->result_array();

				// grab job files
		$this->db->where("job_id",$pid);
                $this->db->where("type",'building');
                $this->db->order_by("created","desc");
                $data['permit_file_building'] = array();
		$data['permit_file_building'] = $this->db->get("permit_files")->result_array();
                
                // grab job files
		$this->db->where("job_id",$pid);
                $this->db->where("type",'netmeter');
		$this->db->order_by("created","desc");
                $data['permit_file_netmeter'] = array();
		$data['permit_file_netmeter'] = $this->db->get("permit_files")->result_array();
                
                // grab job files
		$this->db->where("job_id",$pid);
                $this->db->where("type",'homeowner');
		$this->db->order_by("created","desc");
                $data['permit_file_homeowner'] = array();
		$data['permit_file_homeowner'] = $this->db->get("permit_files")->result_array();

		// grab job files
		$this->db->where("job_id",$pid);
        $this->db->where("type",'lineimage');
		$this->db->order_by("created","desc");
        $data['permit_file_lineimage'] = array();
		$data['permit_file_lineimage'] = $this->db->get("permit_files")->result_array();

        // grab job files
		$this->db->where("job_id",$pid);
        $this->db->where("type",'electric');
		$this->db->order_by("created","desc");
        $data['permit_file_electric'] = array();
		$data['permit_file_electric'] = $this->db->get("permit_files")->result_array();

                // grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
        
		$where='( type="warehouse" or type="engineer1" ) AND user_status="active"';
               // $this->db->where("type","engineer");
        $this->db->where($where);
		$this->db->order_by("first_name","desc");
		$designeruser = $this->db->get("users")->result_array();
                $data['designer_user'] = array();
                foreach($designeruser as $row) {
                    $data['designer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }

				$where='( type="engineer" ) AND user_status="active"';
               // $this->db->where("type","engineer");
                $this->db->where($where);
		        $this->db->order_by("first_name","desc");
		        $designeruser = $this->db->get("users")->result_array();
                $data['designer_eng'] = array();
                foreach($designeruser as $row) {
                    $data['designer_eng'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }

                $data['job_statuses'][''] = "- Select a job status -";
                $data['job_statuses']['unscheduled'] = "Unscheduled";
                if($data['job']['job_type_id']!=5){
                  $data['job_statuses']['inprogress'] = "<font color='red'>".$data['percent_completed']."%, ".$data["timediff"]."hrs remaining</font>";
                }
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['final payment'] = "Final Payment";
                $data['job_statuses']['inspections'] = "Inspections";
                $data['job_statuses']['completed'] = "Completed";
                $data['job_statuses']['to be completed'] = "To Be Completed";
                $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
                //$totalinstaller = $this->db->query("SELECT GROUP_CONCAT(installer_id) as totalinstaller FROM jobs   WHERE jobs.job_date = '".$data['job']['job_date']."' GROUP BY jobs.job_date ")->result_array();
		//$data['totalinstallercnt'] = $totalinstaller[0]['totalinstaller'];
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
				if( $data["job"]["job_type_id"]==15 || $data["job"]["job_type_id"]==16 ){
				 $data['acproposal']=$this->db->query("SELECT apply_permit_fee from acproposal where id=".$data["job"]["proposal_id"])->row_array();
				}
                $this->load->view("common/header");
                $this->load->view("admin/job_permit",$data);
                $this->load->view("common/footer");
  }
  
  function createservicepdf($jobid){
  
   $html = $this->load->view("admin/createpdfhtml_service",'',true);
   $j = array();
 // include("C:\wamp\www\sites\\trunk\scheduler\MPDF53\mpdf.php");
   //include("C:\wamp\www\sites\\trunk\scheduler\mergepdf\mergepdf.php");
   include("/var/www/vhosts/aeihawaii.com/httpdocs/MPDF531/mpdf.php");
   include("/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/mergepdf/mergepdf.php");
   $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
                        customers.email,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			customers.home_phone,
                        customers.secondary_phone,
                        customers.association,
                        customers.heco_account_number,
                        customers.heco_meter_number,
                        job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($jobid)."
		";
     $data = $this->db->query($sql)->row_array();
    
     $userload = $this->getuser($data['user_id']);
     $customername = $data['first_name']." ".$data['last_name'];
    $username = $userload[0]->first_name." ".$userload[0]->last_name;
    $html = str_replace("{salesman_name}" ,$username ,$html);
    $customername_pdf = $data['first_name']."-".$data['last_name'].".pdf";
   /* Customer Information*/
   
   $html = str_replace("{customer_name}" ,$customername ,$html);
   $html = str_replace("{address_customer}" ,$data['address'] ,$html);
   $html = str_replace("{city_customer}" ,$data['city'] ,$html);
   $html = str_replace("{zipcode_customer}" ,$data['zip_code'] ,$html);
   $html = str_replace("{email_customer}" ,$data['email'] ,$html);
   $html = str_replace("{telephone_customer}" ,"'".$data['home_phone']." ".$data['secondary_phone']."'" ,$html);
   $html = str_replace("{assoc_customer}" ,$data['association'], $html);
   if($data['job_date']) {
    $html = str_replace("{installdate_customer}" ,date("F jS, Y ",strtotime($data['job_date'])) ,$html);
   }else {
    $html = str_replace("{installdate_customer}" ,"Unscheduled Job" ,$html);
   }
   $html = str_replace("{dow_customer}" ,date("l",strtotime($data['job_date'])) ,$html);

   /* System Information*/
    if($jobid<15824){
        $html = str_replace("{tor}" ,$data['repair_time'] ,$html);
	} else {
		$data['times_dd']["1"]="9:00am-12:00pm";
		 $data['times_dd']["2"]="1:00pm-4:00pm";
		 $data['times_dd']["3"]="Other(specify time)";
		if($data['repair_time']==3){
			$html = str_replace("{tor}" ,$data['times_dd'][$data['repair_time']]." ".$data['eat_time']."-".$data['edt_time'] ,$html);
		} else{
		 
		 $html = str_replace("{tor}" ,$data['times_dd'][$data['repair_time']] ,$html);
		}
	}
   
   $html = str_replace("{tyor}" ,$data['repair_type'] ,$html);
   $html = str_replace("{dopn}" ,$data['servicedesc'] ,$html);
    $contractor = $data['contractor_id'];
   $temp =explode(",",$contractor);
   $cnamei = array();
   foreach($temp as $c=>$v) {
    $u_name =  $this->getUserIntial($v,true);
    if($u_name)
        $cnamei[] = $u_name;
    }
   $html = str_replace("{contractor}" ,implode(",",$cnamei) , $html );
   
   
   $html = str_replace("{comments}" ,$data['comments'] ,$html);
    
 
  $mpdf=new mPDF('s');
  $mpdf->WriteHTML($html);
  $mpdf->Output($customername_pdf,"D");
  
   }
   function  issendnotification($user_id){
   $sql = "SELECT user_id FROM  notification_setting WHERE user_id = $user_id";
   $rowe = array();
   $rowe = $this->db->query($sql)->result_array();
   if(count($rowe)>1 && $rowe[0]['user_id']){
      return true;
   }else{
        $row['user_id'] = $user_id;
        return false;
   }

 }
 function globalnotifcation(){
   $sql  = "SELECT notification from notification_setting WHERE id=1";
   $nresult =  $this->db->query($sql)->result_array();
   if(!$nresult[0]['notification']) return 'false' ;
 }
 function changevalue($value){
     if($value=='y') return 'Yes';
     return 'No';
  }
 function setjobschedule(){
     $result =  $this->db->query("SELECT * FROM jobs ")->result_array();
      $this->load->library("job");
      foreach($result as $key => $value){
        	 $per = (int)$this->job->percent_completed($value['id']);
                 if( $per == 97){
                     
                     $sql_presale = "SELECT count(*) as cnt from sketch_files where job_id=".$value['job_pid'];
                     $result1 = mysql_query($sql_presale);
                     $res = @mysql_fetch_object($result1);
                     $is_sketch_exit = false;
                     if(@$res->cnt){
                        $is_sketch_exit = true;
                      }
                      if(!$is_sketch_exit){
                          $resultcnt =  $this->db->query("SELECT * FROM timelimit_manual_extend where jid = '".$value['job_pid']."'")->result_array();
                          if(count($resultcnt)>=1) {
                            $row['timeext'] =  168;
                            $row['created_on'] = date("Y-m-d h:i:s");
                            $this->db->where('jid',$value['job_pid']);
                            $this->db->update('timelimit_manual_extend', $row);

                         } else{
                        $row['timeext'] =  168;
                        $row['jid']=$value['job_pid'];
                        $row['created_on'] = date("Y-m-d h:i:s");
                        $this->db->insert("timelimit_manual_extend",$row);
                        }
                        $sql = "UPDATE jobs set current_status='inprogress' WHERE job_pid=".$value['job_pid'];
                        $this->db->query($sql);
                      }
                  }
      }
      return;
  }
  function downloadcsv(){
      $sql = "SELECT id,first_name,last_name,email,address,city,zip_code FROM customers where email is not null AND email!='' order by first_name";
      $row = $this->db->query($sql)->result_array();

      $output = "";
      $output .= "First Name,Last Name ,Email,Address,City,Zip Code,System Size\n";
      foreach($row as $data){
		$system_size=$this->getsystemsize($data['id']);
        $output .= ucfirst(str_replace(",","",$data['first_name'])).", ".ucfirst(str_replace(",","",$data['last_name'])).",".$data['email'].",".str_replace(",","",$data['address']).", ".str_replace(",","",$data['city']).",".$data['zip_code'].",".$system_size."\n";
      }
      $this->load->helper('download');
      force_download("customers.csv", $output);
  }
  function getRoofType($id){
      if (!$id) return 0;
      $j = $this->db->query("SELECT type  FROM roof_types WHERE id=$id")->row_array();
      return $j['type'];
 }

 function getsystemsize($custid){
      if (!$custid) return 0;
      $j = $this->db->query("SELECT system_size  FROM jobs  WHERE  job_type_id=2 AND customer_id=$custid")->row_array();
      if(isset($j['system_size']))
	  return $j['system_size']*1000;
	  else
	  return 0;
 }
 function getTimeFrame($id){
      if (!$id) return 0;
      if($id==1){ return "9:00am-12:00am"; }
      if($id==2){ return "1:00pm-4:00pm"; }
      if($id==3){ return "All Day"; }
 }
 function getstTimeFrame($id){
      if (!$id) return 0;
      if($id==1){ return "9a12p"; }
      if($id==2){ return "1p4p"; }
      if($id==3){ return "All Day"; }
 }
 function downloadphotoreview($job_id){
    //$this->load->helper("thumbnail_helper");
    $this->load->helper('download');
    if($job_id=='') { redirect('admin/error?e=job_id'); }
    /*$pid = $this->getparentjobid($job_id);
    $sql = "SELECT  * from elecphoto_files WHERE job_id=$pid ORDER by photo_id";
    $data['photo']= $this->db->query($sql)->result_array();
    $html=$this->load->view("admin/downelectricphtooreview",$data,true);
    $t = rand(1, 99999);
    $fp = fopen(FCPATH . "pdftemp/temp$t-$job_id.html","w+");
    fputs ($fp, $html);
    fclose ($fp);
    exec("/var/www/vhosts/aeihawaii.com/httpdocs/page/wkhtmltopdf-i386 -B 20 " . FCPATH . "pdftemp/temp$t-$job_id.html     " . FCPATH . "pdftemp/proposal$t-$job_id.pdf ");
     * */
     
    $data_file = file_get_contents("/var/www/vhosts/aeihawaii.com/httpdocs/scheduler/3-elec-pics.jpg"); // Read the file's contents
    force_download("3-elec-pics.jpg", $data_file);
   
  }
 function createpdfpartjob($job_id, $part=FALSE){
     $this->load->helper('download');
     $data = array();
      $sql = "SELECT			jobs.*,customers.id as customer_id,customers.first_name,
               customers.last_name,
               customers.address,
               customers.email,customers.city,customers.state,customers.zip_code,customers.billing_address,customers.billing_state,
               customers.billing_city,
               customers.billing_zip_code,
               customers.different_billing_address,
               customers.home_phone,
               customers.secondary_phone,
               customers.association,
               customers.heco_account_number,
               customers.heco_meter_number,
               customers.neighborhood,
               customers.other_neighborhood,
               job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."";
     $data_job = $this->db->query($sql)->row_array();
     $proposal_id=$data_job['proposal_id'];
     if(!$proposal_id ) { redirect("admin/error?e=permissions");}
     $contractor = @$data_job['contractor_id'];
     $temp =explode(",",$contractor);
     $cnamei = array();
     foreach($temp as $c=>$v) {
      $tech=$this->getUserIntial($v,true);
      if($tech)
       $cnamei[] =$tech ;
     }
     $installer_id = @$data_job['installer_id'];
     $temp =explode(",",$installer_id);
     $installname = array();
     foreach($temp as $c=>$v) {
      if($v){
         $installern=$this->getUserIntial($v,true);
         if($installern)
         $installname[] =$installern ;
       }
      }
      $data["installer"]=implode(",",$installname);
      $data["technicain"]=implode(",",$cnamei);
      $data['job']=$data_job;
      $data["neighborhood"] = "";
      if($data_job["neighborhood"]){
        $sql = "SELECT neighbour from  neigbhour where id=".$data_job['neighborhood'];
        $row_neighbour = $this->db->query($sql)->row_array();
        $data["neighborhood"] = ucfirst($row_neighbour['neighbour']);

      }
      $data["sales_man"]=$this->getUserIntial($data_job["user_id"],true);
      $sql ="SELECT variable_job.*,system_price.title,system_price.id as varaible_id FROM variable_job  LEFT JOIN system_price_proposal as system_price  on variable_job.variable_id=system_price.id AND variable_job.proposal_id=system_price.proposal_id where variable_job.proposal_id=$proposal_id order by variable_job.id ";
      $data["pdf_data"]=$this->db->query($sql)->result_array();
        //$sql_system_price = "SELECT * from system_price ";
        //$data["varaible_data"]= $this->db->query($sql_system_price)->row_array();
        $data["proposal"]=$this->db->query("SELECT  * from proposal WHERE id=$proposal_id")->row_array();
       
		if($part=='part_pdf'){
		    $html = $this->load->view("admin/pdfpart_m",$data,true);
		   return $html;
		}
		 $html = $this->load->view("admin/pdfpart",$data,true);
        $t = rand(1, 99999);
		$fp = fopen(FCPATH . "pdftemp/partpdf$t-$proposal_id.html","w+");
        fputs ($fp, $html);
        fclose ($fp);
        exec("/var/www/vhosts/aeihawaii.com/httpdocs/page/wkhtmltopdf-i386 -B 20 " . FCPATH . "pdftemp/partpdf$t-$proposal_id.html     " . FCPATH . "pdftemp/partpdf$t-$proposal_id.pdf ");
        $data_file = file_get_contents(FCPATH . "pdftemp/partpdf$t-$proposal_id.pdf"); // Read the file's contents
        @$name =  "Parts-List-".$data["proposal"]["dpp_lastname"]."-".$data["proposal"]["dpp_firstname"]."-".date("d-M-Y",strtotime($data_job['job_date'] )).".pdf";
        if($part=='part_pdf'){
             return FCPATH . "pdftemp/partpdf$t-$proposal_id.pdf" ;
         }
		force_download($name, $data_file);
    }

	function createpdfpartswhjob($job_id){
     $this->load->helper('download');
     $data = array();
      $sql = "SELECT			jobs.*,customers.id as customer_id,customers.first_name,
               customers.last_name,
               customers.address,
               customers.email,customers.city,customers.state,customers.zip_code,customers.billing_address,customers.billing_state,
               customers.billing_city,
               customers.billing_zip_code,
               customers.different_billing_address,
               customers.home_phone,
               customers.secondary_phone,
               customers.association,
               customers.heco_account_number,
               customers.heco_meter_number,
               customers.neighborhood,
               customers.other_neighborhood,
               job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."";
     $data_job = $this->db->query($sql)->row_array();
     $proposal_id=$data_job['proposal_id'];
     if(!$proposal_id ) { redirect("admin/error?e=permissions");}
     $contractor = @$data_job['contractor_id'];
     $temp =explode(",",$contractor);
     $cnamei = array();
     foreach($temp as $c=>$v) {
      $tech=$this->getUserIntial($v,true);
      if($tech)
       $cnamei[] =$tech ;
     }
     $installer_id = @$data_job['installer_id'];
     $temp =explode(",",$installer_id);
     $installname = array();
     foreach($temp as $c=>$v) {
      if($v){
         $installern=$this->getUserIntial($v,true);
         if($installern)
         $installname[] =$installern ;
       }
      }
      $data["installer"]=implode(",",$installname);
      $data["technicain"]=implode(",",$cnamei);
      $data['job']=$data_job;
      $data["neighborhood"] = "";
      if($data_job["neighborhood"]){
        $sql = "SELECT neighbour from  neigbhour where id=".$data_job['neighborhood'];
        $row_neighbour = $this->db->query($sql)->row_array();
        $data["neighborhood"] = ucfirst($row_neighbour['neighbour']);

      }
      $data["sales_man"]=$this->getUserIntial($data_job["user_id"],true);
      $sql ="SELECT variable_job.*,system_price.title,system_price.id as varaible_id FROM swh_variable_job as variable_job LEFT JOIN swh_system_price as system_price on variable_job.variable_id=system_price.id where proposal_id=$proposal_id order by variable_job.id ";
      $data["pdf_data"]=$this->db->query($sql)->result_array();
        //$sql_system_price = "SELECT * from system_price ";
        //$data["varaible_data"]= $this->db->query($sql_system_price)->row_array();
        $data["proposal"]=$this->db->query("SELECT  * from proposal WHERE id=$proposal_id")->row_array();
     $html = $this->load->view("admin/swhpdfpart",$data,true);
            $t = rand(1, 99999);
        $fp = fopen(FCPATH . "pdftemp/partpdf$t-$proposal_id.html","w+");
        fputs ($fp, $html);
        fclose ($fp);
        exec("/var/www/vhosts/aeihawaii.com/httpdocs/page/wkhtmltopdf-i386 -B 20 " . FCPATH . "pdftemp/partpdf$t-$proposal_id.html     " . FCPATH . "pdftemp/partpdf$t-$proposal_id.pdf ");
        $data_file = file_get_contents(FCPATH . "pdftemp/partpdf$t-$proposal_id.pdf"); // Read the file's contents
        @$name =  "Parts-List-".$data["proposal"]["dpp_lastname"]."-".$data["proposal"]["dpp_firstname"]."-".date("d-M-Y",strtotime($data_job['job_date'] )).".pdf";
        force_download($name, $data_file);
    }
 function getjoblimit(){
     global $pv_job_count;
     global $swh_job_count;
     global $pm_pl;
     global $pl_pv;
     global $digital_pm_pv;
     global $hoa_setting;
	 global $sc_job_count;
	 global $saf_job_count;
     global $ev_job_count;
     $resultcnt =  $this->db->query("SELECT * FROM globalconfig  where id = 1")->row_array();
     $pv_job_count = $resultcnt['pv_job'];
     $swh_job_count=$resultcnt['swh_job'];
     $sc_job_count=$resultcnt['sc_job'];
     $pm_pl=$resultcnt['pm_pl'];
     $pl_pv=$resultcnt['pl_pv'];
     $hoa_setting=$resultcnt['hoa_setting'];
     $digital_pm_pv=$resultcnt['digital_pm_pv'];
	 $saf_job_count=$resultcnt['saf_job'];
     $ev_job_count=$resultcnt['ev_job'];
   
  }
  function photohelp(){
       $data=array();
       $this->db->where("id",1);
       $data['elec_photo_desc'] = $this->db->get("globalconfig")->row_array();
       $this->load->view("common/header");
       $this->load->view("admin/photohelp",$data);
       $this->load->view("common/footer");
  }
  function downloadphotoreviewpdf($job_id){
    $this->load->helper("thumbnail_helper");
    $this->load->helper('download');
    if($job_id=='') { redirect('admin/error?e=job_id'); }
    $pid = $this->getparentjobid($job_id);

    $sql = "SELECT  * from meter_files WHERE job_id=$pid   AND is_export=1  AND file_type=".FILE_TYPE_METER."  and image_id!=6 ORDER by image_id";
    $data['photo']= $this->db->query($sql)->result_array();

    $sql = "SELECT  * from meter_files WHERE job_id=$pid   AND is_export=1  AND file_type=".FILE_TYPE_METER."  and image_id=6 ORDER by image_id";
    $data['other_elec_photo']= $this->db->query($sql)->result_array();

    $sql = "SELECT  * from meter_files WHERE job_id=$pid   AND is_export=1  AND file_type=".FILE_TYPE_ROOF."  and image_id!=3 ORDER by image_id";
    $data['roofphoto']= $this->db->query($sql)->result_array();

    $sql = "SELECT  * from meter_files WHERE job_id=$pid   AND is_export=1  AND file_type=".FILE_TYPE_ROOF."  and image_id=3 ORDER by image_id";
    $data['other_roof_photo']= $this->db->query($sql)->result_array();

    $sql = "SELECT  * from meter_files WHERE job_id=$pid   AND is_export=1  AND file_type=".FILE_TYPE_OTHER."   ORDER by image_id";
    $data['other_help_photo']= $this->db->query($sql)->result_array();

      $html=$this->load->view("admin/downelectricphtooreview",$data,true);
    if($this->session->userdata("user_id") ==114){
        echo $html;
        die;
    }
    $t = rand(1, 99999);
    $fp = fopen(FCPATH . "pdftemp/temp$t-$job_id.html","w+");
    fputs ($fp, $html);
    fclose ($fp);
    exec("/var/www/vhosts/aeihawaii.com/httpdocs/page/wkhtmltopdf-i386 -B 20 " . FCPATH . "pdftemp/temp$t-$job_id.html     " . FCPATH . "pdftemp/job$t-$job_id.pdf ");
    $data_file = file_get_contents(FCPATH . "pdftemp/job$t-$job_id.pdf"); // Read the file's contents
    force_download("job-$job_id.pdf", $data_file);
  }
 function deleteuserpp($user_id,$profile){
  if($this->session->userdata("role")=='admin' || $this->session->userdata("user_id")==$user_id ){
    $sql="update users set profile_photo='' WHERE id=$user_id";
    $this->db->query($sql);
  }
  if($profile){
    redirect("admin/profile");
  } else {
    redirect("admin/edit_user/$user_id");
  }
 }

  function exportjoblog($job_id)
 {
 
 		$sql = "SELECT jobs.id, customers.id as customer_id, job_types.type as job_type FROM jobs LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON job_types.id=jobs.job_type_id WHERE jobs.id=".$this->db->escape($job_id)."	";
		$job= $this->db->query($sql)->row_array();
 		@$jobid 	= $job['id'];
 		@$customer_id 	= $job['customer_id'];
 		@$job_types 	= $job['job_type'];
 		$sql  = "select activity_log.*, DATE_FORMAT(activity_log.created,'%b %d %Y %h:%i %p') as modifieddate, users.first_name, users.last_name  from activity_log 
 		LEFT  JOIN users on activity_log.user_id=users.id where activity_log.job_id = '$jobid' and activity_log.table_name ='jobs' ";
 		$rows  = $this->db->query($sql)->result_array();		
 		$output = ", Job action Items for # $jobid $job_types Job\n\n";
 		$output .= "Action, Modified Date, Modified by \n";
 		foreach($rows as $key => $val)
 		{
			$action 	= $val['activity_type']; 
			$modifieddate 	= $val['modifieddate']; 
			$Modifiedby 	= ucfirst($val['first_name'])." ".ucfirst($val['last_name']); 
			$output .= "$action ,$modifieddate,$Modifiedby \n";
 		}
 		
 		$sql  = "select activity_log.*, DATE_FORMAT(activity_log.created,'%b %d %Y %h:%i %p') as modifieddate, users.first_name, users.last_name  from activity_log 
 		LEFT  JOIN users on activity_log.user_id=users.id where activity_log.customer_id = '$customer_id' and activity_log.table_name ='customers' ";
 		$rows  = $this->db->query($sql)->result_array();		
 		$output .= "\n\n, Customer action Items for #$jobid $job_types Job\n\n";
 		$output .= "Action, Modified Date, Modified by \n";
 		foreach($rows as $key => $val)
 		{
			$action 	= $val['activity_type']; 
			$modifieddate 	= $val['modifieddate']; 
			$Modifiedby 	= ucfirst($val['first_name'])." ".ucfirst($val['last_name']); 
			$output .= "$action ,$modifieddate,$Modifiedby \n";
 		} 
 		
  		$sql  = "select *, DATE_FORMAT(created,'%b %d %Y %h:%i %p') as modifieddate from job_reschedule_comment where job_id='$jobid' ";
  		$rows  = $this->db->query($sql)->result_array();		
  		$output .= "\n\n, Reschedule Job details for #$jobid $job_types Job\n\n";
  		$output .= "Comment, Rescheduled Date \n";
  		foreach($rows as $key => $val)
  		{
 			$comment 	= $val['comment']; 
 			$modifieddate 	= $val['modifieddate']; 
 			$output .= "$comment ,$modifieddate \n";
 		} 
 		
		ob_end_clean();
		header("Content-type:text/octect-stream");
		header("Content-Disposition:attachment;filename=Joblog_".$jobid.".csv");			
		print $output;  
		print "\n\n";  
		exit;	 		
 
 }

 function pendingReason($job_id)
	{
		$reason  = '';
		$sql = "SELECT system_size,proposal_id,customer_id from jobs WHERE id ='".$job_id."'"; 
		$res = $this->db->query($sql)->row_array();
		$sqlP = "SELECT deal_type,dml,dml_collect_type FROM proposal WHERE id = '".$res['proposal_id']."'";
		$resP = $this->db->query($sqlP)->row_array();
		if(@$resP['deal_type']==2)
		{
			return 'CPF';
			exit;
			}
		if(@($resP['dml']>5) &&  $resP['dml_collect_type']==2){
                        return 'DML';
			exit;
		}
		if($res['system_size']>=10)
		{
			return '10kW+';
			exit;
		}
		
		
		return 'Rescheduled';
		
	}
function update_role_extra()
{
		$select = '';
		$role = '';
		if(@$this->input->post('role'))
		{
			$role = $this->input->post('role');
			}
			
		if($this->input->post('type')=='admin')
		{
			$val = $role=='engineer'?'SELECTED':'';
			$select = '<option value="engineer" '.$val.'>Engineer</option>';
			$val = $role=='warehouse'?'SELECTED':'';
			$select .= '<option value="warehouse" '.$val.'>Warehouse</option>';
			}
		if($this->input->post('type')=='engineer')
		{
			$val = $role=='warehouse'?'SELECTED':'';
			$select .= '<option value="warehouse" '.$val.'>Warehouse</option>';
			}
		if($this->input->post('type')=='warehouse')
		{
			$val = $role=='engineer'?'SELECTED':'';
			$select = '<option value="engineer" '.$val.'>Engineer</option>';
			}
		echo $select;
}
function getRankTypeById($id)
	{
		$sql = "SELECT id,rank_type FROM rank_type WHERE id = '".$id."'";
		$res = $this->db->query($sql)->row_array();
		return $res['rank_type'];
	}
        function getroofattachment($proposal_id) {
            $sql_roof_attachments ="SELECT variable_job.*,system_price_proposal.title FROM variable_job LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.proposal_id=$proposal_id  AND  variable_job.variable_id in (14,59,62,63,64,65,18,15,72,67,57,82,83,93) AND system_price_proposal.title is not null  order by variable_job.id ";
            $data["pdf_roof_attachments"]=$this->db->query($sql_roof_attachments)->result_array();
            $return=array();
            foreach($data["pdf_roof_attachments"] as $dataroof){
              $return[]=$dataroof['title'];
            }
           $roof_string=implode(",",$return);
           return $roof_string;
        }

		function associatecustomer($job_id,$customer_id=0)
	{
		$data = array();
		$data['job_id'] = $job_id;
		if($customer_id!='')
		{
			$sql = "SELECT first_name,last_name FROM customers WHERE id = '".$customer_id."'";
			$res = $this->db->query($sql)->row_array();
			if($res)
			{
				$sql = "SELECT  customers.* ,jobs.job_type_id,jobs.job_type_id,jobs.proposal_id,job_types.type as job_type  FROM customers left join jobs on customers.id=jobs.customer_id  LEFT JOIN job_types ON job_types.id=jobs.job_type_id WHERE  jobs.job_type_id in (1,2,16) AND customers.id != '".$customer_id."' AND  first_name like '%".$res['first_name']."%' AND last_name like '%".$res['last_name']."%'";
				$data['customers'] = $this->db->query($sql)->result_array();
				$data['currentcustomer'] = $customer_id;
				}
			}
		$this->load->view('admin/associatecustomer',$data);
	}
function updateassociatecustomer()
{
	if($this->input->post('job_id') && $this->input->post('customer_id'))
	{
		$sql_customerid=$this->db->query("SELECT customer_id FROM  jobs where id=".$this->input->post('job_id'))->row_array();
		$sql = "UPDATE jobs SET customer_id = '".$this->input->post('customer_id')."' WHERE customer_id = '".$sql_customerid["customer_id"]."'";
		$this->db->query($sql);
		$this->db->query("delete from customers where id=".$sql_customerid["customer_id"]);
		redirect("admin/job_comment/".$this->input->post('job_id'));
	}
}

function delete_is_schedule($jobid,$proposal_id){     
    if($jobid==2){
        $sql = "UPDATE proposal SET is_schedule=0 WHERE id = '".$proposal_id."'";
  $this->db->query($sql);
  
    }
    
   if($jobid==1){
        $sql = "UPDATE swhproposal SET is_schedule=0 WHERE id = '".$proposal_id."'";
       $this->db->query($sql);
   
    }
     
     if($jobid==16){
        $sql = "UPDATE acproposal SET is_schedule=0 WHERE id = '".$proposal_id."'";
	$this->db->query($sql);
       }
  }

function getcustomerId($userId){
      $this->db->select('customer_id');
      $this->db->where('user_id',$userId);
     return $this->db->get('jobs')->result();
  }
  function getCustomerType($custmoerType){
      $this->db->select('type');
      $this->db->where('id',$custmoerType);
      $query= $this->db->get('customer_types')->row_array();
      if($query)
       return $query['type'];
      else return '';
  }
  
  function duplicateCustomer($customerid='',$firstname='',$lastname='',$address='',$city='',$zipcode='',$state=''){
     
      if(!strstr($customerid,'-',true)=='duplicate'):
     // echo $firstname.$lastname.$address.$city.$zipcode.$state;
      $condi=array('trim(first_name)'=>$firstname,'trim(last_name)'=>$lastname,'trim(address)'=>$address,'trim(city)'=>$city,'trim(zip_code)'=>$zipcode,'trim(state)'=>$state);
     $this->db->select('id,first_name,last_name');
 $this->db->where($condi);
 
  $query=$this->db->get('customers')->result();
  if(count($query)>1) return $query;
  else return ;
      else :
      $customerid=explode('-',$customerid);
      $this->db->select('first_name,last_name,address,city,zip_code,state');
      $this->db->where('id',$customerid[1]);
      if($qu=$this->db->get('customers')->row_array()):
           $qu['id !=']=$customerid[1];
           $this->db->select('id,first_name,last_name');
           $this->db->where($qu);
           $query1['customerid']=$customerid[1];
           $query1['duplicate']=$this->db->get('customers')->result();
  $this->load->view('ajax/duplicate',$query1);
      endif;
      endif;
  }
function jobType($customer_id){
    $sql="select distinct job_types.intials as type from job_types inner join jobs on job_types.id=jobs.job_type_id where  jobs.customer_id=$customer_id ";
    $job_type=$this->db->query($sql)->result();
    if($job_type):
    foreach ($job_type as $value):
        $job_typ .=$value->type.',';
    endforeach;
   return $job_type=  rtrim($job_typ,',');
   else:
       return '';
   endif;
}

function engineer_list($job_id,$user_id=0){
  $sql = "SELECT * FROM users WHERE  type='engineer'";
  $data['users'] = $this->db->query($sql)->result_array();
  $user_select=array();
  foreach($data['users'] as $users){
     $user_select[$users['id']]= ucfirst($users['first_name'])." ".ucfirst($users['last_name']);
   }
   $data['job_id']=$job_id;
   $data['user_id']=$user_id;
   $data['engineeruser']=$user_select;
   $this->load->view("admin/engineer_list",$data);
 }

function getunit($proposal_id){
    $sql_zone="SELECT * from acproposalzone where acproposal_id=$proposal_id";
	$zones=$this->db->query($sql_zone)->result_array();
    $unitcount=0;
	foreach( $zones as $zdata) {
		$mz_chk1 = $zdata['mzone_rec1_id'];
		$mz_chk2 = $zdata['mzone_rec2_id'];
		$mz_add_check = $zdata['additional_unit_1_price'];
		$mz_rec_check = $zdata['reccomended_unit_1_price'];
		if($mz_chk1>0 && $mz_chk2>0 ){
		//  $unitcount+=2;
		  continue;
		}else if ($mz_chk1>0 && $mz_add_check==0 ){
		   $unitcount+=1;
		   continue;
		} else if($mz_chk2>0 && $mz_rec_check>0 ){
			$unitcount+=1;
			continue;
	    } else {

		
		   $unitcount+=1;
		 if(!$zdata['reccomended_unit_delete'] &&  !$zdata['additional_unit_delete'] && $zdata['additional_unit_1_price']>0 ) { 
			$unitcount+=2;
		  }
		 if($zdata['reccomended_unit_delete'] &&  $zdata['additional_unit_delete'] ) { 
			$unitcount-=1;
		 }
   
		}
  }

  return $unitcount;
 }


}
?>