<?php
/**
 * Copyright 2010-2012 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License").
 * You may not use this file except in compliance with the License.
 * A copy of the License is located at
 *
 * http://aws.amazon.com/apache2.0
 *
 * or in the "license" file accompanying this file. This file is distributed
 * on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
 * express or implied. See the License for the specific language governing
 * permissions and limitations under the License.
 */

namespace Aws\S3\Iterator;

use Guzzle\Service\Resource\Model;

/**
 * Iterate over a ListBuckets command
 *
 * This iterator includes the following additional options:
 * @option bool names_only Set to true to receive only the object/prefix names
 */
class ListBucketsIterator extends AbstractS3ResourceIterator
{
    /**
     * {@inheritdoc}
     */
    protected function prepareRequest() {}

    /**
     * {@inheritdoc}
     */
    protected function handleResults(Model $result)
    {
        // Get and format the results
        $buckets = $result['Buckets'];

        // If only the names_only set, change arrays to a string
        if ($this->get('names_only')) {
            foreach ($buckets as &$bucket) {
                $bucket = $bucket['Name'];
            }
        }

        return $buckets;
    }

    /**
     * {@inheritdoc}
     */
    protected function determineNextToken(Model $result)
    {
        // ListBuckets does not have markers
        $this->nextToken = false;
    }
}
