<?php
/*
 * Smarty plugin
 * -------------------------------------------------------------
 * File:     function.thumbnail.php
 * Type:     function
 * Name:     thumbnail
 * Purpose:  resizes and caches an image
 * Version:  1.03
 * Creator:  Eli Van Zoeren - eli@newmediacampaigns.com
 * -------------------------------------------------------------
 */
function smarty_function_thumbnail($params, &$smarty)
{
    if(!function_exists('thumbnail')) {
        if (!function_exists('get_instance')) {
            $smarty->trigger_error("thumbnail Error: Cannot load CodeIgniter");
            return '<!-- thumbnail Error: Cannot load CodeIgniter -->';
        }
        $CI = &get_instance();

        $CI->load->helper('thumbnail');
    }
    if (!isset($params['src']) || !isset($params['width']) || !isset($params['height'])) {
        $smarty->trigger_error("thumbnail Error: You must specify a source image and an height and a width");
        return '<!-- thumbnail Error: You must specify a source image and an height and a width -->';
    }

    return thumbnail(
            $params['src'],
            $params['width'],
            $params['height'],
            isset($params['option']) ? $params['option'] : 'crop',
            isset($params['grayscale']) && $params['grayscale'] == 'true'
        );
}
?>
