<?php

class Admin extends Controller {

	function Admin()
	{
		parent::Controller();	
		if(!$this->session->userdata('logged_in'))
		{
			redirect("login?ref=admin");
		}
		
		// if user is an installer, redirect them to an error page if
		// they're trying to do something they do have permissions to do
		if($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y')
		{
			$method = $this->router->method;
			$protected = array("delete_job");
			if(in_array($method,$protected))
			{
				redirect("admin/error?e=permissions");
			}
		}
	}
	
	function index()
	{
		$data = array();
		
		$this->load->helper("date");
		
		$prefs = array (
			'start_day'    => 'sunday',
			'month_type'   => 'long',
			'day_type'     => 'short'
		);
		
		if(@$year=='') {$year = date("Y");}
		if(@$month=='') {$month = date("m");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$data['year'] = $year;
		$data['month'] = $month;
		
		// daily job limit
		$daily_limit = $this->db->get("job_limit")->row_array();
		$daily_limit = $daily_limit['limit'];
		
		// get jobs for the current month
		$j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%m') = '".$year."-".$month."' ORDER BY jobs.job_date ASC")->result_array();
		foreach($j as $key => $value)
		{
			$jobs[date("j", strtotime($value['job_date']))][] = $value;
		}
		$days_count = days_in_month($month,$year);
		
		// grab service calls for the current month
		$sc = $this->db->query("SELECT service_calls.*,colors.hex, users.custom_hex, users.id as user_id FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(`date`,'%Y-%m') = '".$year."-".$month."' GROUP BY DATE_FORMAT(`date`,'%Y-%m-%d')")->result_array();
		// loop through them and assign their days as key values to make them easier to access when setup the calendar values
		$service_calls = array();
		$has_service_calls = array();
		foreach($sc as $key => $value)
		{
			if($value['job_count'] == '')
			{
				$has_service_calls[date("j",strtotime($value['date']))] = true;
			}
			$service_calls[date("j",strtotime($value['date']))] = $value['job_count'];
		}
		
		for($i=0; $i<($days_count + 1); $i++)
		{
			if(array_key_exists($i,$jobs) or array_key_exists($i,$service_calls))
			{
				if(array_key_exists($i,$service_calls))
				{
					$service_call_count = $service_calls[$i];
				}
				else
				{
					$service_call_count = 0;
				}
				
				if($this->session->userdata("role") == 'admin')
				{
					if(array_key_exists($i,$jobs))
					{
						if($jobs[$i][0]['hex'] == '')
						{
							$jobs[$i][0]['hex'] = '7DBB4C';
						}
						if($jobs[$i][0]['custom_hex'] != '') {
							$color = $jobs[$i][0]['custom_hex'];
						} else {
							$color = $jobs[$i][0]['hex'];
						}
						$data['dates'][$i] = '<div style="background:#'.$color.';" class="">';
					}
					else
					{
						if(array_key_exists($i,$service_calls))
						{
							$data['dates'][$i] = '<div class="">';
						}
					}
				}
				else
				{
					if(array_key_exists($i,$jobs))
					{
						// determine if user has any jobs on the current day
						$has_job_on_day = false;
						foreach($jobs[$i] as $day_job)
						{
							if($day_job['user_id'] == $this->session->userdata("user_id"))
							{
								$has_job_on_day = true;
							}
						}
						if ($has_job_on_day === true) {
							$data['dates'][$i] = '<div style="background:#'.$this->session->userdata("hex_color").';" class="">';
						} else {
							$data['dates'][$i] = '<div style="background:#7DBB4C;" class="">';
						}
					}
					else
					{
						if(array_key_exists($i,$service_calls))
						{
							$data['dates'][$i] = '<div class="">';
						}
					}
				}
				
				$day_job_count = max(@$jobs[$i][0]['job_count'],@$service_call_count);
				
				if($day_job_count < 1)
				{
					$day_job_count = 0;
				}
				$data['dates'][$i] .= '<a href="/ajax/preview_day/'.$year.'/'.$month.'/{day}" class="facebox day-view-url">
					<div class="job-count-home">';
				if($day_job_count < 2)
				{
					if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
					{
						$data['dates'][$i] .= '<a href="/ajax/preview_day/'.$year.'/'.$month.'/'.sprintf("%02d",$i).'" class="facebox day-view-url">';
					}
				}
				$data['dates'][$i] .= $day_job_count.'/'.$daily_limit;
				if($day_job_count < $daily_limit)
				{
					if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
					{
						$data['dates'][$i] .= '</a>';
					}
				}
				$data['dates'][$i] .= '
						</a>
					</div>
					</a>
				</div>';
				$data['dates'][$i] .= '<div class="booked-day-home">';
				if(array_key_exists($i,$has_service_calls) or $service_call_count > 0)
				{
					$data['dates'][$i] .= '
					<!--<div class="service-calls"><a href="/ajax/service_calls/'.$year."/".$month."/".sprintf("%02d",$i).'" class="facebox">Service Calls</a></div>-->';
				}
				$data['dates'][$i] .= '
					<span style="color:#fff;">{day}</span>
				</div>';
			}
		}
		
		$prefs['template'] = '

		   {table_open}<table class="calendar2" border="0" cellpadding="0" cellspacing="1">{/table_open}

		   {heading_row_start}<tr>{/heading_row_start}
			
		   {heading_previous_cell}<th><a href="{previous_url}">&lt;&lt;</a></th>{/heading_previous_cell}
		   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
		   {heading_next_cell}<th><a href="{next_url}">&gt;&gt;</a></th>{/heading_next_cell}

		   {heading_row_end}</tr>{/heading_row_end}

		   {week_row_start}<tr class="week-days">{/week_row_start}
		   {week_day_cell}<td style="background:#7D7D7D;"><div align="left" style="color:#fff;">{week_day}</div></td>{/week_day_cell}
		   {week_row_end}</tr>{/week_row_end}

		   {cal_row_start}<tr>{/cal_row_start}
		   {cal_cell_start}<td>{/cal_cell_start}

			{cal_cell_content}
		    <div class="cell-inner-home">
				{content}
			</div>
			{/cal_cell_content}
			{cal_cell_content_today}
			<div class="cell-inner-home">
				{content}
			</div>
			{/cal_cell_content_today}

			{cal_cell_no_content}
			<div class="cell-inner-home">
				<div class="reserve-job-block-home">';
			
			if($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y')
			{
				
			}
			else
			{
				$prefs['template'] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Reserve a Job"><img src="/assets/images/blank.gif" /></a></div>';
			}
			
			$prefs['template'] .= '
				<span class="day-block2">{day}</span>
			</div>
			{/cal_cell_no_content}
			{cal_cell_no_content_today}
			<div class="cell-inner-home">
				<div class="reserve-job-block-home">';
			
			if($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y')
			{
				
			}
			else
			{
				$prefs['template'] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Reserve a Job"><img src="/assets/images/blank.gif" /></a></div>';
			}
				
			$prefs['template'] .= '
				<span class="day-block2">{day}</span>
			</div>
			{/cal_cell_no_content_today}

		   {cal_cell_blank}&nbsp;{/cal_cell_blank}

		   {cal_cell_end}</td>{/cal_cell_end}
		   {cal_row_end}</tr>{/cal_row_end}

		   {table_close}</table>{/table_close}
		';
		
		$this->load->library('calendar',$prefs);
		
		$this->load->view("common/header");
		$this->load->view("admin/index",$data);
		$this->load->view("common/footer");
	}
	
	function   jobschedule($year='',$month='')
	{
		$this->load->library("job");
		$this->load->helper("date");
		
		$data = array();
		
		$prefs = array (
			'start_day'    => 'sunday',
			'month_type'   => 'long',
			'day_type'     => 'long'
		);
		
		$jobs = array();
		
		if($year=='') {$year = date("Y");}
		if($month=='') {$month = date("m");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$data['year'] = $year;
		$data['month'] = $month;
		
		// daily job limit
		$daily_limit = $this->db->get("job_limit")->row_array();
		$daily_limit = $daily_limit['limit'];
		
		// create calendar and year dd values and set which should be preselected
		$data['calendar_months'] = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
		$data['calendar_years'] = array();
		for($i=date("Y",strtotime("-2 years")); $i<date("Y",strtotime("+2 years")); $i++)
		{
			$data['calendar_years'][$i] = $i;
		}
		$data['calendar_month'] = $data['month'];
		$data['calendar_year'] = $data['year'];
			
		// get jobs for the current month
		$j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%m') = '".$year."-".$month."' ORDER BY jobs.job_date ASC")->result_array();
		foreach($j as $key => $value)
		{
			$jobs[date("j", strtotime($value['job_date']))][] = $value;
		}
		$days_count = days_in_month($month,$year);
		
		// grab service calls for the current month
		$sc = $this->db->query("SELECT service_calls.*,colors.hex, users.custom_hex, users.id as user_id FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(`date`,'%Y-%m') = '".$year."-".$month."' GROUP BY DATE_FORMAT(`date`,'%Y-%m-%d')")->result_array();
		// loop through them and assign their days as key values to make them easier to access when setup the calendar values
		$service_calls = array();
		$has_service_calls = array();
		foreach($sc as $key => $value)
		{
			if($value['job_count'] == '')
			{
				$has_service_calls[date("j",strtotime($value['date']))] = true;
			}
			$service_calls[date("j",strtotime($value['date']))] = $value['job_count'];
		}
		
		#die(print(count($service_calls)));
		
		for($i=0; $i<($days_count+1); $i++)
		{
			if(array_key_exists($i,$jobs) or array_key_exists($i,$service_calls))
			{	
				if(array_key_exists($i,$service_calls))
				{
					$service_call_count = $service_calls[$i];
				}
				else
				{
					$service_call_count = 0;
				}
				
				if($this->session->userdata("role") == 'admin')
				{
					if(array_key_exists($i,$jobs))
					{
						if($jobs[$i][0]['hex'] == '')
						{
							$jobs[$i][0]['hex'] = '7DBB4C';
						}
						if($jobs[$i][0]['custom_hex'] != '') {
							$color = $jobs[$i][0]['custom_hex'];
						} else {
							$color = $jobs[$i][0]['hex'];
						}
						$data['dates'][$i] = '<div style="background:#'.$color.';" class="booked-day-wrap tooltip" title="Go To Day View">';
					}
					else
					{
						if(array_key_exists($i,$service_calls))
						{
							$data['dates'][$i] = '<div class="booked-day-wrap2 tooltip" title="Go To Day View">';
						}
					}
				}
				else
				{
					if(array_key_exists($i,$jobs))
					{
						// determine if user has any jobs on the current day
						$has_job_on_day = false;
						foreach($jobs[$i] as $day_job)
						{
							if($day_job['user_id'] == $this->session->userdata("user_id"))
							{
								$has_job_on_day = true;
							}
						}
						if ($has_job_on_day === true) {
							$data['dates'][$i] = '<div style="background:#'.$this->session->userdata("hex_color").';" class="booked-day-wrap tooltip" title="Go To Day View">';
						} else {
							$data['dates'][$i] = '<div style="background:#7DBB4C;" class="booked-day-wrap tooltip" title="Go To Day View">';
						}
					}
					else
					{
						if(array_key_exists($i,$service_calls))
						{
							$data['dates'][$i] = '<div class="booked-day-wrap2 tooltip" title="Go To Day View">';
						}
					}
				}
				
				$day_job_count = 0;
				
				if(array_key_exists($i,$jobs))
				{
					foreach(@$jobs[$i] as $tj)
					{
						$day_job_count += (int)$tj['job_count'];
					}
				}
				
				$day_job_count += @$service_call_count;
				
				if($day_job_count < 1)
				{
					$day_job_count = 0;
				}
				$data['dates'][$i] .= '<a href="/admin/day/'.$year.'/'.$month.'/{day}" class="day-view-url">
					<div class="job-count">';
				if($day_job_count < $daily_limit)
				{
					if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
					{
						$data['dates'][$i] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/'.sprintf("%02d",$i).'" class="facebox reserve-job reserve-inner tooltip" title="Reserve a Job">';
					}
				}
				$data['dates'][$i] .= $day_job_count;
				if($day_job_count < $daily_limit)
				{
					if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
					{
						$data['dates'][$i] .= '</a>';
					}
				}
				$data['dates'][$i] .= '
						</a>
					</div>
					</a>
				</div>';
				$data['dates'][$i] .= '<div class="booked-day">';
				if(array_key_exists($i,$has_service_calls) or $service_call_count > 0)
				{
					$data['dates'][$i] .= '
					<div class="service-calls"><a href="/ajax/service_calls/'.$year."/".$month."/".sprintf("%02d",$i).'" class="facebox">Service Calls</a></div>';
				}
				$data['dates'][$i] .= '
					<span style="color:#fff;">{day}</span>
				</div>';
			}
		}
		
		$prefs['template'] = '

		   {table_open}<table class="calendar" border="0" cellpadding="0" cellspacing="1">{/table_open}

		   {heading_row_start}<tr>{/heading_row_start}
			
		   {heading_previous_cell}<th></th>{/heading_previous_cell}
		   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
		   {heading_next_cell}<th></th>{/heading_next_cell}

		   {heading_row_end}</tr>{/heading_row_end}

		   {week_row_start}<tr class="week-days">{/week_row_start}
		   {week_day_cell}<td style="background:#7D7D7D;"><div align="left" style="color:#fff;">{week_day}</div></td>{/week_day_cell}
		   {week_row_end}</tr>{/week_row_end}

		   {cal_row_start}<tr>{/cal_row_start}
		   {cal_cell_start}<td>{/cal_cell_start}

			{cal_cell_content}
		    <div class="cell-inner-big">
				<a href="/ajax/quick_summary/'.$year.'/'.$month.'/{day}" class="facebox quick-summary tooltip" title="Quick Summary"><img src="/assets/images/magnifier.png" /></a>
				{content}
			</div>
			{/cal_cell_content}
			{cal_cell_content_today}
			<div class="cell-inner-big">
				<a href="/ajax/quick_summary/'.$year.'/'.$month.'/{day}" class="facebox quick-summary tooltip" title="Quick Summary"><img src="/assets/images/magnifier.png" /></a>
				{content}
			</div>
			{/cal_cell_content_today}

			{cal_cell_no_content}
			<div class="cell-inner-big">
				<div class="reserve-job-block">';
			
			if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
			{
				$prefs['template'] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Reserve a Job"><img src="/assets/images/blank.gif" /></a></div>';
			}
			
			$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content}
			{cal_cell_no_content_today}
			<div class="cell-inner-big">
				<div class="reserve-job-block">';
			
			if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
			{
				$prefs['template'] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Reserve a Job"><img src="/assets/images/blank.gif" /></a></div>';
			}
				
			$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content_today}

		   {cal_cell_blank}&nbsp;{/cal_cell_blank}

		   {cal_cell_end}</td>{/cal_cell_end}
		   {cal_row_end}</tr>{/cal_row_end}

		   {table_close}</table>{/table_close}
		';
		
		$this->load->library('calendar',$prefs);
		$this->load->view("common/header");
		$this->load->view("admin/jobschedule",$data);
		$this->load->view("common/footer");
	}
	
	function day($year='',$month='',$day='')
	{
		$this->load->helper("text");
		
		$data = array();
		
		if($year == '' or $month == '' or $day == '') { redirect("admin/error?e=no_day");}
		
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = $day;
		
		$data['day_timestamp'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		
		// daily job limit
		$data['daily_limit'] = $this->db->get("job_limit")->row_array();
		
		$extra_sql = '';
		if($this->session->userdata("role") != 'admin')
		{
			$extra_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));
		}
		// grab photovoltaic jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='2' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
			";
		$data['pv_jobs'] = $this->db->query($sql)->result_array();
		
		// grab solar water heating jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='1' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['swh_jobs'] = $this->db->query($sql)->result_array();
		
		// grab solar attic fan jobs
		$sql = "SELECT 
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='3' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql 
		";
		$data['saf_jobs'] = $this->db->query($sql)->result_array();
		
		// get service calls for the day
		$sql = "SELECT service_calls.*,customers.first_name,customers.last_name,customers.address,customers.city,customers.state,colors.hex FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN customers ON service_calls.customer_id=customers.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(service_calls.date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql";
		$data['service_calls'] = $this->db->query($sql)->result_array();
		
		// get day's installation job count
		$jc = $this->db->query("SELECT job_count as total FROM jobs LEFT JOIN users ON jobs.user_id=users.id WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."' $extra_sql")->row_array();
		// get day's service call total count
		$sc = $this->db->query("SELECT job_count as total FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id WHERE DATE_FORMAT(`date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."' $extra_sql")->row_array();
		$data['day_job_total'] = max(@$sc['total'], @$jc['total']);
		$data['service_count_total'] = @$sc['total'];
		
		$data['notes'] = array();
		// grab notes for all jobs on this day
		foreach($data['pv_jobs'] as $j)
		{
			$notes  = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id='".$j['id']."'")->result_array();
			foreach($notes as $n)
			{
				$data['notes'][strtotime($n['created'])] = $n;
			}
		}
		
		foreach($data['swh_jobs'] as $j)
		{
			$notes  = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id='".$j['id']."'")->result_array();
			foreach($notes as $n)
			{
				$data['notes'][strtotime($n['created'])] = $n;
			}
		}
		
		foreach($data['saf_jobs'] as $j)
		{
			$notes  = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id='".$j['id']."'")->result_array();
			foreach($notes as $n)
			{
				$data['notes'][strtotime($n['created'])] = $n;
			}
		}
		
		foreach($data['service_calls'] as $j)
		{
			$notes  = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id='".$j['id']."'")->result_array();
			foreach($notes as $n)
			{
				$data['notes'][strtotime($n['created'])] = $n;
			}
		}
		
		ksort($data['notes']);
		$data['day_notes'] = array_slice($data['notes'],0,3);
		$data['remaining_notes'] = (count($data['notes']) - count($data['day_notes']));
			
		$this->load->view("common/header");
		$this->load->view("admin/day",$data);
		$this->load->view("common/footer");
	}
	
	function error()
	{
		$data = array();
			
		$this->load->view("common/header");
		$this->load->view("admin/error",$data);
		$this->load->view("common/footer");
	}
	
	function job($job_id='')
	{
		$data = array();
		
		$data['job_id'] = $job_id;
		
		$this->load->library("job");
		$this->load->helper("date");
		$this->load->helper("text");
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		
		// daily job limit
		$data['daily_limit'] = $this->db->get("job_limit")->row_array();
		
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();
		
		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
		
		$data['job_statuses'][''] = "- Select a job status -";
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['completed'] = "Completed";
		
		// set job type so we know what template to display and how to validate the data
		if($data['job']['job_type_id'] == 1) { $job_type = 'swh'; }
		if($data['job']['job_type_id'] == 1) { $job_type = 'swh'; }
		if($data['job']['job_type_id'] == 2) { $job_type = 'pv'; }
		if($data['job']['job_type_id'] == 3) { $job_type = 'saf'; }
		
		// Grab installation types
		$data['contractors'][] = '- Select a contractor -';
		$this->db->order_by('contractor','asc');
		$contractors = $this->db->get("contractors")->result_array();
		foreach($contractors as $row) { $data['contractors'][$row['id']] = $row['contractor']; }
		
		/* ---------------------------------------
		PV Job Type
		--------------------------------------- */
		if($job_type == 'pv')
		{
			// Grab inverter types
			$data['inverter_types'][] = '- Select an inverter type -';
			$this->db->order_by('type','asc');
			$inverter_types = $this->db->get("inverter_types")->result_array();
			foreach($inverter_types as $row) { $data['inverter_types'][$row['id']] = $row['type']; }
			$data['inverter_types']['other'] = 'Other';
			if($data['job']['other_inverter_type'] != '') $data['job']['inverter_type_id'] = 'other';
			
			// Grab module powers
			$data['module_powers'][] = '- Select module power -';
			$this->db->order_by('power','asc');
			$module_powers = $this->db->get("module_powers")->result_array();
			foreach($module_powers as $row) { $data['module_powers'][$row['id']] = $row['power']; }
			$data['module_powers']['other'] = 'Other';
			if($data['job']['other_module_power'] != '') $data['job']['module_power_id'] = 'other';

			// Grab module brands
			$data['module_brands'][] = '- Select a module brand -';
			$this->db->order_by('brand','asc');
			$module_brands = $this->db->get("module_brands")->result_array();
			foreach($module_brands as $row) { $data['module_brands'][$row['id']] = $row['brand']; }
			$data['module_brands']['other'] = 'Other';
			if($data['job']['other_module_brand'] != '') $data['job']['module_brand_id'] = 'other';

			// Grab roof types 
			$data['roof_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$roof_types = $this->db->get("roof_types")->result_array();
			foreach($roof_types as $row) { $data['roof_types'][$row['id']] = $row['type']; }
			$data['roof_types']['other'] = 'Other';
			if($data['job']['other_roof_type'] != '') $data['job']['roof_type_id'] = 'other';

			// Grab rafter types 
			$data['rafter_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$rafter_types = $this->db->get("rafter_types")->result_array();
			foreach($rafter_types as $row) { $data['rafter_types'][$row['id']] = $row['type']; }
			$data['rafter_types']['other'] = 'Other';
			if($data['job']['other_rafter_type'] != '') $data['job']['rafter_type_id'] = 'other';

			// Grab inverter brands
			$data['inverter_brands'][] = '- Select an inverter brand -';
			$this->db->order_by('brand','asc');
			$inverter_brands = $this->db->get("inverter_brands")->result_array();
			foreach($inverter_brands as $row) { $data['inverter_brands'][$row['id']] = $row['brand']; }
			$data['inverter_brands']['other'] = 'Other';
			if($data['job']['other_inverter_brand'] != '') $data['job']['inverter_brand_id'] = 'other';

			// Grab service panel amperage options
			$data['service_panel_amperages'][] = '- Select an amperage -';
			$this->db->order_by('amperage','asc');
			$service_panel_amperages = $this->db->get("service_panel_amperages")->result_array();
			foreach($service_panel_amperages as $row) { $data['service_panel_amperages'][$row['id']] = $row['amperage']; }
			$data['service_panel_amperages']['other'] = 'Other';
			if($data['job']['other_amperage'] != '') $data['job']['service_panel_amperage_id'] = 'other';

			// Grab wire run types
			$data['wire_run_types'][] = '- Select an type -';
			$this->db->order_by('type','asc');
			$wire_run_types = $this->db->get("wire_run_types")->result_array();
			foreach($wire_run_types as $row) { $data['wire_run_types'][$row['id']] = $row['type']; }
			$data['wire_run_types']['other'] = 'Other';
			if($data['job']['other_wire_run_type'] != '') $data['job']['wire_run_type_id'] = 'other';

			// Grab installation types
			$data['installation_types'][] = '- Select an type -';
			$this->db->order_by('type','asc');
			$installation_types = $this->db->get("installation_types")->result_array();
			foreach($installation_types as $row) { $data['installation_types'][$row['id']] = $row['type']; }
			$data['installation_types']['other'] = 'Other';
			if($data['job']['other_installation_type'] != '') $data['job']['installation_type_id'] = 'other';
			
			// build stories drop-down
			for($i=1; $i<=3; $i++) { $data['stories'][$i] = $i; }
		}
		
		if($job_type == 'swh')
		{
			// Grab tank brands
			$data['tank_brands'][] = '- Select a tank brand -';
			$this->db->order_by('brand','asc');
			$tank_brands = $this->db->get("tank_brands")->result_array();
			foreach($tank_brands as $row) { $data['tank_brands'][$row['id']] = $row['brand']; }
			$data['tank_brands']['other'] = 'Other';
			if($data['job']['other_tank_brand'] != '') {$data['job']['tank_brand_id'] = 'other';}
			
			// Grab tank sizes
			$data['tank_sizes'][] = '- Select a tank sizes -';
			$this->db->order_by('size','asc');
			$tank_sizes = $this->db->get("tank_sizes")->result_array();
			foreach($tank_sizes as $row) { $data['tank_sizes'][$row['id']] = $row['size']; }
			$data['tank_sizes']['other'] = 'Other';
			if($data['job']['other_tank_size'] != '') $data['job']['tank_size_id'] = 'other';
			
			// Grab panel types
			$data['panel_types'][] = '- Select a panel type -';
			$this->db->order_by('type','asc');
			$panel_types = $this->db->get("panel_types")->result_array();
			foreach($panel_types as $row) { $data['panel_types'][$row['id']] = $row['type']; }
			$data['panel_types']['other'] = 'Other';
			if($data['job']['other_panel_type'] != '') $data['job']['panel_type_id'] = 'other';
			
			// Grab panel sizes
			$data['panel_sizes'][] = '- Select a panel size -';
			$this->db->order_by('size','asc');
			$panel_sizes = $this->db->get("panel_sizes")->result_array();
			foreach($panel_sizes as $row) { $data['panel_sizes'][$row['id']] = $row['size']; }
			$data['panel_sizes']['other'] = 'Other';
			if($data['job']['other_panel_size'] != '') $data['job']['panel_size_id'] = 'other';
			
			// Grab pipe run types
			$data['piperun_types'][] = '- Select a pipe-run type -';
			$this->db->order_by('type','asc');
			$piperun_types = $this->db->get("piperun_types")->result_array();
			foreach($piperun_types as $row) { $data['piperun_types'][$row['id']] = $row['type']; }
			$data['piperun_types']['other'] = 'Other';
			if($data['job']['other_piperun_type'] != '') $data['job']['piperun_type_id'] = 'other';
			
			// Grab installation types
			$data['installation_types'][] = '- Select an type -';
			$this->db->order_by('type','asc');
			$installation_types = $this->db->get("installation_types")->result_array();
			foreach($installation_types as $row) { $data['installation_types'][$row['id']] = $row['type']; }
			$data['installation_types']['other'] = 'Other';
			if($data['job']['other_installation_type'] != '') $data['job']['installation_type_id'] = 'other';
			
			// Grab roof types 
			$data['roof_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$roof_types = $this->db->get("roof_types")->result_array();
			foreach($roof_types as $row) { $data['roof_types'][$row['id']] = $row['type']; }
			$data['roof_types']['other'] = 'Other';
			if($data['job']['other_roof_type'] != '') $data['job']['roof_type_id'] = 'other';

			// Grab rafter types 
			$data['rafter_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$rafter_types = $this->db->get("rafter_types")->result_array();
			foreach($rafter_types as $row) { $data['rafter_types'][$row['id']] = $row['type']; }
			$data['rafter_types']['other'] = 'Other';
			if($data['job']['other_rafter_type'] != '') $data['job']['rafter_type_id'] = 'other';
			
			// build stories drop-down
			for($i=1; $i<=3; $i++) { $data['stories'][$i] = $i; }
		}
		
		if($job_type == 'saf')
		{
			// Grab fan brands
			$data['fan_brands'][] = '- Select a brand -';
			$this->db->order_by('brand','asc');
			$fan_brands = $this->db->get("fan_brands")->result_array();
			foreach($fan_brands as $row) { $data['fan_brands'][$row['id']] = $row['brand']; }
			$data['fan_brands']['other'] = 'Other';
			
			// Grab fan sizes
			$data['fan_sizes'][] = '- Select a fan size -';
			$this->db->order_by('size','asc');
			$fan_sizes = $this->db->get("fan_sizes")->result_array();
			foreach($fan_sizes as $row) { $data['fan_sizes'][$row['id']] = $row['size']; }
			$data['fan_sizes']['other'] = 'Other';
			
			// Grab installation types
			$data['installation_types'][] = '- Select an type -';
			$this->db->order_by('type','asc');
			$installation_types = $this->db->get("installation_types")->result_array();
			foreach($installation_types as $row) { $data['installation_types'][$row['id']] = $row['type']; }
			$data['installation_types']['other'] = 'Other';
			
			// Grab roof types 
			$data['roof_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$roof_types = $this->db->get("roof_types")->result_array();
			foreach($roof_types as $row) { $data['roof_types'][$row['id']] = $row['type']; }
			$data['roof_types']['other'] = 'Other';

			// Grab rafter types 
			$data['rafter_types'][] = '- Select a roof type -';
			$this->db->order_by('type','asc');
			$rafter_types = $this->db->get("rafter_types")->result_array();
			foreach($rafter_types as $row) { $data['rafter_types'][$row['id']] = $row['type']; }
			$data['rafter_types']['other'] = 'Other';
			
			// build stories drop-down
			for($i=1; $i<=3; $i++) { $data['stories'][$i] = $i; }
		}
		
		if($this->input->post('dosubmit'))
		{
			$row = array();
			// fields for pv job type
			if($job_type == 'pv')
			{
				if ($this->input->post('module_brand_id') == 'other') {
					$row['module_brand_id'] = '';
					$row['other_module_brand'] = $this->input->post("other_module_brand");
				} else {
					$row['module_brand_id'] = $this->input->post("module_brand_id");
					$row['other_module_brand'] = '';
				}
				$row['module_count'] = $this->input->post("module_count");
				$row['system_size'] = $this->input->post("system_size");
				if ($this->input->post("module_power_id") == 'other') {
					$row['module_power_id'] = '';
					$row['other_module_power'] = $this->input->post("other_module_power");
				} else {
					$row['module_power_id'] = $this->input->post("module_power_id");
					$row['other_module_power'] = '';
				}
				if ($this->input->post("inverter_type_id") == 'other') {
					$row['inverter_type_id'] = '';
					$row['other_inverter_type'] = $this->input->post("other_inverter_type");
				} else {
					$row['inverter_type_id'] = $this->input->post("inverter_type_id");
					$row['other_inverter_type'] = '';
				}
				$row['inverter_brand_id'] = $this->input->post("inverter_brand");
				$row['other_inverter_brand'] = $this->input->post("other_inverter_brand");
				$row['inverter_count'] = $this->input->post("inverter_count");
				$row['inverter_accessible'] = $this->input->post("inverter_accessible");
				$row['subpanel_needed'] = $this->input->post("subpanel_needed");
				if ($this->input->post("service_panel_amperage_id") == 'other') {
					$row['service_panel_amperage_id'] = '';
					$row['other_amperage'] = $this->input->post("other_amperage");
				} else {
					$row['service_panel_amperage_id'] = $this->input->post("service_panel_amperage_id");
					$row['other_amperage'] = '';
				}
				if ($this->input->post("wire_run_type_id") == 'other') {
					$row['wire_run_type_id'] = '';
					$row['other_wire_run_type'] = $this->input->post("other_wire_run_type");
				} else {
					$row['wire_run_type_id'] = $this->input->post("wire_run_type_id");
					$row['other_wire_run_type'] = '';
				}
				$row['wire_run_distance'] = $this->input->post("wire_run_distance");
				$row['stories'] = $this->input->post("stories");
				if ($this->input->post("roof_type_id") == 'other') {
					$row['roof_type_id'] = '';
					$row['other_roof_type'] = $this->input->post("other_roof_type");
				} else {
					$row['roof_type_id'] = $this->input->post("roof_type_id");
					$row['other_roof_type'] = '';
				}
				$row['roof_color'] = $this->input->post("roof_color");
				$row['roof_pitch'] = $this->input->post("roof_pitch");
				$row['roof_orientation'] = $this->input->post("roof_orientation");
				$row['module_install_location_access'] = $this->input->post("module_install_location_access");
				if ($this->input->post("rafter_type_id") == 'other') {
					$row['rafter_type_id'] = '';
					$row['other_rafter_type'] = $this->input->post("other_rafter_type");
				} else {
					$row['rafter_type_id'] = $this->input->post("rafter_type_id");
					$row['other_rafter_type'] = '';
				}
				$row['rafter_distance'] = $this->input->post("rafter_distance");
				$row['tilt_kit_needed'] = $this->input->post("tilt_kit_needed");
				if ($this->input->post("installation_type_id") == 'other') {
					$row['installation_type_id'] = '';
					$row['other_installation_type'] = $this->input->post("other_installation_type");
				} else {
					$row['installation_type_id'] = $this->input->post("installation_type_id");
					$row['other_installation_type'] = '';
				}
				$row['contractor_id'] = $this->input->post("contractor_id");
				$row['comments'] = $this->input->post("comments");
			}
			
			if($job_type == 'saf')
			{
				if ($this->input->post("fan_brand_id") == 'other') {
					$row['fan_brand_id'] = '';
					$row['other_fan_brand'] = $this->input->post("other_fan_brand");
				} else {
					$row['fan_brand_id'] = $this->input->post("fan_brand_id");
					$row['other_fan_brand'] = '';
				}
				if ($this->input->post("fan_size_id") == 'other') {
					$row['fan_size_id'] = '';
					$row['other_fan_size'] = $this->input->post("other_fan_size");
				} else {
					$row['fan_size_id'] = $this->input->post("fan_size_id");
					$row['other_fan_size'] = '';
				}
				$row['panel_install_location_access'] = $this->input->post("panel_install_location_access");
				$row['stories'] = $this->input->post("stories");
				if ($this->input->post("roof_type_id") == 'other') {
					$row['roof_type_id'] = '';
					$row['other_roof_type'] = $this->input->post("other_roof_type");
				} else {
					$row['roof_type_id'] = $this->input->post("roof_type_id");
					$row['other_roof_type'] = '';
				}
				$row['roof_color'] = $this->input->post("roof_color");
				$row['roof_pitch'] = $this->input->post("roof_pitch");
				$row['roof_orientation'] = $this->input->post("roof_orientation");
				$row['fan_install_location_access'] = $this->input->post("module_install_location_access");
				if ($this->input->post("rafter_type_id") == 'other') {
					$row['rafter_type_id'] = '';
					$row['other_rafter_type'] = $this->input->post("other_rafter_type");
				} else {
					$row['rafter_type_id'] = $this->input->post("rafter_type_id");
					$row['other_rafter_type'] = '';
				}
				$row['rafter_distance'] = $this->input->post("rafter_distance");
				$row['tilt_kit_needed'] = $this->input->post("tilt_kit_needed");
				if ($this->input->post("installation_type_id") == 'other') {
					$row['installation_type_id'] = '';
					$row['other_installation_type'] = $this->input->post("other_installation_type");
				} else {
					$row['installation_type_id'] = $this->input->post("installation_type_id");
					$row['other_installation_type'] = '';
				}
				$row['contractor_id'] = $this->input->post("contractor_id");
				$row['comments'] = $this->input->post("comments");
			}
			
			if($job_type == 'swh')
			{
				if ($this->input->post("tank_brand_id") == 'other') {
					$row['tank_brand_id'] = '';
					$row['other_tank_brand'] = $this->input->post("other_tank_brand");
				} else {
					$row['tank_brand_id'] = $this->input->post("tank_brand_id");
					$row['other_tank_brand'] = '';
				}
				if ($this->input->post("tank_size_id") == 'other') {
					$row['tank_size_id'] = '';
					$row['other_tank_size'] = $this->input->post("other_tank_size");
				} else {
					$row['tank_size_id'] = $this->input->post("tank_size_id");
					$row['other_tank_size'] = '';
				}
				$row['existing_heater_location'] = $this->input->post("existing_heater_location");
				$row['remove_old_tank'] = $this->input->post("remove_old_tank");
				$row['relocate_old_tank'] = $this->input->post("relocate_old_tank");
				$row['new_tank_location'] = $this->input->post("new_tank_location");
				$row['tank_distance'] = $this->input->post("tank_distance");
				$row['solar_tank_accessible'] = $this->input->post("solar_tank_accessible");
				if ($this->input->post("panel_type_id") == 'other') {
					$row['panel_type_id'] = '';
					$row['other_panel_type'] = $this->input->post("other_panel_type");
				} else {
					$row['panel_type_id'] = $this->input->post("panel_type_id");
					$row['other_panel_type'] = '';
				}
				if ($this->input->post("panel_size_id") == 'other') {
					$row['panel_size_id'] = '';
					$row['other_panel_size'] = $this->input->post("other_panel_size");
				} else {
					$row['panel_size_id'] = $this->input->post("panel_size_id");
					$row['other_panel_size'] = '';
				}
				
				$row['piperun_length'] = $this->input->post("piperun_length");
				if ($this->input->post("piperun_type_id") == 'other') {
					$row['piperun_type_id'] = '';
					$row['other_piperun_type'] = $this->input->post("other_piperun_type");
				} else {
					$row['piperun_type_id'] = $this->input->post("piperun_type_id");
					$row['other_piperun_type'] = '';
				}
				$row['gutter_installation'] = $this->input->post("gutter_installation");
				$row['panel_install_location_access'] = $this->input->post("panel_install_location_access");
				$row['stories'] = $this->input->post("stories");
				if ($this->input->post("rafter_type_id") == 'other') {
					$row['rafter_type_id'] = '';
					$row['other_rafter_type'] = $this->input->post("other_rafter_type");
				} else {
					$row['rafter_type_id'] = $this->input->post("rafter_type_id");
					$row['other_rafter_type'] = '';
				}
				$row['roof_color'] = $this->input->post("roof_color");
				$row['roof_pitch'] = $this->input->post("roof_pitch");
				$row['roof_orientation'] = $this->input->post("roof_orientation");
				$row['module_install_location_access'] = $this->input->post("module_install_location_access");
				if ($this->input->post("rafter_type_id") == 'other') {
					$row['rafter_type_id'] = '';
					$row['other_rafter_type'] = $this->input->post("other_rafter_type");
				} else {
					$row['rafter_type_id'] = $this->input->post("rafter_type_id");
					$row['other_rafter_type'] = '';
				}
				$row['rafter_distance'] = $this->input->post("rafter_distance");
				$row['tilt_kit_needed'] = $this->input->post("tilt_kit_needed");
				if ($this->input->post("installation_type_id") == 'other') {
					$row['installation_type_id'] = '';
					$row['other_installation_type'] = $this->input->post("other_installation_type");
				} else {
					$row['installation_type_id'] = $this->input->post("installation_type_id");
					$row['other_installation_type'] = '';
				}				
				$row['contractor_id'] = $this->input->post("contractor_id");
				$row['comments'] = $this->input->post("comments");
			}
			
			$this->db->where("id",$job_id);
			$this->db->update("jobs",$row);
			
			redirect("admin/job/".$job_id);
		}
		
		$this->load->view("common/header");
		$this->load->view("admin/job_$job_type",$data);
		$this->load->view("common/footer");
	}
	
	function delete_job($job_id='')
	{
		// make sure user is either admin or that the job at least belongs to them before deleting
		if($this->session->userdata("role") != 'admin')
		{
			$row = $this->db->query("SELECT * FROM jobs WHERE user_id=".$this->db->escape($this->session->userdata("user_id"))." AND id=".$this->db->escape($job_id))->row_array();
			if (count($row) > 0) {
				$this->db->where("id",$job_id);
				$this->db->delete("jobs");
				
				if($this->input->get("ref"))
				{
					redirect($this->input->get("ref"));
				}
				else
				{
					redirect("admin/jobschedule");
				}
			} else {
				redirect("admin/error?e=permissions");
			}
		}
		else
		{
			$this->db->where("id",$job_id);
			$this->db->delete("jobs");

			if ($this->input->get("ref")) {
				redirect($this->input->get("ref"));
			} else {
				redirect("admin/jobschedule");
			}
		}
	}
	
	function delete_service_call($service_call_id='')
	{
		// make sure user is either admin or that the job at least belongs to them before deleting
		if($this->session->userdata("role") != 'admin')
		{
			$row = $this->db->query("SELECT * FROM service_calls WHERE user_id=".$this->db->escape($this->session->userdata("user_id"))." AND id=".$this->db->escape($service_call_id))->row_array();
			if (count($row) > 0) {
				$this->db->where("id",$service_call_id);
				$this->db->delete("service_calls");
				
				if ($this->input->get("ref")) {
					redirect($this->input->get("ref"));
				} else {
					redirect("admin/jobschedule");
				}
			} else {
				redirect("admin/error?e=permissions");
			}
		}
		else
		{
			$this->db->where("id",$service_call_id);
			$this->db->delete("service_calls");

			if ($this->input->get("ref")) {
				redirect($this->input->get("ref"));
			} else {
				redirect("admin/jobschedule");
			}
		}
	}
	
	function job_financing($job_id='')
	{
		$data = array();
		
		$data['job_id'] = $job_id;
		
		$this->load->library("job");
		$this->load->helper("text");
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();
		
		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
		
		$data['job_statuses'][''] = "- Select a job status -";
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['completed'] = "Completed";
		
		// Grab payment types
		$data['payment_types'][] = '- Select a payment method -';
		$this->db->order_by('type','asc');
		$payment_types = $this->db->get("payment_types")->result_array();
		foreach($payment_types as $row)
		{
			$data['payment_types'][$row['id']] = $row['type'];
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['system_special_pricing'] = $this->input->post("system_special_pricing");
			$row['list_price'] = $this->input->post("list_price");
			$row['referral'] = $this->input->post("referral");
			$row['program_discount'] = $this->input->post("program_discount");
			$row['state_excise_tax'] = $this->input->post("state_excise_tax");
			$row['referral_amount'] = $this->input->post("referral_amount");
			$row['sales_commission'] = $this->input->post("sales_commission");
			$row['state_tax_credit'] = $this->input->post("state_tax_credit");
			$row['federal_tax_credit'] = $this->input->post("federal_tax_credit");
			$row['total_tax_credits'] = $this->input->post("total_tax_credits");
			$row['payment_type_id'] = $this->input->post("payment_type_id");
			$row['financing_comments'] = $this->input->post("financing_comments");
			
			$this->db->where("id",$job_id);
			$this->db->update("jobs",$row);
			
			redirect("admin/job_financing/".$job_id);
		}
		
		// see if we need to notify user to add a referral
		if($data['job']['referral'] == 'y')
		{
			$this->db->where('job_id',$data['job']['id']);
			$refs = $this->db->get("referrals")->result_array();
			if(count($refs) == 0)
			{
				$data['show_referral_popup'] = true;
			}
		}
		
		$this->load->view("common/header");
		$this->load->view("admin/job_financing",$data);
		$this->load->view("common/footer");
	}
	
	function job_referrals($job_id='')
	{
		$this->load->library("job");
		$this->load->helper("text");
		
		$data = array();
		$data['job_id'] = $job_id;
		
		$sql = "SELECT
			referrals.*,
			referral_types.type as referral_type
			FROM
				referrals
			LEFT JOIN referral_types ON referrals.referral_type_id=referral_types.id
			WHERE referrals.job_id=".$this->db->escape($job_id)."
		";
		$data['referrals'] = $this->db->query($sql)->result_array();
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();
		
		// grab job notes
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($data['job']['id'])." LIMIT 3";
		$data['job_notes'] = $this->db->query($sql)->result_array();
		
		// grab job files
		$this->db->where("job_id",$job_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
		
		$data['job_statuses'][''] = "- Select a job status -";
		$data['job_statuses']['forms pending'] = "Forms Pending";
		$data['job_statuses']['to be installed'] = "To Be Installed";
		$data['job_statuses']['completed'] = "Completed";
			
		$this->load->view("common/header");
		$this->load->view("admin/job_referrals",$data);
		$this->load->view("common/footer");
	}
	
	function add_referral($job_id='')
	{
		$this->load->library("job");
		
		$data = array();
		$data['job_id'] = $job_id;
		
		$this->db->where("job_id",$job_id);
		$data['referrals'] = $this->db->get("referrals")->result_array();
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.first_name,
			customers.last_name,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		
		// states array
		$data['states'] =  array('' => "- Choose a state -");
		$data['states'] += array('AK'=>"Alaska",'AL'=>"Alabama",'AR'=>"Arkansas",'AZ'=>"Arizona",'CA'=>"California",'CO'=>"Colorado",'CT'=>"Connecticut",'DC'=>"District Of Columbia",'DE'=>"Delaware",'FL'=>"Florida",'GA'=>"Georgia",'HI'=>"Hawaii",'IA'=>"Iowa",'ID'=>"Idaho",'IL'=>"Illinois", 'IN'=>"Indiana",'KS'=>"Kansas",'KY'=>"Kentucky",'LA'=>"Louisiana",'MA'=>"Massachusetts",'MD'=>"Maryland",'ME'=>"Maine",'MI'=>"Michigan",'MN'=>"Minnesota",'MO'=>"Missouri",'MS'=>"Mississippi",'MT'=>"Montana",'NC'=>"North Carolina",'ND'=>"North Dakota",'NE'=>"Nebraska",'NH'=>"New Hampshire",'NJ'=>"New Jersey",'NM'=>"New Mexico",'NV'=>"Nevada",'NY'=>"New York",'OH'=>"Ohio",'OK'=>"Oklahoma", 'OR'=>"Oregon",'PA'=>"Pennsylvania",'RI'=>"Rhode Island",'SC'=>"South Carolina",'SD'=>"South Dakota",'TN'=>"Tennessee",'TX'=>"Texas",'UT'=>"Utah",'VA'=>"Virginia",'VT'=>"Vermont",'WA'=>"Washington",'WI'=>"Wisconsin",'WV'=>"West Virginia",'WY'=>"Wyoming");
		
		// Grab referral types
		$data['referral_types'][] = '- Select a referral type -';
		$this->db->order_by('type','asc');
		$referral_types = $this->db->get("referral_types")->result_array();
		foreach($referral_types as $row)
		{
			$data['referral_types'][$row['id']] = $row['type'];
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['job_id'] = $job_id;
			$row['referral_type_id'] = $this->input->post("referral_type_id");
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['home_phone'] = $this->input->post("home_phone");
			$row['address'] = $this->input->post("address");
			$row['city'] = $this->input->post("city");
			$row['state'] = $this->input->post("state");
			$row['zip_code'] = $this->input->post("zip_code");
			$row['referral_amount'] = $this->input->post("referral_amount");
			$row['comments'] = $this->input->post("comments");
			
			$this->db->insert("referrals",$row);
			
			redirect("admin/edit_referral/".$this->db->insert_id());
		}
		
		$this->load->view("common/header");
		$this->load->view("admin/add_referral",$data);
		$this->load->view("common/footer");
	}
	
	function edit_referral($referral_id='')
	{
		$this->load->library("job");
		
		$data = array();
		
		$data['referral_id'] = $referral_id;
		
		// grab referral info
		$this->db->where("id",$referral_id);
		$data['referral'] = $this->db->get("referrals")->row_array();
		
		$job_id = $data['referral']['job_id'];
		
		$data['job_id'] = $job_id;
		
		$this->db->where("job_id",$job_id);
		$data['referrals'] = $this->db->get("referrals")->result_array();
		
		if($job_id=='') { redirect('admin/error?e=job_id'); }
		
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.first_name,
			customers.last_name,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
		$data['job'] = $this->db->query($sql)->row_array();
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
		
		$data['job_timestamp'] = strtotime($data['job']['job_date']);
		
		$data['percent_completed'] = $this->job->percent_completed($job_id);
		
		// states array
		$data['states'] =  array('' => "- Choose a state -");
		$data['states'] += array('AK'=>"Alaska",'AL'=>"Alabama",'AR'=>"Arkansas",'AZ'=>"Arizona",'CA'=>"California",'CO'=>"Colorado",'CT'=>"Connecticut",'DC'=>"District Of Columbia",'DE'=>"Delaware",'FL'=>"Florida",'GA'=>"Georgia",'HI'=>"Hawaii",'IA'=>"Iowa",'ID'=>"Idaho",'IL'=>"Illinois", 'IN'=>"Indiana",'KS'=>"Kansas",'KY'=>"Kentucky",'LA'=>"Louisiana",'MA'=>"Massachusetts",'MD'=>"Maryland",'ME'=>"Maine",'MI'=>"Michigan",'MN'=>"Minnesota",'MO'=>"Missouri",'MS'=>"Mississippi",'MT'=>"Montana",'NC'=>"North Carolina",'ND'=>"North Dakota",'NE'=>"Nebraska",'NH'=>"New Hampshire",'NJ'=>"New Jersey",'NM'=>"New Mexico",'NV'=>"Nevada",'NY'=>"New York",'OH'=>"Ohio",'OK'=>"Oklahoma", 'OR'=>"Oregon",'PA'=>"Pennsylvania",'RI'=>"Rhode Island",'SC'=>"South Carolina",'SD'=>"South Dakota",'TN'=>"Tennessee",'TX'=>"Texas",'UT'=>"Utah",'VA'=>"Virginia",'VT'=>"Vermont",'WA'=>"Washington",'WI'=>"Wisconsin",'WV'=>"West Virginia",'WY'=>"Wyoming");
		
		// Grab referral types
		$data['referral_types'][] = '- Select a referral type -';
		$this->db->order_by('type','asc');
		$referral_types = $this->db->get("referral_types")->result_array();
		foreach($referral_types as $row)
		{
			$data['referral_types'][$row['id']] = $row['type'];
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['job_id'] = $job_id;
			$row['referral_type_id'] = $this->input->post("referral_type_id");
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['home_phone'] = $this->input->post("home_phone");
			$row['address'] = $this->input->post("address");
			$row['city'] = $this->input->post("city");
			$row['state'] = $this->input->post("state");
			$row['zip_code'] = $this->input->post("zip_code");
			$row['referral_amount'] = $this->input->post("referral_amount");
			$row['comments'] = $this->input->post("comments");
			
			$this->db->where("id",$referral_id);
			$this->db->update("referrals",$row);
			
			redirect("admin/edit_referral/".$referral_id);
		}
		
		$this->load->view("common/header");
		$this->load->view("admin/edit_referral",$data);
		$this->load->view("common/footer");
	}
	
	function service_call($service_call_id='')
	{
		$data = array();
		
		$this->load->helper("text");
		
		if($service_call_id=='') { redirect('admin/error?e=service_call_id'); }
		
		$sql = "SELECT
			service_calls.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address
			FROM
				service_calls
			LEFT JOIN customers ON service_calls.customer_id=customers.id
			WHERE service_calls.id=".$this->db->escape($service_call_id)."
		";
		$data['service_call'] = $this->db->query($sql)->row_array();
		$data['service_call_timestamp'] = strtotime($data['service_call']['date']);
		
		// grab job files
		$this->db->where("service_call_id",$service_call_id);
		$this->db->order_by("created","desc");
		$data['job_files'] = $this->db->get("files")->result_array();
		
		// Grab contractors
		$data['contractors'][] = '- Select a contractor -';
		$this->db->order_by('contractor','asc');
		$contractors = $this->db->get("contractors")->result_array();
		foreach($contractors as $row) { $data['contractors'][$row['id']] = $row['contractor']; }
		
		// find other active jobs for customer that this job belongs to
		//$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		//$data['other_jobs'] = $this->db->query($sql)->result_array();
		
		// find other service calls
		$sql = "SELECT service_calls.* FROM service_calls WHERE service_calls.customer_id=".$this->db->escape($data['service_call']['customer_id'])." AND service_calls.id!=".$this->db->escape($service_call_id)." ORDER BY service_calls.date ASC";
		$data['other_service_calls'] = $this->db->query($sql)->result_array();
		
		// grab service call notes
		$data['job_notes'] = $this->db->query("SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id=".$this->db->escape($service_call_id)." LIMIT 3")->result_array();
		
		// build times drop-down
		$start = strtotime('9:00am');
		$end = strtotime('9:00pm');

		$data['times_dd'] = array();
		for ($i = $start; $i <= $end; $i += 900)
		{
			$data['times_dd'][date('g:i a', $i)] = date('g:i a', $i);
		}
		
		// grab technician type users
		$technicians = $this->db->query("SELECT * FROM users WHERE type='installer' ORDER BY last_name ASC")->result_array();
		$data['technicians_dd'] = array();
		foreach($technicians as $key => $value)
		{
			$data['technicians_dd'][$value['id']] = $value['first_name']." ".$value['last_name'];
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['technician_id'] = $this->input->post("technician_id");
			$row['repair_time'] = $this->input->post("repair_time");
			$row['repair_type'] = $this->input->post("repair_type");
			$row['description'] = $this->input->post("description");
			$row['contractor_id'] = $this->input->post("contractor_id");
			$row['comments'] = $this->input->post("comments");
			
			$this->db->where("id",$service_call_id);
			$this->db->update("service_calls",$row);
			
			redirect("admin/service_call/".$service_call_id);
		}
		
		$this->load->view("common/header");
		$this->load->view("admin/service_call",$data);
		$this->load->view("common/footer");
	}
	
	function customer($customer_id='')
	{
		$data = array();
		
		$this->load->helper("text");
		
		$data['customer_id'] = $customer_id;
		if($customer_id=='') { redirect('admin/error?e=customer_id'); }
		
		$data['states'] =  array('' => "- Choose a state -");
		$data['states'] += array('AK'=>"Alaska",'AL'=>"Alabama",'AR'=>"Arkansas",'AZ'=>"Arizona",'CA'=>"California",'CO'=>"Colorado",'CT'=>"Connecticut",'DC'=>"District Of Columbia",'DE'=>"Delaware",'FL'=>"Florida",'GA'=>"Georgia",'HI'=>"Hawaii",'IA'=>"Iowa",'ID'=>"Idaho",'IL'=>"Illinois", 'IN'=>"Indiana",'KS'=>"Kansas",'KY'=>"Kentucky",'LA'=>"Louisiana",'MA'=>"Massachusetts",'MD'=>"Maryland",'ME'=>"Maine",'MI'=>"Michigan",'MN'=>"Minnesota",'MO'=>"Missouri",'MS'=>"Mississippi",'MT'=>"Montana",'NC'=>"North Carolina",'ND'=>"North Dakota",'NE'=>"Nebraska",'NH'=>"New Hampshire",'NJ'=>"New Jersey",'NM'=>"New Mexico",'NV'=>"Nevada",'NY'=>"New York",'OH'=>"Ohio",'OK'=>"Oklahoma", 'OR'=>"Oregon",'PA'=>"Pennsylvania",'RI'=>"Rhode Island",'SC'=>"South Carolina",'SD'=>"South Dakota",'TN'=>"Tennessee",'TX'=>"Texas",'UT'=>"Utah",'VA'=>"Virginia",'VT'=>"Vermont",'WA'=>"Washington",'WI'=>"Wisconsin",'WV'=>"West Virginia",'WY'=>"Wyoming");
		
		// grab customer info
		$this->db->where("id",$customer_id);
		$data['customer'] = $this->db->get("customers")->row_array();
		
		// find existing, other customers with this address...
		$this->db->where("address !=",'');
		$this->db->where("city !=",'');
		$this->db->where("state !=",'');
		$this->db->where("address",$data['customer']['address']);
		$this->db->where("city",$data['customer']['city']);
		$this->db->where("state",$data['customer']['state']);
		$this->db->where("id !=", $data['customer']['id']);
		$data['duplicate_customers'] = $this->db->get("customers")->result_array();
		if(count($data['duplicate_customers'])> 0)
		{
			$data['duplicate_addresses'] = true;
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['customer_type_id'] = $this->input->post("customer_type_id");
			$row['household_type_id'] = $this->input->post("household_type_id");
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['home_phone'] = $this->input->post("home_phone");
			$row['secondary_phone'] = $this->input->post("secondary_phone");
			$row['email'] = $this->input->post("email");
			$row['address'] = $this->input->post("address");
			$row['city'] = $this->input->post("city");
			$row['state'] = $this->input->post("state");
			$row['zip_code'] = $this->input->post("zip_code");
			$row['neighborhood'] = $this->input->post("neighborhood");
			$row['association'] = $this->input->post("association");
			$row['household_members'] = $this->input->post("household_members");
			$row['avg_electric_bill'] = $this->input->post("avg_electric_bill");
			$row['sun_zone'] = $this->input->post("sun_zone");
			$row['heco_account_number'] = $this->input->post("heco_account_number");
			$row['heco_meter_number'] = $this->input->post("heco_meter_number");
			$row['comments'] = $this->input->post("comments");

			$this->db->where("id",$customer_id);
			$this->db->update("customers",$row);

			redirect("admin/customer/".$customer_id);
		}
		
		// grab customer's jobs
		$sql = "SELECT jobs.*,job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($customer_id)." LIMIT 3";
		$data['jobs'] = $this->db->query($sql)->result_array();
		
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes INNER JOIN jobs ON notes.job_id=jobs.id LEFT JOIN users ON notes.user_id=users.id WHERE jobs.customer_id=".$this->db->escape($customer_id)." LIMIT 3";
		$data['notes'] = $this->db->query($sql)->result_array();
		
		// grab customer files
		$sql = "SELECT files.* FROM files INNER JOIN jobs ON files.job_id=jobs.id INNER JOIN customers ON jobs.customer_id=customers.id WHERE jobs.customer_id=".$this->db->escape($customer_id)." ORDER BY files.created DESC LIMIT 3";
		$data['customer_files'] = $this->db->query($sql)->result_array();
		
		// grab household types
		$sql = "SELECT * FROM household_types ORDER BY `type` ASC";
		$htypes = $this->db->query($sql)->result_array();
		$data['household_types'][] = '- Choose a household type';
		foreach($htypes as $h)
		{
			$data['household_types'][$h['id']] = $h['type'];
		}
		
		#die(print_r($data['customer_files']));
			
		$this->load->view("common/header");
		$this->load->view("admin/customer",$data);
		$this->load->view("common/footer");
	}
	
	function customer_jobs($customer_id='')
	{
		$data = array();
			
		$this->load->view("common/header");
		$this->load->view("admin/customer_jobs",$data);
		$this->load->view("common/footer");
	}
	
	function profile()
	{
		$data = array();
		$data['validation_errors'] = false;
		$data['updated'] = false;
		
		// grab user data for form
		$data['user'] = $this->db->query("SELECT * FROM users WHERE id=".$this->db->escape($this->session->userdata("user_id")))->row_array();
		
		if($this->input->post("dosubmit"))
		{
			$this->load->library('validation');
			
			if($this->input->post("email") != $this->session->userdata("email")) 
			{
				$rules['email']	= "required|valid_email|callback_email_exists";
			} 
			else 
			{
				$rules['email']	= "required|valid_email";
			}

			$rules['first_name']	= "required";
			$rules['last_name']	= "required";
			if($this->input->post("new_password"))
			{
				$rules['password'] = "callback_password_check";
				$rules['new_password']	= "required|matches[new_password2]";
				$rules['new_password2']	= "required";
			}
			
			$this->validation->set_rules($rules);
			
			$fields['password']	= 'Password';
			$fields['new_password']	= 'New Password';
			$fields['new_password2'] = 'New Password Confirmation';
			$fields['email'] = 'Email Address';
			$fields['first_name'] = 'First Name';
			$fields['last_name'] = 'Last Name';

			$this->validation->set_fields($fields);

			if ($this->validation->run() == FALSE)
			{
				$data['validation_errors'] = true;
			}
			else
			{
				$data['updated'] = true;
				$row = array();
				$row['email'] = $this->input->post("email");
				$row['first_name'] = $this->input->post("first_name");
				$row['last_name'] = $this->input->post("last_name");
				if($this->input->post("new_password"))
				{
					$row['password'] = md5($this->input->post("new_password"));
				}
				$this->db->where("id",$this->session->userdata("user_id"));
				$this->db->update("users",$row);
				
				// grab updated user data for form
				$data['user'] = $this->db->query("SELECT * FROM users WHERE id=".$this->db->escape($this->session->userdata("user_id")))->row_array();
				$this->session->set_userdata('email', $this->input->post("email"));
			}
		}
		
		$this->load->view("common/header");
		$this->load->view("admin/profile",$data);
		$this->load->view("common/footer");
	}
	
	function search()
	{
		$data = array();
		
		$data['keywords'] = $this->input->get("q");
		$data['search_results'] = $this->db->query("SELECT customers.* FROM customers WHERE customers.first_name LIKE '%".mysql_escape_string($data['keywords'])."%' OR customers.last_name LIKE '%".mysql_escape_string($data['keywords'])."%' OR customers.address LIKE '%".mysql_escape_string($data['keywords'])."%'")->result_array();
		
		$this->load->view("common/header");
		$this->load->view("admin/search",$data);
		$this->load->view("common/footer");
	}
	
	function news()
	{
		$data = array();
			
		$this->load->view("common/header");
		$this->load->view("admin/news",$data);
		$this->load->view("common/footer");
	}
	
	function view_news($news_id)
	{
		$data = array();
			
		$this->load->view("common/header");
		$this->load->view("admin/view_news",$data);
		$this->load->view("common/footer");
	}
	
	function myjobs()
	{
		$data = array();
		
		$this->load->helper("date");
		$this->load->helper("text");
		
		$yearmonth = $this->input->get("yearmonth");
		$day = $this->input->get("day");
		$endyearmonth = $this->input->get("endyearmonth");
		$endday = $this->input->get("endday");
		
		if($yearmonth=='') {$yearmonth = date("Ym",strtotime("-1 month"));}
		if($day=='') {$day = date("d",strtotime("-1 month"));}
		$yearmonth = preg_replace("/[^0-9]/","",$yearmonth);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['yearmonth'] = $yearmonth;
		$data['day'] = $day;
		
		if($endyearmonth=='') {$endyearmonth = date("Ym",strtotime("+1 month"));}
		if($endday=='') {$endday = date("d",strtotime("+1 month"));}
		$endyearmonth = preg_replace("/[^0-9]/","",$endyearmonth);
		$endday = preg_replace("/[^0-9]/","",$endday);
		$data['endyearmonth'] = $endyearmonth;
		$data['endday'] = $endday;
		
		$limit = $this->input->get("limit");
		if($limit > 20 or $limit == '')
		{
			$limit = 5;
		}
		if($limit == 'all')
		{
			$limit = '9999';
		}
		$data['limit'] = $limit;
		
		$extra_jobs_sql = '';
		$extra_sc_sql = '';
		if($this->session->userdata('role') != 'admin')
		{
			$extra_jobs_sql = " AND jobs.user_id=".$this->db->escape($this->session->userdata("user_id"));
			$extra_sc_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata("user_id"));
		}
		
		// get jobs and service calls matching desired dates
		$sql = "SELECT jobs.*, customers.first_name, customers.last_name, customers.address, customers.city, customers.state, job_types.type as job_type FROM jobs LEFT JOIN customers ON jobs.customer_id=customers.id LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE DATE_FORMAT(jobs.job_date,'%Y%m%d') >= '".$data['yearmonth'].$data['day']."' AND DATE_FORMAT(jobs.job_date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."' $extra_jobs_sql";
		#die(print($sql));
		$jobs = $this->db->query($sql)->result_array();
		$sql = "SELECT service_calls.*, customers.first_name, customers.last_name, customers.address, customers.city, customers.state FROM service_calls LEFT JOIN customers ON service_calls.customer_id=customers.id WHERE DATE_FORMAT(service_calls.date,'%Y%m%d') >= '".$data['endyearmonth'].$data['day']."' AND DATE_FORMAT(service_calls.date,'%Y%m%d') <= '".$data['endyearmonth'].$data['endday']."' $extra_sc_sql";
		$service_calls = $this->db->query($sql)->result_array();
		
		#die(print_r($jobs));
		
		$data['jobs'] = array();
		foreach($jobs as $key => $job)
		{
			$data['jobs'][strtotime($job['job_date'])] = $job;
		}
		foreach($service_calls as $key => $service_call)
		{
			$data['jobs'][strtotime($service_call['date'])] = $service_call;
		}
		ksort($data['jobs']);
		
		// get unique month/year's logged-in user has jobs on
		$sql = "SELECT DISTINCT DATE_FORMAT(jobs.job_date,'%Y%m') as yearmonth, job_date FROM jobs WHERE id != '0' $extra_jobs_sql ORDER BY yearmonth ASC";
		#die(print($sql));
		$job_months = $this->db->query($sql)->result_array();
		$service_call_months = $this->db->query("SELECT DISTINCT DATE_FORMAT(service_calls.date,'%Y%m')  as yearmonth, date FROM service_calls WHERE id !='0' $extra_sc_sql ORDER BY yearmonth ASC")->result_array();

		$data['calendar_months'] = ($job_months + $service_call_months);
		
		//$data['calendar_months'] = array_unique($data['calendar_months']);
		
		$data['year_month_dd'] = array();
		foreach($data['calendar_months'] as $ym)
		{
			if (@$ym['date']) {
				// only add yearmonth combos that are new
				if(!array_key_exists(date("M Y",strtotime($ym['date'])),$data['year_month_dd']))
				{
					$data['year_month_dd'][$ym['yearmonth']] = date("M Y",strtotime($ym['date']));
				}
			} else {
				if(!array_key_exists(date("M Y",strtotime($ym['job_date'])),$data['year_month_dd']))
				{
					$data['year_month_dd'][$ym['yearmonth']] = date("M Y",strtotime($ym['job_date']));
				}
			}
		}
		
		// day drop down
		$days_count = days_in_month(substr($yearmonth,-2,2),substr($yearmonth,0,4));
		for($i=1; $i<$days_count+1; $i++)
		{
			$data['day_dd'][sprintf("%02d",$i)] = sprintf("%02d",$i);
		}
		
		// limit drop-down
		$data['limit_dd']['5'] = '5';
		$data['limit_dd']['10'] = '10';
		$data['limit_dd']['20'] = '20';
		$data['limit_dd']['all'] = 'all';
		
		$this->load->view("common/header");
		$this->load->view("admin/myjobs",$data);
		$this->load->view("common/footer");
	}
	
	function users()
	{
		if($this->session->userdata("role") != 'admin')
		{
			redirect("admin/error?e=permissions");
		}
		
		$data = array();
		
		$data['users'] = $this->db->query("SELECT users.*, colors.nickname as color, colors.hex FROM users LEFT JOIN colors ON users.color_id=colors.id ORDER BY users.last_name ASC")->result_array();

		$this->load->view("common/header");
		$this->load->view("admin/users",$data);
		$this->load->view("common/footer");
	}
	
	function edit_user($user_id='')
	{
		$data = array();
		
		if($this->input->get("updated"))
		{
			$data['updated'] = true;
		}
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['color_id'] = $this->input->post("color_id");
			$row['type'] = $this->input->post("type");
			$row['email'] = $this->input->post("email");
			$row['custom_hex'] = $this->input->post("custom_hex");
			if ($this->input->post("installer_permissions") == 'y') {
				$row['installer_permissions'] = 'y';
			} else {
				$row['installer_permissions'] = 'n';
			}
			if($this->input->post("password"))
			{
				$row['password'] = md5($this->input->post("password"));
			}
			$this->db->where("id",$user_id);
			$this->db->update("users",$row);
			
			// update session data
			if($user_id == $this->session->userdata("user_id"))
			{
				$sql = "SELECT colors.* FROM colors WHERE id=".$this->db->escape($this->input->post("color_id"));
				$color = $this->db->query($sql)->row_array();
				
				if(@$row['custom_hex'] != '')
				{
					$hex = $row['custom_hex'];
				}
				else
				{
					if(@$row['type'] == 'admin')
					{			
						$hex = '7DBB4C';
					}
					else
					{
						$hex = $color['hex'];
					}
				}
				
				$this->session->set_userdata('role', $row['type']);
				$this->session->set_userdata('hex_color', $hex);
			}
			
			redirect("admin/edit_user/".$user_id."?updated=true");
		}
		
		$data['user'] = $this->db->query("SELECT users.*, colors.nickname as color, colors.hex FROM users LEFT JOIN colors ON users.color_id=colors.id WHERE users.id=".$this->db->escape($user_id)." ORDER BY users.last_name ASC")->row_array();

		$data['roles'] = array();
		$data['roles']['admin'] = 'Admin';
		$data['roles']['sales'] = 'Salesperson';
		$data['roles']['installer'] = 'Installer';
		
		$data['colors'] = $this->db->get("colors")->result_array();

		$this->load->view("common/header");
		$this->load->view("admin/edit_user",$data);
		$this->load->view("common/footer");
	}
	
	function new_user()
	{
		$data = array();
		
		if($this->input->post("dosubmit"))
		{
			$row = array();
			$row['first_name'] = $this->input->post("first_name");
			$row['last_name'] = $this->input->post("last_name");
			$row['color_id'] = $this->input->post("color_id");
			$row['type'] = $this->input->post("type");
			$row['email'] = $this->input->post("email");
			$row['custom_hex'] = $this->input->post("custom_hex");
			if($this->input->post("password"))
			{
				$row['password'] = md5($this->input->post("password"));
			}

			$this->db->insert("users",$row);
			
			redirect("admin/users");
		}

		$data['roles'] = array();
		$data['roles']['admin'] = 'Admin';
		$data['roles']['sales'] = 'Salesperson';
		$data['roles']['installer'] = 'Installer';
		
		$data['colors'] = $this->db->get("colors")->result_array();

		$this->load->view("common/header");
		$this->load->view("admin/new_user",$data);
		$this->load->view("common/footer");
	}
	
	function delete_user($user_id)
	{
		if($this->session->userdata("role") == 'admin')
		{
			$this->db->where("id",$user_id);
			$this->db->delete("users");
			redirect("admin/users");
		}
		else
		{
			redirect("admin/error?e=permissions");
		}
	}
	
	function password_check($password)
	{
		$row = $this->db->query("SELECT * FROM users WHERE password=".($this->db->escape(md5($this->input->post("password"))))." AND email=".$this->db->escape($this->input->post("email")))->row_array();
		
		if (count($row) == 0)
		{
			$this->validation->set_message('password_check', 'Current password is incorrect');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function email_exists($email)
	{
		$row = $this->db->query("SELECT * FROM users WHERE email=".$this->db->escape($this->input->post("email")))->row_array();
		if (count($row) > 0)
		{
			$this->validation->set_message('email_exists', 'That email address already exists');
			return FALSE;
		}
		else
		{
			return TRUE;
		}
	}
	
	function download($file_id='')
	{
		$this->load->helper('download');
		
		$this->db->where('id',$file_id);
		$file = $this->db->get("files")->row_array();
		
		$data = file_get_contents($_SERVER['DOCUMENT_ROOT']."/uploads/".$file['unique_filename']); // Read the file's contents
		$name = $file['original_filename'];

		force_download($name, $data);
	}
	
	function config()
	{
		$data = array();
		
		$data['tables'] = array();
		$data['tables']['fan_brands'] = array('fkey' => 'brand');
		$data['tables']['fan_sizes'] = array('fkey' => 'size');
		$data['tables']['installation_types'] = array('fkey' => 'type');
		$data['tables']['inverter_brands'] = array('fkey' => 'brand');
		$data['tables']['inverter_types'] = array('fkey' => 'type');
		$data['tables']['module_brands'] = array('fkey' => 'brand');
		$data['tables']['module_powers'] = array('fkey' => 'power');
		$data['tables']['panel_sizes'] = array('fkey' => 'size');
		$data['tables']['panel_types'] = array('fkey' => 'type');
		$data['tables']['piperun_types'] = array('fkey' => 'type');
		$data['tables']['rafter_types'] = array('fkey' => 'type');
		$data['tables']['referral_types'] = array('fkey' => 'type');
		$data['tables']['roof_types'] = array('fkey' => 'type');
		$data['tables']['service_panel_amperages'] = array('fkey' => 'amperage');
		$data['tables']['tank_brands'] = array('fkey' => 'brand');
		$data['tables']['tank_sizes'] = array('fkey' => 'size');
		$data['tables']['fan_brands'] = array('fkey' => 'brand');
		$data['tables']['wire_run_types'] = array('fkey' => 'type');
		$data['tables']['household_types'] = array('fkey' => 'type');
		$data['tables']['contractors'] = array('fkey' => 'contractor');
		
		foreach($data['tables'] as $key => $value)
		{
			$this->db->order_by($value['fkey'],'asc');
			$data['tables'][$key]['rows'] = $this->db->get($key)->result_array();
		}
		
		$row = $this->db->get("job_limit")->row_array();
		$data['daily_limit'] = $row['limit'];
		
		for($i=0; $i<20; $i++)
		{
			$data['daily_limits'][$i] = $i;
		}
		
		if($this->input->post("dosubmit"))
		{
			foreach($data['tables'] as $key => $value)
			{
				// explode textbox values into array
				$options = array();
				$options = explode("\n", $this->input->post($key));
				// remove empty options (in case there were additional line breaks)
				foreach($options as $k => $o) 
				{
					if(trim($o) == '')
					{
						unset($options[$k]);
					}
				}
				#die(print_r($options));
				if(count($options) > 0)
				{
					foreach($options as $option)
					{						
						$matched_rows = array();
						$sql = "SELECT * FROM $key WHERE UPPER(".$value['fkey'].") = ".$this->db->escape(strtoupper($option));
						$matched_rows = $this->db->query($sql)->result_array();
						
						// look for new values
						$new = array();
						if(count($matched_rows) == 0)
						{
							$new[$value['fkey']] = $option;
							$this->db->insert($key,$new);
						}
						
						// delete old values
						$existing_rows = array();
						$existing_rows = $this->db->get($key)->result_array();
						foreach($existing_rows as $row)
						{
							if(!in_array($row[$value['fkey']],$options))
							{
								$sql = "DELETE FROM $key WHERE id = ".$this->db->escape($row['id']);
								$this->db->query($sql);
							}
						}
					}
				}
			}
			
			redirect("admin/config");
		}
		
		$this->load->view("common/header");
		$this->load->view("admin/config",$data);
		$this->load->view("common/footer");
	}
	
	function delete_file($file_id='')
	{
		$this->db->where('id',$file_id);
		$file = $this->db->get("files")->row_array();
		
		$this->db->where("id",$file_id);
		$this->db->delete('files');
		
		redirect("admin/job/".$file['job_id']);
	}

        function    installer_available($year='', $month='', uid='')
	{
		$this->load->library("job");
		$this->load->helper("date");
		$data = array();
		$prefs = array (
			'start_day'    => 'sunday',
			'month_type'   => 'long',
			'day_type'     => 'long'
		);

		$jobs = array();

		if($year=='') {$year = date("Y");}
		if($month=='') {$month = date("m");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$data['year'] = $year;
		$data['month'] = $month;

		// daily job limit
		$daily_limit = $this->db->get("job_limit")->row_array();
		$daily_limit = $daily_limit['limit'];

		// create calendar and year dd values and set which should be preselected
		$data['calendar_months'] = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
		$data['calendar_years'] = array();
		for($i=date("Y",strtotime("-2 years")); $i<date("Y",strtotime("+2 years")); $i++)
		{
			$data['calendar_years'][$i] = $i;
		}
		$data['calendar_month'] = $data['month'];
		$data['calendar_year'] = $data['year'];

		// get jobs for the current month
		$j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id FROM jobs LEFT JOIN users ON jobs.user_id=users.id LEFT JOIN colors ON users.color_id=colors.id  WHERE DATE_FORMAT(jobs.job_date,'%Y-%m') = '".$year."-".$month."' AND jobs.user_id='".uid."' ORDER BY jobs.job_date ASC")->result_array();
		foreach($j as $key => $value)
		{
			$jobs[date("j", strtotime($value['job_date']))][] = $value;
		}
		$days_count = days_in_month($month,$year);

		
		#die(print(count($service_calls)));
                $number_installer = 12;
		for($i=0; $i<($days_count+1); $i++)
		{
                    if($value['job_count']<12){
                        $data['dates'][$i] = '<div style="background:#'.$color.';" class="booked-day-wrap tooltip" title="Go To Day View">'.$value["no_installer_allocated"].'</div>';
                    }
		}

		$prefs['template'] = '

		   {table_open}<table class="calendar" border="0" cellpadding="0" cellspacing="1">{/table_open}

		   {heading_row_start}<tr>{/heading_row_start}

		   {heading_previous_cell}<th></th>{/heading_previous_cell}
		   {heading_title_cell}<th colspan="{colspan}">{heading}</th>{/heading_title_cell}
		   {heading_next_cell}<th></th>{/heading_next_cell}

		   {heading_row_end}</tr>{/heading_row_end}

		   {week_row_start}<tr class="week-days">{/week_row_start}
		   {week_day_cell}<td style="background:#7D7D7D;"><div align="left" style="color:#fff;">{week_day}</div></td>{/week_day_cell}
		   {week_row_end}</tr>{/week_row_end}

		   {cal_row_start}<tr>{/cal_row_start}
		   {cal_cell_start}<td>{/cal_cell_start}

			{cal_cell_content}
		    <div class="cell-inner-big">
				<a href="/ajax/quick_summary/'.$year.'/'.$month.'/{day}" class="facebox quick-summary tooltip" title="Quick Summary"><img src="/assets/images/magnifier.png" /></a>
				{content}
			</div>
			{/cal_cell_content}
			{cal_cell_content_today}
			<div class="cell-inner-big">
				<a href="/ajax/quick_summary/'.$year.'/'.$month.'/{day}" class="facebox quick-summary tooltip" title="Quick Summary"><img src="/assets/images/magnifier.png" /></a>
				{content}
			</div>
			{/cal_cell_content_today}

			{cal_cell_no_content}
			<div class="cell-inner-big">
				<div class="reserve-job-block">';

			if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
			{
				//$prefs['template'] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Reserve a Job"><img src="/assets/images/blank.gif" /></a></div>';
			}

			$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content}
			{cal_cell_no_content_today}
			<div class="cell-inner-big">
				<div class="reserve-job-block">';

			if(!($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y'))
			{
				//$prefs['template'] .= '<a href="/ajax/reserve_job/'.$year.'/'.$month.'/{day}" class="facebox reserve-job tooltip" title="Reserve a Job"><img src="/assets/images/blank.gif" /></a></div>';
			}

			$prefs['template'] .= '
				<span class="day-block">{day}</span>
			</div>
			{/cal_cell_no_content_today}

		   {cal_cell_blank}&nbsp;{/cal_cell_blank}

		   {cal_cell_end}</td>{/cal_cell_end}
		   {cal_row_end}</tr>{/cal_row_end}

		   {table_close}</table>{/table_close}
		';

		$this->load->library('calendar',$prefs);

		$this->load->view("common/header");
		$this->load->view("admin/jobschedule",$data);
		$this->load->view("common/footer");
	}

}

?>