<?php

class Technician_summary extends Controller {

    function Technician_summary() {
        parent::Controller();
        if (!$this->session->userdata('logged_in')) {
            $tempurl = explode("/index.php/", $_SERVER['PHP_SELF']);
            redirect("login?ref=" . $tempurl[1]);
        }
        $this->load->helper(array('form', 'url'));
    }

    function index($month = 0, $date = 0, $year = 0) {
        $data = array();
        if ($month && ($date) && $year) {
            $from_date = $year . '/' . $month . '/' . $date;
            $from_date = strtotime($from_date);
        } else {
            $from_date = strtotime('last Sunday');
        }
        $from_date = date('Y-m-d', $from_date);
        $to_date = date('Y-m-d', strtotime('+6 days', strtotime($from_date)));

        $data['date'] = date("M d,Y", strtotime($from_date)) . " - " . date("M d,Y", strtotime($to_date));
        $data['from_date'] = strtotime($from_date);
        $data['to_date'] = strtotime('+6 days', $data['from_date']);
        $date_filter = "";

        $data['reasons']['ok'] = 'OK';
        $data['reasons']['1'] = 'SIC';
        $data['reasons']['3'] = 'VAC';
        $data['reasons']['9'] = 'OFF';

        $RightsideExist = 1;
        $filterDate = 0;
        $data["filterDate"] = $filterDate;

        $data["RightsideExist"] = $RightsideExist;
        $data['team_details'] = array();
        $data['team_types'] = array();

        if (@$RightsideExist) {

            $filter_by_date = "and DATE_FORMAT(request.start_date,'%Y-%m-%d') <= '" . $filterDate . "' AND DATE_FORMAT(request.end_date,'%Y-%m-%d') >= '" . $filterDate . "'";

            $team_types = $this->db->query("select * from technician_team_types order by id")->result_array();
            $data['team_types'] = $team_types;
          
            foreach ($team_types as $types) {
                $teamsInType = array();
                $teamsInType = $this->db->query("select distinct id from technician_teams where team_type_id=" . $types['id'] . "")->result_array();
               if (count($teamsInType) > 0) {
                    $count = 1;
                    foreach ($teamsInType as $TeamsName) {       
                        $team_wise_tech = array();
                        $team_wise_tech = $this->db->query("select team_names.id as technician_team_id, team_names.created as team_created,team_names.team_name,assigns.technician_id_time,assigns.technician_id_pheo,assigns.technician_email,assigns.assigned FROM technician_teams as team_names LEFT JOIN technicians_assign as assigns ON team_names.id=assigns.team_id where team_names.id=" . $TeamsName['id'] . " and assigns.team_type_id=" . $types['id'] . " and team_names.team_type_id=" . $types['id'] . "")->result_array();

                        if (count($team_wise_tech) > 0) {
                            $technician_id_time = '';
                            $technician_id_pheo = '';
                            $technicians_names = '';

                            foreach ($team_wise_tech as $Technicians) { 
                                $technicians_names = $this->GetUserName($Technicians['technician_id_pheo'], true);
                                $technicianss_name = rtrim($technicians_names, ", ");
                                $team_wise_data['technicians_names'] = $technicianss_name;

                                $technicians_type = $this->GetTechnicianType($Technicians['technician_id_pheo']);
                                $team_wise_data['technicians_type'] = $technicians_type;

                                $team_wise_data['team_type_id'] = $types['id'];
                                $team_wise_data['technician_team_id'] = $TeamsName['id'];
                                $team_wise_data['team_type'] = $types['team_type_name'];
                                $team_wise_data['assigned'] = $this->check_assigned(@$Technicians['technician_id_pheo'], @$TeamsName['id'], @$job_id_sql);
                                $team_wise_data['team_name'] = $Technicians['team_name'];
                                $team_wise_data['team_created'] = $Technicians['team_created'];

                                $team_wise_data['technician_id_time'] = $Technicians['technician_id_time'];
                                $team_wise_data['technician_id_pheo'] = $Technicians['technician_id_pheo'];
                               // $team_wise_data['work_hours'] = $this->work_hours($Technicians['technician_id_time']);
                                $team_wise_data['techInTeam'] = ucfirst($Technicians['team_name'][0]) . ucfirst($Technicians['team_name'][1]) . $count;

                                $team_wise_data[$Technicians['technician_id_pheo']] = $this->GetAllJObsData($Technicians['technician_id_pheo'], $Technicians['technician_id_time'], strtotime($from_date));

                                $this->db2->close();

                                $pieces = explode(" ", $types['team_type_name']);
                                $Ttype = $pieces[0] . ' ' . $count;

                                //$data['team_details'][$types['id']][$Technicians['team_name']][] = $team_wise_data;
                                $data['team_details'][$types['id']][$Ttype][] = $team_wise_data;
                            }
                            $count++;
                        }
                    }
                }
            }
        }
        
        
        $data['team_details_data'] = $this->SortAllData($data['team_details']);
        
        
        $date_filter = "jobs.job_date>='" . $from_date . "' and jobs.job_date<='".$to_date."'";
 $this->db=$this->load->database('default', true);
        $j_r = $this->db->query("SELECT jobs.*, jobs.system_type,colors.hex, users.custom_hex, users.id as user_id ,users.first_name as ufirstname ,
                        users.last_name ulastname, cs.first_name as csfirstname ,
                        cs.last_name as cslastname ,cs.address as csstate,cs.city as cscity,cs.association as  csassociation,cs.zip_code as  zip_code,
                        job_types.intials as job_type
                        FROM jobs
                        LEFT JOIN job_types ON job_types.id=jobs.job_type_id
                        LEFT JOIN  customers cs ON jobs.customer_id = cs.id
                        LEFT JOIN users ON jobs.user_id=users.id
                        LEFT JOIN colors ON users.color_id=colors.id
                        WHERE $date_filter  ORDER BY jobs.job_date ASC ,job_type ASC")->result_array();
        
        $combined_total_hours=0;
        
        foreach ($j_r as $jobs_details)
        {
            $proposal_id=@$jobs_details['proposal_id'];
            
            $combined_total_hours+=$this->getProposalJobhours($proposal_id,@$jobs_details['job_type_id']);
           
        }
        $data['combined_total_hours']=$combined_total_hours;
        
        $submit_filter1 = "and submited_date='" .$from_date. "'";
        
        $technician = $this->db->query("SELECT technician_id_time FROM technicians_assign")->result_array();
        $technician_user=array();
        foreach ($technician as $val){
            $technician_user[]=$val['technician_id_time'];
        }
        
        $this->db2 = $this->load->database('otherdb', true);
       
       
        $q2= $this->db2->query("SELECT sum(total) as total  FROM user_calculated_time_sheet_details  where user_id in (" . implode(',', $technician_user) . ")  $submit_filter1 ");
        $timesheet_total_hours =$q2->row_array();
       
        $data['timesheet_total_hours']=$timesheet_total_hours['total'];
        
    // echo '<pre>';print_r($data['team_details']);die;
        $this->load->view("dayview/technician_summary", $data);
         $this->db=$this->load->database('default', true);
    }
    
    function SortAllData($details = '') {
        if (count($details) > 0) {
            $filterData = array();
            foreach (@$details as $key => $value) {
                foreach (@$value as $key1 => $value1) {
                    $filterData[$key1] = array();
                    foreach (@$value1 as $key2 => $value2) {
                        $filterData[$key1][$value2['technicians_names']] = array();
                        $filterData[$key1][$value2['technicians_names']]['team_type'] = $value2['team_type'];
                        $filterData[$key1][$value2['technicians_names']]['team_type_id'] = $value2['team_type_id'];
                        $filterData[$key1][$value2['technicians_names']]['technician_id_time'] = $value2['technician_id_time'];
                        $filterData[$key1][$value2['technicians_names']]['technician_id_pheo'] = $value2['technician_id_pheo'];
                        $filterData[$key1][$value2['technicians_names']]['technicians_names'] = $value2['technicians_names'];
                        //$dollar = @$value2[$value2['technician_id_pheo']];
                        
                        $worked_hours=0;
                        $job_hours=0;
                        foreach (@$value2[$value2['technician_id_pheo']] as $key3 => $value3) {
                            foreach ($value3 as $key5 => $value5) {
                                //echo '<pre>';
                                //print_r($value5);
                                if($value5['technician_status']=='OK'){
                                    if (count($value5[$key3]) > 0) {
                                        $custname='';
                                        foreach ($value5[$key3] as $key7 => $value7) { 
                                            $custname .= $value7['customer_status'];
                                            
                                        }
                                        //$worked_hours += $value7['technician_worked_hours'];
                                        
                                        $worked_hours= $value5['technician_worked_hours'];
                                        $job_hours+= $value5['job_hours'];
                                        
                                        $filterData[$key1][$value2['technicians_names']]['timeoff_request_id'] = $value5['timeoff_request_id'];
                                        $filterData[$key1][$value2['technicians_names']]['timeoff_reason'] = $value5['timeoff_reason'];
                                        $filterData[$key1][$value2['technicians_names']]['technin_status'] = $value5['technician_status'];
                                        $filterData[$key1][$value2['technicians_names']][$key3] = rtrim($custname,',');
                                    }else{
                                        $worked_hours= $value5['technician_worked_hours'];
                                        
                                        $filterData[$key1][$value2['technicians_names']]['timeoff_request_id'] = $value5['timeoff_request_id'];
                                        $filterData[$key1][$value2['technicians_names']]['timeoff_reason'] = $value5['timeoff_reason'];
                                        $filterData[$key1][$value2['technicians_names']]['technin_status'] = $value5['technician_status'];
                                        $filterData[$key1][$value2['technicians_names']][$key3] = '';
                                    }
                                }else{
                                    $worked_hours += 0;
                                    $filterData[$key1][$value2['technicians_names']]['timeoff_request_id'] = $value5['timeoff_request_id'];
                                    $filterData[$key1][$value2['technicians_names']]['timeoff_reason'] = $value5['timeoff_reason'];
                                    $filterData[$key1][$value2['technicians_names']]['technin_status'] = $value5['technician_status'];
                                    $filterData[$key1][$value2['technicians_names']][$key3] = $value5['timeoff_reason'];
                                }
                            }
                            
                            $filterData[$key1][$value2['technicians_names']]['total-hours'] = $worked_hours;
                            $filterData[$key1][$value2['technicians_names']]['job_hours'] = $job_hours;
                        }
                    }
                }
            }
            return $filterData;
        } else {
            return 0;
        }
    }

    function GetAllJObsData($InstallerId = 0, $timesheetId = 0, $form_date = 0) {
        if (!$InstallerId) {
            return 0;
        }
        $pv_sql = "AND FIND_IN_SET(" . $this->db->escape($InstallerId) . ",installer_id)";
        $job_sql = " AND jobs.job_type_id in(2,16,1,15,5,7,23)";
        $job_sql = " ";
        $this->db2 = $this->load->database('otherdb', true);
        $team_wise_data = array();

        $submit_filter1 = "and t_c.submited_date='" . date('Y-m-d', $form_date) . "'";
        
        $q2 = $this->db2->query("SELECT t_c.* FROM user_calculated_time_sheet_details as t_c where t_c.user_id ='" . $timesheetId . "'  $submit_filter1 ");
        $TimeSheetdetails_cal_total = $q2->row_array();
        
        for ($j = 0; $j < 7; $j++) {

            $form_date = date('Y-m-d', $form_date);
            $date_filter = "jobs.job_date='" . $form_date . "'";

            $filter_by_date = "and DATE_FORMAT(request.start_date,'%Y-%m-%d') <= '" . $form_date . "' AND DATE_FORMAT(request.end_date,'%Y-%m-%d') >= '" . $form_date . "'";
$this->db2 = $this->load->database('otherdb', true);
            $request_details = $this->db2->query("select request.*, emp_users.first_name,emp_users.last_name,emp_users.id as user_id,codes.name as reason FROM emp_timeoff_request as request LEFT JOIN emp_users ON request.user_id=emp_users.id LEFT JOIN absence_codes as codes ON request.timeoff_reason=codes.id WHERE request.user_id='" . $timesheetId . "' $filter_by_date order by request.id desc limit 1");
            $details = $request_details->row_array();
            $team_wise_data = array();
            if (count($details) > 0) {
                if ($details['request_status'] == 'approved' && $details['confirm_request'] == 'Y') {
                    $team_wise_data['technician_status'] = ucfirst($details['reason'][0]) . ucfirst($details['reason'][1]) . ucfirst($details['reason'][2]);
                    $team_wise_data['timeoff_request_id'] = $details['id'];
                    $tech_status = 0;
                    if ($details['timeoff_reason'] == 1) {
                        $team_wise_data['timeoff_reason'] = 1;
                    } else if ($details['timeoff_reason'] == 3) {
                        $team_wise_data['timeoff_reason'] = 3;
                    } else {
                        $team_wise_data['timeoff_reason'] = 9;
                    }
                } else {
                    $team_wise_data['technician_status'] = 'OK';
                    $team_wise_data['timeoff_request_id'] = 0;
                    $team_wise_data['timeoff_reason'] = 'ok';
                    $tech_status = 1;
                }
            } else {
                $team_wise_data['technician_status'] = 'OK';
                $team_wise_data['timeoff_request_id'] = 0;
                $team_wise_data['timeoff_reason'] = 'ok';
                $tech_status = 1;
            }

            if ($tech_status) {
                $submit_filter = "and t_c.submited_date='" . $form_date . "'";

                $q = $this->db2->query("SELECT t_c.* FROM user_time_sheet_details as t_c where t_c.user_id ='" . $timesheetId . "'  $submit_filter ");
                
                
                
                if ($q->num_rows()) {
                    $TimeSheetdetails = $q->row_array();
                    
                } else {
                   
                    $TimeSheetdetails = array();
                }
               // print_r(@$TimeSheetdetails_cal_total);
  $this->db=$this->load->database('default', true);
                $j_r = array();
                $j_r = $this->db->query("SELECT jobs.*, jobs.system_type,colors.hex, users.custom_hex, users.id as user_id ,users.first_name as ufirstname ,
                        users.last_name ulastname, cs.first_name as csfirstname ,
                        cs.last_name as cslastname ,cs.address as csstate,cs.city as cscity,cs.association as  csassociation,cs.zip_code as  zip_code,
                        job_types.intials as job_type
                        FROM jobs
                        LEFT JOIN job_types ON job_types.id=jobs.job_type_id
                        LEFT JOIN  customers cs ON jobs.customer_id = cs.id
                        LEFT JOIN users ON jobs.user_id=users.id
                        LEFT JOIN colors ON users.color_id=colors.id
                        WHERE $date_filter $pv_sql $job_sql ORDER BY jobs.job_date ASC ,job_type ASC")->result_array();
                $temp_array = array();
                
                $team_wise_data['technician_worked_hours'] = @$TimeSheetdetails_cal_total['total']?@$TimeSheetdetails_cal_total['total']:0;
                $job_hours=0;
                if (count($j_r) > 0) {
                    
                    foreach ($j_r as $key => $value) {
                        $temp_array["id"] = $value['id'];
                        $temp_array['type'] = $value['job_type'];
                        $temp_array['customer_id'] = $value['customer_id'];
                        $temp_array['cname'] = ucfirst($value["csfirstname"]) . " " . ucfirst($value["cslastname"]);
                        $temp_array['custname'] = $this->shortString(ucfirst($value["cslastname"]) . " " . ucfirst($value["csfirstname"]), 10);

//                        if($j){
//                            echo '<pre>';
//                            print_r($j_r);
//                            print_r($TimeSheetdetails);
//                            die;
//                        }
                        
                                
                        //$temp_array['customer_status'] = $temp_array['custname'].((@$temp_array['technician_worked_hours']) ? '/'.@$temp_array['technician_worked_hours'] :'');
                     
                        //  change by satyendra on 21/04/2016
                        if($this->session->userdata('tech_scheduler')=='1'|| $this->session->userdata('superadmin')){
                             $temp_array['customer_status'] ='<div class="job-tech-smy"><a href="'.base_url().'admin/job_comment/'.@$temp_array['id'].'" job-no="'.@$temp_array['id'].'">'.  $temp_array['custname'] . '/' . @$TimeSheetdetails['total'].'</a></div>';
                        }else{ 
                            $temp_array['customer_status'] ='<div class="job-tech-smy"><a href="javascript:void(0);">'.  $temp_array['custname'] . '/' . @$TimeSheetdetails['total'].'</a></div>';  
                        }
                      // End by satyendra on 21/04/2016
                        
                        $proposal_id=@$value['proposal_id'];
                        
                        $job_hours+=$this->getJobhours($value['job_pid'],$InstallerId);
                        
                        $team_wise_data[$form_date][] = $temp_array;
                        
                    }
                    $team_wise_data['job_hours']=$job_hours;
                } else {
                    $team_wise_data[$form_date] = $temp_array;
                }
            }
            $team_details[$form_date][] = $team_wise_data;
            $form_date = strtotime('+1 days', strtotime($form_date));
        }
        return $team_details;
    }

    function shortString($string, $strLimit) {
        return (strlen($string) > $strLimit) ? substr($string, 0, $strLimit) . '..' : $string;
    }

    function getTimesheetJobtype() {
        return $this->db2->query("SELECT * FROM timesheet_jobtype order by job_type_order")->result_array();
    }

    function convertTimeStampTodate($timeStap) {
        return @date('m/d/Y', $timeStap);
    }

    function save_reason() {
        $timesheetId = $this->input->post("timesheetId");
        $reasonValue = $this->input->post("did");
        $timeOffid = $this->input->post("timeOffid");
        $timeStamp = $this->input->post("timeStamp");
        $start_date = date('Y-m-d', $this->input->post("timeStamp"));

        $row = array();
        $row['user_id'] = $this->input->post("timesheetId");
        $row['start_date'] = date('Y-m-d', $this->input->post("timeStamp"));
        $row['end_date'] = date('Y-m-d', $this->input->post("timeStamp"));
        $row['hours_leave'] = 8;
        $row['request_date'] = date('Y-m-d H:i:s');

        if ($reasonValue == 1) {
            $row['deduct_from_bank'] = 4;
            $row['timeoff_reason'] = 1;
        } else if ($reasonValue == 3) {
            $row['deduct_from_bank'] = 2;
            $row['timeoff_reason'] = 3;
        } else if ($reasonValue == 9) {
            $row['deduct_from_bank'] = 3;
            $row['timeoff_reason'] = 9;
        } else {
            $row['deduct_from_bank'] = 9999;
            $row['timeoff_reason'] = 9999;
        }

        $this->db2 = $this->load->database('otherdb', true);
        $row_plan = $this->db2->query("SELECT * FROM emp_timeoff_request WHERE user_id=" . $timesheetId . " and id=" . $timeOffid . "")->row_array();
        if (count($row_plan) > 0) {
            if ($reasonValue == 'ok') {
                $row['request_status'] = 'pending';
                $row['confirm_request'] = 'N';
                $this->db2->where(array('user_id' => $timesheetId, 'id' => $timeOffid));
                $this->db2->update("emp_timeoff_request", $row);
            } else {
                $row['request_status'] = 'approved';
                $row['confirm_request'] = 'Y';
                $this->db2->where(array('user_id' => $timesheetId, 'id' => $timeOffid));
                $this->db2->update("emp_timeoff_request", $row);
            }
        } else {
            if ($reasonValue == 'ok') {
                $row['deduct_from_bank'] = 0;
            } else {
                $row['request_status'] = 'approved';
                $row['confirm_request'] = 'Y';
                $this->db2->insert("emp_timeoff_request", $row);
            }
        }
        //$this->db2->last_query();die;
        $json['success'] = true;
        $this->db2->close();
        $json['reasonValue'] = $reasonValue;
        echo json_encode($json);
    }

    function GetTechnicianType($id = 0) {
        if (!$id)
            return 0;
        $intial = 0;
        $j = $this->db->query("SELECT * FROM users WHERE id=$id")->row_array();
        if ($j['type'] == 'lead_tech') {
            $intial = 'L';
        }
        return $intial;
    }

    function GetUserName($id = 0, $fullname = false) {
        if (!$id)
            return 0;
         $this->db=$this->load->database('default', true);

        $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
        $intial = "";
        foreach ($j as $key => $value) {
            $intial = ucfirst($value['first_name'][0]) . strtoupper($value['last_name'][0] . $value['last_name'][1]);
            if ($fullname) {
                $intial = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
            }
        }
        if (strlen($intial) > 15) {
            $intial = substr($intial, 0, 25) . "..";
        }
        return $intial;
    }

    function getEng($id) {
      $this->db=$this->load->database('default', true);
        if (!$id)
            return "";
        if ($id > 0) {
            $j = $this->db->query("SELECT first_name, last_name FROM users WHERE  id =$id ")->result_array();
            if (isset($j[0]['first_name']) || isset($j[0]['last_name']))
                return ucfirst($j[0]['first_name']) . " " . ucfirst($j[0]['last_name']);
        } else {
            return " ";
        }
    }

    function getdayinstaller($job_date) {
      $this->db=$this->load->database('default', true);
        $rs = $this->db->query("SELECT installer_id FROM jobs WHERE  job_date='$job_date' ")->result_array();
        $temp = array();
        foreach ($rs as $key => $value) {
            $temp[] = $value['installer_id'];
        }
        if (count($temp)) {
            return implode(",", $temp);
        }
    }

    function getidothervalue($other, $id, $tablename, $column = "*") {
      $this->db=$this->load->database('default', true);
        if ($other == "other" || $other == "" || !$other) {
            return $id;
        }
        $j = $this->db->query("SELECT $column  FROM $tablename  WHERE  id =$other")->result();

        if (isset($j[0]->$column))
            return $j[0]->$column;
        else
            return "";
    }

    function getUserIntial($id, $fullname = false) {
        if (!$id)
            return 0;
 $this->db=$this->load->database('default', true);
        $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
        $intial = "";
        foreach ($j as $key => $value) {
            $intial = ucfirst($value['first_name'][0]) . ucfirst($value['last_name'][0]);
            if ($fullname) {
                $intial = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
            }
        }
        return $intial;
    }

    function getUserEmpNo($id, $fullname = false) {
        if (!$id)
            return 0;
        $j = $this->db->query("SELECT emp_num FROM users WHERE id=$id")->result_array();
        if ($j[0]['emp_num'] > 0) {
            return $j[0]['emp_num'];
        }
        return $id;
    }

    function getUserFirstName($id) {
        if (!$id)
            return 0;
        $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
        $intial = "";
        foreach ($j as $key => $value) {
            $intial = ucfirst($value['first_name']);
        }
        return $intial;
    }

    function getCustomerNeighborhoodColor($id) {
        if (!$id)
            return '#ffffff';
        $neighborhood = "";
        $value = $this->db->query("SELECT neighborhood,other_neighborhood FROM customers WHERE id=$id")->row_array();
        if (isset($value['neighborhood'])) {
            if ($value['neighborhood'] == "other") {
                return;
            } else {
                if (isset($value['neighborhood']) && $value['neighborhood'] != "" && is_numeric($value['neighborhood'])) {
                    $sql = "SELECT neighbour,color from  neigbhour where id=" . $value['neighborhood'];
                    $row_neighbour = $this->db->query($sql)->row_array();
                    return @$row_neighbour['color'];
                } else {
                    return "#ffffff";
                }
            }
        }
        return @$neighborhood;
    }

    function getCustomerNeighborhood($id) {
        if (!$id)
            return 0;
        $neighborhood = "";
        $j = $this->db->query("SELECT neighborhood,other_neighborhood FROM customers WHERE id=$id")->result_array();
        foreach ($j as $key => $value) {
            if (isset($value['neighborhood'])) {
                if ($value['neighborhood'] == "other") {
                    $neighborhood = ucfirst($value['other_neighborhood']);
                } else {
                    if (isset($value['neighborhood']) && $value['neighborhood'] != "" && is_numeric($value['neighborhood'])) {
                        $sql = "SELECT neighbour from  neigbhour where id=" . $value['neighborhood'];
                        $row_neighbour = $this->db->query($sql)->row_array();
                        $neighborhood = ucfirst(@$row_neighbour['neighbour']);
                    } else {
                        $neighborhood = $value['neighborhood'];
                    }
                }
            }
        }
        if (strlen($neighborhood) > 20) {
            $neighborhood = substr($neighborhood, 0, 20) . "..";
        }
        return @$neighborhood;
    }

    function getCustomerLastname($id) {
        if (!$id)
            return 0;
        $j = $this->db->query("SELECT last_name FROM customers WHERE id=$id")->result_array();
        foreach ($j as $key => $value) {
            $lastname = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
        }
        return @$lastname;
    }

    function getparentjobid($job_id) {
        $resultcnt = $this->db->query("SELECT job_pid FROM jobs  where id = $job_id")->result_array();
        $pid = $resultcnt[0]['job_pid'];
        if (!$pid) {
            $pid = $job_id;
        }
        return $pid;
    }

    function savecomment($id) {
        $row = array();
        $pid = $this->getparentjobid($id);
        $row["comments"] = $this->input->post("comments");
        $this->db->where("job_pid", $pid);
        $this->db->update("jobs", $row);
        $json["success"] = true;
        echo json_encode($json);
    }

    function getArea($pincode) {
        $row = $this->db->query('Select neighbour from neigbhour left join neigbhour_pin_codes neg on neg.neighbour_id=neigbhour.id where neg.pin_codes="' . $pincode . '"')->row_array();
        return @$row['neighbour'];
    }

    function getProposalId($job_pid) {
        $row = $this->db->query('Select proposal_id from jobs where id="' . $job_pid . '"')->row_array();
        return @$row['proposal_id'];
    }

    function getAllvaribleLaborCost($proposal_id, $job_type, $location_access) {

        $row = array();
        $text = '';
        if ($job_type == 2 || $job_type == 6 || $job_type == 7) {

            if ($job_type == 2) {
                $var_list_order = array('EJ' => 101, 'EH' => 102, 'RL' => 206);
            } else if ($job_type == 6) {
                $var_list_order = array('RL' => 224);
            } else {
                $var_list_order = array('PM' => 207);
            }

            foreach ($var_list_order as $key => $val) {
                $variable_id = $val;

                if ($variable_id == 101 || $variable_id == 102) {
                    $sqlc = "SELECT  title, variable_job.price AS hours,quantity as price  ,ROUND(quantity*variable_job.price) AS cost,system_price_proposal.proposal_id  FROM variable_job
        JOIN system_price_proposal  ON variable_job.`variable_id`=system_price_proposal.`id`
         WHERE  variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.id ='" . $variable_id . "' AND system_price_proposal.location_access ='" . $location_access . "'";
                } else {
                    $sqlc = "SELECT  title,quantity AS hours,variable_job.price ,ROUND(quantity*variable_job.price) AS cost,system_price_proposal.proposal_id  FROM variable_job
        JOIN system_price_proposal  ON variable_job.`variable_id`=system_price_proposal.`id`
         WHERE  variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.id ='" . $variable_id . "' AND system_price_proposal.location_access ='" . $location_access . "'";
                }

                $row = $this->db->query($sqlc)->row_array();
                if (count($row)) {
                    if ($job_type == 6) {
                        $text.=floatval($row['hours']) . ' ' . $key . ' / ';
                    } else {
                        $text .=$key . ' ' . floatval($row['hours']) . ' / ';
                    }
                }
            }
        } else if ($job_type == 16 || $job_type == 15) {

            if ($job_type == 16) {
                $var_list_order = array('ACJ' => 35, 'EJ' => 33, 'AL' => 117);
            } else if ($job_type == 15) {
                $var_list_order = array('AS' => 37);
            }
            foreach ($var_list_order as $key => $val) {
                $variable_id = $val;
                $sqlc = "SELECT title, sum(quantity) AS hours, acvariable_job.price as price ,sum(quantity*acvariable_job.price) AS cost,acsystem_price_proposal.proposal_id FROM acvariable_job
        JOIN acsystem_price_proposal  ON acvariable_job.`variable_id`=acsystem_price_proposal.`id`
         WHERE  acvariable_job.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.id ='" . $variable_id . "' AND acsystem_price_proposal.location_access ='" . $location_access . "' ";
                $row = $this->db->query($sqlc)->row_array();
                if (count($row)) {
                    $text .=$key . ' ' . $row['hours'] . ' / ';
                }
            }
        } else if ($job_type == 5 || $job_type == 1) {
            if ($job_type == 5) {
                $var_list_order = array('WM' => 102);
            } else if ($job_type == 1) {
                $var_list_order = array('PJ' => 99, 'RL' => 100);
            }
            foreach ($var_list_order as $key => $val) {
                $variable_id = $val;
                if ($key == 'RL') {
                    $statement = " AND system_price_swhproposal.id in (100,101)";
                    $cols = "SUM(quantity) AS hours";
                } else {
                    $statement = " AND system_price_swhproposal.id ='" . $variable_id . "'";
                    $cols = "quantity AS hours";
                }
                $sqlc = "SELECT  title,$cols,swh_variable_job.price ,ROUND(quantity*swh_variable_job.price) AS cost,system_price_swhproposal.proposal_id  FROM swh_variable_job
    JOIN system_price_swhproposal  ON swh_variable_job.`variable_id`=system_price_swhproposal.`id`
     WHERE  swh_variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_swhproposal.`proposal_id`='" . $proposal_id . "' $statement ";
                $row = $this->db->query($sqlc)->row_array();

                if (count($row)) {
                    $text .=$key . ' ' . floatval($row['hours']) . ' / ';
                }
            }
        }

        if (strlen($text)) {
            return substr($text, 0, -2);
        } else {
            return '';
        }
    }

    function getunit($proposal_id) {
        $sql_zone = "SELECT * from acproposalzone where acproposal_id='" . $proposal_id . "'";
        $zones = $this->db->query($sql_zone)->result_array();
        $unitcount = 0;
        foreach ($zones as $zdata) {
            $mz_chk1 = $zdata['mzone_rec1_id'];
            $mz_chk2 = $zdata['mzone_rec2_id'];
            $mz_add_check = $zdata['additional_unit_1_price'];
            $mz_rec_check = $zdata['reccomended_unit_1_price'];
            if ($mz_chk1 > 0 && $mz_chk2 > 0) {
                //$unitcount+=2;
                continue;
            } else if ($mz_chk1 > 0 && $mz_add_check == 0) {
                $unitcount+=1;
                continue;
            } else if ($mz_chk2 > 0 && $mz_rec_check > 0) {
                $unitcount+=1;
                continue;
            } else {
                $unitcount+=1;
                if (!$zdata['reccomended_unit_delete'] && !$zdata['additional_unit_delete'] && $zdata['additional_unit_1_price'] > 0) {
                    $unitcount+=2;
                }
                if ($zdata['reccomended_unit_delete'] && $zdata['additional_unit_delete']) {
                    $unitcount-=1;
                }
            }
        }
        return $unitcount;
    }

    function deleteTechnician($job_id = 0) {
        $data = array();
        if (!@$job_id) {
            $data['success'] = false;
            echo json_encode($data);
            return;
        }

        $team_type_name = $this->input->post('team_type_name');
        $teamType = $this->input->post('team_type_id');
        $teamId = $this->input->post('technician_team_id');
        $technicianIdPheo = $this->input->post('technician_id_pheo');
        $technicianIdTime = $this->input->post('technician_id_time');
        $job_id = $this->input->post('job_id');
        $techInTeam = $this->input->post('techInTeam');
        //$key = $this->input->post('key');

        $jobUpdate = array();
        $rowjobs = $this->db->query("SELECT * FROM jobs where id=" . $job_id . "")->row_array();
        $job_pid = @$rowjobs['job_pid'];
        $job_type_id = @$rowjobs['job_type_id'];
        if (@$rowjobs['installer_id']) {
            $installer_id = explode(',', $rowjobs['installer_id']);
            if ($technicianIdPheo && in_array($technicianIdPheo, $installer_id)) {
                $pos = array_search($technicianIdPheo, $installer_id);
                unset($installer_id[$pos]);
            }
            $installer_id = implode(",", $installer_id);
            $jobUpdate['installer_id'] = $installer_id;
        } else {
            $jobUpdate['installer_id'] = '';
        }

        $this->db->where(array('job_id' => $job_id, 'technician_id_pheo' => $technicianIdPheo, 'technician_id_time' => $technicianIdTime));
        $this->db->delete("technicians_in_jobs");
        $labour_cont = $this->db->query("SELECT count(*) as count from technicians_in_jobs where job_id=" . $job_id)->result_array();
        $json['labour_count'] = 8 * @$labour_cont[0]['count'];
        if ($labour_cont[0]['count'] > 0) {
            $json['is_tech'] = true;
        } else {
            $json['is_tech'] = false;
        }
        $jobUpdate['labour_allocated'] = $json['labour_count'];
        $this->db->where(array('job_pid' => $job_pid, 'job_type_id' => $job_type_id));
        $this->db->update("jobs", $jobUpdate);

        $rowtechnician = $this->db->query("SELECT * FROM technicians_in_jobs where technician_id_pheo=" . $technicianIdPheo . "")->result_array();
        if (count($rowtechnician) == 0) {
            $set = array();
            $set['assigned'] = 0;
            $this->db->where(array('technician_id_pheo' => $technicianIdPheo));
            $this->db->update("technicians_assign", $set);
        }
        if ($this->db->affected_rows() > 0) {
            $json['success'] = true;
            echo json_encode($json);
        } else {
            $json['success'] = false;
            echo json_encode($json);
        }
    }

    function saveTechnician($job_id = 0) {

        $data = array();
        if (!@$job_id) {
            $data['success'] = false;
            echo json_encode($data);
            return;
        }

        $team_type_name = $this->input->post('team_type_name');
        $teamType = $this->input->post('team_type_id');
        $teamId = $this->input->post('technician_team_id');
        $technicianIdPheo = $this->input->post('technician_id_pheo');
        $technicianIdTime = $this->input->post('technician_id_time');
        $job_id = $this->input->post('job_id');
        $key = $this->input->post('key');

        $row = array();
        $row['team_type_id'] = $this->input->post("team_type_id");
        $row['technician_id_pheo'] = $this->input->post("technician_id_pheo");
        $row['technician_id_time'] = $this->input->post("technician_id_time");
        $row['team_id'] = $this->input->post("technician_team_id");
        $row['job_id'] = $this->input->post("job_id");
        $workhour = $row['technician_worked_hours'] = $this->input->post("technician_worked_hours");

        $row['created'] = date("Y-m-d H:i:s");
        $row['tech_in_team'] = $this->input->post("techInTeam");

        $jobUpdate = array();
        $rowjobs = $this->db->query("SELECT * FROM jobs where id=" . $job_id . "")->row_array();
        $job_pid = @$rowjobs['job_pid'];
        $job_type_id = @$rowjobs['job_type_id'];
        if (@$rowjobs['installer_id']) {
            $installer_id = explode(',', $rowjobs['installer_id']);
            if ($technicianIdPheo && in_array($technicianIdPheo, $installer_id)) {
                
            } else {
                array_push($installer_id, $technicianIdPheo);
            }
            $installer_id = implode(",", $installer_id);
            $jobUpdate['installer_id'] = $installer_id;
        } else {
            $jobUpdate['installer_id'] = $this->input->post("technician_id_pheo");
        }

        $row1 = $this->db->query("SELECT * FROM technicians_in_jobs where job_id=" . $job_id . " and technician_id_pheo=" . $technicianIdPheo . " and technician_id_time=" . $technicianIdTime . "")->row_array();
        if (count($row1) > 0) {
            $data['success'] = true;
            $data['isExist'] = 1;
        } else {
            $this->db->insert("technicians_in_jobs", $row);
            $set = array();
            $set['assigned'] = 1;
            $this->db->where(array('technician_id_pheo' => $technicianIdPheo, 'team_id' => $teamId));
            $this->db->update("technicians_assign", $set);
            $labour_cont = $this->db->query("SELECT count(*) as count from technicians_in_jobs where job_id=" . $job_id)->result_array();
            $data['labour_count'] = 8 * @$labour_cont[0]['count'];
            $jobUpdate['labour_allocated'] = $data['labour_count'];
            $this->db->where(array('job_pid' => $job_pid, 'job_type_id' => $job_type_id));
            $this->db->update("jobs", $jobUpdate);

            $data['success'] = true;
            $data['isExist'] = 0;
        }
        echo json_encode($data);
    }

    function save_technician_by_team($job_id = 0) {
        // 
        $data = array();
        if (!@$job_id) {
            $data['success'] = false;
            echo json_encode($data);
            return;
        }
        $technician_team_id = $this->input->post('technician_team_id');
        $team_name = $this->input->post('team_name');
        $teamId = $this->input->post('technician_team_id');
        $team_type_id = $this->input->post('team_type_id');
        $job_id = $this->input->post('job_id');
        $teamname = $this->input->post("techInTeam");

        $rowjobs = $this->db->query("SELECT * FROM technicians_assign  where team_id=" . $technician_team_id)->result_array();
        foreach ($rowjobs as $team) {
            $row = array();
            $row['team_type_id'] = $team['team_type_id'];
            $row['technician_id_pheo'] = $team['technician_id_pheo'];
            $technicianIdPheo = $team['technician_id_pheo'];
            $row['technician_id_time'] = $team['technician_id_time'];
            $technicianIdTime = $team['technician_id_time'];
            $row['team_id'] = $team['team_id'];
            $row['job_id'] = $job_id;
            $row['tech_in_team'] = $teamname;
            $row['technician_worked_hours'] = $this->work_hours($team['technician_id_time']);
            $row['created'] = date("Y-m-d H:i:s");

            $jobUpdate = array();
            $rowjobs = $this->db->query("SELECT * FROM jobs where id=" . $job_id . "")->row_array();
            $job_pid = @$rowjobs['job_pid'];
            $job_type_id = @$rowjobs['job_type_id'];
            if (@$rowjobs['installer_id']) {
                $installer_id = explode(',', $rowjobs['installer_id']);
                if ($technicianIdPheo && in_array($technicianIdPheo, $installer_id)) {
                    
                } else {
                    array_push($installer_id, $technicianIdPheo);
                }
                $installer_id = implode(",", $installer_id);
                $jobUpdate['installer_id'] = $installer_id;
            } else {
                $jobUpdate['installer_id'] = $team['technician_id_pheo'];
            }

            $row1 = $this->db->query("SELECT * FROM technicians_in_jobs where job_id=" . $job_id . " and technician_id_pheo=" . $technicianIdPheo . " and technician_id_time=" . $technicianIdTime . "")->result_array();

            if (count($row1) > 0) {
                $data['success'] = true;
                $data['isExist'] = 1;
            } else {
                $this->db->insert("technicians_in_jobs", $row);
                $set = array();
                $set['assigned'] = 1;
                $this->db->where(array('technician_id_pheo' => $technicianIdPheo, 'team_id' => $teamId));
                $this->db->update("technicians_assign", $set);
                $labour_cont = $this->db->query("SELECT count(*) as count from technicians_in_jobs where job_id=" . $job_id)->result_array();
                $data['labour_count'] = 8 * @$labour_cont[0]['count'];
                $jobUpdate['labour_allocated'] = $data['labour_count'];
                $this->db->where(array('job_pid' => $job_pid, 'job_type_id' => $job_type_id));
                $this->db->update("jobs", $jobUpdate);
                $data['success'] = true;
                $data['isExist'] = 0;
            }
        }
        echo json_encode($data);
    }

    function work_hours($tech_id) {
        $from_W_date = date('Y-m-d', strtotime('last Sunday'));
        $to_W_date = date('Y-m-d', strtotime('+6 days', strtotime('last Sunday')));
        $this->db2 = $this->load->database('otherdb', true);
        $q = $this->db2->query("SELECT t_c.* FROM user_calculated_time_sheet_details as t_c where t_c.user_id ='" . $tech_id . "'  and t_c.submited_date BETWEEN  '" . $from_W_date . "' and '" . $to_W_date . "'");
        if ($q->num_rows()) {
            $TimeSheetdetails = $q->row_array();
            $technician_worked_hours = $TimeSheetdetails['reg_hrs'] + $TimeSheetdetails['ot'];
        } else {
            $technician_worked_hours = 0;
        }
 $this->db=$this->load->database('default', true);
        return $technician_worked_hours;
    }

     
    function check_assigned($technician_id, $team_id, $job_id) {
        //echo $team_id;
        if (!$job_id) {
            return 0;
        } else {
            $sql = "select * from technicians_in_jobs  where team_id=" . $team_id . " and technician_id_pheo=" . $technician_id . $job_id;
            $row = $this->db->query($sql)->result_array();
            if (count($row) > 0) {
                return 1;
            } else {
                return 0;
            }
        }
    }
    
    
    function assengineer($user_id,$previous_user)
    {
        
        $old_hours=0;
        
        if(!$user_id){
            $json['success']=false;
            echo json_encode($json);
            return;
        }
        $job_no=$this->input->post('job_no');
        
        $text=array();
        
        $time_sheet_details=$this->db->query("SELECT technician_id_time from technicians_assign where technician_id_pheo='".$user_id."'")->row_array();
        
        
        $timesheetId=$time_sheet_details['technician_id_time'];
        
        $this->db2 = $this->load->database('otherdb', true);
        $form_date='';
        
        $job_deatils=array();
        
        $remove_jobs_hours=0;
        foreach ($job_no as $val)
        {
            $j_r = $this->db->query("SELECT job_date,installer_id,job_pid FROM jobs WHERE jobs.id='".$val."'")->row_array();
            
            $form_date=  strtotime($j_r['job_date']);
            
            $installer=  explode(',', $j_r['installer_id']);
            
            $installer = array_diff($installer, array($user_id));
           
            
            $row['installer_id']=  str_replace($previous_user, $user_id, implode(',', $installer)); 
            
            $this->db->where('id',$val);
            $this->db->update('jobs',$row);
            
            //$value = $this->db->query("SELECT proposal_id,job_type_id
                        //FROM jobs
                        //WHERE  id= $val")->row_array();
            $remove_jobs_hours+=$this->getJobhours($j_r['job_pid'],$row['installer_id']);
            
        }
       
        
        $form_date = date('Y-m-d', $form_date);
        $date_filter = "jobs.job_date='" . $form_date . "'";

        $pv_sql = "AND FIND_IN_SET(" . $this->db->escape($user_id) . ",installer_id)";  
           $this->db=$this->load->database('default', true);

        $j_r = $this->db->query("SELECT jobs.*, jobs.system_type,colors.hex, users.custom_hex, users.id as user_id ,users.first_name as ufirstname ,
                        users.last_name ulastname, cs.first_name as csfirstname ,
                        cs.last_name as cslastname ,cs.address as csstate,cs.city as cscity,cs.association as  csassociation,cs.zip_code as  zip_code,
                        job_types.intials as job_type
                        FROM jobs
                        LEFT JOIN job_types ON job_types.id=jobs.job_type_id
                        LEFT JOIN  customers cs ON jobs.customer_id = cs.id
                        LEFT JOIN users ON jobs.user_id=users.id
                        LEFT JOIN colors ON users.color_id=colors.id

                        WHERE $date_filter  $pv_sql ORDER BY jobs.job_date ASC ,job_type ASC")->result_array();

        
            $temp_array = array();
            
            $submit_filter = "and t_c.submited_date='" . $form_date . "'";


                $q = $this->db2->query("SELECT t_c.* FROM user_time_sheet_details as t_c where t_c.user_id ='" . $timesheetId . "'  $submit_filter ");

                
            if ($q->num_rows()) {
                $TimeSheetdetails = $q->row_array();
            } else {
                $TimeSheetdetails = array();
            }
             $jobs_hours=0;   
            foreach ($j_r as $key => $value) 
            {
                $custname = $this->shortString(ucfirst($value["cslastname"]) . " " . ucfirst($value["csfirstname"]), 10);


                $technician_worked_hours = @$TimeSheetdetails['total']?@$TimeSheetdetails['total']:0;

                $text[] ='<div class="job-tech-smy"><a href="'.base_url().'admin/job_comment/'.$value['id'].'" job-no="'.$value['id'].'">'.  $custname . '/' . @$technician_worked_hours.'</a></div>';
                
                 $jobs_hours+=$this->getJobhours($value['job_pid'],$user_id);
            }
        
        
            $json['data']= '<span class="fname">'. implode(' ',$text).'</span>';

            $json['new_hours']=$technician_worked_hours;
            
            $json['new_hours_job']=$jobs_hours;
            $json['remove_jobs_hours']=$remove_jobs_hours;


            $time_sheet_details=$this->db->query("SELECT technician_id_time from technicians_assign where technician_id_pheo='".$previous_user."'")->row_array();
        
        
            $timesheetId=$time_sheet_details['technician_id_time'];
        
        
        
            $submit_filter = "and t_c.submited_date='" . $form_date . "'";

            $q = $this->db2->query("SELECT t_c.* FROM user_time_sheet_details as t_c where t_c.user_id ='" . $timesheetId . "'  $submit_filter ");

            if ($q->num_rows()) {
                $TimeSheetdetails = $q->row_array();
            } else {
                $TimeSheetdetails = array();
            }
           
            $json['old_hours']=@$TimeSheetdetails['total']?@$TimeSheetdetails['total']:0;

            $hours_details=$this->getHours(@$timesheetId,$form_date);
            if(count($hours_details['text'])){
                $data_val = implode(',', $hours_details['text']);
            }else {
                $data_val = "-";
            }
            $json['empty_container']=$data_val;
            $json['success']=TRUE;
            echo json_encode($json);
    }
    function getHours($timesheetId,$form_date){
        $submit_filter = "and t_c.submited_date='" . $form_date . "'";
        $this->db2 = $this->load->database('otherdb', true);
        
        $row = $this->db2->query("SELECT t_c.* FROM user_time_sheet_details as t_c where t_c.user_id ='" . $timesheetId . "'  $submit_filter ")->row_array();
        $timesheet_jobtype=$this->db2->query("SELECT * FROM timesheet_jobtype order by job_type_order")->result_array();
        $string=array();
        $total=0;
        if(count($row))
        foreach ($timesheet_jobtype as $job_type)
        {
             if($row[$job_type['cols_name']]){
              $string[]=$job_type['name'].'/'.$row[$job_type['cols_name']];
             }
            $total+=$row[$job_type['cols_name']];
        }
         $this->db=$this->load->database('default', true);
        $arr=array('total_hrs'=>$total,'text'=>$string);
        return $arr;
    }
    function getJobhours($job_pid,$user_id){
        
        
        $value = $this->db->query("SELECT proposal_id,job_type_id
                       FROM jobs
                       WHERE  job_pid=$job_pid")->row_array();
        
        $proposal_id=$value['proposal_id'];
        $job_type_id=$value['job_type_id'];
        
        
        $labor_type = $this->db->query("SELECT labor_type FROM users WHERE  id='".$user_id."'")->row_array();
        
        $combined_total_hours=0;
        
        if($job_type_id==2)
        {
            if(@$labor_type['labor_type']=='RL')
            {
                 $sql_labor_cost = "SELECT variable_job.quantity FROM variable_job LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.proposal_id='".$proposal_id."'  AND  variable_job.variable_id in (206)   order by variable_job.id ";

                $labor_cost = $this->db->query($sql_labor_cost)->row_array();

                $combined_total_hours+=@$labor_cost['quantity']; 
            }
            
            if (@$labor_type['labor_type']=='EJ' || @$labor_type['labor_type']=='EH') {
               
                $sql_electrical_cost = "SELECT sum(variable_job.price) as hours FROM variable_job LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.proposal_id='".$proposal_id."'  AND  variable_job.variable_id in (101,102)   order by variable_job.id ";
                $electrical_cost = $this->db->query($sql_electrical_cost)->row_array();

                $combined_total_hours+=$electrical_cost['hours'];
            }
      
        }
        else if($job_type_id==16)
        {
            if (@$labor_type['labor_type']=='EJ') 
            {
                $sql_electrical_parts = "SELECT title, sum(quantity) AS hours, acvariable_job.price as price ,sum(quantity*acvariable_job.price) AS cost,acsystem_price_proposal.proposal_id FROM acvariable_job
JOIN acsystem_price_proposal  ON acvariable_job.`variable_id`=acsystem_price_proposal.`id`
 WHERE  acvariable_job.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.id ='33'";
            
             
                $electrical_cost = $this->db->query($sql_electrical_parts)->row_array();

                $combined_total_hours+=$electrical_cost['hours'];
            
            }
	    
	    if (@$labor_type['labor_type']=='ACJ') 
            {
                $sql_electrical_parts = "SELECT title, sum(quantity) AS hours, acvariable_job.price as price ,sum(quantity*acvariable_job.price) AS cost,acsystem_price_proposal.proposal_id FROM acvariable_job
JOIN acsystem_price_proposal  ON acvariable_job.`variable_id`=acsystem_price_proposal.`id`
 WHERE  acvariable_job.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.id ='35'";
            
             
                $electrical_cost = $this->db->query($sql_electrical_parts)->row_array();

                $combined_total_hours+=$electrical_cost['hours'];
            
            }
	    if (@$labor_type['labor_type']=='AL') 
            {
                $sql_electrical_parts = "SELECT title, sum(quantity) AS hours, acvariable_job.price as price ,sum(quantity*acvariable_job.price) AS cost,acsystem_price_proposal.proposal_id FROM acvariable_job
JOIN acsystem_price_proposal  ON acvariable_job.`variable_id`=acsystem_price_proposal.`id`
 WHERE  acvariable_job.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.id ='117'";
            
             
                $electrical_cost = $this->db->query($sql_electrical_parts)->row_array();

                $combined_total_hours+=$electrical_cost['hours'];
            
            }
        }
        else if($job_type_id==1)
        {

            $var_list_order = array('PJ' => 99, 'RL' => 100);
            
            if (@$labor_type['labor_type']=='PJ') 
            {
            $journeyman_plumber = "SELECT  sum(quantity) as hours  FROM swh_variable_job
JOIN system_price_swhproposal  ON swh_variable_job.`variable_id`=system_price_swhproposal.`id`
WHERE  swh_variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_swhproposal.`proposal_id`='" . $proposal_id . "' AND system_price_swhproposal.id in (99)";


            $electrical_cost = $this->db->query($journeyman_plumber)->row_array();
           // print_r($electrical_cost);
            $combined_total_hours+=$electrical_cost['hours'];
            }
            
            if (@$labor_type['labor_type']=='RL') 
            {
                $journeyman_plumber = "SELECT  sum(quantity) as hours  FROM swh_variable_job
    JOIN system_price_swhproposal  ON swh_variable_job.`variable_id`=system_price_swhproposal.`id`
    WHERE  swh_variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_swhproposal.`proposal_id`='" . $proposal_id . "' AND system_price_swhproposal.id in (100)";


                $electrical_cost = $this->db->query($journeyman_plumber)->row_array();
               // print_r($electrical_cost);
                $combined_total_hours+=$electrical_cost['hours'];
            }
            

        }else if($job_type_id==23)
        {

            if (@$labor_type['labor_type']=='GL') 
            {
		$sql = "SELECT * from constructionzone where proposal_id='".$proposal_id."'";
		$constructionzone = $this->db->query($sql)->result_array();
		foreach ($constructionzone as $key=>$cons_val){
		     $combined_total_hours+=@$cons_val['c_hours'];
		}
            
            }
        }
        if($job_type_id==5){
            $combined_total_hours=8;
        }
//        if($combined_total_hours)
//            echo '<br>'.$proposal_id.'<br>'.$job_type_id;
        return $combined_total_hours;
    }
    function getProposalJobhours($proposal_id,$job_type_id){
        $combined_total_hours=0;
        
        if($job_type_id==2)
        {
            $sql_labor_cost = "SELECT variable_job.*,system_price_proposal.title FROM variable_job LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.proposal_id='".$proposal_id."'  AND  variable_job.variable_id in (206)   order by variable_job.id ";

            $labor_cost = $this->db->query($sql_labor_cost)->row_array();
            $combined_total_hours+=@$labor_cost['quantity'];

            $sql_electrical_cost = "SELECT sum(variable_job.price) as hours FROM variable_job LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id AND variable_job.proposal_id=system_price_proposal.proposal_id   where variable_job.proposal_id='".$proposal_id."'  AND  variable_job.variable_id in (101,102)   order by variable_job.id ";
    //die;
            $electrical_cost = $this->db->query($sql_electrical_cost)->row_array();

            $combined_total_hours+=$electrical_cost['hours'];


        }
        else if($job_type_id==16)
        {
            

            $sql_electrical_parts = "SELECT title, sum(quantity) AS hours, acvariable_job.price as price ,sum(quantity*acvariable_job.price) AS cost,acsystem_price_proposal.proposal_id FROM acvariable_job
JOIN acsystem_price_proposal  ON acvariable_job.`variable_id`=acsystem_price_proposal.`id`
 WHERE  acvariable_job.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.id ='33'";
            $electrical_cost = $this->db->query($sql_electrical_parts)->row_array();

            $combined_total_hours+=$electrical_cost['hours'];
            

        }
        else if($job_type_id==1)
        {

             $journeyman_plumber = "SELECT  sum(quantity) as hours  FROM swh_variable_job
JOIN system_price_swhproposal  ON swh_variable_job.`variable_id`=system_price_swhproposal.`id`
WHERE  swh_variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_swhproposal.`proposal_id`='" . $proposal_id . "' AND system_price_swhproposal.id in (99,100)";


            $electrical_cost = $this->db->query($journeyman_plumber)->row_array();
           // print_r($electrical_cost);
            $combined_total_hours+=$electrical_cost['hours'];

        }
        
       if($job_type_id==5){
            $combined_total_hours=8;
        } 
//        if($combined_total_hours)
//            echo '<br>'.$proposal_id.'<br>'.$job_type_id;
        return $combined_total_hours;
    }
}

?>
