<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class Permitapi extends Controller {

    function Permitapi() {

        parent::Controller();

        //ini_set("display_errors",1);
        // if user is an installer, redirect them to an error page if
        // they're trying to do something they do have permissions to do
        if ($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y') {
            $method = $this->router->method;
            $protected = array("delete_job");
            if (in_array($method, $protected)) {
                redirect("admin/error?e=permissions");
            }
        }

        $this->load->helper(array('form', 'url'));
    }

    function buildingpermitstatus($permit_no, $jobid) {

        $permit_exist = $this->getpermitobject($permit_no);
        if ($permit_exist) {
            $data = $this->getexistpermitstatus($permit_exist);
            $data["objectid"] = $permit_exist;
            $this->insetpermitdata($data, $permit_no, 1);
        } else {
            $text = $this->disguise_curl();
            $data = $this->disguise_curl($permit_no, true);
            if (is_numeric($data["objectid"])) {
                $this->insetpermitdata($data, $permit_no);
            }
        }

        if (is_numeric($data["objectid"])) {
            $data_inspection = $this->disguise_curl_futher($data["objectid"], $data["datachanges"]);

            $data_inspectionDetail = $this->disguise_curl_futherDetails($data["objectid"], $data["datachanges"]);

            $row_job_update = array();
            $row_job_update["objectid"] = $data["objectid"];
            $datamining = array();
            $datamining = explode(",", $data[0][11]);
            $bmessage = "Building Inspection  under progress";
            if (count($datamining) > 1) {

                $row_job_update['is_pp_checked'] = 1;

                $date_buildinginspection = $this->buildinginspection($data_inspection);
                if ($date_buildinginspection) {
                    $row_job_update['building_permit_completeiondate'] = date("Y-m-d", strtotime($date_buildinginspection));
                    $row_job_update['building_permit_status'] = "completed";
                    $bmessage = "Building Permit completed on " . $date_buildinginspection;
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'building');
                    $this->db->where("id", $jobid);
                    $this->db->update("jobs", $row_job_update);
                } else {
                    $row_job_update['building_permit_status'] = "none";
                    $row_job_update['is_pp_checked'] = 0;
                }
                $emessage = "Electrical Inspection  under progress";
                $date_electricalinspection = $this->electricalinspection($data_inspection);
                if ($date_electricalinspection) {
                    $row_job_update['electrical_permit_status'] = "completed";
                    $row_job_update['electrical_permit_completeiondate'] = date("Y-m-d", strtotime($date_electricalinspection));
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'electrical');
                    $emessage = "Electrical permit completed on " . $date_electricalinspection;
                    $this->db->where("id", $jobid);
                    $this->db->update("jobs", $row_job_update);
                } else {
                    $row_job_update['electrical_permit_status'] = "none";
                    $row_job_update['is_pp_checked'] = 0;
                }

                $pmessage = "Permit Job Inspection  under progress";
                $date_permitinspection = $this->permitinspection($data_inspectionDetail);
                if ($date_permitinspection) {

                    $row_job_update['building_details_tab_permit_completeiondate'] = date("Y-m-d", strtotime($date_permitinspection));
                    $row_job_update['building_detail_tab_permit_status'] = "completed";
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'Permit Job');
                    $emessage = "Electrical permit completed on " . $date_permitinspection;
                    //$bmessage="Building Permit completed on ".$date_buildinginspection;
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'Detail');
                    $this->db->where("id", $jobid);
                    $this->db->update("jobs", $row_job_update);
                } else {
                    $row_job_update['building_detail_tab_permit_status'] = "none";
                    $row_job_update['is_pp_checked'] = 0;
                }
                $permitstatus = "$bmessage ,$emessage ,$pmessage. ";
            } else {
                $row_job_update['is_pp_checked'] = 1;

                $date_buildinginspection = $this->buildinginspection($data_inspection);
                if ($date_buildinginspection) {
                    $row_job_update['building_permit_completeiondate'] = date("Y-m-d", strtotime($date_buildinginspection));
                    $row_job_update['building_permit_status'] = "completed";
                    $bmessage = "Building Permit completed on " . $date_buildinginspection;
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'building');
                    $this->db->where("id", $jobid);
                    $this->db->update("jobs", $row_job_update);
                } else {
                    $row_job_update['building_permit_status'] = "none";
                    $row_job_update['is_pp_checked'] = 0;
                }
                $emessage = "Electrical Inspection  under progress";
                $date_electricalinspection = $this->electricalinspection($data_inspection);
                if ($date_electricalinspection) {
                    $row_job_update['electrical_permit_status'] = "completed";
                    $row_job_update['electrical_permit_completeiondate'] = date("Y-m-d", strtotime($date_electricalinspection));
                    $emessage = "Electrical permit completed on" . $date_electricalinspection;
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'electrical');
                    $this->db->where("id", $jobid);
                    $this->db->update("jobs", $row_job_update);
                } else {

                    $row_job_update['electrical_permit_status'] = "none";
                }
                $pmessage = "Permit Job Inspection  under progress";
                $date_permitinspection = $this->permitinspection($data_inspectionDetail);

                if ($date_permitinspection) {

                    $row_job_update['building_details_tab_permit_completeiondate'] = date("Y-m-d", strtotime($date_permitinspection));
                    $row_job_update['building_detail_tab_permit_status'] = "completed";
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'Permit Job');
                    $emessage = "Electrical permit completed on " . $date_permitinspection;
                    //$bmessage="Building Permit completed on ".$date_buildinginspection;
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'Detail');
                    $this->db->where("id", $jobid);
                    $this->db->update("jobs", $row_job_update);
                } else {
                    $row_job_update['building_detail_tab_permit_status'] = "none";
                    $row_job_update['is_pp_checked'] = 0;
                }

                $permitstatus = "$bmessage ,$emessage ,$pmessage .( " . $data[0][17] . ")";
                //$row_job_update['building_permit_status']=$data[0][17];
                //$permitstatus=$data[0][17];
            }

            $this->db->where("id", $jobid);
            $this->db->update("jobs", $row_job_update);
        } else {
            $permitstatus = "Please check your permit number. If it is correct,Please contact to Adminstrator";
        }
        $data = array();
        $data["permitstatus"] = $permitstatus;
        $this->load->view("permitapi/permitstatus", $data);
    }

    function electricalpermitstatus($permit_no, $jobid) {
        $permit_exist = $this->getpermitobject($permit_no);
        if ($permit_exist) {
            $data = $this->getexistpermitstatus($permit_exist);
            $data["objectid"] = $permit_exist;
            $this->insetpermitdata($data, $permit_no, 1);
        } else {
            $text = $this->disguise_curl();
            $data = $this->disguise_curl($permit_no, true);

            if (is_numeric($data["objectid"])) {
                $this->insetpermitdata($data, $permit_no);
            }
        }

        if (is_numeric($data["objectid"])) {
            $data_inspection = $this->disguise_curl_futher($data["objectid"], $data["datachanges"]);
            $row_job_update = array();
            $datamining = explode(",", $data[0][11]);
            if (count($datamining) > 1) {
                $row_job_update['electrical_permit_completeiondate'] = date("Y-m-d", strtotime($data[0][11]));
                $row_job_update['electrical_permit_status'] = "completed";
                $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'electrical');
                $permitstatus = "Permit  Completed on " . $data[0][11];
                $this->db->where("id", $jobid);
                $this->db->update("jobs", $row_job_update);
            } else {
                $row_job_update['electrical_permit_status'] = $data[0][17];
                $permitstatus = $data[0][17];
            }

            $this->db->where("id", $jobid);
            $this->db->update("jobs", $row_job_update);
        } else {

            $permitstatus = "Please check your permit number. If it is correct,Please contact to Adminstrator";
        }
        $data = array();
        $data["permitstatus"] = $permitstatus;
        $this->load->view("permitapi/permitstatus", $data);
    }

    function permitcron() {
        
    }

    function get_span($file) {
        $h1count = preg_match_all('/(<span .*>)(.*)(<\/span>)/', $file, $patterns);
        $res = array();
        array_push($res, $patterns[2]);
        array_push($res, count($patterns[2]));
        return $res;
    }

    function read_header($curl, $header) {
        //echo $header;
        return strlen($header);
    }

    function admincron($val = 0) {
          
         
        $sql_building_status = "SELECT id,building_permit,building_permit_status,electrical_permit_status  FROM jobs 
            WHERE  ( building_permit_status!='completed' || building_permit_status IS NULL   || electrical_permit_status!='completed' || electrical_permit_status IS NULL )
            AND building_permit>0 AND job_type_id IN(1,2) AND  ( building_permit_status!='revoke' AND electrical_permit_status!='revoke'  ) ORDER BY objectid "; 
        $row_building = $this->db->query($sql_building_status)->result_array();
        $this->disguise_curl();
        foreach ($row_building as $rowdata) {
            //$data=$this->disguise_curl($rowdata["building_permit"],true);
            $permit_exist = $this->getpermitobject($rowdata["building_permit"]);
            if ($permit_exist) {
                $data = $this->getexistpermitstatus($permit_exist);
                $data["objectid"] = $permit_exist;
                $this->insetpermitdata($data, $rowdata["building_permit"], 1);
            } else {

                $data = $this->disguise_curl($rowdata["building_permit"], true);
                $this->insetpermitdata($data, $rowdata["building_permit"]);
                $row_job_update = array();
                $row_job_update["objectid"] = $data["objectid"];
                $this->db->where("id", $rowdata["id"]);
                 $this->db->update("jobs", $row_job_update);
            }
            if (is_numeric($data["objectid"])) {
                $row_job_update = array();
                $row_job_update["objectid"] = $data["objectid"];
                $data_inspection = $this->disguise_curl_futher($data["objectid"], $data["datachanges"]);
                $datamining = explode(",", $data[0][11]);
                $message = "";
                
                if ($data[0][22]=='Permit revoked' && $rowdata["building_permit_status"] != "revoke"  ){
                     
                     $row_job_update['building_permit_status'] = "revoke";
                     $row_job_update['electrical_permit_status'] = "revoke";
                     $message = "Permit Status";
                     $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'revoke');
                     $this->db->where("id", $rowdata["id"]);
                     $this->db->update("jobs", $row_job_update);
                     return;
                 }
                 
                if (count($datamining) > 1) {
                    $row_job_update['is_pp_checked'] = 1;
                    if ($rowdata["building_permit_status"] != "completed" && $rowdata["building_permit_status"] != "revoke" )  {
                        $date_buildinginspection = $this->buildinginspection($data_inspection);
                        if ($date_buildinginspection) {
                            $row_job_update['building_permit_completeiondate'] = date("Y-m-d", strtotime($date_buildinginspection));
                            $row_job_update['building_permit_status'] = "completed";
                            $message = "Building";
                            $this->db->where("id", $rowdata["id"]);
                            $this->db->update("jobs", $row_job_update);
                                     $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'building');
                            
                        } else {
                            $row_job_update['is_pp_checked'] = 0;
                            $row_job_update['building_permit_status'] = "none";
                        }
                    }
                    if ($rowdata["electrical_permit_status"] != "completed" && $rowdata["electrical_permit_status"] != "revoke") {
                        $date_electricalinspection = $this->electricalinspection($data_inspection);
                        if ($date_electricalinspection) {
                            $row_job_update['electrical_permit_status'] = "completed";
                            $row_job_update['electrical_permit_completeiondate'] = date("Y-m-d", strtotime($date_electricalinspection));
                            $this->db->where("id", $rowdata["id"]);
                            $this->db->update("jobs", $row_job_update);
                            $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'electrical');
                            
                        } else {
                            $row_job_update['is_pp_checked'] = 0;
                            $row_job_update['electrical_permit_status'] = "none";
                        }
                    }
                    //here we get and update the permit job date. by sahil(28-02-2014)
                    if ($rowdata["building_detail_tab_permit_status"] != "completed") {
                        $date_permitinspection = $this->permitinspection($data_inspectionDetail);
                        if ($date_permitinspection) {

                            $row_job_update['building_details_tab_permit_completeiondate'] = date("Y-m-d", strtotime($date_permitinspection));
                            $row_job_update['building_detail_tab_permit_status'] = "completed";
                            $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'Permit Job');
                            $this->db->where("id", $rowdata["id"]);
                            $this->db->update("jobs", $row_job_update);
                        } else {
                            $row_job_update['building_detail_tab_permit_status'] = "none";
                            $row_job_update['is_pp_checked'] = 0;
                        }
                    }
                } else {

                     
                    if ($rowdata["building_permit_status"] != "completed") {
                        $date_buildinginspection = $this->buildinginspection($data_inspection);
                        if ($date_buildinginspection) {
                            //$this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'building');
                            $row_job_update['building_permit_completeiondate'] = date("Y-m-d", strtotime($date_buildinginspection));
                            $row_job_update['building_permit_status'] = "completed";
                            
                            $this->db->where("id", $rowdata["id"]);
                            $this->db->update("jobs", $row_job_update);
                            $message = "Building";
                            $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'building');
                        } else {
                            $row_job_update['building_permit_status'] = "none";
                        }
                    }
                                        if ($rowdata["electrical_permit_status"] != "completed") {
                    
                        $date_electricalinspection = $this->electricalinspection($data_inspection);
                        if ($date_electricalinspection) {
                            $row_job_update['electrical_permit_status'] = "completed";
                            $row_job_update['electrical_permit_completeiondate'] = date("Y-m-d", strtotime($date_electricalinspection));
                    
                            $this->db->where("id", $rowdata["id"]);
                            $this->db->update("jobs", $row_job_update);
                             $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'electrical');
                           
                        } else {
                            $row_job_update['electrical_permit_status'] = "none";
                            $row_job_update['is_pp_checked'] = 0;
                        }
                    }

                    //here we get and update the permit job date. by sahil(28-02-2014)
                    if ($rowdata["building_detail_tab_permit_status"] != "completed") {
                        $data_inspectionDetail = $this->disguise_curl_futherDetails($data["objectid"], $data["datachanges"]);
                        $date_permitinspection = $this->permitinspection($data_inspectionDetail);
                        if ($date_permitinspection) {

                            $row_job_update['building_details_tab_permit_completeiondate'] = date("Y-m-d", strtotime($date_permitinspection));
                            $row_job_update['building_detail_tab_permit_status'] = "completed";
                            //$this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'Permit Job');
                            $this->db->where("id", $rowdata["id"]);
                            $this->db->update("jobs", $row_job_update);
                        } else {
                            $row_job_update['building_detail_tab_permit_status'] = "none";
                            $row_job_update['is_pp_checked'] = 0;
                        }
                    }
                    //$row_job_update['building_permit_status']=$data[0][17];
                    $permitstatus = $data[0][17];
                }
                $this->db->where("id", $rowdata["id"]);
                $this->db->update("jobs", $row_job_update);
            }
        }
        
        if (!$val) {
            $data = array();
            $data["permitstatus"] = "Cron has been run successfully.";
            $this->load->view("permitapi/permitstatus", $data);
        }

        $this->nem_notify_mail(); 
    }

    function disguise_curl($permit_no = 0, $post = false) {

        $url = 'http://dppweb.honolulu.gov/DPPWeb/Default.aspx?PossePresentation=BuildingSignPermitSearch';
        $curl = curl_init();
        // Setup headers - I used the same headers from Firefox version 2.0.0.6 
        // below was split up because php.net said the line was too long. :/ 
        $header[0] = "Accept: text/xml,application/x-www-form-urlencoded,application/xhtml+xml,";
        $header[0] .= "text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5";
        $header[] = "Cache-Control: max-age=0";
        $header[] = "Connection: keep-alive";
        $header[] = "Keep-Alive: 300";
        $header[] = "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7";
        $header[] = "Accept-Language: en-us,en;q=0.5";
        $header[] = "Pragma: "; // browsers keep this blank. 
        curl_setopt($curl, CURLOPT_URL, $url);
        //  curl_setopt($curl, CURLOPT_USERAGENT, 'Googlebot/2.1 (+http://www.google.com/bot.html)'); 
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        //curl_setopt($curl, CURLOPT_REFERER, 'http://172.16.1.39/hrm/dashboard'); 
        //curl_setopt($curl, CURLOPT_REFERER, 'http://dppweb.honolulu.gov/DPPWeb/default.asp?PossePresentation=BuildingPermitSearch&PosseObjectId=47169013'); 
        //curl_setopt($curl, CURLOPT_ENCODING, 'gzip,deflate'); 
        curl_setopt($curl, CURLOPT_AUTOREFERER, 1);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_COOKIESESSION, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_HEADER, true);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_COOKIEJAR, dirname(__FILE__) . "/cookies.txt");
        curl_setopt($curl, CURLOPT_COOKIEFILE, dirname(__FILE__) . "/cookies.txt");
        curl_setopt($curl, CURLOPT_HEADER, 1);
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        if ($post) {
            // $permit_no = $row['permit_no'];
            curl_setopt($curl, CURLOPT_POST, true);
            // curl_setopt ($curl, CURLOPT_POSTFIELDS,$data);
            //curl_setopt($curl, CURLOPT_HEADERFUNCTION, 'read_header');
           curl_setopt($curl, CURLOPT_POSTFIELDS, "currentpaneid=749487&paneid=747895&functiondef=5&sortcolumns=%7B%7D&datachanges=%27d8GWwGIW06h%2FZhoTZWQrDvgZCHqFDtYvOulGjpxO75rTkPjQOOl6XcRmIF0GJQwIYw3GGb6yCLkVJb%252Bs1pJ0kzMPEGZEq5MWzdJB%2FaTBtz3BXX6kRfeWRZFO4re4JPx7hai7LXiidVQ35VCYLh7mbRXGIb9%2FSjzbGKPqc3CrxhlO%2Ffn3VgpItV0eETNTgo8vw4s5P7vXKe84O9C1nxPQs1qsl8PhU9M25kKHPs5z6Q4U%2FbiXi4YIJi%2FVOjUzKW25Y3ErZTVWL0hIJ355QDFGWQ%253D%253D%27%2C%28%27C%27%2C%27S0%27%2C749990%2C%27".$permit_no."%27%29%2C%28%27F%27%2C%27BuildingSignPermitNo_749487_S0%27%2C0%2C0%29%2C%28%27C%27%2C%27S0%27%2C749990%2C%27".$permit_no."%27%29%2C%28%27F%27%2C%27ext-gen1009%27%2C0%2C419%29%2C%28%27F%27%2C%27ext-gen1009%27%2C0%2C790%29&comesfrom=posse&changesxml=");
             $html = curl_exec($curl); // execute the curl command die;
          $newhtml=explode('PosseObjectId=',$html);
          
           $newhtml4=explode("Server:",$newhtml[1]);
          
          
          $newhtml5 = explode("\r\n",$newhtml4[0]);
          $object_id=$newhtml5[0];
            $page_html = file_get_contents("http://dppweb.honolulu.gov/DPPWeb/Default.aspx?PossePresentation=BuildingPermit&PosseObjectId=".$object_id);
            //echo $object_id = $object_id;
            $new_html = @explode("id=datachanges", $page_html);
            $new_html_further = explode('">', $new_html[1]);
            $new_html_further1 = explode('value="', $new_html_further[0]);

            $data = $this->get_span($page_html);
            $data["objectid"] = $object_id;
            $data["datachanges"] = $new_html_further1[1];
            return $data;
       
        }
        return 0;
    }

    function disguise_curl_futher($objectid, $datachangesfurther) {

        $url = 'http://dppweb.honolulu.gov/DPPWeb/Default.aspx?PossePresentation=BuildingPermit&PosseObjectId=' . $objectid;
        $curl = curl_init();
        // Setup headers - I used the same headers from Firefox version 2.0.0.6
        // below was split up because php.net said the line was too long. :/
        $header[0] = "Accept: text/xml,application/x-www-form-urlencoded,application/xhtml+xml,";
        $header[0] .= "text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5";
        $header[] = "Cache-Control: max-age=0";
        $header[] = "Connection: keep-alive";
        $header[] = "Keep-Alive: 300";
        $header[] = "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7";
        $header[] = "Accept-Language: en-us,en;q=0.5";
        $header[] = "Pragma: "; // browsers keep this blank.
        curl_setopt($curl, CURLOPT_URL, $url);
        //  curl_setopt($curl, CURLOPT_USERAGENT, 'Googlebot/2.1 (+http://www.google.com/bot.html)');
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        //curl_setopt($curl, CURLOPT_REFERER, 'http://172.16.1.39/hrm/dashboard');
        //curl_setopt($curl, CURLOPT_REFERER, 'http://dppweb.honolulu.gov/DPPWeb/default.asp?PossePresentation=BuildingPermitSearch&PosseObjectId=47169013');
        //curl_setopt($curl, CURLOPT_ENCODING, 'gzip,deflate');
        curl_setopt($curl, CURLOPT_AUTOREFERER, 1);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_COOKIESESSION, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_HEADER, true);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_COOKIEJAR, dirname(__FILE__) . "/cookies.txt");
        curl_setopt($curl, CURLOPT_COOKIEFILE, dirname(__FILE__) . "/cookies.txt");
        curl_setopt($curl, CURLOPT_HEADER, 1);
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, "currentpaneid=713846&paneid=713860&functiondef=3&sortcolumns=%7B%7D&datachanges=" . urlencode($datachangesfurther) . "&comesfrom=posse&changesxml=");
        $html = curl_exec($curl); // execute the curl command
        $data = $this->get_span($html);
        return $data;
    }

    function getexistpermitstatus($objectid) {
        $url = "http://dppweb.honolulu.gov/DPPWeb/default.asp?PossePresentation=BuildingPermit&PosseObjectId=$objectid";
        $page_html = file_get_contents($url);
        $data = $this->get_span($page_html);
        return $data;
    }

    function getpermitobject($permit_no) {
        $sql = "SELECT id,objectid from permit_details WHERE permit_no=$permit_no";
        $rs = $this->db->query($sql)->row_array();
        if (isset($rs["id"]) && @$rs["objectid"] > 0) {
            return $rs["objectid"];
        }
        return 0;
    }

    function insetpermitdata($data, $permit_no, $update_id = 0) {
		 if($update_id == 0){
		 $sql_get = "SELECT id from permit_details WHERE permit_no=$permit_no";
        $rs = $this->db->query($sql_get)->row_array();
        if (isset($rs["id"]) ) {
            $update_id =$rs["id"];
        }
		 }
        $row_permit_detail = array();
        $row_permit_detail["permit_no"] = $permit_no;
        $row_permit_detail["objectid"] = $data["objectid"];
        $row_permit_detail["application_number"] = $data[0][3];
        $row_permit_detail["job_number"] = $data[0][5];
        $row_permit_detail["description"] = $data[0][7];
        $row_permit_detail["created_date"] = $data[0][9];
        $row_permit_detail["job_completed_date"] = $data[0][11];
        $row_permit_detail["issued_date"] = $data[0][13];
        $row_permit_detail["date_construction_completed"] = $data[0][15];
        $row_permit_detail["status"] = $data[0][17];
        if ($update_id) {
            $this->db->where("id", $update_id);
            $this->db->update("permit_details", $row_permit_detail);
        } else {
            $this->db->insert("permit_details", $row_permit_detail);
        }
    }

    function updatepermitdata($data) {
        // job also update
    }

    function savepermitdata($job_id, $building, $electrical) {
        $pid = $this->getparentjobid($job_id);
        $row = array();
        $row_electrical_permit = $this->db->query("SELECT electrical_permit,building_permit from jobs WHERE id=$pid")->row_array();
        if ($row_electrical_permit["building_permit"] == $electrical && $row_electrical_permit["electrical_permit"] == $electrical ) {
            $json = array();
            $json['success'] = true;
            echo json_encode($json);
            return;
        }
        $row["electrical_permit"] = $electrical;
        $row["building_permit"] = $building;
        $row["building_permit_completeiondate"] = NULL;
        $row["building_permit_status"] = NULL;
        $row["electrical_permit_status"] = NULL;
        $row["electrical_permit_completeiondate"] = NULL;
        $row['is_pp_checked'] = 0;
        $row['objectid'] = NULL;
       /* $this->load->library("activitylog");
        $sql = "SELECT electrical_permit,building_permit,building_permit_completeiondate,building_permit_status,electrical_permit_status,electrical_permit_completeiondate,is_pp_checked,id FROM jobs WHERE job_pid = '" . $job_id . "'";
        $rs = $this->db->query($sql)->result_array();
        foreach ($rs as $data) {
            $diff = $this->activitylog->matchdiffInUpdate($data, $row);
            $this->activitylog->createlog("Update", "jobs", $data['id'], $this->session->userdata("user_id"), '', $diff);
        }*/
        $this->db->where("job_pid", $pid);
        $this->db->update("jobs", $row);
        $json = array();
        $json['success'] = true;
        echo json_encode($json);
    }

    function getparentjobid($job_id) {
        $resultcnt = $this->db->query("SELECT job_pid FROM jobs  where id = $job_id")->result_array();
        $pid = $resultcnt[0]['job_pid'];
        if (!$pid) {
            $pid = $job_id;
        }
        return $pid;
    }

    function permitstatusmail($job_id, $permitno, $objectid, $type = "") {

        // return;
        if (trim($type) == "")
            return;
        $url = "http://dppweb.honolulu.gov/DPPWeb/default.asp?PossePresentation=BuildingPermit&PosseObjectId=$objectid";
        $jobid = $job_id;
        $pid = $this->getparentjobid($job_id);
        $ismailsent = $this->globalnotifcation();
        if (!$ismailsent) {
            return;
        }
        $sql = "SELECT user_id,customer_id,job_date,building_permit_status ,project_designer_id,   electrical_permit_status from jobs where id=$job_id";
        $row = $this->db->query($sql)->row_array();
                $is_sale_user = false;
        if ($row["electrical_permit_status"] == "completed" && $type == "building") {
            $is_sale_user = true;
            $this->updatepermitclosed($job_id);
        }
        if ($row["building_permit_status"] == "completed" && $type == "electrical") {
            $is_sale_user = true;
            $this->updatepermitclosed($job_id);
        }
         $is_sale_user = true;
        $sqlc = "SELECT *  from customers  where id=" . $row["customer_id"];
        $rowc = $this->db->query($sqlc)->row_array();
        $isuserpre = $this->issendnotification($row['user_id']);
         
         $this->load->helper('mail');
         $template = 'template_mail_67';
         $role_id = 67;
         $j= $this->getUserLoadNew($row['user_id'],$template);
		
        $this->load->library('email');
        $config['mailtype'] = 'html';
        $this->email->initialize($config);
        $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
        $row_users = $this->db->query("SELECT users.email,users.type,users.first_name,users.last_name from users
                  LEFT JOIN  notification_setting ns ON ns.user_id = users.id LEFT JOIN permission ps ON ps.user_id = users.id WHERE (user_status='active' or user_status=1) AND  (ps.template_mail_67 = 1 or ps.template_mail_67 is null) and ns.notification =1 AND users.type='admin'")->result_array();
        $name = ucfirst($rowc["first_name"]) . " " . ucfirst($rowc["last_name"]);
         $email_list=array();
     
        foreach ($row_users as $value) {
             $mail=getmailid($value["email"],$value["type"],0,0,67);
             if(!$mail)  continue;
            // $this->sendpermitclosed($mail, 0, $url,$name, $job_id);
             $email_list[]=$value["email"];                      
                                   }
      $query = $this->db->query('SELECT another_email_id FROM mailformat where id=67');
                $row1 = $query->row();
                $another_email_id=  explode(',', $row1->another_email_id);
                
                foreach ($another_email_id as $mail) {
                    $mail=trim($mail);
                     if(!strcmp($mail,'kathryn@alternateenergyhawaii.com') && $type == "building") continue;
                     $email_list[]=$mail;
                       }
    
        $this->email->to($email_list);
           
        if ($type == "electrical") {
            $subject = "Electrical inspection closed for " . ucfirst($rowc["first_name"]) . " " . ucfirst($rowc["last_name"]) . ", $job_id";
        } else if ($type == "building") {
            $subject = "Building inspection closed for " . ucfirst($rowc["first_name"]) . " " . ucfirst($rowc["last_name"]) . ", $job_id";
        } else if ($type == "revoke") {
              $subject = "Permit revoke  for " . ucfirst($rowc["first_name"]) . " " . ucfirst($rowc["last_name"]) . ", $job_id";
        }

        if ($type == "electrical") {
            $msgtxt = 'Congratulations, the electrical permit for is now closed!. For  Detail , please click below';
        } else if ($type == "building") {
            $msgtxt = 'Congratulations, the building permit for is now closed!. For  Detail , please click below';
        } else if ($type == "revoke") {
            $msgtxt = 'Permit Revoke. For  Detail , please click below';
        }


        $this->email->subject($subject);

         $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="' . base_url() . 'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p>' . @$msgtxt . '<br/>
<a href="' . $url . '" target="_blank">Permit Status </a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
        @$this->email->message($message);
        @$this->email->send();
       
if ($row["electrical_permit_status"] == "completed" && $row["building_permit_status"] == "completed") {
            if ($isuserpre){
                 $mail = getmailid($j[0]->email,$j[0]->type,$j[0]->user_status,$j[0]->notification,$role_id);
                 if($mail){
                $this->sendpermitclosed($mail, 0, $url,$name, $job_id);
                          }
            }
			 
			 if(isset($row['project_designer_id']) && $row['project_designer_id']>0){
                                 $engg= $this->getUserLoadNew($row['project_designer_id'],$template);
                                 $mail = getmailid($engg[0]->email,$engg[0]->type,$engg[0]->user_status,$engg[0]->notification,$role_id);
                                 if($mail){
                                $this->sendpermitclosed($mail, 0, $url,$name, $job_id);
                                          }
			 }
                $query = $this->db->query('SELECT another_email_id FROM mailformat where id=67');
                $row = $query->row();
                $another_email_id=  explode(',', $row->another_email_id);
                foreach ($another_email_id as $mail) {
                     $this->sendpermitclosed($mail, 0, $url,$name, $job_id);
                                } 
        }
        return;
    }

    function sendpermitclosed($emaillist, $subject, $url, $name=0, $job_id=0) {
        $this->load->library('email');
        $config['mailtype'] = 'html';
        $this->email->initialize($config);
        $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
        $this->email->to($emaillist);
        $this->email->bcc('permits@alternateenergyhawaii.com');
        $msgtxt = "Your Permit application  has been completed. For Details, please click below";
        $this->email->subject($subject);
      
         $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=67');
                       $row = $query->row();
                       $sub=$row->strsubject;
                       $msg=$row->strbody;
                       $sub= strtr($sub, array('%name%' =>$name, '%job_id%' =>$job_id));
                       $msg=strtr($msg, array(
                      '%url%'=>$url,
                      '%baseurl%' =>base_url(),
					 
                        )); 
         $this->email->subject($sub);               
        @$this->email->message($msg);
        @$this->email->send();
    }

    function issendnotification($user_id) {
        $sql = "SELECT user_id FROM  notification_setting WHERE user_id = $user_id";

        $rowe = array();
        $rowe = $this->db->query($sql)->result_array();
        if ((count($rowe) >= 1) && $rowe[0]['user_id']) {
            return true;
        } else {
            $row['user_id'] = $user_id;
            return false;
        }
    }

    function globalnotifcation() {
        $sql = "SELECT notification from notification_setting WHERE id=1";
        $nresult = $this->db->query($sql)->result_array();
        if (!$nresult[0]['notification'])
            return 'false';
        return true;
    }

    function getUserLoad($id) {
        if (!$id)
            return 0;
        $j = $this->db->query("SELECT * FROM users WHERE id=$id")->result();

        return $j;
    }

    function buildinginspection($data) {
        $tempdata = array();
        $tempdata = $data[0];
        foreach ($data[0] as $key => $value) {

            if ($value == 'Building Code Inspection') {
                if ($tempdata[$key + 2] == 'Complete') {
                    return $tempdata[$key + 1];
                }
            }
        }
        return 0;
    }

    function electricalinspection($data) {
        $tempdata = array();
        $tempdata = $data[0];
        foreach ($data[0] as $key => $value) {
            if ($value == 'Electrical Code Inspection') {
                if ($tempdata[$key + 2] == 'Complete') {
                    return $tempdata[$key + 1];
                }
            }
        }
        return 0;
    }

    function permitinspection($data) {
        $tempdata = array();
        $tempdata = $data[0];

        foreach ($data[0] as $key => $value) {

            if ($value == 'Job Completed Date:') {

                return $tempdata[$key + 1];
            }
        }
        return 0;
    }

    function updatepermitclosed($job_id) {
        $pid = $this->getparentjobid($job_id);
        $row['permitnotfication'] = date("Y-m-d");
        $this->db->where('job_pid', $pid);
        $this->db->update('jobs', $row);
    }

    function buildingpermitstatus1() {
        $previousIdObjectID = $this->updatePreviousPermitDate();

        if (is_array($previousIdObjectID) && !empty($previousIdObjectID)) {

            foreach ($previousIdObjectID as $value) {

                $text = $this->disguise_curl();
                $data = $this->disguise_curl($value["building_permit"], true);

                if (is_numeric($value["objectid"]) && is_numeric($value["building_permit"])) {

                    $jobid = $value["id"];
                    $data_inspection = $this->disguise_curl_futherDetails($value["building_permit"], $data["datachanges"]);
                    // here we check the date is empy or not if it is then update it to crpon_active_log table.By sahil(28-02-2014)
                    if ($data_inspection[0][16] != "" && date("Y-m-d", strtotime($data_inspection[0][16])) != "1970-01-01") {
                        $row_job_update['building_details_tab_permit_completeiondate'] = date("Y-m-d", strtotime($data_inspection[0][16]));
                        $row_job_update['building_detail_tab_permit_status'] = "completed";
                        $this->db->where("id", $jobid);
                        $this->db->update("jobs", $row_job_update);
                    } else if ($data_inspection[0][16] == "" || date("Y-m-d", strtotime($data_inspection[0][16])) == "1970-01-01") {
                        //objectid,permit_number,id,date
                            $data = array(
                                'jobs_id' => $value["id"],
                                'jobs_building_permit' => $value["building_permit"],
                                'jobs_objectid' => $value["objectid"],
                                'permit_date' => date("Y-m-d", strtotime($data_inspection[0][16]))
                            );
                            $this->db->insert('cron_active_log', $data);
                        
                  }
                } else {
                    $permitstatus = "Please check your permit number. If it is correct,Please contact to Adminstrator";
                }
            }
        }
    }

    function updatePreviousPermitDate() {
        //$this->db->limit(10);
        //$this->db->select('id, objectid, building_permit,building_details_tab_permit_completeiondate ');
        //$this->db->where(' building_details_tab_permit_completeiondate< "2000-01-01" AND  building_detail_tab_permit_status!="completed"  AND  building_permit_status = "completed" and electrical_permit_status = "completed" and objectid != "" and objectid>0 and building_permit != "" and building_permit>0');
        $query = $this->db->query('SELECT `id`, `objectid`, `building_permit`, `building_details_tab_permit_completeiondate` FROM (`jobs`) WHERE building_details_tab_permit_completeiondate<"2000-01-01" AND building_detail_tab_permit_status!="completed" AND building_permit_status = "completed" AND electrical_permit_status = "completed" AND objectid != "" AND objectid>0 AND building_permit != "" AND building_permit>0')->result_array();
        //print_r($query);
        return $query;
    }

    function disguise_curl_futherDetails($objectid, $datachangesfurther) {

        $url = 'http://dppweb.honolulu.gov/DPPWeb/Default.aspx?PossePresentation=BuildingPermit&PosseObjectId=' . $objectid;
        $curl = curl_init();
        // Setup headers - I used the same headers from Firefox version 2.0.0.6
        // below was split up because php.net said the line was too long. :/
        $header[0] = "Accept: text/xml,application/x-www-form-urlencoded,application/xhtml+xml,";
        $header[0] .= "text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5";
        $header[] = "Cache-Control: max-age=0";
        $header[] = "Connection: keep-alive";
        $header[] = "Keep-Alive: 300";
        $header[] = "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7";
        $header[] = "Accept-Language: en-us,en;q=0.5";
        $header[] = "Pragma: "; // browsers keep this blank.
        curl_setopt($curl, CURLOPT_URL, $url);
        //  curl_setopt($curl, CURLOPT_USERAGENT, 'Googlebot/2.1 (+http://www.google.com/bot.html)');
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        //curl_setopt($curl, CURLOPT_REFERER, 'http://172.16.1.39/hrm/dashboard');
        //curl_setopt($curl, CURLOPT_REFERER, 'http://dppweb.honolulu.gov/DPPWeb/default.asp?PossePresentation=BuildingPermitSearch&PosseObjectId=47169013');
        //curl_setopt($curl, CURLOPT_ENCODING, 'gzip,deflate');
        curl_setopt($curl, CURLOPT_AUTOREFERER, 1);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_COOKIESESSION, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_HEADER, true);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_COOKIEJAR, dirname(__FILE__) . "/cookies.txt");
        curl_setopt($curl, CURLOPT_COOKIEFILE, dirname(__FILE__) . "/cookies.txt");
        curl_setopt($curl, CURLOPT_HEADER, 1);
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, "currentpaneid=713860&paneid=713846&functiondef=3&sortcolumns=%7B%7D&datachanges=" . urlencode($datachangesfurther) . "&comesfrom=posse&changesxml=");
        $html = curl_exec($curl); // execute the curl command
        $data = $this->get_span($html);
        return $data;
    }
   function nem_notify_mail()
{
    ini_set('max_execution_time', 99999999999999);
    $this->load->library('email');
    $config['mailtype'] = 'html';
    $this->email->initialize($config);
    $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
    $sql_jobs = "select proposal_id,project_designer_id,customer_id,job_pid,job_date as installation_date,created
as booking_date, DATEDIFF(now(),created) AS days, now() as current  from jobs where job_type_id=2 and project_designer_id!='' 
and nem_notification_mail!=1 and job_date is not null and now()<job_date
and DATEDIFF(now(),created)>5"; 
    $result_jobs = $this->db->query($sql_jobs)->result_array();
    $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=60');
    $row_email = $query->row();
    $sub=$row_email->strsubject;
    $msg=$row_email->strbody;
    $row_update=array();
    foreach($result_jobs as $value)
    {
        $job_pid = $value['job_pid'];
        $sql_nem = "select * from permit_files where job_id = $job_pid and type = 'netmeter'";
        $nem_record = $this->db->query($sql_nem)->row_array();
        if(count($nem_record)==0)
        {
            $sql_customer = "SELECT first_name as customer_firstname,last_name as customer_lastname FROM customers where id=".$value['customer_id'];
            $customer_detail = $this->db->query($sql_customer)->row_array();
            if(count($customer_detail)==0)
            {
                continue;
            }
            $this->load->helper('mail');
           $sql_engineer = "SELECT users.first_name as engineer_firstname,users.email,users.type from users LEFT JOIN notification_setting ns ON ns.user_id = users.id LEFT JOIN permission ps ON ps.user_id = users.id WHERE (ps.template_mail_60 = 1 or ps.template_mail_60 is null) AND ns.notification = 1 AND  users.id=".$value['project_designer_id'];
            $engineer_detail = $this->db->query($sql_engineer)->row_array();
            $body=strtr($msg, array(
            '%engineer_firstname%' => $engineer_detail['engineer_firstname'],
            '%customer_firstname%' => $customer_detail['customer_firstname'],
            '%customer_lastname%' => $customer_detail['customer_lastname'],
            '%baseurl%' =>base_url()));
             
            $role_id = 60;
            $mail = getmailid($engineer_detail['email'],$engineer_detail['type'],0,0,$role_id);
            if($mail == TRUE){
            $this->email->to($mail);
            $this->email->cc('tracmorinv@gmail.com'); 
            $this->email->subject($sub);
            $this->email->message($body);
             @$this->email->send();
            }
             $query = $this->db->query('SELECT another_email_id FROM mailformat where id=60');
                $row = $query->row();
                $another_email_id=  explode(',', $row->another_email_id);
                foreach ($another_email_id as $mail) {
                    $this->email->to($mail);
                    $this->email->subject($sub);
                   $this->email->message($body);
                   @$this->email->send();
               }
               
            $row_update['nem_notification_mail']=1;
            $this->db->where("job_pid",$job_pid);
            $this->db->update("jobs",$row_update);
        }
    }
    }
    
     function getUserLoadNew($id,$template) {
        if (!$id)
            return 0;
       $j = $this->db->query("SELECT users.*,ns.notification FROM users LEFT JOIN permission ps ON ps.user_id = users.id  LEFT JOIN notification_setting ns ON ns.user_id = users.id  WHERE (ps.$template =1 or ps.$template is null) AND (users.user_status='active' or users.user_status=1)  AND  users.id=$id")->result();
      
        return $j;
    }
}

?>
