<?php

class Job_status_tab extends Controller {

	function Job_status_tab()
	{
	     
              parent::Controller();
		if(!$this->session->userdata('logged_in'))
		{
		   $tempurl = explode("/index.php/", $_SERVER['PHP_SELF']);
                   redirect("login?ref=".$tempurl[1]);
		}
		if($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y')
		{
			$method = $this->router->method;
			$protected = array("delete_job");
			if(in_array($method,$protected))
			{
				redirect("admin/error?e=permissions");
			}
		}
                $this->getjoblimit();
                $this->load->helper(array('form', 'url','tab_setting'));
	}
        
        
    function  job_status($job_id){  
            
        $data = array();
        ini_set("display_errors","1");
        $data['job_id'] = $job_id;
        $this->load->helper('jobpv');               
        $this->load->library("job");
        $this->load->helper("text");
        $this->load->helper("thumbnail_helper");
        if($job_id=='') { redirect('admin/error?e=job_id'); }

		// get job data
		 $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.association,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
 
		$data['job'] = $this->db->query($sql)->row_array();
                
		if(count($data['job']) == 0){ redirect("admin/error?e=job_id"); }
                $pid = $data['job']['job_pid'];
		$data['titlejob'] = "Job";
                $data['titleshow']="Job";
                if($data['job']['job_type_id'] == 5 ) { $data['titlejob'] = 'Service'; }
                if($data['job']['job_type_id'] == 8 ) { $data['titlejob'] = 'Electrical Pre-install'; }
                if($data['job']['job_type_id'] == 6 ) { 
                    $data['titleshow'] = 'PreLag';
                    $data['job']['job_type']='PreLag';
                }
                if($data['job']['job_type_id'] == 7 ) {
                    $data['titleshow'] = 'Premeasure';
                    $data['job']['job_type']='Premeasure';
                }
                $data['job_timestamp'] = strtotime($data['job']['job_date']);
		$data['der_completed'] =round($this->job->der_percentage($pid));
		$jobtimelimit = $this->gettimeLimit($job_id);
	        $data["timediff"] =  (int) ($jobtimelimit-(int)(time()-strtotime($data['job']['created']))/3600);
		// daily job limit
                $jobtimelimit1 = $this->getexttimeLimit($job_id);
                if($jobtimelimit1){
                   if($data["timediff"]>=0){
                    $data["timediff"] +=$jobtimelimit1;
                   }else{
                    $data["timediff"] = $jobtimelimit1;
                   }

                }
                $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
                $data['customerclass'] = $this->job->getcustomertabclass($job_id);
                $data['jobclass'] = $this->job->getjobtabclass($job_id);
                if($data['job']['project_designer_id']!="" && $data['job']['project_designer_id']){
                    $show_instaler = explode("," ,$data['job']['project_designer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["enginner"]= implode(", " ,$showinstaller_name);
				 } else {
                    $data["enginner"]= " ";
				}
                $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                if($data['job']['installer_id']!="" && $data['job']['installer_id']){
                    $show_instaler = explode("," ,$data['job']['installer_id']);
                    $showinstaller_name = array();
                    foreach($show_instaler as $row_installer){
                        $userload = $this->getuser($row_installer);
                        if(isset($userload[0]->first_name) && isset($userload[0]->last_name) )
                        @$showinstaller_name[] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                    }
                    $data["showinstaller"] = implode(", " ,$showinstaller_name);
                } else {
                    $data["showinstaller"] = " ";
                }
            
              
            $this->db->where("job_id",$pid);
            $this->db->where("type",'spa');
            $this->db->order_by("created","desc");
            $data['file_spa'] = array();
            $data['file_spa'] = $this->db->get("permit_files")->row_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'stc');
            $this->db->order_by("created","desc");
            $data['file_stc'] = array();
            $data['file_stc'] = $this->db->get("permit_files")->row_array();

	    //start-PHOEN-486
	    $this->db->where("job_id",$pid);
            //$this->db->where("file_type",'surveydraft');4861
            $this->db->order_by("created","desc");
            $data['survey_draft_files'] = array();
            $data['survey_draft_files'] = $this->db->get("predesignsketch_files")->row_array();

	    $this->db->where("job_id",$pid);
           // $this->db->where("file_type",'surveyresult');4861
            $this->db->order_by("created","desc");
            $data['survey_result_files'] = array();
            $data['survey_result_files'] = $this->db->get("presale_files")->row_array();
	    //end-PHOEN-486
	    

            $this->db->where("job_id",$pid);
            $this->db->where("type",'project_approved');
            $this->db->order_by("created","desc");
            $data['file_project_approved'] = array();
            $data['file_project_approved'] = $this->db->get("permit_files")->row_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'hoaapproval');
            $this->db->order_by("created","desc");
            $data['file_hoaapproval'] = array();
            $data['file_hoaapproval'] = $this->db->get("permit_files")->row_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'heco_bill');
            $this->db->order_by("created","desc");
            $data['file_heco_bill'] = array();
            $data['file_heco_bill'] = $this->db->get("permit_files")->row_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'signder');
            $this->db->order_by("created","desc");
            $data['file_signder'] = array();
            $data['file_signder'] = $this->db->get("permit_files")->row_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'obt_ride');
            $this->db->order_by("created","desc");
            $data['file_obt_ride'] = array();
            $data['file_obt_ride'] = $this->db->get("permit_files")->row_array();


            $this->db->where("job_id",$pid);
            //$this->db->where("file_type",'projectdesign');4861
            $this->db->order_by("created","desc");
            $data['file_project_design'] = array();
            $data['file_project_design'] = $this->db->get("genral_files")->row_array();//PHOEN-486

            $this->db->where("job_id",$pid);
            $this->db->where("type",'hoa_app');
            $this->db->order_by("created","desc");
            $data['file_hoa_app'] = array();
            $data['file_hoa_app'] = $this->db->get("permit_files")->row_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'heco_ap');
            $this->db->order_by("created","desc");
            $data['file_heco_ap'] = array();
            $data['file_heco_ap'] = $this->db->get("permit_files")->row_array();

           $this->db->where("job_id",$pid);
            $this->db->where("type",'trustdocument');
            $this->db->order_by("created","desc");
            $data['file_trustdocument'] = array();
            $data['file_trustdocument'] = $this->db->get("permit_files")->row_array();

             $this->db->where("job_id",$pid);
            $this->db->where("file_type",'surveyresult');//PHOEN-486
            $this->db->order_by("created","desc");
            $data['file_ssr'] = array();
	    $this->db->order_by("created","desc");//PHOEN-486
            $data['file_ssr'] = $this->db->get("presale_files")->row_array();//  PHOEN-486

            $this->db->where("job_id",$pid);
            $this->db->where("type",'cover_sheet');
            $this->db->order_by("created","desc");
            $data['file_cover_sheet'] = array();
            $data['file_cover_sheet'] = $this->db->get("permit_files")->row_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'heep_app');
            $this->db->order_by("created","desc");
            $data['file_heep_app'] = array();
            $data['file_heep_app'] = $this->db->get("permit_files")->row_array();


            $this->db->where("job_id",$pid);
            $this->db->where("type",'derclosepacket');
            $this->db->order_by("created","desc");
            $data['file_derclosepacket'] = array();
            $data['file_derclosepacket'] = $this->db->get("permit_files")->row_array();

             $this->db->where("job_id",$pid);
            $this->db->where("type",'derclosemailtracking');
            $this->db->order_by("created","desc");
            $data['file_derclosemailtracking'] = array();
            $data['file_derclosemailtracking'] = $this->db->get("permit_files")->row_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'deracceptance');
            $this->db->order_by("created","desc");
            $data['file_deracceptance'] = array();
            $data['file_deracceptance'] = $this->db->get("permit_files")->row_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'arraymapping');
            $this->db->order_by("created","desc");
            $data['file_arraymapping'] = array();
            $data['file_arraymapping'] = $this->db->get("permit_files")->row_array();

             $this->db->where("job_id",$pid);
            $this->db->where("type",'permit_close');
            $this->db->order_by("created","desc");
            $data['file_permitclose'] = array();
            $data['file_permitclose'] = $this->db->get("permit_files")->row_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'permit_open');
            $this->db->order_by("created","desc");
            $data['file_permit_open'] = array();
            $data['file_permit_open'] = $this->db->get("permit_files")->row_array();

            //$this->db->where("job_id",$pid);
            //$this->db->where("file_type",'salesketch');
            //$this->db->order_by("created","desc");
            $data['file_sketch'] = array();
            //$data['file_sketch'] = $this->db->get("permit_files")->row_array();

	    //	start-PHOEN-486
	    $this->db->where("job_id",$pid);
	    //$this->db->where("file_type",'salesketch');4861
	    $this->db->order_by("created","desc");
	    $data['file_sketch'] = $this->db->get("sketch_files")->row_array();
	    
	    //	  end-  PHOEN-486
            $this->db->where("job_id",$pid);
            $this->db->where("type",'newtr_adminrequire');
            $this->db->order_by("created","asc");
            $data['newtr_adminrequire'] = array();
            $data['newtr_adminrequire'] = $this->db->get("permit_files")->result_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'newtr_permithoa');
            $this->db->order_by("created","asc");
            $data['newtr_permithoa'] = array();
            $data['newtr_permithoa'] = $this->db->get("permit_files")->result_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'newtr_hecoder');
            $this->db->order_by("created","asc");
            $data['newtr_hecoder'] = array();
            $data['newtr_hecoder'] = $this->db->get("permit_files")->result_array();


            $this->db->where("job_id",$pid);
            $this->db->where("type",'newtr_hecoderproject');
            $this->db->order_by("created","asc");
            $data['newtr_hecoderproject'] = array();
            $data['newtr_hecoderproject'] = $this->db->get("permit_files")->result_array();

            $this->db->where("job_id",$pid);
            $this->db->where("type",'newtr_hecoderpreinstall');
            $this->db->order_by("created","asc");
            $data['newtr_hecoderpreinstall'] = array();
            $data['newtr_hecoderpreinstall'] = $this->db->get("permit_files")->result_array();
            
            
            $data['file_array_map']=$this->db->query("SELECT * FROM sent_notififaction_log WHERE field_name='array_map' AND job_pid=".$pid)->row_array();
            $data['file_invoice']=$this->db->query("SELECT * FROM sent_notififaction_log WHERE field_name='invoice' AND job_pid=".$pid)->row_array();
            $data['file_closing_packet']=$this->db->query("SELECT * FROM sent_notififaction_log WHERE field_name='closing_packet' AND job_pid=".$pid)->row_array();
            $data['file_net_meter_installed']=$this->db->query("SELECT * FROM sent_notififaction_log WHERE field_name='net_meter_installed' AND job_pid=".$pid)->row_array();
            $data['file_system_turn_on']=$this->db->query("SELECT * FROM sent_notififaction_log WHERE field_name='system_turn_on' AND job_pid=".$pid)->row_array();
            $data['file_closing_courtesy']=$this->db->query("SELECT * FROM sent_notififaction_log WHERE field_name='closing_courtesy' AND job_pid=".$pid)->row_array();
            $data['file_der_receive']=$this->db->query("SELECT * FROM sent_notififaction_log WHERE field_name='der_receive' AND job_pid=".$pid)->row_array();
//	    PHOEN-486
	    $data['payment_recieved_log']=$this->db->query("SELECT * FROM payment_recieved_log WHERE payment_recieved_type='der' AND  job_pid=".$pid." order by id desc" )->row_array();
	    
            $data['file_bis_sent']=$this->db->query("SELECT * FROM sent_notififaction_log WHERE field_name='bis' AND job_pid=".$pid)->row_array();
            $data['file_eis_sent']=$this->db->query("SELECT * FROM sent_notififaction_log WHERE field_name='eis' AND job_pid=".$pid)->row_array();
            
            
            ////drop down log
            $data['file_permit_type']=$this->db->query("SELECT * FROM job_dropdown_log WHERE field_name='permit_type' AND job_pid=".$pid)->row_array();
            $data['file_heco_status']=$this->db->query("SELECT * FROM job_dropdown_log WHERE field_name='heco_status' AND job_pid=".$pid)->row_array();
            $data['file_hoa_status']=$this->db->query("SELECT * FROM job_dropdown_log WHERE field_name='hoa_status' AND job_pid=".$pid)->row_array();
            $data['file_permitting_status']=$this->db->query("SELECT * FROM job_dropdown_log WHERE field_name='permitting_status' AND job_pid=".$pid)->row_array();
            $data['file_post_job_installation']=$this->db->query("SELECT * FROM job_dropdown_log WHERE field_name='post_job_installation' AND job_pid=".$pid)->row_array();
            
            //notes data
            $data['notes_sales']=$this->db->query("SELECT * FROM job_notes_log WHERE notes_type='notes_sales' AND job_pid=".$pid)->result_array();
            $data['notes_booking']=$this->db->query("SELECT * FROM job_notes_log WHERE notes_type='notes_booking' AND job_pid=".$pid)->result_array();
            $data['notes_engineering']=$this->db->query("SELECT * FROM job_notes_log WHERE notes_type='notes_engineering' AND job_pid=".$pid)->result_array();
            $data['notes_construction']=$this->db->query("SELECT * FROM job_notes_log WHERE notes_type='notes_construction' AND job_pid=".$pid)->result_array();
            $data['notes_installation']=$this->db->query("SELECT * FROM job_notes_log WHERE notes_type='notes_installation' AND job_pid=".$pid)->result_array();
            
		// find other active jobs for customer that this job belongs to
		$sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=".$this->db->escape($data['job']['customer_id'])." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['other_jobs'] = $this->db->query($sql)->result_array();

		// grab job notes
		$sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_type_id not in (6,7,8,15) AND jobs.job_pid=".$data['job']['job_pid']." AND jobs.id!=".$this->db->escape($job_id)." ORDER BY jobs.job_date ASC";
		$data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();
		
                $install_assign = $data['job']['installer_id'];
                $installer_assign_array = explode("," ,$install_assign);
                $this->db->where("type","installer");
		$this->db->order_by("first_name","desc");
		$installeruser = $this->db->get("users")->result_array();
                $data['installer_assign']=array();
                $data['installer_user'] = array();
                foreach($installeruser as $row) {
                      if (in_array($row['id'],$installer_assign_array )){
                          $data['installer_assign'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                          continue;
                      }
                      $data['installer_user'][$row['id']] = ucfirst($row['first_name'])." ".ucfirst($row["last_name"]);
                }
                //phase status
              
                $sql_phase_type="SELECT * FROM job_phase_type order by show_order ASC ";
                $phase_statuses=$this->db->query($sql_phase_type)->result_array();
                $data['phase_statuses'][''] = "- Select a job status -";
                foreach($phase_statuses as $key=>$value){
                $data['phase_statuses'][$value['id']]=$value['name'];
                }
                $sql_phase="SELECT * FROM job_phase_log WHERE job_id=".$job_id." ORDER BY id DESC";
                $phase_history=$this->db->query($sql_phase)->result_array();
                $data['phase_history']=$phase_history;
                
                $sql_last_phage="SELECT * FROM job_phase_log WHERE job_id=".$job_id." ORDER BY id DESC LIMIT 1";
                $last_phase_update=$this->db->query($sql_last_phage)->row_array();
                $data['last_phase_update']=$last_phase_update;
                
                $data['permitType'] = array('' => '-Select an action-', 'online' => 'Online', 'OTC'=>'OTC','walkin' => 'Walk-in', 'N/A'=>'N/A','other'=>'Other');
                $data['heco_statusType']=array('' => '-Select an action-', 'Application Sent' => 'Application Sent', 'Technical Review'=>'Technical Review','Approved To Install' => 'Approved To Install', 'Permission To Operate'=>'Permission To Operate');
                $data['hoa_statusType']=array('' => '-Select an action-', 'Application Sent' => 'Application Sent', 'Approved'=>'Approved ','Addessing Comments' => 'Addessing Comments', 'other'=>'Other');
                $data['permitting_statusType']=array('' => '-Select an action-', 'In Progress' => 'In Progress', 'At DHHL/DLNR'=>'At DHHL/DLNR','At DPP' => 'At DPP', 'Addessing Comments'=>'Addessing Comments','Obtained'=>'Obtained','other'=>'Other');
                $data['postjob_Type']=array('' => '-Select an action-', 'Photos Complete' => 'Photos Complete', 'Incorrect'=>'Incorrect ');
                global $schedular_role;
                $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                $data['editcomment'] = false;
                if ($this->session->userdata("user_id")==$data['job']['user_id'] || $this->session->userdata("superadmin")==1 ){
                     $data['editcomment'] = true;
                } 
                $this->load->view("common/header");
                  if ($this->session->userdata("role") == 'installer') {
                    $this->load->view("job_status/job_status_installer",$data);
                  } else {
                      $this->load->view("job_status/job_status",$data);
                      //$this->load->view("job_status/job_status_installer",$data);
                  }
                $this->load->view("common/footer");
       
       
     }
   
      function getproperty($proposal_id,$job_type_id){
          if($job_type_id==2)
               $table="proposal";
          else if($job_type_id==1)
               $table="swhproposal";
          else if($job_type_id==16)
               $table="acproposal";
          else if($job_type_id==20)
               $table="safproposal";
          else if($job_type_id==21)
               $table="homecharging";
          else if($job_type_id==23)
               $table="drwproposal";
          if($table){
                $sql = "SELECT pt.name FROM $table ps LEFT JOIN property_type pt ON ps.property_type=pt.id WHERE ps.id = '" . $proposal_id . "'";
                $data= $this->db->query($sql)->row_array();
                return @$data['name'];
          }else{
               return "";
          }
      }
      
      
       function update_phase_status($job_id, $status)
	{
            $sql = "SELECT
                    jobs.job_type_id,
                    job_types.type as job_type
                    FROM jobs
                    LEFT JOIN job_types ON job_types.id=jobs.job_type_id	
                    WHERE jobs.id=".$job_id;
            $data['job'] = $this->db->query($sql)->row_array();
                
                if(@$status && $job_id)
		{
                         
			$pid = $this->getparentjobid($job_id);
                        $row['job_phase_status'] = $status;
                        $row['modified_by']=$this->session->userdata("user_id");
                        $warray = array('job_pid' => $pid, 'job_type_id' => $data['job']['job_type_id']);
                        $this->db->where($warray);
                        $this->db->update("jobs",$row);
                        
                        //update auto_phase_email_sent
                        $sql= "update jobs set auto_phase_email_sent=0 where id= '".$job_id."'"; 
                        $this->db->query($sql);	
                        
                        $phase=array();
                        $phase['job_id']=$job_id;
                        $phase['job_pid']=$pid;
                        $phase['user_id']=$this->session->userdata("user_id");
                        $phase['created'] = date("Y-m-d H:i:s");
                        $phase['job_phase_status']=$status;
                        $this->db->insert("job_phase_log",$phase);
                        $insertid=$this->db->insert_id();
                        if($insertid){
                         $this->send_updatepahse_alert($job_id,$status);
                        }
                         redirect("job_status_tab/job_status/$job_id");
                        
                        
		 }
                 redirect("job_status_tab/job_status/$job_id");
	}
        
        function getjoblimit(){
           global $pv_job_count;
           global $swh_job_count;
                  global $ac_job_count;
           global $sc_job_count;
                  global $hess_job_count;
                  global $wm_job_count;
           global $gc_job_count;
           $resultcnt =  $this->db->query("SELECT * FROM globalconfig  where id = 1")->row_array();
           $pv_job_count = $resultcnt['pv_job'];
           $swh_job_count=$resultcnt['swh_job'];
           $ac_job_count=$resultcnt['ac_job'];
           $sc_job_count=$resultcnt['sc_job'];
           $hess_job_count=$resultcnt['hess_job'];
           $wm_job_count=$resultcnt['wm_job'];
           $gc_job_count=$resultcnt['gc_job'];

        }

        function getUserLoadNew($id,$template) {
              if (!$id)
                  return 0;
             $j = $this->db->query("SELECT users.*,ns.notification FROM users LEFT JOIN permission ps ON ps.user_id = users.id  LEFT JOIN notification_setting ns ON ns.user_id = users.id  WHERE (ps.$template =1 or ps.$template is NULL)  AND (users.user_status='active' or users.user_status=1)  AND  users.id=$id")->result();
              return $j;
          }
          
         function getparentjobid($job_id){
            $resultcnt =  $this->db->query("SELECT job_pid FROM jobs  where id = $job_id")->result_array();
            $pid = $resultcnt[0]['job_pid'];
            if(!$pid){
             $pid =$job_id;
            }
            return $pid;
          }
          
          function phasestatusnotifaction ($custname,$ljobs , $cjobs,$saleman,$email,$userid=0,$notify=null,$job_id=0,$job_type=''){
            $ismailsent = $this->globalnotifcation();

             if(!$ismailsent){
                 return;
             }
             if($userid){
                 $isuserpre = $this->issendnotification($userid);
                 if(!$isuserpre){
                     return ;
                 }
             }
            $prev_status=$this->get_phasetype($ljobs);
            $next_status=$this->get_phasetype($cjobs);
            
            $this->load->library('email');
            $config['mailtype'] = 'html';
            $this->email->initialize($config);
            $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
            $this->email->to($email);
            $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=69');
                $row = $query->row();
                $sub=$row->strsubject;
                $msg=$row->strbody;

                $sub= strtr($sub, array('%prev_status%' => $prev_status['name'],'%next_status%'=> $next_status['name']));

            $this->email->subject($sub);
            $joblink='javascript:void(0)';
            if($job_id){
              $joblink=base_url().'admin/job_status/'.$job_id;
            }
            $msg= strtr($msg, array('%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%prev_status%' => $prev_status['name'],'%next_status%'=> $next_status['name'],'%custname%'=>$custname,'%project_type%'=>$job_type));
                    

         @$this->email->message($msg);
         @$this->email->send();
         }
         
        function globalnotifcation(){
            $sql  = "SELECT notification from notification_setting WHERE id=1";
            $nresult =  $this->db->query($sql)->result_array();
            if(!$nresult[0]['notification']) return 'false' ;
             return true;
          }
          
          function  issendnotification($user_id){
            $sql = "SELECT user_id FROM  notification_setting WHERE user_id = $user_id";

            $rowe = array();
            $rowe = $this->db->query($sql)->result_array();
            if((count($rowe) >= 1)  && $rowe[0]['user_id']){
               return true;
            }else{
                 $row['user_id'] = $user_id;
                 return false;
            }

          }
          
     function returnInterval($time,$phase_id, $job_id){
         
        $sql="SELECT created FROM job_phase_log WHERE job_id=".$job_id." AND id>".$phase_id." ORDER BY id ASC LIMIT 1";
        $prev_total=$this->db->query($sql)->result_array();
         if(count($prev_total)>0){
            $prev_time=strtotime($prev_total[0]['created']); 
         }else{
            $prev_time=time(); 
         }
        $time = strtotime($time);
        $delta = $prev_time - $time;
         if($delta<0) $delta=-$delta;         
        if(($delta/60) < 1 )
        {
            return $delta."s";
        }
        if(($delta/60) >= 1 && ($delta/60) < 60)
        {
            return floor($delta/60)."m";
        }
        if(($delta/3600) >= 1 && ($delta/3600) < 24)
        {
            $min = ($delta/3600) - floor($delta/3600);
            return floor($delta/3600)."h:" .floor($min*60)."m";
        }
        if(($delta/86400) >= 1 && ($delta/86400) < 7)
        {
            $hour = ($delta/86400) - floor($delta/86400);
            return floor($delta/86400)."d:" .floor($hour*24)."h";
        }
        if(($delta/604800) >= 1)
        {
            $day = ($delta/604800) - floor($delta/604800);
            return floor($delta/604800)."w:" .floor($day*7)."d";
        }
    
     }
     
     
     function get_phasetype($type){
            $phasename=array();
            if($type){
              $sql="SELECT background_color,text_color,name,show_phase FROM job_phase_type where id=".$type;
               $phage=$this->db->query($sql)->row_array();
               if($phage['background_color']){
                  $phasename['bgcolor']=$phage['background_color'];
                  $phasename['text_color']=$phage['text_color'];
                  $phasename['name']=$phage['name'];
                  $phasename['show_phase']=$phage['show_phase'];
                }
            }
            return $phasename;
       }
       
         function save_change_action ($job_id,$type){
            $field_name= $this->input->post('field_name');
            $field_val=$this->input->post('field_val');
            $pid=$job_id;//$this->getparentjobid($jobid);
            $pid=$this->getparentjobid($job_id);
            $row=array();
            
             
           if($job_id!=''){
                 if($type=='permit_type'){
                    $row['permit_type']=$field_val;
                    $row['permit_other']=' ';
                    $this->db->where('job_pid',$pid);
                    $this->db->update('jobs',$row);
                }else if($type=='hoa_status'){
                    $row['hoa_status']=$field_val;
                    $row['hoa_other']='';
                    $this->db->where('job_pid',$pid);
                    $this->db->update('jobs',$row);
               }else if($type=='permitting_status'){
                   $this->db->where('job_pid',$pid);
                   $this->db->update('jobs',array($field_name=>$field_val,'permitting_other'=>' '));
               }else{
                   $this->db->where('job_pid',$pid);
                   $this->db->update('jobs',array($field_name=>$field_val));
               }
           }else{
               $this->db->where('job_pid',$pid);
               $this->db->insert('jobs',array($field_name=>$field_val));
           }
           
            $log=array();
            $log['user_id']=$this->session->userdata("user_id");
            $log['job_id']=$job_id;
            $log['job_pid']=$pid;
            $log['created']=date("Y-m-d H:i:s");
            $log['field_name']=$field_name;
            $sql="SELECT * FROM job_dropdown_log WHERE field_name='$field_name' AND job_id=".$job_id;
            $log_data=$this->db->query($sql)->result_array();
            if(count($log_data)>0){
                $this->db->where(array('job_id'=>$job_id, 'field_name'=>$field_name));
                $this->db->update("job_dropdown_log",$log);
            }else{
                $this->db->insert("job_dropdown_log",$log);
            }
           
           $json['success']=true;
           echo json_encode($json);
        }
        
         function save_other_action ($job_id){
            $field_name= $this->input->post('field_name');
            $input_name= $this->input->post('input_name');
            $input_val=$this->input->post('field_val');
            $pid=$job_id;//$this->getparentjobid($jobid);
           $this->db->where('id',$pid);
           if($job_id!=''){
               $this->db->where('id',$pid);
               $this->db->update('jobs',array($input_name=>$input_val,$field_name=>'other'));
           }else{
               $this->db->where('id',$pid);
               $this->db->insert('jobs',array($input_name=>$input_val,$field_name=>'other'));
           }
           
            $log=array();
            $log['user_id']=$this->session->userdata("user_id");
            $log['job_id']=$job_id;
            $log['job_pid']=$pid;
            $log['created']=date("Y-m-d H:i:s");
            $log['field_name']=$field_name;
            $sql="SELECT * FROM job_dropdown_log WHERE field_name='$field_name' AND job_id=".$job_id;
            $log_data=$this->db->query($sql)->result_array();
            if(count($log_data)>0){
                $this->db->where(array('job_id'=>$job_id, 'field_name'=>$field_name));
                $this->db->update("job_dropdown_log",$log);
            }else{
                $this->db->insert("job_dropdown_log",$log);
            }
            
           $json['success']=true;
           echo json_encode($json);
        }
        
         function add_status_iframe($job_id='',$filet="")
	{
                $data=array();
		$data['job_id'] = $job_id;
                $data['file_type'] = $filet;
                if(strstr($filet,"notes_")){
                    $this->load->view("job_status/add_notes_iframe",$data);
                }else{
		  $this->load->view("job_status/add_status_iframe",$data);
                }
	}
        
       
        
        function add_permitfile_new($job_id='',$file_type="no", $service_call='no'){
                if ($service_call == 'yes') {
                        $data['service_call_id'] = $job_id;
                } else {
                        $data['job_id'] = $job_id;
                }
                $data['file_type'] = $file_type;
                $data['permit_number']='';
                if($file_type=="building" || strstr($file_type,"permit_")){
                    $pid = $this->getparentjobid($job_id);
                    $sql="SELECT building_permit from jobs where id=".$pid;
                    $permitnumber=$this->db->query($sql)->row_array();
                    $data['permit_number']=$permitnumber["building_permit"];
                }

                if($this->input->post("dosubmit"))
                {
                    $config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
                    $config['encrypt_name'] = true;
                    $config['allowed_types'] = 'pdf|jpg|png|jpeg';
                    $this->load->library('upload',$config);
                    $this->upload->initialize($config);
                    $permitno=@$this->input->post("permitno");
                    
                        if($file_type=="building" && $permitno<=0){
                            $data['upload_error'] = true;
                            $data["message"]="Permit no can not be left empty.";
                            $this->load->view("job_status/add_permitfile_new",$data);
                        } else if($file_type=="nemstatus" && trim($this->input->post("pdf_name"))==''){ 
                            $data['file_error'] = true;
                            $this->load->view("job_status/add_permitfile_new",$data);
                            return;
                        }
                        else	if($this->upload->do_upload("upload"))  {
                                $file_data = $this->upload->data();
                                $row = array();
                                if ($service_call == 'yes') {
                                        $row['service_call_id'] = $job_id;
                                } else {
                                        $row['job_id'] = $job_id;
                                }
                                $upload_name=$this->input->post("pdf_name");
                                $row['new_filename'] = $upload_name;
                                $row['original_filename'] = $file_data['orig_name'];
                                $row['unique_filename'] = $file_data['file_name'];
                                $row['mime'] = $file_data['file_type'];
                                $row['created'] = date("Y-m-d H:i:s");
                                $row['job_type'] = 2;
                                $pid = $this->getparentjobid($job_id);
                                $row['job_id'] =  $pid;
                                $row['type'] = $file_type;
                                $row['permit_no'] = @$this->input->post("permitno");
                                $data['permit_number']=@$this->input->post("permitno");
                                $row['file_date'] = strtotime($this->input->post("file_date")." ".date("H:i:s"));
                                $row['filestatus'] = @$this->input->post("filestatus");
                                $row['tr_title'] = @$this->input->post("tr_title");
                                $row['created_by'] = $this->session->userdata("user_id");
                                $this->db->insert("permit_files",$row);
                                $upload_id=$this->db->insert_id();
                                $permit_insert_id=$this->db->insert_id();
				
				//start-PHOEN-486
				
				if($file_type=='salesketch'){
				    $row['file_type'] = 'salesketch';
				    $this->db->insert("sketch_files",$row);
				}
				if($file_type=='ssr'){
				    $row['file_type'] = 'surveyresult';
				    $this->db->insert("presale_files",$row);
				}
				
				if($file_type=='surveydraft'){
				    $row['file_type'] = 'surveydraft';
				    $this->db->insert("predesignsketch_files",$row);
				}
				
				if($file_type=='project_design'){
				    $row['file_type'] = 'projectdesign';
				    $this->db->insert("genral_files",$row);
				}
				//end-PHOEN-486
				
                                $data['jobid'] = $job_id ;
                                $data['file_type'] = $file_type;
                                if($file_type=="building" || strstr($file_type,"permit_")){
                                        $job_u=array();
                                        $job_u["objectid"]=0;
                                        $job_u["building_permit_status"]="";
                                        $job_u["electrical_permit_status"]="";
                                        $job_u["building_permit"]=@$this->input->post("permitno");
                                        $this->db->where("job_pid",$pid);
                                        $this->db->update("jobs",$job_u);
                                }
                                if($file_type=='nemstatus'){
                                        $this->nemstatusmail($job_id,$upload_id);
                                }
                                $loadjob = $this->db->query("SELECT job_type_id,customer_id from jobs where id=$job_id")->row_array();
                                if($loadjob["job_type_id"]==2 && ($file_type=="building" || strstr($file_type,"permit_"))){
                                    $this->pvbuildingpdfmailsend($_SERVER['DOCUMENT_ROOT']."/uploads/".$file_data['file_name'], $loadjob["customer_id"]);
                                }else if ($loadjob["job_type_id"]==1 && ($file_type=="building" || strstr($file_type,"permit_"))){
                                    $this->swhbuildingpdfmailsend($_SERVER['DOCUMENT_ROOT']."/uploads/".$file_data['file_name'], $loadjob["customer_id"]);
                                }
                                  
                                $this->sendupload_notification($job_id, $file_type,$_SERVER['DOCUMENT_ROOT']."/uploads/".$file_data['file_name'],$permit_insert_id); 
                                    
                                $this->load->view("common/header");
                                $this->load->view("job_status/permit_uploaded_new",$data);
                                $this->load->view("common/footer");
                        }
                        else
                        {
                        if($file_type=="building"){
                           $pid = $this->getparentjobid($job_id);
                           $job_u=array();
                           $job_u["building_permit"]=@$this->input->post("permitno");
                           $data['permit_number']=@$this->input->post("permitno");
                           $job_u['permit_bulidingdate'] = time();
                           $job_u['permit_buliding_updatedby'] = $this->session->userdata("user_id");;
                           $job_u["objectid"]=0;
                            $job_u["building_permit_status"]="";
                            $job_u["electrical_permit_status"]="";
                           $this->db->where("job_pid",$pid);
                           $this->db->update("jobs",$job_u);
                           $this->load->view("job_status/permit_uploaded_new_bp",$data);
                           $this->load->view("common/footer");
                          } else {
                                $data['upload_error'] = true;
                                $this->load->view("job_status/add_permitfile_new",$data);
                            }
                                    }
                            }
                            else
                            {
                                $this->load->view("job_status/add_permitfile_new",$data);
                            }
                    }
        function pvbuildingpdfmailsend($pdfpath,$customer_id){
                $this->load->library('email');
                $config['mailtype'] = 'html';
                $sql_cust = "SELECT * FROM customers where id=$customer_id";
                $row_cust = $this->db->query($sql_cust)->row_array();
                $sql_update= "UPDATE  customers  set pv_permit_mailsent=1 where id=$customer_id";
                $this->db->query($sql_update);
                $this->email->initialize($config);
                $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=16');
                 $row = $query->row();
                 $sub=$row->strsubject;
                 $msg=$row->strbody;

                $this->email->to($row_cust['email']);
                $this->email->from('sales@aeihawaii.com', 'Schedular');
                $this->email->subject( $sub);
                $msg=strtr($msg, array(
               '%firstName%' => ucfirst($row_cust['first_name']),
               '%lastName%' => ucfirst($row_cust['last_name']),
                '%baseurl%' =>base_url(),
                         ));
                $this->email->message($msg);
                 $this->email->attach($pdfpath);
                $this->email->send();

                       $query = $this->db->query('SELECT another_email_id FROM mailformat where id=16');
                       $row = $query->row();
                       $another_email_id=  explode(',', $row->another_email_id);
                       foreach ($another_email_id as $mail) {
                           if (!filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
                           $this->email->to($mail);
                           $this->email->subject($sub);
                           @$this->email->message($msg);
                           $this->email->attach($pdfpath);
                           @$this->email->send();
                      }
                      }
            }

            function swhbuildingpdfmailsend($pdfpath,$customer_id){
                 $this->load->library('email');
                 $config['mailtype'] = 'html';
                 $sql_cust = "SELECT * FROM customers where id=$customer_id";
                 $row_cust = $this->db->query($sql_cust)->row_array();
                 $sql_update= "UPDATE  customers  set swh_permit_mailsent=1 where id=$customer_id";
                 $this->db->query($sql_update);
                 $this->email->initialize($config);
                 $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=17');
                 $row = $query->row();
                 $sub=$row->strsubject;
                 $msg=$row->strbody;
                 $this->email->to($row_cust['email']);
                 $this->email->from('sales@aeihawaii.com', 'Schedular');
                 $this->email->subject($sub);
                  $msg=strtr($msg, array(
                    '%firstName%' => ucfirst($row_cust['first_name']),
                    '%lastName%' => ucfirst($row_cust['last_name']),
                    '%baseurl%' =>base_url(),
                    ));
                  $this->email->message($msg);
                  @$this->email->attach($pdfpath);
                  @$this->email->send();

                        $query = $this->db->query('SELECT another_email_id FROM mailformat where id=17');
                        $row = $query->row();
                        $another_email_id=  explode(',', $row->another_email_id);
                        foreach ($another_email_id as $mail) {
                            if (!filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
                            $this->email->to($mail);
                            $this->email->subject($sub);
                            @$this->email->message($msg);
                            $this->email->attach($pdfpath);
                            @$this->email->send();
                       }
                       }
            }
        
        function ajaxnewpremitfilelisting($job_id,$file_type,$permit_no=0){  
            $pid = $this->getparentjobid($job_id);
            $this->db->where("job_id",$pid);
            $this->db->where("type",$file_type);
            $this->db->order_by("created","desc");
            $json = array();
            $downloadname = "Download";
            $plan_files = $this->db->get("permit_files")->row_array();
            $json['filedata']='';
            if (count($plan_files) > 0){
                $json['success']=true;
                if(strstr($file_type,"newtr_")){
                   $json['filedata'].='<tr id="document_'.$plan_files['id'].'" style="background-color:white !important;"><td width="200">'.ucfirst($plan_files['tr_title']).': </td><td align="right" width="400">';
                   $json['filedata'].='<span style="color:#999;">('.$this->getUserIntial($plan_files['created_by']).','.date("m/d/y H:i:s",$plan_files["file_date"]).') </span><span style="color:#000;">'.ucfirst($plan_files["filestatus"]).' '.date("m/d/y",strtotime($plan_files["created"])).'</span>&nbsp;';
                }else if(strstr($file_type,"permit_")){ 
                    $json['filedata'].='<span>(Update Status: </span><a href="http://dppweb.honolulu.gov/DPPWeb/default.asp?PossePresentation=BuildingPermit&PosseObjectId='.@$permit_no.'"><strong style="vertical-align:top;text-decoration:underline;color:green;">'.@$permit_no.')</strong></a><span style="color:#000;">'.ucfirst($plan_files["filestatus"]).' '.date("m/d/y",strtotime($plan_files["created"])).'</span>&nbsp;';
                }else{
                $json['filedata'].='<span style="color:#999;">('.$this->getUserIntial($plan_files['created_by']).','.date("m/d/y H:i:s",$plan_files["file_date"]).') </span><span style="color:#000;">'.ucfirst($plan_files["filestatus"]).' '.date("m/d/y",strtotime($plan_files["created"])).'</span>&nbsp;';
                }
                
                if(strstr($file_type,"photo")){
                   $json['filedata'].='<a  class=""style="vertical-align:top;text-decoration:underline;color:green;" href="'.base_url().'admin/downloadpermit/'.$plan_files['id'].'">'.$downloadname.'</a>';
                } else {
                   $json['filedata'].='<a  class=""style="vertical-align:top;text-decoration:underline;color:green;" href="'.base_url().'admin/downloadpermit/'.$plan_files['id'].'">'.$downloadname.'</a>';
                }
                 if($file_type == 'newtr_swhdocuments' ){
                    $json['filedata'].='<a href="'.base_url().'admin/delete_jobstatusfile/'.$plan_files['id'].'/'.$job_id.'" style="vertical-align:top;text-decoration:none; "> (Delete)</a>';
                } else if(strstr($file_type, "newtr_")){
                     $json['filedata'].='<a href="javascript:void(0);" onclick="delete_document_deposit('.$plan_files['id'].')" style="vertical-align:top;text-decoration:none; "> (Delete)</a>';
                }else {
                    $json['filedata'].='<a href="javascript:void(0);" onclick="delete_uploadfile('.$plan_files['id'].','.$job_id.')" style="vertical-align:top;text-decoration:none; "> (Delete)</a>';
                }

                if(strstr($file_type,"newtr_")){
                  $json['filedata'].='</td></tr>';
                }

            
       	  }
	 echo json_encode($json);

	}
    function getUserIntial($id,$fullname=false){
          if (!$id) return 0;
          $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
          $intial="";
          foreach($j as $key => $value) {
            $intial = ucfirst($value['first_name'][0]).ucfirst($value['last_name'][0]);
            if($fullname){
             $intial = ucfirst($value['first_name'])." ".ucfirst($value['last_name']);
            }
          }
          return $intial;
     }
     
   
      
        function delete_document($id){
             $this->db->where('id', $id);
             $this->db->delete('permit_files');
             $json['success']=true;
          echo json_encode($json);
       }
      
       
        function gettimeLimit($jobid){
          $timelimit = 24;
          $resultcnt =  $this->db->query("SELECT * FROM globalconfig  where id = 1")->result_array();
          $timelimit = $resultcnt[0]['globaltimelimit'];
          return $timelimit;
      }
  
    function getexttimeLimit($jobid){
       $pid = $this->getparentjobid($jobid);
       $resultcnt =  $this->db->query("SELECT timeext as smtimeext,created_on FROM timelimit_manual_extend where jid = '".$pid."' ")->result_array();
       $timelimit = 0;
       if(count($resultcnt)>=1) {
         $timelimit_cal =  (int)(time()-strtotime($resultcnt[0]['created_on']));
         $timelimit = $resultcnt[0]['smtimeext']-round($timelimit_cal/3600);
       }
       return $timelimit;
    }
    
    function getuser($id){
	  if(!isset($id) || $id<0) {
	      $j = new stdclass;
		  $j[0]->first_name=" ";
           $j[0]->last_name=" ";
           $j[0]->phone=" ";
           return $j;
	  }

	  if($id>0){
		$j = new stdclass;
		$j = $this->db->query("SELECT users.* FROM users WHERE  id =$id ")->result();
		if(isset($j[0]->first_name))
			return $j;
		else {
           $j[0]->first_name="";
           $j[0]->last_name="";
           $j[0]->phone="";
           return $j;
       }
	  } else{
	      return " ";
	  }
  }
  
      function getCommentType()
	{
        $sql = "SELECT id,comment_type FROM comment_type";
        return $this->db->query($sql)->result_array();
        }
        
        function getRankType()
	{
		$sql = "SELECT id,rank_type FROM rank_type";
		return $this->db->query($sql)->result_array();
		}
                
    function getproposaltype($proposal_id){
      $sql = "select deal_type from proposal where id=$proposal_id";
      $row=$this->db->query($sql)->row_array();
      return $row['deal_type'];
   }
   
   function getdernastatus($job_id,$type){
    $return = new stdClass();
    $pid=$this->getparentjobid($job_id);
    $row=$this->db->query("SELECT * from der_na where job_id=$pid and type='$type'")->row_array();
     if(isset($row['id']) && $row['id']>0){
        $return->id=$row['id'];
        $return->createdby=$row['created_by'];
         $return->created=$row['created'];
       return $return;
     }else{
       return 0;
     }

   }
   
  
 
    
       function getUsername($id){
            if (!$id) return 0;
      $j = $this->db->query("SELECT first_name,last_name FROM users WHERE id=$id")->row_array();

      return $j['first_name'].' '.$j['last_name'];
        }
        
        
        
    function delete_statusfile($file_id='',$jobid=1)
    {
        $this->db->where('id',$file_id);
        $this->db->delete('permit_files');
        redirect("job_status_tab/job_status/".$jobid."?msg=file_del");
    }
    //start-PHOEN-486
    function delete_perv_uploadfile($file_id,$job_id,$type='')
    {
	$pid = $this->getparentjobid($job_id);
	$this->db->where('job_id',$pid);
        $this->db->delete('permit_files');
	
	if($type=='sketchfiles'){
	    $this->db->where('id',$file_id);
	    $this->db->delete('sketch_files');
	}
	if($type=='surveyresult'){
	    $this->db->where('id',$file_id);
	    $this->db->delete('presale_files');
	}
	if($type=='projectdesign'){
	    $this->db->where('id',$file_id);
	    $this->db->delete('genral_files');
	}
	if($type=='surveydraft'){
	    $this->db->where('id',$file_id);
	    $this->db->delete('predesignsketch_files');
	}
        redirect("job_status_tab/job_status/".$job_id."?msg=file_del");
    }
    //end-PHOEN-486
    function save_deposit_der_amount($proposal_id,$amount,$job_pid,$job_id){ //change by vikas on 05-10-15
        $row["deposit_der_amount"]=$amount;
        $this->db->where('job_pid',$job_pid);
        $this->db->update('jobs', $row);
        $job=$this->db->query("select * from jobs where id=".$job_pid)->row_array();

            $job_type=$job['job_type_id'];
            $table="";
            switch ($job_type){
                case '2':
                    $table="proposal";
                    break;
                case '1':
                    $table="swhproposal";
                    break;
                case '16':
                    $table="acproposal";
                    break;
                case '20':
                    $table="safproposal";
                    break;
                case '21':
                    $table="homecharging";
                    break;
                case '23':
                    $table="drwproposal";
                    break;
               }
               if($table!=""){
                    $prop=array();
                    $prop['amount_deposit']=@$amount;
                    $this->db->where('id',$job['proposal_id']);
                    $this->db->update($table,$prop);
               }
               
                $log=array();
                $log['user_id']=$this->session->userdata("user_id");
                $log['job_pid']=$job_pid;
                $log['created']=date("Y-m-d H:i:s");
                $log['field_name']='der_receive';
                $sql="SELECT * FROM sent_notififaction_log WHERE field_name='der_receive' AND job_pid=".$job_pid;
                $log_data=$this->db->query($sql)->result_array();
                if(count($log_data)>0){
                    $this->db->where(array('job_pid'=>$job_pid, 'field_name'=>'der_receive'));
                    $this->db->update("sent_notififaction_log",$log);
                }else{
                    $this->db->insert("sent_notififaction_log",$log);
                }
                $this->checkreadytinstallmail($proposal_id, $job_id);
               
             $json['success'] = true;
             echo json_encode($json);
        }
        
        function der_stauts_submit($file_type){
            $job_id=$this->input->post("job_id");
            $pid=$this->getparentjobid($job_id);
            $row=array();
            $row["created"]=time();
            $row["created_by"]=$this->session->userdata("user_id");
            $row["type"]=$file_type;
            $row["job_id"]=$job_id;
            $this->db->insert("der_na",$row);
            $insertid=$this->db->insert_id();;
            $json['success']=true;
            $json['msg']='<span style="color:#999;">('.$this->getUserIntial($this->session->userdata("user_id")).','.date("m/d/y H:i:s",time()).') </span>&nbsp;  Not Applicable<a href="javascript:void(0);" onclick="reset_der_na('.$insertid.');"> Reset </a>';
            echo json_encode($json);
             return;
        }
  
        function der_stauts_remove($id){
            $this->db->where("id",$id);
            $this->db->delete("der_na");
            $json['success']=true;
            echo json_encode($json);
            return;
         }          
        function send_notification($type){
            $job_id = $this->input->post("job_id");
            $pid = $this->getparentjobid($job_id);
            $field_name = $this->input->post("field_name");

            $row[$field_name] =NULL;
            $dt = trim($this->input->post("dt"));
            if(isset($dt)&& $dt!='null'){
            $row[$field_name] = implode("-",explode("/",$this->input->post("dt")));
            }
             if($type=='array_map'){
                if($dt!='null')
                   $row['array_email_sent'] =1;
                else
                    $row['array_email_sent'] =0;
            }

            $this->db->where('job_pid',$pid);
            $this->db->update('jobs', $row);
            $log=array();
            $log['user_id']=$this->session->userdata("user_id");
            $log['job_id']=$job_id;
            $log['job_pid']=$pid;
            $log['created']=date("Y-m-d H:i:s");
            $log['field_name']=$field_name;
            $sql="SELECT * FROM sent_notififaction_log WHERE field_name='$field_name' AND job_id=".$job_id;
            $log_data=$this->db->query($sql)->result_array();
            if(count($log_data)>0){
                $this->db->where(array('job_id'=>$job_id, 'field_name'=>$field_name));
                $this->db->update("sent_notififaction_log",$log);
            }else{
                $this->db->insert("sent_notififaction_log",$log);
            }
            $json['success'] = true;
            echo json_encode($json);

     }
     
     function send_bisnotification(){
        $job_id = $this->input->post("job_id");
        $pid = $this->getparentjobid($job_id);
        $row['bis'] =NULL;
        $row['bis_created']=time();
        $row['bis_userid']=$this->session->userdata("user_id");
        $dt = trim($this->input->post("dt"));
        if(isset($dt)&& $dt!='null'){
        $row['bis'] = implode("-",explode("/",$this->input->post("dt")));
        }

        $this->db->where('job_pid',$pid);
        $this->db->update('jobs', $row);
        
            $log=array();
            $log['user_id']=$this->session->userdata("user_id");
            $log['job_id']=$job_id;
            $log['job_pid']=$pid;
            $log['created']=date("Y-m-d H:i:s");
            $log['field_name']='bis';
            $sql="SELECT * FROM sent_notififaction_log WHERE field_name='bis' AND job_id=".$job_id;
            $log_data=$this->db->query($sql)->result_array();
            if(count($log_data)>0){
                $this->db->where(array('job_id'=>$job_id, 'field_name'=>'bis'));
                $this->db->update("sent_notififaction_log",$log);
            }else{
                $this->db->insert("sent_notififaction_log",$log);
            }
            
            
        //$this->sendusermail($job_id,'building');
        $json['success'] = true;
        echo json_encode($json);
      }
      
      function send_eisnotification(){
        $job_id = $this->input->post("job_id");
        $pid = $this->getparentjobid($job_id);
        $row['eis'] = NULL;
        $dt = $this->input->post("dt");
         $row['eis_created']=time();
        $row['eis_userid']=$this->session->userdata("user_id");
        if(isset($dt)&& $dt!='null'){
         $row['eis'] = implode("-",explode("/",$this->input->post("dt")));
        }
        $this->db->where('job_pid',$pid);
        $this->db->update('jobs', $row);
        
            $log=array();
            $log['user_id']=$this->session->userdata("user_id");
            $log['job_id']=$job_id;
            $log['job_pid']=$pid;
            $log['created']=date("Y-m-d H:i:s");
            $log['field_name']='eis';
            $sql="SELECT * FROM sent_notififaction_log WHERE field_name='eis' AND job_id=".$job_id;
            $log_data=$this->db->query($sql)->result_array();
            if(count($log_data)>0){
                $this->db->where(array('job_id'=>$job_id, 'field_name'=>'eis'));
                $this->db->update("sent_notififaction_log",$log);
            }else{
                $this->db->insert("sent_notififaction_log",$log);
            } 
            
       // $this->sendusermail($job_id,'electrical');
        $json['success'] = true;
        echo json_encode($json);
      }
      
       function sendusermail($job_id,$content){
            $ismailsent = $this->globalnotifcation();
            if(!$ismailsent){
                return;
            }
            
             
                if($content == 'building'){
                 $template = 'template_mail_56';
                 $role_id = 56;
                 }else if($content == 'electrical'){
                $template = 'template_mail_57';
                 $role_id = 57;
                 }else{
                 $template = 'template_mail_7';
                 $role_id = 7; 
                 }
                 
            $this->load->helper('mail');
             $sql = "SELECT   users.email,users.type,customers.first_name,customers.last_name,jobs.contractor_id,jobs.installer_id,jobs.conduit_id,jobs.project_designer_id FROM		jobs
                                LEFT JOIN users ON jobs.user_id=users.id
                                LEFT JOIN customers ON jobs.customer_id=customers.id
                                LEFT JOIN  notification_setting ns ON ns.user_id = users.id
                                WHERE ns.notification!=0 AND jobs.id=".$job_id;

             $data = array();
             $data = $this->db->query($sql)->result_array();
             if(count($data)>=1){
                $name = ucfirst($data[0]['last_name'])." ".ucfirst($data[0]['first_name']);
                     $mail =getmailid($data[0]['email'],$data[0]['type'],0,0,$role_id);
                     if($mail){
                        if($content=="paperwork" || $content=="paperwork1" || $content=="paperwork2" || $content=="paperwork3"){
                          @$this->sendpaperworkmail($mail,$content,$job_id,$name);
                        }
                        else{
                   @$this->sendpermitmail($mail,$content,$job_id,$name);
                }
             }
                        $in_user = '';
                if($data[0]['contractor_id']){
                    $in_user .= $data[0]['contractor_id'].",";
                }
                if($data[0]['installer_id']){
                    $in_user .= $data[0]['installer_id'].",";
                }
                 if($data[0]['project_designer_id']){
                    $in_user .= $data[0]['project_designer_id'].",";
                }
                $in_user = substr($in_user,0,-1);
               
                $assoc_users =  array();
                if ($in_user!=''){
                    $assoc_users = $this->db->query("SELECT users.email,users.type from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id LEFT JOIN permission ps ON ps.user_id = users.id  WHERE (ps.$template = 1 or ps.$template is null) and ns.notification!=0 AND type in ('admin','engineer')  AND users.id in ($in_user)")->result_array();
                    foreach ($assoc_users as $value){
                         $mail = getmailid($value['email'],$value['type'],0,0,$role_id);
                       if($content=="paperwork"){
                                @$this->sendpaperworkmail($value['email'],$content,$job_id,$name);
                               }
                             else{
                       @$this->sendpermitmail($value['email'],$content,$job_id,$name);
                     }
                    }
                }
             }
             
                 //send email to another email id
                 if($content == 'building'){
                 $role_id = 56;
                 }else if($content == 'electrical'){
                 $role_id = 57;
                 }else{
                 $role_id = 7; 
                 }
                $query = $this->db->query('SELECT another_email_id FROM mailformat where id='.$role_id);
                $row1 = $query->row();
                $another_email_id=  explode(',', $row1->another_email_id);
                foreach ($another_email_id as $mail) {
                    if (!filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
                    if($content=="paperwork"){
                                @$this->sendpaperworkmail($mail,$content,$job_id,$name);
                               }
                             else{
                       @$this->sendpermitmail($mail,$content,$job_id,$name);
                     }
                }
                }
           
        }
        
        function sendpaperworkmail($mailid,$content,$job_id,$name){
            $ismailsent = $this->globalnotifcation();
             if(!$ismailsent){
                 return;
             }
            $sql_userid="SELECT user_id,job_pid FROM  jobs WHERE  id=".$job_id;
            $row_userid = $this->db->query($sql_userid)->row_array();
            $isuserpre = $this->issendnotification($row_userid['user_id']);
            if(!$isuserpre){
             $json['success'] = true;
             echo json_encode($json);
             return ;
            }
            $sql_pv_job = $this->db->query("SELECT job_date from jobs WHERE job_type_id=2 AND id=".$row_userid['job_pid'])->row_array();
            $sql_pm_job = $this->db->query("SELECT id,job_date from jobs WHERE job_type_id=7 AND job_pid=".$row_userid['job_pid'])->row_array();
            $sql_pl_job = $this->db->query("SELECT id,job_date from jobs WHERE job_type_id=6 AND job_pid=".$row_userid['job_pid'])->row_array();
            $pv_date ="";
            if(isset($sql_pv_job["job_date"]) && @$sql_pv_job["job_date"] ){
              $pv_date =date("l,F j, Y",strtotime($sql_pv_job["job_date"]));
            }
            $pm_date ="";
            if(isset($sql_pm_job["job_date"]) && @$sql_pm_job["job_date"] ){
              $pm_date = "Premeasure scheduled for <a href='".base_url()."admin/job/".$sql_pm_job["id"]."' >".date("l,F j, Y",strtotime($sql_pm_job["job_date"]))."</a>";
            }

            $pl_date ="";
            if(isset($sql_pl_job["job_date"]) && @$sql_pl_job["job_date"] ){
              $pl_date = "Prelag date scheduled for <a href='".base_url()."admin/job/".$sql_pl_job["id"]."' >".strtotime(date("l,F j, Y",$sql_pl_job["job_date"]))."</a>";
            }

            $this->load->library('email');
            $config['mailtype'] = 'html';
            $this->email->initialize($config);
            $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
            $this->email->to($mailid);
            $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=13');
                         $row = $query->row();
                         $sub=$row->strsubject;
                         $msg=$row->strbody;

                         $sub= strtr($sub, array('%fullname%' => $name));


            $this->email->subject($sub);
            $messagebdy='<p>Thank you for submitting your required documents for '.$name.' scheduled for installation on 
         <a href="'.base_url().'admin/job/'.$row_userid['job_pid'].'">'.$pv_date.'</a>.<br/><br/>

         Don\'t forget your customer\'s other important dates: <br/>
         '.$pm_date.'<br/>'.$pl_date.'

         </p>';
           if ($content=='paperwork1'){
                  $messagebdy='<p>Your customer has received a NEM Status update: NEM is "Pending Technical Review" for this customer</p>';
           }
           if ($content=='paperwork2'){
                  $messagebdy='<p>Your customer has received a NEM Status update: NEM is "Accepted - pending permit closure" for this customer.</p>';
           }
           if ($content=='paperwork3'){
                  $messagebdy='<p>Your customer has received a NEM Status update: NEM is "Accepted" for this customer</p>';
           }
            $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
                 <tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
                 </tr>
                 <tr>
              <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">'.$messagebdy.'

         Thanks You,<br/>
         The AEI Administration Team
                         </td>
                 </tr>
                 <tr>
                         <td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
                 </tr>
         </table>';
              $msg=strtr($msg, array(
                          '%pvdate%' => $pv_date,
                          '%fullname%' => $name,
                          '%jobid%' => $row_userid['job_pid'],
                          '%pmdate%' => $pm_date,
                          '%pldate%' => $pl_date,
                          '%message_body%' =>$messagebdy,
                                   '%baseurl%' =>base_url(),
                          ));
              @$this->email->message($msg);
              @$this->email->send();
          }

        function sendpermitmail($mailid,$content,$job_id,$name){
            $ismailsent = $this->globalnotifcation();
             if(!$ismailsent){
                 return;
             }
            $sql_userid="SELECT user_id FROM  jobs WHERE  id=".$job_id;
            $row_userid = $this->db->query($sql_userid)->row_array();
            $isuserpre = $this->issendnotification($row_userid['user_id']);
            if(!$isuserpre){
             $json['success'] = true;
             echo json_encode($json);
             return ;
            }
            $this->load->library('email');
            $config['mailtype'] = 'html';
            $this->email->initialize($config);
            $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
            $this->email->to($mailid);
             if($content == 'building'){
                 $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=56');
              }else if($content == 'electrical'){
                 $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=57'); 
              }else{
                 $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=7');
              }
                         $row = $query->row();
                         $sub=$row->strsubject;
                         $msg=$row->strbody;

                         $sub= strtr($sub, array('%fullname%' => $name));

                          $msg=strtr($msg, array(
                          '%content%' => @ucfirst($content),
                          '%fullname%' => $name,
                          '%jobid%' => $job_id,
                          '%baseurl%' =>base_url(),
                          ));
            $this->email->subject($sub);
            $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
                 <tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
                 </tr>
                 <tr>
              <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
         <p> '.@ucfirst($content).' Permit for '.$name.' has been uploaded for review<br/>
         <a href="'.base_url().'admin/permit_job/'.$job_id.'">Download Permit</a><br/><br/>


         </p>
         Sincerely,<br/>
         The AEI Administration Team
                         </td>
                 </tr>
                 <tr>
                         <td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
                 </tr>
         </table>';
              @$this->email->message($msg);
              @$this->email->send();
          }
        
        
        function send_dropdownchange_notification($job_id=0,$role_id=0){  
            $field_val='';
            $field_name='';
            $field_name=$this->input->post("field_name");
            $field_val=$this->input->post("field_val");
            if(!$field_val){
               $field_val = 'none'; 
            }
            $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
            FROM jobs
            LEFT JOIN job_types ON job_types.id=jobs.job_type_id	
            LEFT JOIN customers ON jobs.customer_id=customers.id
            WHERE jobs.id=".$job_id;
            $data['job'] = $this->db->query($sql)->row_array();
                
                
            $template = 'template_mail_'.$role_id;  
            $this->load->helper('mail');
              
            
            
            $this->load->library('email');
            $config['mailtype'] = 'html';
            $this->email->initialize($config);
            $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
            
            $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id='.$role_id);
            $row_email = $query->row();
            $sub=$row_email->strsubject;
            $msg=$row_email->strbody;
            
            
             $joblink='javascript:void(0)';
               if($job_id){
                $joblink=base_url().'job_status_tab/job_status/'.$job_id;
             }
            
            
             //send email to sales user email id 
               $j= $this->getUserLoadNew($data['job']['user_id'],$template);
                 if(isset($data['job']['user_id'])){
                           
                      $mail =getmailid(@$j[0]->email,@$j[0]->type,0,0,$role_id);
                      if($mail){ 
                        $saleman='%userFirstName%  %userLastName%';
                        $customer='%firstName%  %lastName%';
                        $this->email->to($mail);
                        $sub=strtr($sub, array('%next_status%'=> $field_val));
                        $sub=msgfunction($sub,$job_id);
                        $this->email->subject($sub);
                        $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%fieldname%' => $field_name,'%next_status%'=> $field_val));
                        $msg=msgfunction($msg,$job_id);
                        @$this->email->message($msg);
                        @$this->email->send();  
                     }
                }
                 
                //send email to enginner and installer
                $in_user = '';
                if(trim($data['job']['project_designer_id'])!=''){
                    $in_user .= "'".$data['job']['project_designer_id']."',";
                }
                if(trim($data['job']['installer_id'])!=''){
                    $in_user .= "'".$data['job']['installer_id']."',";
                }
                if(trim($data['job']['contractor_id'])!=''){
                    $in_user .= "'".$data['job']['contractor_id']."',";
                }
                $in_user = substr($in_user,0,-1);
                $assoc_users =  array();
                if ($in_user!=''){
                    $assoc_users = $this->db->query("SELECT users.email,users.type,users.id as user_id,users.first_name, users.last_name from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id  LEFT JOIN permission ps ON ps.user_id = users.id WHERE (ps.$template = 1 or ps.$template is null) AND  ns.notification =1 AND users.type in ('admin','engineer') AND  users.id in ($in_user)")->result_array();
                    foreach ($assoc_users as $value){ 
                      $mail = getmailid($value['email'],$value['type'],0,0,$role_id);
                    if($mail == TRUE){
                        $this->email->to($mail);
                        $sub=strtr($sub, array('%next_status%'=> $field_val));
                        $sub=msgfunction($sub,$job_id);
                        $this->email->subject($sub);
                        $saleman=@$value['first_name'].' '.@$value['last_name'];
                        $customer='%firstName%  %lastName%';
                        $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%fieldname%' => $field_name,'%next_status%'=> $field_val));
                        $msg=msgfunction($msg,$job_id);
                        @$this->email->message($msg);
                        @$this->email->send();
                    }
                }
                }
                            
                //send email to another email id
                $query = $this->db->query('SELECT another_email_id FROM mailformat where id='.$role_id);
                $row1 = $query->row();
                $another_email_id=  explode(',', $row1->another_email_id);
                foreach ($another_email_id as $mail) {
                    if (!filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
                    $saleman='%userFirstName%  %userLastName%';
                    $customer='%firstName%  %lastName%';
                    $this->email->to($mail);
                    $sub=strtr($sub, array('%next_status%'=> $field_val));
                    $sub=msgfunction($sub,$job_id);
                    $this->email->subject($sub);
                    $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%fieldname%' => $field_name,'%next_status%'=> $field_val));
                    $msg=msgfunction($msg,$job_id);
                    @$this->email->message($msg);
                    @$this->email->send();
                }
                }
         }
         
        
      
                   
          function sendupload_notification($job_id=0,$file_type=0,$pdfpath='',$permit_insert_id=0){  
          
             
             $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id	
                LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$job_id;
                $data['job'] = $this->db->query($sql)->row_array();
                
                switch($file_type):
                    case'spa':
                        $role_id=75;
                        break;
                    case'stc':
                        $role_id=76;
                        break;
                    case'salesketch':
                        $role_id=77;
                        break;
                    case'heco_bill':
                        $role_id=78;
                        break;
                    case'trustdocument':
                        $role_id=79;
                        break;
                    case'ssr':
                        $role_id=80;
                        break;
                    case'heco_ap':
                        $role_id=81;
                        break;
                    case'project_design':
                        $role_id=82;
                        break;
                    case'project_approved':
                        $role_id=83;
                        break;
                    case'hoa_app':
                        $role_id=84;
                        break;
                    case'permit_open':
                        $role_id=85;
                        break;
                    case'cover_sheet':
                        $role_id=86;
                        break;
                    case'obt_ride':
                        $role_id=87;
                        break;
                    case'permit_close':
                        $role_id=88;
                        break;
                    case'derclosepacket':
                        $role_id=89;
                        break;
                     case'deracceptance':
                        $role_id=90;
                        break;
                     case'heep_app':
                        $role_id=91;
                        break;
                     case'newtr_adminrequire':
                        $role_id=92;
                        break;
                     case'newtr_permithoa':
                        $role_id=93;
                        break;
                     case'newtr_hecoderpreinstall':
                        $role_id=94;
                        break;
                     case'newtr_hecoderproject':
                        $role_id=95;
                        break;
                     case'newtr_hecoder':
                        $role_id=96;
                        break;
                endswitch;
                $template = 'template_mail_'.$role_id;  
                $this->load->helper('mail');
              
               
           
            $this->load->library('email');
            $config['mailtype'] = 'html';
            $this->email->initialize($config);
            $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
            if($pdfpath!=''){
            $this->email->attach($pdfpath);
            }
            $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id='.$role_id);
            $row_email = $query->row();
            $sub=$row_email->strsubject;
            $msg=$row_email->strbody;
                
                
             $joblink='javascript:void(0)';
               if($job_id){
                $joblink=base_url().'job_status_tab/job_status/'.$job_id;
             }
            
            
             //send email to sales user email id 
               $j= $this->getUserLoadNew($data['job']['user_id'],$template);
                 if(isset($data['job']['user_id'])){
                           
                    $mail =getmailid(@$j[0]->email,@$j[0]->type,0,0,$role_id);
                      if($mail){ 
                        $saleman='%userFirstName%  %userLastName%';
                        $customer='%firstName%  %lastName%';
                        $this->email->to($mail);
                        $sub=msgfunction($sub,$job_id);
                        $this->email->subject($sub);
                        $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%permit_file_id%'=>$permit_insert_id));
                        $msg=msgfunction($msg,$job_id);
                        @$this->email->message($msg);
                        @$this->email->send();  
                     }
                }
                 
                  //send email to enginner and installer
                $in_user = '';
                if(trim($data['job']['project_designer_id'])!=''){
                    $in_user .= "'".$data['job']['project_designer_id']."',";
                }
                 if(trim($data['job']['installer_id'])!=''){
                    $in_user .= "'".$data['job']['installer_id']."',";
                }
                if(trim($data['job']['contractor_id'])!=''){
                    $in_user .= "'".$data['job']['contractor_id']."',";
                }
                
                $in_user = substr($in_user,0,-1);
                $assoc_users =  array();
                if ($in_user!=''){
                    $assoc_users = $this->db->query("SELECT users.email,users.type,users.id as user_id,users.first_name, users.last_name from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id  LEFT JOIN permission ps ON ps.user_id = users.id WHERE (ps.$template = 1 or ps.$template is null) AND  ns.notification =1 AND users.type in ('admin','engineer') AND  users.id in ($in_user)")->result_array();
                    foreach ($assoc_users as $value){ 
                      $mail = getmailid($value['email'],$value['type'],0,0,$role_id);
                    if($mail == TRUE){
                        $this->email->to($mail);
                        $sub=msgfunction($sub,$job_id);
                        $this->email->subject($sub);
                        $saleman=@$value['first_name'].' '.@$value['last_name'];
                        $customer='%firstName%  %lastName%';
                       $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%permit_file_id%'=>$permit_insert_id));
                        $msg=msgfunction($msg,$job_id);
                        @$this->email->message($msg);
                        @$this->email->send();
                    }
                }
                }
                
                   //send email to another email id
                $query = $this->db->query('SELECT another_email_id FROM mailformat where id='.$role_id);
                $row1 = $query->row();
                $another_email_id=  explode(',', $row1->another_email_id);
                foreach ($another_email_id as $mail) {
                    if (!filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
                    $saleman='%userFirstName%  %userLastName%';
                    $customer='%firstName%  %lastName%';
                    $this->email->to($mail);
                    $sub=msgfunction($sub,$job_id);
                    $this->email->subject($sub);
                    $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%permit_file_id%'=>$permit_insert_id));
                    $msg=msgfunction($msg,$job_id);
                    @$this->email->message($msg);
                    @$this->email->send();
                }
                }
         }
         
         function send_updatepahse_alert($job_id=0,$phase_type=0){
             
             $sql = "SELECT
			jobs.id,jobs.user_id,jobs.project_designer_id,jobs.installer_id,jobs.contractor_id,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id	
                LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$job_id;
                $data['job'] = $this->db->query($sql)->row_array();
                
                $field_value='';
                $role_id=0;
                switch($phase_type):
                    case'1':
                        $role_id=97;
                        $sql="SELECT name from job_phase_type where id = 1 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'2':
                        $role_id=98;
                        $sql="SELECT name from job_phase_type where id = 2 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'3':
                        $role_id=99;
                        $sql="SELECT name from job_phase_type where id = 3 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'4':
                        $role_id=100;
                        $sql="SELECT name from job_phase_type where id = 4 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'6':
                        $role_id=101;
                        $sql="SELECT name from job_phase_type where id = 6 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'7':
                        $role_id=102;
                        $sql="SELECT name from job_phase_type where id = 7 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'8':
                        $role_id=103;
                        $sql="SELECT name from job_phase_type where id = 8 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'9':
                        $role_id=104;
                        $sql="SELECT name from job_phase_type where id = 9 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'5':
                        $role_id=120;
                        $sql="SELECT name from job_phase_type where id = 5 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    
                endswitch;
                
                $template = 'template_mail_'.$role_id;  
                $this->load->helper('mail');
              
               
          
            $this->load->library('email');
            $config['mailtype'] = 'html';
            $this->email->initialize($config);
            $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
            $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id='.$role_id);
            $row_email = $query->row();
            $sub=$row_email->strsubject;
            $msg=$row_email->strbody;
                
                
             $joblink='javascript:void(0)';
               if($job_id){
                $joblink=base_url().'job_status_tab/job_status/'.$job_id;
             }
            
            
             //send email to sales user email id 
               $j= $this->getUserLoadNew($data['job']['user_id'],$template);
                 if(isset($data['job']['user_id'])){
                           
                    $mail =getmailid(@$j[0]->email,@$j[0]->type,0,0,$role_id);
                      if($mail){ 
                        $saleman='%userFirstName%  %userLastName%';
                        $customer='%firstName%  %lastName%';
                        $this->email->to($mail);
                        $sub=msgfunction($sub,$job_id);
                        $this->email->subject($sub);
                        $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%fieldname%'=>$field_value));
                        $msg=msgfunction($msg,$job_id);
                        @$this->email->message($msg);
                        @$this->email->send();  
                     }
                }
                 
                  //send email to enginner and installer
                $in_user = '';
                if(trim($data['job']['project_designer_id'])!=''){
                    $in_user .= "'".$data['job']['project_designer_id']."',";
                }
                if(trim($data['job']['installer_id'])!=''){
                    $in_user .= "'".$data['job']['installer_id']."',";
                }
                if(trim($data['job']['contractor_id'])!=''){
                    $in_user .= "'".$data['job']['contractor_id']."',";
                }
                $in_user = substr($in_user,0,-1);
                $assoc_users =  array();
                if ($in_user!=''){
                    $assoc_users = $this->db->query("SELECT users.email,users.type,users.id as user_id,users.first_name, users.last_name from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id  LEFT JOIN permission ps ON ps.user_id = users.id WHERE (ps.$template = 1 or ps.$template is null) AND  ns.notification =1 AND users.type in ('admin','engineer') AND  users.id in ($in_user)")->result_array();
                    foreach ($assoc_users as $value){ 
                      $mail = getmailid($value['email'],$value['type'],0,0,$role_id);
                    if($mail == TRUE){
                        $this->email->to($mail);
                        $sub=msgfunction($sub,$job_id);
                        $this->email->subject($sub);
                        $saleman=@$value['first_name'].' '.@$value['last_name'];
                        $customer='%firstName%  %lastName%';
                       $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%fieldname%'=>$field_value));
                        $msg=msgfunction($msg,$job_id);
                        @$this->email->message($msg);
                        @$this->email->send();
                    }
                }
                }
                
              
                //send email to another email id
                $query = $this->db->query('SELECT another_email_id FROM mailformat where id='.$role_id);
                $row1 = $query->row();
                $another_email_id=  explode(',', $row1->another_email_id);
                foreach ($another_email_id as $mail) {
                    if (!filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
                    $saleman='%userFirstName%  %userLastName%';
                    $customer='%firstName%  %lastName%';
                    $this->email->to($mail);
                    $sub=msgfunction($sub,$job_id);
                    $this->email->subject($sub);
                    $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%fieldname%'=>$field_value));
                    $msg=msgfunction($msg,$job_id);
                    @$this->email->message($msg);
                    @$this->email->send();
                }
                }
               // redirect("job_status_tab/job_status/$job_id");
         }
         
         function date_send_notification_alert($job_id,$type){
             
             $sql = "SELECT
			jobs.id,jobs.user_id,jobs.project_designer_id,jobs.installer_id,jobs.contractor_id,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id	
                LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$job_id;
                $data['job'] = $this->db->query($sql)->row_array();
                
                $field_value='';
                $role_id=0;
                switch($type):
                    case'array_map':
                        $role_id=113;
                        $field_value="Array Map Configured";
                        break;
                    case'invoice':
                        $role_id=114;
                        $field_value="Invoice Sent?";
                        break;
                    case'closing_packet':
                        $role_id=115;
                        $field_value="Customer Closing Packet";
                        break;
                    case'net_meter_installed':
                        $role_id=116;
                        $field_value="Net Meter Installed?";
                        break;
                    case'closing_courtesy':
                        $role_id=118;
                        $field_value="Closing Courtesy Call";
                        break;
                    case'system_turn_on':
                        $role_id=117;
                        $field_value="System Turned On";
                        break;
                    
                endswitch;
                
                $template = 'template_mail_'.$role_id;  
                $this->load->helper('mail');
              
               
          
            $this->load->library('email');
            $config['mailtype'] = 'html';
            $this->email->initialize($config);
            $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
            $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id='.$role_id);
            $row_email = $query->row();
            $sub=$row_email->strsubject;
            $msg=$row_email->strbody;
                
                
             $joblink='javascript:void(0)';
               if($job_id){
                $joblink=base_url().'job_status_tab/job_status/'.$job_id;
             }
            
            
             //send email to sales user email id 
               $j= $this->getUserLoadNew($data['job']['user_id'],$template);
                 if(isset($data['job']['user_id'])){
                           
                    $mail =getmailid(@$j[0]->email,@$j[0]->type,0,0,$role_id);
                      if($mail){ 
                        $saleman='%userFirstName%  %userLastName%';
                        $customer='%firstName%  %lastName%';
                        $this->email->to($mail);
                        $sub=msgfunction($sub,$job_id);
                        $this->email->subject($sub);
                        $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%fieldname%'=>$field_value));
                        $msg=msgfunction($msg,$job_id);
                        @$this->email->message($msg);
                        @$this->email->send();  
                     }
                }
                 
                //send email to enginner and installer
                $in_user = '';
                if(trim($data['job']['project_designer_id'])!=''){
                    $in_user .= "'".$data['job']['project_designer_id']."',";
                }
                if(trim($data['job']['installer_id'])!=''){
                    $in_user .= "'".$data['job']['installer_id']."',";
                }
                if(trim($data['job']['contractor_id'])!=''){
                    $in_user .= "'".$data['job']['contractor_id']."',";
                }
                $in_user = substr($in_user,0,-1);
                $assoc_users =  array();
                if ($in_user!=''){
                    $assoc_users = $this->db->query("SELECT users.email,users.type,users.id as user_id,users.first_name, users.last_name from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id  LEFT JOIN permission ps ON ps.user_id = users.id WHERE (ps.$template = 1 or ps.$template is null) AND  ns.notification =1 AND users.type in ('admin','engineer') AND  users.id in ($in_user)")->result_array();
                    foreach ($assoc_users as $value){ 
                      $mail = getmailid($value['email'],$value['type'],0,0,$role_id);
                    if($mail == TRUE){
                        $this->email->to($mail);
                        $sub=msgfunction($sub,$job_id);
                        $this->email->subject($sub);
                        $saleman=@$value['first_name'].' '.@$value['last_name'];
                        $customer='%firstName%  %lastName%';
                       $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%fieldname%'=>$field_value));
                        $msg=msgfunction($msg,$job_id);
                        @$this->email->message($msg);
                        @$this->email->send();
                    }
                }
                }
                
              
                //send email to another email id
                $query = $this->db->query('SELECT another_email_id FROM mailformat where id='.$role_id);
                $row1 = $query->row();
                $another_email_id=  explode(',', $row1->another_email_id);
                foreach ($another_email_id as $mail) {
                    if (!filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
                    $saleman='%userFirstName%  %userLastName%';
                    $customer='%firstName%  %lastName%';
                    $this->email->to($mail);
                    $sub=msgfunction($sub,$job_id);
                    $this->email->subject($sub);
                    $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%fieldname%'=>$field_value));
                    $msg=msgfunction($msg,$job_id);
                    @$this->email->message($msg);
                    @$this->email->send();
                }
                }
               // redirect("job_status_tab/job_status/$job_id");
             
         }
         
         function savenotes($job_id,$notes_type=''){
            $notes='';
            $notes=$this->input->post('notes');
            $type=$this->input->post('type');
            $row=array();
            $row['job_id']=$job_id;
            $row['job_pid']=$job_id;
            $row['user_id']=$this->session->userdata('user_id');
            $row['created']=date("Y-m-d H:i:s");
            $row['notes_type']=$type;
            $row['notes']=$notes;
            
            $sql="SELECT * FROM job_notes_log WHERE job_id=".$job_id." AND notes_type='$type'";
            $notes_log=$this->db->query($sql)->result_array();
           if(count($notes_log)>0){ 
                $this->db->where(array('job_id'=>$job_id, 'notes_type'=>$notes_type));
                $this->db->update("job_notes_log",$row);
           }else{
            $this->db->insert("job_notes_log",$row);
           }
             
         }
         
          function delete_notes($id){
             $this->db->where('id', $id);
             $this->db->delete('job_notes_log');
             $json['success']=true;
          echo json_encode($json);
       }
        function add_notes($job_id='', $file_type="no", $service_call='no'){
                if ($service_call == 'yes') {
                        $data['service_call_id'] = $job_id;
                } else {
                        $data['job_id'] = $job_id;
                }
                 $pid = $this->getparentjobid($job_id);
                 
                
                if($this->input->post("dosubmit"))
                {
                    
                    if(trim($this->input->post("notes"))==''){
                        $data['error'] = true;
                        $data["message"]="Text Area can not be left empty.";
                        $this->load->view("job_status/add_notes",$data); 
                        return;
                    }
                    $notes='';
                    $notes=$this->input->post('notes');
                    $row=array();
                    $row['job_id']=$job_id;
                    $row['job_pid']=$pid;
                    $row['user_id']=$this->session->userdata('user_id');
                    $row['created']=date("Y-m-d H:i:s"); 
                    $row['notes_type']=$file_type;
                    $row['notes']=$notes;

                    $this->db->insert("job_notes_log",$row);
                    
                     $this->sendnote_notification($job_id,$file_type,$notes);   
                   
                    $data['file_type']=$file_type;
                  //  redirect("job_status_tab/job_status/".$job_id);
                   $this->load->view("job_status/notes_upload_bp",$data); 
                   $this->load->view("common/footer");
                }else{
                   $this->load->view("job_status/add_notes",$data);
                }
            
        }
        
       function notes_ajax_return($job_id,$file_type){  
            $pid = $this->getparentjobid($job_id);
            $this->db->where("job_id",$pid);
            $this->db->where("notes_type",$file_type);
            $this->db->order_by("created","desc");
            $json = array();
            $plan_files = $this->db->get("job_notes_log")->row_array();
            $json['filedata']='';
            if (count($plan_files) > 0){
                $json['success']=true;
                
                $json['filedata'].='<tr id="notes_'.$plan_files['id'].'" style="background-color:white !important;"><td width="200"> Notes: </td><td width="400" align="right">';
                 $filedata.='<span style="color:#999;">('.$CI->getUserIntial($plan_files['user_id']).','.date("m/d/y H:i:s",strtotime($plan_files["created"])).')</span><span style="color:#000;">  '.$plan_files["notes"].'</span>&nbsp;';
                $json['filedata'].='<a href="javascript:void(0);" onclick="delete_notes('.$plan_files['id'].')" style="vertical-align:top;text-decoration:none; "> (Delete)</a>';
                $json['filedata'].='</td></tr>';
       	  }
	 echo json_encode($json);

	}
        
        function checkreadytinstallmail($proposal_id,$job_id){
            
        $sql = "SELECT jobs.*,job_types.type as job_type FROM jobs LEFT JOIN job_types ON job_types.id=jobs.job_type_id
        WHERE jobs.id=".$this->db->escape($job_id)."";
        $data['job'] = $this->db->query($sql)->row_array();
        $job_type = $data['job']['job_type'];
        $this->load->helper('mail');
        $admin_user_array=array();
        $admin_user_array[]= $data['job']['user_id'];
        $sale_user="select id from users where type='admin'";
        
        $result=$this->db->query($sale_user)->result_array();
        
        foreach($result as $usernoti){
          $admin_user_array[]=$usernoti["id"];
        }
       
         $show_instaler=array();
        if($data['job']['project_designer_id']!="" && $data['job']['project_designer_id']){
            $show_instaler = explode("," ,$data['job']['project_designer_id']);
        }
            $new_show_installer=array_merge($admin_user_array,$show_instaler);
            $showinstaller_name = array();
            foreach($new_show_installer as $installer){
            
                $row["ready_to_install"]=1;
                $this->db->where('id',$job_id);
                $this->db->update('jobs', $row);

               $j = $this->db->query("SELECT users.first_name , users.last_name, users.email,users.type FROM users LEFT JOIN notification_setting ns ON ns.user_id = users.id LEFT JOIN permission ps ON ps.user_id = users.id WHERE (ps.template_mail_61 = 1 or ps.template_mail_61 is null) AND ns.notification = 1 AND (users.user_status='active' or users.user_status=0) AND users.id=$installer")->row_array();
            
                $intial = ucfirst($j['first_name']).ucfirst($j['last_name']);
                $this->load->library('email');
                $config['mailtype'] = 'html';
                $this->email->initialize($config);
                $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
                $check_mail = getmailid($j['email'],$j['type'],0,0,61);
                //$this->email->bcc('permits@alternateenergyhawaii.com');
              
                $this->db->where('id','61');
                $mail=$this->db->get('mailformat')->row();
                $subject=$mail->strsubject;
                $subject=msgfunction($subject,$job_id);
                $message=$mail->strbody;
                $message=str_replace('%baseurl%',base_url(),$message);
                $message=str_replace('%jobid%',$job_id,$message);
                $message=str_replace('%userFirstName%',ucfirst($j['first_name']),$message);
                $message=msgfunction($message,$job_id);
                //$subject = "Check Proposal No. $proposal_id for $job_type is ready to install or Not";
                //$msgtxt =  "Dear $intial,<br/><br/> Please Check Job Specs for Proposal $proposal_id for $job_type is ready to install or Not ?";
                if($check_mail == TRUE){
                  $this->email->to($check_mail);
                  $this->email->subject($subject);
                  @$this->email->message($message);
                  @$this->email->send();
                
                }
                
            }
            
                $query = $this->db->query('SELECT another_email_id FROM mailformat where id=61');
                $row = $query->row();
                $another_email_id=  explode(',', $row->another_email_id);
                foreach ($another_email_id as $mail) {
                    if (!filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
                     $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
                    $this->email->to($mail);
                    $this->email->subject($subject);
                    @$this->email->message($message);
                    @$this->email->send();
               }
               }
        
    }
    
     function sendnote_notification($job_id=0,$file_type=0,$notes){  
          
             
             $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id	
                LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$job_id;
                $data['job'] = $this->db->query($sql)->row_array();
                
                
                $template = 'template_mail_119'; 
                $role_id = 119;
                $this->load->helper('mail');
              
            $this->load->library('email');
            $config['mailtype'] = 'html';
            $this->email->initialize($config);
            $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
            $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id='.$role_id);
            $row_email = $query->row();
            $sub=$row_email->strsubject;
            $msg=$row_email->strbody;
                
                
             $joblink='javascript:void(0)';
               if($job_id){
                $joblink=base_url().'job_status_tab/job_status/'.$job_id;
             }
            
            
             //send email to sales user email id 
               $j= $this->getUserLoadNew($data['job']['user_id'],$template);
                 if(isset($data['job']['user_id'])){
                           
                    $mail =getmailid(@$j[0]->email,@$j[0]->type,0,0,$role_id);
                      if($mail){ 
                        $saleman='%userFirstName%  %userLastName%';
                        $customer='%firstName%  %lastName%';
                        $this->email->to($mail);
                        $sub=msgfunction($sub,$job_id);
                        $this->email->subject($sub);
                        $msg= strtr($msg, array('%file_type%'=>$file_type,'%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id));
                        $msg=msgfunction($msg,$job_id);
                        @$this->email->message($msg);
                        @$this->email->send();  
                     }
                }
                 
                  //send email to enginner and installer
                $in_user = '';
                if(trim($data['job']['project_designer_id'])!=''){
                    $in_user .= "'".$data['job']['project_designer_id']."',";
                }
                 if(trim($data['job']['installer_id'])!=''){
                    $in_user .= "'".$data['job']['installer_id']."',";
                }
                if(trim($data['job']['contractor_id'])!=''){
                    $in_user .= "'".$data['job']['contractor_id']."',";
                }
                
                $in_user = substr($in_user,0,-1);
                $assoc_users =  array();
                if ($in_user!=''){
                    $assoc_users = $this->db->query("SELECT users.email,users.type,users.id as user_id,users.first_name, users.last_name from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id  LEFT JOIN permission ps ON ps.user_id = users.id WHERE (ps.$template = 1 or ps.$template is null) AND  ns.notification =1 AND users.type in ('admin','engineer') AND  users.id in ($in_user)")->result_array();
                    foreach ($assoc_users as $value){ 
                      $mail = getmailid($value['email'],$value['type'],0,0,$role_id);
                    if($mail == TRUE){
                        $this->email->to($mail);
                        $sub=msgfunction($sub,$job_id);
                        $this->email->subject($sub);
                        $saleman=@$value['first_name'].' '.@$value['last_name'];
                        $customer='%firstName%  %lastName%';
                       $msg= strtr($msg, array('%file_type%'=>$file_type,'%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id));
                        $msg=msgfunction($msg,$job_id);
                        @$this->email->message($msg);
                        @$this->email->send();
                    }
                }
                }
                
                   //send email to another email id
                $query = $this->db->query('SELECT another_email_id FROM mailformat where id='.$role_id);
                $row1 = $query->row();
                $another_email_id=  explode(',', $row1->another_email_id);
                foreach ($another_email_id as $mail) {
                    if (!filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
                    $saleman='%userFirstName%  %userLastName%';
                    $customer='%firstName%  %lastName%';
                    $this->email->to($mail);
                    $sub=msgfunction($sub,$job_id);
                    $this->email->subject($sub);
                    $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id));
                    $msg=msgfunction($msg,$job_id);
                    @$this->email->message($msg);
                    @$this->email->send();
                }
                }
         }
       
    }
?>