<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 */

class Inspectionstatus extends Controller {

    function Inspectionstatus() {

        parent::Controller();

        //ini_set("display_errors",1);
        // if user is an installer, redirect them to an error page if
        // they're trying to do something they do have permissions to do
        if ($this->session->userdata("role") == 'installer' && $this->session->userdata("installer_permissions") != 'y') {
            $method = $this->router->method;
            $protected = array("delete_job");
            if (in_array($method, $protected)) {
                redirect("admin/error?e=permissions");
            }
        }

        $this->load->helper(array('form', 'url'));
    }

    function buildingpermitstatus($permit_no, $jobid) {

        $permit_exist = $this->getpermitobject($permit_no);
        if ($permit_exist) {
            $data = $this->getexistpermitstatus($permit_exist);
            $data["objectid"] = $permit_exist;
            $this->insetpermitdata($data, $permit_no, 1);
        } else {
            $text = $this->disguise_curl();
            $data = $this->disguise_curl($permit_no, true);
            if (is_numeric($data["objectid"])) {
                $this->insetpermitdata($data, $permit_no);
            }
        }

        if (is_numeric($data["objectid"])) {
            $data_inspection = $this->disguise_curl_futher($data["objectid"], $data["datachanges"]);

            $data_inspectionDetail = $this->disguise_curl_futherDetails($data["objectid"], $data["datachanges"]);

            $row_job_update = array();
            $row_job_update["objectid"] = $data["objectid"];
            $datamining = array();
            $datamining = explode(",", $data[0][11]);
            $bmessage = "Building Inspection  under progress";
            if (count($datamining) > 1) {

                $row_job_update['is_pp_checked'] = 1;

                $date_buildinginspection = $this->buildinginspection($data_inspection);
                if ($date_buildinginspection) {
                    $row_job_update['building_permit_completeiondate'] = date("Y-m-d", strtotime($date_buildinginspection));
                    $row_job_update['building_permit_status'] = "completed";
                    $bmessage = "Building Permit completed on " . $date_buildinginspection;
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'building');
                    $this->db->where("id", $jobid);
                    $this->db->update("jobs", $row_job_update);
                } else {
                    $row_job_update['building_permit_status'] = "none";
                    $row_job_update['is_pp_checked'] = 0;
                }
                $emessage = "Electrical Inspection  under progress";
                $date_electricalinspection = $this->electricalinspection($data_inspection);
                if ($date_electricalinspection) {
                    $row_job_update['electrical_permit_status'] = "completed";
                    $row_job_update['electrical_permit_completeiondate'] = date("Y-m-d", strtotime($date_electricalinspection));
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'electrical');
                    $emessage = "Electrical permit completed on " . $date_electricalinspection;
                    $this->db->where("id", $jobid);
                    $this->db->update("jobs", $row_job_update);
                } else {
                    $row_job_update['electrical_permit_status'] = "none";
                    $row_job_update['is_pp_checked'] = 0;
                }

                $pmessage = "Permit Job Inspection  under progress";
                $date_permitinspection = $this->permitinspection($data_inspectionDetail);
                if ($date_permitinspection) {

                    $row_job_update['building_details_tab_permit_completeiondate'] = date("Y-m-d", strtotime($date_permitinspection));
                    $row_job_update['building_detail_tab_permit_status'] = "completed";
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'Permit Job');
                    $emessage = "Electrical permit completed on " . $date_permitinspection;
                    //$bmessage="Building Permit completed on ".$date_buildinginspection;
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'Detail');
                    $this->db->where("id", $jobid);
                    $this->db->update("jobs", $row_job_update);
                } else {
                    $row_job_update['building_detail_tab_permit_status'] = "none";
                    $row_job_update['is_pp_checked'] = 0;
                }
                $permitstatus = "$bmessage ,$emessage ,$pmessage. ";
            } else {
                $row_job_update['is_pp_checked'] = 1;

                $date_buildinginspection = $this->buildinginspection($data_inspection);
                if ($date_buildinginspection) {
                    $row_job_update['building_permit_completeiondate'] = date("Y-m-d", strtotime($date_buildinginspection));
                    $row_job_update['building_permit_status'] = "completed";
                    $bmessage = "Building Permit completed on " . $date_buildinginspection;
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'building');
                    $this->db->where("id", $jobid);
                    $this->db->update("jobs", $row_job_update);
                } else {
                    $row_job_update['building_permit_status'] = "none";
                    $row_job_update['is_pp_checked'] = 0;
                }
                $emessage = "Electrical Inspection  under progress";
                $date_electricalinspection = $this->electricalinspection($data_inspection);
                if ($date_electricalinspection) {
                    $row_job_update['electrical_permit_status'] = "completed";
                    $row_job_update['electrical_permit_completeiondate'] = date("Y-m-d", strtotime($date_electricalinspection));
                    $emessage = "Electrical permit completed on" . $date_electricalinspection;
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'electrical');
                    $this->db->where("id", $jobid);
                    $this->db->update("jobs", $row_job_update);
                } else {

                    $row_job_update['electrical_permit_status'] = "none";
                }
                $pmessage = "Permit Job Inspection  under progress";
                $date_permitinspection = $this->permitinspection($data_inspectionDetail);

                if ($date_permitinspection) {

                    $row_job_update['building_details_tab_permit_completeiondate'] = date("Y-m-d", strtotime($date_permitinspection));
                    $row_job_update['building_detail_tab_permit_status'] = "completed";
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'Permit Job');
                    $emessage = "Electrical permit completed on " . $date_permitinspection;
                    //$bmessage="Building Permit completed on ".$date_buildinginspection;
                    $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'Detail');
                    $this->db->where("id", $jobid);
                    $this->db->update("jobs", $row_job_update);
                } else {
                    $row_job_update['building_detail_tab_permit_status'] = "none";
                    $row_job_update['is_pp_checked'] = 0;
                }

                $permitstatus = "$bmessage ,$emessage ,$pmessage .( " . $data[0][17] . ")";
                //$row_job_update['building_permit_status']=$data[0][17];
                //$permitstatus=$data[0][17];
            }

            $this->db->where("id", $jobid);
            $this->db->update("jobs", $row_job_update);
        } else {
            $permitstatus = "Please check your permit number. If it is correct,Please contact to Adminstrator";
        }
        $data = array();
        $data["permitstatus"] = $permitstatus;
        $this->load->view("permitapi/permitstatus", $data);
    }

    function electricalpermitstatus($permit_no, $jobid) {
        $permit_exist = $this->getpermitobject($permit_no);
        if ($permit_exist) {
            $data = $this->getexistpermitstatus($permit_exist);
            $data["objectid"] = $permit_exist;
            $this->insetpermitdata($data, $permit_no, 1);
        } else {
            $text = $this->disguise_curl();
            $data = $this->disguise_curl($permit_no, true);

            if (is_numeric($data["objectid"])) {
                $this->insetpermitdata($data, $permit_no);
            }
        }

        if (is_numeric($data["objectid"])) {
            $data_inspection = $this->disguise_curl_futher($data["objectid"], $data["datachanges"]);
            $row_job_update = array();
            $datamining = explode(",", $data[0][11]);
            if (count($datamining) > 1) {
                $row_job_update['electrical_permit_completeiondate'] = date("Y-m-d", strtotime($data[0][11]));
                $row_job_update['electrical_permit_status'] = "completed";
                $this->permitstatusmail($jobid, $permit_no, $data["objectid"], 'electrical');
                $permitstatus = "Permit  Completed on " . $data[0][11];
                $this->db->where("id", $jobid);
                $this->db->update("jobs", $row_job_update);
            } else {
                $row_job_update['electrical_permit_status'] = $data[0][17];
                $permitstatus = $data[0][17];
            }

            $this->db->where("id", $jobid);
            $this->db->update("jobs", $row_job_update);
        } else {

            $permitstatus = "Please check your permit number. If it is correct,Please contact to Adminstrator";
        }
        $data = array();
        $data["permitstatus"] = $permitstatus;
        $this->load->view("permitapi/permitstatus", $data);
    }

    function permitcron() {
        
    }

    function get_span($file) {
        $h1count = preg_match_all('/(<span .*>)(.*)(<\/span>)/', $file, $patterns);
        $res = array();
        array_push($res, $patterns[2]);
        array_push($res, count($patterns[2]));
        return $res;
    }

    function read_header($curl, $header) {
        //echo $header;
        return strlen($header);
    }
    
    function elec_building_status()
    {
        $this->load->view("permitapi/export_ispection");
    }
    
    function run_export_inspection()
    {
        $this->load->helper( 'csv' );
        $date_from = trim($this->input->get('date_from'));
        $date_to = trim($this->input->get('date_to'));
        $this->admincron($date_from,$date_to);
        $fromdate_arr=explode("/",$date_from);
        $todate_arr=explode("/",$date_to);
        $sql_from ="";
        if(isset($date_from) && $date_from!="" && $date_from!="-1" )
        {
            $sql_from = "AND date_format(job_date,'%Y%m%d') >'".$fromdate_arr[2].$fromdate_arr[0].$fromdate_arr[1]."'";
        }
        $sql_to ="";
        if(isset($date_to) && $date_to!="" && $date_to!="-1" )
        {
            $sql_to = "AND date_format(job_date,'%Y%m%d') <'".$todate_arr[2].$todate_arr[0].$todate_arr[1]."'";
        }
       
         
      $sql_inpection_status = "SELECT id,building_permit,electrical_permit,building_permit_status,electrical_permit_status  FROM jobs 
            WHERE  (building_permit_status!='completed' || building_permit_status is null || electrical_permit_status!='completed' || electrical_permit_status is null )
            AND building_permit>0 AND job_type_id=2  $sql_from $sql_to";
       //die;
         $result_inspection = $this->db->query($sql_inpection_status)->result_array();
         $records[0] = array('Job ID','Building Permit','Electrical Permit','Building Permit Status','Electrical Permit Status');
         $k=1;
         foreach($result_inspection as $row)
        {
            $records[$k] =  array($row['id'],$row['building_permit'],$row['electrical_permit'],$row['building_permit_status'],$row['electrical_permit_status']);
            $k++;
        }
         echo $myarray = array_to_csv($records,'permit_status_report.csv');
        //die;
    }
      
    function admincron($date_from="",$date_to="") {
        
        $fromdate_arr=explode("/",$date_from);
        $todate_arr=explode("/",$date_to);
        $sql_from ="";
        if(isset($date_from) && $date_from!="" && $date_from!="-1" )
        {
            $sql_from = "AND date_format(job_date,'%Y%m%d') >'".$fromdate_arr[2].$fromdate_arr[0].$fromdate_arr[1]."'";
        }
        $sql_to ="";
        if(isset($date_to) && $date_to!="" && $date_to!="-1" )
        {
            $sql_to = "AND date_format(job_date,'%Y%m%d') <'".$todate_arr[2].$todate_arr[0].$todate_arr[1]."'";
        }
            
              $sql_building_status = "SELECT id,building_permit,electrical_permit,building_permit_status,electrical_permit_status  FROM jobs 
            WHERE  (building_permit_status!='completed' || building_permit_status is null || electrical_permit_status!='completed' || electrical_permit_status is null )
            AND building_permit>0 AND job_type_id=2  $sql_from $sql_to";
            
       
        
        $row_building = $this->db->query($sql_building_status)->result_array();
        $this->disguise_curl();
        foreach ($row_building as $rowdata) {
            //$data=$this->disguise_curl($rowdata["building_permit"],true);
            $permit_exist = $this->getpermitobject($rowdata["building_permit"]);
            if ($permit_exist) {
                $data = $this->getexistpermitstatus($permit_exist);
                $data["objectid"] = $permit_exist;
                $this->insetpermitdata($data, $rowdata["building_permit"], 1);
            } else {

                $data = $this->disguise_curl($rowdata["building_permit"], true);
                $this->insetpermitdata($data, $rowdata["building_permit"]);
            }
            if (is_numeric($data["objectid"])) {
                $row_job_update = array();
                $row_job_update["objectid"] = $data["objectid"];
                $data_inspection = $this->disguise_curl_futher($data["objectid"], $data["datachanges"]);
                $datamining = explode(",", $data[0][11]);
                $message = "";
                if (count($datamining) > 1) {
                    $row_job_update['is_pp_checked'] = 1;
                    if ($rowdata["building_permit_status"] != "completed") {
                        $date_buildinginspection = $this->buildinginspection($data_inspection);
                        if ($date_buildinginspection) {
                            $row_job_update['building_permit_completeiondate'] = date("Y-m-d", strtotime($date_buildinginspection));
                            $row_job_update['building_permit_status'] = "completed";
                            $message = "Building";
                            $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'building');
                            $this->db->where("id", $rowdata["id"]);
                            $this->db->update("jobs", $row_job_update);
                        } else {
                            $row_job_update['is_pp_checked'] = 0;
                            $row_job_update['building_permit_status'] = "none";
                        }
                    }
                    if ($rowdata["electrical_permit_status"] != "completed") {
                        $date_electricalinspection = $this->electricalinspection($data_inspection);
                        if ($date_electricalinspection) {
                            $row_job_update['electrical_permit_status'] = "completed";
                            $row_job_update['electrical_permit_completeiondate'] = date("Y-m-d", strtotime($date_electricalinspection));
                            $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'electrical');
                            $this->db->where("id", $rowdata["id"]);
                            $this->db->update("jobs", $row_job_update);
                        } else {
                            $row_job_update['is_pp_checked'] = 0;
                            $row_job_update['electrical_permit_status'] = "none";
                        }
                    }
                    //here we get and update the permit job date. by sahil(28-02-2014)
                    if ($rowdata["building_detail_tab_permit_status"] != "completed") {
                        $date_permitinspection = $this->permitinspection($data_inspectionDetail);
                        if ($date_permitinspection) {

                            $row_job_update['building_details_tab_permit_completeiondate'] = date("Y-m-d", strtotime($date_permitinspection));
                            $row_job_update['building_detail_tab_permit_status'] = "completed";
                            $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'Permit Job');
                            $this->db->where("id", $rowdata["id"]);
                            $this->db->update("jobs", $row_job_update);
                        } else {
                            $row_job_update['building_detail_tab_permit_status'] = "none";
                            $row_job_update['is_pp_checked'] = 0;
                        }
                    }
                } else {


                    if ($rowdata["building_permit_status"] != "completed") {

                        $date_buildinginspection = $this->buildinginspection($data_inspection);
                        if ($date_buildinginspection) {
                            $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'building');
                            $row_job_update['building_permit_completeiondate'] = date("Y-m-d", strtotime($date_buildinginspection));
                            $row_job_update['building_permit_status'] = "completed";
                            $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'electrical');
                            $this->db->where("id", $rowdata["id"]);
                            $this->db->update("jobs", $row_job_update);
                            $message = "Building";
                        } else {
                            $row_job_update['building_permit_status'] = "none";
                        }
                    }
                    if ($rowdata["electrical_permit_status"] != "completed") {

                        $date_electricalinspection = $this->electricalinspection($data_inspection);
                        if ($date_electricalinspection) {
                            $row_job_update['electrical_permit_status'] = "completed";
                            $row_job_update['electrical_permit_completeiondate'] = date("Y-m-d", strtotime($date_electricalinspection));
                            $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'electrical');
                            $this->db->where("id", $rowdata["id"]);
                            $this->db->update("jobs", $row_job_update);
                        } else {
                            $row_job_update['electrical_permit_status'] = "none";
                            $row_job_update['is_pp_checked'] = 0;
                        }
                    }

                    //here we get and update the permit job date. by sahil(28-02-2014)
                    if ($rowdata["building_detail_tab_permit_status"] != "completed") {
                        $date_permitinspection = $this->permitinspection($data_inspectionDetail);
                        if ($date_permitinspection) {

                            $row_job_update['building_details_tab_permit_completeiondate'] = date("Y-m-d", strtotime($date_permitinspection));
                            $row_job_update['building_detail_tab_permit_status'] = "completed";
                            $this->permitstatusmail($rowdata["id"], $rowdata["building_permit"], $data["objectid"], 'Permit Job');
                            $this->db->where("id", $rowdata["id"]);
                            $this->db->update("jobs", $row_job_update);
                        } else {
                            $row_job_update['building_detail_tab_permit_status'] = "none";
                            $row_job_update['is_pp_checked'] = 0;
                        }
                    }
                    //$row_job_update['building_permit_status']=$data[0][17];
                    $permitstatus = $data[0][17];
                }
                $this->db->where("id", $rowdata["id"]);
                $this->db->update("jobs", $row_job_update);
            }
        }
    }

    function disguise_curl($permit_no = 0, $post = false) {

        $url = 'http://dppweb.honolulu.gov/DPPWeb/Default.aspx?PossePresentation=BuildingSignPermitSearch';
        $curl = curl_init();
        // Setup headers - I used the same headers from Firefox version 2.0.0.6 
        // below was split up because php.net said the line was too long. :/ 
        $header[0] = "Accept: text/xml,application/x-www-form-urlencoded,application/xhtml+xml,";
        $header[0] .= "text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5";
        $header[] = "Cache-Control: max-age=0";
        $header[] = "Connection: keep-alive";
        $header[] = "Keep-Alive: 300";
        $header[] = "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7";
        $header[] = "Accept-Language: en-us,en;q=0.5";
        $header[] = "Pragma: "; // browsers keep this blank. 
        curl_setopt($curl, CURLOPT_URL, $url);
        //  curl_setopt($curl, CURLOPT_USERAGENT, 'Googlebot/2.1 (+http://www.google.com/bot.html)'); 
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        //curl_setopt($curl, CURLOPT_REFERER, 'http://172.16.1.39/hrm/dashboard'); 
        //curl_setopt($curl, CURLOPT_REFERER, 'http://dppweb.honolulu.gov/DPPWeb/default.asp?PossePresentation=BuildingPermitSearch&PosseObjectId=47169013'); 
        //curl_setopt($curl, CURLOPT_ENCODING, 'gzip,deflate'); 
        curl_setopt($curl, CURLOPT_AUTOREFERER, 1);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_COOKIESESSION, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_HEADER, true);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_COOKIEJAR, dirname(__FILE__) . "/cookies.txt");
        curl_setopt($curl, CURLOPT_COOKIEFILE, dirname(__FILE__) . "/cookies.txt");
        curl_setopt($curl, CURLOPT_HEADER, 1);
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        if ($post) {
            // $permit_no = $row['permit_no'];
            curl_setopt($curl, CURLOPT_POST, true);
            // curl_setopt ($curl, CURLOPT_POSTFIELDS,$data);
            //curl_setopt($curl, CURLOPT_HEADERFUNCTION, 'read_header');
            curl_setopt($curl, CURLOPT_POSTFIELDS, "currentpaneid=749487&paneid=747895&functiondef=5&sortcolumns=%7B%7D&datachanges=%271d10YNC0sm6l%252Bjl1Y7bQXtjpyNIFvSPFQqeFeikjtUUlHVa7kgnlwzJtb1wticeXHQhefQU29vR2%250AvgXQg2lyQm62ISY8lO4tYd7GwVcogz6gKU%252BheHP4dklP9I4FzUSA7JdmCPBApYpM%252BkGgPRO4876R%250ApZ3txJz%252BLn4BmhCgS2cZminJTxuqmEfu8ylY%252BaDoKCOI7uSV19XKnWm0D9CF93pq1tg5FmdzrXWY%250ASNfUs%2FQdQGXRNyWUOcW4gxytfVCKCqc6PF5MZz4%253D%250A%27%2C%28%27C%27%2C%27S0%27%2C747367%2C%27%27%29%2C%28%27C%27%2C%27S0%27%2C749990%2C%27" . $permit_no . "%27%29%2C%28%27F%27%2C%27%27%2C0%2C0%29%2C%28%27F%27%2C%27%27%2C0%2C0%29%2C%28%27F%27%2C%27%27%2C0%2C0%29%2C%28%27F%27%2C%27%27%2C0%2C0%29%2C%28%27F%27%2C%27%27%2C0%2C0%29%2C%28%27F%27%2C%27%27%2C0%2C0%29%2C%28%27F%27%2C%27%27%2C0%2C0%29%2C%28%27F%27%2C%27%27%2C0%2C0%29%2C%28%27F%27%2C%27%27%2C0%2C0%29&comesfrom=posse&changesxml=");
            $html = curl_exec($curl); // execute the curl command 
            $redirect_url = curl_getinfo($curl, CURLINFO_EFFECTIVE_URL);
            $object_id = str_replace('http://dppweb.honolulu.gov/DPPWeb/Default.aspx?PossePresentation=BuildingPermit&PosseObjectId=', "", $redirect_url);
            $page_html = file_get_contents($redirect_url);
            //echo $object_id = $object_id;
            $new_html = @explode("id=datachanges", $page_html);
            $new_html_further = explode('">', $new_html[1]);
            $new_html_further1 = explode('value="', $new_html_further[0]);

            $data = $this->get_span($page_html);
            $data["objectid"] = $object_id;
            $data["datachanges"] = $new_html_further1[1];
            return $data;
       
        }
        return 0;
    }

    function disguise_curl_futher($objectid, $datachangesfurther) {

        $url = 'http://dppweb.honolulu.gov/DPPWeb/Default.aspx?PossePresentation=BuildingPermit&PosseObjectId=' . $objectid;
        $curl = curl_init();
        // Setup headers - I used the same headers from Firefox version 2.0.0.6
        // below was split up because php.net said the line was too long. :/
        $header[0] = "Accept: text/xml,application/x-www-form-urlencoded,application/xhtml+xml,";
        $header[0] .= "text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5";
        $header[] = "Cache-Control: max-age=0";
        $header[] = "Connection: keep-alive";
        $header[] = "Keep-Alive: 300";
        $header[] = "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7";
        $header[] = "Accept-Language: en-us,en;q=0.5";
        $header[] = "Pragma: "; // browsers keep this blank.
        curl_setopt($curl, CURLOPT_URL, $url);
        //  curl_setopt($curl, CURLOPT_USERAGENT, 'Googlebot/2.1 (+http://www.google.com/bot.html)');
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        //curl_setopt($curl, CURLOPT_REFERER, 'http://172.16.1.39/hrm/dashboard');
        //curl_setopt($curl, CURLOPT_REFERER, 'http://dppweb.honolulu.gov/DPPWeb/default.asp?PossePresentation=BuildingPermitSearch&PosseObjectId=47169013');
        //curl_setopt($curl, CURLOPT_ENCODING, 'gzip,deflate');
        curl_setopt($curl, CURLOPT_AUTOREFERER, 1);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_COOKIESESSION, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_HEADER, true);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_COOKIEJAR, dirname(__FILE__) . "/cookies.txt");
        curl_setopt($curl, CURLOPT_COOKIEFILE, dirname(__FILE__) . "/cookies.txt");
        curl_setopt($curl, CURLOPT_HEADER, 1);
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, "currentpaneid=713846&paneid=713860&functiondef=3&sortcolumns=%7B%7D&datachanges=" . urlencode($datachangesfurther) . "&comesfrom=posse&changesxml=");
        $html = curl_exec($curl); // execute the curl command
        $data = $this->get_span($html);
        return $data;
    }

    function getexistpermitstatus($objectid) {
        $url = "http://dppweb.honolulu.gov/DPPWeb/default.asp?PossePresentation=BuildingPermit&PosseObjectId=$objectid";
        $page_html = file_get_contents($url);
        $data = get_span($page_html);
        return $data;
    }

    function getpermitobject($permit_no) {
        $sql = "SELECT id,objectid from permit_details WHERE permit_no=$permit_no";
        $rs = $this->db->query($sql)->row_array();
        if (isset($rs["id"]) && @$rs["objectid"] > 0) {
            return $rs["objectid"];
        }
        return 0;
    }

    function insetpermitdata($data, $permit_no, $update_id = 0) {
        $row_permit_detail = array();
        $row_permit_details["permit_no"] = $permit_no;
        $row_permit_detail["objectid"] = $data["objectid"];
        $row_permit_detail["application_number"] = $data[0][3];
        $row_permit_detail["job_number"] = $data[0][5];
        $row_permit_detail["description"] = $data[0][7];
        $row_permit_detail["created_date"] = $data[0][9];
        $row_permit_detail["job_completed_date"] = $data[0][11];
        $row_permit_detail["issued_date"] = $data[0][13];
        $row_permit_detail["date_construction_completed"] = $data[0][15];
        $row_permit_detail["status"] = $data[0][17];
        if ($update_id) {
            $this->db->where("id", $update_id);
            $this->db->update("permit_details", $row_permit_detail);
        } else {
            $this->db->insert("permit_details", $row_permit_detail);
        }
    }

    function updatepermitdata($data) {
        // job also update
    }

    function savepermitdata($job_id, $building, $electrical) {
        $pid = $this->getparentjobid($job_id);
        $row = array();
        $row_electrical_permit = $this->db->query("SELECT electrical_permit,building_permit from jobs WHERE id=$pid")->row_array();
        if ($row_electrical_permit["building_permit"] == $electrical && $row_electrical_permit["electrical_permit"] == $electrical ) {
            $json = array();
            $json['success'] = true;
            echo json_encode($json);
            return;
        }
        $row["electrical_permit"] = $electrical;
        $row["building_permit"] = $building;
        $row["building_permit_completeiondate"] = NULL;
        $row["building_permit_status"] = NULL;
        $row["electrical_permit_status"] = NULL;
        $row["electrical_permit_completeiondate"] = NULL;
        $row['is_pp_checked'] = 0;
       /* $this->load->library("activitylog");
        $sql = "SELECT electrical_permit,building_permit,building_permit_completeiondate,building_permit_status,electrical_permit_status,electrical_permit_completeiondate,is_pp_checked,id FROM jobs WHERE job_pid = '" . $job_id . "'";
        $rs = $this->db->query($sql)->result_array();
        foreach ($rs as $data) {
            $diff = $this->activitylog->matchdiffInUpdate($data, $row);
            $this->activitylog->createlog("Update", "jobs", $data['id'], $this->session->userdata("user_id"), '', $diff);
        }*/
        $this->db->where("job_pid", $pid);
        $this->db->update("jobs", $row);
        $json = array();
        $json['success'] = true;
        echo json_encode($json);
    }

    function getparentjobid($job_id) {
        $resultcnt = $this->db->query("SELECT job_pid FROM jobs  where id = $job_id")->result_array();
        $pid = $resultcnt[0]['job_pid'];
        if (!$pid) {
            $pid = $job_id;
        }
        return $pid;
    }

    function permitstatusmail($job_id, $permitno, $objectid, $type = "") {

        // return;
        if (trim($type) == "")
            return;
        $url = "http://dppweb.honolulu.gov/DPPWeb/default.asp?PossePresentation=BuildingPermit&PosseObjectId=$objectid";
        $jobid = $job_id;
        $pid = $this->getparentjobid($job_id);
        $ismailsent = $this->globalnotifcation();
        if (!$ismailsent) {
            return;
        }
        $sql = "SELECT user_id,customer_id,job_date,building_permit_status ,project_designer_id,   electrical_permit_status from jobs where id=$job_id";
        $row = $this->db->query($sql)->row_array();
        if ($row["electrical_permit_status"] == "completed" && $type == "electrical") {
            return;
        }
        if ($row["building_permit_status"] == "completed" && $type == "building") {
            return;
        }
        $is_sale_user = false;
        if ($row["electrical_permit_status"] == "completed" && $type == "building") {
            $is_sale_user = true;
            $this->updatepermitclosed($job_id);
        }
        if ($row["building_permit_status"] == "completed" && $type == "electrical") {
            $is_sale_user = true;
            $this->updatepermitclosed($job_id);
        }
        $sqlc = "SELECT *  from customers  where id=" . $row["customer_id"];
        $rowc = $this->db->query($sqlc)->row_array();
        $isuserpre = $this->issendnotification($row['user_id']);

        $j = $this->getUserLoad($row['user_id']);
		
        $this->load->library('email');
        $config['mailtype'] = 'html';
        $this->email->initialize($config);
        $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
        $row_users = $this->db->query("SELECT users.email,users.first_name,users.last_name from users
                  LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type='admin'")->result_array();
        foreach ($row_users as $value) {
            $email_list[] = $value['email'];
        }

        $this->email->to($email_list);

        if ($type == "electrical") {
            $subject = "Electrical inspection closed for " . ucfirst($rowc["first_name"]) . " " . ucfirst($rowc["last_name"]) . ", $job_id";
        } else if ($type == "building") {
            $subject = "Building inspection closed for " . ucfirst($rowc["first_name"]) . " " . ucfirst($rowc["last_name"]) . ", $job_id";
        }
        if ($type == "electrical") {
            $msgtxt = 'Congratulations, the electrical permit for is now closed!. For  Detail , please click below';
        } else if ($type == "building") {
            $msgtxt = 'Congratulations, the building permit for is now closed!. For  Detail , please click below';
        }


        $this->email->subject($subject);

        $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="' . base_url() . 'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p>' . @$msgtxt . '<br/>
<a href="' . $url . '" target="_blank">Permit Status </a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
        @$this->email->message($message);
        @$this->email->send();
        if ($is_sale_user) {

            if ($isuserpre)
                $email_list[] = $j[0]->email;
			 
			 if(isset($row['project_designer_id']) && $row['project_designer_id']>0){
				 $engg = $this->getUserLoad($row['project_designer_id']);
				 $email_list[] = $engg[0]->email;
			 }
            $newsubject = "Permit closed for " . ucfirst($rowc["first_name"]) . " " . ucfirst($rowc["last_name"]) . ", $job_id";
            $this->sendpermitclosed($email_list, $newsubject, $url);
        }
    }

    function sendpermitclosed($emaillist, $subject, $url) {
        $this->load->library('email');
        $config['mailtype'] = 'html';
        $this->email->initialize($config);
        $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
        $this->email->to($emaillist);
        $this->email->bcc('permits@alternateenergyhawaii.com');
        $msgtxt = "Your Permit application  has been completed. For Details, please click below";
        $this->email->subject($subject);
        $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="' . base_url() . 'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p>' . $msgtxt . '<br/>
<a href="' . $url . '" target="_blank">Permit Status </a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
        @$this->email->message($message);
        @$this->email->send();
    }

    function issendnotification($user_id) {
        $sql = "SELECT user_id FROM  notification_setting WHERE user_id = $user_id";

        $rowe = array();
        $rowe = $this->db->query($sql)->result_array();
        if ((count($rowe) >= 1) && $rowe[0]['user_id']) {
            return true;
        } else {
            $row['user_id'] = $user_id;
            return false;
        }
    }

    function globalnotifcation() {
        $sql = "SELECT notification from notification_setting WHERE id=1";
        $nresult = $this->db->query($sql)->result_array();
        if (!$nresult[0]['notification'])
            return 'false';
        return true;
    }

    function getUserLoad($id) {
        if (!$id)
            return 0;
        $j = $this->db->query("SELECT * FROM users WHERE id=$id")->result();

        return $j;
    }

    function buildinginspection($data) {
        $tempdata = array();
        $tempdata = $data[0];
        foreach ($data[0] as $key => $value) {

            if ($value == 'Building Code Inspection') {
                if ($tempdata[$key + 2] == 'Complete') {
                    return $tempdata[$key + 1];
                }
            }
        }
        return 0;
    }

    function electricalinspection($data) {
        $tempdata = array();
        $tempdata = $data[0];
        foreach ($data[0] as $key => $value) {
            if ($value == 'Electrical Code Inspection') {
                if ($tempdata[$key + 2] == 'Complete') {
                    return $tempdata[$key + 1];
                }
            }
        }
        return 0;
    }

    function permitinspection($data) {
        $tempdata = array();
        $tempdata = $data[0];

        foreach ($data[0] as $key => $value) {

            if ($value == 'Job Completed Date:') {

                return $tempdata[$key + 1];
            }
        }
        return 0;
    }

    function updatepermitclosed($job_id) {
        $pid = $this->getparentjobid($job_id);
        $row['permitnotfication'] = date("Y-m-d");
        $this->db->where('job_pid', $pid);
        $this->db->update('jobs', $row);
    }

    function buildingpermitstatus1() {
        $previousIdObjectID = $this->updatePreviousPermitDate();

        if (is_array($previousIdObjectID) && !empty($previousIdObjectID)) {

            foreach ($previousIdObjectID as $value) {

                $text = $this->disguise_curl();
                $data = $this->disguise_curl($value["building_permit"], true);

                if (is_numeric($value["objectid"]) && is_numeric($value["building_permit"])) {

                    $jobid = $value["id"];
                    $data_inspection = $this->disguise_curl_futherDetails($value["building_permit"], $data["datachanges"]);
                    // here we check the date is empy or not if it is then update it to crpon_active_log table.By sahil(28-02-2014)
                    if ($data_inspection[0][16] != "" && date("Y-m-d", strtotime($data_inspection[0][16])) != "1970-01-01") {
                        $row_job_update['building_details_tab_permit_completeiondate'] = date("Y-m-d", strtotime($data_inspection[0][16]));
                        $row_job_update['building_detail_tab_permit_status'] = "completed";
                        $this->db->where("id", $jobid);
                        $this->db->update("jobs", $row_job_update);
                    } else if ($data_inspection[0][16] == "" || date("Y-m-d", strtotime($data_inspection[0][16])) == "1970-01-01") {
                        //objectid,permit_number,id,date
                            $data = array(
                                'jobs_id' => $value["id"],
                                'jobs_building_permit' => $value["building_permit"],
                                'jobs_objectid' => $value["objectid"],
                                'permit_date' => date("Y-m-d", strtotime($data_inspection[0][16]))
                            );
                            $this->db->insert('cron_active_log', $data);
                        
                  }
                } else {
                    $permitstatus = "Please check your permit number. If it is correct,Please contact to Adminstrator";
                }
            }
        }
    }

    function updatePreviousPermitDate() {
        //$this->db->limit(10);
        //$this->db->select('id, objectid, building_permit,building_details_tab_permit_completeiondate ');
        //$this->db->where(' building_details_tab_permit_completeiondate< "2000-01-01" AND  building_detail_tab_permit_status!="completed"  AND  building_permit_status = "completed" and electrical_permit_status = "completed" and objectid != "" and objectid>0 and building_permit != "" and building_permit>0');
        $query = $this->db->query('SELECT `id`, `objectid`, `building_permit`, `building_details_tab_permit_completeiondate` FROM (`jobs`) WHERE building_details_tab_permit_completeiondate<"2000-01-01" AND building_detail_tab_permit_status!="completed" AND building_permit_status = "completed" AND electrical_permit_status = "completed" AND objectid != "" AND objectid>0 AND building_permit != "" AND building_permit>0')->result_array();
        //print_r($query);
        return $query;
    }

    function disguise_curl_futherDetails($objectid, $datachangesfurther) {

        $url = 'http://dppweb.honolulu.gov/DPPWeb/Default.aspx?PossePresentation=BuildingPermit&PosseObjectId=' . $objectid;
        $curl = curl_init();
        // Setup headers - I used the same headers from Firefox version 2.0.0.6
        // below was split up because php.net said the line was too long. :/
        $header[0] = "Accept: text/xml,application/x-www-form-urlencoded,application/xhtml+xml,";
        $header[0] .= "text/html;q=0.9,text/plain;q=0.8,image/png,*/*;q=0.5";
        $header[] = "Cache-Control: max-age=0";
        $header[] = "Connection: keep-alive";
        $header[] = "Keep-Alive: 300";
        $header[] = "Accept-Charset: ISO-8859-1,utf-8;q=0.7,*;q=0.7";
        $header[] = "Accept-Language: en-us,en;q=0.5";
        $header[] = "Pragma: "; // browsers keep this blank.
        curl_setopt($curl, CURLOPT_URL, $url);
        //  curl_setopt($curl, CURLOPT_USERAGENT, 'Googlebot/2.1 (+http://www.google.com/bot.html)');
        curl_setopt($curl, CURLOPT_HTTPHEADER, $header);
        //curl_setopt($curl, CURLOPT_REFERER, 'http://172.16.1.39/hrm/dashboard');
        //curl_setopt($curl, CURLOPT_REFERER, 'http://dppweb.honolulu.gov/DPPWeb/default.asp?PossePresentation=BuildingPermitSearch&PosseObjectId=47169013');
        //curl_setopt($curl, CURLOPT_ENCODING, 'gzip,deflate');
        curl_setopt($curl, CURLOPT_AUTOREFERER, 1);
        curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($curl, CURLOPT_COOKIESESSION, false);
        curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, false);
        curl_setopt($curl, CURLOPT_HEADER, true);
        curl_setopt($curl, CURLOPT_FOLLOWLOCATION, true);
        curl_setopt($curl, CURLOPT_COOKIEJAR, dirname(__FILE__) . "/cookies.txt");
        curl_setopt($curl, CURLOPT_COOKIEFILE, dirname(__FILE__) . "/cookies.txt");
        curl_setopt($curl, CURLOPT_HEADER, 1);
        curl_setopt($curl, CURLOPT_MAXREDIRS, 10);
        curl_setopt($curl, CURLOPT_POST, true);
        curl_setopt($curl, CURLOPT_POSTFIELDS, "currentpaneid=713860&paneid=713846&functiondef=3&sortcolumns=%7B%7D&datachanges=" . urlencode($datachangesfurther) . "&comesfrom=posse&changesxml=");
        $html = curl_exec($curl); // execute the curl command
        $data = $this->get_span($html);
        return $data;
    }

}

?>
