<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1" />
        <title>Alternate Energy</title>
	<style type="text/css">
	    body{font-family:"Neo Sans", Arial, Helvetica, sans-serif; color:#404041; font-size:100%;}

	    *{margin:0; padding:0;}
	    .fl{float:left;}
	    .fr{float:right;}
	    .cl{clear:both;}
	    img{border:none;}
	    li{list-style:none;}
	    strong{font-weight:bold;}

	    /* FIXES */
	    .clearfix:after, .paginationBar:after {content: "."; display: block; height: 0px; clear: both; visibility: hidden;}
	    .clearfix, .paginationBar {display: inline-block;}
	    /* Hides from IE-mac \*/
	    * html .clearfix, * html .paginationBar {height: 1%;}
	    .clearfix{display: block;}
	    /* End hide from IE-mac */

	    .wrap{width:980px; padding:0; margin:16px auto;padding-left:10px;}

	    .headerPan{padding-bottom:1px; margin-bottom:11px; border-bottom:1px solid #71b644; color:#505051; position:relative;}

	    h1{font-style:italic; font-weight:lighter; font-size:38px; margin:44px 0 15px 0; color:#414142; padding-bottom:8px; position:absolute; font-family:neo sans light;}
	    .datePan{font:16px neo sans; white-space:0.01em; margin-bottom:43px; color:#414142;}
	    .datePan strong{font-weight:bold;}

	    h5{font-style:italic; font-weight:lighter; font-size:30px; margin:50px 0 80px 0; color:#414142; padding-bottom:8px; font-family:neo sans light;}

	    h2, h4{font-size:21.5px; font-style:normal; font-family:neo sans; font-weight:bold; margin:0 0 4px 0; letter-spacing:normal; padding-bottom:5px; color:#414142; border-bottom:1px solid #848485;}

	    /*
	    h4{font-size:19px; font-family:neo sans; font-weight:bold; margin:0 0 5px 0; padding-bottom:5px; color:#414142; border-bottom:1px solid #848485;}
	    */


	    p, p.secondp{font-size:17px; font-weight:normal; padding:3px 0; line-height: 135%; color:#414142; font-family:neo sans light;}

	    /*p.secondp{font-size:17px; font-weight:400; padding:3px 0; line-height: 150%; color:#414142; font-family:neo sans light;}*/

	    .notes{font-size:13px; font-weight:lighter; font-family:neo sans light; padding:10px 0; margin-top:10px; line-height:150%; color:#6d6e71; letter-spacing:normal; border-top:1px solid #404041;}
	    .notesd{font-size:14px; font-weight:lighter; font-family:neo sans light; padding:10px 0; margin-top:15px; line-height:150%; color:#6d6e71; letter-spacing:normal; border-top:1px solid #404041;}


	    ul li{font-size:16px; font-weight:normal;}
	    ul li strong{font-weight:bold;}

	    h3{font-size:18px; font-family:neo sans; font-weight:bold; margin:0 0 5px 0; padding-bottom:5px; color:#414142; border-bottom:1px solid #848485;}
	    .catlt{font-size:15px; font-weight:normal; padding:10px 0 20px 0; line-height:150%; color:#414142;}
	    .footeraddress{font-size:11px; line-height:150%; font-weight:normal; border-left:1px solid #71b644; padding:0 10px; margin:0 10px;}

	    .taxbenefits{border-collapse:collapse; width:100%;}
	    /*.tdData{border:none; font-size:15px; font-weight:lighter; padding:3px; color:#414142;}*/
	    .tdData{font-size:17px; font-weight:normal; padding:3px; color:#414142; font-family:neo sans light;}
	    .dataLft, .dataRgt{color:#414142;display:inline-block;font-size:20px; font-style:normal; font-family:neo sans light; font-weight:normal;}
	    .dataRgt{float:right}
	    .txtright{text-align:right;}
	    td strong{color:#000000;}

	    .graphtable{border-collapse:collapse; width:96%; margin:0 auto;}

	    .graphtable td {padding:3px 0 3px 15px; color:#414142; font-weight:lighter; font-size:19px; font-family:neo sans light;}
	    .graphtable th{border-bottom:1px solid #000000; font-weight:lighter; font-size:14px; text-align:left; padding:3px 0 3px 15px; font-family:neo sans; color:#414142;}
	    .declaraton{font-size:20px; font-weight:bold; font-family:neo sans; padding-bottom:5px; letter-spacing:normal; color:#414142;}
	    .declaratontext{font-size:20px; font-weight:normal; font-family:neo sans; letter-spacing:normal; color:#414142;}

	    ol.leftnumbers{float:left;}
	    ol.leftnumbers li{list-style:none; text-align:right; margin:20px 0 0 0; font-size:0.7em;}

	    .chatdiagram{border-collapse:collapse;}

	    ol.graphdata li, ol.graphmonth li{list-style:none; display:inline-block; padding:1px; margin:0 6px; width:15px; font-size:0.8em; text-align:center;}
	    ol.graphdata li{background-color:#6fb446; font-size:0; color:transparent; vertical-align:bottom;}

	    .module{padding-top:10px; font-family:neo sans; font-weight:lighter;}
	    .module strong{font-weight:bold;}

	    .top15{padding-top:15px;}

	    .graphData{background-color: #6FB446; width: 16px; margin: 0 auto;}
	    .monthD{width:15px; text-align:center; font-size:11px;}
	    .listN{font-size:13px; text-align:right; height:25px; vertical-align:bottom;}

	    .salesmandtl{font-size:11px; line-height:150%; font-weight:normal; padding:0 5px; margin:0 5px;}

	    .greenbox{background-color:#71B644; padding:20px; color:#ffffff; width:250px; margin-top:30px; font-size:17px; font-weight:normal; line-height:150%; font-family:neo sans light;}

	    .rightalign{text-align:right;}

	    table.dataTable{border-collapse:collapse; width:100%;}
	    table.dataTable td{padding:5px; font-size:16px; font-weight:normal; color:#414142; font-family:neo sans light;}
	    table.dataTable tr.altBg td{background-color:#f5f5f5;}

	    table.threecolumn{border-collapse:collapse; width:100%;}
	    table.threecolumn h4{border-bottom:none; padding-bottom:0px !important;}

	    table.threecolumn p{padding-bottom:25px !important;}

	    table.dataTable strong, p strong{font-size:16px; font-family:neo sans; font-weight:bold; color:#414142;}

	    .break { page-break-before: always; }

	    .modCompImg img{vertical-align:bottom}
	    table.newTable th{text-align:left;padding:5px; font-size:17px;font-weight:bold!important;background:#E7E7E8!important;color:#414142;font-family:neo sans light;}
	    table.dataTable tr.altBgEven td{background-color:#fafafb}

	    .main-headhh{text-align:center;border-bottom: none;}
	    .main-headhh h3{border-bottom: none;}
	    .feather img{
		width: 41px;
		float: left;
		padding-right: 15px;
	    }
	    .feather h5{
		display: inline;
		vertical-align: top;
		font-size: 17px;
		font-style: normal;
		font-family: neo sans;

	    }
	    .margin_none, .feather p{margin:0;}
	    .feather{padding:15px 0;clear:both;}
	    .testla-hding img {
		width: 91px;
		float: left;
		padding-right: 15px;
	    }
	    .rgt-img {
		width: 330px;
		float:right;
	    }

	    .rgt-imgs{width: 460px;
		      float: right;}

	    .rgt-img img {
		width: 97%;
	    }
	    .greenbox_new{
		background-color: #71B644;
		width: 330px;
		margin-top: 10px !important;
		margin: 0 auto;}

	    .testla-hding {
		padding-bottom: 30px;
	    }

	    hr.dash {
		border-top: 2px dashed #000;
		border-width: 1px;
	    }
	    .declaraton_new_l{
		text-align:center;
		margin-bottom:50px;
	    }

	    .declaraton_new_l img{width:25px;}

	    .declaraton_new_one img{width:25px;}

	    .yeardiv{
		width: 51%;
		float: left;
		text-align: right;
		margin-right: 68px;
	    }

	    .yerdiv_color{
		float: right;
		width: 76%;
		padding:0px 0px 30px;

	    }

	    .graphData_onetow{
		width: 55px;
		margin:0 auto;
	    }

	    .graphData_onetthree{
		width: 55px;
		margin:0 auto;
	    }
	    .graphData_one {
		background: #ccc;
		position: relative;
		width: 55px;
		margin: 0 auto;
	    }
	    .graphData_onethree{
		background:#fff;
		width:80px;

	    }

	    .graphData_onethree p{
		color:#71B644;
		font-weight: bold;
		font-size:14px;
		text-align:center;
	    }


	    .graphData_onetow{
		background: #6FB446;
		position: relative;
		bottom: 0px;}

	    .graphData_onetthree{
		background: #00aeef;
		position: relative;
		bottom: 0px;
	    }
	    .graphData_one_o{
		width: 16px;
		margin:0 auto;
	    }
	    .graphData_onetow_o{
		width: 16px;
		margin:0 auto;
	    }

	    .graphData_onetthree_o{
		width: 16px;
		margin:0 auto;
	    }

	    .graphData_onetfour_o{
		width: 16px;
		margin:0 auto;
	    }

	    .graphData_onetfive_o{
		width: 16px;
		margin:0 auto;
	    }

	    .graphData_one_o {
		background: #e5161e;
		position: relative;
		width: 16px;
		margin: 0 auto;
	    }


	    .graphData_onetow_o{
		background: #007047;
		position: relative;
		bottom: 0px;
	    }

	    .graphData_onetthree_o{
		background: #2eacbf;
		position: relative;
		bottom: 0px;
	    }
	    .graphData_onefour_o{
		background: #f19317;
		position: relative;
		bottom: 0px;
	    }
	    .graphData_onetfive_o{
		background: #00a755;
		position: relative;
		bottom: 0px;
	    }

	    .listN{border-right:1px solid #000;padding-right:5px}	
	    .monthD_new{width:50px; text-align:center; font-size:11px;}
	    .gph-divs{float:left; margin:5px;}
	    .td_center{margin: 0 auto;
		       width: 52px;
	    }
	    .yrdiv_color{
		width: 93%;
		margin: 0 auto;
		padding-top: 15px;
		padding-bottom:30px;
		text-align:center;
	    }
	    .graphData_bb_im{
		background: #fff;
		position: relative;
		bottom: 0px;
		width: 16px;
		margin:0 auto;
	    }
	    .taxbenefits_new span{
		font-size:14px;
	    }

	    .td_noborder .listN{
		border-right:none;
	    }

	    .monthD_newjul{border-right:1px solid #000; padding: 5px 0;}

	    /*---------------Amit-------------------------*/
	    .threecolumn_nfont p{font-size:19px;font-family: neo sans light; color:#000;line-height: 162% }
	    .threecolumn_nfont h4{font-size:22px;}
	    .threecolumn_nfont h5{font-size:32px; border-bottom:none;}
	    .graphtable_one tr td{font-size:14px;font-family: neo sans;}
	    .graphtable_one th{padding: 3px 0 3px 3px; vertical-align:top;}
	    .graphtablejul th{font-size:18px;font-family: neo sans light;}
	    .graphtablejul tr td{font-family: neo sans light;}
	    .taxbenefitsjul tr td{font-size: 20px; font-family: neo sans light;}
	    .module li{font-size:18px; margin-bottom:5px !important;}
	    .aTablejul tr td strong{font-size:18px;}
	    .blebcc tr:nth-child(even) td{background-color: #e7e5e4 !important;}
	    .oness tr td{background-color: #e7e5e4 !important;}
	    .graphtable_oneju th{text-align:center; font-size: 13px; text-align: center;}
	    .graphtable_oneju tr td{text-align: center;font-size: 13px}
	    /*---------------Amit-------------------------*/



        </style>
    </head>

    <body>
	<?php
	$specialdiscount = 0;

	if ($proposal['aei_specials'] == 1) {
	    $specialdiscount = 1000;
	} else if ($proposal['aei_specials'] == 2) {
	    $specialdiscount = 2000;
	} else if ($proposal['aei_specials'] == 3) {
	    $specialdiscount = 1500;
	} else if ($proposal['aei_specials'] == 21) {
	    $specialdiscount = 750;
	} else if ($proposal['aei_specials'] == 22 || $proposal['aei_specials'] == 23) {
	    $specialdiscount = 500;
	} else if ($proposal['aei_specials'] == 31) {
	    $specialdiscount = 500;
	} else if ($proposal['aei_specials'] == 59) {
	    $specialdiscount = 500;
	} else if ($proposal['aei_specials'] > 71) {
	    $special_dis_aei = (int) $proposal['aei_specials'];
	    $specialdiscount = $aei_special_array[$special_dis_aei]["discount_amount"];
	}

	if (@$proposal['deal_type'] == 2) {
	    $proposal['price'] = $proposal['cpfdeal_listprice'];
	}
	//$price_net=$proposal['price'];
	$discount_special = 0;
	if ($proposal['aei_specials'] == 6) {
	    $discount_special = $proposal['lg_listprice_orignal'] - $proposal['price'];
	    // $proposal['price']=$proposal['lg_listprice_orignal'];
	} else if ($proposal['aei_specials'] == 7) {
	    $discount_special = 0;
	    $specialdiscount = 500;
	    // $proposal['price']=$proposal['mitsubishi_listprice_orignal'];
	} else if ($proposal['aei_specials'] == 9 || $proposal['aei_specials'] == 13) {
	    $discount_special = 0;
	    $specialdiscount = 500;
	    // $proposal['price']=$proposal['mitsubishi_listprice_orignal'];
	} else if ($proposal['aei_specials'] == 11) {
	    $discount_special = 0;
	    $specialdiscount = $proposal['price_old_value'] - $proposal['price'];
	    // $proposal['price']=$proposal['mitsubishi_listprice_orignal'];
	}

	$price_net = $proposal['price'];

	$proposal['price'] = $proposal['price'] - $proposal['acharge'] + $proposal['discount'] + $specialdiscount;
	if ($proposal['id'] == 15591) {
	    $proposal['price'] = 29143.5;
	    $price_net = 30693.5;
	}
	?>
	<?php
	$is_married_set = $proposal['is_married'];
	$otherfirstname = trim(@$proposal['dpp_ot_firstname']);
	$otherlastname = trim(@$proposal['dpp_ot_lastname']);
	$cust_name = ucfirst($proposal['dpp_firstname']) . " " . ucfirst($proposal['dpp_lastname']);
	if ($is_married_set > 0 && isset($otherfirstname) && isset($otherlastname) && $otherfirstname != "" && $otherlastname != "") {
	    if (@$proposal['is_married'] == 1) {
		$cust_name = ucfirst($proposal['dpp_firstname']) . " and " . ucfirst($proposal['dpp_ot_firstname']);
	    } else if (@$proposal['is_married'] == 2) {
		$cust_name = ucfirst($proposal['dpp_firstname']) . " and " . ucfirst($proposal['dpp_ot_firstname']) . " " . ucfirst($proposal['dpp_lastname']);
	    } else if (@$proposal['is_married'] == 3) {
		$cust_name = ucfirst($proposal['dpp_firstname']) . " " . ucfirst($proposal['dpp_lastname']) . " and " . ucfirst($proposal['dpp_ot_firstname']) . " " . ucfirst($proposal['dpp_ot_lastname']);
	    }
	} else {
	    $cust_name = ucfirst($proposal['dpp_firstname']) . " " . ucfirst($proposal['dpp_lastname']);
	}

	if ($proposal['property_type'] == 1) {
	    $property_type_name = 'Single Family Home';
	} elseif ($proposal['property_type'] == 2) {
	    $property_type_name = 'Multi Family Home';
	} elseif ($proposal['property_type'] == 3) {
	    $property_type_name = 'Apt/condo/Townhome';
	} elseif ($proposal['property_type'] == 4) {
	    $property_type_name = 'Farm/Ag';
	} else {
	    $property_type_name = '';
	}

	if ($proposal['deal_type'] == 1) {
	    $deal_type = 'Alternate Energy';
	} elseif ($proposal['deal_type'] == 2) {
	    $deal_type = 'Sunrun PPA';
	} elseif ($proposal['deal_type'] == 5) {
	    $deal_type = 'Alternate Energy H.E.S.S';
	} elseif ($proposal['deal_type'] == 9) {
	    $deal_type = 'DER Proposal';
	} else {
	    $deal_type = '';
	}
	?>
        <div class="wrap">
            <div class="clearfix cl">
                <div class="fl" style="padding-top:20px;">
		    <?
		    if (@$sales_user['profile_photo'] && trim($sales_user['profile_photo']) != "") {
			$img_path = thumbnail($sales_user['profile_photo'], 67, 55);
			// if(@file_exists($img_path)){
			?>

    		    <img src="<?= $img_path; ?>" class="fl" style="width:67px; margin-top:7px;" />
		    <? } else { ?>
    		    <img src="<?= base_url() ?>assets/images/missing-photo.jpg" class="fl" style="width:67px; margin-top:7px;" />
		    <? } ?>
                    <div class="salesmandtl fl" style="font-size:14px; margin-top:2px">
                        <strong>Prepared By:</strong> <?= ucfirst(@$sales_user['first_name']) ?> <?= ucfirst(@$sales_user['last_name']); ?><br/>
                        <strong>Phone:</strong> <?= @$sales_user['phone']; ?><br/>
                        <strong>Email:</strong> <?= @$sales_user['email']; ?>
                    </div>
                </div>
                <img src="<?= base_url() ?>assets/pdfimages/logo.png" class="fr" />
            </div>

            <div class="headerPan clearfix" style="margin-top:350px;">
                <h1 class="fl" ><?= round($proposal['system_size'], 2) ?>kW Residential Photovoltaic + H.E.S.S</h1>
                <div style="height:98px;"></div>
            </div>
            <div class="clearfix">
                <div class="datePan"><strong><?= date("F j, Y", strtotime($proposal['created'])); ?> / Quote No. <?= $proposal['id'] ?></strong> / <?= $cust_name; ?>, <?= $proposal['address'] ?>, <?= $proposal['city'] ?>, Hawaii</div>

            </div>
        </div>
	<?
	$startmo = 0;
	$solorsum = 0;
	$pvsumenergy = 0;
	$pvenergyval = 0;
	$first_month_cal = false;
	$first_month_sav = 234;
	$pvenergy_g = array();
	$sun_hours_g = array();
	foreach ($proposal_month as $pvenergy) {
	    if ($pvenergy['month'] == 'Year')
		continue;
	    if (!$first_month_cal) {
		$first_month_sav = ($proposal['ceu'] - $pvenergy['acenergy']) * $proposal["electriccost"];
	    }
	    $solorsum += $pvenergy['solar'];
	    $pvsumenergy +=$pvenergy['acenergy'];
	    $pvenergyval +=$pvenergy['costsaved'];
	    $pvenergy_g[] = $pvenergy['acenergy'];
	    $sun_hours_g[$pvenergy['acenergy']] = $pvenergy['solar'];
	}
	$k = $proposal['nos'];
	$sumtax = 0;
	for ($i = 1; $i <= $k; $i++) {
	    $state_tax = ($proposal['price'] / $k) * .35;
	    if ($state_tax > 5000) {
		$state_tax = 5000;
	    }
	    $sumtax+= ($state_tax) + (($proposal['price'] / $k) * .3);
	}
	$paybackyears = round((@$price_net - $sumtax) / @$pvenergyval, 2);
	$max_pvenergy_g = max(@$pvenergy_g);
	$max_sun_hours = $sun_hours_g[@$max_pvenergy_g];
	$divdedby = 100;
	$per = 1;
	if ($max_pvenergy_g > 700 && $max_pvenergy_g <= 1000) {
	    $divdedby = 150;
	    $per = .66;
	} else if ($max_pvenergy_g > 1000 && $max_pvenergy_g < 2000) {
	    $divdedby = 200;
	    $per = .5;
	} else if ($max_pvenergy_g > 2000) {
	    $divdedby = 300;
	    $per = .33;
	}
	$grpah_m = ceil($max_pvenergy_g / $divdedby);
	$supler = number_format(($pvsumenergy * 5.3 / 1000) * 2.204622622, 2);
	$carbon = number_format(($pvsumenergy * 1.6 / 1000) * 2.204622622, 2);
	$nitrogen = number_format(($pvsumenergy * 2.8 / 1000) * 2.204622622, 2);
	?>

        <div class="wrap break">
            <div class="headerPan clearfix">
                <h1 class="fl" style="color:#ffffff;">Residential Photovoltaic System</h1>
                <img src="<?= base_url() ?>assets/pdfimages/logo.png" class="fr" />
            </div>
            <div class="clearfix">
                <div class="datePan"><strong><?= date("F j, Y", strtotime($proposal['created'])); ?> / Quote No. <?= $proposal['id'] ?></strong> / PV + H.E.S.S. Proposal Page 2</div>

            </div>

            <h5>Introduction</h5>
            <table class="threecolumn threecolumn_nfont">
                <tr>
                    <td width="34%" valign="top">
                        <h4>Congratulations</h4>
                        <p>
                            Welcome to Alternative Energy Inc's.
                            Energy Analysis and Proposal for a grid
                            tied photovoltaic system to be considered
                            for the <strong> <?= $proposal['dpp_lastname'] ?>'s </strong>
                            residence of <strong><?= $proposal['address'] ?></strong>. The
                            purpose of this document is to illustrate
                            the advantages for you, your household
                            and the environment by installing a gridtied
                            photovoltaic system with Alternate
                            Energy Inc.
                        </p>

                        <h4>Three Generations</h4>
                        <p>
                            Alternate Energy Inc. (AEI) is a familyowned
                            and operated business with a long
                            history of serving kamaaina. More than 30
                            years ago, Bruce Ekimura, a plumber by
                            trade, realized that harnessing the power
                            of the sun could help Hawaii families
                            combat the rising price of electricity and
                            help our state become less dependent on
                            imported oil. Bruce and his father became
                            early specialists in the installation of solar
                            hot water heaters, and later photovoltaic
                            (PV) systems, and in 1993 Alternate
                            Energy was officially incorporated.
                        </p>
                    </td>
                    <td width="3%">&nbsp;</td>
                    <td width="34%" valign="top">
                        <p>
                            Today, as rising oil prices continue to keep
                            electricity rates soaring, Alternate Energy
                            remains committed to helping local families
                            and businesses discover the clean, green,
                            moneysaving power of the sun.
                        </p>

                        <h4>Elite Dealer</h4>
                        <p class="clearfix;">
                            Alternate Energy Inc. recently achieved
                            the status of Mitsubishi Electric's first
                            Nationally recognized Elite Dealer for
                            solar PV. This means that we are   
                            <img src="<?= base_url() ?>assets/pdfimages/Elite-Dealer.jpg" class="fr" style="width:150px;padding-top:10px;" />
                            Certified and trusted by Mitsubishi Electric <br/> to sell and install<br /> its premium
                            monocrystalline solar panels in Hawaii.
                        </p>

                        <h4 class="cl">Elite Training & Certification</h4>
                        <p>
                            All of our highly skilled solar technicians
                            are employees (not subcontractors)
                            annually Trained and Certified by
                            Mitsubishi Electric to design, install and
                            service all of your PV needs.
                        </p>
                    </td>
                    <td width="3%">&nbsp;</td>
                    <td width="34%" valign="top">
                        <h4>Elite Products</h4>
                        <p>
                            We understand that photovoltaic systems
                            are a long term investment. That's why
                            we invest in the most reliable companies
                            that have been trusted for years.
                            Mitsubishi Electric's premium solar panels
                            are made 100% in Japan where quality is a
                            high standard.
                        </p>

                        <p>
                            The solar panels are also designed and
                            warrantied for installations near salt
                            water for long lasting performance.
                        </p>

                        <h4>Elite Service</h4>
                        <p>
                            Being family-owned and operated, we
                            take pride in every job and make sure each
                            customer is satisfi ed, every time. We are
                            Hawaii's expert solar company since 1993.
                        </p>

                        <div class="greenbox fl">
                            This system will prevent <?= $supler; ?><br />
                            lbs sulfur dioxide (causes<br />
                            acid rain) from being released<br />
                            into Hawaii's rainforests.
                        </div>
                    </td>
                </tr>
            </table>
        </div> 

        <div class="wrap break">
            <div class="headerPan clearfix">
                <h1 class="fl">Power Production Estimate</h1>
                <img src="<?= base_url() ?>assets/pdfimages/logo.png" class="fr" />
            </div>
            <div class="clearfix">
                <div class="datePan"><strong><?= date("F j, Y", strtotime($proposal['created'])); ?> / Quote No. <?= $proposal['id'] ?></strong> / PV + H.E.S.S. Proposal Page 3</div>

            </div>

            <div class="clearfix">
                <div class="fl" style="width:490px;">
                    <h4>Customer Details</h4>
                    <table class="dataTable blebcc">
                        <tr>
                            <td>
                                Street Address:
                            </td>
                            <td class="rightalign"><?= $proposal['address'] ?> </td>
                        </tr>
                        <tr class="altBg">
                            <td>
                                City, Zip Code, State:
                            </td>    
                            <td class="rightalign"><?= $proposal['city'] . ',' . $proposal['zip'] . ',' . $proposal['state'] ?></td>
                        </tr>
                        <tr>
                            <td>
                                Solar Sunshine Zone:
                            </td>    
                            <td class="rightalign"><?= $proposal['avgzoneenergy'] ?> </td>
                        </tr>
                        <tr class="altBg">
                            <td>
                                Weather Data Source:
                            </td>    
                            <td class="rightalign">(TMY2) HONOLULU, HI 6.2 mi </td>
                        </tr>
                        <tr>
                            <td nowrap="nowrap"><strong></strong>
                                Peak Sun Hours for Production:
                            </td>
                            <td class="rightalign"><?= round($solorsum / 12, 2) ?> hrs </td>
                        </tr>
                        <tr class="altBg">
                            <td>
                                Current Utility Rate:
                            </td>    
                            <td class="rightalign">$<?= number_format($proposal["electriccost"] / 100, 2) ?> / kWh</td>
                        </tr>
                        <tr>
                            <td>
                                Current Utility Export Rate:
                            </td>
                            <td class="rightalign">$<?= @$current_usage_information['export_rate'] ?> / kwh</td>
                        </tr>
                    </table>


                    <h4 style="margin-top:20px;">PV System Specifications</h4>
                    <table class="dataTable">
                        <tr>
                            <td>System Size (DC Rating):</td>
                            <td class="rightalign"><?= $proposal['system_size'] ?> kW </td>
                        </tr>
                        <tr class="altBg">
                            <td>DC to AC Derate Factor: </td>
                            <td class="rightalign"><?= $proposal['dctoacderate'] ?></td>
                        </tr>
                        <tr>	
                            <td>System Size (AC Rating):</td>
                            <td class="rightalign"><?= number_format($proposal['system_size'] * $proposal['dctoacderate'], 2) ?> kW </td>
                        </tr>
                        <tr class="altBg">    
                            <td>Module Type: </td>
                            <td class="rightalign"><?= $qoute_mws[$proposal['module_type']] ?> </td>
                        </tr>
                        <tr>    
                            <td>Number of Modules: </td>
                            <td class="rightalign"><?= $proposal['nom'] ?> </td>
                        </tr>
                        <tr class="altBg">    
                            <td>Module Power:</td>
                            <td class="rightalign"><?
				if ($proposal['module_type'] == 1 || $proposal['module_type'] == 96 || $proposal['module_type'] == 97)
				    echo "255";
				if ($proposal['module_type'] == 2)
				    echo '225';
				if ($proposal['module_type'] == 70 || $proposal['module_type'] == 205)
				    echo '260';
				if ($proposal['module_type'] == 204)
				    echo '290';
				if ($proposal['module_type'] == 206 || $proposal['module_type'] == 216 || $proposal['module_type'] == 217)
				    echo '265';
				?> <? if ($proposal["module_type"] == 232) echo "270"; ?> <?
				if ($proposal['module_type'] == 231)
				    echo '275';
				if ($proposal['module_type'] == 254)
				    echo '265';
				if ($proposal['module_type'] == 297)
				    echo '280';
				?> W</td>
                        </tr>
                        <tr >    
                            <td>Module Dimensions: </td>
                            <td class="rightalign"><?
				if ($proposal['module_type'] == 96)
				    echo '64.57" x 39.37"';
				else if ($proposal['module_type'] == 254)
				    echo '65.2" x 39.1"';
				else if ($proposal['module_type'] == 97)
				    echo '64.76" x 38.70"';
				else
				    echo '64" x 40.1"';
				?></td>
                        </tr>
                        <tr class="altBg">    
                            <td>Inverter Type: </td>
                            <td class="rightalign" nowrap="nowrap">
				<?if($proposal['invertert'] == 298 || $proposal['invertert']==299){
					echo 'SOLAREDGE SE7600A HYBRID INVERTER';
				 }else if($proposal['invertert'] ==241 || $proposal['invertert']==242 || $proposal['invertert']==243 || $proposal['invertert']==249){
					echo 'SchneiderXW6848';
				} ?>		    
			    </td>

                        </tr>
			<tr class="">    
                            <td>Storage Type: </td>
                            <td class="rightalign" nowrap="nowrap"><?= @$qoute_iws[$proposal['invertert']] ?></td>

                        </tr>
                        <tr class="altBg">    
                            <td>Array Azimuth (Orientation):</td>
                            <td class="rightalign"><?= $proposal['arrayazimuth'] ?> &deg;</td>

                        </tr>
                        <tr >
                            <td>Roof Tilt: </td>
                            <td class="rightalign">22 &deg; </td>
                        </tr>
                        <tr class="altBg">    
                            <td>Est. Annual Energy Production (kWh): </td>
                            <td class="rightalign"><?= round((@$pvsumenergy), 2) ?> / Month</td>

                        </tr>   

                    </table>
		    <?
		    $hess_available_capacity = 0;
		    $inverter_size_kW = 0;
		    if ($proposal['invertert'] == 249) {
			$inverter_size_kW = 6;

			$hess_available_capacity = 7.77;
		    } else if ($proposal['invertert'] == 241) {
			$inverter_size_kW = 6;
			$hess_available_capacity = 11.65;
		    } else if ($proposal['invertert'] == 243) {
			$inverter_size_kW = 6;
			$hess_available_capacity = 15.54;
		    } else if ($proposal['invertert'] == 298) {
			$inverter_size_kW = 7.6;
			$hess_available_capacity = 6.4;
		    } else if ($proposal['invertert'] == 299) {
			$inverter_size_kW = 7.6;
			$hess_available_capacity = 12.8;
		    }
		    ?>
                    <h4 style="margin-top:20px;">Storage System Specifications </h4>
                    <table class="dataTable">
                        <tr>
                            <td>System Storage Capacity:</td>
                            <td class="rightalign"><?= $hess_available_capacity ?> kWh </td>
                        </tr>
                        <tr class="altBg">
                            <td>Depth of Discharge: </td>
                            <td class="rightalign">100%</td>
                        </tr>

<!--                        <tr>    
                            <td>Unit Dimensions:</td>
                            <td class="rightalign">3.23 kW </td>
                        </tr>-->
                        <tr >
                            <td>Module Type: </td>
                            <td class="rightalign"><?= $qoute_mws[$proposal['module_type']] ?></td>

                        </tr>
<!--                        <tr>    
                            <td>Number of Modules:</td><td class="rightalign"><?= $proposal['nom'] ?></td>
		       
                        </tr>-->
                        <tr class="altBg">    
                            <td>Module Power:</td><td class="rightalign"><?
		    if ($proposal['module_type'] == 1 || $proposal['module_type'] == 96 || $proposal['module_type'] == 97)
			echo "255";
		    if ($proposal['module_type'] == 2)
			echo '225';
		    if ($proposal['module_type'] == 70 || $proposal['module_type'] == 205)
			echo '260';
		    if ($proposal['module_type'] == 204)
			echo '290';
		    if ($proposal['module_type'] == 206 || $proposal['module_type'] == 216 || $proposal['module_type'] == 217)
			echo '265';
		    ?> <? if ($proposal["module_type"] == 232) echo "270"; ?> <?
		    if ($proposal['module_type'] == 231)
			echo '275';
		    if ($proposal['module_type'] == 254)
			echo '265';
		    if ($proposal['module_type'] == 297)
			echo '280';
		    ?> W</td>
                        </tr>
                        <tr>    
                            <td>Module Dimensions:</td><td class="rightalign"><?
		    if ($proposal['module_type'] == 96)
			echo '64.57" x 39.37"';
		    else if ($proposal['module_type'] == 254)
			echo '65.2" x 39.1"';
		    else if ($proposal['module_type'] == 97)
			echo '64.76" x 38.70"';
		    else
			echo '51.3" x 34" x 7.2"';
		    ?></td>
                        </tr>
                        <tr class="altBg">    
                            <td>Inverter Type:</td>
                            <td class="rightalign" nowrap="nowrap"><?= @$qoute_iws[$proposal['invertert']] ?></td>
                        </tr>
<!--                        <tr>    
                                <td>Array Azimuth (Orientation):</td><td class="rightalign"><?= $proposal['arrayazimuth'] ?> &deg;</td>
			
                        </tr>
                        <tr class="altBg">    
                            <td>Roof Tilt:</td><td class="rightalign">22 &deg;</td>
                        </tr>
                        <tr>    
                            <td>Monthly PV Production:</td><td class="rightalign"><?= round((@$pvsumenergy / 12), 2) ?> / Month</td>
			
                        </tr>-->

			<tr >    
                            <td>Round Trip Efficiency:</td>
                            <td class="rightalign" nowrap="nowrap">92.5%</td>
                        </tr>
			<tr class="altBg">    
                            <td>Equivalent Cycles:</td>
                            <td class="rightalign" nowrap="nowrap">Equivalent to 1 full cycle per day for 10 years</td>
                        </tr>

                    </table>
                </div>
                <!-- graph section -->        
                <div class="fr">
                    <div class="declaraton">Monthly System Production Estimates*</div>
                    <div style="width:472px; float:right;">
                        <div style="border:2px solid #000000; padding:10px 10px 15px 10px;" class="clearfix">
                            <div class="graphchatTable">
                                <table class="" cellpadding="0" cellspacing="0">
                                    <tr>
                                        <td valign="middle"><img src="<?= base_url() ?>assets/pdfimages/chat-left.png" /></td>
                                        <td>
                                            <table class="td_noborder" width="420" cellpadding="0" cellspacing="10" border="0">
                                                <tr>
                                                    <td class="listN" width="20"><?= $grpah_m * $divdedby; ?></td>
<?
foreach ($proposal_month as $pmd) {
    if ($pmd['month'] == 'Year')
	continue;
    ?>
    						    <td rowspan="<?= $grpah_m + 1 ?>" valign="bottom"><div class="graphData" style="height:<?= $pmd['acenergy'] * .37 * $per ?>px;"></div></td>
<? } ?>
                                                </tr>
<? for ($k = $grpah_m - 1; $k >= 0; $k--) { ?> 
    						<tr>
    						    <td class="listN"><?= $k * $divdedby; ?></td>
    						</tr>
				<? } ?>

                                                <tr>
                                                    <td>&nbsp;</td>
                                                    <td class="monthD">J</td>
                                                    <td class="monthD">F</td>
                                                    <td class="monthD">M</td>
                                                    <td class="monthD">A</td>
                                                    <td class="monthD">M</td>
                                                    <td class="monthD">J</td>
                                                    <td class="monthD">J</td>
                                                    <td class="monthD">A</td>
                                                    <td class="monthD">S</td>
                                                    <td class="monthD">O</td>
                                                    <td class="monthD">N</td>
                                                    <td class="monthD">D</td>
                                                </tr>
                                            </table>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td>&nbsp;</td>
                                        <td style="text-align:center; font-family: neo sans;">MONTHS(<?= date("Y", strtotime($proposal['created'])); ?>)</td>
                                    </tr>
                                    <tr>
					<td>&nbsp;</td>
                                    </tr>
                                </table>
                            </div>
                            <table class="graphtable graphtablejul">
				<tr>
                                    <th width="120px">Month</th>
                                    <th>Sun Hours</th><th>Energy (kWh)</th>
                                    <!--<th>Energy Value($)</th>-->
				</tr>
<?
$startmo = 0;
$solorsum = 0;
$pvsumenergy = 0;
$pvenergyval = 0;
foreach ($proposal_month as $pvenergy) {
    if ($pvenergy['month'] == "Year")
	continue;
    $startmo+=1;
    $solorsum += $pvenergy['solar'];
    $pvsumenergy +=$pvenergy['acenergy'];
    $pvenergyval +=$pvenergy['costsaved'];
    ?>
    				<tr>
    				    <td><?= $startmo; ?></td>
    				    <td><?= $pvenergy['solar'] ?></td>
    				    <td><?= $pvenergy['acenergy'] ?></td>
    				    <!--<td><?= $pvenergy['costsaved'] ?></td>-->
    				</tr>
<? } ?>

                                <tr style="border-top:1px solid #000;">
                                    <td>Year</td>
                                    <td><?= round($solorsum / 12, 2) ?></td>
                                    <td><?= $pvsumenergy ?></td>
                                    <!--<td><?= $pvenergyval ?></td>-->
                                </tr>
                            </table>
                        </div>

                        <div style="padding:10px 0; letter-spacing:normal; font-family:neo sans; text-align:left; margin-top:10px; line-height:133%; border-top:0px solid #ffffff;" class="notesd">

                            * Any example estimated PV energy production con-<img src="<?= base_url() ?>assets/pdfimages/nelo.png" class="fr" style="margin-top:-4px; width:143px;padding-bottom: 10px; margin-left:7px;" /> <br />tained in this PV estimate are 
                            hypothetical based on the National Renewable Energy Laboratory's (NREL) PVWatts calculator.
                            Estimate PV production values are provided for illustrative purposes only and should not 
                            be construed as predicted and exact energy production. Hypothetical PV performance results are
                            simulated and have many inherent factors that may affect your PV system's performance. As
                            your PV system has not actually been installed and put into service, the results may have under
                            or over compensated for any impact of certain assumption and weather factors, such as but not
                            limited to your assumption in daytime vs. nighttime loads and/ or cloudy and rainy days. Any 
                            methods, techniques, or assumptions presented in this email are for educational purposes only 
                            and are presented to assist you to make your own judgments on sizing your PV system (for which 
                            you are responsible). Any information or data contained in this PV estimate is historical 
                            and provides no indication of future performance.
                        </div>
                    </div>
                </div>
                <!-- /graph section -->
            </div>    
        </div>
	
	<?  
		$page_no=3;					
	    
	?>
        <div class="wrap break" style="display: <?= (@$proposal['cost_model_summary']) ? 'block' : 'none' ?>">
            <div class="headerPan clearfix">
                <h1 class="fl">Cost Model Summary </h1>
                <img src="<?= base_url() ?>assets/pdfimages/logo.png" class="fr" />
            </div>
            <div class="clearfix">
                <div class="datePan"><strong><?= date("F j, Y", strtotime($proposal['created'])); ?> / Quote No. 
<?= $proposal['id'] ?></strong> / PV + H.E.S.S. Proposal Page 
		    <?
		    if(@$proposal['cost_model_summary']) 
			    echo $page_no = $page_no+1;
		    else
			$page_no = $page_no;
		    ?>
                </div>

		<!-- graph section -->   
		<!-- graph section -->   
		<?php
		
		$sum_curr_energy = 0;
$sum_energy_prod = 0;
$sum_self_supply = 0;
$sum_self_supplyvalue = 0;
$sum_heco_deliver = 0;
$sum_heco_deliver_cost = 0;
$sum_heco_recv = 0;
$sum_heco_recv_cost = 0;
$sum_net_bill = 0;
$sum_lost_credit_value = 0;
$cost_summary_tr = 0;
$sum_curr_avg = 0;
$sum_solar = 0;
$sum_estimated_pv_used_direct = 0;
$sum_estimated_pv_used_direct_valuation = 0;
$sum_estimated_kwh_available_for_credit = 0;
$sum_estimated_pv_available_battery = 0;
$sum_estimated_pv_used_battery = 0;
$sum_hecco_received_curtailed_kWh = 0;
$sum_hecco_deliverd_kwh = 0;
$sum_estimated_energy_credits = 0;

		$max_cost_avoid = 0;
		foreach ($proposal_month as $pvenergy) {
		    $current_electric_cost = $proposal['electriccost'] / 100;
		    $pvenergy["month"] = substr($pvenergy["month"], 0, 3);
		    $current_bill_energy = $pv_grid_model_der[strtolower($pvenergy["month"]) . "_ceu"];
		    $current_bill_doller = round($current_bill_energy * $current_electric_cost);
		    $cost_avoid = $current_bill_doller;
		    if ($cost_avoid > @$max_cost_avoid) {
			$max_cost_avoid = $cost_avoid;
		    }
		}
		if ($max_cost_avoid < 150) {
		    $divdedby = 30;
		    $per = 1.4;
		} else if ($max_cost_avoid >= 150 && $max_cost_avoid < 350) {
		    $divdedby = 70;
		    $per = .75;
		} else if ($max_cost_avoid >= 350 && $max_cost_avoid < 500) {
		    $divdedby = 100;
		    $per = .54;
		} else if ($max_cost_avoid >= 500 && $max_cost_avoid < 1000) {
		    $divdedby = 200;
		    $per = .275;
		} else if ($max_cost_avoid >= 1000 && $max_cost_avoid < 2000) {
		    $divdedby = 400;
		    $per = .14;
		} else if ($max_cost_avoid >= 2000 && $max_cost_avoid < 3500) {
		    $divdedby = 700;
		    $per = .087;
		} else if ($max_cost_avoid >= 3500 && $max_cost_avoid < 5000) {
		    $divdedby = 1000;
		    $per = .087;
		} else if ($max_cost_avoid >= 5000 && $max_cost_avoid < 10000) {
		    $divdedby = 2000;
		    $per = .03;
		} else if ($max_cost_avoid >= 10000) {
		    $divdedby = 4000;
		    $per = .013;
		}
		$grpah_m2 = ceil($max_cost_avoid / $divdedby)
		?>
                <div class="declaraton declaraton_new_l">Avoided Utility Costs vs. Estimated New Net Bill</div>
                <div class="clearfix">
                    <div class="graphchatTable">
                        <table width="100%" cellpadding="0" cellspacing="0">
                            <tr>
                                <td valign="middle"><img src="<?= base_url() ?>assets/pdfimages/chat-left_new.png" /></td>
                                <td>
                                    <table width="100%" cellspacing="0" cellpadding="0" border="0">
                                        <tr>
                                            <td class="listN" width="20"><?= ($grpah_m2) * $divdedby ?></td>
					    
					    <?
						    foreach ($proposal_month as $pvenergy) {
							$current_electric_cost = $proposal['electriccost'] / 100;
							$pvenergy["month"] = substr($pvenergy["month"], 0, 3);
							$current_bill_energy = $pv_grid_model_der[strtolower($pvenergy["month"]) . "_ceu"];
							$current_bill_doller = round($current_bill_energy * $current_electric_cost);
							$day_self_supply = round($pvenergy["acenergy"] * $pv_grid_model_der['day_use'] / 100);
							$day_self_cost = $day_self_supply * $current_electric_cost;
							$hecco_deliverd = $current_bill_energy - $day_self_supply;
							$heco_cost = $hecco_deliverd * $current_electric_cost;
							$hecco_recv = $pvenergy["acenergy"] - $day_self_supply;
							$heco_recv_cost = round($pv_grid_model_der['export_rate'] * $hecco_recv);
							/*************/
							$energy_production_kWh = ($proposal['system_size'] * $proposal['dctoacderate']) * $pvenergy["solar"] * 30.4;
							$sum_energy_prod = $sum_energy_prod + $energy_production_kWh;
							$estimated_pv_used_direct = number_format($current_bill_energy * ($pv_grid_model_der['day_use'] / 100), 2);
							$sum_estimated_pv_used_direct+=$estimated_pv_used_direct;
							$estimated_pv_used_direct_valuation = number_format($estimated_pv_used_direct * ($proposal['electriccost'] / 100), 2);
							$sum_estimated_pv_used_direct_valuation+=$estimated_pv_used_direct_valuation;
							$estimated_pv_available_battery = number_format(($energy_production_kWh - $estimated_pv_used_direct), 2);
							$sum_estimated_pv_available_battery+=$estimated_pv_available_battery;

							if ($estimated_pv_available_battery <= $hess_available_capacity * 30.4) {
							    $estimated_pv_used_battery = $estimated_pv_available_battery;
							} else {
							    $estimated_pv_used_battery = number_format(($hess_available_capacity * 30.4), 2);
							}
							
							$sum_estimated_pv_used_battery+=$estimated_pv_used_battery;

							$hecco_received_curtailed_kWh = $energy_production_kWh - $estimated_pv_used_direct - $estimated_pv_used_battery;
							$sum_hecco_received_curtailed_kWh += $hecco_received_curtailed_kWh;

							$k1 = $current_bill_energy - $estimated_pv_used_direct - $estimated_pv_used_battery;

							if ($k1 <= 0)
							    $hecco_deliverd_kwh = 0;
							else
							    $hecco_deliverd_kwh = $k1;

							$sum_hecco_deliverd_kwh += $hecco_deliverd_kwh;
							$hecco_recv = $energy_production_kWh - $estimated_pv_used_direct;

							$sum_heco_recv = $sum_heco_recv + $hecco_recv;

							if ($hecco_deliverd_kwh < $hecco_received_curtailed_kWh) {
							    $estimated_energy_credits_new = round($pv_grid_model_der['export_rate'] * @$hecco_deliverd, 2);
							    $estimated_kwh_available_for_credit = round($hecco_deliverd_kwh, 2);
							} else {
							    $estimated_energy_credits_new = $pv_grid_model_der['export_rate'] * $hecco_recv;

							    $estimated_kwh_available_for_credit = round($hecco_received_curtailed_kWh, 2);
							}
							$sum_estimated_kwh_available_for_credit+=$estimated_kwh_available_for_credit;
							$sum_estimated_kwh_available_for_credit = round($sum_estimated_kwh_available_for_credit, 2);
							$estimated_energy_credits = round($pv_grid_model_der['export_rate'] * $estimated_kwh_available_for_credit, 2);
							$sum_estimated_energy_credits+=$estimated_energy_credits;

						        $heco_final_bill = $hecco_deliverd_kwh * $current_electric_cost - $estimated_energy_credits;
							/*****/
						        
							$graphpoint_netbeill = 0;
							if ($heco_final_bill < 50) {
							     $graphpoint_netbeill = $heco_final_bill * .7;
							} else {
							     $graphpoint_netbeill = 35 + ($heco_final_bill - 45) * .54;
							}
							
							
							$n_n_bill_without_storage=($estimated_pv_used_battery*($pv_grid_model_der['day_use'] / 100))+$heco_final_bill;
							$st=$n_n_bill_without_storage-$heco_final_bill;
							if ($st < 50) {
							    $graphpoint_without_storage = $st * .5;
							} else {
							    $graphpoint_without_storage = 20 + ($st - 5) * .2;
							}
							$cost_avoid = $current_bill_doller;
							
							$cost_avoid_g = $cost_avoid - $heco_final_bill-$graphpoint_without_storage;
							if ($cost_avoid_g <= 1) {
							    $cost_avoid_g = 2;
							}
							$graphpoint_avoid = 0;
							if ($cost_avoid_g < 50) {
							    $graphpoint_avoid = $cost_avoid_g * .7;
							} else {
							    $graphpoint_avoid = 20 + ($cost_avoid_g - 50) * .2;
							}
							?>                          
    						    <td rowspan="<?= $grpah_m2 + 1 ?>" valign="bottom">
    							<div class="gph-div">
    							    <div class="graphData graphData_one" style="height:<?=$graphpoint_avoid * $per; ?>px;"></div>
    							    <div class="graphData graphData_onetow" style="height:<?=round($graphpoint_without_storage * $per) ?>px;"></div>
							    <div class="graphData graphData_onetthree" style="height:<?=round($graphpoint_netbeill * $per)?>px;"></div>
    							</div>    
    						    </td>
<? } ?>                             
<!--                                            <td valign="bottom">
						<div class="gph-div">
						    <div class="graphData graphData_one" style="height:70px;"></div>
						    <div class="graphData graphData_onetow" style="height:15px;"></div>
						    <div class="graphData graphData_onetthree" style="height:10px;"></div>
						</div>    
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="gph-div">
                                                    <div class="graphData graphData_one" style="height:85px;"></div>
                                                    <div class="graphData graphData_onetow" style="height:20px;"></div>
                                                    <div class="graphData graphData_onetthree" style="height:10px;"></div>
                                                </div>    
                                            </td>
                                            <td valign="bottom">
                                                <div class="gph-div">
                                                    <div class="graphData graphData_one" style="height:90px;"></div>
                                                    <div class="graphData graphData_onetow" style="height:25px;"></div>
                                                    <div class="graphData graphData_onetthree" style="height:10px;"></div>
                                                </div>    
                                            </td>
                                            <td valign="bottom">
                                                <div class="gph-div">
                                                    <div class="graphData graphData_one" style="height:85px;"></div>
                                                    <div class="graphData graphData_onetow" style="height:22px;"></div>
                                                    <div class="graphData graphData_onetthree" style="height:10px;"></div>
                                                </div>    
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="gph-div">
                                                    <div class="graphData graphData_one" style="height:110px;"></div>
                                                    <div class="graphData graphData_onetow" style="height:18px;"></div>
                                                    <div class="graphData graphData_onetthree" style="height:10px;"></div>
                                                </div>    
                                            </td>
                                            <td valign="bottom">
                                                <div class="gph-div">
                                                    <div class="graphData graphData_one" style="height:115px;"></div>
                                                    <div class="graphData graphData_onetow" style="height:20px;"></div>
                                                    <div class="graphData graphData_onetthree" style="height:10px;"></div>
                                                </div>    
                                            </td>
                                            <td valign="bottom">
                                                <div class="gph-div">
                                                    <div class="graphData graphData_one" style="height:120px;"></div>
                                                    <div class="graphData graphData_onetow" style="height:25px;"></div>
                                                    <div class="graphData graphData_onetthree" style="height:10px;"></div>
                                                </div>    
                                            </td>
                                            <td valign="bottom">
                                                <div class="gph-div">
                                                    <div class="graphData graphData_one" style="height:110px;"></div>
                                                    <div class="graphData graphData_onetow" style="height:24px;"></div>
                                                    <div class="graphData graphData_onetthree" style="height:10px;"></div>
                                                </div>    
                                            </td>
                                            <td valign="bottom">
                                                <div class="gph-div">
                                                    <div class="graphData graphData_one" style="height:100px;"></div>
                                                    <div class="graphData graphData_onetow" style="height:20px;"></div>
                                                    <div class="graphData graphData_onetthree" style="height:10px;"></div>
                                                </div>    
                                            </td>
                                            <td valign="bottom">
                                                <div class="gph-div">
                                                    <div class="graphData graphData_one" style="height:115px;"></div>
                                                    <div class="graphData graphData_onetow" style="height:20px;"></div>
                                                    <div class="graphData graphData_onetthree" style="height:10px;"></div>
                                                </div>    
                                            </td>
                                            <td valign="bottom">
                                                <div class="gph-div">
                                                    <div class="graphData graphData_one" style="height:80px;"></div>
                                                    <div class="graphData graphData_onetow" style="height:15px;"></div>
                                                    <div class="graphData graphData_onetthree" style="height:10px;"></div>
                                                </div>    
                                            </td>
                                            <td valign="bottom">
                                                <div class="gph-div">
                                                    <div class="graphData graphData_one" style="height:60px;"></div>
                                                    <div class="graphData graphData_onetow" style="height:10px;"></div>
                                                    <div class="graphData graphData_onetthree" style="height:10px;"></div>

                                                </div>    
                                            </td>-->

                                        </tr>
<? for ($k = $grpah_m2 - 1; $k >= 0; $k--) { ?> 
    						<tr>
    						    <td class="listN"><?= $k * $divdedby; ?></td>
    						</tr>
<? } ?>
                                        <tr>
                                            <td>&nbsp;</td>
                                            <td class="monthD_new">JAN </td>
                                            <td class="monthD_new">FEB </td>
                                            <td class="monthD_new">MAR </td>
                                            <td class="monthD_new">APR </td>
                                            <td class="monthD_new">MAY </td>
                                            <td class="monthD_new">JUN </td>
                                            <td class="monthD_new">JUL </td>
                                            <td class="monthD_new">AUG </td>
                                            <td class="monthD_new">SEP </td>
                                            <td class="monthD_new">OCT </td>
                                            <td class="monthD_new">NOV </td>
                                            <td class="monthD_new">DEC </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>

                        </table>
			<br />
                        <div class="declaraton yerdiv_color">
                            <p style="padding-top:0">
                                <span><img src="<?= base_url() ?>assets/pdfimages/color-n/c6.png" /> </span> 
                                <span>Est. New Net Bill (w/o storage) </span>&nbsp;
                                <span><img src="<?= base_url() ?>assets/pdfimages/color-n/c7.png" /> </span>  
                                <span>Est. New Net Bill (w/ storage) </span>&nbsp;
                                <span><img src="<?= base_url() ?>assets/pdfimages/color-n/c8.png" /> </span> 
                                <span>Avoided Electrical Cost </span>
                            </p>
                        </div>
                        <br /><br /><br />
                    </div>
                    <table class="graphtable dataTable graphtable_one graphtable_oneju">
                        <thead>
                            <th width="80px">&nbsp; </th>
                            <th width="170px">Current Energy Usage (kWh)</th>
                            <th width="153px">Current<br/> Bill ($)</th>
<!--                            <th width="190px">Sun Hours</th>-->
                            <th width="100px">Energy Production (kWh)</th>
                            <th width="250px">Est. PV<br/> used - Direct (kWh) </th>
                            <th width="125px">Est. PV<br/> used - Direct valuation ($<?= number_format($proposal['electriccost'] / 100, 2) ?>/kWh)</th>
                            <th width="164px">Est. PV available - Battery (kWh)</th>
                            <th width="200px">Est. PV <br />used - <br />Battery<br /> (kWh)</th>
                            <th width="150px">HECO received /<br /> curtailed<br />(kWh)</th>
                            <th width="140px">HECO Delivered (kWh)</th>

                            <th width="140px">Est. kWh available for credit ($<?= number_format($proposal['electriccost'] / 100, 2) ?>/kWh)</th>

                            <th width="100px">Estimated Energy Credits ($<?= $current_usage_information["export_rate"] ?>/kWh)</th>
                            <th width="100px">Net Bill <!--<span style="color:orange;">(*Min Bill $25)</span>--> </th>
                        </thead>
                        <tbody>
<?php
$sum_curr_energy = 0;
$sum_energy_prod = 0;
$sum_self_supply = 0;
$sum_self_supplyvalue = 0;
$sum_heco_deliver = 0;
$sum_heco_deliver_cost = 0;
$sum_heco_recv = 0;
$sum_heco_recv_cost = 0;
$sum_net_bill = 0;
$sum_lost_credit_value = 0;
$cost_summary_tr = 0;
$sum_curr_avg = 0;
$sum_solar = 0;
$sum_estimated_pv_used_direct = 0;
$sum_estimated_pv_used_direct_valuation = 0;
$sum_estimated_kwh_available_for_credit = 0;
$sum_estimated_pv_available_battery = 0;
$sum_estimated_pv_used_battery = 0;
$sum_hecco_received_curtailed_kWh = 0;
$sum_hecco_deliverd_kwh = 0;
$sum_estimated_energy_credits = 0;
foreach ($proposal_month as $pvenergy) {
    $cost_summary_tr++;
    $sum_solar+=@$pvenergy['solar'];
    $current_electric_cost = $proposal['electriccost'] / 100;
    ?>
    			    <tr class="<?= ($cost_summary_tr % 2 == 0 ) ? 'altBg' : ''; ?>">
    				<td><?= $pvenergy["month"]; ?><? $pvenergy["month"] = substr($pvenergy["month"], 0, 3); ?>
    				</td>
    				<td><?
				    $current_bill_energy = $pv_grid_model_der[strtolower($pvenergy["month"]) . "_ceu"];
				    $sum_curr_energy = $sum_curr_energy + $current_bill_energy;
				    echo ($current_bill_energy > 0) ? number_format($current_bill_energy, 2) : 0;
				    ?> 
    				</td>
    				<td>$<?
				    $current_bill_doller = round($current_bill_energy * $current_electric_cost, 2);
				    $sum_curr_avg = $sum_curr_avg + $current_bill_doller;
				    echo ($current_bill_doller > 0) ? number_format($current_bill_doller, 2) : 0;
				    ?> 
    				</td>
    <!--                                            <td>
					<?= ($pvenergy["solar"] > 0) ? number_format($pvenergy["solar"], 2) : 0; ?>
    				</td>-->
    				<td><?
				    $energy_production_kWh = ($proposal['system_size'] * $proposal['dctoacderate']) * $pvenergy["solar"] * 30.4;
				    echo number_format($energy_production_kWh, 2);
				    $sum_energy_prod = $sum_energy_prod + $energy_production_kWh;
					?> 
    				</td>
    				<td><?
					$estimated_pv_used_direct = $current_bill_energy * ($pv_grid_model_der['day_use'] / 100);
					echo number_format($estimated_pv_used_direct,2);
					$sum_estimated_pv_used_direct+=$estimated_pv_used_direct
					?>
    				</td>
    				<td>
    				    $<?
				     $estimated_pv_used_direct_valuation = $estimated_pv_used_direct * ($proposal['electriccost'] / 100);
				    echo number_format($estimated_pv_used_direct_valuation,2);
				    $sum_estimated_pv_used_direct_valuation+=$estimated_pv_used_direct_valuation;
				    ?>
    				</td>

        <!--                                <td><?
					$day_self_supply = round($pvenergy["acenergy"] * $pv_grid_model_der['day_use'] / 100, 2);
					echo ($day_self_supply > 0) ? number_format($day_self_supply, 2) : 0;
					$sum_self_supply = $sum_self_supply + $day_self_supply;
					?> </td>
        

         <td> $<?
					$day_self_cost = $day_self_supply * $current_electric_cost;
					$sum_self_supplyvalue = $sum_self_supplyvalue + $day_self_cost;
					echo ($day_self_cost > 0) ? number_format($day_self_cost, 2) : 0;
					?></td>-->

    				<td>
					<?
					 $estimated_pv_available_battery = ($energy_production_kWh - $estimated_pv_used_direct);
					echo number_format($estimated_pv_available_battery,2);
					$sum_estimated_pv_available_battery+=$estimated_pv_available_battery;
					?>
    				</td>
    				<td>
					<?
					if ($estimated_pv_available_battery <= $hess_available_capacity * 30.4) {
					    $estimated_pv_used_battery = $estimated_pv_available_battery;
					} else {
					    $estimated_pv_used_battery = ($hess_available_capacity * 30.4);
					}
					echo number_format($estimated_pv_used_battery,2);
					$sum_estimated_pv_used_battery+=$estimated_pv_used_battery;
					?>
    				</td>

    				<td>
					<?
					$hecco_received_curtailed_kWh = $energy_production_kWh - $estimated_pv_used_direct - $estimated_pv_used_battery;
					$sum_hecco_received_curtailed_kWh += $hecco_received_curtailed_kWh;
					echo ($hecco_received_curtailed_kWh > 0) ? number_format($hecco_received_curtailed_kWh, 2) : 0;
					?> 
    				</td>
    <!--                                <td>$<?
				    $heco_cost = $hecco_deliverd * $current_electric_cost;
				    $sum_heco_deliver_cost = $sum_heco_deliver_cost + $heco_cost;
					?> </td>-->
    				<td>

					<?
					$k1 = $current_bill_energy - $estimated_pv_used_direct - $estimated_pv_used_battery;

					if ($k1 <= 0)
					    $hecco_deliverd_kwh = 0;
					else
					    $hecco_deliverd_kwh = $k1;
					echo number_format($hecco_deliverd_kwh,2);
					$sum_hecco_deliverd_kwh += $hecco_deliverd_kwh;
					$hecco_recv = $energy_production_kWh - $estimated_pv_used_direct;

					$sum_heco_recv = $sum_heco_recv + $hecco_recv;
					?> 
    				</td>

    				<td>
					<?
					if ($hecco_deliverd_kwh < $hecco_received_curtailed_kWh) {
					    $estimated_energy_credits_new = round($pv_grid_model_der['export_rate'] * @$hecco_deliverd, 2);
					    $estimated_kwh_available_for_credit = round($hecco_deliverd_kwh, 2);
					} else {
					    $estimated_energy_credits_new = $pv_grid_model_der['export_rate'] * $hecco_recv;

					    $estimated_kwh_available_for_credit = round($hecco_received_curtailed_kWh, 2);
					}
					$sum_estimated_kwh_available_for_credit+=$estimated_kwh_available_for_credit;
					$sum_estimated_kwh_available_for_credit = round($sum_estimated_kwh_available_for_credit, 2)
					?>
					<? echo number_format($estimated_kwh_available_for_credit, 2); ?>
    				</td> 
    				<td>$<?
					$estimated_energy_credits = round($pv_grid_model_der['export_rate'] * $estimated_kwh_available_for_credit, 2);

					echo ($estimated_energy_credits > 0) ? number_format($estimated_energy_credits, 2) : 0;
					$sum_estimated_energy_credits+=$estimated_energy_credits;
					?> 
    				</td>

    				<td> 
    <?
    $heco_final_bill = $hecco_deliverd_kwh * $current_electric_cost - $estimated_energy_credits;
    $sum_net_bill+=$heco_final_bill;
//                                                    if ($heco_final_bill < 25)
//                                                        $sum_net_bill = round($sum_net_bill + 25, 2);
//                                                    else
//                                                        $sum_net_bill = round($sum_net_bill + $heco_final_bill, 2);
//                                                    if ($heco_final_bill < 25) {
//                                                        $sum_lost_credit_value+=25 - $heco_final_bill;
    ?>
    <!--                                                    <span style="color:orange;">
    <? if ($heco_final_bill < 0) { ?>

							-$<?= str_replace('-', '', number_format($heco_final_bill, 2)); ?>*

    <? } else { ?>

							$<?= number_format($heco_final_bill, 2); ?>*

    <? } ?>

    					</span>    -->
    <? //} else {  ?>
    				    $<?= number_format($heco_final_bill, 2); ?>
    <? //}  ?>
    				</td>
    			    </tr>

<? } ?>
			</tbody>
                    </table>
                </div>
                <div>
		    <p class="table-bottom heading" style="margin-top: 15px;padding-left: 18px;">
			Estimated Annual  Totals: </p>

		    <table class="graphtable dataTable graphtable_one oness" style="border-top: 2px solid #000;">
			<tr class="altBg">
			    <td width="100px">&nbsp;&nbsp;&nbsp; </td>
			    <td width="70px"><? echo number_format(($sum_curr_energy), 2); ?> </td>
			    <td width="70px">$<? echo number_format((@$sum_curr_avg), 2); ?> </td>
<!--                                    <td width="60px"><? echo number_format((@$sum_solar / 12), 2); ?> </td>-->
			    <td width="130px"><? echo number_format(( $sum_energy_prod), 2); ?> </td>
			    <td width="120px"><? echo number_format(( $sum_estimated_pv_used_direct), 2); ?> </td>

			    <td width="120px">$<? echo number_format(( $sum_estimated_pv_used_direct_valuation), 2); ?> </td>
			    <td width="100px"><? echo number_format(( $sum_estimated_pv_available_battery), 2); ?> </td>
			    <td width="100px"><? echo number_format(( $sum_estimated_pv_used_battery), 2); ?> </td>
			    <td width="120px"><? echo number_format(($sum_hecco_received_curtailed_kWh), 2); ?> </td>
<!--                                <td width="100px">$<? echo number_format(($sum_heco_deliver_cost / 12), 2); ?> </td>-->
			    <td width="150px"><? echo number_format(( $sum_hecco_deliverd_kwh), 2); ?>  </td>
			    <td width="162px"><? echo number_format(( $sum_estimated_kwh_available_for_credit), 2); ?>  </td>

			    <td width="130px">$<? echo number_format(($sum_estimated_energy_credits), 2); ?> </td>

			    <td width="100px">$<? echo number_format(($sum_net_bill), 2); ?> </td>
			</tr>    

		    </table>
		</div>
                <div style="clear:both"></div>

                <div style="padding:10px 0; letter-spacing:normal;font-family: neo sans; text-align:left; 
                     margin-top:10px; border-top:0px solid #ffffff;" class="notesd">
                    * Alternate Energy Inc's energy production estimates are based on the National Renewable Energy Laboratory's (NREL) PVWattsTM calculator. It determines the energy production and cost
                    savings of grid-connected photovoltaic (PV) energy systems throughout the world. It allows homeowners, installers, manufacturers, and researchers to easily develop estimates of the performance
                    of hypothetical PV installations. The PVWatts calculator was developed by NREL's Electricity, Resources, and Building Systems Integration Center.

                </div>


		<!-- /graph section -->

	    </div>  
        </div> 

        <div class="wrap break">
            <div class="headerPan clearfix">
                <h1 class="fl">HESS System Analysis </h1>
                <img src="<?= base_url() ?>assets/pdfimages/logo.png" class="fr" />
            </div>
            <div class="clearfix">
                <div class="datePan"><strong>March 12, 2012 / Quote No. Quote No</strong>. 34432 / PV + H.E.S.S. 
                    Proposal Page <?=$page_no=$page_no+1?>					
                </div>


                <div class="clearfix">
		    <div>
			<h4 style="text-align:center; border-bottom:0; margin:30px 0 40px;">Solar Self Consumption</h4>
                        <p style="text-align:right; margin-right:130px;">Energy stored for later use </p>
                    </div>
                    <div class="graphchatTable">
                        <table width="100%">
                            <tr>
                                <td valign="top"><img src="<?= base_url() ?>assets/pdfimages/mwh.png" /></td>
                                <td>
                                    <table width="100%" cellspacing="0" cellpadding="0" border="0">
                                        <tr>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_one_o" style="height:40px;bottom: -10px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_one_o" style="height:50px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_one_o" style="height:60px;bottom: -10px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_one_o" style="height:40px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:30px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_one_o" style="height:30px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:50px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onetthree_o" style="height:20px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:60px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onetthree_o" style="height:20px;    bottom: -10px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:70px;bottom: -10px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onetthree_o" style="height:35px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:65px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onetthree_o" style="height:80px;    bottom: -10px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:30px;bottom: -10px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onetthree_o" style="height:100px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:20px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onetthree_o" style="height:120px; bottom:-10px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:20px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onetthree_o" style="height:100px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:40px;"></div>
                                                    </div>

                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onetthree_o" style="height:120px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:25px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefive_o" style="height:115px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:30px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefive_o" style="height:135px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:20px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefive_o" style="height:120px; margin-top:10px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:25px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefive_o" style="height:110px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:20px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefive_o" style="height:95px; margin-top:10px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:25px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefive_o" style="height:85px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:20px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefive_o" style="height:55px; margin-top:20px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:30px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefive_o" style="height:50px; margin-top:15px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:20px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefive_o" style="height:30px; margin-top:25px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:30px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:15px; margin-top:40px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:30px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:40px; margin-top:25px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:20px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:55px;bottom: -15px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:30px;bottom: -15px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:80px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:20px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:110px;"></div>
                                                        <div class="graphData graphData_onetow_o" style="height:10px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:110px;bottom:-10px"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>       
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:90px; bottom:-10px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:100px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>
                                            </td>    
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:90px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:80px; bottom:-10px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:65px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:50px; bottom:-15px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_onefour_o" style="height:40px; bottom:-5px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_one_o" style="height:45px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>
                                            </td>
                                            <td rowspan="" valign="bottom">
                                                <div class="td_center">
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_one_o" style="height:40px;"></div>
                                                    </div>
                                                    <div class="gph-divs">
                                                        <div class="graphData graphData_one_o" style="height:33px; bottom:-7px;"></div>
                                                    </div>
                                                    <div style="clear:both;"></div>
                                                </div>
                                            </td> 

                                        </tr>

                                        <tr>
                                            <td class="monthD_new monthD_newjul" style="border-left:1px solid #000;">5AM </td>
                                            <td class="monthD_new monthD_newjul">6AM </td>
                                            <td class="monthD_new monthD_newjul">7AM </td>
                                            <td class="monthD_new monthD_newjul">8AM </td>
                                            <td class="monthD_new monthD_newjul">9AM </td>
                                            <td class="monthD_new monthD_newjul">10AM </td>
                                            <td class="monthD_new monthD_newjul">11AM </td>
                                            <td class="monthD_new monthD_newjul">12PM </td>
                                            <td class="monthD_new monthD_newjul">1PM </td>
                                            <td class="monthD_new monthD_newjul">2PM </td>
                                            <td class="monthD_new monthD_newjul">3PM </td>
                                            <td class="monthD_new monthD_newjul">4PM </td>
                                            <td class="monthD_new monthD_newjul">5PM </td>
                                            <td class="monthD_new monthD_newjul">6PM </td>
                                            <td class="monthD_new monthD_newjul">7PM </td>
                                            <td class="monthD_new monthD_newjul">8PM </td>
                                            <td class="monthD_new monthD_newjul">9PM </td>
                                            <td class="monthD_new monthD_newjul">10PM </td>
                                            <td class="monthD_new monthD_newjul">11PM </td>
                                        </tr>
                                    </table>
                                </td>
                            </tr>
                            <tr>
                                <td></td>
                                <td></td>
                            </tr>
                        </table>

                        <div class="declaraton yrdiv_color">
                            <p style="padding-top:0">
                                <span><img src="<?= base_url() ?>assets/pdfimages/color-n/c1.png" /> </span> 
                                <span>HECO Delivered </span>&nbsp;
                                <span><img src="<?= base_url() ?>assets/pdfimages/color-n/c2.png" /> </span> 
                                <span>Est. PV Used - Direct </span>&nbsp;
                                <span><img src="<?= base_url() ?>assets/pdfimages/color-n/c3.png" /> </span>
                                <span>Battery Charging </span>&nbsp;
                                <span><img src="<?= base_url() ?>assets/pdfimages/color-n/c4.png" /> </span>
                                <span>Est. PV Used - Battery </span>&nbsp;
                                <span><img src="<?= base_url() ?>assets/pdfimages/color-n/c5.png" /> </span>
                                <span>PV Production </span>
                            </p>
                        </div>
                    </div>

                </div>



		<div class="clearfix">
		    <div class="fl" style="width:480px;">
			<h4>Load Profile Assumptions*</h4>
			<table class="dataTable blebcc" cellpadding="0" cellspacing="0">
			    <tr>
				<td>Daytime Load:</td><td class="rightalign"><?= @$current_usage_information['day_use']; ?>%</td>

			    </tr>
			    <tr class="altBg">
				<td>Nighttime Load:</td><td class="rightalign"><?= @$current_usage_information['night_use']; ?>%</td>
			    </tr>
			    <tr>
				<td>&nbsp; </td>
			    </tr>
			</table>

			<h4>System Specifications</h4>
			<table class="dataTable" cellpadding="0" cellspacing="0">
			    <tr>
				<td>PV System Size kW </td>
				<td align="right"><?= $proposal['system_size'] ?> </td>
			    </tr>
			    <tr class="altBg">
				<td>Inverter Size kW </td>
				<td align="right"><?= $inverter_size_kW ?> </td>
			    </tr>
			    <tr>
				<td>Max Storage Capacity kWh </td>
				<td align="right"><?= $hess_available_capacity ?></td>
			    </tr>
			    <tr class="altBg">
				<td>Daytime Load kWh (<?= @$current_usage_information['day_use']; ?>%,kWh)</td>
				<td align="right"><?= number_format(($sum_curr_energy / 365) * $pv_grid_model_der['day_use'] / 100,1) ?> </td>
			    </tr>
			    <tr>
				<td>PV Energy Required for HESS (kWh)</td>
				<td align="right"><?= $PV_Power_Required_for_HESS = number_format($hess_available_capacity + round(($sum_curr_energy / 365) * $pv_grid_model_der['day_use'] / 100), 2) ?> </td>
			    </tr>
			    <tr class="altBg">
				<td>Available kW from PV system </td>
				<td align="right"><?= $Available_kW_from_PV_system = number_format($sum_energy_prod / 365, 2) ?> </td>
			    </tr>
			    <tr>
				<td>% of HESS capacity supplied </td>
				<td align="right"><?= round(($Available_kW_from_PV_system / $PV_Power_Required_for_HESS) * 100) ?>%</td>
			    </tr>
			</table>

		    </div>

		    <div class="fr" style="width:472px;">
			<h4>Estimated Annual Breakdown*</h4>
			<table class="dataTable blebcc" cellpadding="0" cellspacing="0">
			    <tr>
				<td>Current Annual Energy Usage (kWh): </td>
				<td align="right"><?= $sum_curr_energy ?> </td>
			    </tr>
			    <tr class="altBg">
				<td>Current Annual Energy Bill:</td>
				<td align="right">$<?= @$sum_curr_avg ?>  </td>
			    </tr>
			    <tr>
				<td>Total Energy Production (kWh/year.): </td>
				<td align="right"><?= number_format($sum_energy_prod, 2) ?></td>
			    </tr>
			    <tr class="altBg">
				<td>Round Trip Efficiency (RTE) Battery </td>
				<td align="right">94% </td>
			    </tr>
			    <tr>
				<td>Estimated PV Used - Direct (kWh/year): </td>
				<td align="right"><?= $sum_estimated_pv_used_direct ?> </td>
			    </tr>
			    <tr class="altBg">
				<td>Estimated PV Used - Battery (kWh) </td>
				<td align="right"><?= number_format(($sum_estimated_pv_used_battery * 0.94), 2) ?> </td>
			    </tr>
			    <tr>
				<td>Heco Delivered (kWh/year): </td>
				<td align="right"><?= number_format($sum_hecco_deliverd_kwh, 2) ?> </td>
			    </tr>
			    <tr class="altBg">
				<td>Heco Received / Curtailed (kWh) </td>
				<td align="right"><?= round($sum_hecco_received_curtailed_kWh) ?> </td>
			    </tr>
			    <tr>
				<td>Estimated kWh Available for Credit </td>
				<td align="right"><?= number_format($sum_estimated_kwh_available_for_credit, 2) ?></td>
			    </tr>
			    <tr class="altBg">
				<td>Estimated Energy Credits @ $0.1507/kWh</td>
				<td align="right">$<?= number_format($sum_estimated_energy_credits, 2) ?></td>
			    </tr>
			    <tr>
				<td><strong>Total Annual Production Value:</strong> </td>
				<td align="right"><strong>$<?
					$total_annual_production_value = (($sum_estimated_pv_used_direct + ($sum_estimated_pv_used_battery * 0.94)) * $proposal['electriccost'] / 100) + $sum_estimated_energy_credits;
					echo number_format($total_annual_production_value, 2)
?></strong> </td>
			    </tr>
			    <tr class="altBg">
				<td>% of Bill Offset:</td>
				<td align="right"><?= round(($total_annual_production_value / $sum_curr_avg) * 100) ?>% </td>
			    </tr>
			    <tr>
				<td>% of Usage covered by PV (direct consumption): </td>
				<td align="right"><?= round(($sum_estimated_pv_used_direct / $sum_curr_energy) * 100) ?>% </td>
			    </tr>
			    <tr class="altBg">
				<td>% of Usage covered by Self-Consumption: PV </td>
				<td align="right"><?= round((($sum_estimated_pv_used_direct + ($sum_estimated_pv_used_battery * 0.94)) / $sum_curr_energy) * 100) ?>%</td>
			    </tr>
<!--			    <tr>
				<td>Used -Direct/ Battery Storage </td>
				<td align="right">&nbsp; </td>
			    </tr>-->
			</table>



		    </div>
		    <div style="clear:both;"></div>
		    <br />
		    <br />
		    <br />

                    <p class="margin_none" style="font-size:14px; font-family:neo sans; border-top:1px solid #000; padding-top:15px;">* Any example estimated PV energy production contained in this estimate are hypothetical based on the National Renewable Energy Laboratory's (NREL) PVWatts calculator.
                        Estimate PV production and battery storage values are provided for illustrative purposes only and should not be construed as predicted and exact energy production or stored
                        energy behavior. Hypothetical PV and battery performance results are simulated and have many inherent factors that may affect your overall system's performance. As your
                        system has not actually been installed and put into service, the results may have under or over compensated for any impact of certain assumptions and weather factors, such
                        as but not limited to your assumptions in daytime vs. nighttime loads and/or cloudy and rainy days. Any methods, techniques, or assumptions presented in this estimate are
                        for educational purposes only and are presented to assist you to make your own judgments on sizing your PV system (for which you are responsible). Any information or data
                        contained in this estimate is historical and provides no indication of future performance.</p>
		</div>    
	    </div>
	</div>

        <div class="wrap break">
            <div class="headerPan clearfix">
                <h1 class="fl">HESS System Investment & Benefits </h1>
                <img src="<?= base_url() ?>assets/pdfimages/logo.png" class="fr" />
            </div>
            <div class="clearfix">
                <div class="datePan"><strong>March 12, 2012 / Quote No. Quote No</strong>. 34432 / PV + H.E.S.S. Proposal Page <?=$page_no=$page_no+1?></div>

            </div>

<?php
$proposal_discount = 0;
if ($proposal['discount']) {
    $proposal_discount = $proposal['discount'];
}
$acharge_amount = 0;
if ($proposal['acharge']) {

    $acharge_amount = $proposal['acharge'];
}

$hawaii_tax_cal = (float) ((($proposal['price'] + $acharge_amount - $proposal_discount - $specialdiscount) * 4.712) / 104.712);
?>
            <div class="clearfix">
                <div class="fl" style="width:490px;">
                    <h4 style="border:none;">AEI's Premium PV System Cost </h4>
                    <div style="border:2px solid #000000; padding:10px 10px 20px;" class="clearfix">
                        <table class="taxbenefits taxbenefitsjul">
                            <tbody>
                                <tr>
                                    <td class="tdData">System Price:</td>
                                    <td align="right">$<? echo $cal = number_format($proposal['price'] - $hawaii_tax_cal, 2) ?> </td>
                                </tr>
                                <tr>
                                    <td class="tdData">General Excise Tax (4.712%): </td>
                                    <td align="right">$<?= number_format($hawaii_tax_cal, 2) ?> </td>
                                </tr>
                                <tr>
                                    <td class="tdData"><strong style="font-size:20px; font-family:neo sans; font-weight:bold;color:#71B644;">Total Payable: </strong></td>
                                    <td align="right"><strong style="font-size:20px; font-family:neo sans; font-weight:bold;color:#71B644;">$<?= number_format($price_net, 2) ?> </strong></td>
                                </tr>

                            </tbody>
                        </table>
                    </div>
                    <p>&nbsp; </p>

                    <h4>Basic Tax Benefits </h4>
                    <table class="dataTable aTablejul">
                        <tbody>
			    <?php
			    $k = $proposal['nos'];
			    $nom = $proposal['nom'];
			    if ($k)
				$mod = @$nom % $k;
			    $mod_temp = @$mod;
			    $sum_state_Tax = 0;
			    $sum_fedral_Tax = 0;
			    $k = ceil($proposal["system_size"] / 5);

			    $system_size_cal = $proposal["system_size"];
			    $ppw = $price_net / ($system_size_cal * 1000);
			    // if($mod!=0 && $nom>$k) {
			    $system_size = array();
			    for ($i = 1; $i <= $k; $i++) {

				if ($system_size_cal - 5 > 0) {
				    $system_size[$i] = 5;
				} else {
				    $system_size[$i] = $system_size_cal;
				}
				$system_size_cal = $system_size_cal - 5;
				/** if($proposal['module_type']==1){  
				  if($mod_temp>0){
				  $system_size[$i]=((($nom-$mod)/$k + 1)*255)/1000;
				  } else{
				  $system_size[$i]=((($nom-$mod)/$k)*255)/1000;
				  }
				  }else{
				  if($mod_temp>0){
				  $system_size[$i]=((($nom-$mod)/$k + 1)*225)/1000;
				  }else{
				  $system_size[$i]=((($nom-$mod)/$k)*225)/1000;
				  }
				  }
				  $mod_temp--; */
			    }
			    // }
			    $sumtax = 0;
			    for ($i = 1; $i <= $k; $i++) {
				$state_tax = ($system_size[$i] * 1000) * $ppw * .35;
				if ($state_tax > 5000) {
				    $state_tax = 5000;
				}
				$sum_state_Tax+=$state_tax;
				$sum_fedral_Tax +=($price_net / $k) * .3;
				$sumtax+= ($state_tax) + (($price_net / $k) * .3);
				$new_system_size = $system_size[$i];
				/* if($mod!=0 && $nom>$k ){
				  $new_system_size=$system_size[$i];

				  }else{
				  $new_system_size=$proposal['system_size']/$proposal['nos'];
				  } */
			    }
			    ?>

<?
$sumtax = 0;
$sum_state_Tax = 0;
$sum_fedral_Tax = 0;
$sum_state_tax = 0;
for ($i = 1; $i <= $k; $i++) {
    $state_tax = ($system_size[$i] * 1000) * $ppw * .35;
    if ($state_tax > 5000) {
	$state_tax = 5000;
    }
    $sum_state_Tax+=$state_tax;
    $shown_fedral_Tax = ($price_net / $k) * .3;
    $sum_fedral_Tax +=($price_net / $k) * .3;

    $sumtax+= ($state_tax) + (($price_net / $k) * .3);
    $sum_state_tax+=$state_tax;
    $new_system_size = $system_size[$i];
    /* if($mod!=0 && $nom>$k ){
      $new_system_size=$system_size[$i];

      }else{
      $new_system_size=$proposal['system_size']/$proposal['nos'];
      } */
    $class_bg = "";
    if ($i % 2 == 0) {
	$class_bg = ' class="altBg"';
	echo '<tr>
					<td >&nbsp;</td>
					<td >&nbsp;</td>
				    </tr>';
    }
    ?>
                                <tr>
                                    <td nowrap="nowrap"><strong>System #<?= $i ?> (<?= number_format($new_system_size, 2) ?> kW):</strong></td>
                                    <td class="rightalign"><strong></strong></td>
                                </tr>
                                <tr class="altBg">    
                                    <td>U.S. Federal Tax Credit 30%*:</td><td class="rightalign">($<?= number_format($shown_fedral_Tax, 2) ?>)</td>
                                </tr>
                                <tr >
                                    <td>Hawaii State Tax Credit 35%*:</td><td class="rightalign">($<?= number_format($state_tax, 2) ?>)</td>
                                </tr>   

					<? } ?>

                        </tbody>
                    </table>
                    <p>&nbsp; </p>
                    <div style="border:2px solid #000000; padding:10px;">
                        <table class="dataTable blebcc">
                            <tbody>
                                <tr>
                                    <td>Total Investment HESS </td>
                                    <td class="rightalign">$<?= $price_net ?> </td>
                                </tr>
                                <tr class="altBg">
                                    <td>U.S. Federal Tax Credit 30%: </td>
                                    <td class="rightalign">$<?= $sum_fedral_Tax ?> </td>
                                </tr>
                                <tr>	
                                    <td>Hawaii State Tax Credit 35%*: (based on value of PV system)</td>
                                    <td class="rightalign">$<?= round($sum_state_tax) ?> </td>
                                </tr>
                                <tr class="altBg">    
                                    <td>Net System Investment (Less Tax Credit) </td>
                                    <td class="rightalign">$<?= $net_system_investment = round($price_net - $sum_fedral_Tax - $sum_state_tax) ?> </td>
                                </tr>
                                <tr>    
                                    <td>Simple Payback (Less Tax Credits): </td>
                                    <td class="rightalign"><?= number_format(($net_system_investment / $total_annual_production_value), 2) ?> </td>
                                </tr>
                                <tr class="altBg">    
                                    <td>Return On Investment (ROI):</td>
                                    <td class="rightalign"><?= number_format(($total_annual_production_value /$net_system_investment )*100, 2) ?></td>
                                </tr>
                                <tr>    
                                    <td>Cost/watt: </td>
                                    <td class="rightalign">$
<?
if ($proposal['module_type'] == 1 || $proposal['module_type'] == 96 || $proposal['module_type'] == 97)
    echo number_format($price_net / ($proposal['nom'] * 255), 2);
if ($proposal['module_type'] == 2)
    echo number_format($price_net / ($proposal['nom'] * 225), 2);
if ($proposal['module_type'] == 70 || $proposal['module_type'] == 205)
    echo number_format($price_net / ($proposal['nom'] * 260), 2);
if ($proposal['module_type'] == 204)
    echo number_format($price_net / ($proposal['nom'] * 290), 2);
if ($proposal['module_type'] == 206 || $proposal['module_type'] == 216 || $proposal['module_type'] == 217)
    echo number_format($price_net / ($proposal['nom'] * 265), 2);
?> 
<? if ($proposal["module_type"] == 232) echo number_format($price_net / ($proposal['nom'] * 270), 2); ?> 
<?
if ($proposal['module_type'] == 231)
    echo number_format($price_net / ($proposal['nom'] * 275), 2);
if ($proposal['module_type'] == 254)
    echo number_format($price_net / ($proposal['nom'] * 265), 2);
if ($proposal['module_type'] == 297)
    echo number_format($price_net / ($proposal['nom'] * 280), 2);
?>
                                    </td>
                                </tr>
<!--                                <tr >    
                                    <td><strong>Cost of Energy battery price/(energy x dod x cycles) </strong></td>
                                    <td>&nbsp; </td>
                                </tr>-->
                                <tr class="altBg" >    
                                    <td>Cost / kWh </td>
                                    <td class="rightalign">
	<?
	$cost_kwh = 0;
	if ($proposal['invertert'] == 249) {
	    $cost_kwh = $net_system_investment / ((7000) * (0.8) * (7.77));
	} else if ($proposal['invertert'] == 241) {
	    $cost_kwh = $net_system_investment / ((7000) * (0.8) * (11.65));
	} else if ($proposal['invertert'] == 243) {
	    $cost_kwh = $net_system_investment / ((7000) * (0.8) * (15.54));
	} else if ($proposal['invertert'] == 298) {
	    $cost_kwh = $net_system_investment / ((3650) * (1) * (6.4));
	} else if ($proposal['invertert'] == 299) {
	    $cost_kwh = $net_system_investment / ((3650) * (1) * (12.8));
	}
	echo number_format($cost_kwh, 2);
	?></td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>

                <div class="fr" style="width:472px;">
                    <div class="greenbox greenbox_new">
                        <img src="<?= base_url() ?>assets/pdfimages/inve_graph.png" />
                    </div>
                    <br />
                    <br />
                    <div style="padding-top:10px; letter-spacing:normal;font-family:neo sans;text-align:left; margin-top:0px; 
                         border-top:1px solid #000;" class="notesd">
                        * Any example estimated PV energy production contained in this estimate are
                        hypothetical based on the National Renewable Energy Laboratory's (NREL) PVWatts
                        calculator. Estimate PV production and battery storage values are provided for
                        illustrative purposes only and should not be construed as predicted and exact energy
                        production or stored energy behavior. Hypothetical PV and battery performance
                        results are simulated and have many inherent factors that may affect your overall
                        system's performance. As your system has not actually been installed and put into
                        service, the results may have under or over compensated for any impact of certain
                        assumptions and weather factors, such as but not limited to your assumptions in
                        daytime vs. nighttime loads and/or cloudy and rainy days. Any methods, techniques,
                        or assumptions presented in this estimate are for educational purposes only and
                        are presented to assist you to make your own judgments on sizing your PV system
                        (for which you are responsible). Any information or data contained in this estimate is
                        historical and provides no indication of future performance.
                    </div>
                </div>
            </div>    
        </div>
<?
$page_hide = false;
if ($proposal['invertert'] == 298 || $proposal['invertert'] == 299) {
    $page_hide = true;
    $page_no = $page_no-2;
    
}
?>
        <div class="wrap break" style="display: <?= ($page_hide) ? 'none' : 'block' ?>">
            <div class="headerPan clearfix">
                <h1 class="fl">H.E.S.S. Summary </h1>
                <img src="<?= base_url() ?>assets/pdfimages/logo.png" class="fr" />
            </div>
            <div class="clearfix">
                <div class="datePan"><strong>March 12, 2012 / Quote No. Quote No</strong>. 34432 / PV + H.E.S.S. Proposal Page <?=$page_no =$page_no+1;?>
		</div>

            </div>

            <div class="clearfix">
                <div class="fl" style="width:480px;">
                    <h4>Type of Modules: Mitsubishi Electric</h4>
                    <p class="class">
                        <img class="fl" src="<?= base_url() ?>assets/pdfimages/Mitsubishi-Electric-logo.png">
                            Mitsubishi Electric is a global leader in providing superior-quality photovoltaic modules to businesses and residences around the world. With more than 37 years experience in the photovoltaic industry, we manufacture products that are designed and built for optimal efficiency and reliability. With a name like Mitsubishi Electric, you can be sure you're getting the best.
                    </p>
                    <ul class="module">                    
                        <li><strong>Module Type:</strong> <?= $qoute_mws[$proposal['module_type']] ?></li>                    
                        <li><strong>Manufacturer Warranty:</strong> 25 Years</li>
                    </ul>

                </div>
                <div class="fr" style="width:472px;">
                    <div class="rgt-img"> 
                        <img src="<?= base_url() ?>assets/pdfimages/Mitsubishi-Electric2.png" alt=""/> 
                    </div>
                </div>
                <div style="clear:both"></div>
                <p>&nbsp;</p>
                <div style="clear:left; display:block; height:5px; background: url('<?=base_url()?>assets/images/energy-dashedlines.png') repeat-x;">&nbsp;</div>

                <div class="fl" style="width:480px;">
                    <p>&nbsp; </p>
                    <h4>Type of Storage: <?= @$qoute_iws[$proposal['invertert']] ?></h4>
                    <p>
                        <img class="fl" src="<?= base_url() ?>assets/pdfimages/powerwall.png" style="width: 222px;
                             padding: 10px 10px 10px 0;">
                            Powerwall is a home battery
                            that charges using electricity
                            generated from solar panels, or
                            when utility rates are low, and powers your home in the evening.
                            It also fortifi es your home against power outages by providing a
                            backup electricity supply. Automated, compact and simple to install,
                            Powerwall offers independence from the utility grid and the security
                            of an emergency backup.
                    </p>
                    <ul class="module">					
                        <li><strong>Technology:</strong> Wall mounted, lithium ion battery </li> 					
                        <li><strong>Storage Sizes Available:</strong> 6.4 kWh (daily cycling) </li>
                        <li><strong>Depth of Discharge:</strong> 100% </li> 					
                        <li><strong>Effi ciency: </strong> 92.5 round-trip DC effi ciency </li>
                        <li><strong>Manufacturer Warranty: </strong>10 Years </li>
                        <li><strong>&nbsp;</strong></li>
                    </ul>

                </div>

                <div class="fr" style="width:472px;">
                    <div class="rgt-img" style="width:380px;">
                        <img style="padding-top:30px;" src="<?= base_url() ?>assets/pdfimages/teslr.png" alt="">
                    </div>
                </div>

                <div style="clear:left; display:block; height:5px; background: url('<?=base_url()?>assets/images/energy-dashedlines.png') repeat-x;">&nbsp;</div>

                <div class="clearfix cl" style="font-family:neo sans; padding:29px 0;">
                    <div style="width:310px;" class="fl">
                        <h3>Module Racking System</h3>
                        <div class="catlt clearfix">
                            <img class="fr" src="<?= base_url() ?>assets/pdfimages/Module-Racking-System.jpg">
                                IronRidge Solar Roof Racking accommodate some of the longest spans in the industry,
                                reducing the number of roof attachments and saving time and money. <br class="cl">
				    </div>
				    </div>		
				    <div style="width:310px; margin-left:20px;" class="fl">
					<h3>Roof Flashing</h3>
					<div class="catlt clearfix">
					    <div class="catlt clearfix"><img class="fr" src="<?= base_url() ?>assets/pdfimages/Roof-Flashing.jpg">Alternate Energy Inc. custom panel roof mount and fl ashing systems are 
						    leak tested to an equivalent pressure of 70 feet of standing water so you can be 
						    sure your roof penetrations remain watertight under the most adverse conditions.
					    </div>				
					</div>
				    </div>
				    <div style="width:310px; margin-left:20px;" class="fl">

					<h3>Hardware &amp; Accessories</h3>

					<div class="catlt clearfix">
					    <img class="fr" src="http://aeihawaii.com/scheduler/assets/pdfimages/ss-hardware-accessories.jpg">
						The hardware like nuts and bolts used in our installations are all stainless 
						steel. This is to ensure a long lasting installation and foundation for 
						your photovoltaic system 
					</div>
				    </div>	
				    </div>


				    </div>    
				    </div>

				    <div class="wrap break" style="display: <?= ($page_hide) ? 'none' : 'block' ?>">
					<div class="headerPan clearfix">
					    <h1 class="fl">H.E.S.S. Summary </h1>
					    <img src="<?= base_url() ?>assets/pdfimages/logo.png" class="fr" />
					</div>
					<div class="clearfix">
					    <div class="datePan"><strong>March 12, 2012 / Quote No. Quote No</strong>. 34432 / PV + H.E.S.S. Proposal Page  <?=$page_no =$page_no+1;?></div>

					</div>

					<div class="clearfix">
					    <div class="fl" style="width:480px;">
						<h4>Tesla Powerwall</h4>
						<div class="testla-hding"> 
						    <img src="<?= base_url() ?>assets/pdfimages/Tesla-Powerwall.png" alt=""/>
						    <p>The Home Energy Storage Solution (HESS) is an
							intelligent distributed energy storage system
							that captures solar power and delivers it when
							needed most. It combines batteries, power
							electronics, and multiple energy inputs in a
							UL-certified appliance controlled by software
							running in the cloud. HESS is a utility-grade product designed for the
							consumer market.</p>
						    <ul class="module">
							<li><strong>Model Types:</strong> HESS 7.77 kWh, HESS 15.54 kWh</li>
							<li><strong>Manufacturer Warranty:</strong> 10 Years</li>
						    </ul>

						</div>

						<h4>H.E.S.S. Features</h4>
						<div class="feather"> 
						    <img src="<?= base_url() ?>assets/pdfimages/Solar-Optimization.png" alt=""/>
						    <h5><strong>Solar Optimization</strong></h5>
						    <p>Keep the power you create! If your home is
							generating more solar power than it needs, the
							excess is stored for future use, instead of buying costly power
							from the grid.</p>
						</div>
						<div class="feather"> 
						    <img src="<?= base_url() ?>assets/pdfimages/Solar-Optimization.png" alt=""/>
						    <h5><strong>Emergency Back Up Power</strong></h5>
						    <p>Peace of mind knowing you'll have power when the grid goes down during the hurricane season.</p>
						</div>
						<div class="feather"> 
						    <img src="<?= base_url() ?>assets/pdfimages/Solar-Optimization.png" alt=""/>
						    <h5><strong>Leading Lithium-ion Technology</strong></h5>
						    <p>Lithium-ion chemistry designed for long life cycles up to 20 years. Comes with a 10 Year 
							Manufacturer Warranty from Sunverge.</p>
						</div>
						<div class="feather"> 
						    <img src="<?= base_url() ?>assets/pdfimages//Solar-Optimization.png" alt=""/>
						    <h5><strong>Reduced Cost Per kWh</strong></h5>
						    <p>Exercise your energy independence by converting your home into its own utility and fix your costs 
							for 20 years.</p>
						</div>
						<div class="feather"> 
						    <img src="<?= base_url() ?>assets/pdfimages/Solar-Optimization.png" alt=""/>
						    <h5><strong>Add Capacity In Oversaturated Circuits</strong></h5>
						    <p>Avoid lengthy utility approval delays and keep the kWh in your control.</p>
						</div>

						<div class="feather"> 
						    <img src="<?= base_url() ?>assets/pdfimages/Solar-Optimization.png" alt=""/>
						    <h5><strong>Bi-Directional Inverter Features</strong></h5>
						    <p>Inverter interfaces with various power sources such as battery storage, photovoltaic panels and 
							the grid with an option for non-export.</p>
						</div>
					    </div>

					    <div class="fr" style="width:472px;">
						<div class="rgt-img">
						    <img src="<?= base_url() ?>assets/pdfimages/teslr1.png" alt=""/>
						</div>
					    </div>
					</div>    
				    </div>



<?
$page_hide = false;
if ($proposal['invertert'] == 249 || $proposal['invertert'] == 241 || $proposal['invertert'] == 242) {
    $page_hide = true;
    $page_no = $page_no-2;
}
?>
				    <div class="wrap break" style="display: <?= ($page_hide) ? 'none' : 'block' ?>">
					<div class="headerPan clearfix">
					    <h1 class="fl">H.E.S.S. Summary </h1>
					    <img src="<?= base_url() ?>assets/pdfimages/logo.png" class="fr" />
					</div>
					<div class="clearfix">
					    <div class="datePan"><strong>March 12, 2012 / Quote No. Quote No</strong>. 34432 / PV + H.E.S.S. Proposal Page <?= $page_no = $page_no + 1 ?></div>

					</div>

					<div class="clearfix">
					    <div class="fl" style="width:480px;">
						<h4>Type of Modules: Mitsubishi Electric</h4>
						<p class="class">
						    <img class="fl" src="<?= base_url() ?>assets/pdfimages/Mitsubishi-Electric-logo.png" style="width: 175px;margin-top: -6px;">
							Mitsubishi Electric is a global leader in providing superior-quality photovoltaic modules to businesses and residences around the world. With more than 37 years experience in the photovoltaic industry, we manufacture products that are designed and built for optimal efficiency and reliability. With a name like Mitsubishi Electric, you can be sure you're getting the best.
						</p>
						<ul class="module">                    
						    <li><strong>Module Type:</strong> <?= $qoute_mws[$proposal['module_type']] ?></li>                    
						    <li><strong>Manufacturer Warranty:</strong> 25 Years</li>
						</ul>

					    </div>
					    <div class="fr" style="width:472px;">
						<div class="rgt-img"> 
						    <img src="<?= base_url() ?>assets/pdfimages/Mitsubishi-Electric2.png" alt=""/> 
						</div>
					    </div>
					    <div style="clear:both"></div>
					    <p>&nbsp;</p>
					    <hr class="dash">


						<div class="fl" style="width:480px;">
						    <p>&nbsp; </p>
						    <h4>Type of Storage: <?= @$qoute_iws[$proposal['invertert']] ?></h4>
						    <p>
							<img class="fl" src="<?= base_url() ?>assets/pdfimages/logo.png" style="width: 222px;
							     padding: 5px 10px 2px 0;">
							    The Home Energy Storage Solution
							    (HESS) is an intelligent distributed
							    energy storage system that captures
							    solar power and delivers it when
							    needed most. It combines batteries, power electronics, and multiple
							    energy inputs in a UL-certifi ed appliance controlled by software
							    running in the cloud. HESS is a utility-grade product designed for the
							    consumer market.
						    </p>
						    <ul class="module">					
							<li><strong>Battery Type: </strong> Li-Ion: NiMnCo, 3.7 V, 75 Ah </li> 					
							<li><strong>Storage Sizes Available: </strong> 7.77 kWh, 15.52 kWh </li>
							<li><strong>Cycle Life (80% DOD): </strong> 4000-7000 Cycles </li>
							<li><strong>Manufacturer Warranty: </strong> 10 Years </li>
							<li><strong>&nbsp;</strong></li>
						    </ul>

						</div>

						<div class="fr" style="width:472px;">
						    <div class="rgt-img" style="width:385px;">
							<img style="padding-top:30px;" src="<?= base_url() ?>assets/pdfimages/Sunverge.png" alt="">
						    </div>
						</div>

						<div style="clear:left; display:block; height:5px; background: url('<?=base_url()?>assets/images/energy-dashedlines.png') repeat-x;">&nbsp;</div>

						<div class="clearfix cl" style="font-family:neo sans; padding:29px 0;">
						    <div style="width:310px;" class="fl">
							<h3>Module Racking System</h3>
							<div class="catlt clearfix">
							    <img class="fr" src="<?= base_url() ?>assets/pdfimages/Module-Racking-System.jpg">
								IronRidge Solar Roof Racking accommodate some of the longest spans in the industry,
								reducing the number of roof attachments and saving time and money. <br class="cl">
								    </div>
								    </div>		
								    <div style="width:310px; margin-left:20px;" class="fl">
									<h3>Roof Flashing</h3>
									<div class="catlt clearfix">
									    <div class="catlt clearfix"><img class="fr" src="<?= base_url() ?>assets/pdfimages/Roof-Flashing.jpg">Alternate Energy Inc. custom panel roof mount and fl ashing systems are 
										    leak tested to an equivalent pressure of 70 feet of standing water so you can be 
										    sure your roof penetrations remain watertight under the most adverse conditions.
									    </div>				
									</div>
								    </div>
								    <div style="width:310px; margin-left:20px;" class="fl">

									<h3>Hardware &amp; Accessories</h3>

									<div class="catlt clearfix">
									    <img class="fr" src="http://aeihawaii.com/scheduler/assets/pdfimages/ss-hardware-accessories.jpg">
										The hardware like nuts and bolts used in our installations are all stainless 
										steel. This is to ensure a long lasting installation and foundation for 
										your photovoltaic system 
									</div>
								    </div>	
								    </div>


								    </div>    
								    </div>

								    <!----------------page 10------------------------->

						<div class="wrap break" style="display: <?= ($page_hide) ? 'none' : 'block' ?>">
									<div class="headerPan clearfix">
									    <h1 class="fl">H.E.S.S. Summary </h1>
									    <img src="<?= base_url() ?>assets/pdfimages/logo.png" class="fr" />
									</div>
									<div class="clearfix">
									    <div class="datePan"><strong>March 12, 2012 / Quote No. Quote No</strong>. 34432 / PV + H.E.S.S. Proposal Page <?= $page_no = $page_no + 1 ?></div>

									</div>

									<div class="clearfix">
									    <div class="fl" style="width:480px;">
										<h4>Tesla Powerwall</h4>
										<div class="testla-hding"> 
										    <img src="<?= base_url() ?>assets/pdfimages/Tesla-Powerwall.png" alt=""/>
										    <p>The Home Energy Storage Solution (HESS) is an
											intelligent distributed energy storage system
											that captures solar power and delivers it when
											needed most. It combines batteries, power
											electronics, and multiple energy inputs in a
											UL-certified appliance controlled by software
											running in the cloud. HESS is a utility-grade product designed for the
											consumer market.</p>
										    <ul class="module">
											<li><strong>Model Types:</strong> HESS 7.77 kWh, HESS 15.54 kWh </li>
											<li><strong><strong>Manufacturer Warranty:</strong> 10 Years </li>
										    </ul>

										</div>

										<h4>H.E.S.S. Features</h4>
										<div class="feather"> 
										    <img src="<?= base_url() ?>assets/pdfimages/Solar-Optimization.png" alt=""/>
										    <h5><strong>Solar Optimization</strong></h5>
										    <p>Keep the power you create! If your home is
											generating more solar power than it needs, the
											excess is stored for future use, instead of buying costly power
											from the grid.</p>
										</div>
										<div class="feather"> 
										    <img src="<?= base_url() ?>assets/pdfimages/Solar-Optimization.png" alt=""/>
										    <h5><strong>Emergency Back Up Power</strong></h5>
										    <p>Peace of mind knowing you'll have power when the grid goes down during the hurricane season.</p>
										</div>
										<div class="feather"> 
										    <img src="<?= base_url() ?>assets/pdfimages/Solar-Optimization.png" alt=""/>
										    <h5><strong>Leading Lithium-ion Technology</strong></h5>
										    <p>Lithium-ion chemistry designed for long life cycles up to 20 years. Comes with a 10 Year 
											Manufacturer Warranty from Sunverge.</p>
										</div>
										<div class="feather"> 
										    <img src="<?= base_url() ?>assets/pdfimages//Solar-Optimization.png" alt=""/>
										    <h5><strong>Reduced Cost Per kWh</strong></h5>
										    <p>Exercise your energy independence by converting your home into its own utility and fix your costs 
											for 20 years.</p>
										</div>
										<div class="feather"> 
										    <img src="<?= base_url() ?>assets/pdfimages/Solar-Optimization.png" alt=""/>
										    <h5><strong>Add Capacity In Oversaturated Circuits</strong></h5>
										    <p>Avoid lengthy utility approval delays and keep the kWh in your control.</p>
										</div>
										<div class="feather"> 
										    <img src="<?= base_url() ?>assets/pdfimages/Solar-Optimization.png" alt=""/>
										    <h5><strong>Bi-Directional Inverter Features</strong></h5>
										    <p>Inverter interfaces with various power sources such as battery storage, photovoltaic panels and 
											the grid with an option for non-export.</p>
										</div>
									    </div>

									    <div class="fr" style="width:472px;">
										<div class="rgt-img rgt-imgs">
										    <img src="<?= base_url() ?>assets/pdfimages/Sunverge-SIS.png" alt=""/>
										</div>
									    </div>
									</div>    
								    </div>

								    <div class="wrap break">
									<div class="headerPan clearfix">
									    <h1 class="fl" style="color:#ffffff;">Residential Photovoltaic System</h1>
									    <img src="<?= base_url() ?>assets/pdfimages/logo.png" class="fr" />
									</div>
									<div class="clearfix">
									    <div class="datePan"><strong><?= date("F j, Y", strtotime($proposal['created'])); ?> / Quote No. <?= $proposal['id'] ?></strong> / PV + H.E.S.S. Proposal Page <?= $page_no = $page_no + 1 ?></div>

									</div>

									<h5>Final Analysis</h5>
									<table class="threecolumn">
									    <tr>
										<td width="30%" valign="top">
										    <h4>Your Solar Future </h4>
										    <p>
											What can you be sure of in times like this?
											You can be sure that your PV system will
											pay for itself while saving you money. As
											an investment property your PV system
											will yield a steady return year after year
											regardless of what the economy is doing,
											protecting your household from rate hikes.
										    </p>
										    <br />
										    <br />
										    <br />
										    <img src="<?= base_url() ?>assets/pdfimages/text-img.png" alt=""/>


										</td>
										<td width="5%">&nbsp; </td>
										<td width="30%">
										    <h4>Assured Warranty </h4>
										    <p>When you choose AEI, you get more
											then a well trained and professional
											staff. You also get AEI's thirty years of
											proven reliability, outstanding customer
											support and the assurance of our 10-
											year guarantee. AEI warrants parts
											and labor against defects in material or
											workmanship for a period of ten years
											from the date of original purchase, and
											agrees to repair or, at the company's
											option, replace a defective product
											without charge for either replacement
											parts or labor during such time.</p>
										    <p>Workmanship warranty covers any type
											of roof damage, roof leaks, or damage
											caused by roof leaks.</p>
										</td>
										<td width="5%">&nbsp; </td>
										<td width="30%" valign="top">
										    <p>
											Mitsubishi Electric warrants the power
											output of their PV panels for twenty-five
											years. The power output degradation
											will not fall under 80% of the designated
											minimum power output.
										    </p>
										    <p>Our Home Energy Storage Solution (HESS)
											has a manufacture warranty of 10 years.</p>

										    <h4>Conclusion</h4>
										    <p class="clearfix;">
											Thank you for the opportunity to present
											you with a proposal for your grid-tied solar
											electric system. Alternate Energy Inc. is
											delighted to be working with you. Please
											let us know what we can do to win your
											business.
										    </p>


										</td>


									    </tr>
									</table>
								    </div>


								    <div class="wrap break">
									<div class="headerPan clearfix" style="margin-bottom:4px!important;">
									    <h1 class="fl">Purchase Agreement </h1>
									    <img src="<?= base_url() ?>assets/pdfimages/logo.png" class="fr" />
									</div>
									<div class="clearfix">
									    <div class="datePan"><strong><?= date("F j, Y", strtotime($proposal['created'])); ?> / Job No.</strong> <?= $proposal['id'] ?></div>

									</div>


									<div class="clearfix">
									    <div class="fl" style="width:480px;">
										<h4>Customer Details</h4>
										<table class="dataTable blebcc">
										    <tr>
											<td>
											    Name
											</td>
											<td class="rightalign"><?= $cust_name; ?></td>
										    </tr>
										    <tr class="altBg">
											<td>
											    Street Address
											</td>    
											<td class="rightalign"><?= $proposal['address'] ?></td>
										    </tr>
										    <tr>
											<td>
											    City, Zip Code, State
											</td>    
											<td class="rightalign"><?= $proposal['city'] ?>, <?= $proposal['zip'] ?>, <?= $proposal['state'] ?></td>
										    </tr>
										    <tr class="altBg">    
											<td>Property Type</td><td class="rightalign"><?= $property_type_name ?></td>
										    </tr>
										    <tr >
											<td colspan="2">
											    Primary Phone ,Secondary Phone:
											    <div style="float:right;">
<?php
$init = &get_instance();
$new_parray = array();
if ($proposal['phone']) {
    $new_parray[] = $init->formatPhoneNumber($proposal['phone']);
} if ($proposal['sphone']) {
    $new_parray[] = $init->formatPhoneNumber($proposal['phone']);
}
echo @implode(",", $new_parray);
?>
											    </div>
											</td>
										    </tr>
										    <tr class="altBg">
											<td>
											    Email
											</td>
											<td class="rightalign"><?= $proposal['email'] ?></td>
										    </tr>
<? if (isset($proposal['home_owner_assoc_name']) && $proposal['home_owner_assoc_name'] != "") { ?>
    										    <tr>
    											<td>  Home Owners Assocation</td>
    											<td class="rightalign"><?= @$proposal['home_owner_assoc_name'] ?></td>
    										    </tr>
<? } ?>
										</table>

										<h4 style="margin-top:20px;">H.E.S.S. Specifications</h4>
										<table class="dataTable blebcc">
										    <tr >
											<td >System Size (Storage Capacity):</td>
											<td class="rightalign"><?= @$qoute_iws[$proposal['invertert']] ?></td>
										    </tr>
										    <tr class="altBg">
											<td>PV System Size:</td>
											<td class="rightalign"><?= $proposal['system_size'] ?> kW </td>
										    </tr>
										    <tr >	
											<td>Module Type:</td>
											<td class="rightalign"><?= $qoute_mws[$proposal['module_type']] ?> </td>
										    </tr>
										    <tr class="altBg">    
											<td>Number of Modules: </td>
											<td class="rightalign"><?= $proposal['nom'] ?> </td>
										    </tr>
										    <tr>    
											<td>Inverter Type: </td>
											<td class="rightalign"><?if($proposal['invertert'] == 298 || $proposal['invertert']==299){
					echo 'SOLAREDGE SE7600A HYBRID INVERTER';
				 }else if($proposal['invertert'] ==241 || $proposal['invertert']==242 || $proposal['invertert']==243 || $proposal['invertert']==249){
					echo 'SchneiderXW6848';
				} ?>	</td>
										    </tr>
										    <tr class="altBg">    
											<td>Number of Inverters: </td>
											<td class="rightalign" nowrap="nowrap"><?= $proposal['se_inverter'] ?> </td>
										    </tr>
										    <tr>    
											<td>Roof Type:</td><td class="rightalign"><?= $qoute_kra[$proposal['roof_type']] ?></td>
										    </tr>
<? if (trim(@$proposal['add_requirement']) && trim($proposal['addwork_desc']) == "") { ?>
    										    <tr>
    											<td colspan="2">Additional Requirements: <?= @$proposal['add_requirement'] ?></td>
    										    </tr>
<? } ?>

<? if ($proposal['addwork_desc'] != "" && trim(@$proposal['add_requirement'])) { ?>
    										    <tr class="altBg">
    											<td colspan="2">Additional Requirements: <?= @$proposal['add_requirement'] ?></td>
    										    </tr>
    										    <tr>
    											<td colspan="2">Additional Work Description: <?= @$proposal['addwork_desc'] ?></td>
    										    </tr>
<? } ?>
<? if ($proposal['addwork_desc'] != "") { ?>
    										    <tr >
    											<td colspan="2">Additional Work Description: <?= @$proposal['addwork_desc'] ?></td>
    										    </tr>
<? } ?>
										</table>
									    </div>
									    <div class="fr" style="width:472px;">
										<div class="declaraton">AEI's Premium PV System Cost</div>
										<div style="border:2px solid #000000; padding:10px; margin-bottom:15px;" class="clearfix">
										    <table class="taxbenefits">
											<tr>
											    <td>&nbsp; </td>
											</tr>
											<tr>
											    <td colspan="2" style="font-size:14px;font-family:neo sans light;">PRICE SUMMARY</td>
											</tr>
											<tr>
											    <td class="tdData">
												<span class="dataLft">System Price: </span>
												<span class="dataRgt txtright">$<? echo $cal = number_format(($proposal['price'] - $hawaii_tax_cal), 2) ?></span>
												<div class="cl"></div>
											    </td>
											</tr>


											<? if ($proposal['aei_specials'] == 13) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft" style="font-family:neo sans;">Friends & Family Incentive:</span>
    												<span class="dataRgt txtright" style="font-family:neo sans;">(<? echo "$" . number_format($specialdiscount, 2); ?>)</span>
    												<div class="cl"></div>
    											    </td>
    											</tr>

<? } ?>
											<?php if ($proposal['acharge']) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft">Addtional Cost:</span>
    												<span class="dataRgt txtright">$<?= number_format(@($proposal['acharge']), 2) ?></span>
    												<div class="cl"></div>
    											    </td>
    											</tr>
<? } ?>
<?php if (@$proposal['aei_specials'] > 0 && $proposal['aei_specials'] < 6) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft"><? if (@$proposal['id'] == 2632) { ?> AEI Special<? } else { ?>Solar Edge Special<? } ?>:</span>
    												<span class="dataRgt txtright"><?= @$trade_option[$proposal['aei_specials']] ?></span>
    												<div class="cl"></div>
    											    </td>
    											</tr>
<? } ?>
<? if ($proposal['aei_specials'] == 6 && $proposal['proposal_pid'] > 3820 && $proposal['module_type'] == 96) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft" style="font-family:neo sans;">AEI Special(Invest For Less):</span>
    												<span class="dataRgt txtright" style="font-family:neo sans;"><?php
    if ($proposal["aei_specials"] == 6 && $proposal["module_type"] == 96 && $proposal["proposal_pid"] > 3820) {
	echo "($" . number_format($discount_special, 2) . ")";
    }
    ?></span>
    												<div class="cl"></div>
    											    </td>
    											</tr>

<? } ?>
											<? if ($proposal['aei_specials'] > 71) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft" style="font-family:neo sans;"><?= $aei_special_array[$special_dis_aei]["special_name"]; ?>:</span>
    												<span class="dataRgt txtright" style="font-family:neo sans;">(<? echo "$" . number_format($specialdiscount, 2); ?>)</span>
    												<div class="cl"></div>
    											    </td>
    											</tr>
<? } ?>
<? if ($proposal['aei_specials'] == 9) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft" style="font-family:neo sans;">AEI Special(20th Anniv. Special):</span>
    												<span class="dataRgt txtright" style="font-family:neo sans;">(<? echo "$" . number_format($specialdiscount, 2); ?>)</span>
    												<div class="cl"></div>
    											    </td>
    											</tr>

<? } ?>

											<? if ($proposal['aei_specials'] == 11) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft" style="font-family:neo sans;">20th Anniversary Clearance Sale:</span>
    												<span class="dataRgt txtright" style="font-family:neo sans;">(<? echo "$" . number_format($specialdiscount, 2); ?>)</span>
    												<div class="cl"></div>
    											    </td>
    											</tr>

<? } ?>
											<? if ($proposal['aei_specials'] == 8 && ($proposal['proposal_pid'] > 3820 || $proposal['proposal_pid'] == 3797 ) && $proposal['module_type'] == 70) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft" style="font-family:neo sans;">AEI Special:</span>
    												<span class="dataRgt txtright" style="font-family:neo sans;">Enphase M250 Launch Special</span>
    												<div class="cl"></div>
    											    </td>
    											</tr>

<? } ?>

											<? if ($proposal['aei_specials'] == 21) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft" style="font-family:neo sans;">2014 AUG BIA Special:</span>
    												<span class="dataRgt txtright" style="font-family:neo sans;">(<? echo "$" . number_format($specialdiscount, 2); ?>)</span>
    												<div class="cl"></div>
    											    </td>
    											</tr>

											<? } ?> 
<? if ($proposal['aei_specials'] == 22) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft" style="font-family:neo sans;">2014 AUG BIA Special:</span>
    												<span class="dataRgt txtright" style="font-family:neo sans;">(<? echo "$" . number_format($specialdiscount, 2); ?>)</span>
    												<div class="cl"></div>
    											    </td>
    											</tr>

<? } ?>
<? if ($proposal['aei_specials'] == 23) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft" style="font-family:neo sans;">2015 JAN BIA Special:</span>
    												<span class="dataRgt txtright" style="font-family:neo sans;">(<? echo "$" . number_format($specialdiscount, 2); ?>)</span>
    												<div class="cl"></div>
    											    </td>
    											</tr>

<? } ?>
<? if ($proposal['aei_specials'] == 31) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft" style="font-family:neo sans;">Kanu Hawaii Discount:</span>
    												<span class="dataRgt txtright" style="font-family:neo sans;">(<? echo "$" . number_format($specialdiscount, 2); ?>)</span>
    												<div class="cl"></div>
    											    </td>
    											</tr>

<? } ?>
<? if ($proposal['aei_specials'] == 59) { ?>
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft" style="font-family:neo sans;"><?= $proposal["other_special"] ?>:</span>
    												<span class="dataRgt txtright" style="font-family:neo sans;">(<? echo "$" . number_format($specialdiscount, 2); ?>)</span>
    												<div class="cl"></div>
    											    </td>
    											</tr>

<? } ?>
<?php if ($proposal['discount']) { ?> 
    											<tr>
    											    <td class="tdData">
    												<span class="dataLft">Discount:</span>
    												<span class="dataRgt txtright">($<?= number_format(@$proposal['discount'], 2) ?>)</span>
    												<div class="cl"></div>
    											    </td>
    											</tr>
<?php } ?>
											<tr>
											    <td class="tdData">
												<span class="dataLft">Sub Total:</span>
												<span class="dataRgt txtright">$<?= number_format(($proposal['price'] - $specialdiscount - $hawaii_tax_cal - $proposal_discount + $acharge_amount), 2) ?></span>
												<div class="cl"></div>
											    </td>
											</tr>
											<tr>
											    <td class="tdData">
												<span class="dataLft">General Excise Tax (4.712%):</span>
												<span class="dataRgt txtright">$<?= number_format($hawaii_tax_cal, 2) ?></span>
												<div class="cl"></div>
											    </td>
											</tr>

											<tr style="border-bottom:1px solid #000; line-height:50px;">
											    <td class="tdData">
												<span class="dataLft" style="padding:5px 0;"><strong style="font-size:20px; font-family:neo sans; font-weight:bold; color:#414142">Total Payable:</strong></span>
												<span class="dataRgt txtright"  style="margin:5px 0;"><strong style="font-size:20px; font-family:neo sans; font-weight:bold; border-top:1px solid #000000;">$<?= number_format($price_net, 2) ?></strong></span>
												<div class="cl"></div>
											    </td>
											</tr>


											<tr>
											    <td colspan="2" style="font-size:14px;font-family:neo sans light; padding-top:20px">TAX INCENTIVES</td>
											</tr>
											<tr>
											    <td class="tdData">
												<span class="dataLft">Hawaii Tax Credit (35%)*:</span>
												<span class="dataRgt txtright">($<?= number_format($sum_state_Tax, 2); ?>)</span>
												<div class="cl"></div>
											    </td>
											</tr>
											<tr>
											    <td class="tdData">
												<span class="dataLft">Federal Tax Credit (30%)*:</span>
												<span class="dataRgt txtright">($<?= number_format($sum_fedral_Tax, 2) ?>)</span>
												<div class="cl"></div>
											    </td>
											</tr>


											<tr>
											    <td class="tdData">
												<span class="dataLft" style="padding:5px 0;"><strong style="font-size:21px; font-family:neo sans; font-weight:bold; color:#414142;">Net Cost (w/ Tax Credits):</strong></span>
												<span class="dataRgt txtright" style="margin:5px 0;"><strong style="font-size:21px; font-family:neo sans; font-weight:bold; border-top:1px solid #000000;">$<?= number_format($price_net - $sumtax, 2); ?></strong></span>
												<div class="cl"></div>
											    </td>
											</tr>		
										    </table>

										</div>

										<div  class='cl'></div>

										<div style="font-family: neo sans light; font-size: 13px;" class="fl">
										    * This agreement is inclusive of the following warranties: <u>Workmanship:</u> 1.) 10 Year Alternate
										    Energy Inc. Workmanship Warranty. <u>Solar Panel Manufacturer:</u> 2.) Mitsubishi Electric 10 Year
										    Manufacturer Limited Product Warranty for its photovoltaic panels. 3.) Mitsubishi Electric 25
										    Year Manufacturer Linear Power Output Warranty for its photovoltaic panels. <u>Solar Inverter
											Manufacturer:</u> 4.) Enphase 25 Year Limited Manufacturer Warranty for its micro-inverters.
										    Note: Alternate Energy Inc. will not be liable for any manufacturer warranties. Manufacturer
										    warranties subject to change at anytime. Please visit and consult with Mitsubishi Electric US,
										    Inc. and Enphase Energy, Inc. for more information for its warranties.  
										</div>




									    </div>
									    <div style="clear:both;"></div>

									    <h4 style="border:none; margin-top:15px;">Method Of Payment</h4>
									    <div style="border:1px solid #000;">
										<div style="float:left; padding:15px; width:40%;">
										    <p><strong>Credit Card:</strong> AMEX | VISA | MC </p>
										    <p><strong>Other:</strong> <del>Cash/Check</del> | ASB | Enerbank </p>
										</div>
										<div style="float:left; padding:15px; width:50%;">
										    <p style=" border-left: 1px solid #000;padding-left: 10px;"><strong>Payment Notes:</strong> &nbsp;<?= $proposal['payment_note'] ?></p>
										</div>
										<div style="clear:both;"></div>
									    </div>



									    <div class="cl clearfix" style="margin-top:20px;">
										<div class="declaraton">Customer Agreement & Contract</div>
										<div style="border:2px solid #000000; padding:10px;" class="clearfix">
<? if ($proposal['mop'] == "gemprogram") { ?>
    										    <div class="declaratontext" style="font-size:15px;">   
    											I, the Buyer, agree to purchase the material and labor described in this Purchase Agreement, subject to and including all of Alternate Energy Inc.'s Photovoltaic Installation Terms & Conditions (attached), which I have initialed and also signed, Alternate Energy Inc.'s Installation Warranty, and subject to additions and deductions pursuant to authorized change orders. I will finance the Total Payable Amount (Loan Amount) through the GEMS Financing Program. I acknowledge that under the GEMS Financing Program Residential Financing Product Guidelines Section 5.6, Alternate Energy Inc. must wait for Energy Financing Solutions (EFS)'s notice to proceed prior to beginning installation. For the purpose of securing the receipt of the Loan Amount net of the origination fee, I consent Alternate Energy Inc. to file UCC-1 and fixture fillings lien at the applicable county's register of deeds. Upon receipt of the Loan Amount net of the origination fee from EFS, Alternate Energy Inc. will remove any/all liens filed within five (5) business days.*<br class="cl" /><br class="cl" />

										    <? } else { ?>
    											<div class="declaratontext"  style="font-size:15px;">
    											    I, the Buyer, agree to pay Alternate Energy, Inc. the Total Payable Amount for the material and labor described in this Purchase Agreement (PV), subject to and including all of Alternate Energy Inc.'s Photovoltaic Installation Terms & Conditions (attached), which I have initialed and also signed, Alternate Energy Inc's Installation Warranty, and subject to additions and deductions pursuant to authorized change orders. I will pay a 50% down payment of the Total Payable Amount upon signing of this Purchase Agreement and the balance when the  PV system installation is completed.*<br class="cl" /><br class="cl" />
<? } ?>
											</div>

											<div class="cl">
											    <div style="width:470px; float:left;">
												<div class="fl"><p font-family:neo sans light;"><?= ucfirst(@$sales_user['first_name']) ?> <?= ucfirst(@$sales_user['last_name']); ?> &nbsp;&nbsp;</p></div>
											    </div>

											    <div style="margin-left:15px; width:470px; float:left;">
												<div class="fl"><p font-family:neo sans light;"><?= $cust_name; ?> &nbsp;&nbsp;</p></div>
											    </div>
											</div>
											<div class="cl">
											    <div style="border-top:2px solid #000000; width:470px; float:left; padding-top:5px;">
												<div class="fl"><p style="font-family:neo sans;">Authorized Agent</p></div>
												<div class="fr"><p style="font-family:neo sans;;margin-right:40px;">Date </p></div>
											    </div>
											    <div style="border-top:2px solid #000000; margin-left:15px; width:470px; float:left; padding-top:5px;">
												<div class="fl"><p style="font-family:neo sans;">Customer Print & Signature</p></div>
												<div class="fr"><p style="font-family:neo sans;margin-right:40px;">Date</p></div>
											    </div>
											</div>
											<div class="cl">
											    <div style="width:470px; float:left;padding-top:20px;">
												<div class="fl"><p font-family:neo sans light;"> <img style="width:330px;" src="<?= base_url() ?>assets/pdfimages/signature.png" class="fl" /></p></div>
												<div class="fr" style="margin-top:22px;"><p font-family:neo sans light;"> <?= Date("M d,Y") ?></p></div>	
											    </div>
											    <div style="width:470px; float:left;padding-top:20px;margin-left:15px;display:none;">
												<div class="fl"><p font-family:neo sans light;"> <img style="margin-top:-7px;" src="<?= base_url() ?>assets/pdfimages/sign1.png" class="fl" /></p></div>
												<div class="fr" style="margin-top:22px;"><p font-family:neo sans light;"> <?= Date("M d,Y") ?></p></div>	
											    </div>       

											</div>
											<div class="cl">
											    <div style="border-top:2px solid #000000; width:470px; float:left; padding-top:5px;">
												<div class="fl"><p style="font-family:neo sans;">President and Principal RME (Lic. No. C-26041)</p></div>
												<div class="fr"><p style="font-family:neo sans;margin-right:40px;">Date</p></div>
											    </div>
											    <div style="border-top:2px solid #000000; width:470px; float:left; padding-top:5px;margin-left:15px;display:none;">
												<div class="fl"><p style="font-family:neo sans;">Principal RME (Lic. No. C-26041)</p></div>
												<div class="fr"><p style="font-family:neo sans;margin-right:40px;">Date</p></div>
											    </div>
											</div>

										    </div>
										</div>
										<div style="padding:0px 0;font-size: 10px;font-family: neo sans;margin-left:0px; margin-top:3px; letter-spacing:normal; text-align:left; border-top:0px solid #ffffff;" class="notesd">* Any example estimated PV energy production contained in this PV estimate are hypothetical based on the National Renewable Energy Laboratory's (NREL) PVWatts calculator. Estimate PV production values are provided for illustrative purposes only and should not be construed as predicted and exact energy production. Hypothetical PV performance results are simulated and have many inherent factors that may affect your PV system's performance. As your PV system has not actually been installed and put into service, the results may have under or over compensated for any impact of certain assumption and weather factors, such as but not limited to your assumption in daytime vs. nighttime loads and/or cloudy and rainy days. Any methods, techniques, or assumptions presented in this email are for educational purposes only and are presented to assist you to make your own judgments on sizing your PV system (for which you are responsible). Any information or data contained in this PV estimate is historical and provides no indication of future performance. All tax incentives that are displayed are for illustration purposes only. Alternate Energy Inc. is not responsible for any tax advice. Please consult with a certified public account (CPA) for your own tax advice.
<? if (( $proposal['module_type'] == 70 || $proposal['module_type'] == 216 || $proposal['module_type'] == 232 || $proposal['module_type'] == 231 || $proposal['module_type'] == 254 ) && ($proposal['invertert'] == 203 || $proposal['invertert'] == 3 || $proposal['invertert'] == 290 || $proposal['invertert'] == 291)) { ?>
    										    ** This agreement is inclusive of the following warranties: Workmanship: 10 Year Alternate Energy Inc. Workmanship Warranty. Solar Panel Manufacturer: Mitsubishi Electric 25 year manufacturer production warranty for its photovoltaic panels. Solar Inverter Manufacturer: Enphase 25 year manufacturer warranty for its micro-inverters. All Alternate Energy Inc. estimates and prices are valid for 30 days from the date of quotation.


<? } elseif (( $proposal['module_type'] == 70 || $proposal['module_type'] == 216 || $proposal['module_type'] == 232 || $proposal['module_type'] == 231 || $proposal['module_type'] == 254 ) && ($proposal['invertert'] == 77 || $proposal['invertert'] == 238 || $proposal['invertert'] == 239)) { ?>
    										    ** This agreement is inclusive of the following warranties: Workmanship: 10 Year Alternate Energy Inc. Workmanship Warranty. Solar Panel Manufacturer: Mitsubishi Electric 25 year manufacturer production warranty for its photovoltaic panels. Solar Inverter Manufacturer: Solar Edge 25 year manufacturer warranty for its power optimizers and Solar Edge 12 year manufacturer warranty for its inverters. All Alternate Energy Inc. estimates and prices are valid for 30 days from the date of quotation. 


<? } elseif (( $proposal['module_type'] == 217 || $proposal['module_type'] == 248 ) && ($proposal['invertert'] == 203 || $proposal['invertert'] == 3 || $proposal['invertert'] == 290 || $proposal['invertert'] == 291)) { ?>
    										    ** This agreement is inclusive of the following warranties: Workmanship: 10 Year Alternate Energy Inc. Workmanship Warranty. Solar Panel Manufacturer: Hyundai 25 year manufacturer Pproduction warranty for its photovoltaic panels. Solar Inverter Manufacturer: Enphase 25 year manufacturer warranty for its micro-inverters. All Alternate Energy Inc. estimates and prices are valid for 30 days from the date of quotation.</div>
<? } elseif (( $proposal['module_type'] == 217 || $proposal['module_type'] == 248 ) && ($proposal['invertert'] == 77 || $proposal['invertert'] == 238 || $proposal['invertert'] == 239)) { ?>
    										** This agreement is inclusive of the following warranties: Workmanship: 10 Year Alternate Energy Inc. Workmanship Warranty. Solar Panel Manufacturer: Hyundai 25 year manufacturer production warranty for its photovoltaic panels. Solar Inverter Manufacturer: Solar Edge 25 year manufacturer warranty for its power optimizers and Solar Edge 12 year manufacturer warranty for its inverters.  All Alternate Energy Inc. estimates and prices are valid for 30 days from the date of quotation.              

<? } else { ?>
    										** All Alternate Energy Inc. estimates and prices are valid for 30 days from the date of quotation.

<? } ?>
									    </div>
									</div>

									<div style="padding:10px 0; margin-top:10px; letter-spacing:normal; text-align:left; border-top:0px solid #ffffff" class="notesd">

									</div>

								    </div>           

								    </body>
								    </html>
