<?php

class Filetab extends Controller {

   function Filetab() {
      parent::Controller();
        if (!$this->session->userdata('logged_in')) {
            $tempurl = explode("/index.php/", $_SERVER['PHP_SELF']);
            redirect("login?ref=" . $tempurl[1]);
        }
        
        $this->load->helper(array('form', 'url','tab_setting'));
        $this->load->library("job");
    }


   function file_index($job_id){
        $data = array();
        $data['file_tab_show'] = 1; 
        $data['job_id'] = $job_id;
        $this->load->helper("text");
        $this->load->helper("thumbnail_helper");
        if ($job_id == '') {
            redirect('admin/error?e=job_id');
        }
        $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=" . $this->db->escape($job_id) . "
		";
        $data['job'] = $this->db->query($sql)->row_array();

        if (count($data['job']) == 0) {
            redirect("admin/error?e=job_id");
        }
        $data['titlejob'] = "Job";
        $data['titleshow'] = "Job";
        if ($data['job']['job_type_id'] == 5) {
            $data['titlejob'] = 'Service';
        }
        if ($data['job']['job_type_id'] == 8) {
            $data['titlejob'] = 'Electrical Pre-install';
        }
        if ($data['job']['job_type_id'] == 6) {
            $data['titleshow'] = 'PreLag';
        }
        if ($data['job']['job_type_id'] == 7) {
            $data['titleshow'] = 'Premeasure';
        }
        $data['job_timestamp'] = strtotime($data['job']['job_date']);
        $data['percent_completed'] = $this->job->percent_completed($job_id);
        $jobtimelimit = $this->gettimeLimit($job_id);
        $data["timediff"] = (int) ($jobtimelimit - (int) (time() - strtotime($data['job']['created'])) / 3600);
        $jobtimelimit1 = $this->getexttimeLimit($job_id);
        if ($jobtimelimit1) {
            if ($data["timediff"] >= 0) {
                $data["timediff"] +=$jobtimelimit1;
            } else {
                $data["timediff"] = $jobtimelimit1;
            }
        }
        // daily job limit
        $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
        $data['customerclass'] = $this->job->getcustomertabclass($job_id);
        $data['jobclass'] = $this->job->getjobtabclass($job_id);

        $userload = $this->getuser($data['job']['modified_by']);
        $data["editedby"] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
        $userload = $this->getuser($data['job']['user_id']);
        $data["salesman"] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
        if ($data['job']['installer_id'] != "" && $data['job']['installer_id']) {
            $show_instaler = explode(",", $data['job']['installer_id']);
            $showinstaller_name = array();
            foreach ($show_instaler as $row_installer) {
                $userload = $this->getuser($row_installer);
                @$showinstaller_name[] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
            }
            $data["showinstaller"] = implode(", ", $showinstaller_name);
        } else {
            $data["showinstaller"] = " ";
        }
        if ($data['job']['contractor_id'] != "" && $data['job']['contractor_id']) {
            $show_instaler = explode(",", $data['job']['contractor_id']);
            $showinstaller_name = array();
            foreach ($show_instaler as $row_installer) {
                $userload = $this->getuser($row_installer);
                @$showinstaller_name[] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
            }
            $data["showelectrican"] = implode(", ", $showinstaller_name);
        } else {
            $data["showelectrican"] = " ";
        }

        if ($data['job']['project_designer_id'] != "" && $data['job']['project_designer_id']) {
            $show_instaler = explode(",", $data['job']['project_designer_id']);
            $showinstaller_name = array();
            foreach ($show_instaler as $row_installer) {
                $userload = $this->getuser($row_installer);
                @$showinstaller_name[] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
            }
            $data["enginner"] = implode(", ", $showinstaller_name);
        } else {
            $data["enginner"] = " ";
        }
        // find other active jobs for customer that this job belongs to
        $sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=" . $this->db->escape($data['job']['customer_id']) . " AND jobs.id!=" . $this->db->escape($job_id) . " ORDER BY jobs.job_date ASC";
        $data['other_jobs'] = $this->db->query($sql)->result_array();

        $sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_type_id not in (6,7,8,15) AND jobs.job_pid=" . $data['job']['job_pid'] . " AND jobs.id!=" . $this->db->escape($job_id) . " ORDER BY jobs.job_date ASC";
        $data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();

        // grab job notes
        $sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=" . $this->db->escape($data['job']['id']) . " LIMIT 3";
        $data['job_notes'] = $this->db->query($sql)->result_array();
        $pid_job = $this->getparentjobid($job_id);
 
        $data["roof_file_options"] = array("1" => "System-Customer Information Sheet", "2" => "System-All electrical panels an wall,Incl meter.","3"=>"Meter-Meter number","4"=>"Meter-Signage showing disconnect location","5"=>"Ac Disconnect-Location, Incl meter","6"=>"Ac Disconnect-Signage","7"=>"Ac Disconnect-Nameplate","8"=>"Inverter-Mfg.'s nameplate","9"=>"Inverter-PV subpanel breaker","10"=>"PV Modules-Mfg.'s nameplate", "11"=>"PV Modules-All PV arrays","12"=>"Other");
        // grab job files
        $this->db->where("job_id", $job_id);
        $this->db->order_by("created", "desc");
        $data['job_files'] = $this->db->get("files")->result_array();
        $this->db->where("job_id", $pid_job);
        $this->db->order_by("created", "desc");
        $data['files'] = $this->db->get("meter_files")->result_array();

        $install_assign = $data['job']['installer_id'];
        $installer_assign_array = explode(",", $install_assign);
        $this->db->where("type", "installer");
        $this->db->order_by("first_name", "desc");
        $installeruser = $this->db->get("users")->result_array();
        $data['installer_assign'] = array();
        $data['installer_user'] = array();
        foreach ($installeruser as $row) {
            if (in_array($row['id'], $installer_assign_array)) {
                $data['installer_assign'][$row['id']] = ucfirst($row['first_name']) . " " . ucfirst($row["last_name"]);
                continue;
            }
            $data['installer_user'][$row['id']] = ucfirst($row['first_name']) . " " . ucfirst($row["last_name"]);
        }
        $data['job_statuses'][''] = "- Select a job status -";
        $data['job_statuses']['unscheduled'] = "Unscheduled";
        if ($data['job']['job_type_id'] < 5 && $data['percent_completed'] != 100) {
            $data['job_statuses']['inprogress'] = "<font color='red'>" . $data['percent_completed'] . "%, " . $data["timediff"] . "hrs remaining</font>";
        }
        $pid = $pid_job;


        $this->db->where("job_id", $pid);
        $this->db->where("file_type", 12);
        $data['new_files'] = array();
        $data['new_files'] = $this->db->get("meter_files")->result_array();
        $totalcount = count($data['new_files']);
         //Ankit-start-26nov
                // start-PHOEN-506
                $sql_phase_type="SELECT * FROM job_phase_type where status=1 and drop_status=1 order by show_order ASC ";
                $phase_statuses=$this->db->query($sql_phase_type)->result_array();
		
                //$data['phase_statuses'][''] = "- Select a job status -";
                foreach($phase_statuses as $key=>$value){
                $data['phase_statuses'][$value['id']]=$value['name'];
                //print_r($data['phase_statuses']); 
                }
		
		
		$sql_phase_type="SELECT * FROM job_phase_type where status=1 and drop_status=2 order by show_order ASC ";
		$phase_statuses=$this->db->query($sql_phase_type)->result_array();
		foreach($phase_statuses as $key=>$value){
		$data['phase_statuses2'][$value['id']]=$value['name'];
		}
		
		// end-PHOEN-506
                 $sql_phase="SELECT * FROM job_phase_log WHERE job_id=".$job_id." ORDER BY id DESC";
                $phase_history=$this->db->query($sql_phase)->result_array();
                $data['phase_history']=$phase_history;
                
                $sql_last_phage="SELECT * FROM job_phase_log WHERE job_id=".$job_id." ORDER BY id DESC LIMIT 1";
                $last_phase_update=$this->db->query($sql_last_phage)->row_array();
                $data['last_phase_update']=$last_phase_update;
                  $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                //Ankit-end-26nov//
        $data['job_statuses']['forms pending'] = "Forms Pending";
        $data['job_statuses']['to be installed'] = "To Be Installed";
        $data['job_statuses']['final payment'] = "Final Payment";
        $data['job_statuses']['inspections'] = "Inspections";
        $data['job_statuses']['completed'] = "Completed";
        $data['job_statuses']['to be completed'] = "To Be Completed";
        $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
        global $schedular_role;
        $data['userrole'] = in_array($this->session->userdata("role"), $schedular_role);
        $this->load->view("common/header");
        if($job_id<34181 || $data['job']['job_type_id'] == 5 || $data['job']['job_type_id'] == 6  || $data['job']['job_type_id'] == 7  || $data['job']['job_type_id'] == 8){
        if(strtotime($data['job']['job_date'])>strtotime("2016-12-19") &&  !($data['job']['job_type_id'] == 5 || $data['job']['job_type_id'] == 6  || $data['job']['job_type_id'] == 7  || $data['job']['job_type_id'] == 8))
         $this->load->view("file_tab/file_index", $data);
        else
        $this->load->view("file_tab/file_index_34181", $data);
        } else {
        $this->load->view("file_tab/file_index", $data);
        }
       
        $this->load->view("common/footer");
    
   }

   //Ankit-start-26nov
      function update_phase_status($job_id, $status)
	{
            $sql = "SELECT
                    jobs.job_type_id,
                    job_types.type as job_type
                    FROM jobs
                    LEFT JOIN job_types ON job_types.id=jobs.job_type_id	
                    WHERE jobs.id=".$job_id;
            $data['job'] = $this->db->query($sql)->row_array();
                
                if(@$status && $job_id)
		{
                         
			$pid = $this->getparentjobid($job_id);
                        $row['job_phase_status'] = $status;
                        $row['modified_by']=$this->session->userdata("user_id");
                        $warray = array('job_pid' => $pid, 'job_type_id' => $data['job']['job_type_id']);
                        $this->db->where($warray);
                        $this->db->update("jobs",$row);
                        
                        //update auto_phase_email_sent
                        $sql= "update jobs set auto_phase_email_sent=0 where id= '".$job_id."'"; 
                        $this->db->query($sql);	
                        
                        $phase=array();
                        $phase['job_id']=$job_id;
                        $phase['job_pid']=$pid;
                        $phase['user_id']=$this->session->userdata("user_id");
                        $phase['created'] = date("Y-m-d H:i:s");
                        $phase['job_phase_status']=$status;
                        $this->db->insert("job_phase_log",$phase);
                        $insertid=$this->db->insert_id();
                        if($insertid){
                         $this->send_updatepahse_alert($job_id,$status);
                        }
                         redirect("filetab/file_index/$job_id");
                        
                        
		 }
                 redirect("filetab/fiel_index/$job_id");
	}
        
        function send_updatepahse_alert($job_id=0,$phase_type=0){
             $this->load->helper('mail');
             $sql = "SELECT
			jobs.id,jobs.user_id,jobs.project_designer_id,jobs.installer_id,jobs.contractor_id,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id	
                LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$job_id;
                $data['job'] = $this->db->query($sql)->row_array();
                
                $field_value='';
                $role_id=0;
                switch($phase_type):
                    case'1':
                        $role_id=97;
                        $sql="SELECT name from job_phase_type where id = 1 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'2':
                        $role_id=98;
                        $sql="SELECT name from job_phase_type where id = 2 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'3':
                        $role_id=99;
                        $sql="SELECT name from job_phase_type where id = 3 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'4':
                        $role_id=100;
                        $sql="SELECT name from job_phase_type where id = 4 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'6':
                        $role_id=101;
                        $sql="SELECT name from job_phase_type where id = 6 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'7':
                        $role_id=102;
                        $sql="SELECT name from job_phase_type where id = 7 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'8':
                        $role_id=103;
                        $sql="SELECT name from job_phase_type where id = 8 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'9':
                        $role_id=104;
                        $sql="SELECT name from job_phase_type where id = 9 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'5':
                        $role_id=120;
                        $sql="SELECT name from job_phase_type where id = 5 ";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    case'10':
                        $role_id=127;
                        $sql="SELECT name from job_phase_type where id = 10";
                        $name = $this->db->query($sql)->row_array();
                        $field_value=$name['name'];
                        break;
                    
                endswitch;
                
                $template = 'template_mail_'.$role_id;  
                $this->load->helper('mail');
              
               
          
            $this->load->library('email');
            $config['mailtype'] = 'html';
            $this->email->initialize($config);
            $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
            $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id='.$role_id);
            $row_email = $query->row();
            $sub=$row_email->strsubject;
            $msg=$row_email->strbody;
                
                
             $joblink='javascript:void(0)';
               if($job_id){
                $joblink=base_url().'job_status_tab/job_status/'.$job_id;
             }
            
            
             //send email to sales user email id 
               $j= $this->getUserLoadNew($data['job']['user_id'],$template);
                 if(isset($data['job']['user_id'])){
                           
                    $mail =getmailid(@$j[0]->email,@$j[0]->type,0,0,$role_id);
                      if($mail){ 
                        $saleman='%userFirstName%  %userLastName%';
                        $customer='%firstName%  %lastName%';
                        $this->email->to($mail);
                        $sub=msgfunction($sub,$job_id);
                        $this->email->subject($sub);
                        $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%fieldname%'=>$field_value));
                        $msg=msgfunction($msg,$job_id);
                        @$this->email->message($msg);
                        @$this->email->send();  
                     }
                }
                 
                  //send email to enginner and installer
                $in_user = '';
                if(trim($data['job']['project_designer_id'])!=''){
                    $in_user .= "'".$data['job']['project_designer_id']."',";
                }
                if(trim($data['job']['installer_id'])!=''){
                    $in_user .= "'".$data['job']['installer_id']."',";
                }
                if(trim($data['job']['contractor_id'])!=''){
                    $in_user .= "'".$data['job']['contractor_id']."',";
                }
                $in_user = substr($in_user,0,-1);
                $assoc_users =  array();
                if ($in_user!=''){
                    $assoc_users = $this->db->query("SELECT users.email,users.type,users.id as user_id,users.first_name, users.last_name from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id  LEFT JOIN permission ps ON ps.user_id = users.id WHERE (ps.$template = 1 or ps.$template is null) AND  ns.notification =1 AND users.type in ('admin','engineer') AND  users.id in ($in_user)")->result_array();
                    foreach ($assoc_users as $value){ 
                      $mail = getmailid($value['email'],$value['type'],0,0,$role_id);
                    if($mail == TRUE){
                        $this->email->to($mail);
                        $sub=msgfunction($sub,$job_id);
                        $this->email->subject($sub);
                        $saleman=@$value['first_name'].' '.@$value['last_name'];
                        $customer='%firstName%  %lastName%';
                       $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%fieldname%'=>$field_value));
                        $msg=msgfunction($msg,$job_id);
                        @$this->email->message($msg);
                        @$this->email->send();
                    }
                }
                }
                
              
                //send email to another email id
                $query = $this->db->query('SELECT another_email_id FROM mailformat where id='.$role_id);
                $row1 = $query->row();
                $another_email_id=  explode(',', $row1->another_email_id);
                foreach ($another_email_id as $mail) {
                    if (!filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
                    $saleman='%userFirstName%  %userLastName%';
                    $customer='%firstName%  %lastName%';
                    $this->email->to($mail);
                    $sub=msgfunction($sub,$job_id);
                    $this->email->subject($sub);
                    $msg= strtr($msg, array('%customer%'=>$customer,'%saleman%' => $saleman , '%baseurl%' =>base_url(), '%href%' => $joblink ,'%project_type%'=>$data['job']['job_type'],'%jobid%'=>$job_id,'%fieldname%'=>$field_value));
                    $msg=msgfunction($msg,$job_id);
                    @$this->email->message($msg);
                    @$this->email->send();
                }
                }
               // redirect("job_status_tab/job_status/$job_id");
         }
         function getUserLoadNew($id,$template) {
              if (!$id)
                  return 0;
             $j = $this->db->query("SELECT users.*,ns.notification FROM users LEFT JOIN permission ps ON ps.user_id = users.id  LEFT JOIN notification_setting ns ON ns.user_id = users.id  WHERE (ps.$template =1 or ps.$template is NULL)  AND (users.user_status='active' or users.user_status=1)  AND  users.id=$id")->result();
              return $j;
          }
        
       function returnInterval($time,$phase_id, $job_id){
         
        $sql="SELECT created FROM job_phase_log WHERE job_id=".$job_id." AND id>".$phase_id." ORDER BY id ASC LIMIT 1";
        $prev_total=$this->db->query($sql)->result_array();
         if(count($prev_total)>0){
            $prev_time=strtotime($prev_total[0]['created']); 
         }else{
            $prev_time=time(); 
         }
        $time = strtotime($time);
        $delta = $prev_time - $time;
         if($delta<0) $delta=-$delta;         
        if(($delta/60) < 1 )
        {
            return $delta."s";
        }
        if(($delta/60) >= 1 && ($delta/60) < 60)
        {
            return floor($delta/60)."m";
        }
        if(($delta/3600) >= 1 && ($delta/3600) < 24)
        {
            $min = ($delta/3600) - floor($delta/3600);
            return floor($delta/3600)."h:" .floor($min*60)."m";
        }
        if(($delta/86400) >= 1 && ($delta/86400) < 7)
        {
            $hour = ($delta/86400) - floor($delta/86400);
            return floor($delta/86400)."d:" .floor($hour*24)."h";
        }
        if(($delta/604800) >= 1)
        {
            $day = ($delta/604800) - floor($delta/604800);
            return floor($delta/604800)."w:" .floor($day*7)."d";
        }
    
     }
     
  function get_phasetype($type){
            $phasename=array();
            if($type){
               $sql="SELECT background_color,text_color,name,show_phase FROM job_phase_type where id=".$type;
               $phage=$this->db->query($sql)->row_array();
               if($phage['background_color']){
                  $phasename['bgcolor']=$phage['background_color'];
                  $phasename['text_color']=$phage['text_color'];
                  $phasename['name']=$phage['name'];
                  $phasename['show_phase']=$phage['show_phase'];
                }
            }
            return $phasename;
       }
          function getproperty($proposal_id,$job_type_id){
          if($job_type_id==2)
               $table="proposal";
          else if($job_type_id==1)
               $table="swhproposal";
          else if($job_type_id==16)
               $table="acproposal";
          else if($job_type_id==20)
               $table="safproposal";
          else if($job_type_id==21)
               $table="homecharging";
          else if($job_type_id==23)
               $table="drwproposal";
          if($table){
                $sql = "SELECT pt.name FROM $table ps LEFT JOIN property_type pt ON ps.property_type=pt.id WHERE ps.id = '" . $proposal_id . "'";
                $data= $this->db->query($sql)->row_array();
                return @$data['name'];
          }else{
               return "";
          }
      }
       //Ankit-end-26nov//
   
    function getUsername($id) {
        if (!$id)
            return 0;
        $j = $this->db->query("SELECT first_name,last_name FROM users WHERE id=$id")->row_array();

        return $j['first_name'] . ' ' . $j['last_name'];
    }
  
       function getUserIntial($id, $fullname = false) {
        if (!$id)
            return 0;
        $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
        $intial = "";
        foreach ($j as $key => $value) {
            $intial = ucfirst($value['first_name'][0]) . strtoupper($value['last_name'][0] . $value['last_name'][0]);
            if ($fullname) {
                $intial = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
            }
        }
        return $intial;
    }
     
    function getdernastatus($job_id, $type) {
        $return = new stdClass();
        $pid = $this->getparentjobid($job_id);
        $row = $this->db->query("SELECT * from der_na where job_id=$pid and type='$type'")->row_array();
        if (isset($row['id']) && $row['id'] > 0) {
            $return->id = $row['id'];
            $return->createdby = $row['created_by'];
            $return->created = $row['created'];
            return $return;
        } else {
            return 0;
        }
    }
    
    
    function gettimeLimit($jobid) {
        $timelimit = 24;
        $resultcnt = $this->db->query("SELECT * FROM globalconfig  where id = 1")->result_array();
        $timelimit = $resultcnt[0]['globaltimelimit'];
        return $timelimit;
    }
      function getexttimeLimit($jobid) {
        $pid = $this->getparentjobid($jobid);
        $resultcnt = $this->db->query("SELECT timeext as smtimeext,created_on FROM timelimit_manual_extend where jid = '" . $pid . "' ")->result_array();
        $timelimit = 0;
        if (count($resultcnt) >= 1) {
            $timelimit_cal = (int) (time() - strtotime($resultcnt[0]['created_on']));
            $timelimit = $resultcnt[0]['smtimeext'] - round($timelimit_cal / 3600);
        }
        return $timelimit;
    }
    
     function getparentjobid($job_id) {
        $resultcnt = $this->db->query("SELECT job_pid FROM jobs  where id = $job_id")->result_array();
        $pid = $resultcnt[0]['job_pid'];
        if (!$pid) {
            $pid = $job_id;
        }
        return $pid;
    }
 function getuser($id) {
        if (!isset($id) || $id < 0) {
            $j = new stdclass;
            $j[0]->first_name = " ";
            $j[0]->last_name = " ";
            $j[0]->phone = " ";
            return $j;
        }

        if ($id > 0) {
            $j = new stdclass;
            $j = $this->db->query("SELECT users.* FROM users WHERE  id =$id ")->result();
            if (isset($j[0]->first_name))
                return $j;
            else {
                @$j[0]->first_name = "";
                @$j[0]->last_name = "";
                @$j[0]->phone = "";
                return $j;
            }
        } else {
            return " ";
        }
    }
    
  
     function getCommentType() {
        $sql = "SELECT id,comment_type FROM comment_type";
        return $this->db->query($sql)->result_array();
    }
        
   function getRankType() {
        $sql = "SELECT id,rank_type FROM rank_type";
        return $this->db->query($sql)->result_array();
    }  
    
    function getproposaltype($proposal_id) {
        $sql = "select deal_type from proposal where id=$proposal_id";
        $row = $this->db->query($sql)->row_array();
        return $row['deal_type'];
    }
    
   function job_file($job_id, $file_type = 3) {
        $data = array();
        $data['job_id'] = $job_id;
        $data['file_type'] = $file_type;
        $this->load->helper("text");
        if ($job_id == '') {
            redirect('admin/error?e=job_id');
        }

        // get job data
        $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=" . $this->db->escape($job_id) . "
		";
        $data['job'] = $this->db->query($sql)->row_array();

        if (count($data['job']) == 0) {
            redirect("admin/error?e=job_id");
        }
        $data['titlejob'] = "Job";
        $data['titleshow'] = "Job";
        if ($data['job']['job_type_id'] == 5) {
            $data['titlejob'] = 'Service';
        }
        if ($data['job']['job_type_id'] == 8) {
            $data['titlejob'] = 'Electrical Pre-install';
        }
        if ($data['job']['job_type_id'] == 6) {
            $data['titleshow'] = 'PreLag';
            $data['job']['job_type'] = 'PreLag';
        }
        $data['job_timestamp'] = strtotime($data['job']['job_date']);
        $data['percent_completed'] = $this->job->percent_completed($job_id);
        $jobtimelimit = $this->gettimeLimit($job_id);
        $data["timediff"] = (int) ($jobtimelimit - (int) (time() - strtotime($data['job']['created'])) / 3600);
        // daily job limit
        $jobtimelimit1 = $this->getexttimeLimit($job_id);
        if ($jobtimelimit1) {
            if ($data["timediff"] >= 0) {
                $data["timediff"] +=$jobtimelimit1;
            } else {
                $data["timediff"] = $jobtimelimit1;
            }
        }
        $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
        $data['customerclass'] = $this->job->getcustomertabclass($job_id);
        $data['jobclass'] = $this->job->getjobtabclass($job_id);
        $data['fileclass'] = $this->job->getfiletabclass($job_id, 'active');
        $userload = $this->getuser($data['job']['modified_by']);
        $data["editedby"] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
        $userload = $this->getuser($data['job']['user_id']);
        $data["salesman"] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
        if ($data['job']['installer_id'] != "" && $data['job']['installer_id']) {
            $show_instaler = explode(",", $data['job']['installer_id']);
            $showinstaller_name = array();
            foreach ($show_instaler as $row_installer) {
                $userload = $this->getuser($row_installer);
                $showinstaller_name[] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
            }
            $data["showinstaller"] = implode(", ", $showinstaller_name);
        } else {
            $data["showinstaller"] = " ";
        }
        if ($data['job']['contractor_id'] != "" && $data['job']['contractor_id']) {
            $show_instaler = explode(",", $data['job']['contractor_id']);
            $showinstaller_name = array();
            foreach ($show_instaler as $row_installer) {
                $userload = $this->getuser($row_installer);
                $showinstaller_name[] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
            }
            $data["showelectrican"] = implode(", ", $showinstaller_name);
        } else {
            $data["showelectrican"] = " ";
        }

        if ($data['job']['project_designer_id'] != "" && $data['job']['project_designer_id']) {
            $show_instaler = explode(",", $data['job']['project_designer_id']);
            $showinstaller_name = array();
            foreach ($show_instaler as $row_installer) {
                $userload = $this->getuser($row_installer);
                @$showinstaller_name[] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
            }
            $data["enginner"] = implode(", ", $showinstaller_name);
        } else {
            $data["enginner"] = " ";
        }
        // find other active jobs for customer that this job belongs to
        $sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=" . $this->db->escape($data['job']['customer_id']) . " AND jobs.id!=" . $this->db->escape($job_id) . " ORDER BY jobs.job_date ASC";
        $data['other_jobs'] = $this->db->query($sql)->result_array();

        // grab job notes
        $sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=" . $this->db->escape($data['job']['id']) . " LIMIT 3";
        $data['job_notes'] = $this->db->query($sql)->result_array();

        // grab job files
        $this->db->where("job_id", $job_id);
        $this->db->order_by("created", "desc");
        $data['job_files'] = $this->db->get("files")->result_array();
        $install_assign = $data['job']['installer_id'];
        $installer_assign_array = explode(",", $install_assign);
        $this->db->where("type", "installer");
        $this->db->order_by("first_name", "desc");
        $installeruser = $this->db->get("users")->result_array();
        $data['installer_assign'] = array();
        $data['installer_user'] = array();
        foreach ($installeruser as $row) {
            if (in_array($row['id'], $installer_assign_array)) {
                $data['installer_assign'][$row['id']] = ucfirst($row['first_name']) . " " . ucfirst($row["last_name"]);
                continue;
            }
            $data['installer_user'][$row['id']] = ucfirst($row['first_name']) . " " . ucfirst($row["last_name"]);
        }
        $data['job_statuses'][''] = "- Select a job status -";
        $data['job_statuses']['unscheduled'] = "Unscheduled";
        if ($data['job']['job_type_id'] < 5 && $data['percent_completed'] != 100) {
            $data['job_statuses']['inprogress'] = "<font color='red'>" . $data['percent_completed'] . "%, " . $data["timediff"] . "hrs remaining</font>";
        }
        $data['job_statuses']['forms pending'] = "Forms Pending";
        $data['job_statuses']['to be installed'] = "To Be Installed";
        $data['job_statuses']['final payment'] = "Final Payment";
        $data['job_statuses']['inspections'] = "Inspections";
        $data['job_statuses']['completed'] = "Completed";
        $data['job_statuses']['to be completed'] = "To Be Completed";
        $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
        global $schedular_role;
        $data['userrole'] = in_array($this->session->userdata("role"), $schedular_role);
        
         //Start by satyendra PHOENIX[318]
        $j=$this->db->query("SELECT p.invertert FROM jobs  LEFT JOIN proposal p ON jobs.proposal_id=p.id  WHERE jobs.id=$job_id")->row_array();
        $inverter_id= $j['invertert']; 
        $file_name= array();
        if($inverter_id=='290' ||$inverter_id=='291'||$inverter_id=='3'||$inverter_id=='203'){
              $file_name= $this->db->query('SELECT * FROM enphase_file_option')->result_array();
        }else if($inverter_id=='238' ||$inverter_id=='239'||$inverter_id=='77' ||$inverter_id=='293' ||$inverter_id=='294'||$inverter_id=='295'||$inverter_id=='296'){
              $file_name= $this->db->query('SELECT * FROM solaredge_file_option')->result_array();
        }else{
              $file_name= $this->db->query('SELECT * FROM enphase_file_option')->result_array();
        }
        $data['file_name']=$file_name;
         //End by satyendra PHOENIX[318]
        
        $this->load->view("common/header");
        $data['error'] = '';
         if ($data['job']['id'] >'16585'){
           $this->load->view("file_tab/file_upload_new", $data);
         }else{
                if ($data['job']['created'] <'2012-08-20'){
                     $this->load->view("file_tab/job_file_old", $data);
                } else{
                    $this->load->view("file_tab/job_file", $data);
                 }
        }
       
        $this->load->view("common/footer");
    } 
    
      function fileview_job($job_id) {
        $data = array();
        $data['file_tab_show'] = 1; // add by vikas on 25-02-2016

        $data['job_id'] = $job_id;

        $this->load->library("job");
        $this->load->helper("text");
        $this->load->helper("thumbnail_helper");

        if ($job_id == '') {
            redirect('admin/error?e=job_id');
        }

        // get job data
        $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=" . $this->db->escape($job_id) . "
		";
        $data['job'] = $this->db->query($sql)->row_array();

        if (count($data['job']) == 0) {
            redirect("admin/error?e=job_id");
        }



        $data['titlejob'] = "Job";
        $data['titleshow'] = "Job";
        if ($data['job']['job_type_id'] == 5) {
            $data['titlejob'] = 'Service';
        }
        if ($data['job']['job_type_id'] == 8) {
            $data['titlejob'] = 'Electrical Pre-install';
        }
        if ($data['job']['job_type_id'] == 6) {
            $data['titleshow'] = 'PreLag';
        }
        if ($data['job']['job_type_id'] == 7) {
            $data['titleshow'] = 'Premeasure';
        }
        $data['job_timestamp'] = strtotime($data['job']['job_date']);
        $data['percent_completed'] = $this->job->percent_completed($job_id);
        $jobtimelimit = $this->gettimeLimit($job_id);
        $data["timediff"] = (int) ($jobtimelimit - (int) (time() - strtotime($data['job']['created'])) / 3600);
        $jobtimelimit1 = $this->getexttimeLimit($job_id);
        if ($jobtimelimit1) {
            if ($data["timediff"] >= 0) {
                $data["timediff"] +=$jobtimelimit1;
            } else {
                $data["timediff"] = $jobtimelimit1;
            }
        }
        // daily job limit
        $data['finaceclass'] = $this->job->getfinancetabclass($job_id);
        $data['customerclass'] = $this->job->getcustomertabclass($job_id);
        $data['jobclass'] = $this->job->getjobtabclass($job_id);

        $userload = $this->getuser($data['job']['modified_by']);
        $data["editedby"] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
        $userload = $this->getuser($data['job']['user_id']);
        $data["salesman"] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
        if ($data['job']['installer_id'] != "" && $data['job']['installer_id']) {
            $show_instaler = explode(",", $data['job']['installer_id']);
            $showinstaller_name = array();
            foreach ($show_instaler as $row_installer) {
                $userload = $this->getuser($row_installer);
                @$showinstaller_name[] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
            }
            $data["showinstaller"] = implode(", ", $showinstaller_name);
        } else {
            $data["showinstaller"] = " ";
        }
        if ($data['job']['contractor_id'] != "" && $data['job']['contractor_id']) {
            $show_instaler = explode(",", $data['job']['contractor_id']);
            $showinstaller_name = array();
            foreach ($show_instaler as $row_installer) {
                $userload = $this->getuser($row_installer);
                @$showinstaller_name[] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
            }
            $data["showelectrican"] = implode(", ", $showinstaller_name);
        } else {
            $data["showelectrican"] = " ";
        }

        if ($data['job']['project_designer_id'] != "" && $data['job']['project_designer_id']) {
            $show_instaler = explode(",", $data['job']['project_designer_id']);
            $showinstaller_name = array();
            foreach ($show_instaler as $row_installer) {
                $userload = $this->getuser($row_installer);
                @$showinstaller_name[] = ucfirst($userload[0]->first_name) . " " . ucfirst($userload[0]->last_name);
            }
            $data["enginner"] = implode(", ", $showinstaller_name);
        } else {
            $data["enginner"] = " ";
        }
        // find other active jobs for customer that this job belongs to
        $sql = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.customer_id=" . $this->db->escape($data['job']['customer_id']) . " AND jobs.id!=" . $this->db->escape($job_id) . " ORDER BY jobs.job_date ASC";
        $data['other_jobs'] = $this->db->query($sql)->result_array();

        $sql_splitjob = "SELECT jobs.*, job_types.type as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_type_id not in (6,7,8,15) AND jobs.job_pid=" . $data['job']['job_pid'] . " AND jobs.id!=" . $this->db->escape($job_id) . " ORDER BY jobs.job_date ASC";
        $data['split_jobs'] = $this->db->query($sql_splitjob)->result_array();

        // grab job notes
        $sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=" . $this->db->escape($data['job']['id']) . " LIMIT 3";
        $data['job_notes'] = $this->db->query($sql)->result_array();

        $data["file_options"] = array();
        $where_id = "";
        if ($data['job']['subpanel_exist'] != 'y') {
            $where_id = " AND id!=2";
        }
        $data_files_option = $this->db->query("SELECT * from file_options where 1 AND 1  $where_id")->result_array();
        foreach ($data_files_option as $dfo) {
            $data["file_options"][$dfo["id"]] = $dfo["file_options"];
        }

        $data["roof_file_options"] = array("1" => "Rooftype Confirmation", "2" => "Array Location on Roof", '3' => 'Other');

        // grab job files
        $this->db->where("job_id", $job_id);
        $this->db->order_by("created", "desc");
        $data['job_files'] = $this->db->get("files")->result_array();
        $pid_job = $this->getparentjobid($job_id);
        $this->db->where("job_id", $pid_job);
        $this->db->order_by("created", "desc");
        $data['files'] = $this->db->get("meter_files")->result_array();

        $install_assign = $data['job']['installer_id'];
        $installer_assign_array = explode(",", $install_assign);
        $this->db->where("type", "installer");
        $this->db->order_by("first_name", "desc");
        $installeruser = $this->db->get("users")->result_array();
        $data['installer_assign'] = array();
        $data['installer_user'] = array();
        foreach ($installeruser as $row) {
            if (in_array($row['id'], $installer_assign_array)) {
                $data['installer_assign'][$row['id']] = ucfirst($row['first_name']) . " " . ucfirst($row["last_name"]);
                continue;
            }
            $data['installer_user'][$row['id']] = ucfirst($row['first_name']) . " " . ucfirst($row["last_name"]);
        }
        $data['job_statuses'][''] = "- Select a job status -";
        $data['job_statuses']['unscheduled'] = "Unscheduled";
        if ($data['job']['job_type_id'] < 5 && $data['percent_completed'] != 100) {
            $data['job_statuses']['inprogress'] = "<font color='red'>" . $data['percent_completed'] . "%, " . $data["timediff"] . "hrs remaining</font>";
        }
        $pid = $pid_job;

        $this->db->where("job_id", $pid);
        $this->db->where("file_type", 1);
        $data['meter_files'] = array();
        $data['meter_files'] = $this->db->get("meter_files")->result_array();
        $this->db->where("job_id", $pid);
        $this->db->where("file_type", 1);
        $this->db->where("image_id", 0);
        $data['cmeter_files'] = array();
        $data['cmeter_files'] = $this->db->get("meter_files")->result_array();
        $totalcount = count($data['cmeter_files']);
        $requiredphoto = array();
        if ($data['job']['subpanel_exist'] != 'y') {
            $where_id = " AND id!=2";
        }

        $sql = "SELECT * FROM file_options WHERE  id not in (SELECT image_id from meter_files  WHERE  file_type=" . FILE_TYPE_METER . " AND job_id=$pid_job) $where_id ";
        $result = $this->db->query($sql)->result_array();
        $mcount = 0;
        $data["requiredphoto"] = array();
        if (count($result) >= 1) {
            foreach ($result as $tdata) {
                $mcount++;
                if ($mcount <= $totalcount)
                    continue;
                $data["requiredphoto"][] = array("id" => $tdata['id']);
            }
        }

        $this->db->where("job_id", $pid);
        $this->db->where("file_type", 2);
        $data['roof_files'] = array();
        $data['roof_files'] = $this->db->get("meter_files")->result_array();
        $data["roofphotorequired"] = array("1" => "Rooftype Confirmation", "2" => "Array Location on Roof");
        $sql = "SELECT image_id from meter_files WHERE  file_type=" . FILE_TYPE_ROOF . " AND job_id=$pid_job ";
        $result = $this->db->query($sql)->result_array();
        $rcount = 1;
        if (count($result) >= 1) {

            foreach ($result as $tdata) {
                unset($data["roofphotorequired"][$tdata['image_id']]);
                $rcount++;
            }
        }

        if ($rcount == 3)
            $data["roofphotorequired"] = array();
        $this->db->where("job_id", $pid);
        $this->db->where("file_type", 3);
        $data['other_files'] = array();
        $data['other_files'] = $this->db->get("meter_files")->result_array();

        $this->db->where("job_id", $pid);
        $this->db->where("file_type", 4);
        $data['pdf_files'] = array();
        $data['pdf_files'] = $this->db->get("meter_files")->result_array();


        $this->db->where("job_id", $pid);
        $this->db->where("photo_id", 1);
        $this->db->where("is_delete", 0);
        $data['elec_photo_1'] = $this->db->get("elecphoto_files")->row_array();

        $this->db->where("job_id", $pid);
        $this->db->where("photo_id", 2);
        $this->db->where("is_delete", 0);
        $data['elec_photo_2'] = $this->db->get("elecphoto_files")->row_array();

        $this->db->where("job_id", $pid);
        $this->db->where("photo_id", 3);
        $this->db->where("is_delete", 0);
        $data['elec_photo_3'] = $this->db->get("elecphoto_files")->row_array();

        $this->db->where("job_id", $pid);
        $this->db->where("photo_id", 4);
        $this->db->where("is_delete", 0);
        $data['elec_photo_4'] = $this->db->get("elecphoto_files")->row_array();

        $this->db->where("job_id", $pid);
        $this->db->where("photo_id", 5);
        $this->db->where("is_delete", 0);

        $data['elec_photo_5'] = $this->db->get("elecphoto_files")->row_array();
        $this->db->where("job_id", $pid);


        $data['elecphoto_allfiles'] = $this->db->get("elecphoto_files")->row_array();

        $this->db->where("job_id", $pid);
        $this->db->where("photo_id", 6);
        $this->db->where("is_delete", 0);
        $data['elec_photo_6'] = $this->db->get("elecphoto_files")->row_array();

        $this->db->where("job_id", $pid);
        $this->db->where("photo_id", 7);
        $this->db->where("is_delete", 0);
        $data['elec_photo_7'] = $this->db->get("elecphoto_files")->row_array();

        $this->db->where("id", 1);
        $data['elec_photo_desc'] = $this->db->get("globalconfig")->row_array();

        $data['job_statuses']['forms pending'] = "Forms Pending";
        $data['job_statuses']['to be installed'] = "To Be Installed";
        $data['job_statuses']['final payment'] = "Final Payment";
        $data['job_statuses']['inspections'] = "Inspections";
        $data['job_statuses']['completed'] = "Completed";
        $data['job_statuses']['to be completed'] = "To Be Completed";
        $data['job_statuses']['pre-measure confirmed'] = "Pre-measure Confirmed";
         //Ankit-start-26nov
                $sql_phase_type="SELECT * FROM job_phase_type order by show_order ASC ";
                $phase_statuses=$this->db->query($sql_phase_type)->result_array();
                $data['phase_statuses'][''] = "- Select a job status -";
                foreach($phase_statuses as $key=>$value){
                $data['phase_statuses'][$value['id']]=$value['name'];
                //print_r($data['phase_statuses']); 
                }
                 $sql_phase="SELECT * FROM job_phase_log WHERE job_id=".$job_id." ORDER BY id DESC";
                $phase_history=$this->db->query($sql_phase)->result_array();
                $data['phase_history']=$phase_history;
                
                $sql_last_phage="SELECT * FROM job_phase_log WHERE job_id=".$job_id." ORDER BY id DESC LIMIT 1";
                $last_phase_update=$this->db->query($sql_last_phage)->row_array();
                $data['last_phase_update']=$last_phase_update;
                  $userload = $this->getuser($data['job']['modified_by']);
                $data["editedby"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                $userload = $this->getuser($data['job']['user_id']);
                $data["salesman"] = ucfirst($userload[0]->first_name)." ".ucfirst($userload[0]->last_name);
                //Ankit-end-26nov//
        global $schedular_role;
        $data['userrole'] = in_array($this->session->userdata("role"), $schedular_role);
        $this->load->view("common/header");
        if ($data['job']['created'] > '2012-08-20') {
                $this->load->view("file_tab/fileview", $data);
        } else {
                $this->load->view("file_tab/fileview_old", $data);
        }
        $this->load->view("common/footer");
    }
    
     function getrooftypeoption($job_id, $file_id) {
        
        $pid = $this->getparentjobid($job_id);
        $sql_image_id = $this->db->query("SELECT image_id,image_text from meter_files  WHERE id=$file_id")->row_array();
        $j=$this->db->query("SELECT p.invertert FROM jobs  LEFT JOIN proposal p ON jobs.proposal_id=p.id  WHERE jobs.id=$job_id")->row_array();
        $inverter_id= $j['invertert']; 
        if($inverter_id=='290' ||$inverter_id=='291'||$inverter_id=='3'||$inverter_id=='203'){
             $file_options = array("0"=>"--Select Label--","1" => "System-Customer Information Sheet", "2" => "System-All electrical panels on wall,Incl meter.","3"=>"Meter-Meter number","4"=>"Meter-Signage showing disconnect location","5"=>"Ac Disconnect-Location, Incl meter","6"=>"Ac Disconnect-Signage","7"=>"Ac Disconnect-Nameplate","8"=>"Inverter-Mfg. nameplate","9"=>"Inverter-PV subpanel breaker","10"=>"PV Modules-Mfg.'s nameplate", "11"=>"PV Modules-All PV arrays");
        }else if($inverter_id=='238' ||$inverter_id=='239'||$inverter_id=='77' ||$inverter_id=='293' ||$inverter_id=='294'||$inverter_id=='295'||$inverter_id=='296'){
             $file_options = array("1" => "System-Customer Information Sheet", "2" => "System-All electrical panels on wall,Incl meter.","3"=>"Meter-Meter number","4"=>"Meter-Signage showing disconnect location","5"=>"Ac Disconnect-Location, Incl meter","6"=>"Ac Disconnect-Signage","7"=>"Ac Disconnect-Nameplate","8"=>"Inverter(s)-LCD Screen","9"=>"Inverter(s)-Serial and part number","10"=>"PV Modules-Mfg.'s nameplate", "11"=>"PV Modules-All PV arrays");
        }else{
            $file_options = array("0"=>"--Select Label--","1" => "System-Customer Information Sheet", "2" => "System-All electrical panels on wall,Incl meter.","3"=>"Meter-Meter number","4"=>"Meter-Signage showing disconnect location","5"=>"Ac Disconnect-Location, Incl meter","6"=>"Ac Disconnect-Signage","7"=>"Ac Disconnect-Nameplate","8"=>"Inverter-Mfg. nameplate","9"=>"Inverter-PV subpanel breaker","10"=>"PV Modules-Mfg.'s nameplate", "11"=>"PV Modules-All PV arrays"); 
        }
        $sql = "SELECT image_id from meter_files  WHERE id!=$file_id AND file_type='12' AND job_id=$pid";
        $result = $this->db->query($sql)->result_array();
        if (count($result) >= 1) {

            foreach ($result as $data) {
                if ($data['image_id'])
                    unset($file_options[$data['image_id']]);
            }
        } else {
            // $file_options[3]="Other";
        }
        $file_options[13] = "Other";
        echo form_dropdown("rooffile", $file_options, @$sql_image_id["image_id"], 'onchange="rooffileupdated(' . $file_id . ',this);"');
        if ($sql_image_id["image_id"] == 13) {
            echo "<div id='other_roof_text'><input value='" . $sql_image_id["image_text"] . "' type=text name=imagetext style='width:140px;' /></div>";
        } else if (count($file_options) == 1) {
            echo "<div id='other_roof_text'><input  type=text name=imagetext style='width:140px;' /></div>";
        }
    }
       function deletefilem($file_id) {
        $url = $this->input->get("q");

        $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;Are you sure to delete this file?<br/>&nbsp;&nbsp;&nbsp;<button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
        $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() { location.href='" . base_url() . "filetab/deleteImage/0/$file_id'}); });</script>";
        echo $output;
    }
    
     public function deleteImage($file, $file_id = 0) {
        if (!$file) {
            $sql = "SELECT * FROM  meter_files WHERE id=" . $file_id;
            $data = $this->db->query($sql)->row_array();
            $file = $data['unique_filename'];
            $file_type=  $data['file_type'];
        }
        if ($file_id) {
            $this->db->where("id", $file_id);
            $this->db->delete('meter_files');
        }

        $success = @unlink(FCPATH . 'uploads/' . $file);
        //info to see if it is doing what it is supposed to
        $info->sucess = $success;
        $info->path = base_url() . 'uploads/' . $file;
        $info->file = is_file(FCPATH . 'uploads/' . $file);
        if (IS_AJAX) {//I don't think it matters if this is set but good for error checking in the console/firebug
            echo json_encode(array($info));
        } else {     //here you will need to decide what you want to show for a successful delete
             if($file_type=='12'){
                redirect("filetab/file_index/" . $data['job_id'] . "?savedata=1");
             }else{
                 redirect("filetab/fileview_job/" . $data['job_id'] . "?savedata=1");
             }
        }
    }
    
     function download_photo($job_id) {
        $this->load->helper("thumbnail");
        $this->load->helper('download');
        if ($job_id == '') {
            redirect('admin/error?e=job_id');
        }
        $pid = $this->getparentjobid($job_id);

        $sql = "SELECT  * from meter_files WHERE job_id=$pid   AND is_export=1  AND file_type='12'  ORDER by image_id";
        $data['photo'] = $this->db->query($sql)->result_array();

        $html = $this->load->view("file_tab/download_photo", $data, true);  
       
        $t = rand(1, 99999);
        $fp = fopen(FCPATH . "pdftemp/temp$t-$job_id.html", "w+");
       // $fp = fopen("E:/xampp/htdocs/sept2015/scheduler/pdftemp/temp$t-$job_id.html", "w+");
        fputs($fp, $html);
        fclose($fp);
        exec("/var/www/vhosts/aeihawaii.com/httpdocs/page/wkhtmltopdf-i386 -B 20 " . FCPATH . "pdftemp/temp$t-$job_id.html     " . FCPATH . "pdftemp/job$t-$job_id.pdf ");
        $data_file = file_get_contents(FCPATH . "pdftemp/job$t-$job_id.pdf"); // Read the file's contents
        force_download("job-$job_id.pdf", $data_file);
    }
    
}

?>