<?php

/*
 * To change this template, choose Tools | Templates
 * and open the template in the editor.
 * * and open the template in the editor.
 */

class Exportapi extends Controller {

    function Exportapi() {

        parent::Controller();
        if (!$this->session->userdata('logged_in')) {
            $tempurl = explode("/index.php/", $_SERVER['PHP_SELF']);
            redirect("login?ref=" . $tempurl[1]);
        }

        if(!$this->session->userdata("superadmin") && !$this->session->userdata('jobs_report'))
		{
			redirect("admin/error?e=permissions");
		}
        $this->load->helper(array('form', 'url'));
    }

    function exportjobyearmonth() {
        $this->load->helper("date");
        $data['calendar_months'] = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
        $data['calendar_years'] = array();
        for ($i = date("Y", strtotime("-2 years")); $i < date("Y", strtotime("+2 years")); $i++) {
            $data['calendar_years'][$i] = $i;
        }
        //$days_count = days_in_month(substr($yearmonth,-2,2),substr($yearmonth,0,4));
        $data['day_dd'][" "] = "Please Select Day";
        for ($i = 1; $i < 32; $i++) {
            $data['day_dd'][sprintf("%02d", $i)] = sprintf("%02d", $i);
        }
        $this->load->view("exportapi/printyearmonth", $data);
    }

    function exportjob() {
        $date3 = $this->input->get("date3");
        $date2 = $this->input->get("date2");
        $date1 = $this->input->get("date1");
        $data = array();
        $date_filter = "";
        $data["dateinterval"] = false;
        $data["date_range"] = false;

        if (isset($date3) && trim($date3) != "") {
            $data["date3"] = $date3;
            $explode_date = explode(";", $date3);
            $date_array = array();
            foreach ($explode_date as $datedata) {
                $date_array[] = "'" . date("Y-m-d", strtotime($datedata)) . "'";
            }
            $date_filter = "jobs.job_date in (" . implode(",", $date_array) . ")";
            $data["dateinterval"] = true;
        } else if (isset($date1) && isset($date2) && strtotime($date1) > 0 && strtotime($date2) > 0) {
            $newdate1 = date("Y-m-d", strtotime($date1));
            $newdate2 = date("Y-m-d", strtotime($date2));
            $data["date2"] = $date2;
            $data["date1"] = $date1;
            $date_filter = "jobs.job_date >='$newdate1' AND jobs.job_date<='$newdate2'";
            $data["date_range"] = true;
        } else {
            $date_filter = "jobs.job_date='" . date("Y-m-d") . "'";
        }
        $user_filter="";
        if($this->session->userdata('role') != 'admin'){
             $user_filter =  " AND jobs.user_id=".$this->session->userdata("user_id");
         }
         
         $sql_price = "SELECT * FROM  ac_system_price";
              $result_price = $this->db->query($sql_price)->result_array();
        $j = array();
        $jobs = array();
        $j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id ,users.first_name as ufirstname ,
            users.last_name ulastname, cs.first_name as csfirstname ,
            cs.last_name as cslastname ,cs.address as csstate,cs.city as cscity,cs.association as  csassociation,cs.zip_code as  zip_code,
            job_types.intials as job_type
            FROM jobs
            LEFT JOIN job_types ON job_types.id=jobs.job_type_id
            LEFT JOIN  customers cs ON jobs.customer_id = cs.id
            LEFT JOIN users ON jobs.user_id=users.id
            LEFT JOIN colors ON users.color_id=colors.id
            WHERE $date_filter $user_filter ORDER BY jobs.job_date ASC")->result_array();


        $this->db->where("type", "installer");
        $this->db->order_by("first_name", "desc");
        $installeruser = $this->db->get("users")->result_array();
        $installer_data = array();
        $output = array();
        $jobdatearray = array();
        foreach ($j as $key => $value) {
            $conductid_arr = array();
            $temp_array = array();
            $jobdatetimestamp = strtotime($value["job_date"]);
            $temp_array["job_date"] = $jobdatetimestamp;
            //$temp_array["neighborhood"] = ucfirst($value["cscity"]);
            /*new-code-start-24-2-2016-job-report*/ 
            $temp_array["city"]= $this->getArea($value['zip_code']);
            /*new-code-end-24-2-2016-job-report*/
            $temp_array['cname'] = ucfirst($value["csfirstname"]) . " " . ucfirst($value["cslastname"]);
            $temp_array['salesman'] = ucfirst($value["ufirstname"]);
            $temp_array['type'] = $value['job_type'];
            $temp_array['rel_job'] = $this->getrelatedjobforexcel($value["job_pid"], $value["id"]);
            $temp_array['comments'] = $value["comments"];
           $proposal_id=$this->getProposalId($value["job_pid"]);
            if($value['job_type']=='SWH' ||$value['job_type']=='WM'){
                $temp_array['nom'] = $value["panel_count"];
            }else if($value['job_type']=='SAF' || $value['job_type']=='EV'){
                $temp_array['nom'] = $value["no_of_saf"];
            }else if($value['job_type']=='AC' || $value['job_type']=='APM' || $value['job_type']=='AS' ){
                $temp_array['nom'] =  $this->getunit($proposal_id,$result_price);
            }else{
                $temp_array['nom'] = $value["job_nom"];
            }

            $temp_array['rooftype'] = @$value["stories"] . $this->getidothervalue($value['roof_type_id'], $value['other_roof_type'], 'roof_types', 'type');
            $installer_id_table = array();
            $installer_id_table = explode(",", $value['installer_id']);

            $newnoassign = array();
            foreach ($installer_id_table as $id) {
                if ($this->getUserFirstName($id))
                    $newnoassign[] = $this->getUserFirstName($id);
            }

            if (count($newnoassign) >= 1)
                $temp_array['installer'] = implode(",", $newnoassign);
            else {
                $temp_array['installer'] = "";
            }
            $temp_array['hex'] = str_replace("#", "", $this->getCustomerNeighborhoodColor($value['customer_id']));
            $temp_array['note'] = $this->getnote($value["job_pid"]);
            if ($value['job_type'] == 'PV') {
                $temp_array['labour'] = $this->getlaboucost($value["proposal_id"]);
            } else {
                $temp_array['labour'] = '';
            }
            /*new-code-start-24-2-2016-job-report*/ 
            

            $temp_array['varibleLaborCost']=$this->getAllvaribleLaborCost($proposal_id,$value["job_type_id"],$value["location_access"]);
            /*new-code-end-24-2-2016-job-report*/
            
            $output[] = $temp_array;
        }
        $data["j"] = $j;
        $data["jobs"] = $jobs;
        //die;
        $this->writeDataintoCSV($output);
        //force_download("jobs.csv", $output);
    }

    function jobyearmonth() {
        $this->load->helper("date");
        $data['calendar_months'] = array('01' => 'Jan', '02' => 'Feb', '03' => 'Mar', '04' => 'Apr', '05' => 'May', '06' => 'Jun', '07' => 'Jul', '08' => 'Aug', '09' => 'Sep', '10' => 'Oct', '11' => 'Nov', '12' => 'Dec');
        $data['calendar_years'] = array();
        for ($i = date("Y", strtotime("-2 years")); $i < date("Y", strtotime("+2 years")); $i++) {
            $data['calendar_years'][$i] = $i;
        }
        //$days_count = days_in_month(substr($yearmonth,-2,2),substr($yearmonth,0,4));
        $data['day_dd'][" "] = "Please Select Day";
        for ($i = 1; $i < 32; $i++) {
            $data['day_dd'][sprintf("%02d", $i)] = sprintf("%02d", $i);
        }
        $this->load->view("exportapi/jobyearmonth", $data);
    }

    function dayview() {
        $date3 = $this->input->get("date3");
        $date2 = $this->input->get("date2");
        $date1 = $this->input->get("date1");
        $data = array();
        $date_filter = "";
        $data["dateinterval"] = false;
        $data["date_range"] = false;
        $sql_price = "SELECT * FROM  ac_system_price";
        $result_price = $this->db->query($sql_price)->result_array();
        if (isset($date3) && trim($date3) != "") {
            $data["date3"] = $date3;
            $explode_date = explode(";", $date3);
            $date_array = array();
            foreach ($explode_date as $datedata) {
                $date_array[] = "'" . date("Y-m-d", strtotime($datedata)) . "'";
            }
            $date_filter = "jobs.job_date in (" . implode(",", $date_array) . ")";
            $data["dateinterval"] = true;
        } else if (isset($date1) && isset($date2) && strtotime($date1) > 0 && strtotime($date2) > 0) {
            $newdate1 = date("Y-m-d", strtotime($date1));
            $newdate2 = date("Y-m-d", strtotime($date2));
            $data["date2"] = $date2;
            $data["date1"] = $date1;
            $date_filter = "jobs.job_date >='$newdate1' AND jobs.job_date<='$newdate2'";
            $data["date_range"] = true;
        } else {
            $date_filter = "jobs.job_date='" . date("Y-m-d") . "'";
        }
         $user_filter="";
        if($this->session->userdata('role') != 'admin'){
             $user_filter =  " AND jobs.user_id=".$this->session->userdata("user_id");
         }
        $j = array();
        $jobs = array();
        $j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id ,users.first_name as ufirstname ,
            users.last_name ulastname, cs.first_name as csfirstname ,
            cs.last_name as cslastname ,cs.address as csstate,cs.city as cscity,cs.association as  csassociation,cs.zip_code as  zip_code,
            job_types.intials as job_type
            FROM jobs
            LEFT JOIN job_types ON job_types.id=jobs.job_type_id
            LEFT JOIN  customers cs ON jobs.customer_id = cs.id
            LEFT JOIN users ON jobs.user_id=users.id
            LEFT JOIN colors ON users.color_id=colors.id
            WHERE $date_filter $user_filter ORDER BY jobs.job_date ASC ,job_type ASC")->result_array();

        $this->db->where("type", "installer");
        $this->db->order_by("first_name", "desc");
        $installeruser = $this->db->get("users")->result_array();
        $installer_data = array();
        $output = array();
        $jobdatearray = array();
        foreach ($j as $key => $value) {
            $conductid_arr = array();
            $temp_array = array();
            $jobdatetimestamp = strtotime($value["job_date"]);
            $temp_array["job_date"] = $jobdatetimestamp;
            //      $temp_array["city"]= ucfirst($value['cscity']);
            /*new-code-start-24-2-2016-job-report*/ 
            $temp_array["city"]= $this->getArea($value['zip_code']);
            /*new-code-end-24-2-2016-job-report*/
            $temp_array["citycolor"] = $this->getCustomerNeighborhoodColor($value['customer_id']);
            $temp_array['id'] = $value['id'];
            $temp_array['type'] = $value['job_type'];
            $temp_array['rel_job'] = $this->getrelatedjob($value["job_pid"], $value["id"]);
            $temp_array['cname'] = ucfirst($value["csfirstname"]) . " " . ucfirst($value["cslastname"]);
            $temp_array['salesman'] = ucfirst($value["ufirstname"]);
            $temp_array['comments'] = $value["comments"];
            $temp_array['proposal_id'] = $value["proposal_id"];
            $proposal_id=$this->getProposalId($value["job_pid"]);
            if($value['job_type']=='SWH' ||$value['job_type']=='WM'){
                $temp_array['nom'] = $value["panel_count"];
            }else if($value['job_type']=='SAF' || $value['job_type']=='EV'){
                $temp_array['nom'] = $value["no_of_saf"];
            }else if($value['job_type']=='AC' || $value['job_type']=='APM' || $value['job_type']=='AS' ){
                $temp_array['nom'] =  $this->getunit($proposal_id,$result_price);
            }else{
                $temp_array['nom'] = $value["job_nom"];
            }
            
            $newstories = "";
            if (isset($value["stories"]) && $value["stories"] != "") {
                $newstories = $value["stories"] . " / ";
            }
            $temp_array['rooftype'] = @$newstories . $this->getidothervalue($value['roof_type_id'], $value['other_roof_type'], 'roof_types', 'type');
            $installer_id_table = array();
            $installer_id_table = explode(",", $value['installer_id']);
            $newnoassign = array();
            foreach ($installer_id_table as $id) {
                if ($this->getUserIntial($id, true))
                    $newnoassign[] = '<div class="instBox" id="rinstaller' . $id . $value['id'] . '"><a href="javascript:void(0);" >' . $this->getUserIntial($id, true) . '</a><a  onclick="removeinstaller(' . $id . ',' . $value['id'] . ')" href="javascript:void(0);" class="instCross"></a></div>';
            }

            if (count($newnoassign) >= 1)
                $temp_array['installer'] = implode(" ", $newnoassign);
            else {
                $temp_array['installer'] = "";
            }
            /*new-code-start-24-2-2016-job-report*/ 
            
            

            $temp_array['varibleLaborCost']=$this->getAllvaribleLaborCost($proposal_id,$value["job_type_id"],$value["location_access"]);
            /*new-code-end-24-2-2016-job-report*/
            $temp_array['note'] = $this->getnote($value["job_pid"]);
            $output[] = $temp_array;
        }
        //print_R($data);die;
        $data["jobs"] = $output;
        $this->load->view("common/header");
        $this->load->view("exportapi/dayviewnew", $data);
        $this->load->view("common/footer");
    }

    function getdayinstaller($job_date) {
        $rs = $this->db->query("SELECT installer_id FROM jobs WHERE  job_date='$job_date' ")->result_array();
        $temp = array();
        foreach ($rs as $key => $value) {
            $temp[] = $value['installer_id'];
        }
        if (count($temp)) {
            return implode(",", $temp);
        }
    }

    function getidothervalue($other, $id, $tablename, $column = "*") {
        if ($other == "other" || $other == "" || !$other) {

            return $id;
        }

        $j = $this->db->query("SELECT $column  FROM $tablename  WHERE  id =$other")->result();

        if (isset($j[0]->$column))
            return $j[0]->$column;
        else
            return "";
    }

    function getUserIntial($id, $fullname = false) {
        if (!$id)
            return 0;
        $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
        $intial = "";
        foreach ($j as $key => $value) {
            $intial = ucfirst($value['first_name'][0]) . ucfirst($value['last_name'][0]);
            if ($fullname) {
                $intial = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
            }
        }
        return $intial;
    }

    function getUserEmpNo($id, $fullname = false) {
        if (!$id)
            return 0;
        $j = $this->db->query("SELECT emp_num FROM users WHERE id=$id")->result_array();
        if ($j[0]['emp_num'] > 0) {
            return $j[0]['emp_num'];
        }

        return $id;
    }

    function getUserFirstName($id) {
        if (!$id)
            return 0;
        $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
        $intial = "";
        foreach ($j as $key => $value) {
            $intial = ucfirst($value['first_name']);
        }

        return $intial;
    }

    function getCustomerNeighborhoodColor($id) {
        if (!$id)
            return '#ffffff';
        $neighborhood = "";
        $value = $this->db->query("SELECT neighborhood,other_neighborhood FROM customers WHERE id=$id")->row_array();
        if (isset($value['neighborhood'])) {
            if ($value['neighborhood'] == "other") {
                return;
            } else {
                if (isset($value['neighborhood']) && $value['neighborhood'] != "" && is_numeric($value['neighborhood'])) {
                    $sql = "SELECT neighbour,color from  neigbhour where id=" . $value['neighborhood'];
                    $row_neighbour = $this->db->query($sql)->row_array();
                    return @$row_neighbour['color'];
                } else {
                    return "#ffffff";
                }
            }
        }
        return @$neighborhood;
    }

    function getCustomerNeighborhood($id) {
        if (!$id)
            return 0;
        $neighborhood = "";
        $j = $this->db->query("SELECT neighborhood,other_neighborhood FROM customers WHERE id=$id")->result_array();
        foreach ($j as $key => $value) {
            if (isset($value['neighborhood'])) {
                if ($value['neighborhood'] == "other") {
                    $neighborhood = ucfirst($value['other_neighborhood']);
                } else {
                    if (isset($value['neighborhood']) && $value['neighborhood'] != "" && is_numeric($value['neighborhood'])) {
                        $sql = "SELECT neighbour from  neigbhour where id=" . $value['neighborhood'];
                        $row_neighbour = $this->db->query($sql)->row_array();
                        $neighborhood = ucfirst(@$row_neighbour['neighbour']);
                    } else {
                        $neighborhood = $value['neighborhood'];
                    }
                }
            }
        }
        if (strlen($neighborhood) > 20) {
            $neighborhood = substr($neighborhood, 0, 20) . "..";
        }
        return @$neighborhood;
    }

    function getCustomerLastname($id) {
        if (!$id)
            return 0;

        $j = $this->db->query("SELECT last_name FROM customers WHERE id=$id")->result_array();
        foreach ($j as $key => $value) {
            $lastname = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
        }
        return @$lastname;
    }

    function writeDataintoCSV($data) {
        //print_R($data);
        //die;
        require_once 'php-excel/PHPExcel.php';
        $objPHPExcel = new PHPExcel();
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Alternate Energy")
                ->setLastModifiedBy("Alternate Energy")
                ->setTitle("Office 2007 XLSX Alternate Energy Document")
                ->setSubject("Office 2007 XLSX Alternate Energy Document")
                ->setDescription("Alternate Energy for Office 2007 XLSX, generated using PHP classes.")
                ->setKeywords("office 2007 Alternate Energy")
                ->setCategory("Alternate Energy");
        // Create a first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setWidth(45);
        $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setWidth(45);
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setWidth(20);
        $objPHPExcel->getActiveSheet()->setCellValue('A1', "Area");
        $objPHPExcel->getActiveSheet()->setCellValue('B1', "Customer");
        $objPHPExcel->getActiveSheet()->setCellValue('C1', "Type");
        $objPHPExcel->getActiveSheet()->setCellValue('D1', "SalesMan");
        $objPHPExcel->getActiveSheet()->setCellValue('E1', "Related Jobs");
//        $objPHPExcel->getActiveSheet()->setCellValue('F1', "Job Spec Notes");
        $objPHPExcel->getActiveSheet()->setCellValue('F1', "Panels/units");
        $objPHPExcel->getActiveSheet()->setCellValue('G1', "Stories/RoofType");
//        $objPHPExcel->getActiveSheet()->setCellValue('I1', "Installers");
        $objPHPExcel->getActiveSheet()->setCellValue('H1', "Notes");
        $objPHPExcel->getActiveSheet()->setCellValue('I1', "Labor allocated(hrs)");
        $objPHPExcel->getActiveSheet()->getPageSetup()->setRowsToRepeatAtTopByStartAndEnd(1, 1);
        // Add data
        $timestamparray = array();
        $i = 2;
        foreach ($data as $key => $keydata) {

            if (!in_array($keydata['job_date'], $timestamparray)) {
                $timestamparray[] = $keydata['job_date'];
                $objPHPExcel->getActiveSheet()->setCellValue('A' . $i, date("F jS, Y", $keydata['job_date']));
                $objPHPExcel->setActiveSheetIndex(0)->mergeCells('A' . $i . ':H' . $i);
                $i++;
            }
            
            $objPHPExcel->getActiveSheet()->setCellValue('A' . $i, $keydata['city'])
                    ->setCellValue('B' . $i, $keydata['cname'])
                    ->setCellValue('C' . $i, $keydata['type'])
                    ->setCellValue('D' . $i, $keydata['salesman'])
                    ->setCellValue('E' . $i, $keydata['rel_job'])
//                    ->setCellValue('F' . $i, $keydata['comments'])
                    ->setCellValue('F' . $i, $keydata['nom'])
                    ->setCellValue('G' . $i, $keydata['rooftype'])
//                    ->setCellValue('I' . $i, $keydata['installer'])
                    ->setCellValue('H' . $i, $keydata["note"])
//                    ->setCellValue('J' . $i, $keydata["labour"])
                    ->setCellValue('I' . $i, $keydata["varibleLaborCost"])
                    
            ;
            $objPHPExcel->getActiveSheet()->getStyle('F' . $i)->getAlignment()->setWrapText(true);
            $objPHPExcel->getActiveSheet()->getStyle('J' . $i)->getAlignment()->setWrapText(true);
            $objPHPExcel->getActiveSheet()->getStyle('A' . $i)->applyFromArray(
                    array(
                        'fill' => array(
                            'type' => PHPExcel_Style_Fill::FILL_SOLID,
                            'color' => array('rgb' => $keydata['hex'])
                        )
                    )
            );
            /*             * $objPHPExcel->getActiveSheet()->getStyle('A3')->applyFromArray(
              array(
              'fill' => array(
              'type' => PHPExcel_Style_Fill::FILL_SOLID,
              'color' => array('rgb' => '0000FF')
              )
              )
              ); */
            $i++;
        }


// Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);


// Save Excel 2007 file
//$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel2007');
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment;filename="jobs.xls"');
        header('Cache-Control: max-age=0');
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    /* download created excel file */

    function downloadExcel() {
        $myFile = "testexcel.xls";
        header("Content-Length: " . filesize($myFile));
        header('Content-Type: application/vnd.ms-excel');
        header('Content-Disposition: attachment; filename=testexcel.xls');
        readfile($myFile);
    }

    function getnote($job_id) {
        $notes = $this->db->query("select *  from notes where job_id=$job_id ")->result_array();
        $return_note_array = array();
        foreach ($notes as $note) {
            $return_note_array[] = @$note["note"] . "(Posted by:" . $this->getUserIntial($note["user_id"], true) . ", " . date("m/d/y", strtotime($note["created"])) . ")";
        }
        return implode(",", $return_note_array);
    }

    function getrelatedjob($job_pid, $job_id) {
        $sql = "SELECT jobs.*, job_types.intials as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_pid=" . $job_pid . " AND jobs.id!=" . $job_id . " ORDER BY jobs.job_date ASC";
        $related_job = $this->db->query($sql)->result_array();
        $link = array();
        foreach ($related_job as $jobs) {
            $link[] = "<a  target='_blank' style='text-decoration:underline;' href='" . base_url() . "admin/job/" . $jobs["id"] . "'>" . $jobs["job_type"] . date("m/d/y", strtotime($jobs["job_date"])) . "</a>";
        }
        return implode(",", $link);
    }

    function getrelatedjobforexcel($job_pid, $job_id) {
        $sql = "SELECT jobs.*, job_types.intials as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_pid=" . $job_pid . " AND jobs.id!=" . $job_id . " ORDER BY jobs.job_date ASC";
        $related_job = $this->db->query($sql)->result_array();
        $link = array();
        foreach ($related_job as $jobs) {
            $link[] = "" . $jobs["job_type"] . date("m/d/y", strtotime($jobs["job_date"])) . "";
        }
        return implode(",", $link);
    }

    function getparentjobid($job_id) {
        $resultcnt = $this->db->query("SELECT job_pid FROM jobs  where id = $job_id")->result_array();
        $pid = $resultcnt[0]['job_pid'];
        if (!$pid) {
            $pid = $job_id;
        }
        return $pid;
    }

    function savecomment($id) {
        $row = array();
        $pid = $this->getparentjobid($id);
        $row["comments"] = $this->input->post("comments");
        $this->db->where("job_pid", $pid);
        $this->db->update("jobs", $row);
        $json["success"] = true;
        echo json_encode($json);
    }

    function addinstaller($job_id) {
        $pid = $this->getparentjobid($job_id);
        $rs_installer = $this->db->query("select concat('0',installer_id) as installer_id from jobs where id=job_pid AND job_pid=$pid")->row_array();
        if (isset($rs_installer["installer_id"]) && $rs_installer["installer_id"] != "") {
            $sql = "SELECT * FROM users WHERE  type='installer' and id not in (" . $rs_installer["installer_id"] . ")";
        } else {
            $sql = "SELECT * FROM users WHERE  type='installer' ";
        }
        $data['users'] = $this->db->query($sql)->result_array();
        $user_select = array();
        foreach ($data['users'] as $users) {
            $user_select[$users['id']] = ucfirst($users['first_name']) . " " . ucfirst($users['last_name']);
        }
        $data['job_id'] = $job_id;

        $data['saleuser'] = $user_select;
        $this->load->view("exportapi/salesuser", $data);
    }

    function updatejobinstaller($job_id) {
        $row = array();
        $pid = $this->getparentjobid($job_id);
        $exist_installer = $this->db->query("select installer_id from jobs where id=job_pid AND job_pid=$pid")->row_array();
        $array_installer = explode(",", $exist_installer["installer_id"]);
        $installer_r = array();
        foreach ($array_installer as $value) {
            if ($value == $this->input->post("installer_id")) {
                $json['success'] = true;
                echo json_encode($json);
                return;
            }
        }
        $row['installer_id'] = $exist_installer["installer_id"] . "," . $this->input->post("installer_id");
        $this->db->where("job_pid", $pid);
        $this->db->update("jobs", $row);
        $json['success'] = true;
        echo json_encode($json);
    }

    function removeinstaller($job_id, $id) {
        $row = array();
        $pid = $this->getparentjobid($job_id);
        $exist_installer = $this->db->query("select installer_id from jobs where id=job_pid AND job_pid=$pid")->row_array();
        $array_installer = explode(",", $exist_installer["installer_id"]);
        $installer_r = array();
        foreach ($array_installer as $value) {
            if ($value == $id)
                continue;
            $installer_r[] = $value;
        }
        $row['installer_id'] = implode(",", $installer_r);
        $this->db->where("job_pid", $pid);
        $this->db->update("jobs", $row);
        $json['success'] = true;
        echo json_encode($json);
    }

    function getinstallerjson() {
        $firstname = $this->input->get("term");

        $row = $this->db->query("SELECT * FROM users WHERE  type='installer'  AND first_name like '$firstname%' ")->result_array();
        $installer_json = array();
        foreach ($row as $installer) {
            $installer_pre['id'] = $installer["id"];
            $installer_pre['value'] = ucfirst($installer["first_name"]) . " " . ucfirst($installer["last_name"]);
            $installer_json[] = $installer_pre;
        }
        echo json_encode($installer_json);
    }

    function getinstallerbyname() {
        $name = @trim($this->input->post("term"));
        $name = str_replace('"', "", $name);
        $explodename = array();
        $explodename = explode(" ", $name);
        if (count($explodename) != 2) {
            $installer_json["success"] = false;
            echo json_encode($installer_json);
            die;
        }
        $firstname = $explodename[0];
        $lastname = $explodename[1];
        // echo "SELECT * FROM users WHERE  type='installer'  AND first_name='$firstname' AND last_name='$lastname' ";
        $row = $this->db->query("SELECT * FROM users WHERE  type='installer'  AND first_name='$firstname' AND last_name='$lastname' ")->row_array();
        $installer_json = array();
        if (isset($row["id"]) && $row["id"] > 0) {
            $installer_json["success"] = true;
            $installer_json["id"] = $row["id"];
            $installer_json["name"] = ucfirst($row['first_name']) . " " . ucfirst($row["last_name"]);
            echo json_encode($installer_json);
            die;
        }
        $installer_json["success"] = false;
        echo json_encode($installer_json);
    }

    function getlaboucost($proposal_id) {
        if ($proposal_id < 11390) {
            $sql = "SELECT sum(variable_job.price*variable_job.quantity) as sumlabour
FROM variable_job
LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
AND variable_job.proposal_id=system_price_proposal.proposal_id
where variable_job.proposal_id=$proposal_id
AND  variable_job.variable_id in (23,17,69)
order by variable_job.id";
            $row = $this->db->query($sql)->row_array();
            $sql_elec = "SELECT sum(variable_job.price*variable_job.quantity) as sumlabour
FROM variable_job
LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
AND variable_job.proposal_id=system_price_proposal.proposal_id
where variable_job.proposal_id=$proposal_id
AND  variable_job.variable_id in (29,31)
order by variable_job.id";
            $row_elec = $this->db->query($sql_elec)->row_array();
            if (!$row_elec) {
                $sql_elec = "SELECT sum(variable_job.price*variable_job.quantity) as sumlabour
FROM variable_job
LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
AND variable_job.proposal_id=system_price_proposal.proposal_id
where variable_job.proposal_id=$proposal_id
AND  variable_job.variable_id in (100,101,102)
order by variable_job.id";
                $row_elec = $this->db->query($sql_elec)->row_array();
            }
            return round($row["sumlabour"] / 40) . " roof/" . round($row_elec["sumlabour"] / 40) . 'elec';
        } else {

            $sql = "SELECT sum(variable_job.quantity) as sumlabour
FROM variable_job
LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
AND variable_job.proposal_id=system_price_proposal.proposal_id
where variable_job.proposal_id=$proposal_id
AND  variable_job.variable_id in (206,207)
order by variable_job.id";
            $row = $this->db->query($sql)->row_array();
            $sql_elec = "SELECT sum(variable_job.quantity) as sumlabour
FROM variable_job
LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
AND variable_job.proposal_id=system_price_proposal.proposal_id
where variable_job.proposal_id=$proposal_id
AND  variable_job.variable_id in (101,102)
order by variable_job.id";
            $row_elec = $this->db->query($sql_elec)->row_array();
            return round($row["sumlabour"]) . " roof/" . round($row_elec["sumlabour"]) . 'elec';
        }
    }

    function getallsalesuser() {
        $sql = "SELECT * FROM users WHERE  type='sales'";
        $data['users'] = $this->db->query($sql)->result_array();
        $user_select = array();
        foreach ($data['users'] as $users) {
            $user_select[$users['id']] = ucfirst($users['first_name']) . " " . ucfirst($users['last_name']);
        }
        $user_select['all'] = 'All';
        $data['saleuser'] = $user_select;
        $data['jobtype_list'] = array("" => "-Please select job type-", "all" => "All jobs", 2 => "PV", 1 => "SWH", 16 => "HVAC", 21 => "EV", 20 => "SAF", 6 => "PV+SWH", 7 => "PV+AC", 8 => "PV+SWH+AC", 9 => "Sold", 10 => "Non-Sold");
        $this->load->view("exportapi/salesuser", $data);
    }

    function downloadcsv($saleuser_id, $job_type_select = '') {
        $this->load->helper('csv');
        $this->load->helper('download');
        $jobtype_select = $job_type_select;
        if ($job_type_select == '') {
            $jobtype_select = "all";
        }
        if ($jobtype_select == "all" || $jobtype_select == 2 || $jobtype_select == 1 || $jobtype_select == 16 || $jobtype_select == 21 || $jobtype_select == 20 || $jobtype_select == 6 || $jobtype_select == 7 || $jobtype_select == 8 || $jobtype_select == "all") {
            if ($jobtype_select == "all") {
                $sql_jobtype = "";
            }
            if ($jobtype_select == 2) {
                $sql_jobtype = "and jobs.job_type_id=2";
            } else if ($jobtype_select == 1) {
                $sql_jobtype = "and jobs.job_type_id=1";
            } else if ($jobtype_select == 16) {
                $sql_jobtype = "and jobs.job_type_id=16";
            } else if ($jobtype_select == 21) {
                $sql_jobtype = "and jobs.job_type_id=21";
            } else if ($jobtype_select == 20) {
                $sql_jobtype = "and jobs.job_type_id=20";
            } else if ($jobtype_select == 6) {
                $sql_jobtype = "and (jobs.job_type_id=2 or jobs.job_type_id=1)";
            } else if ($jobtype_select == 7) {
                $sql_jobtype = "and (jobs.job_type_id=2 or jobs.job_type_id=16)";
            } else if ($jobtype_select == 8) {
                $sql_jobtype = "and (jobs.job_type_id=2 or jobs.job_type_id=16 or jobs.job_type_id=1)";
            } else {
                $sql_jobtype = "";
            }
            $saleuser_filter = "";
            if ($saleuser_id == 'all') {
                $saleuser_filter = "";
            } else {
                $saleuser_filter = "AND jobs.user_id=$saleuser_id";
            }
            $sql = "SELECT distinct first_name,last_name,email FROM  jobs left join customers  on jobs.customer_id=customers.id where 1=1 AND email is not null AND email!=''  $sql_jobtype $saleuser_filter order by first_name";
            $row = $this->db->query($sql)->result_array();
            $output = "";
            $output .= "First Name,Last Name ,Email\n";
            foreach ($row as $data) {
                $output .= ucfirst(str_replace(",", "", $data['first_name'])) . ", " . ucfirst(str_replace(",", "", $data['last_name'])) . "," . $data['email'] . "\n";
            }

            if ($saleuser_id == 'all') {

                force_download("All Customer's list.csv", $output);
            } else {
                $userload = $this->getUserIntial($saleuser_id, true);

                force_download($userload . " Customer's list.csv", $output);
            }
        }
        if ($jobtype_select == 9 || $jobtype_select == 10) {
            $user_filter = "";
            if ($saleuser_id == 'all') {
                $userload = "All Customers ";
                $user_filter = "";
            } else {
                $userload = $this->getUserIntial($saleuser_id, true);
                $user_filter = " and user_id=" . $saleuser_id;
            }
            if ($jobtype_select == 9) {
                $sql = "select * from sold_detail where status = 'sold'  $user_filter";
                $userload.="-sold";
            } else if ($jobtype_select == 10) {
                $sql = "select * from sold_detail where status = 'non-sold' $user_filter";
                $userload.="-non-sold";
            }
            $list_array = $this->db->query($sql)->result_array();
            $records[0] = array('First Name', 'Last Name', 'Email');
            $k = 1;
            foreach ($list_array as $row) {
                $records[$k] = array($row['first_name'], $row['last_name'], $row['email']);
                $k++;
            }
            echo $myarray = array_to_csv($records, $userload . ".csv");
        }
    }

    function sold_nonsold_customer() {
        $data['status_select'] = array(1 => "Non-sold Customers", 2 => "All + Non-sold Customers");
        $this->load->view("exportapi/sold_unsold_customer", $data);
    }

    function getsold_unsold_customers($status = '') {
        $this->load->helper('csv');
        $sql_customer = "select * from customers";
        $customer_record = $this->db->query($sql_customer)->result_array();
        $no_customer = count($customer_record);
        if ($status == 1) {  //for non-sold customers
            $sql_pv = "select concat(dpp_firstname,' ',dpp_lastname) as name, dpp_firstname as first_name,dpp_lastname as last_name,email, city, state, address from proposal where is_schedule =0 and customer_id =0 group by name";
            $sql_swh = "select concat(dpp_firstname,' ',dpp_lastname) as name, dpp_firstname as first_name,dpp_lastname as last_name,email, city, state, address from swhproposal where is_schedule =0 and customer_id =0 group by name";
            $sql_ac = "select concat(first_name,' ',last_name) as name, first_name,last_name,email, city, state, address from acproposal where is_schedule =0 and customer_id =0 group by name";
            $sql_saf = "select concat(dpp_firstname,' ',dpp_lastname) as name, dpp_firstname as first_name,dpp_lastname as last_name,email, city, state, address from safproposal where is_schedule =0 and customer_id =0 group by name";
            $sql_hc = "select concat(dpp_firstname,' ',dpp_lastname) as name, dpp_firstname as first_name,dpp_lastname as last_name,email, city, state, address from homecharging where is_schedule =0 and customer_id =0 group by name";

            $records_pv = $this->db->query($sql_pv)->result_array();
            $records_swh = $this->db->query($sql_swh)->result_array();
            $records_ac = $this->db->query($sql_ac)->result_array();
            $records_saf = $this->db->query($sql_saf)->result_array();
            $records_hc = $this->db->query($sql_hc)->result_array();

            $no_pv = count($records_pv);
            $no_swh = count($records_swh);
            $no_ac = count($records_ac);
            $no_saf = count($records_saf);
            $no_hc = count($records_hc);

//        echo "pv before filter : ".$no_pv;
//        echo "swh before filter : ".$no_swh;
//        echo "ac before filter : ".$no_ac;
//        echo "saf before filter : ".$no_saf;
//        echo "hc before filter : ".$no_hc;

            for ($a = 0; $a < $no_pv; $a++) {  // for pv
                for ($b = 0; $b < $no_customer; $b++) {
                    if ($records_pv[$a]['first_name'] == $customer_record[$b]['first_name'] && $records_pv[$a]['last_name'] == $customer_record[$b]['last_name']) {
                        if ($records_pv[$a]['city'] == $customer_record[$b]['city']) {
                            if ($records_pv[$a]['state'] == $customer_record[$b]['state']) {
                                if ($records_pv[$a]['address'] == $customer_record[$b]['address']) {
                                    if ($records_pv[$a]['email'] == $customer_record[$b]['email']) {
                                        unset($records_pv[$a]);
                                        $no_pv = count($records_pv);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }

            //echo "pv after filter : ".count($records_pv);

            for ($a = 0; $a < $no_swh; $a++) {  // for swh
                for ($b = 0; $b < $no_customer; $b++) {
                    if ($records_swh[$a]['first_name'] == $customer_record[$b]['first_name'] && $records_swh[$a]['last_name'] == $customer_record[$b]['last_name']) {
                        if ($records_swh[$a]['city'] == $customer_record[$b]['city']) {
                            if ($records_swh[$a]['state'] == $customer_record[$b]['state']) {
                                if ($records_swh[$a]['address'] == $customer_record[$b]['address']) {
                                    if ($records_swh[$a]['email'] == $customer_record[$b]['email']) {
                                        unset($records_swh[$a]);
                                        $no_pv = count($records_swh);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }

            //echo "swh after filter : ".count($records_swh);

            for ($a = 0; $a < $no_ac; $a++) {  // for ac
                for ($b = 0; $b < $no_customer; $b++) {
                    if ($records_ac[$a]['first_name'] == $customer_record[$b]['first_name'] && $records_ac[$a]['last_name'] == $customer_record[$b]['last_name']) {
                        if ($records_ac[$a]['city'] == $customer_record[$b]['city']) {
                            if ($records_ac[$a]['state'] == $customer_record[$b]['state']) {
                                if ($records_ac[$a]['address'] == $customer_record[$b]['address']) {
                                    if ($records_ac[$a]['email'] == $customer_record[$b]['email']) {
                                        unset($records_ac[$a]);
                                        $no_ac = count($records_ac);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            //echo "ac after filter : ".count($records_ac);

            for ($a = 0; $a < $no_saf; $a++) {  // for saf
                for ($b = 0; $b < $no_customer; $b++) {
                    if ($records_saf[$a]['first_name'] == $customer_record[$b]['first_name'] && $records_saf[$a]['last_name'] == $customer_record[$b]['last_name']) {
                        if ($records_saf[$a]['city'] == $customer_record[$b]['city']) {
                            if ($records_saf[$a]['state'] == $customer_record[$b]['state']) {
                                if ($records_saf[$a]['address'] == $customer_record[$b]['address']) {
                                    if ($records_saf[$a]['email'] == $customer_record[$b]['email']) {
                                        unset($records_saf[$a]);
                                        $no_saf = count($records_saf);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            //echo "saf after filter : ".count($records_saf);

            for ($a = 0; $a < $no_hc; $a++) {  // for homecharging
                for ($b = 0; $b < $no_customer; $b++) {
                    if ($records_hc[$a]['first_name'] == $customer_record[$b]['first_name'] && $records_hc[$a]['last_name'] == $customer_record[$b]['last_name']) {
                        if ($records_hc[$a]['city'] == $customer_record[$b]['city']) {
                            if ($records_hc[$a]['state'] == $customer_record[$b]['state']) {
                                if ($records_hc[$a]['address'] == $customer_record[$b]['address']) {
                                    if ($records_hc[$a]['email'] == $customer_record[$b]['email']) {
                                        unset($records_hc[$a]);
                                        $no_hc = count($records_hc);
                                        break;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            //echo "hc after filter : ".count($records_hc);

            $total_records = array_merge($records_pv, $records_swh, $records_ac, $records_saf, $records_hc);
            $no_records = count($total_records);
            //echo "total records before filter : ".$no_records;
            for ($i = 0; $i < $no_records; $i++) {
                for ($j = $i + 1; $j < $no_records; $j++) {
                    if ($total_records[$i]['name'] == $total_records[$j]['name']) {
                        unset($total_records[$i]);
                        $no_records = count($total_records);
                        break;
                    }
                }
            }
            //echo "total records after filter : ".count($total_records);
            //die;
            $records[0] = array('First Name', 'Last Name', 'Email');
            $k = 1;
            foreach ($total_records as $row) {
                $records[$k] = array($row['first_name'], $row['last_name'], $row['email']);
                $k++;
            }
            echo $myarray = array_to_csv($records, 'non-sold-customers.csv');
        }

        if ($status == 2) {  //for all+non-sold customers
            $sql_pv = "select concat(dpp_firstname,' ',dpp_lastname) as name, dpp_firstname as first_name,dpp_lastname as last_name,email from proposal group by name";
            $sql_swh = "select concat(dpp_firstname,' ',dpp_lastname) as name, dpp_firstname as first_name,dpp_lastname as last_name,email from swhproposal group by name";
            $sql_ac = "select concat(first_name,' ',last_name) as name, first_name,last_name,email from acproposal group by name";
            $sql_saf = "select concat(dpp_firstname,' ',dpp_lastname) as name, dpp_firstname as first_name,dpp_lastname as last_name,email from safproposal group by name";
            $sql_hc = "select concat(dpp_firstname,' ',dpp_lastname) as name, dpp_firstname as first_name,dpp_lastname as last_name,email from homecharging group by name";



            $records_pv = $this->db->query($sql_pv)->result_array();
            $records_swh = $this->db->query($sql_swh)->result_array();
            $records_ac = $this->db->query($sql_ac)->result_array();
            $records_saf = $this->db->query($sql_saf)->result_array();
            $records_hc = $this->db->query($sql_hc)->result_array();

            $total_records = array_merge($records_pv, $records_swh, $records_ac, $records_saf, $records_hc);

            $no_records = count($total_records);

            for ($i = 0; $i < $no_records; $i++) {
                for ($j = $i + 1; $j < $no_records; $j++) {
                    if ($total_records[$i]['name'] == $total_records[$j]['name']) {
                        unset($total_records[$i]);
                        $no_records = count($total_records);
                        break;
                    }
                }
            }

            $records[0] = array('First Name', 'Last Name', 'Email', 'name');
            $i = 1;
            foreach ($total_records as $row) {
                $records[$i] = array($row['first_name'], $row['last_name'], $row['email'], $row['name']);
                $i++;
            }
            echo $myarray = array_to_csv($records, 'all & non-sold-customers.csv');
        }
    }
    /*new-code-start-24-2-2016-job-report*/ 
    function getArea($pincode){

         $row=$this->db->query('Select neighbour from neigbhour left join neigbhour_pin_codes neg on neg.neighbour_id=neigbhour.id where neg.pin_codes="'.$pincode.'"')->row_array();

         return @$row['neighbour'];
     }
  function getProposalId($job_pid){
      
      $row=$this->db->query('Select proposal_id from jobs where id="'.$job_pid.'"')->row_array();
      
      return @$row['proposal_id'];
  }
  
  function getAllvaribleLaborCost($proposal_id,$job_type,$location_access){
     
      $row=array();
      $text='';
      if($job_type==2 || $job_type==6 || $job_type==7){
          
        if($job_type==2){
            $var_list_order=array('EJ'=>101,'EH'=>102,'RL'=>206);
        }else if($job_type==6){
            $var_list_order=array('RL'=>224);
        }else{
            $var_list_order=array('PM'=>207);
        } 
         
        foreach ($var_list_order as $key=>$val){
            $variable_id=$val;
             
            if($variable_id==101 || $variable_id==102){
                $sqlc = "SELECT  title, variable_job.price AS hours,quantity as price  ,ROUND(quantity*variable_job.price) AS cost,system_price_proposal.proposal_id  FROM variable_job
JOIN system_price_proposal  ON variable_job.`variable_id`=system_price_proposal.`id`
 WHERE  variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.id ='" . $variable_id . "' AND system_price_proposal.location_access ='" . $location_access . "'";
            }else{
                $sqlc = "SELECT  title,quantity AS hours,variable_job.price ,ROUND(quantity*variable_job.price) AS cost,system_price_proposal.proposal_id  FROM variable_job
JOIN system_price_proposal  ON variable_job.`variable_id`=system_price_proposal.`id`
 WHERE  variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.id ='" . $variable_id. "' AND system_price_proposal.location_access ='" . $location_access . "'";
            }
             
            $row = $this->db->query($sqlc)->row_array();
            if (count($row)){
                if($job_type==6){
                    $text.=floatval($row['hours']).' '.$key.' / ';
                }else{
                    $text .=$key.' '.floatval($row['hours']).' / ';
                }
                
            }
            
         }
        }else if($job_type==16 || $job_type==15){
            
            if($job_type==16){
                $var_list_order=array('ACJ'=>35,'EJ'=>33,'AL'=>117);
            }else if($job_type==15){
                $var_list_order=array('AS'=>37);
            }
            foreach ($var_list_order as $key=>$val){
                $variable_id=$val;
                
                $sqlc = "SELECT title, sum(quantity) AS hours, acvariable_job.price as price ,sum(quantity*acvariable_job.price) AS cost,acsystem_price_proposal.proposal_id FROM acvariable_job
    JOIN acsystem_price_proposal  ON acvariable_job.`variable_id`=acsystem_price_proposal.`id`
     WHERE  acvariable_job.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.id ='" . $variable_id. "' AND acsystem_price_proposal.location_access ='" . $location_access . "' ";
                
                $row = $this->db->query($sqlc)->row_array();
                if (count($row)){
                    $text .=$key. ' '.$row['hours'].' / ';
                }
            
            }
        }
        else if($job_type==5 || $job_type==1){
            if($job_type==5){
                $var_list_order=array('WM'=>102);
            }else if($job_type==1){
                $var_list_order=array('PJ'=>99,'RL'=>100);
            }
            foreach ($var_list_order as $key=>$val){
                $variable_id=$val;
                if($key=='RL'){
                    $statement=" AND system_price_swhproposal.id in (100,101)";
                    $cols="SUM(quantity) AS hours";
                }else{
                    $statement=" AND system_price_swhproposal.id ='" . $variable_id. "'";
                    $cols="quantity AS hours";
                }     
                $sqlc = "SELECT  title,$cols,swh_variable_job.price ,ROUND(quantity*swh_variable_job.price) AS cost,system_price_swhproposal.proposal_id  FROM swh_variable_job
JOIN system_price_swhproposal  ON swh_variable_job.`variable_id`=system_price_swhproposal.`id`
 WHERE  swh_variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_swhproposal.`proposal_id`='" . $proposal_id . "' $statement ";
                $row = $this->db->query($sqlc)->row_array();
                    
                    if (count($row)){
                        $text .=$key. ' '.floatval($row['hours']).' / ';
                    }

            }
        }
        if(strlen($text)){
            return substr($text, 0, -2);
        }else{
             return '';
        }
      
  }
  
  function getunit($proposal_id,$sp=0){
      return $this->getProductValue($proposal_id,$sp);
      
        $sql_zone="SELECT * from acproposalzone where acproposal_id='".$proposal_id."'";
	$zones=$this->db->query($sql_zone)->result_array();
        $unitcount=0;
	foreach( $zones as $zdata) {
            $mz_chk1 = $zdata['mzone_rec1_id'];
            $mz_chk2 = $zdata['mzone_rec2_id'];
            $mz_add_check = $zdata['additional_unit_1_price'];
            $mz_rec_check = $zdata['reccomended_unit_1_price'];
            if($mz_chk1>0 && $mz_chk2>0 ){
                //$unitcount+=2;
                continue;
            }else if ($mz_chk1>0 && $mz_add_check==0 ){
                $unitcount+=1;
                continue;
            } else if($mz_chk2>0 && $mz_rec_check>0 ){
                $unitcount+=1;
                continue;
            } else {
                $unitcount+=1;
                if(!$zdata['reccomended_unit_delete'] &&  !$zdata['additional_unit_delete'] && $zdata['additional_unit_1_price']>0 ) { 
                    $unitcount+=2;
                }
                if($zdata['reccomended_unit_delete'] &&  $zdata['additional_unit_delete'] ) { 
                    $unitcount-=1;
                }
            }
        }
        return $unitcount;
    }
 /*new-code-end-24-2-2016-job-report*/
    
    function getProductValue($id,$sp=0){
            $sql = "select reccomended_unit_1,mznewid,zone_type,mzone_rec1_id,mzone_rec2_id,additional_unit_1_price,reccomended_unit_1_price from acproposalzone where acproposal_id=$id  ";
            $vals = $this->db->query($sql)->result_array();
            //print_r($vals);
            if (!empty($vals)) {
                $data = array();
                $data1 = array();
               // $data2 = array();
           foreach ($vals as $val) {
                if((empty($val['reccomended_unit_1']))){continue;}               
                $mz_chk1 = $val['mzone_rec1_id'];
				if ($mz_chk1>0){
					continue;
				}
			  	$data[] =  $val['reccomended_unit_1'];
               
				
				if($val['zone_type']==2){
				 if((empty($val['mznewid']))){continue;}
				  $newzone=explode(",",$val['mznewid']);
				   foreach($newzone as $nzval){
					 $newvalue=(int)$nzval;
					 $data1[]=$sp[$newvalue]['title'];
				   }
				}
               }
            $data2 = array_merge($data, $data1);
            $finalValue = implode(', ', $data2);  
            return $finalValue;
        }
        
    }
}

?>
