<?php

    class Dayview extends Controller {

	function Dayview()
	{
            parent::Controller();
            if(!$this->session->userdata('logged_in') || (!$this->session->userdata("tech_scheduler") && !$this->session->userdata("tech_view") && !$this->session->userdata('superadmin')) )
            {
                //$tempurl = explode("/index.php/", $_SERVER['PHP_SELF']);
                //redirect("login?ref=".$tempurl[1]);
            }
            $this->load->helper(array('form', 'url'));
	}
        
        function index() {
            $date3 = $this->input->get("datepicker3_txt");
            $date2 = $this->input->get("datepicker2_txt");
            $date1 = $this->input->get("datepicker1_txt");

            $data = array();
            $data['date']=date("M d,Y");
            $data['display']=1;
            $date_filter = "";
            $data["dateinterval"] = false;
            $data["date_range"] = false;
            if (isset($date3) && trim($date3) != "") {
                $data["date3"] = $date3;
                $explode_date = explode(";", $date3);
                $date_array = array();
                foreach ($explode_date as $datedata) {
                    $date_array[] = "'" . date("Y-m-d", strtotime($datedata)) . "'";
                }
                $date_filter = "jobs.job_date in (" . implode(",", $date_array) . ")";
                $data["dateinterval"] = true;
                $data['date']=date("M d,Y", strtotime($date3));
                $data['display']=0;
            } else if (isset($date1) && isset($date2) && strtotime($date1) > 0 && strtotime($date2) > 0) {
                $newdate1 = date("Y-m-d", strtotime($date1));
                $newdate2 = date("Y-m-d", strtotime($date2));
                $data["date2"] = $date2;
                $data["date1"] = $date1;
                $date_filter = "jobs.job_date >='$newdate1' AND jobs.job_date<='$newdate2'";
                $data["date_range"] = true;
                $data['date']=date("M d,Y", strtotime($date1))."-".date("M d,Y", strtotime($date2));
                $data['display']=1;
            } else {
                $date_filter = "jobs.job_date='" . date("Y-m-d") . "'";
                $data['display']=0;
            }
            //START JOB FILTER
            
            $data['reasons']['ok'] = 'OK';
            $data['reasons']['1'] = 'SIC';
            $data['reasons']['3'] = 'VAC';
            $data['reasons']['9'] = 'OFF';
            
//            $filter = array();
//            if($this->input->get("pv")){
//               array_push($filter,2);
//            }
//            if($this->input->get("ac")){
//                array_push($filter,16);
//            }
//            if($this->input->get("swh")){
//                array_push($filter,1);
//            }
//            if($this->input->get("pm")){
//                array_push($filter,7);
//            }
//            if($this->input->get("ass")){
//                array_push($filter,15);
//            }
//            if($this->input->get("sc")){
//                array_push($filter,5);
//            }
//            if(count($filter)>0)
//                $filter = implode(",",$filter);
//            else
//                $filter = 0;
//            $pv_sql =" AND jobs.job_type_id in(2,16,1,15,5,7)";
//            if( $filter){
//            $pv_sql = " AND jobs.job_type_id in($filter)";
//           }
//           
           $sql="select * from job_permission where id='1'";
              $permission =$this->db->query($sql)->row_array();
              $job_type_id_arr=array();
              $job_type_id_arr[]=0;
              if( $permission['pv']=='1'|| $this->session->userdata("superadmin")){
                    $job_type_id_arr[]=2;

              }

               if( $permission['ac']=='1'|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=16;
               }
               if($permission['swh']=='1'|| $this->session->userdata("superadmin")){
                    $job_type_id_arr[]=1;
               }
               if($permission['sc']=='1'|| $this->session->userdata("superadmin")){
                     $job_type_id_arr[]=5;
                     $job_type_id_arr[]=26;
               }
               if($permission['pl']=='1'|| $this->session->userdata("superadmin")){
                    $job_type_id_arr[]=6;
               }
               if($permission['ap']=='1'|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=17;
               }
               if($permission['gc']=='1'|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=23;
               }
               if($permission['el']=='1'|| $this->session->userdata("superadmin")){
                     $job_type_id_arr[]=8;
               }
               if($permission['saf']=='1'|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=20;
               }
               if($permission['ev']=='1'|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=21;
               }
//	       start-PHOEN-518
	       if($permission['ev']=='1'|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=25;
               }

			   if($this->session->userdata("superuser")|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=28;
               }

			   if($this->session->userdata("superuser")|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=29;
               }
               if($permission['ev']=='1' || $this->session->userdata("superadmin")) {
                   $job_type_id_arr[]=7;
               }
//              end-PHOEN-518               
             $job_type_str=implode(",",$job_type_id_arr);
             $pv_sql =" AND jobs.job_type_id in($job_type_str)";
           
            //END JOB FILTER
            //Start Code by vikas on 03-03-2016
            $RightsideExist = 1;
            $filterDate = 0;
            if (isset($date1) && isset($date2) && strtotime($date1) > 0 && strtotime($date2) > 0) {
                $from_date = (strtotime($date1)) ? date('m/d/Y', strtotime($date1)) : '';
                $end_date = (strtotime($date2)) ? date('m/d/Y', strtotime($date2)) : '';
                if($from_date == $end_date){
                    $filterDate = date('Y-m-d',  strtotime($date1));
                    $displayTeams = "block";
                }else{
                    $displayTeams = "none";
                    $RightsideExist = 0;
                }
            }else if (isset($date3) && trim($date3) != "" && strtotime($date3) > 0) {
                $filterDate = date('Y-m-d',  strtotime($date3));
                $displayTeams = "block";
            }else{
                $filterDate = date('Y-m-d');
                $displayTeams = "block";
            }
            $data["filterDate"] = $filterDate;
            
            $data["displayTeams"] = $displayTeams;
            $data["RightsideExist"] = $RightsideExist;
            $data['team_details'] = array();
            $data['team_types'] = array();
            
            $this->db->order_by('type', 'asc');
            $inverter_types = $this->db->get("inverter_types")->result_array();
            foreach ($inverter_types as $row) {
                $data['inverter_types'][$row['id']] = $row['type'];
            }
            
            $j = array();
            $jobs = array();
            $j = $this->db->query("SELECT jobs.*, jobs.system_type,colors.hex, users.custom_hex, users.id as user_id ,users.first_name as ufirstname ,
                users.last_name ulastname, cs.first_name as csfirstname ,
                cs.last_name as cslastname ,cs.address as csstate,cs.city as cscity,cs.association as  csassociation,cs.zip_code as  zip_code,
                job_types.intials as job_type
                FROM jobs
                LEFT JOIN job_types ON job_types.id=jobs.job_type_id
                LEFT JOIN  customers cs ON jobs.customer_id = cs.id
                LEFT JOIN users ON jobs.user_id=users.id
                LEFT JOIN colors ON users.color_id=colors.id
                WHERE $date_filter $pv_sql ORDER BY jobs.job_date ASC ,job_type ASC")->result_array();
         
            //echo '<pre>';print_r($j);die;
            $this->db->where("type", "installer");
            $this->db->order_by("first_name", "desc");
            $installeruser = $this->db->get("users")->result_array();
            $installer_data = array();
            $output = array();
            $jobdatearray = array();
            $job_id_list=array();

            // === BATCH PRE-FETCH FOR PERFORMANCE (replaces N+1 per-job queries) ===
            $_all_job_ids = array();
            $_all_customer_ids = array();
            $_all_job_pids = array();
            $_all_zip_codes = array();
            $_all_user_ids = array();
            $_all_roof_type_ids = array();

            foreach ($j as $_jrow) {
                $_all_job_ids[] = intval($_jrow['id']);
                if ($_jrow['customer_id']) $_all_customer_ids[] = intval($_jrow['customer_id']);
                if ($_jrow['job_pid']) $_all_job_pids[] = intval($_jrow['job_pid']);
                if ($_jrow['zip_code'] != '') $_all_zip_codes[] = "'" . addslashes($_jrow['zip_code']) . "'";
                if ($_jrow['user_id']) $_all_user_ids[] = intval($_jrow['user_id']);
                if ($_jrow['project_designer_id']) $_all_user_ids[] = intval($_jrow['project_designer_id']);
                if ($_jrow['installer_id']) {
                    foreach (explode(',', $_jrow['installer_id']) as $_iid) {
                        $_iid = trim($_iid);
                        if ($_iid) $_all_user_ids[] = intval($_iid);
                    }
                }
                if ($_jrow['roof_type_id'] && $_jrow['roof_type_id'] != 'other' && is_numeric($_jrow['roof_type_id'])) {
                    $_all_roof_type_ids[] = intval($_jrow['roof_type_id']);
                }
            }

            $_all_job_ids = array_unique($_all_job_ids);
            $_all_customer_ids = array_unique($_all_customer_ids);
            $_all_job_pids = array_unique($_all_job_pids);
            $_all_zip_codes = array_unique($_all_zip_codes);
            $_all_roof_type_ids = array_unique($_all_roof_type_ids);

            // Batch: Notes by job_id (fetch first to collect note author user_ids)
            $_notes_cache = array();
            if (count($_all_job_ids) > 0) {
                $_notes_rows = $this->db->query("SELECT * FROM notes WHERE job_id IN (" . implode(',', $_all_job_ids) . ")")->result_array();
                foreach ($_notes_rows as $_nr) {
                    if (!isset($_notes_cache[$_nr['job_id']])) $_notes_cache[$_nr['job_id']] = array();
                    $_notes_cache[$_nr['job_id']][] = $_nr;
                    if ($_nr['user_id']) $_all_user_ids[] = intval($_nr['user_id']);
                }
            }
            $_all_user_ids = array_unique($_all_user_ids);

            // Batch: All users (installers, salesmen, engineers, note authors)
            $_user_cache = array();
            if (count($_all_user_ids) > 0) {
                $_user_rows = $this->db->query("SELECT id, first_name, last_name, type FROM users WHERE id IN (" . implode(',', $_all_user_ids) . ")")->result_array();
                foreach ($_user_rows as $_ur) {
                    $_user_cache[$_ur['id']] = $_ur;
                }
            }

            // Batch: Areas by zip code
            $_area_cache = array();
            if (count($_all_zip_codes) > 0) {
                $_area_rows = $this->db->query("SELECT neg.pin_codes, neigbhour.neighbour FROM neigbhour LEFT JOIN neigbhour_pin_codes neg ON neg.neighbour_id=neigbhour.id WHERE neg.pin_codes IN (" . implode(',', $_all_zip_codes) . ")")->result_array();
                foreach ($_area_rows as $_ar) {
                    $_area_cache[$_ar['pin_codes']] = $_ar['neighbour'];
                }
            }

            // Batch: Customer neighborhood colors
            $_neighborhood_cache = array();
            if (count($_all_customer_ids) > 0) {
                $_neigh_rows = $this->db->query("SELECT c.id as cust_id, c.neighborhood, c.other_neighborhood, n.color FROM customers c LEFT JOIN neigbhour n ON c.neighborhood = n.id AND c.neighborhood != 'other' AND c.neighborhood != '' AND c.neighborhood REGEXP '^[0-9]+$' WHERE c.id IN (" . implode(',', $_all_customer_ids) . ")")->result_array();
                foreach ($_neigh_rows as $_nr) {
                    if (!$_nr['neighborhood'] || $_nr['neighborhood'] == 'other' || $_nr['neighborhood'] == '') {
                        $_neighborhood_cache[$_nr['cust_id']] = '#ffffff';
                    } else if (is_numeric($_nr['neighborhood'])) {
                        $_neighborhood_cache[$_nr['cust_id']] = $_nr['color'] ? $_nr['color'] : '#ffffff';
                    } else {
                        $_neighborhood_cache[$_nr['cust_id']] = '#ffffff';
                    }
                }
            }

            // Batch: Related jobs by job_pid (for related job links + job day counting)
            $_related_cache = array();
            if (count($_all_job_pids) > 0) {
                $_rel_rows = $this->db->query("SELECT jobs.id, jobs.job_pid, jobs.job_date, jobs.job_type_id, job_types.intials as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_pid IN (" . implode(',', $_all_job_pids) . ") ORDER BY jobs.job_date ASC")->result_array();
                foreach ($_rel_rows as $_rr) {
                    if (!isset($_related_cache[$_rr['job_pid']])) $_related_cache[$_rr['job_pid']] = array();
                    $_related_cache[$_rr['job_pid']][] = $_rr;
                }
            }

            // Batch: Proposal IDs from parent jobs
            $_proposal_cache = array();
            if (count($_all_job_pids) > 0) {
                $_prop_rows = $this->db->query("SELECT id, proposal_id FROM jobs WHERE id IN (" . implode(',', $_all_job_pids) . ")")->result_array();
                foreach ($_prop_rows as $_pr) {
                    $_proposal_cache[$_pr['id']] = $_pr['proposal_id'];
                }
            }

            // Batch: Proposal details (storage, qoute_nopowerwalls)
            $_proposal_detail_cache = array();
            $_all_proposal_ids = array_values(array_filter(array_unique(array_values($_proposal_cache))));
            if (count($_all_proposal_ids) > 0) {
                $_pd_rows = $this->db->query("SELECT id, storage, qoute_nopowerwalls FROM proposal WHERE id IN (" . implode(',', $_all_proposal_ids) . ")")->result_array();
                foreach ($_pd_rows as $_pd) {
                    $_proposal_detail_cache[$_pd['id']] = $_pd;
                }
            }

            // Batch: AC unit counts from acproposalzone
            $_acunit_cache = array();
            if (count($_all_proposal_ids) > 0) {
                $_acu_rows = $this->db->query("SELECT acproposal_id, mzone_rec1_id, mzone_rec2_id, additional_unit_1_price, reccomended_unit_1_price, reccomended_unit_delete, additional_unit_delete FROM acproposalzone WHERE acproposal_id IN (" . implode(',', $_all_proposal_ids) . ")")->result_array();
                $_acu_grouped = array();
                foreach ($_acu_rows as $_acu) {
                    if (!isset($_acu_grouped[$_acu['acproposal_id']])) $_acu_grouped[$_acu['acproposal_id']] = array();
                    $_acu_grouped[$_acu['acproposal_id']][] = $_acu;
                }
                foreach ($_acu_grouped as $_pid => $_zones) {
                    $_uc = 0;
                    foreach ($_zones as $zdata) {
                        if ($zdata['mzone_rec1_id'] > 0 && $zdata['mzone_rec2_id'] > 0) {
                            continue;
                        } else if ($zdata['mzone_rec1_id'] > 0 && $zdata['additional_unit_1_price'] == 0) {
                            $_uc += 1; continue;
                        } else if ($zdata['mzone_rec2_id'] > 0 && $zdata['reccomended_unit_1_price'] > 0) {
                            $_uc += 1; continue;
                        } else {
                            $_uc += 1;
                            if (!$zdata['reccomended_unit_delete'] && !$zdata['additional_unit_delete'] && $zdata['additional_unit_1_price'] > 0) $_uc += 2;
                            if ($zdata['reccomended_unit_delete'] && $zdata['additional_unit_delete']) $_uc -= 1;
                        }
                    }
                    $_acunit_cache[$_pid] = $_uc;
                }
            }

            // Batch: Roof types
            $_roof_type_cache = array();
            if (count($_all_roof_type_ids) > 0) {
                $_rt_rows = $this->db->query("SELECT id, type FROM roof_types WHERE id IN (" . implode(',', $_all_roof_type_ids) . ")")->result_array();
                foreach ($_rt_rows as $_rt) {
                    $_roof_type_cache[$_rt['id']] = $_rt['type'];
                }
            }
            // === SCH-017: Batch labor cost pre-fetch (replaces per-job getAllvaribleLaborCost) ===
            $_labor_cache = array(); // keyed by proposal_id

            // Collect proposal_ids grouped by variable table type
            $_pv_proposals = array();   // job_type 2,6,7 → variable_job + system_price_proposal
            $_ac_proposals = array();   // job_type 16,15 → acvariable_job + acsystem_price_proposal
            $_swh_proposals = array();  // job_type 5,1 → swh_variable_job + system_price_swhproposal

            foreach ($j as $_lv) {
                $_lpid = isset($_proposal_cache[$_lv['job_pid']]) ? $_proposal_cache[$_lv['job_pid']] : '';
                if (!$_lpid) continue;
                $_ljt = $_lv['job_type_id'];
                $_lla = $_lv['location_access'];
                $_lkey = $_lpid . '_' . $_ljt . '_' . $_lla;
                if (in_array($_ljt, array(2, 6, 7)))  $_pv_proposals[$_lkey] = array('pid' => $_lpid, 'jt' => $_ljt, 'la' => $_lla);
                if (in_array($_ljt, array(16, 15)))    $_ac_proposals[$_lkey] = array('pid' => $_lpid, 'jt' => $_ljt, 'la' => $_lla);
                if (in_array($_ljt, array(5, 1)))      $_swh_proposals[$_lkey] = array('pid' => $_lpid, 'jt' => $_ljt, 'la' => $_lla);
            }

            // PV/PL/PM batch: variable_job + system_price_proposal
            if (count($_pv_proposals) > 0) {
                $_pv_pids = array();
                foreach ($_pv_proposals as $_pp) $_pv_pids[$_pp['pid']] = intval($_pp['pid']);
                $_pids_str = implode(',', $_pv_pids);
                $_pv_var_ids = array(101, 102, 206, 224, 207);
                $_pv_rows = $this->db->query("SELECT variable_job.proposal_id, system_price_proposal.id AS variable_id, variable_job.price AS vj_price, quantity, system_price_proposal.location_access FROM variable_job JOIN system_price_proposal ON variable_job.variable_id = system_price_proposal.id AND system_price_proposal.proposal_id = variable_job.proposal_id WHERE variable_job.proposal_id IN ($_pids_str) AND system_price_proposal.id IN (" . implode(',', $_pv_var_ids) . ")")->result_array();
                // Index: [proposal_id][variable_id][location_access] = row
                $_pv_indexed = array();
                foreach ($_pv_rows as $_pr) {
                    $_pv_indexed[$_pr['proposal_id']][$_pr['variable_id']][$_pr['location_access']] = $_pr;
                }
                // Build labor text for each PV proposal+job_type+location combo
                foreach ($_pv_proposals as $_lkey => $_pp) {
                    $_pid = $_pp['pid']; $_jt = $_pp['jt']; $_la = $_pp['la'];
                    $_text = '';
                    if ($_jt == 2) {
                        $_var_map = array('EJ' => 101, 'EH' => 102, 'RL' => 206);
                    } else if ($_jt == 6) {
                        $_var_map = array('RL' => 224);
                    } else {
                        $_var_map = array('PM' => 207);
                    }
                    foreach ($_var_map as $_label => $_vid) {
                        if (isset($_pv_indexed[$_pid][$_vid][$_la])) {
                            $_r = $_pv_indexed[$_pid][$_vid][$_la];
                            if ($_vid == 101 || $_vid == 102) {
                                $_hours = floatval($_r['vj_price']);
                            } else {
                                $_hours = floatval($_r['quantity']);
                            }
                            if ($_jt == 6) {
                                $_text .= $_hours . ' ' . $_label . ' / ';
                            } else {
                                $_text .= $_label . ' ' . $_hours . ' / ';
                            }
                        }
                    }
                    $_labor_cache[$_lkey] = strlen($_text) ? substr($_text, 0, -2) : '';
                }
            }

            // AC/AS batch: acvariable_job + acsystem_price_proposal
            if (count($_ac_proposals) > 0) {
                $_ac_pids = array();
                foreach ($_ac_proposals as $_ap) $_ac_pids[$_ap['pid']] = intval($_ap['pid']);
                $_apids_str = implode(',', $_ac_pids);
                $_ac_var_ids = array(35, 33, 117, 37);
                $_ac_rows = $this->db->query("SELECT acvariable_job.proposal_id, acsystem_price_proposal.id AS variable_id, SUM(quantity) AS hours, acvariable_job.price, acsystem_price_proposal.location_access FROM acvariable_job JOIN acsystem_price_proposal ON acvariable_job.variable_id = acsystem_price_proposal.id AND acsystem_price_proposal.proposal_id = acvariable_job.proposal_id WHERE acvariable_job.proposal_id IN ($_apids_str) AND acsystem_price_proposal.id IN (" . implode(',', $_ac_var_ids) . ") GROUP BY acvariable_job.proposal_id, acsystem_price_proposal.id, acsystem_price_proposal.location_access")->result_array();
                $_ac_indexed = array();
                foreach ($_ac_rows as $_ar) {
                    $_ac_indexed[$_ar['proposal_id']][$_ar['variable_id']][$_ar['location_access']] = $_ar;
                }
                foreach ($_ac_proposals as $_lkey => $_ap) {
                    $_pid = $_ap['pid']; $_jt = $_ap['jt']; $_la = $_ap['la'];
                    $_text = '';
                    if ($_jt == 16) {
                        $_var_map = array('ACJ' => 35, 'EJ' => 33, 'AL' => 117);
                    } else {
                        $_var_map = array('AS' => 37);
                    }
                    foreach ($_var_map as $_label => $_vid) {
                        if (isset($_ac_indexed[$_pid][$_vid][$_la])) {
                            $_r = $_ac_indexed[$_pid][$_vid][$_la];
                            $_text .= $_label . ' ' . $_r['hours'] . ' / ';
                        }
                    }
                    $_labor_cache[$_lkey] = strlen($_text) ? substr($_text, 0, -2) : '';
                }
            }

            // SWH/SC batch: swh_variable_job + system_price_swhproposal
            if (count($_swh_proposals) > 0) {
                $_swh_pids = array();
                foreach ($_swh_proposals as $_sp) $_swh_pids[$_sp['pid']] = intval($_sp['pid']);
                $_spids_str = implode(',', $_swh_pids);
                $_swh_var_ids = array(99, 100, 101, 102);
                $_swh_rows = $this->db->query("SELECT swh_variable_job.proposal_id, system_price_swhproposal.id AS variable_id, quantity, swh_variable_job.price, system_price_swhproposal.proposal_id AS sp_pid FROM swh_variable_job JOIN system_price_swhproposal ON swh_variable_job.variable_id = system_price_swhproposal.id AND system_price_swhproposal.proposal_id = swh_variable_job.proposal_id WHERE swh_variable_job.proposal_id IN ($_spids_str) AND system_price_swhproposal.id IN (" . implode(',', $_swh_var_ids) . ")")->result_array();
                // Index: [proposal_id][variable_id] = row (but for RL we need sum of 100+101)
                $_swh_indexed = array();
                foreach ($_swh_rows as $_sr) {
                    if (!isset($_swh_indexed[$_sr['proposal_id']][$_sr['variable_id']])) {
                        $_swh_indexed[$_sr['proposal_id']][$_sr['variable_id']] = $_sr;
                    } else {
                        // Sum quantities for RL (100+101)
                        $_swh_indexed[$_sr['proposal_id']][$_sr['variable_id']]['quantity'] += $_sr['quantity'];
                    }
                }
                foreach ($_swh_proposals as $_lkey => $_sp) {
                    $_pid = $_sp['pid']; $_jt = $_sp['jt']; $_la = $_sp['la'];
                    $_text = '';
                    if ($_jt == 5) {
                        $_var_map = array('WM' => 102);
                    } else {
                        $_var_map = array('PJ' => 99, 'RL' => 100);
                    }
                    foreach ($_var_map as $_label => $_vid) {
                        if ($_label == 'RL') {
                            // Sum of 100 + 101
                            $_rl_hours = 0;
                            if (isset($_swh_indexed[$_pid][100])) $_rl_hours += floatval($_swh_indexed[$_pid][100]['quantity']);
                            if (isset($_swh_indexed[$_pid][101])) $_rl_hours += floatval($_swh_indexed[$_pid][101]['quantity']);
                            if ($_rl_hours > 0) {
                                $_text .= $_label . ' ' . $_rl_hours . ' / ';
                            }
                        } else {
                            if (isset($_swh_indexed[$_pid][$_vid])) {
                                $_hours = floatval($_swh_indexed[$_pid][$_vid]['quantity']);
                                $_text .= $_label . ' ' . $_hours . ' / ';
                            }
                        }
                    }
                    $_labor_cache[$_lkey] = strlen($_text) ? substr($_text, 0, -2) : '';
                }
            }
            // === END SCH-017: Batch labor cost ===

            // === END BATCH PRE-FETCH ===

            foreach ($j as $key => $value) {
                array_push($job_id_list,$value['id']);
                $conductid_arr = array();
                $temp_array = array();
                $jobdatetimestamp = strtotime($value["job_date"]);
                $temp_array["job_date"] = $jobdatetimestamp;
                $temp_array["id"]= $value['id'];
                $temp_array["job_pid"]= $value['job_pid'];
                $temp_array["job_type_id"]= $value['job_type_id'];
		//start-PHOEN-526
                $temp_array["user_id"]= $value['user_id'];
                $temp_array["hex"]= $value['hex'];
                $temp_array["custom_hex"]= $value['custom_hex'];
                //end-PHOEN-526
                if($value['job_type']=='PV'){
                    $temp_array["inverter_count"]= $value['inverter_count'];
                    $temp_array["inverter_type_id"]= $value['inverter_type_id'];
                }else{
                    $temp_array["inverter_count"]= 0;
                    $temp_array["inverter_type_id"]= 0;
                }
                
                $temp_array["description"]= $value['servicedesc'];
                $temp_array["labour_allocated"]= $value['labour_allocated'];
                $temp_array["repair_time"]= $value['repair_time'];
                $temp_array["eat_time"]= $value['eat_time'];
                $temp_array["edt_time"]= $value['edt_time'];
                $temp_array["system_type"]= $value['system_type'];
                $temp_array["eng_id"]= $value['project_designer_id'];
                //new code on 04/04/2016
                if($value['dayview_city']!=''){
                       $temp_array["dayview_city"]= $value['dayview_city'];
                }else{
                    $temp_array["dayview_city"]= $value['zip_code'];
                }
                // end code on 04/04/2016
                $ZipArea='';$ZipArea = explode("->", isset($_area_cache[$value['zip_code']]) ? $_area_cache[$value['zip_code']] : '');
                $temp_array["city"]= $ZipArea[0];
                $temp_array["citycolor"] = isset($_neighborhood_cache[$value['customer_id']]) ? $_neighborhood_cache[$value['customer_id']] : '#ffffff';
                $temp_array['id'] = $value['id'];
                $temp_array['type'] = $value['job_type'];
                // Build related job links from cache
                $_rel_links = array();
                if (isset($_related_cache[$value["job_pid"]])) {
                    foreach ($_related_cache[$value["job_pid"]] as $_rj) {
                        if ($_rj['id'] != $value["id"]) {
                            $_rel_links[] = "<a  target='_blank' style='text-decoration:underline;' href='" . base_url() . "admin/job/" . $_rj["id"] . "'>" . $_rj["job_type"] . date("m/d/y", strtotime($_rj["job_date"])) . "</a>";
                        }
                    }
                }
                $temp_array['rel_job'] = implode(",", $_rel_links);
                $temp_array['cname'] = ucfirst($value["csfirstname"]) . " " . ucfirst($value["cslastname"]);
                $temp_array['salesman'] = ucfirst($value["ufirstname"]);
                $temp_array['comments'] = $value["comments"];
                $temp_array['proposal_id'] = $value["proposal_id"];
                $proposal_id = isset($_proposal_cache[$value["job_pid"]]) ? $_proposal_cache[$value["job_pid"]] : '';
                if($value['job_type']=='SWH' ||$value['job_type']=='WM'){
                    $temp_array['nom'] = $value["panel_count"];
                }else if($value['job_type']=='SAF' || $value['job_type']=='EV'){
                    $temp_array['nom'] = $value["no_of_saf"];
                }else if($value['job_type']=='AC' || $value['job_type']=='APM' || $value['job_type']=='AS' ){
                    $temp_array['nom'] = isset($_acunit_cache[$proposal_id]) ? $_acunit_cache[$proposal_id] : 0;
                }else{
                    if($value["job_nom"]>0  )
					$temp_array['nom'] = $value["job_nom"];
					else {
                      $proposal_type = (isset($_proposal_detail_cache[$proposal_id]) && $proposal_id > 0) ? $_proposal_detail_cache[$proposal_id]['storage'] : 0;
					 if( $proposal_type>0)
					$temp_array['nom'] = "Tesla/" . ((isset($_proposal_detail_cache[$proposal_id]) && $proposal_id > 0) ? $_proposal_detail_cache[$proposal_id]['qoute_nopowerwalls'] : 0);
					}
                }
                
                $newstories = "";
                if (isset($value["stories"]) && $value["stories"] != "") {
                    $newstories = $value["stories"] . " / ";
                }
                // Roof type from cache (replaces getidothervalue)
                $_rt_val = '';
                if ($value['roof_type_id'] == 'other' || $value['roof_type_id'] == '' || !$value['roof_type_id']) {
                    $_rt_val = $value['other_roof_type'];
                } else {
                    $_rt_val = isset($_roof_type_cache[$value['roof_type_id']]) ? $_roof_type_cache[$value['roof_type_id']] : '';
                }
                $temp_array['rooftype'] = @$newstories . $_rt_val;
                $installer_id_table = array();
                $installer_id_table = explode(",", $value['installer_id']);
                $newnoassign = array();
                foreach ($installer_id_table as $id) {
                    $id = trim($id);
                    $_ui_name = '';
                    if ($id && isset($_user_cache[$id])) {
                        $_ui_name = ucfirst($_user_cache[$id]['first_name']) . " " . ucfirst($_user_cache[$id]['last_name']);
                    }
                    if ($_ui_name)
                        $newnoassign[] = '<div class="instBox" id="rinstaller' . $id . $value['id'] . '"><a href="javascript:void(0);" >' . $_ui_name . '</a><a  onclick="removeinstaller(' . $id . ',' . $value['id'] . ')" href="javascript:void(0);" class="instCross"></a></div>';
                }
                
                if (count($newnoassign) >= 1)
                    $temp_array['installer'] = implode(" ", $newnoassign);
                else {
                    $temp_array['installer'] = "";
                }
                // SCH-017: Use batch labor cache instead of per-job query
                $_labor_key = $proposal_id . '_' . $value["job_type_id"] . '_' . $value["location_access"];
                $temp_array['varibleLaborCost'] = isset($_labor_cache[$_labor_key]) ? $_labor_cache[$_labor_key] : '';
                // Build notes from cache (replaces getnote)
                $_note_parts = array();
                if (isset($_notes_cache[$value["id"]])) {
                    foreach ($_notes_cache[$value["id"]] as $_n) {
                        $_note_author = '';
                        if (isset($_user_cache[$_n['user_id']])) {
                            $_note_author = ucfirst($_user_cache[$_n['user_id']]['first_name']) . " " . ucfirst($_user_cache[$_n['user_id']]['last_name']);
                        }
                        $_note_parts[] = @$_n["note"] . "(Posted by:" . $_note_author . ", " . date("m/d/y", strtotime($_n["created"])) . ")";
                    }
                }
                $temp_array['note'] = implode(",", $_note_parts);
              
                // Job day counting from cache (replaces getjobday/getacjobday)
                $temp_array['day_name']="";
                if (($value["job_type_id"]==2 || $value["job_type_id"]==6 || $value["job_type_id"]==16) && isset($_related_cache[$value["job_pid"]])) {
                    $_day_type_filter = ($value["job_type_id"]==16) ? array(16) : array(2, 6);
                    $_day_count = 0;
                    $_day_pos = 0;
                    foreach ($_related_cache[$value["job_pid"]] as $_dj) {
                        if (in_array($_dj['job_type_id'], $_day_type_filter)) {
                            $_day_count++;
                            if ($_dj['id'] == $value["id"]) $_day_pos = $_day_count;
                        }
                    }
                    if ($_day_pos == 1 && $_day_count != 1) {
                        $temp_array['day_name'] = "1st day of $_day_count  day job";
                    } else if ($_day_pos == 2) {
                        $temp_array['day_name'] = "2nd day of $_day_count  day job";
                    } else if ($_day_pos == 3) {
                        $temp_array['day_name'] = "3rd day of $_day_count  day job";
                    } else if ($_day_pos == 4) {
                        $temp_array['day_name'] = "4th day of $_day_count  day job";
                    }
                }
                $output[] = $temp_array;
                
            }
            
            
                if(count($job_id_list)>0)
                      $job_id_list = implode(",",$job_id_list);
                 else
                     $job_id_list = 0;
                     $job_id_sql ="";
                 if( $job_id_list){
                     $job_id_sql = " AND job_id in($job_id_list)"; 
                 }
                 
             if(@$RightsideExist){
                $filter_by_date = "and DATE_FORMAT(request.start_date,'%Y-%m-%d') <= '".$filterDate."' AND DATE_FORMAT(request.end_date,'%Y-%m-%d') >= '".$filterDate."'";
                $team_types = $this->db->query("select * from technician_team_types order by id")->result_array();
                $data['team_types'] = $team_types;

                // --- SCH-011: Batch pre-fetch for teams section ---
                // Step 1: Batch fetch ALL team assignments across all types in one query
                $this->db = $this->load->database('default', true);
                $_team_all_assigns = $this->db->query(
                    "SELECT team_names.id as technician_team_id, team_names.created as team_created,
                            team_names.team_name, team_names.team_type_id,
                            assigns.technician_id_time, assigns.technician_id_pheo,
                            assigns.technician_email, assigns.assigned, assigns.team_type_id as assign_type_id
                     FROM technician_teams as team_names
                     LEFT JOIN technicians_assign as assigns ON team_names.id = assigns.team_id
                        AND assigns.team_type_id = team_names.team_type_id
                     WHERE team_names.team_type_id IN (SELECT id FROM technician_team_types)
                     ORDER BY team_names.team_type_id, team_names.id"
                )->result_array();

                // Index by team_type_id -> team_id -> rows
                $_team_grouped = array();
                $_team_pheo_ids = array();
                $_team_time_ids = array();
                foreach ($_team_all_assigns as $_ta) {
                    if (!empty($_ta['technician_id_pheo'])) {
                        $_team_grouped[$_ta['team_type_id']][$_ta['technician_team_id']][] = $_ta;
                        $_team_pheo_ids[$_ta['technician_id_pheo']] = $_ta['technician_id_pheo'];
                    }
                    if (!empty($_ta['technician_id_time'])) {
                        $_team_time_ids[$_ta['technician_id_time']] = $_ta['technician_id_time'];
                    }
                }

                // Step 2: Batch fetch from default DB (replaces GetUserName + GetTechnicianType)
                $_team_user_cache = array();
                if (count($_team_pheo_ids) > 0) {
                    $_pheo_csv = implode(',', $_team_pheo_ids);
                    $_team_users_rows = $this->db->query(
                        "SELECT id, first_name, last_name, type FROM users WHERE id IN ($_pheo_csv)"
                    )->result_array();
                    foreach ($_team_users_rows as $_tu) {
                        $_team_user_cache[$_tu['id']] = $_tu;
                    }
                }

                // Step 3: Batch check_assigned (replaces per-tech technicians_in_jobs query)
                $_team_assigned_cache = array();
                if (count($_team_pheo_ids) > 0 && $job_id_sql) {
                    $_assigned_rows = $this->db->query(
                        "SELECT DISTINCT technician_id_pheo FROM technicians_in_jobs
                         WHERE technician_id_pheo IN ($_pheo_csv) $job_id_sql"
                    )->result_array();
                    foreach ($_assigned_rows as $_ar) {
                        $_team_assigned_cache[$_ar['technician_id_pheo']] = 1;
                    }
                }

                // Step 4: Batch fetch from otherdb (replaces per-tech timeoff + timesheet)
                $_team_timeoff_cache = array();
                $_team_timesheet_cache = array();
                if (count($_team_time_ids) > 0) {
                    $_time_csv = implode(',', $_team_time_ids);
                    $this->db2 = $this->load->database('otherdb', true);

                    // Timeoff batch (keep most recent per user via ORDER BY DESC)
                    $_timeoff_rows = $this->db2->query(
                        "SELECT request.*, emp_users.first_name, emp_users.last_name,
                                emp_users.id as user_id, codes.name as reason
                         FROM emp_timeoff_request as request
                         LEFT JOIN emp_users ON request.user_id = emp_users.id
                         LEFT JOIN absence_codes as codes ON request.timeoff_reason = codes.id
                         WHERE request.user_id IN ($_time_csv) $filter_by_date
                         ORDER BY request.id DESC"
                    )->result_array();
                    foreach ($_timeoff_rows as $_to) {
                        // Only keep first (most recent) per user_id
                        if (!isset($_team_timeoff_cache[$_to['user_id']])) {
                            $_team_timeoff_cache[$_to['user_id']] = $_to;
                        }
                    }

                    // Timesheet batch
                    //change  by satyendra on 12-5-16
                    if(date('D',strtotime("$filterDate"))=='Sun'){
                         $from_W_date=date('Y-m-d',strtotime('this Sunday',strtotime("$filterDate")));
                    }else{
                        $from_W_date=date('Y-m-d',strtotime('last Sunday',strtotime("$filterDate")));
                    }
                    $to_W_date=date('Y-m-d',  strtotime('+6 days',strtotime("$from_W_date")));
                    //END change by satyendra on 12-5-16

                    $_timesheet_rows = $this->db2->query(
                        "SELECT t_c.* FROM user_calculated_time_sheet_details as t_c
                         WHERE t_c.user_id IN ($_time_csv)
                         AND t_c.submited_date BETWEEN '$from_W_date' AND '$to_W_date'"
                    )->result_array();
                    foreach ($_timesheet_rows as $_ts) {
                        $_team_timesheet_cache[$_ts['user_id']] = $_ts;
                    }
                    $this->db2->close();
                }
                // --- END SCH-011 batch pre-fetch ---

                foreach ($team_types as $types)
                {
                    // Use pre-grouped data instead of per-type query
                    if (!isset($_team_grouped[$types['id']]) || count($_team_grouped[$types['id']]) == 0) {
                        continue;
                    }
                    $count = 1;
                    foreach ($_team_grouped[$types['id']] as $_team_id => $_team_techs)
                    {
                        if (count($_team_techs) > 0) {
                            foreach ($_team_techs as $Technicians)
                            {
                                $team_wise_data = array();
                                $_tid = $Technicians['technician_id_pheo'];

                                // GetUserName from cache (replaces per-tech query)
                                $technicianss_name = '';
                                if (isset($_team_user_cache[$_tid])) {
                                    $_u = $_team_user_cache[$_tid];
                                    $technicianss_name = ucfirst($_u['first_name']) . " " . ucfirst($_u['last_name']);
                                    if (strlen($technicianss_name) > 15) {
                                        $technicianss_name = substr($technicianss_name, 0, 25) . "..";
                                    }
                                }

                                // GetTechnicianType from cache (replaces per-tech query)
                                $technicians_type = 0;
                                if (isset($_team_user_cache[$_tid]) && $_team_user_cache[$_tid]['type'] == 'lead_tech') {
                                    $technicians_type = 'L';
                                }
                                $team_wise_data['technicians_type'] = $technicians_type;

                                $team_wise_data['technicians_names'] = $technicianss_name;
                                $team_wise_data['team_type_id'] = $types['id'];
                                $team_wise_data['technician_team_id'] = $_team_id;
                                $team_wise_data['team_type'] = $types['team_type_name'];

                                // check_assigned from cache (replaces per-tech query)
                                $team_wise_data['assigned'] = isset($_team_assigned_cache[$_tid]) ? 1 : 0;

                                $team_wise_data['team_name'] = $Technicians['team_name'];
                                $team_wise_data['team_created'] = $Technicians['team_created'];

                                $team_wise_data['technician_id_time'] = $Technicians['technician_id_time'];
                                $team_wise_data['technician_id_pheo'] = $Technicians['technician_id_pheo'];

                                $team_wise_data['techInTeam'] = ucfirst($Technicians['team_name'][0]).ucfirst($Technicians['team_name'][1]).$count;

                                // Timeoff from cache (replaces per-tech otherdb query)
                                $_time_id = $Technicians['technician_id_time'];
                                if (isset($_team_timeoff_cache[$_time_id])) {
                                    $details = $_team_timeoff_cache[$_time_id];
                                    if ($details['request_status'] == 'approved' && $details['confirm_request'] == 'Y') {
                                        $team_wise_data['technician_status'] = ucfirst($details['reason'][0]).ucfirst($details['reason'][1]).ucfirst($details['reason'][2]);
                                        $team_wise_data['timeoff_request_id'] = $details['id'];

                                        if ($details['timeoff_reason'] == 1) {
                                            $team_wise_data['timeoff_reason'] = 1;
                                        } else if ($details['timeoff_reason'] == 3) {
                                            $team_wise_data['timeoff_reason'] = 3;
                                        } else {
                                            $team_wise_data['timeoff_reason'] = 9;
                                        }
                                    } else {
                                        $team_wise_data['technician_status'] = 'OK';
                                        $team_wise_data['timeoff_request_id'] = 0;
                                        $team_wise_data['timeoff_reason'] = 'ok';
                                    }
                                } else {
                                    $team_wise_data['technician_status'] = 'OK';
                                    $team_wise_data['timeoff_request_id'] = 0;
                                    $team_wise_data['timeoff_reason'] = 'ok';
                                }

                                // Timesheet from cache (replaces per-tech otherdb query)
                                if (isset($_team_timesheet_cache[$_time_id])) {
                                    $TimeSheetdetails = $_team_timesheet_cache[$_time_id];
                                    $team_wise_data['technician_worked_hours'] = $TimeSheetdetails['reg_hrs'] + $TimeSheetdetails['ot'];
                                } else {
                                    $team_wise_data['technician_worked_hours'] = 0;
                                }

                                $data['team_details'][$types['id']][$Technicians['team_name']][] = $team_wise_data;
                            }
                            $count++;
                        }
                    }
                }
            }
            //echo '<pre>';print_r($data['team_details']);die;
            $sql="select * from job_permission where id='1'";
            $data['permission']=$this->db->query($sql)->row_array();
      
            $data["jobs"] = $output;
//           <!-- start-code-11-4-2016 -->
            // === SCH-017: Filter technicians_in_jobs to current day's jobs only ===
            if (count($_all_job_ids) > 0) {
                $_jid_str = implode(',', $_all_job_ids);
                $tech_rows = $this->db->query("SELECT technicians_in_jobs.*, team_type_name FROM technicians_in_jobs LEFT JOIN technician_team_types ON technician_team_types.id = technicians_in_jobs.team_type_id WHERE technicians_in_jobs.job_id IN ($_jid_str) ORDER BY created")->result_array();
            } else {
                $tech_rows = array();
            }
            // Index by job_id for O(1) lookup in view
            $data["technicians_by_job"] = array();
            foreach ($tech_rows as $tr) {
                $data["technicians_by_job"][$tr['job_id']][] = $tr;
            }
            // Keep flat array for backward compat with drag-drop JS
            $data["technicians_details_jobwise"] = $tech_rows;

            // SCH-017: Add technician user IDs to user cache for view lookups
            $_tech_user_ids = array();
            foreach ($tech_rows as $_tr) {
                if ($_tr['technician_id_pheo']) $_tech_user_ids[] = intval($_tr['technician_id_pheo']);
            }
            $_tech_user_ids = array_diff(array_unique($_tech_user_ids), array_keys($_user_cache));
            if (count($_tech_user_ids) > 0) {
                $_tu_rows = $this->db->query("SELECT id, first_name, last_name, type FROM users WHERE id IN (" . implode(',', $_tech_user_ids) . ")")->result_array();
                foreach ($_tu_rows as $_tu) {
                    $_user_cache[$_tu['id']] = $_tu;
                }
            }

            // SCH-017: Batch job help topics for SC/SP/EL/GC jobs
            $_topic_cache = array();
            $_sc_job_ids = array();
            foreach ($j as $_tv) {
                if (in_array($_tv['job_type_id'], array(5, 25, 26, 8, 23))) {
                    $_sc_job_ids[] = intval($_tv['id']);
                }
            }
            if (count($_sc_job_ids) > 0) {
                $_sc_str = implode(',', $_sc_job_ids);
                $_topics = $this->db->query("SELECT tjob.job_id, ticket.topic_id FROM ost_ticket ticket LEFT JOIN osticket tjob ON tjob.os_ticket = ticket.ticket_id WHERE tjob.job_id IN ($_sc_str)")->result_array();
                foreach ($_topics as $_t) {
                    $_topic_cache[$_t['job_id']] = $_t['topic_id'];
                }
            }
            $data['_topic_cache'] = $_topic_cache;

            // SCH-017: Pass user cache to view (eliminates getEng + GetUserName N+1)
            $data['_user_cache'] = $_user_cache;
            // === END SCH-017: technicians_in_jobs ===

            $this->load->view("dayview/index", $data);
        }
        
        function save_reason(){
            $timesheetId =   $this->input->post("timesheetId");
            $reasonValue = $this->input->post("did");
            $timeOffid = $this->input->post("timeOffid");
            $timeStamp = $this->input->post("timeStamp");
            $start_date = date('Y-m-d',$this->input->post("timeStamp"));
            
            $row = array();
            $row['user_id'] = $this->input->post("timesheetId");
            $row['start_date'] = date('Y-m-d',$this->input->post("timeStamp"));
            $row['end_date'] = date('Y-m-d',$this->input->post("timeStamp"));
            $row['hours_leave'] = 8;
            $row['request_date']=date('Y-m-d H:i:s');
            
            if($reasonValue == 1){
                $row['deduct_from_bank'] = 4;
                $row['timeoff_reason'] = 1;
            }else if($reasonValue == 3){
                $row['deduct_from_bank'] = 2;
                $row['timeoff_reason'] = 3;
            }else if($reasonValue == 9){
                $row['deduct_from_bank'] = 3;
                $row['timeoff_reason'] = 9;
            }else{
                $row['deduct_from_bank'] = 9999;
                $row['timeoff_reason'] = 9999;
            }
            
            $this->db2 = $this->load->database('otherdb', true);
            $row_plan = $this->db2->query("SELECT * FROM emp_timeoff_request WHERE user_id=".$timesheetId." and id=".$timeOffid."")->row_array();
            if(count($row_plan) > 0){
                if($reasonValue == 'ok'){
                    $row['request_status']= 'pending';
                    $row['confirm_request']= 'N';
                    $this->db2->where(array('user_id' => $timesheetId, 'id' => $timeOffid));
                    $this->db2->delete("emp_timeoff_request");
                }else{
                    $row['request_status']= 'approved';
                    $row['confirm_request']= 'Y';
                    $this->db2->where(array('user_id' => $timesheetId, 'id' => $timeOffid));
                    $this->db2->update("emp_timeoff_request",$row);
                }
            }else{
                if($reasonValue == 'ok'){
                    $row['deduct_from_bank'] = 0;
                }else{
                    $row['request_status']= 'approved';
                    $row['confirm_request']= 'Y';
                    $this->db2->insert("emp_timeoff_request",$row);
                }
            }
            //$this->db2->last_query();die;
            $json['success'] = true;
            $this->db2->close();
            $json['reasonValue'] = $reasonValue;
            echo json_encode($json);
        }
        
    //start new code on 07/03/2016      
        function exportjob() {
            $this->load->helper('download');
            $date3 = $this->input->get("datepicker3_txt");
            $date2 = $this->input->get("datepicker2_txt");
            $date1 = $this->input->get("datepicker1_txt");
            $data = array();
            $data['date']=date("M d,Y");
            $data['display']=1;
            $date_filter = "";
            $data["dateinterval"] = false;
            $data["date_range"] = false;
            if (isset($date3) && trim($date3) != "") {
                $data["date3"] = $date3;
                $explode_date = explode(";", $date3);
                $date_array = array();
                foreach ($explode_date as $datedata) {
                    $date_array[] = "'" . date("Y-m-d", strtotime($datedata)) . "'";
                }
                $date_filter = "jobs.job_date in (" . implode(",", $date_array) . ")";
                $data["dateinterval"] = true;
                $data['date']=date("M d,Y", strtotime($date3));
                $data['display']=0;
            } else if (isset($date1) && isset($date2) && strtotime($date1) > 0 && strtotime($date2) > 0) {
                $newdate1 = date("Y-m-d", strtotime($date1));
                $newdate2 = date("Y-m-d", strtotime($date2));
                $data["date2"] = $date2;
                $data["date1"] = $date1;
                $date_filter = "jobs.job_date >='$newdate1' AND jobs.job_date<='$newdate2'";
                $data["date_range"] = true;
                $data['date']=date("M d,Y", strtotime($date1))."-".date("M d,Y", strtotime($date2));
                $data['display']=1;
            } else {
                $date_filter = "jobs.job_date='" . date("Y-m-d") . "'";
            }
            //START JOB FILTER
            
            $filter = array();
            if($this->input->get("pv")){
               array_push($filter,2);
            }
            if($this->input->get("ac")){
                array_push($filter,16);
            }
            if($this->input->get("swh")){
                array_push($filter,1);
            }
            if($this->input->get("pm")){
                array_push($filter,7);
            }
            if($this->input->get("ass")){
                array_push($filter,15);
            }
            if($this->input->get("sc")){
                array_push($filter,5);
            }
            if(count($filter)>0)
                $filter = implode(",",$filter);
            else
                $filter = 0;
            $pv_sql =" AND jobs.job_type_id in(2,16,1,15,5,7)";
            if( $filter){
            $pv_sql = " AND jobs.job_type_id in($filter)";
           }
           $sql="select * from job_permission where id='1'";
              $permission =$this->db->query($sql)->row_array();
              $job_type_id_arr=array();
              $job_type_id_arr[]=0;
              if( $permission['pv']=='1'|| $this->session->userdata("superadmin")){
                    $job_type_id_arr[]=2;

              }

               if( $permission['ac']=='1'|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=16;
               }
               if($permission['swh']=='1'|| $this->session->userdata("superadmin")){
                    $job_type_id_arr[]=1;
               }
               if($permission['sc']=='1'|| $this->session->userdata("superadmin")){
                     $job_type_id_arr[]=5;
               }
               if($permission['pl']=='1'|| $this->session->userdata("superadmin")){
                    $job_type_id_arr[]=6;
               }
               if($permission['ap']=='1'|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=17;
               }
               if($permission['gc']=='1'|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=23;
               }
               if($permission['el']=='1'|| $this->session->userdata("superadmin")){
                     $job_type_id_arr[]=8;
               }
               if($permission['saf']=='1'|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=20;
               }
               if($permission['ev']=='1'|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=21;
               }
                 //	       start-PHOEN-518
	       if($permission['ev']=='1'|| $this->session->userdata("superadmin")){
                   $job_type_id_arr[]=25;
               }
//              end-PHOEN-518                
             $job_type_str=implode(",",$job_type_id_arr);
             $pv_sql =" AND jobs.job_type_id in($job_type_str)";
        $j = array();
        $jobs = array();
        $j = $this->db->query("SELECT jobs.*,colors.hex, users.custom_hex, users.id as user_id ,users.first_name as ufirstname ,
            users.last_name ulastname, cs.first_name as csfirstname ,
            cs.last_name as cslastname ,cs.address as csstate,cs.city as cscity,cs.association as  csassociation,cs.zip_code as  zip_code,
            job_types.intials as job_type
            FROM jobs
            LEFT JOIN job_types ON job_types.id=jobs.job_type_id
            LEFT JOIN  customers cs ON jobs.customer_id = cs.id
            LEFT JOIN users ON jobs.user_id=users.id
            LEFT JOIN colors ON users.color_id=colors.id
            WHERE $date_filter $pv_sql ORDER BY jobs.job_date ASC")->result_array();
        
         $temp_array = array();
         $output = array();
         $data['j']=$j;       
                $module_position=1;
                $output="";
                $headingoutput=array();
                $headingoutput[]="SRno.";
                $headingoutput[]="Job Type.";
                $headingoutput[]="Customer Name";
                $headingoutput[]="Sales";
                $headingoutput[]="Engineer";
                $headingoutput[]="Area";
                $headingoutput[]="Related Job";
                $headingoutput[]="Panels/Units";
                $headingoutput[]="Stories/Roof Type";
                $headingoutput[]="Time Allocated";
                $headingoutput[]="Time(For SC)";
                $headingoutput[]="Labour Allocated";
                $headingoutput[]="Notes";
                $headingoutput[]="Discription(For SC)";
                $output.="\n".implode(",",$headingoutput);
                
                $row_output=array();
                $job=$data['j']; 
                if (count($job)==0 ){ 
                $row_output[]="No Details \n";
                $output.="\n".implode(",",$row_output);
              
            } else{
            $k=1;

            // --- SCH-010: Batch pre-fetch for exportjob ---
            $_exp_job_pids = array();
            $_exp_zip_codes = array();
            $_exp_designer_ids = array();
            $_exp_roof_type_ids = array();
            foreach ($j as $_ej) {
                if ($_ej['job_pid'] > 0) $_exp_job_pids[] = intval($_ej['job_pid']);
                if (trim($_ej['zip_code']) != '') $_exp_zip_codes[] = $this->db->escape_str($_ej['zip_code']);
                if (@$_ej['project_designer_id'] > 0) $_exp_designer_ids[] = intval($_ej['project_designer_id']);
                if ($_ej['roof_type_id'] > 0 && $_ej['roof_type_id'] != 'other' && $_ej['roof_type_id'] != '') $_exp_roof_type_ids[] = intval($_ej['roof_type_id']);
            }

            // Batch: Engineers (users by designer ID)
            $_exp_eng_cache = array();
            $_exp_designer_ids = array_unique(array_filter($_exp_designer_ids));
            if (!empty($_exp_designer_ids)) {
                $_exp_eng_in = implode(',', $_exp_designer_ids);
                $_exp_eng_rows = $this->db->query("SELECT id, first_name, last_name FROM users WHERE id IN ($_exp_eng_in)")->result_array();
                foreach ($_exp_eng_rows as $_er) {
                    $_exp_eng_cache[$_er['id']] = ucfirst($_er['first_name']) . " " . ucfirst($_er['last_name']);
                }
            }

            // Batch: Areas (neighborhood by zip code)
            $_exp_area_cache = array();
            $_exp_zip_codes = array_unique(array_filter($_exp_zip_codes));
            if (!empty($_exp_zip_codes)) {
                $_exp_zip_in = "'" . implode("','", $_exp_zip_codes) . "'";
                $_exp_area_rows = $this->db->query("SELECT neg.pin_codes, neigbhour.neighbour FROM neigbhour LEFT JOIN neigbhour_pin_codes neg ON neg.neighbour_id=neigbhour.id WHERE neg.pin_codes IN ($_exp_zip_in)")->result_array();
                foreach ($_exp_area_rows as $_ar) {
                    $_exp_area_cache[$_ar['pin_codes']] = $_ar['neighbour'];
                }
            }

            // Batch: Related jobs (siblings by job_pid)
            $_exp_related_cache = array();
            $_exp_job_pids = array_unique(array_filter($_exp_job_pids));
            if (!empty($_exp_job_pids)) {
                $_exp_pid_in = implode(',', $_exp_job_pids);
                $_exp_rel_rows = $this->db->query("SELECT jobs.id, jobs.job_pid, jobs.job_date, job_types.intials as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_pid IN ($_exp_pid_in) ORDER BY jobs.job_date ASC")->result_array();
                foreach ($_exp_rel_rows as $_rr) {
                    if (!isset($_exp_related_cache[$_rr['job_pid']])) $_exp_related_cache[$_rr['job_pid']] = array();
                    $_exp_related_cache[$_rr['job_pid']][] = $_rr;
                }
            }

            // Batch: Proposal IDs (from parent jobs)
            $_exp_proposal_cache = array();
            if (!empty($_exp_job_pids)) {
                $_exp_prop_rows = $this->db->query("SELECT id, proposal_id FROM jobs WHERE id IN ($_exp_pid_in)")->result_array();
                foreach ($_exp_prop_rows as $_pr) {
                    $_exp_proposal_cache[$_pr['id']] = $_pr['proposal_id'];
                }
            }

            // Batch: AC units (from acproposalzone — replicate getunit() logic)
            $_exp_acunit_cache = array();
            $_exp_proposal_ids = array_unique(array_filter(array_values($_exp_proposal_cache)));
            if (!empty($_exp_proposal_ids)) {
                $_exp_propid_in = implode(',', $_exp_proposal_ids);
                $_exp_zone_rows = $this->db->query("SELECT acproposal_id, mzone_rec1_id, mzone_rec2_id, additional_unit_1_price, reccomended_unit_1_price, reccomended_unit_delete, additional_unit_delete FROM acproposalzone WHERE acproposal_id IN ($_exp_propid_in)")->result_array();
                $_exp_zone_by_prop = array();
                foreach ($_exp_zone_rows as $_zr) {
                    if (!isset($_exp_zone_by_prop[$_zr['acproposal_id']])) $_exp_zone_by_prop[$_zr['acproposal_id']] = array();
                    $_exp_zone_by_prop[$_zr['acproposal_id']][] = $_zr;
                }
                foreach ($_exp_zone_by_prop as $_prop_id => $_zones) {
                    $unitcount = 0;
                    foreach ($_zones as $_zdata) {
                        $mz_chk1 = $_zdata['mzone_rec1_id'];
                        $mz_chk2 = $_zdata['mzone_rec2_id'];
                        $mz_add_check = $_zdata['additional_unit_1_price'];
                        $mz_rec_check = $_zdata['reccomended_unit_1_price'];
                        if ($mz_chk1 > 0 && $mz_chk2 > 0) {
                            continue;
                        } else if ($mz_chk1 > 0 && $mz_add_check == 0) {
                            $unitcount += 1;
                            continue;
                        } else if ($mz_chk2 > 0 && $mz_rec_check > 0) {
                            $unitcount += 1;
                            continue;
                        } else {
                            $unitcount += 1;
                            if (!$_zdata['reccomended_unit_delete'] && !$_zdata['additional_unit_delete'] && $_zdata['additional_unit_1_price'] > 0) {
                                $unitcount += 2;
                            }
                            if ($_zdata['reccomended_unit_delete'] && $_zdata['additional_unit_delete']) {
                                $unitcount -= 1;
                            }
                        }
                    }
                    $_exp_acunit_cache[$_prop_id] = $unitcount;
                }
            }

            // Batch: Roof types
            $_exp_roof_cache = array();
            $_exp_roof_type_ids = array_unique(array_filter($_exp_roof_type_ids));
            if (!empty($_exp_roof_type_ids)) {
                $_exp_rt_in = implode(',', $_exp_roof_type_ids);
                $_exp_rt_rows = $this->db->query("SELECT id, type FROM roof_types WHERE id IN ($_exp_rt_in)")->result_array();
                foreach ($_exp_rt_rows as $_rt) {
                    $_exp_roof_cache[$_rt['id']] = $_rt['type'];
                }
            }
            // --- End SCH-010 batch pre-fetch ---

            foreach ($j as $key => $value) {
                       $row_output[]= $k;
                       $k++;
                       $row_output[]=$value['job_type'];
                       $row_output[]= ucfirst($value["csfirstname"]) . " " . ucfirst($value["cslastname"]);
                       $row_output[]= ucfirst($value["ufirstname"]);
                       // SCH-010: cached engineer name
                       $row_output[]= isset($_exp_eng_cache[@$value['project_designer_id']]) ? $_exp_eng_cache[$value['project_designer_id']] : '';
                       // SCH-010: cached area
                       $ZipArea='';$ZipArea = explode("->", isset($_exp_area_cache[$value['zip_code']]) ? $_exp_area_cache[$value['zip_code']] : '');
                       $row_output[]= $ZipArea[0];
                       // SCH-010: cached related jobs
                       $_exp_rel_links = array();
                       if (isset($_exp_related_cache[$value["job_pid"]])) {
                           foreach ($_exp_related_cache[$value["job_pid"]] as $_rj) {
                               if ($_rj['id'] != $value['id']) {
                                   $_exp_rel_links[] = $_rj['job_type'] . date("m/d/y", strtotime($_rj['job_date']));
                               }
                           }
                       }
                       $row_output[]= implode(",", $_exp_rel_links);
                            // SCH-010: cached proposal ID
                            $proposal_id = isset($_exp_proposal_cache[$value["job_pid"]]) ? $_exp_proposal_cache[$value["job_pid"]] : '';
                            if($value['job_type']=='SWH' ||$value['job_type']=='WM'){
                                $temp_array['nom'] = $value["panel_count"];
                            }else if($value['job_type']=='SAF' || $value['job_type']=='EV'){
                                $temp_array['nom'] = $value["no_of_saf"];
                            }else if($value['job_type']=='AC' || $value['job_type']=='APM' || $value['job_type']=='AS' ){
                                // SCH-010: cached AC unit count
                                $temp_array['nom'] = isset($_exp_acunit_cache[$proposal_id]) ? $_exp_acunit_cache[$proposal_id] : 0;
                            }else{
                                $temp_array['nom'] = $value["job_nom"];
                            }
                       $row_output[]= $temp_array['nom'];
                       // SCH-010: cached roof type
                       $_rt_val = '';
                       if ($value['roof_type_id'] == 'other' || $value['roof_type_id'] == '' || !$value['roof_type_id']) {
                           $_rt_val = $value['other_roof_type'];
                       } else {
                           $_rt_val = isset($_exp_roof_cache[$value['roof_type_id']]) ? $_exp_roof_cache[$value['roof_type_id']] : '';
                       }
                       $row_output[]=@$value["stories"] . $_rt_val;
                       $row_output[]= $this->getAllvaribleLaborCost($proposal_id,$value["job_type_id"],$value["location_access"]);
                         if(@$value['repair_time']==0){
                                $repair_type="None";
                        }
                        else if(@$value['repair_time']==1){
                            $repair_type="	8:00am - 11:00am ";
                        }else if(@$value['repair_time']==2){
                             $repair_type="11:00am - 02:00pm";
                        }else{
                             $repair_type=@$value['edt_time'].'-'.@$value['eat_time'];

                        }
                       $row_output[] = $repair_type;
                       $row_output[] = $value["labour_allocated"];
                       $row_output[] = $value["comments"];
                       $row_output[] = $value["servicedesc"];
                       $output.="\n".implode(",",$row_output);
                       $row_output=array();

                       }
                   }
                force_download("Technicianassign.csv", $output);
       }
   //End new code on 07/03/2016
       
       
        function GetTechnicianType($id=0) {
            if (!$id)
                return 0;
            $intial = 0;
            $this->db = $this->load->database('default', true);
            $j = $this->db->query("SELECT * FROM users WHERE id=$id")->row_array();
            if($j['type'] == 'lead_tech'){
                $intial = 'L';
            }
            return $intial;
        }
    
        function GetUserName($id=0, $fullname = false) {
            if (!$id)
                return 0;
            $this->db = $this->load->database('default', true);
            $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
            $intial = "";
            foreach ($j as $key => $value) {
                $intial = ucfirst($value['first_name'][0]) . strtoupper($value['last_name'][0] . $value['last_name'][1]);
                if ($fullname) {
                    $intial = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
                }
            }
            if(strlen($intial)>15){
                $intial = substr($intial,0,25)."..";
            }
            return $intial;
        }
        
        function getEng($id){ 
           if (!$id)
               return "";
           if($id>0){
                $j = $this->db->query("SELECT first_name, last_name FROM users WHERE  id =$id ")->result_array();
                if(isset($j[0]['first_name'])||isset($j[0]['last_name']))
                    return ucfirst($j[0]['first_name']) . " " . ucfirst($j[0]['last_name']);
            } else{
                return " ";
            }
        }
        
        function getdayinstaller($job_date) {
            $rs = $this->db->query("SELECT installer_id FROM jobs WHERE  job_date='$job_date' ")->result_array();
            $temp = array();
            foreach ($rs as $key => $value) {
                $temp[] = $value['installer_id'];
            }
            if (count($temp)) {
                return implode(",", $temp);
            }
        }

        function getidothervalue($other, $id, $tablename, $column = "*") {
            if ($other == "other" || $other == "" || !$other) {
                return $id;
            }
            $j = $this->db->query("SELECT $column  FROM $tablename  WHERE  id =$other")->result();
            
            if (isset($j[0]->$column))
                return $j[0]->$column;
            else
                return "";
        }

        function getUserIntial($id, $fullname = false) {
            if (!$id)
                return 0;
            $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
            $intial = "";
            foreach ($j as $key => $value) {
                $intial = ucfirst($value['first_name'][0]) . ucfirst($value['last_name'][0]);
                if ($fullname) {
                    $intial = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
                }
            }
            return $intial;
        }
        
        function getUserEmpNo($id, $fullname = false) {
            if (!$id)
                return 0;
            $j = $this->db->query("SELECT emp_num FROM users WHERE id=$id")->result_array();
            if ($j[0]['emp_num'] > 0) {
                return $j[0]['emp_num'];
            }
            return $id;
        }
        
        function getUserFirstName($id) {
            if (!$id)
                return 0;
            $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
            $intial = "";
            foreach ($j as $key => $value) {
                $intial = ucfirst($value['first_name']);
            }
            return $intial;
        }

        function getCustomerNeighborhoodColor($id) {
            if (!$id)
                return '#ffffff';
            $neighborhood = "";
            $value = $this->db->query("SELECT neighborhood,other_neighborhood FROM customers WHERE id=$id")->row_array();
            if (isset($value['neighborhood'])) {
                if ($value['neighborhood'] == "other") {
                    return;
                } else {
                    if (isset($value['neighborhood']) && $value['neighborhood'] != "" && is_numeric($value['neighborhood'])) {
                        $sql = "SELECT neighbour,color from  neigbhour where id=" . $value['neighborhood'];
                        $row_neighbour = $this->db->query($sql)->row_array();
                        return @$row_neighbour['color'];
                    } else {
                        return "#ffffff";
                    }
                }
            }
            return @$neighborhood;
        }

        function getCustomerNeighborhood($id) {
            if (!$id)
                return 0;
            $neighborhood = "";
            $j = $this->db->query("SELECT neighborhood,other_neighborhood FROM customers WHERE id=$id")->result_array();
            foreach ($j as $key => $value) {
                if (isset($value['neighborhood'])) {
                    if ($value['neighborhood'] == "other") {
                        $neighborhood = ucfirst($value['other_neighborhood']);
                    } else {
                        if (isset($value['neighborhood']) && $value['neighborhood'] != "" && is_numeric($value['neighborhood'])) {
                            $sql = "SELECT neighbour from  neigbhour where id=" . $value['neighborhood'];
                            $row_neighbour = $this->db->query($sql)->row_array();
                            $neighborhood = ucfirst(@$row_neighbour['neighbour']);
                        } else {
                            $neighborhood = $value['neighborhood'];
                        }
                    }
                }
            }
            if (strlen($neighborhood) > 20) {
                $neighborhood = substr($neighborhood, 0, 20) . "..";
            }
            return @$neighborhood;
        }
        
        function getCustomerLastname($id) {
            if (!$id)
                return 0;

            $j = $this->db->query("SELECT last_name FROM customers WHERE id=$id")->result_array();
            foreach ($j as $key => $value) {
                $lastname = ucfirst($value['first_name']) . " " . ucfirst($value['last_name']);
            }
            return @$lastname;
        }
        
        function getnote($job_id) {
            $notes = $this->db->query("select *  from notes where job_id=$job_id ")->result_array();
            $return_note_array = array();
            foreach ($notes as $note) {
                $return_note_array[] = @$note["note"] . "(Posted by:" . $this->getUserIntial($note["user_id"], true) . ", " . date("m/d/y", strtotime($note["created"])) . ")";
            }
            return implode(",", $return_note_array);
        }
        
        function getrelatedjob($job_pid, $job_id) {
            $sql = "SELECT jobs.*, job_types.intials as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_pid=" . $job_pid . " AND jobs.id!=" . $job_id . " ORDER BY jobs.job_date ASC";
            $related_job = $this->db->query($sql)->result_array();
            $link = array();
            foreach ($related_job as $jobs) {
                $link[] = "<a  target='_blank' style='text-decoration:underline;' href='" . base_url() . "admin/job/" . $jobs["id"] . "'>" . $jobs["job_type"] . date("m/d/y", strtotime($jobs["job_date"])) . "</a>";
            }
            return implode(",", $link);
        }

        function getrelatedjobforexcel($job_pid, $job_id) {
            $sql = "SELECT jobs.*, job_types.intials as job_type FROM jobs LEFT JOIN job_types ON jobs.job_type_id=job_types.id WHERE jobs.job_pid=" . $job_pid . " AND jobs.id!=" . $job_id . " ORDER BY jobs.job_date ASC";
            $related_job = $this->db->query($sql)->result_array();
            $link = array();
            foreach ($related_job as $jobs) {
                $link[] = "" . $jobs["job_type"] . date("m/d/y", strtotime($jobs["job_date"])) . "";
            }
            return implode(",", $link);
        }

        function getparentjobid($job_id) {
            $resultcnt = $this->db->query("SELECT job_pid FROM jobs  where id = $job_id")->result_array();
            $pid = $resultcnt[0]['job_pid'];
            if (!$pid) {
                $pid = $job_id;
            }
            return $pid;
        }

        function savecomment($id) {
            $row = array();
            $pid = $this->getparentjobid($id);
            $row["comments"] = $this->input->post("comments");
            $this->db->where("job_pid", $pid);
            $this->db->update("jobs", $row);
            $json["success"] = true;
            echo json_encode($json);
        }

        function addinstaller($job_id) {
            $pid = $this->getparentjobid($job_id);
            $rs_installer = $this->db->query("select concat('0',installer_id) as installer_id from jobs where id=$job_id")->row_array();
            if (isset($rs_installer["installer_id"]) && $rs_installer["installer_id"] != "") {
                $sql = "SELECT * FROM users WHERE  type='installer' and id not in (" . $rs_installer["installer_id"] . ")";
            } else {
                $sql = "SELECT * FROM users WHERE  type='installer' ";
            }
            $data['users'] = $this->db->query($sql)->result_array();
            $user_select = array();
            foreach ($data['users'] as $users) {
                $user_select[$users['id']] = ucfirst($users['first_name']) . " " . ucfirst($users['last_name']);
            }
            $data['job_id'] = $job_id;
            
            $data['saleuser'] = $user_select;
            $this->load->view("exportapi/salesuser", $data);
        }
        
        function updatejobinstaller($job_id) {
            $row = array();
            $pid = $this->getparentjobid($job_id);
            $exist_installer = $this->db->query("select installer_id from jobs where id=$job_id")->row_array();
            $array_installer = explode(",", $exist_installer["installer_id"]);
            $installer_r = array();
            foreach ($array_installer as $value) {
                if ($value == $this->input->post("installer_id")) {
                    $json['success'] = true;
                    echo json_encode($json);
                    return;
                }
            }
            $row['installer_id'] = $exist_installer["installer_id"] . "," . $this->input->post("installer_id");
            $this->db->where("id", $job_id);
            $this->db->update("jobs", $row);
            $json['success'] = true;
            echo json_encode($json);
        }
        
        function removeinstaller($job_id, $id) {
            $row = array();
            $pid = $this->getparentjobid($job_id);
            $exist_installer = $this->db->query("select installer_id from jobs where id=$job_id")->row_array();
            $array_installer = explode(",", $exist_installer["installer_id"]);
            $installer_r = array();
            foreach ($array_installer as $value) {
                if ($value == $id)
                    continue;
                $installer_r[] = $value;
            }
            $row['installer_id'] = implode(",", $installer_r);
            $this->db->where("id", $job_id);
            $this->db->update("jobs", $row);
            $json['success'] = true;
            echo json_encode($json);
        }

        function getinstallerjson() {
            $firstname = $this->input->get("term");
            $row = $this->db->query("SELECT * FROM users WHERE  type='installer'  AND first_name like '$firstname%' ")->result_array();
            $installer_json = array();
            foreach ($row as $installer) {
                $installer_pre['id'] = $installer["id"];
                $installer_pre['value'] = ucfirst($installer["first_name"]) . " " . ucfirst($installer["last_name"]);
                $installer_json[] = $installer_pre;
            }
            echo json_encode($installer_json);
        }

        function getinstallerbyname() {
            $name = @trim($this->input->post("term"));
            $name = str_replace('"', "", $name);
            $explodename = array();
            $explodename = explode(" ", $name);
            if (count($explodename) != 2) {
                $installer_json["success"] = false;
                echo json_encode($installer_json);
                die;
            }
            $firstname = $explodename[0];
            $lastname = $explodename[1];
            // echo "SELECT * FROM users WHERE  type='installer'  AND first_name='$firstname' AND last_name='$lastname' ";
            $row = $this->db->query("SELECT * FROM users WHERE  type='installer'  AND first_name='$firstname' AND last_name='$lastname' ")->row_array();
            $installer_json = array();
            if (isset($row["id"]) && $row["id"] > 0) {
                $installer_json["success"] = true;
                $installer_json["id"] = $row["id"];
                $installer_json["name"] = ucfirst($row['first_name']) . " " . ucfirst($row["last_name"]);
                echo json_encode($installer_json);
                die;
            }
            $installer_json["success"] = false;
            echo json_encode($installer_json);
        }
        
        function getlaboucost($proposal_id) {
            if ($proposal_id < 11390) {
                $sql = "SELECT sum(variable_job.price*variable_job.quantity) as sumlabour
    FROM variable_job
    LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
    AND variable_job.proposal_id=system_price_proposal.proposal_id
    where variable_job.proposal_id=$proposal_id
    AND  variable_job.variable_id in (23,17,69)
    order by variable_job.id";
                $row = $this->db->query($sql)->row_array();
                $sql_elec = "SELECT sum(variable_job.price*variable_job.quantity) as sumlabour
    FROM variable_job
    LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
    AND variable_job.proposal_id=system_price_proposal.proposal_id
    where variable_job.proposal_id=$proposal_id
    AND  variable_job.variable_id in (29,31)
    order by variable_job.id";
                $row_elec = $this->db->query($sql_elec)->row_array();
                if (!$row_elec) {
                    $sql_elec = "SELECT sum(variable_job.price*variable_job.quantity) as sumlabour
    FROM variable_job
    LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
    AND variable_job.proposal_id=system_price_proposal.proposal_id
    where variable_job.proposal_id=$proposal_id
    AND  variable_job.variable_id in (100,101,102)
    order by variable_job.id";
                    $row_elec = $this->db->query($sql_elec)->row_array();
                }
                return round($row["sumlabour"] / 40) . " roof/" . round($row_elec["sumlabour"] / 40) . 'elec';
            } else {

                $sql = "SELECT sum(variable_job.quantity) as sumlabour
    FROM variable_job
    LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
    AND variable_job.proposal_id=system_price_proposal.proposal_id
    where variable_job.proposal_id=$proposal_id
    AND  variable_job.variable_id in (206,207)
    order by variable_job.id";
                $row = $this->db->query($sql)->row_array();
                $sql_elec = "SELECT sum(variable_job.quantity) as sumlabour
    FROM variable_job
    LEFT JOIN system_price_proposal on variable_job.variable_id=system_price_proposal.id
    AND variable_job.proposal_id=system_price_proposal.proposal_id
    where variable_job.proposal_id=$proposal_id
    AND  variable_job.variable_id in (101,102)
    order by variable_job.id";
                $row_elec = $this->db->query($sql_elec)->row_array();
                return round($row["sumlabour"]) . " roof/" . round($row_elec["sumlabour"]) . 'elec';
            }
        }

        function getallsalesuser() {
            $sql = "SELECT * FROM users WHERE  type='sales'";
            $data['users'] = $this->db->query($sql)->result_array();
            $user_select = array();
            foreach ($data['users'] as $users) {
                $user_select[$users['id']] = ucfirst($users['first_name']) . " " . ucfirst($users['last_name']);
            }
            $user_select['all'] = 'All';
            $data['saleuser'] = $user_select;
            $data['jobtype_list'] = array("" => "-Please select job type-", "all" => "All jobs", 2 => "PV", 1 => "SWH", 16 => "HVAC", 21 => "EV", 20 => "SAF", 6 => "PV+SWH", 7 => "PV+AC", 8 => "PV+SWH+AC", 9 => "Sold", 10 => "Non-Sold");
            $this->load->view("exportapi/salesuser", $data);
        }

        function downloadcsv($saleuser_id, $job_type_select = '') {
            $this->load->helper('csv');
            $this->load->helper('download');
            $jobtype_select = $job_type_select;
            if ($job_type_select == '') {
                $jobtype_select = "all";
            }
            if ($jobtype_select == "all" || $jobtype_select == 2 || $jobtype_select == 1 || $jobtype_select == 16 || $jobtype_select == 21 || $jobtype_select == 20 || $jobtype_select == 6 || $jobtype_select == 7 || $jobtype_select == 8 || $jobtype_select == "all") {
                if ($jobtype_select == "all") {
                    $sql_jobtype = "";
                }
                if ($jobtype_select == 2) {
                    $sql_jobtype = "and jobs.job_type_id=2";
                } else if ($jobtype_select == 1) {
                    $sql_jobtype = "and jobs.job_type_id=1";
                } else if ($jobtype_select == 16) {
                    $sql_jobtype = "and jobs.job_type_id=16";
                } else if ($jobtype_select == 21) {
                    $sql_jobtype = "and jobs.job_type_id=21";
                } else if ($jobtype_select == 20) {
                    $sql_jobtype = "and jobs.job_type_id=20";
                } else if ($jobtype_select == 6) {
                    $sql_jobtype = "and (jobs.job_type_id=2 or jobs.job_type_id=1)";
                } else if ($jobtype_select == 7) {
                    $sql_jobtype = "and (jobs.job_type_id=2 or jobs.job_type_id=16)";
                } else if ($jobtype_select == 8) {
                    $sql_jobtype = "and (jobs.job_type_id=2 or jobs.job_type_id=16 or jobs.job_type_id=1)";
                } else {
                    $sql_jobtype = "";
                }
                $saleuser_filter = "";
                if ($saleuser_id == 'all') {
                    $saleuser_filter = "";
                } else {
                    $saleuser_filter = "AND jobs.user_id=$saleuser_id";
                }
                $sql = "SELECT distinct first_name,last_name,email FROM  jobs left join customers  on jobs.customer_id=customers.id where 1=1 AND email is not null AND email!=''  $sql_jobtype $saleuser_filter order by first_name";
                $row = $this->db->query($sql)->result_array();
                $output = "";
                $output .= "First Name,Last Name ,Email\n";
                foreach ($row as $data) {
                    $output .= ucfirst(str_replace(",", "", $data['first_name'])) . ", " . ucfirst(str_replace(",", "", $data['last_name'])) . "," . $data['email'] . "\n";
                }

                if ($saleuser_id == 'all') {

                    force_download("All Customer's list.csv", $output);
                } else {
                    $userload = $this->getUserIntial($saleuser_id, true);

                    force_download($userload . " Customer's list.csv", $output);
                }
            }
            if ($jobtype_select == 9 || $jobtype_select == 10) {
                $user_filter = "";
                if ($saleuser_id == 'all') {
                    $userload = "All Customers ";
                    $user_filter = "";
                } else {
                    $userload = $this->getUserIntial($saleuser_id, true);
                    $user_filter = " and user_id=" . $saleuser_id;
                }
                if ($jobtype_select == 9) {
                    $sql = "select * from sold_detail where status = 'sold'  $user_filter";
                    $userload.="-sold";
                } else if ($jobtype_select == 10) {
                    $sql = "select * from sold_detail where status = 'non-sold' $user_filter";
                    $userload.="-non-sold";
                }
                $list_array = $this->db->query($sql)->result_array();
                $records[0] = array('First Name', 'Last Name', 'Email');
                $k = 1;
                foreach ($list_array as $row) {
                    $records[$k] = array($row['first_name'], $row['last_name'], $row['email']);
                    $k++;
                }
                echo $myarray = array_to_csv($records, $userload . ".csv");
            }
        }
        
        function getArea($pincode){
             $row=$this->db->query('Select neighbour from neigbhour left join neigbhour_pin_codes neg on neg.neighbour_id=neigbhour.id where neg.pin_codes="'.$pincode.'"')->row_array();
             return @$row['neighbour'];
         }
         
        function getProposalId($job_pid){
            $row=$this->db->query('Select proposal_id from jobs where id="'.$job_pid.'"')->row_array();
            return @$row['proposal_id'];
        }
      
        function getAllvaribleLaborCost($proposal_id,$job_type,$location_access){
    
            $row=array();
            $text='';
            if($job_type==2 || $job_type==6 || $job_type==7){
                
                if($job_type==2){
                    $var_list_order=array('EJ'=>101,'EH'=>102,'RL'=>206);
                }else if($job_type==6){
                    $var_list_order=array('RL'=>224);
                }else{
                    $var_list_order=array('PM'=>207);
                } 

                foreach ($var_list_order as $key=>$val){
                    $variable_id=$val;

                    if($variable_id==101 || $variable_id==102){
                        $sqlc = "SELECT  title, variable_job.price AS hours,quantity as price  ,ROUND(quantity*variable_job.price) AS cost,system_price_proposal.proposal_id  FROM variable_job
        JOIN system_price_proposal  ON variable_job.`variable_id`=system_price_proposal.`id`
         WHERE  variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.id ='" . $variable_id . "' AND system_price_proposal.location_access ='" . $location_access . "'";
                    }else{
                        $sqlc = "SELECT  title,quantity AS hours,variable_job.price ,ROUND(quantity*variable_job.price) AS cost,system_price_proposal.proposal_id  FROM variable_job
        JOIN system_price_proposal  ON variable_job.`variable_id`=system_price_proposal.`id`
         WHERE  variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.`proposal_id`='" . $proposal_id . "' AND system_price_proposal.id ='" . $variable_id. "' AND system_price_proposal.location_access ='" . $location_access . "'";
                    }

                    $row = $this->db->query($sqlc)->row_array();
                    if (count($row)){
                        if($job_type==6){
                            $text.=floatval($row['hours']).' '.$key.' / ';
                        }else{
                            $text .=$key.' '.floatval($row['hours']).' / ';
                        }
                    }

                }
            }else if($job_type==16 || $job_type==15){
                
                if($job_type==16){
                    $var_list_order=array('ACJ'=>35,'EJ'=>33,'AL'=>117);
                }else if($job_type==15){
                    $var_list_order=array('AS'=>37);
                }
                foreach ($var_list_order as $key=>$val){
                    $variable_id=$val;
                    $sqlc = "SELECT title, sum(quantity) AS hours, acvariable_job.price as price ,sum(quantity*acvariable_job.price) AS cost,acsystem_price_proposal.proposal_id FROM acvariable_job
        JOIN acsystem_price_proposal  ON acvariable_job.`variable_id`=acsystem_price_proposal.`id`
         WHERE  acvariable_job.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.`proposal_id`='" . $proposal_id . "' AND acsystem_price_proposal.id ='" . $variable_id. "' AND acsystem_price_proposal.location_access ='" . $location_access . "' ";
                    $row = $this->db->query($sqlc)->row_array();
                    if (count($row)){
                        $text .=$key. ' '.$row['hours'].' / ';
                    }
                }
            }
            else if($job_type==5 || $job_type==1){
                if($job_type==5){
                    $var_list_order=array('WM'=>102);
                }else if($job_type==1){
                    $var_list_order=array('PJ'=>99,'RL'=>100);
                }
                foreach ($var_list_order as $key=>$val){
                    $variable_id=$val;
                    if($key=='RL'){
                        $statement=" AND system_price_swhproposal.id in (100,101)";
                        $cols="SUM(quantity) AS hours";
                    }else{
                        $statement=" AND system_price_swhproposal.id ='" . $variable_id. "'";
                        $cols="quantity AS hours";
                    }     
                    $sqlc = "SELECT  title,$cols,swh_variable_job.price ,ROUND(quantity*swh_variable_job.price) AS cost,system_price_swhproposal.proposal_id  FROM swh_variable_job
    JOIN system_price_swhproposal  ON swh_variable_job.`variable_id`=system_price_swhproposal.`id`
     WHERE  swh_variable_job.`proposal_id`='" . $proposal_id . "' AND system_price_swhproposal.`proposal_id`='" . $proposal_id . "' $statement ";
                    $row = $this->db->query($sqlc)->row_array();
                    
                    if (count($row)){
                        $text .=$key. ' '.floatval($row['hours']).' / ';
                    }

                }
            }
           
            if(strlen($text)){
                return substr($text, 0, -2);
            }else{
                 return '';
            }
        }
        
        function getunit($proposal_id){
            $sql_zone="SELECT * from acproposalzone where acproposal_id='".$proposal_id."'";
            $zones=$this->db->query($sql_zone)->result_array();
            $unitcount=0;
            foreach( $zones as $zdata) {
                $mz_chk1 = $zdata['mzone_rec1_id'];
                $mz_chk2 = $zdata['mzone_rec2_id'];
                $mz_add_check = $zdata['additional_unit_1_price'];
                $mz_rec_check = $zdata['reccomended_unit_1_price'];
                if($mz_chk1>0 && $mz_chk2>0 ){
                    //$unitcount+=2;
                    continue;
                }else if ($mz_chk1>0 && $mz_add_check==0 ){
                    $unitcount+=1;
                    continue;
                } else if($mz_chk2>0 && $mz_rec_check>0 ){
                    $unitcount+=1;
                    continue;
                } else {
                    $unitcount+=1;
                    if(!$zdata['reccomended_unit_delete'] &&  !$zdata['additional_unit_delete'] && $zdata['additional_unit_1_price']>0 ) { 
                        $unitcount+=2;
                    }
                    if($zdata['reccomended_unit_delete'] &&  $zdata['additional_unit_delete'] ) { 
                        $unitcount-=1;
                    }
                }
            }
            return $unitcount;
        }
        
        function deleteTechnician($job_id=0){
            $data= array();
            if(!@$job_id){
                $data['success'] = false;
                echo json_encode($data);
                return;
            }
            
            $team_type_name = $this->input->post('team_type_name');
            $teamType = $this->input->post('team_type_id');
            $teamId = $this->input->post('technician_team_id');
            $technicianIdPheo = $this->input->post('technician_id_pheo');
            $technicianIdTime = $this->input->post('technician_id_time');
            $job_id = $this->input->post('job_id');
            $techInTeam = $this->input->post('techInTeam');
            //$key = $this->input->post('key');
            
            $jobUpdate = array();
            $rowjobs = $this->db->query("SELECT * FROM jobs where id=".$job_id."")->row_array();
            $job_pid=@$rowjobs['job_pid'];
            $job_type_id=@$rowjobs['job_type_id'];
            if(@$rowjobs['installer_id']){
                $installer_id =  explode(',', $rowjobs['installer_id']);
                if($technicianIdPheo && in_array($technicianIdPheo,$installer_id)) {
                    $pos = array_search($technicianIdPheo, $installer_id);
                    unset($installer_id[$pos]);
                }
                $installer_id = implode(",",$installer_id);
                $jobUpdate['installer_id'] = $installer_id;
            }else{
                $jobUpdate['installer_id'] = '';
            }
            
            $this->db->where(array('job_id' => $job_id,'technician_id_pheo' =>$technicianIdPheo,'technician_id_time' => $technicianIdTime));
            $this->db->delete("technicians_in_jobs");
            $labour_cont=$this->db->query("SELECT count(*) as count from technicians_in_jobs where job_id=".$job_id)->result_array();
            $json['labour_count']=8*@$labour_cont[0]['count'];
            if($labour_cont[0]['count']>0){
                $json['is_tech']=true;
            }else{
                  $json['is_tech']=false;
            }
            $jobUpdate['labour_allocated']=$json['labour_count'];
            $this->db->where(array('id'=>$job_id));
            $this->db->update("jobs",$jobUpdate);
            
             $rowtechnician = $this->db->query("SELECT * FROM technicians_in_jobs where technician_id_pheo=".$technicianIdPheo."")->result_array();
            if (count($rowtechnician)== 0)
            {
             $set=array();
             $set['assigned']=0;
             $this->db->where(array('technician_id_pheo' => $technicianIdPheo));
             $this->db->update("technicians_assign",$set);
            }   
            if($this->db->affected_rows()>0){
                $json['success'] = true;
                echo json_encode($json);
            }else{
                $json['success'] = false;
                echo json_encode($json);
            }
  $this->techunassginmail($technicianIdPheo,$job_id);
	}
        
        function saveTechnician($job_id=0){
            
            $data= array();
            if(!@$job_id){
                $data['success'] = false;
                echo json_encode($data);
                return;
            }
            
            $team_type_name = $this->input->post('team_type_name');
            $teamType = $this->input->post('team_type_id');
            $teamId = $this->input->post('technician_team_id');
            $technicianIdPheo = $this->input->post('technician_id_pheo');
            $technicianIdTime = $this->input->post('technician_id_time');
            $job_id = $this->input->post('job_id');
            $key = $this->input->post('key');
            
            $row = array();
            $row['team_type_id'] = $this->input->post("team_type_id");
            $row['technician_id_pheo'] = $this->input->post("technician_id_pheo");
            $row['technician_id_time'] = $this->input->post("technician_id_time");
            $row['team_id'] = $this->input->post("technician_team_id");
            $row['job_id'] = $this->input->post("job_id");
            $workhour=$row['technician_worked_hours'] = $this->input->post("technician_worked_hours");
            
            $row['created']=date("Y-m-d H:i:s");
            $row['tech_in_team'] = $this->input->post("techInTeam");
            
            $jobUpdate = array();
            $rowjobs = $this->db->query("SELECT * FROM jobs where id=".$job_id."")->row_array();
            $job_pid=@$rowjobs['job_pid'];
            $job_type_id=@$rowjobs['job_type_id'];
            $row['job_pid']=@$rowjobs['job_pid'];
            $row['job_type_id']=@$rowjobs['job_type_id'];
            if(@$rowjobs['installer_id']){
                $installer_id =  explode(',', $rowjobs['installer_id']);
                if($technicianIdPheo && in_array($technicianIdPheo,$installer_id)) {
                }else{
                    array_push($installer_id,$technicianIdPheo);
                }
                $installer_id = implode(",",$installer_id);
                $jobUpdate['installer_id'] = $installer_id;
            }else{
                $jobUpdate['installer_id'] = $this->input->post("technician_id_pheo");
            }
            
            $row1 = $this->db->query("SELECT * FROM technicians_in_jobs where job_id=".$job_id." and technician_id_pheo=".$technicianIdPheo." and technician_id_time=".$technicianIdTime."")->row_array();
            if (count($row1) > 0)
            {
                $data['success'] = true;
                $data['isExist'] = 1;
            }
            else
            {
                $this->db->insert("technicians_in_jobs",$row);
                $set=array();
                $set['assigned']=1;
                $this->db->where(array('technician_id_pheo' => $technicianIdPheo,'team_id'=>$teamId));
                $this->db->update("technicians_assign",$set);
                $labour_cont=$this->db->query("SELECT count(*) as count from technicians_in_jobs where job_id=".$job_id)->result_array();
                $data['labour_count']=8*@$labour_cont[0]['count'];
                $jobUpdate['labour_allocated']=$data['labour_count'];
                $this->db->where(array('id'=>$job_id));
                $this->db->update("jobs",$jobUpdate);
                
                $data['success'] = true;
                $data['isExist'] = 0;
            }
            $this->techassginmail($technicianIdPheo,$job_id);
            echo json_encode($data);
            
        }
        
         function save_technician_by_team($job_id=0){
           // 
            $data= array();
            if(!@$job_id){
                $data['success'] = false;
                echo json_encode($data);
                return;
            }
            $technician_team_id = $this->input->post('technician_team_id');
            $team_name = $this->input->post('team_name');
            $teamId = $this->input->post('technician_team_id');
            $team_type_id= $this->input->post('team_type_id');
            $job_id = $this->input->post('job_id');
            $teamname = $this->input->post("techInTeam");
            
            $rowjobs = $this->db->query("SELECT * FROM technicians_assign  where team_id=".$technician_team_id)->result_array();
            foreach($rowjobs as $team){
            $row = array();
            $row['team_type_id'] =$team['team_type_id']; 
            $row['technician_id_pheo'] = $team['technician_id_pheo'];
            $technicianIdPheo=$team['technician_id_pheo'];
            $row['technician_id_time'] = $team['technician_id_time'];
            $technicianIdTime=$team['technician_id_time'];
            $row['team_id'] =$team['team_id'];
            $row['job_id'] = $job_id;
            $row['tech_in_team'] =$teamname;
            $row['created']=date("Y-m-d H:i:s");
            
            $jobUpdate = array();
            $rowjobs = $this->db->query("SELECT * FROM jobs where id=".$job_id."")->row_array();
            $row['technician_worked_hours'] =$this->work_hours($team['technician_id_time'],$rowjobs['job_date']);  //change satyendra on 12-5-16
            $job_pid=@$rowjobs['job_pid'];
            $job_type_id=@$rowjobs['job_type_id'];
            $row['job_pid']=@$rowjobs['job_pid'];
            $row['job_type_id']=@$rowjobs['job_type_id'];
            if(@$rowjobs['installer_id']){
                $installer_id =  explode(',', $rowjobs['installer_id']);
                if($technicianIdPheo && in_array($technicianIdPheo,$installer_id)) {
                }else{
                    array_push($installer_id,$technicianIdPheo);
                }
                $installer_id = implode(",",$installer_id);
                $jobUpdate['installer_id'] = $installer_id;
            }else{
                $jobUpdate['installer_id'] = $team['technician_id_pheo'];
            }
           
            $row1 = $this->db->query("SELECT * FROM technicians_in_jobs where job_id=".$job_id." and technician_id_pheo=".$technicianIdPheo." and technician_id_time=".$technicianIdTime."")->result_array();
         
            if(count($row1) > 0)
            {
                $data['success'] = true;
                $data['isExist'] = 1;
            }
            else
            {
                $this->db->insert("technicians_in_jobs",$row);
                $set=array();
                $set['assigned']=1;
                $this->db->where(array('technician_id_pheo' => $technicianIdPheo,'team_id'=>$teamId));
                $this->db->update("technicians_assign",$set);
                $labour_cont=$this->db->query("SELECT count(*) as count from technicians_in_jobs where job_id=".$job_id)->result_array();
                $data['labour_count']=8*@$labour_cont[0]['count'];
                $jobUpdate['labour_allocated']=$data['labour_count'];
                $this->db->where(array('id'=>$job_id));
                $this->db->update("jobs",$jobUpdate);
                $data['success'] = true;
                $data['isExist'] = 0;
            }
         }
            echo json_encode($data);
        }
        
       function work_hours($tech_id, $filterDate=''){
           
                 //change  by satyendra on 12-5-16
                if(date('D',strtotime("$filterDate"))=='Sun'){
                     $from_W_date=date('Y-m-d',strtotime('this Sunday',strtotime("$filterDate")));
                }else{
                    $from_W_date=date('Y-m-d',strtotime('last Sunday',strtotime("$filterDate")));
                }
                $to_W_date=date('Y-m-d',  strtotime('+6 days',strtotime("$from_W_date")));
                //END change by satyendra on 12-5-16
                
                $this->db2 = $this->load->database('otherdb', true);
                $q=$this->db2->query("SELECT t_c.* FROM user_calculated_time_sheet_details as t_c where t_c.user_id ='".$tech_id."'  and t_c.submited_date BETWEEN  '".$from_W_date."' and '".$to_W_date."'");   
                if($q->num_rows()){
                    $TimeSheetdetails = $q->row_array();
                    $technician_worked_hours = $TimeSheetdetails['reg_hrs']+$TimeSheetdetails['ot'];
                }else{
                   $technician_worked_hours = 0;
                }
                
                return  $technician_worked_hours;
        } 
        function check_assigned($technician_id,$team_id,$job_id){
           //echo $team_id;
            if(!$job_id){
                 return 0;
             }else{
                   // $sql="select * from technicians_in_jobs  where team_id=".$team_id." and technician_id_pheo=".$technician_id.$job_id ;
                    $sql="select * from technicians_in_jobs  where technician_id_pheo=".$technician_id.$job_id ; //change by satyendra on 3-5-16
                    $row=$this->db->query($sql)->result_array();
                    if(count($row)>0 ){
                      return 1;
                    } else{
                        return 0; 
                    }
             } 
          }
         function update_all_technicians_in_jobs(){
           $data=array(); 
           $sql="select * from technicians_in_jobs";
           $value=$this->db->query($sql)->result_array();
           foreach($value as $row){
                $rowjobs=$this->db->query("select id, job_pid, job_type_id from jobs where id=".$row['job_id'])->result_array(); 
                  foreach($rowjobs as $team){
                    $data['job_pid']=$team['job_pid'];
                    $data['job_type_id']=$team['job_type_id'];
                    $this->db->where('job_id',$team['id']);
                    $this->db->update("technicians_in_jobs",$data);
                }
            }
        }
   
       function savecity($id) {
            $row = array();
            $pid = $this->getparentjobid($id);
            $row["dayview_city"] = $this->input->post("city");
            $this->db->where("id", $id);
            $this->db->update("jobs", $row);
            $json["success"] = true;
            echo json_encode($json);
        }


function techCorrection(){
            $date_filter = "  jobs.job_date >='2016-04-1' AND jobs.job_date<='2016-04-15'";
            $pv_sql =" AND jobs.job_type_id in(2,16,1,5,6,17,23,8,20,21)";
            
            $j = $this->db->query("SELECT * from jobs WHERE   $date_filter $pv_sql")->result_array();
           
            foreach ($j as $job_val){
                
                $q = $this->db->query("SELECT * from  technicians_in_jobs WHERE job_id='".$job_val['id']."' and job_pid='".$job_val['job_pid']."'");
                
                if($q->num_rows()){
                    $tech =$q->result_array();

                    $user_arr=array();
                    $job_id=0;
                    foreach ($tech as $tech_val){
                        $user_arr[]=$tech_val['technician_id_pheo'];
                        $job_type_id=$tech_val['job_type_id'];
                        $job_id=$tech_val['job_id'];
                    }

                   
                    $installer_ids=  implode(',',  $user_arr); 
                   echo  "update jobs set installer_id='".$installer_ids."'  WHERE id='".$job_val['id']."' and job_pid='".$job_val['job_pid']."'  and job_type_id='".$job_val['job_type_id']."' <br/>";
                                 
                    $this->db->query("update jobs set installer_id='".$installer_ids."'  WHERE id='".$job_val['id']."' and job_pid='".$job_val['job_pid']."'  and job_type_id='".$job_val['job_type_id']."' ");
                }else{
                    echo "update jobs set installer_id=''  WHERE id='".$job_val['id']."' and job_pid='".$job_val['job_pid']."'  and job_type_id='".$job_val['job_type_id']."' ";    
                    $this->db->query("update jobs set installer_id=''  WHERE id='".$job_val['id']."' and job_pid='".$job_val['job_pid']."'  and job_type_id='".$job_val['job_type_id']."' ");
                }
                
            }
        }
	//	  start-PHOEN-526
	public  function getJobHelptopic($job_id){
	    
	    
	    $j = $this->db->query("SELECT ticket.topic_id FROM ost_ticket ticket LEFT JOIN osticket tjob ON tjob.os_ticket = ticket.ticket_id   WHERE tjob.job_id ='".$job_id."'")->row_array();
	    
	    if(@$j['topic_id'])
	    {
		 return $j['topic_id'];
	    }
	    return 0;
	      
	}
	
//	end-PHOEN-526
	function techassginmail($userid,$jobid) {
$j= $this->getUserLoadNew($userid);
$this->load->helper('mail');
$this->load->library('email');
 $config['mailtype'] = 'html';
  $this->email->initialize($config);
$this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
 //$mail = getmailid($j[0]->email,$j[0]->type,$j[0]->user_status,$j[0]->notification,135);
 $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=135');
                $row1 = $query->row();
                $sub=$row1->strsubject;
                $msg=$row1->strbody;
                    
                $msg=strtr($msg, array(
                 '%jobid%' => $jobid,
				  '%baseurl%' =>base_url(),
				 
                 ));
	$this->email->subject($sub);
	$sql_jobs = "SELECT ps.home_owner_assoc ,jobs.*,cust.first_name,cust.last_name,cust.association,cust.address,cust.city,cust.state,cust.zip_code
   FROM jobs 
   LEFT JOIN customers cust ON cust.id=jobs.customer_id 
   LEFT JOIN proposal ps ON ps.id=jobs.proposal_id
   WHERE jobs.id=$jobid";

	$row_job=$this->db->query($sql_jobs)->row_array();
	$this->load->helper('jobpv');
   
	$strbody=$msg;
	$hoa_status="no";
	
	if(isset($row_job["association"]) && $row_job["home_owner_assoc"]==2){
       $hoa_status="Yes";
	}

	$cust_name=ucfirst($row_job["first_name"])." ".ucfirst($row_job["last_name"]);
	$booking_date=date("m/d/Y",strtotime($row_job["created"]));
	$installation_date=date("m/d/Y",strtotime($row_job["job_date"]));
    $type="";
    if($row_job['job_type_id']==1){
	 $type="SWH";
	}else if($row_job['job_type_id']==2){
	 $type="PV";
	}else if($row_job['job_type_id']==16){
	 $type="AC";
	}
	$cust_addr=$row_job['address'] ." , ".$row_job['city']." , ".$row_job['state']." , ".$row_job['city'].", ".$row_job['zip_code'];
	$strbody = str_replace("%baseurl%", base_url(), $strbody);   
	$strbody = str_replace("%jobid%",$jobid,$strbody);
	$strbody = str_replace("%customer_name%",$cust_name,$strbody);
	$strbody = str_replace("%customer_address%",$cust_addr,$strbody);
	$strbody = str_replace("%installation_date%",$type.":".$installation_date,$strbody);
	$strbody = str_replace("%hoa_status%", $hoa_status, $strbody);

	$msg=$strbody;
    
          
            $this->email->to($j[0]->email);
               
          @$this->email->message($msg);
          @$this->email->send();
   

         
         $query = $this->db->query('SELECT another_email_id FROM mailformat where id=135');
                $row1 = $query->row();
                $another_email_id=  explode(',', $row1->another_email_id);
                foreach ($another_email_id as $mail) {
                 if (!filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
                   $this->email->to($mail);
                    $this->email->subject($sub);
                    @$this->email->message($msg);
                    @$this->email->send();
               } 
               }
   
	 }
	  
   function techunassginmail($userid,$jobid) {
    $this->load->library('email');
 $config['mailtype'] = 'html';
  $this->email->initialize($config);
$j= $this->getUserLoadNew($userid);
$this->load->helper('mail');
$this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
 //$mail = getmailid($j[0]->email,$j[0]->type,$j[0]->user_status,$j[0]->notification,136);
 $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=136');
                $row1 = $query->row();
                $sub=$row1->strsubject;
                $msg=$row1->strbody;
                    
                $msg=strtr($msg, array(
                 '%jobid%' => $jobid,
				  '%baseurl%' =>base_url(),
				 
                 ));
	$this->email->subject($sub);
	$sql_jobs = "SELECT ps.home_owner_assoc ,jobs.*,cust.first_name,cust.last_name,cust.association,cust.address,cust.city,cust.state,cust.zip_code
   FROM jobs 
   LEFT JOIN customers cust ON cust.id=jobs.customer_id 
   LEFT JOIN proposal ps ON ps.id=jobs.proposal_id
   WHERE jobs.id=$jobid";

	$row_job=$this->db->query($sql_jobs)->row_array();
	$this->load->helper('jobpv');
   
	$strbody=$msg;
	$hoa_status="no";
	
	if(isset($row_job["association"]) && $row_job["home_owner_assoc"]==2){
       $hoa_status="Yes";
	}

	$cust_name=ucfirst($row_job["first_name"])." ".ucfirst($row_job["last_name"]);
	$booking_date=date("m/d/Y",strtotime($row_job["created"]));
	$installation_date=date("m/d/Y",strtotime($row_job["job_date"]));
    $type="";
    if($row_job['job_type_id']==1){
	 $type="SWH";
	}else if($row_job['job_type_id']==2){
	 $type="PV";
	}else if($row_job['job_type_id']==16){
	 $type="AC";
	}
	$cust_addr=$row_job['address'] ." , ".$row_job['city']." , ".$row_job['state']." , ".$row_job['city'].", ".$row_job['zip_code'];
	$strbody = str_replace("%baseurl%", base_url(), $strbody);   
	$strbody = str_replace("%jobid%",$jobid,$strbody);
	$strbody = str_replace("%customer_name%",$cust_name,$strbody);
	$strbody = str_replace("%customer_address%",$cust_addr,$strbody);
	$strbody = str_replace("%installation_date%",$type." -".$installation_date,$strbody);
	$strbody = str_replace("%hoa_status%", $hoa_status, $strbody);

	$msg=$strbody;
    
          
            $this->email->to($j[0]->email);
               
          @$this->email->message($msg);
          @$this->email->send();
   

         
         $query = $this->db->query('SELECT another_email_id FROM mailformat where id=136');
                $row1 = $query->row();
                $another_email_id=  explode(',', $row1->another_email_id);
                foreach ($another_email_id as $mail) {
                 if (!filter_var($mail, FILTER_VALIDATE_EMAIL) === false){
                   $this->email->to($mail);
                    $this->email->subject($sub);
                    @$this->email->message($msg);
                    @$this->email->send();
               } 
               }
   
	 }
	  

 function getUserLoadNew($id) {
        if (!$id)
            return 0;
       $j = $this->db->query("SELECT users.* FROM users  WHERE  (users.user_status='active' or users.user_status=1)  AND  users.id=$id")->result();

        return $j;
    }
	
 function getjobday($job_id,$pid) {
   $sql="select * from jobs where job_type_id in(2,6) and job_pid=".$pid." order by job_date asc";
   $rows=$this->db->query($sql)->result_array();
   $count=0;
   $day=0;
   $showday="";
   foreach ($rows as $row){
     $count++;
     if($row['id']==$job_id)$day=$count;
   }
   if($day==1 && $count!=1){
       $showday="1st day of $count  day job";
   }else if ($day==2){
         $showday="2nd day of $count  day job";
   }else if ($day==3){
         $showday="3rd day of $count  day job";
   }else if ($day==4){
         $showday="4th day of $count  day job";
   }

   return $showday;
}
 function getacjobday($job_id,$pid) {
   $sql="select * from jobs where job_type_id in(16) and job_pid=".$pid." order by job_date asc";
   $rows=$this->db->query($sql)->result_array();
   $count=0;
   $day=0;
   $showday="";
   foreach ($rows as $row){
     $count++;
     if($row['id']==$job_id)$day=$count;
   }
   if($day==1 && $count!=1){
       $showday="1st day of $count  day job";
   }else if ($day==2){
         $showday="2nd day of $count  day job";
   }else if ($day==3){
         $showday="3rd day of $count  day job";
   }else if ($day==4){
         $showday="4th day of $count  day job";
   }
   return $showday;
}

function getteslapanel($id){
	        if($id>0) {
             $row=$this->db->query('Select qoute_nopowerwalls from proposal where id='.$id)->row_array();
             return @$row['qoute_nopowerwalls'];
            }
			return 0;

    }

	function getproposal_type($id){
	        if($id>0) {
             $row=$this->db->query('Select storage from proposal where id='.$id)->row_array();
             return @$row['storage'];
            }
			return 0;

    }
}


?>
