<?php
ini_set("display_errors",1);
class Ajax extends Controller {

	function Ajax()
	{
		parent::Controller();
		if(!$this->session->userdata('logged_in'))
		{
			$tempurl = explode("/index.php/", $_SERVER['PHP_SELF']);
                        redirect("login?ref=".$tempurl[1]);
		}
                $this->getjoblimit();
	}

	function index()
	{

	}

	function preview_job()
	{
		$this->load->view("ajax/preview_job");
	}

	function choose_reserve_date()
	{
		$this->load->view("ajax/choose_reserve_date");
	}




	function preview_day($year='',$month='',$day='')
	{

		if(@$year=='') {$year = date("Y");}
		if(@$month=='') {$month = date("m");}
		if(@$day=='') {$day = date("d");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = $day;

		$data['day_timestamp'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);

		$extra_sql = '';
		if($this->session->userdata("role") != 'admin')
		{
			$extra_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));
		}
		// grab photovoltaic jobs
		$sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='2' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
			";
		$data['jobs'] = $this->db->query($sql)->result_array();

		// grab solar water heating jobs
		$sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='1' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['jobs'] += $this->db->query($sql)->result_array();

		// grab solar attic fan jobs
		$sql = "SELECT
			jobs.*,
			job_types.type as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='3' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['jobs'] += $this->db->query($sql)->result_array();

		// get service calls for the day
		$sql = "SELECT service_calls.*,customers.first_name,customers.last_name,customers.address,customers.city,customers.state,colors.hex FROM service_calls LEFT JOIN users ON service_calls.user_id=users.id LEFT JOIN customers ON service_calls.customer_id=customers.id LEFT JOIN colors ON users.color_id=colors.id WHERE DATE_FORMAT(service_calls.date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql";
		$data['service_calls'] = $this->db->query($sql)->result_array();

		$this->load->view("ajax/preview_day",$data);
	}

	function reserve_job($year='',$month='')
	{       $this->canceljob();
		if(!$this->session->userdata('access')) { redirect("admin/error?e=permissions");}
                if($year=='')
		{
			$year = date("Y");
			$month = date("n");

		}

		$month = ltrim($month,"0");
		 $data['system_type'][]="- Select a system type -";
        $data['system_type']['PV']="PV";
        $data['system_type']['SWH']="SWH";
        $data['system_type']['AC']="AC";
        $data['system_type']['ELEC']="ELEC";
        $data['system_type']['other']="Other";
		$data['year'] = $year;
		$data['month'] = $month;
		$data['neighbour']['']="Select Geographical Area ";
                //$data['neighbour']['other']="Other";
                  $this->db->where('is_new =',1);
		$neighbour_display = $this->db->get("neigbhour")->result_array();
                foreach($neighbour_display as $row) { $data['neighbour'][$row['id']] = $row['neighbour']; }
		$data['customer_id'] = '';
		if($this->input->get("customer_id"))
		{
			$data['customer_id'] = $this->input->get("customer_id");
			$data['customer'] = $this->db->query("SELECT * FROM customers WHERE id=".$this->db->escape($data['customer_id']))->row_array();
		}

		//$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);

		// Grab customer types
		$data['customer_types'][''] = '- Select an Customer Type -';
		$this->db->order_by('type','asc');
		$inverter_types = $this->db->get("customer_types")->result_array();
		foreach($inverter_types as $row)
		{
			$data['customer_types'][$row['id']] = $row['type'];
		}

		// Grab job types
		$data['job_types'][''] = '- Select an Job Type -';
                if($this->session->userdata('role') != 'admin' ){
                    $this->db->where('id !=',6);
                    $this->db->where('id !=',7);
                }
                $this->db->order_by('type','asc');

		$inverter_types = $this->db->get("job_types")->result_array();
		foreach($inverter_types as $row)
		{
			$data['job_types'][$row['id']] = $row['type'];
		}

		if ($this->session->userdata('role') == 'admin')
		{
			$data['salesmen'][''] = '- Select a Salesperson -';
			// Grab salesmen for dropdown
			$this->db->where('type','sales');
			$this->db->or_where('type','admin');
			$sm = $this->db->get("users")->result_array();
			foreach($sm as $v)
			{
				$data['salesmen'][$v['id']] = $v['first_name'].' '.$v['last_name'];
			}
		}
                 $data['data_emt'][0] = "-- Select a Meter Type --";
                 $this->db->order_by('type','asc');
                 $moniter_display = $this->db->get("electric_wire_type")->result_array();
 	         foreach($moniter_display as $row) { $data['data_emt'][$row['id']] = $row['type']; }
		 $data["sesuid"] = $this->session->userdata("user_id");
		 $this->load->view("ajax/reserve_job",$data);
	}

	function init_job()
	{
		//header('Content-Type: application/json; charset=utf-8');

		$this->load->library('validation');
		$new_customer = false;

		// set validation rules
		$rules['job_type'] = "required";
		$rules['first_name'] = "required";
		$rules['last_name']	= "required";

		// set field "real" names
		$fields['first_name'] = "First Name";
		$fields['last_name'] = "Last Name";
		$fields['job_type'] = "Job Type";
		$fields['customer_type'] = "Customer Type";
                $fields['neighborhood'] = "Neighborhood";

		if($this->input->post("customer_id") == '')
		{
			$new_customer = true;
			$rules['customer_type'] = "required";
		}

		$this->validation->set_rules($rules);
		$this->validation->set_fields($fields);

		if($this->validation->run() == FALSE)
		{
			$json['success'] = false;
			$json['msg'] = $this->validation->error_string;
			echo json_encode($json);
		}
		else
		{
			if($new_customer)
			{
				// need to add new customer to db
				$row = array();
				$row['first_name'] = $this->input->post("first_name");
				$row['last_name'] = $this->input->post("last_name");
				$row['customer_type_id'] = $this->input->post("customer_type");
                                $row['neighborhood'] = $this->input->post("neighborhood");
				$row['created'] = date("Y-m-d H:i:s");
				$this->db->insert("customers",$row);
				$customer_id = $this->db->insert_id(); // get id of customer that was added
				
				//Create activity log for new customer
				$this->load->library("activitylog");
				//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
				$this->activitylog->createlog("Create", "customers", '', $this->session->userdata("user_id"), $customer_id);					
				
			}
			else
			{
				$customer_id = $this->input->post("customer_id");
			}

			if($this->input->post("job_type") == 5)
			{
				$job['customer_id'] = $customer_id;
				if ($this->input->post("user_id")) {
					$job['user_id'] = $this->input->post("user_id");
				} else {
					$job['user_id'] = $this->session->userdata("user_id");
				}
				$job['date'] = $this->input->post("job_date")." ".date("h:i:s");
				$job['created'] = date("Y-m-d H:i:s");
				$this->db->insert("service_calls",$job);
				$job_id = $this->db->insert_id();
				$json['job_url'] = 'service_call';
			}
			else
			{
				$job['customer_id'] = $customer_id;
				if ($this->input->post("user_id")) {
					$job['user_id'] = $this->input->post("user_id");
				} else {
					$job['user_id'] = $this->session->userdata("user_id");
				}
				$job['job_type_id'] = $this->input->post("job_type");
				$job['job_date'] = $this->input->post("job_date")." ".date("h:i:s");
				$job['created'] = date("Y-m-d H:i:s");
				$this->db->insert("jobs",$job);
				$job_id = $this->db->insert_id();
				
				//Create activity log for new job
				$this->load->library("activitylog");
				//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
				$this->activitylog->createlog("Create", "jobs", $job_id, $this->session->userdata("user_id"));
				
				$json['job_url'] = 'job';
			}

			$json['success'] = true;
			$json['job_id'] = $job_id;
			$json['msg'] = 'Job added successfully';
			echo json_encode($json);
		}
	}

	function view_job_notes($job_id='')
	{
		$this->load->helper("text");

		// get job/customer info
		$sql = "SELECT
				jobs.*,
				job_types.type as job_type,
				customers.first_name,
				customers.last_name
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			WHERE jobs.id=".$this->db->escape($job_id);
		$data['job'] = $this->db->query($sql)->row_array();

		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.job_id=".$this->db->escape($job_id);
		$data['job_notes'] = $this->db->query($sql)->result_array();

		$this->load->view("ajax/view_job_notes", $data);
	}

	function view_sc_notes($sc_id='')
	{
		$this->load->helper("text");

		// get job/customer info
		$sql = "SELECT
				service_calls.*,
				customers.first_name,
				customers.last_name
			FROM
				service_calls
			LEFT JOIN customers ON service_calls.customer_id=customers.id
			WHERE service_calls.id=".$this->db->escape($sc_id);
		$data['job'] = $this->db->query($sql)->row_array();

		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.service_call_id=".$this->db->escape($sc_id);
		$data['job_notes'] = $this->db->query($sql)->result_array();

		$this->load->view("ajax/view_sc_notes", $data);
	}

	function getCommentType()
	{
		$sql = "SELECT id,comment_type FROM comment_type";
		return $this->db->query($sql)->result_array();
		}
	function getRankType()
	{
		$sql = "SELECT id,rank_type FROM rank_type";
		return $this->db->query($sql)->result_array();
		}
	function add_job_note($job_id='')
	{
		$data['job_id'] = $job_id;
		foreach($this->getCommentType() as $comtype){
		$data['comment_type'][$comtype['id']] = $comtype['comment_type'];
		}
		if($this->session->userdata('warehouse')){
		  $data['comment_type'][99] = "Inventory";
		}
		foreach($this->getRankType() as $ranktype){
		$data['rating_type'][$ranktype['id']] = $ranktype['rank_type'];
		}
		
		$this->load->view("ajax/add_job_note",$data);
	}

	function add_sc_note($sc_id='')
	{
		$data['service_call_id'] = $sc_id;

		$this->load->view("ajax/add_sc_note",$data);
	}

	function edit_job_note($note_id='')
	{
		$data['note_id'] = $note_id;
		foreach($this->getCommentType() as $comtype){
		$data['comment_type'][$comtype['id']] = $comtype['comment_type'];
		}
		if($this->session->userdata('warehouse')){
		  $data['comment_type'][99] = "Inventory";
		}
		foreach($this->getRankType() as $ranktype){
		$data['rating_type'][$ranktype['id']] = $ranktype['rank_type'];
		}
		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.id=".$this->db->escape($note_id);
		$data['job_note'] = $this->db->query($sql)->row_array();
		$data['job_id'] = $data['job_note']['job_id'];

		$this->load->view("ajax/edit_job_note",$data);
	}

	function edit_sc_note($note_id='')
	{
		$data['note_id'] = $note_id;

		$sql = "SELECT notes.*, users.first_name, users.last_name FROM notes LEFT JOIN users ON notes.user_id=users.id WHERE notes.id=".$this->db->escape($note_id);
		$data['job_note'] = $this->db->query($sql)->row_array();
		$data['service_call_id'] = $data['job_note']['service_call_id'];

		$this->load->view("ajax/edit_sc_note",$data);
	}

	function delete_job_note($note_id='')
	{
		// get job id based on note id
		$this->db->where("id",$note_id);
		$note = $this->db->get("notes")->row_array();

		$this->db->where('id',$note_id);
		$this->db->delete("notes");

		redirect("admin/job_comment/".$note['job_id']);
	}

	function delete_sc_note($note_id='')
	{
		// get job id based on note id
		$this->db->where("id",$note_id);
		$note = $this->db->get("notes")->row_array();

		$this->db->where('id',$note_id);
		$this->db->delete("notes");

		redirect("admin/service_call/".$note['service_call_id']);
	}

	function do_update_note()
	{
		$row['note'] = $this->input->post("note");
		$this->db->where("id",$this->input->post("note_id"));
		$row['comment_type'] = $this->input->post("ctype");
		 $rtype=$this->input->post("rtype");
		if(isset($rtype) && $rtype>0 )
		$row['comment_rating'] = $rtype;

		$this->db->update("notes",$row);

		$json['success'] = true;
		$json['msg'] = 'Note has been updated!';
		echo json_encode($json);
	}

	function doaddnote()
	{
		//header('Content-Type: application/json; charset=utf-8');

		$json = array();
		if($this->input->post('ctype')=='')
		{
			$json['success'] = false;
			$json['msg'] = 'Please select comment type';
			echo json_encode($json);
			exit;
		}
		if($this->input->post('rtype')=='')
		{
			$json['success'] = false;
			$json['msg'] = 'Please select rating type';
			echo json_encode($json);
			exit;
		}
		if($this->input->post("note"))
		{
			
			$row = array();
			$row['job_id'] = $this->getparentjobid($this->input->post("job_id"));
			$row['service_call_id'] = $this->input->post("service_call_id");
			$row['note'] = $this->input->post("note");
			$row['comment_type'] = $this->input->post("ctype");
			$row['comment_rating'] = $this->input->post("rtype");
			$row['user_id'] = $this->session->userdata("user_id");
			$row['created'] = date("Y-m-d H:i:s");
			$this->db->insert("notes",$row);
			
			$sql = "SELECT job_type_id,job_pid FROM jobs WHERE id = '".$row['job_id']."'";
			$data = $this->db->query($sql)->row_array();
			if($data['job_type_id']==7 && $row['comment_type']==1)
			{
				$row['job_id'] = $data['job_pid'];
				$row['comment_type'] = 1;
				$this->db->insert("notes",$row);
				}
				$row['job_id'] = $this->input->post("job_id");
                        $sql = "SELECT
				users.email,customers.first_name,customers.last_name,jobs.contractor_id,jobs.installer_id,jobs.conduit_id FROM		jobs
			LEFT JOIN users ON jobs.user_id=users.id
                        LEFT JOIN customers ON jobs.customer_id=customers.id
                        LEFT JOIN  notification_setting ns ON ns.user_id = users.id
			WHERE ns.notification!=0 AND jobs.id=".$row['job_id'];
		        $data = array();

                        $data = $this->db->query($sql)->result_array();
                       if(count($data)>=1){
                            $name = ucfirst($data[0]['first_name'])." ".ucfirst($data[0]['last_name']);
                            @$this->sendcommentmail($data[0]['email'],$row['note'],$row['job_id'],$name);

                            $in_user = '';
                            if(trim($data[0]['contractor_id'])!=''){
                                $in_user .= "'".$data[0]['contractor_id']."',";
                            }
                            if(trim($data[0]['installer_id'])!=''){
                                $in_user .= "'".$data[0]['installer_id']."',";
                            }
                            if(trim($data[0]['conduit_id'])!=''){
                                $in_user .= "'".$data[0]['conduit_id']."',";
                            }
                            $in_user = substr($in_user,0,-1);
                            $assoc_users =  array();
							//echo $in_user;
                            if ($in_user!=''){
                             $assoc_users = $this->db->query("SELECT users.email from users WHERE id in ($in_user)")->result_array();
                            // print_R($assoc_users);
                            foreach ($assoc_users as $value){
                                @$this->sendcommentmail($value['email'],$row['note'],$row['job_id'],$name);
                            }
                            }
                        }
                        $row_users =  array();
                        $row_users = $this->db->query("SELECT users.email from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type in ('admin','engineer','warehouse' )")->result_array();
                        foreach ($row_users as $value){
                          @$this->sendcommentmail($value['email'],$row['note'],$row['job_id'],$name);
                        }

                        $json['success'] = true;
			$json['msg'] = 'comment added';
			echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = 'Problem adding Comment';
			echo json_encode($json);
		}
	}

	function add_file_iframe($job_id='')
	{
		$data['job_id'] = $job_id;
		$this->load->view("ajax/add_file_iframe",$data);
	}
        function add_plan_iframe($job_id='',$filet="")
	{
		$data['job_id'] = $job_id;
                $data['file_type'] = $filet;
		$this->load->view("ajax/add_plan_iframe",$data);
	}
        function add_sketch_iframe($job_id='',$filet="")
	{
		$data['job_id'] = $job_id;
                $data['file_type'] = $filet;
		$this->load->view("ajax/add_sketch_iframe",$data);
	}
        function add_predesignsketch_iframe($job_id='',$filet=""){
            $data['job_id'] = $job_id;
            $data['file_type'] = $filet;
	    $this->load->view("ajax/add_predesignsketch_iframe",$data);
	}
       function add_presale_iframe($job_id='',$filet="")
	{
		$data['job_id'] = $job_id;
                $data['file_type'] = $filet;
		$this->load->view("ajax/add_presale_iframe",$data);
	}

	function add_premit_iframe($job_id='',$filet="")
	{
		$data['job_id'] = $job_id;
                $data['file_type'] = $filet;
		$this->load->view("ajax/add_permit_iframe",$data);
	}
        function add_elecphoto_iframe($job_id='',$photo_id="")
	{
		$data['job_id'] = $job_id;
                $data['photo_id'] = $photo_id;
		$this->load->view("ajax/add_elecphoto_iframe",$data);
	}
        function add_userprofilephoto_iframe($user_id='',$profile=0)
	{
            $data['user_id'] = $user_id;
            $data['profile']=$profile;
            $this->load->view("ajax/add_userprofilephoto_iframe",$data);
	}
	function add_file($job_id='',$service_call='no')
	{
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
			$config['allowed_types'] = 'pdf|doc|docx|xls|xlsx|tiff|gif|jpg|png|jpeg';

			$this->load->library('upload');
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();

				$row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d H:i:s");
				$this->db->insert("files",$row);

				$this->load->view("ajax/file_uploaded",$data);
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_file",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_file",$data);
		}
	}

        function add_planfile($job_id='',$file_type="no", $service_call='no')
	{
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
                        if($file_type=="no"){

                            $config['allowed_types'] = 'pdf';
                        } else{
                          $config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/scheduler/uploads";
                          $config['allowed_types'] = 'gif|jpg|png|jpeg';
                        }

			$this->load->library('upload',$config);
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();

				$row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
                                $pid = $this->getparentjobid($job_id);
                                $row['job_id'] =  $pid;
				$row['created'] = date("Y-m-d H:i:s");
                                $row['created_by'] = $this->session->userdata("user_id");
                                $row['job_type'] = 2;
                                if($file_type=="no"){
                                    $this->db->insert("genral_files",$row);
                                    //  This is used to mantain the revision of plot plan
                                    $this->db->insert("plotplan_revision",$row);
                                } else {
                                    $this->db->insert("meter_files",$row);
                                }
                                /* Create activity log after creation for Final PV Design Plot Plan */
                                if($file_type=="no"){
					$this->load->library("activitylog");
					//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
					$this->activitylog->createlog("Create", "genral_files", $pid, $this->session->userdata("user_id"));
                                }                        
                                
				//$this->db->insert("genral_files",$row);
                                $data['jobid'] = $job_id ;
                                $data['file_type'] = $file_type;
                                $subject = "Uploaded Plot Plan - Please Confirm With Your Customer({cust_name})";
                                $content = " {name} has uploaded this file.";
								$is_changes=$this->input->post("changed_plan");
                                if($is_changes==1){
                                  $this->sendplotplanchange($job_id);
                                  $row_job_arr=array();
                                  $row_job_arr["changed_plan"]=$is_changes;
                                  $row_job_arr["changed_plan_date"]=date("Y-m-d");
                                  $this->db->where("job_pid",$pid);
                                  $this->db->update("jobs",$row_job_arr);
                                } else{
    								$row_job_arr=array();
                                    $row_job_arr["changed_plan"]=0;
                                    $this->db->where("job_pid",$pid);
                                    $this->db->update("jobs",$row_job_arr);
                                    $this->sendjobfilenotification($job_id,$content,$subject,0,1);
                                }
                                

                                $this->load->view("common/header");
				$this->load->view("ajax/plan_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_file",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_file",$data);
		}
	}
        function add_sketchfile($job_id='',$file_type="no", $service_call='no')
	{
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
                        if($file_type=="no"){

                            $config['allowed_types'] = 'pdf';
                        } else{
                          $config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/scheduler/uploads";
                          $config['allowed_types'] = 'gif|jpg|png|jpeg';
                        }
                       
			$this->load->library('upload',$config);
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();

				$row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d H:i:s");
                                $row['created_by'] = $this->session->userdata("user_id");
                                $row['job_type'] = 2;
                                $pid = $this->getparentjobid($job_id);
                                $row['job_id'] =  $pid;
                                $this->db->insert("sketch_files",$row);
                                $data['jobid'] = $job_id ;
                                $data['file_type'] = $file_type;
                                $data['user_id']=$this->session->userdata("user_id");
                                //if($this->session->userdata("role") != 'admin'){
                                    $subject = "{cust_name}: Sketch Uploaded - Ready to Measure";
                                    $content = " {name} has uploaded the file.";
                                    $this->sendjobfilenotification($job_id,$content,$subject,1,1);
                                //}
                                
                                /* Create activity log after creation for Sales Sketch */
				$this->load->library("activitylog");
				//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
				$this->activitylog->createlog("Create", "sketch_files", $pid, $this->session->userdata("user_id"));                                

                                
                                $this->load->view("common/header");
				$this->load->view("ajax/sketch_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_sketchfile",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_sketchfile",$data);
		}
	}
        function add_predesignsketchfile($job_id='',$file_type="no", $service_call='no')
	{
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
                        if($file_type=="no"){

                            $config['allowed_types'] = 'pdf';
                        } else{
                          $config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/scheduler/uploads";
                          $config['allowed_types'] = 'gif|jpg|png|jpeg';
                        }

			$this->load->library('upload',$config);
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();

				$row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d H:i:s");
                                $row['job_type'] = 2;
                                $pid = $this->getparentjobid($job_id);
                                $row['job_id'] =  $pid;
                                $row['created_by'] = $this->session->userdata("user_id");
                                $this->db->insert("predesignsketch_files",$row);
                                $data['jobid'] = $job_id ;
                                $data['file_type'] = $file_type;
                                $data['user_id']=$this->session->userdata("user_id");
                               // if($this->session->userdata("role") != 'admin'){
                                    $subject = "{cust_name}: Pre Design Sketch Uploaded ";
                                    $content = " {name} has uploaded the file.";
                                    $this->sendjobfilenotification($job_id,$content,$subject,0,1);
                                //}
                                
                                /* Create activity log after creation for Pre-Design Sketch */
				$this->load->library("activitylog");
				//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
				$this->activitylog->createlog("Create", "predesignsketch_files", $pid, $this->session->userdata("user_id"));                                   
				
				
                                $this->load->view("common/header");
				$this->load->view("ajax/predesignsketch_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_sketchfile",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_sketchfile",$data);
		}
	}
        function add_presalefile($job_id='',$file_type="no", $service_call='no'){
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
                        if($file_type=="no"){

                            $config['allowed_types'] = 'pdf';
                        } else{
                          $config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/scheduler/uploads";
                          $config['allowed_types'] = 'gif|jpg|png|jpeg';
                        }

			$this->load->library('upload',$config);
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();

				$row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d H:i:s");
                                $row['created_by'] = $this->session->userdata("user_id");
                                $row['job_type'] = 2;
                                $pid = $this->getparentjobid($job_id);
                                $row['job_id'] =  $pid;
                                $this->db->insert("presale_files",$row);
                                $data['jobid'] = $job_id ;
                                $data['file_type'] = $file_type;

                                //if($this->session->userdata("role") == 'admin'  ){
                                    $subject = "{cust_name} :- Pre-Measure Results & Feedback";
                                    $content = "{name} has uploaded this file.";
                                    $this->sendjobfilenotification($job_id,$content,$subject,1,1);
                                //}
                                
                                /* Create activity log after creation for Pre-Measure Results & Feedback file */
				$this->load->library("activitylog");
				//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
				$this->activitylog->createlog("Create", "presale_files", $pid, $this->session->userdata("user_id")); 
                     
                                
                                $this->load->view("common/header");
				$this->load->view("ajax/presale_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_presalefile",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_presalefile",$data);
		}
	}
         function add_permitfile($job_id='',$file_type="no", $service_call='no'){
		if ($service_call == 'yes') {
			$data['service_call_id'] = $job_id;
		} else {
			$data['job_id'] = $job_id;
		}
                $data['file_type'] = $file_type;

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/uploads";
			$config['encrypt_name'] = true;
                        $config['allowed_types'] = 'pdf';
                        $this->load->library('upload',$config);
			$this->upload->initialize($config);
			$permitno=@$this->input->post("permitno");
            if($file_type=="building" && $permitno<=0){
                $data['upload_error'] = true;
			    $data["message"]="Permit no can not be left empty.";
                $this->load->view("ajax/add_permitfile",$data);
            } else	if($this->upload->do_upload("upload"))  {
				$file_data = $this->upload->data();
                                $row = array();
				if ($service_call == 'yes') {
					$row['service_call_id'] = $job_id;
				} else {
					$row['job_id'] = $job_id;
				}
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d H:i:s");
                                $row['job_type'] = 2;
                                $pid = $this->getparentjobid($job_id);
                                $row['job_id'] =  $pid;
                                $row['type'] = $file_type;
                                $row['permit_no'] = @$this->input->post("permitno");
                                $this->db->insert("permit_files",$row);
                                $data['jobid'] = $job_id ;
                                $data['file_type'] = $file_type;
								$job_u=array();
								$job_u["building_permit"]=@$this->input->post("permitno");
                                $this->db->where("job_pid",$pid);
                                $this->db->update("jobs",$job_u);
                                $loadjob = $this->db->query("SELECT job_type_id,customer_id from jobs where id=$job_id")->row_array();
                                if($loadjob["job_type_id"]==2 && $file_type=="building" ){
                                    $this->pvbuildingpdfmailsend($_SERVER['DOCUMENT_ROOT']."/uploads/".$file_data['file_name'], $loadjob["customer_id"]);
                                }else if ($loadjob["job_type_id"]==1 && $file_type=="building"){
                                    $this->swhbuildingpdfmailsend($_SERVER['DOCUMENT_ROOT']."/uploads/".$file_data['file_name'], $loadjob["customer_id"]);
                                }
                                $this->load->view("common/header");
				$this->load->view("ajax/permit_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_permitfile",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_permitfile",$data);
		}
	}
        function add_elecphotofile($job_id='',$photo_id="1"){
		$data['job_id'] = $job_id;

                $data['photo_id'] = $photo_id;

		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/scheduler/uploads";
			$config['encrypt_name'] = true;
                        $config['allowed_types'] = 'jpg|jpeg|png|gif';
                        $this->load->library('upload',$config);
			$this->upload->initialize($config);

			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();
                                $row = array();
				$row['job_id'] = $job_id;
				$row['original_filename'] = $file_data['orig_name'];
				$row['unique_filename'] = $file_data['file_name'];
				$row['mime'] = $file_data['file_type'];
				$row['created'] = date("Y-m-d H:i:s");
                                $row['job_type'] = 2;
                                $row['title']=$file_data['orig_name'];
                                $row['file_size']=$file_data['file_size'];
                                $pid = $this->getparentjobid($job_id);
                                $row['job_id'] =  $pid;
                                $row['photo_id'] = @$photo_id;
                                $this->db->insert("elecphoto_files",$row);
                                $data['jobid'] = $job_id ;
                                $this->load->view("common/header");
				$this->load->view("ajax/elecphoto_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_elecphoto",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_elecphoto",$data);
		}
	}
         function add_userprofilephotofile($user_id,$profile){
		$data['user_id'] = $user_id;
		if($this->input->post("dosubmit"))
		{
			$config['upload_path'] = $_SERVER['DOCUMENT_ROOT']."/scheduler/uploads";
			$config['encrypt_name'] = true;
                        $config['allowed_types'] = 'jpg|jpeg|png|gif';
                        $this->load->library('upload',$config);
			$this->upload->initialize($config);
			if($this->upload->do_upload("upload"))
			{
				$file_data = $this->upload->data();
                                $row = array();
				//$row['unique_filename'] = $file_data['file_name'];
				$row['profile_photo'] = $file_data['file_name'];
				$this->db->where("id",$user_id);
                                $this->db->update("users",$row);
                                $this->load->helper("thumbnail_helper");
                                $src_path = $row['profile_photo'];
                                $data['profile_photo']='Profile Photo <a  href="'.base_url().'admin/deleteuserpp/'.$user_id.'/'.$profile.'">Delete Photo</a>  <br/><img src="'.thumbnail($src_path, 50, 50).'" />';
                                $this->load->view("common/header");
				$this->load->view("ajax/userprofilephoto_uploaded",$data);
                                $this->load->view("common/footer");
			}
			else
			{
				$data['upload_error'] = true;
				$this->load->view("ajax/add_userprofilephotofile",$data);
			}
		}
		else
		{
			$this->load->view("ajax/add_userprofilephotofile",$data);
		}
	}
	function service_calls($year='',$month='',$day='')
	{
		$this->load->helper('text');

		if($year=='') {$year = date("Y");}
		if($month=='') {$month = date("m");}
		if($day=='') {$day = date("d");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = sprintf("%02d",$day);

		$data['calendar_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);

		$extra_sql = '';
		if($this->session->userdata("role") != 'admin')
		{
			$extra_sql = " AND service_calls.user_id=".$this->db->escape($this->session->userdata('user_id'));
		}

		// get jobs for the current month
		$data['service_calls'] = $this->db->query("SELECT service_calls.*,customers.first_name,customers.last_name,customers.address,customers.city,customers.state FROM service_calls LEFT JOIN customers ON service_calls.customer_id=customers.id WHERE DATE_FORMAT(date,'%Y-%m-%d') = '".$year."-".$month."-".$data['day']."' $extra_sql ORDER BY service_calls.date ASC")->result_array();

		$this->load->view("ajax/service_calls",$data);
	}

	function quick_summary($year='',$month='',$day='')
	{
		if(@$year=='') {$year = date("Y");}
		if(@$month=='') {$month = date("m");}
		if(@$day=='') {$day = date("d");}
		$year = preg_replace("/[^0-9]/","",$year);
		$month = preg_replace("/[^0-9]/","",$month);
		$day = preg_replace("/[^0-9]/","",$day);
		$data['year'] = $year;
		$data['month'] = $month;
		$data['day'] = $day;
		$data['timeframe'] = array();
                $data['timeframe'][0]="Not Selected";
                $data['timeframe'][1]="9:00am-12:00am";
                $data['timeframe'][2]="1:00pm-4:00pm";
                $data['timeframe'][3]= "All Day";
		$data['day_timestamp'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
		$data['editjob'] = true;
		$extra_sql = '';
		$pv_sql = '';
		if($this->session->userdata("role") != 'admin' )
		{
		 //$extra_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));
                // $pv_sql = " AND users.id=".$this->db->escape($this->session->userdata("user_id"));

		}
                if( $this->session->userdata("role") == 'installer')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",installer_id)";
                  $data['editjob'] = false;
		}
                  if( $this->session->userdata("role") == 'contractor')
		{
		  $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",contractor_id)";
                  $data['editjob'] = false;
		}
        if( $this->session->userdata("rolep") == 'engineer')
		{
		 // $pv_sql = " AND FIND_IN_SET(".$this->db->escape($this->session->userdata("user_id")).",designer_id)";
           //       $data['editjob'] = false;
		}
		// grab photovoltaic jobs
		$sql = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex,
                        inverter_types.type as inverter_type_name,
                        module_brands.brand as module_brand_name
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
                        LEFT JOIN  inverter_types on  inverter_types.id= jobs.inverter_type_id
                        LEFT JOIN  module_brands on  module_brands.id= jobs.module_brand_id
			WHERE jobs.job_type_id='2' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."'  $pv_sql
			";
		$data['pv_jobs'] = $this->db->query($sql)->result_array();
		foreach($data['pv_jobs'] as $job){
                        $sql_split = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex,
                        inverter_types.type as inverter_type_name,
                        module_brands.brand as module_brand_name
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
                        LEFT JOIN  inverter_types on  inverter_types.id= jobs.inverter_type_id
                        LEFT JOIN  module_brands on  module_brands.id= jobs.module_brand_id
			WHERE jobs.id!=".$job['id']." AND  jobs.job_pid=".$job['job_pid']." AND jobs.job_type_id='2'   $pv_sql	";
		      $data['split_pv_jobs'][$job['job_pid']] = $this->db->query($sql_split)->result_array();

                }
		// grab solar water heating jobs
		$sql = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='1' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql ";
		#die(print($sql));
		$data['swh_jobs'] = $this->db->query($sql)->result_array();
                foreach ($data['swh_jobs'] as $swhjob){
                    $sql_swh = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.id!=".$swhjob["id"]." AND jobs.job_pid=".$swhjob["job_pid"]." AND jobs.job_type_id='1'  $pv_sql ";
		#die(print($sql));
		    $data['split_swh_jobs'][$swhjob["job_pid"]] = $this->db->query($sql_swh)->result_array();
                }

		// grab solar attic fan jobs
		$sql = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='3' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $extra_sql
		";
		$data['saf_jobs'] = $this->db->query($sql)->result_array();

		#die(print(count($data['jobs'])));

		$data['jobs'] = ($data['saf_jobs'] + $data['pv_jobs'] + $data['swh_jobs']);

		// get service calls for the day
		$sql = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='5' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql ";
		$data['service_calls'] = $this->db->query($sql)->result_array();

                // get service calls for the day
		$sql = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='6' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql ";
		$data['pl_jobs'] = $this->db->query($sql)->result_array();
                $sql = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
                        customers.neighborhood,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='7' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql ";
                        $data['pm_jobs'] = $this->db->query($sql)->result_array();

			  $sql = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
                        customers.neighborhood,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='15' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql ";
             $data['apm_jobs'] = $this->db->query($sql)->result_array();
         
		    $sql = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
                        customers.neighborhood,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='16' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql ";
               $data['ac_jobs'] = $this->db->query($sql)->result_array();
			
		    $sql = "SELECT
			jobs.*,
			job_types.intials as job_type,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
                        customers.neighborhood,
			users.first_name as user_first_name,
			users.last_name as user_last_name,
			users.custom_hex,
			colors.hex
			FROM
				jobs
			LEFT JOIN job_types ON jobs.job_type_id=job_types.id
			LEFT JOIN customers ON jobs.customer_id=customers.id
			LEFT JOIN users ON jobs.user_id=users.id
			LEFT JOIN colors ON users.color_id=colors.id
			WHERE jobs.job_type_id='9' AND DATE_FORMAT(job_date,'%Y-%m-%d') = '".date("Y-m-d",$data['day_timestamp'])."' $pv_sql ";
               $data['wm_jobs'] = $this->db->query($sql)->result_array();


                        $this->db->where('is_new =',1);
                        $neighbour_display = $this->db->get("neigbhour")->result_array();
                        foreach($neighbour_display as $row) { $data['neighbour'][$row['id']] = $row['neighbour']; }
                        global $schedular_role;
                        $data['userrole'] = in_array($this->session->userdata("role") , $schedular_role);
                        $this->load->view("ajax/quick_summary",$data);
	}

	function find_previous_customer()
	{
		header('Content-Type: application/json; charset=utf-8');

		$this->db->where('first_name',trim($this->input->post("re_first_name")));
		$this->db->where('last_name',trim($this->input->post("re_last_name")));
		$row = $this->db->get("customers")->row_array();

		if(count($row) > 0)
		{
			$json['success'] = true;
			$json['msg'] = 'Previous customer found matching '.$this->input->post("first_name")." ".$this->input->post("last_name");
			$json['address'] = $row['city'].", ".$row['state']." @ ".$row['address'];
			$json['customer_id'] = $row['id'];
                        $json['city']=$row['city'];
                        $json['state']=$row['state'];
                        $json['address1']=$row['address'];
                        $json['zip']=$row['zip_code'];
                        $json['phone']=$row['secondary_phone'];
                        $json['sun_zone']=$row['sun_zone'];
                        $json['email']=$row['email'];
						$this->db->where('job_type_id',2);
                        $this->db->where('customer_id',$row['id']);
		                $row_job = $this->db->get("jobs")->row_array();
                        if(count($row_job) > 0){
                            $json['job_exist']="y";
                        }else{
                            $json['job_exist']="n";
							
						}
						   $this->db->where('job_type_id',16);
							$this->db->where('customer_id',$row['id']);
							$row_job = $this->db->get("jobs")->row_array();
							if(count($row_job) > 0){
								$json['ac_job_exist']="y";
							}else{
								$json['ac_job_exist']="n";
							}
                        if(isset($row['neighborhood']) ){
                            $json['neighborhood'] = $row['neighborhood'];
                        }elseif($row['neighborhood']!="other"){
                            $json['neighborhood'] = $row['other_neighborhood'];
                        } else {
                            $json['neighborhood'] = "";
                        }
                        echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = 'No customer found '.$this->input->post("first_name")." ".$this->input->post("last_name");
                        $json['neighborhood'] = "";
			echo json_encode($json);
		}
	}
function find_previous_customer_refer()
	{
		header('Content-Type: application/json; charset=utf-8');

		$this->db->where('first_name',trim($this->input->post("refer_first_name")));
		$this->db->where('last_name',trim($this->input->post("refer_last_name")));
		$row = $this->db->get("customers")->row_array();

		if(count($row) > 0)
		{
			$json['success'] = true;
			$json['msg'] = 'Previous customer found matching '.$this->input->post("refer_first_name")." ".$this->input->post("refer_last_name");
			$json['address'] = $row['city'].", ".$row['state']." @ ".$row['address'];
			$json['customer_id'] = $row['id'];
                        $json['city']=$row['city'];
                        $json['state']=$row['state'];
                        $json['address1']=$row['address'];
                        $json['zip']=$row['zip_code'];
                        $json['phone']=$row['secondary_phone'];
                        if(isset($row['neighborhood']) ){
                            $json['neighborhood'] = $row['neighborhood'];
                        }elseif($row['neighborhood']!="other"){
                            $json['neighborhood'] = $row['other_neighborhood'];
                        } else {
                            $json['neighborhood'] = "";
                        }
                        echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = 'No customer found '.$this->input->post("refer_first_name")." ".$this->input->post("refer_first_name");
                        $json['neighborhood'] = "";
			echo json_encode($json);
		}
	}

	function update_day_count()
	{
		$year = $this->input->post("year");
		$month = $this->input->post("month");
		$day = $this->input->post("day");
		$sql = "UPDATE service_calls SET job_count=".$this->db->escape($this->input->post("job_count"))." WHERE DATE_FORMAT(`date`,'%Y-%m-%d') = '".$year."-".$month."-".$day."'";
		$this->db->query($sql);

		//$sql = "UPDATE jobs SET job_count=".$this->db->escape($this->input->post("job_count"))." WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".$day."'";
		//$this->db->query($sql);

		$json['success'] = true;
		$json['msg'] = 'Service call count updated';
		echo json_encode($json);
	}

	function update_job_count()
	{
		$year = $this->input->post("year");
		$month = $this->input->post("month");
		$day = $this->input->post("day");

		$sql = "UPDATE jobs SET job_count=".$this->db->escape($this->input->post("job_count"))." WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".$day."'";
		$this->db->query($sql);

		$json['success'] = true;
		$json['msg'] = 'Job count updated';
		echo json_encode($json);
	}

	function update_day_status($year='',$month='',$day='')
	{
		// get day's installation job count
		$jc = $this->db->query("SELECT job_count as total FROM jobs WHERE DATE_FORMAT(`job_date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."'")->result_array();
		$jc_total = 0;
		foreach($jc as $jcs)
		{
			$jc_total += $jcs['total'];
		}

		// get day's service call total count
		$sc = $this->db->query("SELECT job_count as total FROM service_calls WHERE DATE_FORMAT(`date`,'%Y-%m-%d') = '".$year."-".$month."-".sprintf("%02d",$day)."'")->row_array();

		$data['day_job_total'] = ($jc_total + @$sc['total']);

		// daily job limit
		$data['daily_limit'] = $this->db->get("job_limit")->row_array();

		$this->load->view("ajax/day_status",$data);
	}

	function update_job_status()
	{
           $job_id = $this->input->post("job_id");
           $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$job_id;
             $data['job'] = $this->db->query($sql)->row_array();
             $j = $this->getUserLoad($data['job']['user_id']);
             if($this->input->post("status") && $this->input->post("job_id"))
		{
			$pid = $this->getparentjobid($this->input->post("job_id"));
                        $row['current_status'] = $this->input->post("status");

			if($row['current_status']=='unscheduled'){
                           $row['job_date'] = null;
                           $installer = $this->db->query("SELECT sum(no_installer_allocated)as suminstaller FROM jobs where    job_pid= '".$pid."'")->result_array();
                           $this->db->query("DELETE FROM jobs where job_type_id=".$data['job']['job_type_id']." and id != job_pid and  job_pid= '".$pid."'");
                           $this->db->query("UPDATE jobs set job_lastscheduledate=job_date  where  job_pid= '".$pid."'");
                           $row['no_installer_allocated'] = $installer[0]['suminstaller'];
                        } else{
                            $row['status_updated'] = 'admin';
                        }
                         $warray = array('job_pid' => $pid, 'job_type_id' => $data['job']['job_type_id']);
                         $this->db->where($warray);
			      		 $this->db->update("jobs",$row);
			             $row_users =  array();
                        $row_users = $this->db->query("SELECT users.email,users.first_name,users.last_name from users
                            LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type in ('admin','engineer','warehouse' )")->result_array();
                        foreach ($row_users as $value){

                           $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $row['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$value['email'],0,null,$job_id);
                        }
                        $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $row['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$j[0]->email,$j[0]->id,null,$job_id);
                        if(isset($data['job']['contractor_id'])){
                           $cont = explode(",",$data['job']['contractor_id']);
                           foreach($cont as $user_id){
                            if(!isset($user_id)) continue;
                               $k = $this->getUserLoad($user_id);
                               $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $row['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$k[0]->email,$user_id,null,$job_id);
                            }
                        }
                        if(isset($data['job']['designer_id'])){
                            $cont = explode(",",$data['job']['designer_id']);
                            foreach($cont as $user_id){
                                if(!isset($user_id)) continue;
                               $k = $this->getUserLoad($user_id);
                               $this->statusnotifaction(ucfirst($data['job']['first_name']).ucfirst($data['job']['last_name']),$data['job']['current_status'] , $row['current_status'],ucfirst($j[0]->first_name).ucfirst($j[0]->last_name),$k[0]->email,$user_id,null,$job_id);
                        }
                       }
                        if(isset($data['job']['installer_id'])){
                            $cont = explode(",",$data['job']['installer_id']);
                            foreach($cont as $user_id){
                            if(!isset($user_id)) continue;
                            $k = $this->getUserLoad($user_id);
                            @$this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $row['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$k[0]->email,$user_id,null,$job_id);
                          }
                       }
					   if($this->input->post('status') == 'completed'){
							$sql = "SELECT * FROM osticket WHERE job_id = ".$job_id;
							$data = $this->db->query($sql)->row_array();
							if(@$data['os_ticket']!=''){
								 $this->load->helper('osticket');
								 close_ticket($data['os_ticket']);
								 $sql = "DELETE FROM osticket WHERE job_id = ".$job_id;
								$data = $this->db->query($sql);
				}
			}
                        $json['success'] = true;
			$json['msg'] = "Job status updated!";
			echo json_encode($json);
		}
		else
		{
			$json['success'] = false;
			$json['msg'] = "Problem updating job status!";


			echo json_encode($json);
		}

	}

	function update_daily_limit()
	{
		$sql = "UPDATE job_limit SET `limit`=".$this->db->escape($this->input->post("limit"));
		$this->db->query($sql);

		$json['success'] = true;
		$json['msg'] = 'Daily Limit';
		echo json_encode($json);
	}
    function  installer($year='',$month='',$job_id=0){
        $data = array();
        $data['job'] =array();
        $data["sct"] ="";
        if($job_id) {
		// get job data
		$sql = "SELECT
			jobs.*,
                         sum(jobs.no_installer_allocated) as sum_installer_allocated,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.job_type_id!=6 AND jobs.job_type_id!=7 AND jobs.job_pid=".$this->db->escape($job_id)." GROUP BY jobs.job_pid
		";
            $data['job'] = $this->db->query($sql)->row_array();
            $data["sct"] ="var customer_id = '';var userid =''; var reserverjob;";
          }

        $data['customer_id'] = '';
       	$month = ltrim($month,"0");
	$data['year'] = $year;
	$data['month'] = $month;
	//$data['day'] = $day;
	//$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
	if($this->input->get("customer_id")){
            $data['customer_id'] = $this->input->get("customer_id");
            $data['customer'] = $this->db->query("SELECT * FROM customers WHERE id=".$this->db->escape($data['customer_id']))->row_array();
	}
	/**
         *  To do to remove the hard coded
         */
        $data["numberofsystem"] = array(""=>"Select Number of Systems", "1"=>"1","2"=>"2","3"=>"3","4"=>"4","5"=>"5","6"=>"6");

        $module_array = array(""=>"Select Number of Modules");
        for ($i = 1 ; $i<=100;$i++){
            $module_array[$i] = $i;
        }
        $data["nomodule"] = $module_array;
        $data["nosubarray"] = array(""=>"Select Number of Sub-Arrays","1"=>"1","2"=>"2","3"=>"3","4"=>"4","5"=>"5","6"=>"6","7"=>"7","8"=>"8");
        $sql = "SELECT id,type FROM roof_types ";
        $roof_typea = array();
        $roof_typea["0"]= "-Select roof type-";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0){
             foreach ($query->result() as $row){
                $roof_typea[$row->id] =  $row->type;
            }
        }
        $data["roof_type"]= $roof_typea;

        $data["module_brands"] = array("0"=>"Select Module Type");
        $this->db->order_by('id','asc');
        $moniter_display = $this->db->get("module_brands")->result_array();
        foreach($moniter_display as $row) {
          $data["module_brands"][$row['id']] = $row['brand'];
        }

        $data["wirerundistance"] = array("0"=>"Select Wire Run Distance");
        $this->db->order_by('id','asc');
        $moniter_display = $this->db->get("wire_run_distance")->result_array();
        foreach($moniter_display as $row) {
          $data["wirerundistance"][$row['id']] = $row['type'];
        }

        //$data["wirerundistance"] = array(""=>"Select Wire Run Distance","1"=>"1-20","2"=>"21-40","3"=>"41-80","4"=>"81-120","5"=>"Electrical Contractor");
        $sql = "SELECT id,type FROM wire_run_types ";
        $wire_typea = array();
        $wire_typea[" "]="Select A Wire Run Type";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0){
             foreach ($query->result() as $row){
                $wire_typea[$row->id] =  $row->type;
            }
        }

        $data["wire_type"] = $wire_typea;
        $data["nod"] = array("1"=>"1", "2"=> "2", "3"=>"3","4"=>"4");

        $this->load->view("ajax/installer.php",$data);
    }

    function validate_savejob() {
            $this->load->library('validation');
            $new_customer = false;
            // set validation rules
            $rules['job_type'] = "required";
            $rules['re_first_name'] = "required";
            $rules['re_last_name']	= "required";
            $rules['neighborhood']="required";
	// set field "real" names
            $fields['re_first_name'] = "First Name";
            $fields['re_last_name'] = "Last Name";
            $fields['job_type'] = "Job Type";
            $fields['customer_type'] = "Customer Type";
            $fields['neighborhood'] = "Geographical Area";
            if($this->input->post("customer_id") == ''){
                $new_customer = true;
		$rules['customer_type'] = "required";
            }
            if($this->input->post("spouse_firstname") != ''){
                $rules['spouse_firstname'] = "required";
                $fields['spouse_firstname']="Another First Name";
            }
            if($this->input->post("spouse_lastname") != ''){
               $rules['spouse_lastname']= "required";
               $fields['spouse_lastname']="Another Last Name";
            }
                //$this->validation->set_message('alpha_numeric', 'There is an illegal character being used, please check that there are no spaces or //non-alpha-numeric characters.');
		$this->validation->set_rules($rules);
		$this->validation->set_fields($fields);
		if($this->validation->run() == FALSE)
		{
			$json['success'] = false;
			$json['msg'] = $this->validation->error_string;
			echo json_encode($json);
                        return ;
		}
                $json['success'] = true;
                echo json_encode($json);
    }
    function day_installerassign($year='',$month='',$day='' , $noinstaller = 4 , $noofday = 1){
        global $pv_job_count,$swh_job_count;
        $data = array();
        $data['customer_id'] = '';
        if($year==''){
            $year = date("Y");
            $month = date("n");
            $day = date("j");
	}
	$month = ltrim($month,"0");
	$day = ltrim($day,"0");

	$data['year'] = $year;
	$data['month'] = $month;
	$data['day'] = $day;
        $sql_jobcount = "SELECT count(*)as totaljobs FROM jobs WHERE jobs.job_type_id=".$this->session->userdata('job_type')." and job_date='$year-$month-$day'";
        $nojob = $this->db->query($sql_jobcount)->row_array();
        $date =date("Y-m-d",strtotime("$year-$month-$day"));
        $sql = "SELECT * FROM day_job_setting WHERE job_date='$year-$month-$day' order by id desc";
        $result = $this->db->query($sql)->row_array();
        if(!@$result['id']) {
         $pswh_job_count=$swh_job_count;
         $ppv_job_count=$pv_job_count;
       } else {
        $ppv_job_count=$result['pv'];
        $pswh_job_count=$result['swh'];
       }
        $data['available_installer'] = $noinstaller;
        $data['total_installer']= $this->session->userdata("in_noi");
        $data['no_day'] = $this->session->userdata("in_nod");
	$data['current_day'] = $noofday;
        $data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
        /**
         *  To do to remove the hard coded
         */
         $selectinstaller = array();
         $selectinstaller[0] = "Select Number of Installers";
         if ($data['no_day'] == 1){
             $selectinstaller[$data['total_installer']] = $data['total_installer'];
         }else {
	       if($this->session->userdata('job_type')==16){
					$selectinstaller[1] = 1;
		   } else{
			for($i = 1; $i<=$data['total_installer']; $i++ ){
				$selectinstaller[$i] = $i;
				if ($i >=8) break;
			}
		   }
         }
         $data["numberofinstaller"] = $selectinstaller;
         if($this->session->userdata('job_type')==1 && $nojob['totaljobs']>=$pswh_job_count){
            $data['job_error']="Sorry, SWH jobs at full capacity for this date";
            $this->load->view("ajax/installer_bookederror.php",$data);
            return;
        }
        if($this->session->userdata('job_type')==2 && $nojob['totaljobs']>=$ppv_job_count){
            $data['job_error']="Sorry, PV jobs at full capacity for this date";
            $this->load->view("ajax/installer_bookederror.php",$data);
            return;
        }
         if(!$noofday){
           $this->load->view("ajax/installer_assignederror.php",$data);
        }else{

            $this->load->view("ajax/installer_assign.php",$data);
        }
    }
    function block_day($date,$message=""){
     if (!$date  ){
        return 0;
     }
     else{
         //$date = "$year-$month-$day";
     $sql = "INSERT INTO admin_block_date(block_date,message) values('$date','$message')";
     $this->db->query($sql);
       echo 1;
     }
    }
     function block_day_form($year='',$month='',$day=''){
          $date = "$year-$month-$day";
          $data['year'] = $year;
	$data['month'] = $month;
	$data['day'] = $day;
	$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
          $data['date'] = $date;

        /**
         *  To do to remove the hard coded
         */

        $this->load->view("ajax/adminblockday",$data);

    }
    function save_session(){
        $this->canceljob();
        $this->session->set_userdata($_POST);
        if($this->session->userdata('job_type')==5){
            $setagain["in_noi"] = 1 ;
            $setagain["in_nod"] = 1 ;
            $this->session->set_userdata($setagain);

        }
		
		if($this->session->userdata('job_type')==8){
            $setagain["in_noi"] = 1 ;
            $setagain["in_nod"] = 1 ;
            $this->session->set_userdata($setagain);

        }

        if($this->session->userdata('job_type')==6){
            $setagain["job_type_pl"] = 6 ;
            $setagain["job_new_pl"] = 1 ;
            //$this->session->userdata('job_new_pl')
            $this->session->set_userdata($setagain);

        }
         if($this->session->userdata('job_type')==7){
            $setagain["job_type_pm"] = 7 ;
            $setagain["job_new_pm"] = 1 ;
            //$this->session->userdata('job_new_pl')
            $this->session->set_userdata($setagain);

        }
		if($this->session->userdata('job_type')==9){
            $setagain["job_type_pm"] = 9 ;
            $setagain["job_new_pm"] = 1 ;
            //$this->session->userdata('job_new_pl')
            $this->session->set_userdata($setagain);

        }
		if($this->session->userdata('job_type')==15){
            $setagain["job_type_pm"] = 15 ;
            $setagain["job_new_pm"] = 1 ;
            //$this->session->userdata('job_new_pl')
            $this->session->set_userdata($setagain);

        }

        $json['success'] = true;
        echo json_encode($json);

    }
    function save_session_un($job_id,$is_pm_schedule=0,$is_pl_schedule=0){
      $this->canceljob();
      $pid = $this->getparentjobid($job_id);
	// Create commnet before rescheduling job      
	$row=array();
	$row['comment']=$this->input->get("comment");
	$row['option_reason'] = $this->input->get("option_reason");
	$row['job_id']= $pid;
	$row['created'] =  date("Y-m-d H:i:s");
	$row['user_id']=$this->session->userdata("user_id");
	$this->db->insert("job_reschedule_comment",$row);        
      
      $sql = "SELECT
			jobs.*,
                        sum(no_installer_allocated) as sum_installer_allocated,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
                        customers.customer_type_id,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
                        customers.neighborhood as neighborhood,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.job_type_id!=6 AND jobs.job_type_id!=7 AND jobs.job_type_id!=9  AND  jobs.job_pid=".$this->db->escape($pid)." GROUP BY jobs.job_pid
		";
		$data['job'] = $this->db->query($sql)->row_array();

          
		$data['job'] = $this->db->query($sql)->row_array();
             $sql_pl = "SELECT	count(*) as cnt  FROM  jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE  jobs.job_type_id in (7,9)  AND  jobs.job_pid=".$this->db->escape($pid)." GROUP BY jobs.job_pid
		";
	
                $row_pm =array();
                 $row_pm = $this->db->query($sql_pl)->row_array();
                $arr = array();
         if(isset($row_pm['cnt']) && $row_pm['cnt']>0){
           $arr[0]['pm_exist']= 1;
         }else{
           $arr[0]['pm_exist']= 0;
         }

        $arr[0]['pm_reschedule']= $is_pm_schedule;
        $arr[0]['pl_reschedule']= $is_pl_schedule;
        $arr[0]['job_id'] = $data['job']['id'];
        $arr[0]['in_nos'] = $data['job']['job_nos'];
        $arr[0]['in_nom'] = $data['job']['job_nom'];
        $arr[0]['module_brand_id'] = $data['job']['module_brand_id'];
        $arr[0]['in_nosa'] = $data['job']['job_nosa'];
        $arr[0]['in_rooftype'] = $data['job']['roof_type_id'];
        $arr[0]['in_wirerundist'] = $data['job']['wire_run_distance'];
        $arr[0]['in_wireruntype'] = $data['job']['wire_run_type_id'];
        $arr[0]['in_noi'] = $data['job']['sum_installer_allocated'];

        if($data['job']['in_nod']){
            $arr[0]['in_nod'] = $data['job']['in_nod'];
        }else if ($arr[0]['in_noi']<16){
            $arr[0]['in_nod'] = 1;
        }else if ($arr[0]['in_noi']>16 && $arr[0]['in_noi']<=32){
            $arr[0]['in_nod'] = 2;
        }else if ($arr[0]['in_noi']>32){
            $arr[0]['in_nod'] = 3;
        }else{
            $arr[0]['in_nod'] = 1;
        }
        //$arr[0]['in_nod'] = 1;
        $arr[0]['customer_id'] = $data['job']['customer_id'];
       // $arr[0]['year'] = $data['job'][0]['id'];
        //$arr[0]['month'] = $data['job'][0]['id'];
        $arr[0]['customer_type'] = $data['job']['customer_type_id'];
        $arr[0]['job_type'] = $data['job']['job_type_id'];
        $arr[0]['re_first_name'] = $data['job']['first_name'];
        $arr[0]['re_last_name'] = $data['job']['last_name'];
        $arr[0]['found_client'] = 'y';
        $arr[0]['re_user_id'] = $data['job']['user_id'];
        $arr[0]['nop'] = $data['job']['panel_count'];
        $arr[0]['job_pid'] = $data['job']['job_pid'];
        $arr[0]['piperundist'] = $data['job']['piperun_length'];
        $arr[0]['job_type_pl'] = 0;
        $arr[0]['job_type_pm'] = 0;
        $arr[0]['neighborhood']=$data['job']['neighborhood'];
		$arr[0]['meter_type']=$data['job']['jobs_emt'];
		

        $arr =$arr[0];
        $this->session->set_userdata($arr);
		if(isset($row_pm['cnt']) && $row_pm['cnt']>0){
           $json['pm_exist']= 1;
           $json['nom']= $data['job']['job_nom'];
           $json['in_rooftype']= $data['job']['roof_type_id'];
           $json['user_id']=  $data['job']['user_id'];
         } else{
           $json['pm_exist']= 0;
         }
        $json['success'] = true;
        echo json_encode($json);

    }
    function save_sessioninstaller(){
        $date=$this->input->get("re_date");
        $numberofinstaller=$this->input->get("in_nos");
        $user_id=0;
         if (!$user_id) {
            $user_id = $this->session->userdata("re_user_id");
            if(!$user_id){
                $setagain["re_user_id"] = $this->session->userdata("user_id");
                $this->session->set_userdata($setagain);
                $user_id = $this->session->userdata("user_id");
            }
        }
        if (!$date &&  !$numberofinstaller &&!$user_id){
            $json['success'] = false;
            echo json_encode($json);
            return ;
        }
          $pl_session_installer = $this->db->query("SELECT *  FROM  pl_session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")." ORDER BY id")->row_array();
          if(@$pl_session_installer['date_booked']){
              if($pl_session_installer['date_booked']>$date){
                   $json['success'] = false;
                   $json['msg'] = 'Cannot assign final installation date before your prelag date.';
                   echo json_encode($json);
                   return;
              }
          }
          $session_id = $this->session->userdata("re_session_id");
          $noi_session = $this->session->userdata('in_noi');
          $nod_session =  $this->session->userdata('in_nod');
          $setagain["in_noi"] = $noi_session - $numberofinstaller ;
          $setagain["in_nod"] = $nod_session - 1;
          $this->session->set_userdata($setagain);
          $sql = "INSERT INTO session_installer(sessionid,date_booked,user_id,number_of_installer) VALUES('$session_id', '$date',$user_id,$numberofinstaller )";
          $this->db->query($sql);
          $json['success'] = true;
          echo json_encode($json);

    }
    function canceljob($return_type=0){
      $session_id = $this->session->userdata("re_session_id");
      $sql = "DELETE FROM  session_installer WHERE sessionid='$session_id'";
      $this->db->query($sql);
      $sql_pl = "DELETE FROM  pl_session_installer WHERE sessionid='$session_id'";
      $this->db->query($sql_pl);
      $sql_pm = "DELETE FROM  pm_session_installer WHERE sessionid='$session_id'";
      $this->db->query($sql_pm);
      $this->session->unset_userdata('re_user_id');
      $this->session->unset_userdata('re_first_name');
      $this->session->unset_userdata('re_last_name');
      $this->session->unset_userdata('job_type');
      $this->session->unset_userdata('job_id');
      $this->session->unset_userdata('found_client');
      $this->session->unset_userdata('in_noi');
      $this->session->unset_userdata('in_nom');
      $this->session->unset_userdata('in_nod');
      $this->session->unset_userdata('assigned_pl_installer');
      $this->session->unset_userdata('assigned_pm_installer');
      $this->session->unset_userdata('job_type_pm');
      $this->session->unset_userdata('job_type_pl');
      $this->session->unset_userdata('proposal_id');
      $this->session->unset_userdata('job_new_pl');
      $this->session->unset_userdata('job_new_pm');
      $this->session->unset_userdata('neighborhood');
      $this->session->unset_userdata('job_pid');
      $this->session->unset_userdata('pm_reschedule');
      $this->session->unset_userdata('pl_reschedule');
      $this->session->unset_userdata('proposal_id');
      $this->session->unset_userdata('customer_id');
      $this->session->unset_userdata('module_brand_id');
      $this->session->unset_userdata('customer_exist');
      $this->session->unset_userdata('customer_id');
	  $this->session->unset_userdata('meter_type');
	  $this->session->unset_userdata('dml_collect_type');

      if($return_type) {
        $json['success'] = true;
        echo json_encode($json);
      }
   }
    function savejob() {

      $year = "";
      $month = "";
      $pid = 0;
      $job_id = 0;
      $job_update  = false;
      $da[0]->job_lastscheduledate=null;
      $this->load->library("activitylog");
	  $homeown_association="None";
      
	  if($this->session->userdata('dml_collect_type')==2){
		  $proposal_id=$this->session->userdata('proposal_id');
	      $job_id=$this->createproposaljob( $proposal_id);
	      $this->savePMjobs(null,null, null);
          return;
	  }
      
	  if(@$this->session->userdata('job_type_pm')==7 && $this->session->userdata('job_new_pm')==1 ){
         $this->savePMjobs(null, null, null);
         return;
      }
      if(@$this->session->userdata('job_type_pl')==6 && $this->session->userdata('job_new_pl')==1 ){
          //$pid= $this->getparentjobid(@$this->session->userdata('job_id'));
          $this->savePLjobs(null,null , false);
          return;
      }
       if(@$this->session->userdata('job_type_pl')==6 && @$this->session->userdata('job_type_pm')==7 ){
          $pid= $this->getparentjobid(@$this->session->userdata('job_id'));
          $this->savePLjobs(null,$pid , true);
          $this->savePMjobs(null,$pid, true);
          $this->canceljob();
          return;
      }

      if(@$this->session->userdata('job_type_pl')==6){
          $pid= $this->getparentjobid(@$this->session->userdata('job_id'));
          $this->savePLjobs(null,$pid , true);
          $this->canceljob();
          return;
      }
      if(@$this->session->userdata('job_type_pm')==7){
          $pid= $this->getparentjobid(@$this->session->userdata('job_id'));
          $this->savePMjobs(null,$pid, true);
          $this->canceljob();
          return;
      }
	  if(@$this->session->userdata('job_type_pm')==9 && $this->session->userdata('job_new_pm')==1 ){
         $this->saveSWHPMjobs(null, null, null);
         return;
      } 
	  if(@$this->session->userdata('job_type_pm')==9){
          $pid= $this->getparentjobid(@$this->session->userdata('job_id'));
          $this->saveSWHPMjobs(null,$pid, true);
          $this->canceljob();
          return;
      }

      if(@$this->session->userdata('job_id')&& @$this->session->userdata('job_pid')){
         $pid  = @$this->session->userdata('job_pid');
         $job_id = $this->session->userdata('job_id');
         $session_installer = $this->db->query("SELECT *  FROM  pl_session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")." ORDER BY id")->row_array();
         $session_installer_pm = $this->db->query("SELECT *  FROM  pm_session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")." ORDER BY id")->row_array();
         if(@$session_installer['date_booked'] && @$session_installer_pm['date_booked'] ){
             $sql = "DELETE FROM jobs  where  id!=job_pid AND job_pid=".$pid;
         } else if(@$session_installer['date_booked']) {
            $sql = "DELETE FROM jobs  where job_type_id!=7 AND id!=job_pid AND job_pid=".$pid;
         } else if(@$session_installer_pm['date_booked']){
            $sql = "DELETE FROM jobs  where job_type_id!=6 AND id!=job_pid AND job_pid=".$pid;
         }else{
            $sql = "DELETE FROM jobs  where job_type_id!=9 AND job_type_id!=6 AND job_type_id!=7  AND id!=job_pid AND job_pid=".$pid;
         }
         $this->db->query($sql);
         $sql = "SELECT job_lastscheduledate FROM jobs where job_pid=".$pid;
         $da = $this->db->query($sql)->result();
         $job_update  = true;
      }
      if(!$this->session->userdata('customer_id') ||  $this->session->userdata('customer_exist')=='n' ) {
        // need to add new customer to db
        $row = array();
	$row['first_name'] =  $this->session->userdata('re_first_name');
	$row['last_name'] = $this->session->userdata('re_last_name');
        $row['first_name1'] =  $this->session->userdata('spouse_firstname');
	$row['last_name1'] = $this->session->userdata('spouse_lastname');
        $row['customer_type_id'] = $this->session->userdata('customer_type');
        $row['neighborhood'] = $this->session->userdata('neighborhood');
	$row['created'] = date("Y-m-d H:i:s");
	$this->db->insert("customers",$row);
	$customer_id = $this->db->insert_id(); // get id of customer that was added
	
	//Create activity log for new customer
	//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
	$this->activitylog->createlog("Create", "customers", '', $this->session->userdata("user_id"), $customer_id);	
	}
	else
        {
	$customer_id = $this->session->userdata("customer_id");
        $row['neighborhood'] = $this->session->userdata('neighborhood');
        $this->db->where("id",$customer_id);
        $this->db->update("customers",$row);
        
	//Create activity log for updated customer
	//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
	$this->activitylog->createlog("Update", "customers", '', $this->session->userdata("user_id"), $customer_id);		
        
	}

       $dateinstall = array();
       $session_installer = array();
       $session_installer = $this->db->query("SELECT *  FROM  session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")." ORDER BY id")->result_array();
       $job['in_nod']= count($session_installer);


       foreach($session_installer as $key => $value)
          {
          $date_mail[]= strtotime($value['date_booked']);
           if (!$job_update && $this->session->userdata('job_id')){
            $sql = "SELECT jobs.* FROM 	jobs WHERE jobs.id=".$this->db->escape($job_id);
            $job = $this->db->query($sql)->row_array();
            unset($job['id']);
            unset($job['current_status']);

           }
           $job['current_status'] = "";
           $job['customer_id'] = $customer_id;
           $job['user_id'] = $this->session->userdata('re_user_id');
           $job['job_type_id'] = $this->session->userdata('job_type');

             if($this->session->userdata('job_type')==2){
                $session_installer_data[date("j", strtotime($value['date_booked']))][] = $value;
                $job['modified_by'] =  $this->session->userdata("user_id");
                $job['job_date'] =$value['date_booked']." ".date("h:i:s");
                $dateinstall[] =date("l,F j, Y",strtotime($value['date_booked'])) ;
                //$job['created'] = date("Y-m-d H:i:s");
                $job['no_installer_allocated'] = $value['number_of_installer'];
                $job['module_brand_id'] =  $this->session->userdata('module_brand_id');
                $job['job_nos'] =  $this->session->userdata('in_nos');
                $job['job_nosa'] =  $this->session->userdata('in_nosa');
                $job['job_nom'] =  $this->session->userdata('in_nom');
                $module_id=$this->session->userdata('module_brand_id');
                if($module_id==31){
                   $job["system_size"] = $job['job_nom']*225/1000;
                } else if($module_id==32){
                    $job["system_size"] = $job['job_nom']*255/1000;
                } else if($module_id==33) {
                  $job["system_size"] = $job['job_nom']*260/1000;
                }
                $job['roof_type_id'] =  $this->session->userdata('in_rooftype');
                $job['wire_run_distance'] =  $this->session->userdata('in_wirerundist');
                $job['wire_run_type_id'] =  $this->session->userdata('in_wireruntype');
                $job['jobs_emt']=$this->session->userdata('meter_type');
                if( $this->session->userdata('proposal_id')){
                   $job['proposal_id']=$this->session->userdata('proposal_id');
                   $sql_prop = "SELECT * FROM  proposal WHERE id=".$this->session->userdata('proposal_id');
                   $result =$this->db->query($sql_prop)->row_array();
                   $customer_update = array();
                   $customer_update['city'] = $result['city'];
                   $customer_update['state'] =$result['state'];
                   $customer_update['address'] =$result['address'];
                   $customer_update['home_phone'] ="home";
                   $customer_update['home_phone1'] ="cell";
                   $customer_update['secondary_phone'] = $result['phone'];
                   $customer_update['secondary_phone1'] =$result['sphone'];
                   $customer_update['zip_code'] =$result['zip'];
                   $customer_update['email']=$result['email'];
                   $customer_update['sun_zone'] =$result['avgzoneenergy'];
                   $customer_update['association']=$result["home_owner_assoc_name"];
				   if($result["home_owner_assoc_name"]!=""  &&  $result["home_owner_assoc_name"]!=NULL )
				    $homeown_association=$result["home_owner_assoc_name"];
                    $this->db->where("id",$customer_id);
                    $this->db->update("customers",$customer_update);
                    
		//Create activity log for updated customer
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "customers", '', $this->session->userdata("user_id"), $customer_id);		
                   
                    
                   $job['list_price'] =$result['price'];
                   $job['assessed_value']=$result['assessed_value'];
                   $job['permit_fee']=$result['permit_fee'];
                   $payment_type_method=1;
                   switch($result['mop']){
                    case 'amex' :
                        $job['payment_type_id']=1;
                        break;
                     case 'visa':
                         $job['payment_type_id']=5;
                         break;
                     case 'mc':
                         $job['payment_type_id']=6;
                         break;
                     case 'cash/Check':
                         $job['payment_type_id']=2;
                         break;
                    case 'financing':
                         $job['payment_type_id']=4;
                         break;
                     case 'other':
                        // $job['payment_type_id']=$result['mop'];
                   }
                   $sum_tax = 0;
                   $nos = $result['nos'];
				   if($nos)   $new_price = @$result['price']/$nos;
                   for($k=0;$k<$nos;$k++){
                    $state_exicse_tax = .35*$new_price;
                    if($state_exicse_tax >5000){
                     $state_exicse_tax = 5000;
                    }
                    $federal_tax_credit=.3*$new_price;
                    $sum_tax += $federal_tax_credit+$state_exicse_tax;
                    if($k==0){
                      $job['state_tax_credit'] = number_format($state_exicse_tax,2);
                      $job['federal_tax_credit'] = number_format($federal_tax_credit,2);
                    } else {
                     $job['state_tax_credit_'.$k] = number_format($state_exicse_tax,2);
                     $job['federal_tax_credit_'.$k] = number_format($federal_tax_credit,2);
                    }


                   }
                   $job['total_tax_credits'] = number_format($sum_tax,2);
                   $job['net_total_price'] = number_format(($result['price']-$sum_tax),2);
                   $job['sub_total_price'] = number_format(($result['price'] + $result['price']*0.04712),2);
                   $job['system_size'] = $result['system_size'];
                   if($result['module_type']==1){
                    $job['module_brand_id']=32;

                   }elseif($result['module_type']==2){
                     $job['module_brand_id']=31;
                   } elseif($result['module_type']==70){
                     $job['module_brand_id']=33;
                   } else{
                       $job['module_brand_id']=$result['module_type'];
                   }
                   switch($result['invertert']){
                     case 3:
                        $job['inverter_type_id']=31;
                         break;
                     case 4:
                        $job['inverter_type_id']=25;
                         break;
                     case 5:
                        $job['inverter_type_id']=37;
                         break;
                     case 6:
                        $job['inverter_type_id']=34;
                         break;
                     case 7:
                        $job['inverter_type_id']=36;
                         break;
                     case 43:
                         $job['inverter_type_id']=26;
                             break;
                     case  73:
			   $job['inverter_type_id']=33;
                            break;
                     case  74:
			    $job['inverter_type_id']=38;
                            break;
                    case  77:
			    $job['inverter_type_id']=39;
                            break;
				case  203:
			    $job['inverter_type_id']=203;
                            break;
                   }
               $job["inverter_count"] = $result['not'];

               switch($result["roof_type"]){
               case 8:
                  $job['roof_type_id'] =8;
                  break;
              case 9:
                  $job['roof_type_id'] =8;
                  break;
              case 10:
                  $job['roof_type_id'] =12;
                  break;
             case 11:
                  $job['roof_type_id'] =14;
                  break;
              case 37:
                  $job['roof_type_id'] =5;
                  break;
              case 94:
                  $job['roof_type_id']=13;
                  break;
              case 38:
                  $job['roof_type_id'] =2;
                  break;
               case 39:
                  $job['roof_type_id'] =15;
                  break;
             case 40:
                  $job['roof_type_id'] =16;
                  break;
              case 41:
                  $job['roof_type_id'] =9;
                  break;
              case 42:
                  $job['roof_type_id'] =6;
                  break;
              case 71:
                  $job['roof_type_id'] =11;
                  break;
            }
          if ($result["is_tilt_kit"]==1){
              $result["tilt_kit_needed"]='y';

          }else if ($result["is_tilt_kit"]==2) {
              $result["tilt_kit_needed"]='n';
          }
            $job['qoute_upcharge']=$result['qoute_upcharge'];
            $job['qoute_addwork']=$result['qoute_addwork'];
            $job['addedcharge']=$result['addedcharge'];
            $job['discount']=$result['discountadd'];
            $job['referral_job']=$result['referral_job'];
            $job['jobs_emt']=$result['meter_type'];
            if($result['is_tilt_kit']==1)
             $job['tilt_kit_needed']='y';
            else
              $job['tilt_kit_needed']='n';
            
            $proposal_pid =$this->db->query("SELECT proposal_pid FROM proposal WHERE id=".$this->session->userdata('proposal_id'))->row_array();
            $porposal_delete= $this->db->query("UPDATE  proposal SET is_delete=0 WHERE proposal_pid=".$proposal_pid["proposal_pid"]." AND  id!=".$this->session->userdata('proposal_id'));
            $this->db->query("UPDATE proposal set is_schedule=1,proposal_pid=id WHERE id=".$this->session->userdata('proposal_id'));
         }  $job['job_pid'] = $pid;
                if(!$job_update){
					$job['created'] = date("Y-m-d H:i:s");
                    $this->db->insert("jobs",$job);
                    $job_id = $this->db->insert_id();
                    
			//Create activity log for new job
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Create", "jobs", $job_id, $this->session->userdata("user_id"));			
                    
                    if($this->session->userdata('proposal_id')){
                       $this->insertreferral($job_id,$result);
                    }
                    if(!$pid){
                        $pid = $job_id;
                        $job_pm_id = $this->savePMjobs($job, $job_id, false);
                        if($job_pm_id)
                        $jobpid['pm_job_id']=$job_pm_id;
                        $jobpid['job_pid'] = $pid;
                        $this->db->where("id",$job_id);
                        $this->db->update("jobs",$jobpid);
			//Create activity log for update job
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Update", "jobs", $pid, $this->session->userdata("user_id"));
			
                     
                    }
                } else{
                     $this->db->where("id",$job_id);
                     $this->db->update("jobs",$job);
			//Create activity log for update job
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Update", "jobs", $job_id, $this->session->userdata("user_id"));
			
                   
                     $job_pm_id = $this->savePMjobs($job, $job_id, false);
                     if($job_pm_id)
                     $jobpid['pm_job_id']=$job_pm_id;

                     $jobpid['job_pid'] = $pid;
                     $this->db->where("id",$job_id);
                     $this->db->update("jobs",$jobpid);
			//Create activity log for update job
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Update", "jobs", $pid, $this->session->userdata("user_id"));
                   
                     $job_update =false;
                }

                $year = date("Y" ,strtotime($value['date_booked']));
                $month = date("m" ,strtotime($value['date_booked']));
             }
             if($this->session->userdata('job_type')==1){
                $session_installer_data[date("j", strtotime($value['date_booked']))][] = $value;

                $job['modified_by'] =  $this->session->userdata("user_id");
                $job['job_date'] =$value['date_booked']." ".date("h:i:s");
                $job['created'] = date("Y-m-d H:i:s");
                $dateinstall[] =date("l,F j, Y",strtotime($value['date_booked'])) ;
                $job['no_installer_allocated'] = $value['number_of_installer'];
                $job['roof_type_id'] =  $this->session->userdata('in_rooftype');
                $job['piperun_length'] =  $this->session->userdata('piperundist');
                $job['panel_count'] =  $this->session->userdata('nop');
                if( $this->session->userdata('proposal_id')){
                   $job['proposal_id']=$this->session->userdata('proposal_id');
                   $sql_prop = "SELECT * FROM  swhproposal WHERE id=".$this->session->userdata('proposal_id');
                   $result =$this->db->query($sql_prop)->row_array();
                   $customer_update = array();
                   $customer_update['city'] = $result['city'];
                   $customer_update['state'] =$result['state'];
                   $customer_update['address'] =$result['address'];
                   $customer_update['home_phone'] ="home";
                   $customer_update['home_phone1'] ="cell";
                   $customer_update['secondary_phone'] = $result['phone'];
                   $customer_update['secondary_phone1'] =$result['sphone'];
                   $customer_update['zip_code'] =$result['zip'];
                   $customer_update['email'] = $result['email'];
                   $customer_update['household_members'] =$result['qoute_nohhm'];
                   $customer_update['sun_zone'] =$result['sunshine_zone'];
				   $customer_update['association']=$result["home_owner_assoc_name"];
				   if($result["home_owner_assoc_name"]!=""  &&  $result["home_owner_assoc_name"]!=NULL )
				    $homeown_association=$result["home_owner_assoc_name"];
                   $this->db->where("id",$customer_id);
                   $this->db->update("customers",$customer_update);
                    
		//Create activity log for updated customer
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "customers", '', $this->session->userdata("user_id"), $customer_id);		
                   
                    
                   $job['list_price'] =$result['price'];
                   $payment_type_method=1;
                   switch($result['mop']){
                    case 'amex' :
                        $job['payment_type_id']=1;
                        break;
                     case 'visa':
                         $job['payment_type_id']=5;
                         break;
                     case 'mc':
                         $job['payment_type_id']=6;
                         break;
                     case 'cash/Check':
                         $job['payment_type_id']=2;
                         break;
                    case 'financing':
                         $job['payment_type_id']=4;
                         break;
                     case 'other':
                        // $job['payment_type_id']=$result['mop'];
                   }
				   
				   
                   $sum_tax = 0;
                   $nos =1;
                   $new_price = $result['price']/$nos;
                   for($k=0;$k<$nos;$k++){
                    $state_exicse_tax = .35*$new_price;
                    if($state_exicse_tax >5000){
                     $state_exicse_tax = 5000;
                    }
                    $federal_tax_credit=.3*$new_price;
                    $sum_tax += $federal_tax_credit+$state_exicse_tax;
                    if($k==0){
                      $job['state_tax_credit'] = number_format($state_exicse_tax,2);
                      $job['federal_tax_credit'] = number_format($federal_tax_credit,2);
                    } else {
                     $job['state_tax_credit_'.$k] = number_format($state_exicse_tax,2);
                     $job['federal_tax_credit_'.$k] = number_format($federal_tax_credit,2);
                    }


                   }

                   $job['state_excise_tax']=number_format($result['price']*0.04712,2);
                   $job['total_tax_credits'] = number_format($sum_tax,2);
                   $job['net_total_price'] = number_format(($result['price']-$sum_tax),2);
                   $job['sub_total_price'] = number_format(($result['price'] + $result['price']*0.04712),2);
                   $job['panel_count'] = $result['nop'];
                   $job['tank_brand_id'] = $result['tank_brand_id'];
                   $job['panel_type_id'] = $result['qoute_paneltype'];

                   switch($result["sop"]){
                    case 106:
                        $job['panel_size_id'] =6;
                        break;
                    case 107:
                        $job['panel_size_id'] =7;
                        break;
                   case 108:
                        $job['panel_size_id'] =8;
                       break;
                 }
                 switch($result["sot"]){
                   case 80:
                        $job['tank_size_id']=6;
                        break;
                    case 120:
                        $job['tank_size_id']=7;
                        break;
                   case 160:
                        $job['tank_size_id']=12;
                       break;
                   case 200:
                        $job['tank_size_id']=13;
                        break;
                   case 240:
                        $job['tank_size_id']=11;
                        break;

                 }
               switch($result["roof_type"]){
                case 8:
                  $job['roof_type_id'] =8;
                  break;
              case 9:
                  $job['roof_type_id'] =8;
                  break;
              case 10:
                  $job['roof_type_id'] =12;
                  break;
             case 11:
                  $job['roof_type_id'] =10;
                  break;
              case 71:
                  $job['roof_type_id'] =5;
                  break;
              case 39:
                  $job['roof_type_id'] =2;
                  break;
               case 40:
                  $job['roof_type_id'] =10;
                  break;
             case 41:
                  $job['roof_type_id'] =6;
                  break;
              case 42:
                  $job['roof_type_id'] =9;
                  break;
              case 43:
                  $job['roof_type_id'] =6;
                  break;
              case 72:
                  $job['roof_type_id'] =11;
                  break;
            }
          if ($result["is_tilt_kit"]==1){
              $result["tilt_kit_needed"]='y';

          }else if ($result["is_tilt_kit"]==2) {
              $result["tilt_kit_needed"]='n';
          }
            $job['qoute_upcharge']=$result['qoute_upcharge'];
            $job['qoute_addwork']=$result['qoute_addwork'];
            $job['addedcharge']=$result['addedcharge'];
            $job['discount']=$result['discountadd'];
            $job['referral_job']=$result['referral_job'];
            if($result['is_tilt_kit']==1)
             $job['tilt_kit_needed']='y';
            else
              $job['tilt_kit_needed']='n';
            $proposal_pid =$this->db->query("SELECT proposal_pid FROM swhproposal WHERE id=".$this->session->userdata('proposal_id'))->row_array();
            $porposal_delete= $this->db->query("UPDATE  swhproposal SET is_delete=0 WHERE proposal_pid=".$proposal_pid["proposal_pid"]." AND  id!=".$this->session->userdata('proposal_id'));
            $this->db->query("UPDATE swhproposal set is_schedule=1,proposal_pid=id WHERE id=".$this->session->userdata('proposal_id'));
               }
                $job['job_pid'] = $pid;
                if(!$job_update){
                $this->db->insert("jobs",$job);
                $job_id = $this->db->insert_id();
		
		//Create activity log for new job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Create", "jobs", $job_id, $this->session->userdata("user_id"));		

                
                if(!$pid){
					$job_pm_id = $this->saveSWHPMjobs($job, $job_id, false);
					if($job_pm_id)
                       $jobpid['pm_job_id']=$job_pm_id;
                    $pid = $job_id;
                    $jobpid['job_pid'] = $pid;
                    $this->db->where("id",$job_id);
                    $this->db->update("jobs",$jobpid);
			//Create activity log for update job
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Update", "jobs", $pid, $this->session->userdata("user_id"));			
			
			$row = array();
			$row['activity_type']= "Update";
			$row['table_name'] =  "jobs";
			$row['user_id'] = $this->session->userdata("user_id");
			$row['created'] = date("Y-m-d H:i:s");
			$row['job_id'] =  $pid;
			$this->db->insert("activity_log",$row);                      
                }

                } else {
                    $this->db->where("id",$job_id);
                    $this->db->update("jobs",$job);
			//Create activity log for update job
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Update", "jobs", $job_id, $this->session->userdata("user_id"));	
                  
                    $job_update =false;
                }
                $year = date("Y" ,strtotime($value['date_booked']));
                $month = date("m" ,strtotime($value['date_booked']));
             }
             if($this->session->userdata('job_type')==5 || $this->session->userdata('job_type')==8){
                $session_installer_data[date("j", strtotime($value['date_booked']))][] = $value;
                $job['current_status'] = "to be completed";
                $job['modified_by'] =  $this->session->userdata("user_id");
				$job['repair_type'] =  $this->session->userdata("repair_type");
                $job['job_date'] =$value['date_booked']." ".date("h:i:s");
				$job['system_type_other'] = $this->session->userdata("system_type_other");
				$job['system_type'] = $this->session->userdata("service_call_type");
                $job['created'] = date("Y-m-d H:i:s");
                $dateinstall[] =date("l,F j, Y",strtotime($value['date_booked'])) ;
                $job['no_installer_allocated'] = $value['number_of_installer'];
                if(!$job_update){
                if($this->session->userdata('job_type')==5){
                   $this->db->insert("jobs",$job);
                   $job_id = $this->db->insert_id();
				    $this->load->helper('osticket');
				   $data['name'] = 'Phoenix';
				   $data['email'] = 'support@alternateenergyhawaii.com';
				   $phfirst_name =  $this->session->userdata('re_first_name');
                   $phlast_name = $this->session->userdata('re_last_name');
				   $data['subject'] = "SC $phlast_name-$phfirst_name-#$job_id-".$job['repair_type'];
				   $data['message'] = "<p>A New SC job created with id $job_id. View Details <a href='".base_url()."admin/job/".$job_id."'> click here </a></p>";
                   $data["service_date"]=date("Y-m-d",strtotime($value['date_booked']));
				   $ticket = create_ticket($data);
				   update_ticket($ticket,$data["service_date"]);
				   $sql = "INSERT INTO osticket SET os_ticket = '".trim($ticket)."',job_id = '".$job_id."'";
				   $this->db->query($sql);
                }
                if($this->session->userdata('job_type')==8){
                  $customer_id=$this->session->userdata('customer_id');
                  //die;
                  $job_row = $this->db->query("SELECT `job_pid`, `in_nod`, `rel_job_id`, `pl_job_id`, `pm_job_id`, `customer_id`, `user_id`, `current_status`, `job_date`, `module_brand_id`, `no_installer_allocated`, `other_module_brand`, `module_count`, `system_size`, `module_power_id`, `other_module_power`, `inverter_type_id`, `other_inverter_type`, `inverter_brand_id`, `other_inverter_brand`, `inverter_count`, `inverter_accessible`, `subpanel_needed`, `service_panel_amperage_id`, `other_amperage`, `wire_run_type_id`, `other_wire_run_type`, `wire_run_distance`, `other_wire_run_distance`, `inverter_other_module_number`, `breaker_box_location`, `meter_to_module_distance`, `meter_location`, `module_configuration`, `electric_wire_source`, `electric_wire_source_other`, `stories`, `module_install_location_access`, `is_ladder`, `other_roof_type`, `rafter_type_id`, `other_rafter_type`, `rafter_distance`, `roof_type_id`, `roof_orientation`, `roof_color`, `roof_pitch`, `tilt_kit_needed`, `installation_type_id`, `other_installation_type`, `contractor_id`, `tank_brand_id`, `other_tank_brand`, `tank_size_id`, `other_tank_size`, `heater_location`, `remove_old_tank`, `relocate_old_tank`, `new_tank_location`, `tank_distance`, `solar_tank_accessible`, `panel_type_id`, `other_panel_type`, `panel_size_id`, `other_panel_size`, `panel_count`, `piperun_length`, `piperun_type_id`, `other_piperun_type`, `gutter_installation`, `solar_fan_brand_id`, `solar_fan_brand_other`, `solar_fan_size_id`, `solar_fan_size_other`, `comments`, `created`, `system_special_pricing`, `system_list_price`, `referral`, `program_discount`, `jobs_emt`, `other_jobs_emt`, `referral_amount`, `state_excise_tax`, `sales_commission`, `state_tax_credit`, `fan_install_location_access`, `federal_tax_credit`, `total_tax_credits`, `payment_type_id`, `financing_comments`, `list_price`, `panel_install_location_access`, `existing_heater_location`, `fan_install_access_location`, `fan_brand_id`, `fan_size_id`, `other_fan_brand`, `other_fan_size`, `job_count`, `job_nos`, `job_nosa`, `other_job_nosa`, `job_nom`, `other_job_nom`, `mointer_system`, `other_mointer_system`, `job_spu`, `job_dowr`, `other_job_spu`, `modified_by`, `job_isnws`, `installer_id`, `payment_dpp`, `payment_amdpp`, `payment_fpp`, `payment_amfpp`, `saoorf`, `nodrf`, `job_wssn`, `servicepanelupgrade`, `repair_time`, `repair_type`, `servicedesc`, `spmsip_job`, `conduit_id`, `envoy_serial_number`, `typeofjump`, `bis`, `eis`, `hapsta`, `designer_id`, `elec_insp_quote`, `elec_comments`, `pump_type_id`, `other_pump_type`, `is_pp_checked`, `is_mail_sent`, `status_updated`, `permitnotfication`, `heconotfication`, `job_lastscheduledate`, `proposal_id`, `roof_flashing`, `other_roof_flashing`, `institution`, `arrival_time`, `toprelag`, `pldesc`, `pl_comments`, `pl_completed`, `pm_completed`, `net_total_price`, `sub_total_price`, `state_tax_credit_1`, `state_tax_credit_2`, `state_tax_credit_3`, `state_tax_credit_4`, `state_tax_credit_5`, `state_tax_credit_6`, `federal_tax_credit_1`, `federal_tax_credit_2`, `federal_tax_credit_3`, `standoff_size_id`, `other_standoff_size`, `base_commsion`, `qoute_upcharge`, `qoute_addwork`, `discount`, `addedcharge`, `referral_job`, `subpanel_exist`, `paperwork_completed`, `is_customer_mailsent` from jobs where job_type_id=2 AND customer_id=$customer_id")->row_array();
                 
                  $this->db->insert("jobs",$job_row);
                  $el_job_id = $this->db->insert_id();
                  $job_id=$el_job_id;
                  $job["el_job_id"] =$el_job_id;
                  $this->db->where("id",$el_job_id);
                  $this->db->update("jobs",$job);
                  $job_new_row=array();
                  $job_new_row["el_job_id"] =$el_job_id;
                  $this->db->where("job_pid",$job_row["job_pid"]);
				  $pid=$job_row["job_pid"];
                  $this->db->update("jobs",$job_new_row);

              }
				//Create activity log for new job
				$this->load->library("activitylog");
				//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
				$this->activitylog->createlog("Create", "jobs", $job_id, $this->session->userdata("user_id"));			
	               
               if(!$pid){
                    $pid = $job_id;
                    $jobpid['job_pid'] = $pid;
                    $this->db->where("id",$job_id);
                    $this->db->update("jobs",$jobpid);
			//Create activity log for update job
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Update", "jobs", $job_id, $this->session->userdata("user_id"));				
                    
                }
                } else{
                    $this->db->where("id",$job_id);
                    $this->db->update("jobs",$job);
			//Create activity log for update job
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Update", "jobs", $job_id, $this->session->userdata("user_id"));	
                   
                    $job_update =false;
                }
                $year = date("Y" ,strtotime($value['date_booked']));
                $month = date("m" ,strtotime($value['date_booked']));
             }

        }
          $prelag_date=null;
          if( $this->session->userdata('job_type')==1 || $this->session->userdata('job_type')==2){
              if($this->session->userdata('assigned_pl_installer')==1) {
                $date_pl = $this->savePLjobs($job, $pid, false,$customer_id);
                $prelag_date=date("l,F j, Y",strtotime($date_pl->job_date));
              }
          }
          $json['success'] = true;
          $json['year'] = $year;
          $json['month'] = $month;
          $j= $this->getUserLoad($this->session->userdata('re_user_id'));
          $ismailsent = $this->globalnotifcation();
          if($ismailsent){
            $this->load->library('email');
            $config['mailtype'] = 'html';
            $this->email->initialize($config);

            $this->email->from('sales@aeihawaii.com', 'Schedular');
            $row_users =  array();
            $row_users = $this->db->query("SELECT users.email FROM users LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type in ('admin','engineer','warehouse' )")->result_array();
            $cnt = count($row_users);
            $row_users[$cnt ]['email']= $j[0]->email;
            foreach ($row_users as $valueuser){
                $this->email->to($valueuser['email']);
                $jobtimelimit = $this->gettimeLimit($value['id']);
                $timediff =  $jobtimelimit;
                // foreach($date_mail as $key => $value){
                if($da[0]->job_lastscheduledate!=null){
                if ($this->session->userdata('job_type')==5 || $this->session->userdata('job_type')==8 ){
					  $jobsp_desc="";
					  $jobsp_desc1="";	
					  if($this->session->userdata('job_type')==5){
						$job_desc="AEI Service Call";
						$job_desc1="service call";
					  } else {
						$job_desc="AEI Electrical Pre-install Job";
						$job_desc1="electrical pre-install job";
					  }
                      $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=1');
                       $row = $query->row();
                       $sub=$row->strsubject;
                       $msg=$row->strbody;
                       $sub= strtr($sub, array('%firstName%' =>$this->session->userdata('re_first_name'), '%lastName%' =>$this->session->userdata('re_last_name'),'%subjob_desc%'=>$job_desc));
                       $msg=strtr($msg, array(
                  '%scheduledate%' => date("l,F j, Y", strtotime($da[0]->job_lastscheduledate)),
                  '%installationdates%' => implode(",", $dateinstall),
                  '%lastName%' =>$this->session->userdata('re_last_name'),
                  '%firstName%' =>$this->session->userdata('re_first_name'),
				  '%subjob_desc%'=>$job_desc1,
                  '%baseurl%' =>base_url(),
                 ));
					   $this->email->subject($sub);
                       $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
This job has been rescheduled from '.date("l,F j, Y", strtotime($da[0]->job_lastscheduledate)).' to '.implode(",", $dateinstall).'<br/> To view the details of this '.$job_desc1.' , update and edit your technical specifications here:<br/>
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification for '.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name').'</a><br/><br/>



Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
$message=$msg;
                  }else {

					  $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=2');
                $row = $query->row();
                $sub=$row->strsubject;
                $msg=$row->strbody;
               
                $sub= strtr($sub, array('%firstName%' =>$this->session->userdata('re_first_name'), '%lastName%' => $this->session->userdata('re_last_name')));
             
                $msg=strtr($msg, array(
                 '%userFirstName%' => $j[0]->first_name,
                 '%userLastName%' => $j[0]->last_name,
                 '%scheduledate%' => date("l,F j, Y", strtotime($da[0]->job_lastscheduledate)),
                 '%installationdates%' =>implode(",", $dateinstall),
                 '%jobid%' => $job_id,
                 '%lastName%' => $this->session->userdata('re_last_name'),
                 '%firstName%' => $this->session->userdata('re_first_name'),
                 '%timediff%' => $timediff,
				  '%baseurl%' =>base_url(),
                 ));
                    
                $this->email->subject('Job Rescheduled for  '.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name'));
                $this->email->subject($sub);

                $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p><b>Congratulations '.$j[0]->first_name." ".$j[0]->last_name.'!</b></p>
 This job has been rescheduled from '.date("l,F j, Y", strtotime($da[0]->job_lastscheduledate)).' to '.implode(",", $dateinstall).'
Now that you have completed your contract with your customer, you will now have to enter the technical specifications on the AEI Team System and get them an installation date.
Update and Edit your Technical Specifications Here:
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification</a><br/><br/>

Edit Customer Information:
 <a href="'.base_url().'admin/customer_job/'.$job_id.'">'.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name').' - Installation Date: '.implode(",", $dateinstall).'</a><br/><br/>
<p>
IMPORTANT NOTICE: YOU HAVE '.$timediff.' HOURS FROM TIME OF INITIAL BOOKING TO ENTER AND SAVE ALL REQUIRED FIELDS FOR THE CUSTOMER\'S:<br/>
1.) <a href="'.base_url().'admin/job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">JOB SPECIFICATIONS</a><br/>
2.) <a href="'.base_url().'admin/customer_job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">CUSTOMER INFORMATION</a><br/>
3.) <a href="'.base_url().'admin/job_financing/'.$job_id.'" style="text-decoration:none; color:#418E1C;">PRICE INFORMATION</a><br/>
</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';  $message=$msg;
                  }}else{
                  if ($this->session->userdata('job_type')==5 || $this->session->userdata('job_type')==8 ){
                            $jobsp_desc="";
					  $jobsp_desc1="";	
					  if($this->session->userdata('job_type')==5){
						$job_desc="AEI Service Call";
						$job_desc1="service call";
					  } else {
						$job_desc="AEI Electrical Pre-install Job";
						$job_desc1="electrical pre-install job";
					  }
                       $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=3');
		 			   $row = $query->row();
					   $sub=$row->strsubject;
                       $msg=$row->strbody;
                       $sub= strtr($sub, array('%firstName%' => $this->session->userdata('re_first_name'), '%lastName%' =>$this->session->userdata('re_last_name'),'%aeisubject%'=>$job_desc));
             
                $msg=strtr($msg, array(
                 '%jobid%' => $job_id,
                 '%firstName%' => $this->session->userdata('re_first_name'),
                 '%lastName%' => $this->session->userdata('re_last_name'),'%desc%'=>$job_desc1,
				   '%baseurl%' =>base_url(),
                ));
                       $this->email->subject($sub);
                       $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
A '.$job_desc1.' has been scheduled for your customer.<br/> To view the details of this '.$job_desc1.', update and edit your technical specifications here:<br/>
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification for '.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name').'</a><br/><br/>



Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
   $message=$msg;
                  }else{

                    $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=4');
				 	$row = $query->row();
                    $sub=$row->strsubject;
                    $msg=$row->strbody;
                   $sub= strtr($sub, array('%firstName%' => $j[0]->first_name, '%lastName%' => $j[0]->last_name));
                  $msg=strtr($msg, array(
                 '%userFirstName%' => $j[0]->first_name,
                 '%userLastName%' => $j[0]->last_name,
                 '%jobid%' => $job_id,
                 '%lastName%' => $this->session->userdata('re_last_name'),
                 '%firstName%' => $this->session->userdata('re_first_name'),
                 '%installationdates%' => implode(",", $dateinstall),
                 '%PrelagDate%' => $prelag_date,
                 '%timediff%' => $timediff,
    			 '%baseurl%' =>base_url(),
			     '%association_name%' =>$homeown_association,
                 ));
					$this->email->subject($sub);


                $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p><b>Congratulations '.$j[0]->first_name." ". $j[0]->last_name.'!</b></p>
Now that you have completed your contract with your customer, you will now have to enter the technical specifications on the AEI Team System and get them an installation date.
Update and Edit your Technical Specifications Here:
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification</a><br/><br/>

Edit Customer Information:
 <a href="'.base_url().'admin/customer_job/'.$job_id.'">'.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name').' </a> <br/>Installation Date: <a href="'.base_url().'admin/customer_job/'.$job_id.'">'.implode(",", $dateinstall).'</a><br/><br/>';
 if($this->session->userdata("assigned_pl_installer")==1){
 $message .= 'Prelag Date: <a href="'.base_url().'admin/customer_job/'.$date_pl->id.'">'.$prelag_date.'</a>';
 }
 $message .='</br/><br/><p>
IMPORTANT NOTICE: YOU HAVE '.$timediff.' HOURS FROM TIME OF INITIAL BOOKING TO ENTER AND SAVE ALL REQUIRED FIELDS FOR THE CUSTOMER\'S:<br/>
1.) <a href="'.base_url().'admin/job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">JOB SPECIFICATIONS</a><br/>
2.) <a href="'.base_url().'admin/customer_job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">CUSTOMER INFORMATION</a><br/>
3.) <a href="'.base_url().'admin/job_financing/'.$job_id.'" style="text-decoration:none; color:#418E1C;">PRICE INFORMATION</a><br/>
</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
$message=$msg;
                  }
                }
          @$this->email->message($message);
          @$this->email->send();
        }
         }
          //}
          $this->db->query("UPDATE jobs set job_lastscheduledate=job_date  where  job_pid= '".$pid."'");

          $this->canceljob();
          echo json_encode($json);

    }
    function cancelsessionjob($id,$year ,$month,$noinstaller , $uid){
       $noi_session = $this->session->userdata('in_noi');
       $nod_session =  $this->session->userdata('in_nod');
       $setagain["in_noi"] = $noi_session + $noinstaller ;
       $setagain["in_nod"] = $nod_session + 1;
       $this->session->set_userdata($setagain);
       $sql = "DELETE FROM  session_installer WHERE id='$id'";
       $this->db->query($sql);
       redirect("admin/installer_available/$year/$month/$uid");
    }
    function day_installeredit($year,$month,$day,$installer,$jobs){
         $selectinstaller = array();
         $data["year"] = $year;
         $data["month"] = $month;
         $data["day"] = $day;
         $data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
         $data["installer"] = $installer;
         $data["jobs"] = $jobs;
         $this->load->view("ajax/installer_edit.php",$data);
        }

    function day_installersave(){
        $row = array();
        $resultcnt = 0;
	$row['day'] =  $this->input->post("re_date");
        $resultcnt = array();
	$resultcnt =  $this->db->query("SELECT * FROM installer_manual where day = '".$row['day']."'")->result_array();
        if(count($resultcnt)>=1) {
          $row['installer'] =  $this->input->post("in_nos") + $this->input->post("jobs");
          $this->db->where('day',$row['day']);
          $this->db->update('installer_manual', $row);
          $json['success'] = true;
          echo json_encode($json);
          return;
        }
        $row['installer'] =  $this->input->post("in_nos") + $this->input->post("jobs");
	$row['uid'] = $this->session->userdata('user_id');
	$row['created_on'] = date("Y-m-d H:i:s");
	$this->db->insert("installer_manual",$row);
        $json['success'] = true;
        echo json_encode($json);
    }

     function unblock_day($date,$message=""){
        // echo "$date";
        // die;

     if (!$date  ){
        return 0;
     }
     else{
         //$date = "$year-$month-$day";
     $sql = "DELETE FROM  admin_block_date  WHERE block_date='$date'";
     $this->db->query($sql);
       echo 1;
     }
    }
     function unblock_day_form($year='',$month='',$day=''){
         $date = "$year-$month-$day";
         $data['year'] = $year;
	 $data['month'] = $month;
	 $data['day'] = $day;
	 $data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
         $data['date'] = $date;

        /**
         *  To do to remove the hard coded
         */

        $this->load->view("ajax/adminunblockday",$data);

    }
    function adduser_ajax($usertype=null){

        if($this->session->userdata("role") != 'admin'){
            redirect("admin/error?e=permissions");
        }
        $data = array();
	if($this->input->post("type")){
            $row = array();
            $row['first_name'] = $this->input->post("first_name");
            $row['last_name'] = $this->input->post("last_name");
            $row['color_id'] = $this->input->post("color_id");
            $row['type'] = $this->input->post("type");
            $row['email'] = $this->input->post("email");
            $row['custom_hex'] = $this->input->post("custom_hex");
            if($this->input->post("password"))
            {
                $row['password'] = md5($this->input->post("password"));
            }
           $t = $this->db->insert("users",$row);
           $json['success'] = true;
           $json['id'] = $this->db->insert_id();
           $json['value'] = ucfirst($row['first_name']) ." ".ucfirst($row['last_name']);
           echo json_encode($json);
	   return;
        }
        $roles =array();
        $roles['admin'] = 'Admin';
	$roles['sales'] = 'Salesperson';
	$roles['installer'] = 'Installer';
        $roles['contractor'] = 'Contractor';
	$data['usertype'] = "";
        if($usertype) {
            if(!array_key_exists($usertype, $roles)){
                redirect("admin/error?e=permissions");
            }
            $roles =array();
            $roles[$usertype] = ucfirst($usertype);
        }
        $data['roles'] = array();
	$data['usertype'] = "";
        $data['roles'] = $roles;
        $data['colors'] = $this->db->get("colors")->result_array();
        $this->load->view("ajax/new_user",$data);

    }

    function save_jobinstaller(){

        $assigninstaller=$this->input->post("ai");
        $job_id = $this->input->post("job_id");
        $ci= $this->input->post("ci");
        $chk = $this->input->post("chk");
        $sql = "UPDATE jobs set installer_id='$assigninstaller', conduit_id = '$ci' WHERE id=$job_id";
        $this->db->query($sql);
        if($this->input->post("job_type_id")!=6) {
          $pid = $this->getparentjobid($job_id);
        }else{
            $pid =$this->getparentjobid($job_id)." AND job_type_id=6";
        }
	if(in_array($this->session->userdata("user_id"),array(5,88,66,27,117))){
            $sql_cond = "select contractor_id,job_date from jobs WHERE job_pid=$pid";
            $result_cond = $this->db->query($sql_cond)->result_array();
            $sqlC = "UPDATE jobs set contractor_id='$chk' WHERE job_pid=$pid";
            $this->db->query($sqlC);
            if(isset($result_cond[0]['contractor_id'])){
                $cont = explode(",",$result_cond[0]['contractor_id']);
                $cont_1 = explode(",",$chk);
                $diff = array_diff($cont,$cont_1);
                foreach($diff as $user_id){
                    if(!isset($user_id)) continue;
                    $this->job_unassignnotification($job_id,$user_id,$result_cond[0]['job_date']);
                }
            }
            if(isset($chk)){
                $cont = explode(",",$chk);
                foreach($cont as $user_id){
                    if(!isset($user_id)) continue;
                    $this->job_assignnotification($job_id,$user_id);
                }
            }

        }


        if(isset($assigninstaller)){
            $cont = explode(",",$assigninstaller);
            foreach($cont as $user_id){
                if(!isset($user_id)) continue;
                $this->job_assignnotification($job_id,$user_id);
            }
        }
        if(isset($ci)){
            $cont = explode(",",$ci);
            foreach($cont as $user_id){
                if(!isset($user_id)) continue;
                $this->job_assignnotification($job_id,$user_id);
            }
        }
        $json['success'] = true;
        echo json_encode($json);
    }

    function day_view_save_jobinstaller(){
       $job_id = $this->input->post("job_id");
       $assigninstaller=$this->input->post("ai_".$job_id);
       $ci= $this->input->post("ci_".$job_id);
        $chk = $this->input->post("chk_".$job_id);
        $sql = "UPDATE jobs set installer_id='$assigninstaller', conduit_id = '$ci' WHERE id=$job_id";
        $this->db->query($sql);
        if($this->input->post("job_type_id")!=6) {
          $pid = $this->getparentjobid($job_id);
        }else{
            $pid ="=".$this->getparentjobid($job_id)." AND job_type_id=6";
        }
	if(in_array($this->session->userdata("user_id"),array(5,88,66,27,117))){
            $sql_cond = "select contractor_id,job_date from jobs WHERE job_pid=$pid";
            $result_cond = $this->db->query($sql_cond)->result_array();
            $sqlC = "UPDATE jobs set contractor_id='$chk' WHERE job_pid=$pid";
            $this->db->query($sqlC);
            if(isset($result_cond[0]['contractor_id'])){
                $cont = explode(",",$result_cond[0]['contractor_id']);
                $cont_1 = explode(",",$chk);
                $diff = array_diff($cont,$cont_1);
                foreach($diff as $user_id){
                    if(!isset($user_id)) continue;
                    $this->job_unassignnotification($job_id,$user_id,$result_cond[0]['job_date']);
                }
            }
            if(isset($chk)){
                $cont = explode(",",$chk);
                foreach($cont as $user_id){
                    if(!isset($user_id)) continue;
                    $this->job_assignnotification($job_id,$user_id);
                }
            }

        }


        if(isset($assigninstaller)){
            $cont = explode(",",$assigninstaller);
            foreach($cont as $user_id){
                if(!isset($user_id)) continue;
                $this->job_assignnotification($job_id,$user_id);
            }
        }
        if(isset($ci)){
            $cont = explode(",",$ci);
            foreach($cont as $user_id){
                if(!isset($user_id)) continue;
                $this->job_assignnotification($job_id,$user_id);
            }
        }
        $json['success'] = true;
        echo json_encode($json);
    }
    function delete_referral($id){
        $sql = "DELETE FROM referrals WHERE id=".$id;
        $this->db->query($sql);
        $json['success'] = true;
        echo json_encode($json);
    }
    function ajaxplanlisting($job_id,$file_type="no"){
        $pid = $this->getparentjobid($job_id);
        $this->db->where("job_id",$pid);
	$this->db->order_by("created","desc");
        $plan_files = $this->db->get("genral_files")->result_array();
        if (count($plan_files) > 0){
        $output =    '<table cellspacing="0" class="files-table">';
        foreach ($plan_files as $key => $value) {

        $output .='<tr>';
	$output .='<td><img src="/assets/images/mime-generic.gif" />&nbsp;&nbsp;';
        $output .='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadplan/'.$value['id'].'">'.$value['original_filename'].'</a></td>';
        $output1 ='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadplan/'.$value['id'].'">Download Plot Plan</a>';
	$output .='<td><a href="'.base_url().'admin/delete_planfile/'.$value['id'].'"><img src="/assets/images/delete-icon.gif" /></a></td>';
	$output .='</tr>';
	}
        $output .='</table>';

       } else{
	$output ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';
        $output1 ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';
	}

        $json['first'] = $output;
        $json['second'] = $output1;
        echo json_encode($json);
    }
     function ajaxpremitfilelisting($job_id,$file_type="no"){
        $pid = $this->getparentjobid($job_id);
        $this->db->where("job_id",$pid);
        $this->db->where("type",$file_type);
	$this->db->order_by("created","desc");
        $json = array();
        $downloadname = "Download";
        $type =$file_type;
        if($type=="building"){
            $downloadname = "Download Building Permit";
        }elseif($type=="netmeter"){
            $downloadname = "Download Net Metering Agreement";
        }elseif($type=="homeowner"){
            $downloadname = "Download Home Owners Association";
        }elseif($type=="lineimage"){
            $downloadname = "Download Line Drawing";
        }
        $plan_files = $this->db->get("permit_files")->result_array();
        if (count($plan_files) > 0){
            $json['success']=true;
        foreach ($plan_files as $key => $value) {
            $json['filedata']='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadpermit/'.$value['id'].'">'.$downloadname.'</a></td>';
            $json['uploaddata']='Uploaded     '.date("y/m/d",strtotime($value['created'])).'&nbsp;&nbsp;<a href="'.base_url().'admin/delete_permitfile/'.$value['id'].'/'.$job_id.'"> <img src="/assets/images/delete-icon.gif" /></a>';
       	}
        echo json_encode($json);

       }

    }
    function ajaxsketchlisting($job_id,$file_type="no"){
        $pid = $this->getparentjobid($job_id);
        $this->db->where("job_id",$pid);
	$this->db->order_by("created","desc");

	$plan_files = $this->db->get("sketch_files")->result_array();
        if (count($plan_files) > 0){
        $output =    '<table cellspacing="0" class="files-table">';
        foreach ($plan_files as $key => $value) {

        $output .='<tr>';
	$output .='<td><img src="/assets/images/mime-generic.gif" />&nbsp;&nbsp;';
        $output .='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadsketch/'.$value['id'].'">'.$value['original_filename'].'</a></td>';
        $output1 ='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadsketch/'.$value['id'].'">Download Salesman Sketch</a>';
	$output .='<td><a href="'.base_url().'admin/delete_sketchfile/'.$value['id'].'"><img src="/assets/images/delete-icon.gif" /></a></td>';
	$output .='</tr>';
	}
        $output .='</table>';

       } else{
	$output ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';
        $output1 ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';
	}
        $json =array();
       $json['first'] = $output;
        $json['second'] = $output1;
        echo json_encode($json);

    }
    function ajaxpredesignsketchlisting($job_id,$file_type="no"){
        $pid = $this->getparentjobid($job_id);
        $this->db->where("job_id",$pid);
	$this->db->order_by("created","desc");

	$plan_files = $this->db->get("sketch_files")->result_array();
        if (count($plan_files) > 0){
        $output =    '<table cellspacing="0" class="files-table">';
        foreach ($plan_files as $key => $value) {

        $output .='<tr>';
	$output .='<td><img src="/assets/images/mime-generic.gif" />&nbsp;&nbsp;';
        $output .='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadsketch/'.$value['id'].'">'.$value['original_filename'].'</a></td>';
        $output1 ='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadsketch/'.$value['id'].'">Download Salesman Sketch</a>';
	$output .='<td><a href="'.base_url().'admin/delete_sketchfile/'.$value['id'].'"><img src="/assets/images/delete-icon.gif" /></a></td>';
	$output .='</tr>';
	}
        $output .='</table>';

       } else{
	$output ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';
        $output1 ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';
	}
        $json =array();
       $json['first'] = $output;
        $json['second'] = $output1;
        echo json_encode($json);

    }
     function ajaxelecphotofilelisting($job_id,$photo_id=1){
        $this->load->helper("thumbnail_helper");
        $pid = $this->getparentjobid($job_id);
        $this->db->where("job_id",$pid);
	$this->db->where("photo_id",$photo_id);
      	$elecphoto_files = $this->db->get("elecphoto_files")->result_array();
        if (count($elecphoto_files) > 0){
        $output =    '<table cellspacing="0" class="files-table">';
        foreach ($elecphoto_files as $key => $value) {
            if($value['photo_id']==$photo_id){
            $output .='<tr>';
            $output .='<td><img src="/assets/images/mime-generic.gif" />&nbsp;&nbsp;';
            $output .='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadelecphoto/'.$value['id'].'">'.$value['original_filename'].'</a></td>';
            $output .='<td><a href="'.base_url().'admin/delete_elecphotofile/'.$value['id'].'"><img src="/assets/images/delete-icon.gif" /></a></td>';
            $output .='</tr>';
            }
                   $output1 ='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadelecphoto/'.$value['id'].'">Download Salesman Sketch</a>';
	}
        $output .='</table>';

       } else{
	$output ='<div style="padding:10px; background:#fff;">No uploaded files.</div>';

	}
        $this->db->where("job_id",$pid);
  $this->db->where("photo_id",1);

  $elec_photo_1 = $this->db->get("elecphoto_files")->result_array();
  $this->db->where("job_id",$pid);
  $this->db->where("photo_id",2);
  $elec_photo_2 = $this->db->get("elecphoto_files")->result_array();
  $this->db->where("job_id",$pid);
  $this->db->where("photo_id",3);
  $elec_photo_3 = $this->db->get("elecphoto_files")->result_array();
  $output1 = "<table><tr>";
    if (count($elec_photo_1) > 0){
        foreach ($elec_photo_1 as $key => $value){
          $src_pth = $value["unique_filename"];
	  $output1 .= '<td><a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadplan/'.$value["id"].'"><img src="'.thumbnail($src_pth, 50, 50).'" /></a> </td>';
          }
     } else {
             $output1 .= '<td>No Image1</td>';
     }
     if (count($elec_photo_2) > 0){
        foreach ($elec_photo_1 as $key => $value){
          $src_pth = $value["unique_filename"];
	  $output1 .= '<td><a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadplan/'.$value["id"].'"><img src="'.thumbnail($src_pth, 50, 50).'" /></a> </td>';
          }
     } else {
             $output1 .= '<td>No Image1</td>';
     }
     if (count($elec_photo_3) > 0){
        foreach ($elec_photo_1 as $key => $value){
          $src_pth = $value["unique_filename"];
	  $output1 .= '<td><a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadplan/'.$value["id"].'"><img src="'.thumbnail($src_pth, 50, 50).'" /></a> </td>';
          }
     } else {
             $output1 .= '<td>No Image1</td>';
     }
$output1 .='</tr></table>';
        $json =array();
       $json['success'] = true;
       $json['first'] = $output;
       $json['second'] = $output1;
       echo json_encode($json);

    }
    function ajaxsalefilelisting($job_id,$file_type="no"){
        $pid = $this->getparentjobid($job_id);
        $this->db->where("job_id",$pid);
	$this->db->order_by("created","desc");

	$plan_files = $this->db->get("presale_files")->result_array();
        if (count($plan_files) > 0){
        $output =    '<table cellspacing="0" class="files-table">';
        foreach ($plan_files as $key => $value) {

        $output .='<tr>';
	$output .='<td><img src="/assets/images/mime-generic.gif" />&nbsp;&nbsp;';
        $output .='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadpresale/'.$value['id'].'">'.$value['original_filename'].'</a></td>';
        $output1 ='<a style="vertical-align:top;text-decoration:underline" href="'.base_url().'admin/downloadpresale/'.$value['id'].'">Download Measured Sketch</a>';
        if ($value['notification'])
            $output1 .= "<br/>(Confirmed)";
        else
            $output1 .= "<br/>(Not Confirmed)";
	$output .='<td><a href="'.base_url().'admin/delete_presalefile/'.$value['id'].'"><img src="/assets/images/delete-icon.gif" /></a></td>';
	$output .= '<td style="border: 0pt none;"><div style="display:inline;margin-left:50px;width:250px;float:right;"> <input type="checkbox" value="" name="presalenotification" onclick="sendnotification();"><span  style="padding:5px;">Confirmed By Customer</span></div></td>';

        $output .='</tr>';
	}
        $output .='</table>';

       } else{
	$output ='<div style="padding:10px; background:#fff;">No PreSale files.</div>';
        $output1 ='<div style="padding:10px; background:#fff;">No PreSale files.</div>';
	}

        $json['first'] = $output;
        $json['second'] = $output1;
        echo json_encode($json);

    }

    function savetimelimit(){
     $row = array();
     $resultcnt = 0;
     $getpid  =  $this->input->post("jobid");

     $resultcnt = array();
     $row['jid'] = $this->getparentjobid($getpid);
     $resultcnt =  $this->db->query("SELECT * FROM timelimit_manual_extend where jid = '".$row['jid']."'")->result_array();
     if(count($resultcnt)>=1) {
        $row['timeext'] =  $this->input->post("timeext");
        $this->db->where('jid',$row['jid']);
        $this->db->update('timelimit_manual_extend', $row);
        $json['success'] = true;
         echo json_encode($json);
          return;
        }
        $row['timeext'] =  $this->input->post("timeext");
	$row['created_on'] = date("Y-m-d H:i:s");
	$this->db->insert("timelimit_manual_extend",$row);
        $json['success'] = true;
        echo json_encode($json);
    }
    function timeextform($jobid){
      $data['jobid'] = $jobid;
      $data["timeext"] = array(""=>"Select hours", "5"=>"5","10"=>"10","20"=>"20","30"=>"30","40"=>"40","50"=>"50","168"=>"168","192"=>"192","216"=>"216");
      $data["timeextsel"] = 0;
      $pid = $this->getparentjobid($jobid);
      $resultcnt =  $this->db->query("SELECT * FROM timelimit_manual_extend where jid = '".$pid."'")->result_array();
      if(count($resultcnt)>=1) {
        $data["timeextsel"] = $resultcnt[0]['timeext'];
      }
      $this->load->view("ajax/timeext_job",$data);
    }

    function  globaltimeextform(){
      $data["timeext"] = array(""=>"Select Number of day", "24"=>"1 Day","48"=>"2 Day","72"=>"3 day","96"=>"4 day","120"=>"5 day","144"=>"6 day","168"=>"7 day");
      $data["timeextsel"] = 0;
      $resultcnt =  $this->db->query("SELECT * FROM globalconfig  where id = 1")->result_array();
      if(count($resultcnt)>=1) {
        $data["timeextsel"] = $resultcnt[0]['globaltimelimit'];
      }
      $this->load->view("ajax/globaltimeext_job",$data);
    }
    function saveglobaltimelimit(){
     $row = array();
     $row['globaltimelimit'] =  $this->input->post("timeext");
     $this->db->where('id',1);
     $this->db->update('globalconfig', $row);
     $json['success'] = true;
     echo json_encode($json);
    }
    function getUserLoad($id){
      if (!$id) return 0;
      $j = $this->db->query("SELECT * FROM users WHERE id=$id")->result();

      return $j;
 }
function getUserName($id){
      if (!$id) return 0;
      $j = $this->db->query("SELECT first_name,last_name FROM users WHERE id=$id")->row_array();

      return $j['first_name'].' '.$j['last_name'];
 }
 
 function  installer_swh($year='',$month='',$job_id=0){
        $data = array();
         $data['job'] =array();
         $data["sct"] ="";
        if($job_id) {
		// get job data
		$sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
            $data['job'] = $this->db->query($sql)->row_array();
            $data["sct"] ="var customer_id = '';var userid =''; var reserverjob;";
          }
        $data['customer_id'] = '';
       	$month = ltrim($month,"0");
	$data['year'] = $year;
	$data['month'] = $month;
	//$data['day'] = $day;
	//$data['reserve_date'] = mktime(0, 0, 0, $data['month'], $data['day'], $data['year']);
	if($this->input->get("customer_id")){
            $data['customer_id'] = $this->input->get("customer_id");
            $data['customer'] = $this->db->query("SELECT * FROM customers WHERE id=".$this->db->escape($data['customer_id']))->row_array();
	}
	/**
         *  To do to remove the hard coded
         */
         $sql = "SELECT id,type FROM panel_numbers ";
        $nop_type = array();
        $nop_type["0"]= "Select Number of Panels";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0){
             foreach ($query->result() as $row){
                $nop_type[$row->id] =  $row->type;
            }
        }
        $data["numberofpanels"]= $nop_type;
        $sql = "SELECT id,type FROM roof_types";
        $roof_typea = array();
        $roof_typea["0"]= "-Select roof type-";
        $query = $this->db->query($sql);
        if ($query->num_rows() > 0){
             foreach ($query->result() as $row){
                $roof_typea[$row->id] =  $row->type;
            }
        }
        $data["roof_type"]= $roof_typea;

        $data["piperundistance"] = array("0"=>"Select Pipe Run Distance");
        $this->db->order_by('id','asc');
        $piperundistance_display = $this->db->get("pipe_run_distance")->result_array();
        foreach($piperundistance_display as $row) {
          $data["piperundistance"][$row['id']] = $row['type'];
        }

        $data["nod"] = array("1"=>"1", "2"=> "2", "3"=>"3");

        $this->load->view("ajax/installer_swh.php",$data);
    }
 function gettimeLimit($jobid){
      $timelimit = 24;
     $resultcnt =  $this->db->query("SELECT * FROM globalconfig  where id = 1")->result_array();
     $timelimit = $resultcnt[0]['globaltimelimit'];
     return $timelimit;
  }

 function getparentjobid($job_id){
   $resultcnt =  $this->db->query("SELECT job_pid FROM jobs  where id = $job_id")->result_array();
   $pid = $resultcnt[0]['job_pid'];
   if(!$pid){
    $pid =$job_id;
   }
   return $pid;
 }
 function sendcommentmail($mailid,$content,$job_id,$name){
   $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($mailid);
   $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=11');
                $row = $query->row();
                $sub=$row->strsubject;
                $msg=$row->strbody;
               
                
                $msg=strtr($msg, array(
                 '%fullname%' =>$name,
                 '%content%' => $content,
                 '%jobid%' => $job_id,
        		   '%baseurl%' =>base_url(),

                 ));
   $this->email->subject($sub);
   $sql_userid="SELECT user_id FROM  jobs WHERE  id=".$job_id;
   $row_userid = $this->db->query($sql_userid)->row_array();
   $isuserpre = $this->issendnotification($row_userid['user_id']);
   if(!$isuserpre){
    $json['success'] = true;
    echo json_encode($json);
    return ;
   }
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inci" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> You have received a comment/reply on your job for '.$name.'<br/>'.$content.'<br/>
<a href="'.base_url().'admin/job_comment/'.$job_id.'">Go to Job Comment</a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
          @$this->email->message($msg);
          @$this->email->send();
 }
 function setdeafultpage(){
     $url =  $this->input->get("q");
     $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;Are you sure to set this as default page?<br/>&nbsp;&nbsp;&nbsp;<button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
     $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() { location.href='".base_url()."ajax/sethomepage?q=/$url'}); });</script>";
     echo $output;
 }
 function sethomepage($url){
     $url =  substr($this->input->get("q"),1);
     $rowu['homepage'] = $url;
     $sql = "Select user_id from home_page WHERE user_id=".$this->session->userdata("user_id");
     $row = $this->db->query($sql)->result_array();
     if($row[0]['user_id']){
        $this->db->where('user_id',$row[0]['user_id']);
         $this->db->update("home_page",$rowu);

     }else{
        $rowu['user_id'] = $this->session->userdata("user_id");
        $this->db->insert("home_page",$rowu);
     }
     $this->session->set_userdata(array('job_url'=>$rowu['homepage']));

     redirect($url);
  }
  function deletefilem($file_id){
     $url =  $this->input->get("q");

     $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;Are you sure to delete this file?<br/>&nbsp;&nbsp;&nbsp;<button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
     $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() { location.href='".base_url()."admin/deleteImage/0/$file_id'}); });</script>";
     echo $output;
 }
 function meterdeletefilem($file_id,$job_id){
     $url =  $this->input->get("q");
     $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;Are you sure to delete this file?<br/>&nbsp;&nbsp;&nbsp;<button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
     $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() { location.href='".base_url()."admin/deletemeterImage/$file_id/$job_id'}); });</script>";
     echo $output;
 }
 function deletecustomer($cust_id){
     $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;All Job related to this user will delete.&nbsp;Are you sure to delete this &nbsp;&nbsp;&nbsp;Customer?<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
     $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() { location.href='".base_url()."admin/delete_customer/$cust_id'}); });</script>";
     echo $output;
 }
 function savenotification($value){
   $row['notification'] = $value;
   //$row['id'] = 1;
   $this->db->where('id',1);
   $this->db->update('notification_setting', $row);
   $json['success'] = true;
   echo json_encode($json);
 }
 function save_designer(){
   $jobid =   $this->input->post("job_id");
   $pid = $this->getparentjobid($this->input->post("job_id"));
   $row['designer_id'] = $this->input->post("did");
   $row['project_designer_id'] = $this->input->post("eid");
    $row['engineer_assigned_date']=date('Y-m-d H:i:s');
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        $json['success'] = true;
        echo json_encode($json);
        return;
    }
	
    $this->load->library('email');
    $config['mailtype'] = 'html';
    $this->email->initialize($config);
	if($row['project_designer_id']>0) {
       
    $isuserpre = $this->issendnotification($row['project_designer_id']);

    if(!$isuserpre){
        $json['success'] = true;
        echo json_encode($json);
        return ;
    }
    $j= $this->getUserLoad($row['project_designer_id']);
   
    $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
    $this->email->to($j[0]->email);
     $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=31');
                $row1 = $query->row();
                $sub=$row1->strsubject;
                $msg=$row1->strbody;
               
                
                $msg=strtr($msg, array(
                 '%jobid%' => $jobid,
				  '%baseurl%' =>base_url(),
				 
                 ));
	$this->email->subject($sub);
	$sql_jobs = "SELECT ps.home_owner_assoc ,jobs.*,cust.first_name,cust.last_name,cust.association
   FROM jobs 
   LEFT JOIN customers cust ON cust.id=jobs.customer_id 
   LEFT JOIN proposal ps ON ps.id=jobs.proposal_id
   WHERE jobs.id=$jobid";

	$row_job=$this->db->query($sql_jobs)->row_array();
	$this->load->helper('jobpv');
    $releated_job=getRelatedJobs($jobid,false);
	$strbody=$msg;
	$hoa_status="no";
	
	if(isset($row_job["association"]) && $row_job["home_owner_assoc"]==2){
       $hoa_status="Yes";
	}

	$cust_name=ucfirst($row_job["first_name"])." ".ucfirst($row_job["last_name"]);
	$booking_date=date("m/d/Y",strtotime($row_job["created"]));
	$installation_date=date("m/d/Y",strtotime($row_job["job_date"]));

	$strbody = str_replace("%baseurl%", base_url(), $strbody);   
	$strbody = str_replace("%jobid%",$jobid,$strbody);
	$strbody = str_replace("%customer_name%",$cust_name,$strbody);
	$strbody = str_replace("%booking_date%",$booking_date,$strbody);
	$strbody = str_replace("%installation_date%","PV".$installation_date.", ".$releated_job,$strbody);
	$strbody = str_replace("%hoa_status%", $hoa_status, $strbody);

	$msg=$strbody;
    
	$message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> A Project/Plot plan has assigned to you. For  Detail , please click below<br/>
<a href="'.base_url().'admin/job/'.$jobid.'">Go to Job </a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
          @$this->email->message($msg);
          @$this->email->send();
   
	 }
	  
  $row['designer_id'] = $this->input->post("did");
     if($row['designer_id']>0) {
      
    $isuserpre = $this->issendnotification($row['designer_id']);
    
    if(!$isuserpre){
        $json['success'] = true;
        echo json_encode($json);
        return ;
    }
    $j= $this->getUserLoad($row['designer_id']);
    
    $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
    $this->email->to($j[0]->email);
     $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=12');
                $row = $query->row();
                $sub=$row->strsubject;
                $msg=$row->strbody;
               
                
                $msg=strtr($msg, array(
                 '%jobid%' => $jobid,
				  '%baseurl%' =>base_url(),
				 
                 ));
	$this->email->subject($sub);
    $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> A Project/Plot plan has assigned to you. For  Detail , please click below<br/>
<a href="'.base_url().'admin/job/'.$jobid.'">Go to Job </a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
          @$this->email->message($msg);
          @$this->email->send();
   
	 }
	 $json['success'] = true;
   echo json_encode($json);
 }
 function send_bisnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['bis'] =NULL;
   $dt = trim($this->input->post("dt"));
   if(isset($dt)&& $dt!='null'){
   $row['bis'] = implode("-",explode("/",$this->input->post("dt")));
   }

   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->sendusermail($job_id,'building');
   $json['success'] = true;
   echo json_encode($json);
 }
 function send_paperworknotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['paperwork_completed'] =NULL;
   $dt = trim($this->input->post("dt"));
   if(isset($dt)&& $dt!='null'){
   $row['paperwork_completed'] = implode("-",explode("/",$this->input->post("dt")));
   }

   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->sendusermail($job_id,'paperwork');
   $json['success'] = true;
   echo json_encode($json);
 }
 function send_eisnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['eis'] = NULL;
   $dt = $this->input->post("dt");
   if(isset($dt)&& $dt!='null'){
    $row['eis'] = implode("-",explode("/",$this->input->post("dt")));
   }
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->sendusermail($job_id,'electrical');
   $json['success'] = true;
   echo json_encode($json);
 }
 function send_hapshnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['hapsta'] = NULL;
   $dt = $this->input->post("dt");
   if(isset($dt)&& $dt!='null' ){
    $row['hapsta'] = implode("-",explode("/",$this->input->post("dt")));
   }
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->sendusermail($job_id,'Homeowner Association');
   $json['success'] = true;
   echo json_encode($json);
 }

 function send_haalcnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['haalc'] = NULL;
   $dt = $this->input->post("dt");
   if(isset($dt)&& $dt!='null' ){
    $row['haalc'] = implode("-",explode("/",$this->input->post("dt")));
   }
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->sendusermail($job_id,'Homeowner Association Approval Last Checked ');
   $json['success'] = true;
   echo json_encode($json);
 }
 
 function send_haarnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['haar'] = NULL;
   $dt = $this->input->post("dt");
   if(isset($dt)&& $dt!='null' ){
    $row['haar'] = implode("-",explode("/",$this->input->post("dt")));
   }
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->sendusermail($job_id,'Homeowner Association Approval Received');
   $json['success'] = true;
   echo json_encode($json);
 }

 function savenotificationuser($value,$user_id){
   $row['notification'] = $value;
   $sql = "SELECT user_id FROM  notification_setting WHERE user_id = $user_id";
   $rowe = array();
   $rowe = $this->db->query($sql)->result_array();
   if(count($rowe)>=1 && $rowe[0]['user_id']){
        $this->db->where('user_id',$rowe[0]['user_id']);
        $this->db->update('notification_setting', $row);

     }else{
        $row['user_id'] = $user_id;
        $this->db->insert('notification_setting', $row);
     }

   $json['success'] = true;
   echo json_encode($json);
 }
 function saveeliteuser($value,$user_id){
   $row['elite_agent'] = $value;
   $this->db->where('id',$user_id);
   $this->db->update('users', $row);
   $json['success'] = true;
   echo json_encode($json);
 }
 function savesalessupportuser($value,$user_id,$comm_val){
   $row['sale_support'] = $value;
   $row['sale_support_value'] = $comm_val;
   $this->db->where('id',$user_id);
   $this->db->update('users', $row);
   $json['success'] = true;
   echo json_encode($json);
 }
function saveproposal_access($value,$user_id){
   $row['proposal_access'] = $value;
   $this->db->where('id',$user_id);
   $this->db->update('users', $row);
   $json['success'] = true;
   echo json_encode($json);
 }
 
 function savelead_access($value,$user_id){
   $row['lead_access'] = $value;
   $this->db->where('id',$user_id);
   $this->db->update('users', $row);
   $json['success'] = true;
   echo json_encode($json);
 }
 
  function ppsavechk($value,$jid){
   $row['is_pp_checked'] = $value;
   $this->db->where('job_pid',$jid);
   $this->db->update('jobs', $row);
   $json['success'] = true;
   echo json_encode($json);
 }
 function pfsavechk($pid,$value,$jid,$val=0,$val1=0){
   $row[$jid] = $value;
   if($jid=="cpd_payment1"){
	$row["cpd_payment1_value"]=$val;
   }
   if($jid=="cpd_payment2"){
	$row["cpd_payment2_value"]=$val1;
   }
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $json['success'] = true;
   echo json_encode($json);
   if($jid=="finanicng_approved" && $value>0){
		$ismailsent = $this->globalnotifcation();
   if(!$ismailsent){
        return;
    } 
	 if($pid) {

        	// get job data
            $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($pid)."
		";
            $data = $this->db->query($sql)->row_array();
    $finance_name="";
	if($data["job_type_id"]==2 || $data["job_type_id"]==6 || $data["job_type_id"]==7  ){
		$proposal= $this->db->query("Select name_financier,select_financier from proposal where  id=".$data["proposal_id"])->row_array();
	} else if ($data["job_type_id"]==1){
		$proposal= $this->db->query("Select name_financier,select_financier from swhproposal where  id=".$data["proposal_id"])->row_array();
	} else if($data["job_type_id"]==15 || $data["job_type_id"]==16 ){
		$proposal= $this->db->query("Select name_financier,select_financier from acproposal where  id=".$data["proposal_id"])->row_array();
	}
	
    if($proposal["select_financier"]=="other") 
		$finance_name=$proposal["name_financier"]; 
	else 
	   $finance_name=$proposal["select_financier"]=="0" || $proposal["select_financier"]==" " ?"None":$proposal["select_financier"];

    $this->load->library('email');
    $config['mailtype'] = 'html';
    $this->email->initialize($config);
    $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
    $row_users = $this->db->query("SELECT users.email from users LEFT JOIN notification_setting ns ON users.id=ns.`user_id` WHERE   users.type in ('admin','engineer','warehouse' ) and ns.notification=1")->result_array();
    $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=30');
                $row_email = $query->row();
                $sub=$row_email->strsubject;
                $msg=$row_email->strbody;
               
                $sub= strtr($sub, array('%firstName%' => $data['first_name'], '%lastName%' => $data['last_name']));
             
                 $msg=strtr($msg, array(
                 '%firstName%' => $data['first_name'],
                 '%lastName%' => $data['last_name'],
                 '%baseurl%' =>base_url(),
                 '%finance_name%' => $finance_name,
                 ));
	$j=$this->getUserLoad($data["user_id"]);
	$this->email->to($j[0]->email);
    $this->email->subject($sub);
	@$this->email->message($msg);
    @$this->email->send();
	foreach ($row_users as $value){
      $this->email->to($value['email']);
      $this->email->subject($sub);
	   @$this->email->message($msg);
      @$this->email->send();
  }
 }
}
}
function payment_recieved(){
    $data['payment_type_id']=$this->input->post("payment_type");
    $data['job_pid']=$this->input->post("job_pid");
    $data['datetime']=time();
    $data['ip']=$this->input->ip_address();
    $data['user_id']=$this->input->post('user_id');
   
    if($this->input->post("payment")=="payment_recieved")
        {   $data['payment_recieved_type']='DPA';
            $data['payment_recieved']=$this->input->post("val");
        if($this->db->insert('payment_recieved_log',$data)){
            $this->db->select('payment_recieved,user_id,datetime');
            $this->db->order_by('datetime','desc');
            $this->db->limit(1);
            $query= $this->db->get('payment_recieved_log')->row_array();
            $json['payment']='payment_recieved';
            $json['payment_recieved']=$query['payment_recieved'];
            $json['user_name']=$this->getUserName($query['user_id']);
            $json['datetime']=date('M jS,Y H:ia',$query['datetime']);
            $json['success']=true;
            }
            else
            $json['success']=false;
        }
        if($this->input->post("payment")=="final_payment_recieved")
            { $data['payment_recieved_type']='FAC';
            $data['final_payment_recieved']=$this->input->post("val");
             if($this->db->insert('payment_recieved_log',$data)){
            $this->db->select('final_payment_recieved,user_id,datetime');
            $this->db->order_by('datetime','desc');
            $this->db->limit(1);
            $query= $this->db->get('payment_recieved_log')->row_array();
            $json['payment']='final_payment_recieved';
            $json['final_payment_recieved']=$query['final_payment_recieved'];
            $json['user_name']=$this->getUserName($query['user_id']);
            $json['datetime']=date('M jS,Y H:ia',$query['datetime']);
            $json['success']=true;
            }
            else
            $json['success']=false;
            }

            print json_encode($json);
       }
       
       function recieved_paymentfinal_list($id,$payment_type_id){
          $this->db->select('final_payment_recieved,user_id,datetime,payment_recieved_type');
          $this->db->where('job_pid',$id);
          $this->db->where('payment_type_id',$payment_type_id);
         
          $this->db->where('payment_recieved_type','FAC');
            $this->db->order_by('datetime','desc');
           // $this->db->limit(1);
            $query['final_payment_recieved']= $this->db->get('payment_recieved_log')->result();
           // $json['user_name']=$this->getUserName($query['user_id']);
           //print_R($query);
           $this->load->view('ajax/recieved_paymentfinal_list',$query);
       }
       function recieved_payment_list($id,$payment_type_id){
         $this->db->select('payment_recieved,user_id,datetime,payment_recieved_type');
          $this->db->where('job_pid',$id);
           $this->db->where('payment_type_id',$payment_type_id);
          $this->db->where('payment_recieved_type','DPA');
            $this->db->order_by('datetime','desc');
           // $this->db->limit(1);
            $query['payment_recieved']= $this->db->get('payment_recieved_log')->result();
           // $json['user_name']=$this->getUserName($query['user_id']);
           $this->load->view('ajax/recieved_payment_list',$query);
           // print_R($query);
       }
  function sendpreassementmail($job_id){
    $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
    if($job_id) {
        	// get job data
            $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
            $data = $this->db->query($sql)->row_array();


    $this->load->library('email');
    $config['mailtype'] = 'html';
    $this->email->initialize($config);
    $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
    $row_users = $this->db->query("SELECT users.email from users LEFT JOIN notification_setting ns ON users.id=ns.`user_id` WHERE   users.type in ('admin','engineer','warehouse' ) and ns.notification=1")->result_array();
    $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=6');
                $row_email = $query->row();
                $sub=$row_email->strsubject;
                $msg=$row_email->strbody;
               
                $sub= strtr($sub, array('%firstName%' => $data['first_name'], '%lastName%' => $data['last_name']));
             
                 $msg=strtr($msg, array(
                 '%firstName%' => $data['first_name'],
                 '%lastName%' => $data['last_name'],
                 '%jobid%' => $job_id,
			     '%baseurl%' =>base_url(),
                 '%timediff%' => $timediff,
                 ));
	foreach ($row_users as $value){
      $this->email->to($value['email']);
      $jobtimelimit = $this->gettimeLimit($job_id);
      $timediff =  $jobtimelimit;
       
	  $this->email->subject($sub);
      $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">

Now that you have completed your contract with your customer, you will now have to enter the technical specifications on the AEI Team System and get them an installation date.
Update and Edit your Technical Specifications Here:
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification</a><br/><br/>

Edit Customer Information:
 <a href="'.base_url().'admin/customer_job/'.$job_id.'">'.$data['first_name'].', '.$data['last_name'].'</a><br/><br/>
<p>
IMPORTANT NOTICE: YOU HAVE '.$timediff.' HOURS FROM TIME OF INITIAL BOOKING TO ENTER AND SAVE ALL REQUIRED FIELDS FOR THE CUSTOMER\'S:<br/>
1.) <a href="'.base_url().'admin/job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">JOB SPECIFICATIONS</a><br/>
2.) <a href="'.base_url().'admin/customer_job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">CUSTOMER INFORMATION</a><br/>
3.) <a href="'.base_url().'admin/job_financing/'.$job_id.'" style="text-decoration:none; color:#418E1C;">PRICE INFORMATION</a><br/>
</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
      @$this->email->message($msg);
      @$this->email->send();
  }
  $pid = $this->getparentjobid($job_id);

   $row['notification'] = 1;
   $this->db->where('job_id',$pid);
   $this->db->update('genral_files', $row);
  $json['success'] = true;
 echo json_encode($json);
 }  else {
  $json['success'] = false;
   echo json_encode($json);
}
}
function sendpermitcustomermail($job_id){
    $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
    if($job_id) {
        	// get job data
            $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM
			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id
		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$this->db->escape($job_id)."
		";
            $data = $this->db->query($sql)->row_array();


    $this->load->library('email');
    $config['mailtype'] = 'html';
    $this->email->initialize($config);
    $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
    $row_users = $this->db->query("SELECT users.email from users LEFT JOIN notification_setting ns ON users.id=ns.`user_id` WHERE   users.type in ('admin','engineer','warehouse' ) and ns.notification=1")->result_array();
    foreach ($row_users as $value){
      $this->email->to($value['email']);
      $jobtimelimit = $this->gettimeLimit($job_id);
      $timediff =  $jobtimelimit;
        $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=5');
                $row = $query->row();
                $sub=$row->strsubject;
                $msg=$row->strbody;
               
                $sub= strtr($sub, array('%firstName%' => $data['first_name'], '%lastName%' => $data['last_name']));
             
                $msg=strtr($msg, array(
                 '%userFirstName%' => $data['first_name'],
                 '%userLastName%' => $data['last_name'],
                 '%jobid%' => $job_id,
                 '%timediff%' => $timediff,
				   '%baseurl%' =>base_url(),
                 ));
	  
	  $this->email->subject($sub);
      
	  $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">

Now that you have completed your contract with your customer, you will now have to enter the technical specifications on the AEI Team System and get them an installation date.
Update and Edit your Technical Specifications Here:
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification</a><br/><br/>

Edit Customer Information:
 <a href="'.base_url().'admin/customer_job/'.$job_id.'">'.$data['first_name'].', '.$data['last_name'].'</a><br/><br/>
<p>
IMPORTANT NOTICE: YOU HAVE '.$timediff.' HOURS FROM TIME OF INITIAL BOOKING TO ENTER AND SAVE ALL REQUIRED FIELDS FOR THE CUSTOMER\'S:<br/>
1.) <a href="'.base_url().'admin/job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">JOB SPECIFICATIONS</a><br/>
2.) <a href="'.base_url().'admin/customer_job/'.$job_id.'" style="text-decoration:none; color:#418E1C;">CUSTOMER INFORMATION</a><br/>
3.) <a href="'.base_url().'admin/job_financing/'.$job_id.'" style="text-decoration:none; color:#418E1C;">PRICE INFORMATION</a><br/>
</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
      @$this->email->message($msg);
      @$this->email->send();
  }
  $pid = $this->getparentjobid($job_id);

   $row['notification'] = 1;
   $this->db->where('job_id',$pid);
   $this->db->update('genral_files', $row);
  $json['success'] = true;
 echo json_encode($json);
 }  else {
  $json['success'] = false;
   echo json_encode($json);
}
}
function sendusermail($job_id,$content){
    $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
     $sql = "SELECT   users.email,customers.first_name,customers.last_name,jobs.contractor_id,jobs.installer_id,jobs.conduit_id FROM		jobs
			LEFT JOIN users ON jobs.user_id=users.id
                        LEFT JOIN customers ON jobs.customer_id=customers.id
                        LEFT JOIN  notification_setting ns ON ns.user_id = users.id
			WHERE ns.notification!=0 AND jobs.id=".$job_id;
     
     $data = array();
     $data = $this->db->query($sql)->result_array();
     if(count($data)>=1){
        $name = ucfirst($data[0]['last_name'])." ".ucfirst($data[0]['first_name']);
		if($content=="paperwork" || $content=="paperwork1" || $content=="paperwork2" || $content=="paperwork3"){
		  @$this->sendpaperworkmail($data[0]['email'],$content,$job_id,$name);
		}
		else{
           @$this->sendpermitmail($data[0]['email'],$content,$job_id,$name);
        }
		$in_user = '';
        if($data[0]['contractor_id']){
            $in_user .= $data[0]['contractor_id'].",";
        }
        if($data[0]['installer_id']){
            $in_user .= $data[0]['installer_id'].",";
        }
        $in_user = substr($in_user,0,-1);
        $assoc_users =  array();
        if ($in_user!=''){
            $assoc_users = $this->db->query("SELECT users.email from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type in ('admin','engineer','warehouse' )  AND users.id in ($in_user)")->result_array();
            // print_R($assoc_users);
            foreach ($assoc_users as $value){
               if($content=="paperwork"){
		        @$this->sendpaperworkmail($value['email'],$content,$job_id,$name);
		       }
		     else{
               @$this->sendpermitmail($value['email'],$content,$job_id,$name);
             }
            }
        }
     }
    $row_users =  array();
    $row_users = $this->db->query("SELECT users.email from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type in ('admin','engineer','warehouse' )")->result_array();
   
    foreach ($row_users as $value){
         if($content=="paperwork"){
		  @$this->sendpaperworkmail($value['email'],$content,$job_id,$name);
		}
		else{
           @$this->sendpermitmail($value['email'],$content,$job_id,$name);
        }
     }
}
function sendpermitmail($mailid,$content,$job_id,$name){
   $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
   $sql_userid="SELECT user_id FROM  jobs WHERE  id=".$job_id;
   $row_userid = $this->db->query($sql_userid)->row_array();
   $isuserpre = $this->issendnotification($row_userid['user_id']);
   if(!$isuserpre){
    $json['success'] = true;
    echo json_encode($json);
    return ;
   }
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($mailid);
   $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=7');
                $row = $query->row();
                $sub=$row->strsubject;
                $msg=$row->strbody;
               
                $sub= strtr($sub, array('%fullname%' => $name));
             
                 $msg=strtr($msg, array(
                 '%content%' => @ucfirst($content),
                 '%fullname%' => $name,
                 '%jobid%' => $job_id,
                 '%baseurl%' =>base_url(),
                 ));
   $this->email->subject($sub);
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> '.@ucfirst($content).' Permit for '.$name.' has been uploaded for review<br/>
<a href="'.base_url().'admin/permit_job/'.$job_id.'">Download Permit</a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
     @$this->email->message($msg);
     @$this->email->send();
 }
/*function sendpaperworkmail($mailid,$content,$job_id,$name){
   $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
   $sql_userid="SELECT user_id,job_pid FROM  jobs WHERE  id=".$job_id;
   $row_userid = $this->db->query($sql_userid)->row_array();
   $isuserpre = $this->issendnotification($row_userid['user_id']);
   if(!$isuserpre){
    $json['success'] = true;
    echo json_encode($json);
    return ;
   }
   $sql_pv_job = $this->db->query("SELECT job_date from jobs WHERE job_type_id=2 AND id=".$row_userid['job_pid'])->row_array();
   $sql_pm_job = $this->db->query("SELECT id,job_date from jobs WHERE job_type_id=7 AND id=".$row_userid['job_pid'])->row_array();
   $sql_pl_job = $this->db->query("SELECT id,job_date from jobs WHERE job_type_id=6 AND id=".$row_userid['job_pid'])->row_array();
   $pv_date ="";
   if(isset($sql_pv_job["job_date"]) && @$sql_pv_job["job_date"] ){
     $pv_date =date("l,F j, Y",$sql_pv_job["job_date"]);
   }
   $pm_date ="";
   if(isset($sql_pm_job["job_date"]) && @$sql_pm_job["job_date"] ){
     $pm_date = "Premeasure scheduled for <a href='".base_url()."admin/job/".$sql_pm_job["id"]."' >".date("l,F j, Y",$sql_pm_job["job_date"])."</a>";
   }

   $pl_date ="";
   if(isset($sql_pl_job["job_date"]) && @$sql_pl_job["job_date"] ){
     $pl_date = "Prelag date scheduled for <a href='".base_url()."admin/job/".$sql_pl_job["id"]."' >".date("l,F j, Y",$sql_pl_job["job_date"])."</a>";
   }

   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($mailid);
   $this->email->subject('"AEI System Notification: Documents received for '.$name);
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p>Thank you for submitting your required documents for '.$name.' scheduled for instalation on <br/>
<a href="'.base_url().'admin/job/'.$row_userid['job_pid'].'">'.$pv_date.'</a><br/><br/>

Don\'t forget your customer\'s other important dates: <br/>
'.$pm_date.'<br/>'.$pl_date.'

</p>
Thanks You,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
     @$this->email->message($message);
     @$this->email->send();
 }*/
 function sendjobfilenotification($job_id,$content,$subject,$is_user,$is_admin){
     $ismailsent = $this->globalnotifcation();
     if(!$ismailsent){
        return;
     }
      $sql = "SELECT   users.email,customers.first_name,customers.last_name,jobs.contractor_id,jobs.installer_id,jobs.conduit_id,jobs.designer_id FROM		jobs
			LEFT JOIN users ON jobs.user_id=users.id
                        LEFT JOIN customers ON jobs.customer_id=customers.id
                        LEFT JOIN  notification_setting ns ON ns.user_id = users.id
			WHERE ns.notification!=0 AND jobs.id=".$job_id;
        $data = array();
        $data = $this->db->query($sql)->result_array();
        if(count($data)>=1){
            $name = ucfirst($data[0]['last_name'])." ".ucfirst($data[0]['first_name']);
         }else{
             $name="";
         }
			if(isset($data[0]['designer_id'])&& $data[0]['designer_id']!=""){
				$j = $this->getUserLoad($data[0]['designer_id']);
				@$this->filenotification($j[0]->email,$content,$job_id,$name,$subject);
			}
       if($is_user) {
           @$this->filenotification($data[0]['email'],$content,$job_id,$name,$subject);
           //@$this->filenotification($this->session->userdata("email"),$content,$job_id,$name,$subject);
        }

   if($is_admin){
        $row_users =  array();
        $row_users = $this->db->query("SELECT users.email,users.first_name,users.last_name from users
            LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type in ('admin','engineer','warehouse' )")->result_array();
        foreach ($row_users as $value){

            @$this->filenotification($value['email'],$content,$job_id,$name,$subject);
        }

   }
}
function filenotification($mailid,$content,$job_id,$name,$subject='AEI System  Notification'){
   $ismailsent = $this->globalnotifcation();
   if(!$ismailsent){
        return;
   }
   $sql  = "SELECT notification from notification_setting WHERE id=1";
   $nresult =  $this->db->query($sql)->result_array();
   if(!$nresult[0]['notification']) return ;
   $sql_userid="SELECT user_id FROM  jobs WHERE  id=".$job_id;
   $row_userid = $this->db->query($sql_userid)->row_array();
   $isuserpre = $this->issendnotification($row_userid['user_id']);
   if(!$isuserpre){
    $json['success'] = true;
    echo json_encode($json);
    return ;
   }
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($mailid);
   $subject =@str_replace("{cust_name}",$name,$subject);
    $subject =@str_replace("{name}","",$subject);
   $this->email->subject($subject);
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> '.@str_replace("{name}",$this->session->userdata("first_name").$this->session->userdata("last_name"),$content).' <br/>
<a href="'.base_url().'admin/job/'.$job_id.'">Download </a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
     @$this->email->message($message);
     @$this->email->send();
 }

 function  issendnotification($user_id){
   $sql = "SELECT user_id FROM  notification_setting WHERE user_id = $user_id";

   $rowe = array();
   $rowe = $this->db->query($sql)->result_array();
   if((count($rowe) >= 1)  && $rowe[0]['user_id']){
      return true;
   }else{
        $row['user_id'] = $user_id;
        return false;
   }

 }
 function globalnotifcation(){
   $sql  = "SELECT notification from notification_setting WHERE id=1";
   $nresult =  $this->db->query($sql)->result_array();
   if(!$nresult[0]['notification']) return 'false' ;
    return true;
 }
function updatepreassementmail($job_id){
 $row['notification'] = 0;
 $this->db->where('job_id',$job_id);
 $this->db->update('presale_files', $row);
 $json['success'] = true;
 echo json_encode($json);

}
function updatepermitcustomermail($job_id){
 $row['notification'] = 0;
 $this->db->where('job_id',$job_id);
 $this->db->update('genral_files', $row);
 $json['success'] = true;
 echo json_encode($json);

}
function updatepresale_notification($job_id,$value){
  $row['is_approved'] = $value;
  $this->db->where('job_id',$job_id);
  $this->db->update('presale_files', $row);
  $json['success'] = true;
  echo json_encode($json);
}
function job_assignnotification($jobid,$userid){
     $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
    if($userid==""|| $jobid=="") return;
    $isuserpre = $this->issendnotification($userid);
    if(!$isuserpre){
        return ;
    }
    $j= $this->getUserLoad($userid);
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($j[0]->email);
   $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=8');
                $row = $query->row();
                $sub=$row->strsubject;
                $msg=$row->strbody;
               
                
                $msg=strtr($msg, array(
                 '%jobid%' => $job_id,
				  '%baseurl%' =>base_url(),
                 ));
   $this->email->subject($sub);
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> A job has assigned to you. For job Detail , please click below<br/>
<a href="'.base_url().'admin/job_comment/'.$jobid.'">Go to Job </a><br/><br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
    @$this->email->message($msg);
    @$this->email->send();
}
function job_unassignnotification($jobid,$userid,$date){
     $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
    if($userid==""|| $jobid=="") return;
    $isuserpre = $this->issendnotification($userid);
    if(!$isuserpre){
        return ;
    }
    $j= $this->getUserLoad($userid);
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($j[0]->email);
   $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=9');
                $row = $query->row();
                $sub=$row->strsubject;
                $msg=$row->strbody;
               
                $sub= strtr($sub, array('%firstName%' => $j[0]->last_name, '%lastName%' => $j[0]->first_name, '%currentdate%' => date("l,F j, Y",strtotime($date))));
             
   $this->email->subject($sub);
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p> This job has been unassigned from this job. <br/>


</p>
Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
    @$this->email->message($msg);
    @$this->email->send();
}

function sendpaperworkmail($mailid,$content,$job_id,$name){
   $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        return;
    }
   $sql_userid="SELECT user_id,job_pid FROM  jobs WHERE  id=".$job_id;
   $row_userid = $this->db->query($sql_userid)->row_array();
   $isuserpre = $this->issendnotification($row_userid['user_id']);
   if(!$isuserpre){
    $json['success'] = true;
    echo json_encode($json);
    return ;
   }
   $sql_pv_job = $this->db->query("SELECT job_date from jobs WHERE job_type_id=2 AND id=".$row_userid['job_pid'])->row_array();
   $sql_pm_job = $this->db->query("SELECT id,job_date from jobs WHERE job_type_id=7 AND job_pid=".$row_userid['job_pid'])->row_array();
   $sql_pl_job = $this->db->query("SELECT id,job_date from jobs WHERE job_type_id=6 AND job_pid=".$row_userid['job_pid'])->row_array();
   $pv_date ="";
   if(isset($sql_pv_job["job_date"]) && @$sql_pv_job["job_date"] ){
     $pv_date =date("l,F j, Y",strtotime($sql_pv_job["job_date"]));
   }
   $pm_date ="";
   if(isset($sql_pm_job["job_date"]) && @$sql_pm_job["job_date"] ){
     $pm_date = "Premeasure scheduled for <a href='".base_url()."admin/job/".$sql_pm_job["id"]."' >".date("l,F j, Y",strtotime($sql_pm_job["job_date"]))."</a>";
   }

   $pl_date ="";
   if(isset($sql_pl_job["job_date"]) && @$sql_pl_job["job_date"] ){
     $pl_date = "Prelag date scheduled for <a href='".base_url()."admin/job/".$sql_pl_job["id"]."' >".strtotime(date("l,F j, Y",$sql_pl_job["job_date"]))."</a>";
   }
   
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($mailid);
   $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=13');
                $row = $query->row();
                $sub=$row->strsubject;
                $msg=$row->strbody;
               
                $sub= strtr($sub, array('%fullname%' => $name));
             
              
   $this->email->subject($sub);
   $messagebdy='<p>Thank you for submitting your required documents for '.$name.' scheduled for installation on 
<a href="'.base_url().'admin/job/'.$row_userid['job_pid'].'">'.$pv_date.'</a>.<br/><br/>

Don\'t forget your customer\'s other important dates: <br/>
'.$pm_date.'<br/>'.$pl_date.'

</p>';
  if ($content=='paperwork1'){
	 $messagebdy='<p>Your customer has received a NEM Status update: NEM is "Pending Technical Review" for this customer</p>';
  }
  if ($content=='paperwork2'){
	 $messagebdy='<p>Your customer has received a NEM Status update: NEM is "Accepted - pending permit closure" for this customer.</p>';
  }
  if ($content=='paperwork3'){
	 $messagebdy='<p>Your customer has received a NEM Status update: NEM is "Accepted" for this customer</p>';
  }
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">'.$messagebdy.'
  
Thanks You,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
     $msg=strtr($msg, array(
                 '%pvdate%' => $pv_date,
                 '%fullname%' => $name,
                 '%jobid%' => $row_userid['job_pid'],
                 '%pmdate%' => $pm_date,
                 '%pldate%' => $pl_date,
                 '%message_body%' =>$messagebdy,
		          '%baseurl%' =>base_url(),
                 ));
     @$this->email->message($msg);
     @$this->email->send();
 }

function statusnotifaction ($custname,$ljobs , $cjobs,$saleman,$email,$userid=0,$notify=null,$job_id=0){
   $ismailsent = $this->globalnotifcation();

    if(!$ismailsent){
        return;
    }
    if($userid){
        $isuserpre = $this->issendnotification($userid);
        if(!$isuserpre){
            return ;
        }
    }
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($email);
   if(trim($cjobs)!='' OR  trim($ljobs)!=''){
       $subject ='Job Status For '.$custname.' Has Updated To '.ucfirst($cjobs).' from '.ucfirst($ljobs)."($notify)";
   } else {
       $subject ='Job Status For '.$custname.' Has Updated '."($notify)";
   }
   $this->email->subject($subject);
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p>
Hi '.$saleman.',<br/>';
   $joblink='#';
   if($job_id){
     $joblink=base_url().'admin/job/'.$job_id;
   }
 if(trim($cjobs)!='' OR  trim($ljobs)!=''){
  $message.='Your job <a href="'.$joblink.'"> '.$custname.'\'s </a>  job status has been updated to "'.ucfirst($cjobs).'" from " '.ucfirst($ljobs).'"<br/>' ;
 } else {
   $message.='Your job <a href="'.$joblink.'"> '.$custname.'\'s </a>  job status has been updated.<br/>' ;
 }
$message.='What this means: <br/>
If any actions are necessary, please make them as soon as possible. This change of status could mean informing your customer about the progress of their installation or permits.<br/>
<br/>Thank you,<br/>
The AEI Administration Team<br/>
</p>
	</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
@$this->email->message($message);
@$this->email->send();
}
function permitcommonnotification($job_id,$notify){
    $sql = "SELECT
			jobs.*,
			customers.id as customer_id,
			customers.first_name,
			customers.last_name,
			customers.address,
			customers.city,
			customers.state,
			customers.zip_code,
			customers.billing_address,
			customers.billing_state,
			customers.billing_city,
			customers.billing_zip_code,
			customers.different_billing_address,
			job_types.type as job_type
		FROM			jobs
		LEFT JOIN job_types ON job_types.id=jobs.job_type_id		LEFT JOIN customers ON jobs.customer_id=customers.id
		WHERE jobs.id=".$job_id;
     $data['job'] = $this->db->query($sql)->row_array();
     $j = $this->getUserLoad($data['job']['user_id']);
     $row_users = $this->db->query("SELECT users.email,users.first_name,users.last_name from users
                            LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type in ('admin','engineer','warehouse' )")->result_array();
             foreach ($row_users as $value){
                $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $data['job']['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$value['email'],0,$notify,$job_id);
             }
        $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $data['job']['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$j[0]->email,$j[0]->id,$notify,$job_id);
            if(isset($data['job']['contractor_id'])){
                $cont = explode(",",$data['job']['contractor_id']);
                           foreach($cont as $user_id){
                            if(!isset($user_id)|| trim($user_id)=="") continue;
                            $k = array();
                            $k = $this->getUserLoad($user_id);
                            if(!count($k)|| $k==0) continue;
                               $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $data['job']['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$k[0]->email,$user_id,$notify,$job_id);
                            }
            }
            if(isset($data['job']['designer_id'])){
                            $cont = explode(",",$data['job']['designer_id']);
                             foreach($cont as $user_id){
                           if(!isset($user_id)|| trim($user_id)=="") continue;
                            $k = array();
                            $k = $this->getUserLoad($user_id);
                            if(!count($k)|| $k==0) continue;
                               $this->statusnotifaction(ucfirst($data['job']['first_name']).ucfirst($data['job']['last_name']),$data['job']['current_status'] , $data['job']['current_status'],ucfirst($j[0]->first_name).ucfirst($j[0]->last_name),$k[0]->email,$user_id,$notify,$job_id);
                        }
          }
          if(isset($data['job']['installer_id'])){
                            $cont = explode(",",$data['job']['installer_id']);
                            foreach($cont as $user_id){
                            if(!isset($user_id)|| trim($user_id)=="") continue;
                            $k = array();
                            $k = $this->getUserLoad($user_id);
                            if(!count($k)|| $k==0) continue;

                            $this->statusnotifaction(ucfirst($data['job']['first_name'])." ".ucfirst($data['job']['last_name']),$data['job']['current_status'] , $data['job']['current_status'],ucfirst($j[0]->first_name)." ".ucfirst($j[0]->last_name),$k[0]->email,$user_id,$notify,$job_id);
                          }
       }


    }
function send_permitnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['permitnotfication']=NULL;
   $dt =$this->input->post("dt");
   if($dt && $dt!='null' ){
      $row['permitnotfication'] = implode("-",explode("/",$this->input->post("dt")));
   }
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->permitcommonnotification($job_id,'Permit Closed');
   $json['success'] = true;
   echo json_encode($json);
 }
function send_hieconotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['heconotfication']=NULL;
   $dt = $this->input->post("dt");
   if($dt && $dt!='null'){
     $row['heconotfication'] = implode("-",explode("/",$this->input->post("dt")));
   }
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->permitcommonnotification($job_id,'HECO Notified');
   $json['success'] = true;
   echo json_encode($json);
 }
 function unschedulejob($job_id){
     $pid = $this->getparentjobid($job_id);
     $sql_pl = "SELECT id  FROM jobs WHERE  job_type_id=6 AND job_pid=$pid AND datediff(job_date,now())>=1";
     $row_pl=$this->db->query($sql_pl)->row_array();
     $sql_pm = "SELECT id  FROM jobs WHERE  job_type_id=7 AND job_pid=$pid AND datediff(job_date,now())>=1 ";
     $row_pm=$this->db->query($sql_pm)->row_array();
     $message="";
     $pm_val=0;
     $pl_val=0;
     if(@$row_pm['id']&& @$row_pl['id'] ){
           $pm_val=1;
           $pl_val=1;
           $message="(Associated jobs(PM,PL) will get deleted)";
    } else if(@$row_pm['id']&& !@$row_pl['id']) {
         $message="";
         $pm_val=1;
         $message="(Associated job(PM) will get deleted)";
     }else if(!@$row_pm['id']&& @$row_pl['id']){
           $message="(Associated job(PL) will get deleted)";
           $pl_val=1;
     }

     $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;Are you sure to unschedule  this  $message &nbsp;&nbsp;&nbsp;<br/>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;<button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
     $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() { var val=0;  location.href='".base_url()."ajax/dounschedulejob/$job_id/$pl_val/$pm_val' }); });</script>";
     echo $output;
 }
 function dounschedulejob($job_id,$val,$pm_val=0){
   $pid = $this->getparentjobid($job_id);
     if($val && $pm_val) {
     $installer = $this->db->query("SELECT sum(no_installer_allocated)as suminstaller FROM jobs where  job_type_id=2 AND   job_pid= '".$pid."'")->result_array();
     $this->db->query("DELETE FROM jobs where  id != job_pid  AND   job_pid='".$pid."'");
     $this->db->query("UPDATE jobs set job_lastscheduledate=job_date  where   job_pid= '".$pid."'");
     $sql = "UPDATE jobs set reschedule_pljob=1,reschedule_pmjob=1,job_lastscheduledate=job_date,job_date=null,current_status='unscheduled',no_installer_allocated=".$installer[0]['suminstaller']." where  job_pid=$pid";
     $this->db->query($sql);
   } else if(!$val && $pm_val){
     $installer = $this->db->query("SELECT sum(no_installer_allocated)as suminstaller FROM jobs where  job_type_id=2 AND   job_pid= '".$pid."'")->result_array();
     $this->db->query("DELETE FROM jobs where  job_type_id!=6 AND id != job_pid  AND   job_pid='".$pid."'");
     $this->db->query("UPDATE jobs set job_lastscheduledate=job_date  where   job_pid= '".$pid."'");
     $sql = "UPDATE jobs set reschedule_pmjob=1,job_lastscheduledate=job_date,job_date=null,current_status='unscheduled',no_installer_allocated=".$installer[0]['suminstaller']." where job_type_id!=6 AND  job_pid=$pid";
     $this->db->query($sql);

   } else if($val && !$pm_val){

      $installer = $this->db->query("SELECT sum(no_installer_allocated)as suminstaller FROM jobs where  job_type_id=2 AND   job_pid= '".$pid."'")->result_array();
     $this->db->query("DELETE FROM jobs where  job_type_id!=7 AND id != job_pid  AND   job_pid='".$pid."'");
     $this->db->query("UPDATE jobs set job_lastscheduledate=job_date  where   job_pid= '".$pid."'");
     $sql = "UPDATE jobs set reschedule_pljob=1,job_lastscheduledate=job_date,job_date=null,current_status='unscheduled',no_installer_allocated=".$installer[0]['suminstaller']." where job_type_id!=7 AND  job_pid=$pid";
     $this->db->query($sql);

  } else{
       $installer = $this->db->query("SELECT sum(no_installer_allocated)as suminstaller FROM jobs where  job_type_id=2 AND   job_pid= '".$pid."'")->result_array();
       $this->db->query("DELETE FROM jobs where  job_type_id!=6 AND job_type_id!=7 AND id != job_pid  AND   job_pid='".$pid."'");
       $this->db->query("UPDATE jobs set job_lastscheduledate=job_date  where job_type_id!=6   AND job_type_id!=7 AND  job_pid= '".$pid."'");
       $sql = "UPDATE jobs set job_lastscheduledate=job_date,job_date=null,current_status='unscheduled',no_installer_allocated=".$installer[0]['suminstaller']." where  job_type_id!=7 AND job_type_id!=6  AND job_pid=$pid";
       $this->db->query($sql);

   }
   redirect("admin/myjobs");
 }

 function savePMjobs($job,$job_id,$is_reschedule,$customer_id=0){
      $session_installer = $this->db->query("SELECT *  FROM  pm_session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")." ORDER BY id")->row_array();
    //$return_obj = new stdclass;

      if(@$session_installer['date_booked']){

        if(!$job && !$is_reschedule && !$job_id){
            $job['job_type_id']=7;
            $job['job_date'] =$session_installer['date_booked']." ".date("h:i:s");
            $job['no_installer_allocated'] = 2;
            $slot_time=1;
            $job['current_status'] = "";
            $job['user_id'] = $this->session->userdata('re_user_id');
            $job['modified_by'] =  $this->session->userdata("user_id");
            $job['created'] = date("Y-m-d H:i:s");
            if(!$this->session->userdata('customer_id') ) {
            // need to add new customer to db
             $row = array();
             $row['first_name'] =  $this->session->userdata('re_first_name');
             $row['last_name'] = $this->session->userdata('re_last_name');
             $row['first_name1'] =  $this->session->userdata('spouse_firstname');
             $row['last_name1'] = $this->session->userdata('spouse_lastname');
             $row['customer_type_id'] = $this->session->userdata('customer_type');
             $row['neighborhood'] = $this->session->userdata('neighborhood');
             $row['created'] = date("Y-m-d H:i:s");
             $this->db->insert("customers",$row);
             $customer_id = $this->db->insert_id(); // get id of customer that was added
             
		//Create activity log for new customer
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Create", "customers", '', $this->session->userdata("user_id"), $customer_id);			
            
             
             $this->db->insert("jobs",$job);
             $pm_job_id = $this->db->insert_id();
		//Create activity log for new job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Create", "jobs", $pm_job_id, $this->session->userdata("user_id"));		

	    } else{
               $customer_id=$this->session->userdata('customer_id');
               $job_row = $this->db->query("SELECT `job_pid`, `in_nod`, `rel_job_id`, `pl_job_id`, `pm_job_id`, `customer_id`, `user_id`, `current_status`, `job_date`, `module_brand_id`, `no_installer_allocated`, `other_module_brand`, `module_count`, `system_size`, `module_power_id`, `other_module_power`, `inverter_type_id`, `other_inverter_type`, `inverter_brand_id`, `other_inverter_brand`, `inverter_count`, `inverter_accessible`, `subpanel_needed`, `service_panel_amperage_id`, `other_amperage`, `wire_run_type_id`, `other_wire_run_type`, `wire_run_distance`, `other_wire_run_distance`, `inverter_other_module_number`, `breaker_box_location`, `meter_to_module_distance`, `meter_location`, `module_configuration`, `electric_wire_source`, `electric_wire_source_other`, `stories`, `module_install_location_access`, `is_ladder`, `other_roof_type`, `rafter_type_id`, `other_rafter_type`, `rafter_distance`, `roof_type_id`, `roof_orientation`, `roof_color`, `roof_pitch`, `tilt_kit_needed`, `installation_type_id`, `other_installation_type`, `contractor_id`, `tank_brand_id`, `other_tank_brand`, `tank_size_id`, `other_tank_size`, `heater_location`, `remove_old_tank`, `relocate_old_tank`, `new_tank_location`, `tank_distance`, `solar_tank_accessible`, `panel_type_id`, `other_panel_type`, `panel_size_id`, `other_panel_size`, `panel_count`, `piperun_length`, `piperun_type_id`, `other_piperun_type`, `gutter_installation`, `solar_fan_brand_id`, `solar_fan_brand_other`, `solar_fan_size_id`, `solar_fan_size_other`, `comments`, `created`, `system_special_pricing`, `system_list_price`, `referral`, `program_discount`, `jobs_emt`, `other_jobs_emt`, `referral_amount`, `state_excise_tax`, `sales_commission`, `state_tax_credit`, `fan_install_location_access`, `federal_tax_credit`, `total_tax_credits`, `payment_type_id`, `financing_comments`, `list_price`, `panel_install_location_access`, `existing_heater_location`, `fan_install_access_location`, `fan_brand_id`, `fan_size_id`, `other_fan_brand`, `other_fan_size`, `job_count`, `job_nos`, `job_nosa`, `other_job_nosa`, `job_nom`, `other_job_nom`, `mointer_system`, `other_mointer_system`, `job_spu`, `job_dowr`, `other_job_spu`, `modified_by`, `job_isnws`, `installer_id`, `payment_dpp`, `payment_amdpp`, `payment_fpp`, `payment_amfpp`, `saoorf`, `nodrf`, `job_wssn`, `servicepanelupgrade`, `repair_time`, `repair_type`, `servicedesc`, `spmsip_job`, `conduit_id`, `envoy_serial_number`, `typeofjump`, `bis`, `eis`, `hapsta`, `designer_id`, `elec_insp_quote`, `elec_comments`, `pump_type_id`, `other_pump_type`, `is_pp_checked`, `is_mail_sent`, `status_updated`, `permitnotfication`, `heconotfication`, `job_lastscheduledate`, `proposal_id`, `roof_flashing`, `other_roof_flashing`, `institution`, `arrival_time`, `toprelag`, `pldesc`, `pl_comments`, `pl_completed`, `pm_completed`, `net_total_price`, `sub_total_price`, `state_tax_credit_1`, `state_tax_credit_2`, `state_tax_credit_3`, `state_tax_credit_4`, `state_tax_credit_5`, `state_tax_credit_6`, `federal_tax_credit_1`, `federal_tax_credit_2`, `federal_tax_credit_3`, `standoff_size_id`, `other_standoff_size`, `base_commsion`, `qoute_upcharge`, `qoute_addwork`, `discount`, `addedcharge`, `referral_job`, `subpanel_exist`, `paperwork_completed`, `is_customer_mailsent` from jobs where job_type_id=2 AND customer_id=$customer_id")->row_array();
               $this->db->insert("jobs",$job_row);
               $pm_job_id = $this->db->insert_id();
			   $job['job_pid']=$job_row["job_pid"];
		//Create activity log for new job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Create", "jobs", $pm_job_id, $this->session->userdata("user_id"));
		
               $this->db->where("id",$pm_job_id);
               $this->db->update("jobs",$job);
		
		//Create activity log for update job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "jobs", $pm_job_id, $this->session->userdata("user_id"));
		
               $row['neighborhood'] = $this->session->userdata('neighborhood');
               $this->db->where("id",$customer_id);
               $this->db->update("customers",$row);
		
		//Create activity log for updated customer
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "customers", '', $this->session->userdata("user_id"), $customer_id);
               
           }

            $job_update['pm_job_id']=$pm_job_id;
            if(isset($job_row["job_pid"])&& @$job_row["job_pid"]>0)
			 $job_update['job_pid'] = $job_row["job_pid"];	
			 else
			 $job_update['job_pid'] = $pm_job_id;

            $job_update["customer_id"]=$customer_id;
            $this->db->where("id",$pm_job_id);
            $this->db->update("jobs",$job_update);
		//Create activity log for update job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "jobs", $pm_job_id, $this->session->userdata("user_id"));
           
            $this->sendPMjobnotification($pm_job_id);
            $year = date("Y" ,strtotime($session_installer['date_booked']));
            $month = date("m" ,strtotime($session_installer['date_booked']));
            $json['year'] = @$year;
            $json['month'] = @$month;
            $json['success'] = true;
            echo json_encode($json);
            $this->canceljob();
            return;
        } else    if($is_reschedule && $job_id) {
          $job['job_date'] =$session_installer['date_booked']." ".date("h:i:s");
          $job['current_status']='';
          $this->db->where("job_pid",$job_id);
          $this->db->where("job_type_id",7);
          $this->db->update("jobs",$job);
		//Create activity log for update job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "jobs", $job_id, $this->session->userdata("user_id"));		
          
          $year = date("Y" ,strtotime($session_installer['date_booked']));
          $month = date("m" ,strtotime($session_installer['date_booked']));
          $json['year'] = @$year;
          $json['month'] = @$month;
          $json['success'] = true;
          if(@$this->session->userdata('job_type_pl')==6 && @$this->session->userdata('job_type_pm')==7 ){
            return;
          } else{
              $this->sendcommonjobreschdulenoti($job_id,'Premeasure');
              echo json_encode($json);
          }
          return;
       }
       $job['job_date'] =$session_installer['date_booked']." ".date("h:i:s");
       $job['job_pid']=$job_id;
       $job['job_type_id'] = 7;
       $job['pm_job_id']=$job_id;
       $this->db->insert("jobs",$job);
       $job_pm_id = $this->db->insert_id();
	
	//Create activity log for new job
	$this->load->library("activitylog");
	//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
	$this->activitylog->createlog("Create", "jobs", $job_pm_id, $this->session->userdata("user_id"));		
	
       return $job_pm_id;
    }
    return 0;
 }
 function savePLjobs($job,$job_id,$is_reschedule,$customer_id=0){
    $session_installer = $this->db->query("SELECT *  FROM  pl_session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")." ORDER BY id")->row_array();
    $return_obj = new stdclass;
    if(@$session_installer['date_booked']){
       if($job_id){
        $sql = "SELECT * FROM jobs where jobs.job_type_id=6 AND job_pid=$job_id";
        $is_exist_job=@$this->db->query($sql)->row_array();
       }

      if($job_id==0 || (!isset($is_exist_job['id'])&& !$is_reschedule)){
       $job['job_pid']=$job_id;
       $job['job_type_id']=6;
       $job['rel_job_id'] = $job_id;
       $job['job_date'] =$session_installer['date_booked']." ".date("h:i:s");
       $job['no_installer_allocated'] = 2;
       $slot_time=1;
       $job['current_status'] = "";
       $job['user_id'] = $this->session->userdata('re_user_id');
       $job['modified_by'] =  $this->session->userdata("user_id");
       $job['created'] = date("Y-m-d H:i:s");

       if($session_installer['slot_time']>2 && $session_installer['slot_time']<=4 ){
                $slot_time=2;
        }
          if($session_installer['slot_time']>4  ){
                $slot_time=3;
        }
       $job['arrival_time']=$slot_time;

       if($job_id==0 ){
          if(!$this->session->userdata('customer_id') ) {
        // need to add new customer to db
            $row = array();
            $row['first_name'] =  $this->session->userdata('re_first_name');
            $row['last_name'] = $this->session->userdata('re_last_name');
            $row['first_name1'] =  $this->session->userdata('spouse_firstname');
            $row['last_name1'] = $this->session->userdata('spouse_lastname');
            $row['customer_type_id'] = $this->session->userdata('customer_type');
            $row['neighborhood'] = $this->session->userdata('neighborhood');
            $row['created'] = date("Y-m-d H:i:s");
            $this->db->insert("customers",$row);
            $customer_id = $this->db->insert_id(); // get id of customer that was added
            
		//Create activity log for new customer
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Create", "customers", '', $this->session->userdata("user_id"), $customer_id);		
      
            
            
            $this->db->insert("jobs",$job);
            $pl_job_id = $this->db->insert_id();
            
		//Create activity log for new job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Create", "jobs", $pl_job_id, $this->session->userdata("user_id"));		
           
            } else{
             $customer_id=$this->session->userdata('customer_id');
             $job_row = $this->db->query("SELECT `job_pid`, `in_nod`, `rel_job_id`, `pl_job_id`, `pm_job_id`, `customer_id`, `user_id`, `current_status`, `job_date`, `module_brand_id`, `no_installer_allocated`, `other_module_brand`, `module_count`, `system_size`, `module_power_id`, `other_module_power`, `inverter_type_id`, `other_inverter_type`, `inverter_brand_id`, `other_inverter_brand`, `inverter_count`, `inverter_accessible`, `subpanel_needed`, `service_panel_amperage_id`, `other_amperage`, `wire_run_type_id`, `other_wire_run_type`, `wire_run_distance`, `other_wire_run_distance`, `inverter_other_module_number`, `breaker_box_location`, `meter_to_module_distance`, `meter_location`, `module_configuration`, `electric_wire_source`, `electric_wire_source_other`, `stories`, `module_install_location_access`, `is_ladder`, `other_roof_type`, `rafter_type_id`, `other_rafter_type`, `rafter_distance`, `roof_type_id`, `roof_orientation`, `roof_color`, `roof_pitch`, `tilt_kit_needed`, `installation_type_id`, `other_installation_type`, `contractor_id`, `tank_brand_id`, `other_tank_brand`, `tank_size_id`, `other_tank_size`, `heater_location`, `remove_old_tank`, `relocate_old_tank`, `new_tank_location`, `tank_distance`, `solar_tank_accessible`, `panel_type_id`, `other_panel_type`, `panel_size_id`, `other_panel_size`, `panel_count`, `piperun_length`, `piperun_type_id`, `other_piperun_type`, `gutter_installation`, `solar_fan_brand_id`, `solar_fan_brand_other`, `solar_fan_size_id`, `solar_fan_size_other`, `comments`, `created`, `system_special_pricing`, `system_list_price`, `referral`, `program_discount`, `jobs_emt`, `other_jobs_emt`, `referral_amount`, `state_excise_tax`, `sales_commission`, `state_tax_credit`, `fan_install_location_access`, `federal_tax_credit`, `total_tax_credits`, `payment_type_id`, `financing_comments`, `list_price`, `panel_install_location_access`, `existing_heater_location`, `fan_install_access_location`, `fan_brand_id`, `fan_size_id`, `other_fan_brand`, `other_fan_size`, `job_count`, `job_nos`, `job_nosa`, `other_job_nosa`, `job_nom`, `other_job_nom`, `mointer_system`, `other_mointer_system`, `job_spu`, `job_dowr`, `other_job_spu`, `modified_by`, `job_isnws`, `installer_id`, `payment_dpp`, `payment_amdpp`, `payment_fpp`, `payment_amfpp`, `saoorf`, `nodrf`, `job_wssn`, `servicepanelupgrade`, `repair_time`, `repair_type`, `servicedesc`, `spmsip_job`, `conduit_id`, `envoy_serial_number`, `typeofjump`, `bis`, `eis`, `hapsta`, `designer_id`, `elec_insp_quote`, `elec_comments`, `pump_type_id`, `other_pump_type`, `is_pp_checked`, `is_mail_sent`, `status_updated`, `permitnotfication`, `heconotfication`, `job_lastscheduledate`, `proposal_id`, `roof_flashing`, `other_roof_flashing`, `institution`, `arrival_time`, `toprelag`, `pldesc`, `pl_comments`, `pl_completed`, `pm_completed`, `net_total_price`, `sub_total_price`, `state_tax_credit_1`, `state_tax_credit_2`, `state_tax_credit_3`, `state_tax_credit_4`, `state_tax_credit_5`, `state_tax_credit_6`, `federal_tax_credit_1`, `federal_tax_credit_2`, `federal_tax_credit_3`, `standoff_size_id`, `other_standoff_size`, `base_commsion`, `qoute_upcharge`, `qoute_addwork`, `discount`, `addedcharge`, `referral_job`, `subpanel_exist`, `paperwork_completed`, `is_customer_mailsent` from jobs where job_type_id=2 AND customer_id=$customer_id")->row_array();
             $this->db->insert("jobs",$job_row);
             $pl_job_id = $this->db->insert_id();
              $job['job_pid']=$job_row["job_pid"];
		//Create activity log for new job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Create", "jobs", $pl_job_id, $this->session->userdata("user_id"));
		

		
             $this->db->where("id",$pl_job_id);
             $this->db->update("jobs",$job);
		//Create activity log for update job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "jobs", $pl_job_id, $this->session->userdata("user_id"));
		
             $row['neighborhood'] = $this->session->userdata('neighborhood');
             $this->db->where("id",$customer_id);
             $this->db->update("customers",$row);
             
		//Create activity log for updated customer
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "customers", '', $this->session->userdata("user_id"), $customer_id);		
             
             
            }

        $job_update['customer_id'] = $customer_id;
        // $job_update['user_id']=$this->session->userdata('user_id');
       }else{
           $this->db->insert("jobs",$job);
            $pl_job_id = $this->db->insert_id();
		//Create activity log for new job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Create", "jobs", $pl_job_id, $this->session->userdata("user_id"));
       }

       $job_update['pl_job_id']=$pl_job_id;
       if($job_id==0){
        $job_update['job_pid'] = $pl_job_id;
       }
       if(isset($job_row["job_pid"])&& @$job_row["job_pid"]>0)
			 $job_update['job_pid'] = $job_row["job_pid"];	
       

       $this->db->where("id",$pl_job_id);
       $this->db->update("jobs",$job_update);
	//Create activity log for update job
	$this->load->library("activitylog");
	//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
	$this->activitylog->createlog("Update", "jobs", $pl_job_id, $this->session->userdata("user_id"));	

	
       $year = date("Y" ,strtotime($session_installer['date_booked']));
       $month = date("m" ,strtotime($session_installer['date_booked']));
       if($job_id==0){
         $this->sendPLjobnotification($pl_job_id);
        $json['year'] = @$year;
        $json['month'] = @$month;
        $json['success'] = true;
        echo json_encode($json);
        $this->canceljob();
        return;
       }
       $return_obj->job_date = $session_installer['date_booked'];
       $return_obj->id=$pl_job_id;
       return $return_obj;
      } else if (isset($is_exist_job['id'])&& $is_reschedule){

         $job =array();
         $job['job_date'] =$session_installer['date_booked']." ".date("h:i:s");
         $job['current_status'] = "";
         $slot_time=1;
         if($session_installer['slot_time']>2 && $session_installer['slot_time']<=4 ){
                $slot_time=2;
         }
         if($session_installer['slot_time']>4  ){
                $slot_time=3;
        }

       $job['arrival_time']=$slot_time;
       $this->db->where("id",$is_exist_job['id']);
       $this->db->update("jobs",$job);
	//Create activity log for update job
	$this->load->library("activitylog");
	//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
	$this->activitylog->createlog("Update", "jobs", $is_exist_job['id'], $this->session->userdata("user_id"));
	
        
       $year = date("Y" ,strtotime($session_installer['date_booked']));
       $month = date("m" ,strtotime($session_installer['date_booked']));
       $json['year'] = @$year;
       $json['month'] = @$month;
       if(@$this->session->userdata('job_type_pl')==6 && @$this->session->userdata('job_type_pm')==7 ){
          $this->sendcommonjobreschdulenoti($job_id,'PreLag & Premeasure');
       } else {
          $this->sendcommonjobreschdulenoti($job_id,'PreLag');
       }
       $json['success'] = true;
       echo json_encode($json);

   }

    }

 }
 function photoreview($job_id){
    $this->load->helper("thumbnail_helper");
    if($job_id=='') { redirect('admin/error?e=job_id'); }
    $pid = $this->getparentjobid($job_id);
    $sql = "SELECT  * from elecphoto_files WHERE job_id=$pid ORDER by photo_id";
    $data['photo']= $this->db->query($sql)->result_array();
    $this->load->view("ajax/electricphtooreview",$data);
 }
 function job_setting(){
   $data["pv_jobs"] = array();
   $data["swh_jobs"]=array();
   $data["pv_jobs"][] = "Select Number of PV Job";
   $data["swh_jobs"][] = "Select Number of SWH Job";
   $data["ac_jobs"][] = "Select Number of AC Job";
   $data["sc_jobs"][] = "Select Number of SC Job";
   $data["pl_jobs"][] = "Select Number of PL  Job";
   $resultcnt =  $this->db->query("SELECT * FROM globalconfig  where id = 1")->row_array();
   $data["pv"] = $resultcnt['pv_job'];
   $data["swh"]=$resultcnt['swh_job'];
   $data["ac"]=$resultcnt['ac_job'];
   $data["sc"]=$resultcnt['sc_job'];
   $data["pl"]=$resultcnt['pl_job'];
   $data["wm_swh"]=$resultcnt['wm_swh'];
   $data["pl_pv"]=$resultcnt['pl_pv'];
   $data["pm_pl"]=$resultcnt['pm_pl'];
   $data["digital_pm_pv"]=$resultcnt['digital_pm_pv'];
   $data["hoa_Setting"]=$resultcnt['hoa_setting'];
   $data['apm_ac']=$resultcnt['apm_ac'];
   for($i=1;$i<50;$i++){
    $data["pv_jobs"][]=$i;
    $data["swh_jobs"][] =$i;
    $data["ac_jobs"][] =$i;
    $data["sc_jobs"][] =$i;
    $data["pl_jobs"][] =$i;
   }
   $this->load->view("ajax/global_jobsetting",$data);
 }

 function  save_job_setting(){
   $row =array();
   $row['pv_job'] = $this->input->post("pv_jobs");
   $row['swh_job']=$this->input->post("swh_jobs");
   $row['ac_job']=$this->input->post("ac_jobs");
   $row['sc_job']=$this->input->post("sc_jobs");
   $row['pl_job']=$this->input->post("pl_jobs");
   $row['wm_swh']=$this->input->post("wm_swh");
   $row['pm_pl']=$this->input->post("pm_pl");
   $row['pl_pv']=$this->input->post("pl_pv");
   $row['digital_pm_pv']=$this->input->post("digital_pm_pv");
   $row['hoa_Setting']=$this->input->post("hoa_Setting");
   $row['apm_ac']=$this->input->post("apm_ac");
   $this->db->where('id',1);
   $this->db->update('globalconfig', $row);
   $json['success'] = true;
   echo json_encode($json);

 }

 function getjoblimit(){
     global $pv_job_count;
     global $swh_job_count;
	 global $ac_job_count;
     global $sc_job_count;
	  
     $resultcnt =  $this->db->query("SELECT * FROM globalconfig  where id = 1")->row_array();
     $pv_job_count = $resultcnt['pv_job'];
     $swh_job_count=$resultcnt['swh_job'];
     $ac_job_count=$resultcnt['ac_job'];
     $sc_job_count=$resultcnt['sc_job'];

  }
   function getCustomerNeighborhood($id){
      if (!$id) return 0;
      $neighborhood="";
      $j = $this->db->query("SELECT neighborhood,other_neighborhood FROM customers WHERE id=$id")->result_array();
      foreach($j as $key => $value) {
        if(isset($value['neighborhood'])){
            if($value['neighborhood']=="other"){
                $neighborhood = ucfirst($value['other_neighborhood']);
            }else{
               if(isset($value['neighborhood']) && $value['neighborhood']!="" && is_numeric($value['neighborhood']) ){
               $sql = "SELECT neighbour from  neigbhour where id=".$value['neighborhood'];
               $row_neighbour = $this->db->query($sql)->row_array();
               $neighborhood = ucfirst($row_neighbour['neighbour']);
               }else{
               $neighborhood = $value['neighborhood'];
               }
            }
        }
      }
      if(strlen($neighborhood)>20){
          $neighborhood = substr($neighborhood,0,20)."..";
      }
      return @$neighborhood;
  }

  function sendPLjobnotification($job_id){
      $j= $this->getUserLoad($this->session->userdata('re_user_id'));
      $ismailsent = $this->globalnotifcation();
      $row_users = $this->db->query("SELECT users.email FROM users LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type in ('admin','engineer','warehouse' )")->result_array();
      $cnt = count($row_users);
      $row_users[$cnt ]['email']= $j[0]->email;
      foreach ($row_users as $valueuser){
            $this->load->library('email');
             $config['mailtype'] = 'html';
           $this->email->initialize($config);
          $this->email->to($valueuser['email']);
           $this->email->from('sales@aeihawaii.com', 'Schedular');
         $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=10');
                $row = $query->row();
                $sub=$row->strsubject;
                $msg=$row->strbody;
               
                $sub= strtr($sub, array('%lastName%' => $this->session->userdata('re_last_name'), '%firstName%' => $this->session->userdata('re_first_name')));
             
                 $msg=strtr($msg, array(
                 '%lastName%' => $this->session->userdata('re_last_name'),
                 '%firstName%' => $this->session->userdata('re_first_name'),
                 '%jobid%' => $job_id,
				   '%baseurl%' =>base_url(),
                 ));
		 $this->email->subject($sub);
        $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
A Prelag Job  has been scheduled for your customer.<br/> To view the details of this Prelag Job, update and edit your technical specifications here:<br/>
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification for '.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name').'</a><br/><br/>

Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
       @$this->email->message($msg);
       @$this->email->send();
    }
  }
  function sendPMjobnotification($job_id){
      $j= $this->getUserLoad($this->session->userdata('re_user_id'));
      $ismailsent = $this->globalnotifcation();
      if(!$ismailsent) return ;
      $row_users = $this->db->query("SELECT users.email FROM users LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type in ('admin','engineer','warehouse' )")->result_array();
      $cnt = count($row_users);
      $row_users[$cnt ]['email']= $j[0]->email;
      foreach ($row_users as $valueuser){
            $this->load->library('email');
             $config['mailtype'] = 'html';
           $this->email->initialize($config);
          $this->email->to($valueuser['email']);
           $this->email->from('sales@aeihawaii.com', 'Schedular');
		    $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=14');
                $row = $query->row();
                $sub=$row->strsubject;
                $msg=$row->strbody;
               
                $sub= strtr($sub, array('%lastName%' => $this->session->userdata('re_last_name'),'%firstName%' => $this->session->userdata('re_first_name')));
             
                $msg=strtr($msg, array(
                 '%lastName%' => $this->session->userdata('re_last_name'),
                 '%firstName%' => $this->session->userdata('re_first_name'),
                 '%jobid%' => $job_id,
				  '%baseurl%' =>base_url(),
                  ));
         $this->email->subject($sub);
        $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
A Premeasure Job  has been scheduled for your customer.<br/> To view the details of this Prelag Job, update and edit your technical specifications here:<br/>
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification for '.$this->session->userdata('re_last_name').', '.$this->session->userdata('re_first_name').'</a><br/><br/>

Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
       @$this->email->message($msg);
       @$this->email->send();
    }
  }

  function sendcommonjobreschdulenoti($job_id,$job_name){
      $j= $this->getUserLoad($this->session->userdata('re_user_id'));
      $sql="SELECT c.first_name,c.last_name from jobs  left join  customers c on jobs.customer_id=c.id where jobs.id=$job_id";
      $row_customer = $this->db->query($sql)->row_array();
      $ismailsent = $this->globalnotifcation();
      $row_users = $this->db->query("SELECT users.email FROM users LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type in ('admin','engineer','warehouse' )")->result_array();
      $cnt = count($row_users);
      $row_users[$cnt ]['email']= $j[0]->email;
      foreach ($row_users as $valueuser){
            $this->load->library('email');
             $config['mailtype'] = 'html';
           $this->email->initialize($config);
          $this->email->to($valueuser['email']);
           $this->email->from('sales@aeihawaii.com', 'Schedular');
		   $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=15');
                $row = $query->row();
                $sub=$row->strsubject;
                $msg=$row->strbody;
               
                $sub= strtr($sub, array('%jobname%' => $job_name,'%lastName%' => $row_customer['last_name'],'%firstName%' => $row_customer['first_name']));
             
                $msg=strtr($msg, array(
                 '%jobname%' => $job_name,
                 '%firstName%' => $row_customer['first_name'],
                 '%lastName%' => $row_customer['last_name'],
                 '%jobid%' => $job_id,
				   '%baseurl%' =>base_url(),
                  ));
         $this->email->subject($sub);
        $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
		<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
A '.$job_name.' Job  has been rescheduled for your customer.<br/> To view the details of this '.$job_name.' Job, update and edit your technical specifications here:<br/>
<a href="'.base_url().'admin/job/'.$job_id.'">Edit Technical Specification for '.$row_customer['first_name'].', '.$row_customer['last_name'].'</a><br/><br/>

Sincerely,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
       @$this->email->message($msg);
       @$this->email->send();
    }
  }
  
    function savehelpdetails($id){
       $row =array();
       $desc= $this->input->post("desc");
       $row["elect_phot_".$id]=$desc;
       $this->db->where("id",1);
       $this->db->update("globalconfig",$row);
       $json['success'] = true;
       echo json_encode($json);

    }
  function editphotohelp($id){
      $data=array();
      $data['id']=$id;
      $sql = "SELECT elect_phot_$id as pdesc FROM globalconfig WHERE id=1";
      $result=$this->db->query($sql)->row_array();
      $data['desc']=$result['pdesc'];
      $this->load->view("ajax/photohelp_detail",$data);

  }
   function electricfilemovedconfirm($job_id,$photo_id,$file_id){
     $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;Are you sure ? &nbsp;&nbsp;&nbsp;<br/><br/><button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
     $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() {location.href='".base_url()."ajax/electricfilemoved/$job_id/$photo_id/$file_id'; }); });</script>";
     echo $output;
 }
  function electricfilemoved($job_id,$photo_id,$file_id){
      $file_data=$this->db->query("SELECT * from meter_files WHERE id=$file_id")->row_array();
      $row = array();
      $row['job_id'] = $job_id;
      $row['original_filename'] = $file_data['original_filename'];
      $row['unique_filename'] = $file_data['unique_filename'];
      $row['mime'] = $file_data['mime'];
      $row['created'] = date("Y-m-d H:i:s");
      $row['job_type'] = 2;
      $row['title']=$file_data['title'];
      $row['file_size']=$file_data['file_size'];
      $pid = $this->getparentjobid($job_id);
      $row['job_id'] =  $pid;
      $row['photo_id'] = @$photo_id;
      $this->db->insert("elecphoto_files",$row);
      redirect("admin/fileview_job/".$job_id);

  }
  function pl_reschedule($job_id,$job_timestamp,$user_id,$is_admin=0){
     $data=array();
	 $plopt = array(1=>'Postponed - Roofing issues',2=>'Postponed - HOA',3=>'Rainout',4=>'Cancelled',6=>"Waiting for HECO approval",5=>'Other');
     $data['poption'] = $plopt;
     $data['job_id']=$job_id;
	 $data["is_admin"]=$is_admin;
     $pid = $this->getparentjobid($job_id);
     if(!$job_timestamp) $job_timestamp=time();
     $data['job_timestamp']=$job_timestamp;
     $pid = $this->getparentjobid($job_id);
     $is_pm_job = $this->db->query("SELECT pm_job_id,user_id,job_date from jobs  where job_type_id=7 AND  job_pid=$pid")->row_array();
     $data["is_pm_job"]=@$is_pm_job["pm_job_id"];
     $data["pm_date"]=@$is_pm_job["job_date"];
     $is_pl_job = $this->db->query("SELECT pl_job_id,user_id,job_date from jobs  where job_type_id=6 AND  job_pid=$pid")->row_array();
     $data["is_pl_job"]=@$is_pl_job["pl_job_id"];
     $data["pl_date"]=@$is_pl_job["job_date"];
	 $data["job"] = $this->db->query("SELECT *  from jobs  where job_type_id=2 AND  job_pid=$pid")->row_array();
     if(@!$is_pm_job["pm_job_id"] && @!$is_pl_job["pl_job_id"]){
       // $this->save_session_un($job_id);

     }
     $data["user_id"]=$user_id;
     $this->load->view("ajax/pl_reschedule",$data);
  }
  

  function reschedule($job_id,$user_id){
     $data=array();
     $this->session->unset_userdata('pmOverride');
     $data['job_id']=$job_id;
	 $plopt = array(1=>'Postponed - Roofing issues',2=>'Postponed - HOA',3=>'Rainout',4=>'Cancelled',6=>"Waiting for HECO approval",5=>'Other');
     $data['poption'] = $plopt;
     $data["user_id"]=$user_id;
     $data["job_type"]=$this->input->get("type");
     $job_timestamp=time();
     $data['job_timestamp']=$job_timestamp;     
     $this->load->view("ajax/reschedule",$data);
  }
    
  function confirmdelete_job($job_id)
  { 
     $data=array();
     $data['job_id']=$job_id;
     $data['ref']=$_REQUEST['ref'];

     $this->load->view("ajax/confirmdelete_job",$data);
  }  
  
  function confirmdelete_service($job_id)
  { 
     $data=array();
     $data['job_id']=$job_id;
     $data['ref']=$_REQUEST['ref'];
     $this->load->view("ajax/confirmdelete_service",$data);
  }    
  
  
function update_image_id($file_id,$id,$select_text="",$checked_value=0){
     $row=array();
     $row["image_id"]=$id;
     $row["image_text"]="$select_text";
     $row["is_export"]=$checked_value;
     $this->db->where("id",$file_id);
     $this->db->update("meter_files",$row);
     $json['success'] = true;
     echo json_encode($json);
  }

  function getmetertypeoption($job_id,$file_id=0){
      $pid= $this->getparentjobid($job_id);
      $sql = "select subpanel_exist from jobs where job_pid=$pid and job_type_id=2";
      $result_subpanel=$this->db->query($sql)->row_array();
      $file_options=array();
      $where_id ="";
      if(@$result_subpanel['subpanel_exist']!='y'){
            $where_id=" AND id!=2" ;
      }
      $sql_image_id=$this->db->query("SELECT image_id,image_text from meter_files  WHERE id=$file_id")->row_array();
      $sql = "SELECT * FROM file_options WHERE  id not in (SELECT image_id from meter_files  WHERE id!=$file_id AND file_type=".FILE_TYPE_METER." AND job_id=$pid) $where_id ";
      $result = $this->db->query($sql)->result_array();
      if(count($result)>=1){
          $file_options =array();
          foreach($result as $data){
            $file_options[$data['id']] = $data['file_options'];

          }

      } else {
        $file_options[6]="Other";
	  }
	   $file_options[6]="Other";
        echo @form_dropdown("meterfile",$file_options,@$sql_image_id["image_id"],'onchange="meterfileupdated('.$file_id.',this);"');

        if($sql_image_id["image_id"]==6  ){
            echo "<div id='other_meter_text'><input value='".$sql_image_id["image_text"]."' type=text name=imagetext style='width:140px;' /></div>";
        }else if(count($file_options)==1 ){
        echo "<div id='other_meter_text'><input  type=text name=imagetext style='width:140px;' /></div>";
      }
    }


  function getrooftypeoption($job_id,$file_id){
      $pid= $this->getparentjobid($job_id);
      //$file_options=array();
      $sql_image_id=$this->db->query("SELECT image_id,image_text from meter_files  WHERE id=$file_id")->row_array();
      $file_options = array("1"=>"Rooftype Confirmation", "2"=>"Array Location on Roof");
      $sql = "SELECT image_id from meter_files  WHERE id!=$file_id AND file_type=".FILE_TYPE_ROOF." AND job_id=$pid";
      $result = $this->db->query($sql)->result_array();
      if(count($result)>=1){

          foreach($result as $data){
            //echo $file_options[$data['id']];
              if($data['image_id'])
            unset($file_options[$data['image_id']]);

          }

      } else {
     // $file_options[3]="Other";
	  }
	        $file_options[3]="Other";
      echo form_dropdown("rooffile",$file_options,@$sql_image_id["image_id"], 'onchange="rooffileupdated('.$file_id.',this);"');
      if($sql_image_id["image_id"]==3){
       echo "<div id='other_roof_text'><input value='".$sql_image_id["image_text"]."' type=text name=imagetext style='width:140px;' /></div>";
      } else if(count($file_options)==1 ){
        echo "<div id='other_roof_text'><input  type=text name=imagetext style='width:140px;' /></div>";
      }

  }

  function updateelecexport($value,$file_id){
     $row=array();
     $row['is_export']=$value;
     $this->db->where("id",$file_id);
     $this->db->update("meter_files",$row);
     $json['success'] = true;
     echo json_encode($json);
  }

  function loadjobsetting($year,$month,$day){
    global  $pv_job_count,$swh_job_count,$sc_job_count,$pm_job_count,$el_job_count,$ac_job_count,$apm_job_count;
    $data=array();
    $date =date("Y-m-d",strtotime("$year-$month-$day"));
    $sql = "SELECT * FROM day_job_setting WHERE job_date='$date' order by id desc";
    $result = $this->db->query($sql)->row_array();
    if(!@$result['id']) {
        $data['swh']=$swh_job_count;
        $data['pv']=$pv_job_count;
        $data['sc']=$sc_job_count;
        $data['pm']=$pm_job_count;
	    $data['el']=$el_job_count;
		   $data['ac']=$ac_job_count;
	    $data['apm']=$apm_job_count;
        $data['id']=0;

    } else {

       $data['pv']=$result['pv'];
       $data['pl']=$result['pl'];
       $data['swh']=$result['swh'];
       $data['sc']=$result['sc'];
       $data['pm']=$result['pm'];
	   $data['el']=$result['el'];
	    $data['ac']=$result['ac'];
	    $data['apm']=$result['apm'];
    }

    $data['job_date']=strtotime($date);
    $this->load->view("ajax/job_setting",$data);


  }

  function updatejobsetting($date,$pvjob,$swh,$service,$pmjob,$eljob,$acjob,$apmjob,$pljobs,$id=0){
     $row=array();
     $row['job_date']=date("Y-m-d",$date);
     $row['swh']=$swh;
     $row['sc']=$service;
     $row['pv']=$pvjob;
     $row['pm']=$pmjob;
	 $row['el']=$eljob;
	 $row['ac']=$acjob;
     $row['apm']=$apmjob;
     $row['pl']=$pljobs;
     if($id==0){
         $this->db->insert("day_job_setting",$row);
     } else {
        $this->db->where("id",$id);
        $this->db->update("day_job_setting",$row);
     }
     $json['success'] = true;
     echo json_encode($json);
  }
  function   getallsalesuser($job_id,$user_id){
    $sql = "SELECT * FROM users WHERE  type='sales'";
    $data['users'] = $this->db->query($sql)->result_array();
    $user_select=array();
    foreach($data['users'] as $users){
     $user_select[$users['id']]= ucfirst($users['first_name'])." ".ucfirst($users['last_name']);
    }
    $data['job_id']=$job_id;
    $data['user_id']=$user_id;
    $data['saleuser']=$user_select;
    $this->load->view("ajax/salesuser",$data);
  }
  function updatejobuser($jobid,$uid){
     $row=array();
	 $row['user_id']=$uid;
	 $sql = "SELECT job_pid,proposal_id FROM jobs WHERE id = '".$jobid."'";
	 $res = $this->db->query($sql)->row_array();
	 if($res['job_pid']!='')
	 {
		 $sql = "SELECT id FROM jobs WHERE job_pid = '".$res['job_pid']."'";
		 $rs = $this->db->query($sql)->result_array();
		 foreach($rs as $val)
		 {
			$this->db->where("id",$val['id']);
     		$this->db->update("jobs",$row);
			//Create activity log for update job
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Update", "jobs", $val['id'], $this->session->userdata("user_id"));
		 }
		 //updating proposal user here
		 if($res['proposal_id']!='')
		 {
		 	$this->db->where("id",$res['proposal_id']);
     	 	$this->db->update("proposal",$row);
		 }
	}
	 else
	 {
     	
     	$this->db->where("id",$jobid);
     	$this->db->update("jobs",$row);
	 
		//Create activity log for update job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "jobs", $jobid, $this->session->userdata("user_id"));	
	 }
     $json['success'] = true;
     echo json_encode($json);
  }
  function deleteprofilephoto($user_id,$profile=0){
     $url =  $this->input->get("q");
     $output = "<br/>&nbsp&nbsp;&nbsp;&nbsp;Are you sure to delete this file?<br/>&nbsp;&nbsp;&nbsp;<button class='yessave'>OK</button>&nbsp;<button class='cancel-facebox'>Cancel</button>";
     $output .= "<script>\$(document).ready(function() { \$('.yessave').click(function() { location.href='".base_url()."admin/deleteuserpp/$user_id/$profile'}); });</script>";
     echo $output;
 }

 function pvbuildingpdfmailsend($pdfpath,$customer_id){
         $this->load->library('email');
         $config['mailtype'] = 'html';
         $sql_cust = "SELECT * FROM customers where id=$customer_id";
         $row_cust = $this->db->query($sql_cust)->row_array();
         $sql_update= "UPDATE  customers  set pv_permit_mailsent=1 where id=$customer_id";
         $this->db->query($sql_update);
         $this->email->initialize($config);
		  $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=16');
          $row = $query->row();
          $sub=$row->strsubject;
          $msg=$row->strbody;
               
         $this->email->to($row_cust['email']);
         $this->email->from('sales@aeihawaii.com', 'Schedular');
         $this->email->subject( $sub);
		  $msg=strtr($msg, array(
                 '%firstName%' => ucfirst($row_cust['first_name']),
                 '%lastName%' => ucfirst($row_cust['last_name']),
			      '%baseurl%' =>base_url(),
                  ));
         $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
	<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p><b>Dear '.ucfirst($row_cust['first_name']).' '.ucfirst($row_cust['last_name']) .',</b></p>
For your records, please see the attached building permit for your photovoltaic system.<br/><br/>
After your installation, Alternate Energy will request the required Building and Electrical inspections from the City & County of Honolulu.  Please allow 2-8 weeks for inspections to be completed.<br/><br/>
After both inspections are complete Alternate Energy will notify HECO that your permit has closed.  HECO will then execute your Net Energy Metering (NEM) Agreement, and install your net meter if applicable.  Please allow an additional 2-4 weeks for this process.
<br/><br/>
Feel free to contact us at 808-842-5853 with any questions or concerns.  Thank you for choosing Alternate Energy Inc. for your solar needs!
<br/><br/>
Regards,<br/>
The Alternate Energy Inc. Team <br/><br/>
</p>
Alternate Energy Inc. <br/>
96-1276 Waihona St. #C124, Pearl City HI, 96782<br/>
Office +808 842 5853  |  Web  www.alternateenergyhawaii.com<br/>
Facebook  www.facebook.com/alternateenergyhawaii<br/>
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';

          $this->email->message($msg);
          $this->email->attach($pdfpath);
         $this->email->send();
    }

    function swhbuildingpdfmailsend($pdfpath,$customer_id){
         $this->load->library('email');
         $config['mailtype'] = 'html';
         $sql_cust = "SELECT * FROM customers where id=$customer_id";
         $row_cust = $this->db->query($sql_cust)->row_array();
         $sql_update= "UPDATE  customers  set swh_permit_mailsent=1 where id=$customer_id";
         $this->db->query($sql_update);
         $this->email->initialize($config);
		 $query = $this->db->query('SELECT strsubject,strbody FROM mailformat where id=17');
         $row = $query->row();
         $sub=$row->strsubject;
         $msg=$row->strbody;
         $this->email->to($row_cust['email']);
         $this->email->from('sales@aeihawaii.com', 'Schedular');
         $this->email->subject($sub);
         $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr>
		<td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
	<td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p><b>Dear '.ucfirst($row_cust['first_name']).' '.ucfirst($row_cust['last_name']) .',</b></p>
For your records, please see the attached building permit for your solar water heating system.<br/>
After your installation, Alternate Energy will request the required Building and Electrical inspections from the City & County of Honolulu.  Please allow 2-8 weeks for inspections to be completed.<br/><br/>


Feel free to contact us at 808-842-5853 with any questions or concerns.  Thank you for choosing Alternate Energy Inc. for your solar needs!
<br/><br/>
Regards,<br/>
The Alternate Energy Inc. Team <br/><br/>
</p>
Alternate Energy Inc. <br/>
96-1276 Waihona St. #C124, Pearl City HI, 96782<br/>
Office +808 842 5853  |  Web  www.alternateenergyhawaii.com<br/>
Facebook  www.facebook.com/alternateenergyhawaii<br/>
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
          $msg=strtr($msg, array(
                 '%firstName%' => ucfirst($row_cust['first_name']),
                 '%lastName%' => ucfirst($row_cust['last_name']),
			      '%baseurl%' =>base_url(),
                  ));
          $this->email->message($msg);
          @$this->email->attach($pdfpath);
          @$this->email->send();
    }
    	

function getUserIntial($id,$fullname=false){
      if (!$id) return 0;
      $j = $this->db->query("SELECT first_name , last_name FROM users WHERE id=$id")->result_array();
      $intial="";
      foreach($j as $key => $value) {
        $intial = ucfirst($value['first_name'][0]).ucfirst($value['last_name'][0]);
        if($fullname){
         $intial = ucfirst($value['first_name'])." ".ucfirst($value['last_name']);
        }
      }
      return $intial;
 }
 function insertreferral($job_id,$result){
     if($result['referral_job']==2){
        $row['job_id'] = $job_id;
        $row['referral_type_id'] = 2;
        $row['first_name'] = $result['refer_first_name'];
        $row['last_name'] = $result['refer_last_name'];
        $row['home_phone'] = $result['refer_phone'];
        $row['address'] = $result['refer_address'];
        $row['city'] = $result['refer_city'];
        $row['state'] = $result['refer_state'];
        $row['zip_code'] = $result['refer_zip'];
        $this->db->insert("referrals",$row);
        return;
     } else{
         return;
     }
 }

 function sendplotplanchange($job_id){
   $ismailsent = $this->globalnotifcation();
    if(!$ismailsent){
        functionreturn;
    }
   $sql_userid="SELECT user_id,customer_id,job_pid FROM  jobs WHERE  id=".$job_id;
   $row_userid = $this->db->query($sql_userid)->row_array();
   $user_mail = $this->db->query("SELECT email from users where id=".$row_userid["user_id"])->row_array();
   $customer_info = $this->db->query("SELECT * from customers where id=".$row_userid["customer_id"])->row_array();
   $this->load->library('email');
   $config['mailtype'] = 'html';
   $name=ucfirst($customer_info['first_name'])." ".ucfirst($customer_info['last_name']);
   $this->email->initialize($config);
   $this->email->from('do-not-reply@aeihawaii.com', 'Schedular');
   $this->email->to($user_mail["email"]);
   $this->email->subject('Premeasure uploaded for '.$name.' Changes have been applied - Need confirmation');
   $message = '<table cellpadding="0" cellspacing="0" width="600" align="center" style="line-height:18px; font-family:Arial, Helvetica, sans-serif; font-size:12px;">
	<tr><td><img width="200" height="69" alt="Alternate Energy Inc"  title="Alternate Energy Inc" src="'.base_url().'assets/images/logo.png" /></td>
	</tr>
	<tr>
     <td style="background-color:#EFEFEF; padding:10px 20px; border-top:2px solid #418E1C;">
<p>Your Premeasure sketch has been uploaded but we had to make some changes to the layout.

Please login and confirm these changes as soon as possible. For the job details, <a href="'.base_url().'admin/job/'.$job_id.'">Please click here </a><br/> 


</p>
Thanks You,<br/>
The AEI Administration Team
		</td>
	</tr>
	<tr>
		<td style="color:#666666; font-size:10px; padding-top:5px; border-top:2px solid #418E1C;">&copy; Alternate Energy Inc.</td>
	</tr>
</table>';
     @$this->email->message($message);
     @$this->email->send();
 }
 function createproposaljob($proposal_id=0){
		$sql = "SELECT * from proposal where id = '$proposal_id' " ;
		$proposal_array = $this->db->query($sql)->result_array();  
		$proposal = $proposal_array[0];
		$pid=0;
        $job=array();
		$job['current_status'] = "";
		$customer_id = $proposal['customer_id'];
		$job['user_id'] = $proposal['user_id'];
		$job['job_type_id'] = 2;
        $job['modified_by'] =  $this->session->userdata("user_id");
        $job['job_date'] = null;
        $job['created'] = date("Y-m-d H:i:s");
        $job['no_installer_allocated'] = $proposal['noi'];
		$job['module_brand_id'] =  $proposal['module_type'];
		$job['job_nos'] =  $proposal['nos'];
                $job['job_nosa'] =  $proposal['nosa'];
                $job['job_nom'] =  $proposal['nom'];
                $module_id=$proposal['module_type'];
                if($module_id==31){
                   $job["system_size"] = $job['job_nom']*225/1000;
                } else if($module_id==32){
                    $job["system_size"] = $job['job_nom']*255/1000;
                } else if($module_id==33) {
                  $job["system_size"] = $job['job_nom']*260/1000;
                }
                $job['roof_type_id'] =  $proposal['roof_type'];
                //$job['wire_run_distance'] =  $this->session->userdata('in_wirerundist');
                //$job['wire_run_type_id'] =  $this->session->userdata('in_wireruntype');
                $job['jobs_emt']=$proposal['meter_type'];
                
                if($proposal['id']){
                $job['proposal_id']=$proposal['id'];
		$sql = "SELECT COUNT(id) as totalcount FROM customers  WHERE id = '$customer_id'";
		$rowcount = $this->db->query($sql)->result_array();	
        if($rowcount[0]["totalcount"]){
			$customer_update = array();
			$customer_update['city'] = $proposal['city'];
			$customer_update['state'] =$proposal['state'];
			$customer_update['address'] =$proposal['address'];
			$customer_update['home_phone'] ="home";
			$customer_update['home_phone1'] ="cell";
			$customer_update['secondary_phone'] = $proposal['phone'];
			$customer_update['secondary_phone1'] =$proposal['sphone'];
			$customer_update['zip_code'] =$proposal['zip'];
			$customer_update['email']=$proposal['email'];
			$customer_update['dtml']=$proposal['dml'];
			$customer_update['sun_zone'] =$proposal['avgzoneenergy'];
			$customer_update['association']=$proposal["home_owner_assoc_name"];
			$this->db->where("id",$customer_id);
			$this->db->update("customers",$customer_update);

			//Create activity log for updated customer
			$this->load->library("activitylog");
			//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
			$this->activitylog->createlog("Update", "customers", '', $this->session->userdata("user_id"), $customer_id);		
          } else{
                 
			$row = array();
			$row['first_name'] =  $proposal['dpp_firstname'];
			$row['last_name'] = $proposal['dpp_lastname'];
			$row['first_name1'] =  $proposal['dpp_ot_firstname'];
			$row['last_name1'] = $proposal['dpp_ot_lastname'];
			//$row['customer_type_id'] = $proposal['customer_type'];
			$row['neighborhood'] = $proposal['neighborhood'];			
			$row['city'] = $proposal['city'];
			$row['state'] =$proposal['state'];
			$row['address'] =$proposal['address'];
			$row['home_phone'] ="home";
			$row['home_phone1'] ="cell";
			$row['secondary_phone'] = $proposal['phone'];
			$row['secondary_phone1'] =$proposal['sphone'];
			$row['zip_code'] =$proposal['zip'];
			$row['email']=$proposal['email'];
			$row['sun_zone'] =$proposal['avgzoneenergy'];
			$row['association']=$proposal["home_owner_assoc_name"];				
			$row['created'] = date("Y-m-d H:i:s");
			$row['dtml']=$proposal['dml'];

			$this->db->insert("customers",$row);
			$customer_id = $this->db->insert_id(); // get id of customer that was added                 
                 
                 }
            $arr[0]['customer_id']=$customer_id;
            $arr =$arr[0];
            $this->session->set_userdata($arr);
		    $job['customer_id'] = $customer_id;
                   $job['list_price'] =$proposal['price'];
                   $job['assessed_value']=$proposal['assessed_value'];
                   $job['permit_fee']=$proposal['permit_fee'];
                   $payment_type_method=1;
                   switch($proposal['mop']){
                    case 'amex' :
                        $job['payment_type_id']=1;
                        break;
                     case 'visa':
                         $job['payment_type_id']=5;
                         break;
                     case 'mc':
                         $job['payment_type_id']=6;
                         break;
                     case 'cash/Check':
                         $job['payment_type_id']=2;
                         break;
                    case 'financing':
                         $job['payment_type_id']=4;
                         break;
                     case 'other':
                        // $job['payment_type_id']=$proposal['mop'];
                   }
                   $sum_tax = 0;
                   $nos = $proposal['nos'];
				   if($nos>0)
                   @$new_price = @$proposal['price']/$nos;
				   else
				   @$new_price = @$proposal['price'];
				   
                   for($k=0;$k<$nos;$k++){
                    $state_exicse_tax = .35*$new_price;
                    if($state_exicse_tax >5000){
                     $state_exicse_tax = 5000;
                    }
                    $federal_tax_credit=.3*$new_price;
                    $sum_tax += $federal_tax_credit+$state_exicse_tax;
                    if($k==0){
                      $job['state_tax_credit'] = number_format($state_exicse_tax,2);
                      $job['federal_tax_credit'] = number_format($federal_tax_credit,2);
                    } else {
                     $job['state_tax_credit_'.$k] = number_format($state_exicse_tax,2);
                     $job['federal_tax_credit_'.$k] = number_format($federal_tax_credit,2);
                    }


                   }
                   $job['total_tax_credits'] = number_format($sum_tax,2);
                   $job['net_total_price'] = number_format(($proposal['price']-$sum_tax),2);
                   $job['sub_total_price'] = number_format(($proposal['price'] + $proposal['price']*0.04712),2);
                   $job['system_size'] = $proposal['system_size'];
                   if($proposal['module_type']==1){
                    $job['module_brand_id']=32;

                   }elseif($proposal['module_type']==2){
                     $job['module_brand_id']=31;
                   } elseif($proposal['module_type']==70){
                     $job['module_brand_id']=33;
                   } else{
                       $job['module_brand_id']=$proposal['module_type'];
                   }
                   switch($proposal['invertert']){
                     case 3:
                        $job['inverter_type_id']=31;
                         break;
                     case 4:
                        $job['inverter_type_id']=25;
                         break;
                     case 5:
                        $job['inverter_type_id']=37;
                         break;
                     case 6:
                        $job['inverter_type_id']=34;
                         break;
                     case 7:
                        $job['inverter_type_id']=36;
                         break;
                     case 43:
                         $job['inverter_type_id']=26;
                             break;
                     case  73:
			   $job['inverter_type_id']=33;
                            break;
                     case  74:
			    $job['inverter_type_id']=38;
                            break;
                    case  77:
			        $job['inverter_type_id']=39;
                            break;
                   case  203:
			         $job['inverter_type_id']=203;
                       break;
                   }
               $job["inverter_count"] = $proposal['not'];

               switch($proposal["roof_type"]){
               case 8:
                  $job['roof_type_id'] =8;
                  break;
              case 9:
                  $job['roof_type_id'] =8;
                  break;
              case 10:
                  $job['roof_type_id'] =12;
                  break;
             case 11:
                  $job['roof_type_id'] =10;
                  break;
              case 37:
                  $job['roof_type_id'] =5;
                  break;
              case 94:
                  $job['roof_type_id']=13;
                  break;
              case 38:
                  $job['roof_type_id'] =2;
                  break;
               case 39:
                  $job['roof_type_id'] =10;
                  break;
             case 40:
                  $job['roof_type_id'] =6;
                  break;
              case 41:
                  $job['roof_type_id'] =9;
                  break;
              case 42:
                  $job['roof_type_id'] =6;
                  break;
              case 71:
                  $job['roof_type_id'] =11;
                  break;
            }
          if ($proposal["is_tilt_kit"]==1){
              $proposal["tilt_kit_needed"]='y';

          }else if ($proposal["is_tilt_kit"]==2) {
              $proposal["tilt_kit_needed"]='n';
          }
            $job['qoute_upcharge']=$proposal['qoute_upcharge'];
            $job['qoute_addwork']=$proposal['qoute_addwork'];
            $job['addedcharge']=$proposal['acharge'];
            $job['discount']=$proposal['discount'];
            $job['referral_job']=$proposal['referral_job'];
            $job['jobs_emt']=$proposal['meter_type'];
			$job['current_status']='unscheduled';
            $job['reschedule_pljob']=1;
            $job['reschedule_pmjob']=1;
            if($proposal['is_tilt_kit']==1)
             $job['tilt_kit_needed']='y';
            else
              $job['tilt_kit_needed']='n';
            
            $proposal_pid = $proposal['proposal_pid' ]; 
            $porposal_delete= $this->db->query("UPDATE  proposal SET is_delete=0 WHERE proposal_pid=".$proposal_pid["proposal_pid"]." AND  id!=".$proposal['id' ]);
            $this->db->query("UPDATE proposal set is_schedule=1,proposal_pid=id WHERE id=".$proposal['id' ]);
        }
	    $job['job_pid'] = 0;
	    $this->db->insert("jobs",$job);
	    $job_id = $this->db->insert_id();
            $this->db->query("UPDATE jobs set job_pid='".$job_id."' WHERE id=".$job_id);
                    
		//Create activity log for new job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Create", "jobs", $job_id, $this->session->userdata("user_id"));			
                    
		if($proposal['id'])
		{
			$this->insertreferral($job_id,$proposal);
		}

             
       		return $job_id;
        }       

 function reply_job_note()
 {
	 $data['cid'] = base64_decode($this->input->get('id'));
	 $this->load->view("ajax/reply_note",$data);
	 }
	 function doaddreply()
{
	//header('Content-Type: application/json; charset=utf-8');

	$json = array();
	
	if($this->input->post("reply_note"))
	{
		
		$row = array();
		$row['comment_id'] = $this->input->post("cid");
		$row['reply'] = $this->input->post("reply_note");
		$row['user_id'] = $this->session->userdata("user_id");
		$row['created'] = date("Y-m-d H:i:s");
		$this->db->insert("notes_reply",$row);
         $row=$this->db->query("SELECT * FROM notes WHERE id=".$row['comment_id'])->row_array(); 
		 $row['note']=$this->input->post("reply_note");
					$sql = "SELECT
			users.email,customers.first_name,customers.last_name,jobs.contractor_id,jobs.installer_id,jobs.conduit_id FROM		jobs
		LEFT JOIN users ON jobs.user_id=users.id
					LEFT JOIN customers ON jobs.customer_id=customers.id
					LEFT JOIN  notification_setting ns ON ns.user_id = users.id
		WHERE ns.notification!=0 AND jobs.id=".$row['job_id'];
			$data = array();

					$data = $this->db->query($sql)->result_array();
				   if(count($data)>=1){
						$name = ucfirst($data[0]['first_name'])." ".ucfirst($data[0]['last_name']);
						@$this->sendcommentmail($data[0]['email'],$row['note'],$row['job_id'],$name);

						$in_user = '';
						if($data[0]['contractor_id']){
							$in_user .= $data[0]['contractor_id'].",";
						}
						if($data[0]['installer_id']){
							$in_user .= $data[0]['installer_id'].",";
						}
						if($data[0]['conduit_id']){
							$in_user .= $data[0]['conduit_id'].",";
						}
						$in_user = substr($in_user,0,-1);
						$assoc_users =  array();
						if ($in_user!=''){
						 $assoc_users = $this->db->query("SELECT users.email from users WHERE id in ($in_user)")->result_array();
						// print_R($assoc_users);
						foreach ($assoc_users as $value){
							@$this->sendcommentmail($value['email'],$row['note'],$row['job_id'],$name);
						}
						}
					}
					$row_users =  array();
					$row_users = $this->db->query("SELECT users.email from users LEFT JOIN  notification_setting ns ON ns.user_id = users.id WHERE  ns.notification!=0 AND type in ('admin','engineer','warehouse' )")->result_array();
					foreach ($row_users as $value){
					  @$this->sendcommentmail($value['email'],$row['note'],$row['job_id'],$name);
					}

					$json['success'] = true;
		$json['msg'] = 'Reply added';
		echo json_encode($json);
	}
	else
	{
		$json['success'] = false;
		$json['msg'] = 'Problem adding reply';
		echo json_encode($json);
	}
}
function removecomment($note_id='')
	{
		if(is_numeric($this->input->post('cid'))){
			$this->db->where('id',$this->input->post('cid'));
			$this->db->delete("notes");
			echo 'true';
		}
		else
		echo 'false';
	}


function saveSWHPMjobs($job,$job_id,$is_reschedule,$customer_id=0){
   
      $session_installer = $this->db->query("SELECT *  FROM  pm_session_installer WHERE sessionid='".$this->session->userdata("re_session_id")."' AND user_id=".$this->session->userdata("re_user_id")." ORDER BY id")->row_array();
    //$return_obj = new stdclass;

      if(@$session_installer['date_booked']){

        if(!$job && !$is_reschedule && !$job_id){

			$job['job_type_id']=9;
			//echo $job['job_type_id']; exit;
            $job['job_date'] =$session_installer['date_booked']." ".date("h:i:s");
            $job['no_installer_allocated'] = 2;
            $slot_time=1;
            $job['current_status'] = "";
            $job['user_id'] = $this->session->userdata('re_user_id');
            $job['modified_by'] =  $this->session->userdata("user_id");
            $job['created'] = date("Y-m-d H:i:s");
            if(!$this->session->userdata('customer_id') ) {
            // need to add new customer to db
             $row = array();
             $row['first_name'] =  $this->session->userdata('re_first_name');
             $row['last_name'] = $this->session->userdata('re_last_name');
             $row['first_name1'] =  $this->session->userdata('spouse_firstname');
             $row['last_name1'] = $this->session->userdata('spouse_lastname');
             $row['customer_type_id'] = $this->session->userdata('customer_type');
             $row['neighborhood'] = $this->session->userdata('neighborhood');
             $row['created'] = date("Y-m-d H:i:s");
             $this->db->insert("customers",$row);
             $customer_id = $this->db->insert_id(); // get id of customer that was added

		//Create activity log for new customer
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Create", "customers", '', $this->session->userdata("user_id"), $customer_id);


             $this->db->insert("jobs",$job);
             $pm_job_id = $this->db->insert_id();
		//Create activity log for new job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Create", "jobs", $pm_job_id, $this->session->userdata("user_id"));

	    } else{
               $customer_id=$this->session->userdata('customer_id');
               $job_row = $this->db->query("SELECT `job_pid`, `in_nod`, `rel_job_id`, `pl_job_id`, `pm_job_id`, `customer_id`, `user_id`, `current_status`, `job_date`, `module_brand_id`, `no_installer_allocated`, `other_module_brand`, `module_count`, `system_size`, `module_power_id`, `other_module_power`, `inverter_type_id`, `other_inverter_type`, `inverter_brand_id`, `other_inverter_brand`, `inverter_count`, `inverter_accessible`, `subpanel_needed`, `service_panel_amperage_id`, `other_amperage`, `wire_run_type_id`, `other_wire_run_type`, `wire_run_distance`, `other_wire_run_distance`, `inverter_other_module_number`, `breaker_box_location`, `meter_to_module_distance`, `meter_location`, `module_configuration`, `electric_wire_source`, `electric_wire_source_other`, `stories`, `module_install_location_access`, `is_ladder`, `other_roof_type`, `rafter_type_id`, `other_rafter_type`, `rafter_distance`, `roof_type_id`, `roof_orientation`, `roof_color`, `roof_pitch`, `tilt_kit_needed`, `installation_type_id`, `other_installation_type`, `contractor_id`, `tank_brand_id`, `other_tank_brand`, `tank_size_id`, `other_tank_size`, `heater_location`, `remove_old_tank`, `relocate_old_tank`, `new_tank_location`, `tank_distance`, `solar_tank_accessible`, `panel_type_id`, `other_panel_type`, `panel_size_id`, `other_panel_size`, `panel_count`, `piperun_length`, `piperun_type_id`, `other_piperun_type`, `gutter_installation`, `solar_fan_brand_id`, `solar_fan_brand_other`, `solar_fan_size_id`, `solar_fan_size_other`, `comments`, `created`, `system_special_pricing`, `system_list_price`, `referral`, `program_discount`, `jobs_emt`, `other_jobs_emt`, `referral_amount`, `state_excise_tax`, `sales_commission`, `state_tax_credit`, `fan_install_location_access`, `federal_tax_credit`, `total_tax_credits`, `payment_type_id`, `financing_comments`, `list_price`, `panel_install_location_access`, `existing_heater_location`, `fan_install_access_location`, `fan_brand_id`, `fan_size_id`, `other_fan_brand`, `other_fan_size`, `job_count`, `job_nos`, `job_nosa`, `other_job_nosa`, `job_nom`, `other_job_nom`, `mointer_system`, `other_mointer_system`, `job_spu`, `job_dowr`, `other_job_spu`, `modified_by`, `job_isnws`, `installer_id`, `payment_dpp`, `payment_amdpp`, `payment_fpp`, `payment_amfpp`, `saoorf`, `nodrf`, `job_wssn`, `servicepanelupgrade`, `repair_time`, `repair_type`, `servicedesc`, `spmsip_job`, `conduit_id`, `envoy_serial_number`, `typeofjump`, `bis`, `eis`, `hapsta`, `designer_id`, `elec_insp_quote`, `elec_comments`, `pump_type_id`, `other_pump_type`, `is_pp_checked`, `is_mail_sent`, `status_updated`, `permitnotfication`, `heconotfication`, `job_lastscheduledate`, `proposal_id`, `roof_flashing`, `other_roof_flashing`, `institution`, `arrival_time`, `toprelag`, `pldesc`, `pl_comments`, `pl_completed`, `pm_completed`, `net_total_price`, `sub_total_price`, `state_tax_credit_1`, `state_tax_credit_2`, `state_tax_credit_3`, `state_tax_credit_4`, `state_tax_credit_5`, `state_tax_credit_6`, `federal_tax_credit_1`, `federal_tax_credit_2`, `federal_tax_credit_3`, `standoff_size_id`, `other_standoff_size`, `base_commsion`, `qoute_upcharge`, `qoute_addwork`, `discount`, `addedcharge`, `referral_job`, `subpanel_exist`, `paperwork_completed`, `is_customer_mailsent` from jobs where job_type_id=2 AND customer_id=$customer_id")->row_array();
               $this->db->insert("jobs",$job_row);
               $pm_job_id = $this->db->insert_id();
			   $job['job_pid']=$job_row["job_pid"];
		      //Create activity log for new job
	        	$this->load->library("activitylog");
		     //($activity_type ,$table_name, $job_id, $user_id, $customer_id)
	        	$this->activitylog->createlog("Create", "jobs", $pm_job_id, $this->session->userdata("user_id"));

               $this->db->where("id",$pm_job_id);
               $this->db->update("jobs",$job);

		//Create activity log for update job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "jobs", $pm_job_id, $this->session->userdata("user_id"));

               $row['neighborhood'] = $this->session->userdata('neighborhood');
               $this->db->where("id",$customer_id);
               $this->db->update("customers",$row);

		//Create activity log for updated customer
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "customers", '', $this->session->userdata("user_id"), $customer_id);

           }

            $job_update['pm_job_id']=$pm_job_id;
            if(isset($job_row["job_pid"])&& @$job_row["job_pid"]>0)
			 $job_update['job_pid'] = $job_row["job_pid"];
			 else
			 $job_update['job_pid'] = $pm_job_id;

            $job_update["customer_id"]=$customer_id;
            $this->db->where("id",$pm_job_id);
            $this->db->update("jobs",$job_update);
		//Create activity log for update job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "jobs", $pm_job_id, $this->session->userdata("user_id"));

            $this->sendPMjobnotification($pm_job_id);
            $year = date("Y" ,strtotime($session_installer['date_booked']));
            $month = date("m" ,strtotime($session_installer['date_booked']));
            $json['year'] = @$year;
            $json['month'] = @$month;
            $json['success'] = true;
            
            echo json_encode($json);
            $this->canceljob();
            return;
        } else    if($is_reschedule && $job_id) {
          $job['job_date'] =$session_installer['date_booked']." ".date("h:i:s");
          $job['current_status']='';
          $this->db->where("job_pid",$job_id);
          $this->db->where("job_type_id",9);
          $this->db->update("jobs",$job);
		//Create activity log for update job
		$this->load->library("activitylog");
		//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
		$this->activitylog->createlog("Update", "jobs", $job_id, $this->session->userdata("user_id"));

          $year = date("Y" ,strtotime($session_installer['date_booked']));
          $month = date("m" ,strtotime($session_installer['date_booked']));
          $json['year'] = @$year;
          $json['month'] = @$month;
          $json['success'] = true;
          if(@$this->session->userdata('job_type_pl')==6 && @$this->session->userdata('job_type_pm')==7 ){
            return;
          } else{
              $this->sendcommonjobreschdulenoti($job_id,'Premeasure');
              echo json_encode($json);
          }
          return;
       }
       $job['job_date'] =$session_installer['date_booked']." ".date("h:i:s");
       $job['job_pid']=$job_id;
       $job['job_type_id'] = 9;
       $job['pm_job_id']=$job_id;
       $this->db->insert("jobs",$job);
       $job_pm_id = $this->db->insert_id();

	//Create activity log for new job
	$this->load->library("activitylog");
	//($activity_type ,$table_name, $job_id, $user_id, $customer_id)
	$this->activitylog->createlog("Create", "jobs", $job_pm_id, $this->session->userdata("user_id"));

       return $job_pm_id;
    }
    return 0;
 }

function send_ptrnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['ptr'] =NULL;
   $dt = trim($this->input->post("dt"));
   if(isset($dt)&& $dt!='null'){
   $row['ptr'] = implode("-",explode("/",$this->input->post("dt")));
   }
	$this->load->library("activitylog");
	$sql = "SELECT ptr,id FROM jobs WHERE job_pid = '".$job_id."'";
	$rs = $this->db->query($sql)->result_array();
	/*foreach($rs as $data)
	{
		$diff = $this->activitylog->matchdiffInUpdate($data,$row);
		$this->activitylog->createlog("Update", "jobs", $data['id'], $this->session->userdata("user_id"),'',$diff);	
		}*/
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->sendusermail($job_id,"paperwork1");
   $json['success'] = true;
   echo json_encode($json);
 }
  
  function send_ppcnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['ppc'] =NULL;
   $dt = trim($this->input->post("dt"));
   if(isset($dt)&& $dt!='null'){
   $row['ppc'] = implode("-",explode("/",$this->input->post("dt")));
   }
	$this->load->library("activitylog");
	$sql = "SELECT ppc,id FROM jobs WHERE job_pid = '".$job_id."'";
	$rs = $this->db->query($sql)->result_array();
	/*foreach($rs as $data)
	{
		$diff = $this->activitylog->matchdiffInUpdate($data,$row);
		$this->activitylog->createlog("Update", "jobs", $data['id'], $this->session->userdata("user_id"),'',$diff);	
		}*/
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->sendusermail($job_id,"paperwork2");
   $json['success'] = true;
   echo json_encode($json);
 }
 
 function send_fanotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['fa'] =NULL;
   $dt = trim($this->input->post("dt"));
   if(isset($dt)&& $dt!='null'){
   $row['fa'] = implode("-",explode("/",$this->input->post("dt")));
   }
	$this->load->library("activitylog");
	$sql = "SELECT fa,id FROM jobs WHERE job_pid = '".$job_id."'";
	$rs = $this->db->query($sql)->result_array();
	/*foreach($rs as $data)
	{
		$diff = $this->activitylog->matchdiffInUpdate($data,$row);
		$this->activitylog->createlog("Update", "jobs", $data['id'], $this->session->userdata("user_id"),'',$diff);	
		}*/
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->sendusermail($job_id,"paperwork3");
   $json['success'] = true;
   echo json_encode($json);
 }
  function send_tsnotification(){
   $job_id = $this->input->post("job_id");
   $pid = $this->getparentjobid($job_id);
   $row['ts'] =NULL;
   $dt = trim($this->input->post("dt"));
   if(isset($dt)&& $dt!='null'){
   $row['ts'] = implode("-",explode("/",$this->input->post("dt")));
   }
 $this->load->library("activitylog");
 $sql = "SELECT ts,id FROM jobs WHERE job_pid = '".$job_id."'";
 $rs = $this->db->query($sql)->result_array();
 /*foreach($rs as $data)
 {
  $diff = $this->activitylog->matchdiffInUpdate($data,$row);
  $this->activitylog->createlog("Update", "jobs", $data['id'], $this->session->userdata("user_id"),'',$diff); 
  }*/
   $this->db->where('job_pid',$pid);
   $this->db->update('jobs', $row);
   $this->sendusermail($job_id,"paperwork4");
   $json['success'] = true;
   echo json_encode($json);
 }
 function save_fdamount($job_id,$amount){
    $pid = $this->getparentjobid($job_id);
    $row["final_amount_deposit"]=$amount;
    $this->db->where('job_pid',$pid);
    $this->db->update('jobs', $row);
    $json['success'] = true;
    echo json_encode($json);
}
function save_acfdamount($job_id,$amount){
    $pid = $this->getparentjobid($job_id);
    $row["final_amount_deposit"]=$amount;
    $this->db->where('job_pid',$pid);
    $this->db->update('jobs', $row);
    $json['success'] = true;
    echo json_encode($json);
}
function save_swhfdamount($job_id,$amount){
    $pid = $this->getparentjobid($job_id);
    $row["final_amount_deposit"]=$amount;
    $this->db->where('job_pid',$pid);
    $this->db->update('jobs', $row);
    $json['success'] = true;
    echo json_encode($json);
}
function save_damount($proposal_id,$amount){
  $row["amount_deposit"]=$amount;
  $this->db->where('id',$proposal_id);
  $this->db->update('proposal', $row);
  $json['success'] = true;
  echo json_encode($json);
}
function save_acdamount($proposal_id,$amount){
  $row["amount_deposit"]=$amount;
  $this->db->where('id',$proposal_id);
  $this->db->update('acproposal', $row);
  $json['success'] = true;
  echo json_encode($json);
}
function save_swhdamount($proposal_id,$amount){
  $row["amount_deposit"]=$amount;
  $this->db->where('id',$proposal_id);
  $this->db->update('swhproposal', $row);
  $json['success'] = true;
  echo json_encode($json);
}
function save_damountswh($proposal_id,$amount){
  $row["amount_deposit"]=$amount;
  $this->db->where('id',$proposal_id);
  $this->db->update('swhproposal', $row);
  $json['success'] = true;
  echo json_encode($json);
}

function save_damountac($proposal_id,$amount){
  $row["amount_deposit"]=$amount;
  $this->db->where('id',$proposal_id);
  $this->db->update('acproposal', $row);
  $json['success'] = true;
  echo json_encode($json);
}
function update_job_parts(){
	$job_id=$this->input->post("job_id");
	$status=$this->input->post("status");
	$pid = $this->getparentjobid($job_id);
    $row["part_issue_date"]=date("Y-m-d");
    $row["part_issued"]=$status;
    $this->db->where('job_pid',$pid);
    $this->db->update('jobs', $row);
    $json['success'] = true;
    echo json_encode($json);
}

function save_jfdamount($proposal_id,$amdepoist,$job_id){
  $pid = $this->getparentjobid($job_id);
  $job_type=$this->db->query("SELECT job_type_id,proposal_id from jobs where job_pid=$pid")->row_array();
  $proposal_id=$job_type["proposal_id"];
  $rs=$job_type["job_type_id"];
  if($rs==1 || $rs==9){
     $this->save_swhdamount($proposal_id,$amdepoist);
  }  else if($rs==2 || $rs==6 || $rs==7 ) {
	$this->save_damount($proposal_id,$amdepoist);
  } else if($rs==15 || $rs==16  ) {
    $this->save_acdamount($proposal_id,$amdepoist);
  }
}

}
?>